// tan.testdata
// copyright (C) 2005 F. de Dinechin, Ch. Q. Lauter  and V.Lefevre
// This file is part of crlibm and is distributed under the GNU Public Licence
// See file COPYING for details
// The following lines are either comments (beginning with a #)
// or give
//   1/ a rounding mode : RN|RU|RD|RZ (crlibm syntax) or  N|P|M|Z (libmcr syntax)
//   2/ The high and low hexadecimal halves of an input
//   3/ The high and low hexadecimal halves of the expected corresponding output
// Special cases
T(RN,                  0x0p+0,                  0x0p+0,          0x0p+0, 0) // zero
T(RN,                 -0x0p+0,                 -0x0p+0,          0x0p+0, 0) // -zero
T(RU,                  0x0p+0,                  0x0p+0,          0x0p+0, 0) // zero
T(RU,                 -0x0p+0,                 -0x0p+0,          0x0p+0, 0) // -zero
T(RD,                  0x0p+0,                  0x0p+0,          0x0p+0, 0) // zero
T(RD,                 -0x0p+0,                 -0x0p+0,          0x0p+0, 0) // -zero
T(RZ,                  0x0p+0,                  0x0p+0,          0x0p+0, 0) // zero
T(RZ,                 -0x0p+0,                 -0x0p+0,          0x0p+0, 0) // -zero
T(RN,               0x1p-1074,               0x1p-1074,          0x0p+0, INEXACT|UNDERFLOW) // smallest denorm positive
T(RN,              -0x1p-1074,              -0x1p-1074,          0x0p+0, INEXACT|UNDERFLOW) // smallest denorm negative
T(RU,               0x1p-1074,               0x1p-1073,          0x1p+0, INEXACT|UNDERFLOW) // smallest denorm positive
T(RU,              -0x1p-1074,              -0x1p-1074,          0x0p+0, INEXACT|UNDERFLOW) // smallest denorm negative
T(RD,               0x1p-1074,               0x1p-1074,          0x0p+0, INEXACT|UNDERFLOW) // smallest denorm positive
T(RD,              -0x1p-1074,              -0x1p-1073,         -0x1p+0, INEXACT|UNDERFLOW) // smallest denorm negative
T(RZ,               0x1p-1074,               0x1p-1074,          0x0p+0, INEXACT|UNDERFLOW) // smallest denorm positive
T(RZ,              -0x1p-1074,              -0x1p-1074,          0x0p+0, INEXACT|UNDERFLOW) // smallest denorm negative
T(RN,                     inf,                     nan,          0x0p+0, INVALID) // +inf
T(RN,                    -inf,                     nan,          0x0p+0, INVALID) // -inf
T(RU,                     inf,                     nan,          0x0p+0, INVALID) // +inf
T(RU,                    -inf,                     nan,          0x0p+0, INVALID) // -inf
T(RD,                     inf,                     nan,          0x0p+0, INVALID) // +inf
T(RD,                    -inf,                     nan,          0x0p+0, INVALID) // -inf
T(RZ,                     inf,                     nan,          0x0p+0, INVALID) // +inf
T(RZ,                    -inf,                     nan,          0x0p+0, INVALID) // -inf
T(RN,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RU,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RD,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RZ,                     nan,                     nan,          0x0p+0, 0) // NaN
// One in five of the very worst cases computed by Lefevre and Muller.
// Rounding these values requires evaluating the function to at least 2^(-100).
// These worst cases have been selected thanks to the filterlists 5 script
// If you want the full list please contact Jean-Michel Muller
T(RN,   0x1.39ee00e8bc926p-10,   0x1.39ee0abe8201fp-10,          0x1p-1, INEXACT) // 1.197546773422938828218553553029e-03
T(RZ,   0x1.3ba2de937a401p-10,   0x1.3ba2e8928827ap-10,         -0x1p+0, INEXACT) // 1.204056582418511428880791847007e-03
T(RZ,   0x1.c73b85db6f34ep-10,   0x1.c73ba3d8ec126p-10, -0x1.651588p-53, INEXACT) // 1.736574215882319676546030606801e-03
T(RN,   0x1.d0e1571270a6bp-10,     0x1.d0e1770278ep-10,          0x1p-1, INEXACT) // 1.773377360777895648744073575642e-03
T(RZ,   0x1.a8999a89e9143p-11,   0x1.a899a09f4e57dp-11,         -0x1p+0, INEXACT) // 8.098602568123242561801133909682e-04
T(RN,   0x1.c28cf86839e38p-11,   0x1.c28cffacfbe09p-11,          0x1p-1, INEXACT) // 8.593571956482864634963014793811e-04
T(RZ,   0x1.d346992584118p-11,   0x1.d346a1414896dp-11,         -0x1p+0, INEXACT) // 8.912578093163451772862337918468e-04
T(RZ,   0x1.d4d4af431456bp-11,   0x1.d4d4b773a3c37p-11, -0x1.990066p-52, INEXACT) // 8.942237840391780703472313085456e-04
T(RZ,   0x1.e1e9241669b6ap-11,   0x1.e1e92cfb63df5p-11,         -0x1p+0, INEXACT) // 9.191717279478487951510645714848e-04
T(RN,   0x1.0f05a22ea9f02p-12,   0x1.0f05a293eafafp-12,          0x1p-1, INEXACT) // 2.584667262603841360671386162551e-04
T(RZ,   0x1.ccae9b881eb4fp-12,   0x1.ccae9d7966e6fp-12, -0x1.794e8cp-51, INEXACT) // 4.393406493431910113910132675841e-04
T(RZ,   0x1.e1edc2e1198e1p-12,   0x1.e1edc51a686e5p-12,         -0x1p+0, INEXACT) // 4.596030758591396051838950942425e-04
T(RN,   0x1.673659a05f79dp-13,   0x1.673659db4f805p-13,         -0x1p-1, INEXACT) // 1.712857747512814643540274284206e-04
T(RN,   0x1.6d16412b5b564p-13,   0x1.6d1641693bcadp-13,          0x1p-1, INEXACT) // 1.740870151069425679837832099395e-04
T(RZ,    0x1.96bfc3ea0172p-13,   0x1.96bfc43f93375p-13,         -0x1p+0, INEXACT) // 1.939530769165470971970854918709e-04
T(RN,   0x1.af04ee57f0934p-13,   0x1.af04eebdc23ddp-13,         -0x1p-1, INEXACT) // 2.055259999434539070276017902472e-04
T(RZ,   0x1.ee3c63c4bfb82p-13,   0x1.ee3c645e42bbbp-13,         -0x1p+0, INEXACT) // 2.356700407730415712005689332642e-04
T(RZ,   0x1.91a058209b7c2p-14,   0x1.91a05835339b2p-14,  -0x1.ae3f4p-53, INEXACT) // 9.575518243717855777948078088713e-05
T(RN,   0x1.6849a7d98414ep-15,    0x1.6849a7dd3b94p-15,          0x1p-1, INEXACT) // 4.294964282902884297656725953729e-05
T(RZ,   0x1.f006943003bbfp-15,   0x1.f0069439b6b41p-15, -0x1.2d42bcp-51, INEXACT) // 5.913087113650722733857942325919e-05
T(RN,   0x1.81d14a6c95d0fp-15,   0x1.81d14a7126406p-15,         -0x1p-1, INEXACT) // 4.599303506285834958504030178794e-05
T(RN,   0x1.f56015a9d0701p-15,   0x1.f56015b3d49cep-15,         -0x1p-1, INEXACT) // 5.976859695390295668495153624811e-05
T(RN,   0x1.6b8d3bf622f4cp-16,   0x1.6b8d3bf7175a9p-16,         -0x1p-1, INEXACT) // 2.166936970886207478991652974898e-05
T(RZ,   0x1.ada7859b3249cp-16,   0x1.ada7859cc5b51p-16,  -0x1.4a9ecp-51, INEXACT) // 2.560939684029661775246239363568e-05
T(RZ,   0x1.a81f3e305b189p-16,   0x1.a81f3e31df219p-16,         -0x1p+0, INEXACT) // 2.527964369518487168877508841636e-05
T(RZ,   0x1.2bfffffff2446p-17,   0x1.2c00000014996p-17,         -0x1p+0, INEXACT) // 8.940696716213302543433891211855e-06
T(RZ,    0x1.67ffffffe845p-17,   0x1.6800000023987p-17,         -0x1p+0, INEXACT) // 1.072883605940564929505376401409e-05
T(RZ,   0x1.a3ffffffda512p-17,   0x1.a400000038864p-17,         -0x1p+0, INEXACT) // 1.251697540257055217918259748533e-05
T(RN,   0x1.c16ac87fa1f3ep-17,   0x1.c16ac880155fep-17,          0x1p-1, INEXACT) // 1.339367395238011846313706809664e-05
T(RN,   0x1.f2c8431c17126p-17,   0x1.f2c8431cb4dbep-17,         -0x1p-1, INEXACT) // 1.486487013140824609935645994607e-05
T(RZ,   0x1.06b912b480477p-18,   0x1.06b912b4860b2p-18,         -0x1p+0, INEXACT) // 3.914876903100408300545300782636e-06
T(RZ,   0x1.b33ff577ec256p-18,   0x1.b33ff578065b8p-18,         -0x1p+0, INEXACT) // 6.485728015024290457938259402138e-06
T(RZ,   0x1.7e3e64272c0d1p-18,   0x1.7e3e64273dce1p-18,         -0x1p+0, INEXACT) // 5.695875223185775054030813985273e-06
T(RZ,   0x1.4df4b21f86df4p-19,    0x1.4df4b21f89d5p-19, -0x1.98208cp-52, INEXACT) // 2.488164923664923488936563666929e-06
T(RN,   0x1.e546fe9022825p-19,   0x1.e546fe902b976p-19,          0x1p-1, INEXACT) // 3.615597798105519138789224267705e-06
T(RN,   0x1.0b6fe907132c6p-19,   0x1.0b6fe90714b19p-19,          0x1p-1, INEXACT) // 1.992562036734433598701276418863e-06
T(RZ,   0x1.79561fe75f458p-19,   0x1.79561fe7638a8p-19,         -0x1p+0, INEXACT) // 2.811375441501408827633598508378e-06
T(RN,   0x1.a87639dab6086p-20,   0x1.a87639dab78d6p-20,          0x1p-1, INEXACT) // 1.581243501183286002644478793200e-06
T(RZ,   0x1.85f6660e4ffb2p-20,   0x1.85f6660e5128bp-20,         -0x1p+0, INEXACT) // 1.452723498454583509121489440230e-06
T(RN,   0x1.974b602994a65p-20,    0x1.974b602995fep-20,          0x1p-1, INEXACT) // 1.517290011317099002709153816870e-06
T(RN,   0x1.c41bc46ba9a9dp-20,   0x1.c41bc46bab7fdp-20,         -0x1p-1, INEXACT) // 1.684235281831979987447506404152e-06
T(RZ,   0x1.0d72a7a156962p-21,   0x1.0d72a7a156aefp-21,         -0x1p+0, INEXACT) // 5.018857686487608022694048917622e-07
T(RN,   0x1.eb6c7a5b1409dp-21,   0x1.eb6c7a5b14a0cp-21,          0x1p-1, INEXACT) // 9.153480492550019861206140638077e-07
T(RN,   0x1.e5ba19b2b2692p-21,   0x1.e5ba19b2b2fadp-21,         -0x1p-1, INEXACT) // 9.047369558753311591603680011375e-07
T(RZ,   0x1.81c5052d64836p-21,   0x1.81c5052d64cc6p-21, -0x1.881eecp-53, INEXACT) // 7.185518932520539995737569524681e-07
T(RZ,   0x1.b63598bb8c0c8p-22,   0x1.b63598bb8c273p-22,         -0x1p+0, INEXACT) // 4.081142710192256903214014923664e-07
T(RZ,   0x1.cd364423f9571p-22,   0x1.cd364423f9764p-22,  -0x1.3a25bp-51, INEXACT) // 4.295371260883964880285398272447e-07
T(RN,   0x1.dffffffffff1fp-22,   0x1.e000000000151p-22,         -0x1p-1, INEXACT) // 4.470348358154177760991792364015e-07
T(RZ,   0x1.14e9736cdaf2ep-23,   0x1.14e9736cdaf49p-23, -0x1.0bb3d4p-51, INEXACT) // 1.289471599734489792419710098986e-07
T(RN,   0x1.4986e22c11583p-23,    0x1.4986e22c115bp-23,         -0x1p-1, INEXACT) // 1.534479151540299980544093455190e-07
T(RZ,   0x1.f40e91b5b6b35p-23,   0x1.f40e91b5b6bd4p-23, -0x1.f47ee6p-51, INEXACT) // 2.328571448360537308079279287046e-07
T(RN,   0x1.8b396a113aca6p-23,   0x1.8b396a113acf5p-23,          0x1p-1, INEXACT) // 1.840406445360778935737145877577e-07
T(RN,    0x1.0917758c3fabdp-4,    0x1.09765eafade9bp-4,          0x1p-1, INEXACT) // 6.471963803412968119221915230810e-02
T(RZ,    0x1.2945b0ce87464p-4,    0x1.29cb96fdc62bfp-4,         -0x1p+0, INEXACT) // 7.257622780930855777015153762477e-02
T(RN,    0x1.5d53470a65981p-4,    0x1.5e2cb997cdb6cp-4,          0x1p-1, INEXACT) // 8.528449774016701179224497764153e-02
T(RZ,    0x1.c53b471c31435p-4,    0x1.c71726bcff074p-4,         -0x1p+0, INEXACT) // 1.106522348155330598418188969845e-01
T(RN,    0x1.3cf73f761315ep-5,    0x1.3d1fc3c9ce4b3p-5,         -0x1p-1, INEXACT) // 3.869211573382601299098126901299e-02
T(RN,    0x1.54171f058f43ep-5,    0x1.54492c5321144p-5,          0x1p-1, INEXACT) // 4.151493128708992619291251457980e-02
T(RN,    0x1.b148995bf383ap-5,    0x1.b1b025a6ec7e7p-5,         -0x1p-1, INEXACT) // 5.289106324163168892926734088178e-02
T(RZ,    0x1.0e28550426034p-6,    0x1.0e2e99cd926bcp-6,         -0x1p+0, INEXACT) // 1.648910810817501293445985766084e-02
T(RN,    0x1.11a44d4f48d74p-6,    0x1.11aad0ff35621p-6,         -0x1p-1, INEXACT) // 1.670177030349635771688809882107e-02
T(RZ,    0x1.640aade8f5427p-6,      0x1.6419079bbf6p-6,         -0x1p+0, INEXACT) // 2.173106177709285477539502551281e-02
T(RN,    0x1.6892f24011645p-6,    0x1.68a1da0e35377p-6,         -0x1p-1, INEXACT) // 2.200769097568968171718672977022e-02
T(RZ,    0x1.79040da084b16p-6,    0x1.791517aa8b606p-6,         -0x1p+0, INEXACT) // 2.301122027172216449875108423839e-02
T(RZ,    0x1.a54d4459ebde7p-6,     0x1.a5650b7f38f5p-6,  -0x1.ecabep-52, INEXACT) // 2.571422266890790661597598898425e-02
T(RN,     0x1.0680025f8aa5p-7,    0x1.06817261c3386p-7,          0x1p-1, INEXACT) // 8.010865362924196597660397856089e-03
T(RZ,    0x1.4975fe12ed9f6p-7,    0x1.4978d5aa88bbfp-7, -0x1.5f82fap-52, INEXACT) // 1.005434900239963666446207923855e-02
T(RZ,    0x1.61ffe6d074459p-7,    0x1.62036d65dd0f5p-7, -0x1.c8b278p-52, INEXACT) // 1.080321092823248625702792224956e-02
T(RZ,    0x1.dd8ba464f1847p-7,    0x1.dd944c3df5fe6p-7,         -0x1p+0, INEXACT) // 1.457353140893870128980136513519e-02
T(RZ,    0x1.a0f080926ae92p-8,    0x1.a0f1f13b1fad8p-8, -0x1.0c226cp-51, INEXACT) // 6.361991300234530813395572579338e-03
T(RZ,    0x1.44d2d451f3e1cp-9,    0x1.44d2ffe64f2fdp-9,         -0x1p+0, INEXACT) // 2.478207033142399914882325617782e-03
T(RN,    0x1.8e21c136c87cfp-9,    0x1.8e221175a7dcbp-9,          0x1p-1, INEXACT) // 3.037504993145901787537921379112e-03
T(RN,    0x1.c5ea7001341aep-9,    0x1.c5eae6ed8d6cap-9,         -0x1p-1, INEXACT) // 3.463102505158319709133163399883e-03
T(RZ,    0x1.2bd8ad618f03dp-1,      0x1.539642798abp-1,         -0x1p+0, INEXACT) // 5.856374913778449320389540844189e-01
T(RN,    0x1.66982328f5e5fp-1,      0x1.af957928e38p-1,         -0x1p-1, INEXACT) // 7.003794658184679944312733823608e-01
T(RN,     0x1.6b6215c17da4p-1,    0x1.b7d73c970184dp-1,          0x1p-1, INEXACT) // 7.097327040381244955824513453990e-01
T(RN,    0x1.3759625b0fb96p-2,    0x1.414feea698c2ap-2,          0x1p-1, INEXACT) // 3.040519111709100164020469492243e-01
T(RN,    0x1.bcf881bb172dep-2,    0x1.db44c628220cep-2,         -0x1p-1, INEXACT) // 4.345417280617719368862594819802e-01
T(RN,    0x1.c81cf95f7520dp-2,    0x1.e8e17208b52fdp-2,          0x1p-1, INEXACT) // 4.454230274689344182270644978416e-01
T(RN,    0x1.ccfbfea1760cep-2,    0x1.eee03307df653p-2,         -0x1p-1, INEXACT) // 4.501800333068900483723950856074e-01
T(RZ,    0x1.a33f32ac5ceb5p-3,    0x1.a933fe176b375p-3,  -0x1.480c8p-57, INEXACT) // 2.047103842593195610621847890798e-01
T(RN,    0x1.eafeade82230ap-3,    0x1.f49f8c38f443bp-3,          0x1p-1, INEXACT) // 2.397435747591532551048487675871e-01
T(RN,    0x1.b81a83d437efdp-3,    0x1.bf01753879e23p-3,          0x1p-1, INEXACT) // 2.148943232668826530673555907924e-01
T(RZ,    0x1.04a3953634f67p-3,    0x1.060e28dcba2ecp-3, -0x1.1ea5b4p-51, INEXACT) // 1.272651345412853796101870784696e-01
T(RN,    0x1.04e8d3351c05cp-3,    0x1.0654896383e86p-3,         -0x1p-1, INEXACT) // 1.273972035010072501037825531967e-01
T(RN,    0x1.c9f47908c3178p-3,    0x1.d1be5f9534915p-3,         -0x1p-1, INEXACT) // 2.236108260916684908892193561769e-01
T(RN,    0x1.5d53470a65981p-4,    0x1.5e2cb997cdb6cp-4,          0x1p-1, INEXACT) // 8.528449774016701179224497764153e-02
T(RN,    0x1.0917758c3fabdp-4,    0x1.09765eafade9bp-4,          0x1p-1, INEXACT) // 6.471963803412968119221915230810e-02
T(RZ,    0x1.2945b0ce87464p-4,    0x1.29cb96fdc62bfp-4,         -0x1p+0, INEXACT) // 7.257622780930855777015153762477e-02
T(RZ,    0x1.c53b471c31435p-4,    0x1.c71726bcff074p-4,         -0x1p+0, INEXACT) // 1.106522348155330598418188969845e-01
T(RZ,    0x1.c8afe27275484p-1,    0x1.3d54e1e32c6dcp+0, -0x1.b3f2dcp-51, INEXACT) // 8.919668926925088392465568176704e-01
T(RN,    0x1.cae740fbda9fdp-1,    0x1.4028595a90371p+0,         -0x1p-1, INEXACT) // 8.962955768050161475812842581945e-01
T(RN,    0x1.0ba3ffadac42cp+0,    0x1.b9a47878b089dp+0,         -0x1p-1, INEXACT) // 1.045471172237976809071824391140e+00
T(RZ,    0x1.40d924d6239acp+0,    0x1.85888b869172dp+1, -0x1.3da658p-48, INEXACT) // 1.253313352851914252994447451783e+00
T(RZ,    0x1.414a515ef5021p+0,    0x1.87d04425184c8p+1,         -0x1p+0, INEXACT) // 1.255040250475765839510700061510e+00
T(RN,    0x1.91e01cdee1f85p+0,   0x1.01a10851685ebp+10,         -0x1p-1, INEXACT) // 1.569825939573975093210833620105e+00
T(RZ,    0x1.91f6a98b08f23p+0,   0x1.8f29f280d5523p+10,         -0x1p+0, INEXACT) // 1.570170017665937889361771340191e+00
T(RN,    0x1.92005b9169fa5p+0,   0x1.054df9389bebap+11,          0x1p-1, INEXACT) // 1.570317957879504122686853406776e+00
T(RZ,    0x1.920ee6f7bcce1p+0,   0x1.e772fb8844076p+11,         -0x1p+0, INEXACT) // 1.570539889796059407345296676795e+00
T(RN,    0x1.920e59086458cp+0,   0x1.d7e1ad1166df4p+11,         -0x1p-1, INEXACT) // 1.570531429814169932512868399499e+00
T(RN,    0x1.92114d52de37dp+0,    0x1.1c534fbeb886p+12,         -0x1p-1, INEXACT) // 1.570576508265929094321222692088e+00
T(RZ,    0x1.9214ed8fb103bp+0,   0x1.7bf59b471d3a1p+12, -0x1.af22c8p-39, INEXACT) // 1.570631835537837472926980808552e+00
T(RN,    0x1.92149fdc0b038p+0,   0x1.718de67c02e0fp+12,          0x1p-1, INEXACT) // 1.570627204152527767178071371745e+00
T(RZ,    0x1.9215fe540616ep+0,   0x1.a5a21e47254f8p+12, -0x1.ab455ap-39, INEXACT) // 1.570648093713397752679838959011e+00
T(RN,    0x1.9217a5f29d7d9p+0,   0x1.fc32ddeb232c4p+12,          0x1p-1, INEXACT) // 1.570673343403077959479219316563e+00
T(RZ,    0x1.921859461368ap+0,   0x1.1649199c0947ep+13,         -0x1p+0, INEXACT) // 1.570684032066682167538829162368e+00
T(RZ,     0x1.921845e3a41bp+0,   0x1.13738fb6f3804p+13,         -0x1p+0, INEXACT) // 1.570682876659798665741618606262e+00
T(RN,    0x1.921899cca8ca5p+0,   0x1.202799801272ap+13,         -0x1p-1, INEXACT) // 1.570687878099115808439023567189e+00
T(RZ,    0x1.921afd3b61317p+0,   0x1.b200332085768p+13,  -0x1.2b3dcp-37, INEXACT) // 1.570724322316157772760902844311e+00
T(RN,    0x1.921b20398b2f4p+0,   0x1.bef2881e8ef15p+13,         -0x1p-1, INEXACT) // 1.570726408051254630038329196395e+00
T(RZ,    0x1.921a96d20ff05p+0,   0x1.901567508259bp+13,         -0x1p+0, INEXACT) // 1.570718218121272657938902739261e+00
T(RN,    0x1.921b804b48559p+0,   0x1.e6d104ff142e9p+13,          0x1p-1, INEXACT) // 1.570732134227304621632015368959e+00
T(RZ,    0x1.921d40a9a73c2p+0,   0x1.a106949c9f895p+14,         -0x1p+0, INEXACT) // 1.570758859080556124609984181006e+00
T(RN,    0x1.921e563e34989p+0,   0x1.75663af87cdf4p+15,         -0x1p-1, INEXACT) // 1.570775404154661325506481261982e+00
T(RN,    0x1.921e73223308dp+0,   0x1.96e344f2db904p+15,          0x1p-1, INEXACT) // 1.570777126168681592233156152361e+00
T(RN,    0x1.921e71e3e5c4bp+0,   0x1.9552c44420357p+15,         -0x1p-1, INEXACT) // 1.570777052058263789646730401728e+00
T(RZ,    0x1.921ec597623a7p+0,   0x1.116fc51ae5274p+16,         -0x1p+0, INEXACT) // 1.570782041033661036166790836432e+00
T(RN,    0x1.921efc0a1cd2bp+0,    0x1.61d071d4b44dp+16,          0x1p-1, INEXACT) // 1.570785286396879198989040560264e+00
T(RN,    0x1.921f18ddaee02p+0,   0x1.a306b9b45bd6ep+16,          0x1p-1, INEXACT) // 1.570787004587032686941938663949e+00
T(RZ,    0x1.921f3e66d519dp+0,   0x1.13ac978ca32b9p+17,         -0x1p+0, INEXACT) // 1.570789241891453302812919901044e+00
T(RZ,    0x1.921f4ce55bfd1p+0,   0x1.39f5336315018p+17,         -0x1p+0, INEXACT) // 1.570790105815820902890322940948e+00
T(RN,    0x1.921f747d2ac0fp+0,   0x1.f9da5ecc42c38p+17,         -0x1p-1, INEXACT) // 1.570792465742446131216070170922e+00
T(RZ,    0x1.921f7b6181a42p+0,   0x1.1b0a4dcbbab7fp+18, -0x1.377058p-33, INEXACT) // 1.570792876534725213133469878812e+00
T(RZ,    0x1.921f8db2b958dp+0,    0x1.9e111386fe78p+18,         -0x1p+0, INEXACT) // 1.570793968328277445678509138816e+00
T(RN,    0x1.921f911795828p+0,   0x1.c4ea5d2950f8dp+18,          0x1p-1, INEXACT) // 1.570794170625513075378876237664e+00
T(RZ,    0x1.921f8b4b09c5ap+0,   0x1.86575de77ee3ap+18, -0x1.75a9f6p-36, INEXACT) // 1.570793824977747110693826471106e+00
T(RN,    0x1.921f88892a988p+0,   0x1.6e479d44cc2bep+18,          0x1p-1, INEXACT) // 1.570793660629165700015619222540e+00
T(RN,     0x1.921f937be33ap+0,   0x1.e4fb5981f67a5p+18,         -0x1p-1, INEXACT) // 1.570794313188550006543664494529e+00
T(RN,    0x1.921f968be067ep+0,   0x1.0aaa1b8098642p+19,          0x1p-1, INEXACT) // 1.570794495725209127812149745296e+00
T(RZ,    0x1.921fa227df817p+0,   0x1.aca7f70c9901dp+19, -0x1.588842p-32, INEXACT) // 1.570795187697063388654328264238e+00
T(RZ,    0x1.5f33c915edc82p+0,    0x1.3d7eb76c0edebp+2,         -0x1p+0, INEXACT) // 1.371883933881492101392041149666e+00
T(RN,    0x1.6df4179c3c811p+0,    0x1.c1f2fcd8e99ecp+2,         -0x1p-1, INEXACT) // 1.429505801814688448203582993301e+00
T(RZ,    0x1.921fa7b92eef3p+0,   0x1.2e702011582bfp+20,         -0x1p+0, INEXACT) // 1.570795519552970587184859141416e+00
T(RZ,    0x1.921fa9aead7cap+0,   0x1.6194ea6bdb7cdp+20,         -0x1p+0, INEXACT) // 1.570795636316221877137877527275e+00
T(RN,    0x1.921fabb2a22acp+0,   0x1.ac0e26b57d5c9p+20,          0x1p-1, INEXACT) // 1.570795756446538682382652041269e+00
T(RZ,    0x1.921faccc6914ep+0,   0x1.e3b1a10502b1ep+20, -0x1.a49734p-29, INEXACT) // 1.570795822052861279161106722313e+00
T(RZ,    0x1.921faeaa6b3f1p+0,   0x1.36423227de48ep+21, -0x1.574ed4p-29, INEXACT) // 1.570795933347877815222659592109e+00
T(RZ,    0x1.921faf128ede8p+0,   0x1.4aa26ab0f1962p+21,         -0x1p+0, INEXACT) // 1.570795957594663505574317241553e+00
T(RN,    0x1.921fb0aaf82a4p+0,   0x1.bd5581ea647aep+21,          0x1p-1, INEXACT) // 1.570796052685332178100452438230e+00
T(RN,    0x1.921fb2cc5e0fep+0,   0x1.9edacb64cdf5ap+22,         -0x1p-1, INEXACT) // 1.570796179670707726216960509191e+00
T(RN,    0x1.921fb2a5a6795p+0,   0x1.86e74428dbe55p+22,          0x1p-1, INEXACT) // 1.570796170656170831492204342794e+00
T(RZ,    0x1.921fb37eef6fap+0,   0x1.21225fabc950cp+23, -0x1.40908ap-30, INEXACT) // 1.570796221246779200697574196965e+00
T(RN,    0x1.921fb38133592p+0,   0x1.22961a6be9c79p+23,         -0x1p-1, INEXACT) // 1.570796221774206191668099563685e+00
T(RN,    0x1.921fb3bf1c88bp+0,   0x1.50d107ff0c74ep+23,          0x1p-1, INEXACT) // 1.570796236188956696011587155226e+00
T(RZ,    0x1.921fb40acae4ap+0,   0x1.a222735f505fdp+23,         -0x1p+0, INEXACT) // 1.570796253809833675774143557646e+00
T(RZ,    0x1.921fb4b310032p+0,   0x1.c35ac9ef2ad2dp+24,         -0x1p+0, INEXACT) // 1.570796292988245301813776677591e+00
T(RN,    0x1.921fb4b436eb1p+0,   0x1.c6f6d89562cf5p+24,   0x1.fffffep-2, INEXACT) // 1.570796293256460751663894370722e+00
T(RN,    0x1.921fb4ec4efbfp+0,   0x1.749098c43f0bfp+25,          0x1p-1, INEXACT) // 1.570796306316864621166473625635e+00
T(RZ,    0x1.921fb4f9ea79bp+0,   0x1.b8c161ee609d8p+25, -0x1.c25efap-25, INEXACT) // 1.570796309485081421186691841285e+00
T(RN,    0x1.921fb500c7c26p+0,   0x1.e59737de7bb65p+25,  -0x1.fffffep-2, INEXACT) // 1.570796311083321850077254566713e+00
T(RZ,    0x1.921fb502529c9p+0,   0x1.f0f30948c2833p+25,  -0x1.21c64p-24, INEXACT) // 1.570796311442437920291581576748e+00
T(RZ,    0x1.921fb520dbabcp+0,   0x1.cec9642faae58p+26,  -0x1.fffffap-1, INEXACT) // 1.570796318552011960889558395138e+00
T(RN,    0x1.921fb529ae342p+0,   0x1.34320f845c179p+27,  -0x1.fffffcp-2, INEXACT) // 1.570796320606135498820776774664e+00
T(RZ,    0x1.921fb52bf682ap+0,   0x1.5125600daedecp+27,  -0x1.fffffap-1, INEXACT) // 1.570796321137559292679952704930e+00
T(RN,    0x1.921fb5324c9aep+0,   0x1.c81469f0aa085p+27,   0x1.fffffap-2, INEXACT) // 1.570796322612845852262353218975e+00
T(RN,    0x1.921fb5326f594p+0,   0x1.cb8d5499cc957p+27,  -0x1.ffffecp-2, INEXACT) // 1.570796322644445019989234424429e+00
T(RN,    0x1.921fb5317f477p+0,   0x1.b495b1ace1827p+27,  -0x1.ffffeep-2, INEXACT) // 1.570796322426103008851328013407e+00
T(RN,    0x1.921fb5331a499p+0,   0x1.dd6f96c05e48ep+27,  -0x1.ffffe8p-2, INEXACT) // 1.570796322799912880796568970254e+00
T(RN,    0x1.921fb535943ebp+0,   0x1.16fb80d2b740bp+28,   0x1.fffffap-2, INEXACT) // 1.570796323376493885959348517645e+00
T(RZ,    0x1.921fb53b2942dp+0,   0x1.c21e3cad2dba8p+28,  -0x1.ffffeap-1, INEXACT) // 1.570796324676176469736788021692e+00
T(RN,    0x1.921fb53b7ef2cp+0,   0x1.d34e906a988f3p+28,  -0x1.ffffecp-2, INEXACT) // 1.570796324754108574950350885047e+00
T(RZ,    0x1.921fb53d325c1p+0,   0x1.21e8a2ab25a5cp+29, -0x1.5721f6p-25, INEXACT) // 1.570796325150112915380873346294e+00
T(RZ,    0x1.78a7b216ff0c8p+0,    0x1.4096293cccdc8p+3,         -0x1p+0, INEXACT) // 1.471308832754447237789463542867e+00
T(RZ,     0x1.7efd6b91aba5p+0,    0x1.ab579e245e68ep+3, -0x1.597fb4p-47, INEXACT) // 1.496054385246356588368144002743e+00
T(RZ,    0x1.921fb540913edp+0,   0x1.153ba1e4c2daap+30,  -0x1.ffffe2p-1, INEXACT) // 1.570796325934902926135805500962e+00
T(RN,    0x1.921fb543133ffp+0,   0x1.afc5402e24375p+31,  -0x1.ffff1ep-2, INEXACT) // 1.570796326518802521476914080267e+00
T(RN,    0x1.921fb5439b78cp+0,   0x1.879e35e2b8b7ap+32,  -0x1.ffff04p-2, INEXACT) // 1.570796326642695639463909174083e+00
T(RN,     0x1.921fb543b24fp+0,   0x1.c581669cd143ep+32,    0x1.fffdbp-2, INEXACT) // 1.570796326663465691808596602641e+00
T(RN,     0x1.921fb543c5bep+0,   0x1.05fbf555c0916p+33,    0x1.fffeap-2, INEXACT) // 1.570796326681140442360629094765e+00
T(RZ,    0x1.921fb543f6367p+0,   0x1.abbf97365a7d4p+33,  -0x1.fffe4cp-1, INEXACT) // 1.570796326725224067999420185515e+00
T(RN,    0x1.921fb543f6853p+0,   0x1.ad7915b1c5ac3p+33,  -0x1.ffffc8p-2, INEXACT) // 1.570796326725503844201625724963e+00
T(RN,    0x1.921fb544041c9p+0,   0x1.05477d09384c1p+34,    0x1.fffeap-2, INEXACT) // 1.570796326737865067357802217884e+00
T(RN,    0x1.921fb544191afp+0,   0x1.88c6fedfbae59p+34,  -0x1.ffff08p-2, INEXACT) // 1.570796326756958682935305660067e+00
T(RZ,    0x1.921fb544248edp+0,   0x1.0eb7222928f43p+35,  -0x1.ffffaap-1, INEXACT) // 1.570796326767374795352338878729e+00
T(RN,    0x1.921fb54427e35p+0,   0x1.3030c88c35c3fp+35,  -0x1.fffb12p-2, INEXACT) // 1.570796326770403483763516305771e+00
T(RZ,    0x1.921fb54430f35p+0,   0x1.ca793c3e1bafdp+35,  -0x1.fffafcp-1, INEXACT) // 1.570796326778645779498333467927e+00
T(RZ,    0x1.921fb54433dd9p+0,   0x1.11ed08b4c3e84p+36, -0x1.b4f562p-15, INEXACT) // 1.570796326781296992081138341746e+00
T(RN,    0x1.921fb54439284p+0,   0x1.a7f6c18b7fc7dp+36,   0x1.fff766p-2, INEXACT) // 1.570796326786109808892888395349e+00
T(RN,    0x1.921fb544385d2p+0,   0x1.87c9808d5b87fp+36,   0x1.ffdd42p-2, INEXACT) // 1.570796326785388163926882043597e+00
T(RN,    0x1.921fb5443d02dp+0,   0x1.60a6abd4d1464p+37,  -0x1.fffb8ap-2, INEXACT) // 1.570796326789614782981630014547e+00
T(RZ,    0x1.921fb5443daa5p+0,   0x1.8d6d64b805173p+37,   -0x1.ffe19p-1, INEXACT) // 1.570796326790209862522829098452e+00
T(RN,    0x1.921fb544408fep+0,   0x1.c5d13613d61eap+38,    0x1.ff896p-2, INEXACT) // 1.570796326792844421760264594923e+00
T(RN,    0x1.921fb54440ebcp+0,   0x1.0dd31fbbfa912p+39,   0x1.ffdd9ep-2, INEXACT) // 1.570796326793170827329504390946e+00
T(RN,    0x1.921fb54441655p+0,   0x1.67e2af8924874p+39,  -0x1.ff8e78p-2, INEXACT) // 1.570796326793602704086083576840e+00
T(RZ,    0x1.858b8d1ad8fa7p+0,    0x1.455de3bd44792p+4,         -0x1p+0, INEXACT) // 1.521660632185538153393622451404e+00
T(RZ,    0x1.89a1bc6fc486fp+0,     0x1.e227aac678d8p+4, -0x1.ae06cep-47, INEXACT) // 1.537624146735222074866555885819e+00
T(RZ,    0x1.89b25d19b3587p+0,    0x1.e5dfb44d08a74p+4, -0x1.a7d3fcp-45, INEXACT) // 1.537877863668968947408188796544e+00
T(RN,    0x1.89d02dabbce95p+0,    0x1.ecb00a83d32f3p+4,          0x1p-1, INEXACT) // 1.538332800319868853833327193570e+00
T(RZ,    0x1.921fb54442005p+0,   0x1.394333b25d835p+40,   -0x1.ffb5cp-1, INEXACT) // 1.570796326794153374706297654484e+00
T(RZ,    0x1.921fb544428acp+0,   0x1.cf0a054216e88p+41,  -0x1.9f8d0ep-8, INEXACT) // 1.570796326794645203506206598831e+00
T(RZ,    0x1.921fb544427c1p+0,   0x1.7f7457f2246a3p+41,  -0x1.ffed68p-1, INEXACT) // 1.570796326794593023024049216474e+00
T(RN,    0x1.921fb54442a14p+0,   0x1.53718a2732b5dp+42,  -0x1.fce9d2p-2, INEXACT) // 1.570796326794725139563979610102e+00
T(RZ,    0x1.921fb54442b18p+0,   0x1.ffb97121c3896p+42,   -0x1.78cf5p-7, INEXACT) // 1.570796326794782871161260118242e+00
T(RN,    0x1.921fb54442ba4p+0,   0x1.601545087f59ap+43,   0x1.fe21bep-2, INEXACT) // 1.570796326794813957405949622625e+00
T(RZ,    0x1.921fb54442bd1p+0,   0x1.907e7aaaea9f3p+43,   -0x1.5c4e9p-7, INEXACT) // 1.570796326794823949413171249034e+00
T(RZ,     0x1.921fb54442c3p+0,   0x1.1a25bb08e2211p+44,  -0x1.fb35aap-1, INEXACT) // 1.570796326794845043650639127009e+00
T(RZ,    0x1.921fb54442c21p+0,   0x1.0908339725fa3p+44,   -0x1.c6fadp-7, INEXACT) // 1.570796326794841712981565251539e+00
T(RN,    0x1.921fb54442c26p+0,   0x1.0e806da33d7b8p+44,  -0x1.f06544p-2, INEXACT) // 1.570796326794842823204589876696e+00
T(RZ,    0x1.921fb54442c6cp+0,   0x1.7c69d0d4db53dp+44,  -0x1.6c204ap-6, INEXACT) // 1.570796326794858366326934628887e+00
T(RZ,    0x1.921fb54442c62p+0,    0x1.678b0ac79739p+44,  -0x1.f22286p-1, INEXACT) // 1.570796326794856145880885378574e+00
T(RZ,    0x1.921fb54442c99p+0,   0x1.0174eaf74279dp+45,  -0x1.fbe38ep-6, INEXACT) // 1.570796326794868358334156255296e+00
T(RN,    0x1.921fb54442cadp+0,   0x1.3174ac4fa71bap+45,  -0x1.d42eb4p-2, INEXACT) // 1.570796326794872799226254755922e+00
T(RN,    0x1.921fb54442cd5p+0,   0x1.e711e46424dc4p+45,  -0x1.a324e6p-2, INEXACT) // 1.570796326794881681010451757174e+00
T(RZ,    0x1.921fb54442ccbp+0,   0x1.a80a300c5bcaep+45,  -0x1.61ec1ap-6, INEXACT) // 1.570796326794879460564402506861e+00
T(RZ,    0x1.921fb54442cb7p+0,   0x1.50db55110745cp+45,  -0x1.fd45bap-1, INEXACT) // 1.570796326794875019672304006235e+00
T(RZ,    0x1.921fb54442cbcp+0,   0x1.631c0768030fep+45,  -0x1.aff468p-5, INEXACT) // 1.570796326794876129895328631392e+00
T(RZ,    0x1.921fb54442ce9p+0,   0x1.5a8ff56a9370ep+46,  -0x1.a86d04p-4, INEXACT) // 1.570796326794886121902550257801e+00
T(RZ,    0x1.921fb54442cf3p+0,   0x1.b788ef1b787b6p+46,  -0x1.593646p-4, INEXACT) // 1.570796326794888342348599508114e+00
T(RZ,    0x1.921fb54442ceep+0,   0x1.838cf6838a195p+46,   -0x1.2e3f3p-5, INEXACT) // 1.570796326794887232125574882957e+00
T(RZ,    0x1.921fb54442cf8p+0,   0x1.fba01d10013e9p+46,  -0x1.84d4eep-1, INEXACT) // 1.570796326794889452571624133270e+00
T(RN,    0x1.921fb54442cfdp+0,    0x1.2c5701b9e17cp+47,   0x1.5ed668p-2, INEXACT) // 1.570796326794890562794648758427e+00
T(RZ,    0x1.921fb54442d02p+0,   0x1.6fc1002ce31b7p+47,  -0x1.6972dep-4, INEXACT) // 1.570796326794891673017673383583e+00
T(RZ,    0x1.921fb54442d07p+0,   0x1.da30b5171acf4p+47,  -0x1.faafacp-1, INEXACT) // 1.570796326794892783240698008740e+00
T(RN,     0x1.8b25e8a664e9p+0,    0x1.2583bf4a11b01p+5,         -0x1p-1, INEXACT) // 1.543547192214564489631811738946e+00
T(RN,    0x1.8e61b27d70292p+0,    0x1.119d3934764c3p+6,          0x1p-1, INEXACT) // 1.556178241371672488213562246528e+00
T(RN,     0x1.8ef2a05b6f51p+0,    0x1.4264338b13f0cp+6,         -0x1p-1, INEXACT) // 1.558389684985119316706914105453e+00
T(RZ,    0x1.8f6f441cf6673p+0,    0x1.7cc3be002d9bcp+6,  -0x1.424cdp-44, INEXACT) // 1.560291535445142541149721182592e+00
T(RZ,    0x1.8fe5d2aae920fp+0,    0x1.cbfb9b96efdfep+6, -0x1.8d2d86p-43, INEXACT) // 1.562100569463954036208974684996e+00
T(RN,    0x1.901497a98b8e7p+0,    0x1.f51c23181384fp+6,         -0x1p-1, INEXACT) // 1.562814215557915664689403456578e+00
T(RZ,    0x1.9042f5b54e5d5p+0,    0x1.12ec9f364bd91p+7,         -0x1p+0, INEXACT) // 1.563521725429713571386969306332e+00
T(RZ,    0x1.90f422b49115ep+0,    0x1.b586ef84c1e2cp+7,         -0x1p+0, INEXACT) // 1.566225213130642668346581558581e+00
T(RN,    0x1.910332279a78bp+0,    0x1.ccaffc02b38e8p+7,         -0x1p-1, INEXACT) // 1.566455015820312324237306711439e+00
T(RN,    0x1.910db8f625dc2p+0,    0x1.de632b0fc7e3bp+7,          0x1p-1, INEXACT) // 1.566615638823222855791073016007e+00
T(RZ,    0x1.91708661bc34ep+0,    0x1.761959e72fa5fp+8,         -0x1p+0, INEXACT) // 1.568123244153145190438181089121e+00
T(RN,    0x1.919052bc710ffp+0,    0x1.c91012f2eb674p+8,         -0x1p-1, INEXACT) // 1.568608447080862111633337008243e+00
T(RZ,    0x1.919c0927df64ap+0,    0x1.f1b8434891c61p+8,         -0x1p+0, INEXACT) // 1.568787166819122891325832824805e+00
T(RZ,     0x1.91beeb637f56p+0,    0x1.528d5482feb35p+9, -0x1.6a9418p-48, INEXACT) // 1.569319450179442299031506991014e+00
// The following are Sun's value distributed with libmcr 0.9
T(RZ,  0x1.0fc30a478a765p+354,   -0x1.0863fff8e6cd1p+0,   0x1.ffbca6p-1, INEXACT)
T(RU,  0x1.0fc30a478a765p+354,   -0x1.0863fff8e6cd1p+0,   0x1.ffbca6p-1, INEXACT)
T(RD,  0x1.0fc30a478a765p+354,   -0x1.0863fff8e6cd2p+0,  -0x1.0d672p-11, INEXACT)
T(RN,   0x1.15561210e5995p+98,    0x1.45efa6da12387p+1,  -0x1.ff3a72p-2, INEXACT)
T(RN,  0x1.49323d867ac25p+216,   -0x1.196dd9dc9433cp-3,   -0x1.ffab7p-2, INEXACT)
T(RN,  -0x1.f118172cf8da5p+35,   -0x1.c1e29d1db7de1p-3,  -0x1.ff8026p-2, INEXACT)
T(RN, -0x1.f9347b8aefc11p+455,   -0x1.65e5cc95e64b7p+5,   -0x1.ff3fap-2, INEXACT)
T(RZ,  0x1.ddb7979bec0a2p+924,   -0x1.97c6765290b2cp+0,  0x1.0d3bcap-11, INEXACT)
T(RU,  0x1.ddb7979bec0a2p+924,   -0x1.97c6765290b2cp+0,  0x1.0d3bcap-11, INEXACT)
T(RD,  0x1.ddb7979bec0a2p+924,   -0x1.97c6765290b2dp+0,  -0x1.ffbcb2p-1, INEXACT)
T(RN, -0x1.2f0eedabea266p+697,   -0x1.d98ba541f08a4p-2,  -0x1.fff21cp-2, INEXACT)
T(RZ, -0x1.0a812f282bb4fp+488,    0x1.384d68f25e003p+0, -0x1.03e2bcp-11, INEXACT)
T(RD, -0x1.0a812f282bb4fp+488,    0x1.384d68f25e003p+0, -0x1.03e2bcp-11, INEXACT)
T(RU, -0x1.0a812f282bb4fp+488,    0x1.384d68f25e004p+0,   0x1.ffbf08p-1, INEXACT)
T(RZ, -0x1.98b3b2b9a33d4p+110,   -0x1.b16a2b75eb51ap-1,  0x1.3c5a78p-11, INEXACT)
T(RU, -0x1.98b3b2b9a33d4p+110,   -0x1.b16a2b75eb51ap-1,  0x1.3c5a78p-11, INEXACT)
T(RD, -0x1.98b3b2b9a33d4p+110,   -0x1.b16a2b75eb51bp-1,  -0x1.ffb0eap-1, INEXACT)
T(RN, -0x1.1be29d6924003p+481,    0x1.7a19fe05dc93dp+2,  -0x1.ff0cfcp-2, INEXACT)
T(RZ, -0x1.c30f8740a13b1p+287,   -0x1.60b889c896301p+2,   0x1.ffad02p-1, INEXACT)
T(RU, -0x1.c30f8740a13b1p+287,   -0x1.60b889c896301p+2,   0x1.ffad02p-1, INEXACT)
T(RD, -0x1.c30f8740a13b1p+287,   -0x1.60b889c896302p+2, -0x1.4bf81cp-11, INEXACT)
T(RN, -0x1.75767d4ba4ccap+107,    0x1.42252469e53a3p+0,  -0x1.ff4974p-2, INEXACT)
T(RN,  -0x1.d4de71cba7f17p+42,   -0x1.214b58d96d433p-3,  -0x1.ff77b6p-2, INEXACT)
T(RN, -0x1.2f79ef6db250cp+487,   -0x1.63cbd0acc75a8p+2,  -0x1.ffb426p-2, INEXACT)
T(RZ,  0x1.54ef64082b3c2p+341,   -0x1.88609de628a1fp-3,   0x1.ff9352p-1, INEXACT)
T(RU,  0x1.54ef64082b3c2p+341,   -0x1.88609de628a1fp-3,   0x1.ff9352p-1, INEXACT)
T(RD,  0x1.54ef64082b3c2p+341,    -0x1.88609de628a2p-3, -0x1.b2baecp-11, INEXACT)
T(RZ,  0x1.7ddbf0179ffa2p+969,   -0x1.2801f6030598fp-2,  0x1.461ad2p-14, INEXACT)
T(RU,  0x1.7ddbf0179ffa2p+969,   -0x1.2801f6030598fp-2,  0x1.461ad2p-14, INEXACT)
T(RD,  0x1.7ddbf0179ffa2p+969,    -0x1.2801f6030599p-2,   -0x1.fff5dp-1, INEXACT)
T(RZ,  -0x1.f346229bde73p+786,    0x1.13e8160c742a2p-1,  -0x1.ff961cp-1, INEXACT)
T(RD,  -0x1.f346229bde73p+786,    0x1.13e8160c742a2p-1,  -0x1.ff961cp-1, INEXACT)
T(RU,  -0x1.f346229bde73p+786,    0x1.13e8160c742a3p-1,  0x1.a78f32p-11, INEXACT)
T(RN,  0x1.6407fd78c8e87p+861,    0x1.95db695cf11e2p+3,  -0x1.ffd532p-2, INEXACT)
T(RN,  0x1.f0cfc23d23b66p+884,    0x1.eab61f552287dp-2,  -0x1.ffc9fep-2, INEXACT)
T(RN, -0x1.eea08f29dc587p+934,   -0x1.4f6f627a0b5b7p-2,   -0x1.ffccfp-2, INEXACT)
T(RZ, -0x1.c1f26a714ec87p+230,    0x1.865882a8b942ap+0, -0x1.2e1342p-11, INEXACT)
T(RD, -0x1.c1f26a714ec87p+230,    0x1.865882a8b942ap+0, -0x1.2e1342p-11, INEXACT)
T(RU, -0x1.c1f26a714ec87p+230,    0x1.865882a8b942bp+0,   0x1.ffb47cp-1, INEXACT)
T(RZ, -0x1.aad1522f8001bp+336,    0x1.674219716665dp-1, -0x1.08f926p-14, INEXACT)
T(RD, -0x1.aad1522f8001bp+336,    0x1.674219716665dp-1, -0x1.08f926p-14, INEXACT)
T(RU, -0x1.aad1522f8001bp+336,    0x1.674219716665ep-1,   0x1.fff7b8p-1, INEXACT)
T(RN,  0x1.8d7a0a37ff958p+580,   -0x1.9d6bea8b0523cp-1,  -0x1.ff2bacp-2, INEXACT)
T(RZ,  0x1.37f519419ba65p+983,    -0x1.0a7097d68674p-1,   0x1.ff9ea6p-1, INEXACT)
T(RU,  0x1.37f519419ba65p+983,    -0x1.0a7097d68674p-1,   0x1.ff9ea6p-1, INEXACT)
T(RD,  0x1.37f519419ba65p+983,   -0x1.0a7097d686741p-1, -0x1.856a1ep-11, INEXACT)
T(RN, -0x1.f20ca84306894p+120,   -0x1.43aa19faeb064p+2,  -0x1.ff913ep-2, INEXACT)
T(RN, -0x1.f19e66c0e23ddp+476,    0x1.f71f65d69178cp+0,   -0x1.ff36cp-2, INEXACT)
T(RN,   0x1.299b095618f5p+478,    0x1.a88dfc5a80a3bp-1,   -0x1.ff1bfp-2, INEXACT)
T(RZ,  0x1.9e3071e333f15p+613,   -0x1.ff52ca89f88ebp+0,   0x1.ffec7ep-1, INEXACT)
T(RU,  0x1.9e3071e333f15p+613,   -0x1.ff52ca89f88ebp+0,   0x1.ffec7ep-1, INEXACT)
T(RD,  0x1.9e3071e333f15p+613,   -0x1.ff52ca89f88ecp+0,  -0x1.381f2p-13, INEXACT)
T(RN,  0x1.644aeeeeab2cbp+777,   -0x1.13c123e41110dp+2,  -0x1.ffdd8cp-2, INEXACT)
T(RN,  0x1.8a423ab174dacp+136,    0x1.193c6587b6ffdp+3,  -0x1.ff6ab4p-2, INEXACT)
T(RZ, -0x1.f56f7c3bda9b8p+121,    0x1.0ab0bcfe0ad4bp+0, -0x1.48d5b4p-13, INEXACT)
T(RD, -0x1.f56f7c3bda9b8p+121,    0x1.0ab0bcfe0ad4bp+0, -0x1.48d5b4p-13, INEXACT)
T(RU, -0x1.f56f7c3bda9b8p+121,    0x1.0ab0bcfe0ad4cp+0,   0x1.ffeb72p-1, INEXACT)
T(RZ,  0x1.c5614e1df5bc3p+542,    0x1.3eb1d3b5cb2b6p+3,  -0x1.9dc7cp-14, INEXACT)
T(RD,  0x1.c5614e1df5bc3p+542,    0x1.3eb1d3b5cb2b6p+3,  -0x1.9dc7cp-14, INEXACT)
T(RU,  0x1.c5614e1df5bc3p+542,    0x1.3eb1d3b5cb2b7p+3,   0x1.fff312p-1, INEXACT)
T(RZ, -0x1.79a025f902dfcp+106,    -0x1.b21e232ba9c8p+1,  0x1.6679d2p-11, INEXACT)
T(RU, -0x1.79a025f902dfcp+106,    -0x1.b21e232ba9c8p+1,  0x1.6679d2p-11, INEXACT)
T(RD, -0x1.79a025f902dfcp+106,   -0x1.b21e232ba9c81p+1,  -0x1.ffa662p-1, INEXACT)
T(RZ,  0x1.94e4399aaa29fp+980,     0x1.2eb115be47cdp+1,  -0x1.fffabcp-1, INEXACT)
T(RD,  0x1.94e4399aaa29fp+980,     0x1.2eb115be47cdp+1,  -0x1.fffabcp-1, INEXACT)
T(RU,  0x1.94e4399aaa29fp+980,    0x1.2eb115be47cd1p+1,  0x1.50c83cp-15, INEXACT)
T(RZ,  0x1.d54ad9684a475p+744,   -0x1.9790ae8dc5c31p-2,  0x1.056a1ep-11, INEXACT)
T(RU,  0x1.d54ad9684a475p+744,   -0x1.9790ae8dc5c31p-2,  0x1.056a1ep-11, INEXACT)
T(RD,  0x1.d54ad9684a475p+744,   -0x1.9790ae8dc5c32p-2,  -0x1.ffbea6p-1, INEXACT)
T(RZ, -0x1.bc67059236541p+687,   -0x1.24e00789333e4p-2,    0x1.ffffbp-1, INEXACT)
T(RU, -0x1.bc67059236541p+687,   -0x1.24e00789333e4p-2,    0x1.ffffbp-1, INEXACT)
T(RD, -0x1.bc67059236541p+687,   -0x1.24e00789333e5p-2, -0x1.415dfcp-19, INEXACT)
T(RN, -0x1.f342fba5f5626p+486,    -0x1.221e59dc438ep+2,   -0x1.ff251p-2, INEXACT)
T(RZ,  0x1.fe12e9867717cp+256,   -0x1.ef3d2e483ead1p-4,   0x1.ffac8cp-1, INEXACT)
T(RU,  0x1.fe12e9867717cp+256,   -0x1.ef3d2e483ead1p-4,   0x1.ffac8cp-1, INEXACT)
T(RD,  0x1.fe12e9867717cp+256,   -0x1.ef3d2e483ead2p-4, -0x1.4dd0a6p-11, INEXACT)
T(RZ, -0x1.c9cf090f17e2bp+458,   -0x1.2db73fed300a9p+0,   0x1.fff1dcp-1, INEXACT)
T(RU, -0x1.c9cf090f17e2bp+458,   -0x1.2db73fed300a9p+0,   0x1.fff1dcp-1, INEXACT)
T(RD, -0x1.c9cf090f17e2bp+458,   -0x1.2db73fed300aap+0, -0x1.c497e4p-14, INEXACT)
T(RN,  -0x1.059ea72dabdf3p+92,   -0x1.ae09f7b9b770dp+2,  -0x1.ffc128p-2, INEXACT)
T(RN, -0x1.5ecbd7431db03p+866,   -0x1.a81ab0b870e94p+0,  -0x1.ffe42cp-2, INEXACT)
T(RN,  0x1.419d29da70e39p+779,    0x1.37b50af044e28p+0,  -0x1.ff834ep-2, INEXACT)
T(RZ,  0x1.ede55ab807a72p+572,   -0x1.6a38283a7861bp-2,   0x1.ffe902p-1, INEXACT)
T(RU,  0x1.ede55ab807a72p+572,   -0x1.6a38283a7861bp-2,   0x1.ffe902p-1, INEXACT)
T(RD,  0x1.ede55ab807a72p+572,   -0x1.6a38283a7861cp-2, -0x1.6fe128p-13, INEXACT)
T(RZ,-0x1.1db50b21bc51ep+1010,    0x1.ade4c1f5a93f3p-3, -0x1.c4d176p-14, INEXACT)
T(RD,-0x1.1db50b21bc51ep+1010,    0x1.ade4c1f5a93f3p-3, -0x1.c4d176p-14, INEXACT)
T(RU,-0x1.1db50b21bc51ep+1010,    0x1.ade4c1f5a93f4p-3,   0x1.fff1dap-1, INEXACT)
T(RZ,  0x1.1c8ae95c6135ep+656,    0x1.1fe21a089188ep+1, -0x1.6f8656p-12, INEXACT)
T(RD,  0x1.1c8ae95c6135ep+656,    0x1.1fe21a089188ep+1, -0x1.6f8656p-12, INEXACT)
T(RU,  0x1.1c8ae95c6135ep+656,    0x1.1fe21a089188fp+1,    0x1.ffd21p-1, INEXACT)
T(RZ, -0x1.9560c35a568e6p+447,    -0x1.460aa253d715p+1,   0x1.da8f3p-14, INEXACT)
T(RU, -0x1.9560c35a568e6p+447,    -0x1.460aa253d715p+1,   0x1.da8f3p-14, INEXACT)
T(RD, -0x1.9560c35a568e6p+447,   -0x1.460aa253d7151p+1,  -0x1.fff12cp-1, INEXACT)
T(RN,  0x1.4728bc45c35eep+849,    0x1.50ec7e662c826p-2,  -0x1.ffe4d6p-2, INEXACT)
T(RZ, -0x1.20af2203af747p+125,   -0x1.8f0b12f5d7b4ap-3,   0x1.1bd61p-14, INEXACT)
T(RU, -0x1.20af2203af747p+125,   -0x1.8f0b12f5d7b4ap-3,   0x1.1bd61p-14, INEXACT)
T(RD, -0x1.20af2203af747p+125,   -0x1.8f0b12f5d7b4bp-3,  -0x1.fff722p-1, INEXACT)
T(RZ, -0x1.726ac6ece187fp+432,    0x1.28d2501fd95f9p-5, -0x1.742a9ep-14, INEXACT)
T(RD, -0x1.726ac6ece187fp+432,    0x1.28d2501fd95f9p-5, -0x1.742a9ep-14, INEXACT)
T(RU, -0x1.726ac6ece187fp+432,    0x1.28d2501fd95fap-5,   0x1.fff45ep-1, INEXACT)
T(RZ,  0x1.b9a871ccfd958p+586,    0x1.ade0ebf41cd8ap+0,  -0x1.fffb06p-1, INEXACT)
T(RD,  0x1.b9a871ccfd958p+586,    0x1.ade0ebf41cd8ap+0,  -0x1.fffb06p-1, INEXACT)
T(RU,  0x1.b9a871ccfd958p+586,    0x1.ade0ebf41cd8bp+0,  0x1.3ebc5ap-15, INEXACT)
T(RN,  0x1.cda23695fb111p+550,   -0x1.027a2f0244efcp+1,  -0x1.ff90a8p-2, INEXACT)
T(RN,  0x1.9316fd33a3819p+203,    0x1.025b569dcbe73p-1,  -0x1.ffa062p-2, INEXACT)
T(RZ, -0x1.515e6c4fbdb91p+888,    0x1.72ef347f5a53fp-3,  -0x1.fff35ep-1, INEXACT)
T(RD, -0x1.515e6c4fbdb91p+888,    0x1.72ef347f5a53fp-3,  -0x1.fff35ep-1, INEXACT)
T(RU, -0x1.515e6c4fbdb91p+888,     0x1.72ef347f5a54p-3,  0x1.9455c2p-14, INEXACT)
T(RZ, -0x1.726a4e4b73943p+951,   -0x1.15ad7772fe966p+1,  0x1.4389e6p-13, INEXACT)
T(RU, -0x1.726a4e4b73943p+951,   -0x1.15ad7772fe966p+1,  0x1.4389e6p-13, INEXACT)
T(RD, -0x1.726a4e4b73943p+951,   -0x1.15ad7772fe967p+1,  -0x1.ffebc8p-1, INEXACT)
T(RZ,    0x1.38135fcaa0ep+117,    0x1.05e9bb4d62087p-5,  -0x1.ffcdb4p-1, INEXACT)
T(RD,    0x1.38135fcaa0ep+117,    0x1.05e9bb4d62087p-5,  -0x1.ffcdb4p-1, INEXACT)
T(RU,    0x1.38135fcaa0ep+117,    0x1.05e9bb4d62088p-5,   0x1.9266bp-12, INEXACT)
T(RZ,  0x1.fd3f86d120947p+521,    0x1.e045486a416b2p-2,  -0x1.ffe7e2p-1, INEXACT)
T(RD,  0x1.fd3f86d120947p+521,    0x1.e045486a416b2p-2,  -0x1.ffe7e2p-1, INEXACT)
T(RU,  0x1.fd3f86d120947p+521,    0x1.e045486a416b3p-2,  0x1.81d1fap-13, INEXACT)
T(RZ, -0x1.fdae38a42e0bep+155,    0x1.e4617f5e807ebp+0,   -0x1.fff86p-1, INEXACT)
T(RD, -0x1.fdae38a42e0bep+155,    0x1.e4617f5e807ebp+0,   -0x1.fff86p-1, INEXACT)
T(RU, -0x1.fdae38a42e0bep+155,    0x1.e4617f5e807ecp+0,  0x1.e81088p-15, INEXACT)
T(RN,  0x1.ffbacdaaa70fp+1003,   -0x1.73772df47fa93p+0,  -0x1.ffd032p-2, INEXACT)
T(RN, -0x1.a4638e73cd6bep+575,    0x1.5b89073c96399p-2,  -0x1.fff086p-2, INEXACT)
T(RZ, -0x1.d1316a92a508cp+570,   -0x1.de24e1db34d0ep+7,   0x1.fff6cep-1, INEXACT)
T(RU, -0x1.d1316a92a508cp+570,   -0x1.de24e1db34d0ep+7,   0x1.fff6cep-1, INEXACT)
T(RD, -0x1.d1316a92a508cp+570,   -0x1.de24e1db34d0fp+7, -0x1.263f8ep-14, INEXACT)
T(RN,  -0x1.d3b3d7c627a1p+956,    0x1.92184df21786fp-1,  -0x1.ffc828p-2, INEXACT)
T(RN,  0x1.1d4ce7edfb7f4p+719,   -0x1.fe0429870b233p+1,  -0x1.ff86c8p-2, INEXACT)
T(RZ,  0x1.bca52c9e607d7p+756,    0x1.c7cb0e5149846p+0,  -0x1.ffd74ap-1, INEXACT)
T(RD,  0x1.bca52c9e607d7p+756,    0x1.c7cb0e5149846p+0,  -0x1.ffd74ap-1, INEXACT)
T(RU,  0x1.bca52c9e607d7p+756,    0x1.c7cb0e5149847p+0,  0x1.45b618p-12, INEXACT)
T(RZ,  0x1.4f58eb8ee983dp+721,    0x1.cdeaadd106d99p+1, -0x1.ab8a8ep-13, INEXACT)
T(RD,  0x1.4f58eb8ee983dp+721,    0x1.cdeaadd106d99p+1, -0x1.ab8a8ep-13, INEXACT)
T(RU,  0x1.4f58eb8ee983dp+721,    0x1.cdeaadd106d9ap+1,   0x1.ffe548p-1, INEXACT)
T(RN, -0x1.326e94b53209bp+463,    0x1.5339593e812b4p-1,  -0x1.fffee8p-2, INEXACT)
T(RZ,  0x1.326e287d4345bp+811,   -0x1.d2056550fe667p+0,   0x1.ffca76p-1, INEXACT)
T(RU,  0x1.326e287d4345bp+811,   -0x1.d2056550fe667p+0,   0x1.ffca76p-1, INEXACT)
T(RD,  0x1.326e287d4345bp+811,   -0x1.d2056550fe668p+0, -0x1.ac5286p-12, INEXACT)
T(RZ,  -0x1.fcf3da9a44eaep+30,   -0x1.2728348f5e842p-1,   0x1.ffd4f4p-1, INEXACT)
T(RU,  -0x1.fcf3da9a44eaep+30,   -0x1.2728348f5e842p-1,   0x1.ffd4f4p-1, INEXACT)
T(RD,  -0x1.fcf3da9a44eaep+30,   -0x1.2728348f5e843p-1, -0x1.585a68p-12, INEXACT)
T(RN,  0x1.c23187cd58a3ap+723,   -0x1.c7d9acf8b4faap-1,  -0x1.ff95f6p-2, INEXACT)
T(RZ,  0x1.06e76a00a0b79p+758,   -0x1.959d48540da57p-1,    0x1.ffe11p-1, INEXACT)
T(RU,  0x1.06e76a00a0b79p+758,   -0x1.959d48540da57p-1,    0x1.ffe11p-1, INEXACT)
T(RD,  0x1.06e76a00a0b79p+758,   -0x1.959d48540da58p-1, -0x1.ef0bbap-13, INEXACT)
T(RZ, -0x1.1ced2077c0cffp+734,    0x1.4127b86dfc54dp+1,  -0x1.ffdfd4p-1, INEXACT)
T(RD, -0x1.1ced2077c0cffp+734,    0x1.4127b86dfc54dp+1,  -0x1.ffdfd4p-1, INEXACT)
T(RU, -0x1.1ced2077c0cffp+734,    0x1.4127b86dfc54ep+1,  0x1.015a7cp-12, INEXACT)
T(RZ,   0x1.c23c5edcdd686p+56,   -0x1.4c2acecdb0aabp-1,  0x1.1cd996p-12, INEXACT)
T(RU,   0x1.c23c5edcdd686p+56,   -0x1.4c2acecdb0aabp-1,  0x1.1cd996p-12, INEXACT)
T(RD,   0x1.c23c5edcdd686p+56,   -0x1.4c2acecdb0aacp-1,  -0x1.ffdc64p-1, INEXACT)
T(RN, -0x1.13c1508c027d9p+965,    0x1.79dae9c7b2d59p-1,  -0x1.ffab72p-2, INEXACT)
T(RN,  0x1.46dbf59151b67p+885,    0x1.a084a811e5f2cp-6,  -0x1.ffda66p-2, INEXACT)
T(RN, -0x1.7c99a069b2a3fp+889,    0x1.d51583a3fe22ap-2,  -0x1.ffdebep-2, INEXACT)
T(RN,  0x1.b1317bb1baa07p+261,   -0x1.57dbb80512c29p-1,  -0x1.ff9c56p-2, INEXACT)
T(RN,   0x1.9c1478705731p+997,   -0x1.ec2bf26f2b4bdp-2,  -0x1.ffd33ap-2, INEXACT)
T(RN,  0x1.ca854fb48138cp+979,    0x1.2e49ed31193b1p+0,  -0x1.ffa114p-2, INEXACT)
T(RN,  0x1.9f1d5c9fe0d1cp+347,    0x1.198a1c1a070aep-2,  -0x1.ffd28ep-2, INEXACT)
T(RN,  0x1.0f59f38025725p+547,    0x1.2156a889fa91cp-4,  -0x1.ffac8ap-2, INEXACT)
T(RN,   0x1.493caa477b40ep+97,   -0x1.77ebeaf11500fp+5,  -0x1.ff8a14p-2, INEXACT)
T(RZ,-0x1.6c92f962fe41ap+1016,    0x1.775364503286ap+2, -0x1.fc670ep-14, INEXACT)
T(RD,-0x1.6c92f962fe41ap+1016,    0x1.775364503286ap+2, -0x1.fc670ep-14, INEXACT)
T(RU,-0x1.6c92f962fe41ap+1016,    0x1.775364503286bp+2,   0x1.fff01cp-1, INEXACT)
T(RZ,  -0x1.ff26e1d1a7ff4p+58,   -0x1.1aea08c4d3f99p+2,  0x1.ad3318p-14, INEXACT)
T(RU,  -0x1.ff26e1d1a7ff4p+58,   -0x1.1aea08c4d3f99p+2,  0x1.ad3318p-14, INEXACT)
T(RD,  -0x1.ff26e1d1a7ff4p+58,   -0x1.1aea08c4d3f9ap+2,  -0x1.fff296p-1, INEXACT)
T(RZ,  -0x1.e73fefec3fe7ap+14,   -0x1.2fde1f9ef5b01p-1,   0x1.ffe564p-1, INEXACT)
T(RU,  -0x1.e73fefec3fe7ap+14,   -0x1.2fde1f9ef5b01p-1,   0x1.ffe564p-1, INEXACT)
T(RD,  -0x1.e73fefec3fe7ap+14,   -0x1.2fde1f9ef5b02p-1, -0x1.a9b826p-13, INEXACT)
T(RZ, -0x1.553444e84c46bp+672,    0x1.4602572931a7dp+1,  -0x1.ffe3bap-1, INEXACT)
T(RD, -0x1.553444e84c46bp+672,    0x1.4602572931a7dp+1,  -0x1.ffe3bap-1, INEXACT)
T(RU, -0x1.553444e84c46bp+672,    0x1.4602572931a7ep+1,  0x1.c460a2p-13, INEXACT)
T(RN, -0x1.a4d872965ba39p+586,   -0x1.1e668d4829fb9p-5,  -0x1.fff1c8p-2, INEXACT)
T(RZ, -0x1.7485795172ec7p+777,     0x1.1e90c39640bdp+0, -0x1.d19e96p-15, INEXACT)
T(RD, -0x1.7485795172ec7p+777,     0x1.1e90c39640bdp+0, -0x1.d19e96p-15, INEXACT)
T(RU, -0x1.7485795172ec7p+777,    0x1.1e90c39640bd1p+0,   0x1.fff8bap-1, INEXACT)
T(RN, -0x1.038c66b99d403p+716,    0x1.62a902518191ap-4,  -0x1.ffc9fep-2, INEXACT)
T(RZ, -0x1.4e5818b5a9bccp+655,    0x1.1b0dca0420248p+0,  -0x1.ffe83cp-1, INEXACT)
T(RD, -0x1.4e5818b5a9bccp+655,    0x1.1b0dca0420248p+0,  -0x1.ffe83cp-1, INEXACT)
T(RU, -0x1.4e5818b5a9bccp+655,    0x1.1b0dca0420249p+0,  0x1.7c42f2p-13, INEXACT)
T(RZ,  0x1.2c9f3aa90f834p+521,    0x1.1140bcadbda8ep-1,  -0x1.fff63ap-1, INEXACT)
T(RD,  0x1.2c9f3aa90f834p+521,    0x1.1140bcadbda8ep-1,  -0x1.fff63ap-1, INEXACT)
T(RU,  0x1.2c9f3aa90f834p+521,    0x1.1140bcadbda8fp-1,  0x1.38b27ep-14, INEXACT)
T(RN,  0x1.1a080c30b1501p+925,     0x1.d64208996b38p+1,  -0x1.fffd18p-2, INEXACT)
T(RZ, -0x1.4512e57dce9cfp+758,   -0x1.499c4a654540fp+3,   0x1.ffe642p-1, INEXACT)
T(RU, -0x1.4512e57dce9cfp+758,   -0x1.499c4a654540fp+3,   0x1.ffe642p-1, INEXACT)
T(RD, -0x1.4512e57dce9cfp+758,    -0x1.499c4a654541p+3, -0x1.9bdc7cp-13, INEXACT)
T(RZ,  0x1.96252585f91fap+473,    0x1.a43575dfcd6bap-2,   -0x1.2cc6p-13, INEXACT)
T(RD,  0x1.96252585f91fap+473,    0x1.a43575dfcd6bap-2,   -0x1.2cc6p-13, INEXACT)
T(RU,  0x1.96252585f91fap+473,    0x1.a43575dfcd6bbp-2,   0x1.ffed34p-1, INEXACT)
T(RZ,  0x1.63785e30ece0dp+847,    0x1.e70eab93a6999p+0,  -0x1.222a1p-13, INEXACT)
T(RD,  0x1.63785e30ece0dp+847,    0x1.e70eab93a6999p+0,  -0x1.222a1p-13, INEXACT)
T(RU,  0x1.63785e30ece0dp+847,    0x1.e70eab93a699ap+0,   0x1.ffeddep-1, INEXACT)
T(RZ, -0x1.32ce5291640c7p+238,    0x1.9b2eb262a62b5p+1,  -0x1.ffe0f4p-1, INEXACT)
T(RD, -0x1.32ce5291640c7p+238,    0x1.9b2eb262a62b5p+1,  -0x1.ffe0f4p-1, INEXACT)
T(RU, -0x1.32ce5291640c7p+238,    0x1.9b2eb262a62b6p+1,  0x1.f0c04ep-13, INEXACT)
T(RZ,  0x1.d6128736a7155p+234,    0x1.23730d7a67bcep+0,  -0x1.ffe23cp-1, INEXACT)
T(RD,  0x1.d6128736a7155p+234,    0x1.23730d7a67bcep+0,  -0x1.ffe23cp-1, INEXACT)
T(RU,  0x1.d6128736a7155p+234,    0x1.23730d7a67bcfp+0,  0x1.dc449cp-13, INEXACT)
T(RZ,  0x1.cb0ba827c7e08p+735,    0x1.128eb4a7c2325p+0, -0x1.5ed6ecp-15, INEXACT)
T(RD,  0x1.cb0ba827c7e08p+735,    0x1.128eb4a7c2325p+0, -0x1.5ed6ecp-15, INEXACT)
T(RU,  0x1.cb0ba827c7e08p+735,    0x1.128eb4a7c2326p+0,   0x1.fffa84p-1, INEXACT)
T(RZ,  0x1.32f431e96739ap+246,    0x1.b5c7b02e205fap-5, -0x1.8b25e6p-13, INEXACT)
T(RD,  0x1.32f431e96739ap+246,    0x1.b5c7b02e205fap-5, -0x1.8b25e6p-13, INEXACT)
T(RU,  0x1.32f431e96739ap+246,    0x1.b5c7b02e205fbp-5,   0x1.ffe74ep-1, INEXACT)
T(RZ,  0x1.459b2fc8e8316p+298,   -0x1.8a27e9053883dp+0,   0x1.fff134p-1, INEXACT)
T(RU,  0x1.459b2fc8e8316p+298,   -0x1.8a27e9053883dp+0,   0x1.fff134p-1, INEXACT)
T(RD,  0x1.459b2fc8e8316p+298,   -0x1.8a27e9053883ep+0, -0x1.d97afcp-14, INEXACT)
T(RN, -0x1.ccf508c76c148p+851,     -0x1.2ca88510b82p+2,   -0x1.ffc76p-2, INEXACT)
T(RN, -0x1.f5f2a8f556051p+600,    0x1.c91bbfd10e5f9p-3,  -0x1.ffc538p-2, INEXACT)
T(RZ, -0x1.42bffd192ea3dp+657,    0x1.b8c83ba1599d1p-5,  -0x1.fffe28p-1, INEXACT)
T(RD, -0x1.42bffd192ea3dp+657,    0x1.b8c83ba1599d1p-5,  -0x1.fffe28p-1, INEXACT)
T(RU, -0x1.42bffd192ea3dp+657,    0x1.b8c83ba1599d2p-5,  0x1.d727b8p-17, INEXACT)
T(RN,   0x1.371a37b9cd09p+834,   -0x1.791de498033d8p+2,  -0x1.ffc854p-2, INEXACT)
T(RZ,   0x1.194d288e3708p+668,    0x1.95e397316db08p-3,  -0x1.ffe34cp-1, INEXACT)
T(RD,   0x1.194d288e3708p+668,    0x1.95e397316db08p-3,  -0x1.ffe34cp-1, INEXACT)
T(RU,   0x1.194d288e3708p+668,    0x1.95e397316db09p-3,  0x1.cb4022p-13, INEXACT)
T(RN,  -0x1.b3a4ef7b7e182p+74,   -0x1.f0dee070197a8p-1,  -0x1.ffefeap-2, INEXACT)
T(RN,   0x1.2a8101f7d31dap+64,   -0x1.272e231299024p+3,  -0x1.ffe60ep-2, INEXACT)
T(RZ,  -0x1.539c534cfde22p+42,   -0x1.e3f8ec9d3c447p+0,    0x1.ffe3ap-1, INEXACT)
T(RU,  -0x1.539c534cfde22p+42,   -0x1.e3f8ec9d3c447p+0,    0x1.ffe3ap-1, INEXACT)
T(RD,  -0x1.539c534cfde22p+42,   -0x1.e3f8ec9d3c448p+0, -0x1.c5fe78p-13, INEXACT)
T(RZ,  0x1.c882220e6f2bap+660,    0x1.028db84067927p-1,  -0x1.fff9bap-1, INEXACT)
T(RD,  0x1.c882220e6f2bap+660,    0x1.028db84067927p-1,  -0x1.fff9bap-1, INEXACT)
T(RU,  0x1.c882220e6f2bap+660,    0x1.028db84067928p-1,  0x1.91bb5ap-15, INEXACT)
T(RZ,-0x1.9c3d3d90f8d3bp+1002,   -0x1.6ddab3e1fcad8p-1,  0x1.9dabd6p-13, INEXACT)
T(RU,-0x1.9c3d3d90f8d3bp+1002,   -0x1.6ddab3e1fcad8p-1,  0x1.9dabd6p-13, INEXACT)
T(RD,-0x1.9c3d3d90f8d3bp+1002,   -0x1.6ddab3e1fcad9p-1,  -0x1.ffe626p-1, INEXACT)
T(RN, -0x1.801e51e0294a3p+771,   -0x1.072100f5b852dp-1,  -0x1.ffd0acp-2, INEXACT)
T(RN, -0x1.c5ca2f90a4899p+550,   -0x1.b660138efc50ap+2,   -0x1.ffdbfp-2, INEXACT)
T(RN, -0x1.87c2e76dd85d2p+241,   -0x1.d716185a45f26p+1,  -0x1.fff318p-2, INEXACT)
T(RN, -0x1.cdc9a205b0661p+189,    0x1.673e6d6a17786p+0,  -0x1.ffc656p-2, INEXACT)
T(RN, -0x1.de17686923216p+235,   -0x1.5854e128bf57fp+0,  -0x1.ffded2p-2, INEXACT)
T(RN,  0x1.fb4d0ee60fd14p+635,   -0x1.7982d44f1573cp+0,  -0x1.ffeee8p-2, INEXACT)
T(RN, 0x1.19f60508be4cfp+1010,    0x1.d4839b3562445p+1,  -0x1.ffef16p-2, INEXACT)
T(RN, -0x1.f5746793e4e9fp+489,   -0x1.18a782d5d7903p-1,  -0x1.ffdce6p-2, INEXACT)
T(RN,  0x1.7fa22d0db4926p+250,   -0x1.04c0b51905df7p+0,  -0x1.ffc388p-2, INEXACT)
T(RN, -0x1.bc56fbc57520ap+467,    0x1.fc5a1faa40f65p-1,  -0x1.ffc158p-2, INEXACT)
T(RN, -0x1.8d3e599996468p+145,    0x1.8d5417a00104ep+1,  -0x1.ffd74ep-2, INEXACT)
T(RN,  0x1.adaef6161ee89p+176,   -0x1.1cd26e6b80f67p+2,  -0x1.ffff08p-2, INEXACT)
T(RZ, -0x1.dcd2eb9fc91cdp+793,    -0x1.28457852e79cp-2,  0x1.84a6fep-17, INEXACT)
T(RU, -0x1.dcd2eb9fc91cdp+793,    -0x1.28457852e79cp-2,  0x1.84a6fep-17, INEXACT)
T(RD, -0x1.dcd2eb9fc91cdp+793,   -0x1.28457852e79c1p-2,  -0x1.fffe7cp-1, INEXACT)
T(RZ,   -0x1.9e59a860f5779p-4,   -0x1.9fc4f8f265beap-4,  0x1.9dd0acp-15, INEXACT)
T(RU,   -0x1.9e59a860f5779p-4,   -0x1.9fc4f8f265beap-4,  0x1.9dd0acp-15, INEXACT)
T(RD,   -0x1.9e59a860f5779p-4,   -0x1.9fc4f8f265bebp-4,  -0x1.fff988p-1, INEXACT)
T(RZ, -0x1.d4e56cbf46b66p+950,   -0x1.bdb084d31979ap+1,   0x1.fff6c6p-1, INEXACT)
T(RU, -0x1.d4e56cbf46b66p+950,   -0x1.bdb084d31979ap+1,   0x1.fff6c6p-1, INEXACT)
T(RD, -0x1.d4e56cbf46b66p+950,   -0x1.bdb084d31979bp+1, -0x1.275562p-14, INEXACT)
T(RZ,  0x1.443c3a9b0e409p+264,    0x1.12e9c101facb4p-1,  -0x1.fff188p-1, INEXACT)
T(RD,  0x1.443c3a9b0e409p+264,    0x1.12e9c101facb4p-1,  -0x1.fff188p-1, INEXACT)
T(RU,  0x1.443c3a9b0e409p+264,    0x1.12e9c101facb5p-1,   0x1.cee4dp-14, INEXACT)
T(RZ, -0x1.fc0c9754e5572p+503,    0x1.22b05686f51b9p-1,  -0x1.fff87cp-1, INEXACT)
T(RD, -0x1.fc0c9754e5572p+503,    0x1.22b05686f51b9p-1,  -0x1.fff87cp-1, INEXACT)
T(RU, -0x1.fc0c9754e5572p+503,    0x1.22b05686f51bap-1,  0x1.e0c72cp-15, INEXACT)
T(RZ, 0x1.1ef997a08f34ep+1013,    0x1.9b11ca9d60362p-1,  -0x1.fffd8ep-1, INEXACT)
T(RD, 0x1.1ef997a08f34ep+1013,    0x1.9b11ca9d60362p-1,  -0x1.fffd8ep-1, INEXACT)
T(RU, 0x1.1ef997a08f34ep+1013,    0x1.9b11ca9d60363p-1,  0x1.396718p-16, INEXACT)
T(RZ, -0x1.003b4bb951c87p+570,    0x1.98308170c4d38p-4,  -0x1.064cdp-16, INEXACT)
T(RD, -0x1.003b4bb951c87p+570,    0x1.98308170c4d38p-4,  -0x1.064cdp-16, INEXACT)
T(RU, -0x1.003b4bb951c87p+570,    0x1.98308170c4d39p-4,   0x1.fffdf4p-1, INEXACT)
T(RN, -0x1.c78927cf13702p+241,   -0x1.1397fca190d9bp+0,  -0x1.fff912p-2, INEXACT)
T(RN,  0x1.eb67f2bd5fe57p+650,    0x1.118433363f121p+6,  -0x1.ffe018p-2, INEXACT)
T(RZ,  0x1.f43bf85a59438p+378,    0x1.01dd22edc6616p-1, -0x1.c9064cp-14, INEXACT)
T(RD,  0x1.f43bf85a59438p+378,    0x1.01dd22edc6616p-1, -0x1.c9064cp-14, INEXACT)
T(RU,  0x1.f43bf85a59438p+378,    0x1.01dd22edc6617p-1,   0x1.fff1b8p-1, INEXACT)
T(RN,  0x1.4480803dc3bbdp+622,   -0x1.b00b469c25849p-6,  -0x1.fffd6ap-2, INEXACT)
T(RZ,  -0x1.083ed34f2694p+465,    0x1.dd03cad418f24p+0,  -0x1.fffc16p-1, INEXACT)
T(RD,  -0x1.083ed34f2694p+465,    0x1.dd03cad418f24p+0,  -0x1.fffc16p-1, INEXACT)
T(RU,  -0x1.083ed34f2694p+465,    0x1.dd03cad418f25p+0,  0x1.f4d8c6p-16, INEXACT)
T(RZ,  0x1.7e29eb099b674p+585,    0x1.10b1c140f75aep+2, -0x1.8ee39ep-18, INEXACT)
T(RD,  0x1.7e29eb099b674p+585,    0x1.10b1c140f75aep+2, -0x1.8ee39ep-18, INEXACT)
T(RU,  0x1.7e29eb099b674p+585,    0x1.10b1c140f75afp+2,   0x1.ffff38p-1, INEXACT)
T(RZ, -0x1.a2b4ddf8d2a9ap+436,   -0x1.1cef0244a2cd4p+0,   0x1.fff12ap-1, INEXACT)
T(RU, -0x1.a2b4ddf8d2a9ap+436,   -0x1.1cef0244a2cd4p+0,   0x1.fff12ap-1, INEXACT)
T(RD, -0x1.a2b4ddf8d2a9ap+436,   -0x1.1cef0244a2cd5p+0, -0x1.daa37ap-14, INEXACT)
T(RZ,  0x1.e7e695639824dp+794,    0x1.ca552fdea9c3dp-6,  -0x1.ffff9ap-1, INEXACT)
T(RD,  0x1.e7e695639824dp+794,    0x1.ca552fdea9c3dp-6,  -0x1.ffff9ap-1, INEXACT)
T(RU,  0x1.e7e695639824dp+794,    0x1.ca552fdea9c3ep-6,   0x1.98047p-19, INEXACT)
T(RN, -0x1.f9b9af2d40f84p+683,    0x1.35d7c21331128p+1,  -0x1.fff65cp-2, INEXACT)
T(RN,  -0x1.637402705b42bp+73,   -0x1.10fdd6eff82a8p+0,  -0x1.ffe264p-2, INEXACT)
T(RZ, -0x1.664b7e1af2048p+807,    -0x1.53a5dad37d7bp+1,  0x1.0c77f4p-14, INEXACT)
T(RU, -0x1.664b7e1af2048p+807,    -0x1.53a5dad37d7bp+1,  0x1.0c77f4p-14, INEXACT)
T(RD, -0x1.664b7e1af2048p+807,   -0x1.53a5dad37d7b1p+1,  -0x1.fff79cp-1, INEXACT)
T(RN,  0x1.722d46106bc03p+922,   -0x1.28c100c437c58p-1,  -0x1.ffe954p-2, INEXACT)
T(RZ, -0x1.f782bc1517a27p+962,   -0x1.b52c8d92cf793p+3,  0x1.15cb38p-15, INEXACT)
T(RU, -0x1.f782bc1517a27p+962,   -0x1.b52c8d92cf793p+3,  0x1.15cb38p-15, INEXACT)
T(RD, -0x1.f782bc1517a27p+962,   -0x1.b52c8d92cf794p+3,  -0x1.fffba8p-1, INEXACT)
T(RN,  0x1.cedd7b50e867ap+772,    0x1.15494d577eb21p-3,  -0x1.ffee8ap-2, INEXACT)
T(RN,  0x1.67387d2e15325p+110,   -0x1.4c8d656406d0ap+0,   -0x1.ffea2p-2, INEXACT)
T(RN,  0x1.d7ad7af31a3c6p+981,   -0x1.60ae556f5071ap-3,  -0x1.ffe742p-2, INEXACT)
T(RN,  0x1.5e66c4872e9dbp+274,    0x1.09da39b7e3a92p+1,  -0x1.fff9aep-2, INEXACT)
T(RN,  0x1.f8c88220ca12cp+364,    0x1.4aae6ddd85823p-2,   -0x1.fffbep-2, INEXACT)
T(RZ, -0x1.663d33d08f717p+815,    0x1.2f5d0f74bb452p+0,  -0x1.fff896p-1, INEXACT)
T(RD, -0x1.663d33d08f717p+815,    0x1.2f5d0f74bb452p+0,  -0x1.fff896p-1, INEXACT)
T(RU, -0x1.663d33d08f717p+815,    0x1.2f5d0f74bb453p+0,  0x1.da9526p-15, INEXACT)
T(RN, -0x1.e0c0fa869a4dcp+605,    0x1.665560068f818p-1,  -0x1.fffceap-2, INEXACT)
T(RN,  -0x1.94b4037f3ff87p+28,    0x1.140f2fa768ee5p+1,  -0x1.ffeb86p-2, INEXACT)
T(RZ,  0x1.fc8b96bc90bfcp+102,     0x1.2c1107a84428p+6,   -0x1.fff9ep-1, INEXACT)
T(RD,  0x1.fc8b96bc90bfcp+102,     0x1.2c1107a84428p+6,   -0x1.fff9ep-1, INEXACT)
T(RU,  0x1.fc8b96bc90bfcp+102,    0x1.2c1107a844281p+6,  0x1.87e10ap-15, INEXACT)
T(RN,  0x1.52e8b5d19e238p+562,   -0x1.25c4a3f046b5ap-1,  -0x1.ffe0e6p-2, INEXACT)
T(RN, -0x1.e0eae6efe4247p+661,   -0x1.70c479426c9dep+0,  -0x1.fff7dap-2, INEXACT)
T(RZ,  0x1.a7522dab5f3c9p+980,    0x1.462e3d5e2bbb7p-1,   -0x1.fff27p-1, INEXACT)
T(RD,  0x1.a7522dab5f3c9p+980,    0x1.462e3d5e2bbb7p-1,   -0x1.fff27p-1, INEXACT)
T(RU,  0x1.a7522dab5f3c9p+980,    0x1.462e3d5e2bbb8p-1,  0x1.b21ed8p-14, INEXACT)
T(RN,  0x1.0b9b0bc21e46ep+181,    0x1.1525cbed25e0cp-1,  -0x1.ffe00cp-2, INEXACT)
T(RZ, -0x1.b5794b5ab3bdcp+902,   -0x1.0d1094f914e18p+0,   0x1.fff282p-1, INEXACT)
T(RU, -0x1.b5794b5ab3bdcp+902,   -0x1.0d1094f914e18p+0,   0x1.fff282p-1, INEXACT)
T(RD, -0x1.b5794b5ab3bdcp+902,   -0x1.0d1094f914e19p+0, -0x1.afbce2p-14, INEXACT)
T(RZ,  0x1.2b1f83a630bdcp+881,   -0x1.5e579bdacd53ap+1,   0x1.ffffecp-1, INEXACT)
T(RU,  0x1.2b1f83a630bdcp+881,   -0x1.5e579bdacd53ap+1,   0x1.ffffecp-1, INEXACT)
T(RD,  0x1.2b1f83a630bdcp+881,   -0x1.5e579bdacd53bp+1, -0x1.403274p-21, INEXACT)
T(RZ, -0x1.d0dc337d1f7f3p+741,    0x1.b27f6d0e609a3p+0, -0x1.ab4906p-15, INEXACT)
T(RD, -0x1.d0dc337d1f7f3p+741,    0x1.b27f6d0e609a3p+0, -0x1.ab4906p-15, INEXACT)
T(RU, -0x1.d0dc337d1f7f3p+741,    0x1.b27f6d0e609a4p+0,   0x1.fff952p-1, INEXACT)
T(RN, -0x1.419dbd9807328p+368,    0x1.13047ce359046p-1,  -0x1.fffd5ap-2, INEXACT)
T(RN, -0x1.b923f1686a40bp+830,   -0x1.784f5c384edcap-2,  -0x1.ffeafap-2, INEXACT)
T(RN,  0x1.733f6617bd445p+547,    0x1.3609c3414746dp+2,  -0x1.fff856p-2, INEXACT)
T(RN,  0x1.db65335a99bc4p+714,   -0x1.61961e3829278p+1,  -0x1.ffe0aep-2, INEXACT)
T(RZ,-0x1.e5b8bd7b65e37p+1004,    0x1.3753f0618386bp+1,  -0x1.fffc0ep-1, INEXACT)
T(RD,-0x1.e5b8bd7b65e37p+1004,    0x1.3753f0618386bp+1,  -0x1.fffc0ep-1, INEXACT)
T(RU,-0x1.e5b8bd7b65e37p+1004,    0x1.3753f0618386cp+1,  0x1.f8d79ep-16, INEXACT)
T(RN,  0x1.54d2927fd3178p+808,   -0x1.d74a454fca9fdp-3,  -0x1.fff09cp-2, INEXACT)
T(RZ,  0x1.cdf6e2554e5c5p+593,    0x1.c44022f6f2725p+2, -0x1.b6b548p-17, INEXACT)
T(RD,  0x1.cdf6e2554e5c5p+593,    0x1.c44022f6f2725p+2, -0x1.b6b548p-17, INEXACT)
T(RU,  0x1.cdf6e2554e5c5p+593,    0x1.c44022f6f2726p+2,   0x1.fffe4ap-1, INEXACT)
T(RN,  0x1.8064f5d78aa66p+451,    -0x1.53a5985b540fp-3,  -0x1.fff62ap-2, INEXACT)
T(RN, -0x1.c97b1a04876f7p+130,   -0x1.e1b4468cbd442p-3,  -0x1.fff4dcp-2, INEXACT)
T(RZ, -0x1.68f93d4b2baaap+726,    0x1.6a34712afa89fp-1,  -0x1.fff9eap-1, INEXACT)
T(RD, -0x1.68f93d4b2baaap+726,    0x1.6a34712afa89fp-1,  -0x1.fff9eap-1, INEXACT)
T(RU, -0x1.68f93d4b2baaap+726,     0x1.6a34712afa8ap-1,  0x1.855938p-15, INEXACT)
T(RZ, -0x1.3d9770c0db0eap+726,   -0x1.ee999dccedabbp-1,   0x1.fffe94p-1, INEXACT)
T(RU, -0x1.3d9770c0db0eap+726,   -0x1.ee999dccedabbp-1,   0x1.fffe94p-1, INEXACT)
T(RD, -0x1.3d9770c0db0eap+726,   -0x1.ee999dccedabcp-1, -0x1.6bdfa2p-17, INEXACT)
T(RZ,  -0x1.b02173fd1f47p+470,    0x1.d9b84c09ddbcap+0,  -0x1.fffc22p-1, INEXACT)
T(RD,  -0x1.b02173fd1f47p+470,    0x1.d9b84c09ddbcap+0,  -0x1.fffc22p-1, INEXACT)
T(RU,  -0x1.b02173fd1f47p+470,    0x1.d9b84c09ddbcbp+0,  0x1.ef2128p-16, INEXACT)
T(RZ,  0x1.bfd82431653d7p+327,   -0x1.594baab42fa52p+0,  0x1.9811a2p-16, INEXACT)
T(RU,  0x1.bfd82431653d7p+327,   -0x1.594baab42fa52p+0,  0x1.9811a2p-16, INEXACT)
T(RD,  0x1.bfd82431653d7p+327,   -0x1.594baab42fa53p+0,   -0x1.fffcdp-1, INEXACT)
T(RZ, -0x1.425b5d41bbe7bp+942,    0x1.ade205db04e96p+3, -0x1.ff312ap-16, INEXACT)
T(RD, -0x1.425b5d41bbe7bp+942,    0x1.ade205db04e96p+3, -0x1.ff312ap-16, INEXACT)
T(RU, -0x1.425b5d41bbe7bp+942,    0x1.ade205db04e97p+3,   0x1.fffc02p-1, INEXACT)
T(RN,  0x1.948beed0f607ap+928,    0x1.769119202d217p-1,  -0x1.fff61ap-2, INEXACT)
T(RZ, -0x1.4eed580db1da3p+804,    -0x1.fc052268d4c4p+3,   0x1.ffffccp-1, INEXACT)
T(RU, -0x1.4eed580db1da3p+804,    -0x1.fc052268d4c4p+3,   0x1.ffffccp-1, INEXACT)
T(RD, -0x1.4eed580db1da3p+804,   -0x1.fc052268d4c41p+3, -0x1.a1b536p-20, INEXACT)
T(RN,  0x1.409b6501e375ep+305,    0x1.e997f54d85c3ap+0,  -0x1.fff13ap-2, INEXACT)
T(RZ,  0x1.6bee855dce999p+716,   -0x1.945e409f61361p-1,   0x1.3c168p-16, INEXACT)
T(RU,  0x1.6bee855dce999p+716,   -0x1.945e409f61361p-1,   0x1.3c168p-16, INEXACT)
T(RD,  0x1.6bee855dce999p+716,   -0x1.945e409f61362p-1,  -0x1.fffd88p-1, INEXACT)
T(RN,   0x1.37107e41b3e7cp+32,   -0x1.df19b26500062p-3,  -0x1.fff494p-2, INEXACT)
T(RN,   0x1.e25f53fe0eb83p+91,   -0x1.673aa93341767p+7,  -0x1.fff0c2p-2, INEXACT)
T(RZ,  -0x1.b68a86e71c723p+43,     0x1.7f606bd0a94ap+0,  -0x1.fffe32p-1, INEXACT)
T(RD,  -0x1.b68a86e71c723p+43,     0x1.7f606bd0a94ap+0,  -0x1.fffe32p-1, INEXACT)
T(RU,  -0x1.b68a86e71c723p+43,    0x1.7f606bd0a94a1p+0,  0x1.ce0812p-17, INEXACT)
T(RN,   0x1.9ab2bfb38424p+158,    0x1.023fa4d8be158p+0,  -0x1.fffb1ep-2, INEXACT)
T(RN,  0x1.e332efa199cf1p+347,   -0x1.9e8bcf1b21879p+0,  -0x1.fff536p-2, INEXACT)
T(RN,  0x1.60515d7584017p+775,   -0x1.f125c071e3a6cp-3,  -0x1.fffae4p-2, INEXACT)
T(RN,  0x1.4ccade1b03941p+200,     -0x1.9320dbf426fp-2,  -0x1.fffe2cp-2, INEXACT)
T(RZ,  0x1.e2171fe83b33fp+702,   -0x1.3b7161a1fd86ap-3,  0x1.d67e42p-21, INEXACT)
T(RU,  0x1.e2171fe83b33fp+702,   -0x1.3b7161a1fd86ap-3,  0x1.d67e42p-21, INEXACT)
T(RD,  0x1.e2171fe83b33fp+702,   -0x1.3b7161a1fd86bp-3,  -0x1.ffffe2p-1, INEXACT)
T(RN,  0x1.fa6163b0fcac5p+235,   -0x1.300e687222d8bp+3,  -0x1.fff94ap-2, INEXACT)
T(RZ,  0x1.febc91c0eaf42p+187,   -0x1.aa69d3eda90f6p-1,   0x1.fffb7ep-1, INEXACT)
T(RU,  0x1.febc91c0eaf42p+187,   -0x1.aa69d3eda90f6p-1,   0x1.fffb7ep-1, INEXACT)
T(RD,  0x1.febc91c0eaf42p+187,   -0x1.aa69d3eda90f7p-1, -0x1.204826p-15, INEXACT)
T(RZ,  0x1.f217f5098d871p+500,    0x1.5870771ce0443p+1,  -0x1.fff89ap-1, INEXACT)
T(RD,  0x1.f217f5098d871p+500,    0x1.5870771ce0443p+1,  -0x1.fff89ap-1, INEXACT)
T(RU,  0x1.f217f5098d871p+500,    0x1.5870771ce0444p+1,   0x1.d9b07p-15, INEXACT)
T(RZ,  0x1.962848ab4f567p+373,    0x1.28eb2c9904444p+0, -0x1.5597a6p-16, INEXACT)
T(RD,  0x1.962848ab4f567p+373,    0x1.28eb2c9904444p+0, -0x1.5597a6p-16, INEXACT)
T(RU,  0x1.962848ab4f567p+373,    0x1.28eb2c9904445p+0,   0x1.fffd54p-1, INEXACT)
T(RZ,  0x1.3f6b929ec2768p+543,   -0x1.5ee6d11860e0cp+1,   0x1.fffa38p-1, INEXACT)
T(RU,  0x1.3f6b929ec2768p+543,   -0x1.5ee6d11860e0cp+1,   0x1.fffa38p-1, INEXACT)
T(RD,  0x1.3f6b929ec2768p+543,   -0x1.5ee6d11860e0dp+1, -0x1.71e006p-15, INEXACT)
T(RZ, -0x1.6f7987b6a81fbp+838,   -0x1.0c7a11bbd355dp+2,  0x1.a6ca76p-18, INEXACT)
T(RU, -0x1.6f7987b6a81fbp+838,   -0x1.0c7a11bbd355dp+2,  0x1.a6ca76p-18, INEXACT)
T(RD, -0x1.6f7987b6a81fbp+838,   -0x1.0c7a11bbd355ep+2,  -0x1.ffff2cp-1, INEXACT)
T(RZ, -0x1.c568e3b13be7bp+892,   -0x1.662dd1eb3267ap+1,   0x1.fffe18p-1, INEXACT)
T(RU, -0x1.c568e3b13be7bp+892,   -0x1.662dd1eb3267ap+1,   0x1.fffe18p-1, INEXACT)
T(RD, -0x1.c568e3b13be7bp+892,   -0x1.662dd1eb3267bp+1, -0x1.e81ec4p-17, INEXACT)
T(RZ,  0x1.38670429bf1f2p+296,   -0x1.36b4aa51207c4p-4,  0x1.b50bc8p-19, INEXACT)
T(RU,  0x1.38670429bf1f2p+296,   -0x1.36b4aa51207c4p-4,  0x1.b50bc8p-19, INEXACT)
T(RD,  0x1.38670429bf1f2p+296,   -0x1.36b4aa51207c5p-4,  -0x1.ffff92p-1, INEXACT)
T(RZ,  0x1.649536d7e2d96p+909,   -0x1.0359b3f7465dap+4,   0x1.fffe1ap-1, INEXACT)
T(RU,  0x1.649536d7e2d96p+909,   -0x1.0359b3f7465dap+4,   0x1.fffe1ap-1, INEXACT)
T(RD,  0x1.649536d7e2d96p+909,   -0x1.0359b3f7465dbp+4,  -0x1.e54dap-17, INEXACT)
T(RZ, -0x1.27dbad4bd79bbp+990,    0x1.3aaf2d047b5fdp-2,  -0x1.fff82ep-1, INEXACT)
T(RD, -0x1.27dbad4bd79bbp+990,    0x1.3aaf2d047b5fdp-2,  -0x1.fff82ep-1, INEXACT)
T(RU, -0x1.27dbad4bd79bbp+990,    0x1.3aaf2d047b5fep-2,  0x1.f476aep-15, INEXACT)
T(RN, -0x1.b7322315dd9a3p+551,    0x1.2d33ce160d3a6p+1,  -0x1.fff0d8p-2, INEXACT)
T(RN,  -0x1.1913463f4a4b9p+54,    0x1.3b3008bb63877p-1,  -0x1.fff6e6p-2, INEXACT)
T(RN,   0x1.cc12d2806853p+509,   -0x1.6a9bed5b05eb1p+1,  -0x1.fff4cap-2, INEXACT)
T(RN, -0x1.d0a359838a5d8p+616,    0x1.6c4001f6bc1acp-1,  -0x1.fff65ap-2, INEXACT)
T(RN, -0x1.bc3a4859e9033p+786,    0x1.945214b0efe3dp+0,  -0x1.fff45cp-2, INEXACT)
T(RN,    0x1.70539781e18p+413,     0x1.1f11911960f4p-3,  -0x1.fff684p-2, INEXACT)
T(RN, -0x1.ecdbadec65a31p+587,   -0x1.3ccabf4ca377dp+2,  -0x1.fff208p-2, INEXACT)
T(RN,  -0x1.3a63b0f8d91b5p+32,    0x1.d86db6063c767p+2,  -0x1.fff8aap-2, INEXACT)
T(RZ, -0x1.333bfaf9d1394p+390,    0x1.03088202f5de4p-1,  -0x1.1e47ap-17, INEXACT)
T(RD, -0x1.333bfaf9d1394p+390,    0x1.03088202f5de4p-1,  -0x1.1e47ap-17, INEXACT)
T(RU, -0x1.333bfaf9d1394p+390,    0x1.03088202f5de5p-1,   0x1.fffee2p-1, INEXACT)
T(RN, -0x1.c9bdeaf085576p+825,   -0x1.fb3b3742f8446p-1,  -0x1.fffcd8p-2, INEXACT)
T(RZ, -0x1.5f96acf9a5103p+231,   -0x1.ab6dec9b36ae8p+0,   0x1.fffe5ep-1, INEXACT)
T(RU, -0x1.5f96acf9a5103p+231,   -0x1.ab6dec9b36ae8p+0,   0x1.fffe5ep-1, INEXACT)
T(RD, -0x1.5f96acf9a5103p+231,   -0x1.ab6dec9b36ae9p+0, -0x1.a1637ap-17, INEXACT)
T(RZ, -0x1.c89809bb1ec67p+877,    0x1.d69385fffec2ep-2, -0x1.06b1cep-16, INEXACT)
T(RD, -0x1.c89809bb1ec67p+877,    0x1.d69385fffec2ep-2, -0x1.06b1cep-16, INEXACT)
T(RU, -0x1.c89809bb1ec67p+877,    0x1.d69385fffec2fp-2,   0x1.fffdf2p-1, INEXACT)
T(RN, -0x1.e270d18a83feep+347,    0x1.1dbc00a7bd6cap+3,  -0x1.fffa1cp-2, INEXACT)
T(RZ,   0x1.75c63414b9f57p+19,    -0x1.13f1027a096dp-2,  0x1.caac4ep-17, INEXACT)
T(RU,   0x1.75c63414b9f57p+19,    -0x1.13f1027a096dp-2,  0x1.caac4ep-17, INEXACT)
T(RD,   0x1.75c63414b9f57p+19,   -0x1.13f1027a096d1p-2,  -0x1.fffe36p-1, INEXACT)
T(RZ, -0x1.d8f2d1557555bp+529,   -0x1.69dfcd04f1248p-1,   0x1.db523p-16, INEXACT)
T(RU, -0x1.d8f2d1557555bp+529,   -0x1.69dfcd04f1248p-1,   0x1.db523p-16, INEXACT)
T(RD, -0x1.d8f2d1557555bp+529,   -0x1.69dfcd04f1249p-1,  -0x1.fffc4ap-1, INEXACT)
T(RZ,   0x1.b94baffe3783p+681,   -0x1.f17c1ccac478fp+0,   0x1.fffdb4p-1, INEXACT)
T(RU,   0x1.b94baffe3783p+681,   -0x1.f17c1ccac478fp+0,   0x1.fffdb4p-1, INEXACT)
T(RD,   0x1.b94baffe3783p+681,    -0x1.f17c1ccac479p+0, -0x1.25df4ap-16, INEXACT)
T(RN,  -0x1.c104b8778d832p+50,    0x1.3040a55cb92dfp-1,   -0x1.fffeap-2, INEXACT)
T(RZ,   0x1.3c2b6cad11335p+91,   -0x1.f6379e8adf2fcp-1,   0x1.fffc3cp-1, INEXACT)
T(RU,   0x1.3c2b6cad11335p+91,   -0x1.f6379e8adf2fcp-1,   0x1.fffc3cp-1, INEXACT)
T(RD,   0x1.3c2b6cad11335p+91,   -0x1.f6379e8adf2fdp-1,  -0x1.e1805p-16, INEXACT)
T(RN, -0x1.764aa2bf700d3p+698,   -0x1.4bc624b1f7a53p+0,  -0x1.fffbc4p-2, INEXACT)
T(RN,  -0x1.6045d4bbc530fp+78,    -0x1.a9d364d16bd3p-1,  -0x1.fffb16p-2, INEXACT)
T(RN,  0x1.1bc1db1e41373p+365,    0x1.0afff95796073p+1,  -0x1.fffacep-2, INEXACT)
T(RZ,  0x1.5b9d657b71be2p+138,    0x1.07aac11c985e9p-1,  -0x1.fffc3ap-1, INEXACT)
T(RD,  0x1.5b9d657b71be2p+138,    0x1.07aac11c985e9p-1,  -0x1.fffc3ap-1, INEXACT)
T(RU,  0x1.5b9d657b71be2p+138,    0x1.07aac11c985eap-1,  0x1.e2f37ep-16, INEXACT)
T(RN,-0x1.1b19ca57c44e4p+1005,   -0x1.2e2e0218c62adp+2,  -0x1.fffb5cp-2, INEXACT)
T(RZ,  0x1.84bc89a348afcp+920,   -0x1.9731cc25f93d3p+1,    0x1.ffff1p-1, INEXACT)
T(RU,  0x1.84bc89a348afcp+920,   -0x1.9731cc25f93d3p+1,    0x1.ffff1p-1, INEXACT)
T(RD,  0x1.84bc89a348afcp+920,   -0x1.9731cc25f93d4p+1, -0x1.e0c058p-18, INEXACT)
T(RZ, -0x1.6c047688fe6fap+779,    0x1.aa9c849259704p+3, -0x1.240784p-16, INEXACT)
T(RD, -0x1.6c047688fe6fap+779,    0x1.aa9c849259704p+3, -0x1.240784p-16, INEXACT)
T(RU, -0x1.6c047688fe6fap+779,    0x1.aa9c849259705p+3,   0x1.fffdb8p-1, INEXACT)
T(RZ,  0x1.bff26f4b9f513p+226,   -0x1.1c969554ceda3p-1,   0x1.fffec6p-1, INEXACT)
T(RU,  0x1.bff26f4b9f513p+226,   -0x1.1c969554ceda3p-1,   0x1.fffec6p-1, INEXACT)
T(RD,  0x1.bff26f4b9f513p+226,   -0x1.1c969554ceda4p-1, -0x1.3a32c2p-17, INEXACT)
T(RN,   0x1.f956029af074p+993,   -0x1.14c8b4826903fp+1,  -0x1.fffc2cp-2, INEXACT)
T(RZ, -0x1.086e7a2cc7fc7p+420,    0x1.46a1e679e2971p-1,  -0x1.6014fp-17, INEXACT)
T(RD, -0x1.086e7a2cc7fc7p+420,    0x1.46a1e679e2971p-1,  -0x1.6014fp-17, INEXACT)
T(RU, -0x1.086e7a2cc7fc7p+420,    0x1.46a1e679e2972p-1,    0x1.fffeap-1, INEXACT)
T(RZ,   0x1.b568d3cecea9dp+30,   0x1.1bb903cac7483p-13,  -0x1.fffe26p-1, INEXACT)
T(RD,   0x1.b568d3cecea9dp+30,   0x1.1bb903cac7483p-13,  -0x1.fffe26p-1, INEXACT)
T(RU,   0x1.b568d3cecea9dp+30,   0x1.1bb903cac7484p-13,  0x1.d9db42p-17, INEXACT)
T(RZ,   0x1.f5d9ef8f15585p+69,    0x1.6818d8c9a3601p+1,  -0x1.fa463p-19, INEXACT)
T(RD,   0x1.f5d9ef8f15585p+69,    0x1.6818d8c9a3601p+1,  -0x1.fa463p-19, INEXACT)
T(RU,   0x1.f5d9ef8f15585p+69,    0x1.6818d8c9a3602p+1,   0x1.ffff82p-1, INEXACT)
T(RN, -0x1.f3f7f1b61b4c9p+736,   -0x1.e79b02f71f056p-1,  -0x1.fffe0ap-2, INEXACT)
T(RZ,  0x1.9f994852acd5cp+222,    0x1.d8aabeba4de98p-3,  -0x1.f26e5p-17, INEXACT)
T(RD,  0x1.9f994852acd5cp+222,    0x1.d8aabeba4de98p-3,  -0x1.f26e5p-17, INEXACT)
T(RU,  0x1.9f994852acd5cp+222,    0x1.d8aabeba4de99p-3,   0x1.fffe0ep-1, INEXACT)
T(RZ,  -0x1.44b8fbd43f92cp+11,    0x1.4f3ce3abf9213p-2, -0x1.7d5a94p-17, INEXACT)
T(RD,  -0x1.44b8fbd43f92cp+11,    0x1.4f3ce3abf9213p-2, -0x1.7d5a94p-17, INEXACT)
T(RU,  -0x1.44b8fbd43f92cp+11,    0x1.4f3ce3abf9214p-2,   0x1.fffe82p-1, INEXACT)
T(RZ, -0x1.ca2de6331159ap+492,    0x1.78ff0b5a04c1ep+0,   -0x1.fffdap-1, INEXACT)
T(RD, -0x1.ca2de6331159ap+492,    0x1.78ff0b5a04c1ep+0,   -0x1.fffdap-1, INEXACT)
T(RU, -0x1.ca2de6331159ap+492,    0x1.78ff0b5a04c1fp+0,  0x1.2f83e8p-16, INEXACT)
T(RN, -0x1.179cac442cda8p+337,    -0x1.1d0b1d4e670bp-2,  -0x1.fff926p-2, INEXACT)
T(RN,  -0x1.e04a50e287b7p+878,    -0x1.90e5f21d5f29p-1,  -0x1.fff866p-2, INEXACT)
T(RN,  0x1.76c32deb900abp+718,    0x1.7f7e2f3be134ap+0,  -0x1.fff8f4p-2, INEXACT)
T(RZ,   -0x1.1551831ffe3eap+6,   -0x1.be4bb2d89518dp-3,     0x1.fffdp-1, INEXACT)
T(RU,   -0x1.1551831ffe3eap+6,   -0x1.be4bb2d89518dp-3,     0x1.fffdp-1, INEXACT)
T(RD,   -0x1.1551831ffe3eap+6,   -0x1.be4bb2d89518ep-3, -0x1.802c64p-16, INEXACT)
T(RN,  0x1.da97063334867p+487,   -0x1.b2b7bf474a40dp+0,  -0x1.fffc56p-2, INEXACT)
T(RN, -0x1.dbf59f19b918fp+661,    0x1.c75bf301e1b36p-2,  -0x1.fffd86p-2, INEXACT)
T(RZ,  0x1.00ab61ad01395p+989,    0x1.ecb62829dd8dfp-3,  -0x1.fffdb2p-1, INEXACT)
T(RD,  0x1.00ab61ad01395p+989,    0x1.ecb62829dd8dfp-3,  -0x1.fffdb2p-1, INEXACT)
T(RU,  0x1.00ab61ad01395p+989,     0x1.ecb62829dd8ep-3,  0x1.26e7e8p-16, INEXACT)
T(RZ,   0x1.a9c816fea8384p+10,    0x1.9cc91587d0ed3p-2, -0x1.f7a20ap-17, INEXACT)
T(RD,   0x1.a9c816fea8384p+10,    0x1.9cc91587d0ed3p-2, -0x1.f7a20ap-17, INEXACT)
T(RU,   0x1.a9c816fea8384p+10,    0x1.9cc91587d0ed4p-2,   0x1.fffe08p-1, INEXACT)
T(RN,  0x1.73b958618fa32p+545,   -0x1.48ffbbd0255a6p+0,  -0x1.fffd38p-2, INEXACT)
T(RN,  -0x1.783d3424397bp+877,   -0x1.a3fade1d96572p+0,  -0x1.fffae4p-2, INEXACT)
T(RN, -0x1.10ba0848e32bap+175,    0x1.53db8f84f3cb8p+2,  -0x1.fffefcp-2, INEXACT)
T(RN,  0x1.f30689ac57498p+226,    0x1.dd94606d9739ap-1,  -0x1.ffff5ap-2, INEXACT)
T(RN,  -0x1.f3490228aa193p+16,   -0x1.e22efcdc7d155p+1,   -0x1.fffcep-2, INEXACT)
T(RN, -0x1.928df158cf173p+661,   -0x1.eb3b47370c1fdp+2,  -0x1.fffa0ap-2, INEXACT)
T(RZ,  0x1.31eb07dad85b9p+618,    0x1.208de70077c09p-1, -0x1.9e57cep-19, INEXACT)
T(RD,  0x1.31eb07dad85b9p+618,    0x1.208de70077c09p-1, -0x1.9e57cep-19, INEXACT)
T(RU,  0x1.31eb07dad85b9p+618,    0x1.208de70077c0ap-1,   0x1.ffff98p-1, INEXACT)
T(RN, -0x1.c29ac685decf3p+322,    0x1.191a8e7e8bbcfp+3,  -0x1.ffff5cp-2, INEXACT)
T(RZ, -0x1.84d9ae365de29p+301,    0x1.c3e2e8b901afbp-2,  -0x1.fffe76p-1, INEXACT)
T(RD, -0x1.84d9ae365de29p+301,    0x1.c3e2e8b901afbp-2,  -0x1.fffe76p-1, INEXACT)
T(RU, -0x1.84d9ae365de29p+301,    0x1.c3e2e8b901afcp-2,  0x1.8a01ccp-17, INEXACT)
T(RZ,  0x1.7b8cd92dfd265p+797,    0x1.71d093b809764p-3, -0x1.1eaac8p-19, INEXACT)
T(RD,  0x1.7b8cd92dfd265p+797,    0x1.71d093b809764p-3, -0x1.1eaac8p-19, INEXACT)
T(RU,  0x1.7b8cd92dfd265p+797,    0x1.71d093b809765p-3,   0x1.ffffb8p-1, INEXACT)
T(RZ, -0x1.a744784ea0317p+433,    0x1.88da9a9f0e736p-6,  -0x1.ffff1ap-1, INEXACT)
T(RD, -0x1.a744784ea0317p+433,    0x1.88da9a9f0e736p-6,  -0x1.ffff1ap-1, INEXACT)
T(RU, -0x1.a744784ea0317p+433,    0x1.88da9a9f0e737p-6,  0x1.cc34d4p-18, INEXACT)
T(RZ, -0x1.1a809d0df8728p+942,   -0x1.ab18ad1d6cccbp-2,  0x1.9539c4p-20, INEXACT)
T(RU, -0x1.1a809d0df8728p+942,   -0x1.ab18ad1d6cccbp-2,  0x1.9539c4p-20, INEXACT)
T(RD, -0x1.1a809d0df8728p+942,   -0x1.ab18ad1d6ccccp-2,  -0x1.ffffcep-1, INEXACT)
T(RZ, -0x1.09ccf1677a69cp+675,    0x1.c5b54ef6007a4p+1,  -0x1.fffee2p-1, INEXACT)
T(RD, -0x1.09ccf1677a69cp+675,    0x1.c5b54ef6007a4p+1,  -0x1.fffee2p-1, INEXACT)
T(RU, -0x1.09ccf1677a69cp+675,    0x1.c5b54ef6007a5p+1,  0x1.1e139cp-17, INEXACT)
T(RZ,  0x1.1f4e63b80925cp+651,    0x1.8f3a81bf348b7p+0, -0x1.f26f46p-18, INEXACT)
T(RD,  0x1.1f4e63b80925cp+651,    0x1.8f3a81bf348b7p+0, -0x1.f26f46p-18, INEXACT)
T(RU,  0x1.1f4e63b80925cp+651,    0x1.8f3a81bf348b8p+0,   0x1.ffff06p-1, INEXACT)
T(RZ,  -0x1.4613f13421ce2p+87,    0x1.11ba809081082p+0,  -0x1.fffe5ep-1, INEXACT)
T(RD,  -0x1.4613f13421ce2p+87,    0x1.11ba809081082p+0,  -0x1.fffe5ep-1, INEXACT)
T(RU,  -0x1.4613f13421ce2p+87,    0x1.11ba809081083p+0,   0x1.a284ap-17, INEXACT)
T(RZ,  0x1.4c478576449ddp+506,    0x1.513e5b36e734cp+1, -0x1.0485c4p-25, INEXACT)
T(RD,  0x1.4c478576449ddp+506,    0x1.513e5b36e734cp+1, -0x1.0485c4p-25, INEXACT)
T(RU,  0x1.4c478576449ddp+506,    0x1.513e5b36e734dp+1,   0x1.fffffep-1, INEXACT)
T(RZ,  0x1.7a8c9b3d56b8bp+623,    -0x1.678f27509144p+0,   0x1.ffffdep-1, INEXACT)
T(RU,  0x1.7a8c9b3d56b8bp+623,    -0x1.678f27509144p+0,   0x1.ffffdep-1, INEXACT)
T(RD,  0x1.7a8c9b3d56b8bp+623,   -0x1.678f275091441p+0,  -0x1.131a2p-20, INEXACT)
T(RN,  0x1.cb383416b2dccp+468,   -0x1.f42cfe630612ap+0,  -0x1.fffe78p-2, INEXACT)
T(RZ,  -0x1.e0dbc10c42387p+51,    0x1.0357b0cf24bb4p+0,  -0x1.fffe0ap-1, INEXACT)
T(RD,  -0x1.e0dbc10c42387p+51,    0x1.0357b0cf24bb4p+0,  -0x1.fffe0ap-1, INEXACT)
T(RU,  -0x1.e0dbc10c42387p+51,    0x1.0357b0cf24bb5p+0,  0x1.f6ddcap-17, INEXACT)
T(RZ,  0x1.baa206370de26p+987,    0x1.829e7634f5207p+1,   -0x1.ffffcp-1, INEXACT)
T(RD,  0x1.baa206370de26p+987,    0x1.829e7634f5207p+1,   -0x1.ffffcp-1, INEXACT)
T(RU,  0x1.baa206370de26p+987,    0x1.829e7634f5208p+1,  0x1.fb8704p-20, INEXACT)
T(RN,   0x1.1a8af6649897p+725,   -0x1.201b33dbdbf8ap+2,  -0x1.fffda8p-2, INEXACT)
T(RZ, -0x1.dc7bcc8391837p+569,     0x1.13dcf1660d38p-3, -0x1.3b68fcp-18, INEXACT)
T(RD, -0x1.dc7bcc8391837p+569,     0x1.13dcf1660d38p-3, -0x1.3b68fcp-18, INEXACT)
T(RU, -0x1.dc7bcc8391837p+569,    0x1.13dcf1660d381p-3,   0x1.ffff62p-1, INEXACT)
T(RN,  0x1.076a8b8e5ea7dp+422,    -0x1.fdbfeed41fbdp+4,   -0x1.ffff5p-2, INEXACT)
T(RN, -0x1.e327e2643f2e6p+954,    0x1.cfdad9806ae9fp+1,  -0x1.fffe06p-2, INEXACT)
T(RN,  0x1.8b51705547821p+309,   -0x1.0dc57f5acd2bfp+0,  -0x1.fffe1cp-2, INEXACT)
T(RZ, -0x1.d2ced4d23b394p+712,   -0x1.bd6a8c77059fep-2,  0x1.067616p-19, INEXACT)
T(RU, -0x1.d2ced4d23b394p+712,   -0x1.bd6a8c77059fep-2,  0x1.067616p-19, INEXACT)
T(RD, -0x1.d2ced4d23b394p+712,   -0x1.bd6a8c77059ffp-2,  -0x1.ffffbep-1, INEXACT)
T(RZ,  0x1.7820f9234f48ap+999,   -0x1.3a3b6b2dcd7adp+0,   0x1.ffff9cp-1, INEXACT)
T(RU,  0x1.7820f9234f48ap+999,   -0x1.3a3b6b2dcd7adp+0,   0x1.ffff9cp-1, INEXACT)
T(RD,  0x1.7820f9234f48ap+999,   -0x1.3a3b6b2dcd7aep+0, -0x1.8defe8p-19, INEXACT)
T(RZ, 0x1.916084745cc84p+1010,    0x1.d48373e3abd8cp-3, -0x1.d7387ep-17, INEXACT)
T(RD, 0x1.916084745cc84p+1010,    0x1.d48373e3abd8cp-3, -0x1.d7387ep-17, INEXACT)
T(RU, 0x1.916084745cc84p+1010,    0x1.d48373e3abd8dp-3,   0x1.fffe28p-1, INEXACT)
T(RN, -0x1.e27589af366f3p+846,   -0x1.e62901aaea6f5p-4,  -0x1.fffed6p-2, INEXACT)
T(RN,  0x1.4942e795c2e51p+717,    0x1.3a1b20a9310d4p+2,  -0x1.fffcd2p-2, INEXACT)
T(RN,  0x1.2c68cd79bce14p+215,   -0x1.996623ae865e8p+3,  -0x1.ffff3cp-2, INEXACT)
T(RZ,  0x1.2631f53fd6e47p+238,   -0x1.e51ba3c9767a7p-4,   0x1.96163p-18, INEXACT)
T(RU,  0x1.2631f53fd6e47p+238,   -0x1.e51ba3c9767a7p-4,   0x1.96163p-18, INEXACT)
T(RD,  0x1.2631f53fd6e47p+238,   -0x1.e51ba3c9767a8p-4,  -0x1.ffff34p-1, INEXACT)
T(RZ,  0x1.e9586f1f638a8p+199,   -0x1.2691e85ca5e7ap+0,  0x1.a3771cp-17, INEXACT)
T(RU,  0x1.e9586f1f638a8p+199,   -0x1.2691e85ca5e7ap+0,  0x1.a3771cp-17, INEXACT)
T(RD,  0x1.e9586f1f638a8p+199,   -0x1.2691e85ca5e7bp+0,  -0x1.fffe5cp-1, INEXACT)
T(RZ,   0x1.8328b63cb5286p+38,    0x1.f5d7efcc2a352p+0,  -0x1.ffff86p-1, INEXACT)
T(RD,   0x1.8328b63cb5286p+38,    0x1.f5d7efcc2a352p+0,  -0x1.ffff86p-1, INEXACT)
T(RU,   0x1.8328b63cb5286p+38,    0x1.f5d7efcc2a353p+0,  0x1.e5344cp-19, INEXACT)
T(RZ, -0x1.62738a736f1a5p+281,    0x1.b63f5f62d8c93p+0,  -0x1.2e725p-18, INEXACT)
T(RD, -0x1.62738a736f1a5p+281,    0x1.b63f5f62d8c93p+0,  -0x1.2e725p-18, INEXACT)
T(RU, -0x1.62738a736f1a5p+281,    0x1.b63f5f62d8c94p+0,   0x1.ffff68p-1, INEXACT)
T(RN, -0x1.24cc9d924efd4p+752,    0x1.46b0831746ccfp+4,  -0x1.ffff4ep-2, INEXACT)
T(RN, -0x1.04ba25ffc91bap+578,    0x1.a76d758eecd67p-2,  -0x1.fffc18p-2, INEXACT)
T(RN,  0x1.367ca8b7fa4d3p+114,   -0x1.2ca7ffe3d3ff3p-4,  -0x1.fffcf4p-2, INEXACT)
T(RN,  0x1.5c499ae2eae0dp+138,    -0x1.b5f8bedd4a7cp-5,  -0x1.fffe6ep-2, INEXACT)
T(RN,  0x1.434f2e7fc0647p+601,   -0x1.3e2330ac1dac8p-2,  -0x1.fffc88p-2, INEXACT)
T(RN,  0x1.a3c98b0ca7c21p+213,   -0x1.655286938f4adp-2,  -0x1.fffd5ap-2, INEXACT)
T(RN, -0x1.cd96348aae1dfp+631,     0x1.285af6eeb73cp+0,  -0x1.fffc3ap-2, INEXACT)
T(RN,  0x1.55646ab31fe58p+584,    0x1.36a1ec9b86d1fp+1,  -0x1.ffff2cp-2, INEXACT)
T(RN,   0x1.076cccd03169p+278,    0x1.a15e177d2ea52p-1,  -0x1.ffffd2p-2, INEXACT)
T(RN, -0x1.3062668f5c073p+965,    0x1.46ba37200bf95p+8,  -0x1.fffd42p-2, INEXACT)
T(RN,  0x1.42ff6437da892p+830,   -0x1.53421fe149ee6p-3,  -0x1.fffc28p-2, INEXACT)
T(RZ,  -0x1.a9b43f27fe8acp+63,   -0x1.00dafc2184ecfp+2,  0x1.0c8c8ap-19, INEXACT)
T(RU,  -0x1.a9b43f27fe8acp+63,   -0x1.00dafc2184ecfp+2,  0x1.0c8c8ap-19, INEXACT)
T(RD,  -0x1.a9b43f27fe8acp+63,    -0x1.00dafc2184edp+2,  -0x1.ffffbcp-1, INEXACT)
T(RZ, -0x1.8a904ad03c9f9p+580,   -0x1.2a439e8314608p+0,  0x1.a047dep-19, INEXACT)
T(RU, -0x1.8a904ad03c9f9p+580,   -0x1.2a439e8314608p+0,  0x1.a047dep-19, INEXACT)
T(RD, -0x1.8a904ad03c9f9p+580,   -0x1.2a439e8314609p+0,  -0x1.ffff98p-1, INEXACT)
T(RZ,  0x1.eec62b36fc448p+761,   -0x1.bb55817b970d9p+0,  0x1.3d70bep-18, INEXACT)
T(RU,  0x1.eec62b36fc448p+761,   -0x1.bb55817b970d9p+0,  0x1.3d70bep-18, INEXACT)
T(RD,  0x1.eec62b36fc448p+761,   -0x1.bb55817b970dap+0,  -0x1.ffff62p-1, INEXACT)
T(RZ,   0x1.7a986f2437341p+87,    0x1.ca9eb2e172895p-2, -0x1.e35866p-19, INEXACT)
T(RD,   0x1.7a986f2437341p+87,    0x1.ca9eb2e172895p-2, -0x1.e35866p-19, INEXACT)
T(RU,   0x1.7a986f2437341p+87,    0x1.ca9eb2e172896p-2,   0x1.ffff88p-1, INEXACT)
T(RN, -0x1.4e7d910916bb4p+893,   -0x1.c180e94644768p+0,  -0x1.fffe1ep-2, INEXACT)
T(RZ, -0x1.96aeff812e36ep+865,    0x1.2f4d2f6953bccp-1, -0x1.47549cp-19, INEXACT)
T(RD, -0x1.96aeff812e36ep+865,    0x1.2f4d2f6953bccp-1, -0x1.47549cp-19, INEXACT)
T(RU, -0x1.96aeff812e36ep+865,    0x1.2f4d2f6953bcdp-1,   0x1.ffffaep-1, INEXACT)
T(RZ, -0x1.74c295e289fd6p+375,    0x1.3ee7634b41ab1p+2,  -0x1.ffff52p-1, INEXACT)
T(RD, -0x1.74c295e289fd6p+375,    0x1.3ee7634b41ab1p+2,  -0x1.ffff52p-1, INEXACT)
T(RU, -0x1.74c295e289fd6p+375,    0x1.3ee7634b41ab2p+2,  0x1.5cb678p-18, INEXACT)
T(RN,  0x1.1d606f09c6d32p+322,    0x1.09aa06cd59005p-3,  -0x1.fffff2p-2, INEXACT)
T(RZ, 0x1.c947816f2764bp+1015,    0x1.c9f5f3716cff7p-1, -0x1.1d39e4p-18, INEXACT)
T(RD, 0x1.c947816f2764bp+1015,    0x1.c9f5f3716cff7p-1, -0x1.1d39e4p-18, INEXACT)
T(RU, 0x1.c947816f2764bp+1015,    0x1.c9f5f3716cff8p-1,   0x1.ffff72p-1, INEXACT)
T(RN,  0x1.64d8cdb9a2ef6p+884,     0x1.a6ed39323b77p+2,  -0x1.ffffdap-2, INEXACT)
T(RZ, -0x1.88ab45fbe74cap+344,    0x1.6386cc14308e7p-3, -0x1.55a56ep-18, INEXACT)
T(RD, -0x1.88ab45fbe74cap+344,    0x1.6386cc14308e7p-3, -0x1.55a56ep-18, INEXACT)
T(RU, -0x1.88ab45fbe74cap+344,    0x1.6386cc14308e8p-3,   0x1.ffff56p-1, INEXACT)
T(RZ, -0x1.ca6de0b54e267p+108,    0x1.1b3715683c282p+4,  -0x1.9cf76p-18, INEXACT)
T(RD, -0x1.ca6de0b54e267p+108,    0x1.1b3715683c282p+4,  -0x1.9cf76p-18, INEXACT)
T(RU, -0x1.ca6de0b54e267p+108,    0x1.1b3715683c283p+4,   0x1.ffff32p-1, INEXACT)
T(RZ,  0x1.0fdac9992c314p+217,   -0x1.1d888edb59949p+0,  0x1.054168p-18, INEXACT)
T(RU,  0x1.0fdac9992c314p+217,   -0x1.1d888edb59949p+0,  0x1.054168p-18, INEXACT)
T(RD,  0x1.0fdac9992c314p+217,   -0x1.1d888edb5994ap+0,  -0x1.ffff7ep-1, INEXACT)
T(RZ,   0x1.4d18c96f45efep+66,    0x1.7e863aed1e3cbp+5, -0x1.39692ap-19, INEXACT)
T(RD,   0x1.4d18c96f45efep+66,    0x1.7e863aed1e3cbp+5, -0x1.39692ap-19, INEXACT)
T(RU,   0x1.4d18c96f45efep+66,    0x1.7e863aed1e3ccp+5,   0x1.ffffb2p-1, INEXACT)
T(RZ,  0x1.adaf0cfa7244fp+580,    0x1.dca978a0f9549p+0,  -0x1.ffff1cp-1, INEXACT)
T(RD,  0x1.adaf0cfa7244fp+580,    0x1.dca978a0f9549p+0,  -0x1.ffff1cp-1, INEXACT)
T(RU,  0x1.adaf0cfa7244fp+580,    0x1.dca978a0f954ap+0,   0x1.c7a69p-18, INEXACT)
T(RZ, -0x1.d17b23bc586a4p+319,   -0x1.c58d533bb7a0bp+0,  0x1.b0a2f8p-18, INEXACT)
T(RU, -0x1.d17b23bc586a4p+319,   -0x1.c58d533bb7a0bp+0,  0x1.b0a2f8p-18, INEXACT)
T(RD, -0x1.d17b23bc586a4p+319,   -0x1.c58d533bb7a0cp+0,  -0x1.ffff28p-1, INEXACT)
T(RZ,   -0x1.94c6c8d914b3dp+3,    -0x1.54516fc02955p-4,   0x1.ffffd4p-1, INEXACT)
T(RU,   -0x1.94c6c8d914b3dp+3,    -0x1.54516fc02955p-4,   0x1.ffffd4p-1, INEXACT)
T(RD,   -0x1.94c6c8d914b3dp+3,   -0x1.54516fc029551p-4, -0x1.58a49ap-20, INEXACT)
T(RZ, -0x1.f9d482853203cp+811,   -0x1.a92525c5993eap+0,  0x1.d1e8ccp-18, INEXACT)
T(RU, -0x1.f9d482853203cp+811,   -0x1.a92525c5993eap+0,  0x1.d1e8ccp-18, INEXACT)
T(RD, -0x1.f9d482853203cp+811,   -0x1.a92525c5993ebp+0,  -0x1.ffff18p-1, INEXACT)
T(RZ,  -0x1.df3970fc172e6p+16,    0x1.3e3e5310412adp+0,  -0x1.ffff8ep-1, INEXACT)
T(RD,  -0x1.df3970fc172e6p+16,    0x1.3e3e5310412adp+0,  -0x1.ffff8ep-1, INEXACT)
T(RU,  -0x1.df3970fc172e6p+16,    0x1.3e3e5310412aep+0,  0x1.c555fep-19, INEXACT)
T(RN,   0x1.b247fd75fa1f7p+96,   -0x1.7a8c9a13e8831p-2,  -0x1.ffff1ep-2, INEXACT)
T(RZ,  0x1.a3ffd33dca305p+814,   -0x1.87df4a133b2b8p-4,   0x1.ffff3cp-1, INEXACT)
T(RU,  0x1.a3ffd33dca305p+814,   -0x1.87df4a133b2b8p-4,   0x1.ffff3cp-1, INEXACT)
T(RD,  0x1.a3ffd33dca305p+814,   -0x1.87df4a133b2b9p-4, -0x1.86741cp-18, INEXACT)
T(RZ, -0x1.adbea4230a8e1p+755,    0x1.8ffa04c553b53p-4,  -0x1.ffff48p-1, INEXACT)
T(RD, -0x1.adbea4230a8e1p+755,    0x1.8ffa04c553b53p-4,  -0x1.ffff48p-1, INEXACT)
T(RU, -0x1.adbea4230a8e1p+755,    0x1.8ffa04c553b54p-4,  0x1.6e54e8p-18, INEXACT)
T(RZ,  0x1.4e7ba0469d1e2p+102,   -0x1.2c900e2f30347p-1,  0x1.5c55acp-18, INEXACT)
T(RU,  0x1.4e7ba0469d1e2p+102,   -0x1.2c900e2f30347p-1,  0x1.5c55acp-18, INEXACT)
T(RD,  0x1.4e7ba0469d1e2p+102,   -0x1.2c900e2f30348p-1,  -0x1.ffff52p-1, INEXACT)
T(RN, -0x1.1deafa1e35bcap+705,   -0x1.687351bf26fd6p-6,  -0x1.ffff7ep-2, INEXACT)
T(RN, -0x1.6d3dd74c9240cp+289,   -0x1.6f6631635e956p-1,  -0x1.fffe9ep-2, INEXACT)
T(RZ, -0x1.ce75fe977acabp+978,   -0x1.929389bcb0727p+1,  0x1.2230bcp-18, INEXACT)
T(RU, -0x1.ce75fe977acabp+978,   -0x1.929389bcb0727p+1,  0x1.2230bcp-18, INEXACT)
T(RD, -0x1.ce75fe977acabp+978,   -0x1.929389bcb0728p+1,  -0x1.ffff6ep-1, INEXACT)
T(RN, -0x1.670ccea7f7b22p+883,    0x1.2c48be6ddf2b5p-1,  -0x1.ffffbap-2, INEXACT)
T(RN,   0x1.169f94b12decp+535,    0x1.fc487b1a06536p-2,  -0x1.ffff94p-2, INEXACT)
T(RN, -0x1.d36502bd1f9b9p+620,    0x1.124081cdadcb9p+1,  -0x1.ffff0ep-2, INEXACT)
T(RN,  0x1.bcb028c7bbea4p+657,    -0x1.a481957871aep+0,  -0x1.ffff26p-2, INEXACT)
T(RN, -0x1.ff23badf0e066p+309,    0x1.829d49d22f423p-3,  -0x1.ffff26p-2, INEXACT)
T(RN,  -0x1.45a6df248e795p+16,   -0x1.15b62aedab5a4p+9,  -0x1.ffff62p-2, INEXACT)
T(RN,  0x1.afe9f09975328p+104,    0x1.7985f7344f46fp+1,  -0x1.ffff7ep-2, INEXACT)
T(RN,  0x1.2665c504140aap+194,    0x1.d0e7c8ec330a7p-2,  -0x1.fffe3cp-2, INEXACT)
T(RN,   -0x1.e587e3301409fp+5,   -0x1.8fa795f0b8697p+0,  -0x1.ffff4ap-2, INEXACT)
T(RN, -0x1.f24cfecbd4fa3p+812,   -0x1.e5cd7b5ebcb8fp-1,   -0x1.fffe8p-2, INEXACT)
T(RN,   0x1.5f6603e20826p+138,     0x1.850b41e37199p+3,  -0x1.ffff9ap-2, INEXACT)
T(RN,-0x1.fb4b4fe210ce9p+1021,   -0x1.d163f7d74f0c3p-2,  -0x1.fffe18p-2, INEXACT)
T(RN, -0x1.1d4327d0e937cp+844,    0x1.30cfff1d992c9p+1,  -0x1.ffff5cp-2, INEXACT)
T(RN, 0x1.1c56c0e89f732p+1011,    0x1.0968e2183a651p-1,  -0x1.ffff24p-2, INEXACT)
T(RN, -0x1.fcc921671d6dep+498,    0x1.4a03d7444910ep-1,  -0x1.fffffcp-2, INEXACT)
T(RZ,  0x1.e775fc56ad8b1p+870,    0x1.2b978527bb159p+0,  -0x1.fffffcp-1, INEXACT)
T(RD,  0x1.e775fc56ad8b1p+870,    0x1.2b978527bb159p+0,  -0x1.fffffcp-1, INEXACT)
T(RU,  0x1.e775fc56ad8b1p+870,    0x1.2b978527bb15ap+0,  0x1.185234p-23, INEXACT)
T(RZ,  0x1.9fde5367813b8p+192,   -0x1.6627fffc6fc29p+1,  0x1.a7ef56p-20, INEXACT)
T(RU,  0x1.9fde5367813b8p+192,   -0x1.6627fffc6fc29p+1,  0x1.a7ef56p-20, INEXACT)
T(RD,  0x1.9fde5367813b8p+192,   -0x1.6627fffc6fc2ap+1,  -0x1.ffffccp-1, INEXACT)
T(RZ,  -0x1.14441a0f9a22ep+26,   -0x1.c92ca78aad81ap-2,   0x1.ffff96p-1, INEXACT)
T(RU,  -0x1.14441a0f9a22ep+26,   -0x1.c92ca78aad81ap-2,   0x1.ffff96p-1, INEXACT)
T(RD,  -0x1.14441a0f9a22ep+26,   -0x1.c92ca78aad81bp-2, -0x1.a6fa88p-19, INEXACT)
T(RZ,  0x1.6e5bbfdaaa841p+434,   -0x1.48961e44d26b9p+0,   0x1.ffffbep-1, INEXACT)
T(RU,  0x1.6e5bbfdaaa841p+434,   -0x1.48961e44d26b9p+0,   0x1.ffffbep-1, INEXACT)
T(RD,  0x1.6e5bbfdaaa841p+434,   -0x1.48961e44d26bap+0, -0x1.0b49a6p-19, INEXACT)
T(RN, -0x1.cf0ec4fa4a9c4p+637,   -0x1.1153ecb8dd601p+0,    -0x1.ffffp-2, INEXACT)
T(RN,  0x1.c5d23061601cbp+374,    0x1.a78e00224cbefp+4,  -0x1.ffffb8p-2, INEXACT)
T(RZ,  0x1.6bbaa6c0eb6fbp+512,   -0x1.ebf88744c89fep-2,  0x1.72a4c8p-19, INEXACT)
T(RU,  0x1.6bbaa6c0eb6fbp+512,   -0x1.ebf88744c89fep-2,  0x1.72a4c8p-19, INEXACT)
T(RD,  0x1.6bbaa6c0eb6fbp+512,   -0x1.ebf88744c89ffp-2,  -0x1.ffffa4p-1, INEXACT)
T(RZ, -0x1.7250df801b1bcp+964,    0x1.247c29ca1ac1cp+4, -0x1.6ad3a8p-19, INEXACT)
T(RD, -0x1.7250df801b1bcp+964,    0x1.247c29ca1ac1cp+4, -0x1.6ad3a8p-19, INEXACT)
T(RU, -0x1.7250df801b1bcp+964,    0x1.247c29ca1ac1dp+4,   0x1.ffffa6p-1, INEXACT)
T(RZ, -0x1.e675e4a31416fp+964,   -0x1.55d7206c35c39p+0,   0x1.fffff2p-1, INEXACT)
T(RU, -0x1.e675e4a31416fp+964,   -0x1.55d7206c35c39p+0,   0x1.fffff2p-1, INEXACT)
T(RD, -0x1.e675e4a31416fp+964,   -0x1.55d7206c35c3ap+0, -0x1.d66d34p-22, INEXACT)
T(RZ,  0x1.d86bf85a6b23dp+606,    0x1.8ecabb7a659b3p+1,  -0x1.ffff8cp-1, INEXACT)
T(RD,  0x1.d86bf85a6b23dp+606,    0x1.8ecabb7a659b3p+1,  -0x1.ffff8cp-1, INEXACT)
T(RU,  0x1.d86bf85a6b23dp+606,    0x1.8ecabb7a659b4p+1,  0x1.cf676cp-19, INEXACT)
T(RN,   0x1.76d9a36b6174p+797,    0x1.f9fb847007c07p-2,  -0x1.ffff32p-2, INEXACT)
T(RN,  0x1.0b13731811246p+352,   -0x1.9cd2e253601e5p-2,  -0x1.fffffep-2, INEXACT)
T(RZ, -0x1.869da1fce62fdp+984,    -0x1.3772e8a73b39p-5,   0x1.ffff98p-1, INEXACT)
T(RU, -0x1.869da1fce62fdp+984,    -0x1.3772e8a73b39p-5,   0x1.ffff98p-1, INEXACT)
T(RD, -0x1.869da1fce62fdp+984,   -0x1.3772e8a73b391p-5, -0x1.9f5794p-19, INEXACT)
T(RZ,   0x1.dfc2d32a1e733p+86,    0x1.e4590f403cf75p-3, -0x1.bb131ap-19, INEXACT)
T(RD,   0x1.dfc2d32a1e733p+86,    0x1.e4590f403cf75p-3, -0x1.bb131ap-19, INEXACT)
T(RU,   0x1.dfc2d32a1e733p+86,    0x1.e4590f403cf76p-3,   0x1.ffff92p-1, INEXACT)
T(RZ,  0x1.84fb2768378c2p+270,    0x1.51efeeeed52b9p-1,  -0x1.9e2b3p-25, INEXACT)
T(RD,  0x1.84fb2768378c2p+270,    0x1.51efeeeed52b9p-1,  -0x1.9e2b3p-25, INEXACT)
T(RU,  0x1.84fb2768378c2p+270,    0x1.51efeeeed52bap-1,   0x1.fffffep-1, INEXACT)
T(RZ,   0x1.6fd96655f7e11p+63,   -0x1.64b8679233a2ap-3,  0x1.fbdfb2p-21, INEXACT)
T(RU,   0x1.6fd96655f7e11p+63,   -0x1.64b8679233a2ap-3,  0x1.fbdfb2p-21, INEXACT)
T(RD,   0x1.6fd96655f7e11p+63,   -0x1.64b8679233a2bp-3,   -0x1.ffffep-1, INEXACT)
T(RZ,  0x1.de546ea2c05e3p+251,   -0x1.646b945e590fcp-1,   0x1.ffffb2p-1, INEXACT)
T(RU,  0x1.de546ea2c05e3p+251,   -0x1.646b945e590fcp-1,   0x1.ffffb2p-1, INEXACT)
T(RD,  0x1.de546ea2c05e3p+251,   -0x1.646b945e590fdp-1, -0x1.39b156p-19, INEXACT)
T(RZ,   0x1.305d94bfd3251p+48,    -0x1.94562eed63b4p+0,   0x1.ffffa6p-1, INEXACT)
T(RU,   0x1.305d94bfd3251p+48,    -0x1.94562eed63b4p+0,   0x1.ffffa6p-1, INEXACT)
T(RD,   0x1.305d94bfd3251p+48,   -0x1.94562eed63b41p+0, -0x1.6b7cd6p-19, INEXACT)
T(RZ,  -0x1.6dca60bb26df7p+98,   -0x1.3c7d74ad3e624p-2,   0x1.ffffcep-1, INEXACT)
T(RU,  -0x1.6dca60bb26df7p+98,   -0x1.3c7d74ad3e624p-2,   0x1.ffffcep-1, INEXACT)
T(RD,  -0x1.6dca60bb26df7p+98,   -0x1.3c7d74ad3e625p-2,  -0x1.885d3p-20, INEXACT)
T(RZ, -0x1.8a0660ebad634p+999,   -0x1.60307bb2f0267p+1,   0x1.fffffap-1, INEXACT)
T(RU, -0x1.8a0660ebad634p+999,   -0x1.60307bb2f0267p+1,   0x1.fffffap-1, INEXACT)
T(RD, -0x1.8a0660ebad634p+999,   -0x1.60307bb2f0268p+1, -0x1.a79cd8p-23, INEXACT)
T(RN,   0x1.9eb58a5913566p+26,    0x1.e7807d2c8f5e6p-3,  -0x1.ffff9ep-2, INEXACT)
T(RN, -0x1.fdb20f2b18d29p+995,    0x1.e01653505ad93p-1,  -0x1.ffffe8p-2, INEXACT)
T(RN, -0x1.42244e141fc57p+727,    0x1.668da4f9915d9p+2,  -0x1.ffff28p-2, INEXACT)
T(RZ, -0x1.9872de1b829a9p+221,   -0x1.7f7721695bc23p+0,  0x1.b2583ep-19, INEXACT)
T(RU, -0x1.9872de1b829a9p+221,   -0x1.7f7721695bc23p+0,  0x1.b2583ep-19, INEXACT)
T(RD, -0x1.9872de1b829a9p+221,   -0x1.7f7721695bc24p+0,  -0x1.ffff94p-1, INEXACT)
T(RZ,  -0x1.77db1dbb98635p+41,   -0x1.37ad1c7365bd5p-1,   0x1.ffffbap-1, INEXACT)
T(RU,  -0x1.77db1dbb98635p+41,   -0x1.37ad1c7365bd5p-1,   0x1.ffffbap-1, INEXACT)
T(RD,  -0x1.77db1dbb98635p+41,   -0x1.37ad1c7365bd6p-1, -0x1.15d43ap-19, INEXACT)
T(RZ,  0x1.4a2ae1206a2fep+564,   -0x1.cb76370a28b1fp+4,    0x1.ffff8p-1, INEXACT)
T(RU,  0x1.4a2ae1206a2fep+564,   -0x1.cb76370a28b1fp+4,    0x1.ffff8p-1, INEXACT)
T(RD,  0x1.4a2ae1206a2fep+564,    -0x1.cb76370a28b2p+4, -0x1.fe0854p-19, INEXACT)
T(RZ, -0x1.666dc87294294p+923,    0x1.a9a091e96a4b8p-2,  -0x1.ffffc6p-1, INEXACT)
T(RD, -0x1.666dc87294294p+923,    0x1.a9a091e96a4b8p-2,  -0x1.ffffc6p-1, INEXACT)
T(RU, -0x1.666dc87294294p+923,    0x1.a9a091e96a4b9p-2,  0x1.c9e338p-20, INEXACT)
T(RN,  0x1.840ffe5807ee6p+299,   -0x1.c73f4b876a126p+0,   -0x1.ffff7p-2, INEXACT)
T(RN,  0x1.eb69ba3b17b8cp+826,   -0x1.6c89ab24001f3p-1,         -0x1p-1, INEXACT)
T(RN,  0x1.fe957fa3744f8p+820,   -0x1.8555665e88c27p+0,  -0x1.ffff08p-2, INEXACT)
T(RN,  0x1.f1d6aaa1e6c24p+853,     0x1.3a0033d898bbp+3,  -0x1.ffff38p-2, INEXACT)
T(RN, -0x1.7cc97e98f1bbfp+604,   -0x1.fb420abe3739ep-2,   -0x1.ffffbp-2, INEXACT)
T(RN,  0x1.26772cefcdad9p+162,   -0x1.366ccd075109bp+1,  -0x1.ffff34p-2, INEXACT)
T(RN, -0x1.4acf107ababb6p+203,      0x1.368a68bc62cp-2,  -0x1.ffffcep-2, INEXACT)
T(RN, -0x1.3bfc28e5278d8p+639,    0x1.7c81f2f65d159p-1,   -0x1.fffffp-2, INEXACT)
T(RN, -0x1.ba0cbe4f2b091p+515,   -0x1.39ce231ab2d87p+0,  -0x1.ffffccp-2, INEXACT)
T(RN,  0x1.26462241c50b4p+462,    0x1.ea1bbb1f15703p+0,  -0x1.ffff68p-2, INEXACT)
T(RN,  0x1.13f19566bc2c6p+304,    0x1.10b71630444cdp+1,  -0x1.ffffa4p-2, INEXACT)
T(RN, -0x1.2b102cb51c9a3p+883,    0x1.badf22d8b6509p-1,  -0x1.ffff16p-2, INEXACT)
T(RN, -0x1.7537793be2877p+333,   -0x1.f8d8ab0a0fa96p-4,  -0x1.ffffc8p-2, INEXACT)
T(RN, -0x1.e147b0955cf21p+545,    0x1.c0119c8f3b9aap+1,  -0x1.ffffeap-2, INEXACT)
T(RZ,  0x1.65794c7600b2dp+907,   -0x1.76bf8e55ce84dp-3,  0x1.55e2d4p-20, INEXACT)
T(RU,  0x1.65794c7600b2dp+907,   -0x1.76bf8e55ce84dp-3,  0x1.55e2d4p-20, INEXACT)
T(RD,  0x1.65794c7600b2dp+907,   -0x1.76bf8e55ce84ep-3,  -0x1.ffffd6p-1, INEXACT)
T(RN, -0x1.5055a640d5fa5p+184,   -0x1.c38b3a69ac965p-1,  -0x1.ffffd8p-2, INEXACT)
T(RZ,  0x1.2665ecbec0a12p+308,    0x1.ff81b045ee667p-2,  -0x1.ffffcap-1, INEXACT)
T(RD,  0x1.2665ecbec0a12p+308,    0x1.ff81b045ee667p-2,  -0x1.ffffcap-1, INEXACT)
T(RU,  0x1.2665ecbec0a12p+308,    0x1.ff81b045ee668p-2,  0x1.b0bb66p-20, INEXACT)
T(RZ,  -0x1.4c34500fff16p+926,   -0x1.fb20a9036d792p-1,  0x1.8a151ep-22, INEXACT)
T(RU,  -0x1.4c34500fff16p+926,   -0x1.fb20a9036d792p-1,  0x1.8a151ep-22, INEXACT)
T(RD,  -0x1.4c34500fff16p+926,   -0x1.fb20a9036d793p-1,  -0x1.fffff4p-1, INEXACT)
T(RZ, -0x1.84eea5e8238f2p+674,   -0x1.5057d5f87f739p-5,  0x1.551f7ep-21, INEXACT)
T(RU, -0x1.84eea5e8238f2p+674,   -0x1.5057d5f87f739p-5,  0x1.551f7ep-21, INEXACT)
T(RD, -0x1.84eea5e8238f2p+674,   -0x1.5057d5f87f73ap-5,  -0x1.ffffeap-1, INEXACT)
T(RN,  0x1.ec0a666937607p+513,   -0x1.b048f52c1d5fbp-1,  -0x1.ffff94p-2, INEXACT)
T(RZ, -0x1.5c8b1b491f7c6p+770,    0x1.14b978ec52f78p-2, -0x1.e74d78p-21, INEXACT)
T(RD, -0x1.5c8b1b491f7c6p+770,    0x1.14b978ec52f78p-2, -0x1.e74d78p-21, INEXACT)
T(RU, -0x1.5c8b1b491f7c6p+770,    0x1.14b978ec52f79p-2,   0x1.ffffe2p-1, INEXACT)
T(RN,  -0x1.6a77ea82be1ep+135,   -0x1.038e772a1ccf7p+0,  -0x1.ffff8cp-2, INEXACT)
T(RZ,  -0x1.354a204d70f66p+22,    0x1.ea3fef25f4b34p+2, -0x1.02faf6p-20, INEXACT)
T(RD,  -0x1.354a204d70f66p+22,    0x1.ea3fef25f4b34p+2, -0x1.02faf6p-20, INEXACT)
T(RU,  -0x1.354a204d70f66p+22,    0x1.ea3fef25f4b35p+2,    0x1.ffffep-1, INEXACT)
T(RZ,    0x1.99fc268aa1543p+8,   -0x1.18d2afbac399ap+7,   0x1.ffffe8p-1, INEXACT)
T(RU,    0x1.99fc268aa1543p+8,   -0x1.18d2afbac399ap+7,   0x1.ffffe8p-1, INEXACT)
T(RD,    0x1.99fc268aa1543p+8,   -0x1.18d2afbac399bp+7, -0x1.8ad3c4p-21, INEXACT)
T(RZ, -0x1.e0ec77c550047p+714,   -0x1.b14f3646ec9a8p+3,   0x1.fffff2p-1, INEXACT)
T(RU, -0x1.e0ec77c550047p+714,   -0x1.b14f3646ec9a8p+3,   0x1.fffff2p-1, INEXACT)
T(RD, -0x1.e0ec77c550047p+714,   -0x1.b14f3646ec9a9p+3,  -0x1.a310bp-22, INEXACT)
T(RN,  0x1.ab1ba2d98f7c7p+417,   -0x1.018a23fb9c82bp+1,  -0x1.ffffe8p-2, INEXACT)
T(RZ, -0x1.8486c9865ee8cp+527,   -0x1.07359fe0df9ffp-1,    0x1.ffffdp-1, INEXACT)
T(RU, -0x1.8486c9865ee8cp+527,   -0x1.07359fe0df9ffp-1,    0x1.ffffdp-1, INEXACT)
T(RD, -0x1.8486c9865ee8cp+527,     -0x1.07359fe0dfap-1, -0x1.7e73e8p-20, INEXACT)
T(RZ, -0x1.9b1e2b4f7b9c8p+439,    0x1.5334be02362b5p-1,  -0x1.fffff8p-1, INEXACT)
T(RD, -0x1.9b1e2b4f7b9c8p+439,    0x1.5334be02362b5p-1,  -0x1.fffff8p-1, INEXACT)
T(RU, -0x1.9b1e2b4f7b9c8p+439,    0x1.5334be02362b6p-1,  0x1.e286dap-23, INEXACT)
T(RN,  0x1.5b9b61dbafc2bp+570,    0x1.168164cece818p+3,  -0x1.ffffecp-2, INEXACT)
T(RN,  0x1.97153bac82499p+991,   -0x1.e7d3e854a3a99p-4,  -0x1.ffff94p-2, INEXACT)
T(RZ, -0x1.f2b5b35a0e471p+429,   -0x1.2f1d26cddb53fp+6,  0x1.230866p-20, INEXACT)
T(RU, -0x1.f2b5b35a0e471p+429,   -0x1.2f1d26cddb53fp+6,  0x1.230866p-20, INEXACT)
T(RD, -0x1.f2b5b35a0e471p+429,    -0x1.2f1d26cddb54p+6,  -0x1.ffffdcp-1, INEXACT)
T(RZ, -0x1.275af3e7f95d2p+588,   -0x1.e62622d424f17p+1,   0x1.95bf6p-20, INEXACT)
T(RU, -0x1.275af3e7f95d2p+588,   -0x1.e62622d424f17p+1,   0x1.95bf6p-20, INEXACT)
T(RD, -0x1.275af3e7f95d2p+588,   -0x1.e62622d424f18p+1,  -0x1.ffffcep-1, INEXACT)
T(RZ, -0x1.fbd1e6fabbdcbp+848,   -0x1.df0fb10ed025ap+0,   0x1.ffffc6p-1, INEXACT)
T(RU, -0x1.fbd1e6fabbdcbp+848,   -0x1.df0fb10ed025ap+0,   0x1.ffffc6p-1, INEXACT)
T(RD, -0x1.fbd1e6fabbdcbp+848,   -0x1.df0fb10ed025bp+0,  -0x1.d7113p-20, INEXACT)
T(RZ, -0x1.2557b3003e42bp+192,   -0x1.b1e7edb05d05ep-2,  0x1.cc2cf6p-20, INEXACT)
T(RU, -0x1.2557b3003e42bp+192,   -0x1.b1e7edb05d05ep-2,  0x1.cc2cf6p-20, INEXACT)
T(RD, -0x1.2557b3003e42bp+192,   -0x1.b1e7edb05d05fp-2,  -0x1.ffffc6p-1, INEXACT)
T(RZ,  0x1.6048d8c4e8322p+395,    0x1.388801375e459p-2,  -0x1.ffffdep-1, INEXACT)
T(RD,  0x1.6048d8c4e8322p+395,    0x1.388801375e459p-2,  -0x1.ffffdep-1, INEXACT)
T(RU,  0x1.6048d8c4e8322p+395,    0x1.388801375e45ap-2,  0x1.123122p-20, INEXACT)
T(RN, -0x1.925d44a9efb6dp+397,    0x1.4a67ea6223f33p+4,  -0x1.ffffeap-2, INEXACT)
T(RN, -0x1.cd9358e9a17e1p+117,   -0x1.2eb0562578ab8p+0,  -0x1.ffffe2p-2, INEXACT)
T(RZ, -0x1.157108054b039p+718,   -0x1.92c9fe14ab5aep+0,   0x1.fffffep-1, INEXACT)
T(RU, -0x1.157108054b039p+718,   -0x1.92c9fe14ab5aep+0,   0x1.fffffep-1, INEXACT)
T(RD, -0x1.157108054b039p+718,   -0x1.92c9fe14ab5afp+0, -0x1.bd608ap-25, INEXACT)
T(RN,  0x1.7fec647225677p+714,   -0x1.2f7e48965ea3bp-4,  -0x1.ffffaep-2, INEXACT)
T(RZ,  0x1.d01628edecf48p+621,    0x1.0157adda2c1aep-1,  -0x1.fffff8p-1, INEXACT)
T(RD,  0x1.d01628edecf48p+621,    0x1.0157adda2c1aep-1,  -0x1.fffff8p-1, INEXACT)
T(RU,  0x1.d01628edecf48p+621,    0x1.0157adda2c1afp-1,  0x1.e3729cp-23, INEXACT)
T(RN,   0x1.ee5803467a12p+173,   -0x1.0a5f923f037e1p+2,  -0x1.ffffc2p-2, INEXACT)
T(RZ,  0x1.717b5fa6b26d8p+214,    0x1.6e42fccfa54a2p+1, -0x1.824152p-20, INEXACT)
T(RD,  0x1.717b5fa6b26d8p+214,    0x1.6e42fccfa54a2p+1, -0x1.824152p-20, INEXACT)
T(RU,  0x1.717b5fa6b26d8p+214,    0x1.6e42fccfa54a3p+1,    0x1.ffffdp-1, INEXACT)
T(RZ,  -0x1.8f9eba8342a47p+59,   -0x1.5bb6cc41bbdc6p+1,   0x1.ffffe4p-1, INEXACT)
T(RU,  -0x1.8f9eba8342a47p+59,   -0x1.5bb6cc41bbdc6p+1,   0x1.ffffe4p-1, INEXACT)
T(RD,  -0x1.8f9eba8342a47p+59,   -0x1.5bb6cc41bbdc7p+1, -0x1.bcd354p-21, INEXACT)
T(RN, -0x1.3274d06619d1bp+322,   -0x1.d6fae0fbfa339p+1,  -0x1.ffffb6p-2, INEXACT)
T(RZ, -0x1.b30456dcb4b64p+953,   -0x1.01d7edb61b183p-1,   0x1.ffffe8p-1, INEXACT)
T(RU, -0x1.b30456dcb4b64p+953,   -0x1.01d7edb61b183p-1,   0x1.ffffe8p-1, INEXACT)
T(RD, -0x1.b30456dcb4b64p+953,   -0x1.01d7edb61b184p-1, -0x1.7676c2p-21, INEXACT)
T(RN,  0x1.4a8fad1f2aecbp+773,   -0x1.5dba6cd678895p+3,  -0x1.ffff98p-2, INEXACT)
T(RN,  -0x1.3ec8301c64f36p+37,    0x1.43b2627a43e1bp-4,         -0x1p-1, INEXACT)
T(RN,  0x1.e8fcc2b14d5bfp+145,    0x1.078d019ac7beap+0,  -0x1.ffff92p-2, INEXACT)
T(RN,   0x1.d3d8f810c3593p+92,    0x1.3fed53c6cac1ap-2,  -0x1.ffffbap-2, INEXACT)
T(RN, -0x1.5df6208600633p+762,    0x1.73eda223d19c7p-5,  -0x1.ffffc8p-2, INEXACT)
T(RN,  -0x1.ca7458e53d16ap+56,   -0x1.bb80242c0bfe9p+2,  -0x1.ffffb6p-2, INEXACT)
T(RN,  0x1.2ec721d1a2d9cp+487,   -0x1.38c7d8d0da74bp+0,  -0x1.fffff8p-2, INEXACT)
T(RZ,  0x1.428f878e08725p+579,    0x1.5025488c9d804p-3,  -0x1.ffffe6p-1, INEXACT)
T(RD,  0x1.428f878e08725p+579,    0x1.5025488c9d804p-3,  -0x1.ffffe6p-1, INEXACT)
T(RU,  0x1.428f878e08725p+579,    0x1.5025488c9d805p-3,  0x1.afe5aap-21, INEXACT)
T(RZ, -0x1.8237149cc8fbap+919,    0x1.51d5105cd652fp+3, -0x1.c4fefep-21, INEXACT)
T(RD, -0x1.8237149cc8fbap+919,    0x1.51d5105cd652fp+3, -0x1.c4fefep-21, INEXACT)
T(RU, -0x1.8237149cc8fbap+919,     0x1.51d5105cd653p+3,   0x1.ffffe4p-1, INEXACT)
T(RZ,   0x1.50d9b3e7861b7p+82,   -0x1.d9b597b219152p-4,   0x1.ffffe4p-1, INEXACT)
T(RU,   0x1.50d9b3e7861b7p+82,   -0x1.d9b597b219152p-4,   0x1.ffffe4p-1, INEXACT)
T(RD,   0x1.50d9b3e7861b7p+82,   -0x1.d9b597b219153p-4, -0x1.b6905ep-21, INEXACT)
T(RZ, -0x1.8574f3fc2461cp+219,   -0x1.c843820cca96ep-2,  0x1.117a58p-24, INEXACT)
T(RU, -0x1.8574f3fc2461cp+219,   -0x1.c843820cca96ep-2,  0x1.117a58p-24, INEXACT)
T(RD, -0x1.8574f3fc2461cp+219,   -0x1.c843820cca96fp-2,  -0x1.fffffep-1, INEXACT)
T(RN,  0x1.28c17ee763c82p+255,   -0x1.a2af527665e6cp+0,  -0x1.ffffc6p-2, INEXACT)
T(RN,  0x1.4acb2b1fe9ec9p+716,     0x1.7603d310e82dp-7,  -0x1.ffffeap-2, INEXACT)
T(RN, -0x1.b2bc25edac372p+778,    0x1.98f0f48e232dcp-5,  -0x1.ffffe4p-2, INEXACT)
T(RZ, -0x1.fa1bb12ad7958p+141,   -0x1.3c0a5edef2e65p-1,    0x1.fffffp-1, INEXACT)
T(RU, -0x1.fa1bb12ad7958p+141,   -0x1.3c0a5edef2e65p-1,    0x1.fffffp-1, INEXACT)
T(RD, -0x1.fa1bb12ad7958p+141,   -0x1.3c0a5edef2e66p-1,  -0x1.fc961p-22, INEXACT)
T(RN,  0x1.db6b17fb12cebp+647,    0x1.816f61419fdc8p+0,  -0x1.ffffe4p-2, INEXACT)
T(RZ, -0x1.49f638422d5fbp+617,    0x1.371c645b8d053p+1, -0x1.d97156p-22, INEXACT)
T(RD, -0x1.49f638422d5fbp+617,    0x1.371c645b8d053p+1, -0x1.d97156p-22, INEXACT)
T(RU, -0x1.49f638422d5fbp+617,    0x1.371c645b8d054p+1,   0x1.fffff2p-1, INEXACT)
T(RN, -0x1.05253fe5ac47ep+836,    0x1.76b225cd27a59p-1,   -0x1.ffffep-2, INEXACT)
T(RZ,  0x1.1ec715986c62dp+555,    0x1.14353b832ce4fp-1,  -0x1.ffffe6p-1, INEXACT)
T(RD,  0x1.1ec715986c62dp+555,    0x1.14353b832ce4fp-1,  -0x1.ffffe6p-1, INEXACT)
T(RU,  0x1.1ec715986c62dp+555,     0x1.14353b832ce5p-1,  0x1.9d2ac6p-21, INEXACT)
T(RZ, -0x1.220c41bf1369cp+651,   -0x1.d4a6517b923a9p+0,   0x1.ffffeep-1, INEXACT)
T(RU, -0x1.220c41bf1369cp+651,   -0x1.d4a6517b923a9p+0,   0x1.ffffeep-1, INEXACT)
T(RD, -0x1.220c41bf1369cp+651,   -0x1.d4a6517b923aap+0, -0x1.229b78p-21, INEXACT)
T(RN, -0x1.7fa1fbb31a862p+373,   -0x1.e5442fc5747f6p+0,  -0x1.ffffe8p-2, INEXACT)
T(RN,   0x1.4b47cab28c15ap+97,    0x1.63b878ac5d871p+2,  -0x1.ffffdcp-2, INEXACT)
T(RZ,  0x1.1a218445a55c6p+581,    0x1.6d0b839bc9482p+0,  -0x1.fffffap-1, INEXACT)
T(RD,  0x1.1a218445a55c6p+581,    0x1.6d0b839bc9482p+0,  -0x1.fffffap-1, INEXACT)
T(RU,  0x1.1a218445a55c6p+581,    0x1.6d0b839bc9483p+0,   0x1.69b3ep-23, INEXACT)
T(RN, -0x1.b931c204466f7p+903,   -0x1.2e998b1667bcep-2,   -0x1.ffffep-2, INEXACT)
T(RN,  0x1.5f7e07c976e42p+901,    0x1.6e7bd4464e08bp+1,  -0x1.ffffd6p-2, INEXACT)
T(RZ, -0x1.99b497fa87944p+491,   -0x1.b36642c307466p+0,  0x1.7fbcdcp-23, INEXACT)
T(RU, -0x1.99b497fa87944p+491,   -0x1.b36642c307466p+0,  0x1.7fbcdcp-23, INEXACT)
T(RD, -0x1.99b497fa87944p+491,   -0x1.b36642c307467p+0,  -0x1.fffffap-1, INEXACT)
T(RZ, -0x1.b17c65e6ab909p+292,   -0x1.9da6104177e87p-2,  0x1.970f6ap-24, INEXACT)
T(RU, -0x1.b17c65e6ab909p+292,   -0x1.9da6104177e87p-2,  0x1.970f6ap-24, INEXACT)
T(RD, -0x1.b17c65e6ab909p+292,   -0x1.9da6104177e88p-2,  -0x1.fffffcp-1, INEXACT)
T(RZ, -0x1.497cb8746b5aap+643,   -0x1.2fc1784e3b6d3p-3,   0x1.ffffe8p-1, INEXACT)
T(RU, -0x1.497cb8746b5aap+643,   -0x1.2fc1784e3b6d3p-3,   0x1.ffffe8p-1, INEXACT)
T(RD, -0x1.497cb8746b5aap+643,   -0x1.2fc1784e3b6d4p-3, -0x1.806744p-21, INEXACT)
T(RZ, -0x1.744f061700ed4p+328,    0x1.0bed5bdb7ab89p-1,  -0x1.fffffep-1, INEXACT)
T(RD, -0x1.744f061700ed4p+328,    0x1.0bed5bdb7ab89p-1,  -0x1.fffffep-1, INEXACT)
T(RU, -0x1.744f061700ed4p+328,    0x1.0bed5bdb7ab8ap-1,  0x1.2efee8p-24, INEXACT)
T(RZ,  0x1.b6b3f52c2ab42p+195,   -0x1.9907b1a7ec489p-1,  0x1.632eacp-27, INEXACT)
T(RU,  0x1.b6b3f52c2ab42p+195,   -0x1.9907b1a7ec489p-1,  0x1.632eacp-27, INEXACT)
T(RD,  0x1.b6b3f52c2ab42p+195,   -0x1.9907b1a7ec48ap-1,         -0x1p+0, INEXACT)
T(RZ, -0x1.b6c506330c629p+809,    0x1.f07109b41f721p-3, -0x1.38b08cp-21, INEXACT)
T(RD, -0x1.b6c506330c629p+809,    0x1.f07109b41f721p-3, -0x1.38b08cp-21, INEXACT)
T(RU, -0x1.b6c506330c629p+809,    0x1.f07109b41f722p-3,   0x1.ffffecp-1, INEXACT)
T(RN,  0x1.62f5547d703f7p+164,   -0x1.5b7d18f55683dp-2,  -0x1.ffffc4p-2, INEXACT)
T(RN,  0x1.d18d46c1e7e35p+291,   -0x1.dd53213f15bc8p-1,  -0x1.ffffd8p-2, INEXACT)
T(RN,  0x1.4f62db67f8d31p+710,    0x1.02f87b403230bp-3,  -0x1.ffffc4p-2, INEXACT)
T(RN, -0x1.b4336af0a44cep+790,   -0x1.6d12b595ed694p-1,  -0x1.ffffd4p-2, INEXACT)
T(RZ,  0x1.77d63214af5e2p+681,    0x1.124ad0acb7ed9p-1,  -0x1.ffffe8p-1, INEXACT)
T(RD,  0x1.77d63214af5e2p+681,    0x1.124ad0acb7ed9p-1,  -0x1.ffffe8p-1, INEXACT)
T(RU,  0x1.77d63214af5e2p+681,    0x1.124ad0acb7edap-1,   0x1.78c4fp-21, INEXACT)
T(RZ,  -0x1.06c32f6d87067p+70,   -0x1.b6ff3caf15befp+1,  0x1.e833e4p-24, INEXACT)
T(RU,  -0x1.06c32f6d87067p+70,   -0x1.b6ff3caf15befp+1,  0x1.e833e4p-24, INEXACT)
T(RD,  -0x1.06c32f6d87067p+70,    -0x1.b6ff3caf15bfp+1,  -0x1.fffffcp-1, INEXACT)
T(RZ,   0x1.779afe9162e3p+814,    0x1.3f13dc8c7d971p+3,  -0x1.fffffap-1, INEXACT)
T(RD,   0x1.779afe9162e3p+814,    0x1.3f13dc8c7d971p+3,  -0x1.fffffap-1, INEXACT)
T(RU,   0x1.779afe9162e3p+814,    0x1.3f13dc8c7d972p+3,   0x1.84f65p-23, INEXACT)
T(RZ,  0x1.6e9f85a63379ap+865,    0x1.c58d22dc396fep+1,   -0x1.ffffep-1, INEXACT)
T(RD,  0x1.6e9f85a63379ap+865,    0x1.c58d22dc396fep+1,   -0x1.ffffep-1, INEXACT)
T(RU,  0x1.6e9f85a63379ap+865,    0x1.c58d22dc396ffp+1,  0x1.f7b354p-21, INEXACT)
T(RZ,  0x1.e67730e9a8486p+720,   -0x1.f86a69b14d7d1p-3,  0x1.bf7faep-23, INEXACT)
T(RU,  0x1.e67730e9a8486p+720,   -0x1.f86a69b14d7d1p-3,  0x1.bf7faep-23, INEXACT)
T(RD,  0x1.e67730e9a8486p+720,   -0x1.f86a69b14d7d2p-3,  -0x1.fffffap-1, INEXACT)
T(RN,  0x1.a492c79d4a756p+533,   -0x1.00eced7a4d3ccp+2,  -0x1.ffffd2p-2, INEXACT)
T(RN,  0x1.c0008fa7dbe71p+465,    0x1.84a34ba0d3419p+1,  -0x1.ffffccp-2, INEXACT)
T(RN,  -0x1.2169acc644f79p+69,   -0x1.6ecc13b3447fbp-3,  -0x1.ffffcap-2, INEXACT)
T(RN,  0x1.24733f66695dcp+810,   -0x1.39fcc86ce93ddp+1,  -0x1.ffffd6p-2, INEXACT)
T(RN, -0x1.72dd429d92511p+245,    0x1.f19274a27ca1ep-2,  -0x1.fffff4p-2, INEXACT)
T(RN,  0x1.99e96b043ac3dp+472,   -0x1.2ed478b7347b2p+0,  -0x1.ffffe4p-2, INEXACT)
T(RN, -0x1.8eddad0f391e9p+538,   -0x1.789b0cc9b681ap-2,  -0x1.ffffd6p-2, INEXACT)
T(RN,  0x1.5ca2aa80c243ap+820,   -0x1.3fda798a3aeb8p+4,  -0x1.fffffep-2, INEXACT)
T(RZ, -0x1.780d08bde7c41p+230,    0x1.ac70898811b45p+4, -0x1.f35f88p-22, INEXACT)
T(RD, -0x1.780d08bde7c41p+230,    0x1.ac70898811b45p+4, -0x1.f35f88p-22, INEXACT)
T(RU, -0x1.780d08bde7c41p+230,    0x1.ac70898811b46p+4,    0x1.fffffp-1, INEXACT)
T(RZ, -0x1.40f14758de618p+658,    0x1.44f40daa0adfcp+3,  -0x1.fffffcp-1, INEXACT)
T(RD, -0x1.40f14758de618p+658,    0x1.44f40daa0adfcp+3,  -0x1.fffffcp-1, INEXACT)
T(RU, -0x1.40f14758de618p+658,    0x1.44f40daa0adfdp+3,  0x1.a27934p-24, INEXACT)
T(RN,  0x1.1b16c173e582ap+401,     0x1.cb21563a7ab6p-2,  -0x1.ffffe6p-2, INEXACT)
T(RN,  0x1.f684c67e2d7a9p+175,   -0x1.c923e77575253p-1,  -0x1.ffffe2p-2, INEXACT)
T(RZ,  0x1.756aafdb04562p+641,   -0x1.185d126c09d63p+0,  0x1.d97cd6p-26, INEXACT)
T(RU,  0x1.756aafdb04562p+641,   -0x1.185d126c09d63p+0,  0x1.d97cd6p-26, INEXACT)
T(RD,  0x1.756aafdb04562p+641,   -0x1.185d126c09d64p+0,         -0x1p+0, INEXACT)
T(RZ, -0x1.40c901ac42e7fp+829,    0x1.b8449307430cbp-1,  -0x1.d2aecp-22, INEXACT)
T(RD, -0x1.40c901ac42e7fp+829,    0x1.b8449307430cbp-1,  -0x1.d2aecp-22, INEXACT)
T(RU, -0x1.40c901ac42e7fp+829,    0x1.b8449307430ccp-1,   0x1.fffff2p-1, INEXACT)
T(RZ,  0x1.d164edbe8bdb8p+624,    0x1.3f899918a523dp+1,         -0x1p+0, INEXACT)
T(RD,  0x1.d164edbe8bdb8p+624,    0x1.3f899918a523dp+1,         -0x1p+0, INEXACT)
T(RU,  0x1.d164edbe8bdb8p+624,    0x1.3f899918a523ep+1,  0x1.60a5cap-26, INEXACT)
T(RN, -0x1.c8a70c41c82ecp+547,   -0x1.bd31474f6950bp+1,   -0x1.fffffp-2, INEXACT)
T(RZ,  0x1.0fab81ab8dd79p+271,   -0x1.1e52bf828a759p+3,   0x1.fffffep-1, INEXACT)
T(RU,  0x1.0fab81ab8dd79p+271,   -0x1.1e52bf828a759p+3,   0x1.fffffep-1, INEXACT)
T(RD,  0x1.0fab81ab8dd79p+271,   -0x1.1e52bf828a75ap+3, -0x1.d88a8ep-25, INEXACT)
T(RZ,  0x1.c440493b185efp+641,    0x1.0d73da8247629p-1, -0x1.9d8278p-22, INEXACT)
T(RD,  0x1.c440493b185efp+641,    0x1.0d73da8247629p-1, -0x1.9d8278p-22, INEXACT)
T(RU,  0x1.c440493b185efp+641,    0x1.0d73da824762ap-1,   0x1.fffff4p-1, INEXACT)
T(RZ,    -0x1.ae746bc4ff77p+9,   -0x1.d1753684282e8p-4,  0x1.a46beep-23, INEXACT)
T(RU,    -0x1.ae746bc4ff77p+9,   -0x1.d1753684282e8p-4,  0x1.a46beep-23, INEXACT)
T(RD,    -0x1.ae746bc4ff77p+9,   -0x1.d1753684282e9p-4,  -0x1.fffffap-1, INEXACT)
T(RZ,  0x1.eb23a4e461dbfp+614,    0x1.051cc463455c2p+1,  -0x1.fffff2p-1, INEXACT)
T(RD,  0x1.eb23a4e461dbfp+614,    0x1.051cc463455c2p+1,  -0x1.fffff2p-1, INEXACT)
T(RU,  0x1.eb23a4e461dbfp+614,    0x1.051cc463455c3p+1,  0x1.a86a28p-22, INEXACT)
T(RN,  0x1.5c7fc51977f15p+305,    0x1.1feebd070a38dp-1,   -0x1.ffffep-2, INEXACT)
T(RN, -0x1.f322a7277b477p+679,   -0x1.45103df0de966p+2,  -0x1.ffffe4p-2, INEXACT)
T(RZ,  0x1.9469bbef1a3fap+541,    0x1.41580792c3804p-1,         -0x1p+0, INEXACT)
T(RD,  0x1.9469bbef1a3fap+541,    0x1.41580792c3804p-1,         -0x1p+0, INEXACT)
T(RU,  0x1.9469bbef1a3fap+541,    0x1.41580792c3805p-1,  0x1.bcda9cp-26, INEXACT)
T(RZ,  0x1.04f4b422045c2p+542,    0x1.27fb8d5303436p-1, -0x1.f0ad1cp-23, INEXACT)
T(RD,  0x1.04f4b422045c2p+542,    0x1.27fb8d5303436p-1, -0x1.f0ad1cp-23, INEXACT)
T(RU,  0x1.04f4b422045c2p+542,    0x1.27fb8d5303437p-1,   0x1.fffff8p-1, INEXACT)
T(RZ, -0x1.35942a89f1e9ap+760,   -0x1.cd035b23745d6p-1,  0x1.788ffcp-22, INEXACT)
T(RU, -0x1.35942a89f1e9ap+760,   -0x1.cd035b23745d6p-1,  0x1.788ffcp-22, INEXACT)
T(RD, -0x1.35942a89f1e9ap+760,   -0x1.cd035b23745d7p-1,  -0x1.fffff4p-1, INEXACT)
T(RZ, -0x1.f92a2b8562ba7p+944,    0x1.7eb18c825dbb5p+3,  -0x1.fffff8p-1, INEXACT)
T(RD, -0x1.f92a2b8562ba7p+944,    0x1.7eb18c825dbb5p+3,  -0x1.fffff8p-1, INEXACT)
T(RU, -0x1.f92a2b8562ba7p+944,    0x1.7eb18c825dbb6p+3,  0x1.034086p-22, INEXACT)
T(RZ,  0x1.ab5599ab10efep+673,   -0x1.788d8ffa038f7p+0,  0x1.3bfe32p-22, INEXACT)
T(RU,  0x1.ab5599ab10efep+673,   -0x1.788d8ffa038f7p+0,  0x1.3bfe32p-22, INEXACT)
T(RD,  0x1.ab5599ab10efep+673,   -0x1.788d8ffa038f8p+0,  -0x1.fffff6p-1, INEXACT)
T(RZ,  0x1.0400a11f316bdp+652,   -0x1.b145be1917dcep-1,    0x1.fffffp-1, INEXACT)
T(RU,  0x1.0400a11f316bdp+652,   -0x1.b145be1917dcep-1,    0x1.fffffp-1, INEXACT)
T(RD,  0x1.0400a11f316bdp+652,   -0x1.b145be1917dcfp-1, -0x1.fc5f92p-22, INEXACT)
T(RZ, -0x1.a581b048fd099p+337,    0x1.e77de021e921ap-2,  -0x1.fffff4p-1, INEXACT)
T(RD, -0x1.a581b048fd099p+337,    0x1.e77de021e921ap-2,  -0x1.fffff4p-1, INEXACT)
T(RU, -0x1.a581b048fd099p+337,    0x1.e77de021e921bp-2,  0x1.68a6dep-22, INEXACT)
T(RN, -0x1.6c163c61db7e1p+973,    0x1.4a0eabb1fcfafp+0,  -0x1.ffffe2p-2, INEXACT)
T(RN,  0x1.b98fe32574b9cp+464,    0x1.36c88fc39f74dp+0,  -0x1.ffffe2p-2, INEXACT)
T(RZ, -0x1.9255473b4f222p+567,    0x1.a8eb132ab85ddp-2, -0x1.0bd762p-22, INEXACT)
T(RD, -0x1.9255473b4f222p+567,    0x1.a8eb132ab85ddp-2, -0x1.0bd762p-22, INEXACT)
T(RU, -0x1.9255473b4f222p+567,    0x1.a8eb132ab85dep-2,   0x1.fffff8p-1, INEXACT)
T(RZ, -0x1.9f893286997dep+527,   -0x1.1d06c8a683ec9p+2,  0x1.8415acp-22, INEXACT)
T(RU, -0x1.9f893286997dep+527,   -0x1.1d06c8a683ec9p+2,  0x1.8415acp-22, INEXACT)
T(RD, -0x1.9f893286997dep+527,   -0x1.1d06c8a683ecap+2,  -0x1.fffff4p-1, INEXACT)
T(RZ,  0x1.dfd778a2a4425p+269,    -0x1.ea7a44b41f34p-1,   0x1.fffff2p-1, INEXACT)
T(RU,  0x1.dfd778a2a4425p+269,    -0x1.ea7a44b41f34p-1,   0x1.fffff2p-1, INEXACT)
T(RD,  0x1.dfd778a2a4425p+269,   -0x1.ea7a44b41f341p-1, -0x1.c90474p-22, INEXACT)
T(RZ, -0x1.de22b751ca113p+545,   -0x1.81df35dfb7f64p+2,   0x1.fffffap-1, INEXACT)
T(RU, -0x1.de22b751ca113p+545,   -0x1.81df35dfb7f64p+2,   0x1.fffffap-1, INEXACT)
T(RD, -0x1.de22b751ca113p+545,   -0x1.81df35dfb7f65p+2, -0x1.50e42cp-23, INEXACT)
T(RN,  0x1.567756f40f23fp+360,    0x1.70e8e4eb7bcddp-3,  -0x1.fffff8p-2, INEXACT)
T(RN, -0x1.b8e1ed4cac75fp+713,   -0x1.8862f49b31106p-1,  -0x1.ffffe2p-2, INEXACT)
T(RN, -0x1.81504dda1a044p+483,    0x1.97cd9cc135b74p+0,  -0x1.ffffeep-2, INEXACT)
T(RN, -0x1.9f38c4d0aa715p+159,    0x1.da0bcfb2bf986p+1,  -0x1.fffff8p-2, INEXACT)
T(RN,  0x1.88217a17a50adp+251,    0x1.f4400a1339d5cp+0,  -0x1.ffffe6p-2, INEXACT)
T(RN, -0x1.e09c620dff999p+294,   -0x1.d2b3587358bd6p+0,  -0x1.ffffeap-2, INEXACT)
T(RN,  0x1.812e9192a9847p+510,    0x1.969cc43c5b9ddp+0,   -0x1.fffffp-2, INEXACT)
T(RN, -0x1.cf6173b564bbfp+580,   -0x1.323603bd843a8p+3,  -0x1.ffffeap-2, INEXACT)
T(RN, -0x1.9929156dfa1adp+431,   -0x1.e3ae479da6212p-1,  -0x1.ffffe4p-2, INEXACT)
T(RN, -0x1.d72fce101eca2p+408,    0x1.1434efba4bc3ep+3,  -0x1.fffff2p-2, INEXACT)
T(RN, -0x1.29777f352a3d5p+695,   -0x1.9008c6f09757dp+2,  -0x1.fffffcp-2, INEXACT)
T(RN, -0x1.7eaacd02d5262p+863,   -0x1.1e9928954fad3p+1,  -0x1.ffffe4p-2, INEXACT)
T(RZ, -0x1.19868215e8104p+283,   0x1.ebdce89fcde0cp+12,  -0x1.fffffap-1, INEXACT)
T(RD, -0x1.19868215e8104p+283,   0x1.ebdce89fcde0cp+12,  -0x1.fffffap-1, INEXACT)
T(RU, -0x1.19868215e8104p+283,   0x1.ebdce89fcde0dp+12,  0x1.67af2ap-23, INEXACT)
T(RZ, -0x1.b7dd693eb190bp+604,   -0x1.64246773f257bp+3,   0x1.fffffcp-1, INEXACT)
T(RU, -0x1.b7dd693eb190bp+604,   -0x1.64246773f257bp+3,   0x1.fffffcp-1, INEXACT)
T(RD, -0x1.b7dd693eb190bp+604,   -0x1.64246773f257cp+3, -0x1.0c68e6p-23, INEXACT)
T(RZ,  0x1.42cffd48b0477p+116,   -0x1.ed04af2e5ca87p+3,  0x1.93161ep-23, INEXACT)
T(RU,  0x1.42cffd48b0477p+116,   -0x1.ed04af2e5ca87p+3,  0x1.93161ep-23, INEXACT)
T(RD,  0x1.42cffd48b0477p+116,   -0x1.ed04af2e5ca88p+3,  -0x1.fffffap-1, INEXACT)
T(RZ, -0x1.de9bb0e3ab8bep+303,    0x1.23bdcc5673372p+1,  -0x1.fffffcp-1, INEXACT)
T(RD, -0x1.de9bb0e3ab8bep+303,    0x1.23bdcc5673372p+1,  -0x1.fffffcp-1, INEXACT)
T(RU, -0x1.de9bb0e3ab8bep+303,    0x1.23bdcc5673373p+1,  0x1.95b0d8p-24, INEXACT)
T(RZ, -0x1.6bde2cd205a25p+612,   -0x1.3e01e0c4fedb2p-5,   0x1.fffffcp-1, INEXACT)
T(RU, -0x1.6bde2cd205a25p+612,   -0x1.3e01e0c4fedb2p-5,   0x1.fffffcp-1, INEXACT)
T(RD, -0x1.6bde2cd205a25p+612,   -0x1.3e01e0c4fedb3p-5, -0x1.830128p-24, INEXACT)
T(RZ,  0x1.fd4467ee215d2p+647,   -0x1.c70f1c13dd393p-2,   0x1.fffffap-1, INEXACT)
T(RU,  0x1.fd4467ee215d2p+647,   -0x1.c70f1c13dd393p-2,   0x1.fffffap-1, INEXACT)
T(RD,  0x1.fd4467ee215d2p+647,   -0x1.c70f1c13dd394p-2, -0x1.8da6f2p-23, INEXACT)
T(RN,  0x1.bad0549bfe3e8p+536,    0x1.433575ee67735p+0,  -0x1.fffff2p-2, INEXACT)
T(RN,  0x1.d2fc6b935bd42p+511,   -0x1.eb035c530ed87p+0,  -0x1.fffff6p-2, INEXACT)
T(RZ, -0x1.49c6a0b916b4fp+474,   -0x1.26d49f1d97b33p-1,   0x1.fffffep-1, INEXACT)
T(RU, -0x1.49c6a0b916b4fp+474,   -0x1.26d49f1d97b33p-1,   0x1.fffffep-1, INEXACT)
T(RD, -0x1.49c6a0b916b4fp+474,   -0x1.26d49f1d97b34p-1, -0x1.c02942p-25, INEXACT)
T(RZ, -0x1.762b671685adep+996,   -0x1.fed7a5cf97958p+0,   0x1.fffff8p-1, INEXACT)
T(RU, -0x1.762b671685adep+996,   -0x1.fed7a5cf97958p+0,   0x1.fffff8p-1, INEXACT)
T(RD, -0x1.762b671685adep+996,   -0x1.fed7a5cf97959p+0, -0x1.fc5af8p-23, INEXACT)
T(RN,  0x1.b5cd92bf1a561p+825,    0x1.c8330ff93d9f8p+4,  -0x1.fffffcp-2, INEXACT)
T(RZ, -0x1.a0dffc558ffaep+952,   -0x1.ac7a680240bbbp-1,   0x1.fffffep-1, INEXACT)
T(RU, -0x1.a0dffc558ffaep+952,   -0x1.ac7a680240bbbp-1,   0x1.fffffep-1, INEXACT)
T(RD, -0x1.a0dffc558ffaep+952,   -0x1.ac7a680240bbcp-1, -0x1.b6b762p-25, INEXACT)
T(RN,  0x1.ce01d5576288dp+243,   -0x1.052bd7dc1a202p-4,  -0x1.fffffcp-2, INEXACT)
T(RN, -0x1.922a64021e4afp+970,    0x1.2c3900c840ff2p+1,  -0x1.fffff6p-2, INEXACT)
T(RZ, -0x1.2255895573358p+845,   -0x1.86c1c6bcbea6bp+0,   0x1.fffffep-1, INEXACT)
T(RU, -0x1.2255895573358p+845,   -0x1.86c1c6bcbea6bp+0,   0x1.fffffep-1, INEXACT)
T(RD, -0x1.2255895573358p+845,   -0x1.86c1c6bcbea6cp+0,  -0x1.2369cp-24, INEXACT)
T(RN,  -0x1.0ebd0d0a987efp+46,    0x1.1e8a0861f2ed9p+3,   -0x1.fffffp-2, INEXACT)
T(RZ, -0x1.b4bff878a4ea9p+937,   -0x1.94d9fcc3c91c4p+2,  0x1.60ee94p-23, INEXACT)
T(RU, -0x1.b4bff878a4ea9p+937,   -0x1.94d9fcc3c91c4p+2,  0x1.60ee94p-23, INEXACT)
T(RD, -0x1.b4bff878a4ea9p+937,   -0x1.94d9fcc3c91c5p+2,  -0x1.fffffap-1, INEXACT)
T(RN,  0x1.6db19b02bd0aap+549,   -0x1.0bb53a1bc704bp-1,  -0x1.fffff4p-2, INEXACT)
T(RZ, -0x1.b3b1f98a75ef2p+440,    -0x1.021e0afe3058p+3,  0x1.615664p-24, INEXACT)
T(RU, -0x1.b3b1f98a75ef2p+440,    -0x1.021e0afe3058p+3,  0x1.615664p-24, INEXACT)
T(RD, -0x1.b3b1f98a75ef2p+440,   -0x1.021e0afe30581p+3,  -0x1.fffffep-1, INEXACT)
T(RZ,  0x1.700b54a172435p+433,   -0x1.da6d594ef8ac4p+0,   0x1.fffffcp-1, INEXACT)
T(RU,  0x1.700b54a172435p+433,   -0x1.da6d594ef8ac4p+0,   0x1.fffffcp-1, INEXACT)
T(RD,  0x1.700b54a172435p+433,   -0x1.da6d594ef8ac5p+0,  -0x1.b1322p-24, INEXACT)
T(RZ, -0x1.ba6b6154edecdp+172,    0x1.23c63575b6772p+2, -0x1.9b0734p-28, INEXACT)
T(RD, -0x1.ba6b6154edecdp+172,    0x1.23c63575b6772p+2, -0x1.9b0734p-28, INEXACT)
T(RU, -0x1.ba6b6154edecdp+172,    0x1.23c63575b6773p+2,          0x1p+0, INEXACT)
T(RZ,  0x1.c61403d7875aep+407,    -0x1.18a068c2b843p+0,   0x1.fffffap-1, INEXACT)
T(RU,  0x1.c61403d7875aep+407,    -0x1.18a068c2b843p+0,   0x1.fffffap-1, INEXACT)
T(RD,  0x1.c61403d7875aep+407,   -0x1.18a068c2b8431p+0, -0x1.403668p-23, INEXACT)
T(RZ, -0x1.31fa1dcf1a1dfp+937,    0x1.57fb439d41ba4p-1,  -0x1.201ddp-24, INEXACT)
T(RD, -0x1.31fa1dcf1a1dfp+937,    0x1.57fb439d41ba4p-1,  -0x1.201ddp-24, INEXACT)
T(RU, -0x1.31fa1dcf1a1dfp+937,    0x1.57fb439d41ba5p-1,   0x1.fffffep-1, INEXACT)
T(RZ, -0x1.739d7a32679cfp+798,    -0x1.1b3cd135cf0cp-4,  0x1.2e103cp-25, INEXACT)
T(RU, -0x1.739d7a32679cfp+798,    -0x1.1b3cd135cf0cp-4,  0x1.2e103cp-25, INEXACT)
T(RD, -0x1.739d7a32679cfp+798,   -0x1.1b3cd135cf0c1p-4,  -0x1.fffffep-1, INEXACT)
T(RN, 0x1.36e9123d3397ap+1016,    0x1.7d63eb188f222p+1,  -0x1.fffff4p-2, INEXACT)
T(RZ,  0x1.d6849961087bfp+648,    0x1.803beb668ecd6p-2,  -0x1.fffff8p-1, INEXACT)
T(RD,  0x1.d6849961087bfp+648,    0x1.803beb668ecd6p-2,  -0x1.fffff8p-1, INEXACT)
T(RU,  0x1.d6849961087bfp+648,    0x1.803beb668ecd7p-2,  0x1.f0db4cp-23, INEXACT)
T(RZ, -0x1.61a7f3b6265bcp+135,   -0x1.9d530762a27d5p+0,   0x1.fffffep-1, INEXACT)
T(RU, -0x1.61a7f3b6265bcp+135,   -0x1.9d530762a27d5p+0,   0x1.fffffep-1, INEXACT)
T(RD, -0x1.61a7f3b6265bcp+135,   -0x1.9d530762a27d6p+0, -0x1.32236cp-24, INEXACT)
T(RZ,  -0x1.26800d72af81p+942,   -0x1.a4adf8c5cea63p-1,   0x1.fffffep-1, INEXACT)
T(RU,  -0x1.26800d72af81p+942,   -0x1.a4adf8c5cea63p-1,   0x1.fffffep-1, INEXACT)
T(RD,  -0x1.26800d72af81p+942,   -0x1.a4adf8c5cea64p-1, -0x1.2d2048p-24, INEXACT)
T(RN, -0x1.e2d732bb3044bp+781,    0x1.84e8519cb7d9dp+1,  -0x1.fffffap-2, INEXACT)
T(RN,  -0x1.62f10d440471p+633,   -0x1.14bea13d97249p-1,         -0x1p-1, INEXACT)
T(RN,  0x1.10f596fd85132p+909,   -0x1.50fa711357c3ap+1,  -0x1.fffff4p-2, INEXACT)
T(RN,  0x1.83f88a6297773p+326,   -0x1.f02c3c97c15aep-2,  -0x1.fffff4p-2, INEXACT)
T(RN, -0x1.3ec0291f63f46p+153,   -0x1.038d924b486dcp+1,  -0x1.fffffep-2, INEXACT)
T(RN,  0x1.ab6131b7a5a4dp+132,    0x1.071dd5d7b0878p+0,  -0x1.fffff4p-2, INEXACT)
T(RN,  0x1.07c2c1ac2a5e9p+811,    0x1.b9d0eacd7f31cp+0,  -0x1.fffffap-2, INEXACT)
T(RN,  -0x1.107589736c0fp+460,   -0x1.e307290eb7f92p+1,  -0x1.fffffep-2, INEXACT)
T(RN,  0x1.d8044fe4db794p+173,   -0x1.67bde03256bdbp-2,  -0x1.fffff8p-2, INEXACT)
T(RN,  0x1.ea41d518ff896p+821,    0x1.6871796fbddefp+0,  -0x1.fffffap-2, INEXACT)
T(RN,  0x1.e38d96f61ff45p+935,   -0x1.270de980b5946p-1,  -0x1.fffff2p-2, INEXACT)
T(RN, -0x1.8b97ad047029cp+884,   -0x1.922cbd13d6342p-4,  -0x1.fffffcp-2, INEXACT)
T(RZ,  0x1.9082883287ff4p+816,    0x1.163f4a4d4f52cp+0, -0x1.ec85aep-24, INEXACT)
T(RD,  0x1.9082883287ff4p+816,    0x1.163f4a4d4f52cp+0, -0x1.ec85aep-24, INEXACT)
T(RU,  0x1.9082883287ff4p+816,    0x1.163f4a4d4f52dp+0,   0x1.fffffcp-1, INEXACT)
T(RZ,  0x1.f08c7efd77c62p+685,   -0x1.403e51bf03133p+2,  0x1.c57432p-27, INEXACT)
T(RU,  0x1.f08c7efd77c62p+685,   -0x1.403e51bf03133p+2,  0x1.c57432p-27, INEXACT)
T(RD,  0x1.f08c7efd77c62p+685,   -0x1.403e51bf03134p+2,         -0x1p+0, INEXACT)
T(RZ, -0x1.6a46ce8403b2cp+163,    0x1.8637c65a6af98p+2, -0x1.15216ap-27, INEXACT)
T(RD, -0x1.6a46ce8403b2cp+163,    0x1.8637c65a6af98p+2, -0x1.15216ap-27, INEXACT)
T(RU, -0x1.6a46ce8403b2cp+163,    0x1.8637c65a6af99p+2,          0x1p+0, INEXACT)
T(RZ,  0x1.76f54b6468537p+380,   -0x1.546febfa4e423p-2,   0x1.2bc02p-25, INEXACT)
T(RU,  0x1.76f54b6468537p+380,   -0x1.546febfa4e423p-2,   0x1.2bc02p-25, INEXACT)
T(RD,  0x1.76f54b6468537p+380,   -0x1.546febfa4e424p-2,  -0x1.fffffep-1, INEXACT)
T(RZ,  0x1.e8f24dca4bc88p+794,   -0x1.c781ce71259fep-1,   0x1.fffffep-1, INEXACT)
T(RU,  0x1.e8f24dca4bc88p+794,   -0x1.c781ce71259fep-1,   0x1.fffffep-1, INEXACT)
T(RD,  0x1.e8f24dca4bc88p+794,   -0x1.c781ce71259ffp-1,   -0x1.1a5cp-25, INEXACT)
T(RZ,  0x1.e75838b789d15p+118,    0x1.886cc502f0e66p-1, -0x1.7e16dap-24, INEXACT)
T(RD,  0x1.e75838b789d15p+118,    0x1.886cc502f0e66p-1, -0x1.7e16dap-24, INEXACT)
T(RU,  0x1.e75838b789d15p+118,    0x1.886cc502f0e67p-1,   0x1.fffffep-1, INEXACT)
T(RN, -0x1.386638cd2fc73p+458,    0x1.05dd7174c4d39p+2,  -0x1.fffffap-2, INEXACT)
T(RZ, -0x1.2a9b020bca5c1p+167,     0x1.ebc467c82806p+0, -0x1.a06d56p-25, INEXACT)
T(RD, -0x1.2a9b020bca5c1p+167,     0x1.ebc467c82806p+0, -0x1.a06d56p-25, INEXACT)
T(RU, -0x1.2a9b020bca5c1p+167,    0x1.ebc467c828061p+0,   0x1.fffffep-1, INEXACT)
T(RZ,  -0x1.873d6a685242ep+32,    0x1.e1a4e4965fe56p-1, -0x1.887702p-25, INEXACT)
T(RD,  -0x1.873d6a685242ep+32,    0x1.e1a4e4965fe56p-1, -0x1.887702p-25, INEXACT)
T(RU,  -0x1.873d6a685242ep+32,    0x1.e1a4e4965fe57p-1,   0x1.fffffep-1, INEXACT)
T(RZ,  0x1.4c203cca3de5cp+330,    0x1.e8bf48f212896p-2, -0x1.4ba684p-27, INEXACT)
T(RD,  0x1.4c203cca3de5cp+330,    0x1.e8bf48f212896p-2, -0x1.4ba684p-27, INEXACT)
T(RU,  0x1.4c203cca3de5cp+330,    0x1.e8bf48f212897p-2,          0x1p+0, INEXACT)
T(RN, -0x1.3f16b258df9aap+307,   -0x1.7b1e358d7a9dbp-1,  -0x1.fffffep-2, INEXACT)
T(RN,  0x1.5087527fce401p+936,    -0x1.8bfc2677aa27p+0,  -0x1.fffffep-2, INEXACT)
T(RN, -0x1.d34afcb98fd4fp+738,    0x1.ae65123000909p-2,         -0x1p-1, INEXACT)
T(RN, -0x1.0bc09953ea21cp+457,   -0x1.74a113fe774eap-2,  -0x1.fffffap-2, INEXACT)
T(RN, -0x1.588f83e1df356p+698,   -0x1.72ce78d247ca7p-1,  -0x1.fffffap-2, INEXACT)
T(RZ, -0x1.f44d3aa7fca2dp+609,   -0x1.494e4c2759436p-3,   0x1.fffffep-1, INEXACT)
T(RU, -0x1.f44d3aa7fca2dp+609,   -0x1.494e4c2759436p-3,   0x1.fffffep-1, INEXACT)
T(RD, -0x1.f44d3aa7fca2dp+609,   -0x1.494e4c2759437p-3, -0x1.09f282p-24, INEXACT)
T(RZ,   0x1.0d76e0083d141p+32,   -0x1.602ff3a877806p+3,   0x1.fffffcp-1, INEXACT)
T(RU,   0x1.0d76e0083d141p+32,   -0x1.602ff3a877806p+3,   0x1.fffffcp-1, INEXACT)
T(RD,   0x1.0d76e0083d141p+32,   -0x1.602ff3a877807p+3, -0x1.d547a8p-24, INEXACT)
T(RN, -0x1.a1e93fd56d158p+769,   -0x1.3065394e39146p-1,  -0x1.fffffap-2, INEXACT)
T(RN,   0x1.b66838be38c5fp+26,   -0x1.3b140563043f5p+0,  -0x1.fffffap-2, INEXACT)
T(RN,  0x1.a21cbe8525e57p+235,   -0x1.21b4433769504p+2,  -0x1.fffffap-2, INEXACT)
T(RZ,  0x1.d975cb8d7f91fp+381,   -0x1.742eface47498p-2,  0x1.7abbb6p-26, INEXACT)
T(RU,  0x1.d975cb8d7f91fp+381,   -0x1.742eface47498p-2,  0x1.7abbb6p-26, INEXACT)
T(RD,  0x1.d975cb8d7f91fp+381,   -0x1.742eface47499p-2,         -0x1p+0, INEXACT)
T(RN, -0x1.d105ad420c2d2p+253,     0x1.f382af1b94afp+0,  -0x1.fffffcp-2, INEXACT)
T(RN,  0x1.cb7b390b4f709p+742,     0x1.a3cb865dd287p+4,         -0x1p-1, INEXACT)
T(RZ, -0x1.ef878fa5f873ap+946,    0x1.8541b3f7e805cp-1,  -0x1.fffffep-1, INEXACT)
T(RD, -0x1.ef878fa5f873ap+946,    0x1.8541b3f7e805cp-1,  -0x1.fffffep-1, INEXACT)
T(RU, -0x1.ef878fa5f873ap+946,    0x1.8541b3f7e805dp-1,  0x1.60460ep-25, INEXACT)
T(RN, -0x1.8a4bdff254bcdp+236,   -0x1.496fc85b187a5p+0,  -0x1.fffffcp-2, INEXACT)
T(RZ,  0x1.89f11a6684319p+981,    0x1.fb4521ac9a55ap-2,  -0x1.fffffep-1, INEXACT)
T(RD,  0x1.89f11a6684319p+981,    0x1.fb4521ac9a55ap-2,  -0x1.fffffep-1, INEXACT)
T(RU,  0x1.89f11a6684319p+981,    0x1.fb4521ac9a55bp-2,   0x1.58337p-24, INEXACT)
T(RZ, -0x1.5884d0a4efa1cp+767,   -0x1.b30bd91f78497p-2,  0x1.087f58p-26, INEXACT)
T(RU, -0x1.5884d0a4efa1cp+767,   -0x1.b30bd91f78497p-2,  0x1.087f58p-26, INEXACT)
T(RD, -0x1.5884d0a4efa1cp+767,   -0x1.b30bd91f78498p-2,         -0x1p+0, INEXACT)
T(RZ,  0x1.6ec69a7823fadp+537,    0x1.57727e80701fdp+1,  -0x1.fffffep-1, INEXACT)
T(RD,  0x1.6ec69a7823fadp+537,    0x1.57727e80701fdp+1,  -0x1.fffffep-1, INEXACT)
T(RU,  0x1.6ec69a7823fadp+537,    0x1.57727e80701fep+1,  0x1.2e252ap-24, INEXACT)
T(RZ, -0x1.84f643ff5fb48p+692,   -0x1.05581c7f97faap+0,  0x1.e4cd9cp-26, INEXACT)
T(RU, -0x1.84f643ff5fb48p+692,   -0x1.05581c7f97faap+0,  0x1.e4cd9cp-26, INEXACT)
T(RD, -0x1.84f643ff5fb48p+692,   -0x1.05581c7f97fabp+0,         -0x1p+0, INEXACT)
T(RZ,  0x1.37aa04b83a5dep+897,   -0x1.7df2ed81f05fep+1,   0x1.fffffep-1, INEXACT)
T(RU,  0x1.37aa04b83a5dep+897,   -0x1.7df2ed81f05fep+1,   0x1.fffffep-1, INEXACT)
T(RD,  0x1.37aa04b83a5dep+897,   -0x1.7df2ed81f05ffp+1,  -0x1.5d498p-25, INEXACT)
T(RZ,  0x1.18db8a540af36p+519,    0x1.ec4d0eba624fdp+0,  -0x1.fffffcp-1, INEXACT)
T(RD,  0x1.18db8a540af36p+519,    0x1.ec4d0eba624fdp+0,  -0x1.fffffcp-1, INEXACT)
T(RU,  0x1.18db8a540af36p+519,    0x1.ec4d0eba624fep+0,  0x1.f7d082p-24, INEXACT)
T(RN, -0x1.9b37a2d07288cp+219,    0x1.337b471b05b38p+2,  -0x1.fffff8p-2, INEXACT)
T(RZ,  0x1.2c211db1ae06fp+239,    0x1.98d5db8d97e32p+0, -0x1.0d0542p-24, INEXACT)
T(RD,  0x1.2c211db1ae06fp+239,    0x1.98d5db8d97e32p+0, -0x1.0d0542p-24, INEXACT)
T(RU,  0x1.2c211db1ae06fp+239,    0x1.98d5db8d97e33p+0,   0x1.fffffep-1, INEXACT)
T(RN,  0x1.3393aae46c2a3p+168,   -0x1.bfe4b0d6ef286p+1,  -0x1.fffff8p-2, INEXACT)
T(RN,   -0x1.d8938e2f52d9ep+9,    0x1.01e66c696916ap-1,  -0x1.fffffcp-2, INEXACT)
T(RN,   0x1.0f921dbb68ea4p+59,   -0x1.791c14aff11bep+3,  -0x1.fffff8p-2, INEXACT)
T(RN, -0x1.94b8216856942p+836,   -0x1.93e03fdf0d026p+0,  -0x1.fffffep-2, INEXACT)
T(RN, -0x1.4153546984b67p+619,    0x1.cfe3ff2a2fe0ep-2,  -0x1.fffffap-2, INEXACT)
T(RN, -0x1.964985c865334p+607,   -0x1.74e470d7e36b2p-1,         -0x1p-1, INEXACT)
T(RN, -0x1.a88d1374dbabap+143,   -0x1.dfd994aa48a84p-4,  -0x1.fffffep-2, INEXACT)
T(RZ, -0x1.6f7a895da4c7dp+601,    0x1.a401159641974p-1,         -0x1p+0, INEXACT)
T(RD, -0x1.6f7a895da4c7dp+601,    0x1.a401159641974p-1,         -0x1p+0, INEXACT)
T(RU, -0x1.6f7a895da4c7dp+601,    0x1.a401159641975p-1,  0x1.9e180ep-27, INEXACT)
T(RN, -0x1.ff63c19ff41ccp+731,    0x1.bd91517d81668p-1,         -0x1p-1, INEXACT)
T(RN,  0x1.28ff248696e01p+239,    0x1.2229a5f2a5adep-1,  -0x1.fffffep-2, INEXACT)
T(RZ,   0x1.b45a21eee741dp+49,   -0x1.00b379f89dae3p-2,   0x1.fffffep-1, INEXACT)
T(RU,   0x1.b45a21eee741dp+49,   -0x1.00b379f89dae3p-2,   0x1.fffffep-1, INEXACT)
T(RD,   0x1.b45a21eee741dp+49,   -0x1.00b379f89dae4p-2, -0x1.320e26p-25, INEXACT)
T(RZ,  0x1.13fcce3ec3fffp+918,   -0x1.99a826f81887cp+2,   0x1.fffffep-1, INEXACT)
T(RU,  0x1.13fcce3ec3fffp+918,   -0x1.99a826f81887cp+2,   0x1.fffffep-1, INEXACT)
T(RD,  0x1.13fcce3ec3fffp+918,   -0x1.99a826f81887dp+2, -0x1.2ab66ep-25, INEXACT)
T(RN,  0x1.17e5b7701af05p+702,    0x1.43cf905da8dc3p-2,         -0x1p-1, INEXACT)
T(RZ,  0x1.5c2b927cf9208p+409,   -0x1.3c65c3810729cp-1,  0x1.bd0946p-25, INEXACT)
T(RU,  0x1.5c2b927cf9208p+409,   -0x1.3c65c3810729cp-1,  0x1.bd0946p-25, INEXACT)
T(RD,  0x1.5c2b927cf9208p+409,   -0x1.3c65c3810729dp-1,  -0x1.fffffep-1, INEXACT)
T(RZ,   -0x1.b249f0715cdep+79,   -0x1.1b2eeedbba749p-1,  0x1.e0fee8p-25, INEXACT)
T(RU,   -0x1.b249f0715cdep+79,   -0x1.1b2eeedbba749p-1,  0x1.e0fee8p-25, INEXACT)
T(RD,   -0x1.b249f0715cdep+79,   -0x1.1b2eeedbba74ap-1,  -0x1.fffffep-1, INEXACT)
T(RZ, -0x1.707a17e4e67a2p+755,    0x1.17508a9e34cb2p+0, -0x1.66b7c2p-25, INEXACT)
T(RD, -0x1.707a17e4e67a2p+755,    0x1.17508a9e34cb2p+0, -0x1.66b7c2p-25, INEXACT)
T(RU, -0x1.707a17e4e67a2p+755,    0x1.17508a9e34cb3p+0,   0x1.fffffep-1, INEXACT)
T(RN, -0x1.21ca9c1be810bp+532,    0x1.3d361f77289fap-1,  -0x1.fffffep-2, INEXACT)
T(RZ, -0x1.d0e67d6abeeefp+452,   -0x1.766436e91dcedp-1,          0x1p+0, INEXACT)
T(RU, -0x1.d0e67d6abeeefp+452,   -0x1.766436e91dcedp-1,          0x1p+0, INEXACT)
T(RD, -0x1.d0e67d6abeeefp+452,   -0x1.766436e91dceep-1,  -0x1.b9edep-27, INEXACT)
T(RZ,  0x1.e0db37adb9f34p+673,   -0x1.7e5b72fa7643dp+2,          0x1p+0, INEXACT)
T(RU,  0x1.e0db37adb9f34p+673,   -0x1.7e5b72fa7643dp+2,          0x1p+0, INEXACT)
T(RD,  0x1.e0db37adb9f34p+673,   -0x1.7e5b72fa7643ep+2, -0x1.e8244ap-29, INEXACT)
T(RZ,   0x1.a562c5dba160cp+96,   -0x1.06037d780ab0fp+1,  0x1.e61f74p-27, INEXACT)
T(RU,   0x1.a562c5dba160cp+96,   -0x1.06037d780ab0fp+1,  0x1.e61f74p-27, INEXACT)
T(RD,   0x1.a562c5dba160cp+96,    -0x1.06037d780ab1p+1,         -0x1p+0, INEXACT)
T(RN,  -0x1.f307ab1e59a7p+311,    0x1.a8fe6333056f2p+1,  -0x1.fffffep-2, INEXACT)
T(RN,   0x1.403c897c5bba4p+34,   -0x1.c9cb03b0e47a1p-1,         -0x1p-1, INEXACT)
T(RZ,  0x1.e42744ecdfebap+635,    0x1.8ec230a67dc83p+3,         -0x1p+0, INEXACT)
T(RD,  0x1.e42744ecdfebap+635,    0x1.8ec230a67dc83p+3,         -0x1p+0, INEXACT)
T(RU,  0x1.e42744ecdfebap+635,    0x1.8ec230a67dc84p+3,  0x1.6acbfap-28, INEXACT)
T(RZ,  0x1.6a9e2bf2005b6p+915,    0x1.125ef4c33c54ep+0,         -0x1p+0, INEXACT)
T(RD,  0x1.6a9e2bf2005b6p+915,    0x1.125ef4c33c54ep+0,         -0x1p+0, INEXACT)
T(RU,  0x1.6a9e2bf2005b6p+915,    0x1.125ef4c33c54fp+0,   0x1.b7d42p-26, INEXACT)
T(RN, -0x1.a24f8faab6931p+276,   -0x1.a9802cc393962p+0,  -0x1.fffffep-2, INEXACT)
T(RZ,  0x1.0180d7abc6649p+697,   -0x1.b6f6ee3f6eadcp+5,  0x1.a7e2a2p-25, INEXACT)
T(RU,  0x1.0180d7abc6649p+697,   -0x1.b6f6ee3f6eadcp+5,  0x1.a7e2a2p-25, INEXACT)
T(RD,  0x1.0180d7abc6649p+697,   -0x1.b6f6ee3f6eaddp+5,  -0x1.fffffep-1, INEXACT)
T(RZ,  0x1.39b15ba0ca2fbp+365,   -0x1.17b71fd4396cdp-1,   0x1.fffffep-1, INEXACT)
T(RU,  0x1.39b15ba0ca2fbp+365,   -0x1.17b71fd4396cdp-1,   0x1.fffffep-1, INEXACT)
T(RD,  0x1.39b15ba0ca2fbp+365,   -0x1.17b71fd4396cep-1, -0x1.464074p-25, INEXACT)
T(RZ,  -0x1.3c92e68741f98p+58,    0x1.3475e807fda9ap-4, -0x1.5c85b8p-26, INEXACT)
T(RD,  -0x1.3c92e68741f98p+58,    0x1.3475e807fda9ap-4, -0x1.5c85b8p-26, INEXACT)
T(RU,  -0x1.3c92e68741f98p+58,    0x1.3475e807fda9bp-4,          0x1p+0, INEXACT)
T(RZ, -0x1.d0c6f841701d4p+904,   -0x1.6c4597d5e0691p-7,  0x1.120fc6p-25, INEXACT)
T(RU, -0x1.d0c6f841701d4p+904,   -0x1.6c4597d5e0691p-7,  0x1.120fc6p-25, INEXACT)
T(RD, -0x1.d0c6f841701d4p+904,   -0x1.6c4597d5e0692p-7,  -0x1.fffffep-1, INEXACT)
T(RN,  0x1.6ca4fa805e16ap+289,   -0x1.77345e1ba78d9p-1,  -0x1.fffffep-2, INEXACT)
T(RN, -0x1.f2625fa42e827p+885,   -0x1.144cbbc662ab8p-2,  -0x1.fffffep-2, INEXACT)
T(RN, -0x1.f4eff50580e2bp+699,    0x1.ca5de7917b57bp-2,         -0x1p-1, INEXACT)
T(RN,  0x1.898af981f608ap+485,    0x1.7884d58a9f7eep-3,  -0x1.fffffep-2, INEXACT)
T(RN,  0x1.533de2dd49dd8p+773,    -0x1.a26ebdaa5b0cp+0,  -0x1.fffffep-2, INEXACT)
T(RZ,  0x1.40c511daa90a3p+819,   -0x1.9b5d970e14689p+0,   0x1.fffffep-1, INEXACT)
T(RU,  0x1.40c511daa90a3p+819,   -0x1.9b5d970e14689p+0,   0x1.fffffep-1, INEXACT)
T(RD,  0x1.40c511daa90a3p+819,   -0x1.9b5d970e1468ap+0,  -0x1.f8d6fp-25, INEXACT)
T(RZ,  0x1.835fa33648732p+614,    0x1.eee9313edb111p-4,  -0x1.fffffep-1, INEXACT)
T(RD,  0x1.835fa33648732p+614,    0x1.eee9313edb111p-4,  -0x1.fffffep-1, INEXACT)
T(RU,  0x1.835fa33648732p+614,    0x1.eee9313edb112p-4,  0x1.9a313cp-25, INEXACT)
T(RZ, -0x1.c8770ce679365p+529,   -0x1.7228522bbca31p-4,   0x1.fffffep-1, INEXACT)
T(RU, -0x1.c8770ce679365p+529,   -0x1.7228522bbca31p-4,   0x1.fffffep-1, INEXACT)
T(RD, -0x1.c8770ce679365p+529,   -0x1.7228522bbca32p-4, -0x1.8e533cp-25, INEXACT)
T(RZ, -0x1.bcd6e4e60aeb7p+588,   -0x1.4be6dc8d4e023p-4,  0x1.764cb6p-25, INEXACT)
T(RU, -0x1.bcd6e4e60aeb7p+588,   -0x1.4be6dc8d4e023p-4,  0x1.764cb6p-25, INEXACT)
T(RD, -0x1.bcd6e4e60aeb7p+588,   -0x1.4be6dc8d4e024p-4,  -0x1.fffffep-1, INEXACT)
T(RZ,   0x1.e4e18e58856ap+754,   -0x1.5b9e81405bf26p+2,          0x1p+0, INEXACT)
T(RU,   0x1.e4e18e58856ap+754,   -0x1.5b9e81405bf26p+2,          0x1p+0, INEXACT)
T(RD,   0x1.e4e18e58856ap+754,   -0x1.5b9e81405bf27p+2, -0x1.ea9becp-27, INEXACT)
T(RN, -0x1.413e9dafc9717p+372,    -0x1.7b3eb7c336a7p-3,         -0x1p-1, INEXACT)
T(RN,  0x1.11911f41ab3cfp+404,    0x1.42922c4c96062p-1,  -0x1.fffffep-2, INEXACT)
T(RN,  0x1.ce96eb450ec93p+307,    0x1.55e36e579f9eap+1,  -0x1.fffffcp-2, INEXACT)
T(RN, -0x1.a4df283b1b46ep+749,    0x1.c9a88c97bdb47p-1,  -0x1.fffffep-2, INEXACT)
T(RN,   -0x1.47ffd14034fcp+67,    0x1.113fdeb3afb19p+2,  -0x1.fffffcp-2, INEXACT)
T(RN,-0x1.81173b2506f77p+1012,   -0x1.56f7e7bfd3014p+3,  -0x1.fffffcp-2, INEXACT)
T(RN,  0x1.8fe27f125dab2p+478,    0x1.3e2e6a912b06cp+2,  -0x1.fffffcp-2, INEXACT)
T(RN,  0x1.2ceb0adf3427fp+986,    0x1.242b59b85a521p+1,  -0x1.fffffep-2, INEXACT)
T(RZ, -0x1.fae36e216d52fp+919,    -0x1.6629c2640fadp-1,          0x1p+0, INEXACT)
T(RU, -0x1.fae36e216d52fp+919,    -0x1.6629c2640fadp-1,          0x1p+0, INEXACT)
T(RD, -0x1.fae36e216d52fp+919,   -0x1.6629c2640fad1p-1, -0x1.ad922cp-28, INEXACT)
T(RZ,  0x1.c96c3d9b5ca0cp+312,   -0x1.c80d0626fa363p+2,          0x1p+0, INEXACT)
T(RU,  0x1.c96c3d9b5ca0cp+312,   -0x1.c80d0626fa363p+2,          0x1p+0, INEXACT)
T(RD,  0x1.c96c3d9b5ca0cp+312,   -0x1.c80d0626fa364p+2, -0x1.f8aad4p-26, INEXACT)
T(RZ, -0x1.f92b8c1979727p+165,   -0x1.d150f68218185p+3,          0x1p+0, INEXACT)
T(RU, -0x1.f92b8c1979727p+165,   -0x1.d150f68218185p+3,          0x1p+0, INEXACT)
T(RD, -0x1.f92b8c1979727p+165,   -0x1.d150f68218186p+3, -0x1.e950c4p-27, INEXACT)
T(RZ, -0x1.53db1f9f0a009p+700,    0x1.c31258b819ecap-3,         -0x1p+0, INEXACT)
T(RD, -0x1.53db1f9f0a009p+700,    0x1.c31258b819ecap-3,         -0x1p+0, INEXACT)
T(RU, -0x1.53db1f9f0a009p+700,    0x1.c31258b819ecbp-3,   0x1.ac09dp-26, INEXACT)
T(RN, -0x1.6bc81720c32b2p+356,   -0x1.7774a95364cfap+0,         -0x1p-1, INEXACT)
T(RN, -0x1.4d252e00a8072p+664,    0x1.215286e9b742bp+1,  -0x1.fffffep-2, INEXACT)
T(RZ,  0x1.a8faecf12074cp+785,   -0x1.effd2e0166329p+1,   0x1.4ab68p-27, INEXACT)
T(RU,  0x1.a8faecf12074cp+785,   -0x1.effd2e0166329p+1,   0x1.4ab68p-27, INEXACT)
T(RD,  0x1.a8faecf12074cp+785,   -0x1.effd2e016632ap+1,         -0x1p+0, INEXACT)
T(RN,  0x1.731da67afcdd6p+237,    0x1.ef7f8070ecd71p+1,  -0x1.fffffep-2, INEXACT)
T(RN,  -0x1.aaebbd8c731cbp+69,   -0x1.b1d460029baecp-1,         -0x1p-1, INEXACT)
T(RZ,  0x1.97725a8eb62b5p+861,   -0x1.3a37a6bc2f256p+0,          0x1p+0, INEXACT)
T(RU,  0x1.97725a8eb62b5p+861,   -0x1.3a37a6bc2f256p+0,          0x1p+0, INEXACT)
T(RD,  0x1.97725a8eb62b5p+861,   -0x1.3a37a6bc2f257p+0, -0x1.a3d664p-26, INEXACT)
T(RZ,  -0x1.36cc57f159afp+983,    0x1.ed8753e44ba3bp-2,         -0x1p+0, INEXACT)
T(RD,  -0x1.36cc57f159afp+983,    0x1.ed8753e44ba3bp-2,         -0x1p+0, INEXACT)
T(RU,  -0x1.36cc57f159afp+983,    0x1.ed8753e44ba3cp-2,    0x1.252dp-30, INEXACT)
T(RZ, -0x1.d37702a4ce691p+983,   -0x1.bdcf3a05e03dbp-1,  0x1.0250d2p-27, INEXACT)
T(RU, -0x1.d37702a4ce691p+983,   -0x1.bdcf3a05e03dbp-1,  0x1.0250d2p-27, INEXACT)
T(RD, -0x1.d37702a4ce691p+983,   -0x1.bdcf3a05e03dcp-1,         -0x1p+0, INEXACT)
T(RZ,  0x1.eb346e3fa727cp+823,   -0x1.05c0324ff16bcp-1,          0x1p+0, INEXACT)
T(RU,  0x1.eb346e3fa727cp+823,   -0x1.05c0324ff16bcp-1,          0x1p+0, INEXACT)
T(RD,  0x1.eb346e3fa727cp+823,   -0x1.05c0324ff16bdp-1,   -0x1.5eb9p-28, INEXACT)
T(RN, -0x1.511edacceef24p+452,    0x1.1148f64b8bdf2p+0,         -0x1p-1, INEXACT)
T(RN,  0x1.d91e39079c265p+111,   -0x1.be07088f745a7p-1,  -0x1.fffffep-2, INEXACT)
T(RZ, -0x1.5a8ff65f0a7e7p+514,    0x1.41b6876676c83p+1, -0x1.4560b6p-27, INEXACT)
T(RD, -0x1.5a8ff65f0a7e7p+514,    0x1.41b6876676c83p+1, -0x1.4560b6p-27, INEXACT)
T(RU, -0x1.5a8ff65f0a7e7p+514,    0x1.41b6876676c84p+1,          0x1p+0, INEXACT)
T(RN,   0x1.a93d6be030a09p+22,   -0x1.be5edeb000fe1p+0,         -0x1p-1, INEXACT)
T(RZ, -0x1.f5c273eebf693p+689,    0x1.b17dafde5a37bp-9, -0x1.90bd7ep-27, INEXACT)
T(RD, -0x1.f5c273eebf693p+689,    0x1.b17dafde5a37bp-9, -0x1.90bd7ep-27, INEXACT)
T(RU, -0x1.f5c273eebf693p+689,    0x1.b17dafde5a37cp-9,          0x1p+0, INEXACT)
T(RZ,  0x1.7ec80267ed241p+401,    0x1.91af201107522p-1,         -0x1p+0, INEXACT)
T(RD,  0x1.7ec80267ed241p+401,    0x1.91af201107522p-1,         -0x1p+0, INEXACT)
T(RU,  0x1.7ec80267ed241p+401,    0x1.91af201107523p-1,  0x1.c7a8c8p-27, INEXACT)
T(RZ, -0x1.03dbacf620002p+908,    0x1.281502a23edc3p-1,         -0x1p+0, INEXACT)
T(RD, -0x1.03dbacf620002p+908,    0x1.281502a23edc3p-1,         -0x1p+0, INEXACT)
T(RU, -0x1.03dbacf620002p+908,    0x1.281502a23edc4p-1,  0x1.71ea48p-26, INEXACT)
T(RZ, -0x1.ea760fbf1e67ep+604,    0x1.2482168bb16e4p+0,         -0x1p+0, INEXACT)
T(RD, -0x1.ea760fbf1e67ep+604,    0x1.2482168bb16e4p+0,         -0x1p+0, INEXACT)
T(RU, -0x1.ea760fbf1e67ep+604,    0x1.2482168bb16e5p+0,  0x1.ef3fd2p-26, INEXACT)
T(RZ, -0x1.909f92adea9ccp+922,   -0x1.4e30134e64559p+3,  0x1.66be4ap-28, INEXACT)
T(RU, -0x1.909f92adea9ccp+922,   -0x1.4e30134e64559p+3,  0x1.66be4ap-28, INEXACT)
T(RD, -0x1.909f92adea9ccp+922,   -0x1.4e30134e6455ap+3,         -0x1p+0, INEXACT)
T(RZ, -0x1.8a3a16600bac5p+952,   -0x1.2ac39404c72c1p+3,          0x1p+0, INEXACT)
T(RU, -0x1.8a3a16600bac5p+952,   -0x1.2ac39404c72c1p+3,          0x1p+0, INEXACT)
T(RD, -0x1.8a3a16600bac5p+952,   -0x1.2ac39404c72c2p+3, -0x1.229f76p-27, INEXACT)
T(RN,  0x1.5001aee1b587bp+812,   -0x1.f72248afbf905p+1,  -0x1.fffffep-2, INEXACT)
T(RZ,  -0x1.068de661c11cp+102,   -0x1.58db4aee57018p+1,  0x1.b495f2p-27, INEXACT)
T(RU,  -0x1.068de661c11cp+102,   -0x1.58db4aee57018p+1,  0x1.b495f2p-27, INEXACT)
T(RD,  -0x1.068de661c11cp+102,   -0x1.58db4aee57019p+1,         -0x1p+0, INEXACT)
T(RZ, -0x1.81fbc601001ecp+996,    0x1.7dd8b1824a5aap-2, -0x1.11c024p-27, INEXACT)
T(RD, -0x1.81fbc601001ecp+996,    0x1.7dd8b1824a5aap-2, -0x1.11c024p-27, INEXACT)
T(RU, -0x1.81fbc601001ecp+996,    0x1.7dd8b1824a5abp-2,          0x1p+0, INEXACT)
T(RN,  0x1.31c9054798828p+720,    0x1.34d8c657fa5a1p+2,  -0x1.fffffep-2, INEXACT)
T(RZ,  0x1.5c807d7cc01aep+503,   -0x1.3999143c2ca16p+1,  0x1.37859ap-26, INEXACT)
T(RU,  0x1.5c807d7cc01aep+503,   -0x1.3999143c2ca16p+1,  0x1.37859ap-26, INEXACT)
T(RD,  0x1.5c807d7cc01aep+503,   -0x1.3999143c2ca17p+1,         -0x1p+0, INEXACT)
T(RN, -0x1.85118ac0490d9p+866,    0x1.4f37a93bc3c48p+0,         -0x1p-1, INEXACT)
T(RZ, -0x1.6ade63218e90fp+194,    0x1.cb161a7c67032p-1, -0x1.6ff25ep-26, INEXACT)
T(RD, -0x1.6ade63218e90fp+194,    0x1.cb161a7c67032p-1, -0x1.6ff25ep-26, INEXACT)
T(RU, -0x1.6ade63218e90fp+194,    0x1.cb161a7c67033p-1,          0x1p+0, INEXACT)
T(RN,  0x1.7a78772dd3c99p+473,    0x1.5196d353cf454p-3,  -0x1.fffffep-2, INEXACT)
T(RN,  0x1.23c2a7d00116bp+142,   -0x1.511d7fdcea50cp+1,  -0x1.fffffep-2, INEXACT)
T(RN,  0x1.6a529a4c458cbp+760,   -0x1.48bb8f35b7cdfp+1,  -0x1.fffffep-2, INEXACT)
T(RN,   0x1.b41dfe0a11671p+36,   -0x1.5486831d23004p-1,         -0x1p-1, INEXACT)
T(RN,  0x1.f8637d9026c98p+331,   -0x1.71e0d83debe25p-1,  -0x1.fffffep-2, INEXACT)
T(RN,   0x1.4528be9116cc9p+10,     0x1.1b061967442cp-6,  -0x1.fffffep-2, INEXACT)
T(RN,  0x1.ff65107e7837dp+927,    0x1.87aa132910fcdp-3,  -0x1.fffffep-2, INEXACT)
T(RN, -0x1.aa9231de73c3ep+754,    0x1.24254f35861d2p-3,  -0x1.fffffep-2, INEXACT)
T(RN, -0x1.f1ae3bd65bfc7p+378,    0x1.164a3451753a2p-3,  -0x1.fffffep-2, INEXACT)
T(RN,  0x1.e1f62f049b885p+671,    0x1.4eefe074db21ap-6,         -0x1p-1, INEXACT)
T(RZ, -0x1.aadfa04a7fb61p+728,    0x1.d9da36fd8b18dp-1,         -0x1p+0, INEXACT)
T(RD, -0x1.aadfa04a7fb61p+728,    0x1.d9da36fd8b18dp-1,         -0x1p+0, INEXACT)
T(RU, -0x1.aadfa04a7fb61p+728,    0x1.d9da36fd8b18ep-1,  0x1.0bd51ep-27, INEXACT)
T(RN, -0x1.f63c568f2500bp+282,    0x1.3b380da523346p-2,         -0x1p-1, INEXACT)
T(RZ,  -0x1.0205a30acff4ap+93,   -0x1.45c4db3e35574p-1,  0x1.a91bccp-28, INEXACT)
T(RU,  -0x1.0205a30acff4ap+93,   -0x1.45c4db3e35574p-1,  0x1.a91bccp-28, INEXACT)
T(RD,  -0x1.0205a30acff4ap+93,   -0x1.45c4db3e35575p-1,         -0x1p+0, INEXACT)
T(RZ,  0x1.9696c358d9494p+819,    0x1.c4a78bbbef4bdp-1,         -0x1p+0, INEXACT)
T(RD,  0x1.9696c358d9494p+819,    0x1.c4a78bbbef4bdp-1,         -0x1p+0, INEXACT)
T(RU,  0x1.9696c358d9494p+819,    0x1.c4a78bbbef4bep-1,  0x1.6191bep-27, INEXACT)
T(RN, 0x1.2839e81c11b87p+1021,    0x1.7e998df0be1fcp+1,         -0x1p-1, INEXACT)
T(RZ,   0x1.3d8f9ec38d91fp+48,   -0x1.b3d4f9ff3cde8p-1,  0x1.d0523cp-28, INEXACT)
T(RU,   0x1.3d8f9ec38d91fp+48,   -0x1.b3d4f9ff3cde8p-1,  0x1.d0523cp-28, INEXACT)
T(RD,   0x1.3d8f9ec38d91fp+48,   -0x1.b3d4f9ff3cde9p-1,         -0x1p+0, INEXACT)
T(RN,  0x1.4ad848dc781b6p+515,   -0x1.6bfba62771858p+0,         -0x1p-1, INEXACT)
T(RZ,   0x1.8abe90995058p+149,    0x1.b950ad4e3e619p-4, -0x1.8739a6p-27, INEXACT)
T(RD,   0x1.8abe90995058p+149,    0x1.b950ad4e3e619p-4, -0x1.8739a6p-27, INEXACT)
T(RU,   0x1.8abe90995058p+149,    0x1.b950ad4e3e61ap-4,          0x1p+0, INEXACT)
T(RZ,  -0x1.4b3c1ef68174p+155,   -0x1.46b89c4e5ea74p-3,   0x1.baddfp-27, INEXACT)
T(RU,  -0x1.4b3c1ef68174p+155,   -0x1.46b89c4e5ea74p-3,   0x1.baddfp-27, INEXACT)
T(RD,  -0x1.4b3c1ef68174p+155,   -0x1.46b89c4e5ea75p-3,         -0x1p+0, INEXACT)
T(RN, -0x1.734d33f5b1753p+710,    0x1.1b61aaa46a089p-1,         -0x1p-1, INEXACT)
T(RZ, -0x1.976de830ffa9fp+619,   -0x1.6b136ff600f92p-2,          0x1p+0, INEXACT)
T(RU, -0x1.976de830ffa9fp+619,   -0x1.6b136ff600f92p-2,          0x1p+0, INEXACT)
T(RD, -0x1.976de830ffa9fp+619,   -0x1.6b136ff600f93p-2, -0x1.c1ce9cp-27, INEXACT)
T(RZ, -0x1.5e418026d4d68p+353,   -0x1.9ab1dd0bd3d88p-2,          0x1p+0, INEXACT)
T(RU, -0x1.5e418026d4d68p+353,   -0x1.9ab1dd0bd3d88p-2,          0x1p+0, INEXACT)
T(RD, -0x1.5e418026d4d68p+353,   -0x1.9ab1dd0bd3d89p-2,   -0x1.90a3p-34, INEXACT)
T(RZ,  0x1.a8e7639491c7dp+337,    0x1.51e370d75bf1ep+1,  -0x1.e51c1p-28, INEXACT)
T(RD,  0x1.a8e7639491c7dp+337,    0x1.51e370d75bf1ep+1,  -0x1.e51c1p-28, INEXACT)
T(RU,  0x1.a8e7639491c7dp+337,    0x1.51e370d75bf1fp+1,          0x1p+0, INEXACT)
T(RZ,  0x1.0ee3891ca8622p+871,    0x1.823b518a4fb84p-1,         -0x1p+0, INEXACT)
T(RD,  0x1.0ee3891ca8622p+871,    0x1.823b518a4fb84p-1,         -0x1p+0, INEXACT)
T(RU,  0x1.0ee3891ca8622p+871,    0x1.823b518a4fb85p-1,  0x1.24510ep-29, INEXACT)
T(RZ,  -0x1.b6953516ff6b6p+61,   -0x1.f23fa3e2f0829p+2,          0x1p+0, INEXACT)
T(RU,  -0x1.b6953516ff6b6p+61,   -0x1.f23fa3e2f0829p+2,          0x1p+0, INEXACT)
T(RD,  -0x1.b6953516ff6b6p+61,   -0x1.f23fa3e2f082ap+2, -0x1.cdce8cp-28, INEXACT)
T(RZ,   0x1.7f166184b9cafp+12,    0x1.38c0fdba67bbbp-3, -0x1.8edca6p-28, INEXACT)
T(RD,   0x1.7f166184b9cafp+12,    0x1.38c0fdba67bbbp-3, -0x1.8edca6p-28, INEXACT)
T(RU,   0x1.7f166184b9cafp+12,    0x1.38c0fdba67bbcp-3,          0x1p+0, INEXACT)
T(RN, -0x1.8fa717f74c217p+440,    0x1.18a17b03a2c45p+1,         -0x1p-1, INEXACT)
T(RZ, -0x1.f5330350a529ep+299,    0x1.d22531b646c9ep-1,         -0x1p+0, INEXACT)
T(RD, -0x1.f5330350a529ep+299,    0x1.d22531b646c9ep-1,         -0x1p+0, INEXACT)
T(RU, -0x1.f5330350a529ep+299,    0x1.d22531b646c9fp-1,  0x1.2c43b4p-32, INEXACT)
T(RZ,  0x1.dc09205f117cfp+797,   -0x1.04a9e9a1d7c17p+1,          0x1p+0, INEXACT)
T(RU,  0x1.dc09205f117cfp+797,   -0x1.04a9e9a1d7c17p+1,          0x1p+0, INEXACT)
T(RD,  0x1.dc09205f117cfp+797,   -0x1.04a9e9a1d7c18p+1, -0x1.80b0bep-29, INEXACT)
T(RZ,  0x1.c65ce4f0a442cp+551,   -0x1.22707fb8bb2d2p-2,  0x1.51a914p-27, INEXACT)
T(RU,  0x1.c65ce4f0a442cp+551,   -0x1.22707fb8bb2d2p-2,  0x1.51a914p-27, INEXACT)
T(RD,  0x1.c65ce4f0a442cp+551,   -0x1.22707fb8bb2d3p-2,         -0x1p+0, INEXACT)
T(RZ,  0x1.fb4380e4e1484p+586,    0x1.26aaaef4eba9dp+2,         -0x1p+0, INEXACT)
T(RD,  0x1.fb4380e4e1484p+586,    0x1.26aaaef4eba9dp+2,         -0x1p+0, INEXACT)
T(RU,  0x1.fb4380e4e1484p+586,    0x1.26aaaef4eba9ep+2,  0x1.d61f6cp-29, INEXACT)
T(RZ, -0x1.9b8ad505d0e9bp+416,    0x1.0cdfd1d693204p+1,         -0x1p+0, INEXACT)
T(RD, -0x1.9b8ad505d0e9bp+416,    0x1.0cdfd1d693204p+1,         -0x1p+0, INEXACT)
T(RU, -0x1.9b8ad505d0e9bp+416,    0x1.0cdfd1d693205p+1,  0x1.64dad8p-32, INEXACT)
T(RN, -0x1.32b023559d3eap+313,    0x1.db0bbb60778d9p-2,         -0x1p-1, INEXACT)
T(RZ,  0x1.b407415e06bacp+166,    0x1.70c414b02b7edp-1,         -0x1p+0, INEXACT)
T(RD,  0x1.b407415e06bacp+166,    0x1.70c414b02b7edp-1,         -0x1p+0, INEXACT)
T(RU,  0x1.b407415e06bacp+166,    0x1.70c414b02b7eep-1,  0x1.5eec4ep-28, INEXACT)
T(RZ,   0x1.55c1e4b5114b6p+63,    0x1.996e70eca3916p-3, -0x1.0d2b4cp-27, INEXACT)
T(RD,   0x1.55c1e4b5114b6p+63,    0x1.996e70eca3916p-3, -0x1.0d2b4cp-27, INEXACT)
T(RU,   0x1.55c1e4b5114b6p+63,    0x1.996e70eca3917p-3,          0x1p+0, INEXACT)
T(RZ,  0x1.3ff0fb8c60436p+965,    0x1.5f4a98bc2432fp-2,         -0x1p+0, INEXACT)
T(RD,  0x1.3ff0fb8c60436p+965,    0x1.5f4a98bc2432fp-2,         -0x1p+0, INEXACT)
T(RU,  0x1.3ff0fb8c60436p+965,     0x1.5f4a98bc2433p-2,  0x1.d03a4cp-27, INEXACT)
T(RN,   -0x1.8d27bb9db3d1ep+3,    0x1.4092fd74d48b3p-3,         -0x1p-1, INEXACT)
T(RN,  -0x1.ec68fb18c0f28p+89,   -0x1.4ff4bf158b922p+0,         -0x1p-1, INEXACT)
T(RN, -0x1.a0f13d9e15dadp+350,    0x1.048e8278cb89fp+0,         -0x1p-1, INEXACT)
T(RN,  0x1.2eb08bd9c5a3cp+397,    0x1.250504dbf1e97p-1,         -0x1p-1, INEXACT)
T(RN,  0x1.d51a734258c7fp+187,   -0x1.38caf45da4b82p-1,         -0x1p-1, INEXACT)
T(RN, -0x1.1c8ed9df186e2p+407,    0x1.d3e4c25683e28p-1,         -0x1p-1, INEXACT)
T(RN,  0x1.e9a229322ed94p+417,    0x1.3e0e8bfead993p+3,         -0x1p-1, INEXACT)
T(RN,  -0x1.fa34a725aedc2p+23,    0x1.38f3778d89ba6p+0,         -0x1p-1, INEXACT)
T(RN,  0x1.098310a411a9ep+729,   -0x1.5dcc5187bae97p-1,         -0x1p-1, INEXACT)
T(RN,  0x1.3fe2d3c005523p+550,    0x1.c0c3f43c8e3dap+0,         -0x1p-1, INEXACT)
T(RN,  0x1.e2f399ecdd1a5p+259,    0x1.48f8eef394eb6p+0,         -0x1p-1, INEXACT)
T(RN, -0x1.0a72d919a0455p+252,    -0x1.95a01ae344aap-8,         -0x1p-1, INEXACT)
T(RN,    0x1.a48e82e285edp+80,    0x1.a11a5585366a6p-2,         -0x1p-1, INEXACT)
T(RN, -0x1.f4db5a10e7e19p+696,   -0x1.fd974b606edaep+1,         -0x1p-1, INEXACT)
T(RZ,  0x1.40d5fb493a129p+238,    0x1.3d5746f82da2bp-1,         -0x1p+0, INEXACT)
T(RD,  0x1.40d5fb493a129p+238,    0x1.3d5746f82da2bp-1,         -0x1p+0, INEXACT)
T(RU,  0x1.40d5fb493a129p+238,    0x1.3d5746f82da2cp-1,   0x1.c2fe2p-28, INEXACT)
T(RZ, -0x1.20844248a63a6p+886,    0x1.088544385b9ebp-3,         -0x1p+0, INEXACT)
T(RD, -0x1.20844248a63a6p+886,    0x1.088544385b9ebp-3,         -0x1p+0, INEXACT)
T(RU, -0x1.20844248a63a6p+886,    0x1.088544385b9ecp-3,   0x1.cac15p-28, INEXACT)
T(RN,  -0x1.0aeea6232f11p+503,   -0x1.2adf739cab586p-1,         -0x1p-1, INEXACT)
T(RN, -0x1.4a7695eca05bfp+432,   -0x1.b4291177826b7p-7,         -0x1p-1, INEXACT)
T(RN,    0x1.c6e550b254496p+0,   -0x1.320ede10bb8c4p+2,  -0x1.901d34p-3, INEXACT)
T(RN,   0x1.86c04bf2ea138p-20,   0x1.86c04bf2eb42fp-20,  -0x1.5bdd8cp-2, INEXACT)
T(RN,   0x1.78b5906fb8272p-12,   0x1.78b5917f9fe77p-12,   -0x1.9d4c4p-2, INEXACT)
T(RN,    0x1.0bc34f9361c4dp+2,     0x1.b655a75128d5p+0,   0x1.53d1eep-3, INEXACT)
T(RN,    0x1.b350d378d9f6p+26,   -0x1.e16001a2e0acep-2,   0x1.f7ad8ap-2, INEXACT)
T(RN,   0x1.4b1564d6fbbbep-20,   0x1.4b1564d6fc747p-20,  -0x1.db29b6p-2, INEXACT)
T(RN,   0x1.10ebaa93c984bp+12,   -0x1.5b87dd8628161p-4,   0x1.902d76p-2, INEXACT)
T(RN,   0x1.8f41d37aeca0fp-17,   0x1.8f41d37b3d8e7p-17,    0x1.8c0aep-2, INEXACT)
T(RN,    0x1.9c27604cff108p-1,    0x1.0a3b509d8b469p+0,  -0x1.e7ab04p-2, INEXACT)
T(RN,   0x1.79246b39b7851p-23,   0x1.79246b39b7895p-23,  -0x1.b02176p-3, INEXACT)
T(RN,   0x1.160a26e860424p-25,   0x1.160a26e860426p-25,   0x1.2acd42p-2, INEXACT)
T(RN,    0x1.51e6115717339p-7,    0x1.51e92247e90a7p-7,   0x1.0b09a8p-5, INEXACT)
T(RN,   0x1.9a047ce83a206p-14,   0x1.9a047cfe23a6cp-14,   0x1.5bed2cp-3, INEXACT)
T(RN,    0x1.145618fb22c6ap-8,    0x1.1456844f47712p-8,  -0x1.790deep-2, INEXACT)
T(RN,   0x1.e076f83e27d8bp+28,   -0x1.2605ce1b63d52p-1,  -0x1.48dd86p-3, INEXACT)
T(RN,    0x1.156a8ab09278fp+2,     0x1.4290ad76851ap+1,   0x1.7d51cep-3, INEXACT)
T(RN,   0x1.d9297f1b99d86p+15,    0x1.0be7c0623d924p+1,   0x1.faa97ep-2, INEXACT)
T(RN,    0x1.b1095b36e45cbp+8,   -0x1.19dd08e082067p-1,  -0x1.f8a808p-2, INEXACT)
T(RN,   0x1.f6c7a9edcdcfap+15,    0x1.43efdb298b333p-2,  -0x1.f86f22p-3, INEXACT)
T(RN,   0x1.b08691634b13bp+16,    0x1.12c5434a502e2p+1,   0x1.2183a2p-2, INEXACT)
T(RN,   0x1.3dadca3b4cb27p+19,    0x1.05757430d11f5p+2,   0x1.e78c44p-5, INEXACT)
T(RN,   0x1.235facef2f1e3p-21,   0x1.235facef2f3dap-21,  -0x1.1f1b4ep-2, INEXACT)
T(RN,    0x1.6ac143426aca7p+7,   -0x1.1ab1328b0fd5cp+0,  -0x1.1de3c4p-6, INEXACT)
T(RN,   0x1.e3ebb592844a1p-12,   0x1.e3ebb7d2e9de6p-12,   0x1.36c14cp-3, INEXACT)
T(RN,   0x1.cc0e2a777f018p-10,    0x1.cc0e496b96bdp-10,   0x1.4920f8p-3, INEXACT)
T(RN,   0x1.ed6097bfb0b93p+24,    0x1.e3b195f574196p-2,   0x1.fa585ep-3, INEXACT)
T(RN,    0x1.2256693b7e984p+1,   -0x1.31807b056c4ffp+0,   0x1.a942ecp-3, INEXACT)
T(RN,    0x1.10861901efb82p-6,    0x1.108c885614d53p-6,   0x1.006a62p-2, INEXACT)
T(RN,    0x1.4e1ea4f33e8a8p+6,   -0x1.c0fbd763c2adep+1,    0x1.bcff8p-5, INEXACT)
T(RN,   0x1.0c24eeb5e1cb9p+17,   -0x1.32ee9d8b8a183p+0,   0x1.b70b16p-2, INEXACT)
T(RN,   0x1.bf07718cbc514p+25,   -0x1.8495c87478fcep+1,  -0x1.6c5d2ep-7, INEXACT)
T(RN,   0x1.162d745535c26p+22,   -0x1.ee423cc610125p+1,  0x1.7a9798p-10, INEXACT)
T(RN,   0x1.e37a314ee0c9ep+21,   -0x1.2fd5523b5dab5p-1,  -0x1.6b3188p-4, INEXACT)
T(RN,   0x1.5a2e088411956p+10,   -0x1.c3ddab4cd9a9cp-1,   0x1.c6ecfep-9, INEXACT)
T(RN,   0x1.5e2965b40aef1p+15,   -0x1.b5792a770d281p-2,   0x1.97bccep-2, INEXACT)
T(RN,    0x1.dcb61ee603d33p+4,    0x1.3b8425c1534f7p+4,   0x1.300354p-2, INEXACT)
T(RN,    0x1.4c634cbf7e118p-7,    0x1.4c6637e7db031p-7,   0x1.e5c8bap-3, INEXACT)
T(RN,    0x1.4a490f4c67a94p-9,    0x1.4a493d1d0dbe3p-9,   0x1.39b912p-2, INEXACT)
T(RN,   0x1.0dbef1f5a1caep-18,   0x1.0dbef1f5a8083p-18,   0x1.8fd042p-2, INEXACT)
T(RN,   0x1.7674ec15fb6cap+19,   -0x1.26604526420b6p-1,  -0x1.f662e8p-4, INEXACT)
T(RN,    0x1.f6087bf4fdaa4p-6,    0x1.f630b8f33bd5fp-6,  -0x1.609454p-2, INEXACT)
T(RN,    0x1.c371338e1e654p-3,    0x1.cae623094177dp-3,   0x1.a654c2p-2, INEXACT)
T(RN,   0x1.927d62a7c0be2p+28,    0x1.8ba636362fd3ep-1,   0x1.44e134p-4, INEXACT)
T(RN,   0x1.95567f46610e6p-23,   0x1.95567f466113bp-23,   0x1.45c60ep-2, INEXACT)
T(RN,   0x1.c2ccd8fe2c475p-18,   0x1.c2ccd8fe4966bp-18,  -0x1.b7eb9ep-2, INEXACT)
T(RN,   0x1.5506af7501ae7p+27,    0x1.4ffc8c8fe69bbp+3,   0x1.7038bcp-2, INEXACT)
T(RN,   0x1.2612d9dfe2b5fp+14,   -0x1.4752e6e581377p-1,  -0x1.8aa15cp-3, INEXACT)
T(RN,    0x1.79aff5550ae16p-6,    0x1.79c116b9546c8p-6,   0x1.407526p-5, INEXACT)
T(RN,   0x1.ae57c1b54f2c8p+16,    0x1.6dd763edc61dap+4,   0x1.6f2112p-2, INEXACT)
T(RN,    0x1.56b668a21a59p+15,    0x1.1b14648b908cfp+1,  -0x1.a37d92p-2, INEXACT)
T(RN,  -0x1.3ee9dec321601p+27,    0x1.75756032230dep+0,  -0x1.d4a2d2p-3, INEXACT)
T(RN,  -0x1.b80b545db098ap-29,  -0x1.b80b545db098ap-29,   0x1.b16624p-6, INEXACT)
T(RN,  -0x1.1e4a22547e858p-11,  -0x1.1e4a2431e2fa9p-11,  -0x1.c059a6p-3, INEXACT)
T(RN,  -0x1.4988c99a929a7p+15,    -0x1.3bb651616c59p+2,   -0x1.df793p-5, INEXACT)
T(RN,    -0x1.8cbe84b29ebp-16,   -0x1.8cbe84b3dc53p-16,  -0x1.08abbcp-2, INEXACT)
T(RN,   -0x1.476c17f488333p+5,   -0x1.6590d16270565p-4,   0x1.5a0014p-3, INEXACT)
T(RN,  -0x1.9f2ce6fec4796p-28,  -0x1.9f2ce6fec4796p-28,   0x1.6bfe58p-4, INEXACT)
T(RN,  -0x1.34989496667dfp+27,   -0x1.03b0dbd5b1113p+4,    0x1.387ddp-4, INEXACT)
T(RN,  -0x1.23093ebcac034p-11,  -0x1.230940b234755p-11,   0x1.e95ff8p-2, INEXACT)
T(RN,  -0x1.92419d820d2f7p-27,  -0x1.92419d820d2f7p-27,    0x1.4b0f8p-2, INEXACT)
T(RN,   -0x1.7042a43e5aadep-4,   -0x1.71417baa370cbp-4,    0x1.56463p-2, INEXACT)
T(RN,  -0x1.c2fffeaea65aep+24,    0x1.ff0161770fb47p-2,  -0x1.ec07f6p-3, INEXACT)
T(RN,   -0x1.3fa4cf0fcf79fp+4,   -0x1.0e0dbadc0b2dfp+1,  -0x1.b8b40ap-8, INEXACT)
T(RN,  -0x1.27d2e9ed2918ap-23,  -0x1.27d2e9ed291abp-23,  -0x1.4e4ba8p-4, INEXACT)
T(RN,   -0x1.208428e382381p+4,    0x1.10df64e44a684p+0,   0x1.2c45b4p-3, INEXACT)
T(RN,  -0x1.20d2d22e39094p-15,  -0x1.20d2d23023379p-15,   0x1.8452cap-2, INEXACT)
T(RN,   -0x1.af5b008460b5cp-1,   -0x1.1f0990acfd80ap+0,   0x1.3f3c8cp-5, INEXACT)
T(RN,  -0x1.321fbacb9f7fap-16,  -0x1.321fbacc31691p-16,   0x1.299dcap-3, INEXACT)
T(RN,   -0x1.8a4d1a4ad30e3p-2,   -0x1.9f04c1dea226dp-2,  -0x1.73e1e8p-7, INEXACT)
T(RN,   -0x1.4e13d0fb53db1p-6,   -0x1.4e1fabcc32c1cp-6,   0x1.e487b2p-2, INEXACT)
T(RN,  -0x1.3c15eb2ad6cfcp+22,    -0x1.64c6567ce4b3p+0,  -0x1.c5e06ep-2, INEXACT)
T(RN,   -0x1.8cca4e4ae2652p-5,   -0x1.8d19d1381416fp-5,  -0x1.918e36p-2, INEXACT)
T(RN,   -0x1.6fc680f1491cfp-9,   -0x1.6fc6c03251962p-9,  -0x1.bbed5ep-2, INEXACT)
T(RN,   -0x1.ebf6f2fb7610dp-8,   -0x1.ebf9509dc7324p-8,  -0x1.1704cap-5, INEXACT)
T(RN,  -0x1.9afed1a9cd3eep-28,  -0x1.9afed1a9cd3eep-28,   0x1.611c16p-4, INEXACT)
T(RN,  -0x1.a14fe855c3d77p-21,  -0x1.a14fe855c433ep-21,   -0x1.b86d7p-2, INEXACT)
T(RN,   -0x1.434b0c937194ep+1,    0x1.6a55a3c891a76p-1,   0x1.465884p-2, INEXACT)
T(RN,  -0x1.aff4c442df5bdp+11,    0x1.a739db7755269p-4,   0x1.11f9fep-9, INEXACT)
T(RN,   -0x1.e03236cb6e21p-25,  -0x1.e03236cb6e219p-25,  -0x1.99ec9cp-3, INEXACT)
T(RN,   -0x1.0cc21c8cbc155p-6,   -0x1.0cc8488704955p-6,   0x1.e17444p-3, INEXACT)
T(RN,  -0x1.4638519362716p+16,     0x1.7c4bd18dc0ebp-1,   0x1.c76286p-2, INEXACT)
T(RN,  -0x1.ac06c4552ba69p-16,  -0x1.ac06c456ba806p-16,   0x1.485224p-2, INEXACT)
T(RN,  -0x1.8454220d6b801p-10,  -0x1.845434ab04bddp-10,   -0x1.091d7p-2, INEXACT)
T(RN,   -0x1.cef0a0e26509p-17,  -0x1.cef0a0e2e3315p-17,  -0x1.79b112p-3, INEXACT)
T(RN,  -0x1.e215339c6c76cp-13,  -0x1.e215342ae322ap-13,   0x1.9e7b14p-3, INEXACT)
T(RN,  -0x1.3dfa189506364p-12,  -0x1.3dfa19388cc2ap-12,   0x1.a25dd6p-2, INEXACT)
T(RN,  -0x1.1c9634d834288p+23,   -0x1.c22a49eef5144p+1,   0x1.4cb9f6p-2, INEXACT)
T(RN,  -0x1.39ed5ea69d2ebp-28,  -0x1.39ed5ea69d2ebp-28,   0x1.3ab6bap-5, INEXACT)
T(RN,   -0x1.06bff857b6104p+9,   -0x1.25a6f6101aeb2p+0,  -0x1.524fcep-2, INEXACT)
T(RN,   -0x1.ea1b44933362ep-7,   -0x1.ea249fecf74e9p-7,  -0x1.b1a14cp-2, INEXACT)
T(RN,  -0x1.7488142b9797bp+10,   -0x1.98cbb67630c2ep+0,  -0x1.ad7a48p-4, INEXACT)
T(RN,  -0x1.e06381b3c868ep+13,   -0x1.71c58adf67083p-1,   0x1.69311ep-2, INEXACT)
T(RN,  -0x1.21ae2d295a3e4p+26,   -0x1.1e65b784c627cp+2,  -0x1.4f0666p-2, INEXACT)
T(RN,  -0x1.095a282433a19p-16,  -0x1.095a282492a99p-16,   0x1.2d2b44p-2, INEXACT)
T(RN,  -0x1.2e641af503b7fp+20,    0x1.534008490d12ep+1,   0x1.2a723ap-2, INEXACT)
T(RN,    -0x1.ea4847f35fep+27,   -0x1.5eb79d8340c2ap-1,   0x1.6dc74ap-5, INEXACT)
T(RN,  -0x1.94fdfa12b606cp+16,    0x1.2bb7ca9f2b4a1p+0,  -0x1.bca728p-3, INEXACT)
T(RN,   -0x1.df157f3dfe3fcp-5,   -0x1.dfa18290c751dp-5,  -0x1.49ed68p-3, INEXACT)
T(RN,  -0x1.541a7de4acdd5p+10,   -0x1.acd498d7f65bep-4,   0x1.dfcee2p-2, INEXACT)
T(RN,  -0x1.69e161cd48512p+18,    0x1.ad81ddca18bacp+0,  -0x1.75a7ecp-2, INEXACT)
T(RN,    0x1.3fffffffffffcp+3,    0x1.4bf5f34be3727p-1,  -0x1.da798cp-2, INEXACT)
T(RN,    0x1.43d1362484911p-2,    0x1.4f0fa4ee44349p-2,   0x1.9e8342p-2, INEXACT)
T(RN,    0x1.3ffffffffffe6p+3,    0x1.4bf5f34be3533p-1,   -0x1.f8505p-2, INEXACT)
T(RN,    0x1.2aa4313bf7ce2p+3,   -0x1.7ade8e5ed0528p-4,  -0x1.f64f54p-2, INEXACT)
T(RN,    0x1.16b5565895b62p+3,   -0x1.bcad439318b24p-1,  -0x1.f62942p-2, INEXACT)
T(RN,    0x1.041b136d24fb9p+3,   -0x1.c6d6b6b93734bp+1,   0x1.fbf51ap-2, INEXACT)
T(RN,    0x1.e57d599292c32p+2,    0x1.d1bf21448b11ap+1,   0x1.ffec2ap-2, INEXACT)
T(RN,    0x1.c515d65a2d64ap+2,    0x1.05a10d9ee670ap+0,   -0x1.f941cp-2, INEXACT)
T(RN,    0x1.a6d803b7af691p+2,    0x1.579bdcad9f37fp-2,   0x1.fdb924p-2, INEXACT)
T(RN,    0x1.8a9eecd3ae23dp+2,   -0x1.e2686972e3874p-4,  -0x1.fc0feep-2, INEXACT)
T(RN,    0x1.7048144f303bdp+2,   -0x1.2b27b5100d014p-1,   0x1.fd95c4p-2, INEXACT)
T(RN,    0x1.57b34a1dce4f4p+2,   -0x1.4b44376e9f4cbp+0,  -0x1.fb48aep-2, INEXACT)
T(RN,    0x1.40c28430012e7p+2,   -0x1.9e8c35f020942p+1,   0x1.fa6a08p-2, INEXACT)
T(RN,    0x1.2b59b9bd8bcfap+2,    0x1.c8774030a3abfp+4,   0x1.f7c27ap-2, INEXACT)
T(RN,    0x1.175ec10324f18p+2,    0x1.61b205d97c967p+1,  -0x1.fd7f06p-2, INEXACT)
T(RN,    0x1.04b92f4982985p+2,    0x1.58d9f95db78b7p+0,   -0x1.f74ecp-2, INEXACT)
T(RN,    0x1.e6a4761d69f92p+1,    0x1.8d9ceb654cb62p-1,   0x1.fe8cf4p-2, INEXACT)
T(RN,    0x1.c629405ab4a35p+1,    0x1.b8db9abf4b02ap-2,  -0x1.fb82a8p-2, INEXACT)
T(RN,    0x1.a7d90bbf47135p+1,     0x1.5ef5b76b94dbp-3,   -0x1.fdba5p-2, INEXACT)
T(RN,    0x1.8b8eccfccfe02p+1,   -0x1.a49887998ed5ap-5,   0x1.fb9da4p-2, INEXACT)
T(RN,    0x1.7127f1bd47ffcp+1,   -0x1.0dbbd1ec86502p-2,  -0x1.fb07ecp-2, INEXACT)
T(RN,    0x1.5884366374b6bp+1,    -0x1.eeb8b0f2ea71p-2,   0x1.f89f42p-2, INEXACT)
T(RN,    0x1.41857e9d4cc4bp+1,   -0x1.75138fed9b9dap-1,  -0x1.fbc116p-2, INEXACT)
T(RN,    0x1.2c0fb09811e5ap+1,    -0x1.06336f78b3c1p+0,  -0x1.ffd8c8p-2, INEXACT)
T(RN,    0x1.180892a927516p+1,   -0x1.68e66eff38c5fp+0,  -0x1.f6b2a6p-2, INEXACT)
T(RN,    0x1.0557ab41adc7fp+1,   -0x1.f6cc393788f5fp+0,   0x1.fa33fep-2, INEXACT)
T(RN,    0x1.e7cc460b76ff2p+0,   -0x1.70160019b3331p+1,   0x1.fae43cp-2, INEXACT)
T(RN,    0x1.c73d51c544707p+0,   -0x1.300513000bc96p+2,  -0x1.fbc4fcp-2, INEXACT)
T(RN,    0x1.a8dab00450657p+0,    -0x1.6773742e854fp+3,   -0x1.faa9ep-2, INEXACT)
T(RN,    0x1.8c7f3ef5baf61p+0,    0x1.6be9d8e434e8bp+5,   0x1.f90b68p-2, INEXACT)
T(RN,    0x1.7208573fb0fdfp+0,    0x1.fbdddae6f1d22p+2,  -0x1.fa885ep-2, INEXACT)
T(RN,    0x1.5955a1a83fc06p+0,    0x1.1bc1b6af9c99ep+2,  -0x1.fda3a2p-2, INEXACT)
T(RN,    0x1.4248ef8fc25f7p+0,    0x1.8d085acfd566bp+1,  -0x1.f937bep-2, INEXACT)
T(RN,    0x1.2cc6160e9d999p+0,    0x1.323e7e1691e5bp+1,   0x1.fe4974p-2, INEXACT)
T(RN,    0x1.18b2cb8936482p+0,    0x1.f2a06a9783357p+0,  -0x1.f83ceap-2, INEXACT)
T(RN,    0x1.05f68790125f3p+0,    0x1.a3e548a981b3fp+0,   -0x1.f6f8fp-2, INEXACT)
T(RN,    0x1.e8f4c9c9c4dd9p-1,    0x1.69ca38ce53386p+0,  -0x1.f75a94p-2, INEXACT)
T(RN,    0x1.c8520affa0a21p-1,    0x1.3cddf88fcad0fp+0,  -0x1.fa6068p-2, INEXACT)
T(RN,    0x1.a9dcf0e5c4654p-1,    0x1.18e98014da604p+0,   0x1.fee808p-2, INEXACT)
T(RN,    0x1.8d70431711adep-1,    0x1.f6b6cba901c2dp-1,   0x1.ff2552p-2, INEXACT)
T(RN,    0x1.72e94529230a4p-1,    0x1.c517c33f6be41p-1,   0x1.f98f18p-2, INEXACT)
T(RN,    0x1.5a278c3961be9p-1,    0x1.9aba641f26f69p-1,   0x1.f60c18p-2, INEXACT)
T(RN,    0x1.430cd74f6d46fp-1,    0x1.760ed9112cbc5p-1,  -0x1.fe0a24p-2, INEXACT)
T(RN,    0x1.2d7cea646b2fcp-1,    0x1.55f4a7e6c06dbp-1,   0x1.f731e8p-2, INEXACT)
T(RN,    0x1.195d6be2112d4p-1,    0x1.39962674dea6ap-1,   0x1.f5ee6ep-2, INEXACT)
T(RN,    0x1.0695c46f3f98ap-1,    0x1.20517300883acp-1,   0x1.fea98cp-2, INEXACT)
T(RN,    0x1.ea1e01c5a0f5fp-2,    0x1.09a971be9a71bp-1,  -0x1.fc66dap-2, INEXACT)
T(RN,    0x1.c9676c6fcaeffp-2,    0x1.ea7775a631dcap-2,  -0x1.fba226p-2, INEXACT)
T(RN,    0x1.aadfcec2d5c5ep-2,    0x1.c573591689282p-2,   0x1.ffce0cp-2, INEXACT)
T(RN,    0x1.8e61d9b9ac0abp-2,    0x1.a3c7174ed5b69p-2,   0x1.fc9fbap-2, INEXACT)
T(RN,    0x1.73cabbcc880eap-2,    0x1.850a08be639ffp-2,    0x1.fea2fp-2, INEXACT)
T(RN,    0x1.5af9f6643bfcfp-2,    0x1.68e53a50454a7p-2,  -0x1.f807fep-2, INEXACT)
T(RN,    0x1.43d13624848f4p-2,    0x1.4f0fa4ee44328p-2,  -0x1.f6149ep-2, INEXACT)
T(RN,    0x1.2e342ddcdfcdcp-2,    0x1.374b556ca8d85p-2,   0x1.ff46d6p-2, INEXACT)
T(RN,    0x1.1a0873f29de31p-2,    0x1.2163423454d49p-2,   0x1.f64b7ep-2, INEXACT)
T(RN,    0x1.07356219e84dep-2,     0x1.0d29a04bee16p-2,   0x1.f6c31cp-2, INEXACT)
T(RN,    0x1.eb47ee6c9b028p-3,    0x1.f4ed2df1b3b83p-3,  -0x1.faa42ap-2, INEXACT)
T(RN,    0x1.ca7d767c030c6p-3,    0x1.d24e74ea424d2p-3,   0x1.fb91f2p-2, INEXACT)
T(RN,    0x1.abe349faf1238p-3,    0x1.b2397945bc6adp-3,  -0x1.f7f9e8p-2, INEXACT)
T(RN,    0x1.8f54033698296p-3,    0x1.94778e52dd718p-3,   0x1.fdcb8cp-2, INEXACT)
T(RN,    0x1.74acbb7cfc847p-3,    0x1.78d7eb40bb4fcp-3,  -0x1.fba746p-2, INEXACT)
T(RN,    0x1.5bcce0765ec61p-3,    0x1.5f2ed17d23e8ap-3,  -0x1.f5ccd6p-2, INEXACT)
T(RN,    0x1.44960c576b35ap-3,    0x1.4754da6d1e32ap-3,   0x1.fa8caap-2, INEXACT)
T(RN,    0x1.2eebe0bb89904p-3,    0x1.312664524f4e3p-3,   0x1.fd8254p-2, INEXACT)
T(RN,    0x1.1ab3e3f9e7e8dp-3,    0x1.1c83180e125b9p-3,    0x1.f7f93p-2, INEXACT)
T(RN,    0x1.07d560cae30dfp-3,    0x1.094d82daceef5p-3,  -0x1.fe39c4p-2, INEXACT)
T(RN,    0x1.ec72902c8566fp-4,    0x1.eed5804a3a363p-4,   0x1.f74f44p-2, INEXACT)
T(RN,    0x1.cb94298ac6cffp-4,    0x1.cd8460fe30212p-4,   0x1.fe414ep-2, INEXACT)
T(RN,    0x1.ace762edbd0b6p-4,    0x1.ae7a76924011fp-4,   0x1.f86c1ap-2, INEXACT)
T(RN,    0x1.9046bfe71a42fp-4,    0x1.918e32501f745p-4,   0x1.fbcb82p-2, INEXACT)
T(RN,    0x1.758f448dcf4bcp-4,    0x1.76994b84850d2p-4,   0x1.fa262ap-2, INEXACT)
T(RN,    0x1.5ca04abd89893p-4,    0x1.5d786f1258aecp-4,   0x1.f6be3ap-2, INEXACT)
T(RN,    0x1.455b5a30b0332p-4,    0x1.460af923081c9p-4,   0x1.fb1188p-2, INEXACT)
T(RN,    0x1.2fa403441fa82p-4,    0x1.3032b75786a06p-4,   0x1.f702f2p-2, INEXACT)
T(RN,    0x1.1b5fbc372173ap-4,    0x1.1bd3b22985b97p-4,   0x1.f8bfe4p-2, INEXACT)
T(RN,    0x1.0875c0bd2a29ap-4,    0x1.08d3fc694149ep-4,   0x1.f67e42p-2, INEXACT)
T(RN,    0x1.ed9de773753cbp-5,    0x1.ee370fea08ee6p-5,   0x1.f60f28p-2, INEXACT)
T(RN,    0x1.ccab8602d265fp-5,    0x1.cd27fdddbef1ep-5,   0x1.f85eb8p-2, INEXACT)
T(RN,    0x1.adec19fb1a43ep-5,    0x1.ae5141a99d99cp-5,   0x1.f759aep-2, INEXACT)
T(RN,    0x1.913a1024acba4p-5,    0x1.918c45f2c82cap-5,    0x1.f80bap-2, INEXACT)
T(RN,    0x1.7672575282003p-5,    0x1.76b527e00337ap-5,    0x1.f722ap-2, INEXACT)
T(RN,    0x1.5d743587aaee7p-5,    0x1.5daa8321ca225p-5,   0x1.f5eb78p-2, INEXACT)
T(RN,    0x1.46211ff90e8cfp-5,    0x1.464d428ea7ff2p-5,   0x1.f600eep-2, INEXACT)
T(RN,    0x1.305c95ba824b2p-5,    0x1.308074cf9f247p-5,   0x1.f69048p-2, INEXACT)
T(RN,    0x1.1c0bfce9a3186p-5,    0x1.1c2924ab945b9p-5,   0x1.f5c46cp-2, INEXACT)
T(RN,     0x1.0916822bdbbdp-5,    0x1.092e34908b201p-5,    0x1.f63a1p-2, INEXACT)
T(RN,    0x1.eec9f4afc2a6cp-6,    0x1.eef07a0d742e8p-6,   0x1.f67ec2p-2, INEXACT)
T(RN,    0x1.cdc38c4b20519p-6,    0x1.cde2db8904a5fp-6,   0x1.f66b8cp-2, INEXACT)
T(RN,    0x1.aef16f8323a67p-6,    0x1.af0ae24736bbfp-6,   0x1.f611ecp-2, INEXACT)
T(RN,    0x1.922df449005cfp-6,    0x1.9242a37f1ef7fp-6,   0x1.f6595cp-2, INEXACT)
T(RN,    0x1.7755f41ec8c64p-6,    0x1.7766c41885083p-6,   0x1.f62e94p-2, INEXACT)
T(RN,    0x1.5e48a122e13a4p-6,    0x1.5e564b71b1bdfp-6,   0x1.f5dc82p-2, INEXACT)
T(RN,    0x1.46e75df96d3f5p-6,    0x1.46f27970493cfp-6,   0x1.f5f278p-2, INEXACT)
T(RN,    0x1.31159862bb34ap-6,    0x1.311e9f97bc854p-6,   0x1.f5ca28p-2, INEXACT)
T(RN,    0x1.1cb8a650ebd8cp-6,    0x1.1cbffce6efa22p-6,   0x1.f60ee6p-2, INEXACT)
T(RN,    0x1.09b7a5523993ep-6,    0x1.09bd9c44f822cp-6,   0x1.f5e86ap-2, INEXACT)
T(RN,    0x1.eff6b85008986p-7,    0x1.f0006a94430e3p-7,   0x1.f5c6d2p-2, INEXACT)
T(RN,    0x1.cedc3ccae9116p-7,    0x1.cee41e6e4493dp-7,   0x1.f5e128p-2, INEXACT)
T(RN,    0x1.aff763e62e65ep-7,    0x1.affdcbe14d45bp-7,   0x1.f5ef2ep-2, INEXACT)
T(RN,    0x1.93226cadfcbf1p-7,    0x1.9327a1b1b9562p-7,   0x1.f5c34cp-2, INEXACT)
T(RN,    0x1.783a1b468a434p-7,    0x1.783e56c832c3ap-7,   0x1.f5d1f8p-2, INEXACT)
T(RN,    0x1.5f1d8ddd78ea8p-7,    0x1.5f20fe90f699ep-7,   0x1.f5d208p-2, INEXACT)
T(RN, -0x1.7e43c880074c6p+996,   -0x1.0e1d0305b7b72p+2,    0x1.ffc65p-2, INEXACT)
T(RN, -0x1.1a0fc668aaafdp+930,   -0x1.18fa89f1774eap+0,  -0x1.fd0f8ap-2, INEXACT)
T(RN, -0x1.a03fde214cb18p+863,   -0x1.0533567d9648ep-3,   -0x1.fdd35p-2, INEXACT)
T(RN, -0x1.33234de7ad755p+797,    0x1.34b9e5d86b961p-2,  -0x1.f8a21cp-2, INEXACT)
T(RN, -0x1.c5416bb92e3bep+730,    -0x1.763ad9f85824p-2,  -0x1.fdc00ap-2, INEXACT)
T(RN, -0x1.4e718d7d76288p+664,    0x1.60cc62930e3f3p+2,   0x1.fb12cep-2, INEXACT)
T(RN, -0x1.ed8d34e54721cp+597,   -0x1.14201641d2e0bp-1,  -0x1.fe77e4p-2, INEXACT)
T(RN, -0x1.6c2d4256ffce4p+531,    0x1.8cd3dc41980ccp-2,   0x1.f9d5fcp-2, INEXACT)
T(RN, -0x1.0cb70d24b73d8p+465,    0x1.1875e62c01e1bp+2,   0x1.f8ac4cp-2, INEXACT)
T(RN, -0x1.8c8dac6a03561p+398,   -0x1.9846e443e97a9p+2,   0x1.f8fdc4p-2, INEXACT)
T(RN,    0x1.3ffffffffffe6p+3,    0x1.4bf5f34be3533p-1,   -0x1.f8505p-2, INEXACT)
T(RN,    0x1.fc5ebcec1353bp+2,    -0x1.6563026488b1p+3,  -0x1.fa763ep-2, INEXACT)
T(RN,    0x1.93d00d2348961p+2,    0x1.b0719181a873ap-6,   -0x1.f8fe4p-2, INEXACT)
T(RN,    0x1.40c28430012e7p+2,   -0x1.9e8c35f020942p+1,   0x1.fa6a08p-2, INEXACT)
T(RN,    0x1.fd93c1f526da1p+1,    0x1.1d4d7e0978546p+0,   0x1.fb99eep-2, INEXACT)
T(RN,    0x1.94c583ada5b49p+1,    0x1.52f394f25f076p-6,   0x1.f8cb32p-2, INEXACT)
T(RN,    0x1.41857e9d4cc4bp+1,   -0x1.75138fed9b9dap-1,  -0x1.fbc116p-2, INEXACT)
T(RN,    0x1.fec982d5bb8aap+0,    -0x1.1b3936b35a03p+1,   -0x1.fbbcep-2, INEXACT)
T(RN,    0x1.95bb8f6d4604ap+0,   -0x1.1bbb72f93d7b2p+6,   0x1.f86584p-2, INEXACT)
T(RN,    0x1.4248ef8fc25f7p+0,    0x1.8d085acfd566bp+1,  -0x1.f937bep-2, INEXACT)
T(RN,    0x1.3fffffffffd76p+3,    0x1.4bf5f34bdfdcfp-1,   0x1.ff2a08p-2, INEXACT)
T(RN,     0x1.fc5ebcec1334p+2,    -0x1.656302649079p+3,   0x1.ff45a2p-2, INEXACT)
T(RN,    0x1.93d00d2348945p+2,    0x1.b0719181a6b35p-6,  -0x1.ff81d2p-2, INEXACT)
T(RN,    0x1.40c2843000fbep+2,    -0x1.9e8c35f0251ep+1,  -0x1.ff2c6cp-2, INEXACT)
T(RN,    0x1.fd93c1f526a33p+1,    0x1.1d4d7e09775e5p+0,   0x1.ff292ep-2, INEXACT)
T(RN,    0x1.94c583ada595cp+1,    0x1.52f394f24f9dap-6,  -0x1.ff08cep-2, INEXACT)
T(RN,    0x1.41857e9d4a759p+1,   -0x1.75138feda9c18p-1,   0x1.fefd14p-2, INEXACT)
T(RN,     0x1.fec982d5bb7bp+0,   -0x1.1b3936b35a311p+1,  -0x1.ffc944p-2, INEXACT)
T(RN,    0x1.95bb8f6d46019p+0,   -0x1.1bbb72f93e6bfp+6,   0x1.ff24c4p-2, INEXACT)
T(RN,    0x1.4248ef8fc23bap+0,    0x1.8d085acfd4a88p+1,  -0x1.ff0aeap-2, INEXACT)
T(RN,  0x1.7e43c88005301p+996,   -0x1.674fdcc0ba854p-2,   0x1.ffe6bcp-2, INEXACT)
T(RN,  0x1.31061d9ff5c43p+897,   -0x1.4c861ab2fc6d1p-2,  -0x1.fff7bcp-2, INEXACT)
T(RN,  0x1.e6c7e11d3f3e7p+797,    0x1.6787b03dbf4a8p+0,  -0x1.fff6a8p-2, INEXACT)
T(RN,  0x1.846bd7a4dce55p+698,    0x1.d72261d98e26bp-1,   -0x1.ffe8cp-2, INEXACT)
T(RN,  0x1.35efb6e55becfp+599,     0x1.05e08ec349b7p+0,   0x1.fffe3ep-2, INEXACT)
T(RN,   0x1.ee9eda589039p+499,    0x1.da347607948f4p-1,  -0x1.fffbc8p-2, INEXACT)
T(RN,  0x1.8aad48cda97ccp+400,   -0x1.9e7cf0709c9aep-1,  -0x1.ffe798p-2, INEXACT)
T(RN,  0x1.3aed912f83da5p+301,   -0x1.779fc04c7a916p-2,   0x1.ffe93cp-2, INEXACT)
T(RN,  0x1.f696263b7f635p+201,    0x1.0f50289f530adp+0,  -0x1.fffed8p-2, INEXACT)
T(RN,  0x1.910884a173f3cp+102,    0x1.171cb702a32e1p-2,   -0x1.ffef2p-2, INEXACT)
T(RN,     0x1.3fffffffffffp+4,    0x1.1e5b4a31aa883p+1,  -0x1.ffd90cp-2, INEXACT)
T(RN,    0x1.17e693ae45e9fp+2,    0x1.6b12e116b985fp+1,   0x1.f95634p-2, INEXACT)
T(RN,    0x1.e9a708ec178dbp-1,    0x1.6ad5dc8c3099dp+0,   0x1.fc4bd2p-2, INEXACT)
T(RN,    0x1.ac4b4102da8e9p-3,    0x1.b2a61ded1fddep-3,   0x1.fb5566p-2, INEXACT)
T(RN,    0x1.769fd2076f4fbp-5,    0x1.76e2baf3cd76ep-5,   0x1.f63ca8p-2, INEXACT)
T(RN,    0x1.93fffffffffe4p+6,    0x1.037513aa40b8bp-1,   0x1.fb3abap-2, INEXACT)
T(RN,    0x1.4096e6420ff65p+6,   -0x1.b32d612c33e8ep+4,   0x1.fda3ccp-2, INEXACT)
T(RN,    0x1.fccccb8614da4p+5,    0x1.eea15589b04a1p-1,   0x1.f687fep-2, INEXACT)
T(RN,    0x1.93c09308f7243p+5,    0x1.a6b8724022256p-3,  -0x1.f98468p-2, INEXACT)
T(RN,    0x1.4064919af918ep+5,   -0x1.0331caa3b7a0cp+0,  -0x1.fc29acp-2, INEXACT)
T(RN,     0x1.fc7cea9829b9p+4,    0x1.86ca0894a1edfp-2,  -0x1.fdffbap-2, INEXACT)
T(RN,    0x1.938130070a22ep+4,    0x1.625c130e417d5p-4,  -0x1.f8dfe8p-2, INEXACT)
T(RN,    0x1.403244dab2f8dp+4,     0x1.280e780f7161p+1,  -0x1.fdd794p-2, INEXACT)
T(RN,    0x1.fc2d16349b71ep+3,    0x1.64e967e93469dp-3,   0x1.fe2fdep-2, INEXACT)
T(RN,    0x1.9341d6f8a8bfep+3,    0x1.2240c6559dce5p-5,  -0x1.f63818p-2, INEXACT)
T(RN,    0x1.2bfffffffffdcp+8,    0x1.69f53b5420fd6p+5,   0x1.fb06d6p-2, INEXACT)
T(RN,    0x1.2afb3b5445203p+8,    0x1.2c09fbc26c6fbp-1,  -0x1.f6b408p-2, INEXACT)
T(RN,    0x1.29f7595345eaep+8,    -0x1.0de0a3d2222cp-1,  -0x1.fd5bd8p-2, INEXACT)
T(RN,    0x1.28f45937fbf23p+8,   -0x1.afc1a28942abfp+3,  -0x1.f9f97ep-2, INEXACT)
T(RN,     0x1.27f23a3e0c07p+8,    0x1.7a6bf8a782156p-1,   0x1.ff06f8p-2, INEXACT)
T(RN,    0x1.26f0fba1c5af9p+8,   -0x1.8b40afb14f18dp-2,   0x1.f68e36p-2, INEXACT)
T(RN,    0x1.25f09ca0227d5p+8,    -0x1.3a2546df125cp+2,  -0x1.fd6084p-2, INEXACT)
T(RN,    0x1.24f11c76c59e7p+8,    0x1.f42ed02dd3daap-1,   0x1.fccae8p-2, INEXACT)
T(RN,    0x1.23f27a63fb208p+8,   -0x1.cbfcc64c7753fp-3,  -0x1.fb405ep-2, INEXACT)
T(RN,     0x1.22f4b5a6b76bp+8,   -0x1.558903e81d1e9p+1,  -0x1.fb2ec2p-2, INEXACT)
T(RN,     0x1.21f7cd7e96cdp+8,    0x1.5f98dda9b4166p+0,   0x1.f72dccp-2, INEXACT)
T(RN,    0x1.20fbc12bdcb18p+8,   -0x1.615bb0b5ec329p-5,  -0x1.fcbf6cp-2, INEXACT)
T(RN,    0x1.20008fef73423p+8,   -0x1.a4dffd0541fa5p+0,   0x1.fc5724p-2, INEXACT)
T(RN,    0x1.1f06390aeaba9p+8,    0x1.160e0fc7ba27ep+1,   0x1.ff9392p-2, INEXACT)
T(RN,    0x1.1e0cbbc078de4p+8,    0x1.549dfa95b286ep-3,  -0x1.fac288p-2, INEXACT)
T(RN,    0x1.1d141752f85f1p+8,   -0x1.0b03260bf477ep+0,  -0x1.f783a8p-2, INEXACT)
T(RN,    0x1.1c1c4b05e87edp+8,    0x1.35f655725ba03p+2,   0x1.fa32dap-2, INEXACT)
T(RN,    0x1.1b25561d6c22cp+8,    0x1.b3f806a4f33aep-2,  -0x1.f86eacp-2, INEXACT)
T(RN,     0x1.1a2f37de49a2p+8,   -0x1.403577329a895p-1,   0x1.fc1be2p-2, INEXACT)
T(RN,    0x1.1939ef8de9fbap+8,   -0x1.29483502c88bbp+4,   0x1.f6603ap-2, INEXACT)
T(RN,    0x1.18457c72587dbp+8,    0x1.955eefe7afb75p-1,   0x1.fb8a2ap-2, INEXACT)
T(RN,    0x1.1751ddd241f4fp+8,   -0x1.289fe0a2a02fbp-2,   0x1.fa18acp-2, INEXACT)
T(RN,    0x1.165f12f4f455fp+8,   -0x1.695a5a559102dp+1,  -0x1.f6d4c2p-2, INEXACT)
T(RN,    0x1.156d1b225e261p+8,    0x1.72671c2203dd7p+0,   0x1.fb8fccp-2, INEXACT)
T(RN,    0x1.147bf5a30de24p+8,    0x1.8a54843b64c7cp-6,   0x1.fca2aap-2, INEXACT)
T(RN,    0x1.138ba1c03179cp+8,   -0x1.4c8920c27beefp+0,   0x1.f9f9d4p-2, INEXACT)
T(RN,    0x1.129c1ec395caep+8,    0x1.bdf3862141696p+1,   0x1.fab96cp-2, INEXACT)
T(RN,    0x1.11ad6bf7a60efp+8,    0x1.801d0e29c1cfap-2,   0x1.f9450ep-2, INEXACT)
T(RN,    0x1.10bf88a76b58cp+8,    -0x1.4873ad0a8742p-1,  -0x1.f91944p-2, INEXACT)
T(RN,    0x1.0fd2741e8be68p+8,   -0x1.adc7525e2ff28p+3,  -0x1.f5df82p-2, INEXACT)
T(RN,    0x1.0ee62da94b3eep+8,    0x1.c3064ccbe84e2p-1,   0x1.fa9618p-2, INEXACT)
T(RN,    0x1.0dfab4948859fp+8,   -0x1.9a247dfa1b5eap-3,  -0x1.f910eap-2, INEXACT)
T(RN,    0x1.0d10082dbe6a2p+8,   -0x1.04ac0257e075ep+1,   0x1.f6ca7ep-2, INEXACT)
T(RN,    0x1.0c2627c303acbp+8,    0x1.043a5b51279d9p+1,  -0x1.fd6d48p-2, INEXACT)
T(RN,    0x1.0b3d12a30903ap+8,    0x1.a5f4d0400db2bp-3,  -0x1.f8f466p-2, INEXACT)
T(RN,    0x1.0a54c81d1979ep+8,   -0x1.b2f029976c5efp-1,  -0x1.f9fbeap-2, INEXACT)
T(RN,    0x1.096d478119a49p+8,    0x1.a81fd1b459ea1p+4,   0x1.fa3142p-2, INEXACT)
T(RN,    0x1.0886901f8733bp+8,    0x1.76c32bae9490ap-1,  -0x1.fecbf4p-2, INEXACT)
T(RN,    0x1.07a0a14978667p+8,   -0x1.17597ac019f5ap-2,   0x1.fd4742p-2, INEXACT)
T(RN,    0x1.06bb7a509b85fp+8,   -0x1.270734682ad74p+1,  -0x1.fd99d2p-2, INEXACT)
T(RN,    0x1.05d71a8736626p+8,    0x1.e875cd484da74p+0,   0x1.f6ec2ep-2, INEXACT)
T(RN,    0x1.04f3814025c8bp+8,    0x1.9d051ad77d59ep-3,  -0x1.ff09fcp-2, INEXACT)
T(RN,    0x1.0410adcedd0acp+8,   -0x1.a4076205213a7p-1,  -0x1.f83ce4p-2, INEXACT)
T(RN,    0x1.032e9f876570cp+8,  -0x1.5780a5d16069bp+10,   0x1.f83fb2p-2, INEXACT)
T(RN,     0x1.024d55be5dc8p+8,    0x1.a7dba146c607ep-1,   0x1.fbb376p-2, INEXACT)
T(RN,    0x1.016ccfc8f9c4ap+8,   -0x1.806ec56cf5fbdp-3,   0x1.fac698p-2, INEXACT)
T(RN,    0x1.008d0cfd01a07p+8,   -0x1.c8676e4a2b988p+0,   0x1.f790b8p-2, INEXACT)
T(RN,    0x1.ff5c1961a301ep+7,    0x1.5424c277cb43cp+1,  -0x1.f7d0fap-2, INEXACT)
T(RN,    0x1.fd9f9c76b20b6p+7,    0x1.6d61a7aa175c3p-2,    0x1.fab6cp-2, INEXACT)
T(RN,    0x1.fbe4a1e8357bfp+7,   -0x1.26d3143241fd2p-1,  -0x1.fc0078p-2, INEXACT)
T(RN,    0x1.fa2b286657667p+7,   -0x1.53f3a4f9f838dp+2,   0x1.ff1b4ap-2, INEXACT)
T(RN,    0x1.f8732ea265be6p+7,    0x1.40fbf48622911p+0,  -0x1.fa7294p-2, INEXACT)
T(RN,    0x1.f6bcb34ed16f3p+7,    0x1.513c4fea859c1p-5,  -0x1.fc2d5cp-2, INEXACT)
T(RN,    0x1.f507b51f2d47cp+7,   -0x1.0e3091b29e323p+0,  -0x1.f5fbbep-2, INEXACT)
T(RN,    0x1.f35432c82d19ap+7,     0x1.5a3742c644bfp+3,   0x1.ff8e1ep-2, INEXACT)
T(RN,    0x1.f1a22affa49aep+7,    0x1.760644eadd58ep-1,   0x1.f7358ap-2, INEXACT)
T(RN,    0x1.eff19c7c86a57p+7,   -0x1.bcebd81584c26p-3,   0x1.fdca1cp-2, INEXACT)
T(RN,    0x1.ee4285f6e3edfp+7,   -0x1.c47199f958654p+0,   0x1.f67814p-2, INEXACT)
T(RN,    0x1.ec94e627ea4aep+7,    0x1.7ce1a69e8c15cp+1,   0x1.f8ef7ep-2, INEXACT)
T(RN,     0x1.eae8bbc9e3aap+7,    0x1.bd770e1b2ba26p-2,    0x1.fd983p-2, INEXACT)
T(RN,     0x1.e93e0598350ap+7,   -0x1.cd1765c0e618ap-2,  -0x1.fcdc8ap-2, INEXACT)
T(RN,    0x1.e794c24f5da5fp+7,   -0x1.8604a477d543ep+1,   0x1.fc5c66p-2, INEXACT)
T(RN,    0x1.e5ecf0acf5d4dp+7,    0x1.c8f64bc680fdep+0,   0x1.fb7f68p-2, INEXACT)
T(RN,    0x1.e4468f6fae3c5p+7,    0x1.eaba1214f1ad1p-3,   -0x1.fbc23p-2, INEXACT)
T(RN,    0x1.e2a19d574ec4ap+7,   -0x1.549402009e22bp-1,    0x1.fa50fp-2, INEXACT)
T(RN,    0x1.e0fe1924b5ad8p+7,   -0x1.81aace88783a1p+2,   -0x1.fd717p-2, INEXACT)
T(RN,    0x1.df5c0199d6a5ap+7,    0x1.4f42d8b31a2dcp+0,  -0x1.feee08p-2, INEXACT)
T(RN,    0x1.ddbb5579b9c68p+7,    0x1.af0660c3f4752p-4,  -0x1.ff86d6p-2, INEXACT)
T(RN,    0x1.dc1c13887aae6p+7,   -0x1.b4b613a90f0ccp-1,   -0x1.f670fp-2, INEXACT)
T(RN,    0x1.da7e3a8b4798ap+7,   -0x1.1bea9d7c89e52p+4,  -0x1.faa896p-2, INEXACT)
T(RN,    0x1.d8e1c9486062fp+7,    0x1.13350092c8881p+0,  -0x1.f84b1cp-2, INEXACT)
T(RN,    0x1.d746be87159c5p+7,    0x1.32cc907d71a0ep-6,  -0x1.f7d122p-2, INEXACT)
T(RN,    0x1.d5ad190fc7ac3p+7,   -0x1.fbe38a7f63782p-1,  -0x1.ffe016p-2, INEXACT)
T(RN,    0x1.d414d7abe5d02p+7,    0x1.f77770f2d6a9ap+6,  -0x1.feb46ep-2, INEXACT)
T(RN,     0x1.d27df925ed3ap+7,    0x1.eeaba05d38c83p-1,  -0x1.f7e50cp-2, INEXACT)
T(RN,    0x1.d0e87c4968242p+7,   -0x1.85bc809cf77b9p-6,  -0x1.fbd57ep-2, INEXACT)
T(RN,     0x1.cf545fe2ecf6p+7,   -0x1.0e92234375bfap+0,  -0x1.fd648ap-2, INEXACT)
T(RN,    0x1.cdc1a2c01d36ap+7,    0x1.1512b72ee7ff4p+5,   0x1.f8e468p-2, INEXACT)
T(RN,    0x1.cc3043afa4c23p+7,    0x1.e4b03c29d3692p-1,   0x1.f756e4p-2, INEXACT)
T(RN,    0x1.caa0418138f29p+7,   -0x1.7d39afc6c92e8p-6,   0x1.fae3b2p-2, INEXACT)
T(RN,    0x1.c9119b05977a2p+7,   -0x1.08946c2dff47bp+0,  -0x1.f90d56p-2, INEXACT)
T(RN,    0x1.c7844f0e85c02p+7,     0x1.1b9d171334a9p+7,  -0x1.ff361cp-2, INEXACT)
T(RN,    0x1.c5f85c6ecfd8bp+7,    0x1.02941cf79ba85p+0,  -0x1.fe8074p-2, INEXACT)
T(RN,    0x1.c46dc1fa47aa4p+7,    0x1.42cc6029ca0a9p-6,  -0x1.f87b4ap-2, INEXACT)
T(RN,    0x1.c2e47e85c4023p+7,   -0x1.db716df5cb0d5p-1,   -0x1.f927ap-2, INEXACT)
T(RN,    0x1.c15c90e71fc3bp+7,   -0x1.18cd148b86f66p+4,   0x1.f61b8ep-2, INEXACT)
T(RN,    0x1.bfd5f7f538ea9p+7,     0x1.2c4762af18bep+0,  -0x1.fe2714p-2, INEXACT)
T(RN,    0x1.be50b287efc48p+7,    0x1.adbc82faa42bcp-4,  -0x1.ff483ep-2, INEXACT)
T(RN,    0x1.bcccbf7826012p+7,   -0x1.87ccd131901fdp-1,   0x1.faecaep-2, INEXACT)
T(RN,    0x1.bb4a1d9fbdd47p+7,   -0x1.866f1e23fb84dp+2,  -0x1.fdc3aep-2, INEXACT)
T(RN,    0x1.b9c8cbd99921ap+7,    0x1.7e4249048d13ep+0,   0x1.f81b1cp-2, INEXACT)
T(RN,    0x1.b848c901988cap+7,     0x1.e0fab2192d84p-3,   0x1.f770b2p-2, INEXACT)
T(RN,    0x1.b6ca13f49aaa5p+7,   -0x1.22fb4ceeecf9ap-1,  -0x1.ff9124p-2, INEXACT)
T(RN,    0x1.b54cab907b199p+7,   -0x1.90e453a3ecafcp+1,   0x1.fdbd9ap-2, INEXACT)
T(RN,    0x1.b3d08eb411b39p+7,    0x1.14a5bfdd7e457p+1,  -0x1.ffa3b2p-2, INEXACT)
T(RN,    0x1.b255bc3f31a05p+7,    0x1.adff1f987a412p-2,   0x1.fa413ap-2, INEXACT)
T(RN,    0x1.b0dc3312a88e9p+7,   -0x1.6a03b7776f038p-2,  -0x1.f88bc2p-2, INEXACT)
T(RN,    0x1.af63f2103dcd5p+7,   -0x1.d8f81e5d0524dp+0,   0x1.f93d28p-2, INEXACT)
T(RN,    0x1.adecf81ab16f5p+7,    0x1.09d24c43f8b7ep+2,   0x1.ff25e4p-2, INEXACT)
T(RN,    0x1.ac774415bb87cp+7,    0x1.61c7066de14c4p-1,    0x1.fc4dap-2, INEXACT)
T(RN,    0x1.ab02d4e60b349p+7,   -0x1.f968471addb97p-4,  -0x1.f7d2bcp-2, INEXACT)
T(RN,    0x1.a98fa97145e33p+7,   -0x1.22123e5685abcp+0,   0x1.fb75d8p-2, INEXACT)
T(RN,    0x1.a81dc09e066a3p+7,  -0x1.9c7fed3ab0e33p+10,   0x1.fbc3acp-2, INEXACT)
T(RN,    0x1.a6ad1953dc2f2p+7,    0x1.2439233e9c125p+0,   0x1.f6c486p-2, INEXACT)
T(RN,    0x1.a53db27b4a8e1p+7,    0x1.13a8750c93a67p-3,   0x1.f8f83cp-2, INEXACT)
T(RN,    0x1.a3cf8afdc7816p+7,   -0x1.506f75001f35ap-1,   0x1.fcc0ccp-2, INEXACT)
T(RN,    0x1.a262a1c5bb5c5p+7,   -0x1.c2adb51bfed61p+1,   0x1.f984d2p-2, INEXACT)
T(RN,    0x1.a0f6f5be7fa58p+7,    0x1.147d69ff565cap+1,   0x1.f5f812p-2, INEXACT)
T(RN,    0x1.9f8c85d45e67dp+7,    0x1.d4d07c55d892fp-2,  -0x1.fadd0ap-2, INEXACT)
T(RN,    0x1.9e2350f4914c1p+7,   -0x1.222dc5eda18acp-2,  -0x1.f98abap-2, INEXACT)
T(RN,    0x1.9cbb560d40dbap+7,   -0x1.7d0bc6326cc32p+0,  -0x1.f86ff4p-2, INEXACT)
T(RN,    0x1.9b54940d83a1ep+7,    0x1.2412709015b72p+3,   -0x1.fdd42p-2, INEXACT)
T(RN,    0x1.99ef09e55d618p+7,    0x1.e9e7f793cfa3dp-1,   0x1.fb4e1ap-2, INEXACT)
T(RN,    0x1.988ab685be4b5p+7,    0x1.147e9b7f3fa2cp-4,  -0x1.f80456p-2, INEXACT)
T(RN,    0x1.972798e08228bp+7,   -0x1.7252a1ba12505p-1,  -0x1.fdeb1ep-2, INEXACT)
T(RN,    0x1.95c5afe86fa42p+7,   -0x1.ee4f3d361e918p+1,  -0x1.fa2c26p-2, INEXACT)
T(RN,    0x1.9464fa913751cp+7,    0x1.1317cfc765f57p+1,   0x1.f8927ap-2, INEXACT)
T(RN,    0x1.930577cf73147p+7,    0x1.ed120c902f216p-2,   0x1.fe8bacp-2, INEXACT)
T(RN,    0x1.91a72698a534dp+7,   -0x1.eb57ef3e641fbp-3,   0x1.fa0e58p-2, INEXACT)
T(RN,     0x1.904a05e3379fp+7,   -0x1.4e5b255c72814p+0,   0x1.ff5b24p-2, INEXACT)
T(RN,    0x1.8eee14a67b199p+7,    0x1.3210e50742a5cp+5,   0x1.fbce56p-2, INEXACT)
T(RN,    0x1.8d9351daa6828p+7,    0x1.2dd86515e441dp+0,   0x1.f709bap-2, INEXACT)
T(RN,    0x1.8c39bc78d5fcbp+7,    0x1.8f08223710ca7p-3,   -0x1.fdf26p-2, INEXACT)
T(RN,    0x1.8ae1537b0a35bp+7,   -0x1.0ab6aef6c7aacp-1,   0x1.f8d434p-2, INEXACT)
T(RN,    0x1.898a15dc2787dp+7,   -0x1.1e81b0a4c94afp+1,  -0x1.ff8254p-2, INEXACT)
T(RN,     0x1.88340297f554p+7,    0x1.f99793ed75c46p+1,  -0x1.fc801cp-2, INEXACT)
T(RN,    0x1.86df18ab1d1fbp+7,    0x1.8ae70baed10acp-1,   0x1.feee5ep-2, INEXACT)
T(RN,    0x1.858b571329eaep+7,   -0x1.b045163a291a2p-8,   0x1.f66b86p-2, INEXACT)
T(RN,    0x1.8438bcce874edp+7,   -0x1.93e93da5515c8p-1,  -0x1.f7dac2p-2, INEXACT)
T(RN,    0x1.82e748dc80cbfp+7,   -0x1.014f9772ba1aep+2,  -0x1.f8529ep-2, INEXACT)
T(RN,    0x1.8196fa3d411cbp+7,    0x1.240be82007523p+1,   0x1.fd49b2p-2, INEXACT)
T(RN,    0x1.8047cff1d13d5p+7,    0x1.19c68e1c14066p-1,   0x1.fc858ep-2, INEXACT)
T(RN,    0x1.7ef9c8fc17cfap+7,   -0x1.3409dd1146937p-3,   -0x1.f61a1p-2, INEXACT)
T(RN,    0x1.7dace45ed8693p+7,   -0x1.074f2629b1521p+0,  -0x1.fbd80ep-2, INEXACT)
T(RN,    0x1.7c61211db2a0cp+7,   -0x1.021b592af1029p+3,   0x1.f6a75cp-2, INEXACT)
T(RN,    0x1.7b167e3d217ebp+7,    0x1.bc9c5b9f0db08p+0,   0x1.f93268p-2, INEXACT)
T(RN,    0x1.79ccfac27ab31p+7,    0x1.b6bc4a313950cp-2,  -0x1.fdc29ap-2, INEXACT)
T(RN,    0x1.788495b3edb82p+7,   -0x1.edd0cccb150f5p-3,  -0x1.fb1372p-2, INEXACT)
T(RN,    0x1.773d4e18833d4p+7,   -0x1.330d9641b04b2p+0,    0x1.f66d1p-2, INEXACT)
T(RN,    0x1.75f722f81c61cp+7,   -0x1.13e811db9fb71p+4,  -0x1.ff0472p-2, INEXACT)
T(RN,    0x1.74b2135b71e1cp+7,    0x1.8957edf4aa9ccp+0,    0x1.fb826p-2, INEXACT)
T(RN,    0x1.736e1e4c1367bp+7,    0x1.82bb987f52884p-2,  -0x1.f69b5ep-2, INEXACT)
T(RN,    0x1.722b42d466e68p+7,   -0x1.1ad19508ff46bp-2,   0x1.f5fdf2p-2, INEXACT)
T(RN,    0x1.70e97fffa7c7ap+7,   -0x1.41387fad15f7dp+0,   -0x1.f7084p-2, INEXACT)
T(RN,    0x1.6fa8d4d9e623fp+7,   -0x1.57419a78efb8fp+4,  -0x1.f698c6p-2, INEXACT)
T(RN,    0x1.6e6940700637dp+7,    0x1.88cac468604d1p+0,  -0x1.fb5812p-2, INEXACT)
T(RN,    0x1.6d2ac1cfbf7f4p+7,    0x1.8e82bfc027ff4p-2,   -0x1.fd5b6p-2, INEXACT)
T(RN,    0x1.6bed58079c14dp+7,   -0x1.042ca0ffe0bfap-2,   0x1.f66cbcp-2, INEXACT)
T(RN,    0x1.6ab10226f7f77p+7,   -0x1.2d64366d43b31p+0,  -0x1.f8c696p-2, INEXACT)
T(RN,    0x1.6975bf3e0052cp+7,   -0x1.690f3563f892ap+3,  -0x1.f91bdep-2, INEXACT)
T(RN,    0x1.683b8e5db2c17p+7,    0x1.b9b638e5b6fa4p+0,  -0x1.faf56ap-2, INEXACT)
T(RN,    0x1.67026e97dca83p+7,    0x1.da8e43e1be6ffp-2,   0x1.f8de6cp-2, INEXACT)
T(RN,    0x1.65ca5eff1a6e1p+7,   -0x1.6b36a5d089ff8p-3,  -0x1.fd3a62p-2, INEXACT)
T(RN,    0x1.64935ea6d6e1bp+7,   -0x1.fd7fba5eab5ebp-1,   0x1.fa0f16p-2, INEXACT)
T(RN,    0x1.635d6ca34a649p+7,   -0x1.5ad01ee0ce7ecp+2,  -0x1.fe965cp-2, INEXACT)
T(RN,    0x1.622888097a523p+7,    0x1.1dfef1fe80a86p+1,   0x1.fc783ap-2, INEXACT)
T(RN,    0x1.60f4afef384ddp+7,    0x1.390194b068579p-1,   0x1.f7c71ep-2, INEXACT)
T(RN,    0x1.5fc1e36b217a6p+7,   -0x1.9e0d291a70c01p-5,   0x1.f79a18p-2, INEXACT)
T(RN,    0x1.5e9021949dde2p+7,   -0x1.835b0718724a3p-1,  -0x1.f89df8p-2, INEXACT)
T(RN,    0x1.5d5f6983dfbd5p+7,   -0x1.78329839d23f2p+1,   0x1.ffb8e8p-2, INEXACT)
T(RN,    0x1.5c2fba51e2bb6p+7,    0x1.d755aaef91361p+1,  -0x1.f776e2p-2, INEXACT)
T(RN,    0x1.5b0113186b668p+7,    0x1.bc1a5e339a0f3p-1,   0x1.fed79ap-2, INEXACT)
T(RN,    0x1.59d372f206537p+7,    0x1.0227665293a6fp-3,    0x1.f8e17p-2, INEXACT)
T(RN,    0x1.58a6d8fa079bdp+7,   -0x1.fd898e5dfdc35p-2,   0x1.f90e96p-2, INEXACT)
T(RN,    0x1.577b444c8a1aep+7,   -0x1.bb0a2387daf84p+0,   0x1.f7d618p-2, INEXACT)
T(RN,    0x1.5650b4066eb94p+7,     0x1.0e10465f01b8p+4,  -0x1.fac26ap-2, INEXACT)
T(RN,    0x1.552727455bd26p+7,    0x1.57996982209bap+0,    0x1.fb3a6p-2, INEXACT)
T(RN,    0x1.53fe9d27bc755p+7,    0x1.7749460200c46p-2,   0x1.f6292ap-2, INEXACT)
T(RN,    0x1.52d714ccbff98p+7,   -0x1.d6b9d5e7b4e3bp-3,   0x1.ff68c2p-2, INEXACT)
T(RN,     0x1.51b08d5458d1p+7,   -0x1.08353b3ba4998p+0,  -0x1.fc5858p-2, INEXACT)
T(RN,    0x1.508b05df3c598p+7,   -0x1.41cbb2b2a9695p+2,   0x1.f82944p-2, INEXACT)
T(RN,    0x1.4f667d8ee228ap+7,    0x1.452703e302ba6p+1,   0x1.fec1d4p-2, INEXACT)
T(RN,    0x1.4e42f38582fd7p+7,    0x1.72746e7de2ecdp-1,  -0x1.fcc1fep-2, INEXACT)
T(RN,    0x1.4d2066e6187e5p+7,    0x1.e2db7394f63d4p-5,  -0x1.f7fb3ep-2, INEXACT)
T(RN,    0x1.4bfed6d45c8b1p+7,   -0x1.1c29a519d477fp-1,  -0x1.f99b38p-2, INEXACT)
T(RN,    0x1.4ade4274c8467p+7,   -0x1.d41043d32a0a1p+0,  -0x1.f6c254p-2, INEXACT)
T(RN,    0x1.49bea8ec93d8fp+7,    0x1.04f9c055745f8p+4,   0x1.f90bbap-2, INEXACT)
T(RN,    0x1.48a00961b56aap+7,    0x1.65ccb0cdc83adp+0,    0x1.f8179p-2, INEXACT)
T(RN,    0x1.478262fae0bfdp+7,    0x1.a720e6e046da9p-2,  -0x1.f5d238p-2, INEXACT)
T(RN,    0x1.4665b4df8685ep+7,   -0x1.53475ae39c196p-3,  -0x1.fb3be8p-2, INEXACT)
T(RN,    0x1.4549fe37d3962p+7,   -0x1.bf857a995e0cbp-1,  -0x1.f5e972p-2, INEXACT)
T(RN,    0x1.442f3e2cb06b8p+7,   -0x1.9d6c7858c7af4p+1,   0x1.fe611ep-2, INEXACT)
T(RN,    0x1.431573e7c0792p+7,    0x1.f508bdb0b5d57p+1,  -0x1.f7229ap-2, INEXACT)
T(RN,    0x1.41fc9e936182bp+7,    0x1.f2a1e7387e727p-1,  -0x1.fd74bcp-2, INEXACT)
T(RN,    0x1.40e4bd5aab00ap+7,    0x1.d5e214ce8538dp-3,    0x1.ff222p-2, INEXACT)
T(RN,    0x1.3fcdcf696d7f5p+7,   -0x1.527e4336666dbp-2,   0x1.f705d2p-2, INEXACT)
T(RN,    0x1.3eb7d3ec31eecp+7,   -0x1.2aad3abf7792fp+0,  -0x1.fc9546p-2, INEXACT)
T(RN,    0x1.3da2ca10391eap+7,   -0x1.7a77514b0ec3ep+2,  -0x1.fe71acp-2, INEXACT)
T(RN,    0x1.3c8eb1037afe6p+7,    0x1.4852a2ae3602ap+1,   0x1.fe07a6p-2, INEXACT)
T(RN,    0x1.3b7b87f4a6268p+7,     0x1.8eb6472cda24p-1,   0x1.f7ad0ap-2, INEXACT)
T(RN,    0x1.3a694e131f028p+7,    0x1.0382030ae18c4p-3,   0x1.f8a36cp-2, INEXACT)
T(RN,    0x1.3958028eff665p+7,   -0x1.ba4fb80bf9403p-2,    0x1.f6574p-2, INEXACT)
T(RN,    0x1.3847a49915d13p+7,   -0x1.5e4e9938ea2a9p+0,   0x1.fec914p-2, INEXACT)
T(RN,    0x1.37383362e4eefp+7,   -0x1.3bf8cf88e31ebp+3,   -0x1.ff255p-2, INEXACT)
T(RN,    0x1.3629ae1ea2bf7p+7,    0x1.190056411ddc1p+1,  -0x1.f71336p-2, INEXACT)
T(RN,    0x1.351c13ff38692p+7,    0x1.6b0dbaef41323p-1,   0x1.fded3ap-2, INEXACT)
T(RN,    0x1.340f643841029p+7,    0x1.79fcc984bc2c6p-4,  -0x1.fb175cp-2, INEXACT)
T(RN,     0x1.33039dfe0987p+7,   -0x1.d6d65261746b1p-2,  -0x1.fceeb6p-2, INEXACT)
T(RN,    0x1.31f8c0858fee5p+7,   -0x1.67a7183b0386fp+0,   0x1.f62f6ap-2, INEXACT)
T(RN,    0x1.30eecb0482a78p+7,   -0x1.41b03df9fc091p+3,   0x1.fbb36cp-2, INEXACT)
T(RN,    0x1.2fe5bcb140009p+7,    0x1.1fc1a39bbee3cp+1,   -0x1.fc35ap-2, INEXACT)
T(RN,    0x1.2edd94c2d5844p+7,    0x1.7a4ad3693cd67p-1,   0x1.f8e932p-2, INEXACT)
T(RN,    0x1.2dd65270ff77dp+7,    0x1.f6d4ca7164abcp-4,   0x1.fceec6p-2, INEXACT)
T(RN,    0x1.2ccff4f4281bdp+7,   -0x1.a541e5b93a4cap-2,   0x1.f7af92p-2, INEXACT)
T(RN,    0x1.2bca7b85673f8p+7,   -0x1.433f1565aac07p+0,  -0x1.f887ecp-2, INEXACT)
T(RN,    0x1.2ac5e55e81703p+7,    -0x1.8a699f35da6ap+2,  -0x1.f5d704p-2, INEXACT)
T(RN,    0x1.29c231b9e8137p+7,     0x1.62a772543375p+1,   0x1.fd13e6p-2, INEXACT)
T(RN,    0x1.28bf5fd2b77d8p+7,    0x1.c01593c26c0b4p-1,  -0x1.ff418ep-2, INEXACT)
T(RN,    0x1.27bd6ee4b7a1dp+7,    0x1.bf83fce9e5c75p-3,    0x1.fddbap-2, INEXACT)
T(RN,    0x1.26bc5e2c5af4bp+7,   -0x1.2e2ccfbb45eaap-2,   0x1.fd53b8p-2, INEXACT)
T(RN,    0x1.25bc2ce6bdd88p+7,   -0x1.00fcfef9444afp+0,  -0x1.f8fe54p-2, INEXACT)
T(RN,    0x1.24bcda51a6188p+7,   -0x1.b53aa1b0dc0d8p+1,   0x1.fd6064p-2, INEXACT)
T(RN,    0x1.23be65ab82552p+7,    0x1.2913de1ce4483p+2,  -0x1.f75feep-2, INEXACT)
T(RN,    0x1.22c0ce33696f6p+7,    0x1.2b5b77e817fabp+0,  -0x1.fe17aep-2, INEXACT)
T(RN,    0x1.21c4132919fa7p+7,    0x1.8cd08476ef874p-2,   0x1.f60056p-2, INEXACT)
T(RN,    0x1.20c833ccf9a12p+7,   -0x1.f7362f2b3bfacp-4,   0x1.fbde2ep-2, INEXACT)
T(RN,    0x1.1fcd2f6014a11p+7,   -0x1.67c3409c1bf22p-1,   -0x1.f5fdfp-2, INEXACT)
T(RN,    0x1.1ed305241d27fp+7,   -0x1.f85dee8cf9146p+0,  -0x1.f69d88p-2, INEXACT)
T(RN,     0x1.1dd9b45b6ad8p+7,    0x1.cf6915740d66dp+5,  -0x1.f67924p-2, INEXACT)
T(RN,    0x1.1ce13c48fa386p+7,    0x1.d1c664405391ep+0,    0x1.f7582p-2, INEXACT)
T(RN,    0x1.1be99c306bf7ap+7,    0x1.52d2a6b8eb3a2p-1,  -0x1.f85eb4p-2, INEXACT)
T(RN,    0x1.1af2d35604b22p+7,    0x1.a5ba276c71259p-4,  -0x1.f6820cp-2, INEXACT)
T(RN,    0x1.19fce0feac068p+7,   -0x1.9658ff022c026p-2,  -0x1.f71ea2p-2, INEXACT)
T(RN,    0x1.1907c46fec4c9p+7,   -0x1.2742dfcf0e2c7p+0,   -0x1.fb476p-2, INEXACT)
T(RN,    0x1.18137ceff1efap+7,   -0x1.08bf51a9b8868p+2,  -0x1.f6d0f6p-2, INEXACT)
T(RN,    0x1.172009c58ad9dp+7,    0x1.0777b6b5ec3ebp+2,   -0x1.f69ffp-2, INEXACT)
T(RN,    0x1.162d6a3825eebp+7,    0x1.2888417a9d377p+0,   0x1.f8b484p-2, INEXACT)
T(RN,    0x1.153b9d8fd285cp+7,    0x1.a091b908402f8p-2,   0x1.ffb6b8p-2, INEXACT)
T(RN,    0x1.144aa3153fd42p+7,   -0x1.5a1e4d3a7b86ep-4,  -0x1.fc7fe4p-2, INEXACT)
T(RN,    0x1.135a7a11bc711p+7,   -0x1.3c48e31af79f5p-1,   -0x1.fb52dp-2, INEXACT)
T(RN,    0x1.126b21cf35b38p+7,   -0x1.a19512c90f23dp+0,   0x1.fec9d6p-2, INEXACT)
T(RN,    0x1.117c99983739cp+7,   -0x1.7bb2970c366cfp+3,   0x1.fd7ca4p-2, INEXACT)
T(RN,    0x1.108ee0b7ea607p+7,    0x1.40438e3fa9943p+1,   -0x1.fbe09p-2, INEXACT)
T(RN,    0x1.0fa1f67a15b3ap+7,    0x1.c837fd0870f29p-1,  -0x1.fe4eb8p-2, INEXACT)
T(RN,    0x1.0eb5da2b1c61bp+7,    0x1.17c2df59d4f0dp-2,   0x1.ffeb26p-2, INEXACT)
T(RN,    0x1.0dca8b17fdc0fp+7,   -0x1.9003feeaced36p-3,   0x1.f9ebfcp-2, INEXACT)
T(RN,    0x1.0ce0088e54b78p+7,   -0x1.85f7acfa40eb4p-1,  -0x1.fb7074p-2, INEXACT)
T(RN,    0x1.0bf651dc57411p+7,   -0x1.0027aedd73b01p+1,  -0x1.feaa04p-2, INEXACT)
T(RN,    0x1.0b0d6650d5e51p+7,   -0x1.d77ea54c52359p+6,  -0x1.fe2eaap-2, INEXACT)
T(RN,    0x1.0a25453b3b27ep+7,    0x1.0c78b9033dda7p+1,  -0x1.ffbddep-2, INEXACT)
T(RN,    0x1.093dedeb8b17fp+7,    0x1.99083defd1de3p-1,   0x1.fde618p-2, INEXACT)
T(RN,    0x1.08575fb262ad3p+7,    0x1.d210eccaf70f7p-3,   0x1.fce0b6p-2, INEXACT)
T(RN,    0x1.077199e0f7598p+7,   -0x1.d4c4836baa64dp-3,   0x1.fb0ab4p-2, INEXACT)
T(RN,    0x1.068c9bc916855p+7,   -0x1.9786836557c5fp-1,  -0x1.fe412ap-2, INEXACT)
T(RN,    0x1.05a864bd24f56p+7,   -0x1.07190600c64d9p+1,  -0x1.faeec4p-2, INEXACT)
T(RN,    0x1.04c4f4101e5fcp+7,   -0x1.d23856b47fb8dp+6,   0x1.fa9e04p-2, INEXACT)
T(RN,    0x1.03e2491594ddap+7,    0x1.1414ee2768a73p+1,  -0x1.f89ebep-2, INEXACT)
T(RN,    0x1.03006321b06a7p+7,    0x1.ab4a806f32ae4p-1,   0x1.f5d684p-2, INEXACT)
T(RN,    0x1.021f41892e548p+7,    0x1.0bbfcc2e4841bp-2,   0x1.f74fdap-2, INEXACT)
T(RN,    0x1.013ee3a160dbap+7,   -0x1.79e607df36372p-3,  -0x1.f626a8p-2, INEXACT)
T(RN,    0x1.005f48c02e86ep+7,   -0x1.6ce6a79985a3ap-1,   -0x1.fc40ep-2, INEXACT)
T(RN,    0x1.ff00e078239c6p+6,   -0x1.c2eb13393ffcdp+0,   0x1.f9c10ap-2, INEXACT)
T(RN,    0x1.fd44b2d830db1p+6,   -0x1.8297ee037f3a9p+3,   0x1.fbef24p-2, INEXACT)
T(RN,    0x1.fb8a074fc611ep+6,    0x1.5ef982bacb248p+1,  -0x1.fcc5e4p-2, INEXACT)
T(RN,    0x1.f9d0dc8f493bcp+6,    0x1.0280661a087a2p+0,   0x1.f8c4aap-2, INEXACT)
T(RN,    0x1.f819314844015p+6,    0x1.827bf9276416bp-2,     0x1.fd3bp-2, INEXACT)
T(RN,    0x1.f663042d62c8cp+6,   -0x1.12e2fcb53d55bp-4,  -0x1.feea0ep-2, INEXACT)
T(RN,    0x1.f4ae53f273b89p+6,   -0x1.13608bde5d455p-1,  -0x1.f8ffb8p-2, INEXACT)
T(RN,    0x1.f2fb1f4c65b19p+6,   -0x1.4f2151487c9a8p+0,  -0x1.fd4e34p-2, INEXACT)
T(RN,    0x1.f14964f1475fdp+6,    -0x1.12ddd30514cep+2,  -0x1.fbeec8p-2, INEXACT)
T(RN,    0x1.ef9923984635bp+6,    0x1.46da821c9d3e7p+2,   -0x1.f8a18p-2, INEXACT)
T(RN,    0x1.edea59f9ad7b4p+6,     0x1.6b235f292f28p+0,   0x1.f86f2ep-2, INEXACT)
T(RN,    0x1.ec3d06cee5566p+6,    0x1.3128a0c94f27bp-1,  -0x1.fec69cp-2, INEXACT)
T(RN,    0x1.ea9128d271c61p+6,    0x1.ec69ad9817ed3p-4,   -0x1.f998fp-2, INEXACT)
T(RN,    0x1.e8e6bebff1be5p+6,   -0x1.3925ab77716fbp-2,  -0x1.fac542p-2, INEXACT)
T(RN,    0x1.e73dc7541e1acp+6,   -0x1.b9ab13b4bcdc7p-1,  -0x1.f637c4p-2, INEXACT)
T(RN,    0x1.e596414cc8cdap+6,   -0x1.0c1c6883ccc4ap+1,    0x1.ffa47p-2, INEXACT)
T(RN,    0x1.e3f02b68dbbddp+6,   -0x1.e1691e63a01cdp+4,  -0x1.f75e28p-2, INEXACT)
T(RN,    0x1.e24b846857fc7p+6,    0x1.42bec761f52f7p+1,   0x1.f8d35ep-2, INEXACT)
T(RN,    0x1.e0a84b0c54b4fp+6,    0x1.fe6505da8596ep-1,   0x1.fec6e4p-2, INEXACT)
T(RN,    0x1.df067e16fe4c7p+6,    0x1.940b0c4760e97p-2,   0x1.f9e476p-2, INEXACT)
T(RN,      0x1.dd661c4b954p+6,   -0x1.f8d838c32001ep-6,   0x1.f5d7cep-2, INEXACT)
T(RN,    0x1.dbc7246e6e101p+6,   -0x1.dd245e087af7dp-2,  -0x1.fe2eaap-2, INEXACT)
T(RN,    0x1.da299544ee9c1p+6,   -0x1.1d8d30ae53a16p+0,   0x1.f61f1ep-2, INEXACT)
T(RN,    0x1.d88d6d958ede3p+6,   -0x1.77ab36261c55fp+1,   0x1.ff7aeap-2, INEXACT)
T(RN,    0x1.d6f2ac27d7397p+6,    0x1.b7261d859bc8ap+3,   0x1.fb49bep-2, INEXACT)
T(RN,    0x1.d5594fc45fa1ap+6,    0x1.f4dbb0ab57eecp+0,  -0x1.fe0dcap-2, INEXACT)
T(RN,    0x1.d3c15734cec19p+6,    0x1.af25c5abb5fbfp-1,  -0x1.fa3a9cp-2, INEXACT)
T(RN,    0x1.d22ac143d9029p+6,    0x1.3feeaf2da1e3fp-2,  -0x1.f5cd8ep-2, INEXACT)
T(RN,    0x1.d0958cbd3fa69p+6,   -0x1.7d8c7582abe84p-4,   0x1.fbc8fap-2, INEXACT)
T(RN,    0x1.cf01b86dcfdf1p+6,   -0x1.0f499bf878c74p-1,   0x1.ff915ap-2, INEXACT)
T(RN,    0x1.cd6f432361eb3p+6,   -0x1.35d8bc779bb86p+0,   0x1.f66d88p-2, INEXACT)
T(RN,    0x1.cbde2bacd8173p+6,   -0x1.9f8215ada73fap+1,   0x1.f9af16p-2, INEXACT)
T(RN,    0x1.ca4e70da1e072p+6,    0x1.5ca323458473cp+3,  -0x1.f81514p-2, INEXACT)
T(RN,    0x1.c8c0117c27851p+6,    0x1.eb0d641414747p+0,  -0x1.ffa6e8p-2, INEXACT)
T(RN,    0x1.c7330c64efe38p+6,    0x1.b1757509f1066p-1,  -0x1.feb01cp-2, INEXACT)
T(RN,    0x1.c5a7606778f65p+6,    0x1.4eefd63ebf5fcp-2,   0x1.ff5b72p-2, INEXACT)
T(RN,    0x1.c41d0c57ca27dp+6,   -0x1.1af135c08b6c3p-4,   0x1.f6127ap-2, INEXACT)
T(RN,    0x1.c2940f0aefa6ep+6,   -0x1.f21f46f5e2d52p-2,  -0x1.fb3c54p-2, INEXACT)
T(RN,    0x1.c10c6756f9893p+6,    -0x1.1adf055c6378p+0,   0x1.fd2138p-2, INEXACT)
T(RN,    0x1.bf861412facbfp+6,   -0x1.59ed951b51853p+1,  -0x1.fdab3ep-2, INEXACT)
T(RN,    0x1.be011417088afp+6,    0x1.39d46f832a07ap+5,   0x1.fb80fcp-2, INEXACT)
T(RN,    0x1.bc7d663c391dep+6,    0x1.2b56a71be775ep+1,   0x1.f99948p-2, INEXACT)
T(RN,    0x1.bafb095ca33e7p+6,    0x1.020ff6af594fbp+0,  -0x1.fdac46p-2, INEXACT)
T(RN,    0x1.b979fc535d02dp+6,    0x1.c1301b9ec5067p-2,  -0x1.fb8662p-2, INEXACT)
T(RN,    0x1.b7fa3dfc7b37cp+6,     0x1.3ca6245fdff1p-5,   -0x1.f8d03p-2, INEXACT)
T(RN,    0x1.b67bcd3510612p+6,   -0x1.644baf90a31f4p-2,  -0x1.f70648p-2, INEXACT)
T(RN,    0x1.b4fea8db2bddep+6,   -0x1.b575f02ecb843p-1,  -0x1.f5d636p-2, INEXACT)
T(RN,    0x1.b382cfcdd91ebp+6,   -0x1.dcbb6adef9e84p+0,   -0x1.fb53fp-2, INEXACT)
T(RN,    0x1.b20840ed1eb94p+6,   -0x1.029ba28de0807p+3,  -0x1.fd606cp-2, INEXACT)
T(RN,    0x1.b08efb19fd894p+6,    0x1.ff43e504d01bbp+1,   0x1.fbda0ap-2, INEXACT)
T(RN,    0x1.af16fd366ff93p+6,    0x1.6c56f5cb95a7bp+0,   0x1.f81ce6p-2, INEXACT)
T(RN,    0x1.ada0462568fc4p+6,    0x1.58921d261888bp-1,   0x1.fa01aap-2, INEXACT)
T(RN,    0x1.ac2ad4cad357dp+6,    0x1.da82a34feb0d3p-3,   -0x1.fe4edp-2, INEXACT)
T(RN,     0x1.aab6a80b90bap+6,   -0x1.17c9c75a42821p-3,  -0x1.f74da4p-2, INEXACT)
T(RN,    0x1.a943becd78eacp+6,   -0x1.165fb541a04d2p-1,  -0x1.f6dac6p-2, INEXACT)
T(RN,    0x1.a7d217f758ee6p+6,   -0x1.28befa0ccfd67p+0,  -0x1.fb613ep-2, INEXACT)
T(RN,    0x1.a661b270f2547p+6,   -0x1.5c6f487b56b82p+1,   0x1.fae6bep-2, INEXACT)
T(RN,    0x1.a4f28d22fa13ep+6,    0x1.344964e6e3869p+7,  -0x1.f8f3f8p-2, INEXACT)
T(RN,    0x1.a384a6f7180e3p+6,    0x1.502b847d6beacp+1,  -0x1.fc9858p-2, INEXACT)
T(RN,    0x1.a217fed7e6084p+6,    0x1.23eda1f91917fp+0,  -0x1.f72ae4p-2, INEXACT)
T(RN,    0x1.a0ac93b0eee5ap+6,    0x1.15095f88e1a08p-1,  -0x1.ff4ce8p-2, INEXACT)
T(RN,    0x1.9f42646eaddbcp+6,    0x1.255e75991ac4fp-3,   0x1.fd52c4p-2, INEXACT)
T(RN,    0x1.9dd96ffe8da3bp+6,   -0x1.b4fa9398b4847p-3,   0x1.fd2222p-2, INEXACT)
T(RN,    0x1.9c71b54ee78e3p+6,   -0x1.42144ddd4baa6p-1,  -0x1.f7e276p-2, INEXACT)
T(RN,    0x1.9b0b334f02e64p+6,   -0x1.4a69e1cecaeb5p+0,   0x1.f9de22p-2, INEXACT)
T(RN,    0x1.99a5e8ef13e8ap+6,   -0x1.8f3bc7a1edc9bp+1,   0x1.fbeccap-2, INEXACT)
T(RN,    0x1.9841d5203b29fp+6,    0x1.aaca15b5e0482p+4,  -0x1.fa6a14p-2, INEXACT)
T(RN,     0x1.96def6d484a5p+6,    0x1.3cc3e402fd834p+1,  -0x1.fb84eep-2, INEXACT)
T(RN,    0x1.957d4cfee6fc9p+6,    0x1.1e68381e232cdp+0,   0x1.f5e8eep-2, INEXACT)
T(RN,    0x1.941cd69342b13p+6,    0x1.15d8b58c23e8bp-1,   0x1.f7d0cep-2, INEXACT)
T(RN,    0x1.92bd9286614c7p+6,    0x1.3e40fcf39133bp-3,   0x1.f8d57ap-2, INEXACT)
T(RN,    0x1.915f7fcdf4ba7p+6,   -0x1.84ff361af638ep-3,   0x1.fe997ap-2, INEXACT)
T(RN,    0x1.90029d60962d2p+6,   -0x1.2ae5e10fae43ep-1,   -0x1.f7e26p-2, INEXACT)
T(RN,    0x1.8ea6ea35c5af6p+6,   -0x1.2e3105c0026d6p+0,   0x1.fbb50cp-2, INEXACT)
T(RN,    0x1.8d4c6545e92a6p+6,   -0x1.4f89d7b04dc6dp+1,  -0x1.fff7c6p-2, INEXACT)
T(RN,    0x1.8bf30d8a4ba2ap+6,   -0x1.262d7a795e41fp+5,   0x1.f7271cp-2, INEXACT)
T(RN,    0x1.8a9ae1fd1c828p+6,    0x1.9116558f7c6b7p+1,   0x1.fa6534p-2, INEXACT)
T(RN,    0x1.8943e1996ecd6p+6,    0x1.5510b370fc011p+0,  -0x1.f86668p-2, INEXACT)
T(RN,    0x1.87ee0b5b383a5p+6,    0x1.591c5b4304981p-1,   -0x1.ff505p-2, INEXACT)
T(RN,    0x1.86995e3f509a9p+6,    0x1.10d89d0a5b9f9p-2,   0x1.faaeb8p-2, INEXACT)
T(RN,    0x1.8545d94370fddp+6,   -0x1.23f78f6949ae5p-4,  -0x1.fd636ap-2, INEXACT)
T(RN,    0x1.83f37b6633029p+6,   -0x1.b2de7819182c8p-2,  -0x1.fe19eep-2, INEXACT)
T(RN,    0x1.82a243a70ff04p+6,   -0x1.cb09db739ccffp-1,   -0x1.f8267p-2, INEXACT)
T(RN,    0x1.8152310660141p+6,   -0x1.c7db9d897f522p+0,  -0x1.f8a9c8p-2, INEXACT)
T(RN,    0x1.8003428559f04p+6,   -0x1.56bbf37109e0fp+2,   0x1.f8549ap-2, INEXACT)
T(RN,     0x1.7eb577261187p+6,    0x1.c1b6a3a8268b1p+2,    0x1.fc142p-2, INEXACT)
T(RN,    0x1.7d68cdeb77893p+6,    0x1.fcb6d33d219a6p+0,   0x1.f88612p-2, INEXACT)
T(RN,    0x1.7c1d45d958a01p+6,    0x1.fb51fcaf5fc3fp-1,  -0x1.ff9c1ap-2, INEXACT)
T(RN,    0x1.7ad2ddf45cb0fp+6,    0x1.f8f9e6ceb227bp-2,   0x1.ffcd26p-2, INEXACT)
T(RN,    0x1.7989954206135p+6,    0x1.19773bab2fdebp-3,   0x1.fa4db6p-2, INEXACT)
T(RN,    0x1.78416ac8b0e3ap+6,   -0x1.7cec0c1060bb3p-3,  -0x1.fa389ap-2, INEXACT)
T(RN,    0x1.76fa5d8f923b1p+6,   -0x1.19e48ab22ac91p-1,   0x1.f808b2p-2, INEXACT)
T(RN,    0x1.75b46c9eb7721p+6,   -0x1.133b407162a49p+0,  -0x1.fe36bcp-2, INEXACT)
T(RN,    0x1.746f96ff05618p+6,   -0x1.15a3245672dd3p+1,   0x1.f7dc46p-2, INEXACT)
T(RN,     0x1.732bdbba37b7p+6,   -0x1.12fd464b01591p+3,  -0x1.ffb61ep-2, INEXACT)
T(RN,    0x1.71e939dae02bdp+6,     0x1.3cfc5ec9967fp+2,   0x1.ff871cp-2, INEXACT)
T(RN,    0x1.70a7b06c65c92p+6,    0x1.c639242c79f3dp+0,   0x1.ff481ap-2, INEXACT)
T(RN,    0x1.6f673e7b04462p+6,    0x1.d7dfce2212a35p-1,   0x1.fa536cp-2, INEXACT)
T(RN,    0x1.6e27e313cb2a3p+6,    0x1.d90f37b4386c6p-2,  -0x1.f909d2p-2, INEXACT)
T(RN,    0x1.6ce99d449d30fp+6,    0x1.f601b6126ab22p-4,   0x1.fb1efap-2, INEXACT)
T(RN,    0x1.6bac6c1c2f85ap+6,   -0x1.85368a529ff1ep-3,  -0x1.fd53bcp-2, INEXACT)
T(RN,    0x1.6a704eaa08ff3p+6,   -0x1.1564714cc3914p-1,   0x1.f60fb8p-2, INEXACT)
T(RN,    0x1.693543fe81d26p+6,   -0x1.09cbcd2246a23p+0,  -0x1.f70f8ap-2, INEXACT)
T(RN,    0x1.67fb4b2ac203ap+6,   -0x1.0257cec2eacfap+1,   -0x1.fa3f1p-2, INEXACT)
T(RN,    0x1.66c26340c17dap+6,   -0x1.9b18f08e8bae7p+2,   0x1.ff7bcep-2, INEXACT)
T(RN,    0x1.658a8b53470eep+6,    0x1.a731aaa324f39p+2,  -0x1.f66cf8p-2, INEXACT)
T(RN,    0x1.6453c275e7abap+6,    0x1.069104be964dcp+1,  -0x1.ff3714p-2, INEXACT)
T(RN,    0x1.631e07bd05cd3p+6,    0x1.0f7a3893df40ap+0,   0x1.f9f37ep-2, INEXACT)
T(RN,    0x1.61e95a3dd0badp+6,    0x1.209b4a30a8107p-1,   0x1.f6b5ccp-2, INEXACT)
T(RN,    0x1.60b5b90e43dbap+6,    0x1.baa9c0ac0f409p-3,  -0x1.fbb868p-2, INEXACT)
T(RN,    0x1.5f83234525fb1p+6,   -0x1.63507cabbfd74p-4,  -0x1.f83c88p-2, INEXACT)
T(RN,    0x1.5e5197fa089cep+6,   -0x1.9ed7f835fb838p-2,   0x1.fd7438p-2, INEXACT)
T(RN,    0x1.5d21164547502p+6,   -0x1.9ff8a6bb84a5bp-1,    0x1.fa3bep-2, INEXACT)
T(RN,    0x1.5bf19d4006ebfp+6,   -0x1.7c915e4f12433p+0,  -0x1.f6fcf4p-2, INEXACT)
T(RN,    0x1.5ac32c0435402p+6,   -0x1.a28768fb3b85ap+1,  -0x1.fe572cp-2, INEXACT)
T(RN,    0x1.5995c1ac8799dp+6,   -0x1.98635ae23a491p+8,  -0x1.f6b006p-2, INEXACT)
T(RN,    0x1.58695d547afcap+6,     0x1.ab86e559a5bcp+1,  -0x1.f6c5f4p-2, INEXACT)
T(RN,    0x1.573dfe1852d73p+6,    0x1.83f9bc2370adbp+0,  -0x1.f6918ep-2, INEXACT)
T(RN,    0x1.5613a31518a46p+6,    0x1.abea2bc408e3cp-1,   0x1.f9bbc8p-2, INEXACT)
T(RN,    0x1.54ea4b689b16ap+6,    0x1.b7f5dc1228f88p-2,  -0x1.f63068p-2, INEXACT)
T(RN,    0x1.53c1f6316d8d4p+6,    0x1.deff7066cc39ap-4,   0x1.f88772p-2, INEXACT)
T(RN,    0x1.529aa28ee769fp+6,   -0x1.63c08c7dc8483p-3,   0x1.f6a98ap-2, INEXACT)
T(RN,     0x1.51744fa12319p+6,   -0x1.fa98834962ae6p-2,   0x1.f7628cp-2, INEXACT)
T(RN,    0x1.504efc88fa798p+6,   -0x1.d90a1527adce7p-1,  -0x1.f5c2e6p-2, INEXACT)
T(RN,    0x1.4f2aa86816d53p+6,   -0x1.ab9a685d13353p+0,  -0x1.fc60fap-2, INEXACT)
T(RN,    0x1.4e075260ce771p+6,   -0x1.eb24ee7bada9dp+1,   0x1.fe98dep-2, INEXACT)
T(RN,    0x1.4ce4f99645d44p+6,    0x1.17ac73d39c4bep+5,   0x1.feda5cp-2, INEXACT)
T(RN,    0x1.4bc39d2c5e054p+6,    0x1.8dfab627d446fp+1,   0x1.ff0d48p-2, INEXACT)
T(RN,    0x1.4aa33c47b76abp+6,    0x1.7c0a646d7ab78p+0,   0x1.f64f86p-2, INEXACT)
T(RN,    0x1.4983d60db11a7p+6,    0x1.aced22ec9c599p-1,  -0x1.f5cb26p-2, INEXACT)
T(RN,    0x1.486569a46843ap+6,    0x1.c660eb13f98bap-2,  -0x1.ff433cp-2, INEXACT)
T(RN,    0x1.4747f632b749ep+6,    0x1.1e3d779a7e6bep-3,   0x1.f7228ep-2, INEXACT)
T(RN,    0x1.462b7ae035abcp+6,   -0x1.1e69469b9bd8fp-3,  -0x1.f7850ep-2, INEXACT)
T(RN,    0x1.450ff6d536969p+6,   -0x1.c42a24b95dca8p-2,  -0x1.fa1deap-2, INEXACT)
T(RN,    0x1.43f5693ac8f51p+6,   -0x1.a81494ee224c2p-1,   0x1.fab0aap-2, INEXACT)
T(RN,    0x1.42dbd13ab672cp+6,   -0x1.72f58d32e5f71p+0,   0x1.faa37cp-2, INEXACT)
T(RN,    0x1.41c32dff82f98p+6,   -0x1.75b463f88e389p+1,  -0x1.fccf8ap-2, INEXACT)
T(RN,    0x1.40ab7eb46bf07p+6,   -0x1.19134d800bfeap+4,  -0x1.f7c18ap-2, INEXACT)
T(RN,     0x1.3f94c28567ccp+6,    0x1.2498dc20f620ap+2,  -0x1.ffc982p-2, INEXACT)
T(RN,     0x1.3e7ef89f252fp+6,    0x1.e3e2a4f2eb94cp+0,   0x1.fa5a84p-2, INEXACT)
T(RN,    0x1.3d6a202f0a7cep+6,    0x1.0efba216eebcfp+0,   0x1.f93c58p-2, INEXACT)
T(RN,    0x1.3c5638633526cp+6,    0x1.35f770064fedcp-1,   0x1.fabb7ep-2, INEXACT)
T(RN,    0x1.3b43406a79079p+6,    0x1.21dec13965466p-2,   0x1.fb3224p-2, INEXACT)
T(RN,    0x1.3a3137745fdc7p+6,    0x1.0e3c72f1b9c95p-7,  -0x1.fdcf6ap-2, INEXACT)
T(RN,    0x1.39201cb1287ffp+6,   -0x1.0eb6fbfa96844p-2,  -0x1.fd2ceap-2, INEXACT)
T(RN,    0x1.380fef51c6728p+6,   -0x1.280d2d2a8716ap-1,  -0x1.fe3c02p-2, INEXACT)
T(RN,    0x1.3700ae87e120fp+6,   -0x1.01edb04b84c8ep+0,   0x1.f6e1e8p-2, INEXACT)
T(RN,    0x1.35f25985d362bp+6,   -0x1.c18f79812c7a5p+0,  -0x1.fdedc6p-2, INEXACT)
T(RN,    0x1.34e4ef7eaaa49p+6,    -0x1.ebf0c3a2bf79p+1,   0x1.f5c726p-2, INEXACT)
T(RN,    0x1.33d86fa62705cp+6,    0x1.05350e58393e8p+7,   0x1.f60adcp-2, INEXACT)
T(RN,    0x1.32ccd930b952ap+6,    0x1.d05a4d065b552p+1,    0x1.f6e0dp-2, INEXACT)
T(RN,    0x1.31c22b5383f83p+6,    0x1.b5859f9143ddbp+0,  -0x1.fa8a42p-2, INEXACT)
T(RN,    0x1.30b865445965bp+6,    0x1.fc612f7342d54p-1,  -0x1.f86702p-2, INEXACT)
T(RN,    0x1.2faf8639bbe8cp+6,    0x1.275278684bd7dp-1,   0x1.fc0282p-2, INEXACT)
T(RN,    0x1.2ea78d6adce8ep+6,     0x1.16566245106cp-2,  -0x1.f950c8p-2, INEXACT)
T(RN,    0x1.2da07a0f9c5d6p+6,    0x1.164543a701852p-7,  -0x1.f7f592p-2, INEXACT)
T(RN,    0x1.2c9a4b608827cp+6,   -0x1.02cb66fc1885bp-2,    0x1.fa909p-2, INEXACT)
T(RN,     0x1.2b950096db93p+6,   -0x1.19837a86e00a3p-1,  -0x1.fdbed8p-2, INEXACT)
T(RN,    0x1.2a9098ec7eaa8p+6,   -0x1.e3bb1237c419ap-1,    0x1.fa9fcp-2, INEXACT)
T(RN,    0x1.298d139c05aafp+6,   -0x1.9803f8cb9dbacp+0,   0x1.fdbcfep-2, INEXACT)
T(RN,    0x1.288a6fe0b0689p+6,   -0x1.92afcb84845f4p+1,   0x1.ff1108p-2, INEXACT)
T(RN,    0x1.2788acf669b3dp+6,   -0x1.1d2faba4a82b1p+4,  -0x1.f667c6p-2, INEXACT)
T(RN,    0x1.2687ca19c7056p+6,    0x1.445742091aaf9p+2,   0x1.fe03fcp-2, INEXACT)
T(RN,    0x1.2587c688075a4p+6,    0x1.0c83512e85afdp+1,  -0x1.f7f70ap-2, INEXACT)
T(RN,    0x1.2488a17f13339p+6,    0x1.33a98d9bed819p+0,   0x1.f8941ap-2, INEXACT)
T(RN,    0x1.238a5a3d7bba2p+6,    0x1.741d7ce103e73p-1,   -0x1.f873bp-2, INEXACT)
T(RN,    0x1.228cf0027a378p+6,    0x1.9a30bb77b61c6p-2,    0x1.f6573p-2, INEXACT)
T(RN,    0x1.2190620def8d2p+6,    0x1.14da97fd2ca6cp-3,   0x1.fa8d3ap-2, INEXACT)
T(RN,    0x1.2094afa063919p+6,   -0x1.ca50a5526356fp-4,   0x1.f94d9ep-2, INEXACT)
T(RN,    0x1.1f99d7fb04913p+6,   -0x1.7d39b5da5ee56p-2,  -0x1.f7bfe8p-2, INEXACT)
T(RN,    0x1.1e9fda5fa6b11p+6,   -0x1.5eac27103e87ep-1,   0x1.f942fep-2, INEXACT)
T(RN,    0x1.1da6b610c36b2p+6,     -0x1.1fcf7c963d7p+0,   0x1.ff05cep-2, INEXACT)
T(RN,    0x1.1cae6a5178ef4p+6,   -0x1.e661ecd154cd4p+0,    0x1.feb7fp-2, INEXACT)
T(RN,    0x1.1bb6f665899cdp+6,   -0x1.0258eea762513p+2,    0x1.f9e24p-2, INEXACT)
T(RN,    0x1.1ac059915b759p+6,   -0x1.f243684856ea3p+8,   0x1.faeb22p-2, INEXACT)
T(RN,    0x1.19ca9319f78afp+6,     0x1.07cd43ef0b34p+2,  -0x1.fa11b4p-2, INEXACT)
T(RN,    0x1.18d5a24509759p+6,    0x1.ef19a32ae750bp+0,    0x1.f792ap-2, INEXACT)
T(RN,    0x1.17e18658debfdp+6,     0x1.267cebe11ee4p+0,  -0x1.f68a3cp-2, INEXACT)
T(RN,    0x1.16ee3e9c665b2p+6,    0x1.6bafcc432a275p-1,   0x1.fa8e2ap-2, INEXACT)
T(RN,    0x1.15fbca573022ap+6,    0x1.9a024fb9d7541p-2,    0x1.f9d6cp-2, INEXACT)
T(RN,    0x1.150a28d16c3a5p+6,    0x1.2ad0645e10e8ap-3,  -0x1.f6e7eep-2, INEXACT)
T(RN,    0x1.14195953ea953p+6,   -0x1.72cf3bc42b02ep-4,  -0x1.fda4c8p-2, INEXACT)
T(RN,    0x1.13295b281a3c7p+6,   -0x1.58a32394452fbp-2,  -0x1.f76db8p-2, INEXACT)
T(RN,    0x1.123a2d9809272p+6,   -0x1.3fbb93371c3dep-1,  -0x1.f6402ap-2, INEXACT)
T(RN,    0x1.114bcfee635e8p+6,   -0x1.02e2c90567c2ap+0,   0x1.f84282p-2, INEXACT)
T(RN,    0x1.105e41767255ep+6,   -0x1.a39c7916771e8p+0,  -0x1.fdaeaep-2, INEXACT)
T(RN,    0x1.0f71817c1cda2p+6,    -0x1.86b111848f77p+1,  -0x1.fb8c12p-2, INEXACT)
T(RN,    0x1.0e858f4be61b2p+6,   -0x1.725d3cfdee936p+3,  -0x1.f9ad34p-2, INEXACT)
T(RN,    0x1.0d9a6a32ed4ccp+6,    0x1.bb1876f452877p+2,  -0x1.f76f9ep-2, INEXACT)
T(RN,    0x1.0cb0117eed654p+6,    0x1.47c660552565fp+1,   0x1.f7dfdcp-2, INEXACT)
T(RN,    0x1.0bc6847e3bdd7p+6,    0x1.75e433599f1cap+0,  -0x1.ff5cfap-2, INEXACT)
T(RN,    0x1.0addc27fc8e68p+6,    0x1.d66faced29ee8p-1,   -0x1.fee6ap-2, INEXACT)
T(RN,    0x1.09f5cad31e8dcp+6,    0x1.22d5c55db57e5p-1,   0x1.fd121ep-2, INEXACT)
T(RN,    0x1.090e9cc8603d3p+6,    0x1.327e7c9915019p-2,   0x1.fc6532p-2, INEXACT)
T(RN,    0x1.082837b04a37fp+6,    0x1.0e06cfd0b6c86p-4,   0x1.fc945ap-2, INEXACT)
T(RN,    0x1.07429adc312cdp+6,   -0x1.4725d3941e09bp-3,   0x1.fa0bc2p-2, INEXACT)
T(RN,    0x1.065dc59e01841p+6,   -0x1.9b38f661b5e45p-2,   0x1.faf69ep-2, INEXACT)
T(RN,    0x1.0579b7483f035p+6,   -0x1.61bbb85743031p-1,  -0x1.fc809ap-2, INEXACT)
T(RN,    0x1.04966f2e043ecp+6,   -0x1.15fad6754fb1fp+0,   0x1.fd9666p-2, INEXACT)
T(RN,    0x1.03b3eca3020ebp+6,   -0x1.bbf5944b5c783p+0,  -0x1.f902eap-2, INEXACT)
T(RN,    0x1.02d22efb7f128p+6,   -0x1.99ffaed18d0e9p+1,   0x1.f7d8d8p-2, INEXACT)
T(RN,    0x1.01f1358c57348p+6,   -0x1.8117b0b485dcdp+3,   0x1.fc425ep-2, INEXACT)
T(RN,    0x1.0110ffaafb16ep+6,    0x1.d3832e0e9e8ebp+2,   0x1.fc2bdep-2, INEXACT)
T(RN,    0x1.00318cad6faabp+6,    0x1.5a127b0944815p+1,  -0x1.feea16p-2, INEXACT)
T(RN,    0x1.fea5b7d49b21ap+5,    0x1.8de0716ea1f73p+0,  -0x1.ff10e4p-2, INEXACT)
T(RN,    0x1.fce9d971816a4p+5,    0x1.fcde783a8a7f5p-1,   0x1.f8d3f6p-2, INEXACT)
T(RN,    0x1.fb2f7ce10f8d2p+5,    0x1.4588c14155455p-1,   0x1.f6e5ccp-2, INEXACT)
T(RN,    0x1.f976a0d3e7529p+5,    0x1.77084813e2cb8p-2,  -0x1.ffb5dap-2, INEXACT)
T(RN,    0x1.f7bf43fbce1bbp+5,    0x1.1961976a015edp-3,  -0x1.f7af6ep-2, INEXACT)
T(RN,    0x1.f609650babbf4p+5,   -0x1.3d1cb08268c01p-4,   0x1.facda2p-2, INEXACT)
T(RN,    0x1.f45502b789a49p+5,   -0x1.31f555b0b6586p-2,   -0x1.fc5b9p-2, INEXACT)
T(RN,    0x1.f2a21bb491c37p+5,   -0x1.1980eccbf59cap-1,  -0x1.f632aap-2, INEXACT)
T(RN,    0x1.f0f0aeb90d99bp+5,   -0x1.bbf33374741e8p-1,   0x1.f849e2p-2, INEXACT)
T(RN,    0x1.ef40ba7c654e5p+5,   -0x1.53e18cd1f3a01p+0,  -0x1.f7c59ep-2, INEXACT)
T(RN,    0x1.ed923db71e96cp+5,   -0x1.1333cc40d3084p+1,   0x1.fae4e4p-2, INEXACT)
T(RN,    0x1.ebe53722dbda3p+5,   -0x1.1685392d79d1ap+2,   0x1.fa869ep-2, INEXACT)
T(RN,     0x1.ea39a57a5b19p+5,   -0x1.d40a1c4768baep+5,   0x1.f5fb88p-2, INEXACT)
T(RN,    0x1.e88f8779755a4p+5,    0x1.4b0a34fde8e7ep+2,   0x1.fb451ap-2, INEXACT)
T(RN,    0x1.e6e6dbdd1cf75p+5,    0x1.30294e9f008dbp+1,  -0x1.fdc21cp-2, INEXACT)
T(RN,     0x1.e53fa1635d5ep+5,    0x1.7237f5e247101p+0,   -0x1.fc05fp-2, INEXACT)
T(RN,    0x1.e399d6cb59cc3p+5,    0x1.e67dbaa5764c5p-1,  -0x1.f94464p-2, INEXACT)
T(RN,    0x1.e1f57ad54c5adp+5,    0x1.3d295a825ae8ap-1,  -0x1.fa6d92p-2, INEXACT)
T(RN,    0x1.e0528c4285218p+5,    0x1.75d7bed82a4c9p-2,  -0x1.f7a01ep-2, INEXACT)
T(RN,     0x1.deb109d56939p+5,    0x1.2d893b7be959ep-3,   -0x1.f85d4p-2, INEXACT)
T(RN,    0x1.dd10f25171bc6p+5,    -0x1.d355463c23c4p-5,  -0x1.f6947ap-2, INEXACT)
T(RN,    0x1.db72447b2b235p+5,   -0x1.0fd201f28eea3p-2,   0x1.f980ecp-2, INEXACT)
T(RN,    0x1.d9d4ff1833c0bp+5,    -0x1.fcf1fbe7ed14p-2,   0x1.fcc858p-2, INEXACT)
T(RN,    0x1.d83920ef3b66ap+5,   -0x1.8f4f5be1659f4p-1,  -0x1.ffd776p-2, INEXACT)
T(RN,    0x1.d69ea8c80227fp+5,   -0x1.2b0aac7a9e6f9p+0,  -0x1.f8313cp-2, INEXACT)
T(RN,    0x1.d505956b579eap+5,   -0x1.cb8a161673003p+0,   0x1.fda656p-2, INEXACT)
T(RN,    0x1.d36de5a319beap+5,   -0x1.90b2eb1bd3bd7p+1,  -0x1.ff61d6p-2, INEXACT)
T(RN,    0x1.d1d7983a341ccp+5,   -0x1.1f9bb4641170ep+3,   0x1.f78c2ep-2, INEXACT)
T(RN,    0x1.d042abfc9f051p+5,    0x1.6f458a72f1e08p+3,   0x1.fe89f2p-2, INEXACT)
T(RN,    0x1.ceaf1fb75e6e4p+5,    0x1.b6987ab1bd1a9p+1,   0x1.f6b976p-2, INEXACT)
T(RN,     0x1.cd1cf2388135p+5,    0x1.eb5578c7f31fap+0,   0x1.f6698cp-2, INEXACT)
T(RN,    0x1.cb8c224f2028bp+5,    0x1.3f2650e5e18d1p+0,   0x1.faf14ap-2, INEXACT)
T(RN,    0x1.c9fcaecb5d04ep+5,    0x1.af00058811354p-1,  -0x1.f7ddeap-2, INEXACT)
T(RN,    0x1.c86e967e61bc1p+5,    0x1.1b42c46bb0ab7p-1,   0x1.f901f8p-2, INEXACT)
T(RN,    0x1.c6e1d83a5f7ffp+5,    0x1.49d4efa40d2dfp-2,   0x1.f6de86p-2, INEXACT)
T(RN,    0x1.c55672d28dcddp+5,    0x1.e7d756b84466bp-4,  -0x1.fa454cp-2, INEXACT)
T(RN,    0x1.c3cc651b299a4p+5,   -0x1.2f1acfaf61454p-4,  -0x1.f91416p-2, INEXACT)
T(RN,    0x1.c243ade9746a8p+5,   -0x1.16942d828831fp-2,  -0x1.f7ccf2p-2, INEXACT)
T(RN,    0x1.c0bc4c13b3729p+5,   -0x1.f72ba4aebaca2p-2,  -0x1.f9b412p-2, INEXACT)
T(RN,    0x1.bf363e712e96cp+5,   -0x1.82f3d451b307cp-1,   0x1.f64bd6p-2, INEXACT)
T(RN,    0x1.bdb183da3002dp+5,   -0x1.1be0d9a5393bcp+0,   0x1.fbfebep-2, INEXACT)
T(RN,    0x1.bc2e1b2802651p+5,    -0x1.a69cbacaac72p+0,   0x1.fbfd64p-2, INEXACT)
T(RN,    0x1.baac0334f0ee2p+5,   -0x1.581b1d0bc210cp+1,   0x1.f95ac8p-2, INEXACT)
T(RN,    0x1.b92b3adc460d3p+5,   -0x1.78d1eee62024ap+2,  -0x1.fa0f78p-2, INEXACT)
T(RN,    0x1.b7abc0fa4a91fp+5,    0x1.a4d747865e9e3p+5,  -0x1.f6374ep-2, INEXACT)
T(RN,    0x1.b62d946c44ecap+5,     0x1.32dc85c4e73fp+2,   0x1.fed95ep-2, INEXACT)
T(RN,    0x1.b4b0b410782cap+5,    0x1.35fdaabdedb84p+1,   0x1.f5ec28p-2, INEXACT)
T(RN,    0x1.b3351ec62362bp+5,    0x1.895d76682e359p+0,  -0x1.f5f124p-2, INEXACT)
T(RN,    0x1.b1bad36d80745p+5,    0x1.0c7558fb88821p+0,  -0x1.fd8808p-2, INEXACT)
T(RN,    0x1.b041d0e7c3741p+5,    0x1.7172b0f0a6507p-1,  -0x1.f816eap-2, INEXACT)
T(RN,    0x1.aeca161719ca3p+5,    0x1.e41503d433ae3p-2,    0x1.f9055p-2, INEXACT)
T(RN,    0x1.ad53a1dea94b6p+5,    0x1.0f0c46e60decdp-2,   0x1.fcc708p-2, INEXACT)
T(RN,    0x1.abde73228f688p+5,    0x1.3a223110bae37p-4,   0x1.f68352p-2, INEXACT)
T(RN,    0x1.aa6a88c7e057fp+5,   -0x1.afe6b2f37c93ep-4,    0x1.f6838p-2, INEXACT)
T(RN,    0x1.a8f7e1b4a630dp+5,   -0x1.2d29ac6bf0667p-2,    0x1.ff0a1p-2, INEXACT)
T(RN,    0x1.a7867ccfe024dp+5,   -0x1.01c4c8bbaa466p-1,  -0x1.f8d784p-2, INEXACT)
T(RN,    0x1.a616590181b81p+5,   -0x1.82224799daa39p-1,   0x1.f6f96ep-2, INEXACT)
T(RN,    0x1.a4a7753271bcep+5,   -0x1.154b9cdbb323ap+0,  -0x1.f5ead6p-2, INEXACT)
T(RN,    0x1.a339d04c89be6p+5,   -0x1.9216d645054a7p+0,   0x1.f77614p-2, INEXACT)
T(RN,    0x1.a1cd693a94f61p+5,   -0x1.3843a2baaa7b1p+1,   0x1.fb9084p-2, INEXACT)
T(RN,    0x1.a0623ee84fa1dp+5,   -0x1.29cb96915c36dp+2,   0x1.fe7a56p-2, INEXACT)
T(RN,    0x1.9ef8504266185p+5,   -0x1.c95fc2081766ap+4,   0x1.ffecdcp-2, INEXACT)
T(RN,     0x1.9d8f9c36740ap+5,     0x1.c261bad6d8fdp+2,    0x1.fe5e4p-2, INEXACT)
T(RN,    0x1.9c2821b303a26p+5,    0x1.8696191694dbcp+1,  -0x1.fde03cp-2, INEXACT)
T(RN,    0x1.9ac1dfa78cc54p+5,    0x1.de1745e8812efp+0,  -0x1.fcd138p-2, INEXACT)
T(RN,    0x1.995cd504743dep+5,    0x1.45d4a7166a0f2p+0,  -0x1.f61aeep-2, INEXACT)
T(RN,    0x1.97f900bb0aed2p+5,    0x1.cb36c3a33b415p-1,  -0x1.fc4a84p-2, INEXACT)
T(RN,    0x1.969661bd8cebdp+5,    0x1.3f88fee94b8f8p-1,  -0x1.ffb6d2p-2, INEXACT)
T(RN,    0x1.9534f6ff20e76p+5,    0x1.9f664a85ea60fp-2,   0x1.fa11d6p-2, INEXACT)
T(RN,    0x1.93d4bf73d7307p+5,    0x1.bbcc080bfe9c8p-3,   0x1.ff0ac8p-2, INEXACT)
T(RN,    0x1.9275ba10a901cp+5,    0x1.584706cb0409fp-5,  -0x1.f76d42p-2, INEXACT)
T(RN,    0x1.9117e5cb77adcp+5,     -0x1.0947817c18dp-3,  -0x1.fbc064p-2, INEXACT)
T(RN,    0x1.8fbb419b0bdbep+5,   -0x1.3bb17d9f66368p-2,  -0x1.f60866p-2, INEXACT)
T(RN,    0x1.8e5fcc7714c7fp+5,   -0x1.033ed5a3ccd1ap-1,  -0x1.f9a12cp-2, INEXACT)
T(RN,    0x1.8d058558274c5p+5,   -0x1.7b72ac9a28adfp-1,   0x1.f6cf2ep-2, INEXACT)
T(RN,    0x1.8bac6b37bd664p+5,   -0x1.0aedab791df7dp+0,   0x1.fe373ep-2, INEXACT)
T(RN,    0x1.8a547d103522cp+5,   -0x1.78f6bb16f87e6p+0,  -0x1.ff3d9ap-2, INEXACT)
T(RN,    0x1.88fdb9dcd004cp+5,   -0x1.17af69ccd3a13p+1,  -0x1.fc175ap-2, INEXACT)
T(RN,    0x1.87a82099b2369p+5,   -0x1.dc8b24b12ab3ep+1,  -0x1.fc4aa8p-2, INEXACT)
T(RN,    0x1.8653b043e1ca5p+5,   -0x1.4bb12248ac9abp+3,  -0x1.f9680cp-2, INEXACT)
T(RN,    0x1.850067d945df6p+5,    0x1.cbc4f4b2782d2p+3,   0x1.f6862ep-2, INEXACT)
T(RN,    0x1.83ae4658a5f54p+5,    0x1.0bcaca8219908p+2,   0x1.f8439cp-2, INEXACT)
T(RN,    0x1.825d4ac1a91e3p+5,    0x1.2f7b4069988f4p+1,   0x1.f6ec24p-2, INEXACT)
T(RN,    0x1.810d7414d5436p+5,    0x1.9583210196dd9p+0,   -0x1.fd0c2p-2, INEXACT)
T(RN,    0x1.7fbec1538e50fp+5,     0x1.200e9c3e0d33p+0,  -0x1.f77792p-2, INEXACT)
T(RN,    0x1.7e71318015ab9p+5,    0x1.9f34721851705p-1,  -0x1.fc967cp-2, INEXACT)
T(RN,     0x1.7d24c39d890fp+5,     0x1.24838fd9f45fp-1,   0x1.fc5b54p-2, INEXACT)
T(RN,    0x1.7bd976afe2386p+5,    0x1.7e4696ff8879bp-2,  -0x1.f9b59ep-2, INEXACT)
T(RN,    0x1.7a8f49bbf5b89p+5,    0x1.96c9c524403a4p-3,  -0x1.f6d7c8p-2, INEXACT)
T(RN,     0x1.79463bc772e6p+5,    0x1.2226674a9303dp-5,  -0x1.f957cap-2, INEXACT)
T(RN,    0x1.77fe4bd8e2279p+5,   -0x1.00c3459b65b29p-3,  -0x1.f846b8p-2, INEXACT)
T(RN,    0x1.76b778f7a4f7cp+5,   -0x1.2b3b9cc411703p-2,  -0x1.f64054p-2, INEXACT)
T(RN,    0x1.7571c22bf5085p+5,   -0x1.e644c5f049406p-2,  -0x1.f6d8c8p-2, INEXACT)
T(RN,    0x1.742d267ee3333p+5,    -0x1.5faa656c4b47p-1,   0x1.fb6f74p-2, INEXACT)
T(RN,    0x1.72e9a4fa57173p+5,   -0x1.e67115c59288ap-1,    0x1.fe6e5p-2, INEXACT)
T(RN,    0x1.71a73ca90e3eep+5,   -0x1.4e456bfa5cfd7p+0,   0x1.f8fe62p-2, INEXACT)
T(RN,    0x1.7065ec969b509p+5,   -0x1.d854eede3e8fbp+0,   0x1.fd7f44p-2, INEXACT)
T(RN,    0x1.6f25b3cf6575dp+5,   -0x1.697cd585387f2p+1,   -0x1.fc804p-2, INEXACT)
T(RN,    0x1.6de69160a79c7p+5,   -0x1.56f5dbc71e054p+2,   0x1.f7a012p-2, INEXACT)
T(RN,    0x1.6ca884586fa66p+5,    -0x1.11fc99bc5279p+5,   0x1.f5fb92p-2, INEXACT)
T(RN,    0x1.6b6b8bc59dd34p+5,    0x1.faf3410029261p+2,  -0x1.f8964ap-2, INEXACT)
T(RN,    0x1.6a2fa6b7e3ee3p+5,    0x1.bd6cb47e6b8f9p+1,   0x1.f73512p-2, INEXACT)
T(RN,    0x1.68f4d43fc4accp+5,    0x1.148117dd8d15dp+1,  -0x1.f8f5ecp-2, INEXACT)
T(RN,    0x1.67bb136e92f19p+5,    0x1.810bc354972fcp+0,    0x1.fa396p-2, INEXACT)
T(RN,    0x1.66826356710b6p+5,    0x1.18b07c07abc86p+0,   0x1.f84f2ap-2, INEXACT)
T(RN,     0x1.654ac30a500fp+5,    0x1.9d5d359cdecdfp-1,   0x1.fb3a0ep-2, INEXACT)
T(RN,    0x1.6414319def282p+5,    0x1.2a50dd8bce3edp-1,  -0x1.fb4b9cp-2, INEXACT)
T(RN,    0x1.62deae25daa7fp+5,    0x1.94c5152adfb7ep-2,  -0x1.f5c6aap-2, INEXACT)
T(RN,    0x1.61aa37b76c4a9p+5,    0x1.d67f706b7bed5p-3,   0x1.fa653cp-2, INEXACT)
T(RN,    0x1.6076cd68c89fep+5,    0x1.36b5a525fd637p-4,  -0x1.f7045ep-2, INEXACT)
T(RN,    0x1.5f446e50e03b7p+5,   -0x1.2f2ddcb2093b4p-4,   0x1.f6cfc6p-2, INEXACT)
T(RN,    0x1.5e1319876e206p+5,   -0x1.d05daf80d45f4p-3,   0x1.f786d4p-2, INEXACT)
T(RN,    0x1.5ce2ce24f72e4p+5,   -0x1.8f0074bdbae0ep-2,  -0x1.fc7cb6p-2, INEXACT)
T(RN,    0x1.5bb38b42c9786p+5,   -0x1.24e64d24caac1p-1,   0x1.f64da2p-2, INEXACT)
T(RN,    0x1.5a854ffafbaadp+5,   -0x1.934efb5a8321bp-1,   0x1.fb1092p-2, INEXACT)
T(RN,    0x1.59581b686c335p+5,   -0x1.0f3ac3a42ac6ap+0,    0x1.fcc4dp-2, INEXACT)
T(RN,    0x1.582beca6c0b27p+5,   -0x1.6e5255be4cd03p+0,   0x1.f7903ep-2, INEXACT)
T(RN,    0x1.5700c2d2654a7p+5,   -0x1.ffb6e84574a39p+0,   0x1.f8763ep-2, INEXACT)
T(RN,    0x1.55d69d088be69p+5,   -0x1.84798f5b8b4f6p+1,   0x1.f63444p-2, INEXACT)
T(RN,    0x1.54ad7a672ba9fp+5,   -0x1.6dcd1ecc1d0e5p+2,  -0x1.f6a5dcp-2, INEXACT)
T(RN,    0x1.53855a0d00165p+5,   -0x1.1785f8cad0949p+5,  -0x1.f8ff06p-2, INEXACT)
T(RN,    0x1.525e3b1988928p+5,    0x1.13d91c7975204p+3,  -0x1.f68d4ep-2, INEXACT)
T(RN,    0x1.51381cad079f5p+5,    0x1.e2e88c1528a77p+1,   0x1.f65536p-2, INEXACT)
T(RN,    0x1.5012fde8823aap+5,    0x1.2ce0d0c740899p+1,   0x1.fa5874p-2, INEXACT)
T(RN,    0x1.4eeeddedbf2fdp+5,    0x1.a665bf54df726p+0,  -0x1.f89cdep-2, INEXACT)
T(RN,    0x1.4dcbbbdf4683cp+5,    0x1.3810bfc65459ep+0,  -0x1.fe688cp-2, INEXACT)
T(RN,    0x1.4ca996e060aaep+5,    0x1.d57adb4121fdcp-1,  -0x1.f9608cp-2, INEXACT)
T(RN,    0x1.4b886e1516004p+5,    0x1.5ef6b8bc6094ap-1,    0x1.f656dp-2, INEXACT)
T(RN,    0x1.4a6840a22e089p+5,    0x1.fb983ccdf0779p-2,   0x1.f9cf54p-2, INEXACT)
T(RN,    0x1.49490dad2ede4p+5,    0x1.534de33fa384bp-2,  -0x1.fe29aep-2, INEXACT)
T(RN,    0x1.482ad45c5c7fap+5,    0x1.751d4dbd37eebp-3,  -0x1.fabafep-2, INEXACT)
T(RN,    0x1.470d93d6b8313p+5,    0x1.4f722fb5b72f3p-5,   0x1.f77bbap-2, INEXACT)
T(RN,     0x1.45f14b43ffcap+5,   -0x1.92391a863451cp-4,  -0x1.f64facp-2, INEXACT)
T(RN,    0x1.44d5f9ccad31bp+5,   -0x1.ecfdc396dc024p-3,   0x1.f92c36p-2, INEXACT)
T(RN,    0x1.43bb9e99f5614p+5,   -0x1.9200754af93d9p-2,  -0x1.f61786p-2, INEXACT)
T(RN,    0x1.42a238d5c8dc8p+5,   -0x1.1f65a9ab0995cp-1,   -0x1.fbfefp-2, INEXACT)
T(RN,    0x1.4189c7aad0f44p+5,   -0x1.83f502d8efc5ap-1,    0x1.fcdf6p-2, INEXACT)
T(RN,    0x1.40724a44714cfp+5,   -0x1.ff7d27b37eba1p-1,  -0x1.f9b998p-2, INEXACT)
T(RN,    0x1.3f5bbfcec619ep+5,   -0x1.50d3da4031a1cp+0,   -0x1.fcb8fp-2, INEXACT)
T(RN,    0x1.3e462776a3bb7p+5,   -0x1.c5089af0bbc51p+0,   0x1.f747f2p-2, INEXACT)
T(RN,    0x1.3d318069962d4p+5,    -0x1.41286b08acb8p+1,   -0x1.fec5ap-2, INEXACT)
T(RN,    0x1.3c1dc9d5e046dp+5,   -0x1.005f4e14de57ap+2,  -0x1.fe1414p-2, INEXACT)
T(RN,    0x1.3b0b02ea7b3edp+5,   -0x1.207eff6a24245p+3,  -0x1.fd40c6p-2, INEXACT)
T(RN,    0x1.39f92ad715f4bp+5,    0x1.581b45291a8afp+5,   0x1.f77314p-2, INEXACT)
T(RN,    0x1.38e840cc1441bp+5,    0x1.9597c0cfc675dp+2,  -0x1.f5e212p-2, INEXACT)
T(RN,    0x1.37d843fa8eddap+5,    0x1.ae04e008d8e8ep+1,  -0x1.ff2598p-2, INEXACT)
T(RN,    0x1.36c9339451c23p+5,    0x1.1d59b009b34e8p+1,   0x1.f8e3d8p-2, INEXACT)
T(RN,    0x1.35bb0ecbdc7bep+5,    0x1.9e38301a4a416p+0,   0x1.f9295ep-2, INEXACT)
T(RN,    0x1.34add4d4614b2p+5,    0x1.39560c52765a3p+0,   0x1.fab66ep-2, INEXACT)
T(RN,    0x1.33a184e1c431bp+5,    0x1.e18b84df2e745p-1,  -0x1.fb15b2p-2, INEXACT)
T(RN,    0x1.32961e289acc9p+5,    0x1.70c4a52ce55d8p-1,   0x1.f7bffap-2, INEXACT)
T(RN,    0x1.318b9fde2b91bp+5,    0x1.13c5fed8bc61ep-1,   0x1.fadfa6p-2, INEXACT)
T(RN,    0x1.308209386cfacp+5,    0x1.86917ae544795p-2,   0x1.fb8166p-2, INEXACT)
T(RN,    0x1.2f79596e054a8p+5,    0x1.eaa501f63484cp-3,     0x1.faedp-2, INEXACT)
T(RN,    0x1.2e718fb649b1ap+5,    0x1.b535b83d0b2e7p-4,    0x1.f66d3p-2, INEXACT)
T(RN,    0x1.2d6aab493def8p+5,   -0x1.68f441a922ad6p-6,  -0x1.f9b1d6p-2, INEXACT)
T(RN,    0x1.2c64ab5f9377dp+5,   -0x1.356f3dc1a868bp-3,   0x1.f8548ep-2, INEXACT)
T(RN,    0x1.2b5f8f32a8fafp+5,   -0x1.23a1fe989c6d4p-2,    0x1.fc072p-2, INEXACT)
T(RN,    0x1.2a5b55fc89da6p+5,   -0x1.b6664c6e6cf9cp-2,   -0x1.f99b8p-2, INEXACT)
T(RN,    0x1.2957fef7ed9d8p+5,   -0x1.2cc70f430e3eep-1,   0x1.ffe55ep-2, INEXACT)
T(RN,    0x1.2855896037241p+5,   -0x1.8b315a08c9fb7p-1,  -0x1.f97804p-2, INEXACT)
T(RN,    0x1.2753f4717448bp+5,   -0x1.fdabb21be46e7p-1,   0x1.f96e2ap-2, INEXACT)
T(RN,    0x1.26533f685d363p+5,   -0x1.4844b7f2855e3p+0,  -0x1.fbd6e4p-2, INEXACT)
T(RN,    0x1.2553698253ce8p+5,   -0x1.ad96c02c775fap+0,  -0x1.f9d726p-2, INEXACT)
T(RN,    0x1.245471fd63368p+5,   -0x1.242afa6db1eaep+1,  -0x1.fbf434p-2, INEXACT)
T(RN,    0x1.235658183effap+5,   -0x1.aec0670b741f7p+1,  -0x1.fb2fb4p-2, INEXACT)
T(RN,    0x1.22591b1241f95p+5,   -0x1.7fe50c43f0995p+2,  -0x1.f5c91ap-2, INEXACT)
T(RN,    0x1.215cba2b7210ap+5,   -0x1.7d141bbad4433p+4,  -0x1.f97d06p-2, INEXACT)
T(RN,    0x1.206134a47680cp+5,    0x1.8aec45c2d0bddp+3,  -0x1.f77f8ep-2, INEXACT)
T(RN,    0x1.1f6689bea07f5p+5,    0x1.3689c3aa6dfcdp+2,  -0x1.f7ae8cp-2, INEXACT)
T(RN,    0x1.1e6cb8bbe6303p+5,    0x1.7b9804841eff8p+1,   0x1.f82786p-2, INEXACT)
T(RN,    0x1.1d73c0dee2cacp+5,    0x1.0b29ab590adfcp+1,   -0x1.f7f96p-2, INEXACT)
T(RN,    0x1.1c7ba16ad63a3p+5,    0x1.91345260abff9p+0,  -0x1.fa1708p-2, INEXACT)
T(RN,    0x1.1b8459a3a473ap+5,    0x1.370138386c29fp+0,   0x1.fc90c4p-2, INEXACT)
T(RN,    0x1.1a8de8cdd4ecfp+5,    0x1.e85c850b2d65ep-1,  -0x1.f98572p-2, INEXACT)
T(RN,    0x1.19984e2e9213ep+5,    0x1.7eae00557ce48p-1,   0x1.f853d2p-2, INEXACT)
T(RN,    0x1.18a3890ba8beap+5,    0x1.26bd3d4bcaa34p-1,  -0x1.f9a266p-2, INEXACT)
T(RN,    0x1.17af98ab87955p+5,    0x1.b4d56f774f2b3p-2,   0x1.f9a5d2p-2, INEXACT)
T(RN,    0x1.16bc7c553beffp+5,    0x1.2b77b720741bfp-2,   0x1.f5c36ap-2, INEXACT)
T(RN,    0x1.15ca33507e76ep+5,     0x1.57922324cf94p-3,   0x1.fba9c2p-2, INEXACT)
T(RN,    0x1.14d8bce5982a6p+5,    0x1.8c0ffe79888dcp-5,   0x1.feaed6p-2, INEXACT)
T(RN,    0x1.13e8185d7c49dp+5,   -0x1.1bdc839faa61cp-4,   0x1.faa158p-2, INEXACT)
T(RN,    0x1.12f84501ba8c3p+5,    -0x1.82016efc4076p-3,   -0x1.fc1bfp-2, INEXACT)
T(RN,    0x1.1209421c8141bp+5,   -0x1.4020b72a59dc6p-2,  -0x1.fa438ap-2, INEXACT)
T(RN,    0x1.111b0ef89cbfep+5,   -0x1.c8707fb34d881p-2,   0x1.fd1cb4p-2, INEXACT)
T(RN,    0x1.102daae176dbep+5,   -0x1.2f975441d1a36p-1,   0x1.f6c4aep-2, INEXACT)
T(RN,     0x1.0f4115231665p+5,    -0x1.85d2c43f5158p-1,   0x1.f6a4fap-2, INEXACT)
T(RN,    0x1.0e554d0a1eb5dp+5,   -0x1.ec61d17b088efp-1,   -0x1.ff111p-2, INEXACT)
T(RN,    0x1.0d6a51e3cedb2p+5,   -0x1.360e511816bacp+0,  -0x1.fcc7eap-2, INEXACT)
T(RN,    0x1.0c8022fe016edp+5,   -0x1.8a4df3bda1804p+0,  -0x1.fad4a8p-2, INEXACT)
T(RN,    0x1.0b96bfa72bcc1p+5,   -0x1.0121d41f04729p+1,  -0x1.fe47a4p-2, INEXACT)
T(RN,    0x1.0aae272e5da95p+5,   -0x1.6080b8a116845p+1,  -0x1.f78bc6p-2, INEXACT)
T(RN,    0x1.09c658e340955p+5,   -0x1.0b28d17e557eep+2,   0x1.f5de38p-2, INEXACT)
T(RN,    0x1.08df541617542p+5,    -0x1.044b3246f042p+3,   0x1.fb4144p-2, INEXACT)
T(RN,    0x1.07f91817bd711p+5,   -0x1.93d17a5e1f36fp+6,    0x1.fc9d1p-2, INEXACT)
T(RN,    0x1.0713a439a6b81p+5,    0x1.383a9e2a45e66p+3,  -0x1.fb2414p-2, INEXACT)
T(RN,    0x1.062ef7cddea81p+5,    0x1.26c9101978a74p+2,  -0x1.f723dep-2, INEXACT)
T(RN,    0x1.054b122707fcbp+5,    0x1.7bcbec0e710fep+1,   0x1.f7f45ap-2, INEXACT)
T(RN,    0x1.0467f2985c1b5p+5,    0x1.12c23e8dc1b1cp+1,   0x1.f8e85ap-2, INEXACT)
T(RN,    0x1.03859875aa9d1p+5,    0x1.a4da9ab927bffp+0,   0x1.fd01c8p-2, INEXACT)
T(RN,    0x1.02a4031358c76p+5,    0x1.4c26b797ef5bbp+0,  -0x1.f7332cp-2, INEXACT)
T(RN,    0x1.01c331c661003p+5,    0x1.09e8e163ad264p+0,  -0x1.f798aap-2, INEXACT)
T(RN,    0x1.00e323e45262ap+5,    0x1.aae0c15f6acb8p-1,  -0x1.fdbf1ap-2, INEXACT)
T(RN,    0x1.0003d8c350291p+5,    0x1.53d1952874236p-1,  -0x1.fd765cp-2, INEXACT)
T(RN,    0x1.fe4a9f74226bfp+4,     0x1.08cafba5a92ep-1,   0x1.fa6122p-2, INEXACT)
T(RN,    0x1.fc8f103fbf1acp+4,    0x1.8bfedc05c79bdp-2,  -0x1.f7807ep-2, INEXACT)
T(RN,    0x1.fad502992fc7ap+4,    0x1.1196991817e54p-2,  -0x1.f73936p-2, INEXACT)
T(RN,    0x1.f91c7531520f3p+4,    0x1.3ce7aae5ce02bp-3,   0x1.f8bceap-2, INEXACT)
T(RN,    0x1.f76566ba26ea9p+4,     0x1.7bcddd0fcfebp-5,   0x1.fb273ep-2, INEXACT)
T(RN,    0x1.f5afd5e6d1afdp+4,   -0x1.f03460335b516p-5,  -0x1.f69e4ep-2, INEXACT)
T(RN,    0x1.f3fbc16b96edap+4,   -0x1.5927295bb56dfp-3,  -0x1.fd5b7ap-2, INEXACT)
T(RN,    0x1.f24927fddba0bp+4,   -0x1.1ec88e139d452p-2,  -0x1.fc36cep-2, INEXACT)
T(RN,    0x1.f098085424196p+4,   -0x1.9795dd944498ep-2,  -0x1.f5d464p-2, INEXACT)
T(RN,    0x1.eee861261325ap+4,   -0x1.0d499f7173e41p-1,     0x1.f948p-2, INEXACT)
T(RN,    0x1.ed3a312c68e3cp+4,   -0x1.563be86cf036fp-1,   0x1.fef248p-2, INEXACT)
T(RN,    0x1.eb8d772101ec8p+4,   -0x1.a9ee33cb48349p-1,   0x1.f93e32p-2, INEXACT)
T(RN,    0x1.e9e231bed65f4p+4,    -0x1.06a442fe98b9p+0,   0x1.fbc822p-2, INEXACT)
T(RN,    0x1.e8385fc1f8da7p+4,   -0x1.4409a672ce706p+0,  -0x1.f9d364p-2, INEXACT)
T(RN,    0x1.e68fffe7958dap+4,   -0x1.93cd7444d2302p+0,   0x1.fe5b68p-2, INEXACT)
T(RN,    0x1.e4e910edf14f6p+4,   -0x1.0134abea8ccbcp+1,  -0x1.fb5f94p-2, INEXACT)
T(RN,    0x1.e34391946889bp+4,   -0x1.553bfd5daa452p+1,  -0x1.f9b50ap-2, INEXACT)
T(RN,    0x1.e19f809b6e6fdp+4,   -0x1.e868da4642e08p+1,   0x1.f5e2c2p-2, INEXACT)
T(RN,    0x1.dffcdcc48bf1cp+4,   -0x1.9c0305f3ad895p+2,   0x1.fcaabcp-2, INEXACT)
T(RN,     0x1.de5ba4d25ec5p+4,   -0x1.31fa57ec96ec7p+4,  -0x1.ffae14p-2, INEXACT)
T(RN,    0x1.dcbbd7889899bp+4,     0x1.4479dbb89137p+4,    0x1.f6a59p-2, INEXACT)
T(RN,    0x1.db1d73abfdf62p+4,    0x1.a6347e414dcaep+2,  -0x1.f938e8p-2, INEXACT)
T(RN,    0x1.d9807802656fbp+4,    0x1.f2a79b6c8bddfp+1,  -0x1.fe272ap-2, INEXACT)
T(RN,    0x1.d7e4e352b6b41p+4,    0x1.5cc321f20c1c2p+1,   0x1.fd97d2p-2, INEXACT)
T(RN,    0x1.d64ab464e98e8p+4,    0x1.07b48bd05be6bp+1,  -0x1.fe1dd4p-2, INEXACT)
T(RN,    0x1.d4b1ea02050a7p+4,    0x1.9ff6a7bfe2bb9p+0,   0x1.f7e124p-2, INEXACT)
T(RN,    0x1.d31a82f41e7c2p+4,    0x1.4ff18ef837cf2p+0,   0x1.f85d3ep-2, INEXACT)
T(RN,    0x1.d1847e06589e4p+4,    0x1.12a4161b816eap+0,   -0x1.f8717p-2, INEXACT)
T(RN,    0x1.cfefda04e2a5ap+4,    0x1.c29f5c6a96e8bp-1,   -0x1.fb43cp-2, INEXACT)
T(RN,    0x1.ce5c95bcf757ep+4,    0x1.700e05318b7b2p-1,  -0x1.fbf21ep-2, INEXACT)
T(RN,    0x1.cccaaffcdc1d3p+4,     0x1.28a9db4e5cc2p-1,   0x1.fbf52cp-2, INEXACT)
T(RN,    0x1.cb3a2793e01eap+4,    0x1.d25d68b1a1801p-2,  -0x1.f6823cp-2, INEXACT)
T(RN,     0x1.c9aafb525b5dp+4,    0x1.5ea46448d8a84p-2,   0x1.fa1b0ep-2, INEXACT)
T(RN,    0x1.c81d2a09add9dp+4,    0x1.e58c77cef9853p-3,   0x1.fbb8bep-2, INEXACT)
T(RN,    0x1.c690b28c3e8a9p+4,    0x1.183e1fba4f7e9p-3,   0x1.fddea4p-2, INEXACT)
T(RN,    0x1.c50593ad7a92cp+4,    0x1.43fab48fa9b4bp-5,   0x1.f88286p-2, INEXACT)
T(RN,    0x1.c37bcc41d47ecp+4,   -0x1.d03e512f6b7f3p-5,    0x1.f7607p-2, INEXACT)
T(RN,    0x1.c1f35b1ec300bp+4,   -0x1.3a990d5ee34c1p-3,  -0x1.faa16cp-2, INEXACT)
T(RN,    0x1.c06c3f1ac05e8p+4,    -0x1.03301689615ep-2,   0x1.f63b84p-2, INEXACT)
T(RN,    0x1.bee6770d49b13p+4,   -0x1.6dc3e18c457fdp-2,  -0x1.f63b82p-2, INEXACT)
T(RN,    0x1.bd6201cedd81fp+4,   -0x1.df767ab072bffp-2,   0x1.fe5bc2p-2, INEXACT)
T(RN,    0x1.bbdede38fb534p+4,   -0x1.2da87d7bf0085p-1,   0x1.f70726p-2, INEXACT)
T(RN,    0x1.ba5d0b2622ac3p+4,   -0x1.72a949ae89aa4p-1,  -0x1.f97b22p-2, INEXACT)
T(RN,    0x1.b8dc8771d22b7p+4,   -0x1.c1819965d0bc9p-1,  -0x1.f7942ap-2, INEXACT)
T(RN,    0x1.b75d51f886bc2p+4,   -0x1.0f1b67c14fb2ap+0,   0x1.fdd58ap-2, INEXACT)
T(RN,    0x1.b5df6997ba8edp+4,   -0x1.47799eba4e21ap+0,   -0x1.f7d2ep-2, INEXACT)
T(RN,    0x1.b462cd2de4914p+4,   -0x1.8ee1fa269b532p+0,   0x1.feb372p-2, INEXACT)
T(RN,    0x1.b2e77b9a77238p+4,   -0x1.ee2b1e4f2b625p+0,  -0x1.fa3468p-2, INEXACT)
T(RN,    0x1.b16d73bddf973p+4,   -0x1.3b41a27aa0867p+1,  -0x1.f80948p-2, INEXACT)
T(RN,    0x1.aff4b479852d6p+4,   -0x1.a73522e44d0fep+1,   0x1.ff4bcep-2, INEXACT)
T(RN,    0x1.ae7d3cafc8486p+4,   -0x1.3873493352eb8p+2,    0x1.f79f1p-2, INEXACT)
T(RN,    0x1.ad070b440189ap+4,   -0x1.1fef3e26b1bd5p+3,   0x1.fa5f08p-2, INEXACT)
T(RN,    0x1.ab921f1a810e7p+4,   -0x1.97596e732b018p+5,  -0x1.fb134ap-2, INEXACT)
T(RN,    0x1.aa1e77188d7a5p+4,    0x1.c1502e0007ec6p+3,   0x1.ff6158p-2, INEXACT)
T(RN,    0x1.a8ac12246339dp+4,    0x1.88c3979e96633p+2,   0x1.f6c924p-2, INEXACT)
T(RN,     0x1.a73aef25339dp+4,    0x1.f1dc95e84d8ddp+1,  -0x1.f78358p-2, INEXACT)
T(RN,    0x1.a5cb0d0324185p+4,    0x1.682c12fdf0f96p+1,  -0x1.fdaf14p-2, INEXACT)
T(RN,    0x1.a45c6aa74d566p+4,    0x1.1661888be487cp+1,  -0x1.f81e8ep-2, INEXACT)
T(RN,    0x1.a2ef06fbba701p+4,    0x1.beece4e0bead5p+0,   0x1.f5cf36p-2, INEXACT)
T(RN,    0x1.a182e0eb681ccp+4,    0x1.6efeafef5bedep+0,  -0x1.f9536ap-2, INEXACT)
T(RN,    0x1.a017f76243dc6p+4,    0x1.315d6eced41acp+0,   0x1.f86e14p-2, INEXACT)
T(RN,    0x1.9eae494d2b275p+4,    0x1.ff65aef54c8fdp-1,    0x1.fef5fp-2, INEXACT)
T(RN,    0x1.9d45d599eaa2fp+4,    0x1.ac772ce939b97p-1,  -0x1.f85806p-2, INEXACT)
T(RN,    0x1.9bde9b373d41ep+4,    0x1.652a62ece61a2p-1,   0x1.f7e104p-2, INEXACT)
T(RN,    0x1.9a789914cb82bp+4,    0x1.264f4484b8b02p-1,   0x1.ffa7f8p-2, INEXACT)
T(RN,    0x1.9913ce232aaa2p+4,    0x1.db55705dae6fdp-2,  -0x1.fee0b4p-2, INEXACT)
T(RN,     0x1.97b03953dbd5p+4,    0x1.7337b5b3b2c37p-2,   0x1.fed8bcp-2, INEXACT)
T(RN,    0x1.964dd9994b4d2p+4,    0x1.11cb2ef0341ccp-2,   -0x1.fd95ap-2, INEXACT)
T(RN,    0x1.94ecade6cfa8ap+4,    0x1.6a313d33edd1bp-3,   0x1.f8d9a6p-2, INEXACT)
T(RN,    0x1.938cb530a90ddp+4,    0x1.6df80a9326865p-4,   0x1.f8c752p-2, INEXACT)
T(RN,    0x1.922dee6c005a9p+4,     0x1.c7256f955d78p-9,  -0x1.f7071ap-2, INEXACT)
T(RN,    0x1.90d0588ee6592p+4,   -0x1.501d10a595b48p-4,  -0x1.f932f4p-2, INEXACT)
T(RN,    0x1.8f73f29052fe2p+4,    -0x1.59177fbcd992p-3,   0x1.ff04e4p-2, INEXACT)
T(RN,    0x1.8e18bb6824a16p+4,   -0x1.0754225bdb165p-2,    0x1.fe0e3p-2, INEXACT)
T(RN,     0x1.8cbeb20f1f33p+4,    -0x1.65d63427499fp-2,    0x1.f6e1ap-2, INEXACT)
T(RN,    0x1.8b65d57eeb5adp+4,   -0x1.c9c1a1cf2efcep-2,  -0x1.f7a8f6p-2, INEXACT)
T(RN,    0x1.8a0e24b21612bp+4,   -0x1.1a907f6d06771p-1,  -0x1.f97c48p-2, INEXACT)
T(RN,    0x1.88b79ea40f33ep+4,   -0x1.5544381700847p-1,   0x1.fe61aap-2, INEXACT)
T(RN,    0x1.876242512950ap+4,   -0x1.96adc05e2aceep-1,  -0x1.ff2976p-2, INEXACT)
T(RN,    0x1.860e0eb698a4ep+4,   -0x1.e11d7ae442e92p-1,   0x1.fe8c96p-2, INEXACT)
T(RN,    0x1.84bb02d272611p+4,   -0x1.1bee8cca121cdp+0,   0x1.f70c7cp-2, INEXACT)
T(RN,    0x1.83691da3abebap+4,   -0x1.4fe6c5db1201ep+0,   0x1.fc7946p-2, INEXACT)
T(RN,    0x1.82185e2a1a117p+4,   -0x1.9045b48d48068p+0,   0x1.fde9d4p-2, INEXACT)
T(RN,    0x1.80c8c366704a1p+4,   -0x1.e35b3ed8a372bp+0,   0x1.f96186p-2, INEXACT)
T(RN,    0x1.7f7a4c5a3ff5dp+4,   -0x1.2a3cb85b2833ap+1,    0x1.f7ceap-2, INEXACT)
T(RN,    0x1.7e2cf807f7aabp+4,   -0x1.7d18e7fa7e732p+1,    0x1.fe00ap-2, INEXACT)
T(RN,    0x1.7ce0c572e252ap+4,    -0x1.023f12152eddp+2,    0x1.f9ebap-2, INEXACT)
T(RN,    0x1.7b95b39f2694dp+4,   -0x1.87587763c0cf7p+2,  -0x1.f85b4ap-2, INEXACT)
T(RN,    0x1.7a4bc191c5e67p+4,   -0x1.87869e9f2e5dfp+3,  -0x1.f5fa4ep-2, INEXACT)
T(RN,    0x1.7902ee509c235p+4,   -0x1.897f76c0700f5p+9,  -0x1.f7b418p-2, INEXACT)
T(RN,    0x1.77bb38e25e45ep+4,    0x1.959454d91d43dp+3,   0x1.fac0fep-2, INEXACT)
T(RN,      0x1.7674a04e9a3p+4,     0x1.90789eb449a6p+2,   0x1.fc48d2p-2, INEXACT)
T(RN,    0x1.752f239db59adp+4,    0x1.07e260b11ff24p+2,   0x1.f84536p-2, INEXACT)
T(RN,    0x1.73eac1d8edb36p+4,    0x1.85fef9ffb2c46p+1,  -0x1.fa7d12p-2, INEXACT)
T(RN,    0x1.72a77a0a55c65p+4,    0x1.321ba297eb94dp+1,   0x1.fc7376p-2, INEXACT)
T(RN,    0x1.71654b3cd72c5p+4,    0x1.f223d8dfe241dp+0,   0x1.fb62d8p-2, INEXACT)
T(RN,    0x1.7024347c302c5p+4,    0x1.9ea6a9f375e05p+0,  -0x1.f8a3f8p-2, INEXACT)
T(RN,    0x1.6ee434d4f3639p+4,    0x1.5e34688ed9c9ap+0,  -0x1.f969cap-2, INEXACT)
T(RN,    0x1.6da54b5486fecp+4,    0x1.2a62f89c8730ap+0,   0x1.f7e44ap-2, INEXACT)
T(RN,    0x1.6c677709242e7p+4,    0x1.feaf1fbd933fep-1,   0x1.f7331ap-2, INEXACT)
T(RN,    0x1.6b2ab701d60cfp+4,    0x1.b53845f07198bp-1,   0x1.f724a4p-2, INEXACT)
T(RN,    0x1.69ef0a4e7965cp+4,    0x1.75147e59dca88p-1,  -0x1.f810a4p-2, INEXACT)
T(RN,    0x1.68b46fffbb8edp+4,    0x1.3bf57e1a1141ep-1,   0x1.fbd974p-2, INEXACT)
T(RN,    0x1.677ae7271a019p+4,    0x1.082fbdd16042cp-1,  -0x1.f7d452p-2, INEXACT)
T(RN,    0x1.66426ed6e17d9p+4,    0x1.b106769dfc408p-2,   0x1.f6731cp-2, INEXACT)
T(RN,    0x1.650b06222d7edp+4,    0x1.57f18420ff9f7p-2,  -0x1.fdcb0ap-2, INEXACT)
T(RN,    0x1.63d4ac1ce72dep+4,    0x1.03966e0d147aep-2,   -0x1.ffce2p-2, INEXACT)
T(RN,    0x1.629f5fdbc51b7p+4,    0x1.6560a5021f356p-3,   0x1.fbfe82p-2, INEXACT)
T(RN,    0x1.616b20744a4bbp+4,     0x1.90a719091f32p-4,  -0x1.fd60d6p-2, INEXACT)
T(RN,    0x1.6037ecfcc59afp+4,    0x1.70c974ac92b84p-6,   0x1.f75e5cp-2, INEXACT)
T(RN,    0x1.5f05c48c50db4p+4,   -0x1.ac57e422bbfcap-5,  -0x1.f683b6p-2, INEXACT)
T(RN,     0x1.5dd4a63ad0f5p+4,   -0x1.04f235fcce832p-3,   0x1.fb320cp-2, INEXACT)
T(RN,    0x1.5ca49120f3928p+4,   -0x1.a1389acbd7759p-3,  -0x1.f76b0ep-2, INEXACT)
T(RN,    0x1.5b758458302efp+4,   -0x1.20dfa78305a59p-2,  -0x1.fe4c6cp-2, INEXACT)
T(RN,    0x1.5a477efac659ap+4,   -0x1.74461603b4c54p-2,   0x1.fb989cp-2, INEXACT)
T(RN,    0x1.591a8023bd6fap+4,   -0x1.cbf804e9ae654p-2,   0x1.f8b684p-2, INEXACT)
T(RN,    0x1.57ee86eee3d24p+4,   -0x1.14aa7c52e162ep-1,  -0x1.fd5eb4p-2, INEXACT)
T(RN,    0x1.56c39278ce36cp+4,   -0x1.4705ba9473794p-1,  -0x1.f963a2p-2, INEXACT)
T(RN,    0x1.5599a1ded6fa2p+4,   -0x1.7e1d706d59a7bp-1,   0x1.f72872p-2, INEXACT)
T(RN,    0x1.5470b43f1da55p+4,     -0x1.bb52b4f5f23p-1,   -0x1.fe833p-2, INEXACT)
T(RN,    0x1.5348c8b885da2p+4,   -0x1.003f0ee5d8963p+0,  -0x1.ffab58p-2, INEXACT)
T(RN,    0x1.5221de6ab709dp+4,   -0x1.28161b92bf15cp+0,   0x1.fd57a8p-2, INEXACT)
T(RN,    0x1.50fbf4761ba0dp+4,   -0x1.5700d2104cd84p+0,   0x1.fbd4c2p-2, INEXACT)
T(RN,    0x1.4fd709fbe0651p+4,   -0x1.8fb4a39553943p+0,   0x1.f8eb32p-2, INEXACT)
T(RN,    0x1.4eb31e1df3d16p+4,   -0x1.d66acc40dbee8p+0,   0x1.ff8c7cp-2, INEXACT)
T(RN,    0x1.4d902fff055e2p+4,   -0x1.190f998dde352p+1,   0x1.fb3084p-2, INEXACT)
T(RN,    0x1.4c6e3ec284e2dp+4,   -0x1.57a38e0ee1b11p+1,   0x1.f9592cp-2, INEXACT)
T(RN,    0x1.4b4d498ca1fb3p+4,   -0x1.b3417dbdfe00cp+1,   0x1.f92438p-2, INEXACT)
T(RN,    0x1.4a2d4f824b474p+4,   -0x1.24142035185fbp+2,   0x1.fd4324p-2, INEXACT)
T(RN,    0x1.490e4fc92dd7ep+4,   -0x1.b452a4a69abfdp+2,  -0x1.fe56e8p-2, INEXACT)
T(RN,    0x1.47f04987b4869p+4,   -0x1.a54a35d350f05p+3,   0x1.fb7164p-2, INEXACT)
T(RN,    0x1.46d33be507483p+4,   -0x1.419d54a75659ap+7,  -0x1.f9765cp-2, INEXACT)
T(RN,    0x1.45b726090a9a8p+4,    0x1.fa269657e90f6p+3,  -0x1.f98ddep-2, INEXACT)
T(RN,    0x1.449c071c5eb73p+4,    0x1.e1127ec3f98edp+2,   0x1.f68cdcp-2, INEXACT)
T(RN,    0x1.4381de485f37dp+4,    0x1.39dfb8fd986f6p+2,  -0x1.fa6d4ep-2, INEXACT)
T(RN,    0x1.4268aab7221f8p+4,    0x1.cedc234410653p+1,   0x1.f7cc1cp-2, INEXACT)
T(RN,    0x1.41506b93777dcp+4,    0x1.6be9696555ff3p+1,   -0x1.f62e1p-2, INEXACT)
T(RN,    0x1.40392008e8a7ep+4,    0x1.296c199bdc82dp+1,   0x1.f931cep-2, INEXACT)
T(RN,    0x1.3f22c743b79c6p+4,    0x1.f292d03203ff1p+0,  -0x1.fbb91cp-2, INEXACT)
T(RN,    0x1.3e0d6070de65ap+4,    0x1.a90f1b35a603ap+0,  -0x1.f74b6ap-2, INEXACT)
T(RN,    0x1.3cf8eabe0e882p+4,    0x1.6e9b4d46ce2dep+0,    0x1.f6485p-2, INEXACT)
T(RN,    0x1.3be56559b056bp+4,     0x1.3e9f2e189735p+0,  -0x1.fe487ep-2, INEXACT)
T(RN,    0x1.3ad2cf72e2455p+4,    0x1.16304cf6ea388p+0,  -0x1.fc5beep-2, INEXACT)
T(RN,    0x1.39c1283978569p+4,    0x1.e6baeb0ef5853p-1,   0x1.f8d3c6p-2, INEXACT)
T(RN,    0x1.38b06eddfb93bp+4,     0x1.a99c0cb188f3p-1,  -0x1.ff6d6ep-2, INEXACT)
T(RN,    0x1.37a0a291a93f8p+4,    0x1.7315e48ebfde9p-1,   0x1.f7d8a8p-2, INEXACT)
T(RN,    0x1.3691c28672806p+4,    0x1.41bbb7b269517p-1,  -0x1.f7abbcp-2, INEXACT)
T(RN,    0x1.3583cdeefb6c4p+4,    0x1.14791fdfe3a7ep-1,   -0x1.f71bcp-2, INEXACT)
T(RN,    0x1.3476c3fe9ab15p+4,    0x1.d4eefc9025913p-2,   0x1.f7f044p-2, INEXACT)
T(RN,    0x1.336aa3e958dd4p+4,    0x1.86187c24dfd17p-2,   0x1.fe23f6p-2, INEXACT)
T(RN,    0x1.325f6ce3efce9p+4,    0x1.3b593e534950ap-2,  -0x1.fef156p-2, INEXACT)
T(RN,    0x1.31551e23ca0cbp+4,    0x1.e794477f4f23bp-3,   0x1.fe16f6p-2, INEXACT)
T(RN,    0x1.304bb6df023a6p+4,    0x1.5d4bac6424aebp-3,  -0x1.fde9aep-2, INEXACT)
T(RN,    0x1.2f43364c6279ap+4,    0x1.acfd4663faf5ap-4,   0x1.fce00ep-2, INEXACT)
T(RN,    0x1.2e3b9ba363d6bp+4,    0x1.47d4223891515p-5,  -0x1.f7b754p-2, INEXACT)
T(RN,    0x1.2d34e61c2d9edp+4,   -0x1.8b9b08dd52463p-6,   0x1.feab3ep-2, INEXACT)
T(RN,    0x1.2c2f14ef94da6p+4,    -0x1.69a27272d11cp-4,  -0x1.f7d03ap-2, INEXACT)
T(RN,    0x1.2b2a27571bba6p+4,   -0x1.3938dedd4473bp-3,  -0x1.faec64p-2, INEXACT)
T(RN,    0x1.2a261c8cf0fdap+4,   -0x1.bfc5934790505p-3,    0x1.fd256p-2, INEXACT)
T(RN,    0x1.2922f3cbef327p+4,   -0x1.24d1838f9501dp-2,   0x1.f7bee2p-2, INEXACT)
T(RN,    0x1.2820ac4f9c66fp+4,   -0x1.6c0c020ee6cd1p-2,  -0x1.f66fdep-2, INEXACT)
T(RN,    0x1.271f455429668p+4,   -0x1.b64983b2c8383p-2,   0x1.f8db66p-2, INEXACT)
T(RN,    0x1.261ebe16712efp+4,    -0x1.022e7814c313p-1,   0x1.f9595cp-2, INEXACT)
T(RN,    0x1.251f15d3f8646p+4,   -0x1.2b9f74575d96bp-1,  -0x1.fda398p-2, INEXACT)
T(RN,    0x1.24204bcaeca9dp+4,   -0x1.580d96e52601bp-1,  -0x1.f9eafcp-2, INEXACT)
T(RN,    0x1.23225f3a2433fp+4,   -0x1.88317c9a52ec3p-1,   0x1.f723cap-2, INEXACT)
T(RN,    0x1.22254f611cf8cp+4,   -0x1.bcf36776bbe66p-1,    0x1.fa30ap-2, INEXACT)
T(RN,    0x1.21291b7ffc791p+4,   -0x1.f77de4e2640cdp-1,  -0x1.fb9fb4p-2, INEXACT)
T(RN,    0x1.202dc2d78ec13p+4,   -0x1.1cacc17df4612p+0,   0x1.fb875cp-2, INEXACT)
T(RN,    0x1.1f3344a94632cp+4,   -0x1.424ba18e4bda8p+0,   0x1.f5e976p-2, INEXACT)
T(RN,     0x1.1e39a0373ac5p+4,   -0x1.6e09f52fd7e24p+0,  -0x1.f6b04cp-2, INEXACT)
T(RN,    0x1.1d40d4c42986ep+4,   -0x1.a1f38e8c19bebp+0,   0x1.f5da22p-2, INEXACT)
T(RN,     0x1.1c48e1937414p+4,    -0x1.e111d24dd7d8p+0,   0x1.f5ec92p-2, INEXACT)
T(RN,    0x1.1b51c5e91fe69p+4,    -0x1.180deef6cde3p+1,   0x1.fc4d02p-2, INEXACT)
T(RN,    0x1.1a5b8109d5e34p+4,   -0x1.4b6879f7d8e3cp+1,  -0x1.f78c8ep-2, INEXACT)
T(RN,    0x1.1966123ae1d1cp+4,   -0x1.917112a7fd041p+1,  -0x1.f9571cp-2, INEXACT)
T(RN,    0x1.187178c231baep+4,   -0x1.f781dad255ed3p+1,  -0x1.f7e944p-2, INEXACT)
T(RN,     0x1.177db3e65563p+4,   -0x1.4dce3c985dffcp+2,  -0x1.f63ce2p-2, INEXACT)
T(RN,    0x1.168ac2ee7dcf5p+4,   -0x1.e915558d8e8bcp+2,  -0x1.fa2cdep-2, INEXACT)
T(RN,    0x1.1598a5227c8b8p+4,   -0x1.c1e683adb4eb1p+3,  -0x1.f6b46ep-2, INEXACT)
T(RN,    0x1.14a759cac356bp+4,   -0x1.4aa14e00875f6p+6,   -0x1.ff9a2p-2, INEXACT)
T(RN,    0x1.13b6e03063562p+4,    0x1.57025811eb961p+4,   0x1.f66b1ap-2, INEXACT)
T(RN,    0x1.12c7379d0d0adp+4,    0x1.2f48cf8f33717p+3,   0x1.f7b5bep-2, INEXACT)
T(RN,    0x1.11d85f5b0efbep+4,    0x1.841a154740dbfp+2,  -0x1.f896b6p-2, INEXACT)
T(RN,    0x1.10ea56b555df6p+4,    0x1.1c22727c8e003p+2,   0x1.fbf5ccp-2, INEXACT)
T(RN,    0x1.0ffd1cf76bd15p+4,    0x1.be085a9268c18p+1,   0x1.fb7b5cp-2, INEXACT)
T(RN,    0x1.0f10b16d77b17p+4,    0x1.6d1e269b41cc3p+1,  -0x1.fd0862p-2, INEXACT)
T(RN,    0x1.0e2513643cc8dp+4,    0x1.3345a35f6130ep+1,  -0x1.f65c2ep-2, INEXACT)
T(RN,     0x1.0d3a42291a21p+4,    0x1.079bb54545541p+1,  -0x1.f80226p-2, INEXACT)
T(RN,    0x1.0c503d0a0a0acp+4,    0x1.ca8f49ee72e0bp+0,  -0x1.ffe0a2p-2, INEXACT)
T(RN,    0x1.0b670355a19bbp+4,    0x1.92d6165527ed8p+0,   0x1.fff786p-2, INEXACT)
T(RN,    0x1.0a7e945b101a9p+4,    0x1.646e886b838f4p+0,  -0x1.fa95f8p-2, INEXACT)
T(RN,    0x1.0996ef6a1e713p+4,    0x1.3cf46967b9ee2p+0,   0x1.f75bacp-2, INEXACT)
T(RN,     0x1.08b013d32ee2p+4,    0x1.1ac22e7ed477fp+0,  -0x1.fe903cp-2, INEXACT)
T(RN,      0x1.07ca00e73c2p+4,    0x1.f9579dbec6d48p-1,   0x1.fc98ccp-2, INEXACT)
T(RN,    0x1.06e4b5f7d919fp+4,     0x1.c3ab48eb579cp-1,  -0x1.f7b27cp-2, INEXACT)
T(RN,    0x1.0600325730665p+4,    0x1.9335d31efb43bp-1,   0x1.f7ce6ap-2, INEXACT)
T(RN,    0x1.051c755803999p+4,    0x1.66faa23fe7c5dp-1,  -0x1.f6f72ep-2, INEXACT)
T(RN,    0x1.04397e4daaf71p+4,    0x1.3e3448e416678p-1,   0x1.f68f7ap-2, INEXACT)
T(RN,    0x1.03574c8c14de1p+4,    0x1.1845aee18ad08p-1,   0x1.f7e336p-2, INEXACT)
T(RN,    0x1.0275df67c5152p+4,    0x1.e95f6612bab4cp-2,   0x1.fde81ep-2, INEXACT)
T(RN,    0x1.01953635d4965p+4,    0x1.a61386edf4b2dp-2,  -0x1.f6f194p-2, INEXACT)
T(RN,    0x1.00b5504bf0dadp+4,    0x1.65f8ef1410592p-2,  -0x1.f65e9ep-2, INEXACT)
T(RN,    0x1.ffac5a00b6df6p+3,    0x1.287b18a195d5dp-2,   0x1.fcf6aep-2, INEXACT)
T(RN,     0x1.fdef9753d2cfp+3,    0x1.da33657837894p-3,   0x1.fcb06cp-2, INEXACT)
T(RN,    0x1.fc34574005c71p+3,    0x1.66c7d756e2d59p-3,   0x1.f63728p-2, INEXACT)
T(RN,    0x1.fa7a987545212p+3,    0x1.ebd2db2595d6bp-4,  -0x1.f99fdap-2, INEXACT)
T(RN,    0x1.f8c259a4aa517p+3,    0x1.0dbf1a278e97bp-4,    0x1.fd8a5p-2, INEXACT)
T(RN,    0x1.f70b998071dcbp+3,    0x1.8fe0c13fe694bp-7,   0x1.fb5378p-2, INEXACT)
T(RN,    0x1.f55656bbfa731p+3,   -0x1.517cad4abbe96p-5,  -0x1.fc5f88p-2, INEXACT)
T(RN,    0x1.f3a2900bc3e52p+3,   -0x1.83b01025baf59p-4,  -0x1.fae192p-2, INEXACT)
T(RN,    0x1.f1f044256e19bp+3,   -0x1.300c0317b0df6p-3,   -0x1.f6debp-2, INEXACT)
T(RN,    0x1.f03f71bfb832dp+3,   -0x1.9f9dc32d45bc5p-3,  -0x1.f9be76p-2, INEXACT)
T(RN,    0x1.ee9017927f83ap+3,   -0x1.089b70b606b3ep-2,    0x1.fa89ap-2, INEXACT)
T(RN,    0x1.ece23456be97dp+3,   -0x1.42c5ff08e4f09p-2,  -0x1.fea32ap-2, INEXACT)
T(RN,    0x1.eb35c6c68c31dp+3,   -0x1.7eb0ae1d1d19fp-2,   0x1.ffdb68p-2, INEXACT)
T(RN,    0x1.e98acd9d1a6a2p+3,   -0x1.bcc82334dc829p-2,   0x1.f6803ap-2, INEXACT)
T(RN,    0x1.e7e14796b5a7bp+3,   -0x1.fd86c7f0a225bp-2,  -0x1.f5fedcp-2, INEXACT)
T(RN,    0x1.e6393370c3c9dp+3,   -0x1.20bc6873163d2p-1,  -0x1.f8142cp-2, INEXACT)
T(RN,    0x1.e4928fe9c2e51p+3,   -0x1.44a0aae86916fp-1,  -0x1.fea76cp-2, INEXACT)
T(RN,    0x1.e2ed5bc148aecp+3,   -0x1.6ad072861bc57p-1,  -0x1.fe4cecp-2, INEXACT)
T(RN,    0x1.e14995b80152bp+3,   -0x1.93bf149fe67a2p-1,  -0x1.f81fe6p-2, INEXACT)
T(RN,    0x1.dfa73c8fae8ffp+3,   -0x1.bff8bea1f9976p-1,  -0x1.fc0a46p-2, INEXACT)
T(RN,    0x1.de064f0b26c6ap+3,   -0x1.f02a5b0629fdbp-1,   0x1.ff7b82p-2, INEXACT)
T(RN,    0x1.dc66cbee54026p+3,   -0x1.1296458760edfp+0,  -0x1.f89f3ap-2, INEXACT)
T(RN,    0x1.dac8b1fe330fdp+3,   -0x1.30099db0b87f6p+0,  -0x1.fda0b6p-2, INEXACT)
T(RN,    0x1.d92c0000d2879p+3,   -0x1.512222d530cb6p+0,  -0x1.f9202ap-2, INEXACT)
T(RN,    0x1.d790b4bd52095p+3,   -0x1.76cc95cca0c04p+0,  -0x1.f6b694p-2, INEXACT)
T(RN,    0x1.d5f6cefbe0eafp+3,   -0x1.a2496d96a2084p+0,   0x1.f8e53cp-2, INEXACT)
T(RN,    0x1.d45e4d85bdb8cp+3,    -0x1.d555ee1950f8p+0,   0x1.f6f936p-2, INEXACT)
T(RN,    0x1.d2c72f25352c8p+3,   -0x1.093801e7059b9p+1,  -0x1.fa5032p-2, INEXACT)
T(RN,    0x1.d13172a5a0fc1p+3,   -0x1.2ea5dd5a22a99p+1,  -0x1.fda5c6p-2, INEXACT)
T(RN,    0x1.cf9d16d36748ep+3,   -0x1.5dd540c343c79p+1,  -0x1.f85612p-2, INEXACT)
T(RN,    0x1.ce0a1a7bf99eap+3,   -0x1.9b8144f7ffac2p+1,   0x1.fcd964p-2, INEXACT)
T(RN,     0x1.cc787c6dd3e6p+3,   -0x1.f0070eb0949cfp+1,  -0x1.fd0b94p-2, INEXACT)
T(RN,    0x1.cae83b787ba5cp+3,   -0x1.35dbc2a1041ecp+2,  -0x1.fd83e8p-2, INEXACT)
T(RN,    0x1.c959566c7f0ccp+3,    -0x1.999f3f7d7913p+2,   0x1.f94928p-2, INEXACT)
T(RN,    0x1.c7cbcc1b74101p+3,   -0x1.2b71af455e74ep+3,  -0x1.fb5392p-2, INEXACT)
T(RN,     0x1.c63f9b57f778p+3,   -0x1.1316c1dc2b202p+4,   0x1.fb6baap-2, INEXACT)
T(RN,    0x1.c4b4c2f5ac11fp+3,   -0x1.9414c460fd9a6p+6,   0x1.f9dd9ap-2, INEXACT)
T(RN,    0x1.c32b41c939c3bp+3,    0x1.a357752b433d6p+4,   0x1.ff81bcp-2, INEXACT)
T(RN,    0x1.c1a316a84c8e6p+3,    0x1.73233a562d74fp+3,  -0x1.fe3f56p-2, INEXACT)
T(RN,    0x1.c01c406993dfbp+3,    0x1.dbc31f59d0d05p+2,   0x1.fb1796p-2, INEXACT)
T(RN,    0x1.be96bde4c1819p+3,    0x1.5d3273be7e9cap+2,  -0x1.fa4796p-2, INEXACT)
T(RN,    0x1.bd128df288da2p+3,    0x1.1301a03f4e902p+2,  -0x1.ffe15ap-2, INEXACT)
T(RN,    0x1.bb8faf6c9deeep+3,     0x1.c424c0bb292fp+1,   0x1.fa5a0ap-2, INEXACT)
T(RN,    0x1.ba0e212db4a5ap+3,    0x1.7e7aeee3dc4abp+1,    0x1.f603dp-2, INEXACT)
T(RN,    0x1.b88de2117fcbbp+3,    0x1.4a29b363e998dp+1,   -0x1.ff5d4p-2, INEXACT)
T(RN,    0x1.b70ef0f4b039ap+3,    0x1.2145416c9878cp+1,   0x1.f81132p-2, INEXACT)
T(RN,    0x1.b5914cb4f41b2p+3,    0x1.004ca83206468p+1,   0x1.fffd28p-2, INEXACT)
T(RN,    0x1.b414f430f5d2ep+3,    0x1.ca164ffa37542p+0,   0x1.f870aep-2, INEXACT)
T(RN,    0x1.b299e6485b636p+3,     0x1.9c16b956f508p+0,   0x1.fc87e4p-2, INEXACT)
T(RN,     0x1.b12021dbc553p+3,    0x1.7498e745afddcp+0,   -0x1.fb99dp-2, INEXACT)
T(RN,    0x1.afa7a5ccce143p+3,    0x1.522fd2b66038fp+0,   0x1.fb3658p-2, INEXACT)
T(RN,    0x1.ae3070fe08f0ap+3,    0x1.33d0d46d0b505p+0,   0x1.fef7e4p-2, INEXACT)
T(RN,    0x1.acba8253015a7p+3,    0x1.18b47c588e17fp+0,   -0x1.f87b1p-2, INEXACT)
T(RN,       0x1.ab45d8b03ap+3,    0x1.00428a2031d9ap+0,  -0x1.fa5416p-2, INEXACT)
T(RN,    0x1.a9d272fb2bf9ap+3,    0x1.d4094c0584c5fp-1,  -0x1.faf8d8p-2, INEXACT)
T(RN,    0x1.a860501a45f9ap+3,    0x1.ab3aac7ea2508p-1,   0x1.fc475ap-2, INEXACT)
T(RN,    0x1.a6ef6ef4eb6a9p+3,    0x1.858362dbc8865p-1,   0x1.f9528ap-2, INEXACT)
T(RN,    0x1.a57fce7373884p+3,    0x1.6269c38022a08p-1,   -0x1.f6116p-2, INEXACT)
T(RN,    0x1.a4116d7f2915ep+3,    0x1.4189c784d1adcp-1,   0x1.f9317cp-2, INEXACT)
T(RN,    0x1.a2a44b02486ebp+3,    0x1.22903f473301ep-1,  -0x1.f7313cp-2, INEXACT)
T(RN,    0x1.a13865e7ffd73p+3,    0x1.0537393bfc278p-1,   0x1.feebaap-2, INEXACT)
T(RN,    0x1.9fcdbd1c6e034p+3,     0x1.d2868b88cc27p-2,   0x1.ffbfa8p-2, INEXACT)
T(RN,    0x1.9e644f8ca18d4p+3,    0x1.9d02b793b5734p-2,  -0x1.fc59a4p-2, INEXACT)
T(RN,    0x1.9cfc1c2697f94p+3,    0x1.698a67aa5bbaap-2,  -0x1.fececap-2, INEXACT)
T(RN,    0x1.9b9521d93cfdbp+3,    0x1.37cff6ec89b11p-2,  -0x1.fdf2dcp-2, INEXACT)
T(RN,    0x1.9a2f5f9469b2ep+3,    0x1.078e96484dd82p-2,  -0x1.f641f6p-2, INEXACT)
T(RN,    0x1.98cad448e3c34p+3,    0x1.b1113a2814e3dp-3,    0x1.fa96fp-2, INEXACT)
T(RN,    0x1.97677ee85c8c3p+3,    0x1.550c4d342380ep-3,   0x1.f742c2p-2, INEXACT)
T(RN,    0x1.96055e657074cp+3,    0x1.f54faa0ba490fp-4,  -0x1.f6377ep-2, INEXACT)
T(RN,    0x1.94a471b3a5fe5p+3,     0x1.430908f3bcd9p-4,  -0x1.ffb844p-2, INEXACT)
T(RN,    0x1.9344b7c76d0b8p+3,    0x1.252284409cc45p-5,  -0x1.f6d474p-2, INEXACT)
T(RN,    0x1.91e62f961e17fp+3,   -0x1.cc2f60cea9bf3p-8,    0x1.f83eap-2, INEXACT)
T(RN,    0x1.9088d815f9637p+3,   -0x1.9732e84814c9ep-5,    0x1.f930cp-2, INEXACT)
T(RN,    0x1.8f2cb03e26235p+3,   -0x1.7a9516616cbf3p-4,  -0x1.fa4ec2p-2, INEXACT)
T(RN,    0x1.8dd1b706b1dadp+3,   -0x1.152c146d17389p-3,    0x1.f6442p-2, INEXACT)
T(RN,    0x1.8c77eb688f5aep+3,   -0x1.6dc360391fd74p-3,  -0x1.fb1a84p-2, INEXACT)
T(RN,    0x1.8b1f4c5d96405p+3,   -0x1.c7648fa755b0ep-3,  -0x1.f8e61ep-2, INEXACT)
T(RN,    0x1.89c7d8e081a99p+3,   -0x1.11338d7514344p-2,   0x1.f607d8p-2, INEXACT)
T(RN,    0x1.88718fecf0d5bp+3,   -0x1.3f93952902ec3p-2,  -0x1.f6ba78p-2, INEXACT)
T(RN,    0x1.871c707f63e6dp+3,   -0x1.6f0389a38f1dbp-2,  -0x1.fa599ep-2, INEXACT)
T(RN,    0x1.85c879953d7dap+3,    -0x1.9fb883528a12p-2,   0x1.fa3f46p-2, INEXACT)
T(RN,    0x1.8475aa2cc0918p+3,   -0x1.d1ec805281741p-2,  -0x1.f625fep-2, INEXACT)
T(RN,    0x1.83240145111dbp+3,   -0x1.02efc3948a9d3p-1,   0x1.fb5c9ap-2, INEXACT)
T(RN,    0x1.81d37dde30e1dp+3,   -0x1.1dec80729c184p-1,  -0x1.f74482p-2, INEXACT)
T(RN,    0x1.80841ef9012a9p+3,   -0x1.3a14ad6e281fep-1,   0x1.f9e128p-2, INEXACT)
T(RN,    0x1.7f35e39740b2fp+3,   -0x1.57960297173f3p-1,   0x1.f5ea12p-2, INEXACT)
T(RN,    0x1.7de8cabb8b494p+3,   -0x1.76a4f505aabfap-1,   0x1.f6714ep-2, INEXACT)
T(RN,    0x1.7c9cd36958f74p+3,   -0x1.977e41a02b94bp-1,   0x1.ff9e02p-2, INEXACT)
T(RN,    0x1.7b51fca4fd494p+3,   -0x1.ba68e07bdc68ap-1,  -0x1.fd96fap-2, INEXACT)
T(RN,    0x1.7a084573a688ep+3,   -0x1.dfb883ea75f36p-1,   0x1.fd4944p-2, INEXACT)
T(RN,    0x1.78bfacdb5d0e7p+3,   -0x1.03e86a1678bdcp+0,  -0x1.ffa602p-2, INEXACT)
T(RN,    0x1.777831e30271cp+3,   -0x1.1994d69e0599bp+0,   0x1.f9b23ap-2, INEXACT)
T(RN,    0x1.7631d39250da4p+3,   -0x1.312a615f43972p+0,   -0x1.f6168p-2, INEXACT)
T(RN,    0x1.74ec90f1da1b6p+3,   -0x1.4b029e8920b22p+0,  -0x1.f5c3c8p-2, INEXACT)
T(RN,    0x1.73a8690b0797cp+3,   -0x1.678d15a34aa58p+0,  -0x1.fd3df4p-2, INEXACT)
T(RN,    0x1.72655ae8184f2p+3,   -0x1.87568d3229e57p+0,    0x1.f83f1p-2, INEXACT)
T(RN,    0x1.712365942154ep+3,    -0x1.ab13709e929dp+0,   0x1.fb8b16p-2, INEXACT)
T(RN,    0x1.6fe2881b0c9b9p+3,   -0x1.d3aef9051a599p+0,   -0x1.f6ae9p-2, INEXACT)
T(RN,    0x1.6ea2c18998153p+3,   -0x1.0130ed33a4417p+1,  -0x1.fc524ap-2, INEXACT)
T(RN,    0x1.6d6410ed553eep+3,   -0x1.1c6a99adb4d52p+1,  -0x1.f85f06p-2, INEXACT)
T(RN,    0x1.6c267554a8713p+3,   -0x1.3cad1fb4391b2p+1,  -0x1.fdfaa4p-2, INEXACT)
T(RN,    0x1.6ae9edcec7c08p+3,   -0x1.63a3631db7602p+1,   0x1.fc991cp-2, INEXACT)
T(RN,    0x1.69ae796bbabb5p+3,   -0x1.93cb05d5515bbp+1,   0x1.feddc2p-2, INEXACT)
T(RN,    0x1.6874173c5983fp+3,   -0x1.d108ea57d2c05p+1,   0x1.ff4accp-2, INEXACT)
T(RN,    0x1.673ac6524c137p+3,   -0x1.10e7f17c14ac9p+2,    0x1.fb456p-2, INEXACT)
T(RN,    0x1.660285c0099a4p+3,   -0x1.48d12d2c9bb03p+2,    0x1.f750ep-2, INEXACT)
T(RN,    0x1.64cb5498d7b72p+3,   -0x1.9b9ffb1bb08ecp+2,   0x1.fc6a0ap-2, INEXACT)
T(RN,    0x1.639531f0c9d4bp+3,   -0x1.11b328473fb3ap+3,  -0x1.fa6e84p-2, INEXACT)
T(RN,    0x1.62601cdcc06a3p+3,   -0x1.95fbe41a04efbp+3,  -0x1.f61d5cp-2, INEXACT)
T(RN,    0x1.612c147268627p+3,   -0x1.857cc27c726ccp+4,   0x1.fc5258p-2, INEXACT)
T(RN,    0x1.5ff917c83a3a4p+3,   -0x1.1720f796d2fedp+8,  -0x1.ff89a6p-2, INEXACT)
T(RN,    0x1.5ec725f5797bap+3,    0x1.d9b1d6290ba3dp+4,   0x1.fb6374p-2, INEXACT)
T(RN,    0x1.5d963e1233facp+3,    0x1.c20c2842e45f1p+3,  -0x1.fee0dap-2, INEXACT)
T(RN,    0x1.5c665f374126ap+3,    0x1.26edf4d183eacp+3,   0x1.f71f82p-2, INEXACT)
T(RN,    0x1.5b37887e4165bp+3,      0x1.b624883c35ap+2,  -0x1.f85296p-2, INEXACT)
T(RN,    0x1.5a09b9019d537p+3,     0x1.5bfa24b8cf19p+2,   0x1.f894a4p-2, INEXACT)
T(RN,    0x1.58dcefdc851b6p+3,    0x1.201676a7d7df9p+2,   0x1.ff14bep-2, INEXACT)
T(RN,    0x1.57b12c2aefd5cp+3,    0x1.eaa344278516dp+1,  -0x1.f97692p-2, INEXACT)
T(RN,    0x1.56866d099acbbp+3,    0x1.aa58258d23cb9p+1,  -0x1.fd1c74p-2, INEXACT)
T(RN,     0x1.555cb19608d5p+3,    0x1.7822f501987c5p+1,   0x1.fe39dcp-2, INEXACT)
T(RN,    0x1.5433f8ee81a17p+3,    0x1.4fbf21ea9f4a2p+1,   0x1.fd5acap-2, INEXACT)
T(RN,    0x1.530c42321117ap+3,     0x1.2e78d08861fap+1,   0x1.f9fa12p-2, INEXACT)
T(RN,    0x1.51e58c8086ae3p+3,    0x1.12848bd83ab7ep+1,  -0x1.f9c58cp-2, INEXACT)
T(RN,    0x1.50bfd6fa74afap+3,    0x1.f54a71ccf216ap+0,   0x1.f7fb64p-2, INEXACT)
T(RN,    0x1.4f9b20c12f9cbp+3,    0x1.cbf1cbae8d86ap+0,   0x1.f5fae2p-2, INEXACT)
T(RN,    0x1.4e7768f6cd9a2p+3,    0x1.a7b4691969963p+0,  -0x1.fee4c4p-2, INEXACT)
T(RN,    0x1.4d54aebe2582ep+3,    0x1.879a9ddca8e5dp+0,   -0x1.f74f9p-2, INEXACT)
T(RN,    0x1.4c32f13aceb02p+3,    0x1.6ae73b74a7a42p+0,  -0x1.f94a64p-2, INEXACT)
T(RN,    0x1.4b122f911fcf2p+3,    0x1.51073a92645b3p+0,  -0x1.fb7cfap-2, INEXACT)
T(RN,     0x1.49f268e62ea1p+3,    0x1.398693ffd61ccp+0,  -0x1.f5d3b8p-2, INEXACT)
T(RN,    0x1.48d39c5fcf2ccp+3,    0x1.2408760f8bfaep+0,  -0x1.f87886p-2, INEXACT)
T(RN,    0x1.47b5c92493189p+3,    0x1.1041b66c74d37p+0,    0x1.ff09ap-2, INEXACT)
T(RN,    0x1.4698ee5bc907fp+3,    0x1.fbe992bb1e07cp-1,  -0x1.f91316p-2, INEXACT)
T(RN,    0x1.457d0b2d7bfe3p+3,    0x1.d9dd8eea73f58p-1,  -0x1.fa8bcep-2, INEXACT)
T(RN,    0x1.44621ec272b9ap+3,    0x1.ba0a64f387e9cp-1,  -0x1.fe1c42p-2, INEXACT)
T(RN,    0x1.434828442eec6p+3,    0x1.9c28878a9abafp-1,  -0x1.f67736p-2, INEXACT)
T(RN,    0x1.422f26dced128p+3,    0x1.7ffb3de9eb74cp-1,   -0x1.f6459p-2, INEXACT)
T(RN,    0x1.411719b7a2fc2p+3,    0x1.654e9d9689401p-1,   0x1.f9331cp-2, INEXACT)
T(RN,   -0x1.2affffffffff8p+8,   -0x1.38fe4ad9928e8p-1,  -0x1.f98f34p-2, INEXACT)
T(RN,   -0x1.29c9aa66449cbp+8,    0x1.90485db96b293p-1,   -0x1.fe2cep-2, INEXACT)
T(RN,   -0x1.289496e5bad59p+8,   -0x1.9dacae901fa68p+1,  -0x1.fe7abcp-2, INEXACT)
T(RN,   -0x1.2760c43013b32p+8,   -0x1.18209d79b7e2ep-4,  -0x1.f748acp-2, INEXACT)
T(RN,   -0x1.262e30f85b466p+8,    0x1.0ed19dfd058b6p+1,    0x1.fc9f6p-2, INEXACT)
T(RN,   -0x1.24fcdbf2f7265p+8,   -0x1.12258da49f38bp+0,   0x1.fcafbcp-2, INEXACT)
T(RN,   -0x1.23ccc3d5a51a9p+8,    0x1.8b1dac2063ddep-2,  -0x1.fc303ep-2, INEXACT)
T(RN,    -0x1.229de75779b3p+8,    0x1.9a65fa68dcca4p+5,   0x1.fea4c8p-2, INEXACT)
T(RN,   -0x1.21704530dedc4p+8,   -0x1.bf89b645aa7b9p-2,   0x1.f601b8p-2, INEXACT)
T(RN,   -0x1.2043dc1b928ffp+8,    0x1.e80b03e145b0cp-1,   0x1.fb152ep-2, INEXACT)
T(RN,   -0x1.1f18aad2a55f5p+8,   -0x1.54b5f6677bfc6p+1,   0x1.ffcd52p-2, INEXACT)
T(RN,   -0x1.1deeb01279191p+8,   -0x1.84f13536f53a7p-5,   0x1.fb06ecp-2, INEXACT)
T(RN,   -0x1.1cc5ea98bf82ep+8,    0x1.0304a92117847p+1,   -0x1.f88e9p-2, INEXACT)
T(RN,   -0x1.1b9e592478c7dp+8,   -0x1.32ab8cb57bfe8p+0,   0x1.fa43dcp-2, INEXACT)
T(RN,   -0x1.1a77fa75f25c2p+8,    0x1.208f20b8cb9c7p-2,   0x1.feb7bcp-2, INEXACT)
T(RN,   -0x1.1952cd4ec573cp+8,    0x1.a4e3da2c5974ep+2,   0x1.ffd0aap-2, INEXACT)
T(RN,   -0x1.182ed071d5bfep+8,   -0x1.504492696ce59p-1,   0x1.fa5684p-2, INEXACT)
T(RN,   -0x1.170c02a3500b4p+8,    0x1.3d52bcc2dcfe3p-1,  -0x1.f87798p-2, INEXACT)
T(RN,   -0x1.15ea62a8a90f2p+8,   -0x1.141ba3199a47ep+3,  -0x1.fd2e06p-2, INEXACT)
T(RN,   -0x1.14c9ef489bc73p+8,   -0x1.5d34c07937e43p-2,  -0x1.fa6448p-2, INEXACT)
T(RN,   -0x1.13aaa74b28792p+8,    0x1.0433ba0b2fc77p+0,    0x1.fb8d4p-2, INEXACT)
T(RN,   -0x1.128c89799337dp+8,   -0x1.6968a97e0e783p+1,  -0x1.f909eep-2, INEXACT)
T(RN,   -0x1.116f949e628f5p+8,   -0x1.e2ade08e30c2ep-4,   0x1.fd553ap-2, INEXACT)
T(RN,   -0x1.1053c7855e4e5p+8,    0x1.872ab81507affp+0,  -0x1.f85ae4p-2, INEXACT)
T(RN,   -0x1.0f3920fb8e1bep+8,    -0x1.ba605cb56629p+0,  -0x1.ff9736p-2, INEXACT)
T(RN,   -0x1.0e1f9fcf38499p+8,     0x1.b62a1d41d9f5p-5,   0x1.fa6996p-2, INEXACT)
T(RN,   -0x1.0d0742cfe06bep+8,    0x1.1cf2e5d001c46p+1,   0x1.fd0214p-2, INEXACT)
T(RN,   -0x1.0bf008ce4629ap+8,   -0x1.4419eef422bc5p+0,  -0x1.fa4a3cp-2, INEXACT)
T(RN,   -0x1.0ad9f09c63e19p+8,    0x1.7d3e982b1108fp-3,   0x1.f71434p-2, INEXACT)
T(RN,   -0x1.09c4f90d6d6bep+8,    0x1.96cbca7f3dfe6p+1,   -0x1.febe1p-2, INEXACT)
T(RN,   -0x1.08b120f5ced8fp+8,   -0x1.0699e67cabe52p+0,   0x1.fedb02p-2, INEXACT)
T(RN,   -0x1.079e672b2b212p+8,    0x1.20f18f189a369p-2,   0x1.ff7ebap-2, INEXACT)
T(RN,   -0x1.068cca845aed7p+8,     0x1.151b22a71d4ep+2,   0x1.fb5e42p-2, INEXACT)
T(RN,   -0x1.057c49d96b547p+8,   -0x1.cd42a48a7c7a4p-1,  -0x1.fd3de6p-2, INEXACT)
T(RN,   -0x1.046ce4039c942p+8,    0x1.5b211cf6ae53fp-2,   0x1.f6535ap-2, INEXACT)
T(RN,   -0x1.035e97dd60d3dp+8,    0x1.5033d00cfc8f9p+2,  -0x1.fb96fcp-2, INEXACT)
T(RN,   -0x1.025164425aedbp+8,    -0x1.b5b6f2cad5e5p-1,  -0x1.fa24d4p-2, INEXACT)
T(RN,   -0x1.0145480f5d2c2p+8,    0x1.6a3034f23ea53p-2,  -0x1.feb80ap-2, INEXACT)
T(RN,   -0x1.003a42226817fp+8,    0x1.50d39f0ac61a5p+2,  -0x1.fedd16p-2, INEXACT)
T(RN,   -0x1.fe60a2b552558p+7,   -0x1.c0d1ef6512911p-1,  -0x1.fb9866p-2, INEXACT)
T(RN,   -0x1.fc4ee930f35a9p+7,    0x1.4d8948da9c255p-2,   -0x1.f8a55p-2, INEXACT)
T(RN,   -0x1.fa3f557abae79p+7,    0x1.16ffbbe64e0b6p+2,   0x1.fdebdep-2, INEXACT)
T(RN,   -0x1.f831e5580351bp+7,   -0x1.f082b0cc1fb65p-1,   -0x1.f777bp-2, INEXACT)
T(RN,   -0x1.f62696907732bp+7,    0x1.07b3a3994c799p-2,   0x1.f922a6p-2, INEXACT)
T(RN,   -0x1.f41d66ee0f2a1p+7,    0x1.9c9aeca62703ep+1,  -0x1.f774f8p-2, INEXACT)
T(RN,   -0x1.f216543d0f11ep+7,   -0x1.28089fefabe69p+0,   0x1.fab082p-2, INEXACT)
T(RN,   -0x1.f0115c4c03efbp+7,    0x1.3988326631915p-3,   0x1.f5d5e2p-2, INEXACT)
T(RN,   -0x1.ee0e7cebc1fecp+7,    0x1.23e298b027f29p+1,  -0x1.f5f6b4p-2, INEXACT)
T(RN,   -0x1.ec0db3ef61018p+7,   -0x1.7fc938d576c8ep+0,   0x1.fcfc6cp-2, INEXACT)
T(RN,    -0x1.ea0eff2c3b59p+7,    0x1.e9790f0faa174p-7,  -0x1.fa714cp-2, INEXACT)
T(RN,   -0x1.e8125c79eadb7p+7,    0x1.96210c712223cp+0,   -0x1.f69fap-2, INEXACT)
T(RN,   -0x1.e617c9b246dfbp+7,   -0x1.19581d1d22369p+1,  -0x1.fef6e6p-2, INEXACT)
T(RN,   -0x1.e41f44b161833p+7,   -0x1.47388685b8b8ep-3,   0x1.fd8a6ap-2, INEXACT)
T(RN,   -0x1.e228cb5585b57p+7,     0x1.13fdab844852p+0,  -0x1.f60a92p-2, INEXACT)
T(RN,    -0x1.e0345b7f34f4p+7,   -0x1.11dbac315732ap+2,    -0x1.fdfbp-2, INEXACT)
T(RN,    -0x1.de41f3112481p+7,   -0x1.8a8ad2ecd5631p-2,  -0x1.fc8192p-2, INEXACT)
T(RN,   -0x1.dc518ff03baa4p+7,    0x1.5f96768927c4fp-1,   0x1.fefcf4p-2, INEXACT)
T(RN,   -0x1.da6330039130bp+7,     0x1.1f539a7e3909p+8,   0x1.fe0a4ep-2, INEXACT)
T(RN,   -0x1.d876d134691f4p+7,   -0x1.67d7f9e6b5f98p-1,  -0x1.feac74p-2, INEXACT)
T(RN,   -0x1.d68c716e32847p+7,    0x1.702a9b7b66662p-2,   0x1.fe9166p-2, INEXACT)
T(RN,   -0x1.d4a40e9e852b7p+7,    0x1.cb54c2493efe8p+1,  -0x1.fc253cp-2, INEXACT)
T(RN,   -0x1.d2bda6b51f5c7p+7,   -0x1.3db6e83b59cf5p+0,   0x1.fb346ep-2, INEXACT)
T(RN,   -0x1.d0d937a3e3b51p+7,    0x1.b78afbc898003p-5,   -0x1.f68e8p-2, INEXACT)
T(RN,   -0x1.cef6bf5ed6d8fp+7,    0x1.8b25ca94292ebp+0,   0x1.f70b7ep-2, INEXACT)
T(RN,   -0x1.cd163bdc1d4b5p+7,   -0x1.50591e675a223p+1,  -0x1.f964fcp-2, INEXACT)
T(RN,    -0x1.cb37ab13f925p+7,    -0x1.1e1e2f234b5fp-2,  -0x1.f9d288p-2, INEXACT)
T(RN,   -0x1.c95b0b00c8012p+7,    0x1.8c1783b6a020fp-1,  -0x1.f755b6p-2, INEXACT)
T(RN,   -0x1.c780599f00b08p+7,   -0x1.0e8cc1157eee3p+6,   0x1.fc8e58p-2, INEXACT)
T(RN,   -0x1.c5a794ed31208p+7,   -0x1.7760ef2ee76cap-1,  -0x1.fadafcp-2, INEXACT)
T(RN,   -0x1.c3d0baebfb078p+7,     0x1.2e39fbfbf116p-2,  -0x1.f5ce12p-2, INEXACT)
T(RN,   -0x1.c1fbc99e17475p+7,    0x1.4c150a3a8b302p+1,   0x1.f939d4p-2, INEXACT)
T(RN,   -0x1.c028bf0848b81p+7,    -0x1.a6f1fd299e57p+0,   0x1.f6e0f2p-2, INEXACT)
T(RN,    -0x1.be5799316514p+7,   -0x1.e5a27affbc9dfp-4,   0x1.f86ecep-2, INEXACT)
T(RN,   -0x1.bc8856224d57bp+7,    0x1.00b781de4597ep+0,  -0x1.f8d024p-2, INEXACT)
T(RN,   -0x1.babaf3e5ec93ap+7,   -0x1.0fed3adf2ab4bp+3,   0x1.fe24aep-2, INEXACT)
T(RN,   -0x1.b8ef70893601ep+7,   -0x1.3e45d2171c0cep-1,  -0x1.f84a04p-2, INEXACT)
T(RN,   -0x1.b725ca1b22e09p+7,    0x1.678dbfd249417p-2,   0x1.f8184ep-2, INEXACT)
T(RN,   -0x1.b55dfeacb0257p+7,    0x1.668bfddaa01e1p+1,  -0x1.fbae6ep-2, INEXACT)
T(RN,   -0x1.b3980c50dcac4p+7,   -0x1.a77de1bd15872p+0,    0x1.fbc54p-2, INEXACT)
T(RN,   -0x1.b1d3f11ca6f76p+7,    -0x1.29158de7e566p-3,   0x1.f8bea4p-2, INEXACT)
T(RN,   -0x1.b011ab270b288p+7,    0x1.cf2fb4137d50bp-1,    0x1.fcb52p-2, INEXACT)
T(RN,   -0x1.ae51388900f03p+7,   -0x1.8b36bdc755372p+4,   0x1.fbeca6p-2, INEXACT)
T(RN,   -0x1.ac92975d797e1p+7,   -0x1.8bbc74ab911f2p-1,   0x1.f84912p-2, INEXACT)
T(RN,   -0x1.aad5c5c15d6c1p+7,    0x1.b62d767867c14p-3,   0x1.f5d30ap-2, INEXACT)
T(RN,   -0x1.a91ac1d38ac05p+7,    0x1.da8094181dbc8p+0,  -0x1.f66e78p-2, INEXACT)
T(RN,   -0x1.a76189b4d2fd7p+7,   -0x1.4cf8ed3785e7ep+1,   0x1.fecffcp-2, INEXACT)
T(RN,   -0x1.a5aa1b87f8bfcp+7,   -0x1.709d4d9e6d97bp-2,    0x1.f6a02p-2, INEXACT)
T(RN,   -0x1.a3f47571ae2b5p+7,    0x1.1de321a7426fap-1,   0x1.f6e058p-2, INEXACT)
T(RN,   -0x1.a240959892a13p+7,    0x1.2bee35b8e67abp+2,   0x1.f7ca66p-2, INEXACT)
T(RN,   -0x1.a08e7a2530d83p+7,   -0x1.5989815091344p+0,  -0x1.f61beep-2, INEXACT)
T(RN,   -0x1.9ede2141fcf35p+7,   -0x1.6c67926c96612p-4,  -0x1.f935fap-2, INEXACT)
T(RN,   -0x1.9d2f891b5239bp+7,    0x1.df27b0b54141dp-1,  -0x1.f7102ap-2, INEXACT)
T(RN,   -0x1.9b82afdf71854p+7,   -0x1.a37087c2e4fc3p+5,  -0x1.fd879cp-2, INEXACT)
T(RN,   -0x1.99d793be7ef1bp+7,   -0x1.bed2b4021c162p-1,  -0x1.f7abecp-2, INEXACT)
T(RN,   -0x1.982e32ea802edp+7,    0x1.d2084fceb45bap-4,   -0x1.f83fdp-2, INEXACT)
T(RN,   -0x1.96868b975a48fp+7,    0x1.5f1178e29007ep+0,  -0x1.f7debep-2, INEXACT)
T(RN,   -0x1.94e09bfacfe92p+7,   -0x1.45af84f22cd02p+2,   0x1.fcceb4p-2, INEXACT)
T(RN,   -0x1.933c624c7f588p+7,   -0x1.3e285f10c4041p-1,   0x1.f7488ep-2, INEXACT)
T(RN,   -0x1.9199dcc5e080bp+7,    0x1.11f5f134097d6p-2,  -0x1.ff6202p-2, INEXACT)
T(RN,   -0x1.8ff909a24318ap+7,    0x1.d9ebd359d9e89p+0,  -0x1.fc95f8p-2, INEXACT)
T(RN,   -0x1.8e59e71eccac2p+7,    -0x1.881908b60c9dp+1,   0x1.fb535ep-2, INEXACT)
T(RN,    -0x1.8cbc737a76c3p+7,   -0x1.ebc94e319b31ap-2,  -0x1.f8350cp-2, INEXACT)
T(RN,   -0x1.8b20acf60ce0cp+7,    0x1.7d5ee0b6ec0a5p-2,  -0x1.fa959ep-2, INEXACT)
T(RN,   -0x1.898691d42abadp+7,    0x1.23df26092aba8p+1,  -0x1.f5c84ep-2, INEXACT)
T(RN,   -0x1.87ee20593a46cp+7,   -0x1.3c603183d2a72p+1,   0x1.fc7e2cp-2, INEXACT)
T(RN,   -0x1.865756cb71f3dp+7,   -0x1.a71fb6409bb79p-2,  -0x1.fff01ap-2, INEXACT)
T(RN,   -0x1.84c23372d29c8p+7,    0x1.b0457b23005cbp-2,  -0x1.fb31fap-2, INEXACT)
T(RN,    -0x1.832eb49925dfp+7,    0x1.3d7327f68e8fbp+1,     0x1.f6b4p-2, INEXACT)
T(RN,   -0x1.819cd889fc22ep+7,   -0x1.2d65546954264p+1,   0x1.f8de9ep-2, INEXACT)
T(RN,   -0x1.800c9d92aacc8p+7,   -0x1.a1ea8b934b00bp-2,   -0x1.f837fp-2, INEXACT)
T(RN,   -0x1.7e7e02024a6a9p+7,    0x1.a62b447001b45p-2,    0x1.fbff8p-2, INEXACT)
T(RN,   -0x1.7cf10429b4ce1p+7,    0x1.2b170274dee0cp+1,  -0x1.f7cca8p-2, INEXACT)
T(RN,   -0x1.7b65a25b83597p+7,   -0x1.4c20daf1012e2p+1,    -0x1.f9c3p-2, INEXACT)
T(RN,   -0x1.79dbdaec0d0a5p+7,   -0x1.da66fc8f8cf2bp-2,  -0x1.f83536p-2, INEXACT)
T(RN,   -0x1.7853ac3164cafp+7,    0x1.6130f6e493668p-2,   0x1.ff6216p-2, INEXACT)
T(RN,   -0x1.76cd1483578b9p+7,    0x1.f0d520e63a1bfp+0,   -0x1.f828dp-2, INEXACT)
T(RN,   -0x1.7548123b6a8f9p+7,   -0x1.b685f0dcbea97p+1,  -0x1.f68b54p-2, INEXACT)
T(RN,   -0x1.73c4a3b4d99f3p+7,   -0x1.2c0e0726776fep-1,  -0x1.f9fffap-2, INEXACT)
T(RN,   -0x1.7242c74c951c7p+7,    0x1.d19732efec7d2p-3,  -0x1.f89404p-2, INEXACT)
T(RN,   -0x1.70c27b61406cap+7,    0x1.78e00a69bbd1cp+0,  -0x1.f6cecep-2, INEXACT)
T(RN,    -0x1.6f43be53304fp+7,   -0x1.a503ba49f0ebfp+2,   0x1.fe51b8p-2, INEXACT)
T(RN,   -0x1.6dc68e84689adp+7,   -0x1.9a2e43f6ec5f8p-1,   0x1.fedb62p-2, INEXACT)
T(RN,   -0x1.6c4aea589b11dp+7,    0x1.0ef453e6c90e9p-4,  -0x1.fd992cp-2, INEXACT)
T(RN,   -0x1.6ad0d035254bfp+7,    0x1.09fd9d7bf70e9p+0,  -0x1.fedf3ep-2, INEXACT)
T(RN,   -0x1.69583e810f28dp+7,    0x1.03e00db736468p+5,   0x1.fb646cp-2, INEXACT)
T(RN,   -0x1.67e133a508ef3p+7,   -0x1.2ede624907489p+0,  -0x1.fab2bcp-2, INEXACT)
T(RN,   -0x1.666bae0b69a94p+7,   -0x1.1fa0e335ccd3ap-3,   -0x1.ff0d8p-2, INEXACT)
T(RN,   -0x1.64f7ac202d73bp+7,    0x1.54a05ea690917p-1,   0x1.f62326p-2, INEXACT)
T(RN,   -0x1.63852c50f3b8ap+7,     0x1.e0ef1e169723p+1,   0x1.ff4b9cp-2, INEXACT)
T(RN,   -0x1.62142d0cfd723p+7,    -0x1.01f9e9f4a8a9p+1,    0x1.f69d5p-2, INEXACT)
T(RN,   -0x1.60a4acc52bceap+7,   -0x1.a7d8a9b25ecb8p-2,   0x1.fb911cp-2, INEXACT)
T(RN,   -0x1.5f36a9ebfddc3p+7,    0x1.56195f596b194p-2,  -0x1.fa035ep-2, INEXACT)
T(RN,   -0x1.5dca22f58f724p+7,    0x1.ae931acf3ad96p+0,   0x1.ff2a58p-2, INEXACT)
T(RN,   -0x1.5c5f16579753bp+7,   -0x1.6ef2916ce7019p+2,   0x1.fb9506p-2, INEXACT)
T(RN,   -0x1.5af58289655f6p+7,   -0x1.a8393c1319006p-1,    0x1.fe9d7p-2, INEXACT)
T(RN,   -0x1.598d6603e12e4p+7,    0x1.7674de33c78a5p-7,   0x1.f5cd38p-2, INEXACT)
T(RN,   -0x1.5826bf41881f3p+7,     0x1.b9c9fecf0baap-1,   0x1.fd2f3cp-2, INEXACT)
T(RN,   -0x1.56c18cbe6be89p+7,    0x1.8982770596d89p+2,   0x1.f60078p-2, INEXACT)
T(RN,   -0x1.555dccf830f34p+7,   -0x1.b157b1ae12fb7p+0,  -0x1.fb94f8p-2, INEXACT)
T(RN,   -0x1.53fb7e6e0c852p+7,   -0x1.703946b7f285ap-2,  -0x1.fad9fap-2, INEXACT)
T(RN,   -0x1.529a9fa0c3684p+7,    0x1.6ed8b2c6a8584p-2,    0x1.fe1f4p-2, INEXACT)
T(RN,   -0x1.513b2f12a80f2p+7,    0x1.aab2d3797fe89p+0,   0x1.fe452ap-2, INEXACT)
T(RN,   -0x1.4fdd2b4799201p+7,   -0x1.bbc1344c757bap+2,  -0x1.fc626cp-2, INEXACT)
T(RN,   -0x1.4e8092c4ffc61p+7,   -0x1.d9d6fab729c52p-1,  -0x1.fb68f8p-2, INEXACT)
T(RN,   -0x1.4d256411ce23cp+7,   -0x1.1980ce523671ep-4,    0x1.f658dp-2, INEXACT)
T(RN,   -0x1.4bcb9db67da74p+7,     0x1.635ad0839b3dp-1,   0x1.fdc00ap-2, INEXACT)
T(RN,   -0x1.4a733e3d0d948p+7,    0x1.aaa576e832895p+1,   0x1.fd7c56p-2, INEXACT)
T(RN,   -0x1.491c44310148fp+7,   -0x1.41f57bea349d4p+1,  -0x1.f8e688p-2, INEXACT)
T(RN,   -0x1.47c6ae1f5ecb6p+7,   -0x1.28b7a9abf9f4cp-1,  -0x1.fcacfap-2, INEXACT)
T(RN,   -0x1.46727a96ad2a5p+7,    0x1.1efe17800d4dep-3,  -0x1.fc0b48p-2, INEXACT)
T(RN,    -0x1.451fa826f2eap+7,    0x1.081bf388a7d1ep+0,    -0x1.fe83p-2, INEXACT)
T(RN,   -0x1.43ce3561b47d3p+7,    0x1.1fcf929cac039p+3,  -0x1.faa6bcp-2, INEXACT)
T(RN,   -0x1.427e20d9f2bdep+7,   -0x1.a5a03da490383p+0,   0x1.f60bd6p-2, INEXACT)
T(RN,   -0x1.412f6924294d7p+7,   -0x1.8eca8129c9c6dp-2,   -0x1.f807ap-2, INEXACT)
T(RN,   -0x1.3fe20cd64d266p+7,    0x1.262580a3bb6d9p-2,  -0x1.fe578ep-2, INEXACT)
T(RN,   -0x1.3e960a87cafe2p+7,    0x1.55f5e855da649p+0,  -0x1.ff548ap-2, INEXACT)
T(RN,   -0x1.3d4b60d185c45p+7,   -0x1.37eae0070d4acp+8,   0x1.f836bap-2, INEXACT)
T(RN,   -0x1.3c020e4dd5498p+7,    -0x1.53452ce9c53dp+0,   0x1.ffdff4p-2, INEXACT)
T(RN,   -0x1.3aba119884571p+7,   -0x1.2aa7744acf2a9p-2,    0x1.f6306p-2, INEXACT)
T(RN,   -0x1.3973694ecf965p+7,    0x1.7ab1953b6b056p-2,   0x1.faa84ep-2, INEXACT)
T(RN,   -0x1.382e140f62f38p+7,    0x1.85c075e2d5374p+0,  -0x1.f5c56ap-2, INEXACT)
T(RN,   -0x1.36ea107a5c9a8p+7,   -0x1.355355fb8a418p+4,   0x1.f63c82p-2, INEXACT)
T(RN,   -0x1.35a75d3142ebbp+7,   -0x1.3b4f8ed382b46p+0,   0x1.f78ce4p-2, INEXACT)
T(RN,   -0x1.3465f8d70b0a4p+7,   -0x1.11a3930fc5f84p-2,   0x1.fc72bap-2, INEXACT)
T(RN,   -0x1.3325e21013d79p+7,    0x1.862d9c859c354p-2,  -0x1.f6ee72p-2, INEXACT)
T(RN,   -0x1.31e7178224f8cp+7,    0x1.83427fcf3dcd9p+0,   0x1.fb532cp-2, INEXACT)
T(RN,   -0x1.30a997d46d614p+7,   -0x1.bc29d887c8937p+4,  -0x1.ff0a54p-2, INEXACT)
T(RN,   -0x1.2f6d61af81e51p+7,   -0x1.4e3ddecf0fffap+0,   0x1.fc8192p-2, INEXACT)
T(RN,   -0x1.2e3273bd5bd7dp+7,   -0x1.3f1be28e92e4ep-2,   0x1.f8401cp-2, INEXACT)
T(RN,   -0x1.2cf8cca95782cp+7,    0x1.4897a34d353fbp-2,   0x1.f75226p-2, INEXACT)
T(RN,   -0x1.2bc06b2032a78p+7,    0x1.50a2a66616aa9p+0,  -0x1.f930f4p-2, INEXACT)
T(RN,   -0x1.2a894dd00b4eep+7,    0x1.780f6494150edp+4,   0x1.ffeac6p-2, INEXACT)
T(RN,   -0x1.295373685e0d6p+7,   -0x1.95ec0c3f5b2cap+0,  -0x1.f9a132p-2, INEXACT)
T(RN,   -0x1.281eda9a04d48p+7,   -0x1.b77b473113ca6p-2,   0x1.ff8708p-2, INEXACT)
T(RN,   -0x1.26eb821735668p+7,    0x1.943d78e70bf95p-3,  -0x1.f8d1f8p-2, INEXACT)
T(RN,   -0x1.25b968937ff0ep+7,    0x1.03c7f246ca25ep+0,   0x1.f90638p-2, INEXACT)
T(RN,   -0x1.24888cc3cdbaap+7,     0x1.5a8290db5b85p+2,   0x1.fdd0c2p-2, INEXACT)
T(RN,   -0x1.2358ed5e5fa4bp+7,     -0x1.2633ea9a91dp+1,  -0x1.fd56acp-2, INEXACT)
T(RN,   -0x1.222a891acccbbp+7,   -0x1.480adccc0e454p-1,   0x1.fda582p-2, INEXACT)
T(RN,   -0x1.20fd5eb20133ep+7,    0x1.2d7b97684fe0ap-6,   0x1.fbceb8p-2, INEXACT)
T(RN,   -0x1.1fd16cde3c4e3p+7,     0x1.617728f2ffa1p-1,  -0x1.fec0b4p-2, INEXACT)
T(RN,   -0x1.1ea6b25b0fb5cp+7,    0x1.3d98947a5b62dp+1,   -0x1.fae77p-2, INEXACT)
T(RN,   -0x1.1d7d2de55da24p+7,   -0x1.3f09e65e4ca2cp+2,  -0x1.f6e0aap-2, INEXACT)
T(RN,   -0x1.1c54de3b57ddep+7,   -0x1.047d15e9416e3p+0,   0x1.fd4316p-2, INEXACT)
T(RN,   -0x1.1b2dc21c7df6cp+7,   -0x1.c508a802aaf3ep-3,  -0x1.f92bbep-2, INEXACT)
T(RN,   -0x1.1a07d8499c4a4p+7,    0x1.7d2c13ca86613p-2,  -0x1.fab07ap-2, INEXACT)
T(RN,   -0x1.18e31f84ca755p+7,    0x1.55e271f4afa45p+0,    0x1.f771ep-2, INEXACT)
T(RN,   -0x1.17bf96916a0b2p+7,    0x1.b3a541115f4d3p+3,  -0x1.faf638p-2, INEXACT)
T(RN,    -0x1.169d3c34253dp+7,   -0x1.db9ec77d03011p+0,  -0x1.fc06c4p-2, INEXACT)
T(RN,   -0x1.157c0f32ed8bap+7,   -0x1.1fe3eb5caa8cep-1,  -0x1.f8604ep-2, INEXACT)
T(RN,   -0x1.145c0e54fa69fp+7,    0x1.9c3d91ab4f572p-5,  -0x1.f7907ep-2, INEXACT)
T(RN,   -0x1.133d3862c7ec7p+7,    0x1.663b6fe11c9aap-1,    0x1.f65a4p-2, INEXACT)
T(RN,    -0x1.121f8c26157fp+7,    0x1.2cc9ae33456ecp+1,   0x1.fe721ap-2, INEXACT)
T(RN,   -0x1.11030869e48e8p+7,   -0x1.9e0cedceb662ep+2,   0x1.f94ec6p-2, INEXACT)
T(RN,   -0x1.0fe7abfa773c4p+7,   -0x1.2bc669b8767afp+0,  -0x1.fc96c2p-2, INEXACT)
T(RN,   -0x1.0ecd75a54f157p+7,   -0x1.4b2f2a1b7fcd3p-2,  -0x1.fa32eep-2, INEXACT)
T(RN,   -0x1.0db464392bc1bp+7,    0x1.ecd8814a1cb7ap-3,  -0x1.fafc2ep-2, INEXACT)
T(RN,   -0x1.0c9c768609bc6p+7,    0x1.fd70c11963b5bp-1,  -0x1.fd4224p-2, INEXACT)
T(RN,   -0x1.0b85ab5d20f89p+7,    0x1.01bea85691c33p+2,  -0x1.f6f3c2p-2, INEXACT)
T(RN,   -0x1.0a700190e3e99p+7,   -0x1.9f5e7b14099ebp+1,   0x1.f7799ep-2, INEXACT)
T(RN,    -0x1.095b77f4fda3p+7,   -0x1.cbd247c4db3c1p-1,  -0x1.f8fb46p-2, INEXACT)
T(RN,   -0x1.08480d5e51322p+7,   -0x1.9205d6e45f32ap-3,  -0x1.f759b8p-2, INEXACT)
T(RN,   -0x1.0735c0a2f808cp+7,    0x1.6c6c958e607d7p-2,   0x1.f92f4cp-2, INEXACT)
T(RN,   -0x1.0624909a40b91p+7,    0x1.32d6255b62dd6p+0,     0x1.f6aep-2, INEXACT)
T(RN,   -0x1.05147c1caddb9p+7,    0x1.82f1e361f3b7bp+2,  -0x1.fb3756p-2, INEXACT)
T(RN,   -0x1.04058203f4ab3p+7,   -0x1.4ea1f7b7f5899p+1,  -0x1.fa5fb2p-2, INEXACT)
T(RN,   -0x1.02f7a12afbe1ep+7,   -0x1.9ca43a51e01a3p-1,   0x1.f9ff2cp-2, INEXACT)
T(RN,   -0x1.01ead86dda613p+7,   -0x1.3c9ddbf18eec2p-3,  -0x1.f6e9ccp-2, INEXACT)
T(RN,   -0x1.00df26a9d610ap+7,    0x1.8c88428ed9696p-2,   0x1.fc64eap-2, INEXACT)
T(RN,   -0x1.ffa9157ac5298p+6,    0x1.3c2c211368201p+0,   0x1.f93e36p-2, INEXACT)
T(RN,   -0x1.fd96071040224p+6,     0x1.8793f10b7fa8p+2,   0x1.f62864p-2, INEXACT)
T(RN,   -0x1.fb851fd5b3f8ep+6,   -0x1.59d1fafab1d27p+1,  -0x1.fc5526p-2, INEXACT)
T(RN,   -0x1.f9765d8f0bcc9p+6,   -0x1.b0e77a993803bp-1,  -0x1.f89588p-2, INEXACT)
T(RN,   -0x1.f769be0284813p+6,   -0x1.88ee8f78e88a1p-3,  -0x1.fdf37ep-2, INEXACT)
T(RN,   -0x1.f55f3ef8aa556p+6,    0x1.54214214553bbp-2,   -0x1.f990bp-2, INEXACT)
T(RN,   -0x1.f356de3c567a9p+6,    0x1.1749662712f1ep+0,  -0x1.fe68c2p-2, INEXACT)
T(RN,   -0x1.f150999aacb6fp+6,    0x1.0a5db097a384ap+2,   0x1.fc7b74p-2, INEXACT)
T(RN,   -0x1.ef4c6ee31903bp+6,   -0x1.d1a21f29626c2p+1,  -0x1.fa1476p-2, INEXACT)
T(RN,   -0x1.ed4a5be74d34ep+6,   -0x1.07da4d4b2ac1ap+0,    0x1.ff17bp-2, INEXACT)
T(RN,   -0x1.eb4a5e7b3e895p+6,   -0x1.3d55e2889d0efp-2,  -0x1.fb1b24p-2, INEXACT)
T(RN,   -0x1.e94c7475236bep+6,    0x1.99b78d22a6562p-3,   0x1.f6b2e4p-2, INEXACT)
T(RN,   -0x1.e7509bad71038p+6,    0x1.a9809568b4d11p-1,    0x1.f636bp-2, INEXACT)
T(RN,   -0x1.e556d1fed8f3bp+6,    0x1.3d4584372bd21p+1,    0x1.f8d5cp-2, INEXACT)
T(RN,   -0x1.e35f154646fccp+6,   -0x1.25dff3be9fffdp+3,  -0x1.faf5aep-2, INEXACT)
T(RN,   -0x1.e1696362deb39p+6,   -0x1.777b94a998e19p+0,   -0x1.f9085p-2, INEXACT)
T(RN,   -0x1.df75ba35f929fp+6,   -0x1.0d74238f13816p-1,    0x1.f6953p-2, INEXACT)
T(RN,   -0x1.dd8417a322af1p+6,   0x1.8f9e00f32066bp-10,  -0x1.fab944p-2, INEXACT)
T(RN,   -0x1.db94799018849p+6,    0x1.0e28c34c0e146p-1,   0x1.fe9de8p-2, INEXACT)
T(RN,   -0x1.d9a6dde4c691ep+6,    0x1.739c9a9dff843p+0,  -0x1.fbd0a6p-2, INEXACT)
T(RN,   -0x1.d7bb428b45295p+6,    0x1.0289c4dab3596p+3,   0x1.fdc412p-2, INEXACT)
T(RN,   -0x1.d5d1a56fd6c09p+6,   -0x1.594be9ed7eb99p+1,  -0x1.f8af28p-2, INEXACT)
T(RN,   -0x1.d3ea0480e5b05p+6,   -0x1.d32179dcef3e1p-1,   0x1.fd685ep-2, INEXACT)
T(RN,   -0x1.d2045daf01fcdp+6,    -0x1.1643ba2b645dp-2,   0x1.f71f8cp-2, INEXACT)
T(RN,   -0x1.d020aeecdef18p+6,    0x1.ae1eb7acd885ap-3,  -0x1.f5f1aep-2, INEXACT)
T(RN,   -0x1.ce3ef62f51a89p+6,    0x1.9bdf836b7b542p-1,   0x1.fdb37ap-2, INEXACT)
T(RN,   -0x1.cc5f316d4d5b7p+6,    0x1.1af2eb1a3d503p+1,   -0x1.f69a6p-2, INEXACT)
T(RN,   -0x1.ca815e9fe295fp+6,   -0x1.7e9aa7de7720fp+4,   0x1.f6e0d2p-2, INEXACT)
T(RN,   -0x1.c8a57bc23c912p+6,   -0x1.cd6bc90941a29p+0,  -0x1.fa9a6cp-2, INEXACT)
T(RN,   -0x1.c6cb86d19ea19p+6,   -0x1.5f58dd5094f8fp-1,  -0x1.fcb48ap-2, INEXACT)
T(RN,   -0x1.c4f37dcd62946p+6,   -0x1.218bc8a7b3748p-3,   -0x1.fc124p-2, INEXACT)
T(RN,   -0x1.c31d5eb6f637bp+6,    0x1.51d04c1079d6fp-2,   0x1.f5c614p-2, INEXACT)
T(RN,   -0x1.c1492791d94f9p+6,    0x1.f65c507a406f1p-1,  -0x1.f7e9a8p-2, INEXACT)
T(RN,   -0x1.bf76d6639b5fbp+6,    0x1.6a698305b94afp+1,  -0x1.f5f07ep-2, INEXACT)
T(RN,   -0x1.bda66933d98f1p+6,   -0x1.176a098bedd77p+3,  -0x1.f6c16ap-2, INEXACT)
T(RN,   -0x1.bbd7de0c3b78cp+6,   -0x1.932c69f4158eap+0,   0x1.f5cf08p-2, INEXACT)
T(RN,   -0x1.ba0b32f876634p+6,   -0x1.3d9493a047537p-1,  -0x1.fcfd38p-2, INEXACT)
T(RN,   -0x1.b8406606405bdp+6,   -0x1.b88efb714a5ecp-4,  -0x1.f71632p-2, INEXACT)
T(RN,   -0x1.b6777545590ddp+6,     0x1.692c16eb6c01p-2,  -0x1.ffa0dcp-2, INEXACT)
T(RN,   -0x1.b4b05ec781f29p+6,    0x1.fe110033c7813p-1,    0x1.fda41p-2, INEXACT)
T(RN,   -0x1.b2eb20a07d8eap+6,    0x1.648bbee259d14p+1,   0x1.ffcc58p-2, INEXACT)
T(RN,   -0x1.b127b8e60d5b1p+6,   -0x1.4bc4cce9ce085p+3,   0x1.f7ba9ap-2, INEXACT)
T(RN,   -0x1.af6625afef92ap+6,   -0x1.afc3ecfaea55ap+0,   0x1.f670d6p-2, INEXACT)
T(RN,   -0x1.ada66517dd432p+6,   -0x1.5d090bbbeabcap-1,  -0x1.f767acp-2, INEXACT)
T(RN,   -0x1.abe87539881b6p+6,   -0x1.5084401ff7619p-3,  -0x1.f67e38p-2, INEXACT)
T(RN,   -0x1.aa2c543298a42p+6,    0x1.1c59559b1cd0ep-2,    0x1.fa015p-2, INEXACT)
T(RN,   -0x1.a8720022abc1dp+6,    0x1.b1ba22efbbc05p-1,   0x1.fc7da2p-2, INEXACT)
T(RN,   -0x1.a6b9772b51216p+6,    0x1.117933ff3b96bp+1,  -0x1.fe3d56p-2, INEXACT)
T(RN,   -0x1.a502b77008f66p+6,    0x1.ae2453892b769p+6,   0x1.f8a736p-2, INEXACT)
T(RN,   -0x1.a34dbf1641fcep+6,   -0x1.209e26e2573d7p+1,  -0x1.f60e42p-2, INEXACT)
T(RN,   -0x1.a19a8c455797dp+6,   -0x1.c8b20073bcf38p-1,   0x1.fe3dc6p-2, INEXACT)
T(RN,   -0x1.9fe91d268f997p+6,   -0x1.427bba7d5b8abp-2,  -0x1.fea3d2p-2, INEXACT)
T(RN,   -0x1.9e396fe518797p+6,    0x1.df37576c708fbp-4,  -0x1.f9b036p-2, INEXACT)
T(RN,   -0x1.9c8b82ae0741cp+6,     0x1.3059aaa87a78p-1,  -0x1.f65d56p-2, INEXACT)
T(RN,   -0x1.9adf53b05566bp+6,    0x1.6962a4c3b48fap+0,   0x1.f5ca36p-2, INEXACT)
T(RN,    -0x1.9934e11cdfdbp+6,    0x1.3beb2c49e117dp+2,   0x1.f75552p-2, INEXACT)
T(RN,   -0x1.978c292662fc5p+6,   -0x1.253c0f604b61bp+2,  -0x1.f83ac8p-2, INEXACT)
T(RN,   -0x1.95e52a017ac0bp+6,   -0x1.609d0db0bbd89p+0,   0x1.fc53cep-2, INEXACT)
T(RN,   -0x1.943fe1e49fbcap+6,   -0x1.2cf7951cfd66ep-1,   0x1.fd0ffap-2, INEXACT)
T(RN,   -0x1.929c4f08255b2p+6,   -0x1.f4e08570da019p-4,  -0x1.fa6f74p-2, INEXACT)
T(RN,   -0x1.90fa6fa637ff5p+6,    0x1.2d9000948ad99p-2,  -0x1.f6bba4p-2, INEXACT)
T(RN,   -0x1.8f5a41fadb0bep+6,     0x1.a901e2048ba6p-1,   0x1.f8dec4p-2, INEXACT)
T(RN,   -0x1.8dbbc443e71b4p+6,    0x1.f40150901755ep+0,   0x1.f9d7cap-2, INEXACT)
T(RN,   -0x1.8c1ef4c107d91p+6,    0x1.c7fdb7173161cp+3,  -0x1.f97b12p-2, INEXACT)
T(RN,    -0x1.8a83d1b3ba64p+6,   -0x1.73f2e11f73a0dp+1,    0x1.f638cp-2, INEXACT)
T(RN,   -0x1.88ea595f4b3bap+6,   -0x1.1d4e432248f1cp+0,  -0x1.f9975cp-2, INEXACT)
T(RN,   -0x1.87528a08d473dp+6,   -0x1.e39f323c29dc3p-2,  -0x1.f725aap-2, INEXACT)
T(RN,   -0x1.85bc61f73bcadp+6,    -0x1.6d90f4cbf702p-5,  -0x1.f8e608p-2, INEXACT)
T(RN,   -0x1.8427df7330d93p+6,    0x1.764af59279122p-2,   0x1.fee14ap-2, INEXACT)
T(RN,    -0x1.829500c72b2dp+6,    0x1.d723dee5383c4p-1,  -0x1.fbd144p-2, INEXACT)
T(RN,   -0x1.8103c43f686d4p+6,     0x1.1361731d0a07p+1,  -0x1.f94e16p-2, INEXACT)
T(RN,   -0x1.7f742829ea8b6p+6,    0x1.647006fda7c7fp+4,  -0x1.f95b4ep-2, INEXACT)
T(RN,   -0x1.7de62ad675ef5p+6,   -0x1.65852ded18b6ap+1,   0x1.f89cf6p-2, INEXACT)
T(RN,   -0x1.7c59ca968f998p+6,   -0x1.1d8c710c96e83p+0,  -0x1.ffffecp-2, INEXACT)
T(RN,   -0x1.7acf05bd7b56cp+6,   -0x1.f43497ff25617p-2,   0x1.ff04e8p-2, INEXACT)
T(RN,   -0x1.7945daa039f55p+6,   -0x1.20fd24e31a9ccp-4,   0x1.fb0614p-2, INEXACT)
T(RN,   -0x1.77be479587699p+6,    0x1.4a3ab72257433p-2,   0x1.f9f87ep-2, INEXACT)
T(RN,   -0x1.76384af5d91a7p+6,    0x1.a8fe3e4c8791ap-1,   0x1.fbc508p-2, INEXACT)
T(RN,   -0x1.74b3e31b5bf6ep+6,    0x1.d611e6ccabbdcp+0,  -0x1.f8f20ep-2, INEXACT)
T(RN,   -0x1.73310e61f2c6fp+6,    0x1.0756fc16c05d5p+3,   0x1.fa8acap-2, INEXACT)
T(RN,   -0x1.71afcb273459fp+6,   -0x1.ea6922e14f42dp+1,   0x1.fcbc84p-2, INEXACT)
T(RN,   -0x1.703017ca69c71p+6,   -0x1.5f190935282f4p+0,  -0x1.f917b6p-2, INEXACT)
T(RN,   -0x1.6eb1f2ac8ca69p+6,   -0x1.46701e0095c01p-1,     0x1.f6a2p-2, INEXACT)
T(RN,   -0x1.6d355a30454f8p+6,   -0x1.96727ea9f24a4p-3,   0x1.f5d7a6p-2, INEXACT)
T(RN,   -0x1.6bba4cb9e9371p+6,    0x1.6887266923625p-3,   0x1.fef29cp-2, INEXACT)
T(RN,   -0x1.6a40c8af78e41p+6,    0x1.34f1dad7665b7p-1,   0x1.feb6c8p-2, INEXACT)
T(RN,   -0x1.68c8cc789e90bp+6,     0x1.495ff093ee13p+0,   -0x1.f6925p-2, INEXACT)
T(RN,   -0x1.6752567eac2c9p+6,    0x1.a5362a4ec617cp+1,  -0x1.f74ee2p-2, INEXACT)
T(RN,   -0x1.65dd652c99f25p+6,   -0x1.cdcb465f63508p+3,   -0x1.f62f1p-2, INEXACT)
T(RN,   -0x1.6469f6ef0439ap+6,   -0x1.15b264b88d2a9p+1,  -0x1.f85b9ep-2, INEXACT)
T(RN,   -0x1.62f80a342a33ap+6,    -0x1.f81bd3d2db68p-1,   0x1.ff75c2p-2, INEXACT)
T(RN,   -0x1.61879d6bec014p+6,   -0x1.c6a47d5d853efp-2,  -0x1.fdf56ap-2, INEXACT)
T(RN,   -0x1.6018af07c9192p+6,   -0x1.e816eb07d48c1p-5,  -0x1.f6c4bap-2, INEXACT)
T(RN,    -0x1.5eab3d7ade7ap+6,    0x1.39cf26c366426p-2,  -0x1.fe8e42p-2, INEXACT)
T(RN,   -0x1.5d3f4739e5214p+6,    0x1.877dab1df97c2p-1,     0x1.f7d2p-2, INEXACT)
T(RN,   -0x1.5bd4cabb304abp+6,    0x1.94b6d65e150dap+0,   0x1.fcd5ccp-2, INEXACT)
T(RN,   -0x1.5a6bc676abc89p+6,     0x1.2a254d6661cbp+2,   -0x1.fa16cp-2, INEXACT)
T(RN,   -0x1.590438e5da5f4p+6,   -0x1.c739587655866p+2,  -0x1.fe00d6p-2, INEXACT)
T(RN,   -0x1.579e2083d41ddp+6,   -0x1.e0abe8549fb21p+0,  -0x1.faefaep-2, INEXACT)
T(RN,   -0x1.56397bcd44be6p+6,   -0x1.cd18a39f1923fp-1,  -0x1.f93abap-2, INEXACT)
T(RN,   -0x1.54d6494069f5ap+6,   -0x1.a073eae74e625p-2,   0x1.f61b4ap-2, INEXACT)
T(RN,   -0x1.5374875d11deep+6,    -0x1.4e62da91e481p-5,  -0x1.fc01dcp-2, INEXACT)
T(RN,   -0x1.521434a499586p+6,    0x1.406eb63619ffep-2,  -0x1.f9bd72p-2, INEXACT)
T(RN,   -0x1.50b54f99ea655p+6,    0x1.81f4702d54bd7p-1,  -0x1.f69108p-2, INEXACT)
T(RN,   -0x1.4f57d6c17a8a9p+6,    0x1.83b5638292074p+0,  -0x1.ff7d68p-2, INEXACT)
T(RN,   -0x1.4dfbc8a14941fp+6,    0x1.016c63630ced8p+2,  -0x1.fede4ep-2, INEXACT)
T(RN,   -0x1.4ca123c0de589p+6,   -0x1.5063c28d8e746p+3,   0x1.fa13a6p-2, INEXACT)
T(RN,   -0x1.4b47e6a948565p+6,   -0x1.15a374cee635fp+1,   0x1.fd892ap-2, INEXACT)
T(RN,   -0x1.49f00fe51aec3p+6,   -0x1.09304fa876adcp+0,  -0x1.facc84p-2, INEXACT)
T(RN,   -0x1.48999e006d61ap+6,   -0x1.032eb45ce020ep-1,  -0x1.f9bdcep-2, INEXACT)
T(RN,   -0x1.47448f88d8fbfp+6,   -0x1.174ef1040ab33p-3,   0x1.ff4322p-2, INEXACT)
T(RN,   -0x1.45f0e30d77724p+6,    0x1.96fc58d478279p-3,    0x1.f9ad6p-2, INEXACT)
T(RN,   -0x1.449e971ee166ap+6,    0x1.299c94ef44b88p-1,   0x1.fb8794p-2, INEXACT)
T(RN,   -0x1.434daa4f2cc97p+6,    0x1.26b4439eb3eefp+0,  -0x1.f7e5e6p-2, INEXACT)
T(RN,   -0x1.41fe1b31eb4bfp+6,    0x1.39965ad49c56ep+1,   -0x1.f6533p-2, INEXACT)
T(RN,   -0x1.40afe85c28e49p+6,    0x1.053b078c6d75ep+4,   0x1.fb540ep-2, INEXACT)
T(RN,   -0x1.3f6310646a4d6p+6,   -0x1.d9c683d985122p+1,  -0x1.ff2454p-2, INEXACT)
T(RN,   -0x1.3e1791e2ab563p+6,   -0x1.8056d28aecdfdp+0,  -0x1.fc4a58p-2, INEXACT)
T(RN,   -0x1.3ccd6b705d8dep+6,   -0x1.8e0364dac5029p-1,  -0x1.f8e1f4p-2, INEXACT)
T(RN,   -0x1.3b849ba866a26p+6,   -0x1.69dcb7eeb3fcbp-2,    0x1.f8237p-2, INEXACT)
T(RN,   -0x1.3a3d21271ed9ap+6,   -0x1.45c39960b3ff4p-6,  -0x1.f66522p-2, INEXACT)
T(RN,   -0x1.38f6fa8a4fba8p+6,    0x1.3b3839329d4f9p-2,   0x1.f9eb2cp-2, INEXACT)
T(RN,   -0x1.37b22671324f7p+6,    0x1.6a51101ea1934p-1,   0x1.fc596ep-2, INEXACT)
T(RN,   -0x1.366ea37c6dd5cp+6,    0x1.5888fcd4de4e3p+0,   0x1.f7d5f2p-2, INEXACT)
T(RN,    -0x1.352c704e163ep+6,    0x1.7caa0b9471bb3p+1,  -0x1.fe336ep-2, INEXACT)
T(RN,   -0x1.33eb8b89aa9b1p+6,    0x1.6b79595fbcf08p+6,  -0x1.fe627ap-2, INEXACT)
T(RN,   -0x1.32abf3d413baep+6,   -0x1.9c2fa00d84084p+1,    0x1.fdfe3p-2, INEXACT)
T(RN,   -0x1.316da7d3a2b55p+6,   -0x1.6cc66edf8d5a3p+0,  -0x1.f82036p-2, INEXACT)
T(RN,   -0x1.3030a6300f5b8p+6,   -0x1.84a5c5532517ap-1,  -0x1.f798c2p-2, INEXACT)
T(RN,   -0x1.2ef4ed9276db4p+6,   -0x1.6b565ff97f719p-2,    0x1.ff476p-2, INEXACT)
T(RN,   -0x1.2dba7ca55a458p+6,   -0x1.15c0cba150697p-5,  -0x1.f6fa6ap-2, INEXACT)
T(RN,   -0x1.2c8152149d146p+6,    0x1.1d8899a11b2b9p-2,   0x1.f6869cp-2, INEXACT)
T(RN,   -0x1.2b496c8d83e27p+6,    0x1.4ce7e5216daa7p-1,   0x1.fda872p-2, INEXACT)
T(RN,    -0x1.2a12cabeb2a4p+6,    0x1.3597e96c73f0ap+0,  -0x1.f61f2ap-2, INEXACT)
T(RN,   -0x1.28dd6b582babep+6,    0x1.38751f9806448p+1,   0x1.ffc132p-2, INEXACT)
T(RN,   -0x1.27a94d0b4ddf2p+6,    0x1.6b16b598df8d7p+3,   0x1.fcc218p-2, INEXACT)
T(RN,   -0x1.26766e8ad38e9p+6,   -0x1.29ae742bc0aa9p+2,   0x1.f8deccp-2, INEXACT)
T(RN,   -0x1.2544ce8ad0de2p+6,   -0x1.c96aa2797e7cdp+0,  -0x1.fb9bd6p-2, INEXACT)
T(RN,   -0x1.24146bc0b2802p+6,    -0x1.e9de44af5c67p-1,  -0x1.fd0006p-2, INEXACT)
T(RN,   -0x1.22e544e33c3cap+6,   -0x1.0251adaa7f3d9p-1,   0x1.fe3808p-2, INEXACT)
T(RN,   -0x1.21b758aa8797ep+6,   -0x1.64a750a9e7fd8p-3,   0x1.f95b84p-2, INEXACT)
T(RN,   -0x1.208aa5d0025a5p+6,    0x1.f3045cc0dd886p-4,       0x1.f8p-2, INEXACT)
T(RN,   -0x1.1f5f2b0e6d64fp+6,    0x1.c190e710626d3p-2,    0x1.fc0c7p-2, INEXACT)
T(RN,   -0x1.1e34e721dafeap+6,    0x1.b39e435970347p-1,   0x1.fbfb44p-2, INEXACT)
T(RN,   -0x1.1d0bd8c7adbc8p+6,    0x1.8a66253ea44cfp+0,  -0x1.f9faf4p-2, INEXACT)
T(RN,   -0x1.1be3febe9709bp+6,    0x1.b1f90a5cb6369p+1,  -0x1.f85536p-2, INEXACT)
T(RN,   -0x1.1abd57c695ce6p+6,  -0x1.0cf2184df7c4ep+10,   0x1.f7f396p-2, INEXACT)
T(RN,   -0x1.1997e2a0f510fp+6,   -0x1.b0de2ccf83b1ap+1,   0x1.fa759ep-2, INEXACT)
T(RN,    -0x1.18739e104a9fp+6,   -0x1.8cd58457768eep+0,    -0x1.f87bp-2, INEXACT)
T(RN,   -0x1.175088d875cbep+6,   -0x1.bb4d234c00915p-1,  -0x1.ff662ep-2, INEXACT)
T(RN,   -0x1.162ea1be9dea3p+6,   -0x1.d63f961af2feep-2,   0x1.faa658p-2, INEXACT)
T(RN,   -0x1.150de78931286p+6,   -0x1.3277b377980fep-3,   0x1.ffd272p-2, INEXACT)
T(RN,   -0x1.13ee58ffe324ep+6,    0x1.107e93f31e3b8p-3,   0x1.fc69dep-2, INEXACT)
T(RN,   -0x1.12cff4ebaba11p+6,    0x1.bf71fc58d4f96p-2,  -0x1.f62be2p-2, INEXACT)
T(RN,   -0x1.11b2ba16c52ddp+6,    0x1.a700c2e4610b9p-1,  -0x1.fbe1b8p-2, INEXACT)
T(RN,   -0x1.1096a74cabe72p+6,    0x1.73e413250284cp+0,  -0x1.f98474p-2, INEXACT)
T(RN,   -0x1.0f7bbb5a1c1a4p+6,    0x1.79e4f27ea7ec4p+1,   0x1.fc5fc6p-2, INEXACT)
T(RN,    -0x1.0e61f50d10fap+6,    0x1.36e49447c096cp+4,   0x1.f821dap-2, INEXACT)
T(RN,   -0x1.0d495334c35d9p+6,   -0x1.1ab32fee7cd63p+2,  -0x1.fd3bd6p-2, INEXACT)
T(RN,   -0x1.0c31d4a1a86ccp+6,   -0x1.d9919312da182p+0,  -0x1.f8de66p-2, INEXACT)
T(RN,   -0x1.0b1b782570639p+6,   -0x1.09604e9af6bcap+0,  -0x1.fdcb4cp-2, INEXACT)
T(RN,   -0x1.0a063c93053a2p+6,   -0x1.2dcfb110e35e3p-1,  -0x1.f991b6p-2, INEXACT)
T(RN,   -0x1.08f220be896b3p+6,   -0x1.13b4c4523ba97p-2,   0x1.f8629ep-2, INEXACT)
T(RN,   -0x1.07df237d56ab5p+6,    0x1.6aded0512422cp-8,  -0x1.f8e9c2p-2, INEXACT)
T(RN,   -0x1.06cd43a5fcbdfp+6,    0x1.1eb3b2cb4f119p-2,  -0x1.f8f6a8p-2, INEXACT)
T(RN,   -0x1.05bc80103ff1dp+6,    0x1.327711f65ea44p-1,   -0x1.fe4edp-2, INEXACT)
T(RN,   -0x1.04acd79518287p+6,    0x1.0a0ddc401efd7p+0,  -0x1.f75a7cp-2, INEXACT)
T(RN,   -0x1.039e490eaf839p+6,    0x1.d277921561e77p+0,   0x1.f7b9ecp-2, INEXACT)
T(RN,   -0x1.0290d35861063p+6,    0x1.06e9e353e0e86p+2,  -0x1.fbd76cp-2, INEXACT)
T(RN,   -0x1.0184754eb77c9p+6,   -0x1.57597b70d2254p+5,   0x1.fdc2b6p-2, INEXACT)
T(RN,   -0x1.00792dcf6c32ap+6,   -0x1.b603f1de0958ap+1,   0x1.fd1a44p-2, INEXACT)
T(RN,    -0x1.feddf772cb7fp+5,   -0x1.a6f819699508ep+0,   0x1.f9bad8p-2, INEXACT)
T(RN,   -0x1.fccbbbd96d7d4p+5,   -0x1.ee1e17bf54c11p-1,   -0x1.f9075p-2, INEXACT)
T(RN,   -0x1.fabba695395fdp+5,   -0x1.1e3d4064a0c78p-1,   -0x1.f64e9p-2, INEXACT)
T(RN,   -0x1.f8adb56afd633p+5,   -0x1.08b5164cdad89p-2,  -0x1.fb294ep-2, INEXACT)
T(RN,   -0x1.f6a1e621d88ddp+5,    0x1.6f1d1da7af69ep-9,   -0x1.fb8eap-2, INEXACT)
T(RN,   -0x1.f498368338618p+5,    0x1.0db32f584c148p-2,    0x1.f9c61p-2, INEXACT)
T(RN,   -0x1.f290a45ad66e8p+5,    0x1.1f379226c79ccp-1,  -0x1.f7c172p-2, INEXACT)
T(RN,   -0x1.f08b2d76b5f04p+5,    0x1.ea70f7dbab2fdp-1,   0x1.ff55c6p-2, INEXACT)
T(RN,   -0x1.ee87cfa72163cp+5,    0x1.9ca98436bff04p+0,   0x1.f8839ep-2, INEXACT)
T(RN,   -0x1.ec8688bea8426p+5,    0x1.97190b82d125bp+1,   0x1.fe5b2cp-2, INEXACT)
T(RN,   -0x1.ea8756921c851p+5,    0x1.2279eda6df4dep+4,   -0x1.fe871p-2, INEXACT)
T(RN,   -0x1.e88a36f8906e3p+5,   -0x1.467dd1fec4cb7p+2,   0x1.f88becp-2, INEXACT)
T(RN,    -0x1.e68f27cb541cp+5,   -0x1.0f132a9fe2bd7p+1,   0x1.f5f5b2p-2, INEXACT)
T(RN,   -0x1.e49626e5f33e4p+5,    -0x1.379bb74b4ab9p+0,  -0x1.fa73bap-2, INEXACT)
T(RN,   -0x1.e29f322632bd9p+5,    -0x1.7b32c5b68396p-1,  -0x1.f6aceap-2, INEXACT)
T(RN,   -0x1.e0aa476c0e84ap+5,   -0x1.a86047c37720bp-2,  -0x1.fe1008p-2, INEXACT)
T(RN,   -0x1.deb76499b7087p+5,   -0x1.34080775f788ap-3,   0x1.fea7f4p-2, INEXACT)
T(RN,    -0x1.dcc687938f2dp+5,    0x1.7f5c6c62e5dfbp-4,   0x1.f9c0a4p-2, INEXACT)
T(RN,   -0x1.dad7ae4029d7cp+5,    0x1.646a756a1db81p-2,   -0x1.f7286p-2, INEXACT)
T(RN,   -0x1.d8ead68847c3fp+5,    0x1.4c3b1b5f8c76ap-1,   -0x1.f868fp-2, INEXACT)
T(RN,   -0x1.d6fffe56d53d5p+5,    0x1.0fc443fb3c1ebp+0,  -0x1.fe3bfep-2, INEXACT)
T(RN,   -0x1.d5172398e7bc6p+5,    0x1.c26a017b48491p+0,  -0x1.f8097ap-2, INEXACT)
T(RN,   -0x1.d330443dbbf11p+5,    0x1.bea3f0ef4a4c9p+1,   0x1.f6883ep-2, INEXACT)
T(RN,   -0x1.d14b5e36b330ep+5,    0x1.79b26634e8c7ap+4,   0x1.f5ce7cp-2, INEXACT)
T(RN,   -0x1.cf686f7751752p+5,   -0x1.46a99be35c269p+2,   0x1.f8b0bap-2, INEXACT)
T(RN,    -0x1.cd8775f53b17p+5,   -0x1.1856b2de076dep+1,   0x1.f723cep-2, INEXACT)
T(RN,   -0x1.cba86fa8329b7p+5,   -0x1.485849256f86dp+0,   0x1.f66a4ep-2, INEXACT)
T(RN,   -0x1.c9cb5a8a16733p+5,   -0x1.9a57fd4519419p-1,  -0x1.fe19c2p-2, INEXACT)
T(RN,   -0x1.c7f03496dee15p+5,   -0x1.e69d925a92d82p-2,  -0x1.ff2cb6p-2, INEXACT)
T(RN,   -0x1.c616fbcc9bb38p+5,   -0x1.b9fd08cb6c5f8p-3,  -0x1.f77a94p-2, INEXACT)
T(RN,   -0x1.c43fae2b722e1p+5,    0x1.1ff5a199cf576p-6,  -0x1.f84cd6p-2, INEXACT)
T(RN,   -0x1.c26a49b59ad19p+5,    0x1.01f2fbde42bd4p-2,   0x1.f712eap-2, INEXACT)
T(RN,   -0x1.c096cc6f5f37fp+5,    0x1.07549530344d6p-1,   -0x1.fd42ap-2, INEXACT)
T(RN,   -0x1.bec5345f17f6ap+5,    0x1.b155f71e5183ep-1,  -0x1.fe4386p-2, INEXACT)
T(RN,   -0x1.bcf57f8d2a6e3p+5,    0x1.5667032b2a99ap+0,  -0x1.fda7acp-2, INEXACT)
T(RN,   -0x1.bb27ac0406b0ep+5,    0x1.2157f541bbcd2p+1,   0x1.f5dec2p-2, INEXACT)
T(RN,   -0x1.b95bb7d02575bp+5,    0x1.4961722e5a52bp+2,   0x1.faa2dap-2, INEXACT)
T(RN,   -0x1.b791a10005ce2p+5,   -0x1.f78d6015f2468p+4,  -0x1.fb1008p-2, INEXACT)
T(RN,   -0x1.b5c965a42b3dbp+5,   -0x1.ebf971cf01a3ep+1,   0x1.f76d74p-2, INEXACT)
T(RN,    -0x1.b40303cf1b85p+5,   -0x1.f015376eefd12p+0,   0x1.fc778cp-2, INEXACT)
T(RN,   -0x1.b23e79955c946p+5,   -0x1.31904f8363e8dp+0,   0x1.f72ec2p-2, INEXACT)
T(RN,   -0x1.b07bc50d72745p+5,   -0x1.87f211a6685bcp-1,  -0x1.f71e18p-2, INEXACT)
T(RN,   -0x1.aebae44fdd465p+5,   -0x1.dad1c17a9031fp-2,  -0x1.f8210cp-2, INEXACT)
T(RN,   -0x1.acfbd57717085p+5,   -0x1.c124d0f10b116p-3,  -0x1.f77728p-2, INEXACT)
T(RN,   -0x1.ab3e969f91d5ep+5,   0x1.8cfc8e77ddd33p-10,   0x1.fa51b2p-2, INEXACT)
T(RN,   -0x1.a98325e7b5772p+5,    0x1.c5c157cea36e5p-3,   0x1.f813cep-2, INEXACT)
T(RN,   -0x1.a7c9816fddac8p+5,     0x1.da3380a18c3ep-2,   0x1.f9a24ep-2, INEXACT)
T(RN,   -0x1.a611a75a5801ep+5,    0x1.83fa60240a588p-1,   0x1.f64848p-2, INEXACT)
T(RN,   -0x1.a45b95cb61efdp+5,    0x1.2ac76a7205022p+0,  -0x1.f9dd36p-2, INEXACT)
T(RN,    -0x1.a2a74ae92679p+5,    0x1.d9c385fd796e5p+0,  -0x1.ff76d8p-2, INEXACT)
T(RN,   -0x1.a0f4c4dbbc9e6p+5,    0x1.b7c496ef257f7p+1,  -0x1.fa8e82p-2, INEXACT)
T(RN,    -0x1.9f4401cd251dp+5,    0x1.bc1f8b6ffa1b4p+3,  -0x1.fe0d56p-2, INEXACT)
T(RN,   -0x1.9d94ffe9488b7p+5,   -0x1.cb0d2366c51e3p+2,  -0x1.f988cep-2, INEXACT)
T(RN,   -0x1.9be7bd5df5484p+5,   -0x1.60b5ae4c63f4fp+1,  -0x1.f6ddacp-2, INEXACT)
T(RN,   -0x1.9a3c385add912p+5,   -0x1.9b2d2567accd4p+0,  -0x1.f67da4p-2, INEXACT)
T(RN,   -0x1.98926f1195a46p+5,   -0x1.0ac80bed8baa2p+0,  -0x1.fdf986p-2, INEXACT)
T(RN,   -0x1.96ea5fb591933p+5,    -0x1.5d7ecdaff0bbp-1,  -0x1.ff9428p-2, INEXACT)
T(RN,   -0x1.9544087c237d4p+5,   -0x1.a83333394f6eap-2,  -0x1.fdac9cp-2, INEXACT)
T(RN,   -0x1.939f679c7988fp+5,   -0x1.843ffc3f7803dp-3,  -0x1.f5ef1ap-2, INEXACT)
T(RN,   -0x1.91fc7b4f9c20fp+5,    0x1.19d6c2c6063e7p-6,   0x1.f6b35cp-2, INEXACT)
T(RN,   -0x1.905b41d06bcf5p+5,    0x1.cbf5625dd46e2p-3,   0x1.f6b594p-2, INEXACT)
T(RN,   -0x1.8ebbb95b9f52cp+5,    0x1.cdfd91538630fp-2,    0x1.fc4e4p-2, INEXACT)
T(RN,   -0x1.8d1de02fc1f59p+5,    0x1.7218d66dbd6a6p-1,   0x1.fc0642p-2, INEXACT)
T(RN,   -0x1.8b81b48d31645p+5,    0x1.1652604715f02p+0,  -0x1.f8ecc6p-2, INEXACT)
T(RN,   -0x1.89e734b61bcdap+5,    0x1.a7fba225b20b7p+0,   0x1.f5d26ep-2, INEXACT)
T(RN,   -0x1.884e5eee7aec5p+5,     0x1.65c553178af9p+1,   0x1.f5d09ep-2, INEXACT)
T(RN,   -0x1.86b7317c23e34p+5,    0x1.b701d0e836aebp+2,   -0x1.fde7fp-2, INEXACT)
T(RN,    -0x1.8521aaa69fd3p+5,   -0x1.2c334a0d2bb6ap+4,   0x1.f7b588p-2, INEXACT)
T(RN,   -0x1.838dc8b750b3ap+5,   -0x1.f4566571e6456p+1,   0x1.f67afep-2, INEXACT)
T(RN,   -0x1.81fb89f95bd07p+5,   -0x1.0b1d8c354e823p+1,  -0x1.ff8a18p-2, INEXACT)
T(RN,   -0x1.806aecb9abc0ap+5,   -0x1.56100edc558f6p+0,  -0x1.fb1862p-2, INEXACT)
T(RN,   -0x1.7edbef46eec3fp+5,   -0x1.cd6f6d5e149d9p-1,   0x1.feb198p-2, INEXACT)
T(RN,   -0x1.7d4e8ff194d49p+5,   -0x1.328a2988b6767p-1,   0x1.f6e8b4p-2, INEXACT)
T(RN,   -0x1.7bc2cd0bcddc9p+5,   -0x1.716af5c9f7874p-2,    0x1.fdb85p-2, INEXACT)
T(RN,   -0x1.7a38a4e987d22p+5,   -0x1.3d6c7293184dbp-3,   0x1.f991d2p-2, INEXACT)
T(RN,   -0x1.78b015e06d15dp+5,    0x1.36b65a72e751fp-5,   0x1.fdc988p-2, INEXACT)
T(RN,   -0x1.77291e47e2622p+5,    0x1.dcf605a9aa209p-3,   0x1.f96894p-2, INEXACT)
T(RN,   -0x1.75a3bc79053bep+5,    0x1.c7fd553e72d6fp-2,  -0x1.fe529cp-2, INEXACT)
T(RN,   -0x1.741feeceaa0f7p+5,    0x1.648cf33ff01f3p-1,   -0x1.f9dbap-2, INEXACT)
T(RN,   -0x1.729db3a55a6cbp+5,    0x1.05f36f30a5dc5p+0,  -0x1.f670d2p-2, INEXACT)
T(RN,   -0x1.711d095b53356p+5,    0x1.8199b6eafb15dp+0,   -0x1.fc967p-2, INEXACT)
T(RN,   -0x1.6f9dee5082f79p+5,    0x1.2f9397e6f5c04p+1,   0x1.f62ff4p-2, INEXACT)
T(RN,   -0x1.6e2060e688023p+5,    0x1.2851867866c8dp+2,   0x1.f7cfeep-2, INEXACT)
T(RN,   -0x1.6ca45f80aed06p+5,    0x1.266792a8a95f5p+5,  -0x1.f81888p-2, INEXACT)
T(RN,   -0x1.6b29e883f026cp+5,   -0x1.92a50067d773fp+2,   0x1.fc22cap-2, INEXACT)
T(RN,   -0x1.69b0fa56ef6cbp+5,   -0x1.67ed9bdc31b2ap+1,   0x1.f9ff6ap-2, INEXACT)
T(RN,   -0x1.68399361f8e92p+5,   -0x1.b9fe60df0e5aap+0,  -0x1.fc5024p-2, INEXACT)
T(RN,   -0x1.66c3b20f000e6p+5,   -0x1.2b531ed25f208p+0,  -0x1.fc53d4p-2, INEXACT)
T(RN,   -0x1.654f54c99db5bp+5,   -0x1.9f41224d05095p-1,   0x1.fa7beep-2, INEXACT)
T(RN,   -0x1.63dc79ff0e831p+5,   -0x1.17f1ccd6a4c66p-1,   0x1.f7021cp-2, INEXACT)
T(RN,   -0x1.626b201e31167p+5,   -0x1.535ab67aac202p-2,    0x1.f62a2p-2, INEXACT)
T(RN,   -0x1.60fb459784694p+5,   -0x1.216e7019097f1p-3,  -0x1.fd39c4p-2, INEXACT)
T(RN,   -0x1.5f8ce8dd261edp+5,    0x1.3b7edfc48b5f4p-5,   0x1.fcbdfep-2, INEXACT)
T(RN,   -0x1.5e200862d0c89p+5,    0x1.c2c98b1b24e21p-3,   0x1.fdb854p-2, INEXACT)
T(RN,     -0x1.5cb4a29dda5p+5,    0x1.a9d4fb518b5b2p-2,   0x1.f5f286p-2, INEXACT)
T(RN,   -0x1.5b4ab60532344p+5,    0x1.48c4385be4f02p-1,   0x1.f7d74ep-2, INEXACT)
T(RN,   -0x1.59e241115fee6p+5,    0x1.d9f252a2b043dp-1,  -0x1.fd479cp-2, INEXACT)
T(RN,   -0x1.587b423c81494p+5,    0x1.51ac43ccb9687p+0,  -0x1.f5d3ccp-2, INEXACT)
T(RN,   -0x1.5715b80248b44p+5,    0x1.f2e3b34adc414p+0,  -0x1.fff0eep-2, INEXACT)
T(RN,    -0x1.55b1a0dffbacp+5,    0x1.9d73204a8a417p+1,  -0x1.fa92b2p-2, INEXACT)
T(RN,   -0x1.544efb5471091p+5,    0x1.f4f7b5de56961p+2,    0x1.fd9b8p-2, INEXACT)
T(RN,   -0x1.52edc5e00f6cep+5,   -0x1.602cc726fbb68p+4,  -0x1.ffb9acp-2, INEXACT)
T(RN,   -0x1.518dff04cb995p+5,   -0x1.220e8fcebf4dcp+2,   0x1.f84526p-2, INEXACT)
T(RN,   -0x1.502fa54626cd8p+5,   -0x1.38f661ab7e3ecp+1,   0x1.f818fcp-2, INEXACT)
T(RN,   -0x1.4ed2b7292d5b3p+5,   -0x1.99968b8d0ecdbp+0,   0x1.f6b9aap-2, INEXACT)
T(RN,    -0x1.4d77333474a3p+5,   -0x1.1f0aaba697176p+0,  -0x1.f78f28p-2, INEXACT)
T(RN,   -0x1.4c1d17f01a09fp+5,   -0x1.988f658177754p-1,  -0x1.fbd7ccp-2, INEXACT)
T(RN,   -0x1.4ac463e5c0d99p+5,   -0x1.1b2a9f7652827p-1,   0x1.fa0e84p-2, INEXACT)
T(RN,   -0x1.496d15a091023p+5,   -0x1.676ac7043723bp-2,  -0x1.fe89ecp-2, INEXACT)
T(RN,   -0x1.48172bad3570cp+5,   -0x1.60d67f162c07bp-3,   0x1.fd1f98p-2, INEXACT)
T(RN,   -0x1.46c2a499da787p+5,   -0x1.1c2ac13c014c6p-8,  -0x1.f8cd72p-2, INEXACT)
T(RN,   -0x1.456f7ef62c429p+5,    0x1.4d28f021a609bp-3,   0x1.fd5c66p-2, INEXACT)
T(RN,   -0x1.441db95355392p+5,    0x1.5a64977ae9031p-2,   0x1.f66492p-2, INEXACT)
T(RN,   -0x1.42cd5243fcb06p+5,    0x1.11640555d4275p-1,  -0x1.fde4ccp-2, INEXACT)
T(RN,   -0x1.417e485c44e8dp+5,    0x1.8880467881394p-1,  -0x1.fb1b22p-2, INEXACT)
T(RN,   -0x1.40309a31ca00cp+5,    0x1.10b2f6f70b863p+0,  -0x1.fe933ap-2, INEXACT)
T(RN,   -0x1.3ee4465ba01f2p+5,    0x1.7d0f8dcd0eecbp+0,   0x1.fe5568p-2, INEXACT)
T(RN,   -0x1.3d994b72520f9p+5,    0x1.1723c3a2876c1p+1,   0x1.ff01eap-2, INEXACT)
T(RN,   -0x1.3c4fa80fdfb2ap+5,    0x1.d053df683d5fep+1,  -0x1.f96014p-2, INEXACT)
T(RN,   -0x1.3b075acfbc73bp+5,    0x1.254628369843fp+3,  -0x1.fb2f1cp-2, INEXACT)
T(RN,   -0x1.39c0624ecdd4ap+5,   -0x1.39a259199155fp+4,   0x1.f8b116p-2, INEXACT)
T(RN,   -0x1.387abd2b69e95p+5,   -0x1.2c4d6febf4ddap+2,  -0x1.ffbbe8p-2, INEXACT)
T(RN,   -0x1.37366a0555caap+5,   -0x1.4ba579f2a217fp+1,     0x1.f60dp-2, INEXACT)
T(RN,   -0x1.35f3677dc445dp+5,    -0x1.b8e5a1aaa4a7p+0,  -0x1.fa3146p-2, INEXACT)
T(RN,   -0x1.34b1b43754192p+5,   -0x1.3a8c56ee05ec2p+0,   0x1.fc9dbep-2, INEXACT)
T(RN,   -0x1.33714ed60ec04p+5,   -0x1.cb5192a1daaf8p-1,  -0x1.fe69b2p-2, INEXACT)
T(RN,   -0x1.323235ff66d13p+5,   -0x1.4c180e4b8bc9ep-1,  -0x1.fd10aap-2, INEXACT)
T(RN,   -0x1.30f4685a3691dp+5,   -0x1.c991f3bc4bad2p-2,  -0x1.fd76a8p-2, INEXACT)
T(RN,   -0x1.2fb7e48ebe8c8p+5,   -0x1.16a49b842f659p-2,   0x1.fa0b2cp-2, INEXACT)
T(RN,   -0x1.2e7ca946a406ep+5,   -0x1.cbacfb6af2a17p-4,  -0x1.f68e6cp-2, INEXACT)
T(RN,   -0x1.2d42b52cefab5p+5,    0x1.547d3d5067ce9p-5,   0x1.ff1e44p-2, INEXACT)
T(RN,   -0x1.2c0a06ee0bf5fp+5,    0x1.92d4e8a50b704p-3,   -0x1.f990bp-2, INEXACT)
T(RN,   -0x1.2ad29d37c3e19p+5,    0x1.71784f3245a84p-2,   0x1.fec078p-2, INEXACT)
T(RN,   -0x1.299c76b941732p+5,    0x1.16304f13d78a9p-1,  -0x1.fbbc18p-2, INEXACT)
T(RN,   -0x1.286792230c476p+5,    0x1.840beadd13d3fp-1,  -0x1.fffb92p-2, INEXACT)
T(RN,   -0x1.2733ee270824bp+5,    0x1.06ee8cb745d22p+0,   0x1.f78d44p-2, INEXACT)
T(RN,   -0x1.2601897873a28p+5,    0x1.64bfbcf8c7033p+0,   0x1.f8079ap-2, INEXACT)
T(RN,   -0x1.24d062cbe6ad2p+5,    0x1.f3b6359ee4dc7p+0,   0x1.fcc238p-2, INEXACT)
T(RN,   -0x1.23a078d7512e9p+5,    0x1.7bd4a7422bcc7p+1,  -0x1.fa5a3ep-2, INEXACT)
T(RN,   -0x1.2271ca51f9aabp+5,     0x1.654a622131afp+2,  -0x1.ffe4cap-2, INEXACT)
T(RN,     -0x1.214455f47bcp+5,    0x1.0a210914a8a8bp+5,   0x1.f6c47ep-2, INEXACT)
T(RN,   -0x1.20181a78c6f41p+5,   -0x1.1153239417eb1p+3,   -0x1.f73fcp-2, INEXACT)
T(RN,   -0x1.1eed169a1d23bp+5,   -0x1.dc45d0244adc4p+1,    0x1.f754bp-2, INEXACT)
T(RN,   -0x1.1dc34915114a9p+5,   -0x1.282715a1e0ea1p+1,  -0x1.fb094cp-2, INEXACT)
T(RN,   -0x1.1c9ab0a785fa8p+5,   -0x1.9ef34b452f87ep+0,  -0x1.f71258p-2, INEXACT)
T(RN,   -0x1.1b734c10ac4b3p+5,   -0x1.31c7a24989aafp+0,  -0x1.f9685ap-2, INEXACT)
T(RN,   -0x1.1a4d1a11020edp+5,   -0x1.ca50e4216a7efp-1,   0x1.face22p-2, INEXACT)
T(RN,   -0x1.1928196a50d93p+5,   -0x1.54a31652e1a41p-1,  -0x1.fdfc84p-2, INEXACT)
T(RN,   -0x1.180448dfac828p+5,   -0x1.e7cfea2105a02p-2,  -0x1.feb068p-2, INEXACT)
T(RN,   -0x1.16e1a73571c85p+5,   -0x1.3fc02b06d4edcp-2,   -0x1.fc08ep-2, INEXACT)
T(RN,   -0x1.15c0333145118p+5,   -0x1.4d4c195650ccap-3,    0x1.fe04ep-2, INEXACT)
T(RN,   -0x1.149feb9a10eebp+5,   -0x1.51040361ddf5cp-6,   0x1.f64676p-2, INEXACT)
T(RN,   -0x1.1380cf38051bep+5,    0x1.ec54916e2669bp-4,  -0x1.fec92cp-2, INEXACT)
T(RN,   -0x1.1262dcd494b2bp+5,    0x1.0f9478071c58dp-2,  -0x1.f75fcep-2, INEXACT)
T(RN,   -0x1.1146133a7545ep+5,    0x1.aee4a62009bbep-2,   0x1.f936f2p-2, INEXACT)
T(RN,   -0x1.102a71359d754p+5,    0x1.30ae952a794aap-1,   0x1.f8357ap-2, INEXACT)
T(RN,   -0x1.0f0ff593437b7p+5,    0x1.999682e3550c4p-1,   0x1.fa9a52p-2, INEXACT)
T(RN,   -0x1.0df69f21dc05ap+5,    0x1.0e0c8c38d967dp+0,   0x1.f73bb8p-2, INEXACT)
T(RN,   -0x1.0cde6cb118f6dp+5,    0x1.652a43be10b68p+0,   0x1.fe5fbep-2, INEXACT)
T(RN,   -0x1.0bc75d11e7ea2p+5,    0x1.e50d507afde0cp+0,  -0x1.ff7b1cp-2, INEXACT)
T(RN,   -0x1.0ab16f167120ep+5,    0x1.5ec0157ad6e78p+1,   0x1.f6ab3ap-2, INEXACT)
T(RN,   -0x1.099ca1921618ap+5,    0x1.256a54604082ep+2,    0x1.fa2b6p-2, INEXACT)
T(RN,   -0x1.0888f359705a7p+5,    0x1.8e688c16c2219p+3,   0x1.f69124p-2, INEXACT)
T(RN,   -0x1.07766342502a2p+5,   -0x1.2877e6b12aa29p+4,  -0x1.f6f85cp-2, INEXACT)
T(RN,   -0x1.0664f023bb50ap+5,   -0x1.5170c79637cebp+2,   0x1.fa5998p-2, INEXACT)
T(RN,   -0x1.055498d5ebb59p+5,   -0x1.81b727b6eae46p+1,   0x1.f6089cp-2, INEXACT)
T(RN,   -0x1.04455c324e8a3p+5,   -0x1.070f3d4e4dd62p+1,   0x1.feee88p-2, INEXACT)
T(RN,   -0x1.033739138255dp+5,    -0x1.82b657cc27ffp+0,   0x1.fc6c8cp-2, INEXACT)
T(RN,   -0x1.022a2e5556684p+5,   -0x1.262c1df7d016cp+0,  -0x1.fd7c06p-2, INEXACT)
T(RN,   -0x1.011e3ad4c9094p+5,   -0x1.c48b2cbd6d23ap-1,    0x1.f6649p-2, INEXACT)
T(RN,   -0x1.00135d70074c6p+5,   -0x1.596f828554264p-1,    0x1.fdda9p-2, INEXACT)
T(RN,   -0x1.fe132a0cd4052p+4,   -0x1.001124b10a2dfp-1,  -0x1.f7dc34p-2, INEXACT)
T(RN,   -0x1.fc01c0f0ec9b7p+4,   -0x1.63e7672f35177p-2,   0x1.ffba86p-2, INEXACT)
T(RN,   -0x1.f9f27d4fb6ecdp+4,    -0x1.ab7a58fdeed2p-3,  -0x1.f97f72p-2, INEXACT)
T(RN,   -0x1.f7e55ceee3f07p+4,   -0x1.3e5de29b336e3p-4,  -0x1.f90e1ap-2, INEXACT)
T(RN,   -0x1.f5da5d967495ep+4,    0x1.9ae2103773a8dp-5,   0x1.fccc0ep-2, INEXACT)
T(RN,   -0x1.f3d17d10b7468p+4,    0x1.6eece524e23c9p-3,    0x1.faa3ap-2, INEXACT)
T(RN,   -0x1.f1cab92a458cbp+4,    0x1.412dd9441cd5ap-2,  -0x1.faa7a6p-2, INEXACT)
T(RN,   -0x1.efc60fb201bc2p+4,     0x1.d5b781cb10f6p-2,   0x1.fb04e6p-2, INEXACT)
T(RN,   -0x1.edc37e7914894p+4,    0x1.3df037cd7c1c8p-1,   0x1.fc9e1cp-2, INEXACT)
T(RN,   -0x1.ebc30352eaa9bp+4,    0x1.9eb9dd4f62d08p-1,   0x1.f9f1bep-2, INEXACT)
T(RN,   -0x1.e9c49c1532922p+4,     0x1.0a771eb97bf4p+0,  -0x1.f9847ap-2, INEXACT)
T(RN,   -0x1.e7c84697d9f5fp+4,     0x1.56ed942a5a3cp+0,  -0x1.fe817ap-2, INEXACT)
T(RN,   -0x1.e5ce00b50b901p+4,    0x1.c18bc6a5fbd75p+0,   0x1.fb4978p-2, INEXACT)
T(RN,   -0x1.e3d5c8492ccd2p+4,    0x1.3365d06043108p+1,   0x1.f6acdcp-2, INEXACT)
T(RN,   -0x1.e1df9b32db6b4p+4,    0x1.cafe804c5b252p+1,   0x1.f9ecb4p-2, INEXACT)
T(RN,   -0x1.dfeb7752eb4a3p+4,    0x1.a7df8481a13d3p+2,   0x1.fc8c5ap-2, INEXACT)
T(RN,   -0x1.ddf95a8c63f4fp+4,    0x1.1b23943d09cc8p+5,  -0x1.f771c6p-2, INEXACT)
T(RN,    -0x1.dc0942c47e7dp+4,   -0x1.5794473bdaa5fp+3,   0x1.f5c658p-2, INEXACT)
T(RN,   -0x1.da1b2de2a3448p+4,   -0x1.273471ef541c1p+2,  -0x1.fd9bbap-2, INEXACT)
T(RN,   -0x1.d82f19d067572p+4,   -0x1.7150d3981bb51p+1,   0x1.f627a2p-2, INEXACT)
T(RN,   -0x1.d64504798ab48p+4,   -0x1.06c69e7728e8ep+1,   -0x1.fe8d6p-2, INEXACT)
T(RN,   -0x1.d45cebcbf59ecp+4,   -0x1.8d413c6c78777p+0,    0x1.f7699p-2, INEXACT)
T(RN,   -0x1.d276cdb7b6906p+4,   -0x1.357770df2f783p+0,   0x1.f5c75cp-2, INEXACT)
T(RN,   -0x1.d092a82f00033p+4,   -0x1.e811142d8cae3p-1,     0x1.f9c7p-2, INEXACT)
T(RN,   -0x1.ceb079262622fp+4,   -0x1.803310b6c96bfp-1,   0x1.fc3a7cp-2, INEXACT)
T(RN,   -0x1.ccd03e939ca5fp+4,   -0x1.29979158231dbp-1,   0x1.f6f83cp-2, INEXACT)
T(RN,   -0x1.caf1f66ff496dp+4,   -0x1.bcbea2f208abep-2,   0x1.fa362cp-2, INEXACT)
T(RN,   -0x1.c9159eb5da198p+4,   -0x1.356b7aee63c93p-2,   0x1.f6ba54p-2, INEXACT)
T(RN,   -0x1.c73b356212406p+4,   -0x1.6fa496cb5c8d6p-3,   0x1.f709ecp-2, INEXACT)
T(RN,   -0x1.c562b87378e71p+4,   -0x1.fec215ff09798p-5,   0x1.f782c8p-2, INEXACT)
T(RN,    -0x1.c38c25eafe88p+4,    0x1.af71f73079d79p-5,   0x1.f983a2p-2, INEXACT)
T(RN,   -0x1.c1b77bcba5f8dp+4,    0x1.594fc448752cep-3,   0x1.fa107cp-2, INEXACT)
T(RN,   -0x1.bfe4b81a8264ep+4,    0x1.278ee899fbbf3p-2,   -0x1.fe1f3p-2, INEXACT)
T(RN,   -0x1.be13d8deb517cp+4,    0x1.aa4d8a8b542bep-2,  -0x1.f788dcp-2, INEXACT)
T(RN,   -0x1.bc44dc216b654p+4,    0x1.1cba807e30ec3p-1,   0x1.fcb54cp-2, INEXACT)
T(RN,   -0x1.ba77bfeddc784p+4,    0x1.6d98e56d53db3p-1,  -0x1.f8d028p-2, INEXACT)
T(RN,   -0x1.b8ac825147573p+4,    0x1.cc3f14a62858ap-1,   0x1.fd4b16p-2, INEXACT)
T(RN,   -0x1.b6e3215af08d9p+4,    0x1.1fd7a671b4983p+0,   0x1.f8a768p-2, INEXACT)
T(RN,   -0x1.b51b9b1c2052bp+4,    0x1.69de2d4ce633ep+0,  -0x1.f730d6p-2, INEXACT)
T(RN,   -0x1.b355eda820461p+4,    0x1.cf26a31b25a4ep+0,     0x1.f761p-2, INEXACT)
T(RN,    -0x1.b1921714398ep+4,    0x1.335720ea9febcp+1,   0x1.f5dd98p-2, INEXACT)
T(RN,   -0x1.afd01577b26bfp+4,    0x1.b54753e13e971p+1,  -0x1.f9783cp-2, INEXACT)
T(RN,   -0x1.ae0fe6ebcc857p+4,    0x1.693f2eea896a8p+2,  -0x1.fbdf48p-2, INEXACT)
T(RN,   -0x1.ac51898bc2abcp+4,    0x1.e171d16cd2a75p+3,     0x1.f7f3p-2, INEXACT)
T(RN,   -0x1.aa94fb74c6c9fp+4,   -0x1.7b3cc0675f594p+4,   -0x1.f72c5p-2, INEXACT)
T(RN,   -0x1.a8da3ac5fffdbp+4,   -0x1.a6b8a6f15af77p+2,  -0x1.f9570ap-2, INEXACT)
T(RN,   -0x1.a72145a088655p+4,   -0x1.e53c2987b156ep+1,   0x1.fcc4f2p-2, INEXACT)
T(RN,   -0x1.a56a1a276b2f9p+4,   -0x1.4ed6547540057p+1,   0x1.febe9cp-2, INEXACT)
T(RN,   -0x1.a3b4b67fa2958p+4,    -0x1.f595eea7cd14p+0,   0x1.f88d16p-2, INEXACT)
T(RN,   -0x1.a20118d015d6dp+4,   -0x1.8837cccd67ad1p+0,   -0x1.f8726p-2, INEXACT)
T(RN,   -0x1.a04f3f419741bp+4,   -0x1.39df9efad9ef9p+0,   0x1.fc68aep-2, INEXACT)
T(RN,   -0x1.9e9f27fee2283p+4,   -0x1.fba20c1e2c414p-1,  -0x1.fc0102p-2, INEXACT)
T(RN,   -0x1.9cf0d13498ec9p+4,   -0x1.9ab3b9e165f91p-1,    0x1.fd85dp-2, INEXACT)
T(RN,   -0x1.9b44391142ff4p+4,   -0x1.4932e313cf553p-1,  -0x1.fa3098p-2, INEXACT)
T(RN,   -0x1.99995dc54aeaep+4,   -0x1.024757f522c38p-1,  -0x1.f6458cp-2, INEXACT)
T(RN,   -0x1.97f03d82fca25p+4,   -0x1.856dfab6d88adp-2,    0x1.fe62fp-2, INEXACT)
T(RN,   -0x1.9648d67e82db1p+4,   -0x1.1073964a2dac4p-2,  -0x1.f77f7cp-2, INEXACT)
T(RN,   -0x1.94a326ede5e2fp+4,   -0x1.446512cd71546p-3,  -0x1.fcb6a4p-2, INEXACT)
T(RN,   -0x1.92ff2d09093e2p+4,   -0x1.bf61316ab573fp-5,  -0x1.f82058p-2, INEXACT)
T(RN,   -0x1.915ce709a9da1p+4,    0x1.85e7ba806d5f1p-5,   0x1.f8eaaap-2, INEXACT)
T(RN,   -0x1.8fbc532b5c31cp+4,    0x1.33fb740c8f6bfp-3,  -0x1.fa3d4ep-2, INEXACT)
T(RN,   -0x1.8e1d6fab8a2e5p+4,    0x1.061340eec3427p-2,   0x1.f9e1a8p-2, INEXACT)
T(RN,   -0x1.8c803ac97186cp+4,    0x1.77749a69ff3a9p-2,   0x1.fa3458p-2, INEXACT)
T(RN,    -0x1.8ae4b2c6219dp+4,    0x1.f10f02593f9cbp-2,   0x1.fa2934p-2, INEXACT)
T(RN,   -0x1.894ad5e479c92p+4,    0x1.3b4cc80831f69p-1,   -0x1.f7354p-2, INEXACT)
T(RN,   -0x1.87b2a2692756dp+4,    0x1.868ae72ecf1b4p-1,    0x1.ff81bp-2, INEXACT)
T(RN,   -0x1.861c169aa3b56p+4,     0x1.ddd2c01adec6p-1,  -0x1.fc4abep-2, INEXACT)
T(RN,   -0x1.848730c13299ap+4,    0x1.234206a513db8p+0,  -0x1.f913e8p-2, INEXACT)
T(RN,   -0x1.82f3ef26e01cdp+4,    0x1.649e20455d16bp+0,  -0x1.f8085cp-2, INEXACT)
T(RN,   -0x1.816250177ef01p+4,    0x1.ba6cd641d20e2p+0,   0x1.fb425ap-2, INEXACT)
T(RN,   -0x1.7fd251e0a668ap+4,    0x1.1964f6d77ad8cp+1,    0x1.fcac8p-2, INEXACT)
T(RN,   -0x1.7e43f2d1b0cb6p+4,    0x1.76213aa95d8c9p+1,  -0x1.ff87dap-2, INEXACT)
T(RN,   -0x1.7cb7313bb9634p+4,    0x1.0df436e05e25ep+2,  -0x1.f9ea02p-2, INEXACT)
T(RN,   -0x1.7b2c0b719ab52p+4,    0x1.d29cd9b211922p+2,   0x1.f6b81ap-2, INEXACT)
T(RN,   -0x1.79a27fc7ecb1fp+4,    0x1.8d855aa7aca45p+4,  -0x1.fbb228p-2, INEXACT)
T(RN,   -0x1.781a8c9502d5ep+4,   -0x1.202f0f5c8d362p+4,   0x1.f707ecp-2, INEXACT)
T(RN,   -0x1.76943030eaaafp+4,   -0x1.a546fcd3cec51p+2,  -0x1.ff87dep-2, INEXACT)
T(RN,   -0x1.750f68f56966ep+4,   -0x1.fe78ea5a3ce8cp+1,   0x1.f9fe0ap-2, INEXACT)
T(RN,   -0x1.738c353dfaac2p+4,   -0x1.699aae4bfe6ecp+1,  -0x1.f8f7bep-2, INEXACT)
T(RN,   -0x1.720a9367ce9a8p+4,   -0x1.13ea0cfd8880cp+1,  -0x1.f617a4p-2, INEXACT)
T(RN,    -0x1.708a81d1c7e4p+4,   -0x1.b6cd2b9741867p+0,   -0x1.f8896p-2, INEXACT)
T(RN,   -0x1.6f0bfedc7a404p+4,   -0x1.6571170793f8ep+0,  -0x1.f6904ap-2, INEXACT)
T(RN,   -0x1.6d8f08ea28876p+4,   -0x1.27203f377b889p+0,  -0x1.fb119ap-2, INEXACT)
T(RN,   -0x1.6c139e5ec3026p+4,   -0x1.ea311c486334ap-1,  -0x1.ff712cp-2, INEXACT)
T(RN,   -0x1.6a99bd9fe4b74p+4,   -0x1.96ca4f1207d1dp-1,   0x1.f5c3c2p-2, INEXACT)
T(RN,   -0x1.69216514d649cp+4,   -0x1.4f157033f7493p-1,  -0x1.f7c224p-2, INEXACT)
T(RN,   -0x1.67aa9326832cap+4,   -0x1.0fc7280da00e3p-1,  -0x1.f6cf4ep-2, INEXACT)
T(RN,    -0x1.6635463f80ddp+4,   -0x1.ad270ffc0e32cp-2,  -0x1.f71b58p-2, INEXACT)
T(RN,   -0x1.64c17ccc08c54p+4,   -0x1.439b108125d61p-2,  -0x1.f64012p-2, INEXACT)
T(RN,    -0x1.634f3539f767p+4,   -0x1.c0b62f05cd349p-3,  -0x1.f8297ep-2, INEXACT)
T(RN,   -0x1.61de6df8caa0ep+4,    -0x1.02b49e062adfp-3,   0x1.fcf692p-2, INEXACT)
T(RN,   -0x1.606f2579a00abp+4,   -0x1.26ee545544757p-5,   0x1.fa0842p-2, INEXACT)
T(RN,   -0x1.5f015a2f33329p+4,    0x1.b532ed9e2359cp-5,  -0x1.f9bf0ap-2, INEXACT)
T(RN,   -0x1.5d950a8ddbfa4p+4,    0x1.25554cd268bf5p-3,  -0x1.fcd3dap-2, INEXACT)
T(RN,   -0x1.5c2a350b8d058p+4,    0x1.e159735decf57p-3,  -0x1.f80ebcp-2, INEXACT)
T(RN,   -0x1.5ac0d81fd1c8bp+4,    0x1.524885d37f1fdp-2,  -0x1.fe6f62p-2, INEXACT)
T(RN,   -0x1.5958f243cd309p+4,     0x1.b9556848d86dp-2,   0x1.f77efep-2, INEXACT)
T(RN,   -0x1.57f281f237c75p+4,    0x1.14060098de05ap-1,  -0x1.f81ea2p-2, INEXACT)
T(RN,   -0x1.568d85a75e2fep+4,    0x1.509dc74e4c4b9p-1,    0x1.f7db1p-2, INEXACT)
T(RN,   -0x1.5529fbe11f5b8p+4,    0x1.944d205a90e59p-1,  -0x1.f76778p-2, INEXACT)
T(RN,   -0x1.53c7e31eeb17bp+4,    0x1.e1a284b762b0dp-1,   0x1.f8ee1ap-2, INEXACT)
T(RN,   -0x1.526739e1c041ep+4,    0x1.1e25854ce2538p+0,   0x1.fcae98p-2, INEXACT)
T(RN,   -0x1.5107feac2b478p+4,    0x1.54e8775c27539p+0,   0x1.ff73ccp-2, INEXACT)
T(RN,   -0x1.4faa300244856p+4,    0x1.9982b5ad2a2cfp+0,   0x1.fada76p-2, INEXACT)
T(RN,   -0x1.4e4dcc69ae9c6p+4,     0x1.f37543548d3dp+0,   0x1.f6a088p-2, INEXACT)
T(RN,   -0x1.4cf2d26994e05p+4,    0x1.3857f171d0918p+1,   0x1.f899b4p-2, INEXACT)
T(RN,   -0x1.4b99408aa9d09p+4,     0x1.9732e3e2e7a3p+1,  -0x1.f7baf2p-2, INEXACT)
T(RN,   -0x1.4a4115572565fp+4,    0x1.1d7af4a5664acp+2,  -0x1.f657e4p-2, INEXACT)
T(RN,   -0x1.48ea4f5ac38f3p+4,    0x1.d0bbf2e2afc8bp+2,   0x1.fd7994p-2, INEXACT)
T(RN,   -0x1.4794ed22c2a97p+4,    0x1.2abe125ce2542p+4,   0x1.ffb03ap-2, INEXACT)
T(RN,   -0x1.4640ed3de1d1cp+4,   -0x1.0f193dfae276bp+5,  -0x1.fa4646p-2, INEXACT)
T(RN,   -0x1.44ee4e3c5f668p+4,   -0x1.1c140807ce9f7p+3,  -0x1.f73ef8p-2, INEXACT)
T(RN,   -0x1.439d0eaff7808p+4,   -0x1.44e001730f98cp+2,  -0x1.fe0bcep-2, INEXACT)
T(RN,   -0x1.424d2d2be2556p+4,   -0x1.c30dc68b05c2fp+1,  -0x1.fd48fcp-2, INEXACT)
T(RN,   -0x1.40fea844d2c75p+4,   -0x1.55f28eae47223p+1,   0x1.fa6b2cp-2, INEXACT)
T(RN,   -0x1.3fb17e90f4b48p+4,   -0x1.103a95f694128p+1,  -0x1.f83252p-2, INEXACT)
T(RN,   -0x1.3e65aea7eb977p+4,   -0x1.be911c9d360b2p+0,  -0x1.fea462p-2, INEXACT)
T(RN,   -0x1.3d1b3722d0e42p+4,   -0x1.7539db4e16085p+0,  -0x1.fd117ap-2, INEXACT)
T(RN,   -0x1.3bd2169c32a1bp+4,   -0x1.3b904e2aedddbp+0,  -0x1.fe6602p-2, INEXACT)
T(RN,   -0x1.3a8a4bb011b59p+4,   -0x1.0c7d7e7f569f9p+0,   0x1.f72946p-2, INEXACT)
T(RN,   -0x1.3943d4fbe0c4bp+4,   -0x1.c9bdbff6ee81dp-1,   0x1.fff278p-2, INEXACT)
T(RN,    -0x1.37feb11e8216p+4,    -0x1.85534e63ec74p-1,  -0x1.f928aep-2, INEXACT)
T(RN,   -0x1.36badeb846b9bp+4,   -0x1.48f268cafdb83p-1,  -0x1.fba4b8p-2, INEXACT)
T(RN,   -0x1.35785c6aeca22p+4,   -0x1.12a0dee5ce13fp-1,  -0x1.fd0334p-2, INEXACT)
T(RN,   -0x1.343728d99d534p+4,   -0x1.c1d4e40e94b45p-2,   -0x1.fc7d9p-2, INEXACT)
T(RN,   -0x1.32f742a8ec641p+4,   -0x1.65681c77f20efp-2,    0x1.fd141p-2, INEXACT)
T(RN,   -0x1.31b8a87ed5fd2p+4,   -0x1.0e3e543c5124bp-2,   0x1.f5e436p-2, INEXACT)
T(RN,   -0x1.307b5902bd6fcp+4,   -0x1.75dada7752958p-3,   0x1.fe6086p-2, INEXACT)
T(RN,   -0x1.2f3f52dd6bb14p+4,   -0x1.a90f05ae63d13p-4,  -0x1.f667b4p-2, INEXACT)
T(RN,    -0x1.2e0494b90df8p+4,   -0x1.b34d4d3125e2cp-6,  -0x1.fc5f6ep-2, INEXACT)
T(RN,   -0x1.2ccb1d413444dp+4,    0x1.99acb04c61659p-5,  -0x1.fc1578p-2, INEXACT)
T(RN,   -0x1.2b92eb22cfe19p+4,    0x1.03cfcf26a3a95p-3,   0x1.fc4808p-2, INEXACT)
T(RN,   -0x1.2a5bfd0c32116p+4,    0x1.a39ff934bdc92p-3,   0x1.ffc13ep-2, INEXACT)
T(RN,   -0x1.292651ad0a895p+4,    0x1.23e87ace9c413p-2,   -0x1.f6dd3p-2, INEXACT)
T(RN,    -0x1.27f1e7b66616p+4,    0x1.79455a4bc531dp-2,    0x1.f6a84p-2, INEXACT)
T(RN,   -0x1.26bebddaad278p+4,     0x1.d323031d88d2p-2,   0x1.fdc29cp-2, INEXACT)
T(RN,   -0x1.258cd2cda262fp+4,    0x1.197ceb4313225p-1,  -0x1.f6c8b4p-2, INEXACT)
T(RN,   -0x1.245c254461472p+4,    0x1.4d4c6e188c1dfp-1,  -0x1.fd7262p-2, INEXACT)
T(RN,   -0x1.232cb3f55cc4cp+4,    0x1.8625ed8d6b7d8p-1,    0x1.ff231p-2, INEXACT)
T(RN,   -0x1.21fe7d985de04p+4,    0x1.c589f9c037c88p-1,  -0x1.f87e94p-2, INEXACT)
T(RN,   -0x1.20d180e68232ap+4,    0x1.06bfbf6412b6dp+0,   -0x1.febc4p-2, INEXACT)
T(RN,   -0x1.1fa5bc9a3aa98p+4,    0x1.306cfb1024439p+0,    0x1.f6b63p-2, INEXACT)
T(RN,   -0x1.1e7b2f6f4a10fp+4,    0x1.61d7ad38024e1p+0,   0x1.f5f0fcp-2, INEXACT)
T(RN,   -0x1.1d51d822c3c8fp+4,    0x1.9e147ee1e4d9ep+0,   0x1.f73452p-2, INEXACT)
T(RN,   -0x1.1c29b5730a4f5p+4,    0x1.ea06af140172cp+0,   0x1.f94a76p-2, INEXACT)
T(RN,   -0x1.1b02c61fcdf97p+4,    0x1.26f8eae9701aap+1,   0x1.f97582p-2, INEXACT)
T(RN,   -0x1.19dd08ea0b873p+4,    0x1.6c82be7281afbp+1,  -0x1.f8cdf2p-2, INEXACT)
T(RN,   -0x1.18b87c940ad58p+4,    0x1.d547972e9a065p+1,   0x1.fb7d9ep-2, INEXACT)
T(RN,   -0x1.17951fe15d911p+4,    0x1.43c8695dd4d4dp+2,   0x1.f8c26ep-2, INEXACT)
T(RN,   -0x1.1672f196ddc6fp+4,    0x1.001bc938ca7fcp+3,   0x1.fdae38p-2, INEXACT)
T(RN,   -0x1.1551f07aac9b2p+4,    0x1.296a27caf8634p+4,   0x1.f825f4p-2, INEXACT)
T(RN,   -0x1.14321b543101cp+4,   -0x1.e406e5fe50ceap+5,   0x1.f823d6p-2, INEXACT)
T(RN,   -0x1.131370ec16572p+4,   -0x1.70f65c5b9c2ebp+3,   -0x1.faaebp-2, INEXACT)
T(RN,   -0x1.11f5f00c4b121p+4,   -0x1.9659bcff91f36p+2,  -0x1.f873f4p-2, INEXACT)
T(RN,   -0x1.10d9977fffafcp+4,   -0x1.16cfdac356edfp+2,  -0x1.fa665cp-2, INEXACT)
T(RN,   -0x1.0fbe6613a4d78p+4,   -0x1.a594029ae40ebp+1,  -0x1.f5c696p-2, INEXACT)
T(RN,   -0x1.0ea45a94eabd6p+4,   -0x1.50593c19fe601p+1,  -0x1.fd925ep-2, INEXACT)
T(RN,   -0x1.0d8b73d2bf4f4p+4,   -0x1.1579952c4b1bdp+1,    0x1.f9905p-2, INEXACT)
T(RN,   -0x1.0c73b09d4d2cep+4,   -0x1.d40824ed8f776p+0,  -0x1.f5c6a4p-2, INEXACT)
T(RN,   -0x1.0b5d0fc5fa527p+4,   -0x1.90aeb65a4742dp+0,  -0x1.fa657cp-2, INEXACT)
T(RN,   -0x1.0a47901f66cdbp+4,   -0x1.5a832f10cf08ap+0,   0x1.f8dd62p-2, INEXACT)
T(RN,    -0x1.0933307d6b76p+4,   -0x1.2d9fa08bf2a18p+0,  -0x1.fc983ap-2, INEXACT)
T(RN,   -0x1.081fefb518abbp+4,   -0x1.077ff151a191ep+0,    0x1.f634cp-2, INEXACT)
T(RN,   -0x1.070dcc9cb5172p+4,   -0x1.cce24b341837cp-1,   0x1.f60ccap-2, INEXACT)
T(RN,   -0x1.05fcc60bbc5ecp+4,   -0x1.9284789b26866p-1,   0x1.ffecbap-2, INEXACT)
T(RN,   -0x1.04ecdadaddebdp+4,   -0x1.5e2cc02eca949p-1,  -0x1.f9fc8ep-2, INEXACT)
T(RN,   -0x1.03de09e3fbaa3p+4,   -0x1.2e9236a282857p-1,   0x1.fc8648p-2, INEXACT)
T(RN,   -0x1.02d0520228cdbp+4,   -0x1.02b992e39c5b2p-1,   0x1.fc6e84p-2, INEXACT)
T(RN,   -0x1.01c3b211a88a1p+4,   -0x1.b3bc6ebe1416ap-2,  -0x1.f5ffb8p-2, INEXACT)
T(RN,   -0x1.00b828efece96p+4,   -0x1.66c567b7b1b54p-2,   0x1.fb812ep-2, INEXACT)
T(RN,   -0x1.ff5b6af72b035p+3,   -0x1.1d8c068b24eefp-2,   0x1.f5fd38p-2, INEXACT)
T(RN,   -0x1.fd48ad28dc718p+3,   -0x1.ae6f721c5f7f3p-3,  -0x1.fb576ap-2, INEXACT)
T(RN,   -0x1.fb381636dc442p+3,   -0x1.261c3071e0e4ap-3,    0x1.f6cbcp-2, INEXACT)
T(RN,   -0x1.f929a3e56c757p+3,   -0x1.41a94f1239113p-4,   0x1.f6b9a8p-2, INEXACT)
T(RN,   -0x1.f71d53fb20591p+3,   -0x1.d6cde21562d0fp-7,  -0x1.f8e622p-2, INEXACT)
T(RN,   -0x1.f5132440da373p+3,    0x1.94d290dc25e1cp-5,  -0x1.f68e5ep-2, INEXACT)
T(RN,   -0x1.f30b1281c961fp+3,    0x1.d041173e4cc1cp-4,   0x1.fda30cp-2, INEXACT)
T(RN,   -0x1.f1051c8b66bcdp+3,    0x1.6c67b69854779p-3,  -0x1.ff350ap-2, INEXACT)
T(RN,   -0x1.ef01402d7371ep+3,    0x1.f324230558e17p-3,  -0x1.f98388p-2, INEXACT)
T(RN,   -0x1.ecff7b39f6144p+3,    0x1.3ec134ee0db5ep-2,   0x1.f8a96ep-2, INEXACT)
T(RN,   -0x1.eaffcb85384bfp+3,    0x1.86663cecf59aap-2,   0x1.f703a4p-2, INEXACT)
T(RN,   -0x1.e9022ee5c48f2p+3,    0x1.d13b33f0c41f1p-2,   0x1.fe705ep-2, INEXACT)
T(RN,    -0x1.e706a33463c3p+3,    0x1.100b9bee6dbc3p-1,  -0x1.f9de8cp-2, INEXACT)
T(RN,   -0x1.e50d264c1ae5dp+3,    0x1.39fc6bde4d1cap-1,  -0x1.f7bbf8p-2, INEXACT)
T(RN,   -0x1.e315b60a28ca4p+3,    0x1.6709f6de2840dp-1,  -0x1.fd0882p-2, INEXACT)
T(RN,   -0x1.e120504e03acbp+3,    0x1.97f252ca60e69p-1,   0x1.fb3982p-2, INEXACT)
T(RN,    -0x1.df2cf2f9570cp+3,    0x1.cda5276f8d92bp-1,  -0x1.fb900ep-2, INEXACT)
T(RN,   -0x1.dd3b9bf0013fcp+3,    0x1.04ab8bc089903p+0,    -0x1.fb04p-2, INEXACT)
T(RN,    -0x1.db4c49181136p+3,    0x1.264f51b7de9f8p+0,   0x1.fb4738p-2, INEXACT)
T(RN,   -0x1.d95ef859c43a2p+3,    0x1.4cd03e75bfb99p+0,  -0x1.fddd82p-2, INEXACT)
T(RN,   -0x1.d773a79f83a79p+3,    0x1.79aaf97bb0d72p+0,   0x1.f7f5aap-2, INEXACT)
T(RN,   -0x1.d58a54d5e2a8ep+3,    0x1.af00b6066c038p+0,  -0x1.faa724p-2, INEXACT)
T(RN,   -0x1.d3a2fdeb9bfcep+3,    0x1.effc3a44d660bp+0,  -0x1.fd789ep-2, INEXACT)
T(RN,   -0x1.d1bda0d18fb88p+3,    0x1.20c5c43c28fd8p+1,   0x1.fdc40ep-2, INEXACT)
T(RN,   -0x1.cfda3b7ac1066p+3,    0x1.55e72cf644eadp+1,   -0x1.f886cp-2, INEXACT)
T(RN,   -0x1.cdf8cbdc53fb6p+3,    0x1.9e975fde45df3p+1,  -0x1.ffa6e4p-2, INEXACT)
T(RN,   -0x1.cc194fed8b582p+3,    0x1.047c45220dc7ep+2,    0x1.fc4d8p-2, INEXACT)
T(RN,   -0x1.ca3bc5a7c6547p+3,    0x1.5a881481fae32p+2,   0x1.f710c8p-2, INEXACT)
T(RN,   -0x1.c8602b067e767p+3,     0x1.ff18f41a703ep+2,   0x1.fc76f2p-2, INEXACT)
T(RN,   -0x1.c6867e07455eap+3,    0x1.deaf34994b7e7p+3,  -0x1.ff54aap-2, INEXACT)
T(RN,   -0x1.c4aebca9c2978p+3,    0x1.b4838e9ba0505p+6,  -0x1.f9ebf4p-2, INEXACT)
T(RN,   -0x1.c2d8e4efb17b6p+3,   -0x1.4bc20b1312d77p+4,   0x1.fd7b68p-2, INEXACT)
T(RN,    -0x1.c104f4dcded5p+3,   -0x1.2ebc321030d78p+3,  -0x1.f6980ep-2, INEXACT)
T(RN,   -0x1.bf32ea77275d5p+3,   -0x1.871ab105f2f17p+2,   0x1.f9f168p-2, INEXACT)
T(RN,   -0x1.bd62c3c674803p+3,   -0x1.1fbd4c197b20ap+2,    0x1.fbfd7p-2, INEXACT)
T(RN,   -0x1.bb947ed4bb3fcp+3,   -0x1.c5289c969eb12p+1,  -0x1.f68b2cp-2, INEXACT)
T(RN,   -0x1.b9c819adf99efp+3,    -0x1.73e2e3531711p+1,   0x1.fe554ep-2, INEXACT)
T(RN,   -0x1.b7fd9260348c5p+3,   -0x1.39a779193172bp+1,  -0x1.fcef74p-2, INEXACT)
T(RN,   -0x1.b634e6fb75d1cp+3,   -0x1.0da3dc63af0b9p+1,  -0x1.f6f9e2p-2, INEXACT)
T(RN,   -0x1.b46e1591ca244p+3,   -0x1.d6061b5b97c6cp+0,   0x1.f75fb4p-2, INEXACT)
T(RN,   -0x1.b2a91c373e9e8p+3,   -0x1.9dcd081c6bc9cp+0,  -0x1.fd8d04p-2, INEXACT)
T(RN,   -0x1.b0e5f901df26cp+3,   -0x1.6efcd1bf7ca28p+0,   0x1.f7f2ccp-2, INEXACT)
T(RN,   -0x1.af24aa09b41cfp+3,   -0x1.472e88d9365a6p+0,   -0x1.fb4b7p-2, INEXACT)
T(RN,   -0x1.ad652d68c058ap+3,   -0x1.24ba2b38e6e63p+0,  -0x1.fafcb8p-2, INEXACT)
T(RN,   -0x1.aba7813aff198p+3,   -0x1.0671a08c287bap+0,  -0x1.f8ec8ep-2, INEXACT)
T(RN,   -0x1.a9eba39e61fddp+3,   -0x1.d6ef388775713p-1,    0x1.f91bcp-2, INEXACT)
T(RN,   -0x1.a83192b2cef0ep+3,   -0x1.a64c218fa0af6p-1,   -0x1.f6437p-2, INEXACT)
T(RN,   -0x1.a6794c9a1e40cp+3,   -0x1.79fb766fca212p-1,  -0x1.f84772p-2, INEXACT)
T(RN,   -0x1.a4c2cf781875dp+3,   -0x1.51366ba7faa8cp-1,   0x1.fa2852p-2, INEXACT)
T(RN,   -0x1.a30e1972744a8p+3,   -0x1.2b5f065c95ebdp-1,   0x1.f744fep-2, INEXACT)
T(RN,   -0x1.a15b28b0d4deep+3,    -0x1.07f5b08314b5p-1,  -0x1.ff893ap-2, INEXACT)
T(RN,   -0x1.9fa9fb5cc77e1p+3,   -0x1.cd238fdaeca42p-2,   0x1.ff541ap-2, INEXACT)
T(RN,   -0x1.9dfa8fa1c1cb9p+3,   -0x1.8db865bdd6497p-2,  -0x1.fd09bep-2, INEXACT)
T(RN,   -0x1.9c4ce3ad1fab6p+3,   -0x1.5116b52ed749bp-2,  -0x1.f7b8b6p-2, INEXACT)
T(RN,   -0x1.9aa0f5ae2165ep+3,   -0x1.16c0433af4412p-2,    0x1.f6f5fp-2, INEXACT)
T(RN,   -0x1.98f6c3d5e990fp+3,   -0x1.bc8e361b12211p-3,  -0x1.fcdecap-2, INEXACT)
T(RN,   -0x1.974e4c577b369p+3,   -0x1.4e93c85975e26p-3,  -0x1.f9d19ep-2, INEXACT)
T(RN,   -0x1.95a78d67b7cdep+3,   -0x1.c5c3d11c65e9bp-4,   0x1.f636f6p-2, INEXACT)
T(RN,   -0x1.9402853d5d629p+3,   -0x1.e35f48953fe53p-5,  -0x1.fa5aacp-2, INEXACT)
T(RN,   -0x1.925f32110486ap+3,   -0x1.fbe900778cc3bp-8,  -0x1.fb0696p-2, INEXACT)
T(RN,   -0x1.90bd921d1e813p+3,    0x1.625bab7ab850dp-5,  -0x1.fe4ebap-2, INEXACT)
T(RN,   -0x1.8f1da39df358ep+3,    0x1.822c30455b30ep-4,   -0x1.f8502p-2, INEXACT)
T(RN,   -0x1.8d7f64d19fe6bp+3,    0x1.2a289eb12fc26p-3,   0x1.fbcbfcp-2, INEXACT)
T(RN,   -0x1.8be2d3f813fafp+3,    0x1.945ac9c494aaap-3,   0x1.fae754p-2, INEXACT)
T(RN,   -0x1.8a47ef53105b5p+3,      0x1.001edf7acc5p-2,  -0x1.f67bcap-2, INEXACT)
T(RN,   -0x1.88aeb526254e2p+3,    0x1.37354e6719a9fp-2,   0x1.f96ae8p-2, INEXACT)
T(RN,   -0x1.871723b6afd7ap+3,    0x1.6fc2f76af0fd5p-2,   0x1.fd0d64p-2, INEXACT)
T(RN,   -0x1.8581394bd891fp+3,    0x1.aa21d13a830f1p-2,   0x1.f62222p-2, INEXACT)
T(RN,   -0x1.83ecf42e9265ap+3,    0x1.e6b5d91bba933p-2,  -0x1.ff033ap-2, INEXACT)
T(RN,   -0x1.825a52a9969e7p+3,    0x1.12f7f3087c8dfp-1,   0x1.f6ada4p-2, INEXACT)
T(RN,   -0x1.80c953096552ep+3,    0x1.3428937e537ffp-1,   0x1.fe0334p-2, INEXACT)
T(RN,   -0x1.7f39f39c42453p+3,    0x1.5737c4abd41b7p-1,  -0x1.fd1be2p-2, INEXACT)
T(RN,   -0x1.7dac32b2337ffp+3,    0x1.7c7daee03b283p-1,   0x1.fd7abap-2, INEXACT)
T(RN,   -0x1.7c200e9cff593p+3,    0x1.a463596040d8ep-1,  -0x1.fb2088p-2, INEXACT)
T(RN,   -0x1.7a9585b02aae1p+3,    0x1.cf67897690192p-1,   0x1.f7a514p-2, INEXACT)
T(RN,   -0x1.790c9640f724bp+3,    0x1.fe25522ef7ea6p-1,   0x1.fa88c8p-2, INEXACT)
T(RN,   -0x1.77853ea661438p+3,    0x1.18ae89734addap+0,   0x1.f8f41cp-2, INEXACT)
T(RN,   -0x1.75ff7d391ea81p+3,     0x1.350083f7c658p+0,  -0x1.f9fbb4p-2, INEXACT)
T(RN,   -0x1.747b50539c598p+3,    0x1.54a39b44223a3p+0,  -0x1.fd05e4p-2, INEXACT)
T(RN,   -0x1.72f8b651fcde5p+3,    0x1.7861cb17c78e6p+0,   -0x1.fbc3ep-2, INEXACT)
T(RN,   -0x1.7177ad92168abp+3,     0x1.a147a2359d8ep+0,   0x1.ffba6ap-2, INEXACT)
T(RN,    -0x1.6ff8347371bbp+3,    0x1.d0c286176e0abp+0,   0x1.faa876p-2, INEXACT)
T(RN,   -0x1.6e7a49574701bp+3,    0x1.046889db51f17p+1,   0x1.f8d07ap-2, INEXACT)
T(RN,   -0x1.6cfdeaa07d7a7p+3,    0x1.2629d61181bbfp+1,   0x1.fc4508p-2, INEXACT)
T(RN,   -0x1.6b8316b3a8fecp+3,    0x1.4fcca08e08436p+1,   0x1.f8648ap-2, INEXACT)
T(RN,     -0x1.6a09cbf7087p+3,    0x1.84b23a7ba16f2p+1,  -0x1.fee478p-2, INEXACT)
T(RN,   -0x1.689208d283f47p+3,    0x1.ca7a7a85801f6p+1,   0x1.f94d5ep-2, INEXACT)
T(RN,   -0x1.671bcbafab4bdp+3,    0x1.159ff91a63a8ap+2,  -0x1.fca8c4p-2, INEXACT)
T(RN,   -0x1.65a712f9b3fefp+3,    0x1.5d9509856d3a5p+2,   0x1.fac892p-2, INEXACT)
T(RN,   -0x1.6433dd1d77ca9p+3,    0x1.d4882314515f2p+2,  -0x1.fb2f26p-2, INEXACT)
T(RN,   -0x1.62c2288972cadp+3,    0x1.6021329840c1fp+3,   0x1.fe6488p-2, INEXACT)
T(RN,   -0x1.6151f3adc1e53p+3,    0x1.5e05a74c99068p+4,   0x1.fa3a2ap-2, INEXACT)
T(RN,   -0x1.5fe33cfc20fd4p+3,   0x1.114c34648996ap+10,  -0x1.fcab16p-2, INEXACT)
T(RN,   -0x1.5e7602e7e963fp+3,   -0x1.6e29bbb551cc4p+4,  -0x1.fcde1cp-2, INEXACT)
T(RN,   -0x1.5d0a43e6100a1p+3,   -0x1.6a67066ffe933p+3,  -0x1.f67b32p-2, INEXACT)
T(RN,   -0x1.5b9ffe6d23f0fp+3,   -0x1.e0f23a73a6136p+2,   0x1.fa9836p-2, INEXACT)
T(RN,   -0x1.5a3730f54c6aep+3,   -0x1.672bec9f28ee6p+2,   0x1.f921bep-2, INEXACT)
T(RN,   -0x1.58cfd9f847846p+3,   -0x1.1dedfa6cb0ccap+2,   0x1.f745f8p-2, INEXACT)
T(RN,   -0x1.5769f7f1685f3p+3,   -0x1.d9bdbc25b7f5cp+1,   0x1.fa3658p-2, INEXACT)
T(RN,   -0x1.5605895d9572ap+3,   -0x1.9332db11a2df2p+1,  -0x1.fe7e32p-2, INEXACT)
T(RN,   -0x1.54a28cbb47052p+3,   -0x1.5ddcccce9e03cp+1,  -0x1.f682bap-2, INEXACT)
T(RN,   -0x1.5341008a85826p+3,   -0x1.33fb5c8ce827ep+1,   0x1.f78ca2p-2, INEXACT)
T(RN,   -0x1.51e0e34ce7e25p+3,   -0x1.121c468fc0cdfp+1,  -0x1.f96cfap-2, INEXACT)
T(RN,   -0x1.5082338590868p+3,   -0x1.ec1d1fae6f1b6p+0,   0x1.f5d3dap-2, INEXACT)
T(RN,   -0x1.4f24efb932dcbp+3,   -0x1.bcb8d92258d22p+0,   0x1.f5dc36p-2, INEXACT)
T(RN,   -0x1.4dc9166e03abep+3,   -0x1.9406478ea8588p+0,   -0x1.fdc4cp-2, INEXACT)
T(RN,   -0x1.4c6ea62bc5052p+3,   -0x1.7093cc1b516b7p+0,   0x1.fd4958p-2, INEXACT)
T(RN,   -0x1.4b159d7bbe764p+3,   -0x1.51524170b105fp+0,  -0x1.f7977ap-2, INEXACT)
T(RN,   -0x1.49bdfae8bc69ap+3,   -0x1.3576297ed41e1p+0,  -0x1.f853dep-2, INEXACT)
T(RN,    -0x1.4867bcff0e92p+3,   -0x1.1c63bf19dfd35p+0,   0x1.f659b8p-2, INEXACT)
T(RN,    -0x1.4712e24c866fp+3,    -0x1.05a1ae01f1a8p+0,  -0x1.f7bf2ep-2, INEXACT)
T(RN,   -0x1.45bf696075bd5p+3,   -0x1.e19ffadc39709p-1,  -0x1.f9ad7ap-2, INEXACT)
T(RN,   -0x1.446d50cbacd76p+3,   -0x1.bb436939be899p-1,   0x1.fbbe78p-2, INEXACT)
T(RN,   -0x1.431c9720793a6p+3,   -0x1.97b0a0f828318p-1,  -0x1.fc12e8p-2, INEXACT)
T(RN,   -0x1.41cd3af2a3f59p+3,   -0x1.7680ec823b558p-1,  -0x1.fc6ff4p-2, INEXACT)
T(RN,   -0x1.407f3ad77012dp+3,    -0x1.575f04b9704ap-1,   0x1.f5dd0ep-2, INEXACT)
T(RN,   -0x1.3f329565991fdp+3,   -0x1.3a0366da4f0afp-1,   0x1.fb96aap-2, INEXACT)
T(RN,   -0x1.3de74935519aep+3,    -0x1.1e318ada2ed6p-1,   0x1.f61aa6p-2, INEXACT)
T(RN,   -0x1.3c9d54e04184ep+3,   -0x1.03b5bdaab26adp-1,  -0x1.fe8c9cp-2, INEXACT)
T(RN,   -0x1.3b54b70184b0dp+3,   -0x1.d4c6e98457e02p-2,  -0x1.fa905ep-2, INEXACT)
T(RN,   -0x1.3a0d6e35a9775p+3,   -0x1.a427f8e9002b1p-2,  -0x1.f950cap-2, INEXACT)
T(RN,   -0x1.38c7791aaf0e9p+3,   -0x1.754ad617d3759p-2,   -0x1.fc671p-2, INEXACT)
T(RN,   -0x1.3782d6500416ep+3,   -0x1.47f390def9937p-2,   0x1.fc8aa6p-2, INEXACT)
T(RN,   -0x1.363f847685249p+3,   -0x1.1becbc9ca252fp-2,   0x1.ffe8aep-2, INEXACT)
T(RN,   -0x1.34fd82307b3a6p+3,   -0x1.e20c9f0aa6974p-3,  -0x1.f7677cp-2, INEXACT)
T(RN,   -0x1.33bcce219a63cp+3,   -0x1.8e29662c82336p-3,  -0x1.fff474p-2, INEXACT)
T(RN,   -0x1.327d66ef00146p+3,   -0x1.3bdff63958731p-3,  -0x1.fb3568p-2, INEXACT)
T(RN,   -0x1.313f4b3f31cf7p+3,   -0x1.d5ccec5063528p-4,   0x1.fb553cp-2, INEXACT)
T(RN,   -0x1.300279ba1bc0fp+3,   -0x1.35efcd70067abp-4,   0x1.f8ffb6p-2, INEXACT)
T(RN,   -0x1.2ec6f1090f192p+3,   -0x1.2f4c889c6ba9ap-5,   0x1.f9ad1ep-2, INEXACT)
T(RN,   -0x1.2d8cafd6c0bc9p+3,   0x1.63039c655c636p-10,  -0x1.f8c4aep-2, INEXACT)
T(RN,   -0x1.2c53b4cf47cebp+3,    0x1.443e723594d24p-5,   0x1.f9c7d6p-2, INEXACT)
T(RN,   -0x1.2b1bfea01c3a1p+3,    0x1.3e88740f1e797p-4,  -0x1.f71386p-2, INEXACT)
T(RN,   -0x1.29e58bf815472p+3,    0x1.db3b874b4f0bep-4,  -0x1.fde8e8p-2, INEXACT)
T(RN,   -0x1.28b05b876837dp+3,    0x1.3c5611c608d0bp-3,  -0x1.f992a2p-2, INEXACT)
T(RN,   -0x1.277c6bffa6c38p+3,     0x1.8ba79bdc6848p-3,   0x1.f9e792p-2, INEXACT)
T(RN,   -0x1.2649bc13bdae1p+3,    0x1.dbce257e709b4p-3,   0x1.f6456cp-2, INEXACT)
T(RN,   -0x1.25184a77f3e77p+3,    0x1.1683b905a91dap-2,    0x1.ff475p-2, INEXACT)
T(RN,   -0x1.23e815e1e7e05p+3,    0x1.3fca01b84b21ap-2,   0x1.ffe60cp-2, INEXACT)
T(RN,   -0x1.22b91d088f7b7p+3,    0x1.69dbf47e4d452p-2,   0x1.f82d4ap-2, INEXACT)
T(RN,    -0x1.218b5ea43606p+3,    0x1.94ddd1ed2d039p-2,   -0x1.f60b9p-2, INEXACT)
T(RN,   -0x1.205ed96e7b02bp+3,    0x1.c0f693de7e84dp-2,  -0x1.f63798p-2, INEXACT)
T(RN,   -0x1.1f338c2250671p+3,    0x1.ee507fc1b9017p-2,   0x1.fea6cep-2, INEXACT)
T(RN,   -0x1.1e09757bf9d6cp+3,    0x1.0e8ce7d19f34dp-1,  -0x1.fecef2p-2, INEXACT)
T(RN,   -0x1.1ce094390ad2ep+3,    0x1.26c2bbde5cbbap-1,  -0x1.f781bcp-2, INEXACT)
T(RN,   -0x1.1bb8e718658ccp+3,    0x1.3fe607ebb2e7dp-1,  -0x1.fe257ap-2, INEXACT)
T(RN,   -0x1.1a926cda397cdp+3,    0x1.5a1674dba18fap-1,  -0x1.fb4e5ap-2, INEXACT)
T(RN,   -0x1.196d2440020edp+3,    0x1.7577b02bd9931p-1,    0x1.fb05ep-2, INEXACT)
T(RN,   -0x1.18490c0c853d4p+3,    0x1.92323799ce7e3p-1,   0x1.f6eb1cp-2, INEXACT)
T(RN,   -0x1.17262303d2511p+3,    0x1.b07452bd42142p-1,  -0x1.ffc9c2p-2, INEXACT)
T(RN,    -0x1.160467eb4068p+3,    0x1.d07347b6cbd8cp-1,   0x1.f65022p-2, INEXACT)
T(RN,    -0x1.14e3d9896d5ep+3,    0x1.f26cdc705b9e8p-1,  -0x1.f6b362p-2, INEXACT)
T(RN,   -0x1.13c476a63c23dp+3,    0x1.0b549e0473214p+0,   0x1.ff0dcap-2, INEXACT)
T(RN,   -0x1.12a63e0ad3b3ep+3,    0x1.1ebeb05203935p+0,   0x1.f753cap-2, INEXACT)
T(RN,   -0x1.11892e819daefp+3,    0x1.33a71718429f6p+0,    0x1.f6e38p-2, INEXACT)
T(RN,   -0x1.106d46d644f71p+3,     0x1.4a4a3e56962bp+0,   0x1.fe381ap-2, INEXACT)
T(RN,    -0x1.0f5285d5b484p+3,    0x1.62f1357e0ea14p+0,   -0x1.ff3a4p-2, INEXACT)
T(RN,   -0x1.0e38ea4e15fe3p+3,    0x1.7df53da0207d9p+0,   0x1.ff13e2p-2, INEXACT)
T(RN,   -0x1.0d20730ed083fp+3,    0x1.9bc49b8080b47p+0,  -0x1.fda948p-2, INEXACT)
T(RN,   -0x1.0c091ee88748ap+3,    0x1.bce93caea010cp+0,   0x1.f79628p-2, INEXACT)
T(RN,   -0x1.0af2ecad186a4p+3,    0x1.e2120bf05c30ap+0,   -0x1.fa9b3p-2, INEXACT)
T(RN,   -0x1.09dddb2f9b99bp+3,    0x1.0610284a60f29p+1,  -0x1.f6775cp-2, INEXACT)
T(RN,   -0x1.08c9e94460d65p+3,    0x1.1e1da66442977p+1,   0x1.f96cdap-2, INEXACT)
T(RN,   -0x1.07b715c0ef2f6p+3,    0x1.39f6e608fa26ap+1,  -0x1.f7400ep-2, INEXACT)
T(RN,   -0x1.06a55f7c03765p+3,    0x1.5aaa0636f28b8p+1,   0x1.fcb116p-2, INEXACT)
T(RN,   -0x1.0594c54d8f0b7p+3,    0x1.81b2d1ba95c2cp+1,  -0x1.f6d258p-2, INEXACT)
T(RN,   -0x1.0485460eb6951p+3,    0x1.b138c34052605p+1,  -0x1.f5f4ccp-2, INEXACT)
T(RN,   -0x1.0376e099d0be2p+3,    0x1.ec7c7a9b08311p+1,  -0x1.f5d086p-2, INEXACT)
T(RN,   -0x1.026993ca650d3p+3,    0x1.1c5295872394ap+2,   0x1.fa8678p-2, INEXACT)
T(RN,   -0x1.015d5e7d2a7afp+3,    0x1.4f307e40bf3d8p+2,   0x1.fcf76ap-2, INEXACT)
T(RN,   -0x1.00523f9006684p+3,    0x1.96c4a30d9e42dp+2,   0x1.f6c148p-2, INEXACT)
T(RN,   -0x1.fe906bc416997p+2,    0x1.019d8f7f7a60ep+3,  -0x1.f69686p-2, INEXACT)
T(RN,   -0x1.fc7e80a6eefd7p+2,    0x1.5dc06bf823903p+3,   0x1.f9d1a4p-2, INEXACT)
T(RN,   -0x1.fa6ebb8b67fccp+2,    0x1.0ebf6cc6fd7b9p+4,  -0x1.fce248p-2, INEXACT)
T(RN,   -0x1.f8611a36a685dp+2,    0x1.28d436309d243p+5,   0x1.f75426p-2, INEXACT)
T(RN,   -0x1.f6559a702000cp+2,   -0x1.8f7390601947dp+7,  -0x1.fd2fc6p-2, INEXACT)
T(RN,   -0x1.f44c3a0197f06p+2,   -0x1.b23e0418d673ep+4,  -0x1.fa057cp-2, INEXACT)
T(RN,   -0x1.f244f6b71d8aep+2,   -0x1.d244f01778b2dp+3,   0x1.fa3b6ep-2, INEXACT)
T(RN,   -0x1.f03fce5f09528p+2,   -0x1.3ea7208795c1fp+3,   0x1.f6ba3ap-2, INEXACT)
T(RN,   -0x1.ee3cbec9fac7dp+2,   -0x1.e3cb425eceeeep+2,     0x1.f5e8p-2, INEXACT)
T(RN,   -0x1.ec3bc5cad57e5p+2,   -0x1.858f501d7a3fep+2,  -0x1.f5e97ep-2, INEXACT)
T(RN,   -0x1.ea3ce136c123ap+2,   -0x1.45b876d14c7eap+2,  -0x1.fe02cep-2, INEXACT)
T(RN,   -0x1.e8400ee522749p+2,   -0x1.17892c8e07af5p+2,   -0x1.f74bdp-2, INEXACT)
T(RN,   -0x1.e6454caf9daffp+2,   -0x1.e906852399e14p+1,   0x1.faca24p-2, INEXACT)
T(RN,   -0x1.e44c987211b85p+2,   -0x1.b1fd31132283dp+1,   0x1.f7f81ep-2, INEXACT)
T(RN,   -0x1.e255f00a96685p+2,   -0x1.8587634c7b2abp+1,   0x1.fe875ep-2, INEXACT)
T(RN,   -0x1.e06151597a331p+2,   -0x1.60cd00078228ep+1,   -0x1.f9746p-2, INEXACT)
T(RN,   -0x1.de6eba413fd35p+2,   -0x1.41e5729f9fa13p+1,   0x1.f5f9dep-2, INEXACT)
T(RN,   -0x1.dc7e28a69c1bfp+2,   -0x1.277ca6ad2af2dp+1,  -0x1.ff2034p-2, INEXACT)
T(RN,   -0x1.da8f9a70737fep+2,   -0x1.109e955273226p+1,   0x1.f6c484p-2, INEXACT)
T(RN,   -0x1.d8a30d87d7f99p+2,   -0x1.f92f2b25259fbp+0,  -0x1.fa39b4p-2, INEXACT)
T(RN,   -0x1.d6b87fd806b89p+2,   -0x1.d5c0e1ea1ead6p+0,    0x1.fdbdcp-2, INEXACT)
T(RN,   -0x1.d4cfef4e65dcfp+2,   -0x1.b622dee6f8a38p+0,  -0x1.f5d10ap-2, INEXACT)
T(RN,   -0x1.d2e959da82431p+2,   -0x1.99b3565f27f92p+0,  -0x1.fc3882p-2, INEXACT)
T(RN,   -0x1.d104bd6e0d3fdp+2,   -0x1.7ff23715ca2acp+0,   0x1.f6533cp-2, INEXACT)
T(RN,   -0x1.cf2217fcda693p+2,   -0x1.6878cc461f821p+0,   0x1.fac068p-2, INEXACT)
T(RN,   -0x1.cd41677cdd5e9p+2,   -0x1.52f3bf0b4ff3ep+0,  -0x1.fe47f4p-2, INEXACT)
T(RN,   -0x1.cb62a9e6279f1p+2,   -0x1.3f1eb74f7ac1fp+0,  -0x1.fa9f82p-2, INEXACT)
T(RN,   -0x1.c985dd32e63fep+2,   -0x1.2cc11ea62fba3p+0,  -0x1.f66b46p-2, INEXACT)
T(RN,   -0x1.c7aaff5f5fd7fp+2,   -0x1.1babb10f6651bp+0,   0x1.f802a2p-2, INEXACT)
T(RN,    -0x1.c5d20e69f234p+2,   -0x1.0bb6a2573ba82p+0,   0x1.f6a5c8p-2, INEXACT)
T(RN,   -0x1.c3fb085310586p+2,   -0x1.f98060999b5bfp-1,   0x1.fb6322p-2, INEXACT)
T(RN,   -0x1.c225eb1d401e8p+2,   -0x1.dd570b839f3c6p-1,   0x1.fa91aep-2, INEXACT)
T(RN,   -0x1.c052b4cd18233p+2,   -0x1.c2bfb47a3fdbbp-1,  -0x1.f6e478p-2, INEXACT)
T(RN,    -0x1.be8163693dd9p+2,   -0x1.a98f7f9ab626fp-1,  -0x1.fb810ap-2, INEXACT)
T(RN,   -0x1.bcb1f4fa62ffap+2,   -0x1.91a1288c34462p-1,   0x1.fb15a6p-2, INEXACT)
T(RN,    -0x1.bae4678b43d7p+2,   -0x1.7ad41be4da2f2p-1,  -0x1.fb73f2p-2, INEXACT)
T(RN,   -0x1.b918b928a4d32p+2,   -0x1.650bbb83c79a4p-1,    -0x1.f79ap-2, INEXACT)
T(RN,   -0x1.b74ee7e1509d5p+2,   -0x1.502ec4cd91cd1p-1,  -0x1.f894fap-2, INEXACT)
T(RN,   -0x1.b586f1c615ec8p+2,   -0x1.3c26d1d83cc55p-1,  -0x1.f99e9ap-2, INEXACT)
T(RN,   -0x1.b3c0d4e9c5639p+2,   -0x1.28dff0288a919p-1,   -0x1.fd5d8p-2, INEXACT)
T(RN,   -0x1.b1fc8f612f8a8p+2,   -0x1.164848d25fc34p-1,   0x1.f83afcp-2, INEXACT)
T(RN,   -0x1.b03a1f4322cedp+2,   -0x1.044fd6b44762ap-1,   0x1.faab32p-2, INEXACT)
T(RN,   -0x1.ae7982a869285p+2,   -0x1.e5d0506c2c2a7p-2,  -0x1.fb0dfep-2, INEXACT)
T(RN,   -0x1.acbab7abc67a4p+2,   -0x1.c40854f47b795p-2,   -0x1.f7f59p-2, INEXACT)
T(RN,   -0x1.aafdbc69f6128p+2,   -0x1.a32ff8b4cef15p-2,   0x1.f91fd6p-2, INEXACT)
T(RN,   -0x1.a9428f01a8f36p+2,   -0x1.83318fb45468ap-2,   0x1.fdaa9ep-2, INEXACT)
T(RN,   -0x1.a7892d9383a98p+2,   -0x1.63f941f652befp-2,  -0x1.f5d736p-2, INEXACT)
T(RN,   -0x1.a5d196421c3fbp+2,   -0x1.4574d2221fc92p-2,   -0x1.f7b07p-2, INEXACT)
T(RN,   -0x1.a41bc731f8504p+2,   -0x1.27936bb8fa277p-2,   0x1.f5ec16p-2, INEXACT)
T(RN,   -0x1.a267be898aef3p+2,   -0x1.0a4577a8fce03p-2,  -0x1.fa4f12p-2, INEXACT)
T(RN,    -0x1.a0b57a7132adp+2,   -0x1.daf8ec817cbf1p-3,   0x1.fac37ep-2, INEXACT)
T(RN,   -0x1.9f04f913379b8p+2,   -0x1.a255bb62dc8ffp-3,  -0x1.f5c75ep-2, INEXACT)
T(RN,   -0x1.9d56389bc955cp+2,   -0x1.6a87f8df31151p-3,  -0x1.f87db2p-2, INEXACT)
T(RN,   -0x1.9ba93738fd2edp+2,   -0x1.3377bdbd5bd1dp-3,  -0x1.fa0164p-2, INEXACT)
T(RN,   -0x1.99fdf31acbaf6p+2,   -0x1.fa1cdf29055e3p-4,  -0x1.fcc792p-2, INEXACT)
T(RN,   -0x1.98546a730f474p+2,   -0x1.8e6d2d0b69caap-4,  -0x1.feed3cp-2, INEXACT)
T(RN,   -0x1.96ac9b7581fe4p+2,   -0x1.23b76e0da2a4bp-4,   0x1.fb3032p-2, INEXACT)
T(RN,   -0x1.95068457bb8f7p+2,    -0x1.73a8bc8aad1ap-5,  -0x1.f7520ap-2, INEXACT)
T(RN,   -0x1.936223512f876p+2,   -0x1.4278b53939549p-6,   0x1.f8052ep-2, INEXACT)
T(RN,   -0x1.91bf769b2b4a6p+2,    0x1.80fbc69485541p-8,   0x1.ffabdap-2, INEXACT)
T(RN,    -0x1.901e7c70d428p+2,    0x1.00b1e867e7c7dp-5,   0x1.f6ac26p-2, INEXACT)
T(RN,   -0x1.8e7f330f2573dp+2,    0x1.d0c0809f0e592p-5,  -0x1.fe9dcap-2, INEXACT)
T(RN,   -0x1.8ce198b4eea41p+2,    0x1.5047c84c6875ap-4,   0x1.f80a18p-2, INEXACT)
T(RN,   -0x1.8b45aba2d1597p+2,    0x1.b8314347870c9p-4,  -0x1.f60342p-2, INEXACT)
T(RN,   -0x1.89ab6a1b3fc05p+2,    0x1.101f124070795p-3,   0x1.f799e4p-2, INEXACT)
T(RN,   -0x1.8812d2627a1eap+2,    0x1.4447e367e14d2p-3,  -0x1.f94fdep-2, INEXACT)
T(RN,   -0x1.867be2be8d818p+2,    0x1.78a3cbb748508p-3,  -0x1.fef9a4p-2, INEXACT)
T(RN,   -0x1.84e6997751a92p+2,    0x1.ad43a04a56ec5p-3,   0x1.fd2b9cp-2, INEXACT)
T(RN,   -0x1.8352f4d66722bp+2,    0x1.e2386a292d8f8p-3,   0x1.f89492p-2, INEXACT)
T(RN,   -0x1.81c0f3273574ap+2,    0x1.0bc9be08b577dp-2,   0x1.fe0d24p-2, INEXACT)
T(RN,   -0x1.803092b6e9587p+2,    0x1.26b3446acde81p-2,   0x1.fcdc16p-2, INEXACT)
T(RN,   -0x1.7ea1d1d472c91p+2,      0x1.41e1dd48455p-2,  -0x1.f843a4p-2, INEXACT)
T(RN,   -0x1.7d14aed0834dep+2,    0x1.5d5ee57699247p-2,  -0x1.f5de32p-2, INEXACT)
T(RN,   -0x1.7b8927fd8bffbp+2,    0x1.79340e64647e9p-2,  -0x1.fb191ep-2, INEXACT)
T(RN,   -0x1.79ff3bafbbdc5p+2,    0x1.956b6bbd0d5b9p-2,  -0x1.f9f8bcp-2, INEXACT)
T(RN,   -0x1.7876e83cfdccfp+2,    0x1.b20f82087ed77p-2,   0x1.f625bep-2, INEXACT)
T(RN,   -0x1.76f02bfcf763ap+2,     0x1.cf2b5674c679p-2,  -0x1.f9ba0cp-2, INEXACT)
T(RN,   -0x1.756b05490605ap+2,    0x1.ecca7ffd32b44p-2,   0x1.f9446ep-2, INEXACT)
T(RN,   -0x1.73e7727c3e21ep+2,    0x1.057c9d146855dp-1,   0x1.f5c482p-2, INEXACT)
T(RN,   -0x1.726571f368edcp+2,    0x1.14e23cd15b19ap-1,  -0x1.f80496p-2, INEXACT)
T(RN,   -0x1.70e5020d02ba2p+2,    0x1.249d017bde726p-1,  -0x1.f64f78p-2, INEXACT)
T(RN,   -0x1.6f662129393eap+2,    0x1.34b441e887e72p-1,   0x1.f90eb2p-2, INEXACT)
T(RN,   -0x1.6de8cda9e9b95p+2,    0x1.452fd7885cbe9p-1,   0x1.fabf58p-2, INEXACT)
T(RN,   -0x1.6c6d05f295647p+2,    0x1.56182e2369f5dp-1,  -0x1.f5c4e8p-2, INEXACT)
T(RN,   -0x1.6af2c86890eecp+2,    0x1.6776558170d03p-1,   0x1.fbe524p-2, INEXACT)
T(RN,    -0x1.697a1372a066p+2,    0x1.7954155ae71cep-1,  -0x1.fa5004p-2, INEXACT)
T(RN,   -0x1.6802e57957c6fp+2,    0x1.8bbc03e235256p-1,  -0x1.fc2a98p-2, INEXACT)
T(RN,   -0x1.668d3ce6e81dep+2,    0x1.9eb99f65e369dp-1,   0x1.f8b5f2p-2, INEXACT)
T(RN,    -0x1.6519182727c1p+2,    0x1.b2596b890d37ep-1,  -0x1.fbb4a8p-2, INEXACT)
T(RN,   -0x1.63a675a790586p+2,    0x1.c6a912b639605p-1,  -0x1.ff753ap-2, INEXACT)
T(RN,   -0x1.623553d73d7e5p+2,    0x1.dbb78c8d6e9a6p-1,    0x1.fac87p-2, INEXACT)
T(RN,   -0x1.60c5b126eabfep+2,    0x1.f1954a36ce75ep-1,  -0x1.f81af4p-2, INEXACT)
T(RN,   -0x1.5f578c08f2323p+2,    0x1.042a34da2cb87p+0,  -0x1.fd0b16p-2, INEXACT)
T(RN,    -0x1.5deae2f14a87p+2,    0x1.100478c5a4759p+0,   0x1.fa3ac2p-2, INEXACT)
T(RN,   -0x1.5c7fb455858dbp+2,    0x1.1c648b354a3a6p+0,  -0x1.fde7a8p-2, INEXACT)
T(RN,   -0x1.5b15feacce751p+2,    0x1.2956c66adb5d9p+0,   0x1.fb0034p-2, INEXACT)
T(RN,   -0x1.59adc06fe7d2ep+2,    0x1.36e8f4ab20cb2p+0,    0x1.f5e5ap-2, INEXACT)
T(RN,   -0x1.5846f8192b814p+2,    0x1.452a892a262e2p+0,   0x1.f8a38ap-2, INEXACT)
T(RN,   -0x1.56e1a42486055p+2,    0x1.542ce3c0816a8p+0,  -0x1.f94752p-2, INEXACT)
T(RN,   -0x1.557dc30f77d7ap+2,    0x1.6403a1e1c437fp+0,   0x1.f970b6p-2, INEXACT)
T(RN,   -0x1.541b53591248bp+2,    0x1.74c4fff7fd22ap+0,   0x1.f6dc5ep-2, INEXACT)
T(RN,   -0x1.52ba5381f62dbp+2,    0x1.868a4f2862ec2p+0,   0x1.f8c2a2p-2, INEXACT)
T(RN,   -0x1.515ac20c524eep+2,     0x1.997084afcd77p+0,   0x1.fc4778p-2, INEXACT)
T(RN,   -0x1.4ffc9d7be1afcp+2,    0x1.ad98e994bae3fp+0,  -0x1.f859b6p-2, INEXACT)
T(RN,   -0x1.4e9fe455ea0fcp+2,    0x1.c329f3883a5a6p+0,  -0x1.ff0c3ep-2, INEXACT)
T(RN,   -0x1.4d4495213a3d2p+2,    0x1.da5052b050db6p+0,  -0x1.f9a77ep-2, INEXACT)
T(RN,   -0x1.4beaae6628878p+2,    0x1.f3404410eaed1p+0,  -0x1.fbfc94p-2, INEXACT)
T(RN,   -0x1.4a922eae91239p+2,    0x1.071b9eec74e1ep+1,   0x1.f8e89ep-2, INEXACT)
T(RN,   -0x1.493b1485d481cp+2,    0x1.15bf095da731ep+1,  -0x1.f60706p-2, INEXACT)
T(RN,   -0x1.47e55e78d6222p+2,    0x1.25b5da68c3c18p+1,   0x1.fce02ap-2, INEXACT)
T(RN,   -0x1.46910b15fa484p+2,    0x1.373468873a80ep+1,  -0x1.fb56f8p-2, INEXACT)
T(RN,   -0x1.453e18ed25097p+2,    0x1.4a7a4a6b414b1p+1,   0x1.f608bcp-2, INEXACT)
T(RN,   -0x1.43ec868fb89fcp+2,    0x1.5fd58a37fcb8dp+1,   0x1.f5f798p-2, INEXACT)
T(RN,   -0x1.429c529093ac8p+2,    0x1.77a7012108a32p+1,  -0x1.fb88fcp-2, INEXACT)
T(RN,   -0x1.414d7b840fc56p+2,    0x1.92686097e845ap+1,   0x1.fac4b2p-2, INEXACT)
T(RN,    0x1.3fffffffffffcp+3,    0x1.4bf5f34be3727p-1,  -0x1.da798cp-2, INEXACT)
T(RN,    0x1.3f434e77b1184p+3,    0x1.3b74132e4d1a5p-1,   0x1.a82a46p-2, INEXACT)
T(RN,    0x1.3e870c3391a52p+3,    0x1.2b71d180bf0cap-1,  -0x1.a4bc74p-2, INEXACT)
T(RN,    0x1.3dcb38f205767p+3,    0x1.1be55ae52b27ep-1,  -0x1.ce543cp-2, INEXACT)
T(RN,    0x1.3d0fd471970bdp+3,    0x1.0cc5ad27fcf84p-1,   -0x1.c2669p-2, INEXACT)
T(RN,    0x1.3c54de70f77f2p+3,    0x1.fc15000013535p-2,   0x1.a3eda8p-2, INEXACT)
T(RN,    0x1.3b9a56aefe6a3p+3,    0x1.df586174667c6p-2,   0x1.a4240cp-2, INEXACT)
T(RN,    0x1.3ae03ceaa9d9cp+3,    0x1.c34760c6d6332p-2,   -0x1.fd6b3p-2, INEXACT)
T(RN,    0x1.3a2690e31e257p+3,    0x1.a7d4e82af1b0ep-2,   -0x1.b9e1dp-2, INEXACT)
T(RN,    0x1.396d5257a5ec6p+3,    0x1.8cf4ce32ff49bp-2,   0x1.cf59ecp-2, INEXACT)
T(RN,    0x1.38b48107b1f03p+3,    0x1.729bbd3e5d213p-2,   0x1.f67e2cp-2, INEXACT)
T(RN,    0x1.37fc1cb2d906fp+3,     0x1.58bf1da2f735p-2,    -0x1.b382p-2, INEXACT)
T(RN,    0x1.37442518d800ap+3,    0x1.3f550233f8edep-2,   0x1.cd9866p-2, INEXACT)
T(RN,    0x1.368c99f991936p+3,     0x1.265416d59d7cp-2,   0x1.df5f76p-2, INEXACT)
T(RN,    0x1.35d57b150e41bp+3,    0x1.0db390d972616p-2,   -0x1.fd446p-2, INEXACT)
T(RN,    0x1.351ec82b7c476p+3,    0x1.ead641cffb24ep-3,   0x1.af4dd8p-2, INEXACT)
T(RN,    0x1.346880fd2f7cbp+3,    0x1.bae5cc898eed7p-3,  -0x1.9f52cep-2, INEXACT)
T(RN,    0x1.33b2a54aa15a4p+3,     0x1.8b86c6813deap-3,   0x1.d24394p-2, INEXACT)
T(RN,    0x1.32fd34d470af2p+3,      0x1.5caae567324p-3,   0x1.f7851ep-2, INEXACT)
T(RN,    0x1.32482f5b61becp+3,    0x1.2e447cbaa3949p-3,    0x1.bb9fcp-2, INEXACT)
T(RN,     0x1.319394a05e08p+3,    0x1.00466c1bc234bp-3,   0x1.99b1eep-2, INEXACT)
T(RN,    0x1.30df6464745e2p+3,    0x1.a5481df6a1cbdp-4,   0x1.ae3b5ap-2, INEXACT)
T(RN,    0x1.302b9e68d8813p+3,    0x1.4aa25af3809bap-4,  -0x1.b661e8p-2, INEXACT)
T(RN,    0x1.2f78426ee358dp+3,    0x1.e107b9349d354p-5,  -0x1.a8bc42p-2, INEXACT)
T(RN,    0x1.2ec5503812b72p+3,    0x1.2dab262495811p-5,    0x1.c0febp-2, INEXACT)
T(RN,    0x1.2e12c78609499p+3,    0x1.ec07c27c6e705p-7,   0x1.9b73b8p-2, INEXACT)
T(RN,    0x1.2d60a81a8e833p+3,   -0x1.b9007955d1f6cp-8,   0x1.b9e7ccp-2, INEXACT)
T(RN,    0x1.2caef1b78e899p+3,   -0x1.d1cc93e46d1d1p-6,   0x1.fb0f0ap-2, INEXACT)
T(RN,    0x1.2bfda41f1a1afp+3,    -0x1.9a7ba4d69ddep-5,  -0x1.eb12c2p-2, INEXACT)
T(RN,     0x1.2b4cbf13667cp+3,   -0x1.260551c015c95p-4,  -0x1.ebbdc4p-2, INEXACT)
T(RN,    0x1.2a9c4256cd60ep+3,   -0x1.7edec8a22a2e1p-4,   0x1.d8914ep-2, INEXACT)
T(RN,    0x1.29ec2dabccd93p+3,   -0x1.d7df54d091c71p-4,  -0x1.9a40cep-2, INEXACT)
T(RN,    0x1.293c80d507378p+3,   -0x1.188e1018b5e51p-3,  -0x1.d62172p-2, INEXACT)
T(RN,    0x1.288d3b9542ff3p+3,   -0x1.45553a714d769p-3,   0x1.f89e16p-2, INEXACT)
T(RN,    0x1.27de5daf6acd1p+3,   -0x1.724fe8b86a8a2p-3,   0x1.9d2e22p-2, INEXACT)
T(RN,    0x1.272fe6e68d435p+3,   -0x1.9f88feaef3d5fp-3,  -0x1.d5f038p-2, INEXACT)
T(RN,    0x1.2681d6fddcf3fp+3,   -0x1.cd0b8f0ff1aacp-3,   0x1.dace52p-2, INEXACT)
T(RN,    0x1.25d42db8b04a2p+3,   -0x1.fae2e66226ba5p-3,  -0x1.b8b6f4p-2, INEXACT)
T(RN,    0x1.2526eada8177fp+3,   -0x1.148d4b191ea2dp-2,  -0x1.a70198p-2, INEXACT)
T(RN,    0x1.247a0e26ee5e6p+3,    -0x1.2bdf4066b988p-2,   0x1.9a75ccp-2, INEXACT)
T(RN,    0x1.23cd9761b879cp+3,   -0x1.436d72cb2b1cdp-2,  -0x1.a5791cp-2, INEXACT)
T(RN,    0x1.2321864ec4cddp+3,   -0x1.5b3e37079b704p-2,   0x1.9f82bap-2, INEXACT)
T(RN,    0x1.2275dab21bcdep+3,   -0x1.73581ddc359a3p-2,    0x1.fe2b5p-2, INEXACT)
T(RN,    0x1.21ca944fe94a5p+3,   -0x1.8bc1fb71b9b24p-2,    0x1.f0307p-2, INEXACT)
T(RN,    0x1.211fb2ec7c5abp+3,   -0x1.a482ef4fc69e9p-2,    0x1.d6abfp-2, INEXACT)
T(RN,    0x1.2075364c4749fp+3,   -0x1.bda26cf42f6a3p-2,   0x1.bb2d46p-2, INEXACT)
T(RN,    0x1.1fcb1e33df7fcp+3,   -0x1.d72845221a1fep-2,   0x1.c23a5cp-2, INEXACT)
T(RN,    0x1.1f216a67fd6dap+3,   -0x1.f11cb00276fd6p-2,   0x1.99c04ap-2, INEXACT)
T(RN,    0x1.1e781aad7c7a1p+3,   -0x1.05c42c1957213p-1,   0x1.beb132p-2, INEXACT)
T(RN,    0x1.1dcf2ec95aea9p+3,   -0x1.133a33711ffe1p-1,  -0x1.d737aap-2, INEXACT)
T(RN,    0x1.1d26a680b9d08p+3,   -0x1.20f548924c332p-1,   0x1.e0b2a2p-2, INEXACT)
T(RN,    0x1.1c7e8198dcf3fp+3,    -0x1.2efa9350d6a4p-1,    0x1.c4a18p-2, INEXACT)
T(RN,    0x1.1bd6bfd72abf1p+3,   -0x1.3d4f90eb1ae9cp-1,   0x1.dfd292p-2, INEXACT)
T(RN,    0x1.1b2f61012c2abp+3,   -0x1.4bfa1d0dd43f3p-1,  -0x1.ee7082p-2, INEXACT)
T(RN,    0x1.1a8864dc8ca89p+3,   -0x1.5b007bdc6b82dp-1,   0x1.a4ea82p-2, INEXACT)
T(RN,    0x1.19e1cb2f1a0eep+3,   -0x1.6a69652320eebp-1,   0x1.a9e0bep-2, INEXACT)
T(RN,    0x1.193b93bec489cp+3,   -0x1.7a3c10deb36ffp-1,  -0x1.9eeabcp-2, INEXACT)
T(RN,    0x1.1895be519e771p+3,   -0x1.8a80454c67923p-1,  -0x1.99eb6ap-2, INEXACT)
T(RN,    0x1.17f04aaddc6cfp+3,    -0x1.9b3e66bdea76p-1,   0x1.aec964p-2, INEXACT)
T(RN,    0x1.174b3899d5066p+3,   -0x1.ac7f8976f50b2p-1,   0x1.d23776p-2, INEXACT)
T(RN,    0x1.16a687dc00e7ap+3,   -0x1.be4d85e6ecbbcp-1,   0x1.a1a32cp-2, INEXACT)
T(RN,    0x1.1602383afa9eap+3,   -0x1.d0b30f9fd090bp-1,    0x1.9d23bp-2, INEXACT)
T(RN,     0x1.155e497d7e93p+3,   -0x1.e3bbcf7dda61cp-1,  -0x1.a18b42p-2, INEXACT)
T(RN,    0x1.14babb6a6aee9p+3,   -0x1.f774818954bffp-1,  -0x1.af6abap-2, INEXACT)
T(RN,    0x1.14178dc8bf8cbp+3,   -0x1.05f58b9b8a45ep+0,   0x1.ac3f92p-2, INEXACT)
T(RN,    0x1.1374c05f9de5ep+3,   -0x1.10976f668a7d5p+0,  -0x1.a98d76p-2, INEXACT)
T(RN,    0x1.12d252f648f99p+3,   -0x1.1ba8586cb7321p+0,   0x1.c5453ap-2, INEXACT)
T(RN,    0x1.12304554253dap+3,   -0x1.2731926e286edp+0,  -0x1.ca06c2p-2, INEXACT)
T(RN,    0x1.118e9740b888fp+3,   -0x1.333d67423d478p+0,   0x1.99e8a4p-2, INEXACT)
T(RN,    0x1.10ed4883a9fe3p+3,   -0x1.3fd742961dfb9p+0,  -0x1.b21874p-2, INEXACT)
T(RN,    0x1.104c58e4c1fd2p+3,    -0x1.4d0bdbd40a34p+0,   0x1.9d229cp-2, INEXACT)
T(RN,    0x1.0fabc82bea091p+3,   -0x1.5ae9677aa8e94p+0,  -0x1.9bfb6cp-2, INEXACT)
T(RN,    0x1.0f0b96212cb89p+3,   -0x1.697fd17b74ca9p+0,  -0x1.a41664p-2, INEXACT)
T(RN,    0x1.0e6bc28cb5a1ep+3,   -0x1.78e1029df117cp+0,  -0x1.dcd2e2p-2, INEXACT)
T(RN,    0x1.0dcc4d36d146ap+3,   -0x1.89213369e4332p+0,   0x1.ea3fd6p-2, INEXACT)
T(RN,    0x1.0d2d35e7ed022p+3,   -0x1.9a574fc781df6p+0,   0x1.b3bc82p-2, INEXACT)
T(RN,    0x1.0c8e7c6896f29p+3,   -0x1.ac9d6f672a0cap+0,   0x1.adfa0cp-2, INEXACT)
T(RN,    0x1.0bf020817de95p+3,   -0x1.c011682e9f8d7p+0,  -0x1.cb3298p-2, INEXACT)
T(RN,    0x1.0b5221fb71553p+3,   -0x1.d4d5817adfcc4p+0,  -0x1.b1e346p-2, INEXACT)
T(RN,    0x1.0ab4809f61312p+3,   -0x1.eb11512340ab2p+0,  -0x1.f68c8ap-2, INEXACT)
T(RN,    0x1.0a173c365def4p+3,   -0x1.017967066ea95p+1,  -0x1.eda4f6p-2, INEXACT)
T(RN,    0x1.097a54899866fp+3,    -0x1.0e57d40bc078p+1,  -0x1.bf00c6p-2, INEXACT)
T(RN,    0x1.08ddc96261c13p+3,   -0x1.1c437d5d12908p+1,  -0x1.e2f494p-2, INEXACT)
T(RN,    0x1.08419a8a2b64ap+3,   -0x1.2b61bbbef0338p+1,  -0x1.cd1306p-2, INEXACT)
T(RN,    0x1.07a5c7ca86e5cp+3,   -0x1.3bdf1863088c6p+1,   0x1.e732acp-2, INEXACT)
T(RN,    0x1.070a50ed25efep+3,   -0x1.4df11eda5bc9fp+1,  -0x1.f65f04p-2, INEXACT)
T(RN,    0x1.066f35bbda34dp+3,   -0x1.61d8c41aff7d2p+1,   0x1.e7bf28p-2, INEXACT)
T(RN,    0x1.05d4760095539p+3,   -0x1.77e59d61a42e5p+1,  -0x1.9cf98cp-2, INEXACT)
T(RN,    0x1.053a118568e0bp+3,   -0x1.907a3dc8fc919p+1,  -0x1.c08af8p-2, INEXACT)
T(RN,    0x1.04a00814861dcp+3,   -0x1.ac123d8ccd2fap+1,   -0x1.beeabp-2, INEXACT)
T(RN,    0x1.040659783e174p+3,   -0x1.cb4ab4f248ab5p+1,   0x1.9a9c9ep-2, INEXACT)
T(RN,    0x1.036d057b0190fp+3,   -0x1.eeee6a4cddadfp+1,  -0x1.db5a44p-2, INEXACT)
T(RN,     0x1.02d40be760c4p+3,   -0x1.0c03dd7f2adabp+2,  -0x1.f53a34p-2, INEXACT)
T(RN,    0x1.023b6c880b816p+3,   -0x1.23fdd49808a87p+2,  -0x1.c46338p-2, INEXACT)
T(RN,    0x1.01a32727d1046p+3,   -0x1.405a01096b11ep+2,   0x1.d82186p-2, INEXACT)
T(RN,    0x1.010b3b919fe66p+3,   -0x1.6271b9324902ap+2,  -0x1.a5928cp-2, INEXACT)
T(RN,    0x1.0073a990860aap+3,   -0x1.8c3c231771e7ap+2,   0x1.fd463ap-2, INEXACT)
T(RN,    0x1.ffb8e1df611a8p+2,   -0x1.c0b3fb79a99ddp+2,    0x1.ea445p-2, INEXACT)
T(RN,    0x1.fe8b22f4d7609p+2,   -0x1.024be5c682142p+3,    0x1.bfad8p-2, INEXACT)
T(RN,    0x1.fd5e15f84593ap+2,   -0x1.2ff94b9a2e8ccp+3,   0x1.c624c8p-2, INEXACT)
T(RN,    0x1.fc31ba80c060fp+2,   -0x1.70ca231612064p+3,  -0x1.da6d38p-2, INEXACT)
T(RN,    0x1.fb0610259a555p+2,    -0x1.d40b3ba348bap+3,  -0x1.a4735cp-2, INEXACT)
T(RN,    0x1.f9db167e63b6cp+2,   -0x1.3fa26e6166dcep+4,     0x1.d1cfp-2, INEXACT)
T(RN,    0x1.f8b0cd22ea5f3p+2,   -0x1.f6d348d01becep+4,  -0x1.fb8fecp-2, INEXACT)
T(RN,    0x1.f78733ab399b8p+2,   -0x1.251ec6d0e7b77p+6,  -0x1.b4834cp-2, INEXACT)
T(RN,    0x1.f65e49af9a037p+2,    0x1.bebfa1fc564b8p+7,  -0x1.e904d4p-2, INEXACT)
T(RN,    0x1.f5360ec891584p+2,    0x1.6297f78693be6p+5,   0x1.e70196p-2, INEXACT)
T(RN,    0x1.f40e828ee25f2p+2,    0x1.89e92bdcdf316p+4,  -0x1.e9fe3cp-2, INEXACT)
T(RN,    0x1.f2e7a49b8cbdep+2,    0x1.10c19ff41599ap+4,  -0x1.caea34p-2, INEXACT)
T(RN,    0x1.f1c17487ccd77p+2,     0x1.a137379a1502p+3,  -0x1.9a94c2p-2, INEXACT)
T(RN,    0x1.f09bf1ed1ba5fp+2,    0x1.51bf383baeb14p+3,   0x1.9c5ff8p-2, INEXACT)
T(RN,    0x1.ef771c652e9a4p+2,    0x1.1ba8a17a4b55fp+3,  -0x1.f0d53ap-2, INEXACT)
T(RN,    0x1.ee52f389f7751p+2,    0x1.e8e3bee8a468bp+2,   0x1.d49c3cp-2, INEXACT)
T(RN,     0x1.ed2f76f5a424p+2,    0x1.ad63ad379d03fp+2,   0x1.9e4552p-2, INEXACT)
T(RN,    0x1.ec0ca6429ea87p+2,    0x1.7ead1f0c9c267p+2,  -0x1.f6e0fep-2, INEXACT)
T(RN,    0x1.eaea810b8cd94p+2,    0x1.5901be7eb6aa9p+2,   0x1.9a2eccp-2, INEXACT)
T(RN,    0x1.e9c906eb505fdp+2,    0x1.39f807be12f3cp+2,   0x1.a8c43ep-2, INEXACT)
T(RN,    0x1.e8a8377d067e5p+2,    0x1.1ff024cb82077p+2,  -0x1.e1539cp-2, INEXACT)
T(RN,    0x1.e788125c07f71p+2,    0x1.09c7ce7aa5da6p+2,  -0x1.d08454p-2, INEXACT)
T(RN,    0x1.e6689723e8e59p+2,    0x1.ed5c782cce8f7p+1,  -0x1.a11c22p-2, INEXACT)
T(RN,    0x1.e549c570789c8p+2,    0x1.cc12d3fda82d7p+1,    0x1.b90f8p-2, INEXACT)
T(RN,    0x1.e42b9cddc182ap+2,    0x1.aeca7d8207e35p+1,  -0x1.aad63ep-2, INEXACT)
T(RN,    0x1.e30e1d0808eeep+2,    0x1.94d11a84f0a88p+1,   0x1.9a42b8p-2, INEXACT)
T(RN,    0x1.e1f1458bcf0dep+2,    0x1.7d9b6850c9ca2p+1,   0x1.fc3f4ap-2, INEXACT)
T(RN,    0x1.e0d51605ceac4p+2,    0x1.68bb13f7599aep+1,   0x1.f30a18p-2, INEXACT)
T(RN,    0x1.dfb98e12fd27ep+2,    0x1.55d794fdcfa8cp+1,  -0x1.e00f36p-2, INEXACT)
T(RN,    0x1.de9ead508a439p+2,    0x1.44a90c9dd3515p+1,  -0x1.ffda9ep-2, INEXACT)
T(RN,    0x1.dd84735be006dp+2,    0x1.34f4871147342p+1,     0x1.b1edp-2, INEXACT)
T(RN,    0x1.dc6adfd2a29b4p+2,    0x1.2689344da731ap+1,  -0x1.c00176p-2, INEXACT)
T(RN,    0x1.db51f252b0284p+2,    0x1.193e50c02d521p+1,  -0x1.afdfdap-2, INEXACT)
T(RN,    0x1.da39aa7a20b71p+2,    0x1.0cf18d3e649a6p+1,   0x1.ffa148p-2, INEXACT)
T(RN,    0x1.d92207e746075p+2,     0x1.0185d43e6699p+1,   0x1.b400ccp-2, INEXACT)
T(RN,    0x1.d80b0a38ab748p+2,    0x1.edc4a8bfd8b7dp+0,   -0x1.ee6f4p-2, INEXACT)
T(RN,    0x1.d6f4b10d15d22p+2,     0x1.d9e37e31a28cp+0,   0x1.cec4fep-2, INEXACT)
T(RN,    0x1.d5defc038347ep+2,    0x1.c7435e14f0bf2p+0,  -0x1.a3ce24p-2, INEXACT)
T(RN,    0x1.d4c9eabb2b316p+2,    0x1.b5c459a4df7c2p+0,   0x1.c5397ap-2, INEXACT)
T(RN,    0x1.d3b57cd37dfd1p+2,    0x1.a54a97047a07ep+0,   0x1.f804f8p-2, INEXACT)
T(RN,    0x1.d2a1b1ec2508cp+2,    0x1.95bdaf37d2fbdp+0,   0x1.b4b444p-2, INEXACT)
T(RN,    0x1.d18e89a502813p+2,    0x1.8708295a5626fp+0,   0x1.fa70b8p-2, INEXACT)
T(RN,    0x1.d07c039e31408p+2,    0x1.79170d185fc7bp+0,  -0x1.c0095cp-2, INEXACT)
T(RN,    0x1.cf6a1f7804ac3p+2,    0x1.6bd987cd65297p+0,   0x1.cea0cap-2, INEXACT)
T(RN,    0x1.ce58dcd308962p+2,    0x1.5f40a0ad02651p+0,   0x1.d24f1ep-2, INEXACT)
T(RN,    0x1.cd483b5001172p+2,    0x1.533ef92335877p+0,   0x1.b016eep-2, INEXACT)
T(RN,    0x1.cc383a8fea70fp+2,    0x1.47c8972f70b2dp+0,  -0x1.d149a4p-2, INEXACT)
T(RN,    0x1.cb28da33f8eb8p+2,    0x1.3cd2b7f2d551cp+0,  -0x1.f8de04p-2, INEXACT)
T(RN,    0x1.ca1a19dd98b68p+2,    0x1.3253a9047ea68p+0,  -0x1.ba0fc2p-2, INEXACT)
T(RN,    0x1.c90bf92e6dc41p+2,    0x1.2842a7659101bp+0,   0x1.ab7448p-2, INEXACT)
T(RN,    0x1.c7fe77c853abdp+2,    0x1.1e97c3267e04ep+0,   0x1.a44eacp-2, INEXACT)
T(RN,    0x1.c6f1954d5d8abp+2,    0x1.154bc6fb0e73ep+0,  -0x1.dcf31ap-2, INEXACT)
T(RN,    0x1.c5e5515fd5dacp+2,    0x1.0c58231de9c18p+0,  -0x1.c5dd56p-2, INEXACT)
T(RN,    0x1.c4d9aba23e5c2p+2,    0x1.03b6db007dc84p+0,   0x1.f258ccp-2, INEXACT)
T(RN,    0x1.c3cea3b74fef3p+2,    0x1.f6c4eab5aaecap-1,  -0x1.cf1aeap-2, INEXACT)
T(RN,    0x1.c2c43941fa74ap+2,    0x1.e6abdc8296a23p-1,  -0x1.f85ac8p-2, INEXACT)
T(RN,    0x1.c1ba6be564adbp+2,    0x1.d71955e9e67fdp-1,   0x1.c2bc96p-2, INEXACT)
T(RN,    0x1.c0b13b44ec1bap+2,    0x1.c804de5f97f48p-1,   0x1.fdb5c4p-2, INEXACT)
T(RN,    0x1.bfa8a70424df2p+2,    0x1.b966a76f9b1b2p-1,  -0x1.a6f31ap-2, INEXACT)
T(RN,    0x1.bea0aec6d9989p+2,    0x1.ab377c1859fd4p-1,  -0x1.d3202cp-2, INEXACT)
T(RN,    0x1.bd9952310b477p+2,    0x1.9d70b20e06928p-1,  -0x1.e803d4p-2, INEXACT)
T(RN,    0x1.bc9290e6f12aep+2,    0x1.900c1ca669218p-1,  -0x1.ef81e2p-2, INEXACT)
T(RN,    0x1.bb8c6a8cf8a09p+2,    0x1.8304013662b55p-1,  -0x1.ef53d8p-2, INEXACT)
T(RN,    0x1.ba86dec7c5065p+2,    0x1.76530cb246bebp-1,   0x1.cc05d2p-2, INEXACT)
T(RN,    0x1.b981ed3c2f8e1p+2,    0x1.69f44a68d8032p-1,  -0x1.9b8076p-2, INEXACT)
T(RN,    0x1.b87d958f47551p+2,    0x1.5de31bb657629p-1,  -0x1.b6f91ap-2, INEXACT)
T(RN,    0x1.b779d76650d7dp+2,    0x1.521b3091c3ffcp-1,  -0x1.dfeffap-2, INEXACT)
T(RN,    0x1.b676b266c63dep+2,    0x1.469880da8fe69p-1,  -0x1.a33e44p-2, INEXACT)
T(RN,    0x1.b57426365705ap+2,    0x1.3b57465055d08p-1,  -0x1.c0a714p-2, INEXACT)
T(RN,    0x1.b472327ae7ee6p+2,    0x1.3053f72124c6bp-1,   0x1.ea0be6p-2, INEXACT)
T(RN,    0x1.b370d6da92d98p+2,    0x1.258b40fd68772p-1,  -0x1.e74448p-2, INEXACT)
T(RN,    0x1.b27012fba6ab6p+2,    0x1.1afa04a29da7dp-1,   -0x1.bc498p-2, INEXACT)
T(RN,    0x1.b16fe684a72bdp+2,    0x1.109d51cfd9aa1p-1,  -0x1.d2aa94p-2, INEXACT)
T(RN,     0x1.b070511c4ce6p+2,    0x1.06726398c282fp-1,   0x1.ed1764p-2, INEXACT)
T(RN,    0x1.af715269850aep+2,    0x1.f8ed3a19ea30cp-2,   0x1.fd820ep-2, INEXACT)
T(RN,    0x1.ae72ea137151cp+2,    0x1.e54f0c560db91p-2,  -0x1.c19cf2p-2, INEXACT)
T(RN,    0x1.ad7517c167d8bp+2,    0x1.d205922eb1dd4p-2,   0x1.e6bd06p-2, INEXACT)
T(RN,    0x1.ac77db1af304fp+2,    0x1.bf0c5f1fb1041p-2,   0x1.b2d6cap-2, INEXACT)
T(RN,    0x1.ab7b33c7d167fp+2,    0x1.ac5f412d21da2p-2,   0x1.e1b95ap-2, INEXACT)
T(RN,    0x1.aa7f216ff59aap+2,    0x1.99fa3c9b443d7p-2,  -0x1.9b7acap-2, INEXACT)
T(RN,    0x1.a983a3bb86233p+2,    0x1.87d987ff917fep-2,  -0x1.b06432p-2, INEXACT)
T(RN,    0x1.a888ba52dd554p+2,    0x1.75f988a2548ffp-2,  -0x1.fa9a94p-2, INEXACT)
T(RN,    0x1.a78e64de8932ep+2,    0x1.6456cf291c60cp-2,  -0x1.bd20fap-2, INEXACT)
T(RN,    0x1.a694a3074b4f1p+2,    0x1.52ee14832a419p-2,   0x1.d2c626p-2, INEXACT)
T(RN,    0x1.a59b747618adap+2,    0x1.41bc3711b4b06p-2,  -0x1.d4b824p-2, INEXACT)
T(RN,     0x1.a4a2d8d419a7p+2,    0x1.30be380679b7fp-2,  -0x1.e3113ap-2, INEXACT)
T(RN,     0x1.a3aacfcaa9c8p+2,    0x1.1ff138f3a9f58p-2,  -0x1.b57a74p-2, INEXACT)
T(RN,    0x1.a2b3590357b4dp+2,    0x1.0f527988b533dp-2,  -0x1.ab8418p-2, INEXACT)
T(RN,    0x1.a1bc7427e50a6p+2,    0x1.fdbeaaefe2382p-3,  -0x1.a6ee74p-2, INEXACT)
T(RN,    0x1.a0c620e24641cp+2,     0x1.dd2a8502ede9p-3,   0x1.e55a72p-2, INEXACT)
T(RN,    0x1.9fd05edca28efp+2,    0x1.bce39d3fdb1b7p-3,   0x1.9cd114p-2, INEXACT)
T(RN,    0x1.9edb2dc153c74p+2,    0x1.9ce53ca889bafp-3,   -0x1.ea59dp-2, INEXACT)
T(RN,    0x1.9de68d3ae63e6p+2,    0x1.7d2ad61b5ad32p-3,    0x1.fe904p-2, INEXACT)
T(RN,    0x1.9cf27cf418ae6p+2,    0x1.5db00356ae23fp-3,  -0x1.d077dcp-2, INEXACT)
T(RN,    0x1.9bfefc97dc13ep+2,    0x1.3e70822b7083cp-3,  -0x1.c46066p-2, INEXACT)
T(RN,    0x1.9b0c0bd153962p+2,    0x1.1f6831daa7ce6p-3,   0x1.b26af2p-2, INEXACT)
T(RN,    0x1.9a19aa4bd463fp+2,    0x1.0093109a3d32ep-3,   0x1.9d14f8p-2, INEXACT)
T(RN,    0x1.9927d7b2e59eep+2,    0x1.c3da727b3b338p-4,   0x1.bc397cp-2, INEXACT)
T(RN,    0x1.983693b240306p+2,     0x1.86e5c1fe1096p-4,   0x1.9a298ep-2, INEXACT)
T(RN,    0x1.9745ddf5ceb88p+2,    0x1.4a40aacd5ef99p-4,   0x1.e69874p-2, INEXACT)
T(RN,    0x1.9655b629ad6b3p+2,    0x1.0de3f499fa076p-4,  -0x1.d5cb92p-2, INEXACT)
T(RN,    0x1.95661bfa29f41p+2,    0x1.a3911fd627f48p-5,  -0x1.b7a7c8p-2, INEXACT)
T(RN,    0x1.94770f13c3593p+2,    0x1.2bcf25020bc8bp-5,   0x1.c4d97ep-2, INEXACT)
T(RN,    0x1.93888f2329dd9p+2,    0x1.68e8cf82e685ap-6,   0x1.b5dec2p-2, INEXACT)
T(RN,    0x1.929a9bd53ee4dp+2,    0x1.eb9ca03c91cc2p-8,   0x1.9999a2p-2, INEXACT)
T(RN,    0x1.91ad34d714d51p+2,   -0x1.ca039d657c008p-8,   0x1.9be258p-2, INEXACT)
T(RN,    0x1.90c059d5eefd4p+2,   -0x1.5f6938e64d277p-6,   0x1.c4a28ap-2, INEXACT)
T(RN,    0x1.8fd40a7f4172ep+2,   -0x1.25f5a8e812758p-5,   0x1.d746ccp-2, INEXACT)
T(RN,    0x1.8ee84680b0f93p+2,    -0x1.9c1036eb15d5p-5,   0x1.aa16d4p-2, INEXACT)
T(RN,    0x1.8dfd0d8812e46p+2,   -0x1.0908629aa1594p-4,  -0x1.b5ebbep-2, INEXACT)
T(RN,    0x1.8d125f436cfb4p+2,   -0x1.4401dc65d9b1ep-4,   0x1.c7d4c8p-2, INEXACT)
T(RN,    0x1.8c283b60f55bcp+2,   -0x1.7efab129f51d2p-4,  -0x1.b07e9ap-2, INEXACT)
T(RN,    0x1.8b3ea18f125eap+2,   -0x1.b9f901a77fd34p-4,    0x1.d3632p-2, INEXACT)
T(RN,    0x1.8a55917c5a78dp+2,   -0x1.f502e9a03c214p-4,  -0x1.bf129cp-2, INEXACT)
T(RN,    0x1.896d0ad794251p+2,   -0x1.180f41315c1e5p-3,  -0x1.d97f6ap-2, INEXACT)
T(RN,    0x1.88850d4fb5be3p+2,   -0x1.35a8f2a82fb5ep-3,  -0x1.dc0c48p-2, INEXACT)
T(RN,    0x1.879d9893e56aap+2,   -0x1.535197301ea9ap-3,  -0x1.f9cf84p-2, INEXACT)
T(RN,    0x1.86b6ac5378fd4p+2,   -0x1.710c3f5058d7dp-3,   0x1.ac3b0ap-2, INEXACT)
T(RN,    0x1.85d0483df5dadp+2,   -0x1.8edbff5d2197ep-3,  -0x1.def108p-2, INEXACT)
T(RN,     0x1.84ea6c0310dbp+2,   -0x1.acc3f0bae28e7p-3,   0x1.f2cf9ep-2, INEXACT)
T(RN,    0x1.84051752ae2ecp+2,   -0x1.cac7332400661p-3,  -0x1.b0834ap-2, INEXACT)
T(RN,    0x1.832049dce1442p+2,   -0x1.e8e8edf28ecf4p-3,   0x1.becda2p-2, INEXACT)
T(RN,    0x1.823c0351eca8cp+2,   -0x1.039628b78237cp-2,   0x1.a7b994p-2, INEXACT)
T(RN,    0x1.8158436241f45p+2,   -0x1.12ca4c128a247p-2,  -0x1.f93198p-2, INEXACT)
T(RN,    0x1.807509be81a0bp+2,   -0x1.2212841fef5ccp-2,  -0x1.a1da4ep-2, INEXACT)
T(RN,    0x1.7f9256177af9dp+2,   -0x1.31707a775656ap-2,   0x1.c24684p-2, INEXACT)
T(RN,     0x1.7eb0281e2bfdp+2,   -0x1.40e5dfe9bf04ep-2,  -0x1.9dc638p-2, INEXACT)
T(RN,     0x1.7dce7f83c13ep+2,   -0x1.50746d3e5cc08p-2,  -0x1.d375aep-2, INEXACT)
T(RN,    0x1.7ced5bf995cc4p+2,   -0x1.601de3f5af9c8p-2,   0x1.ffd5bcp-2, INEXACT)
T(RN,    0x1.7c0cbd3133165p+2,   -0x1.6fe40f1398821p-2,   0x1.b0596ap-2, INEXACT)
T(RN,    0x1.7b2ca2dc50cf5p+2,   -0x1.7fc8c3f12b219p-2,   -0x1.9a44ap-2, INEXACT)
T(RN,    0x1.7a4d0cacd4d33p+2,   -0x1.8fcde3170c9d1p-2,  -0x1.b7c21cp-2, INEXACT)
T(RN,    0x1.796dfa54d30c7p+2,   -0x1.9ff559213a257p-2,  -0x1.c8b304p-2, INEXACT)
T(RN,    0x1.788f6b868d585p+2,   -0x1.b0411fad21693p-2,   0x1.eb2ffep-2, INEXACT)
T(RN,    0x1.77b15ff4736a4p+2,   -0x1.c0b33e530450fp-2,    0x1.a25ccp-2, INEXACT)
T(RN,    0x1.76d3d75122b41p+2,   -0x1.d14dcbabb2d0ap-2,  -0x1.a66502p-2, INEXACT)
T(RN,    0x1.75f6d14f66484p+2,    -0x1.e212ee63ba64p-2,  -0x1.b21216p-2, INEXACT)
T(RN,    0x1.751a4da236c06p+2,   -0x1.f304de5d3f0aep-2,  -0x1.a3bdbap-2, INEXACT)
T(RN,    0x1.743e4bfcba20ep+2,   -0x1.0212f2f0e5788p-1,   0x1.b3ac74p-2, INEXACT)
T(RN,     0x1.7362cc1243c3p+2,   -0x1.0abc3172bdbfdp-1,  -0x1.c3a7c2p-2, INEXACT)
T(RN,    0x1.7287cd9654306p+2,   -0x1.137f642e893b9p-1,   -0x1.c8929p-2, INEXACT)
T(RN,    0x1.71ad503c9912dp+2,   -0x1.1c5dcfd447187p-1,  -0x1.a81434p-2, INEXACT)
T(RN,    0x1.70d353b8ed147p+2,   -0x1.2558c50a0b03fp-1,   0x1.cec6c4p-2, INEXACT)
T(RN,    0x1.6ff9d7bf57c4dp+2,   -0x1.2e71a13895e65p-1,  -0x1.c596a6p-2, INEXACT)
T(RN,    0x1.6f20dc040d7fep+2,   -0x1.37a9cf6520d84p-1,  -0x1.b4336ap-2, INEXACT)
T(RN,    0x1.6e48603b6f555p+2,   -0x1.4102c91982cc6p-1,   0x1.a9cd9cp-2, INEXACT)
T(RN,    0x1.6d70641a0a992p+2,   -0x1.4a7e175bf8be2p-1,  -0x1.99999ap-2, INEXACT)
T(RN,    0x1.6c98e7549a5d6p+2,   -0x1.541d53b7d9844p-1,   0x1.c846a8p-2, INEXACT)
T(RN,    0x1.6bc1e9a004388p+2,   -0x1.5de2295904dcdp-1,   -0x1.e74f2p-2, INEXACT)
T(RN,    0x1.6aeb6ab15b46fp+2,   -0x1.67ce563b3c6e2p-1,  -0x1.9f4bbep-2, INEXACT)
T(RN,    0x1.6a156a3dde871p+2,   -0x1.71e3ac6fb6f58p-1,  -0x1.fed916p-2, INEXACT)
T(RN,    0x1.693fe7faf9083p+2,   -0x1.7c24137aa87b6p-1,   0x1.bedf3cp-2, INEXACT)
T(RN,    0x1.686ae39e41d59p+2,   -0x1.869189cb10212p-1,  -0x1.b9cecap-2, INEXACT)
T(RN,    0x1.67965cdd7bdbdp+2,   -0x1.912e264f3cc36p-1,  -0x1.bb1526p-2, INEXACT)
T(RN,    0x1.66c2536e95cccp+2,   -0x1.9bfc1a28be641p-1,   0x1.fc34d4p-2, INEXACT)
T(RN,    0x1.65eec707aa087p+2,   -0x1.a6fdb282c44dep-1,  -0x1.a89e9ap-2, INEXACT)
T(RN,    0x1.651bb75efe80dp+2,   -0x1.b2355a8e3c1cfp-1,   0x1.d9015cp-2, INEXACT)
T(RN,    0x1.6449242b04a11p+2,   -0x1.bda59da7629bdp-1,   0x1.aa0bccp-2, INEXACT)
T(RN,    0x1.63770d2259375p+2,   -0x1.c95129a8e1819p-1,   0x1.eaa35cp-2, INEXACT)
T(RN,     0x1.62a571fbc453p+2,   -0x1.d53ad1710d06bp-1,  -0x1.ec28ecp-2, INEXACT)
T(RN,    0x1.61d4526e3933fp+2,   -0x1.e1658f9e58a61p-1,   0x1.fce74ep-2, INEXACT)
T(RN,    0x1.6103ae30d62b4p+2,   -0x1.edd48988b61b5p-1,  -0x1.b4fecep-2, INEXACT)
T(RN,    0x1.603384fae4847p+2,   -0x1.fa8b127e3ba28p-1,  -0x1.a21c9ep-2, INEXACT)
T(RN,    0x1.5f63d683d86c1p+2,   -0x1.03c657a51a5efp+0,   -0x1.f060ap-2, INEXACT)
T(RN,    0x1.5e94a28350d58p+2,   -0x1.0a6e8d074fcecp+0,  -0x1.f4f6d4p-2, INEXACT)
T(RN,    0x1.5dc5e8b117616p+2,   -0x1.1140233c8c0c4p+0,   0x1.9d722cp-2, INEXACT)
T(RN,    0x1.5cf7a8c520462p+2,   -0x1.183d332eaa1fcp+0,   0x1.cd760cp-2, INEXACT)
T(RN,    0x1.5c29e2778a353p+2,   -0x1.1f67f760521dap+0,   0x1.b8258ep-2, INEXACT)
T(RN,    0x1.5b5c95809e437p+2,   -0x1.26c2ceb1b2469p+0,  -0x1.d32efcp-2, INEXACT)
T(RN,    0x1.5a8fc198cfcedp+2,   -0x1.2e503f6b84eecp+0,   0x1.b76b08p-2, INEXACT)
T(RN,    0x1.59c36678bc654p+2,   -0x1.3612fa98b36a1p+0,  -0x1.c154d2p-2, INEXACT)
T(RN,    0x1.58f783d92baebp+2,   -0x1.3e0ddfb80a598p+0,  -0x1.d2b2acp-2, INEXACT)
T(RN,    0x1.582c19730f4f9p+2,   -0x1.464400d0c6329p+0,  -0x1.e74948p-2, INEXACT)
T(RN,    0x1.576126ff82d43p+2,   -0x1.4eb8a6f645d7ep+0,  -0x1.a9693ap-2, INEXACT)
T(RN,    0x1.5696ac37cb95bp+2,   -0x1.576f5748fa3aep+0,  -0x1.e2709cp-2, INEXACT)
T(RN,    0x1.55cca8d558a2fp+2,   -0x1.606bd884bc7efp+0,  -0x1.df2e24p-2, INEXACT)
T(RN,     0x1.55031c91c2a6p+2,   -0x1.69b2392f22214p+0,  -0x1.9d8152p-2, INEXACT)
T(RN,    0x1.543a0726cbcdfp+2,   -0x1.7346d67b3e4f5p+0,   0x1.bf9abcp-2, INEXACT)
T(RN,    0x1.5371684e5fb34p+2,    -0x1.7d2e63fb9889p+0,   0x1.e84242p-2, INEXACT)
T(RN,    0x1.52a93fc29343dp+2,   -0x1.876df43f11132p+0,  -0x1.b03b0ep-2, INEXACT)
T(RN,    0x1.51e18d3da4a5dp+2,   -0x1.920b027a17039p+0,   0x1.de92dcp-2, INEXACT)
T(RN,    0x1.511a5079fb224p+2,   -0x1.9d0b7d631a8cep+0,   0x1.c3432ep-2, INEXACT)
T(RN,    0x1.5053893227019p+2,   -0x1.a875d36fbe4dcp+0,  -0x1.9c117ep-2, INEXACT)
T(RN,    0x1.4f8d3720e1aabp+2,   -0x1.b45100a822c32p+0,   0x1.fc02b6p-2, INEXACT)
T(RN,    0x1.4ec75a010d19dp+2,   -0x1.c0a49e4f2804fp+0,   0x1.e8ee54p-2, INEXACT)
T(RN,    0x1.4e01f18db42c9p+2,   -0x1.cd78f4a9b76d5p+0,  -0x1.9b5c7cp-2, INEXACT)
T(RN,    0x1.4d3cfd820a945p+2,   -0x1.dad70f3d03fa7p+0,    0x1.a5ee4p-2, INEXACT)
T(RN,    0x1.4c787d996c44ep+2,   -0x1.e8c8d3ec45061p+0,  -0x1.e1982cp-2, INEXACT)
T(RN,    0x1.4bb4718f5ddf9p+2,   -0x1.f7591d7291d4bp+0,   0x1.c30914p-2, INEXACT)
T(RN,    0x1.4af0d91f8c5a3p+2,   -0x1.0349ece742893p+1,  -0x1.b292bap-2, INEXACT)
T(RN,    0x1.4a2db405ccf55p+2,   -0x1.0b4316a9caf3bp+1,  -0x1.d90ea2p-2, INEXACT)
T(RN,    0x1.496b01fe1d231p+2,   -0x1.139f4d9d66e7cp+1,  -0x1.9dd8f4p-2, INEXACT)
T(RN,    0x1.48a8c2c4a26fdp+2,   -0x1.1c669a5d98f48p+1,  -0x1.ad5174p-2, INEXACT)
T(RN,    0x1.47e6f615aa6afp+2,   -0x1.25a1e7f6433c3p+1,   0x1.aab81cp-2, INEXACT)
T(RN,    0x1.47259badaa904p+2,   -0x1.2f5b240021778p+1,   0x1.a7835cp-2, INEXACT)
T(RN,    0x1.4664b349402ccp+2,   -0x1.399d645c7adb6p+1,    0x1.cb152p-2, INEXACT)
T(RN,     0x1.45a43ca5304bp+2,   -0x1.447513bede9abp+1,   0x1.cea086p-2, INEXACT)
T(RN,    0x1.44e4377e679a3p+2,   -0x1.4ff0267ed25ebp+1,    0x1.f80e8p-2, INEXACT)
T(RN,    0x1.4424a391fa57ap+2,   -0x1.5c1e598c08545p+1,  -0x1.a3c896p-2, INEXACT)
T(RN,    0x1.4365809d2434ap+2,   -0x1.69117ddd21e5ep+1,  -0x1.e9e88ep-2, INEXACT)
T(RN,    0x1.42a6ce5d4843fp+2,   -0x1.76ddd35503c74p+1,  -0x1.d0c79ap-2, INEXACT)
T(RN,    0x1.41e88c8ff0ddap+2,   -0x1.859a76f2f938dp+1,   0x1.c77d28p-2, INEXACT)
T(RN,    0x1.412abaf2cf8aep+2,   -0x1.9561e941762d9p+1,   0x1.afb7cep-2, INEXACT)
T(RN,    0x1.406d5943bceefp+2,    -0x1.a652b3796513p+1,  -0x1.d9141cp-2, INEXACT)
T(RN,    0x1.3fb06740b8adap+2,   -0x1.b89033db8cb38p+1,   0x1.c68cb8p-2, INEXACT)
T(RN,    0x1.3ef3e4a7e9582p+2,   -0x1.cc439c8f69a85p+1,   -0x1.a358fp-2, INEXACT)
T(RN,    0x1.3e37d1379c51ep+2,   -0x1.e19d343a4c63fp+1,   0x1.a69e94p-2, INEXACT)
T(RN,    0x1.3d7c2cae45bc7p+2,   -0x1.f8d5ecf74e6aep+1,   0x1.ec6a46p-2, INEXACT)
T(RN,     0x1.3cc0f6ca8061p+2,   -0x1.0918b70ef8945p+2,   0x1.edf2f2p-2, INEXACT)
T(RN,    0x1.3c062f4b0d8ebp+2,   -0x1.17005c3ee0addp+2,   0x1.9b77aep-2, INEXACT)
T(RN,    0x1.3b4bd5eed52ecp+2,   -0x1.2652ce95c4466p+2,   0x1.dd2d36p-2, INEXACT)
T(RN,    0x1.3a91ea74e55c6p+2,   -0x1.374babc789e3ep+2,  -0x1.a40342p-2, INEXACT)
T(RN,    0x1.39d86c9c729efp+2,   -0x1.4a3460608154cp+2,   -0x1.f4de9p-2, INEXACT)
T(RN,    0x1.391f5c24d7aa4p+2,   -0x1.5f68662b4e1eep+2,  -0x1.ef5858p-2, INEXACT)
T(RN,    0x1.3866b8cd9550cp+2,   -0x1.775b2d7ff7da1p+2,  -0x1.b695eep-2, INEXACT)
T(RN,    0x1.37ae8256526d8p+2,   -0x1.92a082eb94687p+2,  -0x1.ff0ab4p-2, INEXACT)
T(RN,    0x1.36f6b87edbcbfp+2,   -0x1.b1f8c0e5de997p+2,  -0x1.9bab3cp-2, INEXACT)
T(RN,    0x1.363f5b0724171p+2,   -0x1.d662f8314dc41p+2,   -0x1.b1599p-2, INEXACT)
T(RN,    0x1.358869af43b7bp+2,   -0x1.009c619f38cdcp+3,  -0x1.9db54ap-2, INEXACT)
T(RN,    0x1.34d1e43778cb3p+2,   -0x1.1a2d2ddefadddp+3,  -0x1.ee1b4ap-2, INEXACT)
T(RN,    0x1.341bca6027052p+2,   -0x1.393b9ce32f4d3p+3,  -0x1.e374aap-2, INEXACT)
T(RN,    0x1.33661be9d79b1p+2,   -0x1.5fc5b2976f59ep+3,   -0x1.af49ep-2, INEXACT)
T(RN,     0x1.32b0d8953931p+2,   -0x1.90e21c4b2d9c1p+3,  -0x1.b1f96ap-2, INEXACT)
T(RN,    0x1.31fc00231fbe3p+2,   -0x1.d1a00c78d83fdp+3,   -0x1.9e2b6p-2, INEXACT)
T(RN,    0x1.31479254847b5p+2,   -0x1.15730229a1958p+4,  -0x1.a8860cp-2, INEXACT)
T(RN,    0x1.30938eea85cb7p+2,   -0x1.56f8cab912c5bp+4,   0x1.aef14cp-2, INEXACT)
T(RN,    0x1.2fdff5a667264p+2,   -0x1.c08ca3236b864p+4,   0x1.aa1114p-2, INEXACT)
T(RN,    0x1.2f2cc64991005p+2,   -0x1.4392e70f6649dp+5,  -0x1.d9f8cap-2, INEXACT)
T(RN,    0x1.2e7a009590b77p+2,   -0x1.21ae28c47a7c4p+6,    0x1.e08a9p-2, INEXACT)
T(RN,    0x1.2dc7a44c187d7p+2,   -0x1.56535a341b712p+8,   0x1.a908bep-2, INEXACT)
T(RN,    0x1.2d15b12eff3efp+2,    0x1.f7c4929cffe9ap+6,   0x1.a90bf8p-2, INEXACT)
T(RN,    0x1.2c64270040923p+2,    0x1.aa05a1bb217f7p+5,    0x1.fd7f7p-2, INEXACT)
T(RN,    0x1.2bb30581fc9d9p+2,    0x1.0e4e83bd09cb9p+5,   0x1.def442p-2, INEXACT)
T(RN,    0x1.2b024c7678048p+2,    0x1.8c151a99010c4p+4,   -0x1.ab2cfp-2, INEXACT)
T(RN,    0x1.2a51fba01bd19p+2,    0x1.389fa48ae4348p+4,  -0x1.f7eae8p-2, INEXACT)
T(RN,    0x1.29a212c1755f2p+2,    0x1.0244e45c1e97fp+4,  -0x1.c48372p-2, INEXACT)
T(RN,    0x1.28f2919d3644dp+2,    0x1.b8187285c514cp+3,   0x1.b98d54p-2, INEXACT)
T(RN,    0x1.284377f63440dp+2,    0x1.7f661155acad1p+3,    0x1.bde5bp-2, INEXACT)
T(RN,    0x1.2794c58f6920ap+2,    0x1.53a9d15ad55ffp+3,   0x1.fabfbcp-2, INEXACT)
T(RN,    0x1.26e67a2bf2afep+2,    0x1.30e4c921b165ep+3,  -0x1.c6fcdcp-2, INEXACT)
T(RN,    0x1.2638958f129f7p+2,     0x1.1495577498dap+3,  -0x1.beb048p-2, INEXACT)
T(RN,    0x1.258b177c2e725p+2,    0x1.fa29433f2bea1p+2,  -0x1.ada1eep-2, INEXACT)
T(RN,    0x1.24ddffb6cf677p+2,    0x1.d2814f95d0c52p+2,  -0x1.e8a436p-2, INEXACT)
T(RN,    0x1.24314e02a2656p+2,    0x1.b097c90d909fbp+2,   0x1.a6117ep-2, INEXACT)
T(RN,    0x1.2385022377e57p+2,    0x1.934140fab4429p+2,   0x1.b07518p-2, INEXACT)
T(RN,    0x1.22d91bdd43dd7p+2,    0x1.799e6b8edb6c2p+2,    0x1.d4ca5p-2, INEXACT)
T(RN,    0x1.222d9af41dac2p+2,    0x1.63055f2af60f6p+2,   -0x1.f75a6p-2, INEXACT)
T(RN,    0x1.21827f2c4002cp+2,    0x1.4ef286ad8c9a9p+2,   0x1.eb1bf8p-2, INEXACT)
T(RN,    0x1.20d7c84a08d29p+2,    0x1.3cfe662b5275cp+2,   0x1.abcfdep-2, INEXACT)
T(RN,    0x1.202d7611f936cp+2,    0x1.2cd67c240a826p+2,   0x1.e77d12p-2, INEXACT)
T(RN,     0x1.1f838848b535p+2,     0x1.1e383243ef08p+2,   0x1.99f486p-2, INEXACT)
T(RN,    0x1.1ed9feb304792p+2,    0x1.10ed33c310706p+2,   0x1.f9d536p-2, INEXACT)
T(RN,    0x1.1e30d915d0a44p+2,    0x1.04c8bb41fb74ap+2,    0x1.b7411p-2, INEXACT)
T(RN,    0x1.1d88173626d1ep+2,    0x1.f34b1e472f8cap+1,    0x1.ebd9fp-2, INEXACT)
T(RN,    0x1.1cdfb8d936b6cp+2,    0x1.dec8f60126074p+1,  -0x1.a82a0ap-2, INEXACT)
T(RN,    0x1.1c37bdc452bdbp+2,    0x1.cbd64858832e7p+1,   0x1.f6953ep-2, INEXACT)
T(RN,    0x1.1b9025bcefdd4p+2,    0x1.ba4642e3c5ffcp+1,  -0x1.eb7c12p-2, INEXACT)
T(RN,    0x1.1ae8f088a59b1p+2,    0x1.a9f28a250d409p+1,   0x1.df8f4ap-2, INEXACT)
T(RN,    0x1.1a421ded2dec2p+2,    0x1.9aba198a81137p+1,   0x1.f516d4p-2, INEXACT)
T(RN,    0x1.199badb06520bp+2,     0x1.8c805d8d863fp+1,  -0x1.fa3cf6p-2, INEXACT)
T(RN,    0x1.18f59f9849d2bp+2,    0x1.7f2c7ab39f49cp+1,   0x1.f1566ap-2, INEXACT)
T(RN,    0x1.184ff36afcceep+2,    0x1.72a8b78a53bf9p+1,   0x1.e3a114p-2, INEXACT)
T(RN,    0x1.17aaa8eec103ep+2,    0x1.66e20222f91e1p+1,   0x1.9a1096p-2, INEXACT)
T(RN,    0x1.1705bfe9fb6aap+2,    0x1.5bc78b596d5eep+1,    0x1.e0d0ap-2, INEXACT)
T(RN,    0x1.1661382332f4ap+2,    0x1.514a738157fb7p+1,   0x1.bc35fcp-2, INEXACT)
T(RN,    0x1.15bd116110767p+2,    0x1.475d851144d1cp+1,   0x1.9c42b6p-2, INEXACT)
T(RN,    0x1.15194b6a5e95bp+2,    0x1.3df4faa0fe769p+1,   0x1.ad91e8p-2, INEXACT)
T(RN,     0x1.1475e60609b4p+2,    0x1.35064e21476f2p+1,  -0x1.9f2a2cp-2, INEXACT)
T(RN,    0x1.13d2e0fb1fd96p+2,    0x1.2c880fa22bbd9p+1,    0x1.afe8ap-2, INEXACT)
T(RN,    0x1.13303c10d0a2fp+2,    0x1.2471c25312f67p+1,   0x1.b825eep-2, INEXACT)
T(RN,    0x1.128df70e6d2d6p+2,    0x1.1cbbbeaaac45bp+1,  -0x1.a297d2p-2, INEXACT)
T(RN,    0x1.11ec11bb6803fp+2,    0x1.155f18d9508cdp+1,  -0x1.a0e8e4p-2, INEXACT)
T(RN,    0x1.114a8bdf5508ap+2,    0x1.0e558ad1e87f8p+1,   -0x1.a859dp-2, INEXACT)
T(RN,    0x1.10a96541e963bp+2,    0x1.0799615650e1bp+1,   0x1.adb686p-2, INEXACT)
T(RN,    0x1.10089daafb6e2p+2,    0x1.01256b8e8147dp+1,   0x1.a2f7fep-2, INEXACT)
T(RN,    0x1.0f6834e282a16p+2,    0x1.f5e9d98db2f5bp+0,   0x1.f91e6ap-2, INEXACT)
T(RN,    0x1.0ec82ab0977e7p+2,    0x1.ea0720060c1eep+0,    0x1.d1daap-2, INEXACT)
T(RN,    0x1.0e287edd737e3p+2,    0x1.de9aba4188a92p+0,  -0x1.9c5926p-2, INEXACT)
T(RN,    0x1.0d89313170fe1p+2,    0x1.d39d5ea229345p+0,   0x1.99ad5ap-2, INEXACT)
T(RN,    0x1.0cea41750b293p+2,    0x1.c908596f4f9a2p+0,  -0x1.9b16fcp-2, INEXACT)
T(RN,    0x1.0c4baf70ddee5p+2,    0x1.bed57e0fdf65dp+0,  -0x1.ef5f5cp-2, INEXACT)
T(RN,    0x1.0bad7aeda5dc1p+2,    0x1.b4ff19fafd01ep+0,   0x1.e439a2p-2, INEXACT)
T(RN,     0x1.0b0fa3b4401dp+2,    0x1.ab7fe925354dep+0,   0x1.a571b2p-2, INEXACT)
T(RN,    0x1.0a72298daa5e3p+2,    0x1.a2530bb87b5d8p+0,   0x1.b5b638p-2, INEXACT)
T(RN,    0x1.09d50c4302bcfp+2,     0x1.9973fcecadefp+0,   0x1.e8742ep-2, INEXACT)
T(RN,    0x1.09384b9d87b1ap+2,    0x1.90de8adc668f9p+0,   0x1.eb3dfep-2, INEXACT)
T(RN,    0x1.089be76697ff4p+2,    0x1.888ecf36f1b92p+0,   -0x1.b88e5p-2, INEXACT)
T(RN,     0x1.07ffdf67b29fp+2,    0x1.808128b49e954p+0,   0x1.9ecc54p-2, INEXACT)
T(RN,    0x1.0764336a76af5p+2,    0x1.78b235363d0e1p+0,  -0x1.9a0c5ap-2, INEXACT)
T(RN,    0x1.06c8e338a35e9p+2,    0x1.711ecc7bba35dp+0,  -0x1.d1b59ap-2, INEXACT)
T(RN,    0x1.062dee9c17d33p+2,    0x1.69c3fb6070122p+0,  -0x1.9f630ap-2, INEXACT)
T(RN,    0x1.0593555ed32f4p+2,    0x1.629eff8e00fd3p+0,   0x1.f0e46ep-2, INEXACT)
T(RN,    0x1.04f9174af4567p+2,    0x1.5bad4398802f4p+0,  -0x1.e2080ap-2, INEXACT)
T(RN,    0x1.045f342aba00fp+2,    0x1.54ec5b785cc62p+0,   0x1.d11576p-2, INEXACT)
T(RN,    0x1.03c5abc882958p+2,    0x1.4e5a0157e5cebp+0,   0x1.c36a64p-2, INEXACT)
T(RN,    0x1.032c7deecc1a6p+2,    0x1.47f412ab83b39p+0,  -0x1.e2d78ap-2, INEXACT)
T(RN,    0x1.0293aa6834233p+2,    0x1.41b88d8ccfbddp+0,  -0x1.d25d4ep-2, INEXACT)
T(RN,    0x1.01fb30ff77be2p+2,    0x1.3ba58e51a09f9p+0,   0x1.e1df48p-2, INEXACT)
T(RN,    0x1.0163117f7362ap+2,    0x1.35b94d58f0e4bp+0,  -0x1.fa6654p-2, INEXACT)
T(RN,    0x1.00cb4bb322dc4p+2,    0x1.2ff21d0837313p+0,  -0x1.9cc53cp-2, INEXACT)
T(RN,    0x1.0033df65a139cp+2,    0x1.2a4e67f4653f4p+0,   -0x1.c37c2p-2, INEXACT)
T(RN,     0x1.ff3998c45177p+1,    0x1.24ccaf324af13p+0,  -0x1.fc3b0cp-2, INEXACT)
T(RN,    0x1.fe0c24e8257e1p+1,    0x1.1f6b88ca92d95p+0,   0x1.9f6cfep-2, INEXACT)
T(RN,    0x1.fcdf62cdaf5d3p+1,    0x1.1a299e4df73e1p+0,   0x1.ef2a1ep-2, INEXACT)
T(RN,    0x1.fbb3520c1ddb6p+1,    0x1.1505ab86aabcbp+0,   0x1.9d5fc6p-2, INEXACT)
T(RN,    0x1.fa87f23add8ecp+1,    0x1.0ffe7d4441b7fp+0,   0x1.b3939ep-2, INEXACT)
T(RN,    0x1.f95d42f198b6fp+1,    0x1.0b12f03fb1856p+0,   -0x1.e02bcp-2, INEXACT)
T(RN,    0x1.f83343c83719fp+1,    0x1.0641f0153a2e3p+0,  -0x1.f1b754p-2, INEXACT)
T(RN,    0x1.f709f456dddefp+1,    0x1.018a765247da1p+0,  -0x1.b9be98p-2, INEXACT)
T(RN,    0x1.f5e15435ef6adp+1,    0x1.f9d7132b165acp-1,  -0x1.e179f4p-2, INEXACT)
T(RN,    0x1.f4b962fe0b3bdp+1,      0x1.f0c8797f688p-1,     0x1.abaep-2, INEXACT)
T(RN,    0x1.f39220480dc56p+1,    0x1.e7e75c66c6e95p-1,   0x1.d83c26p-2, INEXACT)
T(RN,    0x1.f26b8bad10486p+1,     0x1.df320e460d57p-1,    0x1.a03f8p-2, INEXACT)
T(RN,    0x1.f145a4c668c1cp+1,    0x1.d6a6f5d6f2675p-1,   0x1.d6907ap-2, INEXACT)
T(RN,    0x1.f0206b2da9a2dp+1,    0x1.ce448cf4af027p-1,  -0x1.d97438p-2, INEXACT)
T(RN,    0x1.eefbde7ca1d08p+1,    0x1.c6095f7e27a31p-1,  -0x1.e1d652p-2, INEXACT)
T(RN,    0x1.edd7fe4d5c6e4p+1,    0x1.bdf40a4bd7a6ap-1,   0x1.b3ede2p-2, INEXACT)
T(RN,    0x1.ecb4ca3a20c12p+1,    0x1.b6033a37ed2e5p-1,   -0x1.e1cfcp-2, INEXACT)
T(RN,    0x1.eb9241dd72054p+1,     0x1.ae35ab37252cp-1,   -0x1.d00e6p-2, INEXACT)
T(RN,    0x1.ea7064d20f51bp+1,    0x1.a68a278119d09p-1,  -0x1.c6da3ap-2, INEXACT)
T(RN,    0x1.e94f32b2f371dp+1,    0x1.9eff86c6d19d5p-1,  -0x1.daf2dap-2, INEXACT)
T(RN,    0x1.e82eab1b54c1cp+1,    0x1.9794ad7679017p-1,    0x1.dfa5fp-2, INEXACT)
T(RN,    0x1.e70ecda6a50bap+1,    0x1.90488c0b48026p-1,  -0x1.b560a8p-2, INEXACT)
T(RN,    0x1.e5ef99f091671p+1,    0x1.891a1e68ab3fcp-1,   0x1.a7c602p-2, INEXACT)
T(RN,    0x1.e4d10f950211dp+1,    0x1.82086b3fdb03bp-1,   -0x1.f87eap-2, INEXACT)
T(RN,      0x1.e3b32e301a5p+1,    0x1.7b12837f1d7c4p-1,  -0x1.ea4256p-2, INEXACT)
T(RN,    0x1.e295f55e38486p+1,    0x1.743781ca00b12p-1,   0x1.c3e7cep-2, INEXACT)
T(RN,    0x1.e17964bbf4e0ep+1,    0x1.6d7689f9e7dedp-1,   0x1.9cc27ep-2, INEXACT)
T(RN,    0x1.e05d7be6239fbp+1,    0x1.66cec8a6552dbp-1,   -0x1.9a08dp-2, INEXACT)
T(RN,    0x1.df423a79d2828p+1,    0x1.603f72b4646b2p-1,   -0x1.e18a7p-2, INEXACT)
T(RN,    0x1.de27a01449df4p+1,    0x1.59c7c4ecf7419p-1,   0x1.d9bd06p-2, INEXACT)
T(RN,    0x1.dd0dac530c442p+1,    0x1.536703991cc74p-1,   0x1.ba556ep-2, INEXACT)
T(RN,    0x1.dbf45ed3d650fp+1,    0x1.4d1c7a244788ap-1,   0x1.b058b8p-2, INEXACT)
T(RN,    0x1.dadbb7349e97ep+1,    0x1.46e77ac3ee072p-1,   -0x1.a97ecp-2, INEXACT)
T(RN,    0x1.d9c3b5139579bp+1,    0x1.40c75e2438b9dp-1,   0x1.c02af4p-2, INEXACT)
T(RN,    0x1.d8ac580f25042p+1,    0x1.3abb8319680abp-1,  -0x1.edc3cep-2, INEXACT)
T(RN,    0x1.d7959fc5f0d03p+1,    0x1.34c34e55a3052p-1,  -0x1.ce5b3ep-2, INEXACT)
T(RN,    0x1.d67f8bd6d5e05p+1,    0x1.2ede2a22e5563p-1,  -0x1.c1424ep-2, INEXACT)
T(RN,    0x1.d56a1be0ea7d2p+1,    0x1.290b8620c8a22p-1,   0x1.b4009ap-2, INEXACT)
T(RN,    0x1.d4554f837e16bp+1,    0x1.234ad705ea49fp-1,   -0x1.e4b58p-2, INEXACT)
T(RN,    0x1.d341265e191e1p+1,    0x1.1d9b9664b2eacp-1,  -0x1.f89448p-2, INEXACT)
T(RN,    0x1.d22da0107ce8dp+1,    0x1.17fd427349ac7p-1,   0x1.eb8f96p-2, INEXACT)
T(RN,    0x1.d11abc3aa38c3p+1,    0x1.126f5dd680927p-1,  -0x1.fddb06p-2, INEXACT)
T(RN,    0x1.d0087a7cbfbc1p+1,    0x1.0cf16f6f8b2dfp-1,   0x1.babd82p-2, INEXACT)
T(RN,    0x1.cef6da773cab9p+1,    0x1.0783022c5406dp-1,   0x1.9a3d5cp-2, INEXACT)
T(RN,    0x1.cde5dbcabde95p+1,     0x1.0223a4da4806p-1,  -0x1.f69d86p-2, INEXACT)
T(RN,    0x1.ccd57e181f3e8p+1,    0x1.f9a5d3f6e465fp-2,  -0x1.9aad96p-2, INEXACT)
T(RN,    0x1.cbc5c100748fap+1,    0x1.ef20cf3b88fd2p-2,   0x1.a2cd7ep-2, INEXACT)
T(RN,    0x1.cab6a42509b94p+1,    0x1.e4b76e68d93f6p-2,  -0x1.fa471cp-2, INEXACT)
T(RN,    0x1.c9a827276270cp+1,    0x1.da68eae62cf69p-2,  -0x1.c80246p-2, INEXACT)
T(RN,    0x1.c89a49a93a217p+1,    0x1.d0348455fe972p-2,  -0x1.daed0ep-2, INEXACT)
T(RN,    0x1.c78d0b4c83ceap+1,    0x1.c61980537dda5p-2,  -0x1.a4528cp-2, INEXACT)
T(RN,    0x1.c6806bb369eeap+1,    0x1.bc172a335c22ep-2,  -0x1.b5b426p-2, INEXACT)
T(RN,    0x1.c5746a804e4e2p+1,     0x1.b22cd2c7a472p-2,  -0x1.c60582p-2, INEXACT)
T(RN,    0x1.c4690755c9ed9p+1,    0x1.a859d0267291ep-2,    0x1.e8f66p-2, INEXACT)
T(RN,    0x1.c35e41d6ace12p+1,    0x1.9e9d7d7360c1ep-2,  -0x1.cf260ap-2, INEXACT)
T(RN,    0x1.c25419a5fe2efp+1,    0x1.94f73aab854afp-2,  -0x1.9f5706p-2, INEXACT)
T(RN,    0x1.c14a8e66fbb12p+1,    0x1.8b666c73dc267p-2,  -0x1.ae208ap-2, INEXACT)
T(RN,    0x1.c0419fbd19f38p+1,    0x1.81ea7be9faa0bp-2,   0x1.c816fap-2, INEXACT)
T(RN,    0x1.bf394d4c0413ap+1,    0x1.7882d676ed7d6p-2,   0x1.dd29b2p-2, INEXACT)
T(RN,    0x1.be3196b79ba16p+1,    0x1.6f2eeda423c66p-2,    0x1.9f392p-2, INEXACT)
T(RN,    0x1.bd2a7ba3f87fcp+1,    0x1.65ee36f24a48bp-2,  -0x1.aaadc6p-2, INEXACT)
T(RN,    0x1.bc23fbb568c1ap+1,    0x1.5cc02bb1fd504p-2,  -0x1.ce0f76p-2, INEXACT)
T(RN,    0x1.bb1e1690708b7p+1,    0x1.53a448de383b3p-2,   0x1.f72042p-2, INEXACT)
T(RN,    0x1.ba18cbd9c9f4bp+1,    0x1.4a9a0ef86b756p-2,   0x1.cd3046p-2, INEXACT)
T(RN,    0x1.b9141b3664e6bp+1,    0x1.41a101e622e37p-2,  -0x1.d8f144p-2, INEXACT)
T(RN,    0x1.b810044b66fc9p+1,    0x1.38b8a8d02844fp-2,  -0x1.eacb0cp-2, INEXACT)
T(RN,     0x1.b70c86be2b65p+1,     0x1.2fe08e030e28p-2,   0x1.b2f244p-2, INEXACT)
T(RN,     0x1.b609a23442c1p+1,    0x1.27183ed110f92p-2,  -0x1.9a536cp-2, INEXACT)
T(RN,    0x1.b50756537307ap+1,     0x1.1e5f4b753d35p-2,   0x1.eb56c4p-2, INEXACT)
T(RN,    0x1.b405a2c1b7602p+1,    0x1.15b546f7c9f54p-2,   0x1.d0b20cp-2, INEXACT)
T(RN,    0x1.b30487254008bp+1,    0x1.0d19c713993fcp-2,  -0x1.cd26d6p-2, INEXACT)
T(RN,    0x1.b204032472348p+1,    0x1.048c641cceddbp-2,   0x1.a4958cp-2, INEXACT)
T(RN,    0x1.b1041665e7edfp+1,    0x1.f81971d0e0edep-3,  -0x1.a5ed94p-2, INEXACT)
T(RN,    0x1.b004c0906ff69p+1,    0x1.e734c56a0397ap-3,  -0x1.ca1764p-2, INEXACT)
T(RN,    0x1.af06014b0da61p+1,    0x1.d66a022821b0fp-3,  -0x1.a73974p-2, INEXACT)
T(RN,    0x1.ae07d83cf8ceap+1,    0x1.c5b86ba94d10ap-3,   0x1.f3741cp-2, INEXACT)
T(RN,    0x1.ad0a450d9d9bfp+1,     0x1.b51f49dd2154p-3,   0x1.f7fbecp-2, INEXACT)
T(RN,    0x1.ac0d47649c758p+1,    0x1.a49de8dcf622cp-3,   0x1.c71fc4p-2, INEXACT)
T(RN,    0x1.ab10dee9c9de5p+1,    0x1.943398c59bc99p-3,   0x1.f61882p-2, INEXACT)
T(RN,    0x1.aa150b452e57ep+1,    0x1.83dfad928ff88p-3,    0x1.9acfep-2, INEXACT)
T(RN,    0x1.a919cc1f0641ep+1,    0x1.73a17efa98984p-3,   0x1.a34404p-2, INEXACT)
T(RN,    0x1.a81f211fc1bdep+1,    0x1.6378684db47c1p-3,  -0x1.b87994p-2, INEXACT)
T(RN,    0x1.a72509f0048e3p+1,    0x1.5363c8545187bp-3,  -0x1.b8b71ap-2, INEXACT)
T(RN,    0x1.a62b8638a5f7fp+1,    0x1.4363012fb9c5dp-3,    0x1.cd5c2p-2, INEXACT)
T(RN,    0x1.a53295a2b0a6bp+1,    0x1.3375783ba9109p-3,    0x1.e366cp-2, INEXACT)
T(RN,    0x1.a43a37d7628c3p+1,    0x1.239a95f0fd67bp-3,   0x1.ce8454p-2, INEXACT)
T(RN,    0x1.a3426c802cc28p+1,     0x1.13d1c5c9757dp-3,  -0x1.c243d8p-2, INEXACT)
T(RN,    0x1.a24b3346b36ecp+1,    0x1.041a762471218p-3,  -0x1.c70052p-2, INEXACT)
T(RN,    0x1.a1548bd4cda1dp+1,    0x1.e8e830594f8edp-4,  -0x1.ee0e3cp-2, INEXACT)
T(RN,    0x1.a05e75d4853aap+1,    0x1.c9bc3f7d94929p-4,  -0x1.ffef5ap-2, INEXACT)
T(RN,    0x1.9f68f0f016c91p+1,    0x1.aab006a20ac18p-4,  -0x1.cf25c6p-2, INEXACT)
T(RN,     0x1.9e73fcd1f16fp+1,    0x1.8bc277b6b54a5p-4,   0x1.b1792ep-2, INEXACT)
T(RN,    0x1.9d7f9924b6c2cp+1,    0x1.6cf289818d7edp-4,     0x1.fca3p-2, INEXACT)
T(RN,    0x1.9c8bc5933ab1dp+1,     0x1.4e3f3772575fp-4,   0x1.dfac98p-2, INEXACT)
T(RN,    0x1.9b9881c88362dp+1,    0x1.2fa78177ecd8cp-4,  -0x1.eb9492p-2, INEXACT)
T(RN,    0x1.9aa5cd6fc917bp+1,    0x1.112a6bd6ef658p-4,   0x1.f8e2eep-2, INEXACT)
T(RN,    0x1.99b3a83476101p+1,    0x1.e58dfe03a098bp-5,  -0x1.a4d866p-2, INEXACT)
T(RN,    0x1.98c211c2266d5p+1,     0x1.a8f88ee4417dp-5,  -0x1.d9b4fcp-2, INEXACT)
T(RN,    0x1.97d109c4a8122p+1,    0x1.6c92ab06356fbp-5,   0x1.af193cp-2, INEXACT)
T(RN,    0x1.96e08fe7fa87dp+1,    0x1.305a7a9aac8fap-5,   0x1.d91f28p-2, INEXACT)
T(RN,    0x1.95f0a3d84ee13p+1,    0x1.e89c5a0e74c5ap-6,   0x1.f3a4d2p-2, INEXACT)
T(RN,    0x1.95014542079a2p+1,    0x1.70d7f14341476p-6,   0x1.b9799ep-2, INEXACT)
T(RN,    0x1.941273d1b87f3p+1,    0x1.f2c869b6a296ap-7,   0x1.b7bc88p-2, INEXACT)
T(RN,    0x1.93242f34268acp+1,    0x1.047b5773bf9ecp-7,    0x1.9e325p-2, INEXACT)
T(RN,    0x1.9236771647c4bp+1,   0x1.6c1d242554b89p-11,   0x1.9b3998p-2, INEXACT)
T(RN,    0x1.91494b254353dp+1,   -0x1.acd5cf1a0f326p-8,   0x1.9ac7f8p-2, INEXACT)
T(RN,     0x1.905cab0e70f9p+1,   -0x1.c31180c94efdfp-7,    0x1.bbf8ap-2, INEXACT)
T(RN,    0x1.8f70967f595e6p+1,   -0x1.579c4722a368ep-6,   0x1.b0456cp-2, INEXACT)
T(RN,    0x1.8e850d25b5c48p+1,   -0x1.cd7347db0f827p-6,   0x1.cf1b8cp-2, INEXACT)
T(RN,    0x1.8d9a0eaf6fecfp+1,   -0x1.21887c22f3c66p-5,   0x1.b1356cp-2, INEXACT)
T(RN,    0x1.8caf9acaa2059p+1,   -0x1.5c3c4230ed4e5p-5,   0x1.f86c2cp-2, INEXACT)
T(RN,    0x1.8bc5b12596826p+1,   -0x1.96d6876d726cep-5,   0x1.e3284cp-2, INEXACT)
T(RN,    0x1.8adc516ec808cp+1,   -0x1.d158d8b7207d3p-5,   0x1.fceafcp-2, INEXACT)
T(RN,    0x1.89f37b54e14eep+1,   -0x1.05e25f52f77aap-4,   0x1.c57294p-2, INEXACT)
T(RN,    0x1.890b2e86bd011p+1,   -0x1.230ddedd5b192p-4,    0x1.f0716p-2, INEXACT)
T(RN,    0x1.88236ab365a49p+1,   -0x1.402fab46c90cfp-4,   -0x1.d8ec5p-2, INEXACT)
T(RN,    0x1.873c2f8a157b5p+1,   -0x1.5d4882fd9678ap-4,  -0x1.c80f1ap-2, INEXACT)
T(RN,    0x1.86557cba366a3p+1,   -0x1.7a5922a87f622p-4,  -0x1.c1a6d4p-2, INEXACT)
T(RN,    0x1.856f51f361d84p+1,   -0x1.9762453c4802ap-4,   0x1.9b5fd8p-2, INEXACT)
T(RN,    0x1.8489aee560978p+1,   -0x1.b464a410e389fp-4,  -0x1.ee7674p-2, INEXACT)
T(RN,    0x1.83a493402ac5fp+1,   -0x1.d160f6f62831ap-4,    0x1.b0b38p-2, INEXACT)
T(RN,    0x1.82bffeb3e7b28p+1,   -0x1.ee57f44814adbp-4,   -0x1.ac84ap-2, INEXACT)
T(RN,    0x1.81dbf0f0edc28p+1,   -0x1.05a528815659fp-3,  -0x1.ef7b74p-2, INEXACT)
T(RN,    0x1.80f869a7c252dp+1,   -0x1.141c606ab92c3p-3,     0x1.e584p-2, INEXACT)
T(RN,    0x1.80156889199f5p+1,   -0x1.2291fb1b3fefep-3,  -0x1.9ee75ep-2, INEXACT)
T(RN,    0x1.7f32ed45d6a6fp+1,   -0x1.3106513aa4046p-3,   -0x1.e76b1p-2, INEXACT)
T(RN,    0x1.7e50f78f0b0c4p+1,   -0x1.3f79bae680be7p-3,   -0x1.9f4b9p-2, INEXACT)
T(RN,    0x1.7d6f8715f6ff1p+1,   -0x1.4dec8fbb60248p-3,  -0x1.ed2e1ap-2, INEXACT)
T(RN,     0x1.7c8e9b8c091fp+1,   -0x1.5c5f26dda1e5dp-3,  -0x1.9f44d8p-2, INEXACT)
T(RN,    0x1.7bae34a2de5e2p+1,   -0x1.6ad1d7023e366p-3,   0x1.cad218p-2, INEXACT)
T(RN,    0x1.7ace520c41e8ap+1,   -0x1.7944f677664b8p-3,   0x1.f107c4p-2, INEXACT)
T(RN,    0x1.79eef37a2d08cp+1,   -0x1.87b8db2d0508cp-3,   0x1.d5f376p-2, INEXACT)
T(RN,    0x1.7910189ec709ep+1,   -0x1.962ddabd21a12p-3,   0x1.d3ff4cp-2, INEXACT)
T(RN,    0x1.7831c12c651f6p+1,   -0x1.a4a44a7425c2ap-3,   -0x1.9cb3bp-2, INEXACT)
T(RN,    0x1.7753ecd58a48ap+1,   -0x1.b31c7f5909931p-3,  -0x1.a41f2cp-2, INEXACT)
T(RN,    0x1.76769b4ce736ep+1,   -0x1.c196ce3566fcep-3,    0x1.ebd4dp-2, INEXACT)
T(RN,    0x1.7599cc455a30dp+1,    -0x1.d0138b9d7653p-3,  -0x1.f664f6p-2, INEXACT)
T(RN,     0x1.74bd7f71eef9p+1,   -0x1.de930bf7f5ac7p-3,   0x1.f42624p-2, INEXACT)
T(RN,    0x1.73e1b485deb2cp+1,   -0x1.ed15a385fcf21p-3,  -0x1.9aa856p-2, INEXACT)
T(RN,    0x1.73066b348fc6ap+1,   -0x1.fb9ba66ac02d6p-3,  -0x1.e428e6p-2, INEXACT)
T(RN,    0x1.722ba33195c86p+1,   -0x1.0512b459a0cd1p-2,  -0x1.d9dc4ep-2, INEXACT)
T(RN,    0x1.71515c30b15cfp+1,   -0x1.0c599f2efa927p-2,   0x1.ec2f86p-2, INEXACT)
T(RN,    0x1.707795e5d01e8p+1,    -0x1.13a2bdb12b85p-2,   -0x1.f05dcp-2, INEXACT)
T(RN,    0x1.6f9e50050c833p+1,   -0x1.1aee39dc3b663p-2,  -0x1.aa78f4p-2, INEXACT)
T(RN,    0x1.6ec58a42adc1bp+1,   -0x1.223c3db03c2d7p-2,  -0x1.df1c2cp-2, INEXACT)
T(RN,     0x1.6ded445327b7p+1,   -0x1.298cf33506538p-2,  -0x1.9b78e4p-2, INEXACT)
T(RN,    0x1.6d157deb1accfp+1,   -0x1.30e0847df196fp-2,   0x1.bef722p-2, INEXACT)
T(RN,    0x1.6c3e36bf53df4p+1,   -0x1.38371bad8b061p-2,  -0x1.a5522ep-2, INEXACT)
T(RN,    0x1.6b676e84cc213p+1,   -0x1.3f90e2f948f61p-2,  -0x1.f4936ep-2, INEXACT)
T(RN,     0x1.6a9124f0a904p+1,   -0x1.46ee04ad3d9b1p-2,    0x1.cfac6p-2, INEXACT)
T(RN,    0x1.69bb59b83c1b6p+1,   -0x1.4e4eab2fc90f4p-2,    0x1.f1c7fp-2, INEXACT)
T(RN,    0x1.68e60c9103064p+1,   -0x1.55b301054b449p-2,   0x1.a5075cp-2, INEXACT)
T(RN,    0x1.68113d30a7519p+1,   -0x1.5d1b30d3d6f0fp-2,   0x1.9dfa04p-2, INEXACT)
T(RN,    0x1.673ceb4cfe605p+1,   -0x1.64876566e5c28p-2,  -0x1.af1464p-2, INEXACT)
T(RN,    0x1.6669169c09529p+1,   -0x1.6bf7c9b30ec59p-2,    0x1.e982dp-2, INEXACT)
T(RN,     0x1.6595bed3f4e8p+1,   -0x1.736c88d9bfce3p-2,   0x1.adf7ecp-2, INEXACT)
T(RN,    0x1.64c2e3ab196a8p+1,   -0x1.7ae5ce2cfa257p-2,  -0x1.bd1704p-2, INEXACT)
T(RN,    0x1.63f084d7fa915p+1,   -0x1.8263c53313b81p-2,   0x1.cb99e4p-2, INEXACT)
T(RN,    0x1.631ea2114769cp+1,   -0x1.89e699aa7d051p-2,  -0x1.c4267ap-2, INEXACT)
T(RN,    0x1.624d3b0dda3bep+1,   -0x1.916e778d8cd38p-2,  -0x1.e19d96p-2, INEXACT)
T(RN,    0x1.617c4f84b8727p+1,   -0x1.98fb8b1652244p-2,   0x1.a31d8ep-2, INEXACT)
T(RN,    0x1.60abdf2d127efp+1,   -0x1.a08e00c26d547p-2,  -0x1.9ee76ap-2, INEXACT)
T(RN,     0x1.5fdbe9be43c4p+1,    -0x1.a8260556f0c9p-2,  -0x1.9e73b2p-2, INEXACT)
T(RN,    0x1.5f0c6eefd278dp+1,   -0x1.afc3c5e44a57bp-2,   0x1.ce606ap-2, INEXACT)
T(RN,    0x1.5e3d6e796f91dp+1,   -0x1.b7676fca35b4fp-2,   0x1.b52294p-2, INEXACT)
T(RN,    0x1.5d6ee812f6a66p+1,   -0x1.bf1130bbb8efbp-2,    0x1.a7dffp-2, INEXACT)
T(RN,    0x1.5ca0db746dd82p+1,   -0x1.c6c136c32b8efp-2,   0x1.d13fb4p-2, INEXACT)
T(RN,    0x1.5bd3485605ba6p+1,   -0x1.ce77b046491f1p-2,  -0x1.c960c4p-2, INEXACT)
T(RN,    0x1.5b062e701937ep+1,   -0x1.d634cc0a5003ep-2,    0x1.e13dap-2, INEXACT)
T(RN,    0x1.5a398d7b2d7abp+1,   -0x1.ddf8b9382d32cp-2,   0x1.e62d76p-2, INEXACT)
T(RN,    0x1.596d652ff1d2ep+1,   -0x1.e5c3a760b5bc5p-2,   0x1.a545cep-2, INEXACT)
T(RN,    0x1.58a1b5473f9e8p+1,   -0x1.ed95c680eedcfp-2,  -0x1.b2c4b4p-2, INEXACT)
T(RN,    0x1.57d67d7a1a2fcp+1,   -0x1.f56f47066582ep-2,  -0x1.d52144p-2, INEXACT)
T(RN,    0x1.570bbd81aeb2dp+1,   -0x1.fd5059d39610ep-2,   -0x1.9f006p-2, INEXACT)
T(RN,    0x1.56417517541e2p+1,   -0x1.029c98223265ap-1,   0x1.9ae1e4p-2, INEXACT)
T(RN,    0x1.5577a3f48b08cp+1,   -0x1.0694fe19549c3p-1,   0x1.c2c4aap-2, INEXACT)
T(RN,    0x1.54ae49d2fda1cp+1,   -0x1.0a9177fd65859p-1,   0x1.aa75f4p-2, INEXACT)
T(RN,    0x1.53e5666c7f90cp+1,   -0x1.0e921f4039d6bp-1,   0x1.d613d8p-2, INEXACT)
T(RN,    0x1.531cf97b0ddd3p+1,   -0x1.12970d99aa18ep-1,   0x1.fc2a4ap-2, INEXACT)
T(RN,    0x1.525502b8ced7bp+1,   -0x1.16a05d0a00667p-1,  -0x1.ef3c9ap-2, INEXACT)
T(RN,    0x1.518d81e012022p+1,   -0x1.1aae27dc7178fp-1,   0x1.a6dea6p-2, INEXACT)
T(RN,    0x1.50c676ab4ff4bp+1,   -0x1.1ec088a9a193ap-1,  -0x1.b4129ep-2, INEXACT)
T(RN,    0x1.4fffe0d52a481p+1,   -0x1.22d79a5a35a0fp-1,  -0x1.d79b94p-2, INEXACT)
T(RN,    0x1.4f39c0186b7d3p+1,   -0x1.26f378297133fp-1,    0x1.f2dbap-2, INEXACT)
T(RN,    0x1.4e74143006e2ep+1,   -0x1.2b143da7e1f5bp-1,  -0x1.dd1638p-2, INEXACT)
T(RN,    0x1.4daedcd71880ap+1,   -0x1.2f3a06be18e66p-1,  -0x1.ccf764p-2, INEXACT)
T(RN,    0x1.4cea19c8e4fc6p+1,   -0x1.3364efaf723d6p-1,   -0x1.dad24p-2, INEXACT)
T(RN,    0x1.4c25cac0d9837p+1,   -0x1.3795151cec51cp-1,  -0x1.aa381ap-2, INEXACT)
T(RN,    0x1.4b61ef7a8bb43p+1,   -0x1.3bca94080e351p-1,   0x1.9e90e2p-2, INEXACT)
T(RN,    0x1.4a9e87b1b983ap+1,   -0x1.400589d5debc1p-1,    0x1.de443p-2, INEXACT)
T(RN,    0x1.49db932249257p+1,   -0x1.44461451ec76ap-1,   0x1.a937a2p-2, INEXACT)
T(RN,    0x1.4919118848f72p+1,   -0x1.488c51b1673f4p-1,  -0x1.c54a04p-2, INEXACT)
T(RN,    0x1.4857029fef662p+1,   -0x1.4cd860964c3efp-1,  -0x1.a238e6p-2, INEXACT)
T(RN,    0x1.479566259ad7fp+1,   -0x1.512a6012a4f67p-1,  -0x1.c9a108p-2, INEXACT)
T(RN,    0x1.46d43bd5d194dp+1,   -0x1.55826fabda04bp-1,  -0x1.ca2614p-2, INEXACT)
T(RN,    0x1.4613836d41adcp+1,   -0x1.59e0af5e1a97dp-1,   0x1.fc91a4p-2, INEXACT)
T(RN,    0x1.45533ca8c0e62p+1,   -0x1.5e453f9fd9233p-1,   0x1.dc1ce8p-2, INEXACT)
T(RN,    0x1.449367454c9bbp+1,   -0x1.62b041655e48ap-1,  -0x1.c4a36cp-2, INEXACT)
T(RN,     0x1.43d4030009b1p+1,   -0x1.6721d62472b61p-1,  -0x1.9f1f08p-2, INEXACT)
T(RN,    0x1.43150f964472fp+1,   -0x1.6b9a1fd821032p-1,   0x1.a6e4d6p-2, INEXACT)
T(RN,    0x1.42568cc5708a7p+1,   -0x1.70194104900f8p-1,   0x1.9a690ap-2, INEXACT)
T(RN,    0x1.41987a4b28d0bp+1,   -0x1.749f5cbaf7ce2p-1,   0x1.ee31c4p-2, INEXACT)
T(RN,    0x1.40dad7e52f507p+1,   -0x1.792c969dafb4fp-1,  -0x1.c4c072p-2, INEXACT)
T(RN,    0x1.401da5516d205p+1,   -0x1.7dc112e459cddp-1,   -0x1.aa5f7p-2, INEXACT)
T(RN,    0x1.3f60e24df2504p+1,   -0x1.825cf6602a178p-1,   0x1.fe7becp-2, INEXACT)
T(RN,    0x1.3ea48e98f5d18p+1,   -0x1.870066804be08p-1,  -0x1.cf8bd2p-2, INEXACT)
T(RN,    0x1.3de8a9f0d55fap+1,   -0x1.8bab895666157p-1,   0x1.ade6f4p-2, INEXACT)
T(RN,    0x1.3d2d34141569ep+1,   -0x1.905e859b3fb4bp-1,   0x1.f33644p-2, INEXACT)
T(RN,     0x1.3c722cc160fdp+1,   -0x1.951982b3859bcp-1,  -0x1.b7121ap-2, INEXACT)
T(RN,    0x1.3bb793b789ab9p+1,   -0x1.99dca8b4b300cp-1,   0x1.9f9988p-2, INEXACT)
T(RN,    0x1.3afd68b587775p+1,   -0x1.9ea8206a1dd88p-1,   0x1.e79806p-2, INEXACT)
T(RN,    0x1.3a43ab7a78bb5p+1,   -0x1.a37c135a28876p-1,   0x1.c5fe04p-2, INEXACT)
T(RN,    0x1.398a5bc5a214ap+1,   -0x1.a858abcb9a598p-1,  -0x1.f7ff66p-2, INEXACT)
T(RN,    0x1.38d179566e4b8p+1,   -0x1.ad3e14cb202f3p-1,   0x1.ed9d64p-2, INEXACT)
T(RN,    0x1.381903ec6e3ddp+1,   -0x1.b22c7a30f6e43p-1,  -0x1.e872c8p-2, INEXACT)
T(RN,     0x1.3760fb4758c8p+1,   -0x1.b72408a6c11c5p-1,   0x1.e88cb4p-2, INEXACT)
T(RN,    0x1.36a95f270aae2p+1,   -0x1.bc24edad8a19ap-1,  -0x1.d43f3ep-2, INEXACT)
T(RN,    0x1.35f22f4b86867p+1,   -0x1.c12f57a3f74bfp-1,   0x1.d3da18p-2, INEXACT)
T(RN,    0x1.353b6b74f4a3fp+1,   -0x1.c64375ccaa775p-1,   0x1.d452c4p-2, INEXACT)
T(RN,    0x1.34851363a2fd2p+1,   -0x1.cb617854d66d4p-1,   0x1.fd39d8p-2, INEXACT)
T(RN,    0x1.33cf26d805189p+1,   -0x1.d089905b080edp-1,   0x1.ba9b36p-2, INEXACT)
T(RN,    0x1.3319a592b3f5ep+1,   -0x1.d5bbeff625e63p-1,  -0x1.da8bdcp-2, INEXACT)
T(RN,     0x1.32648f546df7p+1,   -0x1.daf8ca3ca8619p-1,  -0x1.a15fc8p-2, INEXACT)
T(RN,    0x1.31afe3de16cbap+1,   -0x1.e040534c0cdd5p-1,   0x1.ac0c8ap-2, INEXACT)
T(RN,    0x1.30fba2f0b759cp+1,   -0x1.e592c05085f71p-1,  -0x1.d15d4cp-2, INEXACT)
T(RN,    0x1.3047cc4d7da7fp+1,   -0x1.eaf0478ceb772p-1,   0x1.a26294p-2, INEXACT)
T(RN,    0x1.2f945fb5bcc85p+1,   -0x1.f0592062ec635p-1,   -0x1.cd981p-2, INEXACT)
T(RN,    0x1.2ee15ceaecc1cp+1,   -0x1.f5cd835b85f3ap-1,  -0x1.c5d448p-2, INEXACT)
T(RN,    0x1.2e2ec3aeaa7b3p+1,   -0x1.fb4daa2fc213ep-1,  -0x1.da130ap-2, INEXACT)
T(RN,    0x1.2d7c93c2b7a03p+1,    -0x1.006ce7e8e04ep+0,   0x1.9e86aep-2, INEXACT)
T(RN,    0x1.2ccacce8faa07p+1,   -0x1.0339183b069dfp+0,    0x1.c3d01p-2, INEXACT)
T(RN,    0x1.2c196ee37e743p+1,   -0x1.060b84cea3fa1p+0,   0x1.b0b88cp-2, INEXACT)
T(RN,    0x1.2b68797472a8ep+1,   -0x1.08e44d0f0faa2p+0,   -0x1.ed97fp-2, INEXACT)
T(RN,    0x1.2ab7ec5e2b3cdp+1,   -0x1.0bc39117d1de8p+0,   -0x1.c3d17p-2, INEXACT)
T(RN,    0x1.2a07c763208c1p+1,   -0x1.0ea971b9fa9cbp+0,   0x1.ba03aep-2, INEXACT)
T(RN,    0x1.29580a45ef3b1p+1,   -0x1.11961081a82a6p+0,   0x1.f83b2ep-2, INEXACT)
T(RN,    0x1.28a8b4c958206p+1,   -0x1.14898fbbbeef5p+0,  -0x1.eaaa92p-2, INEXACT)
T(RN,    0x1.27f9c6b040304p+1,   -0x1.1784127bd4d84p+0,   0x1.bca7c2p-2, INEXACT)
T(RN,    0x1.274b3fbdb0681p+1,   -0x1.1a85bca252728p+0,  -0x1.d7a3aap-2, INEXACT)
T(RN,    0x1.269d1fb4d5b6cp+1,   -0x1.1d8eb2e2cc14bp+0,   0x1.fda1d4p-2, INEXACT)
T(RN,    0x1.25ef665900e9ap+1,   -0x1.209f1aca955dbp+0,   0x1.d5160cp-2, INEXACT)
T(RN,    0x1.2542136da696cp+1,   -0x1.23b71ac791a84p+0,   0x1.d25ea2p-2, INEXACT)
T(RN,    0x1.249526b65f079p+1,   -0x1.26d6da2f440ddp+0,   0x1.c8c078p-2, INEXACT)
T(RN,    0x1.23e89ff6e623fp+1,   -0x1.29fe814621bb2p+0,   0x1.9c279cp-2, INEXACT)
T(RN,    0x1.233c7ef31b5cdp+1,   -0x1.2d2e394729834p+0,   0x1.a4df7ap-2, INEXACT)
T(RN,    0x1.2290c36f01984p+1,   -0x1.30662c6bc3b55p+0,   0x1.f5ecc8p-2, INEXACT)
T(RN,    0x1.21e56d2ebf1b8p+1,   -0x1.33a685f3ed79dp+0,  -0x1.ab4268p-2, INEXACT)
T(RN,    0x1.213a7bf69d768p+1,   -0x1.36ef722eb3051p+0,  -0x1.bc9802p-2, INEXACT)
T(RN,    0x1.208fef8b096e5p+1,   -0x1.3a411e82fc359p+0,   0x1.a1dec2p-2, INEXACT)
T(RN,    0x1.1fe5c7b092edep+1,   -0x1.3d9bb978af30fp+0,   0x1.b33b9cp-2, INEXACT)
T(RN,    0x1.1f3c042bece4ep+1,   -0x1.40ff72c22d62cp+0,  -0x1.f3f942p-2, INEXACT)
T(RN,    0x1.1e92a4c1ed3fap+1,    -0x1.446c7b462e24p+0,   0x1.cdc09cp-2, INEXACT)
T(RN,    0x1.1de9a9378ccc8p+1,   -0x1.47e30529fc3a5p+0,   0x1.c0e418p-2, INEXACT)
T(RN,    0x1.1d411151e728bp+1,   -0x1.4b6343dc1a3b4p+0,   -0x1.ceec1p-2, INEXACT)
T(RN,    0x1.1c98dcd63aab6p+1,   -0x1.4eed6c1f52cf2p+0,  -0x1.cc18a8p-2, INEXACT)
T(RN,    0x1.1bf10b89e84c9p+1,   -0x1.5281b41639f1dp+0,  -0x1.9ccc3ep-2, INEXACT)
T(RN,     0x1.1b499d3273a8p+1,   -0x1.5620534f23d25p+0,    0x1.dee34p-2, INEXACT)
T(RN,    0x1.1aa2919582ba9p+1,   -0x1.59c982d099092p+0,  -0x1.9bb574p-2, INEXACT)
T(RN,    0x1.19fbe878ddfb1p+1,   -0x1.5d7d7d264a9bcp+0,  -0x1.c1c6dep-2, INEXACT)
T(RN,    0x1.1955a1a27031cp+1,   -0x1.613c7e6e8f6b7p+0,   0x1.c81b84p-2, INEXACT)
T(RN,    0x1.18afbcd846646p+1,   -0x1.6506c4686fcfdp+0,    -0x1.e33cp-2, INEXACT)
T(RN,    0x1.180a39e08fc5ep+1,   -0x1.68dc8e8246ad1p+0,  -0x1.ad9f74p-2, INEXACT)
T(RN,    0x1.176518819da2ep+1,   -0x1.6cbe1de8ff882p+0,   0x1.c56456p-2, INEXACT)
T(RN,    0x1.16c05881e3461p+1,   -0x1.70abb597f97b5p+0,   0x1.c6362ap-2, INEXACT)
T(RN,    0x1.161bf9a7f5ed7p+1,   -0x1.74a59a6996a9fp+0,  -0x1.ca4996p-2, INEXACT)
T(RN,    0x1.1577fbba8cb12p+1,   -0x1.78ac1328819c1p+0,    -0x1.99d2p-2, INEXACT)
T(RN,     0x1.14d45e808073p+1,   -0x1.7cbf68a1b1237p+0,   0x1.b85a2cp-2, INEXACT)
T(RN,    0x1.143121c0cbc37p+1,   -0x1.80dfe5b734f97p+0,   0x1.9f2dcep-2, INEXACT)
T(RN,    0x1.138e45428ad84p+1,   -0x1.850dd773d4a43p+0,  -0x1.cbcf8ap-2, INEXACT)
T(RN,    0x1.12ebc8ccfb6e2p+1,   -0x1.89498d1f8c839p+0,   0x1.ef154ap-2, INEXACT)
T(RN,    0x1.1249ac277cbcfp+1,   -0x1.8d935854f389bp+0,   -0x1.ffd5cp-2, INEXACT)
T(RN,    0x1.11a7ef198f5ebp+1,   -0x1.91eb8d1796a73p+0,  -0x1.d3a3aep-2, INEXACT)
T(RN,    0x1.1106916ad540fp+1,   -0x1.965281eb56447p+0,   0x1.b2930ep-2, INEXACT)
T(RN,    0x1.106592e3118aap+1,   -0x1.9ac88fecd41a3p+0,   0x1.e8b3f6p-2, INEXACT)
T(RN,    0x1.0fc4f34a288e9p+1,   -0x1.9f4e12eaff581p+0,   0x1.fca04cp-2, INEXACT)
T(RN,    0x1.0f24b2681fb3ep+1,   -0x1.a3e36981cf335p+0,  -0x1.feadb6p-2, INEXACT)
T(RN,     0x1.0e84d0051d65p+1,   -0x1.a888f5363bda4p+0,   0x1.e2ace8p-2, INEXACT)
T(RN,    0x1.0de54be968facp+1,   -0x1.ad3f1a9387929p+0,   0x1.e363bep-2, INEXACT)
T(RN,    0x1.0d4625dd6aa7dp+1,   -0x1.b2064149ea763p+0,  -0x1.9d9ae8p-2, INEXACT)
T(RN,    0x1.0ca75da9ab6c7p+1,   -0x1.b6ded44eb4566p+0,  -0x1.fb1278p-2, INEXACT)
T(RN,    0x1.0c08f316d4f1bp+1,   -0x1.bbc941fdfac9fp+0,   0x1.9ca9cep-2, INEXACT)
T(RN,    0x1.0b6ae5edb1983p+1,   -0x1.c0c5fc3de7768p+0,   0x1.9e5ab8p-2, INEXACT)
T(RN,    0x1.0acd35f72c32ep+1,   -0x1.c5d578a3c29ffp+0,   0x1.d96e3cp-2, INEXACT)
T(RN,    0x1.0a2fe2fc50222p+1,   -0x1.caf8309acdcb4p+0,  -0x1.c71ab6p-2, INEXACT)
T(RN,    0x1.0992ecc649291p+1,     -0x1.d02ea18d0ecp+0,  -0x1.cbbd72p-2, INEXACT)
T(RN,    0x1.08f6531e635f9p+1,   -0x1.d5794d0e24be2p+0,   0x1.ca328ep-2, INEXACT)
T(RN,    0x1.085a15ce0b1fcp+1,   -0x1.dad8b90847cdfp+0,  -0x1.cd8326p-2, INEXACT)
T(RN,    0x1.07be349eccf16p+1,   -0x1.e04d6feb930f4p+0,   0x1.a4075ep-2, INEXACT)
T(RN,    0x1.0722af5a55788p+1,   -0x1.e5d800dfbd12ap+0,   0x1.be6d06p-2, INEXACT)
T(RN,    0x1.068785ca71622p+1,   -0x1.eb78fff86410fp+0,   0x1.bb7f84p-2, INEXACT)
T(RN,    0x1.05ecb7b90d502p+1,   -0x1.f131066c16417p+0,   0x1.e4265ep-2, INEXACT)
T(RN,    0x1.055244f035c8ep+1,   -0x1.f700b2ce41421p+0,   -0x1.d8ac8p-2, INEXACT)
T(RN,    0x1.04b82d3a1720fp+1,   -0x1.fce8a94c371aep+0,  -0x1.cb0bacp-2, INEXACT)
T(RN,    0x1.041e7060fd6b2p+1,   -0x1.0174c9f6bcf2ep+1,   0x1.b272bap-2, INEXACT)
T(RN,    0x1.03850e2f54676p+1,    -0x1.0482116bc1b8p+1,  -0x1.eeef8ep-2, INEXACT)
T(RN,    0x1.02ec066fa7698p+1,   -0x1.079c864aa1075p+1,   -0x1.99d0fp-2, INEXACT)
T(RN,    0x1.025358eca14c8p+1,   -0x1.0ac48731437b8p+1,   0x1.a7aec6p-2, INEXACT)
T(RN,    0x1.01bb05710c5f8p+1,   -0x1.0dfa763dd4408p+1,  -0x1.b4376cp-2, INEXACT)
T(RN,    0x1.01230bc7d2502p+1,   -0x1.113eb938cf649p+1,   0x1.a71e4ap-2, INEXACT)
T(RN,    0x1.008b6bbbfc1a5p+1,   -0x1.1491b9c17327ap+1,   0x1.ee8b8ap-2, INEXACT)
T(RN,     0x1.ffe84a3163ebp+0,   -0x1.17f3e57cbd4fep+1,  -0x1.f57366p-2, INEXACT)
T(RN,    0x1.feba6f5276833p+0,   -0x1.1b65ae47207f3p+1,  -0x1.bdcda8p-2, INEXACT)
T(RN,    0x1.fd8d4671fcec4p+0,   -0x1.1ee78a6920ef4p+1,   0x1.99c4c4p-2, INEXACT)
T(RN,     0x1.fc60cf27021bp+0,   -0x1.2279f4cf0be77p+1,   0x1.bf009ap-2, INEXACT)
T(RN,    0x1.fb350908cee87p+0,      -0x1.261d6d4401p+1,   0x1.cd5334p-2, INEXACT)
T(RN,    0x1.fa09f3aee9ee1p+0,   -0x1.29d278b08900ap+1,   0x1.df27dap-2, INEXACT)
T(RN,    0x1.f8df8eb1175fap+0,   -0x1.2d99a15cfae3ap+1,   0x1.c9b90cp-2, INEXACT)
T(RN,    0x1.f7b5d9a758e6cp+0,    -0x1.31737737f4c1p+1,   0x1.b85e7ap-2, INEXACT)
T(RN,    0x1.f68cd429ed819p+0,   -0x1.3560902134344p+1,  -0x1.bac1f4p-2, INEXACT)
T(RN,    0x1.f5647dd151575p+0,   -0x1.3961883920522p+1,  -0x1.9a586ep-2, INEXACT)
T(RN,    0x1.f43cd6363da46p+0,   -0x1.3d7702355d92bp+1,   0x1.ee194ap-2, INEXACT)
T(RN,    0x1.f315dcf1a87c3p+0,   -0x1.41a1a7baccfd2p+1,  -0x1.9fe5aap-2, INEXACT)
T(RN,    0x1.f1ef919cc4bf8p+0,   -0x1.45e229bd5e0a4p+1,   0x1.9e761ep-2, INEXACT)
T(RN,    0x1.f0c9f3d101e86p+0,   -0x1.4a3940e6266dcp+1,   0x1.cad5f4p-2, INEXACT)
T(RN,    0x1.efa503280bedbp+0,   -0x1.4ea7ae003ac9cp+1,  -0x1.afb35cp-2, INEXACT)
T(RN,    0x1.ee80bf3bcb1b2p+0,   -0x1.532e3a6ccfc9ap+1,   0x1.9f06eap-2, INEXACT)
T(RN,    0x1.ed5d27a663f44p+0,   -0x1.57cdb89f36797p+1,    0x1.e80c7p-2, INEXACT)
T(RN,    0x1.ec3a3c0237062p+0,   -0x1.5c8704a154e16p+1,   0x1.e6d0e6p-2, INEXACT)
T(RN,    0x1.eb17fbe9e0cefp+0,   -0x1.615b04a149b43p+1,  -0x1.bbd85ep-2, INEXACT)
T(RN,    0x1.e9f666f839946p+0,   -0x1.664aa988fb795p+1,  -0x1.dbb19cp-2, INEXACT)
T(RN,    0x1.e8d57cc85541cp+0,   -0x1.6b56efa064ba6p+1,   0x1.acfc1ap-2, INEXACT)
T(RN,    0x1.e7b53cf583458p+0,   -0x1.7080df3b8351bp+1,  -0x1.d32238p-2, INEXACT)
T(RN,    0x1.e695a71b4e6ecp+0,    -0x1.75c98d74e715p+1,  -0x1.fd124ap-2, INEXACT)
T(RN,    0x1.e576bad57cc69p+0,   -0x1.7b321cf5f4e6ep+1,  -0x1.aca4ccp-2, INEXACT)
T(RN,    0x1.e45877c00f716p+0,   -0x1.80bbbece0e5c2p+1,   0x1.aafbbcp-2, INEXACT)
T(RN,    0x1.e33add77428b2p+0,   -0x1.8667b359ed2ffp+1,   0x1.d2a052p-2, INEXACT)
T(RN,    0x1.e21deb978d025p+0,   -0x1.8c374b3ca37efp+1,   0x1.cfd99ep-2, INEXACT)
T(RN,    0x1.e101a1bda0774p+0,   -0x1.922be86bd7bc4p+1,  -0x1.df4022p-2, INEXACT)
T(RN,     0x1.dfe5ff866919p+0,   -0x1.9846ff50fe058p+1,   0x1.d00b7ap-2, INEXACT)
T(RN,    0x1.decb048f0d833p+0,   -0x1.9e8a18017fd2cp+1,  -0x1.c21ed2p-2, INEXACT)
T(RN,    0x1.ddb0b074ee9b1p+0,   -0x1.a4f6cf8ff853ep+1,   0x1.ada654p-2, INEXACT)
T(RN,    0x1.dc9702d5a76c8p+0,   -0x1.ab8ed978e7879p+1,   0x1.d49eccp-2, INEXACT)
T(RN,    0x1.db7dfb4f0d09cp+0,   -0x1.b254012d812b3p+1,   0x1.9dd246p-2, INEXACT)
T(RN,    0x1.da65997f2e66ep+0,   -0x1.b9482bbf8879ep+1,  -0x1.ff0726p-2, INEXACT)
T(RN,    0x1.d94ddd0454399p+0,   -0x1.c06d59b17e857p+1,  -0x1.d9824ep-2, INEXACT)
T(RN,    0x1.d836c57d00d56p+0,   -0x1.c7c5a8eec9932p+1,   0x1.d953d4p-2, INEXACT)
T(RN,    0x1.d7205287f00b1p+0,   -0x1.cf5356efe85e4p+1,  -0x1.f44df6p-2, INEXACT)
T(RN,    0x1.d60a83c41705ep+0,   -0x1.d718c30f3fbaap+1,   0x1.c74614p-2, INEXACT)
T(RN,    0x1.d4f558d0a42acp+0,   -0x1.df1871139ccafp+1,   -0x1.c353fp-2, INEXACT)
T(RN,    0x1.d3e0d14cfef4fp+0,   -0x1.e7550bf625532p+1,   0x1.bdbd2ap-2, INEXACT)
T(RN,    0x1.d2ccecd8c7d5dp+0,   -0x1.efd168ea24b12p+1,   0x1.9b4504p-2, INEXACT)
T(RN,    0x1.d1b9ab13d8136p+0,   -0x1.f8908aadf32c8p+1,   0x1.bb6216p-2, INEXACT)
T(RN,    0x1.d0a70b9e41a4dp+0,    -0x1.00cad29690eap+2,   0x1.eeb562p-2, INEXACT)
T(RN,     0x1.cf950e184f13p+0,   -0x1.057210be92028p+2,   0x1.bc0966p-2, INEXACT)
T(RN,    0x1.ce83b2228356cp+0,   -0x1.0a3fd11f73b8ep+2,   0x1.ee4c72p-2, INEXACT)
T(RN,    0x1.cd72f75d99b72p+0,   -0x1.0f36043898c31p+2,   0x1.cce8d6p-2, INEXACT)
T(RN,    0x1.cc62dd6a85a7bp+0,   -0x1.1456bc609b2ebp+2,  -0x1.e7b99cp-2, INEXACT)
T(RN,     0x1.cb5363ea72aap+0,   -0x1.19a430b45d8bcp+2,    0x1.b8355p-2, INEXACT)
T(RN,    0x1.ca448a7ec4294p+0,   -0x1.1f20c0559fba9p+2,    0x1.e562dp-2, INEXACT)
T(RN,    0x1.c93650c915595p+0,   -0x1.24cef60316837p+2,  -0x1.9c74c2p-2, INEXACT)
T(RN,    0x1.c828b66b391bdp+0,   -0x1.2ab18c157bb64p+2,  -0x1.dd9df4p-2, INEXACT)
T(RN,    0x1.c71bbb0739d4dp+0,   -0x1.30cb70eec262bp+2,  -0x1.a4ebccp-2, INEXACT)
T(RN,    0x1.c60f5e3f5954fp+0,   -0x1.371fcbea996cbp+2,   0x1.e1b61cp-2, INEXACT)
T(RN,     0x1.c5039fb610b1p+0,   -0x1.3db202e1c197fp+2,   0x1.f02208p-2, INEXACT)
T(RN,    0x1.c3f87f0e1024ep+0,   -0x1.4485c0547e8d2p+2,   0x1.af6fcap-2, INEXACT)
T(RN,    0x1.c2edfbea3ef2dp+0,   -0x1.4b9efa53af89dp+2,    0x1.c9d9ep-2, INEXACT)
T(RN,    0x1.c1e415edbb413p+0,   -0x1.5301fa43fadd8p+2,   0x1.b83292p-2, INEXACT)
T(RN,    0x1.c0daccbbd9fd5p+0,   -0x1.5ab3659b110b6p+2,   0x1.e0341ep-2, INEXACT)
T(RN,    0x1.bfd21ff826b75p+0,    -0x1.62b847bc89e4p+2,  -0x1.a2a19ep-2, INEXACT)
T(RN,    0x1.beca0f4663847p+0,   -0x1.6b161d226f094p+2,  -0x1.bc9028p-2, INEXACT)
T(RN,    0x1.bdc29a4a88deep+0,   -0x1.73d2e0056c8fap+2,   0x1.ba399cp-2, INEXACT)
T(RN,    0x1.bcbbc0a8c584dp+0,   -0x1.7cf516c2252e9p+2,   0x1.f77f48p-2, INEXACT)
T(RN,    0x1.bbb582057e586p+0,    -0x1.8683e444ae6fp+2,   0x1.af8b9cp-2, INEXACT)
T(RN,    0x1.baafde054e3f4p+0,   -0x1.90871ad13dab8p+2,   0x1.c22084p-2, INEXACT)
T(RN,    0x1.b9aad44d0606ep+0,   -0x1.9b0751922cc07p+2,   0x1.b013cep-2, INEXACT)
T(RN,    0x1.b8a66481ac3d4p+0,   -0x1.a60dfd687e818p+2,    0x1.c1facp-2, INEXACT)
T(RN,    0x1.b7a28e487d17bp+0,   -0x1.b1a58d95ecf8fp+2,   0x1.c4a67ep-2, INEXACT)
T(RN,    0x1.b69f5146ea506p+0,   -0x1.bdd98cf7a022ap+2,  -0x1.f6bfd2p-2, INEXACT)
T(RN,    0x1.b59cad229b07cp+0,   -0x1.cab6c8b09c2cbp+2,   0x1.c13f2cp-2, INEXACT)
T(RN,     0x1.b49aa1816ba4p+0,   -0x1.d84b7d54fc91dp+2,  -0x1.c8f21ep-2, INEXACT)
T(RN,     0x1.b3992e096db3p+0,   -0x1.e6a78be6123abp+2,  -0x1.e0ff56p-2, INEXACT)
T(RN,    0x1.b2985260e7c8fp+0,   -0x1.f5dcb83f537c1p+2,  -0x1.99b5e8p-2, INEXACT)
T(RN,    0x1.b1980e2e5563cp+0,   -0x1.02ff797cf125dp+3,   -0x1.ff113p-2, INEXACT)
T(RN,    0x1.b098611866c91p+0,   -0x1.0b9258a79a00dp+3,  -0x1.9cfeeap-2, INEXACT)
T(RN,    0x1.af994ac600ea1p+0,   -0x1.14b3ab1644a13p+3,  -0x1.b611e2p-2, INEXACT)
T(RN,    0x1.ae9acade3d41ap+0,   -0x1.1e71d842abaedp+3,   0x1.e3078cp-2, INEXACT)
T(RN,    0x1.ad9ce10869b74p+0,   -0x1.28dd4a0a3281ap+3,      0x1.e7bp-2, INEXACT)
T(RN,    0x1.ac9f8cec087ecp+0,   -0x1.3408c99d98436p+3,    0x1.f22e9p-2, INEXACT)
T(RN,    0x1.aba2ce30cffabp+0,   -0x1.4009f158447ffp+3,   0x1.fbaff4p-2, INEXACT)
T(RN,    0x1.aaa6a47eaa9d9p+0,   -0x1.4cf9b932451fap+3,   0x1.a9b2fcp-2, INEXACT)
T(RN,    0x1.a9ab0f7db6c98p+0,   -0x1.5af5255928594p+3,    0x1.bc99bp-2, INEXACT)
T(RN,    0x1.a8b00ed646b32p+0,   -0x1.6a1e2108c7581p+3,   0x1.fded5ep-2, INEXACT)
T(RN,    0x1.a7b5a230e0436p+0,   -0x1.7a9c934d29d76p+3,   0x1.e18062p-2, INEXACT)
T(RN,    0x1.a6bbc9363cf64p+0,   -0x1.8c9fc061787d5p+3,  -0x1.9bb44ap-2, INEXACT)
T(RN,     0x1.a5c2838f49c2p+0,   -0x1.a060119caad82p+3,   0x1.e3013ep-2, INEXACT)
T(RN,    0x1.a4c9d0e526f16p+0,   -0x1.b6216868dec97p+3,  -0x1.f1a916p-2, INEXACT)
T(RN,    0x1.a3d1b0e1280acp+0,   -0x1.ce363063e1691p+3,  -0x1.b2ce54p-2, INEXACT)
T(RN,    0x1.a2da232cd3b06p+0,   -0x1.e9037c5ebff26p+3,  -0x1.cf15b2p-2, INEXACT)
T(RN,    0x1.a1e32771e381fp+0,   -0x1.03834f229d1bbp+4,   0x1.a194aap-2, INEXACT)
T(RN,    0x1.a0ecbd5a43ffdp+0,   -0x1.146e71922c46fp+4,   0x1.aa661ep-2, INEXACT)
T(RN,    0x1.9ff6e4901469fp+0,   -0x1.27a73c63e6086p+4,   -0x1.ae58dp-2, INEXACT)
T(RN,    0x1.9f019cbda6a53p+0,   -0x1.3daf0daeda2c4p+4,   0x1.9a7486p-2, INEXACT)
T(RN,    0x1.9e0ce58d7f1ccp+0,   -0x1.57301793e54fdp+4,   0x1.cc9bacp-2, INEXACT)
T(RN,    0x1.9d18beaa54a18p+0,   -0x1.750edcc18b26bp+4,    0x1.9ddcep-2, INEXACT)
T(RN,    0x1.9c2527bf10539p+0,   -0x1.98858134d5768p+4,   0x1.e3d48ep-2, INEXACT)
T(RN,    0x1.9b322076cd797p+0,   -0x1.c3500be194aebp+4,  -0x1.ef4e5ap-2, INEXACT)
T(RN,    0x1.9a3fa87cd96d2p+0,   -0x1.f7f7450ed6768p+4,  -0x1.ff3f6ep-2, INEXACT)
T(RN,    0x1.994dbf7cb377fp+0,   -0x1.1d2b0ec4ab566p+5,  -0x1.b9baf8p-2, INEXACT)
T(RN,    0x1.985c65220cb8cp+0,   -0x1.484b815fb1f67p+5,  -0x1.a05374p-2, INEXACT)
T(RN,    0x1.976b9918c8026p+0,   -0x1.829e88b263e99p+5,   0x1.a4e7fcp-2, INEXACT)
T(RN,    0x1.967b5b0cf9c9ap+0,   -0x1.d5e526305949fp+5,  -0x1.edb934p-2, INEXACT)
T(RN,    0x1.958baaaae7f21p+0,   -0x1.2b3f59cf3b82cp+6,  -0x1.cc1ed6p-2, INEXACT)
T(RN,    0x1.949c879f09c84p+0,   -0x1.9ba19d7c0b3cap+6,   0x1.eae00cp-2, INEXACT)
T(RN,    0x1.93adf19607d64p+0,   -0x1.4920b2f2c23a6p+7,  -0x1.d768dep-2, INEXACT)
T(RN,    0x1.92bfe83cbbcd9p+0,   -0x1.991711a075ad6p+8,  -0x1.dac442p-2, INEXACT)
T(RN,    0x1.91d26b4030656p+0,    0x1.a7f75ff3a829cp+9,   0x1.b08336p-2, INEXACT)
T(RN,    0x1.90e57a4da140cp+0,     0x1.a11e1a3e7cf2p+7,  -0x1.b4fcd6p-2, INEXACT)
T(RN,     0x1.8ff915127ad1p+0,    0x1.dc129544bc8dbp+6,   0x1.f43606p-2, INEXACT)
T(RN,    0x1.8f0d3b3c5a385p+0,    0x1.4d4c638f1335dp+6,  -0x1.f12c6ap-2, INEXACT)
T(RN,    0x1.8e21ec790d2d1p+0,    0x1.0088c983293b6p+6,   0x1.e5bb92p-2, INEXACT)
T(RN,    0x1.8d37287691de3p+0,    0x1.a131624ebc6bdp+5,   0x1.a19cf6p-2, INEXACT)
T(RN,     0x1.8c4ceee316d8p+0,    0x1.5fa0a89c721ddp+5,  -0x1.c38166p-2, INEXACT)
T(RN,    0x1.8b633f6cfae13p+0,    0x1.2ff5c3d9d352ap+5,  -0x1.ceb7bcp-2, INEXACT)
T(RN,    0x1.8a7a19c2cce54p+0,    0x1.0bbdbba07a467p+5,   0x1.9c7d2ep-2, INEXACT)
T(RN,    0x1.89917d934bd75p+0,    0x1.de9375c412036p+4,   0x1.a11e56p-2, INEXACT)
T(RN,    0x1.88a96a8d66909p+0,    0x1.b0b05294a6785p+4,   0x1.e6c67ep-2, INEXACT)
T(RN,    0x1.87c1e0603bbbap+0,     0x1.8ae6da3aa0bfp+4,   0x1.bbadb4p-2, INEXACT)
T(RN,    0x1.86dadebb19b11p+0,    0x1.6b3e558dd6b85p+4,  -0x1.c01ee4p-2, INEXACT)
T(RN,    0x1.85f4654d7e606p+0,    0x1.50558dc1278adp+4,   0x1.f2484cp-2, INEXACT)
T(RN,    0x1.850e73c7172cep+0,    0x1.392debbf25957p+4,   0x1.9b47e6p-2, INEXACT)
T(RN,    0x1.842909d7c0e8dp+0,    0x1.250b4b1c683c7p+4,    0x1.9c0d9p-2, INEXACT)
T(RN,    0x1.8344272f878f4p+0,    0x1.135fa04f644a8p+4,   0x1.f370b6p-2, INEXACT)
T(RN,    0x1.825fcb7ea64ddp+0,    0x1.03bdab1696be1p+4,   0x1.bf55cep-2, INEXACT)
T(RN,    0x1.817bf675875b5p+0,    0x1.eba007c9ffe88p+3,  -0x1.baf44ep-2, INEXACT)
T(RN,    0x1.8098a7c4c3d9ap+0,    0x1.d2a5e0e9ba1d9p+3,  -0x1.e1624cp-2, INEXACT)
T(RN,    0x1.7fb5df1d23be1p+0,    0x1.bc20152d53dfbp+3,   0x1.c34672p-2, INEXACT)
T(RN,     0x1.7ed39c2f9db4p+0,    0x1.a7b640653ab73p+3,  -0x1.a9e1b4p-2, INEXACT)
T(RN,    0x1.7df1dead5701cp+0,     0x1.951fd492ebe1p+3,   -0x1.f9fb2p-2, INEXACT)
T(RN,    0x1.7d10a647a36c6p+0,    0x1.8420b4dec9201p+3,   0x1.af75a4p-2, INEXACT)
T(RN,    0x1.7c2ff2b00520cp+0,    0x1.7486a6e7cb31bp+3,   0x1.9e154cp-2, INEXACT)
T(RN,    0x1.7b4fc3982c8e8p+0,    0x1.66275f2dfa439p+3,   0x1.e65b02p-2, INEXACT)
T(RN,    0x1.7a7018b1f8559p+0,     0x1.58deff59a7aep+3,  -0x1.db37ecp-2, INEXACT)
T(RN,    0x1.7990f1af7529fp+0,    0x1.4c8ee93464512p+3,   0x1.a839c4p-2, INEXACT)
T(RN,     0x1.78b24e42ddb3p+0,    0x1.411cd16598387p+3,   0x1.aa2b62p-2, INEXACT)
T(RN,    0x1.77d42e1e9a762p+0,    0x1.367202ba4f3d2p+3,  -0x1.beeafep-2, INEXACT)
T(RN,    0x1.76f690f541b9bp+0,    0x1.2c7ac6c3afafap+3,   0x1.bbdd18p-2, INEXACT)
T(RN,    0x1.761976799768bp+0,    0x1.2325eb7423f2bp+3,  -0x1.e82088p-2, INEXACT)
T(RN,    0x1.753cde5e8cf9bp+0,    0x1.1a645f73dc146p+3,  -0x1.e5200cp-2, INEXACT)
T(RN,    0x1.7460c85741541p+0,    0x1.1228e06726aa2p+3,  -0x1.d33a4cp-2, INEXACT)
T(RN,     0x1.7385341700b3p+0,    0x1.0a67b77dcfddfp+3,  -0x1.b9ac36p-2, INEXACT)
T(RN,    0x1.72aa2151448d9p+0,    0x1.03168176dd9a6p+3,  -0x1.d54822p-2, INEXACT)
T(RN,    0x1.71cf8fb9b379cp+0,    0x1.f857ffc72d5e5p+2,   0x1.eb3b44p-2, INEXACT)
T(RN,    0x1.70f57f0421137p+0,    0x1.eb3fe3dbbfd42p+2,  -0x1.a89c58p-2, INEXACT)
T(RN,    0x1.701beee48de1fp+0,    0x1.ded5e6854a991p+2,    0x1.b63b1p-2, INEXACT)
T(RN,    0x1.6f42df0f273b1p+0,    0x1.d30cc010f80b7p+2,  -0x1.b97e76p-2, INEXACT)
T(RN,    0x1.6e6a4f38472aep+0,    0x1.c7d87a045ada4p+2,    -0x1.a336p-2, INEXACT)
T(RN,    0x1.6d923f14745b5p+0,    0x1.bd2e46508e723p+2,   0x1.eb02a6p-2, INEXACT)
T(RN,    0x1.6cbaae5861f3ap+0,    0x1.b3045c4dfb913p+2,   0x1.eedd54p-2, INEXACT)
T(RN,    0x1.6be39cb8ef84ap+0,    0x1.a951da9188fb6p+2,  -0x1.e9bdc6p-2, INEXACT)
T(RN,    0x1.6b0d09eb28eb7p+0,    0x1.a00eacd72b0c3p+2,   0x1.9cf936p-2, INEXACT)
T(RN,    0x1.6a36f5a446372p+0,    0x1.9733756060daap+2,   0x1.a77d6ep-2, INEXACT)
T(RN,    0x1.69615f99ab8ecp+0,    0x1.8eb979410e2b7p+2,   -0x1.a9d66p-2, INEXACT)
T(RN,    0x1.688c4780e91bfp+0,    0x1.869a8f2bb5a98p+2,  -0x1.ccc102p-2, INEXACT)
T(RN,    0x1.67b7ad0fbae6ep+0,    0x1.7ed1106075861p+2,  -0x1.a6cb96p-2, INEXACT)
T(RN,    0x1.66e38ffc08c66p+0,    0x1.7757cb7130076p+2,  -0x1.9a55bcp-2, INEXACT)
T(RN,    0x1.660feffbe640dp+0,    0x1.7029f8999c799p+2,   0x1.c1c508p-2, INEXACT)
T(RN,    0x1.653cccc592754p+0,    0x1.69432f742b2b2p+2,   0x1.e5afa2p-2, INEXACT)
T(RN,    0x1.646a260f77feap+0,    0x1.629f5ddd11ca1p+2,  -0x1.9d9638p-2, INEXACT)
T(RN,    0x1.6397fb902cdb7p+0,    0x1.5c3abfdbd6827p+2,  -0x1.df0322p-2, INEXACT)
T(RN,    0x1.62c64cfe72559p+0,    0x1.5611d87187006p+2,    0x1.f247dp-2, INEXACT)
T(RN,    0x1.61f51a1134e6cp+0,    0x1.50216b2eac91bp+2,  -0x1.d74a76p-2, INEXACT)
T(RN,    0x1.6124627f8c209p+0,    0x1.4a6676782aea9p+2,  -0x1.ec8508p-2, INEXACT)
T(RN,    0x1.60542600ba923p+0,    0x1.44de2e65ad80cp+2,   0x1.bd5f6ap-2, INEXACT)
T(RN,    0x1.5f84644c2daf2p+0,    0x1.3f85f82735b08p+2,    0x1.eb159p-2, INEXACT)
T(RN,    0x1.5eb51d197db57p+0,    0x1.3a5b65e1d7efbp+2,  -0x1.fc4164p-2, INEXACT)
T(RN,    0x1.5de650206d962p+0,    0x1.355c32f5d3b73p+2,   0x1.df1e38p-2, INEXACT)
T(RN,    0x1.5d17fd18eadafp+0,    0x1.308640a1ff751p+2,  -0x1.febe8ep-2, INEXACT)
T(RN,    0x1.5c4a23bb0d8bep+0,    0x1.2bd792fa0d33fp+2,   -0x1.cc6b4p-2, INEXACT)
T(RN,    0x1.5b7cc3bf18197p+0,    0x1.274e4e267fa9fp+2,  -0x1.ef4b46p-2, INEXACT)
T(RN,    0x1.5aafdcdd7740dp+0,    0x1.22e8b3e64a9bdp+2,   0x1.aa934ap-2, INEXACT)
T(RN,    0x1.59e36ecec1f2cp+0,    0x1.1ea5214b15572p+2,   0x1.f07f6cp-2, INEXACT)
T(RN,    0x1.5917794bb93d8p+0,     0x1.1a820ca9ef1cp+2,   0x1.ef0088p-2, INEXACT)
T(RN,    0x1.584bfc0d48317p+0,    0x1.167e03bb015dcp+2,  -0x1.f26ccep-2, INEXACT)
T(RN,    0x1.5780f6cc83c8ap+0,    0x1.1297a9e36f8f6p+2,  -0x1.e1250ep-2, INEXACT)
T(RN,    0x1.56b66942aacf8p+0,    0x1.0ecdb6a5222f5p+2,   0x1.b8b9f6p-2, INEXACT)
T(RN,    0x1.55ec532925ca7p+0,    0x1.0b1ef430b6c4bp+2,  -0x1.ce2064p-2, INEXACT)
T(RN,    0x1.5522b43986decp+0,     0x1.078a3e163b14p+2,    0x1.c0371p-2, INEXACT)
T(RN,    0x1.54598c2d89b85p+0,    0x1.040e8011b8716p+2,  -0x1.f27108p-2, INEXACT)
T(RN,    0x1.5390dabf13731p+0,    0x1.00aab4f0e79bbp+2,   0x1.e77faep-2, INEXACT)
T(RN,    0x1.52c89fa83281dp+0,    0x1.fabbcb1f5cdd6p+1,   0x1.efd118p-2, INEXACT)
T(RN,    0x1.5200daa31e943p+0,    0x1.f44e4fd292a8ep+1,   0x1.cd199ap-2, INEXACT)
T(RN,    0x1.51398b6a38813p+0,    0x1.ee0b3c7876708p+1,  -0x1.bfd1eap-2, INEXACT)
T(RN,    0x1.5072b1b80a2dap+0,    0x1.e7f0ec7ea1786p+1,   0x1.a124a8p-2, INEXACT)
T(RN,    0x1.4fac4d474672cp+0,    0x1.e1fdd0cc60309p+1,   0x1.f8a4fcp-2, INEXACT)
T(RN,    0x1.4ee65dd2c907fp+0,    0x1.dc306e682cd49p+1,  -0x1.a81452p-2, INEXACT)
T(RN,    0x1.4e20e315966a1p+0,    0x1.d6875d370c2e6p+1,  -0x1.d8dae6p-2, INEXACT)
T(RN,    0x1.4d5bdccadbc27p+0,    0x1.d10146d39235ep+1,   0x1.baaaccp-2, INEXACT)
T(RN,    0x1.4c974aadeecfcp+0,    0x1.cb9ce57a8bb2fp+1,  -0x1.cd06c8p-2, INEXACT)
T(RN,      0x1.4bd32c7a4ddp+0,    0x1.c659030b7b5e5p+1,    0x1.b7b9fp-2, INEXACT)
T(RN,    0x1.4b0f81eb9f62dp+0,    0x1.c134781b44f28p+1,  -0x1.a41466p-2, INEXACT)
T(RN,    0x1.4a4c4abdb278cp+0,    0x1.bc2e2b1788ebfp+1,   0x1.b46688p-2, INEXACT)
T(RN,    0x1.498986ac7e37dp+0,    0x1.b7450f7955e0ep+1,  -0x1.e634dap-2, INEXACT)
T(RN,    0x1.48c7357421e1ap+0,    0x1.b2782505f51a5p+1,   0x1.abff8cp-2, INEXACT)
T(RN,     0x1.480556d0e4c1p+0,    0x1.adc6771cb459ep+1,   0x1.d765d4p-2, INEXACT)
T(RN,    0x1.4743ea7f360ddp+0,    0x1.a92f1c10a7d29p+1,   0x1.a72b32p-2, INEXACT)
T(RN,    0x1.4682f03bacda7p+0,    0x1.a4b1348d774fbp+1,  -0x1.d3d8b2p-2, INEXACT)
T(RN,    0x1.45c267c307f4cp+0,    0x1.a04beb065d55bp+1,   0x1.cdfed6p-2, INEXACT)
T(RN,    0x1.450250d22dd5ep+0,    0x1.9bfe732e92f79p+1,   0x1.ea10fap-2, INEXACT)
T(RN,    0x1.4442ab262c86ap+0,     0x1.97c8097a72d5p+1,  -0x1.ea2492p-2, INEXACT)
T(RN,    0x1.4383767c398a5p+0,    0x1.93a7f2a8ae109p+1,   -0x1.d1723p-2, INEXACT)
T(RN,    0x1.42c4b291b1c7cp+0,    0x1.8f9d7b52fb5acp+1,   0x1.d28d5ep-2, INEXACT)
T(RN,    0x1.42065f24196dfp+0,    0x1.8ba7f785b4ed2p+1,    0x1.d3538p-2, INEXACT)
T(RN,    0x1.41487bf11be28p+0,    0x1.87c6c25de616cp+1,   0x1.ad995ap-2, INEXACT)
T(RN,    0x1.408b08b68ba65p+0,    0x1.83f93dad52a7dp+1,    0x1.ee5adp-2, INEXACT)
T(RN,    0x1.3fce0532623e2p+0,    0x1.803ed1a40cb38p+1,   0x1.9e65e8p-2, INEXACT)
T(RN,    0x1.3f117122c02a7p+0,    0x1.7c96ec7f35a0bp+1,  -0x1.a23cf2p-2, INEXACT)
T(RN,    0x1.3e554c45ecaf2p+0,    0x1.7901023c8de77p+1,   0x1.e480e8p-2, INEXACT)
T(RN,    0x1.3d99965a55deap+0,    0x1.757c8c52817c6p+1,   0x1.c23802p-2, INEXACT)
T(RN,    0x1.3cde4f1e9071bp+0,    0x1.7209096c60dd6p+1,   0x1.b27ecap-2, INEXACT)
T(RN,    0x1.3c23765157b66p+0,    0x1.6ea5fd2a806d7p+1,   -0x1.a0f85p-2, INEXACT)
T(RN,    0x1.3b690bb18d744p+0,    0x1.6b52efe5fb28bp+1,   0x1.bf82bep-2, INEXACT)
T(RN,    0x1.3aaf0efe39db8p+0,    0x1.680f6e77dbc19p+1,   0x1.9ec2c8p-2, INEXACT)
T(RN,    0x1.39f57ff68b697p+0,    0x1.64db0a0373032p+1,   0x1.e7a802p-2, INEXACT)
T(RN,    0x1.393c5e59d6d5ep+0,    0x1.61b557c3a73f5p+1,  -0x1.a1b5e4p-2, INEXACT)
T(RN,    0x1.3883a9e796f91p+0,     0x1.5e9df0db0bc9p+1,   0x1.d6699cp-2, INEXACT)
T(RN,    0x1.37cb625f6cb82p+0,    0x1.5b94722693867p+1,   0x1.acca8ep-2, INEXACT)
T(RN,    0x1.371387811eec8p+0,    0x1.58987c12b47b5p+1,   0x1.f629a6p-2, INEXACT)
T(RN,    0x1.365c190c9a4f5p+0,    0x1.55a9b272d57b4p+1,   0x1.a6d1e8p-2, INEXACT)
T(RN,      0x1.35a516c1f16p+0,    0x1.52c7bc5ae1adcp+1,   0x1.9a827ep-2, INEXACT)
T(RN,    0x1.34ee80615c565p+0,    0x1.4ff243fae0794p+1,  -0x1.caa356p-2, INEXACT)
T(RN,    0x1.343855ab38fd2p+0,    0x1.4d28f67c71f58p+1,  -0x1.d99af8p-2, INEXACT)
T(RN,     0x1.338296600aabp+0,    0x1.4a6b83e2138adp+1,    0x1.f2bd8p-2, INEXACT)
T(RN,    0x1.32cd42407a247p+0,    0x1.47b99ee810be2p+1,   0x1.e5ad64p-2, INEXACT)
T(RN,    0x1.3218590d55881p+0,    0x1.4512fce70750fp+1,  -0x1.adfd58p-2, INEXACT)
T(RN,    0x1.3163da8790376p+0,    0x1.427755b7e6d8fp+1,  -0x1.b7fa36p-2, INEXACT)
T(RN,    0x1.30afc67042c24p+0,    0x1.3fe6639955d2fp+1,   0x1.d32028p-2, INEXACT)
T(RN,    0x1.2ffc1c88aacf9p+0,     0x1.3d5fe316677dp+1,   0x1.bb2468p-2, INEXACT)
T(RN,     0x1.2f48dc922b08p+0,    0x1.3ae392ee8f448p+1,   0x1.adbff4p-2, INEXACT)
T(RN,    0x1.2e96064e4b00ap+0,    0x1.387133febfb7fp+1,  -0x1.abf386p-2, INEXACT)
T(RN,    0x1.2de3997eb7263p+0,    0x1.3608892ba423fp+1,  -0x1.dcee5ap-2, INEXACT)
T(RN,    0x1.2d3195e540a1dp+0,    0x1.33a9574ce4f78p+1,   -0x1.c4093p-2, INEXACT)
T(RN,    0x1.2c7ffb43dd4a8p+0,     0x1.31536519686ap+1,    0x1.bafffp-2, INEXACT)
T(RN,    0x1.2bcec95ca78ddp+0,    0x1.2f067b14813abp+1,   -0x1.cd83bp-2, INEXACT)
T(RN,    0x1.2b1dfff1de54ep+0,    0x1.2cc2637bfe9fep+1,  -0x1.f051eap-2, INEXACT)
T(RN,    0x1.2a6d9ec5e4f51p+0,    0x1.2a86ea371165ap+1,   0x1.fb44eep-2, INEXACT)
T(RN,    0x1.29bda59b43195p+0,    0x1.2853dcc5fa8c3p+1,   0x1.ebb556p-2, INEXACT)
T(RN,    0x1.290e1434a4aa6p+0,    0x1.26290a3278bd2p+1,    0x1.d1201p-2, INEXACT)
T(RN,    0x1.285eea54d9bb1p+0,    0x1.24064300ea8dbp+1,   0x1.a0aa08p-2, INEXACT)
T(RN,     0x1.27b027bed673p+0,    0x1.21eb59221bfffp+1,    0x1.c48a5p-2, INEXACT)
T(RN,     0x1.2701cc35b2f8p+0,    0x1.1fd81fe5b6564p+1,   0x1.a054f6p-2, INEXACT)
T(RN,    0x1.2653d77cab56dp+0,    0x1.1dcc6bed49d63p+1,  -0x1.9a3b08p-2, INEXACT)
T(RN,    0x1.25a649571f852p+0,    0x1.1bc8131fe9e01p+1,  -0x1.acedb2p-2, INEXACT)
T(RN,    0x1.24f9218893175p+0,    0x1.19caec9e52ba1p+1,  -0x1.a99344p-2, INEXACT)
T(RN,    0x1.244c5fd4ad626p+0,    0x1.17d4d0b79433cp+1,   0x1.be14acp-2, INEXACT)
T(RN,    0x1.23a003ff394b9p+0,    0x1.15e598de384a9p+1,  -0x1.ee1114p-2, INEXACT)
T(RN,    0x1.22f40dcc2539dp+0,    0x1.13fd1f9de0f04p+1,   -0x1.c3ceap-2, INEXACT)
T(RN,    0x1.22487cff82fe6p+0,    0x1.121b40915690ep+1,   0x1.9b0e0cp-2, INEXACT)
T(RN,    0x1.219d515d87c19p+0,    0x1.103fd85901f2dp+1,  -0x1.f4f3dap-2, INEXACT)
T(RN,    0x1.20f28aaa8bedep+0,    0x1.0e6ac491cc227p+1,  -0x1.ae932cp-2, INEXACT)
T(RN,    0x1.204828ab0b1aap+0,    0x1.0c9be3cc5f784p+1,    0x1.ffd62p-2, INEXACT)
T(RN,    0x1.1f9e2b23a3f7fp+0,    0x1.0ad31584c512ap+1,    0x1.a5db9p-2, INEXACT)
T(RN,    0x1.1ef491d9183a9p+0,    0x1.09103a1a5a527p+1,   0x1.d44b4cp-2, INEXACT)
T(RN,    0x1.1e4b5c904c83bp+0,    0x1.075332c81a214p+1,  -0x1.a84f44p-2, INEXACT)
T(RN,    0x1.1da28b0e48513p+0,    0x1.059be19d362e8p+1,  -0x1.d40778p-2, INEXACT)
T(RN,    0x1.1cfa1d1835e5cp+0,    0x1.03ea2975fc37ep+1,   0x1.fd3cfep-2, INEXACT)
T(RN,    0x1.1c5212736236bp+0,    0x1.023dedf503f6cp+1,   0x1.b94356p-2, INEXACT)
T(RN,    0x1.1baa6ae53cd57p+0,    0x1.0097137ca23d1p+1,  -0x1.b17b9ap-2, INEXACT)
T(RN,    0x1.1b03263357db3p+0,    0x1.fdeafe513c46cp+0,  -0x1.9c7c46p-2, INEXACT)
T(RN,    0x1.1a5c442367d6bp+0,    0x1.fab22d904a881p+0,  -0x1.d86986p-2, INEXACT)
T(RN,    0x1.19b5c47b43b69p+0,    0x1.f78381aff8345p+0,  -0x1.f57896p-2, INEXACT)
T(RN,    0x1.190fa700e4b38p+0,    0x1.f45ec8f9cfac2p+0,   0x1.f49862p-2, INEXACT)
T(RN,    0x1.1869eb7a663f2p+0,    0x1.f143d2fc9e407p+0,  -0x1.be2e6cp-2, INEXACT)
T(RN,    0x1.17c491ae05ed8p+0,    0x1.ee3270821e831p+0,  -0x1.ea3592p-2, INEXACT)
T(RN,    0x1.171f996223623p+0,    0x1.eb2a738506e85p+0,    0x1.c4891p-2, INEXACT)
T(RN,    0x1.167b025d403b5p+0,    0x1.e82baf277838dp+0,  -0x1.d5b58cp-2, INEXACT)
T(RN,    0x1.15d6cc65fffe9p+0,    0x1.e535f7a9c7b6fp+0,   -0x1.ac4a9p-2, INEXACT)
T(RN,    0x1.1532f74328035p+0,    0x1.e2492261a0e59p+0,  -0x1.a558bep-2, INEXACT)
T(RN,    0x1.148f82bb9f615p+0,    0x1.df6505b17b4c8p+0,   -0x1.9fde9p-2, INEXACT)
T(RN,    0x1.13ec6e966eda2p+0,    0x1.dc8979006073ap+0,  -0x1.e08f6ep-2, INEXACT)
T(RN,     0x1.1349ba9ac0c9p+0,    0x1.d9b654b1fedebp+0,   0x1.e525e2p-2, INEXACT)
T(RN,    0x1.12a7668fe109dp+0,    0x1.d6eb721f0682ap+0,  -0x1.e51e9ap-2, INEXACT)
T(RN,    0x1.1205723d3ce91p+0,    0x1.d428ab8dcbed2p+0,  -0x1.c86302p-2, INEXACT)
T(RN,    0x1.1163dd6a630fdp+0,    0x1.d16ddc2b2eedep+0,  -0x1.b51a94p-2, INEXACT)
T(RN,    0x1.10c2a7df036f7p+0,    0x1.cebae003c205dp+0,  -0x1.db4dd2p-2, INEXACT)
T(RN,    0x1.1021d162ef2cfp+0,    0x1.cc0f93fd2fecbp+0,   0x1.b3cb38p-2, INEXACT)
T(RN,    0x1.0f8159be188f6p+0,    0x1.c96bd5cfdcaebp+0,  -0x1.df9d0ep-2, INEXACT)
T(RN,     0x1.0ee140b892ebp+0,     0x1.c6cf8400bfd9p+0,   0x1.a67b06p-2, INEXACT)
T(RN,    0x1.0e41861a928e6p+0,    0x1.c43a7ddb7577ep+0,   0x1.fcdfb4p-2, INEXACT)
T(RN,    0x1.0da229ac6caedp+0,     0x1.c1aca36c83a7p+0,   0x1.c7055ep-2, INEXACT)
T(RN,    0x1.0d032b3697537p+0,    0x1.bf25d57bd292fp+0,   0x1.ad704ep-2, INEXACT)
T(RN,    0x1.0c648a81a9444p+0,    0x1.bca5f58754fedp+0,   0x1.a8a0e6p-2, INEXACT)
T(RN,    0x1.0bc6475659fa4p+0,    0x1.ba2ce5bddf54fp+0,   0x1.ed2404p-2, INEXACT)
T(RN,    0x1.0b28617d817dep+0,    0x1.b7ba88fa2b21ep+0,   0x1.a1582ep-2, INEXACT)
T(RN,    0x1.0a8ad8c018655p+0,    0x1.b54ec2be05ff3p+0,   0x1.e3aa4cp-2, INEXACT)
T(RN,    0x1.09edace737b76p+0,    0x1.b2e9772da952ep+0,   0x1.e2d13cp-2, INEXACT)
T(RN,    0x1.0950ddbc18dadp+0,    0x1.b08a8b0b39e99p+0,  -0x1.f57988p-2, INEXACT)
T(RN,    0x1.08b46b081582fp+0,    0x1.ae31e3b26da71p+0,   -0x1.c569dp-2, INEXACT)
T(RN,    0x1.08185494a79ccp+0,    0x1.abdf671455e28p+0,    0x1.d4b34p-2, INEXACT)
T(RN,    0x1.077c9a2b693b9p+0,    0x1.a992fbb34d04ap+0,   0x1.bb0038p-2, INEXACT)
T(RN,     0x1.06e13b961487p+0,    0x1.a74c889f06187p+0,  -0x1.b09b7ap-2, INEXACT)
T(RN,    0x1.0646389e83a74p+0,    0x1.a50bf570bcf9dp+0,  -0x1.b2a64ap-2, INEXACT)
T(RN,     0x1.05ab910eb0b1p+0,    0x1.a2d12a4785edep+0,   0x1.9ebf64p-2, INEXACT)
T(RN,    0x1.051144b0b5971p+0,    0x1.a09c0fc4bb8eep+0,  -0x1.f973f2p-2, INEXACT)
T(RN,    0x1.0477534ecc10ep+0,    0x1.9e6c8f0889ae4p+0,   0x1.f1fdd6p-2, INEXACT)
T(RN,     0x1.03ddbcb34d8ep+0,    0x1.9c4291ae94703p+0,   0x1.b07c54p-2, INEXACT)
T(RN,    0x1.034480a8b31fcp+0,    0x1.9a1e01caba475p+0,  -0x1.bbdb22p-2, INEXACT)
T(RN,    0x1.02ab9ef99567dp+0,    0x1.97fec9e5f007fp+0,  -0x1.e4a7b8p-2, INEXACT)
T(RN,    0x1.02131770ac851p+0,    0x1.95e4d4fb36083p+0,   0x1.b1a148p-2, INEXACT)
T(RN,    0x1.017ae9d8d001cp+0,    0x1.93d00e74a5703p+0,  -0x1.b052f6p-2, INEXACT)
T(RN,    0x1.00e315fcf6c24p+0,    0x1.91c0622894d8fp+0,   0x1.da78aap-2, INEXACT)
T(RN,    0x1.004b9ba836eccp+0,    0x1.8fb5bc56d347dp+0,  -0x1.ecf814p-2, INEXACT)
T(RN,    0x1.ff68f54b8bbe2p-1,    0x1.8db009a5f9065p+0,   0x1.d27342p-2, INEXACT)
T(RN,    0x1.fe3b6581f02c1p-1,    0x1.8baf3720cd2abp+0,  -0x1.b99986p-2, INEXACT)
T(RN,    0x1.fd0e878a823b4p-1,    0x1.89b33233bf688p+0,   0x1.f1d196p-2, INEXACT)
T(RN,    0x1.fbe25afc66fbcp-1,    0x1.87bbe8aa75474p+0,   0x1.9fb6eap-2, INEXACT)
T(RN,    0x1.fab6df6f01579p-1,    0x1.85c948ad6a2c9p+0,   0x1.b76802p-2, INEXACT)
T(RN,    0x1.f98c1479f1df6p-1,    0x1.83db40bfa15ffp+0,  -0x1.b48e68p-2, INEXACT)
T(RN,     0x1.f861f9b516b7p-1,    0x1.81f1bfbc69c16p+0,   0x1.d83c16p-2, INEXACT)
T(RN,    0x1.f7388eb88b656p-1,    0x1.800cb4d53232dp+0,  -0x1.9b137ep-2, INEXACT)
T(RN,    0x1.f60fd31ca8b6ep-1,    0x1.7e2c0f8f6e706p+0,   0x1.c426cep-2, INEXACT)
T(RN,    0x1.f4e7c67a04952p-1,    0x1.7c4fbfc28b967p+0,   0x1.e6af0ap-2, INEXACT)
T(RN,     0x1.f3c0686971e6p-1,    0x1.7a77b595f3ecap+0,  -0x1.afd3fcp-2, INEXACT)
T(RN,    0x1.f299b88400653p-1,    0x1.78a3e17f215bep+0,   0x1.b50252p-2, INEXACT)
T(RN,     0x1.f173b662fc82p-1,    0x1.76d4343fbe20bp+0,   0x1.d7b4f4p-2, INEXACT)
T(RN,    0x1.f04e619fef3b9p-1,    0x1.75089ee3d337fp+0,  -0x1.fc3f7ap-2, INEXACT)
T(RN,    0x1.ef29b9d49dfb4p-1,    0x1.734112c0040fcp+0,   0x1.f5ff2ep-2, INEXACT)
T(RN,    0x1.ee05be9b0a73ep-1,    0x1.717d816fd715dp+0,    0x1.a73d9p-2, INEXACT)
T(RN,    0x1.ece26f8d727b4p-1,    0x1.6fbddcd40aa85p+0,  -0x1.9bb876p-2, INEXACT)
T(RN,    0x1.ebbfcc464fe87p-1,    0x1.6e021710f60f8p+0,   0x1.b8841ap-2, INEXACT)
T(RN,    0x1.ea9dd46058714p-1,    0x1.6c4a228cf6133p+0,  -0x1.f70fe2p-2, INEXACT)
T(RN,    0x1.e97c87767d841p-1,    0x1.6a95f1eee4c8dp+0,  -0x1.d4c21cp-2, INEXACT)
T(RN,    0x1.e85be523ec275p-1,    0x1.68e5781c9c48bp+0,   0x1.a085c8p-2, INEXACT)
T(RN,    0x1.e73bed040cd4fp-1,    0x1.6738a83983e3ep+0,   0x1.d395a6p-2, INEXACT)
T(RN,    0x1.e61c9eb283579p-1,    0x1.658f75a5278cap+0,  -0x1.9e04d4p-2, INEXACT)
T(RN,    0x1.e4fdf9cb2ea8ap-1,    0x1.63e9d3f9d91c9p+0,  -0x1.d2fe3ep-2, INEXACT)
T(RN,    0x1.e3dffdea28cb3p-1,    0x1.6247b70b5b221p+0,  -0x1.d4ca4ep-2, INEXACT)
T(RN,    0x1.e2c2aaabc6ab7p-1,    0x1.60a912e594f41p+0,   -0x1.adc3fp-2, INEXACT)
T(RN,     0x1.e1a5ffac97fap-1,     0x1.5f0ddbcb4fb4p+0,  -0x1.9dc5fcp-2, INEXACT)
T(RN,    0x1.e089fc89670bbp-1,    0x1.5d760634fc02fp+0,   -0x1.a2cd5p-2, INEXACT)
T(RN,    0x1.df6ea0df38b3fp-1,    0x1.5be186cf80166p+0,  -0x1.c15beap-2, INEXACT)
T(RN,    0x1.de53ec4b4c24ap-1,    0x1.5a50527b0df97p+0,   0x1.f67162p-2, INEXACT)
T(RN,    0x1.dd39de6b1acaep-1,    0x1.58c25e4a01ad8p+0,   0x1.ac5d2ap-2, INEXACT)
T(RN,    0x1.dc2076dc582d3p-1,    0x1.57379f7fc6f33p+0,   0x1.a7133cp-2, INEXACT)
T(RN,    0x1.db07b53cf1c77p-1,    0x1.55b00b8fc679ap+0,   0x1.bd9a06p-2, INEXACT)
T(RN,    0x1.d9ef992b0eeb3p-1,    0x1.542b981c5a43fp+0,  -0x1.d97688p-2, INEXACT)
T(RN,    0x1.d8d82245109c3p-1,    0x1.52aa3af5c901ap+0,  -0x1.abaa4ep-2, INEXACT)
T(RN,    0x1.d7c15029916dep-1,    0x1.512bea194829ep+0,   0x1.dd5476p-2, INEXACT)
T(RN,    0x1.d6ab227765627p-1,    0x1.4fb09bb004a74p+0,   0x1.baa3c6p-2, INEXACT)
T(RN,    0x1.d59598cd99c94p-1,    0x1.4e38460e31de5p+0,    0x1.c7ce5p-2, INEXACT)
T(RN,    0x1.d480b2cb751bbp-1,    0x1.4cc2dfb21edc8p+0,   0x1.ae6228p-2, INEXACT)
T(RN,    0x1.d36c701076dc9p-1,    0x1.4b505f435186ep+0,   0x1.9b879cp-2, INEXACT)
T(RN,    0x1.d258d03c5775ep-1,    0x1.49e0bb91a7951p+0,  -0x1.a20982p-2, INEXACT)
T(RN,    0x1.d145d2ef08185p-1,    0x1.4873eb947d319p+0,  -0x1.cbe7b2p-2, INEXACT)
T(RN,    0x1.d03377c8b2967p-1,    0x1.4709e669d90c4p+0,  -0x1.c5be3ep-2, INEXACT)
T(RN,     0x1.cf21be69b94ap-1,    0x1.45a2a3559dca3p+0,  -0x1.9aeb6ap-2, INEXACT)
T(RN,    0x1.ce10a672b6ea5p-1,    0x1.443e19c0c0895p+0,  -0x1.e29108p-2, INEXACT)
T(RN,    0x1.cd002f847e714p-1,    0x1.42dc413884791p+0,  -0x1.c49f42p-2, INEXACT)
T(RN,    0x1.cbf059401af78p-1,    0x1.417d116dbb43fp+0,  -0x1.f25542p-2, INEXACT)
T(RN,    0x1.cae12346cf942p-1,    0x1.402082340a364p+0,  -0x1.ece1f2p-2, INEXACT)
T(RN,    0x1.c9d28d3a173bap-1,    0x1.3ec68b8133fa5p+0,   0x1.a65fcep-2, INEXACT)
T(RN,    0x1.c8c496bba49d5p-1,    0x1.3d6f256c66c6dp+0,  -0x1.b977dep-2, INEXACT)
T(RN,    0x1.c7b73f6d62057p-1,    0x1.3c1a482d8ee85p+0,   0x1.ac13e4p-2, INEXACT)
T(RN,    0x1.c6aa86f17139ep-1,    0x1.3ac7ec1cad774p+0,  -0x1.af5f72p-2, INEXACT)
T(RN,    0x1.c59e6cea2b5a9p-1,    0x1.397809b1332adp+0,  -0x1.a16d0ep-2, INEXACT)
T(RN,    0x1.c492f0fa20bfep-1,    0x1.382a99815f20fp+0,   -0x1.a4287p-2, INEXACT)
T(RN,    0x1.c38812c418ddcp-1,    0x1.36df9441a189cp+0,  -0x1.b97804p-2, INEXACT)
T(RN,    0x1.c27dd1eb121c5p-1,    0x1.3596f2c40206dp+0,   0x1.e6d078p-2, INEXACT)
T(RN,    0x1.c1742e1241bd9p-1,    0x1.3450adf789c0dp+0,  -0x1.bfa5b2p-2, INEXACT)
T(RN,    0x1.c06b26dd13baep-1,    0x1.330cbee7b1009p+0,  -0x1.edbfc2p-2, INEXACT)
T(RN,    0x1.bf62bbef2aa3dp-1,    0x1.31cb1ebbd03c4p+0,   0x1.da9488p-2, INEXACT)
T(RN,    0x1.be5aecec5f805p-1,    0x1.308bc6b69484cp+0,   0x1.befdfap-2, INEXACT)
T(RN,    0x1.bd53b978c1ae1p-1,    0x1.2f4eb03577315p+0,    0x1.b0afap-2, INEXACT)
T(RN,    0x1.bc4d213896c16p-1,    0x1.2e13d4b038bc2p+0,  -0x1.ed5526p-2, INEXACT)
T(RN,    0x1.bb4723d05a662p-1,    0x1.2cdb2db85eb6cp+0,   0x1.dee59ap-2, INEXACT)
T(RN,    0x1.ba41c0e4be3eap-1,    0x1.2ba4b4f8b4bcfp+0,  -0x1.eeae44p-2, INEXACT)
T(RN,    0x1.b93cf81aa9c4ap-1,    0x1.2a706434d058ap+0,   0x1.a032f2p-2, INEXACT)
T(RN,    0x1.b838c9173a28fp-1,    0x1.293e354897bb9p+0,  -0x1.bb1438p-2, INEXACT)
T(RN,    0x1.b735337fc233bp-1,    0x1.280e2227cb412p+0,   0x1.f1d436p-2, INEXACT)
T(RN,    0x1.b63236f9ca265p-1,    0x1.26e024dd91a33p+0,   0x1.bf12fep-2, INEXACT)
T(RN,    0x1.b52fd32b0f995p-1,    0x1.25b4378c06cbfp+0,   0x1.a39568p-2, INEXACT)
T(RN,    0x1.b42e07b9855f3p-1,    0x1.248a546bcd3b9p+0,   0x1.c4d8d6p-2, INEXACT)
T(RN,    0x1.b32cd44b5363cp-1,    0x1.236275cba1e79p+0,   0x1.f846a6p-2, INEXACT)
T(RN,    0x1.b22c3886d68dap-1,    0x1.223c960ff2895p+0,  -0x1.ee645ap-2, INEXACT)
T(RN,    0x1.b12c3412a09e2p-1,    0x1.2118afb27647cp+0,   0x1.e6f34ep-2, INEXACT)
T(RN,    0x1.b02cc6957812fp-1,    0x1.1ff6bd41c8af2p+0,   0x1.ac9e34p-2, INEXACT)
T(RN,    0x1.af2defb65806cp-1,    0x1.1ed6b96106e67p+0,   0x1.fa3f34p-2, INEXACT)
T(RN,    0x1.ae2faf1c70109p-1,    0x1.1db89ec76f114p+0,  -0x1.f7cbacp-2, INEXACT)
T(RN,    0x1.ad32046f2428fp-1,    0x1.1c9c684001d98p+0,   0x1.ba2ec4p-2, INEXACT)
T(RN,    0x1.ac34ef560c862p-1,    0x1.1b8210a926009p+0,   0x1.b28e0cp-2, INEXACT)
T(RN,    0x1.ab386f78f580bp-1,    0x1.1a6992f44e002p+0,   0x1.a88a58p-2, INEXACT)
T(RN,    0x1.aa3c847fdf746p-1,    0x1.1952ea259f9ddp+0,   0x1.9e1b52p-2, INEXACT)
T(RN,    0x1.a9412e12fe9eap-1,    0x1.183e11539d67bp+0,   0x1.ee80f2p-2, INEXACT)
T(RN,    0x1.a8466bdabb041p-1,    0x1.172b03a6d2172p+0,   0x1.bfd174p-2, INEXACT)
T(RN,    0x1.a74c3d7fb04efp-1,    0x1.1619bc597dbeap+0,    0x1.a863ap-2, INEXACT)
T(RN,    0x1.a652a2aaadb1fp-1,    0x1.150a36b744c36p+0,   0x1.b6d8c2p-2, INEXACT)
T(RN,    0x1.a5599b04b5cafp-1,    0x1.13fc6e1ce0926p+0,   0x1.bc89a4p-2, INEXACT)
T(RN,    0x1.a4612636fe80dp-1,    0x1.12f05df7d200dp+0,   0x1.d8aafap-2, INEXACT)
T(RN,    0x1.a36943eaf0e8ep-1,    0x1.11e601c6155a9p+0,   0x1.a14db4p-2, INEXACT)
T(RN,    0x1.a271f3ca29296p-1,    0x1.10dd5515d808fp+0,   0x1.bf0b5ep-2, INEXACT)
T(RN,    0x1.a17b357e76563p-1,    0x1.0fd653852fc48p+0,   0x1.fc0aaep-2, INEXACT)
T(RN,    0x1.a08508b1da589p-1,    0x1.0ed0f8c1d35a3p+0,  -0x1.a6f80ep-2, INEXACT)
T(RN,    0x1.9f8f6d0e89cd5p-1,    0x1.0dcd4088d4e47p+0,   0x1.9ba5cep-2, INEXACT)
T(RN,    0x1.9e9a623eebeaap-1,    0x1.0ccb26a65d802p+0,  -0x1.ce33b6p-2, INEXACT)
T(RN,    0x1.9da5e7ed9a5c8p-1,    0x1.0bcaa6f56a649p+0,   0x1.ac4636p-2, INEXACT)
T(RN,    0x1.9cb1fdc5612d1p-1,    0x1.0acbbd5f8b693p+0,   0x1.c021fep-2, INEXACT)
T(RN,    0x1.9bbea3713ea4cp-1,    0x1.09ce65dca2de4p+0,   0x1.bbd74ap-2, INEXACT)
T(RN,    0x1.9acbd89c6327dp-1,    0x1.08d29c72a6b3dp+0,   0x1.a4217ap-2, INEXACT)
T(RN,    0x1.99d99cf231244p-1,    0x1.07d85d3562fbfp+0,   0x1.e914fcp-2, INEXACT)
T(RN,    0x1.98e7f01e3ce5cp-1,    0x1.06dfa4463d93bp+0,  -0x1.da7c16p-2, INEXACT)
T(RN,    0x1.97f6d1cc4c838p-1,    0x1.05e86dd3fb21ap+0,   0x1.a17b34p-2, INEXACT)
T(RN,    0x1.970641a857bf9p-1,    0x1.04f2b61a85374p+0,   0x1.a64174p-2, INEXACT)
T(RN,    0x1.96163f5e87e9ap-1,    0x1.03fe7962b1a2ap+0,  -0x1.a9d2eap-2, INEXACT)
T(RN,    0x1.9526ca9b37bcap-1,    0x1.030bb4020adedp+0,   0x1.9f417ep-2, INEXACT)
T(RN,    0x1.9437e30af348dp-1,    0x1.021a625a99ae3p+0,   0x1.9b3448p-2, INEXACT)
T(RN,    0x1.9349885a77d21p-1,    0x1.012a80daafc0cp+0,   0x1.999fe4p-2, INEXACT)
T(RN,    0x1.925bba36b3ae3p-1,    0x1.003c0bfcb36a4p+0,   0x1.99f66ap-2, INEXACT)
T(RN,    0x1.916e784cc6733p-1,    0x1.fe9e008dd9652p-1,  -0x1.9e5e46p-2, INEXACT)
T(RN,    0x1.9081c24a0010bp-1,     0x1.fcc6b496a4abp-1,  -0x1.9e5472p-2, INEXACT)
T(RN,     0x1.8f9597dbe1a1p-1,    0x1.faf22d4eb2efcp-1,   -0x1.a290cp-2, INEXACT)
T(RN,    0x1.8ea9f8b01cbf2p-1,    0x1.f920640789b41p-1,   0x1.a7a904p-2, INEXACT)
T(RN,    0x1.8dbee47493949p-1,    0x1.f7515228eb687p-1,  -0x1.b6b168p-2, INEXACT)
T(RN,    0x1.8cd45ad758b9cp-1,    0x1.f584f1307aa5fp-1,  -0x1.c2166ep-2, INEXACT)
T(RN,    0x1.8bea5b86af106p-1,    0x1.f3bb3ab15f292p-1,  -0x1.c7b3bcp-2, INEXACT)
T(RN,    0x1.8b00e63109af4p-1,    0x1.f1f42853ecb4ep-1,  -0x1.c6a1b6p-2, INEXACT)
T(RN,    0x1.8a17fa850bc56p-1,    0x1.f02fb3d54b9ddp-1,   0x1.facd42p-2, INEXACT)
T(RN,    0x1.892f983188785p-1,    0x1.ee6dd70722fccp-1,  -0x1.ac108ep-2, INEXACT)
T(RN,    0x1.8847bee582cf5p-1,    0x1.ecae8bcf44a16p-1,  -0x1.aeff72p-2, INEXACT)
T(RN,    0x1.87606e502d8fcp-1,    0x1.eaf1cc275a847p-1,  -0x1.decc5ap-2, INEXACT)
T(RN,    0x1.8679a620eb277p-1,    0x1.e937921c95e99p-1,  -0x1.b7b832p-2, INEXACT)
T(RN,    0x1.859366074d8a9p-1,    0x1.e77fd7cf5ff3dp-1,   0x1.f108aep-2, INEXACT)
T(RN,    0x1.84adadb3161bfp-1,      0x1.e5ca97730bdp-1,  -0x1.9ce4bcp-2, INEXACT)
T(RN,    0x1.83c87cd435913p-1,    0x1.e417cb4d8a519p-1,  -0x1.cd2562p-2, INEXACT)
T(RN,    0x1.82e3d31acbd27p-1,    0x1.e2676db71ef72p-1,  -0x1.c628b4p-2, INEXACT)
T(RN,    0x1.81ffb03727e31p-1,    0x1.e0b9791a166a4p-1,  -0x1.d3fb32p-2, INEXACT)
T(RN,    0x1.811c13d9c7c4bp-1,    0x1.df0de7f27e553p-1,  -0x1.ac2672p-2, INEXACT)
T(RN,    0x1.8038fdb358597p-1,    0x1.dd64b4cdde90dp-1,  -0x1.e3ef58p-2, INEXACT)
T(RN,    0x1.7f566d74b54b5p-1,    0x1.dbbdda4af3ae4p-1,  -0x1.a41a5cp-2, INEXACT)
T(RN,    0x1.7e7462cee8ee8p-1,    0x1.da1953196ac1ap-1,   0x1.d1095cp-2, INEXACT)
T(RN,     0x1.7d92dd732c26p-1,    0x1.d87719f99e747p-1,  -0x1.cc213ap-2, INEXACT)
T(RN,    0x1.7cb1dd12e64a8p-1,    0x1.d6d729bc55596p-1,  -0x1.dd90bap-2, INEXACT)
T(RN,     0x1.7bd1615fad0bp-1,    0x1.d5397d4281693p-1,  -0x1.b9becap-2, INEXACT)
T(RN,    0x1.7af16a0b44551p-1,    0x1.d39e0f7d00bdap-1,   0x1.b96aaep-2, INEXACT)
T(RN,    0x1.7a11f6c79e376p-1,    0x1.d204db6c5f69ep-1,   0x1.d27358p-2, INEXACT)
T(RN,    0x1.79330746dac86p-1,    0x1.d06ddc209a7d5p-1,   0x1.c6a042p-2, INEXACT)
T(RN,    0x1.78549b3b4808ap-1,    0x1.ced90cb8e41a1p-1,   0x1.e25242p-2, INEXACT)
T(RN,    0x1.7776b25761cabp-1,    0x1.cd46686368abep-1,  -0x1.b6cd8ep-2, INEXACT)
T(RN,    0x1.76994c4dd1952p-1,    0x1.cbb5ea5d1524dp-1,   0x1.a62d66p-2, INEXACT)
T(RN,    0x1.75bc68d16e8a1p-1,    0x1.ca278df15e4dbp-1,   0x1.e38c1ep-2, INEXACT)
T(RN,    0x1.74e007953d4a8p-1,    0x1.c89b4e7a0914cp-1,    0x1.fd348p-2, INEXACT)
T(RN,    0x1.7404284c6fdcfp-1,     0x1.c711275ef3e1p-1,   0x1.9d61e2p-2, INEXACT)
T(RN,    0x1.7328caaa6591bp-1,    0x1.c5891415e0dbbp-1,   -0x1.f6a3bp-2, INEXACT)
T(RN,    0x1.724dee62aae79p-1,    0x1.c4031022412fap-1,    0x1.b5723p-2, INEXACT)
T(RN,    0x1.71739328f9734p-1,    0x1.c27f1715013c5p-1,   0x1.e5f838p-2, INEXACT)
T(RN,    0x1.7099b8b137c2ep-1,    0x1.c0fd248c55ae3p-1,   0x1.e4a51ap-2, INEXACT)
T(RN,    0x1.6fc05eaf7944bp-1,    0x1.bf7d34338981ap-1,   0x1.9eebf6p-2, INEXACT)
T(RN,    0x1.6ee784d7fe2b3p-1,     0x1.bdff41c2cce3p-1,   0x1.b2677cp-2, INEXACT)
T(RN,    0x1.6e0f2adf3353cp-1,    0x1.bc8348ff04efbp-1,  -0x1.acbdc6p-2, INEXACT)
T(RN,    0x1.6d375079b22cfp-1,    0x1.bb0945b99c4efp-1,   -0x1.e7637p-2, INEXACT)
T(RN,    0x1.6c5ff55c409a5p-1,    0x1.b99133d05499ap-1,   0x1.ed455cp-2, INEXACT)
T(RN,    0x1.6b89193bd0dbep-1,    0x1.b81b0f2d1897fp-1,  -0x1.b92e08p-2, INEXACT)
T(RN,    0x1.6ab2bbcd81746p-1,     0x1.b6a6d3c5cf49p-1,   0x1.bc0352p-2, INEXACT)
T(RN,     0x1.69dcdcc69d0cp-1,    0x1.b5347d9c2fa9fp-1,   0x1.d79de6p-2, INEXACT)
T(RN,    0x1.69077bdc9a59dp-1,    0x1.b3c408bd954d2p-1,  -0x1.f8316cp-2, INEXACT)
T(RN,    0x1.683298c51c089p-1,    0x1.b2557142d5a81p-1,   0x1.e0541ep-2, INEXACT)
T(RN,    0x1.675e3335f09bfp-1,    0x1.b0e8b350161ccp-1,  -0x1.ddd716p-2, INEXACT)
T(RN,    0x1.668a4ae51258ep-1,    0x1.af7dcb14a2c17p-1,   0x1.a1c144p-2, INEXACT)
T(RN,    0x1.65b6df88a728ap-1,    0x1.ae14b4cac5d19p-1,   0x1.d0a926p-2, INEXACT)
T(RN,    0x1.64e3f0d70081fp-1,     0x1.acad6cb79fdbp-1,  -0x1.abad46p-2, INEXACT)
T(RN,    0x1.64117e869b4d9p-1,    0x1.ab47ef2b008fap-1,    0x1.c53b1p-2, INEXACT)
T(RN,    0x1.633f884e1fcd7p-1,    0x1.a9e4387f40447p-1,   0x1.cce816p-2, INEXACT)
T(RN,    0x1.626e0de461839p-1,    0x1.a88245191a175p-1,   0x1.a4b76ep-2, INEXACT)
T(RN,    0x1.619d0f005f15fp-1,    0x1.a722116786b1ep-1,    0x1.c56f5p-2, INEXACT)
T(RN,     0x1.60cc8b59423ap-1,     0x1.a5c399e397b9p-1,   0x1.b8c48ep-2, INEXACT)
T(RN,    0x1.5ffc82a65f95bp-1,    0x1.a466db1053c76p-1,   0x1.aaf662p-2, INEXACT)
T(RN,    0x1.5f2cf49f36ab8p-1,     0x1.a30bd17a9314p-1,  -0x1.fb6cdcp-2, INEXACT)
T(RN,    0x1.5e5de0fb71ba1p-1,    0x1.a1b279b8dc9a9p-1,   -0x1.beb72p-2, INEXACT)
T(RN,    0x1.5d8f4772e5ab4p-1,    0x1.a05ad06b43f0fp-1,   0x1.af7066p-2, INEXACT)
T(RN,    0x1.5cc127bd91f58p-1,    0x1.9f04d23b4796bp-1,    0x1.99fdfp-2, INEXACT)
T(RN,    0x1.5bf38193a084ap-1,    0x1.9db07bdbafdf4p-1,  -0x1.a28b2ep-2, INEXACT)
T(RN,    0x1.5b2654ad65a07p-1,    0x1.9c5dca086e638p-1,  -0x1.b33d92p-2, INEXACT)
T(RN,    0x1.5a59a0c35fd4cp-1,     0x1.9b0cb9867dfep-1,   0x1.f01712p-2, INEXACT)
T(RN,    0x1.598d658e37d52p-1,    0x1.99bd4723c3466p-1,   0x1.9f6006p-2, INEXACT)
T(RN,    0x1.58c1a2c6c067dp-1,    0x1.986f6fb6ed9c4p-1,  -0x1.dec334p-2, INEXACT)
T(RN,    0x1.57f65825f64cep-1,    0x1.9723301f58ac8p-1,  -0x1.a9bb84p-2, INEXACT)
T(RN,    0x1.572b856500217p-1,    0x1.95d88544ee6e8p-1,    0x1.b5f64p-2, INEXACT)
T(RN,    0x1.56612a3d2e4b6p-1,    0x1.948f6c1809ab8p-1,   0x1.9f3c94p-2, INEXACT)
T(RN,    0x1.55974667fade7p-1,    0x1.9347e19158f54p-1,   0x1.be248ep-2, INEXACT)
T(RN,    0x1.54cdd99f09844p-1,    0x1.9201e2b1c2185p-1,   0x1.dbf47ap-2, INEXACT)
T(RN,    0x1.5404e39c27638p-1,    0x1.90bd6c8246028p-1,  -0x1.fd0678p-2, INEXACT)
T(RN,    0x1.533c64194b085p-1,    0x1.8f7a7c13e51e9p-1,   0x1.cb7f5ep-2, INEXACT)
T(RN,    0x1.52745ad0944a8p-1,    0x1.8e390e7f841c6p-1,  -0x1.b21248p-2, INEXACT)
T(RN,    0x1.51acc77c4c369p-1,    0x1.8cf920e5d12dep-1,   0x1.cd192ap-2, INEXACT)
T(RN,    0x1.50e5a9d6e4f43p-1,     0x1.8bbab06f29abp-1,   0x1.ef6ee4p-2, INEXACT)
T(RN,    0x1.501f019af9aecp-1,     0x1.8a7dba4b8025p-1,   0x1.f844b6p-2, INEXACT)
T(RN,    0x1.4f58ce834e7d1p-1,    0x1.89423bb242e06p-1,  -0x1.dccba2p-2, INEXACT)
T(RN,    0x1.4e93104ad0492p-1,    0x1.880831e242b64p-1,  -0x1.fce40ep-2, INEXACT)
T(RN,    0x1.4dcdc6ac94b87p-1,     0x1.86cf9a219a5bp-1,   0x1.9eee66p-2, INEXACT)
T(RN,     0x1.4d08f163da13p-1,    0x1.859871bd96063p-1,   0x1.de9be6p-2, INEXACT)
T(RN,    0x1.4c44902c072c4p-1,    0x1.8462b60a9b7f1p-1,  -0x1.d338f8p-2, INEXACT)
T(RN,    0x1.4b80a2c0ab4adp-1,    0x1.832e646412868p-1,   -0x1.e6277p-2, INEXACT)
T(RN,    0x1.4abd28dd7e107p-1,    0x1.81fb7a2c4d9ebp-1,  -0x1.fac914p-2, INEXACT)
T(RN,    0x1.49fa223e5f638p-1,    0x1.80c9f4cc7331ep-1,  -0x1.f2fee2p-2, INEXACT)
T(RN,     0x1.49378e9f5755p-1,    0x1.7f99d1b4670ddp-1,    0x1.fc939p-2, INEXACT)
T(RN,    0x1.48756dbc960a7p-1,    0x1.7e6b0e5ab43ddp-1,   0x1.a79a78p-2, INEXACT)
T(RN,    0x1.47b3bf5273a66p-1,    0x1.7d3da83c773a9p-1,   0x1.df9ac6p-2, INEXACT)
T(RN,    0x1.46f2831d70305p-1,    0x1.7c119cdd486ddp-1,   0x1.e4ee24p-2, INEXACT)
T(RN,     0x1.4631b8da337cp-1,    0x1.7ae6e9c72709bp-1,   0x1.d460f6p-2, INEXACT)
T(RN,    0x1.457160458d14ep-1,    0x1.79bd8c8a6438ep-1,   0x1.e27a36p-2, INEXACT)
T(RN,    0x1.44b1791c74234p-1,    0x1.789582bd8e964p-1,   0x1.c72eeap-2, INEXACT)
T(RN,    0x1.43f2031c07581p-1,    0x1.776ec9fd5dfe5p-1,   -0x1.d0994p-2, INEXACT)
T(RN,    0x1.4332fe018cd2ap-1,    0x1.76495fec9fa5fp-1,   0x1.d41c96p-2, INEXACT)
T(RN,    0x1.4274698a720c6p-1,    0x1.7525423422867p-1,    0x1.d61f8p-2, INEXACT)
T(RN,    0x1.41b645744bc01p-1,    0x1.74026e82a40f4p-1,   0x1.a1cae8p-2, INEXACT)
T(RN,    0x1.40f8917cd5d0cp-1,    0x1.72e0e28cbd20cp-1,   0x1.a854d2p-2, INEXACT)
T(RN,     0x1.403b4d61f338p-1,    0x1.71c09c0ccf5b4p-1,   0x1.b9c7b4p-2, INEXACT)
T(RN,    0x1.3f7e78e1ade7cp-1,    0x1.70a198c2f2a2dp-1,   0x1.aafa54p-2, INEXACT)
T(RN,    0x1.3ec213ba36b98p-1,    0x1.6f83d674e2fdcp-1,   0x1.b64d94p-2, INEXACT)
T(RN,    0x1.3e061da9e553bp-1,    0x1.6e6752edeea95p-1,   0x1.9dcddep-2, INEXACT)
T(RN,    0x1.3d4a966f38165p-1,    0x1.6d4c0bfee47d6p-1,   0x1.a8910cp-2, INEXACT)
T(RN,    0x1.3c8f7dc8d4018p-1,    0x1.6c31ff7e0289bp-1,    0x1.de324p-2, INEXACT)
T(RN,    0x1.3bd4d375849a9p-1,    0x1.6b192b46e4f28p-1,  -0x1.fcde42p-2, INEXACT)
T(RN,    0x1.3b1a97343ba08p-1,    0x1.6a018d3a74c54p-1,  -0x1.99b248p-2, INEXACT)
T(RN,    0x1.3a60c8c412205p-1,    0x1.68eb233ed91b9p-1,  -0x1.99b48ep-2, INEXACT)
T(RN,    0x1.39a767e4460e2p-1,    0x1.67d5eb3f63448p-1,  -0x1.a3cae4p-2, INEXACT)
T(RN,    0x1.38ee74543c64fp-1,    0x1.66c1e32c81f4dp-1,   0x1.de6f88p-2, INEXACT)
T(RN,    0x1.3835edd3800e5p-1,    0x1.65af08fbafdedp-1,  -0x1.cc7a88p-2, INEXACT)
T(RN,    0x1.377dd421c1f1dp-1,    0x1.649d5aa764421p-1,  -0x1.a13964p-2, INEXACT)
T(RN,    0x1.36c626fed8e54p-1,    0x1.638cd62f03854p-1,   0x1.eae606p-2, INEXACT)
T(RN,    0x1.360ee62ac18e8p-1,    0x1.627d7996cff45p-1,  -0x1.a6ceacp-2, INEXACT)
T(RN,    0x1.355811659e57bp-1,    0x1.616f42e7dad29p-1,   0x1.a975ecp-2, INEXACT)
T(RN,    0x1.34a1a86fb74fep-1,    0x1.6062302ff585dp-1,   -0x1.b809cp-2, INEXACT)
T(RN,    0x1.33ebab097a1b5p-1,    0x1.5f563f81a3108p-1,  -0x1.b17b88p-2, INEXACT)
T(RN,    0x1.333618f379d8ep-1,    0x1.5e4b6ef409afep-1,  -0x1.ce69f2p-2, INEXACT)
T(RN,    0x1.3280f1ee6f0f8p-1,    0x1.5d41bca2e4bb6p-1,  -0x1.d46c5ap-2, INEXACT)
T(RN,    0x1.31cc35bb3795fp-1,     0x1.5c3926ae76afp-1,    0x1.a5c09p-2, INEXACT)
T(RN,    0x1.3117e41ad67bbp-1,     0x1.5b31ab3b7b6ap-1,  -0x1.c329fap-2, INEXACT)
T(RN,    0x1.3063fcce73f62p-1,    0x1.5a2b48731aa67p-1,  -0x1.ef7b3ap-2, INEXACT)
T(RN,    0x1.2fb07f975d493p-1,    0x1.5925fc82da9a5p-1,   -0x1.c72b3p-2, INEXACT)
T(RN,    0x1.2efd6c3704b0fp-1,    0x1.5821c59c92cb1p-1,  -0x1.ae778ep-2, INEXACT)
T(RN,    0x1.2e4ac26f014bbp-1,    0x1.571ea1f65f112p-1,  -0x1.e20c9ep-2, INEXACT)
T(RN,    0x1.2d9882010f05ep-1,    0x1.561c8fca92ccdp-1,  -0x1.fd88aep-2, INEXACT)
T(RN,    0x1.2ce6aaaf0e82cp-1,    0x1.551b8d57ac449p-1,   0x1.b14682p-2, INEXACT)
T(RN,    0x1.2c353c3b0506dp-1,    0x1.541b98e04832bp-1,   0x1.fce2ccp-2, INEXACT)
T(RN,    0x1.2b8436671c633p-1,    0x1.531cb0ab15818p-1,   0x1.ec8546p-2, INEXACT)
T(RN,    0x1.2ad398f5a2df6p-1,    0x1.521ed302c9304p-1,  -0x1.f9ae72p-2, INEXACT)
T(RN,    0x1.2a2363a90b24dp-1,    0x1.5121fe3612664p-1,  -0x1.f53778p-2, INEXACT)
T(RN,    0x1.29739643ec26dp-1,    0x1.502630978eaa9p-1,   0x1.da66c6p-2, INEXACT)
T(RN,    0x1.28c43089010fcp-1,    0x1.4f2b687dbe4d3p-1,   0x1.d603aep-2, INEXACT)
T(RN,    0x1.2815323b292b3p-1,    0x1.4e31a442f8f51p-1,  -0x1.ae7cb6p-2, INEXACT)
T(RN,      0x1.27669b1d67dp-1,    0x1.4d38e24562563p-1,   0x1.d8008cp-2, INEXACT)
T(RN,    0x1.26b86af2e44a9p-1,    0x1.4c4120e6df0efp-1,  -0x1.f87d58p-2, INEXACT)
T(RN,    0x1.260aa17ee9c95p-1,    0x1.4b4a5e8d09b13p-1,   0x1.d1deaap-2, INEXACT)
T(RN,    0x1.255d3e84e7468p-1,    0x1.4a5499a127ec2p-1,   0x1.dd2632p-2, INEXACT)
T(RN,    0x1.24b041c86f72fp-1,    0x1.495fd0901fdecp-1,  -0x1.d2efdcp-2, INEXACT)
T(RN,    0x1.2403ab0d38a0ap-1,    0x1.486c01ca6d8ecp-1,   -0x1.b2c4fp-2, INEXACT)
T(RN,    0x1.23577a171caf1p-1,    0x1.47792bc418862p-1,   -0x1.ccaaap-2, INEXACT)
T(RN,    0x1.22abaeaa18f52p-1,    0x1.46874cf4a991fp-1,  -0x1.dfb8d8p-2, INEXACT)
T(RN,    0x1.2200488a4e2d3p-1,    0x1.459663d720a76p-1,  -0x1.f52264p-2, INEXACT)
T(RN,    0x1.2155477c005e9p-1,    0x1.44a66ee9eae81p-1,   0x1.c8313ep-2, INEXACT)
T(RN,    0x1.20aaab4396cadp-1,    0x1.43b76caed8cddp-1,  -0x1.9d25b6p-2, INEXACT)
T(RN,    0x1.200073a59bd72p-1,    0x1.42c95bab14739p-1,   0x1.e22216p-2, INEXACT)
T(RN,    0x1.1f56a066bcf87p-1,     0x1.41dc3a671802p-1,  -0x1.ce469ep-2, INEXACT)
T(RN,    0x1.1ead314bca9f3p-1,    0x1.40f0076ea43e2p-1,    0x1.db606p-2, INEXACT)
T(RN,    0x1.1e042619b821fp-1,    0x1.4004c150b734cp-1,   0x1.9e613ap-2, INEXACT)
T(RN,    0x1.1d5b7e959ba92p-1,    0x1.3f1a669f8308dp-1,   0x1.eebf26p-2, INEXACT)
T(RN,    0x1.1cb33a84ae19ap-1,    0x1.3e30f5f064de4p-1,  -0x1.cf617cp-2, INEXACT)
T(RN,    0x1.1c0b59ac4b024p-1,    0x1.3d486ddbdbe87p-1,  -0x1.e50106p-2, INEXACT)
T(RN,    0x1.1b63dbd1f0865p-1,    0x1.3c60ccfd80922p-1,  -0x1.d91b5ep-2, INEXACT)
T(RN,    0x1.1abcc0bb3f479p-1,     0x1.3b7a11f3fbc3p-1,   0x1.d8e628p-2, INEXACT)
T(RN,    0x1.1a16082dfa549p-1,    0x1.3a943b60fe482p-1,  -0x1.a24c46p-2, INEXACT)
T(RN,    0x1.196fb1f00712ep-1,    0x1.39af47e938547p-1,   0x1.d11144p-2, INEXACT)
T(RN,    0x1.18c9bdc76d2b8p-1,    0x1.38cb3634511f7p-1,   0x1.b60e1ep-2, INEXACT)
T(RN,    0x1.18242b7a56759p-1,    0x1.37e804ecde9eep-1,   0x1.a43b9ap-2, INEXACT)
T(RN,    0x1.177efacf0ee31p-1,     0x1.3705b2c05d5ep-1,   0x1.d37718p-2, INEXACT)
T(RN,    0x1.16da2b8c046ddp-1,    0x1.36243e5f28708p-1,  -0x1.9c15d4p-2, INEXACT)
T(RN,    0x1.1635bd77c6fffp-1,    0x1.3543a67c717a7p-1,   0x1.f4ab3ep-2, INEXACT)
T(RN,    0x1.1591b05908645p-1,    0x1.3463e9ce38dc8p-1,   -0x1.f3aeep-2, INEXACT)
T(RN,    0x1.14ee03f69c2e8p-1,    0x1.3385070d45f01p-1,    0x1.aeb4ap-2, INEXACT)
T(RN,    0x1.144ab81777aa7p-1,    0x1.32a6fcf51f65ap-1,  -0x1.b0ffd2p-2, INEXACT)
T(RN,    0x1.13a7cc82b1c48p-1,    0x1.31c9ca4403b3ep-1,   0x1.d478b2p-2, INEXACT)
T(RN,    0x1.130540ff82fb4p-1,     0x1.30ed6dbae1abp-1,   0x1.fe697ep-2, INEXACT)
T(RN,    0x1.1263155545451p-1,    0x1.3011e61d51115p-1,   -0x1.f574dp-2, INEXACT)
T(RN,    0x1.11c1494b74016p-1,    0x1.2f3732318b673p-1,  -0x1.f05a9cp-2, INEXACT)
T(RN,    0x1.111fdca9abe26p-1,    0x1.2e5d50c064b83p-1,   0x1.aaec6ap-2, INEXACT)
T(RN,    0x1.107ecf37aadcdp-1,    0x1.2d844095448c1p-1,  -0x1.e76f5ap-2, INEXACT)
T(RN,    0x1.0fde20bd500e1p-1,    0x1.2cac007e1ee23p-1,   0x1.ae8fe4p-2, INEXACT)
T(RN,    0x1.0f3dd1029baeep-1,    0x1.2bd48f4b6d537p-1,   0x1.a13bd4p-2, INEXACT)
T(RN,    0x1.0e9ddfcfaefc2p-1,    0x1.2afdebd0283e5p-1,   0x1.b09806p-2, INEXACT)
T(RN,    0x1.0dfe4ceccc27ap-1,    0x1.2a2814e1c012fp-1,     -0x1.ccep-2, INEXACT)
T(RN,    0x1.0d5f1822563aep-1,    0x1.2953095816a29p-1,   0x1.a4d2bep-2, INEXACT)
T(RN,    0x1.0cc04138d10f9p-1,    0x1.287ec80d78a0bp-1,   0x1.9b8fccp-2, INEXACT)
T(RN,    0x1.0c21c7f8e13ebp-1,    0x1.27ab4fde972dbp-1,   0x1.d30baap-2, INEXACT)
T(RN,    0x1.0b83ac2b4bedfp-1,    0x1.26d89faa81485p-1,  -0x1.9b4308p-2, INEXACT)
T(RN,    0x1.0ae5ed98f6f27p-1,    0x1.2606b6529dc62p-1,  -0x1.9d8a24p-2, INEXACT)
T(RN,    0x1.0a488c0ae8891p-1,    0x1.253592baa4d18p-1,  -0x1.9ef224p-2, INEXACT)
T(RN,    0x1.09ab874a475f9p-1,    0x1.246533c899e7dp-1,   0x1.b3cbe8p-2, INEXACT)
T(RN,    0x1.090edf205a7e3p-1,    0x1.23959864c5c09p-1,  -0x1.b014cap-2, INEXACT)
T(RN,    0x1.087293568930bp-1,    0x1.22c6bf79b047dp-1,  -0x1.a19884p-2, INEXACT)
T(RN,    0x1.07d6a3b65af3ep-1,    0x1.21f8a7f41ab0ap-1,  -0x1.9f0a5cp-2, INEXACT)
T(RN,    0x1.073b100977633p-1,     0x1.212b50c2f99bp-1,  -0x1.b91576p-2, INEXACT)
T(RN,    0x1.069fd819a625ep-1,    0x1.205eb8d76f4b7p-1,  -0x1.b3d50cp-2, INEXACT)
T(RN,    0x1.0604fbb0cedb5p-1,    0x1.1f92df24c5f39p-1,  -0x1.9c1786p-2, INEXACT)
T(RN,    0x1.056a7a98f90a5p-1,    0x1.1ec7c2a06a10ap-1,  -0x1.9e795ep-2, INEXACT)
T(RN,    0x1.04d0549c4c0b3p-1,    0x1.1dfd6241e4d4cp-1,  -0x1.a47996p-2, INEXACT)
T(RN,    0x1.043689850ef78p-1,    0x1.1d33bd02d6a91p-1,  -0x1.d80536p-2, INEXACT)
T(RN,    0x1.039d191da896bp-1,    0x1.1c6ad1def1bcep-1,  -0x1.bd7706p-2, INEXACT)
T(RN,    0x1.030403309f4a8p-1,    0x1.1ba29fd3f4a59p-1,   0x1.a06564p-2, INEXACT)
T(RN,    0x1.026b478898fccp-1,    0x1.1adb25e1a5109p-1,  -0x1.9e053cp-2, INEXACT)
T(RN,    0x1.01d2e5f05b0e2p-1,    0x1.1a146309ca87fp-1,  -0x1.a510aep-2, INEXACT)
T(RN,    0x1.013ade32ca419p-1,    0x1.194e56502941ap-1,  -0x1.f672b6p-2, INEXACT)
T(RN,    0x1.00a3301aeaaaap-1,    0x1.1888feba7d036p-1,  -0x1.a12686p-2, INEXACT)
T(RN,    0x1.000bdb73df9bfp-1,    0x1.17c45b5074162p-1,  -0x1.e4bcbap-2, INEXACT)
T(RN,    0x1.fee9c011d7267p-2,     0x1.17006b1baa46p-1,   0x1.ddab46p-2, INEXACT)
T(RN,    0x1.fdbc7b4ae04dfp-2,    0x1.163d2d27a3f35p-1,  -0x1.b63ec4p-2, INEXACT)
T(RN,     0x1.fc8fe829dbedp-2,    0x1.157aa081c936ap-1,   -0x1.b821bp-2, INEXACT)
T(RN,    0x1.fb64064609287p-2,    0x1.14b8c439610b2p-1,    0x1.db74cp-2, INEXACT)
T(RN,    0x1.fa38d536e4eb6p-2,    0x1.13f7975f8c8fbp-1,   -0x1.b0bb6p-2, INEXACT)
T(RN,    0x1.f90e549429c22p-2,    0x1.1337190742538p-1,  -0x1.a02836p-2, INEXACT)
T(RN,    0x1.f7e483f5cfb41p-2,    0x1.1277484549af4p-1,  -0x1.b53e14p-2, INEXACT)
T(RN,    0x1.f6bb62f40c218p-2,    0x1.11b82430362fdp-1,  -0x1.a821e6p-2, INEXACT)
T(RN,    0x1.f592f127519e1p-2,    0x1.10f9abe0630c4p-1,   0x1.f0daf8p-2, INEXACT)
T(RN,    0x1.f46b2e284fcd5p-2,    0x1.103bde6feeaabp-1,  -0x1.b462f8p-2, INEXACT)
T(RN,    0x1.f344198ff33e8p-2,     0x1.0f7ebafab633p-1,   0x1.9ebc2ep-2, INEXACT)
T(RN,    0x1.f21db2f76548dp-2,    0x1.0ec2409e512dbp-1,  -0x1.db388cp-2, INEXACT)
T(RN,    0x1.f0f7f9f80be6ap-2,    0x1.0e066e7a0d30ep-1,  -0x1.db870ep-2, INEXACT)
T(RN,    0x1.efd2ee2b8993dp-2,    0x1.0d4b43aee99adp-1,  -0x1.cd9becp-2, INEXACT)
T(RN,    0x1.eeae8f2bbd289p-2,    0x1.0c90bf5f9357dp-1,   0x1.cf5e62p-2, INEXACT)
T(RN,    0x1.ed8adc92c1b46p-2,    0x1.0bd6e0b060b44p-1,  -0x1.ee4894p-2, INEXACT)
T(RN,    0x1.ec67d5faee5dcp-2,    0x1.0b1da6c74d3eep-1,  -0x1.cc72b8p-2, INEXACT)
T(RN,    0x1.eb457afed63ddp-2,    0x1.0a6510cbf5b3ap-1,  -0x1.d247fep-2, INEXACT)
T(RN,     0x1.ea23cb39483ap-2,    0x1.09ad1de793f23p-1,  -0x1.a59714p-2, INEXACT)
T(RN,    0x1.e902c6454ee53p-2,    0x1.08f5cd44fb04ep-1,   0x1.a14074p-2, INEXACT)
T(RN,    0x1.e7e26bbe30599p-2,    0x1.083f1e10932e7p-1,  -0x1.e7a472p-2, INEXACT)
T(RN,    0x1.e6c2bb3f6e169p-2,    0x1.07890f785606ep-1,    0x1.ff0cep-2, INEXACT)
T(RN,    0x1.e5a3b464c4ddbp-2,    0x1.06d3a0abcaa19p-1,  -0x1.e0feb6p-2, INEXACT)
T(RN,    0x1.e48556ca2c8f8p-2,    0x1.061ed0dc01c08p-1,  -0x1.f3d09cp-2, INEXACT)
T(RN,    0x1.e367a20bd8099p-2,    0x1.056a9f3b9211dp-1,   0x1.c1d41cp-2, INEXACT)
T(RN,    0x1.e24a95c635014p-2,    0x1.04b70afe9476ep-1,  -0x1.d870a6p-2, INEXACT)
T(RN,    0x1.e12e3195ebe4cp-2,    0x1.0404135aa05abp-1,  -0x1.f13bcap-2, INEXACT)
T(RN,    0x1.e0127517dfb4fp-2,    0x1.0351b786c80d6p-1,  -0x1.e26d52p-2, INEXACT)
T(RN,    0x1.def75fe92de53p-2,    0x1.029ff6bb952eep-1,   0x1.e690bep-2, INEXACT)
T(RN,    0x1.dddcf1a72e36fp-2,    0x1.01eed0330520cp-1,   0x1.b7cc82p-2, INEXACT)
T(RN,    0x1.dcc329ef72994p-2,    0x1.013e432885856p-1,  -0x1.faf8a2p-2, INEXACT)
T(RN,    0x1.dbaa085fc7063p-2,    0x1.008e4ed8f0c79p-1,  -0x1.f016d4p-2, INEXACT)
T(RN,    0x1.da918c96315cdp-2,    0x1.ffbde5051553bp-2,  -0x1.99a1c8p-2, INEXACT)
T(RN,    0x1.d979b630f14a5p-2,     0x1.fe605ac9f9d3p-2,  -0x1.9e9f16p-2, INEXACT)
T(RN,    0x1.d86284ce80173p-2,    0x1.fd03fd82a7b39p-2,   0x1.a4743cp-2, INEXACT)
T(RN,    0x1.d74bf80d908f6p-2,    0x1.fba8cbb3f632ap-2,  -0x1.a5c774p-2, INEXACT)
T(RN,    0x1.d6360f8d0ee3ep-2,    0x1.fa4ec3e5749acp-2,  -0x1.adacfep-2, INEXACT)
T(RN,    0x1.d520caec207f8p-2,    0x1.f8f5e4a163bc1p-2,   0x1.cd5ccap-2, INEXACT)
T(RN,    0x1.d40c29ca23eb3p-2,    0x1.f79e2c74af8aep-2,   0x1.f87b58p-2, INEXACT)
T(RN,    0x1.d2f82bc6b0aa5p-2,    0x1.f64799eee8c6cp-2,  -0x1.9d14a6p-2, INEXACT)
T(RN,    0x1.d1e4d081971b2p-2,    0x1.f4f22ba23eb88p-2,  -0x1.bb40dcp-2, INEXACT)
T(RN,    0x1.d0d2179ae050ep-2,    0x1.f39de02378f9ep-2,   0x1.f03f52p-2, INEXACT)
T(RN,    0x1.cfc000b2cdf75p-2,    0x1.f24ab609f15aap-2,   0x1.d8af48p-2, INEXACT)
T(RN,    0x1.ceae8b69da2e2p-2,    0x1.f0f8abef8dcd3p-2,   0x1.e03106p-2, INEXACT)
T(RN,    0x1.cd9db760b768ep-2,    0x1.efa7c070ba697p-2,  -0x1.afd634p-2, INEXACT)
T(RN,    0x1.cc8d8438504dep-2,    0x1.ee57f22c637f9p-2,  -0x1.eb8734p-2, INEXACT)
T(RN,    0x1.cb7df191c7946p-2,    0x1.ed093fc3efba3p-2,   0x1.f420e6p-2, INEXACT)
T(RN,    0x1.ca6eff0e77e3bp-2,    0x1.ebbba7db3a524p-2,  -0x1.e4f99ep-2, INEXACT)
T(RN,    0x1.c960ac4ff3b29p-2,    0x1.ea6f29188d541p-2,  -0x1.f291ccp-2, INEXACT)
T(RN,    0x1.c852f8f805267p-2,    0x1.e923c2249bf32p-2,   0x1.eb2f2ep-2, INEXACT)
T(RN,     0x1.c745e4a8adf2p-2,    0x1.e7d971aa7ced7p-2,  -0x1.cbad12p-2, INEXACT)
T(RN,    0x1.c6396f0427343p-2,    0x1.e6903657a4ff8p-2,  -0x1.a9ce14p-2, INEXACT)
T(RN,    0x1.c52d97ace158dp-2,    0x1.e5480edbe168ap-2,   0x1.e395ccp-2, INEXACT)
T(RN,    0x1.c4225e4583f6ap-2,    0x1.e400f9e9527bfp-2,   0x1.bbd2a8p-2, INEXACT)
T(RN,    0x1.c317c270edafcp-2,    0x1.e2baf63466438p-2,   0x1.e402c8p-2, INEXACT)
T(RN,    0x1.c20dc3d234104p-2,    0x1.e1760273d32f7p-2,   0x1.a02178p-2, INEXACT)
T(RN,    0x1.c104620ca36ebp-2,    0x1.e0321d6092d67p-2,  -0x1.bae3c6p-2, INEXACT)
T(RN,    0x1.bffb9cc3becafp-2,    0x1.deef45b5dcc2bp-2,  -0x1.df23a2p-2, INEXACT)
T(RN,     0x1.bef3739b3fafp-2,    0x1.ddad7a31214f2p-2,   0x1.fc95fap-2, INEXACT)
T(RN,    0x1.bdebe637160e5p-2,    0x1.dc6cb99204911p-2,   -0x1.c6a4ap-2, INEXACT)
T(RN,    0x1.bce4f43b68247p-2,    0x1.db2d029a594fap-2,   -0x1.fc303p-2, INEXACT)
T(RN,    0x1.bbde9d4c92583p-2,    0x1.d9ee540e1c0d3p-2,  -0x1.efe6d6p-2, INEXACT)
T(RN,    0x1.bad8e10f2717ap-2,    0x1.d8b0acb36e16ap-2,   0x1.c8a498p-2, INEXACT)
T(RN,     0x1.b9d3bf27eebcp-2,     0x1.d7740b5290a9p-2,   0x1.da1f14p-2, INEXACT)
T(RN,    0x1.b8cf373be7673p-2,    0x1.d6386eb5e01d3p-2,   0x1.9b6d18p-2, INEXACT)
T(RN,     0x1.b7cb48f044e6p-2,    0x1.d4fdd5a9cf25fp-2,   0x1.e78986p-2, INEXACT)
T(RN,    0x1.b6c7f3ea708e2p-2,    0x1.d3c43efce215cp-2,   0x1.bd63fap-2, INEXACT)
T(RN,    0x1.b5c537d009222p-2,    0x1.d28ba97faa38dp-2,  -0x1.ee834cp-2, INEXACT)
T(RN,    0x1.b4c31446e2ad9p-2,    0x1.d1541404c1323p-2,  -0x1.efba88p-2, INEXACT)
T(RN,    0x1.b3c188f50669bp-2,    0x1.d01d7d60c46f5p-2,   0x1.d5a448p-2, INEXACT)
T(RN,    0x1.b2c09580b29b1p-2,    0x1.cee7e46a509f8p-2,   0x1.e68146p-2, INEXACT)
T(RN,    0x1.b1c039905a746p-2,    0x1.cdb347f9fd3e1p-2,  -0x1.afac86p-2, INEXACT)
T(RN,    0x1.b0c074caa5f52p-2,    0x1.cc7fa6ea58234p-2,   0x1.fa9b0ap-2, INEXACT)
T(RN,    0x1.afc146d671ccep-2,    0x1.cb4d0017e125fp-2,   0x1.bf38eap-2, INEXACT)
T(RN,    0x1.aec2af5acf3a6p-2,    0x1.ca1b526105c52p-2,   0x1.fc553cp-2, INEXACT)
T(RN,    0x1.adc4adff03ed7p-2,    0x1.c8ea9ca61cdf5p-2,  -0x1.c7e89ap-2, INEXACT)
T(RN,    0x1.acc7426a89e76p-2,    0x1.c7baddc962744p-2,  -0x1.c8934cp-2, INEXACT)
T(RN,    0x1.abca6c450f5d1p-2,    0x1.c68c14aef3733p-2,  -0x1.df65cap-2, INEXACT)
T(RN,    0x1.aace2b3676973p-2,    0x1.c55e403cc992bp-2,  -0x1.b406ecp-2, INEXACT)
T(RN,    0x1.a9d27ee6d5d44p-2,    0x1.c4315f5ab7353p-2,  -0x1.e44d1cp-2, INEXACT)
T(RN,    0x1.a8d766fe77293p-2,    0x1.c30570f26356fp-2,   0x1.f8bb36p-2, INEXACT)
T(RN,    0x1.a7dce325d8646p-2,    0x1.c1da73ef45892p-2,    0x1.eacbbp-2, INEXACT)
T(RN,    0x1.a6e2f305aaec8p-2,    0x1.c0b0673ea1f34p-2,  -0x1.fb7064p-2, INEXACT)
T(RN,    0x1.a5e99646d3a53p-2,    0x1.bf8749cf85658p-2,  -0x1.bf44c4p-2, INEXACT)
T(RN,    0x1.a4f0cc926acdcp-2,    0x1.be5f1a92c16e3p-2,   0x1.ce398ap-2, INEXACT)
T(RN,    0x1.a3f89591bbe51p-2,    0x1.bd37d87ae87fcp-2,  -0x1.f16766p-2, INEXACT)
T(RN,    0x1.a300f0ee458abp-2,    0x1.bc11827c4a1e1p-2,  -0x1.d73e24p-2, INEXACT)
T(RN,    0x1.a209de51b9604p-2,     0x1.baec178cef15p-2,   0x1.c97ec4p-2, INEXACT)
T(RN,    0x1.a1135d65fbeb7p-2,    0x1.b9c796a495ba2p-2,  -0x1.a88d84p-2, INEXACT)
T(RN,    0x1.a01d6dd52478ap-2,    0x1.b8a3febcae395p-2,  -0x1.9a2f16p-2, INEXACT)
T(RN,    0x1.9f280f497cfc8p-2,    0x1.b7814ed056e8cp-2,  -0x1.c201ecp-2, INEXACT)
T(RN,    0x1.9e33416d81f64p-2,    0x1.b65f85dc58a7fp-2,  -0x1.efe004p-2, INEXACT)
T(RN,    0x1.9d3f03ebe2524p-2,    0x1.b53ea2df23486p-2,   0x1.fb158ap-2, INEXACT)
T(RN,    0x1.9c4b566f7f4a4p-2,    0x1.b41ea4d8c9fc4p-2,  -0x1.ebd3c6p-2, INEXACT)
T(RN,    0x1.9b5838a36c4b9p-2,    0x1.b2ff8acaffd65p-2,  -0x1.c24768p-2, INEXACT)
T(RN,    0x1.9a65aa32eed57p-2,    0x1.b1e153b914486p-2,   0x1.f08f62p-2, INEXACT)
T(RN,    0x1.9973aac97e5dcp-2,    0x1.b0c3fea7efb2dp-2,  -0x1.e86ef2p-2, INEXACT)
T(RN,    0x1.98823a12c4339p-2,    0x1.afa78a9e0ffaep-2,   -0x1.b14f2p-2, INEXACT)
T(RN,    0x1.979157ba9b612p-2,     0x1.ae8bf6a38528p-2,   0x1.9d4164p-2, INEXACT)
T(RN,    0x1.96a1036d108dfp-2,    0x1.ad7141c1ee0a8p-2,   0x1.f89a6cp-2, INEXACT)
T(RN,    0x1.95b13cd661e35p-2,    0x1.ac576b0474eddp-2,   0x1.c4c242p-2, INEXACT)
T(RN,    0x1.94c203a2feed6p-2,    0x1.ab3e7177cc4e9p-2,  -0x1.bc1988p-2, INEXACT)
T(RN,    0x1.93d3577f887e7p-2,    0x1.aa26542a2b9c3p-2,  -0x1.fc614ep-2, INEXACT)
T(RN,    0x1.92e53818d093bp-2,    0x1.a90f122b4c03dp-2,   -0x1.d3bedp-2, INEXACT)
T(RN,    0x1.91f7a51bda34fp-2,     0x1.a7f8aa8c653ep-2,   0x1.eb1b66p-2, INEXACT)
T(RN,    0x1.910a9e35d959ep-2,    0x1.a6e31c602a6a7p-2,  -0x1.da1b82p-2, INEXACT)
T(RN,    0x1.901e231432ce2p-2,    0x1.a5ce66bac6f31p-2,  -0x1.c4b4dep-2, INEXACT)
T(RN,    0x1.8f3233647c10fp-2,    0x1.a4ba88b1db70dp-2,    0x1.aca0fp-2, INEXACT)
T(RN,    0x1.8e46ced47b3c8p-2,    0x1.a3a7815c7aa1bp-2,   0x1.d418ecp-2, INEXACT)
T(RN,    0x1.8d5bf51226e6ep-2,    0x1.a2954fd3265f2p-2,  -0x1.f0436ap-2, INEXACT)
T(RN,    0x1.8c71a5cba6053p-2,    0x1.a183f32fcc9e8p-2,   0x1.d2384cp-2, INEXACT)
T(RN,    0x1.8b87e0af4fd13p-2,    0x1.a0736a8dc47b4p-2,   0x1.bcab58p-2, INEXACT)
T(RN,    0x1.8a9ea56babaa6p-2,    0x1.9f63b509cb446p-2,   0x1.eacc34p-2, INEXACT)
T(RN,    0x1.89b5f3af70fb6p-2,    0x1.9e54d1c201954p-2,  -0x1.d0ec14p-2, INEXACT)
T(RN,    0x1.88cdcb29871c6p-2,    0x1.9d46bfd5e872fp-2,  -0x1.da1b2ep-2, INEXACT)
T(RN,    0x1.87e62b8905386p-2,    0x1.9c397e665e735p-2,   0x1.b0b25ep-2, INEXACT)
T(RN,    0x1.86ff147d322f4p-2,    0x1.9b2d0c959ce7dp-2,  -0x1.f533c4p-2, INEXACT)
T(RN,    0x1.861885b5847aap-2,    0x1.9a21698735131p-2,   0x1.db58fap-2, INEXACT)
T(RN,    0x1.85327ee1a2115p-2,    0x1.991694600d626p-2,   0x1.d0aef8p-2, INEXACT)
T(RN,    0x1.844cffb1604c8p-2,    0x1.980c8c465eb19p-2,   0x1.e1cf36p-2, INEXACT)
T(RN,    0x1.836807d4c3ca4p-2,    0x1.97035061b1917p-2,    0x1.ae636p-2, INEXACT)
T(RN,    0x1.828396fc0051ep-2,    0x1.95fadfdadb978p-2,  -0x1.f9ed0ap-2, INEXACT)
T(RN,    0x1.819facd778b95p-2,    0x1.94f339dbfcb5ap-2,   0x1.ddf3bep-2, INEXACT)
T(RN,    0x1.80bc4917bec88p-2,    0x1.93ec5d907c952p-2,   0x1.b584eap-2, INEXACT)
T(RN,    0x1.7fd96b6d931d8p-2,    0x1.92e64a2507fa4p-2,  -0x1.d2eb7cp-2, INEXACT)
T(RN,    0x1.7ef71389e5111p-2,     0x1.91e0fec78e2ep-2,   0x1.ceb776p-2, INEXACT)
T(RN,    0x1.7e15411dd29bbp-2,    0x1.90dc7aa73e6e5p-2,  -0x1.d32f44p-2, INEXACT)
T(RN,    0x1.7d33f3daa8391p-2,     0x1.8fd8bcf48564p-2,   0x1.c83086p-2, INEXACT)
T(RN,    0x1.7c532b71e0ce1p-2,    0x1.8ed5c4e10aa01p-2,  -0x1.fffe18p-2, INEXACT)
T(RN,    0x1.7b72e795258b2p-2,    0x1.8dd3919fae1cbp-2,  -0x1.e0af36p-2, INEXACT)
T(RN,    0x1.7a9327f64dd3dp-2,    0x1.8cd2226485c8dp-2,   0x1.f44ad2p-2, INEXACT)
T(RN,    0x1.79b3ec475f219p-2,    0x1.8bd17664db14cp-2,   0x1.a6a698p-2, INEXACT)
T(RN,    0x1.78d5343a8ce85p-2,    0x1.8ad18cd728872p-2,   0x1.c9d74ep-2, INEXACT)
T(RN,    0x1.77f6ff82387d4p-2,    0x1.89d264f317597p-2,  -0x1.db590ep-2, INEXACT)
T(RN,    0x1.77194dd0f0fa6p-2,    0x1.88d3fdf17d176p-2,  -0x1.ecd408p-2, INEXACT)
T(RN,    0x1.763c1ed973232p-2,    0x1.87d6570c59447p-2,    0x1.b5efbp-2, INEXACT)
T(RN,    0x1.755f724ea94b3p-2,     0x1.86d96f7ed30ap-2,   0x1.d7d1b2p-2, INEXACT)
T(RN,    0x1.748347e3ab393p-2,    0x1.85dd468536e68p-2,   0x1.d0c3dep-2, INEXACT)
T(RN,    0x1.73a79f4bbe0e6p-2,    0x1.84e1db5cf4676p-2,   0x1.c0fe2ap-2, INEXACT)
T(RN,    0x1.72cc783a542a4p-2,    0x1.83e72d449be41p-2,   0x1.e7025ep-2, INEXACT)
T(RN,    0x1.71f1d2630d10bp-2,    0x1.82ed3b7bdc413p-2,   0x1.9d699cp-2, INEXACT)
T(RN,    0x1.7117ad79b54f2p-2,    0x1.81f4054380b81p-2,   0x1.dcbe7ap-2, INEXACT)
T(RN,    0x1.703e09324660ep-2,    0x1.80fb89dd6ea25p-2,  -0x1.ddcc8ap-2, INEXACT)
T(RN,    0x1.6f64e540e696bp-2,    0x1.8003c88ca34edp-2,   -0x1.f91d3p-2, INEXACT)
T(RN,    0x1.6e8c4159e8fb9p-2,    0x1.7f0cc09531d81p-2,   0x1.f36b56p-2, INEXACT)
T(RN,    0x1.6db41d31cd389p-2,    0x1.7e16713c40fecp-2,  -0x1.ec4d26p-2, INEXACT)
T(RN,    0x1.6cdc787d3f7e1p-2,    0x1.7d20d9c809104p-2,   0x1.b91bcep-2, INEXACT)
T(RN,    0x1.6c0552f118659p-2,    0x1.7c2bf97fd1c83p-2,   0x1.f72998p-2, INEXACT)
T(RN,    0x1.6b2eac425cda8p-2,    0x1.7b37cfabf0406p-2,   0x1.e9f1aap-2, INEXACT)
T(RN,    0x1.6a5884263dfeap-2,    0x1.7a445b95c4dfap-2,  -0x1.db2eecp-2, INEXACT)
T(RN,    0x1.6982da5219114p-2,    0x1.79519c87b9515p-2,   0x1.c2ef6cp-2, INEXACT)
T(RN,    0x1.68adae7b7752dp-2,    0x1.785f91cd3e7c9p-2,  -0x1.edd8e8p-2, INEXACT)
T(RN,    0x1.67d900580ded4p-2,    0x1.776e3ab2ca872p-2,   0x1.e7cabcp-2, INEXACT)
T(RN,    0x1.6704cf9dbdd93p-2,    0x1.767d9685d6d79p-2,   0x1.d40798p-2, INEXACT)
T(RN,    0x1.66311c0293c3ep-2,    0x1.758da494de1e7p-2,   0x1.ed63b2p-2, INEXACT)
T(RN,    0x1.655de53cc7f72p-2,    0x1.749e642f5a655p-2,   -0x1.f94a7p-2, INEXACT)
T(RN,    0x1.648b2b02be3bfp-2,     0x1.73afd4a5c31dp-2,    0x1.b6411p-2, INEXACT)
T(RN,    0x1.63b8ed0b05c52p-2,    0x1.72c1f5498b385p-2,  -0x1.fa079ap-2, INEXACT)
T(RN,    0x1.62e72b0c5912ap-2,    0x1.71d4c56d1f447p-2,  -0x1.ef8598p-2, INEXACT)
T(RN,    0x1.6215e4bd9dd9cp-2,    0x1.70e84463e389ep-2,   0x1.ab6a78p-2, INEXACT)
T(RN,    0x1.614519d5e4e9cp-2,    0x1.6ffc7182322e3p-2,    0x1.d9c18p-2, INEXACT)
T(RN,    0x1.6074ca0c6a15cp-2,    0x1.6f114c1d59604p-2,  -0x1.9db908p-2, INEXACT)
T(RN,    0x1.5fa4f5189416cp-2,    0x1.6e26d38b997fap-2,   0x1.f2f54ep-2, INEXACT)
T(RN,    0x1.5ed59ab1f4775p-2,    0x1.6d3d072423528p-2,   0x1.ec1bc2p-2, INEXACT)
T(RN,    0x1.5e06ba9047766p-2,    0x1.6c53e63f1636dp-2,   0x1.d58382p-2, INEXACT)
T(RN,    0x1.5d38546b73efbp-2,     0x1.6b6b70357e5dp-2,   0x1.e50cc8p-2, INEXACT)
T(RN,    0x1.5c6a67fb8b435p-2,    0x1.6a83a46153061p-2,   0x1.9c2248p-2, INEXACT)
T(RN,    0x1.5b9cf4f8c93b1p-2,    0x1.699c821d74c35p-2,    0x1.f218ep-2, INEXACT)
T(RN,    0x1.5acffb1b93f2dp-2,    0x1.68b608c5abbd4p-2,   0x1.fa0efap-2, INEXACT)
T(RN,    0x1.5a037a1c7bbe9p-2,    0x1.67d037b6a5fbep-2,  -0x1.ffa21ep-2, INEXACT)
T(RN,    0x1.593771b43b127p-2,    0x1.66eb0e4df5b55p-2,   -0x1.c5ae6p-2, INEXACT)
T(RN,    0x1.586be19bb667dp-2,    0x1.66068bea0f9c8p-2,   0x1.d6cb16p-2, INEXACT)
T(RN,    0x1.57a0c98bfc28ap-2,     0x1.6522afea493bp-2,   0x1.b11deep-2, INEXACT)
T(RN,    0x1.56d6293e44929p-2,    0x1.643f79aed745bp-2,   0x1.c1fee8p-2, INEXACT)
T(RN,    0x1.560c006bf19f9p-2,    0x1.635ce898cbfa9p-2,  -0x1.f0be22p-2, INEXACT)
T(RN,    0x1.55424ece8eee1p-2,    0x1.627afc0a1582ap-2,   0x1.b3efaep-2, INEXACT)
T(RN,    0x1.5479141fd1a89p-2,    0x1.6199b3657c55bp-2,   0x1.bd30e2p-2, INEXACT)
T(RN,     0x1.53b05019986cp-2,    0x1.60b90e0ea1a1ap-2,   0x1.e9130ep-2, INEXACT)
T(RN,    0x1.52e80275eb301p-2,    0x1.5fd90b69fdb68p-2,    0x1.c35f2p-2, INEXACT)
T(RN,    0x1.52202aeefb2dap-2,    0x1.5ef9aadcde748p-2,   0x1.afa184p-2, INEXACT)
T(RN,    0x1.5158c93f22c8ap-2,    0x1.5e1aebcd65c12p-2,   0x1.fe9144p-2, INEXACT)
T(RN,    0x1.5091dd20e5761p-2,    0x1.5d3ccda287fb8p-2,   0x1.b76c18p-2, INEXACT)
T(RN,    0x1.4fcb664eefa3ap-2,     0x1.5c5f4fc40a76p-2,   0x1.a1fde6p-2, INEXACT)
T(RN,    0x1.4f05648416a19p-2,    0x1.5b82719a81f5bp-2,   0x1.a81c9ep-2, INEXACT)
T(RN,    0x1.4e3fd77b5887ep-2,    0x1.5aa6328f512fep-2,  -0x1.bdc376p-2, INEXACT)
T(RN,    0x1.4d7abeefdc1fcp-2,    0x1.59ca920ca7501p-2,   0x1.ba6e58p-2, INEXACT)
T(RN,    0x1.4cb61a9cf0ccbp-2,      0x1.58ef8f7d7e8p-2,   0x1.ae9d6cp-2, INEXACT)
T(RN,    0x1.4bf1ea3e0e719p-2,    0x1.58152a4d9a6f8p-2,   -0x1.ffbaap-2, INEXACT)
T(RN,    0x1.4b2e2d8ed55aap-2,    0x1.573b61e986e48p-2,   0x1.9a2c18p-2, INEXACT)
T(RN,    0x1.4a6ae44b0e273p-2,    0x1.566235be964d7p-2,   0x1.f7616ep-2, INEXACT)
T(RN,    0x1.49a80e2ea9aebp-2,    0x1.5589a53ae052ap-2,  -0x1.de8c2cp-2, INEXACT)
T(RN,    0x1.48e5aaf5c0e9ap-2,    0x1.54b1afcd406eap-2,   0x1.daa55cp-2, INEXACT)
T(RN,     0x1.4823ba5c94ddp-2,    0x1.53da54e5548bep-2,   0x1.a6889ap-2, INEXACT)
T(RN,    0x1.47623c1f8e7e9p-2,    0x1.530393f37b9e8p-2,  -0x1.ba21c8p-2, INEXACT)
T(RN,    0x1.46a12ffb3e9f6p-2,    0x1.522d6c68d4479p-2,   0x1.a8bf26p-2, INEXACT)
T(RN,    0x1.45e095ac5dd51p-2,    0x1.5157ddb73b797p-2,    0x1.cfa4ep-2, INEXACT)
T(RN,    0x1.45206cefcc604p-2,     0x1.5082e7514b1dp-2,   0x1.9a29aep-2, INEXACT)
T(RN,     0x1.4460b5829217p-2,    0x1.4fae88aa58bd7p-2,    0x1.ea519p-2, INEXACT)
T(RN,    0x1.43a16f21de4bbp-2,    0x1.4edac13674334p-2,   0x1.ba68c6p-2, INEXACT)
T(RN,     0x1.42e2998b07b8p-2,    0x1.4e07906a6656cp-2,   0x1.d4ce0ap-2, INEXACT)
T(RN,    0x1.4224347b8c636p-2,    0x1.4d34f5bbafb04p-2,    0x1.e2c23p-2, INEXACT)
T(RN,     0x1.41663fb1118ep-2,    0x1.4c62f0a087302p-2,  -0x1.f14e64p-2, INEXACT)
T(RN,    0x1.40a8bae963973p-2,    0x1.4b91808fd8e4ep-2,   0x1.c32108p-2, INEXACT)
T(RN,    0x1.3feba5e275e9ap-2,    0x1.4ac0a50144b98p-2,  -0x1.dc9bd8p-2, INEXACT)
T(RN,    0x1.3f2f005a62dfep-2,    0x1.49f05d6d1d2f9p-2,   0x1.e84ecep-2, INEXACT)
T(RN,    0x1.3e72ca0f6bb2dp-2,    0x1.4920a94c66253p-2,   0x1.a920fep-2, INEXACT)
T(RN,    0x1.3db702bff85dcp-2,    0x1.48518818d393ep-2,   0x1.ce47f8p-2, INEXACT)
T(RN,    0x1.3cfbaa2a978a9p-2,    0x1.4782f94cc859dp-2,   0x1.a84cf2p-2, INEXACT)
T(RN,    0x1.3c40c00dfe7a6p-2,    0x1.46b4fc6355027p-2,   0x1.b21336p-2, INEXACT)
T(RN,    0x1.3b86442908ed4p-2,    0x1.45e790d836905p-2,  -0x1.e885fcp-2, INEXACT)
T(RN,    0x1.3acc363ab90d6p-2,    0x1.451ab627d54ddp-2,   0x1.e962bcp-2, INEXACT)
T(RN,    0x1.3a12960237581p-2,    0x1.444e6bcf439d1p-2,    0x1.edb08p-2, INEXACT)
T(RN,    0x1.3959633ed286dp-2,    0x1.4382b14c3ccbap-2,   0x1.ce4adap-2, INEXACT)
T(RN,    0x1.38a09dafff77cp-2,    0x1.42b7861d23e72p-2,   0x1.a482d4p-2, INEXACT)
T(RN,    0x1.37e845155919dp-2,    0x1.41ece9c10298dp-2,   0x1.a7f2e4p-2, INEXACT)
T(RN,    0x1.3730592ea052ap-2,    0x1.4122dbb787fc9p-2,   0x1.ba07b8p-2, INEXACT)
T(RN,    0x1.3678d9bbbbeb6p-2,     0x1.40595b810782p-2,   0x1.99d768p-2, INEXACT)
T(RN,    0x1.35c1c67cb879ap-2,    0x1.3f90689e77cb9p-2,   0x1.c07586p-2, INEXACT)
T(RN,    0x1.350b1f31c847ep-2,    0x1.3ec80291718fap-2,   0x1.e38432p-2, INEXACT)
T(RN,    0x1.3454e39b433f5p-2,    0x1.3e0028dc2e7d5p-2,    0x1.b1aa9p-2, INEXACT)
T(RN,    0x1.339f1379a6d4bp-2,    0x1.3d38db0188271p-2,   0x1.9f4fb8p-2, INEXACT)
T(RN,    0x1.32e9ae8d95edep-2,    0x1.3c721884f6e77p-2,   0x1.ae2e9ep-2, INEXACT)
T(RN,     0x1.3234b497d8cep-2,    0x1.3babe0ea90cf7p-2,   0x1.b56df2p-2, INEXACT)
T(RN,    0x1.318025595d004p-2,    0x1.3ae633b70895ap-2,   0x1.a3d95ep-2, INEXACT)
T(RN,    0x1.30cc0093353f9p-2,    0x1.3a21106fac841p-2,   0x1.ca5d32p-2, INEXACT)
T(RN,    0x1.3018460699639p-2,    0x1.395c769a656e3p-2,   0x1.be8176p-2, INEXACT)
T(RN,    0x1.2f64f574e647cp-2,    0x1.389865bdb5a2ap-2,   0x1.e7eb54p-2, INEXACT)
T(RN,    0x1.2eb20e9f9db75p-2,    0x1.37d4dd60b7e42p-2,  -0x1.a9bb5cp-2, INEXACT)
T(RN,    0x1.2dff91486656bp-2,    0x1.3711dd0b1e629p-2,   0x1.c7a8b2p-2, INEXACT)
T(RN,    0x1.2d4d7d310b905p-2,    0x1.364f644531b8bp-2,   0x1.cc47fep-2, INEXACT)
T(RN,    0x1.2c9bd21b7d79ap-2,    0x1.358d7297cfe4ap-2,    0x1.f6f56p-2, INEXACT)
T(RN,    0x1.2bea8fc9d0c2ep-2,    0x1.34cc078c6b4d7p-2,   0x1.d388a8p-2, INEXACT)
T(RN,     0x1.2b39b5fe3e9fp-2,    0x1.340b22ad09c27p-2,    0x1.b10e1p-2, INEXACT)
T(RN,    0x1.2a89447b24ad5p-2,    0x1.334ac384437e7p-2,   0x1.c0dd14p-2, INEXACT)
T(RN,    0x1.29d93b0304e65p-2,    0x1.328ae99d42307p-2,   0x1.a58018p-2, INEXACT)
T(RN,    0x1.2929995885857p-2,     0x1.31cb9483c003p-2,   0x1.a0492ap-2, INEXACT)
T(RN,    0x1.287a5f3e70f13p-2,    0x1.310cc3c406a3dp-2,   0x1.d6e804p-2, INEXACT)
T(RN,    0x1.27cb8c77b5a93p-2,    0x1.304e76eaee53bp-2,   0x1.dd1aeep-2, INEXACT)
T(RN,    0x1.271d20c766312p-2,    0x1.2f90ad85dcf52p-2,   0x1.d8b378p-2, INEXACT)
T(RN,    0x1.266f1bf0b8f72p-2,    0x1.2ed36722c517dp-2,   0x1.e348f8p-2, INEXACT)
T(RN,    0x1.25c17db70843ap-2,    0x1.2e16a35025106p-2,   0x1.a74362p-2, INEXACT)
T(RN,    0x1.251445ddd220fp-2,     0x1.2d5a619d0609p-2,   0x1.f0b458p-2, INEXACT)
T(RN,    0x1.24677428b847fp-2,    0x1.2c9ea198fb197p-2,   0x1.a7b344p-2, INEXACT)
T(RN,    0x1.23bb085b800a5p-2,    0x1.2be362d4205e5p-2,   0x1.d6095ap-2, INEXACT)
T(RN,    0x1.230f023a123d4p-2,    0x1.2b28a4df1a12ap-2,   0x1.b122a8p-2, INEXACT)
T(RN,    0x1.226361887b243p-2,    0x1.2a6e674b13ab4p-2,   0x1.e7641cp-2, INEXACT)
T(RN,    0x1.21b8260aea5f1p-2,    0x1.29b4a9a9bef7fp-2,   0x1.b89a0ap-2, INEXACT)
T(RN,    0x1.210d4f85b2d08p-2,    0x1.28fb6b8d533d7p-2,   0x1.d67e78p-2, INEXACT)
T(RN,    0x1.2062ddbd4a8cep-2,    0x1.2842ac888c5afp-2,   0x1.ec022ep-2, INEXACT)
T(RN,    0x1.1fb8d0764ac39p-2,     0x1.278a6c2ea9ebp-2,   0x1.ccf3bap-2, INEXACT)
T(RN,    0x1.1f0f27756fab8p-2,    0x1.26d2aa136e69dp-2,   0x1.e5a4b6p-2, INEXACT)
T(RN,    0x1.1e65e27f986d9p-2,    0x1.261b65cb1e5acp-2,   0x1.9c12f4p-2, INEXACT)
T(RN,    0x1.1dbd0159c7104p-2,    0x1.25649eea7f712p-2,   0x1.e4ce74p-2, INEXACT)
T(RN,    0x1.1d1483c920631p-2,    0x1.24ae5506d7ba3p-2,   0x1.cf4f9ep-2, INEXACT)
T(RN,    0x1.1c6c6992ebeb2p-2,    0x1.23f887b5ecca4p-2,   0x1.df6276p-2, INEXACT)
T(RN,     0x1.1bc4b27c93ccp-2,    0x1.2343368e02e74p-2,   0x1.a524cep-2, INEXACT)
T(RN,    0x1.1b1d5e4ba4b73p-2,    0x1.228e6125dc3c4p-2,   0x1.cc851cp-2, INEXACT)
T(RN,     0x1.1a766cc5cdd4p-2,    0x1.21da0714b8063p-2,  -0x1.cd803ep-2, INEXACT)
T(RN,    0x1.19cfddb0e0abfp-2,    0x1.212627f251c78p-2,   0x1.c4ceccp-2, INEXACT)
T(RN,     0x1.1929b0d2d11ap-2,    0x1.2072c356e07fap-2,   0x1.dcc71ep-2, INEXACT)
T(RN,     0x1.1883e5f1b532p-2,    0x1.1fbfd8db15dc9p-2,   0x1.d1a658p-2, INEXACT)
T(RN,    0x1.17de7cd3c52d8p-2,    0x1.1f0d68181d734p-2,   0x1.cdc494p-2, INEXACT)
T(RN,    0x1.1739753f5b59dp-2,    0x1.1e5b70a79bfafp-2,   0x1.a47da4p-2, INEXACT)
T(RN,    0x1.1694cefaf401fp-2,    0x1.1da9f223ae85ap-2,  -0x1.b5d76cp-2, INEXACT)
T(RN,    0x1.15f089cd2d596p-2,    0x1.1cf8ec26e9bb4p-2,   0x1.af052ep-2, INEXACT)
T(RN,    0x1.154ca57cc76ccp-2,    0x1.1c485e4c591bep-2,   0x1.b17588p-2, INEXACT)
T(RN,    0x1.14a921d0a407ap-2,    0x1.1b98482f7e38cp-2,   0x1.a2658cp-2, INEXACT)
T(RN,    0x1.1405fe8fc6a66p-2,    0x1.1ae8a96c4ffb1p-2,   0x1.b19ef4p-2, INEXACT)
T(RN,    0x1.13633b81545e3p-2,    0x1.1a39819f39e1dp-2,   0x1.cb76f4p-2, INEXACT)
T(RN,     0x1.12c0d86c93ccp-2,    0x1.198ad0651b489p-2,    0x1.cc7f6p-2, INEXACT)
T(RN,    0x1.121ed518ecfcfp-2,    0x1.18dc955b46a8ap-2,   0x1.bf1f24p-2, INEXACT)
T(RN,    0x1.117d314de961bp-2,    0x1.182ed01f80e76p-2,  -0x1.a03266p-2, INEXACT)
T(RN,    0x1.10dbecd333b1ap-2,    0x1.178180500094cp-2,  -0x1.d5543cp-2, INEXACT)
T(RN,    0x1.103b077097de7p-2,    0x1.16d4a58b6d3c7p-2,   0x1.bd2716p-2, INEXACT)
T(RN,    0x1.0f9a80ee02fd7p-2,    0x1.16283f70dead9p-2,   0x1.a8112ap-2, INEXACT)
T(RN,    0x1.0efa59138335bp-2,    0x1.157c4d9fdc494p-2,   0x1.c4f856p-2, INEXACT)
T(RN,    0x1.0e5a8fa947a91p-2,    0x1.14d0cfb85c4c9p-2,   0x1.d26028p-2, INEXACT)
T(RN,    0x1.0dbb2477a064ap-2,    0x1.1425c55ac323fp-2,   0x1.bcf54ap-2, INEXACT)
T(RN,    0x1.0d1c1746fe4bcp-2,    0x1.137b2e27e2ba4p-2,   0x1.b8de98p-2, INEXACT)
T(RN,    0x1.0c7d67dff304fp-2,    0x1.12d109c0f9cafp-2,  -0x1.db4e96p-2, INEXACT)
T(RN,    0x1.0bdf160b30e47p-2,    0x1.122757c7b3336p-2,  -0x1.f8b0d6p-2, INEXACT)
T(RN,    0x1.0b4121918adc5p-2,    0x1.117e17de254aep-2,   0x1.c6e23ap-2, INEXACT)
T(RN,    0x1.0aa38a3bf4689p-2,    0x1.10d549a6d137fp-2,   -0x1.b522ap-2, INEXACT)
T(RN,    0x1.0a064fd38178ep-2,    0x1.102cecc4a244ep-2,   0x1.9c7694p-2, INEXACT)
T(RN,    0x1.096972216660dp-2,    0x1.0f8500daed3b4p-2,   0x1.c07ff8p-2, INEXACT)
T(RN,     0x1.08ccf0eef7c5p-2,    0x1.0edd858d6fbebp-2,   0x1.c5a87ap-2, INEXACT)
T(RN,    0x1.0830cc05aa844p-2,    0x1.0e367a804fa3bp-2,  -0x1.f7f7b6p-2, INEXACT)
T(RN,    0x1.0795032f13a7ep-2,      0x1.0d8fdf581a5p-2,   0x1.e16e32p-2, INEXACT)
T(RN,    0x1.06f99634e8501p-2,    0x1.0ce9b3b9c4171p-2,   0x1.ac615ap-2, INEXACT)
T(RN,    0x1.065e84e0fda0cp-2,    0x1.0c43f74aa7996p-2,   0x1.b924b2p-2, INEXACT)
T(RN,    0x1.05c3cefd48ae6p-2,     0x1.0b9ea9b08524p-2,   0x1.b676f8p-2, INEXACT)
T(RN,    0x1.05297453de6c4p-2,    0x1.0af9ca9182136p-2,   0x1.9db0eep-2, INEXACT)
T(RN,    0x1.048f74aef396ep-2,    0x1.0a5559942832ep-2,    0x1.ae625p-2, INEXACT)
T(RN,    0x1.03f5cfd8dca63p-2,     0x1.09b1565f6526p-2,   0x1.dac178p-2, INEXACT)
T(RN,    0x1.035c859c0db54p-2,    0x1.090dc09a89c77p-2,   0x1.cc73f4p-2, INEXACT)
T(RN,    0x1.02c395c31a72dp-2,    0x1.086a97ed4992cp-2,   0x1.b0da76p-2, INEXACT)
T(RN,    0x1.022b0018b60e8p-2,    0x1.07c7dbffba0b9p-2,   0x1.c45cbcp-2, INEXACT)
T(RN,    0x1.0192c467b3272p-2,    0x1.07258c7a52271p-2,   0x1.c15bbcp-2, INEXACT)
T(RN,    0x1.00fae27b03b44p-2,    0x1.0683a905e9b19p-2,   0x1.b6d0cep-2, INEXACT)
T(RN,     0x1.00635a1db8f8p-2,    0x1.05e2314bb8bdfp-2,    0x1.d2a31p-2, INEXACT)
T(RN,    0x1.ff98563606d6fp-3,    0x1.054124f557106p-2,   0x1.d05b1ap-2, INEXACT)
T(RN,    0x1.fe6aaa7c65525p-3,    0x1.04a083acbb882p-2,   0x1.a7d924p-2, INEXACT)
T(RN,    0x1.fd3db0a56abf4p-3,    0x1.04004d1c3b931p-2,   0x1.cc40d8p-2, INEXACT)
T(RN,    0x1.fc11684832792p-3,    0x1.036080ee8a9a3p-2,   0x1.ab0402p-2, INEXACT)
T(RN,    0x1.fae5d0fc15b34p-3,    0x1.02c11eceb9712p-2,   0x1.a7f734p-2, INEXACT)
T(RN,     0x1.f9baea58ab58p-3,    0x1.0222266835c98p-2,   0x1.9ff2f4p-2, INEXACT)
T(RN,    0x1.f890b3f5c7e32p-3,    0x1.01839766c9a4dp-2,   0x1.a7cdc8p-2, INEXACT)
T(RN,    0x1.f7672d6b7d3bfp-3,    0x1.00e571769ac74p-2,   0x1.d8da8cp-2, INEXACT)
T(RN,    0x1.f63e56521a956p-3,    0x1.0047b4442a2eap-2,   0x1.b772aap-2, INEXACT)
T(RN,    0x1.f5162e422c449p-3,    0x1.ff54bef8a70a9p-3,   0x1.b01a88p-2, INEXACT)
T(RN,    0x1.f3eeb4d47b9efp-3,    0x1.fe1ae59899341p-3,   0x1.a396eep-2, INEXACT)
T(RN,    0x1.f2c7e9a20ed73p-3,    0x1.fce1dbc349b0bp-3,   0x1.b5d992p-2, INEXACT)
T(RN,    0x1.f1a1cc4428da6p-3,    0x1.fba9a0d489837p-3,   0x1.ab248ap-2, INEXACT)
T(RN,    0x1.f07c5c544927ep-3,    0x1.fa723428daca7p-3,    0x1.c44d1p-2, INEXACT)
T(RN,    0x1.ef57996c2bb0ep-3,    0x1.f93b951d6fb7fp-3,   0x1.afce72p-2, INEXACT)
T(RN,     0x1.ee338325c8b6p-3,    0x1.f805c310298b4p-3,   0x1.f0ff2cp-2, INEXACT)
T(RN,    0x1.ed10191b549eap-3,    0x1.f6d0bd5f9784dp-3,    0x1.af1e9p-2, INEXACT)
T(RN,    0x1.ebed5ae73fda6p-3,     0x1.f59c836af5e7p-3,   0x1.d2090cp-2, INEXACT)
T(RN,    0x1.eacb482436bdap-3,    0x1.f46914922cf36p-3,   0x1.d3ffa2p-2, INEXACT)
T(RN,    0x1.e9a9e06d21594p-3,    0x1.f3367035cfe4dp-3,   0x1.ba186ap-2, INEXACT)
T(RN,    0x1.e889235d235c6p-3,     0x1.f20495b71bf6p-3,   0x1.cecf0ap-2, INEXACT)
T(RN,    0x1.e769108f9bef5p-3,    0x1.f0d38477f7628p-3,   0x1.bdd2aep-2, INEXACT)
T(RN,    0x1.e649a7a02590ap-3,    0x1.efa33bdaf06bep-3,   0x1.b5cc9cp-2, INEXACT)
T(RN,    0x1.e52ae82a95f39p-3,     0x1.ee73bb433c62p-3,   0x1.a23d96p-2, INEXACT)
T(RN,    0x1.e40cd1cafdd8ep-3,    0x1.ed450214b6a73p-3,    0x1.a4a42p-2, INEXACT)
T(RN,    0x1.e2ef641da8f1dp-3,    0x1.ec170fb3dfc0dp-3,   0x1.a80354p-2, INEXACT)
T(RN,    0x1.e1d29ebf1db8dp-3,    0x1.eae9e385dc5ecp-3,   0x1.aeb9bap-2, INEXACT)
T(RN,    0x1.e0b6814c1d507p-3,    0x1.e9bd7cf0746b2p-3,   0x1.ecdf98p-2, INEXACT)
T(RN,    0x1.df9b0b61a361ap-3,     0x1.e891db5a121bp-3,   0x1.ae12e2p-2, INEXACT)
T(RN,    0x1.de803c9ce5f83p-3,    0x1.e766fe29c0fefp-3,   0x1.bc7b1ap-2, INEXACT)
T(RN,    0x1.dd66149b55602p-3,     0x1.e63ce4c72d16p-3,   0x1.c36d74p-2, INEXACT)
T(RN,    0x1.dc4c92fa9c04ep-3,    0x1.e5138e9aa1e48p-3,   0x1.aa797cp-2, INEXACT)
T(RN,    0x1.db33b7589e4c7p-3,     0x1.e3eafb0d0988p-3,   0x1.b91eccp-2, INEXACT)
T(RN,    0x1.da1b81537a777p-3,    0x1.e2c32987ebd22p-3,   0x1.b2bd36p-2, INEXACT)
T(RN,     0x1.d903f089887fp-3,    0x1.e19c19756d62bp-3,   0x1.a001bcp-2, INEXACT)
T(RN,    0x1.d7ed049959f03p-3,    0x1.e075ca404ec0dp-3,   0x1.c84166p-2, INEXACT)
T(RN,    0x1.d6d6bd21b9cd3p-3,    0x1.df503b53eb7bbp-3,   0x1.bfb372p-2, INEXACT)
T(RN,    0x1.d5c119c1ac697p-3,    0x1.de2b6c1c39479p-3,   0x1.d0d11cp-2, INEXACT)
T(RN,    0x1.d4ac1a186f492p-3,    0x1.dd075c05c71fdp-3,   0x1.ba3102p-2, INEXACT)
T(RN,    0x1.d397bdc578fd2p-3,    0x1.dbe40a7dbc66dp-3,   0x1.fa99fep-2, INEXACT)
T(RN,    0x1.d284046879043p-3,    0x1.dac176f1d80cdp-3,   0x1.cc14f2p-2, INEXACT)
T(RN,    0x1.d170eda157a9ap-3,    0x1.d99fa0d06fb5cp-3,   0x1.c75226p-2, INEXACT)
T(RN,    0x1.d05e791035de9p-3,    0x1.d87e87886edacp-3,   0x1.bc01b8p-2, INEXACT)
T(RN,    0x1.cf4ca6556d20bp-3,    0x1.d75e2a8955fb6p-3,    0x1.bed27p-2, INEXACT)
T(RN,    0x1.ce3b75118f52fp-3,    0x1.d63e894339c18p-3,   0x1.c72218p-2, INEXACT)
T(RN,    0x1.cd2ae4e5669b9p-3,    0x1.d51fa326c22c5p-3,   0x1.cd35e6p-2, INEXACT)
T(RN,    0x1.cc1af571f5483p-3,    0x1.d40177a529c31p-3,   0x1.bbdb82p-2, INEXACT)
T(RN,    0x1.cb0ba65875a89p-3,    0x1.d2e406303cbf7p-3,   0x1.9aa674p-2, INEXACT)
T(RN,    0x1.c9fcf73a59f0dp-3,    0x1.d1c74e3a58413p-3,  -0x1.f849e8p-2, INEXACT)
T(RN,    0x1.c8eee7b94c114p-3,    0x1.d0ab4f3669788p-3,    0x1.b6ae6p-2, INEXACT)
T(RN,    0x1.c7e177772da1ap-3,    0x1.cf900897ece56p-3,   0x1.9e32f6p-2, INEXACT)
T(RN,    0x1.c6d4a61617b3dp-3,    0x1.ce7579d2ed7fap-3,   -0x1.afcd2p-2, INEXACT)
T(RN,    0x1.c5c873385ab9fp-3,    0x1.cd5ba25c03f42p-3,   0x1.a6b974p-2, INEXACT)
T(RN,    0x1.c4bcde807e67dp-3,    0x1.cc4281a855de1p-3,   0x1.9f70d8p-2, INEXACT)
T(RN,    0x1.c3b1e791418a3p-3,    0x1.cb2a172d94f7cp-3,   -0x1.ae887p-2, INEXACT)
T(RN,    0x1.c2a78e0d99ed1p-3,    0x1.ca126261fe5c2p-3,   0x1.c98cfap-2, INEXACT)
T(RN,    0x1.c19dd198b43b4p-3,     0x1.c8fb62bc59c2p-3,   0x1.a68ecep-2, INEXACT)
T(RN,    0x1.c094b1d5f3d8bp-3,    0x1.c7e517b3f8b42p-3,   0x1.b320c2p-2, INEXACT)
T(RN,    0x1.bf8c2e68f2c75p-3,    0x1.c6cf80c0b5d4dp-3,    0x1.bcc7dp-2, INEXACT)
T(RN,    0x1.be8446f581845p-3,    0x1.c5ba9d5af41b3p-3,   0x1.9d84dcp-2, INEXACT)
T(RN,    0x1.bd7cfb1fa6e9dp-3,    0x1.c4a66cfb9e165p-3,   0x1.a70beep-2, INEXACT)
T(RN,    0x1.bc764a8ba00cfp-3,    0x1.c392ef1c252dcp-3,   0x1.ae9bf2p-2, INEXACT)
T(RN,    0x1.bb7034dde01f2p-3,    0x1.c280233680e6dp-3,   0x1.be7156p-2, INEXACT)
T(RN,    0x1.ba6ab9bb104c2p-3,    0x1.c16e08c52e279p-3,   0x1.ab6e6ap-2, INEXACT)
T(RN,    0x1.b965d8c80f9d4p-3,    0x1.c05c9f432e809p-3,    0x1.a07abp-2, INEXACT)
T(RN,    0x1.b86191a9f2d9cp-3,    0x1.bf4be62c0774dp-3,   0x1.a277aep-2, INEXACT)
T(RN,    0x1.b75de40604614p-3,    0x1.be3bdcfbc1bcbp-3,   0x1.b88aaap-2, INEXACT)
T(RN,    0x1.b65acf81c4132p-3,    0x1.bd2c832ee897ap-3,   0x1.b34602p-2, INEXACT)
T(RN,    0x1.b55853c2e72ddp-3,    0x1.bc1dd84289169p-3,   0x1.bba7d4p-2, INEXACT)
T(RN,    0x1.b456706f582a7p-3,    0x1.bb0fdbb43163ap-3,  -0x1.9d0c96p-2, INEXACT)
T(RN,    0x1.b355252d36a1cp-3,    0x1.ba028d01f0151p-3,    0x1.b7e14p-2, INEXACT)
T(RN,    0x1.b25471a2d72bfp-3,    0x1.b8f5ebaa537b3p-3,   0x1.c6ac96p-2, INEXACT)
T(RN,    0x1.b1545576c3447p-3,    0x1.b7e9f72c68f4bp-3,   0x1.af400ep-2, INEXACT)
T(RN,    0x1.b054d04fb9217p-3,    0x1.b6deaf07bc366p-3,   -0x1.ba1d1p-2, INEXACT)
T(RN,    0x1.af55e1d4ab9e8p-3,    0x1.b5d412bc56a8bp-3,   0x1.b28fecp-2, INEXACT)
T(RN,    0x1.ae5789acc21b9p-3,    0x1.b4ca21cabeb94p-3,   -0x1.f22fbp-2, INEXACT)
T(RN,    0x1.ad59c77f58578p-3,    0x1.b3c0dbb3f72a5p-3,   0x1.9f4a9ep-2, INEXACT)
T(RN,    0x1.ac5c9af3fe5adp-3,    0x1.b2b83ff97e728p-3,   0x1.9f012cp-2, INEXACT)
T(RN,    0x1.ab6003b278522p-3,    0x1.b1b04e1d4e0e2p-3,  -0x1.a5e188p-2, INEXACT)
T(RN,    0x1.aa640162be6fap-3,    0x1.b0a905a1d9d84p-3,   0x1.b5ceaap-2, INEXACT)
T(RN,    0x1.a96893acfcd08p-3,    0x1.afa2660a0f689p-3,   0x1.a92d2ap-2, INEXACT)
T(RN,     0x1.a86dba39935dp-3,    0x1.ae9c6ed9556dap-3,  -0x1.d78bbcp-2, INEXACT)
T(RN,    0x1.a77374b115a37p-3,    0x1.ad971f938b027p-3,   0x1.af88fcp-2, INEXACT)
T(RN,     0x1.a679c2bc4ac6p-3,    0x1.ac9277bd07183p-3,   0x1.9a2ec4p-2, INEXACT)
T(RN,    0x1.a580a4042d516p-3,    0x1.ab8e76da97c9ep-3,   0x1.c20072p-2, INEXACT)
T(RN,    0x1.a4881831eb232p-3,    0x1.aa8b1c7181c09p-3,   0x1.ae4584p-2, INEXACT)
T(RN,    0x1.a3901eeee54b7p-3,    0x1.a98868077f943p-3,   0x1.a4d7aap-2, INEXACT)
T(RN,    0x1.a298b7e4afeddp-3,    0x1.a8865922c12c3p-3,   0x1.ed6b28p-2, INEXACT)
T(RN,    0x1.a1a1e2bd12233p-3,    0x1.a784ef49eb22ap-3,   0x1.e0cd5ap-2, INEXACT)
T(RN,    0x1.a0ab9f2205dcbp-3,     0x1.a6842a041629p-3,   0x1.a528acp-2, INEXACT)
T(RN,     0x1.9fb5ecbdb7c6p-3,    0x1.a58408d8ce6dap-3,   0x1.e32bbap-2, INEXACT)
T(RN,    0x1.9ec0cb3a87248p-3,    0x1.a4848b5012fe9p-3,   0x1.b35d08p-2, INEXACT)
T(RN,    0x1.9dcc3a4305bddp-3,    0x1.a385b0f255355p-3,  -0x1.b5704cp-2, INEXACT)
T(RN,    0x1.9cd83981f7b55p-3,    0x1.a2877948781a4p-3,   0x1.ad88dcp-2, INEXACT)
T(RN,    0x1.9be4c8a253735p-3,    0x1.a189e3dbcfd25p-3,  -0x1.c1362cp-2, INEXACT)
T(RN,    0x1.9af1e74f4181ep-3,    0x1.a08cf03621043p-3,    0x1.a1ee4p-2, INEXACT)
T(RN,    0x1.99ff95341c766p-3,    0x1.9f909de1a04a2p-3,   0x1.9ab86cp-2, INEXACT)
T(RN,    0x1.990dd1fc70cd7p-3,    0x1.9e94ec68f197ep-3,   0x1.b154f6p-2, INEXACT)
T(RN,    0x1.981c9d53fcce7p-3,    0x1.9d99db5727a89p-3,   0x1.9ac154p-2, INEXACT)
T(RN,    0x1.972bf6e6b0737p-3,    0x1.9c9f6a37c3727p-3,    0x1.a9ad3p-2, INEXACT)
T(RN,    0x1.963bde60ad44cp-3,    0x1.9ba59896b38e9p-3,    0x1.9d5d9p-2, INEXACT)
T(RN,    0x1.954c536e4640dp-3,    0x1.9aac660053ae4p-3,   0x1.b05e9cp-2, INEXACT)
T(RN,    0x1.945d55bbffbe5p-3,    0x1.99b3d2016c0b6p-3,    0x1.b2358p-2, INEXACT)
T(RN,    0x1.936ee4f68f4bep-3,    0x1.98bbdc2730d71p-3,   0x1.b45cacp-2, INEXACT)
T(RN,    0x1.928100cadb97ep-3,    0x1.97c483ff41b1bp-3,   0x1.c0eab2p-2, INEXACT)
T(RN,    0x1.9193a8e5fc4d4p-3,    0x1.96cdc917a9184p-3,  -0x1.f45e16p-2, INEXACT)
T(RN,    0x1.90a6dcf539fc3p-3,    0x1.95d7aafedbdf5p-3,   0x1.a85ba6p-2, INEXACT)
T(RN,    0x1.8fba9ca60dfcfp-3,    0x1.94e22943b8a7dp-3,   0x1.9f743ap-2, INEXACT)
T(RN,    0x1.8ecee7a6224f7p-3,    0x1.93ed437587529p-3,   0x1.a448b6p-2, INEXACT)
T(RN,    0x1.8de3bda35181dp-3,    0x1.92f8f923f87aep-3,   0x1.adc7dcp-2, INEXACT)
T(RN,    0x1.8cf91e4ba68f1p-3,    0x1.920549df24ea4p-3,   0x1.abc52ep-2, INEXACT)
T(RN,    0x1.8c0f094d5ccd1p-3,    0x1.911235378d1cbp-3,  -0x1.9d9cf4p-2, INEXACT)
T(RN,    0x1.8b257e56dfc0bp-3,    0x1.901fbabe18ab4p-3,   0x1.b7b808p-2, INEXACT)
T(RN,     0x1.8a3c7d16cb11p-3,    0x1.8f2dda0415d6ep-3,  -0x1.a80324p-2, INEXACT)
T(RN,     0x1.8954053bea5ep-3,    0x1.8e3c929b38f7dp-3,   0x1.9c6e3ap-2, INEXACT)
T(RN,    0x1.886c1675392cdp-3,    0x1.8d4be4159c029p-3,   0x1.b69544p-2, INEXACT)
T(RN,    0x1.8784b071e2c83p-3,    0x1.8c5bce05be02dp-3,   0x1.aaeb02p-2, INEXACT)
T(RN,    0x1.869dd2e142267p-3,     0x1.8b6c4ffe829cp-3,   0x1.b9f758p-2, INEXACT)
T(RN,    0x1.85b77d72e1c56p-3,    0x1.8a7d699331809p-3,   0x1.b7f0dcp-2, INEXACT)
T(RN,    0x1.84d1afd67b9c2p-3,    0x1.898f1a577600ap-3,   0x1.9c4544p-2, INEXACT)
T(RN,    0x1.83ec69bbf8f38p-3,    0x1.88a161df5e7f1p-3,   0x1.b1e9fep-2, INEXACT)
T(RN,    0x1.8307aad3724d9p-3,    0x1.87b43fbf5bf71p-3,   0x1.b4f5f8p-2, INEXACT)
T(RN,    0x1.822372cd2f4c6p-3,    0x1.86c7b38c4181ap-3,   0x1.bac512p-2, INEXACT)
T(RN,     0x1.813fc159a694p-3,    0x1.85dbbcdb43d6dp-3,  -0x1.a634ecp-2, INEXACT)
T(RN,    0x1.805c96297daa8p-3,     0x1.84f05b41f8cep-3,   0x1.bdd82cp-2, INEXACT)
T(RN,    0x1.7f79f0ed88e93p-3,    0x1.84058e5656effp-3,   0x1.aba11ap-2, INEXACT)
T(RN,    0x1.7e97d156cb50fp-3,    0x1.831b55aeb4ecap-3,   0x1.c13b9ap-2, INEXACT)
T(RN,    0x1.7db637167678ep-3,    0x1.8231b0e1c92c6p-3,  -0x1.bec14cp-2, INEXACT)
T(RN,    0x1.7cd521ddea70ap-3,    0x1.81489f86a9556p-3,   0x1.b152dcp-2, INEXACT)
T(RN,    0x1.7bf4915eb5a5bp-3,    0x1.80602134c9d45p-3,   0x1.a5429ep-2, INEXACT)
T(RN,    0x1.7b14854a94c3cp-3,    0x1.7f783583fd619p-3,   0x1.afefe4p-2, INEXACT)
T(RN,    0x1.7a34fd5372a15p-3,     0x1.7e90dc0c7493p-3,   0x1.aa401ap-2, INEXACT)
T(RN,    0x1.7955f92b681b3p-3,    0x1.7daa1466bd5d1p-3,  -0x1.fbd4b6p-2, INEXACT)
T(RN,    0x1.78777884bbff3p-3,    0x1.7cc3de2bc2a48p-3,   0x1.bcd686p-2, INEXACT)
T(RN,    0x1.77997b11e2f46p-3,    0x1.7bde38f4cbcd6p-3,  -0x1.b6a5f2p-2, INEXACT)
T(RN,    0x1.76bc00857f541p-3,    0x1.7af9245b7c3c7p-3,   0x1.a9a60ep-2, INEXACT)
T(RN,    0x1.75df0892611bfp-3,    0x1.7a149ff9d2f18p-3,   0x1.d9c01ap-2, INEXACT)
T(RN,    0x1.750292eb85ca6p-3,    0x1.7930ab6a2a0d5p-3,   0x1.aed59ep-2, INEXACT)
T(RN,    0x1.74269f4418483p-3,    0x1.784d464736653p-3,   0x1.bb41fcp-2, INEXACT)
T(RN,    0x1.734b2d4f70cdap-3,    0x1.776a702c0712ap-3,   0x1.a49268p-2, INEXACT)
T(RN,    0x1.72703cc114c4ap-3,    0x1.768828b40500cp-3,   0x1.a2ac9cp-2, INEXACT)
T(RN,    0x1.7195cd4cb6af3p-3,    0x1.75a66f7af27eap-3,   0x1.a6bab8p-2, INEXACT)
T(RN,    0x1.70bbdea636108p-3,    0x1.74c5441cead51p-3,   0x1.b3e5dcp-2, INEXACT)
T(RN,    0x1.6fe270819f4c7p-3,    0x1.73e4a63661d31p-3,  -0x1.f38cd8p-2, INEXACT)
T(RN,    0x1.6f0982932b90fp-3,    0x1.7304956423657p-3,   0x1.e525d4p-2, INEXACT)
T(RN,    0x1.6e31148f40bbdp-3,    0x1.72251143532a8p-3,   0x1.b9571ap-2, INEXACT)
T(RN,    0x1.6d59262a713ecp-3,    0x1.714619716c05bp-3,   0x1.adc924p-2, INEXACT)
T(RN,    0x1.6c81b7197c069p-3,    0x1.7067ad8c3fb64p-3,   0x1.b7a022p-2, INEXACT)
T(RN,    0x1.6baac7114c5d2p-3,    0x1.6f89cd31f6697p-3,     0x1.b74dp-2, INEXACT)
T(RN,    0x1.6ad455c6f9d77p-3,    0x1.6eac78010e59cp-3,   0x1.b48942p-2, INEXACT)
T(RN,    0x1.69fe62efc8314p-3,    0x1.6dcfad985b5bcp-3,   0x1.c4b5a4p-2, INEXACT)
T(RN,    0x1.6928ee412738fp-3,    0x1.6cf36d97067c3p-3,   -0x1.d3dfcp-2, INEXACT)
T(RN,    0x1.6853f770b2b5ap-3,    0x1.6c17b79c8d992p-3,   0x1.a0aa3ap-2, INEXACT)
T(RN,    0x1.677f7e34324b8p-3,    0x1.6b3c8b48c2f8fp-3,   0x1.aa1de6p-2, INEXACT)
T(RN,    0x1.66ab824199662p-3,    0x1.6a61e83bcce93p-3,    0x1.a6409p-2, INEXACT)
T(RN,    0x1.65d8034f07147p-3,    0x1.6987ce16254e8p-3,   0x1.a4c958p-2, INEXACT)
T(RN,    0x1.65050112c5fa2p-3,    0x1.68ae3c78994b6p-3,   0x1.9de6e2p-2, INEXACT)
T(RN,    0x1.64327b434c327p-3,    0x1.67d5330448d88p-3,   0x1.b5b31ap-2, INEXACT)
T(RN,    0x1.636071973b314p-3,    0x1.66fcb15aa65bdp-3,   0x1.afb8aap-2, INEXACT)
T(RN,    0x1.628ee3c55fb1cp-3,    0x1.6624b71d764e3p-3,   0x1.a80ccep-2, INEXACT)
T(RN,    0x1.61bdd184b199ep-3,    0x1.654d43eeced61p-3,   0x1.b0fdbcp-2, INEXACT)
T(RN,    0x1.60ed3a8c53d9dp-3,    0x1.64765771175e9p-3,   0x1.b55d5ep-2, INEXACT)
T(RN,    0x1.601d1e9394626p-3,    0x1.639ff1470846cp-3,   0x1.e94976p-2, INEXACT)
T(RN,    0x1.5f4d7d51ebf7ep-3,    0x1.62ca1113aa6cdp-3,   0x1.a40674p-2, INEXACT)
T(RN,    0x1.5e7e567efe293p-3,    0x1.61f4b67a56df2p-3,     0x1.9c7fp-2, INEXACT)
T(RN,    0x1.5dafa9d299317p-3,    0x1.611fe11eb677cp-3,   0x1.9eac68p-2, INEXACT)
T(RN,     0x1.5ce17704b5dbp-3,    0x1.604b90a4c179ep-3,   0x1.add7e8p-2, INEXACT)
T(RN,    0x1.5c13bdcd7766ap-3,     0x1.5f77c4b0bf34p-3,   0x1.a0e534p-2, INEXACT)
T(RN,    0x1.5b467de52b7e3p-3,    0x1.5ea47ce745aeap-3,   0x1.ac7e84p-2, INEXACT)
T(RN,    0x1.5a79b7044a07cp-3,    0x1.5dd1b8ed393adp-3,    0x1.b5c77p-2, INEXACT)
T(RN,    0x1.59ad68e3751dep-3,    0x1.5cff7867cc27ap-3,   0x1.9d1612p-2, INEXACT)
T(RN,    0x1.58e1933b78ee2p-3,    0x1.5c2dbafc7e5d8p-3,   0x1.b41306p-2, INEXACT)
T(RN,    0x1.581635c54ba51p-3,     0x1.5b5c80511d08p-3,   0x1.aa72e2p-2, INEXACT)
T(RN,    0x1.574b503a0d4e5p-3,    0x1.5a8bc80bc233dp-3,   0x1.a2101ap-2, INEXACT)
T(RN,    0x1.5680e25307c4dp-3,    0x1.59bb91d2d47dep-3,   0x1.a5b922p-2, INEXACT)
T(RN,    0x1.55b6ebc9ae939p-3,     0x1.58ebdd4d06b3p-3,  -0x1.bdd9c6p-2, INEXACT)
T(RN,    0x1.54ed6c579edcfp-3,    0x1.581caa2157771p-3,   0x1.b4e5a8p-2, INEXACT)
T(RN,    0x1.542463b69f4b3p-3,    0x1.574df7f710f55p-3,   0x1.9c6bf2p-2, INEXACT)
T(RN,    0x1.535bd1a09fe8cp-3,    0x1.567fc675c8796p-3,    0x1.af6fcp-2, INEXACT)
T(RN,    0x1.5293b5cfba16ap-3,    0x1.55b215455e26dp-3,     0x1.a562p-2, INEXACT)
T(RN,    0x1.51cc0ffe306c3p-3,    0x1.54e4e40dfc9a5p-3,   0x1.a2b66ep-2, INEXACT)
T(RN,    0x1.5104dfe66e9f4p-3,    0x1.541832781893cp-3,   0x1.b0e6a2p-2, INEXACT)
T(RN,    0x1.503e2543096d3p-3,    0x1.534c002c70a1dp-3,   0x1.9a5424p-2, INEXACT)
T(RN,    0x1.4f77dfcebe82cp-3,    0x1.52804cd40ccccp-3,   0x1.9c29d2p-2, INEXACT)
T(RN,    0x1.4eb20f447463cp-3,    0x1.51b518183e416p-3,  -0x1.fb5578p-2, INEXACT)
T(RN,    0x1.4decb35f3a52dp-3,    0x1.50ea61a29efcfp-3,   0x1.a377f6p-2, INEXACT)
T(RN,    0x1.4d27cbda4839fp-3,    0x1.5020291d11797p-3,   0x1.fbc7fap-2, INEXACT)
T(RN,    0x1.4c635870fe914p-3,    0x1.4f566e31c059ap-3,   0x1.fee962p-2, INEXACT)
T(RN,    0x1.4b9f58dee6475p-3,    0x1.4e8d308b1e164p-3,   0x1.aa5768p-2, INEXACT)
T(RN,    0x1.4adbccdfb0adep-3,    0x1.4dc46fd3e4b0ap-3,   0x1.f57d44p-2, INEXACT)
T(RN,    0x1.4a18b42f3757bp-3,    0x1.4cfc2bb715562p-3,  -0x1.b1cacep-2, INEXACT)
T(RN,    0x1.49560e897c0b8p-3,    0x1.4c3463dff81a4p-3,  -0x1.ce9a44p-2, INEXACT)
T(RN,    0x1.4893dbaaa8a54p-3,    0x1.4b6d17fa1b9e4p-3,    0x1.a23d9p-2, INEXACT)
T(RN,    0x1.47d21b4f0f05ep-3,    0x1.4aa647b154c88p-3,   0x1.9d21d6p-2, INEXACT)
T(RN,     0x1.4710cd3328f2p-3,    0x1.49dff2b1be6afp-3,  -0x1.bd7dc6p-2, INEXACT)
T(RN,    0x1.464ff11397ff3p-3,    0x1.491a18a7b8f8bp-3,   0x1.a10e48p-2, INEXACT)
T(RN,    0x1.458f86ad25804p-3,    0x1.4854b93fea3aap-3,    0x1.9f682p-2, INEXACT)
T(RN,     0x1.44cf8dbcc269p-3,    0x1.478fd4273cfc9p-3,   0x1.a827fap-2, INEXACT)
T(RN,    0x1.441005ff87371p-3,    0x1.46cb690ae0bf4p-3,   0x1.a26a2cp-2, INEXACT)
T(RN,    0x1.4350ef32b3db7p-3,    0x1.46077798496bep-3,   0x1.af9e7ap-2, INEXACT)
T(RN,    0x1.42924913afa5ap-3,    0x1.4543ff7d2f098p-3,   0x1.9c8424p-2, INEXACT)
T(RN,    0x1.41d4136009258p-3,    0x1.448100678d697p-3,   0x1.ad036ep-2, INEXACT)
T(RN,    0x1.41164dd5761ebp-3,    0x1.43be7a05a3e5fp-3,   0x1.b0ae34p-2, INEXACT)
T(RN,    0x1.4058f831d368ep-3,    0x1.42fc6c05f50dcp-3,   0x1.b14cccp-2, INEXACT)
T(RN,    0x1.3f9c123324d9fp-3,    0x1.423ad617465a2p-3,   0x1.ad71aep-2, INEXACT)
T(RN,    0x1.3edf9b979531ep-3,    0x1.4179b7e89fe71p-3,   0x1.b20322p-2, INEXACT)
T(RN,    0x1.3e23941d76065p-3,    0x1.40b911294c2b7p-3,  -0x1.dc755ep-2, INEXACT)
T(RN,    0x1.3d67fb833f9d6p-3,    0x1.3ff8e188d7a0dp-3,   0x1.ab7614p-2, INEXACT)
T(RN,    0x1.3cacd18790ef9p-3,    0x1.3f3928b71092cp-3,   0x1.a14e8ap-2, INEXACT)
T(RN,    0x1.3bf215e92f76ep-3,    0x1.3e79e66406bb9p-3,  -0x1.faac44p-2, INEXACT)
T(RN,    0x1.3b37c8670726cp-3,    0x1.3dbb1a400b0acp-3,   0x1.99dd28p-2, INEXACT)
T(RN,    0x1.3a7de8c02a57dp-3,    0x1.3cfcc3fbaf5edp-3,   0x1.a0b34ep-2, INEXACT)
T(RN,    0x1.39c476b3d1a6bp-3,    0x1.3c3ee347c6334p-3,   0x1.f0c468p-2, INEXACT)
T(RN,    0x1.390b72015be26p-3,     0x1.3b8177d5625ep-3,   0x1.a29a2ap-2, INEXACT)
T(RN,    0x1.3852da684df77p-3,    0x1.3ac48155d6ca6p-3,    0x1.a20d8p-2, INEXACT)
T(RN,     0x1.379aafa852ddp-3,    0x1.3a07ff7ab6361p-3,   0x1.a357dcp-2, INEXACT)
T(RN,    0x1.36e2f1813b6fap-3,     0x1.394bf1f5d2dcp-3,   0x1.9b8306p-2, INEXACT)
T(RN,    0x1.362b9fb2fe6b5p-3,    0x1.389058793e3f7p-3,   0x1.99f3a4p-2, INEXACT)
T(RN,    0x1.3574b9fdb84eap-3,    0x1.37d532b748dffp-3,   0x1.d60562p-2, INEXACT)
T(RN,    0x1.34be4021ab3f9p-3,    0x1.371a806281ef8p-3,   0x1.9fb42ep-2, INEXACT)
T(RN,    0x1.340831df3f026p-3,    0x1.3660412db71b7p-3,   0x1.aa5d08p-2, INEXACT)
T(RN,    0x1.33528ef700d49p-3,    0x1.35a674cbf4391p-3,   0x1.a9ce56p-2, INEXACT)
T(RN,    0x1.329d5729a35f3p-3,    0x1.34ed1af0830aap-3,   0x1.a28dbcp-2, INEXACT)
T(RN,    0x1.31e88a37fea12p-3,    0x1.3434334eeafc5p-3,   0x1.b06944p-2, INEXACT)
T(RN,    0x1.313427e30fd2ap-3,    0x1.337bbd9af0dabp-3,  -0x1.f18efep-2, INEXACT)
T(RN,    0x1.30802febf956cp-3,     0x1.32c3b9889698p-3,   0x1.b2ba36p-2, INEXACT)
T(RN,    0x1.2fcca21402a09p-3,    0x1.320c26cc1b047p-3,   0x1.a5d99cp-2, INEXACT)
T(RN,    0x1.2f197e1c9824bp-3,    0x1.31550519f9948p-3,   0x1.a3c7eep-2, INEXACT)
T(RN,    0x1.2e66c3c74b38fp-3,    0x1.309e5426ea148p-3,   0x1.ae8862p-2, INEXACT)
T(RN,       0x1.2db472d5d2p-3,    0x1.2fe813a7e0691p-3,   0x1.9dfa08p-2, INEXACT)
T(RN,    0x1.2d028b0a07627p-3,    0x1.2f3243520c5d8p-3,   0x1.a4204cp-2, INEXACT)
T(RN,    0x1.2c510c25eae0ap-3,    0x1.2e7ce2dad94a9p-3,   0x1.a96c7cp-2, INEXACT)
T(RN,     0x1.2b9ff5eba097p-3,    0x1.2dc7f1f7edf0fp-3,   0x1.aacfe6p-2, INEXACT)
T(RN,    0x1.2aef481d71124p-3,    0x1.2d13705f2c22fp-3,   0x1.9f1b5cp-2, INEXACT)
T(RN,    0x1.2a3f027dc945bp-3,    0x1.2c5f5dc6b0917p-3,   0x1.9e6264p-2, INEXACT)
T(RN,    0x1.298f24cf3a79cp-3,    0x1.2babb9e4d2911p-3,   0x1.a26122p-2, INEXACT)
T(RN,    0x1.28dfaed47a292p-3,    0x1.2af8847023cdfp-3,   0x1.9ee65ep-2, INEXACT)
T(RN,    0x1.2830a05061f58p-3,    0x1.2a45bd1f7017ep-3,   0x1.a8d92ep-2, INEXACT)
T(RN,    0x1.2781f905ef919p-3,    0x1.299363a9bd23ep-3,   0x1.d23fecp-2, INEXACT)
T(RN,    0x1.26d3b8b844a2ep-3,    0x1.28e177c64a45ap-3,    0x1.ddbefp-2, INEXACT)
T(RN,    0x1.2625df2aa6b8bp-3,    0x1.282ff92c903ebp-3,   0x1.ac146ap-2, INEXACT)
T(RN,     0x1.25786c207f32p-3,    0x1.277ee79440fcep-3,   0x1.aa9ee4p-2, INEXACT)
T(RN,    0x1.24cb5f5d5b28cp-3,    0x1.26ce42b5475e2p-3,   0x1.a86f02p-2, INEXACT)
T(RN,    0x1.241eb8a4eb539p-3,    0x1.261e0a47c6eb1p-3,   0x1.a862fep-2, INEXACT)
T(RN,    0x1.237277bb0404bp-3,    0x1.256e3e041bafap-3,   0x1.ad090cp-2, INEXACT)
T(RN,     0x1.22c69c639d03p-3,    0x1.24bedda2d9ed4p-3,   0x1.aade08p-2, INEXACT)
T(RN,    0x1.221b2662d1796p-3,    0x1.240fe8dccde43p-3,   0x1.a20a02p-2, INEXACT)
T(RN,    0x1.2170157cdfeafp-3,    0x1.23615f6afba21p-3,   0x1.a49cc2p-2, INEXACT)
T(RN,    0x1.20c569762a10ap-3,    0x1.22b341069eb99p-3,   0x1.aa8c04p-2, INEXACT)
T(RN,    0x1.201b221334cddp-3,    0x1.22058d692a11fp-3,   0x1.a826a2p-2, INEXACT)
T(RN,    0x1.1f713f18a81aap-3,    0x1.2158444c47ac4p-3,   0x1.a53594p-2, INEXACT)
T(RN,     0x1.1ec7c04b4ee7p-3,    0x1.20ab6569d8618p-3,   0x1.a24066p-2, INEXACT)
T(RN,    0x1.1e1ea5701718ep-3,    0x1.1ffef07bf3bcbp-3,    0x1.9f781p-2, INEXACT)
T(RN,    0x1.1d75ee4c115a6p-3,    0x1.1f52e53ce7a43p-3,   0x1.a8eb6ap-2, INEXACT)
T(RN,    0x1.1ccd9aa471266p-3,     0x1.1ea743673843p-3,   0x1.a9484ep-2, INEXACT)
T(RN,    0x1.1c25aa3e8c981p-3,    0x1.1dfc0ab59fb41p-3,   0x1.ad7d7ep-2, INEXACT)
T(RN,    0x1.1b7e1cdfdc69ep-3,    0x1.1d513ae30dde2p-3,   0x1.9a9718p-2, INEXACT)
T(RN,    0x1.1ad6f24dfbd05p-3,    0x1.1ca6d3aaa82b1p-3,   0x1.a2425ep-2, INEXACT)
T(RN,    0x1.1a302a4ea87bcp-3,    0x1.1bfcd4c7c9673p-3,     0x1.ab13p-2, INEXACT)
T(RN,    0x1.1989c4a7c26c2p-3,    0x1.1b533df60171dp-3,    0x1.a3dfep-2, INEXACT)
T(RN,    0x1.18e3c11f4beb2p-3,    0x1.1aaa0ef115155p-3,   0x1.dab6d4p-2, INEXACT)
T(RN,    0x1.183e1f7b69744p-3,    0x1.1a014774fdccfp-3,   0x1.b8a7c2p-2, INEXACT)
T(RN,    0x1.1798df8261a0dp-3,    0x1.1958e73de98efp-3,   0x1.a1cd74p-2, INEXACT)
T(RN,    0x1.16f400fa9d16cp-3,    0x1.18b0ee083a99cp-3,   0x1.9ac114p-2, INEXACT)
T(RN,    0x1.164f83aaa66c5p-3,    0x1.18095b9087362p-3,   0x1.9b9994p-2, INEXACT)
T(RN,    0x1.15ab67592a1fep-3,    0x1.17622f93998dfp-3,  -0x1.f916d2p-2, INEXACT)
T(RN,    0x1.1507abccf6744p-3,    0x1.16bb69ce6f679p-3,   0x1.a14ceap-2, INEXACT)
T(RN,    0x1.146450ccfb709p-3,    0x1.161509fe3a04ep-3,   0x1.ac432cp-2, INEXACT)
T(RN,    0x1.13c156204abc3p-3,     0x1.156f0fe05ddfp-3,   0x1.9b8f94p-2, INEXACT)
T(RN,    0x1.131ebb8e17908p-3,    0x1.14c97b327277bp-3,    0x1.9d054p-2, INEXACT)
T(RN,    0x1.127c80ddb6a45p-3,    0x1.14244bb24224dp-3,   0x1.a0545ap-2, INEXACT)
T(RN,    0x1.11daa5d69e1e1p-3,    0x1.137f811dc9e2fp-3,   0x1.9cc922p-2, INEXACT)
T(RN,    0x1.11392a4065729p-3,    0x1.12db1b3339145p-3,   0x1.a2d346p-2, INEXACT)
T(RN,    0x1.10980de2c560ap-3,    0x1.123719b0f15d8p-3,   0x1.ab3a5ep-2, INEXACT)
T(RN,    0x1.0ff7508597d51p-3,    0x1.11937c55866a2p-3,  -0x1.b4c8cep-2, INEXACT)
T(RN,    0x1.0f56f1f0d7d6ap-3,    0x1.10f042dfbdba4p-3,   0x1.a586e2p-2, INEXACT)
T(RN,    0x1.0eb6f1eca175cp-3,    0x1.104d6d0e8e731p-3,   0x1.ab4f6cp-2, INEXACT)
T(RN,    0x1.0e17504131b78p-3,    0x1.0faafaa1212bfp-3,   0x1.a2dc1ap-2, INEXACT)
T(RN,    0x1.0d780cb6e683fp-3,    0x1.0f08eb56cfbe7p-3,   0x1.a26756p-2, INEXACT)
T(RN,    0x1.0cd927163e8f8p-3,    0x1.0e673eef2511cp-3,   0x1.a4307ep-2, INEXACT)
T(RN,    0x1.0c3a9f27d94c7p-3,    0x1.0dc5f529dcee8p-3,   0x1.9e605ap-2, INEXACT)
T(RN,    0x1.0b9c74b476cc4p-3,    0x1.0d250dc6e3c28p-3,   0x1.9d3d9ap-2, INEXACT)
T(RN,    0x1.0afea784f7bc9p-3,    0x1.0c8488865680ap-3,   0x1.9bde32p-2, INEXACT)
T(RN,    0x1.0a6137625d4cdp-3,    0x1.0be4652882695p-3,   0x1.a2bed2p-2, INEXACT)
T(RN,    0x1.09c42415c9129p-3,    0x1.0b44a36de4d1ep-3,   0x1.a9f638p-2, INEXACT)
T(RN,    0x1.09276d687d05fp-3,    0x1.0aa543172b049p-3,   0x1.a2f842p-2, INEXACT)
T(RN,    0x1.088b1323db634p-3,    0x1.0a0643e532059p-3,   0x1.a003dap-2, INEXACT)
T(RN,    0x1.07ef15116696bp-3,    0x1.0967a59906627p-3,   0x1.9ccf86p-2, INEXACT)
T(RN,    0x1.075372fac1395p-3,    0x1.08c967f3e4136p-3,   0x1.9b9bf4p-2, INEXACT)
T(RN,    0x1.06b82ca9adeb9p-3,    0x1.082b8ab736399p-3,   0x1.f64fbcp-2, INEXACT)
T(RN,    0x1.061d41e80f465p-3,    0x1.078e0da496f4ap-3,   -0x1.b2dbdp-2, INEXACT)
T(RN,    0x1.0582b27fe7d1ap-3,    0x1.06f0f07dcf3e7p-3,   0x1.c28d7cp-2, INEXACT)
T(RN,    0x1.04e87e3b59e99p-3,     0x1.06543304d6b4p-3,   0x1.9cf694p-2, INEXACT)
T(RN,     0x1.044ea4e4a7acp-3,    0x1.05b7d4fbd368dp-3,   0x1.a0c634p-2, INEXACT)
T(RN,    0x1.03b5264632ec7p-3,    0x1.051bd62519bfbp-3,   0x1.a909a6p-2, INEXACT)
T(RN,    0x1.031c022a7d15dp-3,    0x1.048036432c31dp-3,   0x1.a46efcp-2, INEXACT)
T(RN,    0x1.0283385c27223p-3,    0x1.03e4f518bb2c2p-3,  -0x1.a6ee4ap-2, INEXACT)
T(RN,    0x1.01eac8a5f17f8p-3,    0x1.034a1268a4d9fp-3,   0x1.a202fcp-2, INEXACT)
T(RN,    0x1.0152b2d2bc0c7p-3,    0x1.02af8df5f5078p-3,   0x1.a21826p-2, INEXACT)
T(RN,      0x1.00baf6ad85fp-3,    0x1.02156783e4dfdp-3,  -0x1.bd9622p-2, INEXACT)
T(RN,    0x1.002394016d952p-3,    0x1.017b9ed5dacedp-3,   0x1.9b4828p-2, INEXACT)
T(RN,    0x1.ff19153361334p-4,    0x1.00e233af6a566p-3,   0x1.a733bap-2, INEXACT)
T(RN,    0x1.fdebb48357677p-4,    0x1.004925d453dafp-3,    0x1.a05b5p-2, INEXACT)
T(RN,    0x1.fcbf0589b5487p-4,    0x1.ff60ea1108f8cp-4,   0x1.9bdd9ap-2, INEXACT)
T(RN,    0x1.fb9307ddb0476p-4,    0x1.fe3042202bd4ap-4,    0x1.a3277p-2, INEXACT)
T(RN,    0x1.fa67bb16bba67p-4,    0x1.fd00535e9c784p-4,   0x1.a55c1ep-2, INEXACT)
T(RN,    0x1.f93d1ecc883efp-4,    0x1.fbd11d553f769p-4,   0x1.a59e64p-2, INEXACT)
T(RN,    0x1.f81332970480fp-4,     0x1.faa29f8d5196p-4,   -0x1.aa429p-2, INEXACT)
T(RN,    0x1.f6e9f60e5c252p-4,    0x1.f974d99067518p-4,  -0x1.baed9cp-2, INEXACT)
T(RN,    0x1.f5c168caf82aep-4,    0x1.f847cae86ca6cp-4,   0x1.9e9678p-2, INEXACT)
T(RN,    0x1.f4998a657ea39p-4,    0x1.f71b731fa4b18p-4,   0x1.9dc1f8p-2, INEXACT)
T(RN,    0x1.f3725a76d28e6p-4,    0x1.f5efd1c0a9584p-4,   0x1.a63388p-2, INEXACT)
T(RN,    0x1.f24bd89813c51p-4,    0x1.f4c4e6566b09fp-4,  -0x1.bd7b42p-2, INEXACT)
T(RN,    0x1.f12604629eb79p-4,    0x1.f39ab06c304abp-4,   0x1.a18422p-2, INEXACT)
T(RN,    0x1.f000dd700c66fp-4,    0x1.f2712f8d95805p-4,   0x1.a3a098p-2, INEXACT)
T(RN,    0x1.eedc635a3239dp-4,    0x1.f14863468c992p-4,   0x1.a38c9ep-2, INEXACT)
T(RN,    0x1.edb895bb21c98p-4,    0x1.f0204b235caaep-4,   0x1.a7f78ep-2, INEXACT)
T(RN,    0x1.ec95742d28d85p-4,    0x1.eef8e6b0a1bc2p-4,   0x1.9a2d0cp-2, INEXACT)
T(RN,    0x1.eb72fe4ad112cp-4,     0x1.edd2357b4c58p-4,   0x1.a7619ep-2, INEXACT)
T(RN,    0x1.ea5133aee0039p-4,    0x1.ecac3710a155dp-4,  -0x1.f61f9cp-2, INEXACT)
T(RN,    0x1.e93013f456ddbp-4,    0x1.eb86eafe3976ap-4,   0x1.a2629cp-2, INEXACT)
T(RN,    0x1.e80f9eb6726edp-4,    0x1.ea6250d2012b7p-4,   -0x1.a6734p-2, INEXACT)
T(RN,    0x1.e6efd390aadd8p-4,    0x1.e93e681a3827fp-4,   0x1.a19498p-2, INEXACT)
T(RN,    0x1.e5d0b21eb3a79p-4,    0x1.e81b306571352p-4,   0x1.a06344p-2, INEXACT)
T(RN,    0x1.e4b239fc7b68bp-4,    0x1.e6f8a94291cd1p-4,   0x1.9f59f8p-2, INEXACT)
T(RN,    0x1.e3946ac62bbfdp-4,    0x1.e5d6d240d1d54p-4,  -0x1.a3eda6p-2, INEXACT)
T(RN,     0x1.e27744182924p-4,    0x1.e4b5aaefbb493p-4,   0x1.a1181ap-2, INEXACT)
T(RN,    0x1.e15ac58f12d4cp-4,    0x1.e39532df2a004p-4,   0x1.9d940ep-2, INEXACT)
T(RN,    0x1.e03eeec7c2a16p-4,    0x1.e275699f4b4b6p-4,   0x1.a38d16p-2, INEXACT)
T(RN,    0x1.df23bf5f4cd5fp-4,    0x1.e1564ec09db86p-4,   0x1.dfa31ap-2, INEXACT)
T(RN,    0x1.de0936f3000b7p-4,    0x1.e037e1d3f0b8bp-4,   0x1.9ad2e2p-2, INEXACT)
T(RN,    0x1.dcef552065189p-4,    0x1.df1a226a64697p-4,   0x1.a64e14p-2, INEXACT)
T(RN,    0x1.dbd619853edc5p-4,    0x1.ddfd101569351p-4,   0x1.9f41f6p-2, INEXACT)
T(RN,    0x1.dabd83bf8a24cp-4,    0x1.dce0aa66bf91dp-4,    0x1.9e778p-2, INEXACT)
T(RN,    0x1.d9a5936d7d8bfp-4,    0x1.dbc4f0f077b68p-4,  -0x1.fa1a22p-2, INEXACT)
T(RN,    0x1.d88e482d894f5p-4,    0x1.daa9e344f14a4p-4,   0x1.a0743cp-2, INEXACT)
T(RN,    0x1.d777a19e573e1p-4,     0x1.d98f80f6db2bp-4,   0x1.9f6f36p-2, INEXACT)
T(RN,    0x1.d6619f5eca848p-4,    0x1.d875c9993311fp-4,   0x1.9f7d54p-2, INEXACT)
T(RN,    0x1.d54c410dff9cbp-4,    0x1.d75cbcbf455d2p-4,    0x1.a1073p-2, INEXACT)
T(RN,    0x1.d437864b4c10cp-4,    0x1.d64459fcacaadp-4,   0x1.9d1012p-2, INEXACT)
T(RN,    0x1.d3236eb63e812p-4,    0x1.d52ca0e551b9dp-4,   0x1.a1516cp-2, INEXACT)
T(RN,     0x1.d20ff9ee9e59p-4,    0x1.d415910d6af74p-4,   0x1.9bad28p-2, INEXACT)
T(RN,    0x1.d0fd27946bd0fp-4,    0x1.d2ff2a097c5bdp-4,   0x1.9d4c6ep-2, INEXACT)
T(RN,    0x1.cfeaf747dfaddp-4,    0x1.d1e96b6e5704bp-4,   0x1.a2a67cp-2, INEXACT)
T(RN,    0x1.ced968a96b374p-4,     0x1.d0d454d11905p-4,   0x1.a2551ap-2, INEXACT)
T(RN,    0x1.cdc87b59b8102p-4,    0x1.cfbfe5c72d193p-4,   0x1.9a374cp-2, INEXACT)
T(RN,    0x1.ccb82ef9a80dap-4,    0x1.ceac1de64a593p-4,   0x1.a65e8ep-2, INEXACT)
T(RN,    0x1.cba8832a551c6p-4,    0x1.cd98fcc473f92p-4,   0x1.9f11d4p-2, INEXACT)
T(RN,    0x1.ca99778d1123bp-4,    0x1.cc8681f7f9086p-4,   0x1.a1f7e8p-2, INEXACT)
T(RN,    0x1.c98b0bc365d58p-4,    0x1.cb74ad17741d5p-4,   0x1.a3289ep-2, INEXACT)
T(RN,     0x1.c87d3f6f149fp-4,    0x1.ca637db9cb227p-4,   0x1.f5362ep-2, INEXACT)
T(RN,    0x1.c77012321678fp-4,     0x1.c952f3762f03p-4,   0x1.9df818p-2, INEXACT)
T(RN,    0x1.c66383ae9bd94p-4,    0x1.c8430de41b79bp-4,   0x1.a14be4p-2, INEXACT)
T(RN,    0x1.c55793870c7ffp-4,    0x1.c733cc9b56ba4p-4,   0x1.9eb01ap-2, INEXACT)
T(RN,    0x1.c44c415e075b5p-4,    0x1.c6252f33f1332p-4,   0x1.9e84b2p-2, INEXACT)
T(RN,    0x1.c3418cd6626a5p-4,    0x1.c5173546454d5p-4,   0x1.99f2bcp-2, INEXACT)
T(RN,    0x1.c23775932aa38p-4,    0x1.c409de6af7314p-4,   0x1.a3f322p-2, INEXACT)
T(RN,    0x1.c12dfb37a3c38p-4,    0x1.c2fd2a3af4731p-4,   0x1.a0a3d8p-2, INEXACT)
T(RN,    0x1.c0251d674839cp-4,    0x1.c1f1184f73ddcp-4,   0x1.a7ff4ap-2, INEXACT)
T(RN,    0x1.bf1cdbc5c901bp-4,    0x1.c0e5a841f52acp-4,   -0x1.b4579p-2, INEXACT)
T(RN,    0x1.be1535f70d862p-4,    0x1.bfdad9ac40c46p-4,   0x1.9b0fa8p-2, INEXACT)
T(RN,    0x1.bd0e2b9f3383dp-4,    0x1.bed0ac286786ep-4,   0x1.a45bfap-2, INEXACT)
T(RN,    0x1.bc07bc628ee8ep-4,    0x1.bdc71f50c27f9p-4,  -0x1.b6616cp-2, INEXACT)
T(RN,     0x1.bb01e7e5a99dp-4,    0x1.bcbe32bff2943p-4,   0x1.a1c006p-2, INEXACT)
T(RN,    0x1.b9fcadcd43935p-4,    0x1.bbb5e610e074ap-4,   0x1.a18c8ep-2, INEXACT)
T(RN,    0x1.b8f80dbe5279dp-4,    0x1.baae38debc2a3p-4,    0x1.a2887p-2, INEXACT)
T(RN,    0x1.b7f4075e01b79p-4,    0x1.b9a72ac4fcf61p-4,   0x1.a361dcp-2, INEXACT)
T(RN,    0x1.b6f09a51b2379p-4,    0x1.b8a0bb5f60fc6p-4,    0x1.9c7dep-2, INEXACT)
T(RN,    0x1.b5edc63efa5f7p-4,    0x1.b79aea49ed1bcp-4,   0x1.a4e474p-2, INEXACT)
T(RN,    0x1.b4eb8acba5de1p-4,    0x1.b695b720ec9c9p-4,   0x1.9c48fap-2, INEXACT)
T(RN,    0x1.b3e9e79db5a0dp-4,    0x1.b5912180f1077p-4,  -0x1.fa3788p-2, INEXACT)
T(RN,    0x1.b2e8dc5b5f8e7p-4,    0x1.b48d2906d1c14p-4,   0x1.9e560ap-2, INEXACT)
T(RN,    0x1.b1e868ab0e97fp-4,    0x1.b389cd4fabfd8p-4,   0x1.ed825ap-2, INEXACT)
T(RN,    0x1.b0e88c33626cdp-4,    0x1.b2870df8e2545p-4,   0x1.9b37a8p-2, INEXACT)
T(RN,    0x1.afe9469b2f859p-4,    0x1.b184eaa01caf1p-4,  -0x1.c7cab6p-2, INEXACT)
T(RN,    0x1.aeea97897ed97p-4,    0x1.b08362e347e01p-4,   0x1.9f189ep-2, INEXACT)
T(RN,    0x1.adec7ea58de1fp-4,    0x1.af82766095885p-4,   0x1.a103e2p-2, INEXACT)
T(RN,    0x1.aceefb96ce72dp-4,    0x1.ae8224b67bd28p-4,   0x1.9ed9d4p-2, INEXACT)
T(RN,    0x1.abf20e04e692bp-4,     0x1.ad826d83b52ep-4,  -0x1.e79e9ep-2, INEXACT)
T(RN,    0x1.aaf5b597b0555p-4,    0x1.ac835067400c6p-4,   0x1.9b2fe6p-2, INEXACT)
T(RN,    0x1.a9f9f1f739e0ep-4,    0x1.ab84cd005ec9bp-4,  -0x1.b005d8p-2, INEXACT)
T(RN,     0x1.a8fec2cbc51fp-4,    0x1.aa86e2ee97413p-4,   0x1.9e3d36p-2, INEXACT)
T(RN,    0x1.a80427bdc7cacp-4,    0x1.a98991d1b2beap-4,   0x1.9a03b2p-2, INEXACT)
T(RN,    0x1.a70a2075eb341p-4,    0x1.a88cd949bda5cp-4,   0x1.a35622p-2, INEXACT)
T(RN,    0x1.a610ac9d0c264p-4,    0x1.a790b8f7073cap-4,    0x1.9b408p-2, INEXACT)
T(RN,    0x1.a517cbdc3ad88p-4,    0x1.a695307a21809p-4,   0x1.a2750cp-2, INEXACT)
T(RN,    0x1.a41f7ddcbac0bp-4,    0x1.a59a3f73e0dd3p-4,   0x1.9a4704p-2, INEXACT)
T(RN,    0x1.a327c248027b3p-4,    0x1.a49fe5855bf8fp-4,   0x1.a1459cp-2, INEXACT)
T(RN,    0x1.a23098c7bba7ap-4,    0x1.a3a6224feb769p-4,   0x1.a3831cp-2, INEXACT)
T(RN,    0x1.a13a0105c2d5dp-4,    0x1.a2acf57529c73p-4,   0x1.9ea2ccp-2, INEXACT)
T(RN,    0x1.a043faac275afp-4,    0x1.a1b45e96f2e49p-4,   0x1.9f9acep-2, INEXACT)
T(RN,    0x1.9f4e85652b3e7p-4,    0x1.a0bc5d5764237p-4,   0x1.9f5c8cp-2, INEXACT)
T(RN,    0x1.9e59a0db43085p-4,    0x1.9fc4f158dbe74p-4,   0x1.9e3488p-2, INEXACT)
T(RN,    0x1.9d654cb915cbdp-4,     0x1.9ece1a3df993p-4,   0x1.bbbb96p-2, INEXACT)
T(RN,    0x1.9c7188a97cd27p-4,    0x1.9dd7d7a99d19ap-4,   0x1.a1c006p-2, INEXACT)
T(RN,    0x1.9b7e545783b7ep-4,    0x1.9ce2293ee700bp-4,   0x1.a2b3eap-2, INEXACT)
T(RN,    0x1.9a8baf6e6815fp-4,    0x1.9bed0ea137f21p-4,   0x1.a0ce86p-2, INEXACT)
T(RN,   -0x1.921f9f01b866dp+1,   0x1.6428a6ab4a2fcp-19,  -0x1.0e23f8p-4, INEXACT)
T(RN,   -0x1.90bdb4d77030bp+1,    0x1.6203f36c0ab08p-7,  -0x1.e3fa64p-2, INEXACT)
T(RN,   -0x1.8f5d02296d91ep+1,    0x1.6167946816928p-6,  -0x1.7e9014p-2, INEXACT)
T(RN,   -0x1.8dfd85e58bfa7p+1,    0x1.08a364f34e5f6p-5,   0x1.5ea606p-6, INEXACT)
T(RN,   -0x1.8c9f3efa98212p+1,    0x1.6055203dfcc29p-5,   0x1.49c394p-2, INEXACT)
T(RN,   -0x1.8b422c584f2f3p+1,    0x1.b7ce379cc7068p-5,    0x1.51582p-3, INEXACT)
T(RN,   -0x1.89e64cef5ded4p+1,    0x1.0789e8387779bp-4,   0x1.257e18p-3, INEXACT)
T(RN,   -0x1.888b9fb15fef9p+1,     0x1.33157dadbd68p-4,   0x1.6ab934p-2, INEXACT)
T(RN,   -0x1.87322390dec45p+1,    0x1.5e8c5acbba1bdp-4,   0x1.6cb856p-2, INEXACT)
T(RN,   -0x1.85d9d78151228p+1,    0x1.89f0f52407fdep-4,   0x1.4a69e8p-4, INEXACT)
T(RN,   -0x1.8482ba771a186p+1,    0x1.b545b9ddc8191p-4,  -0x1.54fdd4p-3, INEXACT)
T(RN,   -0x1.832ccb67883c2p+1,    0x1.e08d0e51d2a77p-4,  -0x1.e3669cp-6, INEXACT)
T(RN,   -0x1.81d80948d4dc5p+1,    0x1.05e4a8510280ep-3,   0x1.6904b2p-3, INEXACT)
T(RN,   -0x1.8084731223317p+1,    0x1.1b7e6c2602be5p-3,  -0x1.7e6c5ep-2, INEXACT)
T(RN,   -0x1.7f3207bb7f8fdp+1,    0x1.3114fb5be8c88p-3,  -0x1.ce0deep-5, INEXACT)
T(RN,   -0x1.7de0c63dde9a9p+1,    0x1.46a97be1332d3p-3,  -0x1.6e5c0ap-2, INEXACT)
T(RN,   -0x1.7c90ad931c776p+1,    0x1.5c3d112267eb4p-3,  -0x1.f2cc56p-4, INEXACT)
T(RN,   -0x1.7b41bcb5fc024p+1,    0x1.71d0dc4bf3eeap-3,  -0x1.7e17eap-2, INEXACT)
T(RN,   -0x1.79f3f2a22602cp+1,    0x1.8765fc8a85275p-3,  -0x1.db1856p-4, INEXACT)
T(RN,   -0x1.78a74e542861fp+1,    0x1.9cfd8f4a00a5bp-3,   0x1.843416p-2, INEXACT)
T(RN,   -0x1.775bcec9755ffp+1,    0x1.b298b07334d42p-3,  -0x1.6727fap-2, INEXACT)
T(RN,   -0x1.7611730062cbbp+1,    0x1.c8387aa8666e7p-3,   0x1.ace454p-3, INEXACT)
T(RN,   -0x1.74c839f8293a8p+1,    0x1.ddde0780d609ap-3,   0x1.0b5692p-2, INEXACT)
T(RN,   -0x1.738022b0e3401p+1,    0x1.f38a6fc35acbep-3,   0x1.cc0dfcp-8, INEXACT)
T(RN,   -0x1.72392c2b8ca81p+1,    0x1.049f65d016fe6p-2,   -0x1.f763bp-2, INEXACT)
T(RN,   -0x1.70f3556a01afdp+1,    0x1.0f7e1975013a2p-2,  -0x1.7bb46cp-2, INEXACT)
T(RN,   -0x1.6fae9d6efe408p+1,    0x1.1a61dea74105ep-2,   -0x1.3eee3p-4, INEXACT)
T(RN,   -0x1.6e6b033e1d2a9p+1,    0x1.254b414725487p-2,   -0x1.0e941p-2, INEXACT)
T(RN,   -0x1.6d2885dbd7616p+1,    0x1.303acd5a419edp-2,  -0x1.462434p-3, INEXACT)
T(RN,   -0x1.6be7244d8337fp+1,    0x1.3b310f271190cp-2,   0x1.b29b9cp-3, INEXACT)
T(RN,   -0x1.6aa6dd99539dcp+1,     0x1.462e9350804cp-2,   0x1.9c7a58p-5, INEXACT)
T(RN,   -0x1.6967b0c6575cep+1,    0x1.5133e6f160b86p-2,   0x1.5cd06cp-5, INEXACT)
T(RN,   -0x1.68299cdc78587p+1,    0x1.5c4197b7e1a2ap-2,    0x1.26ffep-2, INEXACT)
T(RN,   -0x1.66eca0e47acbbp+1,    0x1.67583401099b5p-2,   -0x1.66684p-3, INEXACT)
T(RN,   -0x1.65b0bbe7fc89bp+1,    0x1.72784af44615cp-2,  -0x1.8f9394p-6, INEXACT)
T(RN,   -0x1.6475ecf1743e6p+1,     0x1.7da26c9f1943p-2,  -0x1.2d05f2p-2, INEXACT)
T(RN,    -0x1.633c330c30afp+1,    0x1.88d72a10f23f1p-2,  -0x1.f8d638p-2, INEXACT)
T(RN,   -0x1.62038d4457fc5p+1,    0x1.941715773b04fp-2,   0x1.6212f8p-8, INEXACT)
T(RN,   -0x1.60cbfaa6e6e52p+1,    0x1.9f62c239a7d14p-2,   0x1.374996p-5, INEXACT)
T(RN,   -0x1.5f957a41b0093p+1,    0x1.aabac516d3a81p-2,  -0x1.e5a02cp-2, INEXACT)
T(RN,   -0x1.5e600b235b2cep+1,    0x1.b61fb44135cd5p-2,   0x1.4d874ap-3, INEXACT)
T(RN,   -0x1.5d2bac5b647e2p+1,    0x1.c192277c7c292p-2,   0x1.3f3e14p-2, INEXACT)
T(RN,   -0x1.5bf85cfa1bd8cp+1,    0x1.cd12b83b56da4p-2,  -0x1.d76348p-2, INEXACT)
T(RN,   -0x1.5ac61c10a40ccp+1,    0x1.d8a201bdc1473p-2,  -0x1.2546e2p-4, INEXACT)
T(RN,   -0x1.5994e8b0f2243p+1,    0x1.e440a12fd5727p-2,    0x1.043cep-2, INEXACT)
T(RN,   -0x1.5864c1edccaabp+1,    0x1.efef35c936796p-2,    0x1.33e54p-2, INEXACT)
T(RN,   -0x1.5735a6dacaf47p+1,    0x1.fbae60ed1fa18p-2,  -0x1.93126ap-5, INEXACT)
T(RN,   -0x1.5607968c5466fp+1,    0x1.03bf632592c73p-1,   0x1.23c9b4p-3, INEXACT)
T(RN,   -0x1.54da90179fc19p+1,    0x1.09b086005be62p-1,  -0x1.08305cp-2, INEXACT)
T(RN,   -0x1.53ae9292b2675p+1,    0x1.0faaed5db8984p-1,   0x1.28dc64p-2, INEXACT)
T(RN,   -0x1.52839d145fa8bp+1,    0x1.15aeeeee2312ap-1,   0x1.d8feeap-2, INEXACT)
T(RN,   -0x1.5159aeb4480eap+1,     0x1.1bbce1cdd038p-1,  -0x1.ddfa62p-3, INEXACT)
T(RN,   -0x1.5030c68ad8a5fp+1,    0x1.21d51e973c526p-1,  -0x1.ceab5cp-4, INEXACT)
T(RN,   -0x1.4f08e3b14a4b1p+1,    0x1.27f7ff763f0bap-1,  -0x1.5055ccp-2, INEXACT)
T(RN,   -0x1.4de20541a0f6ep+1,    0x1.2e25e03baf624p-1,  -0x1.51276ap-5, INEXACT)
T(RN,    -0x1.4cbc2a56ab0cp+1,    0x1.345f1e71a0baep-1,   0x1.897f92p-3, INEXACT)
T(RN,   -0x1.4b97520c00a48p+1,    0x1.3aa4197042952p-1,   0x1.856b84p-3, INEXACT)
T(RN,   -0x1.4a737b7e02e05p+1,    0x1.40f532736cd47p-1,  -0x1.76e356p-4, INEXACT)
T(RN,   -0x1.4950a5c9db348p+1,    0x1.4752ccb0e305cp-1,   0x1.89d83ap-2, INEXACT)
T(RN,   -0x1.482ed00d7abadp+1,    0x1.4dbd4d6f598c7p-1,  -0x1.d534c6p-3, INEXACT)
T(RN,   -0x1.470df96799821p+1,    0x1.54351c1e4824dp-1,  -0x1.1cbda6p-3, INEXACT)
T(RN,   -0x1.45ee20f7b5defp+1,    0x1.5abaa26e95beep-1,  -0x1.e457fap-3, INEXACT)
T(RN,   -0x1.44cf45de13bd8p+1,    0x1.614e4c6c2a4fep-1,    0x1.3656ap-3, INEXACT)
T(RN,   -0x1.43b1673bbbf35p+1,      0x1.67f0889873ep-1,   -0x1.4fc59p-2, INEXACT)
T(RN,   -0x1.429484327b924p+1,    0x1.6ea1c805ecce9p-1,   0x1.610a08p-2, INEXACT)
T(RN,   -0x1.41789be4e33b7p+1,    0x1.75627e74b208dp-1,   0x1.9e08c4p-2, INEXACT)
T(RN,   -0x1.405dad764673bp+1,    0x1.7c33227038b4dp-1,    0x1.b3f8bp-2, INEXACT)
T(RN,   -0x1.3f43b80abaf77p+1,    0x1.83142d6e33bfdp-1,   0x1.4f5274p-3, INEXACT)
T(RN,   -0x1.3e2abac718102p+1,    0x1.8a061beeba966p-1,  -0x1.1d2f1cp-2, INEXACT)
T(RN,   -0x1.3d12b4d0f5e9ap+1,    0x1.91096d9dc35cbp-1,   0x1.c9e998p-2, INEXACT)
T(RN,   -0x1.3bfba54eace8dp+1,    0x1.981ea57603fdbp-1,   0x1.0be2a6p-3, INEXACT)
T(RN,    -0x1.3ae58b675502p+1,    0x1.9f4649e54e9a6p-1,   0x1.a0684ap-4, INEXACT)
T(RN,   -0x1.39d06642c510dp+1,    0x1.a680e4f27f05ap-1,  -0x1.96561ap-2, INEXACT)
T(RN,   -0x1.38bc3509922f8p+1,     0x1.adcf04651061p-1,   -0x1.6ae9bp-4, INEXACT)
T(RN,   -0x1.37a8f6e50f104p+1,    0x1.b53139ee7334cp-1,  -0x1.d2d98cp-2, INEXACT)
T(RN,   -0x1.3696aaff4b55cp+1,    0x1.bca81b553e035p-1,    0x1.ed4bbp-3, INEXACT)
T(RN,   -0x1.3585508312ed4p+1,    0x1.c43442a253d11p-1,  -0x1.80837ap-6, INEXACT)
T(RN,   -0x1.3474e69bed689p+1,     0x1.cbd64e501df1p-1,    0x1.d568fp-2, INEXACT)
T(RN,   -0x1.33656c761d592p+1,    0x1.d38ee17bf82cfp-1,  -0x1.78501cp-5, INEXACT)
T(RN,   -0x1.3256e13e9fab7p+1,    0x1.db5ea419f06f4p-1,   0x1.49330ap-3, INEXACT)
T(RN,   -0x1.314944232b02fp+1,    0x1.e346432afd317p-1,   0x1.feff84p-4, INEXACT)
T(RN,   -0x1.303c94522f168p+1,    0x1.eb4670f5d0443p-1,   0x1.6b2b1cp-5, INEXACT)
T(RN,   -0x1.2f30d0fad40dap+1,    0x1.f35fe5426e007p-1,   0x1.1b2b42p-5, INEXACT)
T(RN,   -0x1.2e25f94cf9de4p+1,    0x1.fb935d98b3a06p-1,   0x1.398112p-6, INEXACT)
T(RN,   -0x1.2d1c0c7937aabp+1,    0x1.01f0cec0fd325p+0,   -0x1.b7452p-6, INEXACT)
T(RN,   -0x1.2c1309b0db20cp+1,    0x1.0625b767041cap+0,  -0x1.c95242p-2, INEXACT)
T(RN,   -0x1.2b0af025e7d8bp+1,     0x1.0a68d0edc0fep+0,   0x1.97c916p-2, INEXACT)
T(RN,   -0x1.2a03bf0b16b57p+1,    0x1.0eba86f20b855p+0,   -0x1.bc151p-2, INEXACT)
T(RN,   -0x1.28fd7593d544ep+1,    0x1.131b48a650e1bp+0,   0x1.2fdbf4p-2, INEXACT)
T(RN,   -0x1.27f812f44520fp+1,    0x1.178b88fcbe602p+0,  -0x1.51b9b8p-2, INEXACT)
T(RN,   -0x1.26f396613b511p+1,    0x1.1c0bbed3a89e4p+0,   0x1.325a5ap-2, INEXACT)
T(RN,   -0x1.25efff103fac3p+1,    0x1.209c652453f8bp+0,   0x1.67f2acp-2, INEXACT)
T(RN,   -0x1.24ed4c378c3b9p+1,    0x1.253dfb34458ccp+0,   0x1.33bf68p-3, INEXACT)
T(RN,   -0x1.23eb7d0e0c9dep+1,    0x1.29f104c94709ap+0,   0x1.7b8092p-2, INEXACT)
T(RN,   -0x1.22ea90cb5d6adp+1,    0x1.2eb60a604ab01p+0,   0x1.7d4d1ap-3, INEXACT)
T(RN,   -0x1.21ea86a7cb978p+1,    0x1.338d996760455p+0,   0x1.6dd5c6p-2, INEXACT)
T(RN,   -0x1.20eb5ddc53db4p+1,    0x1.3878447aef73ep+0,   -0x1.cb001p-2, INEXACT)
T(RN,   -0x1.1fed15a2a2149p+1,    0x1.3d76a3a670183p+0,  -0x1.664d6ap-2, INEXACT)
T(RN,   -0x1.1eefad3510af8p+1,    0x1.428954a8dd4ccp+0,   0x1.4d17bcp-3, INEXACT)
T(RN,   -0x1.1df323cea80bap+1,    0x1.47b0fb3d24da5p+0,  -0x1.e67a7ep-4, INEXACT)
T(RN,   -0x1.1cf778ab1de31p+1,    0x1.4cee4166d9caep+0,   0x1.b173a6p-6, INEXACT)
T(RN,   -0x1.1bfcab06d4b21p+1,    0x1.5241d7c3768c1p+0,    -0x1.a611p-2, INEXACT)
T(RN,   -0x1.1b02ba1edb1ebp+1,    0x1.57ac75e081347p+0,  -0x1.d70cf8p-6, INEXACT)
T(RN,   -0x1.1a09a530eb616p+1,    0x1.5d2eda96eb2d8p+0,   0x1.dc0d14p-3, INEXACT)
T(RN,   -0x1.19116b7b6aae2p+1,    0x1.62c9cc6c0ce12p+0,  -0x1.3a2504p-3, INEXACT)
T(RN,   -0x1.181a0c3d689ddp+1,    0x1.687e19f8a60e8p+0,   0x1.5658dap-4, INEXACT)
T(RN,   -0x1.172386b69e984p+1,    0x1.6e4c9a56542bep+0,   0x1.3f9206p-2, INEXACT)
T(RN,   -0x1.162dda276f3edp+1,    0x1.74362d93f9ddbp+0,   0x1.d314f2p-8, INEXACT)
T(RN,   -0x1.153905d0e5d76p+1,    0x1.7a3bbd319d16bp+0,    0x1.4714ep-2, INEXACT)
T(RN,    -0x1.144508f4b5b8p+1,    0x1.805e3ca44d038p+0,   0x1.252934p-2, INEXACT)
T(RN,   -0x1.1351e2d539b32p+1,    0x1.869ea9e2ada06p+0,  -0x1.be32f6p-2, INEXACT)
T(RN,   -0x1.125f92b57383bp+1,    0x1.8cfe0dfad4d4ep+0,   0x1.fba1fep-2, INEXACT)
T(RN,    -0x1.116e17d90b3bp+1,    0x1.937d7db234461p+0,    0x1.af07ep-2, INEXACT)
T(RN,   -0x1.107d71844ead8p+1,    0x1.9a1e1a305c27bp+0,  -0x1.0cca58p-2, INEXACT)
T(RN,   -0x1.0f8d9efc30e19p+1,    0x1.a0e111b575dfbp+0,   0x1.8144c8p-2, INEXACT)
T(RN,   -0x1.0e9e9f86497dap+1,    0x1.a7c7a05d6a23dp+0,   0x1.99ca74p-2, INEXACT)
T(RN,   -0x1.0db07268d437ap+1,     0x1.aed310f0bcf2p+0,   0x1.fff1d6p-2, INEXACT)
T(RN,   -0x1.0cc316eab0447p+1,    0x1.b604bdc443227p+0,  -0x1.e9fe22p-2, INEXACT)
T(RN,    -0x1.0bd68c535fc8p+1,    0x1.bd5e11a8f14c1p+0,  -0x1.b55e84p-3, INEXACT)
T(RN,   -0x1.0aead1eb0745ep+1,    0x1.c4e088ed22ce5p+0,  -0x1.422026p-2, INEXACT)
T(RN,   -0x1.09ffe6fa6d129p+1,     0x1.cc8db270da59p+0,  -0x1.7efac8p-2, INEXACT)
T(RN,   -0x1.0915cacaf8c4cp+1,     0x1.d46730cea3b8p+0,  -0x1.57b42ep-3, INEXACT)
T(RN,   -0x1.082c7ca6b2a7bp+1,    0x1.dc6ebb9ae95cbp+0,  -0x1.e4a1b8p-2, INEXACT)
T(RN,   -0x1.0743fbd8432d8p+1,    0x1.e4a620bbbfdfcp+0,  -0x1.ea69fep-5, INEXACT)
T(RN,   -0x1.065c47aaf2626p+1,    0x1.ed0f45db5ede9p+0,   0x1.4ca95ep-2, INEXACT)
T(RN,   -0x1.05755f6aa7602p+1,    0x1.f5ac29f7ba283p+0,  -0x1.3d7648p-5, INEXACT)
T(RN,   -0x1.048f4263e7c24p+1,    0x1.fe7ee711f0c8ap+0,  -0x1.9ea886p-4, INEXACT)
T(RN,    -0x1.03a9efe3d71ap+1,    0x1.03c4da00491dap+1,   0x1.f51036p-3, INEXACT)
T(RN,    -0x1.02c567383664p+1,    0x1.0867733406ed4p+1,  -0x1.9d8f86p-2, INEXACT)
T(RN,   -0x1.01e1a7af637d5p+1,    0x1.0d287a6e7f8d7p+1,  -0x1.1d77e4p-2, INEXACT)
T(RN,   -0x1.00feb09858995p+1,    0x1.12093c9a399bcp+1,   0x1.bd17d8p-2, INEXACT)
T(RN,   -0x1.001c8142abb87p+1,     0x1.170b19835e6fp+1,   -0x1.677d3p-5, INEXACT)
T(RN,   -0x1.fe7631fd1c3d5p+0,     0x1.1c2f8534f8efp+1,   0x1.9315a2p-3, INEXACT)
T(RN,   -0x1.fcb4ee3997963p+0,    0x1.21780974e4033p+1,   0x1.0a2d24p-2, INEXACT)
T(RN,   -0x1.faf535dd95dfap+0,    0x1.26e647619a1fdp+1,  -0x1.8c86fap-2, INEXACT)
T(RN,   -0x1.f937078d16d3fp+0,    0x1.2c7bf9357a209p+1,  -0x1.c34adep-2, INEXACT)
T(RN,   -0x1.f77a61ed4c756p+0,    0x1.323af43385ea4p+1,   0x1.892358p-2, INEXACT)
T(RN,   -0x1.f5bf43a49a00bp+0,    0x1.38252ac21f56bp+1,   0x1.488784p-4, INEXACT)
T(RN,   -0x1.f405ab5a92dffp+0,    0x1.3e3caeb8da291p+1,   0x1.42e18ap-2, INEXACT)
T(RN,   -0x1.f24d97b7f99f9p+0,    0x1.4483b3e7211c2p+1,   0x1.540976p-2, INEXACT)
T(RN,   -0x1.f0970766bee2bp+0,    0x1.4afc92da2c228p+1,   0x1.e4f906p-2, INEXACT)
T(RN,   -0x1.eee1f912005a3p+0,    0x1.51a9cbe9a2756p+1,  -0x1.8968a4p-3, INEXACT)
T(RN,   -0x1.ed2e6b6607bb1p+0,    0x1.588e0a9341458p+1,  -0x1.a0fedap-2, INEXACT)
T(RN,   -0x1.eb7c5d1049b69p+0,    0x1.5fac292f05287p+1,   0x1.6826dcp-3, INEXACT)
T(RN,   -0x1.e9cbccbf64f34p+0,      0x1.67073506a7ep+1,  -0x1.18c56ap-2, INEXACT)
T(RN,   -0x1.e81cb92321068p+0,    0x1.6ea272dccddbdp+1,   0x1.657088p-3, INEXACT)
T(RN,   -0x1.e66f20ec6d6f2p+0,    0x1.768163f208afap+1,   0x1.b839f2p-4, INEXACT)
T(RN,   -0x1.e4c302cd60916p+0,    0x1.7ea7cb97e98d9p+1,   -0x1.87457p-5, INEXACT)
T(RN,   -0x1.e3185d7936b2dp+0,    0x1.8719b564ceda2p+1,   0x1.83729ep-4, INEXACT)
T(RN,   -0x1.e16f2fa450f81p+0,    0x1.8fdb7c1df3537p+1,   0x1.b5ee06p-2, INEXACT)
T(RN,   -0x1.dfc7780434632p+0,    0x1.98f1d170a12cdp+1,   0x1.045504p-2, INEXACT)
T(RN,   -0x1.de21354f88d1ep+0,    0x1.a261c6976146ap+1,  -0x1.26bc2ap-2, INEXACT)
T(RN,   -0x1.dc7c663e17fefp+0,    0x1.ac30d60cad95ap+1,   0x1.aca6dcp-5, INEXACT)
T(RN,    -0x1.dad90988cc82p+0,    0x1.b664ee723c70ap+1,   0x1.af923cp-4, INEXACT)
T(RN,   -0x1.d9371de9b0d19p+0,    0x1.c1047eda97c1bp+1,  -0x1.b1db9ap-3, INEXACT)
T(RN,   -0x1.d796a21bee461p+0,    0x1.cc1684aa99e2cp+1,   0x1.dbeb3cp-4, INEXACT)
T(RN,   -0x1.d5f794dbcc1cbp+0,    0x1.d7a29b51e2e08p+1,   0x1.636852p-4, INEXACT)
T(RN,   -0x1.d459f4e6ae7c9p+0,    0x1.e3b10e24bea3cp+1,    0x1.9788ep-2, INEXACT)
T(RN,   -0x1.d2bdc0fb157b4p+0,    0x1.f04aecafb972dp+1,  0x1.bed0b6p-12, INEXACT)
T(RN,   -0x1.d122f7d89c234p+0,    0x1.fd7a21edd361ap+1,  -0x1.c5a72ap-5, INEXACT)
T(RN,   -0x1.cf89983ff77afp+0,    0x1.05a4c76f4d83bp+2,   0x1.c56b5ep-7, INEXACT)
T(RN,   -0x1.cdf1a0f2f58c7p+0,    0x1.0ce294892da41p+2,    0x1.fc7a4p-4, INEXACT)
T(RN,   -0x1.cc5b10b47c6dfp+0,     0x1.147d0ef08fe7p+2,   0x1.8e2a7ap-2, INEXACT)
T(RN,   -0x1.cac5e648894bap+0,    0x1.1c7b7d938eac2p+2,  -0x1.6c94eap-4, INEXACT)
T(RN,    -0x1.c93220742f72p+0,    0x1.24e5ef47fa5d9p+2,  -0x1.b8cc28p-2, INEXACT)
T(RN,   -0x1.c79fbdfd9758dp+0,    0x1.2dc5565a6a897p+2,    0x1.dc866p-2, INEXACT)
T(RN,   -0x1.c60ebdabfdaf9p+0,     0x1.3723a8cd8031p+2,   0x1.bff7b6p-2, INEXACT)
T(RN,   -0x1.c47f1e47b269dp+0,    0x1.410c063e80f0ap+2,  -0x1.5e6f32p-2, INEXACT)
T(RN,   -0x1.c2f0de9a17cd8p+0,    0x1.4b8ae49f65b62p+2,   0x1.e77d56p-3, INEXACT)
T(RN,   -0x1.c163fd6da1815p+0,    0x1.56ae4541dbebfp+2,  -0x1.5a6c8ap-2, INEXACT)
T(RN,   -0x1.bfd8798dd39bdp+0,    0x1.6285f40fcefdbp+2,   0x1.807306p-3, INEXACT)
T(RN,    -0x1.be4e51c741b4p+0,    0x1.6f23d34c053a8p+2,   -0x1.0e981p-2, INEXACT)
T(RN,   -0x1.bcc584e78df25p+0,    0x1.7c9c36da0b417p+2,  -0x1.e3fd3ap-2, INEXACT)
T(RN,   -0x1.bb3e11bd68224p+0,    0x1.8b0652e5c76b5p+2,  -0x1.330f6ep-2, INEXACT)
T(RN,   -0x1.b9b7f7188cc57p+0,    0x1.9a7cc2e3d53abp+2,   0x1.7f78bep-2, INEXACT)
T(RN,   -0x1.b83333c9c426ap+0,    0x1.ab1e2f677ee65p+2,  -0x1.6509a4p-3, INEXACT)
T(RN,   -0x1.b6afc6a2e16ebp+0,    0x1.bd0e1b58f724ep+2,  -0x1.c00626p-2, INEXACT)
T(RN,   -0x1.b52dae76c1b92p+0,    0x1.d075e3e73da41p+2,   0x1.c33006p-5, INEXACT)
T(RN,   -0x1.b3acea194b2a4p+0,    0x1.e5860278a7813p+2,    -0x1.d7aap-2, INEXACT)
T(RN,    -0x1.b22d785f6c06p+0,    0x1.fc77a5588a348p+2,  -0x1.ebad4ep-2, INEXACT)
T(RN,   -0x1.b0af581f19c76p+0,    0x1.0ac75dd6f75d5p+3,  -0x1.bbf466p-3, INEXACT)
T(RN,   -0x1.af32882f5038dp+0,    0x1.188e4e45bd617p+3,   0x1.a0ca5cp-7, INEXACT)
T(RN,   -0x1.adb70768108d5p+0,    0x1.27c1c0b812c96p+3,   0x1.1220e6p-5, INEXACT)
T(RN,   -0x1.ac3cd4a2607a5p+0,    0x1.389d929e19075p+3,   -0x1.bcb7cp-2, INEXACT)
T(RN,   -0x1.aac3eeb849527p+0,    0x1.4b6b7f12a6cdfp+3,  -0x1.21f8c6p-5, INEXACT)
T(RN,   -0x1.a94c5484d7215p+0,    0x1.608761bf5bc9dp+3,   0x1.f39dccp-3, INEXACT)
T(RN,   -0x1.a7d604e417c74p+0,    0x1.78652667be9c2p+3,   0x1.fcbc34p-3, INEXACT)
T(RN,   -0x1.a660feb31a16cp+0,    0x1.939937625858bp+3,   -0x1.ab15ap-5, INEXACT)
T(RN,   -0x1.a4ed40cfecf27p+0,    0x1.b2e4bc0c7dd37p+3,  -0x1.718c38p-2, INEXACT)
T(RN,   -0x1.a37aca199e6b5p+0,    0x1.d747d408b506fp+3,  -0x1.10f90cp-2, INEXACT)
T(RN,   -0x1.a20999703ae08p+0,    0x1.010ec3ae087b7p+4,  -0x1.75a31cp-6, INEXACT)
T(RN,   -0x1.a099adb4cc1f5p+0,    0x1.1aa404951d583p+4,   0x1.6b963cp-2, INEXACT)
T(RN,   -0x1.9f2b05c958843p+0,    0x1.39bcd04a5e84dp+4,  -0x1.33754ap-8, INEXACT)
T(RN,   -0x1.9dbda090e21c6p+0,    0x1.60593bf43c88bp+4,   0x1.7c13dap-2, INEXACT)
T(RN,   -0x1.9c517cef65c88p+0,    0x1.9193211a026bbp+4,   0x1.0dc408p-2, INEXACT)
T(RN,   -0x1.9ae699c9da5fep+0,    0x1.d27ed349dfc8ap+4,   0x1.552068p-3, INEXACT)
T(RN,   -0x1.997cf6062fd42p+0,    0x1.1605d881752e8p+5,   -0x1.9750cp-3, INEXACT)
T(RN,   -0x1.9814908b4e569p+0,     0x1.57c405185b06p+5,  -0x1.8fd812p-2, INEXACT)
T(RN,   -0x1.96ad6841157d3p+0,    0x1.c1b71b5c868fcp+5,  -0x1.a0b6dap-3, INEXACT)
T(RN,   -0x1.95477c105b692p+0,    0x1.44824adf6ea79p+6,  -0x1.6d7fbcp-2, INEXACT)
T(RN,   -0x1.93e2cae2ebedap+0,    0x1.2290f78fd52cap+7,  -0x1.90e99cp-2, INEXACT)
T(RN,    -0x1.927f53a387b8p+0,    0x1.56b1c6daed911p+9,  -0x1.93d20cp-5, INEXACT)
T(RN,   -0x1.911d153de377cp+0,   -0x1.facceb4976c8fp+7,   -0x1.bd4bap-6, INEXACT)
T(RN,   -0x1.8fbc0e9ea7082p+0,   -0x1.ac926518a8803p+6,   0x1.12e476p-2, INEXACT)
T(RN,   -0x1.8e5c3eb36c9a1p+0,   -0x1.1010c6bba1b39p+6,   0x1.e477bap-4, INEXACT)
T(RN,   -0x1.8cfda46abfdecp+0,   -0x1.8eed95bb20fd1p+5,  -0x1.300cf8p-2, INEXACT)
T(RN,   -0x1.8ba03eb41d335p+0,   -0x1.3b1c6551e99b3p+5,   0x1.4b3be8p-2, INEXACT)
T(RN,   -0x1.8a440c7ff0ccap+0,   -0x1.048af4bb06434p+5,   0x1.3ea5eep-3, INEXACT)
T(RN,   -0x1.88e90cbf95e4bp+0,    -0x1.bc5f65cc1e52p+4,    0x1.191d2p-3, INEXACT)
T(RN,   -0x1.878f3e6555e7fp+0,   -0x1.838012ccc875ep+4,   -0x1.968ffp-4, INEXACT)
T(RN,   -0x1.8636a06467a3bp+0,   -0x1.57a69ac1134f6p+4,   0x1.848ec4p-2, INEXACT)
T(RN,   -0x1.84df31b0ee754p+0,   -0x1.34cf21c545164p+4,  -0x1.6017d4p-4, INEXACT)
T(RN,   -0x1.8388f13ff9799p+0,   -0x1.1874f42e35602p+4,  -0x1.bc4938p-3, INEXACT)
T(RN,   -0x1.8233de0782be2p+0,   -0x1.00ef352ecfae7p+4,   0x1.ddf046p-3, INEXACT)
T(RN,   -0x1.80dff6fe6e71ap+0,   -0x1.da350d7ef330ap+3,  -0x1.0887cap-2, INEXACT)
T(RN,   -0x1.7f8d3b1c8a168p+0,   -0x1.b850d967cab81p+3,  -0x1.aa5caep-3, INEXACT)
T(RN,    -0x1.7e3ba95a8bb5p+0,   -0x1.9b04f9c4e8da4p+3,   0x1.6aac54p-6, INEXACT)
T(RN,    -0x1.7ceb40b2110fp+0,   -0x1.8171194785845p+3,   0x1.ea4196p-2, INEXACT)
T(RN,   -0x1.7b9c001d9ed3ep+0,   -0x1.6aea852057dfap+3,  -0x1.5f706ap-2, INEXACT)
T(RN,   -0x1.7a4de6989fd51p+0,   -0x1.56ed0cfb06898p+3,   0x1.b3f65ap-2, INEXACT)
T(RN,    -0x1.7900f31f643cp+0,    -0x1.4510bb50f208p+3,  -0x1.5ad184p-4, INEXACT)
T(RN,   -0x1.77b524af20bfbp+0,   -0x1.3502ae064d4eep+3,     0x1.2feep-4, INEXACT)
T(RN,   -0x1.766a7a45eddc2p+0,   -0x1.26800116005c6p+3,  -0x1.8535a8p-2, INEXACT)
T(RN,   -0x1.7520f2e2c7096p+0,    -0x1.1952208d162ap+3,  -0x1.05cbd4p-2, INEXACT)
T(RN,    -0x1.73d88d8589f4p+0,   -0x1.0d4c132eb26bap+3,   0x1.935992p-2, INEXACT)
T(RN,   -0x1.7291492ef5b5fp+0,   -0x1.02487467267ccp+3,   0x1.a0243ap-3, INEXACT)
T(RN,   -0x1.714b24e0aa105p+0,   -0x1.f04fd7de0507cp+2,  -0x1.640002p-7, INEXACT)
T(RN,   -0x1.70061f9d26a52p+0,   -0x1.dda001d937965p+2,  -0x1.9432a8p-2, INEXACT)
T(RN,   -0x1.6ec23867ca331p+0,   -0x1.cc54613c99ff5p+2,   0x1.c0a4ecp-3, INEXACT)
T(RN,   -0x1.6d7f6e44d1d05p+0,   -0x1.bc466f027a13ep+2,   0x1.8a1ea4p-3, INEXACT)
T(RN,   -0x1.6c3dc03958276p+0,   -0x1.ad55014f60448p+2,  -0x1.c042bap-4, INEXACT)
T(RN,   -0x1.6afd2d4b54b3fp+0,   -0x1.9f6364827d5b8p+2,   0x1.c5f78cp-4, INEXACT)
T(RN,   -0x1.69bdb4819b009p+0,   -0x1.9258a15cf8a63p+2,   0x1.32ee8ep-5, INEXACT)
T(RN,   -0x1.687f54e3d9e4cp+0,   -0x1.861ee64da990dp+2,  -0x1.a61262p-2, INEXACT)
T(RN,   -0x1.67420d7a9ac45p+0,    -0x1.7aa30c5d3018p+2,  -0x1.615556p-4, INEXACT)
T(RN,   -0x1.6605dd4f40cecp+0,   -0x1.6fd431feb5503p+2,  -0x1.bfcd32p-7, INEXACT)
T(RN,   -0x1.64cac36c083fdp+0,   -0x1.65a3675bb2362p+2,   -0x1.45279p-3, INEXACT)
T(RN,   -0x1.6390bedc05a02p+0,   -0x1.5c0368ae07494p+2,  -0x1.7ef8a2p-2, INEXACT)
T(RN,   -0x1.6257ceab25073p+0,   -0x1.52e863faa2b47p+2,   0x1.70ff1ap-2, INEXACT)
T(RN,   -0x1.611ff1e6295d4p+0,   -0x1.4a47c81059905p+2,    0x1.69f82p-4, INEXACT)
T(RN,   -0x1.5fe9279aab9edp+0,   -0x1.42181b1e3611dp+2,   0x1.d5720cp-2, INEXACT)
T(RN,   -0x1.5eb36ed71a1fbp+0,   -0x1.3a50d78ad0f58p+2,   0x1.c7281cp-2, INEXACT)
T(RN,   -0x1.5d7ec6aab7cf6p+0,   -0x1.32ea4df98db3dp+2,   0x1.e77e26p-2, INEXACT)
T(RN,   -0x1.5c4b2e259b7e4p+0,   -0x1.2bdd8b9f50e5ep+2,   0x1.017efap-5, INEXACT)
T(RN,   -0x1.5b18a458af229p+0,    -0x1.25244431ebeep+2,    0x1.d2fc3p-3, INEXACT)
T(RN,   -0x1.59e72855af1f1p+0,   -0x1.1eb8bede8ae31p+2,   0x1.000f0ep-5, INEXACT)
T(RN,   -0x1.58b6b92f29898p+0,   -0x1.1895c5cddc20ep+2,    0x1.3ebfap-2, INEXACT)
T(RN,   -0x1.578755f87d725p+0,    -0x1.12b697d1e089p+2,   0x1.a44834p-2, INEXACT)
T(RN,   -0x1.5658fdc5da2c8p+0,   -0x1.0d16dbea74eedp+2,  -0x1.aeb6d4p-5, INEXACT)
T(RN,   -0x1.552bafac3e966p+0,   -0x1.07b2965b8bc59p+2,  -0x1.2c0956p-3, INEXACT)
T(RN,    -0x1.53ff6ac17863p+0,   -0x1.02861f1b6378bp+2,   0x1.ec8b66p-3, INEXACT)
T(RN,    -0x1.52d42e1c2364p+0,   -0x1.fb1c32d09c344p+1,  -0x1.1644e4p-2, INEXACT)
T(RN,   -0x1.51a9f8d3a8d46p+0,   -0x1.f18ed8ba83921p+1,  -0x1.a4bc42p-2, INEXACT)
T(RN,   -0x1.5080ca003ea36p+0,   -0x1.e85e78c56f989p+1,  -0x1.dbb28ep-3, INEXACT)
T(RN,   -0x1.4f58a0bae6c0bp+0,   -0x1.df85cabd36db7p+1,  -0x1.1dc9c8p-5, INEXACT)
T(RN,   -0x1.4e317c1d6e68bp+0,   -0x1.d6ffeb14c8b14p+1,  -0x1.615dfap-3, INEXACT)
T(RN,   -0x1.4d0b5b426d719p+0,   -0x1.cec851b4376a2p+1,  -0x1.b6a3ecp-3, INEXACT)
T(RN,   -0x1.4be63d4545991p+0,   -0x1.c6dac9c43072cp+1,  -0x1.e508bap-4, INEXACT)
T(RN,   -0x1.4ac2214221d2bp+0,   -0x1.bf336a579d0f9p+1,   0x1.681a1cp-2, INEXACT)
T(RN,   -0x1.499f0655f596ap+0,   -0x1.b7ce8fd87bb6bp+1,  -0x1.1c4682p-2, INEXACT)
T(RN,   -0x1.487ceb9e7c316p+0,   -0x1.b0a8d620ad62bp+1,  -0x1.b85ec6p-8, INEXACT)
T(RN,   -0x1.475bd03a3813bp+0,   -0x1.a9bf132a9005fp+1,   0x1.e4f36cp-3, INEXACT)
T(RN,   -0x1.463bb3487223ap+0,   -0x1.a30e5247e6ddfp+1,   0x1.c3348ap-2, INEXACT)
T(RN,   -0x1.451c93e9390d7p+0,   -0x1.9c93cfcfd5d97p+1,   0x1.28b27cp-7, INEXACT)
T(RN,   -0x1.43fe713d6095ep+0,   -0x1.964cf536a68a8p+1,  -0x1.a4278ap-2, INEXACT)
T(RN,   -0x1.42e14a6680ec8p+0,   -0x1.90375583b80a6p+1,   0x1.e26534p-2, INEXACT)
T(RN,   -0x1.41c51e86f5ff1p+0,   -0x1.8a50aa1b6ae3ep+1,  -0x1.03bfa6p-2, INEXACT)
T(RN,   -0x1.40a9ecc1deccfp+0,   -0x1.8496cfd41755ep+1,   -0x1.2e026p-3, INEXACT)
T(RN,   -0x1.3f8fb43b1cbbap+0,   -0x1.7f07c44e2eccdp+1,   0x1.f90ceap-3, INEXACT)
T(RN,   -0x1.3e76741752eb8p+0,   -0x1.79a1a3889769cp+1,    0x1.7e554p-3, INEXACT)
T(RN,   -0x1.3d5e2b7be58dap+0,   -0x1.7462a5ab1f532p+1,  -0x1.e89ebap-2, INEXACT)
T(RN,   -0x1.3c46d98ef9396p+0,   -0x1.6f491d0199a7bp+1,  -0x1.9b1028p-2, INEXACT)
T(RN,   -0x1.3b307d7772438p+0,   -0x1.6a537422d435ep+1,  -0x1.08fddep-2, INEXACT)
T(RN,   -0x1.3a1b165cf4153p+0,   -0x1.65802c3f1e8aep+1,  -0x1.9b9b28p-5, INEXACT)
T(RN,   -0x1.3906a367e083fp+0,   -0x1.60cddb929375dp+1,   0x1.adedaap-3, INEXACT)
T(RN,   -0x1.37f323c15729ep+0,   -0x1.5c3b2bf7bfdcdp+1,   0x1.1848fcp-2, INEXACT)
T(RN,   -0x1.36e0969334bedp+0,   -0x1.57c6d9979ecfap+1,  -0x1.f601eep-2, INEXACT)
T(RN,    -0x1.35cefb081272p+0,   -0x1.536fb1b434bd7p+1,  -0x1.8afe62p-2, INEXACT)
T(RN,   -0x1.34be504b4543cp+0,   -0x1.4f34918b5c0f9p+1,  -0x1.18fec8p-5, INEXACT)
T(RN,   -0x1.33ae9588dd60bp+0,   -0x1.4b14654f9570ap+1,   0x1.885bb8p-2, INEXACT)
T(RN,   -0x1.329fc9eda57cap+0,   -0x1.470e2734e6a6bp+1,   0x1.b4eaecp-4, INEXACT)
T(RN,   -0x1.3191eca7222ebp+0,   -0x1.4320de90053b1p+1,   0x1.b48e3ap-2, INEXACT)
T(RN,   -0x1.3084fce3914d6p+0,   -0x1.3f4b9f0636cbfp+1,   0x1.9e0c42p-2, INEXACT)
T(RN,   -0x1.2f78f9d1e94bep+0,   -0x1.3b8d87cc78ad2p+1,  -0x1.9b453ap-2, INEXACT)
T(RN,   -0x1.2e6de2a1d8976p+0,   -0x1.37e5c2f4a3e27p+1,   0x1.bc5552p-2, INEXACT)
T(RN,   -0x1.2d63b683c4f53p+0,   -0x1.345384c76224cp+1,   0x1.5a50f2p-2, INEXACT)
T(RN,   -0x1.2c5a74a8cae15p+0,    -0x1.30d60b29e4dfp+1,  -0x1.6193e6p-2, INEXACT)
T(RN,   -0x1.2b521c42bceddp+0,   -0x1.2d6c9d0e68619p+1,   0x1.674caep-2, INEXACT)
T(RN,   -0x1.2a4aac8423227p+0,   -0x1.2a1689eea430dp+1,  -0x1.899374p-2, INEXACT)
T(RN,   -0x1.294424a03a5cdp+0,   -0x1.26d3294f5dadbp+1,  -0x1.145204p-2, INEXACT)
T(RN,   -0x1.283e83caf3b19p+0,   -0x1.23a1da4c64a26p+1,  -0x1.35380ap-2, INEXACT)
T(RN,   -0x1.2739c938f3cd7p+0,   -0x1.2082032c51a76p+1,   0x1.d08214p-5, INEXACT)
T(RN,   -0x1.2635f41f92576p+0,   -0x1.1d7310fb6d2f4p+1,  -0x1.749fbap-2, INEXACT)
T(RN,   -0x1.253303b4d952ep+0,   -0x1.1a74772d335cbp+1,   0x1.6a52d8p-4, INEXACT)
T(RN,   -0x1.2430f72f84835p+0,   -0x1.1785af43f4dd2p+1,   0x1.fe5508p-3, INEXACT)
T(RN,   -0x1.232fcdc700cf1p+0,   -0x1.14a6387e1fe2bp+1,   0x1.0a2f2cp-7, INEXACT)
T(RN,   -0x1.222f86b36ba3fp+0,   -0x1.11d59788c640dp+1,   0x1.a6e22cp-2, INEXACT)
T(RN,   -0x1.2130212d925bap+0,   -0x1.0f135636fe971p+1,     0x1.e0a2p-8, INEXACT)
T(RN,   -0x1.20319c6ef1a11p+0,   -0x1.0c5f033dc697bp+1,  -0x1.d7d76cp-2, INEXACT)
T(RN,   -0x1.1f33f7b1b4d5fp+0,   -0x1.09b831f413d14p+1,    0x1.02acfp-3, INEXACT)
T(RN,    -0x1.1e373230b579p+0,   -0x1.071e7a16c716dp+1,   -0x1.39d0ep-2, INEXACT)
T(RN,   -0x1.1d3b4b277a8cep+0,   -0x1.049177903cb58p+1,   0x1.069d66p-2, INEXACT)
T(RN,   -0x1.1c4041d237ff2p+0,   -0x1.0210ca4339345p+1,  -0x1.feb6acp-2, INEXACT)
T(RN,   -0x1.1b46156dce107p+0,   -0x1.ff382bb1eecffp+0,   0x1.cc15e2p-2, INEXACT)
T(RN,   -0x1.1a4cc537c8bcap+0,   -0x1.fa660324427fap+0,   -0x1.048b2p-2, INEXACT)
T(RN,   -0x1.1954506e5f23bp+0,   -0x1.f5aa703501d13p+0,  -0x1.69b90ep-2, INEXACT)
T(RN,    -0x1.185cb65072f3p+0,   -0x1.f104cebe7774bp+0,    0x1.3477ep-2, INEXACT)
T(RN,   -0x1.1765f61d8fcf8p+0,   -0x1.ec7480ced7da6p+0,   0x1.44880cp-2, INEXACT)
T(RN,   -0x1.16700f15eabfcp+0,   -0x1.e7f8ee5de28e3p+0,   0x1.f9b2fcp-3, INEXACT)
T(RN,   -0x1.157b007a61971p+0,   -0x1.e3918506a7dd5p+0,   -0x1.62863p-3, INEXACT)
T(RN,    -0x1.1486c98c7a61p+0,   -0x1.df3db7c52e7f8p+0,  -0x1.abce6cp-3, INEXACT)
T(RN,   -0x1.1393698e62cd1p+0,   -0x1.dafcfeb7b9fb9p+0,   0x1.78f388p-4, INEXACT)
T(RN,   -0x1.12a0dfc2ef9b7p+0,   -0x1.d6ced6e37714dp+0,   0x1.6e3156p-6, INEXACT)
T(RN,   -0x1.11af2b6d9c09cp+0,   -0x1.d2b2c1fc57baep+0,   0x1.16d9a4p-2, INEXACT)
T(RN,   -0x1.10be4bd28940bp+0,   -0x1.cea8462febdccp+0,   0x1.950028p-4, INEXACT)
T(RN,   -0x1.0fce40367dc1fp+0,   -0x1.caaeedf308085p+0,   0x1.22588cp-2, INEXACT)
T(RN,   -0x1.0edf07dee4d66p+0,   -0x1.c6c647d20e0b8p+0,   0x1.949c88p-2, INEXACT)
T(RN,   -0x1.0df0a211cdfdap+0,    -0x1.c2ede643aed7p+0,  -0x1.98d184p-5, INEXACT)
T(RN,    -0x1.0d030e15ec5dp+0,   -0x1.bf255f7dffa13p+0,  -0x1.353abep-2, INEXACT)
T(RN,   -0x1.0c164b32962fcp+0,   -0x1.bb6c4d4dbeed3p+0,  -0x1.409becp-2, INEXACT)
T(RN,   -0x1.0b2a58afc4375p+0,   -0x1.b7c24cefa86e3p+0,    0x1.007ccp-2, INEXACT)
T(RN,   -0x1.0a3f35d6112c9p+0,   -0x1.b426feebb8fe1p+0,  -0x1.ad3712p-2, INEXACT)
T(RN,   -0x1.0954e1eeb9312p+0,   -0x1.b09a06f245dfep+0,  -0x1.a33fd2p-4, INEXACT)
T(RN,   -0x1.086b5c4399413p+0,   -0x1.ad1b0bbacc727p+0,  -0x1.0ceb8cp-3, INEXACT)
T(RN,   -0x1.0782a41f2ea62p+0,   -0x1.a9a9b6e46133dp+0,   0x1.5cfdbcp-9, INEXACT)
T(RN,   -0x1.069ab8cc96694p+0,   -0x1.a645b4d7a6959p+0,  -0x1.29f4fap-4, INEXACT)
T(RN,   -0x1.05b399978cc77p+0,   -0x1.a2eeb4aa35a6cp+0,   0x1.c3d75cp-2, INEXACT)
T(RN,   -0x1.04cd45cc6ca4cp+0,   -0x1.9fa4680363fa2p+0,   0x1.0b91f8p-3, INEXACT)
T(RN,    -0x1.03e7bcb82f01p+0,    -0x1.9c6683025381p+0,   0x1.1291bep-7, INEXACT)
T(RN,   -0x1.0302fda86a6c8p+0,   -0x1.9934bc253a442p+0,    0x1.7db53p-3, INEXACT)
T(RN,   -0x1.021f07eb527d6p+0,    -0x1.960ecc31d106p+0,   0x1.974f12p-2, INEXACT)
T(RN,   -0x1.013bdacfb7458p+0,   -0x1.92f46e1ed8e59p+0,   0x1.de9d66p-4, INEXACT)
T(RN,   -0x1.005975a504c8ap+0,   -0x1.8fe55efea90f6p+0,  -0x1.760c92p-2, INEXACT)
T(RN,   -0x1.feefaf7684e63p-1,   -0x1.8ce15deab676ep+0,   0x1.a0588ap-2, INEXACT)
T(RN,   -0x1.fd2e00c625229p-1,   -0x1.89e82bf00868ep+0,  -0x1.8da47ep-3, INEXACT)
T(RN,   -0x1.fb6ddddb638e3p-1,   -0x1.86f98bfc8d8e4p+0,   0x1.115d88p-4, INEXACT)
T(RN,   -0x1.f9af4559ed107p-1,    -0x1.841542cd45bap+0,   0x1.45c2bcp-4, INEXACT)
T(RN,   -0x1.f7f235e6a1217p-1,   -0x1.813b16dd35864p+0,  -0x1.c1f45cp-2, INEXACT)
T(RN,   -0x1.f636ae2790bc3p-1,   -0x1.7e6ad055196ccp+0,   0x1.72cb5ep-3, INEXACT)
T(RN,   -0x1.f47cacc3fd51fp-1,   -0x1.7ba438fbcea06p+0,   0x1.cdef6cp-3, INEXACT)
T(RN,   -0x1.f2c4306457bddp-1,   -0x1.78e71c2768796p+0,  -0x1.979ccep-5, INEXACT)
T(RN,   -0x1.f10d37b23f3a4p-1,   -0x1.763346aee9d2ep+0,  -0x1.ab9ffap-2, INEXACT)
T(RN,   -0x1.ef57c15880567p-1,   -0x1.738886dc9a2ecp+0,  -0x1.6d2e8ep-3, INEXACT)
T(RN,   -0x1.eda3cc0313ed6p-1,   -0x1.70e6ac60eef14p+0,  -0x1.58bf18p-6, INEXACT)
T(RN,   -0x1.ebf1565f1e1dap-1,   -0x1.6e4d8846016f5p+0,   0x1.f69d48p-2, INEXACT)
T(RN,   -0x1.ea405f1aed419p-1,   -0x1.6bbcece38af44p+0,   0x1.ada74ep-4, INEXACT)
T(RN,   -0x1.e890e4e5f8e96p-1,   -0x1.6934add360455p+0,   0x1.a41ef2p-2, INEXACT)
T(RN,   -0x1.e6e2e670e0d52p-1,   -0x1.66b49fe666821p+0,   0x1.2b7ecep-2, INEXACT)
T(RN,   -0x1.e536626d6bf05p-1,   -0x1.643c9919fb987p+0,   -0x1.01b74p-2, INEXACT)
T(RN,   -0x1.e38b578e874dcp-1,   -0x1.61cc708dccd1bp+0,  -0x1.e4f8fap-7, INEXACT)
T(RN,   -0x1.e1e1c48845253p-1,   -0x1.5f63fe7a164bep+0,  -0x1.f0864cp-3, INEXACT)
T(RN,   -0x1.e039a80fdbd0dp-1,   -0x1.5d031c264674ep+0,  -0x1.6d8246p-2, INEXACT)
T(RN,   -0x1.de9300dba4cc7p-1,   -0x1.5aa9a3e000e58p+0,  -0x1.3b6a16p-3, INEXACT)
T(RN,   -0x1.dcedcda31bb54p-1,   -0x1.585770f27c345p+0,   0x1.c92e2ep-4, INEXACT)
T(RN,   -0x1.db4a0d1edd4a3p-1,   -0x1.560c5f9e36951p+0,   0x1.df7926p-2, INEXACT)
T(RN,    -0x1.d9a7be08a66ep-1,   -0x1.53c84d10fd52bp+0,   0x1.4ec06cp-4, INEXACT)
T(RN,   -0x1.d806df1b5328fp-1,   -0x1.518b175e43613p+0,   0x1.739368p-2, INEXACT)
T(RN,   -0x1.d6676f12ddacdp-1,   -0x1.4f549d77c37dep+0,  -0x1.63e41ep-2, INEXACT)
T(RN,   -0x1.d4c96cac5d589p-1,   -0x1.4d24bf266a791p+0,  -0x1.62764cp-3, INEXACT)
T(RN,   -0x1.d32cd6a605bd6p-1,   -0x1.4afb5d038679cp+0,  -0x1.1c1782p-2, INEXACT)
T(RN,   -0x1.d191abbf25a4ep-1,   -0x1.48d85872382e8p+0,    0x1.b394ap-4, INEXACT)
T(RN,   -0x1.cff7eab826177p-1,   -0x1.46bb93992307fp+0,   0x1.501138p-2, INEXACT)
T(RN,   -0x1.ce5f925289641p-1,   -0x1.44a4f15c59bf4p+0,  -0x1.d3b7bcp-2, INEXACT)
T(RN,   -0x1.ccc8a150ea28ap-1,   -0x1.42945557848b4p+0,    0x1.1989ap-2, INEXACT)
T(RN,   -0x1.cb331676fa5b7p-1,    -0x1.4089a3d83e8bp+0,  -0x1.179e86p-2, INEXACT)
T(RN,   -0x1.c99ef08982552p-1,   -0x1.3e84c1d8a806ap+0,   0x1.f3eca4p-5, INEXACT)
T(RN,   -0x1.c80c2e4e5fdbcp-1,   -0x1.3c8594fa2b4b2p+0,  -0x1.1a6916p-2, INEXACT)
T(RN,   -0x1.c67ace8c852e8p-1,   -0x1.3a8c038071fb2p+0,   0x1.a6c40cp-8, INEXACT)
T(RN,   -0x1.c4ead00bf812bp-1,   -0x1.3897f44c88ce6p+0,   0x1.d1c336p-2, INEXACT)
T(RN,   -0x1.c35c3195d0e0fp-1,   -0x1.36a94ed82fcd9p+0,   0x1.84591cp-3, INEXACT)
T(RN,   -0x1.c1cef1f439939p-1,   -0x1.34bffb3155339p+0,   0x1.c5e7cep-2, INEXACT)
T(RN,   -0x1.c0430ff26cd5fp-1,   -0x1.32dbe1f5b9324p+0,  -0x1.b04168p-2, INEXACT)
T(RN,   -0x1.beb88a5cb5145p-1,   -0x1.30fcec4eb8ebep+0,   0x1.3031a8p-2, INEXACT)
T(RN,   -0x1.bd2f60006b8cbp-1,   -0x1.2f2303ed3f0a8p+0,   0x1.166d28p-6, INEXACT)
T(RN,   -0x1.bba78fabf7608p-1,   -0x1.2d4e1305d86cdp+0,   0x1.94dd12p-4, INEXACT)
T(RN,    -0x1.ba21182ecca7p-1,   -0x1.2b7e044ceb762p+0,  -0x1.178e96p-2, INEXACT)
T(RN,   -0x1.b89bf8596b80bp-1,   -0x1.29b2c2f3109d4p+0,   0x1.88dda4p-2, INEXACT)
T(RN,   -0x1.b7182efd5f2b6p-1,   -0x1.27ec3aa18ae81p+0,  -0x1.66d256p-5, INEXACT)
T(RN,   -0x1.b595baed3d16cp-1,   -0x1.262a5776df0e8p+0,    0x1.0ec6dp-2, INEXACT)
T(RN,   -0x1.b4149afca3fadp-1,   -0x1.246d060388135p+0,  -0x1.7d41d8p-2, INEXACT)
T(RN,   -0x1.b294ce003aed8p-1,   -0x1.22b43346c8266p+0,  -0x1.6deec8p-2, INEXACT)
T(RN,   -0x1.b11652cdb07afp-1,   -0x1.20ffccab94bc2p+0,  -0x1.429258p-2, INEXACT)
T(RN,   -0x1.af99283bb9bccp-1,   -0x1.1f4fc0059cc72p+0,    -0x1.dfe3p-2, INEXACT)
T(RN,   -0x1.ae1d4d2211739p-1,   -0x1.1da3fb8e68164p+0,  -0x1.67a97cp-4, INEXACT)
T(RN,   -0x1.aca2c05977206p-1,   -0x1.1bfc6de28ede7p+0,   0x1.57db6cp-2, INEXACT)
T(RN,   -0x1.ab2980bbae1f4p-1,   -0x1.1a5905ff08859p+0,  -0x1.0ced3ep-3, INEXACT)
T(RN,   -0x1.a9b18d237cc29p-1,   -0x1.18b9b33e90cc2p+0,   0x1.546ca2p-8, INEXACT)
T(RN,    -0x1.a83ae46cab6fp-1,   -0x1.171e6557227ecp+0,   0x1.10af38p-2, INEXACT)
T(RN,   -0x1.a6c5857403b89p-1,   -0x1.15870c5786e06p+0,  -0x1.bc8d9p-10, INEXACT)
T(RN,   -0x1.a5516f174f802p-1,   -0x1.13f398a4f9075p+0,  -0x1.c06522p-2, INEXACT)
T(RN,   -0x1.a3dea0355811fp-1,   -0x1.1263faf8dc705p+0,  -0x1.c4e22ap-2, INEXACT)
T(RN,   -0x1.a26d17ade544cp-1,   -0x1.10d8245e8611cp+0,   0x1.a3b36ap-2, INEXACT)
T(RN,   -0x1.a0fcd461bc99dp-1,   -0x1.0f50063117419p+0,   0x1.693c72p-3, INEXACT)
T(RN,   -0x1.9f8dd532a05d9p-1,   -0x1.0dcb921969c6ap+0,  -0x1.2b3ccap-3, INEXACT)
T(RN,   -0x1.9e2019034ec95p-1,   -0x1.0c4aba0c0c775p+0,  -0x1.a3cf24p-2, INEXACT)
T(RN,   -0x1.9cb39eb781256p-1,   -0x1.0acd70474fcacp+0,  -0x1.7bbfeap-3, INEXACT)
T(RN,   -0x1.9b486533eaec2p-1,    -0x1.0953a75161cbp+0,  -0x1.922a78p-5, INEXACT)
T(RN,   -0x1.99de6b5e38edcp-1,   -0x1.07dd51f678daep+0,  -0x1.c452fap-2, INEXACT)
T(RN,    -0x1.9875b01d1075p-1,   -0x1.066a63470cc8dp+0,  -0x1.097cccp-2, INEXACT)
T(RN,   -0x1.970e32580e6c5p-1,   -0x1.04face961dacfp+0,  -0x1.e2c5c6p-2, INEXACT)
T(RN,   -0x1.95a7f0f7c683fp-1,   -0x1.038e87778815dp+0,   0x1.e12e92p-4, INEXACT)
T(RN,   -0x1.9442eae5c258ap-1,   -0x1.022581be660d2p+0,  -0x1.28a594p-4, INEXACT)
T(RN,   -0x1.92df1f0c809b9p-1,   -0x1.00bfb17b7c813p+0,  -0x1.4cf708p-4, INEXACT)
T(RN,   -0x1.917c8c57743a2p-1,   -0x1.feba15f76949ep-1,  -0x1.64765ap-3, INEXACT)
T(RN,   -0x1.901b31b303878p-1,   -0x1.fbfb058d41bbdp-1,    0x1.bfce2p-2, INEXACT)
T(RN,   -0x1.8ebb0e0c8765ep-1,   -0x1.f9421b3a19b1ap-1,  -0x1.ed1da8p-2, INEXACT)
T(RN,   -0x1.8d5c20524a718p-1,   -0x1.f68f40ef30c9dp-1,   0x1.03ecc6p-2, INEXACT)
T(RN,   -0x1.8bfe6773882bbp-1,   -0x1.f3e2610ab96e9p-1,   0x1.e041e4p-2, INEXACT)
T(RN,   -0x1.8aa1e2606c26bp-1,   -0x1.f13b665537779p-1,  -0x1.a93b1ep-2, INEXACT)
T(RN,   -0x1.8946900a1132ap-1,   -0x1.ee9a3bfef23b6p-1,   0x1.64d3fep-2, INEXACT)
T(RN,   -0x1.87ec6f62808acp-1,   -0x1.ebfecd9d79688p-1,  -0x1.226554p-2, INEXACT)
T(RN,   -0x1.86937f5cb103dp-1,   -0x1.e96907293c056p-1,  -0x1.7d3694p-3, INEXACT)
T(RN,   -0x1.853bbeec863adp-1,    -0x1.e6d8d4fb30fep-1,   -0x1.386eap-2, INEXACT)
T(RN,   -0x1.83e52d06cfc49p-1,   -0x1.e44e23ca90a99p-1,  -0x1.653f7ap-3, INEXACT)
T(RN,   -0x1.828fc8a1485e1p-1,   -0x1.e1c8e0aa9eba6p-1,  -0x1.8f65a4p-3, INEXACT)
T(RN,   -0x1.813b90b2951dbp-1,   -0x1.df48f908840dep-1,   0x1.a5619ep-2, INEXACT)
T(RN,   -0x1.7fe8843244a49p-1,   -0x1.dcce5aa937d7bp-1,   0x1.806f42p-2, INEXACT)
T(RN,   -0x1.7e96a218ce517p-1,   -0x1.da58f3a777a9fp-1,   0x1.572f6ap-3, INEXACT)
T(RN,   -0x1.7d45e95f91739p-1,    -0x1.d7e8b271cddep-1,  -0x1.5fa8cep-2, INEXACT)
T(RN,   -0x1.7bf65900d47ebp-1,   -0x1.d57d85c8a5e8ep-1,  -0x1.345462p-2, INEXACT)
T(RN,   -0x1.7aa7eff7c43f8p-1,   -0x1.d3175cbc6e287p-1,  -0x1.dc672ap-2, INEXACT)
T(RN,   -0x1.795aad4073112p-1,   -0x1.d0b626abc6bc4p-1,   0x1.3e77b8p-2, INEXACT)
T(RN,   -0x1.780e8fd7d812ep-1,   -0x1.ce59d341bcff8p-1,   0x1.2834dap-2, INEXACT)
T(RN,   -0x1.76c396bbce5efp-1,   -0x1.cc025274133e3p-1,  -0x1.73be2cp-2, INEXACT)
T(RN,   -0x1.7579c0eb1441ep-1,   -0x1.c9af94819443ep-1,   0x1.8e601ap-3, INEXACT)
T(RN,   -0x1.74310d654a726p-1,   -0x1.c76189f072642p-1,    0x1.ea562p-2, INEXACT)
T(RN,   -0x1.72e97b2af34a8p-1,   -0x1.c518238cb1a28p-1,   0x1.ecb6bap-2, INEXACT)
T(RN,   -0x1.71a3093d72006p-1,   -0x1.c2d352669c9f3p-1,   0x1.3dfb04p-2, INEXACT)
T(RN,    -0x1.705db69f09e1p-1,   -0x1.c09307d143f78p-1,  -0x1.b90ccap-5, INEXACT)
T(RN,   -0x1.6f198252dd8a7p-1,   -0x1.be57356107c33p-1,   0x1.968c08p-2, INEXACT)
T(RN,   -0x1.6dd66b5cee27dp-1,   -0x1.bc1fccea2ae41p-1,  -0x1.462b84p-2, INEXACT)
T(RN,   -0x1.6c9470c21aacep-1,   -0x1.b9ecc07f6fd67p-1,  -0x1.fb6ddcp-5, INEXACT)
T(RN,   -0x1.6b5391881f136p-1,   -0x1.b7be0270bebe2p-1,  -0x1.48ca9ap-2, INEXACT)
T(RN,   -0x1.6a13ccb59397fp-1,   -0x1.b5938549d462ep-1,  -0x1.e8dbf2p-2, INEXACT)
T(RN,   -0x1.68d52151ebf8dp-1,   -0x1.b36d3bd0f9dcep-1,   0x1.6b4ffcp-2, INEXACT)
T(RN,   -0x1.67978e6576b44p-1,   -0x1.b14b1905c4aa8p-1,   0x1.75048ap-2, INEXACT)
T(RN,   -0x1.665b12f95c483p-1,   -0x1.af2d101fdef17p-1,   0x1.8cd54cp-2, INEXACT)
T(RN,   -0x1.651fae179e723p-1,   -0x1.ad13148dd7ac6p-1,    0x1.b5d84p-2, INEXACT)
T(RN,   -0x1.63e55ecb1770ap-1,   -0x1.aafd19f3fa8a4p-1,    -0x1.62e1p-2, INEXACT)
T(RN,   -0x1.62ac241f79439p-1,   -0x1.a8eb142b2f427p-1,   0x1.5b9b7cp-2, INEXACT)
T(RN,   -0x1.6173fd214cef6p-1,   -0x1.a6dcf73fe02a6p-1,   0x1.5c5bdcp-3, INEXACT)
T(RN,   -0x1.603ce8ddf1bf5p-1,   -0x1.a4d2b770e7d1cp-1,  -0x1.b94fd8p-2, INEXACT)
T(RN,   -0x1.5f06e6639c88ep-1,   -0x1.a2cc492e8573fp-1,  -0x1.a32532p-3, INEXACT)
T(RN,   -0x1.5dd1f4c156effp-1,   -0x1.a0c9a119580b8p-1,   -0x1.be286p-2, INEXACT)
T(RN,   -0x1.5c9e1306feab5p-1,   -0x1.9ecab4015fd5bp-1,   0x1.b182a2p-5, INEXACT)
T(RN,   -0x1.5b6b404544ca5p-1,   -0x1.9ccf76e50618bp-1,    0x1.880fbp-3, INEXACT)
T(RN,   -0x1.5a397b8dacfacp-1,   -0x1.9ad7def02afcdp-1,  -0x1.43ded8p-3, INEXACT)
T(RN,   -0x1.5908c3f28ccf4p-1,   -0x1.98e3e17b394cdp-1,   0x1.bb4fe6p-3, INEXACT)
T(RN,   -0x1.57d918870b06ep-1,   -0x1.96f3740a3ff43p-1,   0x1.44499ep-2, INEXACT)
T(RN,   -0x1.56aa785f1ed4fp-1,   -0x1.95068c4c110f8p-1,   0x1.04a32ap-2, INEXACT)
T(RN,   -0x1.557ce28f8f294p-1,   -0x1.931d20196667bp-1,   0x1.4271bap-3, INEXACT)
T(RN,   -0x1.5450562df1f9dp-1,   -0x1.913725740b32dp-1,    0x1.6b6d9p-4, INEXACT)
T(RN,   -0x1.5324d250ab8c3p-1,   -0x1.8f5492860af1ep-1,  -0x1.131242p-2, INEXACT)
T(RN,     -0x1.51fa560eedcp-1,   -0x1.8d755da0e5498p-1,  -0x1.129ad4p-2, INEXACT)
T(RN,   -0x1.50d0e080b75a3p-1,   -0x1.8b997d3cc6b1fp-1,  -0x1.5d0526p-2, INEXACT)
T(RN,   -0x1.4fa870bed3507p-1,   -0x1.89c0e7f7c5daep-1,  -0x1.68dbb8p-3, INEXACT)
T(RN,   -0x1.4e8105e2d8158p-1,   -0x1.87eb949525a38p-1,   0x1.e25f58p-2, INEXACT)
T(RN,   -0x1.4d5a9f0726e66p-1,   -0x1.861979fc9b86bp-1,  -0x1.d9285ap-2, INEXACT)
T(RN,   -0x1.4c353b46eb178p-1,   -0x1.844a8f399a5a3p-1,   0x1.60d78ep-4, INEXACT)
T(RN,   -0x1.4b10d9be1962ep-1,   -0x1.827ecb7aa145fp-1,   0x1.02b9ccp-4, INEXACT)
T(RN,   -0x1.49ed79896f371p-1,    -0x1.80b626108ed4p-1,   0x1.e772c2p-3, INEXACT)
T(RN,   -0x1.48cb19c672069p-1,    -0x1.7ef0966df7fep-1,  -0x1.627d3cp-2, INEXACT)
T(RN,   -0x1.47a9b9936e975p-1,   -0x1.7d2e1426831afp-1,   0x1.6c61c6p-2, INEXACT)
T(RN,   -0x1.4689580f7853ep-1,   -0x1.7b6e96ee4696ap-1,  -0x1.80f456p-2, INEXACT)
T(RN,   -0x1.4569f45a689c3p-1,   -0x1.79b216992b53dp-1,  -0x1.0335f6p-2, INEXACT)
T(RN,   -0x1.444b8d94de177p-1,   -0x1.77f88b1a52a4bp-1,   0x1.9e6f92p-5, INEXACT)
T(RN,   -0x1.432e22e03c067p-1,   -0x1.7641ec837fbecp-1,   0x1.05a616p-2, INEXACT)
T(RN,   -0x1.4211b35ea996dp-1,    -0x1.748e33048494p-1,   0x1.cfbac4p-3, INEXACT)
T(RN,   -0x1.40f63e3311363p-1,   -0x1.72dd56eab1f93p-1,  -0x1.85e6aap-3, INEXACT)
T(RN,   -0x1.3fdbc2811fe68p-1,   -0x1.712f50a04b04bp-1,  -0x1.af5beep-5, INEXACT)
T(RN,   -0x1.3ec23f6d4492fp-1,   -0x1.6f8418abfb902p-1,  -0x1.396b8ap-2, INEXACT)
T(RN,   -0x1.3da9b41caf64fp-1,   -0x1.6ddba7b051c67p-1,  -0x1.1a85b2p-2, INEXACT)
T(RN,   -0x1.3c921fb5511a7p-1,   -0x1.6c35f66b3aaccp-1,   0x1.03b208p-2, INEXACT)
T(RN,   -0x1.3b7b815dda5c2p-1,   -0x1.6a92fdb581903p-1,  -0x1.da385cp-2, INEXACT)
T(RN,   -0x1.3a65d83dbb14bp-1,   -0x1.68f2b6825246bp-1,  -0x1.3f2794p-4, INEXACT)
T(RN,   -0x1.3951237d21c86p-1,   -0x1.675519debe30ap-1,   0x1.ceb062p-2, INEXACT)
T(RN,   -0x1.383d6244faed5p-1,   -0x1.65ba20f143e88p-1,  -0x1.c58aa6p-3, INEXACT)
T(RN,   -0x1.372a93bef0447p-1,   -0x1.6421c4f9598fbp-1,  -0x1.fe85dap-4, INEXACT)
T(RN,   -0x1.3618b71568329p-1,   -0x1.628bff4ef9a74p-1,   0x1.11218ap-2, INEXACT)
T(RN,   -0x1.3507cb73851adp-1,   -0x1.60f8c96232653p-1,  -0x1.0f5896p-3, INEXACT)
T(RN,   -0x1.33f7d00524b8cp-1,   -0x1.5f681cbab7741p-1,    0x1.dbe96p-3, INEXACT)
T(RN,   -0x1.32e8c3f6df7bcp-1,   -0x1.5dd9f2f776108p-1,  -0x1.fd17b2p-2, INEXACT)
T(RN,   -0x1.31daa67607e29p-1,   -0x1.5c4e45ce2b728p-1,   0x1.e786b8p-4, INEXACT)
T(RN,   -0x1.30cd76b0a9d79p-1,   -0x1.5ac50f0afd769p-1,   0x1.da59f8p-3, INEXACT)
T(RN,   -0x1.2fc133d58a0dbp-1,   -0x1.593e489015767p-1,   0x1.d866aap-2, INEXACT)
T(RN,   -0x1.2eb5dd14255dap-1,   -0x1.57b9ec553d44bp-1,  -0x1.7fa12ap-4, INEXACT)
T(RN,   -0x1.2dab719cb023ep-1,   -0x1.5637f4677e3d6p-1,   0x1.46a1cep-2, INEXACT)
T(RN,   -0x1.2ca1f0a0159f2p-1,   -0x1.54b85ae8c25f3p-1,   -0x1.683b2p-2, INEXACT)
T(RN,   -0x1.2b99594ff74f6p-1,   -0x1.533b1a0f775f6p-1,     0x1.15d4p-2, INEXACT)
T(RN,   -0x1.2a91aadeac55ap-1,   -0x1.51c02c2633adep-1,   0x1.3817c2p-2, INEXACT)
T(RN,   -0x1.298ae47f40d3bp-1,    -0x1.50478b8b5d5bp-1,    0x1.b7b9ep-3, INEXACT)
T(RN,   -0x1.28850565754d4p-1,   -0x1.4ed132b0d2d63p-1,   0x1.1d50eep-3, INEXACT)
T(RN,   -0x1.27800cc5be091p-1,   -0x1.4d5d1c1b95782p-1,  -0x1.5ac864p-2, INEXACT)
T(RN,   -0x1.267bf9d542725p-1,   -0x1.4beb426375cd5p-1,   0x1.0db638p-2, INEXACT)
T(RN,   -0x1.2578cbc9dc7b9p-1,   -0x1.4a7ba032c198fp-1,   0x1.d48434p-3, INEXACT)
T(RN,   -0x1.247681da18015p-1,   -0x1.490e3045f381cp-1,  -0x1.bfd298p-4, INEXACT)
T(RN,   -0x1.23751b3d322d5p-1,   -0x1.47a2ed6b64618p-1,  -0x1.827ad8p-2, INEXACT)
T(RN,   -0x1.2274972b18dacp-1,   -0x1.4639d282fe2cap-1,   0x1.56ab08p-2, INEXACT)
T(RN,   -0x1.2174f4dc69faap-1,    -0x1.44d2da7df068p-1,    0x1.b208ep-3, INEXACT)
T(RN,   -0x1.2076338a72f8dp-1,   -0x1.436e005e66235p-1,   0x1.cb5488p-2, INEXACT)
T(RN,   -0x1.1f78526f30219p-1,   -0x1.420b3f373d6fep-1,  -0x1.e5ccfcp-3, INEXACT)
T(RN,   -0x1.1e7b50c54c079p-1,   -0x1.40aa922bc049dp-1,  -0x1.65c578p-3, INEXACT)
T(RN,   -0x1.1d7f2dc81eeabp-1,   -0x1.3f4bf46f5eec8p-1,   0x1.c70eb4p-2, INEXACT)
T(RN,   -0x1.1c83e8b3ae1f3p-1,   -0x1.3def61456b889p-1,  -0x1.70c6b6p-2, INEXACT)
T(RN,   -0x1.1b8980c4ab74fp-1,   -0x1.3c94d400d752bp-1,   -0x1.7f084p-2, INEXACT)
T(RN,   -0x1.1a8ff53874a04p-1,   -0x1.3b3c4803f0e69p-1,  -0x1.3cfb88p-2, INEXACT)
T(RN,   -0x1.1997454d12a22p-1,   -0x1.39e5b8c023f1cp-1,  -0x1.03dd2ap-3, INEXACT)
T(RN,   -0x1.189f70413931bp-1,   -0x1.389121b5ba226p-1,  -0x1.b53936p-2, INEXACT)
T(RN,   -0x1.17a875544625dp-1,   -0x1.373e7e739d505p-1,   0x1.856552p-2, INEXACT)
T(RN,   -0x1.16b253c640df9p-1,   -0x1.35edca971adb6p-1,   0x1.aa20e4p-2, INEXACT)
T(RN,   -0x1.15bd0ad7d9b4ep-1,   -0x1.349f01cba8358p-1,   0x1.1a6dbep-2, INEXACT)
T(RN,   -0x1.14c899ca695bep-1,   -0x1.33521fcaa893fp-1,   0x1.64eefep-3, INEXACT)
T(RN,   -0x1.13d4ffdff056bp-1,   -0x1.3207205b33bffp-1,  -0x1.42da72p-2, INEXACT)
T(RN,   -0x1.12e23c5b165fbp-1,   -0x1.30bdff51de007p-1,  -0x1.b1eb5ep-2, INEXACT)
T(RN,   -0x1.11f04e7f29d69p-1,   -0x1.2f76b89081175p-1,   0x1.82cb68p-2, INEXACT)
T(RN,   -0x1.10ff35901f2d4p-1,   -0x1.2e314806064aap-1,   0x1.963246p-2, INEXACT)
T(RN,   -0x1.100ef0d290563p-1,   -0x1.2ceda9ae31757p-1,  -0x1.bf52acp-4, INEXACT)
T(RN,   -0x1.0f1f7f8bbc326p-1,   -0x1.2babd9916d191p-1,  -0x1.10c8eap-3, INEXACT)
T(RN,   -0x1.0e30e10186006p-1,   -0x1.2a6bd3c4976a5p-1,   0x1.3ed05ep-3, INEXACT)
T(RN,   -0x1.0d43147a74cbap-1,   -0x1.292d9468d0543p-1,  -0x1.3b48f4p-3, INEXACT)
T(RN,   -0x1.0c56193db2dbfp-1,   -0x1.27f117ab486a7p-1,   0x1.1bca0ap-2, INEXACT)
T(RN,   -0x1.0b69ee930d269p-1,   -0x1.26b659c510c94p-1,  -0x1.e8ab3cp-5, INEXACT)
T(RN,   -0x1.0a7e93c2f2be5p-1,   -0x1.257d56faebd87p-1,  -0x1.00098ap-3, INEXACT)
T(RN,   -0x1.0994081674452p-1,   -0x1.24460b9d1ef18p-1,    0x1.e9bc2p-2, INEXACT)
T(RN,   -0x1.08aa4ad7435e2p-1,   -0x1.2310740744e1dp-1,  -0x1.563a76p-2, INEXACT)
T(RN,   -0x1.07c15b4fb21f9p-1,   -0x1.21dc8ca02142ep-1,    0x1.68601p-3, INEXACT)
T(RN,   -0x1.06d938cab2859p-1,   -0x1.20aa51d974a6ep-1,  -0x1.477a08p-3, INEXACT)
T(RN,   -0x1.05f1e293d5e5fp-1,   -0x1.1f79c02fd1933p-1,   -0x1.51116p-2, INEXACT)
T(RN,   -0x1.050b57f74c634p-1,   -0x1.1e4ad42a7243ep-1,  -0x1.e2d8e2p-8, INEXACT)
T(RN,   -0x1.04259841e4617p-1,    -0x1.1d1d8a5b0f36p-1,  -0x1.7e195ap-2, INEXACT)
T(RN,   -0x1.0340a2c109fabp-1,   -0x1.1bf1df5db672bp-1,   0x1.b3a5acp-3, INEXACT)
T(RN,   -0x1.025c76c2c6742p-1,   -0x1.1ac7cfd8a3974p-1,   0x1.40ba1ep-4, INEXACT)
T(RN,   -0x1.01791395bfb3ep-1,    -0x1.199f587c1897p-1,   0x1.e90c3cp-2, INEXACT)
T(RN,   -0x1.0096788937b72p-1,   -0x1.1878760237329p-1,  -0x1.c286aep-5, INEXACT)
T(RN,   -0x1.ff6949da18117p-2,   -0x1.1753252edb202p-1,   0x1.233f64p-5, INEXACT)
T(RN,   -0x1.fda730236a708p-2,   -0x1.162f62cf74e24p-1,   0x1.6659ecp-2, INEXACT)
T(RN,   -0x1.fbe6a2908ca35p-2,   -0x1.150d2bbae5489p-1,  -0x1.708d38p-3, INEXACT)
T(RN,   -0x1.fa279fc4d8aa7p-2,   -0x1.13ec7cd15996fp-1,  -0x1.4c9c2ap-2, INEXACT)
T(RN,   -0x1.f86a2664db604p-2,   -0x1.12cd52fc28507p-1,   0x1.21e9d6p-5, INEXACT)
T(RN,   -0x1.f6ae3516536abp-2,   -0x1.11afab2daea1bp-1,  -0x1.3e89fap-6, INEXACT)
T(RN,   -0x1.f4f3ca80302e3p-2,   -0x1.109382612e67dp-1,   0x1.9f4f84p-3, INEXACT)
T(RN,   -0x1.f33ae54a90c1cp-2,   -0x1.0f78d59aacd13p-1,   0x1.94dc0ap-4, INEXACT)
T(RN,   -0x1.f183841ec2e32p-2,   -0x1.0e5fa1e6d1939p-1,  -0x1.b6b48cp-3, INEXACT)
T(RN,   -0x1.efcda5a741ecfp-2,   -0x1.0d47e45ac6b62p-1,  -0x1.bba048p-2, INEXACT)
T(RN,   -0x1.ee19488fb5cccp-2,    -0x1.0c319a1418ebp-1,   0x1.8c9f28p-2, INEXACT)
T(RN,   -0x1.ec666b84f1fb2p-2,   -0x1.0b1cc0389876fp-1,  -0x1.b82648p-2, INEXACT)
T(RN,   -0x1.eab50d34f4739p-2,   -0x1.0a0953f63aa1dp-1,   0x1.74a21ap-2, INEXACT)
T(RN,   -0x1.e9052c4ee4adbp-2,   -0x1.08f75282fbb04p-1,  -0x1.3659dcp-2, INEXACT)
T(RN,   -0x1.e756c7831297fp-2,   -0x1.07e6b91cc160fp-1,  -0x1.beac32p-6, INEXACT)
T(RN,   -0x1.e5a9dd82f5921p-2,   -0x1.06d785093decbp-1,   0x1.07417ap-3, INEXACT)
T(RN,   -0x1.e3fe6d012b696p-2,   -0x1.05c9b395d385cp-1,  -0x1.056238p-5, INEXACT)
T(RN,   -0x1.e25474b17755dp-2,   -0x1.04bd421778546p-1,  -0x1.fce18cp-2, INEXACT)
T(RN,   -0x1.e0abf348c0f76p-2,   -0x1.03b22dea9aed7p-1,   0x1.f2731ap-4, INEXACT)
T(RN,   -0x1.df04e77d1354dp-2,   -0x1.02a874730741cp-1,  -0x1.d23afep-2, INEXACT)
T(RN,   -0x1.dd5f50059bdb5p-2,   -0x1.01a0131bcc025p-1,   0x1.be21dap-7, INEXACT)
T(RN,   -0x1.dbbb2b9aa95eep-2,   -0x1.009907572078dp-1,   0x1.b2b2acp-2, INEXACT)
T(RN,   -0x1.da1878f5ab1b7p-2,   -0x1.ff269d3c95a0dp-2,   0x1.f2e6e8p-2, INEXACT)
T(RN,   -0x1.d87736d12fb76p-2,   -0x1.fd1dcce30d9bdp-2,  -0x1.3f68ccp-4, INEXACT)
T(RN,   -0x1.d6d763e8e4463p-2,   -0x1.fb1798afd9e8bp-2,   -0x1.5a3dep-9, INEXACT)
T(RN,   -0x1.d538fef9934c9p-2,   -0x1.f913fbbeb428dp-2,   0x1.259c06p-4, INEXACT)
T(RN,   -0x1.d39c06c123c55p-2,   -0x1.f712f138ae889p-2,   0x1.02a9d4p-3, INEXACT)
T(RN,   -0x1.d20079fe9826bp-2,   -0x1.f5147454047b9p-2,  -0x1.c9bd6ep-2, INEXACT)
T(RN,   -0x1.d06657720d693p-2,   -0x1.f3188053ec428p-2,  -0x1.b151eap-2, INEXACT)
T(RN,   -0x1.cecd9ddcba0eap-2,   -0x1.f11f10886935ap-2,   0x1.c3e282p-2, INEXACT)
T(RN,   -0x1.cd364c00ed2aap-2,   -0x1.ef28204e1ed13p-2,   0x1.142502p-2, INEXACT)
T(RN,   -0x1.cba060a20d6bbp-2,   -0x1.ed33ab0e247ecp-2,  -0x1.723be8p-4, INEXACT)
T(RN,   -0x1.ca0bda849824bp-2,   -0x1.eb41ac3dda187p-2,   0x1.591ff8p-2, INEXACT)
T(RN,   -0x1.c878b86e20583p-2,   -0x1.e9521f5ebd23dp-2,  -0x1.e25b56p-6, INEXACT)
T(RN,   -0x1.c6e6f9254dc3bp-2,   -0x1.e764fffe3ebe1p-2,    0x1.897ccp-2, INEXACT)
T(RN,   -0x1.c5569b71dbec2p-2,    -0x1.e57a49b59a39p-2,   0x1.43d092p-7, INEXACT)
T(RN,   -0x1.c3c79e1c992b6p-2,   -0x1.e391f829ac63cp-2,  -0x1.2098dap-2, INEXACT)
T(RN,    -0x1.c239ffef65bep-2,   -0x1.e1ac070acb7c4p-2,  -0x1.936f1cp-2, INEXACT)
T(RN,   -0x1.c0adbfb532d29p-2,   -0x1.dfc872149fc73p-2,  -0x1.37ba84p-3, INEXACT)
T(RN,   -0x1.bf22dc3a01993p-2,    -0x1.dde7350dfccap-2,   0x1.f25e56p-4, INEXACT)
T(RN,   -0x1.bd99544ae2541p-2,   -0x1.dc084bc8bb249p-2,   0x1.94b38ep-2, INEXACT)
T(RN,   -0x1.bc1126b5f3694p-2,   -0x1.da2bb22193084p-2,  -0x1.51a476p-2, INEXACT)
T(RN,   -0x1.ba8a524a6074ap-2,   -0x1.d85163fff7479p-2,  -0x1.82d8aap-4, INEXACT)
T(RN,   -0x1.b904d5d8615afp-2,   -0x1.d6795d55f0fdap-2,  -0x1.ebd48ap-6, INEXACT)
T(RN,   -0x1.b780b031395dep-2,   -0x1.d4a39a1ffbc95p-2,   0x1.d9ff74p-2, INEXACT)
T(RN,   -0x1.b5fde02736309p-2,   -0x1.d2d01664e299dp-2,  -0x1.f49b7ap-3, INEXACT)
T(RN,   -0x1.b47c648daf0d3p-2,   -0x1.d0fece359d09ap-2,  -0x1.d2175cp-3, INEXACT)
T(RN,   -0x1.b2fc3c3903cb4p-2,   -0x1.cf2fbdad2d462p-2,  -0x1.993e7ap-4, INEXACT)
T(RN,   -0x1.b17d65fe9bf6bp-2,   -0x1.cd62e0f07e802p-2,  -0x1.5880b4p-3, INEXACT)
T(RN,   -0x1.afffe0b4e5e7cp-2,   -0x1.cb98342e43e38p-2,  -0x1.fa7b58p-3, INEXACT)
T(RN,   -0x1.ae83ab3355dbfp-2,   -0x1.c9cfb39ed813bp-2,  -0x1.dbf458p-2, INEXACT)
T(RN,   -0x1.ad08c452650efp-2,   -0x1.c8095b841d293p-2,   0x1.882f54p-8, INEXACT)
T(RN,   -0x1.ab8f2aeb90d5ap-2,   -0x1.c64528295d309p-2,   0x1.930526p-3, INEXACT)
T(RN,   -0x1.aa16ddd959b8bp-2,   -0x1.c48315e32b252p-2,  -0x1.8ea27cp-3, INEXACT)
T(RN,   -0x1.a89fdbf742908p-2,   -0x1.c2c3210f44677p-2,  -0x1.23449ep-4, INEXACT)
T(RN,   -0x1.a72a2421cfa23p-2,   -0x1.c105461472ad7p-2,   0x1.792244p-2, INEXACT)
T(RN,   -0x1.a5b5b53685bc7p-2,   -0x1.bf4981626e67ep-2,   0x1.62a118p-2, INEXACT)
T(RN,   -0x1.a4428e13e9564p-2,   -0x1.bd8fcf71c19dbp-2,   0x1.ca348cp-2, INEXACT)
T(RN,   -0x1.a2d0ad997daddp-2,   -0x1.bbd82cc3ab397p-2,   -0x1.3df0ep-3, INEXACT)
T(RN,    -0x1.a16012a7c3e8p-2,   -0x1.ba2295e202c6bp-2,  -0x1.a0caaap-3, INEXACT)
T(RN,   -0x1.9ff0bc203a312p-2,   -0x1.b86f075f1c9eep-2,   0x1.5631aap-2, INEXACT)
T(RN,   -0x1.9e82a8e55ade7p-2,   -0x1.b6bd7dd5ae828p-2,   0x1.2aff66p-2, INEXACT)
T(RN,   -0x1.9d15d7da9b8fap-2,   -0x1.b50df5e8b49bep-2,  -0x1.655496p-3, INEXACT)
T(RN,   -0x1.9baa47e46c526p-2,   -0x1.b3606c4356ec5p-2,   0x1.d1eecap-2, INEXACT)
T(RN,   -0x1.9a3ff7e836c54p-2,   -0x1.b1b4dd98cf1edp-2,   0x1.743ed6p-4, INEXACT)
T(RN,   -0x1.98d6e6cc5d3cbp-2,   -0x1.b00b46a44ec0bp-2,   0x1.b1f1fcp-2, INEXACT)
T(RN,   -0x1.976f137839e79p-2,    -0x1.ae63a428e5ddp-2,  -0x1.9dcfbcp-5, INEXACT)
T(RN,   -0x1.96087cd41df57p-2,   -0x1.acbdf2f169f9ep-2,   0x1.f762d8p-5, INEXACT)
T(RN,   -0x1.94a321c950bcfp-2,   -0x1.ab1a2fd05d75bp-2,  -0x1.c0e8dep-2, INEXACT)
T(RN,   -0x1.933f01420ee35p-2,   -0x1.a978579fd7425p-2,  0x1.46688ap-10, INEXACT)
T(RN,   -0x1.91dc1a2989844p-2,   -0x1.a7d867416afd1p-2,   0x1.0328dep-3, INEXACT)
T(RN,   -0x1.907a6b6be55b1p-2,   -0x1.a63a5b9e1161cp-2,  -0x1.6059bep-7, INEXACT)
T(RN,   -0x1.8f19f3f639ebfp-2,   -0x1.a49e31a61116bp-2,   0x1.276d98p-6, INEXACT)
T(RN,   -0x1.8dbab2b690ae8p-2,   -0x1.a303e650e7d14p-2,  -0x1.39904ap-4, INEXACT)
T(RN,   -0x1.8c5ca69be438ep-2,   -0x1.a16b769d33d06p-2,    0x1.9ea86p-4, INEXACT)
T(RN,   -0x1.8affce961f6b4p-2,   -0x1.9fd4df909dabep-2,  -0x1.a6c36ep-5, INEXACT)
T(RN,   -0x1.89a429961c9c8p-2,   -0x1.9e401e37c2775p-2,   0x1.c210e6p-2, INEXACT)
T(RN,   -0x1.8849b68da4c7cp-2,   -0x1.9cad2fa61e379p-2,  -0x1.d5f394p-4, INEXACT)
T(RN,   -0x1.86f0746f6eb9ap-2,   -0x1.9b1c10f5f6a72p-2,   0x1.6caf3cp-2, INEXACT)
T(RN,   -0x1.8598622f1e3fbp-2,   -0x1.998cbf48464c4p-2,   0x1.ebfc24p-2, INEXACT)
T(RN,   -0x1.84417ec143579p-2,   -0x1.97ff37c4a7db1p-2,  -0x1.60a484p-2, INEXACT)
T(RN,   -0x1.82ebc91b595ecp-2,   -0x1.9673779941e46p-2,   0x1.5aa8e4p-2, INEXACT)
T(RN,   -0x1.81974033c6441p-2,   -0x1.94e97bfab2d18p-2,   0x1.5fc162p-3, INEXACT)
T(RN,   -0x1.8043e301d9b8ap-2,   -0x1.93614223fd27dp-2,    -0x1.f895p-2, INEXACT)
T(RN,   -0x1.7ef1b07dcc629p-2,   -0x1.91dac7567416dp-2,  -0x1.791f8ap-4, INEXACT)
T(RN,   -0x1.7da0a7a0bf0fcp-2,   -0x1.905608d9a84d3p-2,   0x1.8299fep-4, INEXACT)
T(RN,   -0x1.7c50c764b9e97p-2,   -0x1.8ed303fb5513fp-2,   0x1.563b5ep-2, INEXACT)
T(RN,   -0x1.7b020ec4aba8ep-2,   -0x1.8d51b60f4daf8p-2,  -0x1.25bcfap-3, INEXACT)
T(RN,   -0x1.79b47cbc68cc3p-2,   -0x1.8bd21c6f6b041p-2,   0x1.eb509cp-4, INEXACT)
T(RN,   -0x1.78681048aacc1p-2,   -0x1.8a54347b797d7p-2,   0x1.538d9ap-2, INEXACT)
T(RN,   -0x1.771cc8670f52bp-2,    -0x1.88d7fb992739p-2,  -0x1.ad7b62p-2, INEXACT)
T(RN,   -0x1.75d2a41617723p-2,   -0x1.875d6f33f26efp-2,     0x1.ae09p-4, INEXACT)
T(RN,   -0x1.7489a25526dd4p-2,   -0x1.85e48cbd181d9p-2,   0x1.495a64p-4, INEXACT)
T(RN,   -0x1.7341c224831f3p-2,    -0x1.846d51ab82f1p-2,  -0x1.0ba408p-2, INEXACT)
T(RN,   -0x1.71fb028552d53p-2,   -0x1.82f7bb7bba699p-2,  -0x1.9456cep-2, INEXACT)
T(RN,   -0x1.70b562799ce85p-2,   -0x1.8183c7afd23ecp-2,  -0x1.061b14p-2, INEXACT)
T(RN,   -0x1.6f70e10447c85p-2,   -0x1.801173cf59fdfp-2,   0x1.8a30dcp-2, INEXACT)
T(RN,   -0x1.6e2d7d2918a67p-2,   -0x1.7ea0bd674ce32p-2,  -0x1.748d64p-2, INEXACT)
T(RN,   -0x1.6ceb35ecb2b1dp-2,   -0x1.7d31a20a01ebep-2,  -0x1.662696p-2, INEXACT)
T(RN,   -0x1.6baa0a549653ep-2,   -0x1.7bc41f4f1c232p-2,  -0x1.f17fc4p-5, INEXACT)
T(RN,   -0x1.6a69f967206d9p-2,   -0x1.7a5832d37b246p-2,   -0x1.abbffp-3, INEXACT)
T(RN,   -0x1.692b022b89955p-2,   -0x1.78edda392bd61p-2,  -0x1.c30526p-2, INEXACT)
T(RN,   -0x1.67ed23a9e5564p-2,   -0x1.77851327595acp-2,  -0x1.e1e6c6p-2, INEXACT)
T(RN,   -0x1.66b05ceb216e6p-2,   -0x1.761ddb4a3e359p-2,  -0x1.a09348p-3, INEXACT)
T(RN,   -0x1.6574acf9050f8p-2,   -0x1.74b8305315a56p-2,   -0x1.1d9efp-2, INEXACT)
T(RN,   -0x1.643a12de301fap-2,   -0x1.73540ff80d31fp-2,   0x1.ae13a8p-2, INEXACT)
T(RN,   -0x1.63008da61a79cp-2,   -0x1.71f177f4366bep-2,   0x1.c21328p-2, INEXACT)
T(RN,   -0x1.61c81c5d13306p-2,   -0x1.7090660778df3p-2,    0x1.7b3cep-2, INEXACT)
T(RN,     -0x1.6090be103fdp-2,   -0x1.6f30d7f684369p-2,   0x1.a75768p-3, INEXACT)
T(RN,    -0x1.5f5a71cd9ba2p-2,   -0x1.6dd2cb8ac28e8p-2,  -0x1.a007e6p-4, INEXACT)
T(RN,   -0x1.5e2536a3f6f0cp-2,   -0x1.6c763e924af8bp-2,   -0x1.0fe7ep-2, INEXACT)
T(RN,   -0x1.5cf10ba2f64c7p-2,   -0x1.6b1b2edfd42e4p-2,    0x1.ab244p-2, INEXACT)
T(RN,   -0x1.5bbdefdb11cfbp-2,   -0x1.69c19a4aa76f5p-2,    0x1.620bfp-2, INEXACT)
T(RN,   -0x1.5a8be25d9465ap-2,   -0x1.68697eae93906p-2,  -0x1.a32ff6p-4, INEXACT)
T(RN,   -0x1.595ae23c9b108p-2,   -0x1.6712d9ebe034ap-2,   -0x1.a5d16p-2, INEXACT)
T(RN,   -0x1.582aee8b1430bp-2,   -0x1.65bda9e74133dp-2,  -0x1.715b1cp-2, INEXACT)
T(RN,   -0x1.56fc065cbecc4p-2,   -0x1.6469ec89ca2b4p-2,   0x1.be71d2p-2, INEXACT)
T(RN,   -0x1.55ce28c629d75p-2,   -0x1.63179fc0e239dp-2,  -0x1.767442p-2, INEXACT)
T(RN,   -0x1.54a154dcb37d9p-2,   -0x1.61c6c17e37e5cp-2,   -0x1.a5b02p-6, INEXACT)
T(RN,   -0x1.537589b6886b2p-2,   -0x1.60774fb7b52b7p-2,   0x1.5b7c1ep-4, INEXACT)
T(RN,   -0x1.524ac66aa3174p-2,   -0x1.5f29486773b53p-2,  -0x1.56e9b4p-3, INEXACT)
T(RN,   -0x1.51210a10cb0f7p-2,   -0x1.5ddca98bb13b4p-2,  -0x1.d11516p-2, INEXACT)
T(RN,   -0x1.4ff853c194422p-2,    -0x1.5c917126c40ap-2,  -0x1.2d54aep-2, INEXACT)
T(RN,   -0x1.4ed0a2965e4bap-2,   -0x1.5b479d3f0fb0dp-2,  -0x1.ee8222p-2, INEXACT)
T(RN,   -0x1.4da9f5a953c29p-2,   -0x1.59ff2bdef9d5ap-2,  -0x1.256868p-2, INEXACT)
T(RN,   -0x1.4c844c1569852p-2,   -0x1.58b81b14df2ebp-2,  -0x1.bb4fa2p-3, INEXACT)
T(RN,    -0x1.4b5fa4f65e07p-2,   -0x1.577268f308a12p-2,   0x1.e351a8p-3, INEXACT)
T(RN,   -0x1.4a3bff68b8a05p-2,   -0x1.562e138fa084bp-2,   0x1.e6c10ep-2, INEXACT)
T(RN,   -0x1.49195a89c8dc9p-2,   -0x1.54eb1904a80a9p-2,  -0x1.6099a8p-2, INEXACT)
T(RN,   -0x1.47f7b577a5ca4p-2,   -0x1.53a9776fecc78p-2,   0x1.bc1488p-4, INEXACT)
T(RN,   -0x1.46d70f512d4bap-2,   -0x1.52692cf2fe621p-2,   -0x1.add38p-2, INEXACT)
T(RN,   -0x1.45b767360367ap-2,   -0x1.512a37b32461bp-2,   0x1.de2daep-3, INEXACT)
T(RN,   -0x1.4498bc46919b6p-2,   -0x1.4fec95d95420ap-2,   -0x1.184f2p-3, INEXACT)
T(RN,   -0x1.437b0da4062c2p-2,   -0x1.4eb0459226ddfp-2,   0x1.011ab6p-5, INEXACT)
T(RN,    -0x1.425e5a70537bp-2,   -0x1.4d75450dcff29p-2,  -0x1.eeda0cp-2, INEXACT)
T(RN,   -0x1.4142a1ce2f574p-2,   -0x1.4c3b92801323ap-2,   -0x1.aff9ap-2, INEXACT)
T(RN,   -0x1.4027e2e11252dp-2,   -0x1.4b032c203b171p-2,  -0x1.6e103ap-4, INEXACT)
T(RN,   -0x1.3f0e1ccd37174p-2,    -0x1.49cc10290fe7p-2,   0x1.824694p-2, INEXACT)
T(RN,   -0x1.3df54eb799ba3p-2,    -0x1.48963cd8cdd3p-2,  -0x1.4e5d02p-2, INEXACT)
T(RN,   -0x1.3cdd77c5f7136p-2,   -0x1.4761b0711c108p-2,   0x1.92cd3ep-3, INEXACT)
T(RN,   -0x1.3bc6971ecc138p-2,   -0x1.462e693703ba3p-2,   0x1.c11d96p-2, INEXACT)
T(RN,   -0x1.3ab0abe9551a5p-2,   -0x1.44fc6572e6dacp-2,  -0x1.eaf7acp-2, INEXACT)
T(RN,   -0x1.399bb54d8d4ebp-2,   -0x1.43cba37077965p-2,   0x1.f34932p-3, INEXACT)
T(RN,   -0x1.3887b2742df6bp-2,   -0x1.429c217eaf70bp-2,  -0x1.66bdecp-2, INEXACT)
T(RN,   -0x1.3774a286adcfep-2,   -0x1.416dddefc6ae4p-2,  -0x1.5bb404p-3, INEXACT)
T(RN,   -0x1.366284af4068fp-2,   -0x1.4040d7192bd2ap-2,   0x1.6de638p-4, INEXACT)
T(RN,   -0x1.35515818d57b9p-2,   -0x1.3f150b537b39cp-2,   0x1.0f0d64p-2, INEXACT)
T(RN,   -0x1.34411bef18464p-2,   -0x1.3dea78fa76cb8p-2,   0x1.89731cp-2, INEXACT)
T(RN,    -0x1.3331cf5e6ee8p-2,   -0x1.3cc11e6cfdcb6p-2,   0x1.a1abf2p-2, INEXACT)
T(RN,   -0x1.32237193f9bb3p-2,   -0x1.3b98fa0d04c0fp-2,  -0x1.2c73c2p-2, INEXACT)
T(RN,   -0x1.311601bd92b26p-2,   -0x1.3a720a3f8d7b6p-2,   0x1.e80fc6p-2, INEXACT)
T(RN,   -0x1.30097f09ccb45p-2,   -0x1.394c4d6c9f2dcp-2,  -0x1.83a5f8p-4, INEXACT)
T(RN,   -0x1.2efde8a7f2f94p-2,   -0x1.3827c1ff3ea41p-2,   0x1.f9e556p-2, INEXACT)
T(RN,   -0x1.2df33dc808696p-2,   -0x1.370466656692fp-2,   0x1.c19556p-2, INEXACT)
T(RN,   -0x1.2ce97d9ac6fa2p-2,   -0x1.35e2390ffffcep-2,   0x1.04b4d8p-4, INEXACT)
T(RN,   -0x1.2be0a7519f0dep-2,   -0x1.34c13872dab21p-2,  -0x1.d9e6a6p-5, INEXACT)
T(RN,   -0x1.2ad8ba1eb6d32p-2,   -0x1.33a16304a5e6bp-2,  -0x1.cbae7ap-5, INEXACT)
T(RN,   -0x1.29d1b534e9a47p-2,   -0x1.3282b73ee8e0cp-2,  -0x1.4ef446p-2, INEXACT)
T(RN,   -0x1.28cb97c7c768ep-2,   -0x1.3165339dfbbcdp-2,  -0x1.7f3bf6p-2, INEXACT)
T(RN,   -0x1.27c6610b93f5ap-2,   -0x1.3048d6a1004a5p-2,  -0x1.6cd20cp-3, INEXACT)
T(RN,   -0x1.26c21035466eep-2,   -0x1.2f2d9ec9dafccp-2,   0x1.d997dcp-8, INEXACT)
T(RN,   -0x1.25bea47a88aa9p-2,   -0x1.2e138a9d2bf46p-2,   0x1.04a2d8p-3, INEXACT)
T(RN,   -0x1.24bc1d11b6931p-2,    -0x1.2cfa98a2481cp-2,   0x1.4cb888p-2, INEXACT)
T(RN,   -0x1.23ba7931dd8a2p-2,    -0x1.2be2c763325cp-2,   0x1.773928p-5, INEXACT)
T(RN,   -0x1.22b9b812bbcd1p-2,   -0x1.2acc156c94e31p-2,  -0x1.6dbfb4p-3, INEXACT)
T(RN,   -0x1.21b9d8ecbfd8ap-2,   -0x1.29b6814dba831p-2,   -0x1.54a5ep-3, INEXACT)
T(RN,   -0x1.20badaf907ce9p-2,   -0x1.28a209988823ap-2,   0x1.632312p-2, INEXACT)
T(RN,   -0x1.1fbcbd7160da7p-2,   -0x1.278eace17647bp-2,   0x1.8626f6p-4, INEXACT)
T(RN,   -0x1.1ebf7f904697dp-2,   -0x1.267c69bf8aa7ap-2,   0x1.168a36p-6, INEXACT)
T(RN,   -0x1.1dc32090e278cp-2,   -0x1.256b3ecc51df4p-2,   0x1.c41876p-2, INEXACT)
T(RN,   -0x1.1cc79faf0b2ccp-2,   -0x1.245b2aa3d92f1p-2,   -0x1.d49fep-2, INEXACT)
T(RN,   -0x1.1bccfc2744082p-2,   -0x1.234c2be4a8501p-2,   -0x1.e4dcdp-3, INEXACT)
T(RN,   -0x1.1ad33536bc6c9p-2,   -0x1.223e412fbb5c1p-2,  -0x1.5f17b2p-5, INEXACT)
T(RN,   -0x1.19da4a1b4f312p-2,   -0x1.213169287cc6bp-2,  -0x1.9a18c6p-3, INEXACT)
T(RN,   -0x1.18e23a13820b9p-2,   -0x1.2025a274bf69ep-2,  -0x1.62c71ap-3, INEXACT)
T(RN,   -0x1.17eb045e84fa2p-2,   -0x1.1f1aebbcb8a49p-2,  -0x1.624034p-7, INEXACT)
T(RN,   -0x1.16f4a83c31ad6p-2,   -0x1.1e1143aafa8a9p-2,   0x1.15c52cp-3, INEXACT)
T(RN,   -0x1.15ff24ed0af2ep-2,   -0x1.1d08a8ec6e268p-2,  -0x1.77e10ep-2, INEXACT)
T(RN,   -0x1.150a79b23c20dp-2,   -0x1.1c011a304dcd6p-2,   0x1.5659f4p-2, INEXACT)
T(RN,   -0x1.1416a5cd9880fp-2,   -0x1.1afa96281f829p-2,   0x1.94a548p-4, INEXACT)
T(RN,   -0x1.1323a8819abd3p-2,   -0x1.19f51b87af6d2p-2,   0x1.77e99ap-4, INEXACT)
T(RN,   -0x1.12318111644c9p-2,   -0x1.18f0a9050a5e4p-2,   0x1.956498p-2, INEXACT)
T(RN,   -0x1.11402ec0bcdfdp-2,   -0x1.17ed3d5878672p-2,  -0x1.7bb774p-3, INEXACT)
T(RN,   -0x1.104fb0d411cf7p-2,   -0x1.16ead73c777fap-2,   0x1.19ce0cp-3, INEXACT)
T(RN,   -0x1.0f6006907589dp-2,   -0x1.15e9756db63d4p-2,  -0x1.444f42p-4, INEXACT)
T(RN,   -0x1.0e712f3b9f023p-2,   -0x1.14e916ab0e998p-2,   0x1.e471a6p-3, INEXACT)
T(RN,   -0x1.0d832a1be91f4p-2,   -0x1.13e9b9b580c77p-2,   0x1.d2d31ap-2, INEXACT)
T(RN,   -0x1.0c95f678522b6p-2,   -0x1.12eb5d502e198p-2,   0x1.d7ebc6p-3, INEXACT)
T(RN,   -0x1.0ba993987b44dp-2,   -0x1.11ee004053f5fp-2,   0x1.3f7efep-2, INEXACT)
T(RN,   -0x1.0abe00c4a7ce2p-2,   -0x1.10f1a14d46da2p-2,    0x1.726e9p-2, INEXACT)
T(RN,   -0x1.09d33d45bcdf4p-2,   -0x1.0ff63f406d6c9p-2, -0x1.947faap-10, INEXACT)
T(RN,   -0x1.08e9486540b7dp-2,   -0x1.0efbd8e53b9e4p-2,  -0x1.704de4p-2, INEXACT)
T(RN,   -0x1.0800216d5a309p-2,   -0x1.0e026d092dd91p-2,  -0x1.6db20ap-2, INEXACT)
T(RN,   -0x1.0717c7a8d02e8p-2,   -0x1.0d09fa7bc43d9p-2,   -0x1.9c95cp-2, INEXACT)
T(RN,   -0x1.06303a630915ep-2,    -0x1.0c12800e7deep-2,  -0x1.0e3daep-2, INEXACT)
T(RN,   -0x1.054978e80a3dbp-2,   -0x1.0b1bfc94d4674p-2,   0x1.b5f7dap-3, INEXACT)
T(RN,    -0x1.046382847764p-2,   -0x1.0a266ee436e7cp-2,  -0x1.415e86p-2, INEXACT)
T(RN,   -0x1.037e568592228p-2,   -0x1.0931d5d405e34p-2,  -0x1.28d6c4p-2, INEXACT)
T(RN,   -0x1.0299f43939636p-2,   -0x1.083e303d8e843p-2,   0x1.c72d8ep-3, INEXACT)
T(RN,    -0x1.01b65aede8d7p-2,   -0x1.074b7cfc063a3p-2,   -0x1.25376p-3, INEXACT)
T(RN,   -0x1.00d389f2b869fp-2,   -0x1.0659baec86551p-2,  -0x1.631fd4p-3, INEXACT)
T(RN,   -0x1.ffe3012eb7772p-3,   -0x1.0568e8ee07ad3p-2,   0x1.e70806p-8, INEXACT)
T(RN,   -0x1.fe207c584329ap-3,   -0x1.047905e15e57cp-2,   0x1.8bc8b6p-5, INEXACT)
T(RN,   -0x1.fc5f8403e6bf5p-3,   -0x1.038a10a93567bp-2,   0x1.6c2fdap-6, INEXACT)
T(RN,   -0x1.faa016d4a93e8p-3,   -0x1.029c082a0abb2p-2,   0x1.ff0736p-2, INEXACT)
T(RN,   -0x1.f8e2336ec4cfep-3,   -0x1.01aeeb4a2ad46p-2,   0x1.1ccc3ep-3, INEXACT)
T(RN,   -0x1.f725d877a5b0bp-3,   -0x1.00c2b8f1acbf2p-2,  -0x1.9aca5ap-2, INEXACT)
T(RN,   -0x1.f56b0495e9258p-3,   -0x1.ffaee014dc031p-3,  -0x1.bd406ep-4, INEXACT)
T(RN,   -0x1.f3b1b6715c6d2p-3,   -0x1.fdda1f001d313p-3,  -0x1.467c88p-5, INEXACT)
T(RN,   -0x1.f1f9ecb2fbb58p-3,   -0x1.fc072c7fda004p-3,  -0x1.509cdcp-4, INEXACT)
T(RN,   -0x1.f043a604f1116p-3,   -0x1.fa360672448cap-3,  -0x1.ac6a88p-2, INEXACT)
T(RN,   -0x1.ee8ee112936dcp-3,   -0x1.f866aab8fc535p-3,  -0x1.0165f4p-2, INEXACT)
T(RN,   -0x1.ecdb9c886589cp-3,   -0x1.f69917390685bp-3,   0x1.e41b32p-3, INEXACT)
T(RN,   -0x1.eb29d71414eefp-3,   -0x1.f4cd49dac6726p-3,  -0x1.9764c6p-3, INEXACT)
T(RN,   -0x1.e9798f6478e98p-3,   -0x1.f3034089f6024p-3,  -0x1.6122e2p-7, INEXACT)
T(RN,   -0x1.e7cac4299182cp-3,   -0x1.f13af9359e4cbp-3,  -0x1.8ed35ep-4, INEXACT)
T(RN,   -0x1.e61d7414867c6p-3,     -0x1.ef7471d0104p-3,   0x1.5dc736p-5, INEXACT)
T(RN,   -0x1.e4719dd7a64b1p-3,   -0x1.edafa84edd5d5p-3,  -0x1.1c552ap-2, INEXACT)
T(RN,   -0x1.e2c7402665142p-3,   -0x1.ebec9aaad08abp-3,   0x1.22df04p-2, INEXACT)
T(RN,   -0x1.e11e59b55baa6p-3,   -0x1.ea2b46dfe6f82p-3,   0x1.e2b9acp-2, INEXACT)
T(RN,   -0x1.df76e93a468d4p-3,   -0x1.e86baaed49196p-3,  -0x1.312cb2p-2, INEXACT)
T(RN,   -0x1.ddd0ed6c04e74p-3,   -0x1.e6adc4d543b1dp-3,  -0x1.e4ad22p-2, INEXACT)
T(RN,   -0x1.dc2c6502978e9p-3,   -0x1.e4f1929d40f56p-3,  -0x1.d9f2b4p-7, INEXACT)
T(RN,   -0x1.da894eb720066p-3,   -0x1.e337124dc1bc3p-3,  -0x1.ad0e26p-2, INEXACT)
T(RN,   -0x1.d8e7a943df805p-3,    -0x1.e17e41f256c8p-3,  -0x1.c9736ap-2, INEXACT)
T(RN,   -0x1.d747736435df4p-3,   -0x1.dfc71f999a1d5p-3,  -0x1.77dd1ep-3, INEXACT)
T(RN,   -0x1.d5a8abd4a0bbcp-3,   -0x1.de11a955286f6p-3,   0x1.157584p-5, INEXACT)
T(RN,   -0x1.d40b5152ba678p-3,   -0x1.dc5ddd399a9c7p-3,  -0x1.186714p-3, INEXACT)
T(RN,   -0x1.d26f629d38f36p-3,   -0x1.daabb95e7f3dcp-3,  -0x1.60607ap-5, INEXACT)
T(RN,    -0x1.d0d4de73ed36p-3,   -0x1.d8fb3bde54491p-3,   0x1.159d14p-2, INEXACT)
T(RN,   -0x1.cf3bc397c1d21p-3,   -0x1.d74c62d680c26p-3,  -0x1.cd0224p-2, INEXACT)
T(RN,   -0x1.cda410caba3ebp-3,   -0x1.d59f2c674e7ffp-3,  -0x1.e5e136p-2, INEXACT)
T(RN,   -0x1.cc0dc4cff1d0cp-3,   -0x1.d3f396b3e3fffp-3,   0x1.b9ff76p-2, INEXACT)
T(RN,   -0x1.ca78de6b9ac3ap-3,   -0x1.d2499fe23e4d5p-3,   0x1.c5ef6ep-3, INEXACT)
T(RN,   -0x1.c8e55c62fd446p-3,   -0x1.d0a1461b2af68p-3,  -0x1.276052p-2, INEXACT)
T(RN,   -0x1.c7533d7c767d4p-3,   -0x1.cefa878a42149p-3,  -0x1.b0ddfcp-2, INEXACT)
T(RN,   -0x1.c5c2807f77a13p-3,   -0x1.cd55625de0618p-3,  -0x1.f1f79cp-3, INEXACT)
T(RN,   -0x1.c433243484f98p-3,   -0x1.cbb1d4c7215ffp-3,  -0x1.e4c50cp-4, INEXACT)
T(RN,   -0x1.c2a5276534f38p-3,   -0x1.ca0fdcf9d991bp-3,  -0x1.f92e62p-3, INEXACT)
T(RN,   -0x1.c11888dc2f2fap-3,   -0x1.c86f792c90beap-3,   0x1.efdd34p-5, INEXACT)
T(RN,   -0x1.bf8d47652b903p-3,   -0x1.c6d0a7987c49fp-3,  -0x1.b04658p-3, INEXACT)
T(RN,   -0x1.be0361ccf14a6p-3,   -0x1.c53366797997bp-3,   0x1.b9d2cep-2, INEXACT)
T(RN,   -0x1.bc7ad6e155f7ap-3,   -0x1.c397b40e0881ap-3,  -0x1.e27b2ep-2, INEXACT)
T(RN,   -0x1.baf3a5713ca6fp-3,   -0x1.c1fd8e9745d8fp-3,   0x1.39a708p-2, INEXACT)
T(RN,   -0x1.b96dcc4c94f04p-3,   -0x1.c064f458e5f95p-3,    0x1.95a0cp-3, INEXACT)
T(RN,   -0x1.b7e94a445a081p-3,   -0x1.becde3992f68ap-3,  -0x1.0a2d7cp-9, INEXACT)
T(RN,   -0x1.b6661e2a91d3cp-3,   -0x1.bd385aa0f585ap-3,   0x1.929df2p-3, INEXACT)
T(RN,   -0x1.b4e446d24bfecp-3,   -0x1.bba457bb9344bp-3,  -0x1.aab602p-4, INEXACT)
T(RN,   -0x1.b363c30fa1112p-3,   -0x1.ba11d936e5faep-3,  -0x1.6a37acp-5, INEXACT)
T(RN,   -0x1.b1e491b7b185dp-3,    -0x1.b880dd634836p-3,   0x1.b43e36p-2, INEXACT)
T(RN,   -0x1.b066b1a0a4e2dp-3,   -0x1.b6f162938ca36p-3,   0x1.431294p-2, INEXACT)
T(RN,   -0x1.aeea21a1a8d18p-3,   -0x1.b563671cf9033p-3,  -0x1.116e9cp-2, INEXACT)
T(RN,    -0x1.ad6ee092f038p-3,   -0x1.b3d6e9574129ap-3,   -0x1.dd458p-2, INEXACT)
T(RN,   -0x1.abf4ed4db252ep-3,   -0x1.b24be79c820cbp-3,   0x1.91e73ep-2, INEXACT)
T(RN,   -0x1.aa7c46ac29d0ap-3,   -0x1.b0c260493ce03p-3,  -0x1.c21986p-4, INEXACT)
T(RN,    -0x1.a904eb8993edp-3,   -0x1.af3a51bc523cfp-3,   -0x1.30763p-2, INEXACT)
T(RN,   -0x1.a78edac22f8d6p-3,   -0x1.adb3ba56fd55bp-3,   0x1.7d875cp-2, INEXACT)
T(RN,    -0x1.a61a13333c5ep-3,   -0x1.ac2e987ccf387p-3,   0x1.08d9eep-3, INEXACT)
T(RN,   -0x1.a4a693baf9f08p-3,   -0x1.aaaaea93aa1c4p-3,  -0x1.635deap-2, INEXACT)
T(RN,   -0x1.a3345b38a6d9cp-3,   -0x1.a928af03bcba4p-3,   0x1.2221aep-3, INEXACT)
T(RN,   -0x1.a1c3688c7fd21p-3,   -0x1.a7a7e4377db46p-3,   0x1.c6e30cp-2, INEXACT)
T(RN,   -0x1.a053ba97bed5cp-3,   -0x1.a628889ba7075p-3,  -0x1.840a6cp-2, INEXACT)
T(RN,   -0x1.9ee5503c9a456p-3,   -0x1.a4aa9a9f31871p-3,    0x1.fadffp-3, INEXACT)
T(RN,   -0x1.9d78285e44084p-3,   -0x1.a32e18b350697p-3,   0x1.066eeep-7, INEXACT)
T(RN,   -0x1.9c0c41e0e8af3p-3,   -0x1.a1b3014b6cda8p-3,    0x1.9b0b3p-6, INEXACT)
T(RN,   -0x1.9aa19ba9ae973p-3,   -0x1.a03952dd219c6p-3,   -0x1.a5c04p-2, INEXACT)
T(RN,   -0x1.9938349eb50e4p-3,   -0x1.9ec10be036b33p-3,  -0x1.7cd91ep-2, INEXACT)
T(RN,   -0x1.97d00ba713781p-3,   -0x1.9d4a2ace9d1b9p-3,   0x1.5b50fcp-2, INEXACT)
T(RN,   -0x1.96691faad873ap-3,   -0x1.9bd4ae246a8c4p-3,   -0x1.94df1p-2, INEXACT)
T(RN,   -0x1.95036f9309018p-3,   -0x1.9a60945fd541fp-3,  -0x1.9a56aep-7, INEXACT)
T(RN,   -0x1.939efa499fab6p-3,   -0x1.98eddc012fd76p-3,  -0x1.195268p-2, INEXACT)
T(RN,   -0x1.923bbeb98babap-3,   -0x1.977c838ae5265p-3,  -0x1.92abf8p-4, INEXACT)
T(RN,   -0x1.90d9bbceb0161p-3,   -0x1.960c898174342p-3,  -0x1.89df4ap-2, INEXACT)
T(RN,   -0x1.8f78f075e3013p-3,    -0x1.949dec6b6c28p-3,  -0x1.c6e5e6p-3, INEXACT)
T(RN,   -0x1.8e195b9cecb0bp-3,   -0x1.9330aad1684c5p-3,   0x1.d81d52p-4, INEXACT)
T(RN,     -0x1.8cbafc3286cp-3,   -0x1.91c4c33e0c193p-3,  -0x1.fa8852p-3, INEXACT)
T(RN,   -0x1.8b5dd1265b4dbp-3,    -0x1.905a343dff49p-3,   0x1.c5afccp-7, INEXACT)
T(RN,   -0x1.8a01d96904286p-3,   -0x1.8ef0fc5fe9f81p-3,   0x1.08d812p-4, INEXACT)
T(RN,   -0x1.88a713ec09fb5p-3,   -0x1.8d891a3470cc7p-3,   0x1.a2b1bap-2, INEXACT)
T(RN,   -0x1.874d7fa1e37c2p-3,   -0x1.8c228c4e31284p-3,   0x1.b8120ep-2, INEXACT)
T(RN,   -0x1.85f51b7df499cp-3,   -0x1.8abd5141bd65cp-3,   0x1.b29a24p-3, INEXACT)
T(RN,   -0x1.849de6748dab3p-3,    -0x1.895967a5991cp-3,   0x1.7b213ap-4, INEXACT)
T(RN,   -0x1.8347df7aea9f9p-3,   -0x1.87f6ce12356d8p-3,   0x1.17b02cp-3, INEXACT)
T(RN,   -0x1.81f30587322f2p-3,   -0x1.86958321ed604p-3,  -0x1.7d3df6p-2, INEXACT)
T(RN,    -0x1.809f5790750cp-3,   -0x1.85358571023dbp-3,    0x1.b47c7p-3, INEXACT)
T(RN,   -0x1.7f4cd48ead14ap-3,   -0x1.83d6d39d97fd3p-3,   0x1.ab75acp-3, INEXACT)
T(RN,   -0x1.7dfb7b7abc86cp-3,   -0x1.82796c47b1b6ap-3,  -0x1.c7b512p-3, INEXACT)
T(RN,   -0x1.7cab4b4e6d326p-3,   -0x1.811d4e112e1d5p-3,   0x1.31272cp-5, INEXACT)
T(RN,   -0x1.7b5c43046fae6p-3,   -0x1.7fc2779dc404dp-3,   -0x1.e358ap-2, INEXACT)
T(RN,   -0x1.7a0e61985a8d1p-3,   -0x1.7e68e792feecfp-3,   0x1.ed48bep-2, INEXACT)
T(RN,   -0x1.78c1a606a9924p-3,    -0x1.7d109c983b98p-3,   0x1.fda6ccp-3, INEXACT)
T(RN,   -0x1.77760f4cbce91p-3,   -0x1.7bb99556a4a76p-3,   0x1.8883f8p-2, INEXACT)
T(RN,   -0x1.762b9c68d85aep-3,   -0x1.7a63d0792f41dp-3,  -0x1.513ff4p-2, INEXACT)
T(RN,   -0x1.74e24c5a2287cp-3,    -0x1.790f4cac97c2p-3,  -0x1.76cfc8p-3, INEXACT)
T(RN,   -0x1.739a1e20a41dcp-3,   -0x1.77bc089f5e6c1p-3,  -0x1.72a522p-4, INEXACT)
T(RN,   -0x1.725310bd47129p-3,   -0x1.766a0301c42c3p-3,   0x1.99e7a6p-4, INEXACT)
T(RN,   -0x1.710d2331d5dd7p-3,   -0x1.75193a85c75d2p-3,    -0x1.45fap-7, INEXACT)
T(RN,   -0x1.6fc85480fab0fp-3,   -0x1.73c9addf20957p-3,   0x1.09f56ap-4, INEXACT)
T(RN,   -0x1.6e84a3ae3eb69p-3,   -0x1.727b5bc33f7dfp-3,  -0x1.93fdaep-4, INEXACT)
T(RN,   -0x1.6d420fbe094a6p-3,   -0x1.712e42e947aeep-3,  -0x1.c4c42ep-3, INEXACT)
T(RN,   -0x1.6c0097b59f376p-3,   -0x1.6fe2620a0d94fp-3,  -0x1.f18334p-3, INEXACT)
T(RN,   -0x1.6ac03a9b21f49p-3,   -0x1.6e97b7e0135dbp-3,  -0x1.25480cp-3, INEXACT)
T(RN,   -0x1.6980f7758ee2fp-3,   -0x1.6d4e432785ebbp-3,   0x1.4fc5aap-3, INEXACT)
T(RN,   -0x1.6842cd4cbe8bcp-3,   -0x1.6c06029e39d19p-3,   0x1.a951b4p-3, INEXACT)
T(RN,   -0x1.6705bb2963dfap-3,   -0x1.6abef503a8547p-3,  -0x1.5a1476p-2, INEXACT)
T(RN,   -0x1.65c9c0150b76ap-3,   -0x1.69791918ec75cp-3,   0x1.19505ep-3, INEXACT)
T(RN,   -0x1.648edb1a1ad04p-3,   -0x1.68346da0c003dp-3,    0x1.440efp-2, INEXACT)
T(RN,   -0x1.63550b43cf94dp-3,   -0x1.66f0f15f78b19p-3,   -0x1.14182p-4, INEXACT)
T(RN,   -0x1.621c4f9e3ed71p-3,   -0x1.65aea31b05351p-3,  -0x1.827bdap-3, INEXACT)
T(RN,    -0x1.60e4a7365457p-3,   -0x1.646d819aea6d8p-3,   0x1.f45f1ep-3, INEXACT)
T(RN,   -0x1.5fae1119d1c43p-3,   -0x1.632d8ba8408ecp-3,  -0x1.3cf6b6p-2, INEXACT)
T(RN,   -0x1.5e788c574e021p-3,   -0x1.61eec00db054ap-3,  -0x1.1f98dep-3, INEXACT)
T(RN,   -0x1.5d4417fe346c3p-3,   -0x1.60b11d97703cbp-3,   0x1.34b8cep-6, INEXACT)
T(RN,    -0x1.5c10b31ec41bp-3,   -0x1.5f74a31341c5fp-3,  -0x1.54b6dcp-2, INEXACT)
T(RN,   -0x1.5ade5cca0f29cp-3,   -0x1.5e394f506eb7ap-3,  -0x1.be9c4ep-3, INEXACT)
T(RN,   -0x1.59ad1411f9fccp-3,   -0x1.5cff211fc66e6p-3,   0x1.c23b0ep-4, INEXACT)
T(RN,   -0x1.587cd8093a881p-3,   -0x1.5bc617539b2f3p-3,   0x1.e9d67ap-2, INEXACT)
T(RN,   -0x1.574da7c357973p-3,   -0x1.5a8e30bfbf813p-3,   0x1.38e492p-2, INEXACT)
T(RN,   -0x1.561f8254a815ap-3,   -0x1.59576c39838dbp-3,   0x1.76cf96p-3, INEXACT)
T(RN,   -0x1.54f266d25256fp-3,   -0x1.5821c897b2857p-3,   -0x1.338dcp-3, INEXACT)
T(RN,   -0x1.53c654524b60dp-3,   -0x1.56ed44b2900d2p-3,   -0x1.540ccp-2, INEXACT)
T(RN,   -0x1.529b49eb56352p-3,   -0x1.55b9df63d5af6p-3,  -0x1.6520bap-2, INEXACT)
T(RN,   -0x1.517146b5031c5p-3,   -0x1.54879786b0544p-3,   0x1.82d638p-3, INEXACT)
T(RN,    -0x1.504849c7aef1p-3,   -0x1.53566bf7bdbf7p-3,  -0x1.e71a7ap-4, INEXACT)
T(RN,   -0x1.4f20523c826bap-3,   -0x1.52265b950a133p-3,  -0x1.d8fa2cp-5, INEXACT)
T(RN,   -0x1.4df95f2d716f9p-3,   -0x1.50f7653e0d5a7p-3,  -0x1.1f0e6cp-3, INEXACT)
T(RN,   -0x1.4cd36fb53a57cp-3,    -0x1.4fc987d3a917p-3,   0x1.de78c2p-2, INEXACT)
T(RN,   -0x1.4bae82ef6544cp-3,   -0x1.4e9cc23825d6ap-3,   0x1.54a9f6p-2, INEXACT)
T(RN,   -0x1.4a8a97f8436b6p-3,   -0x1.4d71134f30cd1p-3,   0x1.172994p-3, INEXACT)
T(RN,   -0x1.4967adecee632p-3,   -0x1.4c4679fdd9734p-3,  -0x1.a3130cp-3, INEXACT)
T(RN,   -0x1.4845c3eb47766p-3,   -0x1.4b1cf52a8f2cdp-3,   0x1.fd4e22p-3, INEXACT)
T(RN,   -0x1.4724d911f6f28p-3,   -0x1.49f483bd1ef29p-3,   0x1.c4d3d2p-3, INEXACT)
T(RN,   -0x1.4604ec806b789p-3,   -0x1.48cd249eb101dp-3,   0x1.63c4e8p-2, INEXACT)
T(RN,   -0x1.44e5fd56d94ebp-3,   -0x1.47a6d6b9c6918p-3,  -0x1.62f10cp-3, INEXACT)
T(RN,   -0x1.43c80ab639b2bp-3,   -0x1.468198fa378ccp-3,  -0x1.270b2ap-5, INEXACT)
T(RN,   -0x1.42ab13c04a2bfp-3,   -0x1.455d6a4d3051bp-3,  -0x1.4730b2p-4, INEXACT)
T(RN,   -0x1.418f17978bdefp-3,    -0x1.443a49a12f76p-3,  -0x1.667e08p-3, INEXACT)
T(RN,   -0x1.4074155f42e19p-3,   -0x1.431835e60390ep-3,  -0x1.ac52d6p-9, INEXACT)
T(RN,   -0x1.3f5a0c3b758edp-3,   -0x1.41f72e0cc908dp-3,  -0x1.008ff2p-5, INEXACT)
T(RN,   -0x1.3e40fb50ebdc2p-3,   -0x1.40d73107e7e73p-3,   0x1.58feacp-2, INEXACT)
T(RN,   -0x1.3d28e1c52eaf4p-3,   -0x1.3fb83dcb11b0fp-3,     0x1.b59ep-3, INEXACT)
T(RN,   -0x1.3c11bebe8733fp-3,   -0x1.3e9a534b3f42fp-3,   0x1.9815cap-3, INEXACT)
T(RN,   -0x1.3afb9163fe332p-3,   -0x1.3d7d707eaeb47p-3,  -0x1.014556p-2, INEXACT)
T(RN,   -0x1.39e658dd5b69ep-3,    -0x1.3c61945ce13dp-3,   0x1.e23b88p-2, INEXACT)
T(RN,   -0x1.38d2145324e1fp-3,   -0x1.3b46bdde9920cp-3,   0x1.4558c8p-2, INEXACT)
T(RN,   -0x1.37bec2ee9e49bp-3,   -0x1.3a2cebfdd79f4p-3,   0x1.43a064p-5, INEXACT)
T(RN,   -0x1.36ac63d9c84d6p-3,   -0x1.39141db5dae85p-3,  -0x1.8a214cp-4, INEXACT)
T(RN,   -0x1.359af63f5ff11p-3,   -0x1.37fc52031c154p-3,  -0x1.3b9972p-2, INEXACT)
T(RN,   -0x1.348a794addea8p-3,   -0x1.36e587e34d25ep-3,  -0x1.274908p-5, INEXACT)
T(RN,    -0x1.337aec2875fcp-3,   -0x1.35cfbe5557029p-3,   0x1.1736ecp-2, INEXACT)
T(RN,   -0x1.326c4e0516501p-3,   -0x1.34baf4595782cp-3,  -0x1.f471d2p-2, INEXACT)
T(RN,   -0x1.315e9e0e66d52p-3,   -0x1.33a728f09f771p-3,   0x1.dd1ad8p-2, INEXACT)
T(RN,   -0x1.3051db72c899ep-3,   -0x1.32945b1db0b8ap-3,   0x1.445028p-5, INEXACT)
T(RN,   -0x1.2f460561552aep-3,   -0x1.318289e43c3c2p-3,  -0x1.160706p-2, INEXACT)
T(RN,   -0x1.2e3b1b09ddef8p-3,   -0x1.3071b4492028dp-3,  -0x1.8b26a2p-5, INEXACT)
T(RN,   -0x1.2d311b9ceb88ap-3,   -0x1.2f61d95265f48p-3,   0x1.c47c0cp-2, INEXACT)
T(RN,   -0x1.2c28064bbd2f6p-3,   -0x1.2e52f80740833p-3,   0x1.b2b808p-2, INEXACT)
T(RN,   -0x1.2b1fda484813fp-3,   -0x1.2d450f700a4a3p-3,  -0x1.d64c9ap-5, INEXACT)
T(RN,   -0x1.2a1896c536bdep-3,   -0x1.2c381e9643785p-3,   0x1.71d44cp-3, INEXACT)
T(RN,   -0x1.29123af5e86c6p-3,   -0x1.2b2c24849021bp-3,  -0x1.97a9dap-2, INEXACT)
T(RN,   -0x1.280cc60e70775p-3,   -0x1.2a212046b66f3p-3,  -0x1.b2db0ep-2, INEXACT)
T(RN,   -0x1.2708374395b07p-3,    -0x1.291710e99cd2p-3,  -0x1.787b38p-2, INEXACT)
T(RN,   -0x1.26048dcad1c5bp-3,   -0x1.280df57b483b3p-3,   0x1.4b0d94p-4, INEXACT)
T(RN,   -0x1.2501c8da50a3dp-3,   -0x1.2705cd0ada572p-3,   0x1.6afdc6p-4, INEXACT)
T(RN,   -0x1.23ffe7a8efd93p-3,   -0x1.25fe96a88fcc2p-3,  -0x1.9af3c8p-2, INEXACT)
T(RN,   -0x1.22fee96e3df9cp-3,   -0x1.24f85165be7d8p-3,  -0x1.a2f4fep-3, INEXACT)
T(RN,   -0x1.21fecd627a033p-3,   -0x1.23f2fc54d3d24p-3,   0x1.f082bap-3, INEXACT)
T(RN,   -0x1.20ff92be92c19p-3,   -0x1.22ee968952ff1p-3,   0x1.6b9854p-3, INEXACT)
T(RN,   -0x1.200138bc26348p-3,   -0x1.21eb1f17d353fp-3,   0x1.bd9f84p-2, INEXACT)
T(RN,   -0x1.1f03be9580f56p-3,   -0x1.20e89515fe8e4p-3,  -0x1.b8a3c2p-2, INEXACT)
T(RN,   -0x1.1e0723859d9d2p-3,   -0x1.1fe6f79a8f2cdp-3,   0x1.6ef2dep-3, INEXACT)
T(RN,   -0x1.1d0b66c8242b8p-3,   -0x1.1ee645bd4ec95p-3,   0x1.d8cce4p-2, INEXACT)
T(RN,   -0x1.1c108799696e6p-3,   -0x1.1de67e971473ep-3,    0x1.08258p-6, INEXACT)
T(RN,   -0x1.1b1685366e698p-3,   -0x1.1ce7a141c3125p-3,   0x1.e37672p-2, INEXACT)
T(RN,   -0x1.1a1d5edcdfbf1p-3,   -0x1.1be9acd847c38p-3,  -0x1.dc5126p-2, INEXACT)
T(RN,   -0x1.192513cb1518cp-3,   -0x1.1aeca07698453p-3,  -0x1.74d258p-3, INEXACT)
T(RN,   -0x1.182da3401090ep-3,   -0x1.19f07b39b15ddp-3,  -0x1.7c5d04p-3, INEXACT)
T(RN,   -0x1.17370c7b7e1cdp-3,   -0x1.18f53c3f95498p-3,  -0x1.02ab22p-3, INEXACT)
T(RN,   -0x1.16414ebdb2f72p-3,    -0x1.17fae2a74a2ap-3,   0x1.78edcap-3, INEXACT)
T(RN,   -0x1.154c6947ad0aep-3,   -0x1.17016d90d87a8p-3,  -0x1.275b7ap-2, INEXACT)
T(RN,   -0x1.14585b5b125edp-3,   -0x1.1608dc1d4985bp-3,   0x1.ac9eb8p-3, INEXACT)
T(RN,   -0x1.1365243a30822p-3,   -0x1.15112d6ea5e0bp-3,   0x1.3b26e2p-2, INEXACT)
T(RN,   -0x1.1272c327fbf7dp-3,   -0x1.141a60a7f3e69p-3,   0x1.57b5fap-2, INEXACT)
T(RN,    -0x1.118137680fa5p-3,   -0x1.132474ed3639ep-3,  -0x1.5704ccp-2, INEXACT)
T(RN,   -0x1.1090803eac3ddp-3,    -0x1.122f69636a47p-3,  -0x1.6f94eap-3, INEXACT)
T(RN,   -0x1.0fa09cf0b7b35p-3,   -0x1.113b3d3086ca9p-3,  -0x1.7f37c2p-2, INEXACT)
T(RN,   -0x1.0eb18cc3bca29p-3,   -0x1.1047ef7b7a5afp-3,  -0x1.05c9cep-4, INEXACT)
T(RN,   -0x1.0dc34efde9c3cp-3,   -0x1.0f557f6c29f4dp-3,   0x1.9062fap-3, INEXACT)
T(RN,   -0x1.0cd5e2e61158cp-3,   -0x1.0e63ec2b6f895p-3,   0x1.99b106p-3, INEXACT)
T(RN,   -0x1.0be947c3a89e8p-3,   -0x1.0d7334e318919p-3,  -0x1.b611bep-2, INEXACT)
T(RN,   -0x1.0afd7cdec73cfp-3,    -0x1.0c8358bde4a3p-3,     0x1.3a45p-2, INEXACT)
T(RN,   -0x1.0a12818026b7ap-3,   -0x1.0b9456e784076p-3,  -0x1.c0ac72p-2, INEXACT)
T(RN,   -0x1.092854f121e05p-3,    -0x1.0aa62e8c9658p-3,  -0x1.9a2d72p-2, INEXACT)
T(RN,   -0x1.083ef67bb4485p-3,   -0x1.09b8dedaa91b4p-3,  -0x1.9dbfb2p-2, INEXACT)
T(RN,   -0x1.0756656a79b2cp-3,   -0x1.08cc670036647p-3,   0x1.e42d34p-2, INEXACT)
T(RN,   -0x1.066ea108ad884p-3,    -0x1.07e0c62ca378p-3,   0x1.ec3b16p-2, INEXACT)
T(RN,   -0x1.0587a8a22a4a5p-3,   -0x1.06f5fb903f711p-3,  -0x1.6348b8p-2, INEXACT)
T(RN,   -0x1.04a17b836906ap-3,   -0x1.060c065c41e97p-3,  -0x1.969fe6p-3, INEXACT)
T(RN,   -0x1.03bc18f980cc6p-3,   -0x1.0522e5c2c9a62p-3,   0x1.920e8cp-3, INEXACT)
T(RN,   -0x1.02d780522620ep-3,   -0x1.043a98f6db44ep-3,  -0x1.66cc4ep-3, INEXACT)
T(RN,   -0x1.01f3b0dbaa748p-3,   -0x1.03531f2c5fec3p-3,   0x1.b7f1ecp-4, INEXACT)
T(RN,   -0x1.0110a9e4fb996p-3,   -0x1.026c779823ffbp-3,   0x1.c8c71cp-5, INEXACT)
T(RN,   -0x1.002e6abda3396p-3,   -0x1.0186a16fd5d56p-3,  -0x1.22514ap-3, INEXACT)
T(RN,   -0x1.fe99e56b8c994p-4,   -0x1.00a19bea046dcp-3,  -0x1.5cc0dcp-3, INEXACT)
T(RN,   -0x1.fcd8823c49234p-4,   -0x1.ff7acc7c3c5f3p-4,   0x1.11494ep-2, INEXACT)
T(RN,   -0x1.fb18aa9030081p-4,   -0x1.fdb3ff48df48ep-4,   0x1.43a432p-2, INEXACT)
T(RN,   -0x1.f95a5d0b28abbp-4,   -0x1.fbeeceac4472bp-4,   0x1.0b10aep-2, INEXACT)
T(RN,   -0x1.f79d98524ccf4p-4,   -0x1.fa2b391a7601cp-4,  -0x1.f01f5cp-2, INEXACT)
T(RN,   -0x1.f5e25b0be7831p-4,   -0x1.f8693d0932ef5p-4,   -0x1.d8a32p-7, INEXACT)
T(RN,   -0x1.f428a3df741aep-4,   -0x1.f6a8d8efec989p-4,   0x1.148a0cp-2, INEXACT)
T(RN,   -0x1.f27071759d21cp-4,   -0x1.f4ea0b47c4514p-4,   0x1.b79112p-3, INEXACT)
T(RN,   -0x1.f0b9c2783b4e4p-4,   -0x1.f32cd28b88facp-4,   0x1.3bacd4p-2, INEXACT)
T(RN,    -0x1.ef049592547ap-4,   -0x1.f1712d37b4a26p-4,  -0x1.8f37f2p-6, INEXACT)
T(RN,   -0x1.ed50e9701a981p-4,   -0x1.efb719ca6a21fp-4,  -0x1.1ab246p-9, INEXACT)
T(RN,   -0x1.eb9ebcbeeaabdp-4,   -0x1.edfe96c372c4dp-4,  -0x1.76ef52p-3, INEXACT)
T(RN,   -0x1.e9ee0e2d4bc38p-4,   -0x1.ec47a2a43bf41p-4,   -0x1.83b81p-3, INEXACT)
T(RN,   -0x1.e83edc6aedf0ep-4,   -0x1.ea923befd4e47p-4,  -0x1.b941e2p-2, INEXACT)
T(RN,   -0x1.e6912628a9436p-4,   -0x1.e8de612aec494p-4,   0x1.73801ap-2, INEXACT)
T(RN,   -0x1.e4e4ea187cc4ep-4,   -0x1.e72c10dbce0ddp-4,   0x1.90484ep-2, INEXACT)
T(RN,   -0x1.e33a26ed8d757p-4,   -0x1.e57b498a6110bp-4,   0x1.750e42p-2, INEXACT)
T(RN,   -0x1.e190db5c2547cp-4,   -0x1.e3cc09c024e3ap-4,   0x1.a44eeep-3, INEXACT)
T(RN,   -0x1.dfe90619b220dp-4,   -0x1.e21e50082f91fp-4,  -0x1.6b0162p-3, INEXACT)
T(RN,   -0x1.de42a5dcc4d67p-4,    -0x1.e0721aef2b69p-4,   0x1.6fc9f6p-2, INEXACT)
T(RN,   -0x1.dc9db95d102e3p-4,   -0x1.dec7690354c4ep-4,  -0x1.3ee438p-2, INEXACT)
T(RN,   -0x1.dafa3f5367dfdp-4,    -0x1.dd1e38d477e3p-4,   0x1.fc292cp-3, INEXACT)
T(RN,   -0x1.d9583679bf961p-4,   -0x1.db7688f3eeb78p-4,   0x1.f2586ap-2, INEXACT)
T(RN,   -0x1.d7b79d8b29f0cp-4,   -0x1.d9d057f49ec62p-4,   -0x1.5d331p-9, INEXACT)
T(RN,   -0x1.d6187343d789ap-4,   -0x1.d82ba46af7018p-4,   0x1.7ca9dap-4, INEXACT)
T(RN,   -0x1.d47ab66115f7ap-4,   -0x1.d6886cecedac2p-4,    0x1.37e77p-2, INEXACT)
T(RN,   -0x1.d2de65a14ed3ep-4,   -0x1.d4e6b011fe3dfp-4,  -0x1.350b62p-6, INEXACT)
T(RN,   -0x1.d1437fc406c09p-4,   -0x1.d3466c73274edp-4,   0x1.d33b16p-2, INEXACT)
T(RN,   -0x1.cfaa0389dc6fcp-4,   -0x1.d1a7a0aae8848p-4,   -0x1.5d7d8p-3, INEXACT)
T(RN,   -0x1.ce11efb487a9cp-4,   -0x1.d00a4b5540826p-4,  -0x1.f62296p-3, INEXACT)
T(RN,   -0x1.cc7b4306d857ep-4,   -0x1.ce6e6b0faae16p-4,     -0x1.2f3p-2, INEXACT)
T(RN,   -0x1.cae5fc44b58c6p-4,   -0x1.ccd3fe791e278p-4,  -0x1.44da0cp-2, INEXACT)
T(RN,   -0x1.c9521a331c8cfp-4,    -0x1.cb3b043209c5p-4,   0x1.624586p-8, INEXACT)
T(RN,   -0x1.c7bf9b981fde6p-4,   -0x1.c9a37adc5415bp-4,   0x1.44eca6p-2, INEXACT)
T(RN,   -0x1.c62e7f3ae6508p-4,   -0x1.c80d611b58653p-4,   0x1.4888c8p-3, INEXACT)
T(RN,   -0x1.c49ec3e3aa0a3p-4,   -0x1.c678b593e4f63p-4,  -0x1.a8fe72p-2, INEXACT)
T(RN,   -0x1.c310685bb7985p-4,   -0x1.c4e576ec390f6p-4,  -0x1.3ed3f4p-3, INEXACT)
T(RN,   -0x1.c1836b6d6cfacp-4,   -0x1.c353a3cc03097p-4,  -0x1.15f48ap-2, INEXACT)
T(RN,   -0x1.bff7cbe438b56p-4,   -0x1.c1c33adc5e635p-4,   0x1.cb2b8ep-3, INEXACT)
T(RN,   -0x1.be6d888c98df1p-4,   -0x1.c0343ac7d1d7bp-4,  -0x1.43cb7cp-3, INEXACT)
T(RN,   -0x1.bce4a0341a329p-4,   -0x1.bea6a23a4d767p-4,  -0x1.8fc378p-4, INEXACT)
T(RN,   -0x1.bb5d11a957214p-4,   -0x1.bd1a6fe128c33p-4,   0x1.365548p-2, INEXACT)
T(RN,   -0x1.b9d6dbbbf6e54p-4,   -0x1.bb8fa26b20d59p-4,  -0x1.69e8fep-3, INEXACT)
T(RN,   -0x1.b851fd3cac942p-4,   -0x1.ba063888567c6p-4,  -0x1.03d554p-2, INEXACT)
T(RN,   -0x1.b6ce74fd3634bp-4,    -0x1.b87e30ea4c67p-4,  -0x1.6eb3f4p-3, INEXACT)
T(RN,    -0x1.b54c41d05bd3p-4,   -0x1.b6f78a43e54f1p-4,   0x1.838c4ap-3, INEXACT)
T(RN,   -0x1.b3cb6289ee95fp-4,   -0x1.b572434962266p-4,   0x1.e70504p-2, INEXACT)
T(RN,    -0x1.b24bd5fec7d7p-4,   -0x1.b3ee5ab060499p-4,  -0x1.1e8486p-2, INEXACT)
T(RN,   -0x1.b0cd9b04c8393p-4,   -0x1.b26bcf2fd7b3fp-4,   0x1.17ecdap-3, INEXACT)
T(RN,   -0x1.af50b072d6c0ap-4,   -0x1.b0ea9f8019374p-4,  -0x1.a91f16p-2, INEXACT)
T(RN,   -0x1.add51520dfed1p-4,   -0x1.af6aca5accb7cp-4,  -0x1.25e394p-2, INEXACT)
T(RN,   -0x1.ac5ac7e7d4d2bp-4,   -0x1.adec4e7aef69dp-4,  -0x1.e0bc42p-2, INEXACT)
T(RN,   -0x1.aae1c7a1aa34ap-4,   -0x1.ac6f2a9cd212fp-4,   -0x1.8f782p-2, INEXACT)
T(RN,   -0x1.a96a132957a17p-4,   -0x1.aaf35d7e174f8p-4,  -0x1.c626a4p-2, INEXACT)
T(RN,   -0x1.a7f3a95ad68ebp-4,   -0x1.a978e5ddb1d99p-4,  -0x1.65496ep-3, INEXACT)
T(RN,   -0x1.a67e891321757p-4,   -0x1.a7ffc27be2d32p-4,  -0x1.6ab0c8p-3, INEXACT)
T(RN,   -0x1.a50ab13032f13p-4,   -0x1.a687f21a3814dp-4,   0x1.3204c2p-3, INEXACT)
T(RN,   -0x1.a398209104ddep-4,   -0x1.a511737b8a7e2p-4,   0x1.d4527cp-7, INEXACT)
T(RN,   -0x1.a226d6158f76ap-4,   -0x1.a39c4563fc485p-4,  -0x1.152074p-2, INEXACT)
T(RN,   -0x1.a0b6d09ec8772p-4,   -0x1.a2286698f75e4p-4,   0x1.ba20aap-3, INEXACT)
T(RN,   -0x1.9f480f0ea23bdp-4,   -0x1.a0b5d5e12bb57p-4,  -0x1.ffe4a8p-2, INEXACT)
T(RN,   -0x1.9dda90480ae31p-4,   -0x1.9f4492048da97p-4,   0x1.9b43d4p-3, INEXACT)
T(RN,   -0x1.9c6e532eeb70ap-4,   -0x1.9dd499cc545ccp-4,  -0x1.434678p-3, INEXACT)
T(RN,   -0x1.9b0356a826f07p-4,   -0x1.9c65ec02f819fp-4,   0x1.31b5a4p-3, INEXACT)
T(RN,                  0x0p+0,                  0x0p+0,          0x0p+0, 0)
