// Code generated by 'ccgo -o vfs_netbsd_amd64.go c/vfs.c -I../testdata/sqlite-amalgamation-3380500 -lmodernc.org/sqlite/lib -pkgname vfs -nocapi -export-externs X -D SQLITE_OS_UNIX -hide=vfsFullPathname -hide=vfsOpen -hide=vfsRead -hide=vfsAccess -hide=vfsFileSize -hide=vfsClose', DO NOT EDIT.

package vfs

import (
	"math"
	"reflect"
	"sync/atomic"
	"unsafe"

	"modernc.org/libc"
	"modernc.org/libc/sys/types"
	"modernc.org/sqlite/lib"
)

var _ = math.Pi
var _ reflect.Kind
var _ atomic.Value
var _ unsafe.Pointer
var _ *libc.TLS
var _ types.Size_t

// Get the "code" values
//	$NetBSD: trap.h,v 1.1 2003/04/26 18:39:48 fvdl Exp $

//	$NetBSD: trap.h,v 1.2 2003/08/07 16:30:33 agc Exp $

// -
// Copyright (c) 1990 The Regents of the University of California.
// All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// William Jolitz.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)trap.h	5.4 (Berkeley) 5/9/91

// Trap type values
// also known in trap.c for name strings

// Trap's coming from user mode

// Flags kludged into the trap code

//	$NetBSD: mcontext.h,v 1.19 2018/02/15 15:53:56 kamil Exp $

// -
// Copyright (c) 1999 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Klaus Klein.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

//	$NetBSD: frame_regs.h,v 1.7 2015/04/26 18:49:39 mrg Exp $

// amd64 registers (and friends) ordered as in a trap/interrupt/syscall frame.
// Also the indexes into the 'general register state' (__greg_t) passed to
// userland.
// Historically they were in the same order, but the order in the frames
// has been changed to improve syscall efficiency.
//
// Notes:
// 1) gdb (amd64nbsd-tdep.c) has a lookup table that assumes the __greg_t
//    ordering.
// 2) src/lib/libc/arch/x86_64/gen/makecontext.c assumes that the first
//    6 entries in the __greg_t array match the registers used to pass
//    function arguments.
// 3) The 'struct reg' from machine/reg.h has to match __greg_t.
//    Since they are both arrays and indexed with the same tokens this
//    shouldn't be a problem, but is rather confusing.
//    This assumption is made in a lot of places!
// 4) There might be other code out there that relies on the ordering.
//
// The first entries below match the registers used for syscall arguments
// (%rcx is destroyed by the syscall instruction, the libc system call
// stubs copy %rcx to %r10).
// arg6-arg9 are copied from the user stack for system calls with more
// than 6 args (SYS_MAXSYSARGS is 8, + 2 entries for SYS___SYSCALL).

// General register state
const ( /* mcontext.h:43:1: */
	_REG_RDI    = 0  /* tf_rdi */
	_REG_RSI    = 1  /* tf_rsi */
	_REG_RDX    = 2  /* tf_rdx */
	_REG_R10    = 6  /* tf_r10 */
	_REG_R8     = 4  /* tf_r8 */
	_REG_R9     = 5  /* tf_r9 */
	_REG_RCX    = 3  /* tf_rcx */
	_REG_R11    = 7  /* tf_r11 */
	_REG_R12    = 8  /* tf_r12 */
	_REG_R13    = 9  /* tf_r13 */
	_REG_R14    = 10 /* tf_r14 */
	_REG_R15    = 11 /* tf_r15 */
	_REG_RBP    = 12 /* tf_rbp */
	_REG_RBX    = 13 /* tf_rbx */
	_REG_RAX    = 14 /* tf_rax */
	_REG_GS     = 15 /* tf_gs */
	_REG_FS     = 16 /* tf_fs */
	_REG_ES     = 17 /* tf_es */
	_REG_DS     = 18 /* tf_ds */
	_REG_TRAPNO = 19 /* Below portion defined in hardware */
	_REG_ERR    = 20 /* tf_err: Dummy inserted if not defined */
	_REG_RIP    = 21 /* tf_rip */
	_REG_CS     = 22 /* tf_cs */
	_REG_RFLAGS = 23 /* These are pushed unconditionally on the x86-64 */
	_REG_RSP    = 24 /* tf_rsp */
	_REG_SS     = 25
	_NGREG      = 26
)

//	$NetBSD: idtype.h,v 1.5 2016/04/09 17:02:51 riastradh Exp $

// -
// Copyright (c) 2016 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Christos Zoulas.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

// Using the solaris constants, some of them are not applicable to us
// Do not re-order the list, or add elements in the middle as this will
// break the ABI of the system calls using this.  We set a high private
// maximum so that new values can be added in the future without
// changing the width of the type.
const ( /* idtype.h:41:1: */
	P_MYID       = -1 // Me/my process group
	P_ALL        = 0  // All processes.
	P_PID        = 1  // A process identifier.
	P_LWPID      = 2  // An LWP identifier.
	P_PPID       = 3  // A parent process identifier.
	P_PGID       = 4  // A process group identifier.
	P_SID        = 5  // A session identifier.
	P_CID        = 6  // A scheduling class identifier.
	P_UID        = 7  // A user identifier.
	P_GID        = 8  // A group identifier.
	P_TASKID     = 9  // A task identifier.
	P_PROJID     = 10 // A project identifier.
	P_POOLID     = 11 // A pool identifier.
	P_ZONEID     = 12 // A zone identifier.
	P_CTID       = 13 // A (process) contract identifier.
	P_CPUID      = 14 // CPU identifier.
	P_PSETID     = 15 // Processor set identifier.
	_P_MAXIDTYPE = 2147483647
)

type ptrdiff_t = int64 /* <builtin>:3:26 */

type size_t = uint64 /* <builtin>:9:23 */

type wchar_t = int32 /* <builtin>:15:24 */

//	$NetBSD: featuretest.h,v 1.10 2013/04/26 18:29:06 christos Exp $

// Written by Klaus Klein <kleink@NetBSD.org>, February 2, 1998.
// Public domain.
//
// NOTE: Do not protect this header against multiple inclusion.  Doing
// so can have subtle side-effects due to header file inclusion order
// and testing of e.g. _POSIX_SOURCE vs. _POSIX_C_SOURCE.  Instead,
// protect each CPP macro that we want to supply.

// Feature-test macros are defined by several standards, and allow an
// application to specify what symbols they want the system headers to
// expose, and hence what standard they want them to conform to.
// There are two classes of feature-test macros.  The first class
// specify complete standards, and if one of these is defined, header
// files will try to conform to the relevant standard.  They are:
//
// ANSI macros:
// _ANSI_SOURCE			ANSI C89
//
// POSIX macros:
// _POSIX_SOURCE == 1		IEEE Std 1003.1 (version?)
// _POSIX_C_SOURCE == 1		IEEE Std 1003.1-1990
// _POSIX_C_SOURCE == 2		IEEE Std 1003.2-1992
// _POSIX_C_SOURCE == 199309L	IEEE Std 1003.1b-1993
// _POSIX_C_SOURCE == 199506L	ISO/IEC 9945-1:1996
// _POSIX_C_SOURCE == 200112L	IEEE Std 1003.1-2001
// _POSIX_C_SOURCE == 200809L   IEEE Std 1003.1-2008
//
// X/Open macros:
// _XOPEN_SOURCE		System Interfaces and Headers, Issue 4, Ver 2
// _XOPEN_SOURCE_EXTENDED == 1	XSH4.2 UNIX extensions
// _XOPEN_SOURCE == 500		System Interfaces and Headers, Issue 5
// _XOPEN_SOURCE == 520		Networking Services (XNS), Issue 5.2
// _XOPEN_SOURCE == 600		IEEE Std 1003.1-2001, XSI option
// _XOPEN_SOURCE == 700		IEEE Std 1003.1-2008, XSI option
//
// NetBSD macros:
// _NETBSD_SOURCE == 1		Make all NetBSD features available.
//
// If more than one of these "major" feature-test macros is defined,
// then the set of facilities provided (and namespace used) is the
// union of that specified by the relevant standards, and in case of
// conflict, the earlier standard in the above list has precedence (so
// if both _POSIX_C_SOURCE and _NETBSD_SOURCE are defined, the version
// of rename() that's used is the POSIX one).  If none of the "major"
// feature-test macros is defined, _NETBSD_SOURCE is assumed.
//
// There are also "minor" feature-test macros, which enable extra
// functionality in addition to some base standard.  They should be
// defined along with one of the "major" macros.  The "minor" macros
// are:
//
// _REENTRANT
// _ISOC99_SOURCE
// _ISOC11_SOURCE
// _LARGEFILE_SOURCE		Large File Support
//		<http://ftp.sas.com/standards/large.file/x_open.20Mar96.html>

type va_list = uintptr /* stdarg.h:53:19 */

// CAPI3REF: 64-Bit Integer Types
// KEYWORDS: sqlite_int64 sqlite_uint64
//
// Because there is no cross-platform way to specify 64-bit integer types
// SQLite includes typedefs for 64-bit signed and unsigned integers.
//
// The sqlite3_int64 and sqlite3_uint64 are the preferred type definitions.
// The sqlite_int64 and sqlite_uint64 types are supported for backwards
// compatibility only.
//
// ^The sqlite3_int64 and sqlite_int64 types can store integer values
// between -9223372036854775808 and +9223372036854775807 inclusive.  ^The
// sqlite3_uint64 and sqlite_uint64 types can store integer values
// between 0 and +18446744073709551615 inclusive.
type sqlite_int64 = int64           /* sqlite3.h:301:25 */
type sqlite_uint64 = uint64         /* sqlite3.h:302:34 */
type sqlite3_int64 = sqlite_int64   /* sqlite3.h:304:22 */
type sqlite3_uint64 = sqlite_uint64 /* sqlite3.h:305:23 */

// The type for a callback function.
// This is legacy and deprecated.  It is included for historical
// compatibility and is not documented.
type sqlite3_callback = uintptr /* sqlite3.h:361:13 */

// CAPI3REF: Result Codes
// KEYWORDS: {result code definitions}
//
// Many SQLite functions return an integer result code from the set shown
// here in order to indicate success or failure.
//
// New error codes may be added in future versions of SQLite.
//
// See also: [extended result code definitions]
// beginning-of-error-codes
// end-of-error-codes

// CAPI3REF: Extended Result Codes
// KEYWORDS: {extended result code definitions}
//
// In its default configuration, SQLite API routines return one of 30 integer
// [result codes].  However, experience has shown that many of
// these result codes are too coarse-grained.  They do not provide as
// much information about problems as programmers might like.  In an effort to
// address this, newer versions of SQLite (version 3.3.8 [dateof:3.3.8]
// and later) include
// support for additional result codes that provide more detailed information
// about errors. These [extended result codes] are enabled or disabled
// on a per database connection basis using the
// [sqlite3_extended_result_codes()] API.  Or, the extended code for
// the most recent error can be obtained using
// [sqlite3_extended_errcode()].

// CAPI3REF: Flags For File Open Operations
//
// These bit values are intended for use in the
// 3rd parameter to the [sqlite3_open_v2()] interface and
// in the 4th parameter to the [sqlite3_vfs.xOpen] method.
//
// Only those flags marked as "Ok for sqlite3_open_v2()" may be
// used as the third argument to the [sqlite3_open_v2()] interface.
// The other flags have historically been ignored by sqlite3_open_v2(),
// though future versions of SQLite might change so that an error is
// raised if any of the disallowed bits are passed into sqlite3_open_v2().
// Applications should not depend on the historical behavior.
//
// Note in particular that passing the SQLITE_OPEN_EXCLUSIVE flag into
// [sqlite3_open_v2()] does *not* cause the underlying database file
// to be opened using O_EXCL.  Passing SQLITE_OPEN_EXCLUSIVE into
// [sqlite3_open_v2()] has historically be a no-op and might become an
// error in future versions of SQLite.

// Reserved:                         0x00F00000
// Legacy compatibility:

// CAPI3REF: Device Characteristics
//
// The xDeviceCharacteristics method of the [sqlite3_io_methods]
// object returns an integer which is a vector of these
// bit values expressing I/O characteristics of the mass storage
// device that holds the file that the [sqlite3_io_methods]
// refers to.
//
// The SQLITE_IOCAP_ATOMIC property means that all writes of
// any size are atomic.  The SQLITE_IOCAP_ATOMICnnn values
// mean that writes of blocks that are nnn bytes in size and
// are aligned to an address which is an integer multiple of
// nnn are atomic.  The SQLITE_IOCAP_SAFE_APPEND value means
// that when data is appended to a file, the data is appended
// first then the size of the file is extended, never the other
// way around.  The SQLITE_IOCAP_SEQUENTIAL property means that
// information is written to disk in the same order as calls
// to xWrite().  The SQLITE_IOCAP_POWERSAFE_OVERWRITE property means that
// after reboot following a crash or power loss, the only bytes in a
// file that were written at the application level might have changed
// and that adjacent bytes, even bytes within the same sector are
// guaranteed to be unchanged.  The SQLITE_IOCAP_UNDELETABLE_WHEN_OPEN
// flag indicates that a file cannot be deleted when open.  The
// SQLITE_IOCAP_IMMUTABLE flag indicates that the file is on
// read-only media and cannot be changed even by processes with
// elevated privileges.
//
// The SQLITE_IOCAP_BATCH_ATOMIC property means that the underlying
// filesystem supports doing multiple write operations atomically when those
// write operations are bracketed by [SQLITE_FCNTL_BEGIN_ATOMIC_WRITE] and
// [SQLITE_FCNTL_COMMIT_ATOMIC_WRITE].

// CAPI3REF: File Locking Levels
//
// SQLite uses one of these integer values as the second
// argument to calls it makes to the xLock() and xUnlock() methods
// of an [sqlite3_io_methods] object.

// CAPI3REF: Synchronization Type Flags
//
// When SQLite invokes the xSync() method of an
// [sqlite3_io_methods] object it uses a combination of
// these integer values as the second argument.
//
// When the SQLITE_SYNC_DATAONLY flag is used, it means that the
// sync operation only needs to flush data to mass storage.  Inode
// information need not be flushed. If the lower four bits of the flag
// equal SQLITE_SYNC_NORMAL, that means to use normal fsync() semantics.
// If the lower four bits equal SQLITE_SYNC_FULL, that means
// to use Mac OS X style fullsync instead of fsync().
//
// Do not confuse the SQLITE_SYNC_NORMAL and SQLITE_SYNC_FULL flags
// with the [PRAGMA synchronous]=NORMAL and [PRAGMA synchronous]=FULL
// settings.  The [synchronous pragma] determines when calls to the
// xSync VFS method occur and applies uniformly across all platforms.
// The SQLITE_SYNC_NORMAL and SQLITE_SYNC_FULL flags determine how
// energetic or rigorous or forceful the sync operations are and
// only make a difference on Mac OSX for the default SQLite code.
// (Third-party VFS implementations might also make the distinction
// between SQLITE_SYNC_NORMAL and SQLITE_SYNC_FULL, but among the
// operating systems natively supported by SQLite, only Mac OSX
// cares about the difference.)

// CAPI3REF: OS Interface Open File Handle
//
// An [sqlite3_file] object represents an open file in the
// [sqlite3_vfs | OS interface layer].  Individual OS interface
// implementations will
// want to subclass this object by appending additional fields
// for their own use.  The pMethods entry is a pointer to an
// [sqlite3_io_methods] object that defines methods for performing
// I/O operations on the open file.
type sqlite3_file1 = struct{ pMethods uintptr } /* sqlite3.h:722:9 */

// CAPI3REF: Result Codes
// KEYWORDS: {result code definitions}
//
// Many SQLite functions return an integer result code from the set shown
// here in order to indicate success or failure.
//
// New error codes may be added in future versions of SQLite.
//
// See also: [extended result code definitions]
// beginning-of-error-codes
// end-of-error-codes

// CAPI3REF: Extended Result Codes
// KEYWORDS: {extended result code definitions}
//
// In its default configuration, SQLite API routines return one of 30 integer
// [result codes].  However, experience has shown that many of
// these result codes are too coarse-grained.  They do not provide as
// much information about problems as programmers might like.  In an effort to
// address this, newer versions of SQLite (version 3.3.8 [dateof:3.3.8]
// and later) include
// support for additional result codes that provide more detailed information
// about errors. These [extended result codes] are enabled or disabled
// on a per database connection basis using the
// [sqlite3_extended_result_codes()] API.  Or, the extended code for
// the most recent error can be obtained using
// [sqlite3_extended_errcode()].

// CAPI3REF: Flags For File Open Operations
//
// These bit values are intended for use in the
// 3rd parameter to the [sqlite3_open_v2()] interface and
// in the 4th parameter to the [sqlite3_vfs.xOpen] method.
//
// Only those flags marked as "Ok for sqlite3_open_v2()" may be
// used as the third argument to the [sqlite3_open_v2()] interface.
// The other flags have historically been ignored by sqlite3_open_v2(),
// though future versions of SQLite might change so that an error is
// raised if any of the disallowed bits are passed into sqlite3_open_v2().
// Applications should not depend on the historical behavior.
//
// Note in particular that passing the SQLITE_OPEN_EXCLUSIVE flag into
// [sqlite3_open_v2()] does *not* cause the underlying database file
// to be opened using O_EXCL.  Passing SQLITE_OPEN_EXCLUSIVE into
// [sqlite3_open_v2()] has historically be a no-op and might become an
// error in future versions of SQLite.

// Reserved:                         0x00F00000
// Legacy compatibility:

// CAPI3REF: Device Characteristics
//
// The xDeviceCharacteristics method of the [sqlite3_io_methods]
// object returns an integer which is a vector of these
// bit values expressing I/O characteristics of the mass storage
// device that holds the file that the [sqlite3_io_methods]
// refers to.
//
// The SQLITE_IOCAP_ATOMIC property means that all writes of
// any size are atomic.  The SQLITE_IOCAP_ATOMICnnn values
// mean that writes of blocks that are nnn bytes in size and
// are aligned to an address which is an integer multiple of
// nnn are atomic.  The SQLITE_IOCAP_SAFE_APPEND value means
// that when data is appended to a file, the data is appended
// first then the size of the file is extended, never the other
// way around.  The SQLITE_IOCAP_SEQUENTIAL property means that
// information is written to disk in the same order as calls
// to xWrite().  The SQLITE_IOCAP_POWERSAFE_OVERWRITE property means that
// after reboot following a crash or power loss, the only bytes in a
// file that were written at the application level might have changed
// and that adjacent bytes, even bytes within the same sector are
// guaranteed to be unchanged.  The SQLITE_IOCAP_UNDELETABLE_WHEN_OPEN
// flag indicates that a file cannot be deleted when open.  The
// SQLITE_IOCAP_IMMUTABLE flag indicates that the file is on
// read-only media and cannot be changed even by processes with
// elevated privileges.
//
// The SQLITE_IOCAP_BATCH_ATOMIC property means that the underlying
// filesystem supports doing multiple write operations atomically when those
// write operations are bracketed by [SQLITE_FCNTL_BEGIN_ATOMIC_WRITE] and
// [SQLITE_FCNTL_COMMIT_ATOMIC_WRITE].

// CAPI3REF: File Locking Levels
//
// SQLite uses one of these integer values as the second
// argument to calls it makes to the xLock() and xUnlock() methods
// of an [sqlite3_io_methods] object.

// CAPI3REF: Synchronization Type Flags
//
// When SQLite invokes the xSync() method of an
// [sqlite3_io_methods] object it uses a combination of
// these integer values as the second argument.
//
// When the SQLITE_SYNC_DATAONLY flag is used, it means that the
// sync operation only needs to flush data to mass storage.  Inode
// information need not be flushed. If the lower four bits of the flag
// equal SQLITE_SYNC_NORMAL, that means to use normal fsync() semantics.
// If the lower four bits equal SQLITE_SYNC_FULL, that means
// to use Mac OS X style fullsync instead of fsync().
//
// Do not confuse the SQLITE_SYNC_NORMAL and SQLITE_SYNC_FULL flags
// with the [PRAGMA synchronous]=NORMAL and [PRAGMA synchronous]=FULL
// settings.  The [synchronous pragma] determines when calls to the
// xSync VFS method occur and applies uniformly across all platforms.
// The SQLITE_SYNC_NORMAL and SQLITE_SYNC_FULL flags determine how
// energetic or rigorous or forceful the sync operations are and
// only make a difference on Mac OSX for the default SQLite code.
// (Third-party VFS implementations might also make the distinction
// between SQLITE_SYNC_NORMAL and SQLITE_SYNC_FULL, but among the
// operating systems natively supported by SQLite, only Mac OSX
// cares about the difference.)

// CAPI3REF: OS Interface Open File Handle
//
// An [sqlite3_file] object represents an open file in the
// [sqlite3_vfs | OS interface layer].  Individual OS interface
// implementations will
// want to subclass this object by appending additional fields
// for their own use.  The pMethods entry is a pointer to an
// [sqlite3_io_methods] object that defines methods for performing
// I/O operations on the open file.
type sqlite3_file = sqlite3_file1 /* sqlite3.h:722:29 */
type sqlite3_io_methods1 = struct {
	iVersion               int32
	_                      [4]byte
	xClose                 uintptr
	xRead                  uintptr
	xWrite                 uintptr
	xTruncate              uintptr
	xSync                  uintptr
	xFileSize              uintptr
	xLock                  uintptr
	xUnlock                uintptr
	xCheckReservedLock     uintptr
	xFileControl           uintptr
	xSectorSize            uintptr
	xDeviceCharacteristics uintptr
	xShmMap                uintptr
	xShmLock               uintptr
	xShmBarrier            uintptr
	xShmUnmap              uintptr
	xFetch                 uintptr
	xUnfetch               uintptr
} /* sqlite3.h:722:9 */

// CAPI3REF: OS Interface File Virtual Methods Object
//
// Every file opened by the [sqlite3_vfs.xOpen] method populates an
// [sqlite3_file] object (or, more commonly, a subclass of the
// [sqlite3_file] object) with a pointer to an instance of this object.
// This object defines the methods used to perform various operations
// against the open file represented by the [sqlite3_file] object.
//
// If the [sqlite3_vfs.xOpen] method sets the sqlite3_file.pMethods element
// to a non-NULL pointer, then the sqlite3_io_methods.xClose method
// may be invoked even if the [sqlite3_vfs.xOpen] reported that it failed.  The
// only way to prevent a call to xClose following a failed [sqlite3_vfs.xOpen]
// is for the [sqlite3_vfs.xOpen] to set the sqlite3_file.pMethods element
// to NULL.
//
// The flags argument to xSync may be one of [SQLITE_SYNC_NORMAL] or
// [SQLITE_SYNC_FULL].  The first choice is the normal fsync().
// The second choice is a Mac OS X style fullsync.  The [SQLITE_SYNC_DATAONLY]
// flag may be ORed in to indicate that only the data of the file
// and not its inode needs to be synced.
//
// The integer values to xLock() and xUnlock() are one of
// <ul>
// <li> [SQLITE_LOCK_NONE],
// <li> [SQLITE_LOCK_SHARED],
// <li> [SQLITE_LOCK_RESERVED],
// <li> [SQLITE_LOCK_PENDING], or
// <li> [SQLITE_LOCK_EXCLUSIVE].
// </ul>
// xLock() increases the lock. xUnlock() decreases the lock.
// The xCheckReservedLock() method checks whether any database connection,
// either in this process or in some other process, is holding a RESERVED,
// PENDING, or EXCLUSIVE lock on the file.  It returns true
// if such a lock exists and false otherwise.
//
// The xFileControl() method is a generic interface that allows custom
// VFS implementations to directly control an open file using the
// [sqlite3_file_control()] interface.  The second "op" argument is an
// integer opcode.  The third argument is a generic pointer intended to
// point to a structure that may contain arguments or space in which to
// write return values.  Potential uses for xFileControl() might be
// functions to enable blocking locks with timeouts, to change the
// locking strategy (for example to use dot-file locks), to inquire
// about the status of a lock, or to break stale locks.  The SQLite
// core reserves all opcodes less than 100 for its own use.
// A [file control opcodes | list of opcodes] less than 100 is available.
// Applications that define a custom xFileControl method should use opcodes
// greater than 100 to avoid conflicts.  VFS implementations should
// return [SQLITE_NOTFOUND] for file control opcodes that they do not
// recognize.
//
// The xSectorSize() method returns the sector size of the
// device that underlies the file.  The sector size is the
// minimum write that can be performed without disturbing
// other bytes in the file.  The xDeviceCharacteristics()
// method returns a bit vector describing behaviors of the
// underlying device:
//
// <ul>
// <li> [SQLITE_IOCAP_ATOMIC]
// <li> [SQLITE_IOCAP_ATOMIC512]
// <li> [SQLITE_IOCAP_ATOMIC1K]
// <li> [SQLITE_IOCAP_ATOMIC2K]
// <li> [SQLITE_IOCAP_ATOMIC4K]
// <li> [SQLITE_IOCAP_ATOMIC8K]
// <li> [SQLITE_IOCAP_ATOMIC16K]
// <li> [SQLITE_IOCAP_ATOMIC32K]
// <li> [SQLITE_IOCAP_ATOMIC64K]
// <li> [SQLITE_IOCAP_SAFE_APPEND]
// <li> [SQLITE_IOCAP_SEQUENTIAL]
// <li> [SQLITE_IOCAP_UNDELETABLE_WHEN_OPEN]
// <li> [SQLITE_IOCAP_POWERSAFE_OVERWRITE]
// <li> [SQLITE_IOCAP_IMMUTABLE]
// <li> [SQLITE_IOCAP_BATCH_ATOMIC]
// </ul>
//
// The SQLITE_IOCAP_ATOMIC property means that all writes of
// any size are atomic.  The SQLITE_IOCAP_ATOMICnnn values
// mean that writes of blocks that are nnn bytes in size and
// are aligned to an address which is an integer multiple of
// nnn are atomic.  The SQLITE_IOCAP_SAFE_APPEND value means
// that when data is appended to a file, the data is appended
// first then the size of the file is extended, never the other
// way around.  The SQLITE_IOCAP_SEQUENTIAL property means that
// information is written to disk in the same order as calls
// to xWrite().
//
// If xRead() returns SQLITE_IOERR_SHORT_READ it must also fill
// in the unread portions of the buffer with zeros.  A VFS that
// fails to zero-fill short reads might seem to work.  However,
// failure to zero-fill short reads will eventually lead to
// database corruption.
type sqlite3_io_methods = sqlite3_io_methods1 /* sqlite3.h:821:35 */

// CAPI3REF: OS Interface Object
//
// An instance of the sqlite3_vfs object defines the interface between
// the SQLite core and the underlying operating system.  The "vfs"
// in the name of the object stands for "virtual file system".  See
// the [VFS | VFS documentation] for further information.
//
// The VFS interface is sometimes extended by adding new methods onto
// the end.  Each time such an extension occurs, the iVersion field
// is incremented.  The iVersion value started out as 1 in
// SQLite [version 3.5.0] on [dateof:3.5.0], then increased to 2
// with SQLite [version 3.7.0] on [dateof:3.7.0], and then increased
// to 3 with SQLite [version 3.7.6] on [dateof:3.7.6].  Additional fields
// may be appended to the sqlite3_vfs object and the iVersion value
// may increase again in future versions of SQLite.
// Note that due to an oversight, the structure
// of the sqlite3_vfs object changed in the transition from
// SQLite [version 3.5.9] to [version 3.6.0] on [dateof:3.6.0]
// and yet the iVersion field was not increased.
//
// The szOsFile field is the size of the subclassed [sqlite3_file]
// structure used by this VFS.  mxPathname is the maximum length of
// a pathname in this VFS.
//
// Registered sqlite3_vfs objects are kept on a linked list formed by
// the pNext pointer.  The [sqlite3_vfs_register()]
// and [sqlite3_vfs_unregister()] interfaces manage this list
// in a thread-safe way.  The [sqlite3_vfs_find()] interface
// searches the list.  Neither the application code nor the VFS
// implementation should use the pNext pointer.
//
// The pNext field is the only field in the sqlite3_vfs
// structure that SQLite will ever modify.  SQLite will only access
// or modify this field while holding a particular static mutex.
// The application should never modify anything within the sqlite3_vfs
// object once the object has been registered.
//
// The zName field holds the name of the VFS module.  The name must
// be unique across all VFS modules.
//
// [[sqlite3_vfs.xOpen]]
// ^SQLite guarantees that the zFilename parameter to xOpen
// is either a NULL pointer or string obtained
// from xFullPathname() with an optional suffix added.
// ^If a suffix is added to the zFilename parameter, it will
// consist of a single "-" character followed by no more than
// 11 alphanumeric and/or "-" characters.
// ^SQLite further guarantees that
// the string will be valid and unchanged until xClose() is
// called. Because of the previous sentence,
// the [sqlite3_file] can safely store a pointer to the
// filename if it needs to remember the filename for some reason.
// If the zFilename parameter to xOpen is a NULL pointer then xOpen
// must invent its own temporary name for the file.  ^Whenever the
// xFilename parameter is NULL it will also be the case that the
// flags parameter will include [SQLITE_OPEN_DELETEONCLOSE].
//
// The flags argument to xOpen() includes all bits set in
// the flags argument to [sqlite3_open_v2()].  Or if [sqlite3_open()]
// or [sqlite3_open16()] is used, then flags includes at least
// [SQLITE_OPEN_READWRITE] | [SQLITE_OPEN_CREATE].
// If xOpen() opens a file read-only then it sets *pOutFlags to
// include [SQLITE_OPEN_READONLY].  Other bits in *pOutFlags may be set.
//
// ^(SQLite will also add one of the following flags to the xOpen()
// call, depending on the object being opened:
//
// <ul>
// <li>  [SQLITE_OPEN_MAIN_DB]
// <li>  [SQLITE_OPEN_MAIN_JOURNAL]
// <li>  [SQLITE_OPEN_TEMP_DB]
// <li>  [SQLITE_OPEN_TEMP_JOURNAL]
// <li>  [SQLITE_OPEN_TRANSIENT_DB]
// <li>  [SQLITE_OPEN_SUBJOURNAL]
// <li>  [SQLITE_OPEN_SUPER_JOURNAL]
// <li>  [SQLITE_OPEN_WAL]
// </ul>)^
//
// The file I/O implementation can use the object type flags to
// change the way it deals with files.  For example, an application
// that does not care about crash recovery or rollback might make
// the open of a journal file a no-op.  Writes to this journal would
// also be no-ops, and any attempt to read the journal would return
// SQLITE_IOERR.  Or the implementation might recognize that a database
// file will be doing page-aligned sector reads and writes in a random
// order and set up its I/O subsystem accordingly.
//
// SQLite might also add one of the following flags to the xOpen method:
//
// <ul>
// <li> [SQLITE_OPEN_DELETEONCLOSE]
// <li> [SQLITE_OPEN_EXCLUSIVE]
// </ul>
//
// The [SQLITE_OPEN_DELETEONCLOSE] flag means the file should be
// deleted when it is closed.  ^The [SQLITE_OPEN_DELETEONCLOSE]
// will be set for TEMP databases and their journals, transient
// databases, and subjournals.
//
// ^The [SQLITE_OPEN_EXCLUSIVE] flag is always used in conjunction
// with the [SQLITE_OPEN_CREATE] flag, which are both directly
// analogous to the O_EXCL and O_CREAT flags of the POSIX open()
// API.  The SQLITE_OPEN_EXCLUSIVE flag, when paired with the
// SQLITE_OPEN_CREATE, is used to indicate that file should always
// be created, and that it is an error if it already exists.
// It is <i>not</i> used to indicate the file should be opened
// for exclusive access.
//
// ^At least szOsFile bytes of memory are allocated by SQLite
// to hold the [sqlite3_file] structure passed as the third
// argument to xOpen.  The xOpen method does not have to
// allocate the structure; it should just fill it in.  Note that
// the xOpen method must set the sqlite3_file.pMethods to either
// a valid [sqlite3_io_methods] object or to NULL.  xOpen must do
// this even if the open fails.  SQLite expects that the sqlite3_file.pMethods
// element will be valid after xOpen returns regardless of the success
// or failure of the xOpen call.
//
// [[sqlite3_vfs.xAccess]]
// ^The flags argument to xAccess() may be [SQLITE_ACCESS_EXISTS]
// to test for the existence of a file, or [SQLITE_ACCESS_READWRITE] to
// test whether a file is readable and writable, or [SQLITE_ACCESS_READ]
// to test whether a file is at least readable.  The SQLITE_ACCESS_READ
// flag is never actually used and is not implemented in the built-in
// VFSes of SQLite.  The file is named by the second argument and can be a
// directory. The xAccess method returns [SQLITE_OK] on success or some
// non-zero error code if there is an I/O error or if the name of
// the file given in the second argument is illegal.  If SQLITE_OK
// is returned, then non-zero or zero is written into *pResOut to indicate
// whether or not the file is accessible.
//
// ^SQLite will always allocate at least mxPathname+1 bytes for the
// output buffer xFullPathname.  The exact size of the output buffer
// is also passed as a parameter to both  methods. If the output buffer
// is not large enough, [SQLITE_CANTOPEN] should be returned. Since this is
// handled as a fatal error by SQLite, vfs implementations should endeavor
// to prevent this by setting mxPathname to a sufficiently large value.
//
// The xRandomness(), xSleep(), xCurrentTime(), and xCurrentTimeInt64()
// interfaces are not strictly a part of the filesystem, but they are
// included in the VFS structure for completeness.
// The xRandomness() function attempts to return nBytes bytes
// of good-quality randomness into zOut.  The return value is
// the actual number of bytes of randomness obtained.
// The xSleep() method causes the calling thread to sleep for at
// least the number of microseconds given.  ^The xCurrentTime()
// method returns a Julian Day Number for the current date and time as
// a floating point value.
// ^The xCurrentTimeInt64() method returns, as an integer, the Julian
// Day Number multiplied by 86400000 (the number of milliseconds in
// a 24-hour day).
// ^SQLite will use the xCurrentTimeInt64() method to get the current
// date and time if that method is available (if iVersion is 2 or
// greater and the function pointer is not NULL) and will fall back
// to xCurrentTime() if xCurrentTimeInt64() is unavailable.
//
// ^The xSetSystemCall(), xGetSystemCall(), and xNestSystemCall() interfaces
// are not used by the SQLite core.  These optional interfaces are provided
// by some VFSes to facilitate testing of the VFS code. By overriding
// system calls with functions under its control, a test program can
// simulate faults and error conditions that would otherwise be difficult
// or impossible to induce.  The set of system calls that can be overridden
// varies from one VFS to another, and from one version of the same VFS to the
// next.  Applications that use these interfaces must be prepared for any
// or all of these interfaces to be NULL or for their behavior to change
// from one release to the next.  Applications must not attempt to access
// any of these methods if the iVersion of the VFS is less than 3.
type sqlite3_vfs1 = struct {
	iVersion          int32
	szOsFile          int32
	mxPathname        int32
	_                 [4]byte
	pNext             uintptr
	zName             uintptr
	pAppData          uintptr
	xOpen             uintptr
	xDelete           uintptr
	xAccess           uintptr
	xFullPathname     uintptr
	xDlOpen           uintptr
	xDlError          uintptr
	xDlSym            uintptr
	xDlClose          uintptr
	xRandomness       uintptr
	xSleep            uintptr
	xCurrentTime      uintptr
	xGetLastError     uintptr
	xCurrentTimeInt64 uintptr
	xSetSystemCall    uintptr
	xGetSystemCall    uintptr
	xNextSystemCall   uintptr
} /* sqlite3.h:1425:9 */

// CAPI3REF: OS Interface Object
//
// An instance of the sqlite3_vfs object defines the interface between
// the SQLite core and the underlying operating system.  The "vfs"
// in the name of the object stands for "virtual file system".  See
// the [VFS | VFS documentation] for further information.
//
// The VFS interface is sometimes extended by adding new methods onto
// the end.  Each time such an extension occurs, the iVersion field
// is incremented.  The iVersion value started out as 1 in
// SQLite [version 3.5.0] on [dateof:3.5.0], then increased to 2
// with SQLite [version 3.7.0] on [dateof:3.7.0], and then increased
// to 3 with SQLite [version 3.7.6] on [dateof:3.7.6].  Additional fields
// may be appended to the sqlite3_vfs object and the iVersion value
// may increase again in future versions of SQLite.
// Note that due to an oversight, the structure
// of the sqlite3_vfs object changed in the transition from
// SQLite [version 3.5.9] to [version 3.6.0] on [dateof:3.6.0]
// and yet the iVersion field was not increased.
//
// The szOsFile field is the size of the subclassed [sqlite3_file]
// structure used by this VFS.  mxPathname is the maximum length of
// a pathname in this VFS.
//
// Registered sqlite3_vfs objects are kept on a linked list formed by
// the pNext pointer.  The [sqlite3_vfs_register()]
// and [sqlite3_vfs_unregister()] interfaces manage this list
// in a thread-safe way.  The [sqlite3_vfs_find()] interface
// searches the list.  Neither the application code nor the VFS
// implementation should use the pNext pointer.
//
// The pNext field is the only field in the sqlite3_vfs
// structure that SQLite will ever modify.  SQLite will only access
// or modify this field while holding a particular static mutex.
// The application should never modify anything within the sqlite3_vfs
// object once the object has been registered.
//
// The zName field holds the name of the VFS module.  The name must
// be unique across all VFS modules.
//
// [[sqlite3_vfs.xOpen]]
// ^SQLite guarantees that the zFilename parameter to xOpen
// is either a NULL pointer or string obtained
// from xFullPathname() with an optional suffix added.
// ^If a suffix is added to the zFilename parameter, it will
// consist of a single "-" character followed by no more than
// 11 alphanumeric and/or "-" characters.
// ^SQLite further guarantees that
// the string will be valid and unchanged until xClose() is
// called. Because of the previous sentence,
// the [sqlite3_file] can safely store a pointer to the
// filename if it needs to remember the filename for some reason.
// If the zFilename parameter to xOpen is a NULL pointer then xOpen
// must invent its own temporary name for the file.  ^Whenever the
// xFilename parameter is NULL it will also be the case that the
// flags parameter will include [SQLITE_OPEN_DELETEONCLOSE].
//
// The flags argument to xOpen() includes all bits set in
// the flags argument to [sqlite3_open_v2()].  Or if [sqlite3_open()]
// or [sqlite3_open16()] is used, then flags includes at least
// [SQLITE_OPEN_READWRITE] | [SQLITE_OPEN_CREATE].
// If xOpen() opens a file read-only then it sets *pOutFlags to
// include [SQLITE_OPEN_READONLY].  Other bits in *pOutFlags may be set.
//
// ^(SQLite will also add one of the following flags to the xOpen()
// call, depending on the object being opened:
//
// <ul>
// <li>  [SQLITE_OPEN_MAIN_DB]
// <li>  [SQLITE_OPEN_MAIN_JOURNAL]
// <li>  [SQLITE_OPEN_TEMP_DB]
// <li>  [SQLITE_OPEN_TEMP_JOURNAL]
// <li>  [SQLITE_OPEN_TRANSIENT_DB]
// <li>  [SQLITE_OPEN_SUBJOURNAL]
// <li>  [SQLITE_OPEN_SUPER_JOURNAL]
// <li>  [SQLITE_OPEN_WAL]
// </ul>)^
//
// The file I/O implementation can use the object type flags to
// change the way it deals with files.  For example, an application
// that does not care about crash recovery or rollback might make
// the open of a journal file a no-op.  Writes to this journal would
// also be no-ops, and any attempt to read the journal would return
// SQLITE_IOERR.  Or the implementation might recognize that a database
// file will be doing page-aligned sector reads and writes in a random
// order and set up its I/O subsystem accordingly.
//
// SQLite might also add one of the following flags to the xOpen method:
//
// <ul>
// <li> [SQLITE_OPEN_DELETEONCLOSE]
// <li> [SQLITE_OPEN_EXCLUSIVE]
// </ul>
//
// The [SQLITE_OPEN_DELETEONCLOSE] flag means the file should be
// deleted when it is closed.  ^The [SQLITE_OPEN_DELETEONCLOSE]
// will be set for TEMP databases and their journals, transient
// databases, and subjournals.
//
// ^The [SQLITE_OPEN_EXCLUSIVE] flag is always used in conjunction
// with the [SQLITE_OPEN_CREATE] flag, which are both directly
// analogous to the O_EXCL and O_CREAT flags of the POSIX open()
// API.  The SQLITE_OPEN_EXCLUSIVE flag, when paired with the
// SQLITE_OPEN_CREATE, is used to indicate that file should always
// be created, and that it is an error if it already exists.
// It is <i>not</i> used to indicate the file should be opened
// for exclusive access.
//
// ^At least szOsFile bytes of memory are allocated by SQLite
// to hold the [sqlite3_file] structure passed as the third
// argument to xOpen.  The xOpen method does not have to
// allocate the structure; it should just fill it in.  Note that
// the xOpen method must set the sqlite3_file.pMethods to either
// a valid [sqlite3_io_methods] object or to NULL.  xOpen must do
// this even if the open fails.  SQLite expects that the sqlite3_file.pMethods
// element will be valid after xOpen returns regardless of the success
// or failure of the xOpen call.
//
// [[sqlite3_vfs.xAccess]]
// ^The flags argument to xAccess() may be [SQLITE_ACCESS_EXISTS]
// to test for the existence of a file, or [SQLITE_ACCESS_READWRITE] to
// test whether a file is readable and writable, or [SQLITE_ACCESS_READ]
// to test whether a file is at least readable.  The SQLITE_ACCESS_READ
// flag is never actually used and is not implemented in the built-in
// VFSes of SQLite.  The file is named by the second argument and can be a
// directory. The xAccess method returns [SQLITE_OK] on success or some
// non-zero error code if there is an I/O error or if the name of
// the file given in the second argument is illegal.  If SQLITE_OK
// is returned, then non-zero or zero is written into *pResOut to indicate
// whether or not the file is accessible.
//
// ^SQLite will always allocate at least mxPathname+1 bytes for the
// output buffer xFullPathname.  The exact size of the output buffer
// is also passed as a parameter to both  methods. If the output buffer
// is not large enough, [SQLITE_CANTOPEN] should be returned. Since this is
// handled as a fatal error by SQLite, vfs implementations should endeavor
// to prevent this by setting mxPathname to a sufficiently large value.
//
// The xRandomness(), xSleep(), xCurrentTime(), and xCurrentTimeInt64()
// interfaces are not strictly a part of the filesystem, but they are
// included in the VFS structure for completeness.
// The xRandomness() function attempts to return nBytes bytes
// of good-quality randomness into zOut.  The return value is
// the actual number of bytes of randomness obtained.
// The xSleep() method causes the calling thread to sleep for at
// least the number of microseconds given.  ^The xCurrentTime()
// method returns a Julian Day Number for the current date and time as
// a floating point value.
// ^The xCurrentTimeInt64() method returns, as an integer, the Julian
// Day Number multiplied by 86400000 (the number of milliseconds in
// a 24-hour day).
// ^SQLite will use the xCurrentTimeInt64() method to get the current
// date and time if that method is available (if iVersion is 2 or
// greater and the function pointer is not NULL) and will fall back
// to xCurrentTime() if xCurrentTimeInt64() is unavailable.
//
// ^The xSetSystemCall(), xGetSystemCall(), and xNestSystemCall() interfaces
// are not used by the SQLite core.  These optional interfaces are provided
// by some VFSes to facilitate testing of the VFS code. By overriding
// system calls with functions under its control, a test program can
// simulate faults and error conditions that would otherwise be difficult
// or impossible to induce.  The set of system calls that can be overridden
// varies from one VFS to another, and from one version of the same VFS to the
// next.  Applications that use these interfaces must be prepared for any
// or all of these interfaces to be NULL or for their behavior to change
// from one release to the next.  Applications must not attempt to access
// any of these methods if the iVersion of the VFS is less than 3.
type sqlite3_vfs = sqlite3_vfs1    /* sqlite3.h:1425:28 */
type sqlite3_syscall_ptr = uintptr /* sqlite3.h:1426:14 */

// CAPI3REF: Memory Allocation Routines
//
// An instance of this object defines the interface between SQLite
// and low-level memory allocation routines.
//
// This object is used in only one place in the SQLite interface.
// A pointer to an instance of this object is the argument to
// [sqlite3_config()] when the configuration option is
// [SQLITE_CONFIG_MALLOC] or [SQLITE_CONFIG_GETMALLOC].
// By creating an instance of this object
// and passing it to [sqlite3_config]([SQLITE_CONFIG_MALLOC])
// during configuration, an application can specify an alternative
// memory allocation subsystem for SQLite to use for all of its
// dynamic memory needs.
//
// Note that SQLite comes with several [built-in memory allocators]
// that are perfectly adequate for the overwhelming majority of applications
// and that this object is only useful to a tiny minority of applications
// with specialized memory allocation requirements.  This object is
// also used during testing of SQLite in order to specify an alternative
// memory allocator that simulates memory out-of-memory conditions in
// order to verify that SQLite recovers gracefully from such
// conditions.
//
// The xMalloc, xRealloc, and xFree methods must work like the
// malloc(), realloc() and free() functions from the standard C library.
// ^SQLite guarantees that the second argument to
// xRealloc is always a value returned by a prior call to xRoundup.
//
// xSize should return the allocated size of a memory allocation
// previously obtained from xMalloc or xRealloc.  The allocated size
// is always at least as big as the requested size but may be larger.
//
// The xRoundup method returns what would be the allocated size of
// a memory allocation given a particular requested size.  Most memory
// allocators round up memory allocations at least to the next multiple
// of 8.  Some allocators round up to a larger multiple or to a power of 2.
// Every memory allocation request coming in through [sqlite3_malloc()]
// or [sqlite3_realloc()] first calls xRoundup.  If xRoundup returns 0,
// that causes the corresponding memory allocation to fail.
//
// The xInit method initializes the memory allocator.  For example,
// it might allocate any required mutexes or initialize internal data
// structures.  The xShutdown method is invoked (indirectly) by
// [sqlite3_shutdown()] and should deallocate any resources acquired
// by xInit.  The pAppData pointer is used as the only parameter to
// xInit and xShutdown.
//
// SQLite holds the [SQLITE_MUTEX_STATIC_MAIN] mutex when it invokes
// the xInit method, so the xInit method need not be threadsafe.  The
// xShutdown method is only called from [sqlite3_shutdown()] so it does
// not need to be threadsafe either.  For all other methods, SQLite
// holds the [SQLITE_MUTEX_STATIC_MEM] mutex as long as the
// [SQLITE_CONFIG_MEMSTATUS] configuration option is turned on (which
// it is by default) and so the methods are automatically serialized.
// However, if [SQLITE_CONFIG_MEMSTATUS] is disabled, then the other
// methods must be threadsafe or else make their own arrangements for
// serialization.
//
// SQLite will never invoke xInit() more than once without an intervening
// call to xShutdown().
type sqlite3_mem_methods1 = struct {
	xMalloc   uintptr
	xFree     uintptr
	xRealloc  uintptr
	xSize     uintptr
	xRoundup  uintptr
	xInit     uintptr
	xShutdown uintptr
	pAppData  uintptr
} /* sqlite3.h:1723:9 */

// CAPI3REF: Memory Allocation Routines
//
// An instance of this object defines the interface between SQLite
// and low-level memory allocation routines.
//
// This object is used in only one place in the SQLite interface.
// A pointer to an instance of this object is the argument to
// [sqlite3_config()] when the configuration option is
// [SQLITE_CONFIG_MALLOC] or [SQLITE_CONFIG_GETMALLOC].
// By creating an instance of this object
// and passing it to [sqlite3_config]([SQLITE_CONFIG_MALLOC])
// during configuration, an application can specify an alternative
// memory allocation subsystem for SQLite to use for all of its
// dynamic memory needs.
//
// Note that SQLite comes with several [built-in memory allocators]
// that are perfectly adequate for the overwhelming majority of applications
// and that this object is only useful to a tiny minority of applications
// with specialized memory allocation requirements.  This object is
// also used during testing of SQLite in order to specify an alternative
// memory allocator that simulates memory out-of-memory conditions in
// order to verify that SQLite recovers gracefully from such
// conditions.
//
// The xMalloc, xRealloc, and xFree methods must work like the
// malloc(), realloc() and free() functions from the standard C library.
// ^SQLite guarantees that the second argument to
// xRealloc is always a value returned by a prior call to xRoundup.
//
// xSize should return the allocated size of a memory allocation
// previously obtained from xMalloc or xRealloc.  The allocated size
// is always at least as big as the requested size but may be larger.
//
// The xRoundup method returns what would be the allocated size of
// a memory allocation given a particular requested size.  Most memory
// allocators round up memory allocations at least to the next multiple
// of 8.  Some allocators round up to a larger multiple or to a power of 2.
// Every memory allocation request coming in through [sqlite3_malloc()]
// or [sqlite3_realloc()] first calls xRoundup.  If xRoundup returns 0,
// that causes the corresponding memory allocation to fail.
//
// The xInit method initializes the memory allocator.  For example,
// it might allocate any required mutexes or initialize internal data
// structures.  The xShutdown method is invoked (indirectly) by
// [sqlite3_shutdown()] and should deallocate any resources acquired
// by xInit.  The pAppData pointer is used as the only parameter to
// xInit and xShutdown.
//
// SQLite holds the [SQLITE_MUTEX_STATIC_MAIN] mutex when it invokes
// the xInit method, so the xInit method need not be threadsafe.  The
// xShutdown method is only called from [sqlite3_shutdown()] so it does
// not need to be threadsafe either.  For all other methods, SQLite
// holds the [SQLITE_MUTEX_STATIC_MEM] mutex as long as the
// [SQLITE_CONFIG_MEMSTATUS] configuration option is turned on (which
// it is by default) and so the methods are automatically serialized.
// However, if [SQLITE_CONFIG_MEMSTATUS] is disabled, then the other
// methods must be threadsafe or else make their own arrangements for
// serialization.
//
// SQLite will never invoke xInit() more than once without an intervening
// call to xShutdown().
type sqlite3_mem_methods = sqlite3_mem_methods1 /* sqlite3.h:1723:36 */

// CAPI3REF: Constants Defining Special Destructor Behavior
//
// These are special values for the destructor that is passed in as the
// final argument to routines like [sqlite3_result_blob()].  ^If the destructor
// argument is SQLITE_STATIC, it means that the content pointer is constant
// and will never change.  It does not need to be destroyed.  ^The
// SQLITE_TRANSIENT value means that the content will likely change in
// the near future and that SQLite should make its own private copy of
// the content before returning.
//
// The typedef is necessary to work around problems in certain
// C++ compilers.
type sqlite3_destructor_type = uintptr /* sqlite3.h:5752:14 */

// The interface to the virtual-table mechanism is currently considered
// to be experimental.  The interface might change in incompatible ways.
// If this is a problem for you, do not use the interface at this time.
//
// When the virtual-table mechanism stabilizes, we will declare the
// interface fixed, support it indefinitely, and remove this comment.

// Structures used by the virtual table interface
type sqlite3_vtab1 = struct {
	pModule uintptr
	nRef    int32
	_       [4]byte
	zErrMsg uintptr
} /* sqlite3.h:6937:9 */

// The interface to the virtual-table mechanism is currently considered
// to be experimental.  The interface might change in incompatible ways.
// If this is a problem for you, do not use the interface at this time.
//
// When the virtual-table mechanism stabilizes, we will declare the
// interface fixed, support it indefinitely, and remove this comment.

// Structures used by the virtual table interface
type sqlite3_vtab = sqlite3_vtab1 /* sqlite3.h:6937:29 */
type sqlite3_index_info1 = struct {
	nConstraint      int32
	_                [4]byte
	aConstraint      uintptr
	nOrderBy         int32
	_                [4]byte
	aOrderBy         uintptr
	aConstraintUsage uintptr
	idxNum           int32
	_                [4]byte
	idxStr           uintptr
	needToFreeIdxStr int32
	orderByConsumed  int32
	estimatedCost    float64
	estimatedRows    sqlite3_int64
	idxFlags         int32
	_                [4]byte
	colUsed          sqlite3_uint64
} /* sqlite3.h:6938:9 */

type sqlite3_index_info = sqlite3_index_info1       /* sqlite3.h:6938:35 */
type sqlite3_vtab_cursor1 = struct{ pVtab uintptr } /* sqlite3.h:6939:9 */

type sqlite3_vtab_cursor = sqlite3_vtab_cursor1 /* sqlite3.h:6939:36 */
type sqlite3_module1 = struct {
	iVersion      int32
	_             [4]byte
	xCreate       uintptr
	xConnect      uintptr
	xBestIndex    uintptr
	xDisconnect   uintptr
	xDestroy      uintptr
	xOpen         uintptr
	xClose        uintptr
	xFilter       uintptr
	xNext         uintptr
	xEof          uintptr
	xColumn       uintptr
	xRowid        uintptr
	xUpdate       uintptr
	xBegin        uintptr
	xSync         uintptr
	xCommit       uintptr
	xRollback     uintptr
	xFindFunction uintptr
	xRename       uintptr
	xSavepoint    uintptr
	xRelease      uintptr
	xRollbackTo   uintptr
	xShadowName   uintptr
} /* sqlite3.h:6937:9 */

type sqlite3_module = sqlite3_module1 /* sqlite3.h:6940:31 */

// CAPI3REF: Virtual Table Indexing Information
// KEYWORDS: sqlite3_index_info
//
// The sqlite3_index_info structure and its substructures is used as part
// of the [virtual table] interface to
// pass information into and receive the reply from the [xBestIndex]
// method of a [virtual table module].  The fields under **Inputs** are the
// inputs to xBestIndex and are read-only.  xBestIndex inserts its
// results into the **Outputs** fields.
//
// ^(The aConstraint[] array records WHERE clause constraints of the form:
//
// <blockquote>column OP expr</blockquote>
//
// where OP is =, &lt;, &lt;=, &gt;, or &gt;=.)^  ^(The particular operator is
// stored in aConstraint[].op using one of the
// [SQLITE_INDEX_CONSTRAINT_EQ | SQLITE_INDEX_CONSTRAINT_ values].)^
// ^(The index of the column is stored in
// aConstraint[].iColumn.)^  ^(aConstraint[].usable is TRUE if the
// expr on the right-hand side can be evaluated (and thus the constraint
// is usable) and false if it cannot.)^
//
// ^The optimizer automatically inverts terms of the form "expr OP column"
// and makes other simplifications to the WHERE clause in an attempt to
// get as many WHERE clause terms into the form shown above as possible.
// ^The aConstraint[] array only reports WHERE clause terms that are
// relevant to the particular virtual table being queried.
//
// ^Information about the ORDER BY clause is stored in aOrderBy[].
// ^Each term of aOrderBy records a column of the ORDER BY clause.
//
// The colUsed field indicates which columns of the virtual table may be
// required by the current scan. Virtual table columns are numbered from
// zero in the order in which they appear within the CREATE TABLE statement
// passed to sqlite3_declare_vtab(). For the first 63 columns (columns 0-62),
// the corresponding bit is set within the colUsed mask if the column may be
// required by SQLite. If the table has at least 64 columns and any column
// to the right of the first 63 is required, then bit 63 of colUsed is also
// set. In other words, column iCol may be required if the expression
// (colUsed & ((sqlite3_uint64)1 << (iCol>=63 ? 63 : iCol))) evaluates to
// non-zero.
//
// The [xBestIndex] method must fill aConstraintUsage[] with information
// about what parameters to pass to xFilter.  ^If argvIndex>0 then
// the right-hand side of the corresponding aConstraint[] is evaluated
// and becomes the argvIndex-th entry in argv.  ^(If aConstraintUsage[].omit
// is true, then the constraint is assumed to be fully handled by the
// virtual table and might not be checked again by the byte code.)^ ^(The
// aConstraintUsage[].omit flag is an optimization hint. When the omit flag
// is left in its default setting of false, the constraint will always be
// checked separately in byte code.  If the omit flag is change to true, then
// the constraint may or may not be checked in byte code.  In other words,
// when the omit flag is true there is no guarantee that the constraint will
// not be checked again using byte code.)^
//
// ^The idxNum and idxPtr values are recorded and passed into the
// [xFilter] method.
// ^[sqlite3_free()] is used to free idxPtr if and only if
// needToFreeIdxPtr is true.
//
// ^The orderByConsumed means that output from [xFilter]/[xNext] will occur in
// the correct order to satisfy the ORDER BY clause so that no separate
// sorting step is required.
//
// ^The estimatedCost value is an estimate of the cost of a particular
// strategy. A cost of N indicates that the cost of the strategy is similar
// to a linear scan of an SQLite table with N rows. A cost of log(N)
// indicates that the expense of the operation is similar to that of a
// binary search on a unique indexed field of an SQLite table with N rows.
//
// ^The estimatedRows value is an estimate of the number of rows that
// will be returned by the strategy.
//
// The xBestIndex method may optionally populate the idxFlags field with a
// mask of SQLITE_INDEX_SCAN_* flags. Currently there is only one such flag -
// SQLITE_INDEX_SCAN_UNIQUE. If the xBestIndex method sets this flag, SQLite
// assumes that the strategy may visit at most one row.
//
// Additionally, if xBestIndex sets the SQLITE_INDEX_SCAN_UNIQUE flag, then
// SQLite also assumes that if a call to the xUpdate() method is made as
// part of the same statement to delete or update a virtual table row and the
// implementation returns SQLITE_CONSTRAINT, then there is no need to rollback
// any database changes. In other words, if the xUpdate() returns
// SQLITE_CONSTRAINT, the database contents must be exactly as they were
// before xUpdate was called. By contrast, if SQLITE_INDEX_SCAN_UNIQUE is not
// set and xUpdate returns SQLITE_CONSTRAINT, any database changes made by
// the xUpdate method are automatically rolled back by SQLite.
//
// IMPORTANT: The estimatedRows field was added to the sqlite3_index_info
// structure for SQLite [version 3.8.2] ([dateof:3.8.2]).
// If a virtual table extension is
// used with an SQLite version earlier than 3.8.2, the results of attempting
// to read or write the estimatedRows field are undefined (but are likely
// to include crashing the application). The estimatedRows field should
// therefore only be used if [sqlite3_libversion_number()] returns a
// value greater than or equal to 3008002. Similarly, the idxFlags field
// was added for [version 3.9.0] ([dateof:3.9.0]).
// It may therefore only be used if
// sqlite3_libversion_number() returns a value greater than or equal to
// 3009000.
type sqlite3_index_constraint = struct {
	iColumn     int32
	op          uint8
	usable      uint8
	_           [2]byte
	iTermOffset int32
} /* sqlite3.h:6938:9 */

// CAPI3REF: Virtual Table Indexing Information
// KEYWORDS: sqlite3_index_info
//
// The sqlite3_index_info structure and its substructures is used as part
// of the [virtual table] interface to
// pass information into and receive the reply from the [xBestIndex]
// method of a [virtual table module].  The fields under **Inputs** are the
// inputs to xBestIndex and are read-only.  xBestIndex inserts its
// results into the **Outputs** fields.
//
// ^(The aConstraint[] array records WHERE clause constraints of the form:
//
// <blockquote>column OP expr</blockquote>
//
// where OP is =, &lt;, &lt;=, &gt;, or &gt;=.)^  ^(The particular operator is
// stored in aConstraint[].op using one of the
// [SQLITE_INDEX_CONSTRAINT_EQ | SQLITE_INDEX_CONSTRAINT_ values].)^
// ^(The index of the column is stored in
// aConstraint[].iColumn.)^  ^(aConstraint[].usable is TRUE if the
// expr on the right-hand side can be evaluated (and thus the constraint
// is usable) and false if it cannot.)^
//
// ^The optimizer automatically inverts terms of the form "expr OP column"
// and makes other simplifications to the WHERE clause in an attempt to
// get as many WHERE clause terms into the form shown above as possible.
// ^The aConstraint[] array only reports WHERE clause terms that are
// relevant to the particular virtual table being queried.
//
// ^Information about the ORDER BY clause is stored in aOrderBy[].
// ^Each term of aOrderBy records a column of the ORDER BY clause.
//
// The colUsed field indicates which columns of the virtual table may be
// required by the current scan. Virtual table columns are numbered from
// zero in the order in which they appear within the CREATE TABLE statement
// passed to sqlite3_declare_vtab(). For the first 63 columns (columns 0-62),
// the corresponding bit is set within the colUsed mask if the column may be
// required by SQLite. If the table has at least 64 columns and any column
// to the right of the first 63 is required, then bit 63 of colUsed is also
// set. In other words, column iCol may be required if the expression
// (colUsed & ((sqlite3_uint64)1 << (iCol>=63 ? 63 : iCol))) evaluates to
// non-zero.
//
// The [xBestIndex] method must fill aConstraintUsage[] with information
// about what parameters to pass to xFilter.  ^If argvIndex>0 then
// the right-hand side of the corresponding aConstraint[] is evaluated
// and becomes the argvIndex-th entry in argv.  ^(If aConstraintUsage[].omit
// is true, then the constraint is assumed to be fully handled by the
// virtual table and might not be checked again by the byte code.)^ ^(The
// aConstraintUsage[].omit flag is an optimization hint. When the omit flag
// is left in its default setting of false, the constraint will always be
// checked separately in byte code.  If the omit flag is change to true, then
// the constraint may or may not be checked in byte code.  In other words,
// when the omit flag is true there is no guarantee that the constraint will
// not be checked again using byte code.)^
//
// ^The idxNum and idxPtr values are recorded and passed into the
// [xFilter] method.
// ^[sqlite3_free()] is used to free idxPtr if and only if
// needToFreeIdxPtr is true.
//
// ^The orderByConsumed means that output from [xFilter]/[xNext] will occur in
// the correct order to satisfy the ORDER BY clause so that no separate
// sorting step is required.
//
// ^The estimatedCost value is an estimate of the cost of a particular
// strategy. A cost of N indicates that the cost of the strategy is similar
// to a linear scan of an SQLite table with N rows. A cost of log(N)
// indicates that the expense of the operation is similar to that of a
// binary search on a unique indexed field of an SQLite table with N rows.
//
// ^The estimatedRows value is an estimate of the number of rows that
// will be returned by the strategy.
//
// The xBestIndex method may optionally populate the idxFlags field with a
// mask of SQLITE_INDEX_SCAN_* flags. Currently there is only one such flag -
// SQLITE_INDEX_SCAN_UNIQUE. If the xBestIndex method sets this flag, SQLite
// assumes that the strategy may visit at most one row.
//
// Additionally, if xBestIndex sets the SQLITE_INDEX_SCAN_UNIQUE flag, then
// SQLite also assumes that if a call to the xUpdate() method is made as
// part of the same statement to delete or update a virtual table row and the
// implementation returns SQLITE_CONSTRAINT, then there is no need to rollback
// any database changes. In other words, if the xUpdate() returns
// SQLITE_CONSTRAINT, the database contents must be exactly as they were
// before xUpdate was called. By contrast, if SQLITE_INDEX_SCAN_UNIQUE is not
// set and xUpdate returns SQLITE_CONSTRAINT, any database changes made by
// the xUpdate method are automatically rolled back by SQLite.
//
// IMPORTANT: The estimatedRows field was added to the sqlite3_index_info
// structure for SQLite [version 3.8.2] ([dateof:3.8.2]).
// If a virtual table extension is
// used with an SQLite version earlier than 3.8.2, the results of attempting
// to read or write the estimatedRows field are undefined (but are likely
// to include crashing the application). The estimatedRows field should
// therefore only be used if [sqlite3_libversion_number()] returns a
// value greater than or equal to 3008002. Similarly, the idxFlags field
// was added for [version 3.9.0] ([dateof:3.9.0]).
// It may therefore only be used if
// sqlite3_libversion_number() returns a value greater than or equal to
// 3009000.
type sqlite3_index_orderby = struct {
	iColumn int32
	desc    uint8
	_       [3]byte
} /* sqlite3.h:6938:9 */

// CAPI3REF: Virtual Table Indexing Information
// KEYWORDS: sqlite3_index_info
//
// The sqlite3_index_info structure and its substructures is used as part
// of the [virtual table] interface to
// pass information into and receive the reply from the [xBestIndex]
// method of a [virtual table module].  The fields under **Inputs** are the
// inputs to xBestIndex and are read-only.  xBestIndex inserts its
// results into the **Outputs** fields.
//
// ^(The aConstraint[] array records WHERE clause constraints of the form:
//
// <blockquote>column OP expr</blockquote>
//
// where OP is =, &lt;, &lt;=, &gt;, or &gt;=.)^  ^(The particular operator is
// stored in aConstraint[].op using one of the
// [SQLITE_INDEX_CONSTRAINT_EQ | SQLITE_INDEX_CONSTRAINT_ values].)^
// ^(The index of the column is stored in
// aConstraint[].iColumn.)^  ^(aConstraint[].usable is TRUE if the
// expr on the right-hand side can be evaluated (and thus the constraint
// is usable) and false if it cannot.)^
//
// ^The optimizer automatically inverts terms of the form "expr OP column"
// and makes other simplifications to the WHERE clause in an attempt to
// get as many WHERE clause terms into the form shown above as possible.
// ^The aConstraint[] array only reports WHERE clause terms that are
// relevant to the particular virtual table being queried.
//
// ^Information about the ORDER BY clause is stored in aOrderBy[].
// ^Each term of aOrderBy records a column of the ORDER BY clause.
//
// The colUsed field indicates which columns of the virtual table may be
// required by the current scan. Virtual table columns are numbered from
// zero in the order in which they appear within the CREATE TABLE statement
// passed to sqlite3_declare_vtab(). For the first 63 columns (columns 0-62),
// the corresponding bit is set within the colUsed mask if the column may be
// required by SQLite. If the table has at least 64 columns and any column
// to the right of the first 63 is required, then bit 63 of colUsed is also
// set. In other words, column iCol may be required if the expression
// (colUsed & ((sqlite3_uint64)1 << (iCol>=63 ? 63 : iCol))) evaluates to
// non-zero.
//
// The [xBestIndex] method must fill aConstraintUsage[] with information
// about what parameters to pass to xFilter.  ^If argvIndex>0 then
// the right-hand side of the corresponding aConstraint[] is evaluated
// and becomes the argvIndex-th entry in argv.  ^(If aConstraintUsage[].omit
// is true, then the constraint is assumed to be fully handled by the
// virtual table and might not be checked again by the byte code.)^ ^(The
// aConstraintUsage[].omit flag is an optimization hint. When the omit flag
// is left in its default setting of false, the constraint will always be
// checked separately in byte code.  If the omit flag is change to true, then
// the constraint may or may not be checked in byte code.  In other words,
// when the omit flag is true there is no guarantee that the constraint will
// not be checked again using byte code.)^
//
// ^The idxNum and idxPtr values are recorded and passed into the
// [xFilter] method.
// ^[sqlite3_free()] is used to free idxPtr if and only if
// needToFreeIdxPtr is true.
//
// ^The orderByConsumed means that output from [xFilter]/[xNext] will occur in
// the correct order to satisfy the ORDER BY clause so that no separate
// sorting step is required.
//
// ^The estimatedCost value is an estimate of the cost of a particular
// strategy. A cost of N indicates that the cost of the strategy is similar
// to a linear scan of an SQLite table with N rows. A cost of log(N)
// indicates that the expense of the operation is similar to that of a
// binary search on a unique indexed field of an SQLite table with N rows.
//
// ^The estimatedRows value is an estimate of the number of rows that
// will be returned by the strategy.
//
// The xBestIndex method may optionally populate the idxFlags field with a
// mask of SQLITE_INDEX_SCAN_* flags. Currently there is only one such flag -
// SQLITE_INDEX_SCAN_UNIQUE. If the xBestIndex method sets this flag, SQLite
// assumes that the strategy may visit at most one row.
//
// Additionally, if xBestIndex sets the SQLITE_INDEX_SCAN_UNIQUE flag, then
// SQLite also assumes that if a call to the xUpdate() method is made as
// part of the same statement to delete or update a virtual table row and the
// implementation returns SQLITE_CONSTRAINT, then there is no need to rollback
// any database changes. In other words, if the xUpdate() returns
// SQLITE_CONSTRAINT, the database contents must be exactly as they were
// before xUpdate was called. By contrast, if SQLITE_INDEX_SCAN_UNIQUE is not
// set and xUpdate returns SQLITE_CONSTRAINT, any database changes made by
// the xUpdate method are automatically rolled back by SQLite.
//
// IMPORTANT: The estimatedRows field was added to the sqlite3_index_info
// structure for SQLite [version 3.8.2] ([dateof:3.8.2]).
// If a virtual table extension is
// used with an SQLite version earlier than 3.8.2, the results of attempting
// to read or write the estimatedRows field are undefined (but are likely
// to include crashing the application). The estimatedRows field should
// therefore only be used if [sqlite3_libversion_number()] returns a
// value greater than or equal to 3008002. Similarly, the idxFlags field
// was added for [version 3.9.0] ([dateof:3.9.0]).
// It may therefore only be used if
// sqlite3_libversion_number() returns a value greater than or equal to
// 3009000.
type sqlite3_index_constraint_usage = struct {
	argvIndex int32
	omit      uint8
	_         [3]byte
} /* sqlite3.h:6938:9 */

// CAPI3REF: Mutex Methods Object
//
// An instance of this structure defines the low-level routines
// used to allocate and use mutexes.
//
// Usually, the default mutex implementations provided by SQLite are
// sufficient, however the application has the option of substituting a custom
// implementation for specialized deployments or systems for which SQLite
// does not provide a suitable implementation. In this case, the application
// creates and populates an instance of this structure to pass
// to sqlite3_config() along with the [SQLITE_CONFIG_MUTEX] option.
// Additionally, an instance of this structure can be used as an
// output variable when querying the system for the current mutex
// implementation, using the [SQLITE_CONFIG_GETMUTEX] option.
//
// ^The xMutexInit method defined by this structure is invoked as
// part of system initialization by the sqlite3_initialize() function.
// ^The xMutexInit routine is called by SQLite exactly once for each
// effective call to [sqlite3_initialize()].
//
// ^The xMutexEnd method defined by this structure is invoked as
// part of system shutdown by the sqlite3_shutdown() function. The
// implementation of this method is expected to release all outstanding
// resources obtained by the mutex methods implementation, especially
// those obtained by the xMutexInit method.  ^The xMutexEnd()
// interface is invoked exactly once for each call to [sqlite3_shutdown()].
//
// ^(The remaining seven methods defined by this structure (xMutexAlloc,
// xMutexFree, xMutexEnter, xMutexTry, xMutexLeave, xMutexHeld and
// xMutexNotheld) implement the following interfaces (respectively):
//
// <ul>
//
//	<li>  [sqlite3_mutex_alloc()] </li>
//	<li>  [sqlite3_mutex_free()] </li>
//	<li>  [sqlite3_mutex_enter()] </li>
//	<li>  [sqlite3_mutex_try()] </li>
//	<li>  [sqlite3_mutex_leave()] </li>
//	<li>  [sqlite3_mutex_held()] </li>
//	<li>  [sqlite3_mutex_notheld()] </li>
//
// </ul>)^
//
// The only difference is that the public sqlite3_XXX functions enumerated
// above silently ignore any invocations that pass a NULL pointer instead
// of a valid mutex handle. The implementations of the methods defined
// by this structure are not required to handle this case. The results
// of passing a NULL pointer instead of a valid mutex handle are undefined
// (i.e. it is acceptable to provide an implementation that segfaults if
// it is passed a NULL pointer).
//
// The xMutexInit() method must be threadsafe.  It must be harmless to
// invoke xMutexInit() multiple times within the same process and without
// intervening calls to xMutexEnd().  Second and subsequent calls to
// xMutexInit() must be no-ops.
//
// xMutexInit() must not use SQLite memory allocation ([sqlite3_malloc()]
// and its associates).  Similarly, xMutexAlloc() must not use SQLite memory
// allocation for a static mutex.  ^However xMutexAlloc() may use SQLite
// memory allocation for a fast or recursive mutex.
//
// ^SQLite will invoke the xMutexEnd() method when [sqlite3_shutdown()] is
// called, but only if the prior call to xMutexInit returned SQLITE_OK.
// If xMutexInit fails in any way, it is expected to clean up after itself
// prior to returning.
type sqlite3_mutex_methods1 = struct {
	xMutexInit    uintptr
	xMutexEnd     uintptr
	xMutexAlloc   uintptr
	xMutexFree    uintptr
	xMutexEnter   uintptr
	xMutexTry     uintptr
	xMutexLeave   uintptr
	xMutexHeld    uintptr
	xMutexNotheld uintptr
} /* sqlite3.h:7804:9 */

// CAPI3REF: Mutex Methods Object
//
// An instance of this structure defines the low-level routines
// used to allocate and use mutexes.
//
// Usually, the default mutex implementations provided by SQLite are
// sufficient, however the application has the option of substituting a custom
// implementation for specialized deployments or systems for which SQLite
// does not provide a suitable implementation. In this case, the application
// creates and populates an instance of this structure to pass
// to sqlite3_config() along with the [SQLITE_CONFIG_MUTEX] option.
// Additionally, an instance of this structure can be used as an
// output variable when querying the system for the current mutex
// implementation, using the [SQLITE_CONFIG_GETMUTEX] option.
//
// ^The xMutexInit method defined by this structure is invoked as
// part of system initialization by the sqlite3_initialize() function.
// ^The xMutexInit routine is called by SQLite exactly once for each
// effective call to [sqlite3_initialize()].
//
// ^The xMutexEnd method defined by this structure is invoked as
// part of system shutdown by the sqlite3_shutdown() function. The
// implementation of this method is expected to release all outstanding
// resources obtained by the mutex methods implementation, especially
// those obtained by the xMutexInit method.  ^The xMutexEnd()
// interface is invoked exactly once for each call to [sqlite3_shutdown()].
//
// ^(The remaining seven methods defined by this structure (xMutexAlloc,
// xMutexFree, xMutexEnter, xMutexTry, xMutexLeave, xMutexHeld and
// xMutexNotheld) implement the following interfaces (respectively):
//
// <ul>
//
//	<li>  [sqlite3_mutex_alloc()] </li>
//	<li>  [sqlite3_mutex_free()] </li>
//	<li>  [sqlite3_mutex_enter()] </li>
//	<li>  [sqlite3_mutex_try()] </li>
//	<li>  [sqlite3_mutex_leave()] </li>
//	<li>  [sqlite3_mutex_held()] </li>
//	<li>  [sqlite3_mutex_notheld()] </li>
//
// </ul>)^
//
// The only difference is that the public sqlite3_XXX functions enumerated
// above silently ignore any invocations that pass a NULL pointer instead
// of a valid mutex handle. The implementations of the methods defined
// by this structure are not required to handle this case. The results
// of passing a NULL pointer instead of a valid mutex handle are undefined
// (i.e. it is acceptable to provide an implementation that segfaults if
// it is passed a NULL pointer).
//
// The xMutexInit() method must be threadsafe.  It must be harmless to
// invoke xMutexInit() multiple times within the same process and without
// intervening calls to xMutexEnd().  Second and subsequent calls to
// xMutexInit() must be no-ops.
//
// xMutexInit() must not use SQLite memory allocation ([sqlite3_malloc()]
// and its associates).  Similarly, xMutexAlloc() must not use SQLite memory
// allocation for a static mutex.  ^However xMutexAlloc() may use SQLite
// memory allocation for a fast or recursive mutex.
//
// ^SQLite will invoke the xMutexEnd() method when [sqlite3_shutdown()] is
// called, but only if the prior call to xMutexInit returned SQLITE_OK.
// If xMutexInit fails in any way, it is expected to clean up after itself
// prior to returning.
type sqlite3_mutex_methods = sqlite3_mutex_methods1 /* sqlite3.h:7804:38 */

// CAPI3REF: Custom Page Cache Object
//
// The sqlite3_pcache_page object represents a single page in the
// page cache.  The page cache will allocate instances of this
// object.  Various methods of the page cache use pointers to instances
// of this object as parameters or as their return value.
//
// See [sqlite3_pcache_methods2] for additional information.
type sqlite3_pcache_page1 = struct {
	pBuf   uintptr
	pExtra uintptr
} /* sqlite3.h:8573:9 */

// CAPI3REF: Custom Page Cache Object
//
// The sqlite3_pcache_page object represents a single page in the
// page cache.  The page cache will allocate instances of this
// object.  Various methods of the page cache use pointers to instances
// of this object as parameters or as their return value.
//
// See [sqlite3_pcache_methods2] for additional information.
type sqlite3_pcache_page = sqlite3_pcache_page1 /* sqlite3.h:8573:36 */

// CAPI3REF: Application Defined Page Cache.
// KEYWORDS: {page cache}
//
// ^(The [sqlite3_config]([SQLITE_CONFIG_PCACHE2], ...) interface can
// register an alternative page cache implementation by passing in an
// instance of the sqlite3_pcache_methods2 structure.)^
// In many applications, most of the heap memory allocated by
// SQLite is used for the page cache.
// By implementing a
// custom page cache using this API, an application can better control
// the amount of memory consumed by SQLite, the way in which
// that memory is allocated and released, and the policies used to
// determine exactly which parts of a database file are cached and for
// how long.
//
// The alternative page cache mechanism is an
// extreme measure that is only needed by the most demanding applications.
// The built-in page cache is recommended for most uses.
//
// ^(The contents of the sqlite3_pcache_methods2 structure are copied to an
// internal buffer by SQLite within the call to [sqlite3_config].  Hence
// the application may discard the parameter after the call to
// [sqlite3_config()] returns.)^
//
// [[the xInit() page cache method]]
// ^(The xInit() method is called once for each effective
// call to [sqlite3_initialize()])^
// (usually only once during the lifetime of the process). ^(The xInit()
// method is passed a copy of the sqlite3_pcache_methods2.pArg value.)^
// The intent of the xInit() method is to set up global data structures
// required by the custom page cache implementation.
// ^(If the xInit() method is NULL, then the
// built-in default page cache is used instead of the application defined
// page cache.)^
//
// [[the xShutdown() page cache method]]
// ^The xShutdown() method is called by [sqlite3_shutdown()].
// It can be used to clean up
// any outstanding resources before process shutdown, if required.
// ^The xShutdown() method may be NULL.
//
// ^SQLite automatically serializes calls to the xInit method,
// so the xInit method need not be threadsafe.  ^The
// xShutdown method is only called from [sqlite3_shutdown()] so it does
// not need to be threadsafe either.  All other methods must be threadsafe
// in multithreaded applications.
//
// ^SQLite will never invoke xInit() more than once without an intervening
// call to xShutdown().
//
// [[the xCreate() page cache methods]]
// ^SQLite invokes the xCreate() method to construct a new cache instance.
// SQLite will typically create one cache instance for each open database file,
// though this is not guaranteed. ^The
// first parameter, szPage, is the size in bytes of the pages that must
// be allocated by the cache.  ^szPage will always a power of two.  ^The
// second parameter szExtra is a number of bytes of extra storage
// associated with each page cache entry.  ^The szExtra parameter will
// a number less than 250.  SQLite will use the
// extra szExtra bytes on each page to store metadata about the underlying
// database page on disk.  The value passed into szExtra depends
// on the SQLite version, the target platform, and how SQLite was compiled.
// ^The third argument to xCreate(), bPurgeable, is true if the cache being
// created will be used to cache database pages of a file stored on disk, or
// false if it is used for an in-memory database. The cache implementation
// does not have to do anything special based with the value of bPurgeable;
// it is purely advisory.  ^On a cache where bPurgeable is false, SQLite will
// never invoke xUnpin() except to deliberately delete a page.
// ^In other words, calls to xUnpin() on a cache with bPurgeable set to
// false will always have the "discard" flag set to true.
// ^Hence, a cache created with bPurgeable false will
// never contain any unpinned pages.
//
// [[the xCachesize() page cache method]]
// ^(The xCachesize() method may be called at any time by SQLite to set the
// suggested maximum cache-size (number of pages stored by) the cache
// instance passed as the first argument. This is the value configured using
// the SQLite "[PRAGMA cache_size]" command.)^  As with the bPurgeable
// parameter, the implementation is not required to do anything with this
// value; it is advisory only.
//
// [[the xPagecount() page cache methods]]
// The xPagecount() method must return the number of pages currently
// stored in the cache, both pinned and unpinned.
//
// [[the xFetch() page cache methods]]
// The xFetch() method locates a page in the cache and returns a pointer to
// an sqlite3_pcache_page object associated with that page, or a NULL pointer.
// The pBuf element of the returned sqlite3_pcache_page object will be a
// pointer to a buffer of szPage bytes used to store the content of a
// single database page.  The pExtra element of sqlite3_pcache_page will be
// a pointer to the szExtra bytes of extra storage that SQLite has requested
// for each entry in the page cache.
//
// The page to be fetched is determined by the key. ^The minimum key value
// is 1.  After it has been retrieved using xFetch, the page is considered
// to be "pinned".
//
// If the requested page is already in the page cache, then the page cache
// implementation must return a pointer to the page buffer with its content
// intact.  If the requested page is not already in the cache, then the
// cache implementation should use the value of the createFlag
// parameter to help it determined what action to take:
//
// <table border=1 width=85% align=center>
// <tr><th> createFlag <th> Behavior when page is not already in cache
// <tr><td> 0 <td> Do not allocate a new page.  Return NULL.
// <tr><td> 1 <td> Allocate a new page if it easy and convenient to do so.
//
//	Otherwise return NULL.
//
// <tr><td> 2 <td> Make every effort to allocate a new page.  Only return
//
//	NULL if allocating a new page is effectively impossible.
//
// </table>
//
// ^(SQLite will normally invoke xFetch() with a createFlag of 0 or 1.  SQLite
// will only use a createFlag of 2 after a prior call with a createFlag of 1
// failed.)^  In between the xFetch() calls, SQLite may
// attempt to unpin one or more cache pages by spilling the content of
// pinned pages to disk and synching the operating system disk cache.
//
// [[the xUnpin() page cache method]]
// ^xUnpin() is called by SQLite with a pointer to a currently pinned page
// as its second argument.  If the third parameter, discard, is non-zero,
// then the page must be evicted from the cache.
// ^If the discard parameter is
// zero, then the page may be discarded or retained at the discretion of
// page cache implementation. ^The page cache implementation
// may choose to evict unpinned pages at any time.
//
// The cache must not perform any reference counting. A single
// call to xUnpin() unpins the page regardless of the number of prior calls
// to xFetch().
//
// [[the xRekey() page cache methods]]
// The xRekey() method is used to change the key value associated with the
// page passed as the second argument. If the cache
// previously contains an entry associated with newKey, it must be
// discarded. ^Any prior cache entry associated with newKey is guaranteed not
// to be pinned.
//
// When SQLite calls the xTruncate() method, the cache must discard all
// existing cache entries with page numbers (keys) greater than or equal
// to the value of the iLimit parameter passed to xTruncate(). If any
// of these pages are pinned, they are implicitly unpinned, meaning that
// they can be safely discarded.
//
// [[the xDestroy() page cache method]]
// ^The xDestroy() method is used to delete a cache allocated by xCreate().
// All resources associated with the specified cache should be freed. ^After
// calling the xDestroy() method, SQLite considers the [sqlite3_pcache*]
// handle invalid, and will not use it with any other sqlite3_pcache_methods2
// functions.
//
// [[the xShrink() page cache method]]
// ^SQLite invokes the xShrink() method when it wants the page cache to
// free up as much of heap memory as possible.  The page cache implementation
// is not obligated to free any memory, but well-behaved implementations should
// do their best.
type sqlite3_pcache_methods21 = struct {
	iVersion   int32
	_          [4]byte
	pArg       uintptr
	xInit      uintptr
	xShutdown  uintptr
	xCreate    uintptr
	xCachesize uintptr
	xPagecount uintptr
	xFetch     uintptr
	xUnpin     uintptr
	xRekey     uintptr
	xTruncate  uintptr
	xDestroy   uintptr
	xShrink    uintptr
} /* sqlite3.h:8738:9 */

// CAPI3REF: Application Defined Page Cache.
// KEYWORDS: {page cache}
//
// ^(The [sqlite3_config]([SQLITE_CONFIG_PCACHE2], ...) interface can
// register an alternative page cache implementation by passing in an
// instance of the sqlite3_pcache_methods2 structure.)^
// In many applications, most of the heap memory allocated by
// SQLite is used for the page cache.
// By implementing a
// custom page cache using this API, an application can better control
// the amount of memory consumed by SQLite, the way in which
// that memory is allocated and released, and the policies used to
// determine exactly which parts of a database file are cached and for
// how long.
//
// The alternative page cache mechanism is an
// extreme measure that is only needed by the most demanding applications.
// The built-in page cache is recommended for most uses.
//
// ^(The contents of the sqlite3_pcache_methods2 structure are copied to an
// internal buffer by SQLite within the call to [sqlite3_config].  Hence
// the application may discard the parameter after the call to
// [sqlite3_config()] returns.)^
//
// [[the xInit() page cache method]]
// ^(The xInit() method is called once for each effective
// call to [sqlite3_initialize()])^
// (usually only once during the lifetime of the process). ^(The xInit()
// method is passed a copy of the sqlite3_pcache_methods2.pArg value.)^
// The intent of the xInit() method is to set up global data structures
// required by the custom page cache implementation.
// ^(If the xInit() method is NULL, then the
// built-in default page cache is used instead of the application defined
// page cache.)^
//
// [[the xShutdown() page cache method]]
// ^The xShutdown() method is called by [sqlite3_shutdown()].
// It can be used to clean up
// any outstanding resources before process shutdown, if required.
// ^The xShutdown() method may be NULL.
//
// ^SQLite automatically serializes calls to the xInit method,
// so the xInit method need not be threadsafe.  ^The
// xShutdown method is only called from [sqlite3_shutdown()] so it does
// not need to be threadsafe either.  All other methods must be threadsafe
// in multithreaded applications.
//
// ^SQLite will never invoke xInit() more than once without an intervening
// call to xShutdown().
//
// [[the xCreate() page cache methods]]
// ^SQLite invokes the xCreate() method to construct a new cache instance.
// SQLite will typically create one cache instance for each open database file,
// though this is not guaranteed. ^The
// first parameter, szPage, is the size in bytes of the pages that must
// be allocated by the cache.  ^szPage will always a power of two.  ^The
// second parameter szExtra is a number of bytes of extra storage
// associated with each page cache entry.  ^The szExtra parameter will
// a number less than 250.  SQLite will use the
// extra szExtra bytes on each page to store metadata about the underlying
// database page on disk.  The value passed into szExtra depends
// on the SQLite version, the target platform, and how SQLite was compiled.
// ^The third argument to xCreate(), bPurgeable, is true if the cache being
// created will be used to cache database pages of a file stored on disk, or
// false if it is used for an in-memory database. The cache implementation
// does not have to do anything special based with the value of bPurgeable;
// it is purely advisory.  ^On a cache where bPurgeable is false, SQLite will
// never invoke xUnpin() except to deliberately delete a page.
// ^In other words, calls to xUnpin() on a cache with bPurgeable set to
// false will always have the "discard" flag set to true.
// ^Hence, a cache created with bPurgeable false will
// never contain any unpinned pages.
//
// [[the xCachesize() page cache method]]
// ^(The xCachesize() method may be called at any time by SQLite to set the
// suggested maximum cache-size (number of pages stored by) the cache
// instance passed as the first argument. This is the value configured using
// the SQLite "[PRAGMA cache_size]" command.)^  As with the bPurgeable
// parameter, the implementation is not required to do anything with this
// value; it is advisory only.
//
// [[the xPagecount() page cache methods]]
// The xPagecount() method must return the number of pages currently
// stored in the cache, both pinned and unpinned.
//
// [[the xFetch() page cache methods]]
// The xFetch() method locates a page in the cache and returns a pointer to
// an sqlite3_pcache_page object associated with that page, or a NULL pointer.
// The pBuf element of the returned sqlite3_pcache_page object will be a
// pointer to a buffer of szPage bytes used to store the content of a
// single database page.  The pExtra element of sqlite3_pcache_page will be
// a pointer to the szExtra bytes of extra storage that SQLite has requested
// for each entry in the page cache.
//
// The page to be fetched is determined by the key. ^The minimum key value
// is 1.  After it has been retrieved using xFetch, the page is considered
// to be "pinned".
//
// If the requested page is already in the page cache, then the page cache
// implementation must return a pointer to the page buffer with its content
// intact.  If the requested page is not already in the cache, then the
// cache implementation should use the value of the createFlag
// parameter to help it determined what action to take:
//
// <table border=1 width=85% align=center>
// <tr><th> createFlag <th> Behavior when page is not already in cache
// <tr><td> 0 <td> Do not allocate a new page.  Return NULL.
// <tr><td> 1 <td> Allocate a new page if it easy and convenient to do so.
//
//	Otherwise return NULL.
//
// <tr><td> 2 <td> Make every effort to allocate a new page.  Only return
//
//	NULL if allocating a new page is effectively impossible.
//
// </table>
//
// ^(SQLite will normally invoke xFetch() with a createFlag of 0 or 1.  SQLite
// will only use a createFlag of 2 after a prior call with a createFlag of 1
// failed.)^  In between the xFetch() calls, SQLite may
// attempt to unpin one or more cache pages by spilling the content of
// pinned pages to disk and synching the operating system disk cache.
//
// [[the xUnpin() page cache method]]
// ^xUnpin() is called by SQLite with a pointer to a currently pinned page
// as its second argument.  If the third parameter, discard, is non-zero,
// then the page must be evicted from the cache.
// ^If the discard parameter is
// zero, then the page may be discarded or retained at the discretion of
// page cache implementation. ^The page cache implementation
// may choose to evict unpinned pages at any time.
//
// The cache must not perform any reference counting. A single
// call to xUnpin() unpins the page regardless of the number of prior calls
// to xFetch().
//
// [[the xRekey() page cache methods]]
// The xRekey() method is used to change the key value associated with the
// page passed as the second argument. If the cache
// previously contains an entry associated with newKey, it must be
// discarded. ^Any prior cache entry associated with newKey is guaranteed not
// to be pinned.
//
// When SQLite calls the xTruncate() method, the cache must discard all
// existing cache entries with page numbers (keys) greater than or equal
// to the value of the iLimit parameter passed to xTruncate(). If any
// of these pages are pinned, they are implicitly unpinned, meaning that
// they can be safely discarded.
//
// [[the xDestroy() page cache method]]
// ^The xDestroy() method is used to delete a cache allocated by xCreate().
// All resources associated with the specified cache should be freed. ^After
// calling the xDestroy() method, SQLite considers the [sqlite3_pcache*]
// handle invalid, and will not use it with any other sqlite3_pcache_methods2
// functions.
//
// [[the xShrink() page cache method]]
// ^SQLite invokes the xShrink() method when it wants the page cache to
// free up as much of heap memory as possible.  The page cache implementation
// is not obligated to free any memory, but well-behaved implementations should
// do their best.
type sqlite3_pcache_methods2 = sqlite3_pcache_methods21 /* sqlite3.h:8738:40 */

// This is the obsolete pcache_methods object that has now been replaced
// by sqlite3_pcache_methods2.  This object is not used by SQLite.  It is
// retained in the header file for backwards compatibility only.
type sqlite3_pcache_methods1 = struct {
	pArg       uintptr
	xInit      uintptr
	xShutdown  uintptr
	xCreate    uintptr
	xCachesize uintptr
	xPagecount uintptr
	xFetch     uintptr
	xUnpin     uintptr
	xRekey     uintptr
	xTruncate  uintptr
	xDestroy   uintptr
} /* sqlite3.h:8761:9 */

// This is the obsolete pcache_methods object that has now been replaced
// by sqlite3_pcache_methods2.  This object is not used by SQLite.  It is
// retained in the header file for backwards compatibility only.
type sqlite3_pcache_methods = sqlite3_pcache_methods1 /* sqlite3.h:8761:39 */

// CAPI3REF: Database Snapshot
// KEYWORDS: {snapshot} {sqlite3_snapshot}
//
// An instance of the snapshot object records the state of a [WAL mode]
// database for some specific point in history.
//
// In [WAL mode], multiple [database connections] that are open on the
// same database file can each be reading a different historical version
// of the database file.  When a [database connection] begins a read
// transaction, that connection sees an unchanging copy of the database
// as it existed for the point in time when the transaction first started.
// Subsequent changes to the database from other connections are not seen
// by the reader until a new read transaction is started.
//
// The sqlite3_snapshot object records state information about an historical
// version of the database file so that it is possible to later open a new read
// transaction that sees that historical version of the database rather than
// the most recent version.
type sqlite3_snapshot1 = struct{ hidden [48]uint8 } /* sqlite3.h:10079:9 */

// CAPI3REF: Database Snapshot
// KEYWORDS: {snapshot} {sqlite3_snapshot}
//
// An instance of the snapshot object records the state of a [WAL mode]
// database for some specific point in history.
//
// In [WAL mode], multiple [database connections] that are open on the
// same database file can each be reading a different historical version
// of the database file.  When a [database connection] begins a read
// transaction, that connection sees an unchanging copy of the database
// as it existed for the point in time when the transaction first started.
// Subsequent changes to the database from other connections are not seen
// by the reader until a new read transaction is started.
//
// The sqlite3_snapshot object records state information about an historical
// version of the database file so that it is possible to later open a new read
// transaction that sees that historical version of the database rather than
// the most recent version.
type sqlite3_snapshot = sqlite3_snapshot1 /* sqlite3.h:10081:3 */

// CAPI3REF: Flags for sqlite3_deserialize()
//
// The following are allowed values for 6th argument (the F argument) to
// the [sqlite3_deserialize(D,S,P,N,M,F)] interface.
//
// The SQLITE_DESERIALIZE_FREEONCLOSE means that the database serialization
// in the P argument is held in memory obtained from [sqlite3_malloc64()]
// and that SQLite should take ownership of this memory and automatically
// free it when it has finished using it.  Without this flag, the caller
// is responsible for freeing any dynamically allocated memory.
//
// The SQLITE_DESERIALIZE_RESIZEABLE flag means that SQLite is allowed to
// grow the size of the database using calls to [sqlite3_realloc64()].  This
// flag should only be used if SQLITE_DESERIALIZE_FREEONCLOSE is also used.
// Without this flag, the deserialized database cannot increase in size beyond
// the number of bytes specified by the M parameter.
//
// The SQLITE_DESERIALIZE_READONLY flag means that the deserialized database
// should be treated as read-only.

// Undo the hack that converts floating point types to integer for
// builds on processors without floating point support.

//******* Begin file sqlite3rtree.h ********
// 2010 August 30
//
// The author disclaims copyright to this source code.  In place of
// a legal notice, here is a blessing:
//
//    May you do good and not evil.
//    May you find forgiveness for yourself and forgive others.
//    May you share freely, never taking more than you give.
//
//

type sqlite3_rtree_geometry1 = struct {
	pContext uintptr
	nParam   int32
	_        [4]byte
	aParam   uintptr
	pUser    uintptr
	xDelUser uintptr
} /* sqlite3.h:10410:9 */

// CAPI3REF: Flags for sqlite3_deserialize()
//
// The following are allowed values for 6th argument (the F argument) to
// the [sqlite3_deserialize(D,S,P,N,M,F)] interface.
//
// The SQLITE_DESERIALIZE_FREEONCLOSE means that the database serialization
// in the P argument is held in memory obtained from [sqlite3_malloc64()]
// and that SQLite should take ownership of this memory and automatically
// free it when it has finished using it.  Without this flag, the caller
// is responsible for freeing any dynamically allocated memory.
//
// The SQLITE_DESERIALIZE_RESIZEABLE flag means that SQLite is allowed to
// grow the size of the database using calls to [sqlite3_realloc64()].  This
// flag should only be used if SQLITE_DESERIALIZE_FREEONCLOSE is also used.
// Without this flag, the deserialized database cannot increase in size beyond
// the number of bytes specified by the M parameter.
//
// The SQLITE_DESERIALIZE_READONLY flag means that the deserialized database
// should be treated as read-only.

// Undo the hack that converts floating point types to integer for
// builds on processors without floating point support.

//******* Begin file sqlite3rtree.h ********
// 2010 August 30
//
// The author disclaims copyright to this source code.  In place of
// a legal notice, here is a blessing:
//
//    May you do good and not evil.
//    May you find forgiveness for yourself and forgive others.
//    May you share freely, never taking more than you give.
//
//

type sqlite3_rtree_geometry = sqlite3_rtree_geometry1 /* sqlite3.h:10410:39 */
type sqlite3_rtree_query_info1 = struct {
	pContext      uintptr
	nParam        int32
	_             [4]byte
	aParam        uintptr
	pUser         uintptr
	xDelUser      uintptr
	aCoord        uintptr
	anQueue       uintptr
	nCoord        int32
	iLevel        int32
	mxLevel       int32
	_             [4]byte
	iRowid        sqlite3_int64
	rParentScore  sqlite3_rtree_dbl
	eParentWithin int32
	eWithin       int32
	rScore        sqlite3_rtree_dbl
	apSqlParam    uintptr
} /* sqlite3.h:10411:9 */

type sqlite3_rtree_query_info = sqlite3_rtree_query_info1 /* sqlite3.h:10411:41 */

// The double-precision datatype used by RTree depends on the
// SQLITE_RTREE_INT_ONLY compile-time option.
type sqlite3_rtree_dbl = float64 /* sqlite3.h:10419:18 */

// Allowed values for sqlite3_rtree_query.eWithin and .eParentWithin.

//******* End of sqlite3rtree.h ********
//******* Begin file sqlite3session.h ********

//******* End of sqlite3session.h ********
//******* Begin file fts5.h ********
// 2014 May 31
//
// The author disclaims copyright to this source code.  In place of
// a legal notice, here is a blessing:
//
//    May you do good and not evil.
//    May you find forgiveness for yourself and forgive others.
//    May you share freely, never taking more than you give.
//
//
//
// Interfaces to extend FTS5. Using the interfaces defined in this file,
// FTS5 may be extended with:
//
//     * custom tokenizers, and
//     * custom auxiliary functions.

// ************************************************************************
//
// CUSTOM AUXILIARY FUNCTIONS
//
// Virtual table implementations may overload SQL functions by implementing
// the sqlite3_module.xFindFunction() method.

type Fts5ExtensionApi1 = struct {
	iVersion           int32
	_                  [4]byte
	xUserData          uintptr
	xColumnCount       uintptr
	xRowCount          uintptr
	xColumnTotalSize   uintptr
	xTokenize          uintptr
	xPhraseCount       uintptr
	xPhraseSize        uintptr
	xInstCount         uintptr
	xInst              uintptr
	xRowid             uintptr
	xColumnText        uintptr
	xColumnSize        uintptr
	xQueryPhrase       uintptr
	xSetAuxdata        uintptr
	xGetAuxdata        uintptr
	xPhraseFirst       uintptr
	xPhraseNext        uintptr
	xPhraseFirstColumn uintptr
	xPhraseNextColumn  uintptr
} /* sqlite3.h:12266:9 */

// Allowed values for sqlite3_rtree_query.eWithin and .eParentWithin.

//******* End of sqlite3rtree.h ********
//******* Begin file sqlite3session.h ********

//******* End of sqlite3session.h ********
//******* Begin file fts5.h ********
// 2014 May 31
//
// The author disclaims copyright to this source code.  In place of
// a legal notice, here is a blessing:
//
//    May you do good and not evil.
//    May you find forgiveness for yourself and forgive others.
//    May you share freely, never taking more than you give.
//
//
//
// Interfaces to extend FTS5. Using the interfaces defined in this file,
// FTS5 may be extended with:
//
//     * custom tokenizers, and
//     * custom auxiliary functions.

// ************************************************************************
//
// CUSTOM AUXILIARY FUNCTIONS
//
// Virtual table implementations may overload SQL functions by implementing
// the sqlite3_module.xFindFunction() method.

type Fts5ExtensionApi = Fts5ExtensionApi1 /* sqlite3.h:12266:33 */
type Fts5PhraseIter1 = struct {
	a uintptr
	b uintptr
} /* sqlite3.h:12268:9 */

type Fts5PhraseIter = Fts5PhraseIter1 /* sqlite3.h:12268:31 */

type fts5_extension_function = uintptr /* sqlite3.h:12270:14 */
type fts5_tokenizer1 = struct {
	xCreate   uintptr
	xDelete   uintptr
	xTokenize uintptr
} /* sqlite3.h:12729:9 */

type fts5_tokenizer = fts5_tokenizer1 /* sqlite3.h:12729:31 */

// Flags that may be passed as the third argument to xTokenize()

// Flags that may be passed by the tokenizer implementation back to FTS5
// as the third argument to the supplied xToken callback.

//
// END OF CUSTOM TOKENIZERS
//

// ************************************************************************
//
// FTS5 EXTENSION REGISTRATION API
type fts5_api1 = struct {
	iVersion         int32
	_                [4]byte
	xCreateTokenizer uintptr
	xFindTokenizer   uintptr
	xCreateFunction  uintptr
} /* sqlite3.h:12765:9 */

// Flags that may be passed as the third argument to xTokenize()

// Flags that may be passed by the tokenizer implementation back to FTS5
// as the third argument to the supplied xToken callback.

//
// END OF CUSTOM TOKENIZERS
//

// ************************************************************************
//
// FTS5 EXTENSION REGISTRATION API
type fts5_api = fts5_api1 /* sqlite3.h:12765:25 */

type locale_t = uintptr /* string.h:116:25 */

// __cpu_simple_lock_t used to be a full word.

// The amd64 does not have strict alignment requirements.

//	$NetBSD: ansi.h,v 1.11 2019/05/07 03:49:26 kamil Exp $

//	$NetBSD: common_ansi.h,v 1.1 2014/08/19 07:27:31 matt Exp $

// -
// Copyright (c) 2014 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Matt Thomas of 3am Software Foundry.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

//	$NetBSD: int_types.h,v 1.7 2014/07/25 21:43:13 joerg Exp $

// -
// Copyright (c) 1990 The Regents of the University of California.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	from: @(#)types.h	7.5 (Berkeley) 3/9/91

//	$NetBSD: ansi.h,v 1.14 2011/07/17 20:54:54 joerg Exp $

// -
// Copyright (c) 2000, 2001, 2002 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Jun-ichiro itojun Hagino and by Klaus Klein.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

type int8_t = int8 /* types.h:54:18 */

type uint8_t = uint8 /* types.h:59:19 */

type int16_t = int16 /* types.h:64:19 */

type uint16_t = uint16 /* types.h:69:20 */

type int32_t = int32 /* types.h:74:19 */

type uint32_t = uint32 /* types.h:79:20 */

type int64_t = int64 /* types.h:84:19 */

type uint64_t = uint64 /* types.h:89:20 */

type u_int8_t = uint8_t   /* types.h:93:18 */
type u_int16_t = uint16_t /* types.h:94:18 */
type u_int32_t = uint32_t /* types.h:95:18 */
type u_int64_t = uint64_t /* types.h:96:18 */

//	$NetBSD: endian.h,v 1.1 2003/04/26 18:39:40 fvdl Exp $

//	$NetBSD: endian.h,v 1.30 2016/02/27 21:37:35 christos Exp $

// Copyright (c) 1987, 1991, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)endian.h	8.1 (Berkeley) 6/11/93

//	$NetBSD: featuretest.h,v 1.10 2013/04/26 18:29:06 christos Exp $

// Written by Klaus Klein <kleink@NetBSD.org>, February 2, 1998.
// Public domain.
//
// NOTE: Do not protect this header against multiple inclusion.  Doing
// so can have subtle side-effects due to header file inclusion order
// and testing of e.g. _POSIX_SOURCE vs. _POSIX_C_SOURCE.  Instead,
// protect each CPP macro that we want to supply.

// Feature-test macros are defined by several standards, and allow an
// application to specify what symbols they want the system headers to
// expose, and hence what standard they want them to conform to.
// There are two classes of feature-test macros.  The first class
// specify complete standards, and if one of these is defined, header
// files will try to conform to the relevant standard.  They are:
//
// ANSI macros:
// _ANSI_SOURCE			ANSI C89
//
// POSIX macros:
// _POSIX_SOURCE == 1		IEEE Std 1003.1 (version?)
// _POSIX_C_SOURCE == 1		IEEE Std 1003.1-1990
// _POSIX_C_SOURCE == 2		IEEE Std 1003.2-1992
// _POSIX_C_SOURCE == 199309L	IEEE Std 1003.1b-1993
// _POSIX_C_SOURCE == 199506L	ISO/IEC 9945-1:1996
// _POSIX_C_SOURCE == 200112L	IEEE Std 1003.1-2001
// _POSIX_C_SOURCE == 200809L   IEEE Std 1003.1-2008
//
// X/Open macros:
// _XOPEN_SOURCE		System Interfaces and Headers, Issue 4, Ver 2
// _XOPEN_SOURCE_EXTENDED == 1	XSH4.2 UNIX extensions
// _XOPEN_SOURCE == 500		System Interfaces and Headers, Issue 5
// _XOPEN_SOURCE == 520		Networking Services (XNS), Issue 5.2
// _XOPEN_SOURCE == 600		IEEE Std 1003.1-2001, XSI option
// _XOPEN_SOURCE == 700		IEEE Std 1003.1-2008, XSI option
//
// NetBSD macros:
// _NETBSD_SOURCE == 1		Make all NetBSD features available.
//
// If more than one of these "major" feature-test macros is defined,
// then the set of facilities provided (and namespace used) is the
// union of that specified by the relevant standards, and in case of
// conflict, the earlier standard in the above list has precedence (so
// if both _POSIX_C_SOURCE and _NETBSD_SOURCE are defined, the version
// of rename() that's used is the POSIX one).  If none of the "major"
// feature-test macros is defined, _NETBSD_SOURCE is assumed.
//
// There are also "minor" feature-test macros, which enable extra
// functionality in addition to some base standard.  They should be
// defined along with one of the "major" macros.  The "minor" macros
// are:
//
// _REENTRANT
// _ISOC99_SOURCE
// _ISOC11_SOURCE
// _LARGEFILE_SOURCE		Large File Support
//		<http://ftp.sas.com/standards/large.file/x_open.20Mar96.html>

// Definitions for byte order, according to byte significance from low
// address to high.

// C-family endian-ness definitions

//	$NetBSD: ansi.h,v 1.14 2011/07/17 20:54:54 joerg Exp $

// -
// Copyright (c) 2000, 2001, 2002 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Jun-ichiro itojun Hagino and by Klaus Klein.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

//	$NetBSD: cdefs.h,v 1.141 2019/02/21 21:34:05 christos Exp $

// * Copyright (c) 1991, 1993
//	The Regents of the University of California.  All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Berkeley Software Design, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)cdefs.h	8.8 (Berkeley) 1/9/95

//	$NetBSD: types.h,v 1.102 2018/11/06 16:26:44 maya Exp $

// -
// Copyright (c) 1982, 1986, 1991, 1993, 1994
//	The Regents of the University of California.  All rights reserved.
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)types.h	8.4 (Berkeley) 1/21/94

type in_addr_t = uint32 /* endian.h:58:21 */

type in_port_t = uint16 /* endian.h:63:21 */

func __byte_swap_u64_variable(tls *libc.TLS, x uint64_t) uint64_t { /* byte_swap.h:48:1: */
	panic(`/usr/include/machine/byte_swap.h:50:2: assembler statements not supported`)
	return x
}

func __byte_swap_u32_variable(tls *libc.TLS, x uint32_t) uint32_t { /* byte_swap.h:57:1: */
	panic(`/usr/include/machine/byte_swap.h:59:2: assembler statements not supported`)
	return x
}

func __byte_swap_u16_variable(tls *libc.TLS, x uint16_t) uint16_t { /* byte_swap.h:66:1: */
	panic(`/usr/include/machine/byte_swap.h:68:2: assembler statements not supported`)
	return x
}

//      $NetBSD: bswap.h,v 1.19 2015/03/12 15:28:16 christos Exp $

// Written by Manuel Bouyer. Public domain

//	$NetBSD: stdint.h,v 1.8 2018/11/06 16:26:44 maya Exp $

// -
// Copyright (c) 2001, 2004 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Klaus Klein.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

//	$NetBSD: cdefs.h,v 1.141 2019/02/21 21:34:05 christos Exp $

// * Copyright (c) 1991, 1993
//	The Regents of the University of California.  All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Berkeley Software Design, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)cdefs.h	8.8 (Berkeley) 1/9/95

//	$NetBSD: int_types.h,v 1.7 2014/07/25 21:43:13 joerg Exp $

// -
// Copyright (c) 1990 The Regents of the University of California.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	from: @(#)types.h	7.5 (Berkeley) 3/9/91

type intptr_t = int64 /* stdint.h:79:20 */

type uintptr_t = uint64 /* stdint.h:84:21 */

//	$NetBSD: int_mwgwtypes.h,v 1.8 2014/07/25 21:43:13 joerg Exp $

// -
// Copyright (c) 2001 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Klaus Klein.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

//	$NetBSD: common_int_mwgwtypes.h,v 1.1 2014/07/25 21:43:13 joerg Exp $

// -
// Copyright (c) 2014 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Joerg Sonnenberger.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

// 7.18.1 Integer types

// 7.18.1.2 Minimum-width integer types

type int_least8_t = int8     /* common_int_mwgwtypes.h:45:32 */
type uint_least8_t = uint8   /* common_int_mwgwtypes.h:46:32 */
type int_least16_t = int16   /* common_int_mwgwtypes.h:47:32 */
type uint_least16_t = uint16 /* common_int_mwgwtypes.h:48:32 */
type int_least32_t = int32   /* common_int_mwgwtypes.h:49:32 */
type uint_least32_t = uint32 /* common_int_mwgwtypes.h:50:32 */
type int_least64_t = int64   /* common_int_mwgwtypes.h:51:32 */
type uint_least64_t = uint64 /* common_int_mwgwtypes.h:52:32 */

// 7.18.1.3 Fastest minimum-width integer types
type int_fast8_t = int32    /* common_int_mwgwtypes.h:55:32 */
type uint_fast8_t = uint32  /* common_int_mwgwtypes.h:56:32 */
type int_fast16_t = int32   /* common_int_mwgwtypes.h:57:32 */
type uint_fast16_t = uint32 /* common_int_mwgwtypes.h:58:32 */
type int_fast32_t = int32   /* common_int_mwgwtypes.h:59:32 */
type uint_fast32_t = uint32 /* common_int_mwgwtypes.h:60:32 */
type int_fast64_t = int64   /* common_int_mwgwtypes.h:61:32 */
type uint_fast64_t = uint64 /* common_int_mwgwtypes.h:62:32 */

// 7.18.1.5 Greatest-width integer types

type intmax_t = int64   /* common_int_mwgwtypes.h:66:33 */
type uintmax_t = uint64 /* common_int_mwgwtypes.h:67:32 */

type u_char = uint8   /* types.h:101:23 */
type u_short = uint16 /* types.h:102:24 */
type u_int = uint32   /* types.h:103:22 */
type u_long = uint64  /* types.h:104:23 */

type unchar = uint8  /* types.h:106:23 */ // Sys V compatibility
type ushort = uint16 /* types.h:107:24 */ // Sys V compatibility
type uint = uint32   /* types.h:108:22 */ // Sys V compatibility
type ulong = uint64  /* types.h:109:23 */ // Sys V compatibility

type u_quad_t = uint64_t /* types.h:112:18 */ // quads
type quad_t = int64_t    /* types.h:113:18 */
type qaddr_t = uintptr   /* types.h:114:16 */

// The types longlong_t and u_longlong_t exist for use with the
// Sun-derived XDR routines involving these types, and their usage
// in other contexts is discouraged.  Further note that these types
// may not be equivalent to "long long" and "unsigned long long",
// they are only guaranteed to be signed and unsigned 64-bit types
// respectively.  Portable programs that need 64-bit types should use
// the C99 types int64_t and uint64_t instead.

type longlong_t = int64_t    /* types.h:126:18 */ // for XDR
type u_longlong_t = uint64_t /* types.h:127:18 */ // for XDR

type blkcnt_t = int64_t  /* types.h:129:18 */ // fs block count
type blksize_t = int32_t /* types.h:130:18 */ // fs optimal block size

type fsblkcnt_t = uint64 /* types.h:133:22 */ // fs block count (statvfs)

type fsfilcnt_t = uint64 /* types.h:138:22 */ // fs file count

// We don't and shouldn't use caddr_t in the kernel anymore
type caddr_t = uintptr /* types.h:145:19 */ // core address

type daddr_t = int64_t /* types.h:154:18 */ // disk address

type dev_t = uint64_t   /* types.h:157:18 */ // device number
type fixpt_t = uint32_t /* types.h:158:18 */ // fixed point number

type gid_t = uint32 /* types.h:161:18 */ // group id

type id_t = uint32_t  /* types.h:165:18 */ // group id, process id or user id
type ino_t = uint64_t /* types.h:166:18 */ // inode number
type key_t = int64    /* types.h:167:15 */ // IPC key (for Sys V IPC)

type mode_t = uint32 /* types.h:170:18 */ // permissions

type nlink_t = uint32_t /* types.h:174:18 */ // link count

type off_t = int64 /* types.h:177:18 */ // file offset

type pid_t = int32     /* types.h:182:18 */ // process id
type lwpid_t = int32_t /* types.h:185:18 */ // LWP id
type rlim_t = uint64_t /* types.h:186:18 */ // resource limit
type segsz_t = int32_t /* types.h:187:18 */ // segment size
type swblk_t = int32_t /* types.h:188:18 */ // swap offset

type uid_t = uint32 /* types.h:191:18 */ // user id

type mqd_t = int32 /* types.h:195:14 */

type cpuid_t = uint64 /* types.h:197:23 */

type psetid_t = int32 /* types.h:199:14 */

type clock_t = uint32 /* types.h:268:24 */

type ssize_t = int64 /* types.h:284:24 */

type time_t = int64 /* types.h:289:23 */

type clockid_t = int32 /* types.h:294:26 */

type timer_t = int32 /* types.h:299:24 */

type suseconds_t = int32 /* types.h:304:27 */

type useconds_t = uint32 /* types.h:309:26 */

// 32 = 2 ^ 5

// Select uses bit fields of file descriptors.  These macros manipulate
// such bit fields.  Note: FD_SETSIZE may be defined by the user.

type fd_set1 = struct{ fds_bits [8]uint32 } /* fd_set.h:66:9 */

// 32 = 2 ^ 5

// Select uses bit fields of file descriptors.  These macros manipulate
// such bit fields.  Note: FD_SETSIZE may be defined by the user.

type fd_set = fd_set1 /* fd_set.h:68:3 */

// Expose our internals if we are not required to hide them.

type kauth_cred_t = uintptr /* types.h:318:27 */

type pri_t = int32 /* types.h:320:13 */

//	$NetBSD: pthread_types.h,v 1.23 2017/09/09 23:21:45 kamil Exp $

// -
// Copyright (c) 2001, 2008 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Nathan J. Williams.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

// We use the "pthread_spin_t" name internally; "pthread_spinlock_t" is the
// POSIX spinlock object.
//
// C++ expects to be using PTHREAD_FOO_INITIALIZER as a member initializer.
// This does not work for volatile types.  Since C++ does not touch the guts
// of those types, we do not include volatile in the C++ definitions.
type pthread_spin_t = uint8 /* pthread_types.h:43:29 */

// Copied from PTQ_HEAD in pthread_queue.h

type pthread_queue_struct_t = struct {
	ptqh_first uintptr
	ptqh_last  uintptr
} /* pthread_types.h:61:1 */

type pthread_queue_t = pthread_queue_struct_t /* pthread_types.h:62:39 */
type __pthread_attr_st = struct {
	pta_magic   uint32
	pta_flags   int32
	pta_private uintptr
} /* pthread_types.h:65:1 */

type __pthread_mutex_st = struct {
	ptm_magic      uint32
	ptm_errorcheck uint8
	ptm_pad1       [3]uint8_t
	__8            struct{ ptm_ceiling uint8 }
	ptm_pad2       [3]uint8_t
	_              [4]byte
	ptm_owner      pthread_t
	ptm_waiters    uintptr
	ptm_recursed   uint32
	_              [4]byte
	ptm_spare2     uintptr
} /* pthread_types.h:66:1 */

type __pthread_mutexattr_st = struct {
	ptma_magic   uint32
	_            [4]byte
	ptma_private uintptr
} /* pthread_types.h:67:1 */

type __pthread_cond_st = struct {
	ptc_magic   uint32
	ptc_lock    uint8
	_           [3]byte
	ptc_waiters pthread_queue_t
	ptc_mutex   uintptr
	ptc_private uintptr
} /* pthread_types.h:68:1 */

type __pthread_condattr_st = struct {
	ptca_magic   uint32
	_            [4]byte
	ptca_private uintptr
} /* pthread_types.h:69:1 */

type __pthread_rwlock_st = struct {
	ptr_magic     uint32
	ptr_interlock uint8
	_             [3]byte
	ptr_rblocked  pthread_queue_t
	ptr_wblocked  pthread_queue_t
	ptr_nreaders  uint32
	_             [4]byte
	ptr_owner     pthread_t
	ptr_private   uintptr
} /* pthread_types.h:71:1 */

type __pthread_rwlockattr_st = struct {
	ptra_magic   uint32
	_            [4]byte
	ptra_private uintptr
} /* pthread_types.h:72:1 */

type __pthread_barrier_st = struct {
	ptb_magic      uint32
	ptb_lock       pthread_spin_t
	_              [3]byte
	ptb_waiters    pthread_queue_t
	ptb_initcount  uint32
	ptb_curcount   uint32
	ptb_generation uint32
	_              [4]byte
	ptb_private    uintptr
} /* pthread_types.h:73:1 */

type __pthread_barrierattr_st = struct {
	ptba_magic   uint32
	_            [4]byte
	ptba_private uintptr
} /* pthread_types.h:74:1 */

type pthread_t = uintptr                          /* pthread_types.h:76:29 */
type pthread_attr_t = __pthread_attr_st           /* pthread_types.h:77:34 */
type pthread_mutex_t = __pthread_mutex_st         /* pthread_types.h:78:35 */
type pthread_mutexattr_t = __pthread_mutexattr_st /* pthread_types.h:79:39 */
type pthread_cond_t = __pthread_cond_st           /* pthread_types.h:80:34 */
type pthread_condattr_t = __pthread_condattr_st   /* pthread_types.h:81:38 */
type __pthread_once_st = struct {
	pto_mutex pthread_mutex_t
	pto_done  int32
	_         [4]byte
} /* pthread_types.h:82:9 */

type pthread_once_t = __pthread_once_st /* pthread_types.h:82:34 */
type __pthread_spinlock_st = struct {
	pts_magic uint32
	pts_spin  uint8
	_         [3]byte
	pts_flags int32
} /* pthread_types.h:83:9 */

type pthread_spinlock_t = __pthread_spinlock_st       /* pthread_types.h:83:38 */
type pthread_rwlock_t = __pthread_rwlock_st           /* pthread_types.h:84:36 */
type pthread_rwlockattr_t = __pthread_rwlockattr_st   /* pthread_types.h:85:40 */
type pthread_barrier_t = __pthread_barrier_st         /* pthread_types.h:86:37 */
type pthread_barrierattr_t = __pthread_barrierattr_st /* pthread_types.h:87:41 */
type pthread_key_t = int32                            /* pthread_types.h:88:13 */

//	$NetBSD: stat.h,v 1.68 2013/10/17 18:01:11 njoly Exp $

// -
// Copyright (c) 1982, 1986, 1989, 1993
//	The Regents of the University of California.  All rights reserved.
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)stat.h	8.12 (Berkeley) 8/17/94

//	$NetBSD: featuretest.h,v 1.10 2013/04/26 18:29:06 christos Exp $

// Written by Klaus Klein <kleink@NetBSD.org>, February 2, 1998.
// Public domain.
//
// NOTE: Do not protect this header against multiple inclusion.  Doing
// so can have subtle side-effects due to header file inclusion order
// and testing of e.g. _POSIX_SOURCE vs. _POSIX_C_SOURCE.  Instead,
// protect each CPP macro that we want to supply.

// Feature-test macros are defined by several standards, and allow an
// application to specify what symbols they want the system headers to
// expose, and hence what standard they want them to conform to.
// There are two classes of feature-test macros.  The first class
// specify complete standards, and if one of these is defined, header
// files will try to conform to the relevant standard.  They are:
//
// ANSI macros:
// _ANSI_SOURCE			ANSI C89
//
// POSIX macros:
// _POSIX_SOURCE == 1		IEEE Std 1003.1 (version?)
// _POSIX_C_SOURCE == 1		IEEE Std 1003.1-1990
// _POSIX_C_SOURCE == 2		IEEE Std 1003.2-1992
// _POSIX_C_SOURCE == 199309L	IEEE Std 1003.1b-1993
// _POSIX_C_SOURCE == 199506L	ISO/IEC 9945-1:1996
// _POSIX_C_SOURCE == 200112L	IEEE Std 1003.1-2001
// _POSIX_C_SOURCE == 200809L   IEEE Std 1003.1-2008
//
// X/Open macros:
// _XOPEN_SOURCE		System Interfaces and Headers, Issue 4, Ver 2
// _XOPEN_SOURCE_EXTENDED == 1	XSH4.2 UNIX extensions
// _XOPEN_SOURCE == 500		System Interfaces and Headers, Issue 5
// _XOPEN_SOURCE == 520		Networking Services (XNS), Issue 5.2
// _XOPEN_SOURCE == 600		IEEE Std 1003.1-2001, XSI option
// _XOPEN_SOURCE == 700		IEEE Std 1003.1-2008, XSI option
//
// NetBSD macros:
// _NETBSD_SOURCE == 1		Make all NetBSD features available.
//
// If more than one of these "major" feature-test macros is defined,
// then the set of facilities provided (and namespace used) is the
// union of that specified by the relevant standards, and in case of
// conflict, the earlier standard in the above list has precedence (so
// if both _POSIX_C_SOURCE and _NETBSD_SOURCE are defined, the version
// of rename() that's used is the POSIX one).  If none of the "major"
// feature-test macros is defined, _NETBSD_SOURCE is assumed.
//
// There are also "minor" feature-test macros, which enable extra
// functionality in addition to some base standard.  They should be
// defined along with one of the "major" macros.  The "minor" macros
// are:
//
// _REENTRANT
// _ISOC99_SOURCE
// _ISOC11_SOURCE
// _LARGEFILE_SOURCE		Large File Support
//		<http://ftp.sas.com/standards/large.file/x_open.20Mar96.html>

//	$NetBSD: types.h,v 1.102 2018/11/06 16:26:44 maya Exp $

// -
// Copyright (c) 1982, 1986, 1991, 1993, 1994
//	The Regents of the University of California.  All rights reserved.
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)types.h	8.4 (Berkeley) 1/21/94

// POSIX:2008 / XPG7 requires struct timespec to be declared in
// this header, but does not provide the usual exemption
// "inclusion of this header may make visible symbols defined in <time.h>".
//
// This is a Standard omission, acknowledged by the committee and
// scheduled to be corrected in Technical Corrigendum 2, according to
// http://austingroupbugs.net/view.php?id=531
//	$NetBSD: time.h,v 1.79 2017/01/17 15:28:34 maya Exp $

// Copyright (c) 1982, 1986, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)time.h	8.5 (Berkeley) 5/4/95

//	$NetBSD: featuretest.h,v 1.10 2013/04/26 18:29:06 christos Exp $

// Written by Klaus Klein <kleink@NetBSD.org>, February 2, 1998.
// Public domain.
//
// NOTE: Do not protect this header against multiple inclusion.  Doing
// so can have subtle side-effects due to header file inclusion order
// and testing of e.g. _POSIX_SOURCE vs. _POSIX_C_SOURCE.  Instead,
// protect each CPP macro that we want to supply.

// Feature-test macros are defined by several standards, and allow an
// application to specify what symbols they want the system headers to
// expose, and hence what standard they want them to conform to.
// There are two classes of feature-test macros.  The first class
// specify complete standards, and if one of these is defined, header
// files will try to conform to the relevant standard.  They are:
//
// ANSI macros:
// _ANSI_SOURCE			ANSI C89
//
// POSIX macros:
// _POSIX_SOURCE == 1		IEEE Std 1003.1 (version?)
// _POSIX_C_SOURCE == 1		IEEE Std 1003.1-1990
// _POSIX_C_SOURCE == 2		IEEE Std 1003.2-1992
// _POSIX_C_SOURCE == 199309L	IEEE Std 1003.1b-1993
// _POSIX_C_SOURCE == 199506L	ISO/IEC 9945-1:1996
// _POSIX_C_SOURCE == 200112L	IEEE Std 1003.1-2001
// _POSIX_C_SOURCE == 200809L   IEEE Std 1003.1-2008
//
// X/Open macros:
// _XOPEN_SOURCE		System Interfaces and Headers, Issue 4, Ver 2
// _XOPEN_SOURCE_EXTENDED == 1	XSH4.2 UNIX extensions
// _XOPEN_SOURCE == 500		System Interfaces and Headers, Issue 5
// _XOPEN_SOURCE == 520		Networking Services (XNS), Issue 5.2
// _XOPEN_SOURCE == 600		IEEE Std 1003.1-2001, XSI option
// _XOPEN_SOURCE == 700		IEEE Std 1003.1-2008, XSI option
//
// NetBSD macros:
// _NETBSD_SOURCE == 1		Make all NetBSD features available.
//
// If more than one of these "major" feature-test macros is defined,
// then the set of facilities provided (and namespace used) is the
// union of that specified by the relevant standards, and in case of
// conflict, the earlier standard in the above list has precedence (so
// if both _POSIX_C_SOURCE and _NETBSD_SOURCE are defined, the version
// of rename() that's used is the POSIX one).  If none of the "major"
// feature-test macros is defined, _NETBSD_SOURCE is assumed.
//
// There are also "minor" feature-test macros, which enable extra
// functionality in addition to some base standard.  They should be
// defined along with one of the "major" macros.  The "minor" macros
// are:
//
// _REENTRANT
// _ISOC99_SOURCE
// _ISOC11_SOURCE
// _LARGEFILE_SOURCE		Large File Support
//		<http://ftp.sas.com/standards/large.file/x_open.20Mar96.html>

//	$NetBSD: types.h,v 1.102 2018/11/06 16:26:44 maya Exp $

// -
// Copyright (c) 1982, 1986, 1991, 1993, 1994
//	The Regents of the University of California.  All rights reserved.
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)types.h	8.4 (Berkeley) 1/21/94

// Structure returned by gettimeofday(2) system call,
// and used in other calls.
type timeval = struct {
	tv_sec  time_t
	tv_usec suseconds_t
	_       [4]byte
} /* time.h:44:1 */

//	$NetBSD: timespec.h,v 1.1 2015/07/31 12:51:32 kamil Exp $

// Copyright (c) 1982, 1986, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)time.h	8.5 (Berkeley) 5/4/95
//
// Extracted by Kamil Rytarowski from:
// NetBSD: src/sys/sys/time.h,v 1.69 2015/05/19 23:35:11 riastradh Exp

//	$NetBSD: ansi.h,v 1.14 2011/07/17 20:54:54 joerg Exp $

// -
// Copyright (c) 2000, 2001, 2002 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Jun-ichiro itojun Hagino and by Klaus Klein.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

type timespec = struct {
	tv_sec  time_t
	tv_nsec int64
} /* timespec.h:47:1 */

// Note: timezone is obsolete. All timezone handling is now in
// userland. Its just here for back compatibility.
type timezone = struct {
	tz_minuteswest int32
	tz_dsttime     int32
} /* time.h:65:1 */

// Operations on timevals.

// hide bintime for _STANDALONE because this header is used for hpcboot.exe,
// which is built with compilers which don't recognize LL suffix.
//
//	http://mail-index.NetBSD.org/tech-userlevel/2008/02/27/msg000181.html
type bintime = struct {
	sec  time_t
	frac uint64_t
} /* time.h:102:1 */

// Operations on timespecs.

// Names of the interval timers, and structure
// defining a timer setting.
// NB: Must match the CLOCK_ constants below.

type itimerval = struct {
	it_interval struct {
		tv_sec  time_t
		tv_usec suseconds_t
		_       [4]byte
	}
	it_value struct {
		tv_sec  time_t
		tv_usec suseconds_t
		_       [4]byte
	}
} /* time.h:280:1 */

// Structure defined by POSIX.1b to be like a itimerval, but with
// timespecs. Used in the timer_*() system calls.
type itimerspec = struct {
	it_interval struct {
		tv_sec  time_t
		tv_nsec int64
	}
	it_value struct {
		tv_sec  time_t
		tv_nsec int64
	}
} /* time.h:289:1 */

//	$NetBSD: select.h,v 1.37 2014/04/25 15:52:45 pooka Exp $

// -
// Copyright (c) 1992, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)select.h	8.2 (Berkeley) 1/4/94

//	$NetBSD: cdefs.h,v 1.141 2019/02/21 21:34:05 christos Exp $

// * Copyright (c) 1991, 1993
//	The Regents of the University of California.  All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Berkeley Software Design, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)cdefs.h	8.8 (Berkeley) 1/9/95

//	$NetBSD: featuretest.h,v 1.10 2013/04/26 18:29:06 christos Exp $

// Written by Klaus Klein <kleink@NetBSD.org>, February 2, 1998.
// Public domain.
//
// NOTE: Do not protect this header against multiple inclusion.  Doing
// so can have subtle side-effects due to header file inclusion order
// and testing of e.g. _POSIX_SOURCE vs. _POSIX_C_SOURCE.  Instead,
// protect each CPP macro that we want to supply.

// Feature-test macros are defined by several standards, and allow an
// application to specify what symbols they want the system headers to
// expose, and hence what standard they want them to conform to.
// There are two classes of feature-test macros.  The first class
// specify complete standards, and if one of these is defined, header
// files will try to conform to the relevant standard.  They are:
//
// ANSI macros:
// _ANSI_SOURCE			ANSI C89
//
// POSIX macros:
// _POSIX_SOURCE == 1		IEEE Std 1003.1 (version?)
// _POSIX_C_SOURCE == 1		IEEE Std 1003.1-1990
// _POSIX_C_SOURCE == 2		IEEE Std 1003.2-1992
// _POSIX_C_SOURCE == 199309L	IEEE Std 1003.1b-1993
// _POSIX_C_SOURCE == 199506L	ISO/IEC 9945-1:1996
// _POSIX_C_SOURCE == 200112L	IEEE Std 1003.1-2001
// _POSIX_C_SOURCE == 200809L   IEEE Std 1003.1-2008
//
// X/Open macros:
// _XOPEN_SOURCE		System Interfaces and Headers, Issue 4, Ver 2
// _XOPEN_SOURCE_EXTENDED == 1	XSH4.2 UNIX extensions
// _XOPEN_SOURCE == 500		System Interfaces and Headers, Issue 5
// _XOPEN_SOURCE == 520		Networking Services (XNS), Issue 5.2
// _XOPEN_SOURCE == 600		IEEE Std 1003.1-2001, XSI option
// _XOPEN_SOURCE == 700		IEEE Std 1003.1-2008, XSI option
//
// NetBSD macros:
// _NETBSD_SOURCE == 1		Make all NetBSD features available.
//
// If more than one of these "major" feature-test macros is defined,
// then the set of facilities provided (and namespace used) is the
// union of that specified by the relevant standards, and in case of
// conflict, the earlier standard in the above list has precedence (so
// if both _POSIX_C_SOURCE and _NETBSD_SOURCE are defined, the version
// of rename() that's used is the POSIX one).  If none of the "major"
// feature-test macros is defined, _NETBSD_SOURCE is assumed.
//
// There are also "minor" feature-test macros, which enable extra
// functionality in addition to some base standard.  They should be
// defined along with one of the "major" macros.  The "minor" macros
// are:
//
// _REENTRANT
// _ISOC99_SOURCE
// _ISOC11_SOURCE
// _LARGEFILE_SOURCE		Large File Support
//		<http://ftp.sas.com/standards/large.file/x_open.20Mar96.html>

//	$NetBSD: fd_set.h,v 1.7 2018/06/24 12:05:40 kamil Exp $

// -
// Copyright (c) 1992, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	from: @(#)types.h	8.4 (Berkeley) 1/21/94

//	$NetBSD: sigtypes.h,v 1.11 2017/01/12 18:29:14 christos Exp $

// Copyright (c) 1982, 1986, 1989, 1991, 1993
//	The Regents of the University of California.  All rights reserved.
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)signal.h	8.4 (Berkeley) 5/4/95

// This header file defines various signal-related types.  We also keep
// the macros to manipulate sigset_t here, to encapsulate knowledge of
// its internals.

//	$NetBSD: featuretest.h,v 1.10 2013/04/26 18:29:06 christos Exp $

// Written by Klaus Klein <kleink@NetBSD.org>, February 2, 1998.
// Public domain.
//
// NOTE: Do not protect this header against multiple inclusion.  Doing
// so can have subtle side-effects due to header file inclusion order
// and testing of e.g. _POSIX_SOURCE vs. _POSIX_C_SOURCE.  Instead,
// protect each CPP macro that we want to supply.

// Feature-test macros are defined by several standards, and allow an
// application to specify what symbols they want the system headers to
// expose, and hence what standard they want them to conform to.
// There are two classes of feature-test macros.  The first class
// specify complete standards, and if one of these is defined, header
// files will try to conform to the relevant standard.  They are:
//
// ANSI macros:
// _ANSI_SOURCE			ANSI C89
//
// POSIX macros:
// _POSIX_SOURCE == 1		IEEE Std 1003.1 (version?)
// _POSIX_C_SOURCE == 1		IEEE Std 1003.1-1990
// _POSIX_C_SOURCE == 2		IEEE Std 1003.2-1992
// _POSIX_C_SOURCE == 199309L	IEEE Std 1003.1b-1993
// _POSIX_C_SOURCE == 199506L	ISO/IEC 9945-1:1996
// _POSIX_C_SOURCE == 200112L	IEEE Std 1003.1-2001
// _POSIX_C_SOURCE == 200809L   IEEE Std 1003.1-2008
//
// X/Open macros:
// _XOPEN_SOURCE		System Interfaces and Headers, Issue 4, Ver 2
// _XOPEN_SOURCE_EXTENDED == 1	XSH4.2 UNIX extensions
// _XOPEN_SOURCE == 500		System Interfaces and Headers, Issue 5
// _XOPEN_SOURCE == 520		Networking Services (XNS), Issue 5.2
// _XOPEN_SOURCE == 600		IEEE Std 1003.1-2001, XSI option
// _XOPEN_SOURCE == 700		IEEE Std 1003.1-2008, XSI option
//
// NetBSD macros:
// _NETBSD_SOURCE == 1		Make all NetBSD features available.
//
// If more than one of these "major" feature-test macros is defined,
// then the set of facilities provided (and namespace used) is the
// union of that specified by the relevant standards, and in case of
// conflict, the earlier standard in the above list has precedence (so
// if both _POSIX_C_SOURCE and _NETBSD_SOURCE are defined, the version
// of rename() that's used is the POSIX one).  If none of the "major"
// feature-test macros is defined, _NETBSD_SOURCE is assumed.
//
// There are also "minor" feature-test macros, which enable extra
// functionality in addition to some base standard.  They should be
// defined along with one of the "major" macros.  The "minor" macros
// are:
//
// _REENTRANT
// _ISOC99_SOURCE
// _ISOC11_SOURCE
// _LARGEFILE_SOURCE		Large File Support
//		<http://ftp.sas.com/standards/large.file/x_open.20Mar96.html>

//	$NetBSD: int_types.h,v 1.7 2014/07/25 21:43:13 joerg Exp $

// -
// Copyright (c) 1990 The Regents of the University of California.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	from: @(#)types.h	7.5 (Berkeley) 3/9/91

//	$NetBSD: ansi.h,v 1.11 2019/05/07 03:49:26 kamil Exp $

//	$NetBSD: common_ansi.h,v 1.1 2014/08/19 07:27:31 matt Exp $

// -
// Copyright (c) 2014 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Matt Thomas of 3am Software Foundry.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

type sigset_t = struct{ __bits [4]uint32 } /* sigtypes.h:62:3 */

// Macro for manipulating signal masks.

type sigaltstack = struct {
	ss_sp    uintptr
	ss_size  size_t
	ss_flags int32
	_        [4]byte
} /* sigtypes.h:108:9 */

// Macro for manipulating signal masks.

type stack_t = sigaltstack /* sigtypes.h:116:3 */

//	$NetBSD: time.h,v 1.47 2016/10/04 09:41:41 kamil Exp $

// Copyright (c) 1989, 1993
//	The Regents of the University of California.  All rights reserved.
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)time.h	8.3 (Berkeley) 1/21/94

//	$NetBSD: cdefs.h,v 1.141 2019/02/21 21:34:05 christos Exp $

// * Copyright (c) 1991, 1993
//	The Regents of the University of California.  All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Berkeley Software Design, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)cdefs.h	8.8 (Berkeley) 1/9/95

//	$NetBSD: featuretest.h,v 1.10 2013/04/26 18:29:06 christos Exp $

// Written by Klaus Klein <kleink@NetBSD.org>, February 2, 1998.
// Public domain.
//
// NOTE: Do not protect this header against multiple inclusion.  Doing
// so can have subtle side-effects due to header file inclusion order
// and testing of e.g. _POSIX_SOURCE vs. _POSIX_C_SOURCE.  Instead,
// protect each CPP macro that we want to supply.

// Feature-test macros are defined by several standards, and allow an
// application to specify what symbols they want the system headers to
// expose, and hence what standard they want them to conform to.
// There are two classes of feature-test macros.  The first class
// specify complete standards, and if one of these is defined, header
// files will try to conform to the relevant standard.  They are:
//
// ANSI macros:
// _ANSI_SOURCE			ANSI C89
//
// POSIX macros:
// _POSIX_SOURCE == 1		IEEE Std 1003.1 (version?)
// _POSIX_C_SOURCE == 1		IEEE Std 1003.1-1990
// _POSIX_C_SOURCE == 2		IEEE Std 1003.2-1992
// _POSIX_C_SOURCE == 199309L	IEEE Std 1003.1b-1993
// _POSIX_C_SOURCE == 199506L	ISO/IEC 9945-1:1996
// _POSIX_C_SOURCE == 200112L	IEEE Std 1003.1-2001
// _POSIX_C_SOURCE == 200809L   IEEE Std 1003.1-2008
//
// X/Open macros:
// _XOPEN_SOURCE		System Interfaces and Headers, Issue 4, Ver 2
// _XOPEN_SOURCE_EXTENDED == 1	XSH4.2 UNIX extensions
// _XOPEN_SOURCE == 500		System Interfaces and Headers, Issue 5
// _XOPEN_SOURCE == 520		Networking Services (XNS), Issue 5.2
// _XOPEN_SOURCE == 600		IEEE Std 1003.1-2001, XSI option
// _XOPEN_SOURCE == 700		IEEE Std 1003.1-2008, XSI option
//
// NetBSD macros:
// _NETBSD_SOURCE == 1		Make all NetBSD features available.
//
// If more than one of these "major" feature-test macros is defined,
// then the set of facilities provided (and namespace used) is the
// union of that specified by the relevant standards, and in case of
// conflict, the earlier standard in the above list has precedence (so
// if both _POSIX_C_SOURCE and _NETBSD_SOURCE are defined, the version
// of rename() that's used is the POSIX one).  If none of the "major"
// feature-test macros is defined, _NETBSD_SOURCE is assumed.
//
// There are also "minor" feature-test macros, which enable extra
// functionality in addition to some base standard.  They should be
// defined along with one of the "major" macros.  The "minor" macros
// are:
//
// _REENTRANT
// _ISOC99_SOURCE
// _ISOC11_SOURCE
// _LARGEFILE_SOURCE		Large File Support
//		<http://ftp.sas.com/standards/large.file/x_open.20Mar96.html>

//	$NetBSD: ansi.h,v 1.11 2019/05/07 03:49:26 kamil Exp $

//	$NetBSD: common_ansi.h,v 1.1 2014/08/19 07:27:31 matt Exp $

// -
// Copyright (c) 2014 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Matt Thomas of 3am Software Foundry.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

//	$NetBSD: null.h,v 1.9 2010/07/06 11:56:20 kleink Exp $

// Written by Klaus Klein <kleink@NetBSD.org>, December 22, 1999.
// Public domain.

type tm = struct {
	tm_sec    int32
	tm_min    int32
	tm_hour   int32
	tm_mday   int32
	tm_mon    int32
	tm_year   int32
	tm_wday   int32
	tm_yday   int32
	tm_isdst  int32
	_         [4]byte
	tm_gmtoff int64
	tm_zone   uintptr
} /* time.h:75:1 */

// ISO/IEC 9899:201x 7.27.1/3 Components of time
//	$NetBSD: timespec.h,v 1.1 2015/07/31 12:51:32 kamil Exp $

// Copyright (c) 1982, 1986, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)time.h	8.5 (Berkeley) 5/4/95
//
// Extracted by Kamil Rytarowski from:
// NetBSD: src/sys/sys/time.h,v 1.69 2015/05/19 23:35:11 riastradh Exp

//	$NetBSD: time.h,v 1.79 2017/01/17 15:28:34 maya Exp $

// Copyright (c) 1982, 1986, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)time.h	8.5 (Berkeley) 5/4/95

type sigevent = struct {
	sigev_notify int32
	sigev_signo  int32
	sigev_value  struct {
		_         [0]uint64
		sival_int int32
		_         [4]byte
	}
	sigev_notify_function   uintptr
	sigev_notify_attributes uintptr
} /* time.h:146:1 */

//	$NetBSD: idtype.h,v 1.5 2016/04/09 17:02:51 riastradh Exp $

// -
// Copyright (c) 2016 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Christos Zoulas.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

// Using the solaris constants, some of them are not applicable to us
// Do not re-order the list, or add elements in the middle as this will
// break the ABI of the system calls using this.  We set a high private
// maximum so that new values can be added in the future without
// changing the width of the type.
type idtype_t = int32 /* idtype.h:60:3 */

type timezone_t = uintptr /* time.h:198:24 */

type stat = struct {
	st_dev   dev_t
	st_mode  uint32
	_        [4]byte
	st_ino   ino_t
	st_nlink nlink_t
	st_uid   uint32
	st_gid   uint32
	_        [4]byte
	st_rdev  dev_t
	st_atim  struct {
		tv_sec  time_t
		tv_nsec int64
	}
	st_mtim struct {
		tv_sec  time_t
		tv_nsec int64
	}
	st_ctim struct {
		tv_sec  time_t
		tv_nsec int64
	}
	st_birthtim struct {
		tv_sec  time_t
		tv_nsec int64
	}
	st_size    int64
	st_blocks  blkcnt_t
	st_blksize blksize_t
	st_flags   uint32_t
	st_gen     uint32_t
	st_spare   [2]uint32_t
	_          [4]byte
} /* stat.h:59:1 */

//	$NetBSD: file.h,v 1.85 2019/05/08 13:40:19 isaki Exp $

// -
// Copyright (c) 2009 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Andrew Doran.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

// Copyright (c) 1982, 1986, 1989, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)file.h	8.3 (Berkeley) 1/9/95

//	$NetBSD: fcntl.h,v 1.50 2018/02/20 18:20:05 kamil Exp $

// -
// Copyright (c) 1983, 1990, 1993
//	The Regents of the University of California.  All rights reserved.
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)fcntl.h	8.3 (Berkeley) 1/21/94

// This file includes the definitions for open and fcntl
// described by POSIX for <fcntl.h>; it also includes
// related kernel definitions.

//	$NetBSD: featuretest.h,v 1.10 2013/04/26 18:29:06 christos Exp $

// Written by Klaus Klein <kleink@NetBSD.org>, February 2, 1998.
// Public domain.
//
// NOTE: Do not protect this header against multiple inclusion.  Doing
// so can have subtle side-effects due to header file inclusion order
// and testing of e.g. _POSIX_SOURCE vs. _POSIX_C_SOURCE.  Instead,
// protect each CPP macro that we want to supply.

// Feature-test macros are defined by several standards, and allow an
// application to specify what symbols they want the system headers to
// expose, and hence what standard they want them to conform to.
// There are two classes of feature-test macros.  The first class
// specify complete standards, and if one of these is defined, header
// files will try to conform to the relevant standard.  They are:
//
// ANSI macros:
// _ANSI_SOURCE			ANSI C89
//
// POSIX macros:
// _POSIX_SOURCE == 1		IEEE Std 1003.1 (version?)
// _POSIX_C_SOURCE == 1		IEEE Std 1003.1-1990
// _POSIX_C_SOURCE == 2		IEEE Std 1003.2-1992
// _POSIX_C_SOURCE == 199309L	IEEE Std 1003.1b-1993
// _POSIX_C_SOURCE == 199506L	ISO/IEC 9945-1:1996
// _POSIX_C_SOURCE == 200112L	IEEE Std 1003.1-2001
// _POSIX_C_SOURCE == 200809L   IEEE Std 1003.1-2008
//
// X/Open macros:
// _XOPEN_SOURCE		System Interfaces and Headers, Issue 4, Ver 2
// _XOPEN_SOURCE_EXTENDED == 1	XSH4.2 UNIX extensions
// _XOPEN_SOURCE == 500		System Interfaces and Headers, Issue 5
// _XOPEN_SOURCE == 520		Networking Services (XNS), Issue 5.2
// _XOPEN_SOURCE == 600		IEEE Std 1003.1-2001, XSI option
// _XOPEN_SOURCE == 700		IEEE Std 1003.1-2008, XSI option
//
// NetBSD macros:
// _NETBSD_SOURCE == 1		Make all NetBSD features available.
//
// If more than one of these "major" feature-test macros is defined,
// then the set of facilities provided (and namespace used) is the
// union of that specified by the relevant standards, and in case of
// conflict, the earlier standard in the above list has precedence (so
// if both _POSIX_C_SOURCE and _NETBSD_SOURCE are defined, the version
// of rename() that's used is the POSIX one).  If none of the "major"
// feature-test macros is defined, _NETBSD_SOURCE is assumed.
//
// There are also "minor" feature-test macros, which enable extra
// functionality in addition to some base standard.  They should be
// defined along with one of the "major" macros.  The "minor" macros
// are:
//
// _REENTRANT
// _ISOC99_SOURCE
// _ISOC11_SOURCE
// _LARGEFILE_SOURCE		Large File Support
//		<http://ftp.sas.com/standards/large.file/x_open.20Mar96.html>

//	$NetBSD: types.h,v 1.102 2018/11/06 16:26:44 maya Exp $

// -
// Copyright (c) 1982, 1986, 1991, 1993, 1994
//	The Regents of the University of California.  All rights reserved.
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)types.h	8.4 (Berkeley) 1/21/94

// File status flags: these are used by open(2), fcntl(2).
// They are also used (indirectly) in the kernel file structure f_flags,
// which is a superset of the open/fcntl flags.  Open flags and f_flags
// are inter-convertible using OFLAGS(fflags) and FFLAGS(oflags).
// Open/fcntl flags begin with O_; kernel-internal flags begin with F.
// open-only flags

// Kernel encoding of open mode; separate read and write bits that are
// independently testable: 1 greater than the above.
//
// XXX
// FREAD and FWRITE are excluded from the #ifdef _KERNEL so that TIOCFLUSH,
// which was documented to use FREAD/FWRITE, continues to work.
// path component

// defined by POSIX 1003.1; BSD default, but required to be bitwise distinct

// The O_* flags used to have only F* names, which were used in the kernel
// and by fcntl.  We retain the F* names for the kernel f_flags field
// and for backward compatibility for fcntl.

// Constants used for fcntl(2)

// command values

// file descriptor flags (F_GETFD, F_SETFD)

// record locking flags (F_GETLK, F_SETLK, F_SETLKW)

// Constants for fcntl's passed to the underlying fs - like ioctl's.

// Define command macros for operations which, if implemented, must be
// the same for all fs's.

// Define command macros for fs-specific commands.

// Advisory file segment locking data type -
// information passed to system by user
type flock = struct {
	l_start  int64
	l_len    int64
	l_pid    int32
	l_type   int16
	l_whence int16
} /* fcntl.h:252:1 */

//	$NetBSD: unistd.h,v 1.61 2016/08/04 06:43:43 christos Exp $

// Copyright (c) 1989, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)unistd.h	8.2 (Berkeley) 1/7/94

//	$NetBSD: featuretest.h,v 1.10 2013/04/26 18:29:06 christos Exp $

// Written by Klaus Klein <kleink@NetBSD.org>, February 2, 1998.
// Public domain.
//
// NOTE: Do not protect this header against multiple inclusion.  Doing
// so can have subtle side-effects due to header file inclusion order
// and testing of e.g. _POSIX_SOURCE vs. _POSIX_C_SOURCE.  Instead,
// protect each CPP macro that we want to supply.

// Feature-test macros are defined by several standards, and allow an
// application to specify what symbols they want the system headers to
// expose, and hence what standard they want them to conform to.
// There are two classes of feature-test macros.  The first class
// specify complete standards, and if one of these is defined, header
// files will try to conform to the relevant standard.  They are:
//
// ANSI macros:
// _ANSI_SOURCE			ANSI C89
//
// POSIX macros:
// _POSIX_SOURCE == 1		IEEE Std 1003.1 (version?)
// _POSIX_C_SOURCE == 1		IEEE Std 1003.1-1990
// _POSIX_C_SOURCE == 2		IEEE Std 1003.2-1992
// _POSIX_C_SOURCE == 199309L	IEEE Std 1003.1b-1993
// _POSIX_C_SOURCE == 199506L	ISO/IEC 9945-1:1996
// _POSIX_C_SOURCE == 200112L	IEEE Std 1003.1-2001
// _POSIX_C_SOURCE == 200809L   IEEE Std 1003.1-2008
//
// X/Open macros:
// _XOPEN_SOURCE		System Interfaces and Headers, Issue 4, Ver 2
// _XOPEN_SOURCE_EXTENDED == 1	XSH4.2 UNIX extensions
// _XOPEN_SOURCE == 500		System Interfaces and Headers, Issue 5
// _XOPEN_SOURCE == 520		Networking Services (XNS), Issue 5.2
// _XOPEN_SOURCE == 600		IEEE Std 1003.1-2001, XSI option
// _XOPEN_SOURCE == 700		IEEE Std 1003.1-2008, XSI option
//
// NetBSD macros:
// _NETBSD_SOURCE == 1		Make all NetBSD features available.
//
// If more than one of these "major" feature-test macros is defined,
// then the set of facilities provided (and namespace used) is the
// union of that specified by the relevant standards, and in case of
// conflict, the earlier standard in the above list has precedence (so
// if both _POSIX_C_SOURCE and _NETBSD_SOURCE are defined, the version
// of rename() that's used is the POSIX one).  If none of the "major"
// feature-test macros is defined, _NETBSD_SOURCE is assumed.
//
// There are also "minor" feature-test macros, which enable extra
// functionality in addition to some base standard.  They should be
// defined along with one of the "major" macros.  The "minor" macros
// are:
//
// _REENTRANT
// _ISOC99_SOURCE
// _ISOC11_SOURCE
// _LARGEFILE_SOURCE		Large File Support
//		<http://ftp.sas.com/standards/large.file/x_open.20Mar96.html>

// compile-time symbolic constants
// implementation supports job control

// According to POSIX 1003.1:
// "The saved set-user-ID capability allows a program to regain the
// effective user ID established at the last exec call."
// However, the setuid/setgid function as specified by POSIX 1003.1 does
// not allow changing the effective ID from the super-user without also
// changed the saved ID, so it is impossible to get super-user privileges
// back later.  Instead we provide this feature independent of the current
// effective ID through the seteuid/setegid function.  In addition, we do
// not use the saved ID as specified by POSIX 1003.1 in setuid/setgid,
// because this would make it impossible for a set-user-ID executable
// owned by a user other than the super-user to permanently revoke its
// extra privileges.

// We support the posix_spawn() family of functions (unconditionally).

// execution-time symbolic constants

// POSIX options and option groups we unconditionally do or don't
// implement.  Those options which are implemented (or not) entirely
// in user mode are defined in <unistd.h>.  Please keep this list in
// alphabetical order.
//
// Anything which is defined as zero below **must** have an
// implementation for the corresponding sysconf() which is able to
// determine conclusively whether or not the feature is supported.
// Anything which is defined as other than -1 below **must** have
// complete headers, types, and function declarations as specified by
// the POSIX standard; however, if the relevant sysconf() function
// returns -1, the functions may be stubbed out.
// Advisory information
// asynchronous I/O is available
// barriers
// chown requires correct privileges
// clock selection
// cputime clock
// CPU type
// file synchronization is available
// support IPv6
// job control is available
// memory mapped files
// memory locking whole address space
// memory locking address ranges
// memory access protections
// message passing is available
// monotonic clock
// too-long path comp generate errors
// prioritized I/O
// priority scheduling
// raw sockets
// read/write locks
// realtime signals
// regular expressions
// semaphores
// shared memory objects
// shell
// spin locks
// sporadic server
// synchronized I/O is available
// threads
// pthread_attr for stack size
// pthread_attr for stack address
// thread cputime clock
// _r functions
// PTHREAD_PRIO_PROTECT
// timeouts
// timers
// typed memory objects
// may disable terminal spec chars

// C binding

// XPG4.2 shared memory

// access function

// whence values for lseek(2)

// whence values for lseek(2); renamed by POSIX 1003.1

// fsync_range values.
//
// Note the following flag values were chosen to not overlap
// values for SEEK_XXX flags.  While not currently implemented,
// it is possible to extend this call to respect SEEK_CUR and
// SEEK_END offset addressing modes.

// configurable pathname variables; use as argument to pathconf(3)

// From OpenSolaris, used by SEEK_DATA/SEEK_HOLE.

// configurable system variables; use as argument to sysconf(3)
// XXX The value of _SC_CLK_TCK is embedded in <time.h>.
// XXX The value of _SC_PAGESIZE is embedded in <sys/shm.h>.

// Actually, they are not supported or implemented yet

// These are implemented

// Extensions found in Solaris and Linux.

// Commonly provided sysconf() extensions
// Native variables

// configurable system strings

// Descriptor types.

//	$NetBSD: param.h,v 1.599.2.10 2021/05/12 13:15:54 martin Exp $

// -
// Copyright (c) 1982, 1986, 1989, 1993
//	The Regents of the University of California.  All rights reserved.
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)param.h	8.3 (Berkeley) 4/4/95

// Historic BSD #defines -- probably will remain untouched for all time.

//	#define __NetBSD_Version__ MMmmrrpp00
//
//	M = major version
//	m = minor version; a minor number of 99 indicates current.
//	r = 0 (*)
//	p = patchlevel
//
// When new releases are made, src/gnu/usr.bin/groff/tmac/mdoc.local
// needs to be updated and the changes sent back to the groff maintainers.
//
// (*)	Up to 2.0I "release" used to be "",A-Z,Z[A-Z] but numeric
//	    	e.g. NetBSD-1.2D  = 102040000 ('D' == 4)
//	NetBSD-2.0H 	(200080000) was changed on 20041001 to:
//	2.99.9		(299000900)

// Historical NetBSD #define
//
// NetBSD 1.4 was the last release for which this value was incremented.
// The value is now permanently fixed at 199905. It will never be
// changed again.
//
// New code must use __NetBSD_Version__ instead, and should not even
// count on NetBSD being defined.
//

// These macros determine if we are running in protected mode or not.
//   _HARDKERNEL: code uses kernel namespace and runs in hw priviledged mode
//   _SOFTKERNEL: code uses kernel namespace but runs without hw priviledges

//	$NetBSD: null.h,v 1.9 2010/07/06 11:56:20 kleink Exp $

// Written by Klaus Klein <kleink@NetBSD.org>, December 22, 1999.
// Public domain.

//	$NetBSD: inttypes.h,v 1.6 2013/04/22 21:26:48 joerg Exp $

// -
// Copyright (c) 1998, 2000 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Klaus J. Klein.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

// 7.8  Format conversion of integer types

//	$NetBSD: stdint.h,v 1.8 2018/11/06 16:26:44 maya Exp $

// -
// Copyright (c) 2001, 2004 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Klaus Klein.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

//	$NetBSD: int_fmtio.h,v 1.7 2014/07/25 21:43:13 joerg Exp $

// -
// Copyright (c) 2001 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Klaus Klein.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

// 7.8.1 Macros for format specifiers

// fprintf macros for signed integers

// fprintf macros for unsigned integers

// fscanf macros for signed integers

// fscanf macros for unsigned integers

//	$NetBSD: types.h,v 1.102 2018/11/06 16:26:44 maya Exp $

// -
// Copyright (c) 1982, 1986, 1991, 1993, 1994
//	The Regents of the University of California.  All rights reserved.
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)types.h	8.4 (Berkeley) 1/21/94

// Machine-independent constants (some used in following include files).
// Redefined constants are from POSIX 1003.1 limits file.
//
// MAXCOMLEN should be >= sizeof(ac_comm) (see <acct.h>)
// MAXHOSTNAMELEN should be >= (_POSIX_HOST_NAME_MAX + 1) (see <limits.h>)
// MAXLOGNAME should be >= UT_NAMESIZE (see <utmp.h>)
//	$NetBSD: syslimits.h,v 1.28 2015/08/21 07:19:39 uebayasi Exp $

// Copyright (c) 1988, 1993
//	The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)syslimits.h	8.1 (Berkeley) 6/2/93

//	$NetBSD: featuretest.h,v 1.10 2013/04/26 18:29:06 christos Exp $

// Written by Klaus Klein <kleink@NetBSD.org>, February 2, 1998.
// Public domain.
//
// NOTE: Do not protect this header against multiple inclusion.  Doing
// so can have subtle side-effects due to header file inclusion order
// and testing of e.g. _POSIX_SOURCE vs. _POSIX_C_SOURCE.  Instead,
// protect each CPP macro that we want to supply.

// Feature-test macros are defined by several standards, and allow an
// application to specify what symbols they want the system headers to
// expose, and hence what standard they want them to conform to.
// There are two classes of feature-test macros.  The first class
// specify complete standards, and if one of these is defined, header
// files will try to conform to the relevant standard.  They are:
//
// ANSI macros:
// _ANSI_SOURCE			ANSI C89
//
// POSIX macros:
// _POSIX_SOURCE == 1		IEEE Std 1003.1 (version?)
// _POSIX_C_SOURCE == 1		IEEE Std 1003.1-1990
// _POSIX_C_SOURCE == 2		IEEE Std 1003.2-1992
// _POSIX_C_SOURCE == 199309L	IEEE Std 1003.1b-1993
// _POSIX_C_SOURCE == 199506L	ISO/IEC 9945-1:1996
// _POSIX_C_SOURCE == 200112L	IEEE Std 1003.1-2001
// _POSIX_C_SOURCE == 200809L   IEEE Std 1003.1-2008
//
// X/Open macros:
// _XOPEN_SOURCE		System Interfaces and Headers, Issue 4, Ver 2
// _XOPEN_SOURCE_EXTENDED == 1	XSH4.2 UNIX extensions
// _XOPEN_SOURCE == 500		System Interfaces and Headers, Issue 5
// _XOPEN_SOURCE == 520		Networking Services (XNS), Issue 5.2
// _XOPEN_SOURCE == 600		IEEE Std 1003.1-2001, XSI option
// _XOPEN_SOURCE == 700		IEEE Std 1003.1-2008, XSI option
//
// NetBSD macros:
// _NETBSD_SOURCE == 1		Make all NetBSD features available.
//
// If more than one of these "major" feature-test macros is defined,
// then the set of facilities provided (and namespace used) is the
// union of that specified by the relevant standards, and in case of
// conflict, the earlier standard in the above list has precedence (so
// if both _POSIX_C_SOURCE and _NETBSD_SOURCE are defined, the version
// of rename() that's used is the POSIX one).  If none of the "major"
// feature-test macros is defined, _NETBSD_SOURCE is assumed.
//
// There are also "minor" feature-test macros, which enable extra
// functionality in addition to some base standard.  They should be
// defined along with one of the "major" macros.  The "minor" macros
// are:
//
// _REENTRANT
// _ISOC99_SOURCE
// _ISOC11_SOURCE
// _LARGEFILE_SOURCE		Large File Support
//		<http://ftp.sas.com/standards/large.file/x_open.20Mar96.html>

// kept in sync with MAXNAMLEN

// IEEE Std 1003.1c-95, adopted in X/Open CAE Specification Issue 5 Version 2

// X/Open CAE Specification Issue 5 Version 2

// DEPRECATED: use LOGIN_NAME_MAX instead.

// Macros for min/max.

// More types and definitions used throughout the kernel.

// Signals.
//	$NetBSD: signal.h,v 1.72 2017/04/21 15:10:35 christos Exp $

// Copyright (c) 1982, 1986, 1989, 1991, 1993
//	The Regents of the University of California.  All rights reserved.
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)signal.h	8.4 (Berkeley) 5/4/95

//	$NetBSD: featuretest.h,v 1.10 2013/04/26 18:29:06 christos Exp $

// Written by Klaus Klein <kleink@NetBSD.org>, February 2, 1998.
// Public domain.
//
// NOTE: Do not protect this header against multiple inclusion.  Doing
// so can have subtle side-effects due to header file inclusion order
// and testing of e.g. _POSIX_SOURCE vs. _POSIX_C_SOURCE.  Instead,
// protect each CPP macro that we want to supply.

// Feature-test macros are defined by several standards, and allow an
// application to specify what symbols they want the system headers to
// expose, and hence what standard they want them to conform to.
// There are two classes of feature-test macros.  The first class
// specify complete standards, and if one of these is defined, header
// files will try to conform to the relevant standard.  They are:
//
// ANSI macros:
// _ANSI_SOURCE			ANSI C89
//
// POSIX macros:
// _POSIX_SOURCE == 1		IEEE Std 1003.1 (version?)
// _POSIX_C_SOURCE == 1		IEEE Std 1003.1-1990
// _POSIX_C_SOURCE == 2		IEEE Std 1003.2-1992
// _POSIX_C_SOURCE == 199309L	IEEE Std 1003.1b-1993
// _POSIX_C_SOURCE == 199506L	ISO/IEC 9945-1:1996
// _POSIX_C_SOURCE == 200112L	IEEE Std 1003.1-2001
// _POSIX_C_SOURCE == 200809L   IEEE Std 1003.1-2008
//
// X/Open macros:
// _XOPEN_SOURCE		System Interfaces and Headers, Issue 4, Ver 2
// _XOPEN_SOURCE_EXTENDED == 1	XSH4.2 UNIX extensions
// _XOPEN_SOURCE == 500		System Interfaces and Headers, Issue 5
// _XOPEN_SOURCE == 520		Networking Services (XNS), Issue 5.2
// _XOPEN_SOURCE == 600		IEEE Std 1003.1-2001, XSI option
// _XOPEN_SOURCE == 700		IEEE Std 1003.1-2008, XSI option
//
// NetBSD macros:
// _NETBSD_SOURCE == 1		Make all NetBSD features available.
//
// If more than one of these "major" feature-test macros is defined,
// then the set of facilities provided (and namespace used) is the
// union of that specified by the relevant standards, and in case of
// conflict, the earlier standard in the above list has precedence (so
// if both _POSIX_C_SOURCE and _NETBSD_SOURCE are defined, the version
// of rename() that's used is the POSIX one).  If none of the "major"
// feature-test macros is defined, _NETBSD_SOURCE is assumed.
//
// There are also "minor" feature-test macros, which enable extra
// functionality in addition to some base standard.  They should be
// defined along with one of the "major" macros.  The "minor" macros
// are:
//
// _REENTRANT
// _ISOC99_SOURCE
// _ISOC11_SOURCE
// _LARGEFILE_SOURCE		Large File Support
//		<http://ftp.sas.com/standards/large.file/x_open.20Mar96.html>

//	$NetBSD: sigtypes.h,v 1.11 2017/01/12 18:29:14 christos Exp $

// Copyright (c) 1982, 1986, 1989, 1991, 1993
//	The Regents of the University of California.  All rights reserved.
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)signal.h	8.4 (Berkeley) 5/4/95

//	$NetBSD: cdefs.h,v 1.141 2019/02/21 21:34:05 christos Exp $

// * Copyright (c) 1991, 1993
//	The Regents of the University of California.  All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Berkeley Software Design, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)cdefs.h	8.8 (Berkeley) 1/9/95

//	$NetBSD: siginfo.h,v 1.33.2.1 2019/10/15 18:32:13 martin Exp $

// -
// Copyright (c) 2002 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Christos Zoulas.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

//	$NetBSD: signal.h,v 1.12 2013/01/02 19:40:23 dsl Exp $

// Copyright (c) 1982, 1986, 1989, 1991 Regents of the University of California.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)signal.h	7.16 (Berkeley) 3/17/91

//	$NetBSD: featuretest.h,v 1.10 2013/04/26 18:29:06 christos Exp $

// Written by Klaus Klein <kleink@NetBSD.org>, February 2, 1998.
// Public domain.
//
// NOTE: Do not protect this header against multiple inclusion.  Doing
// so can have subtle side-effects due to header file inclusion order
// and testing of e.g. _POSIX_SOURCE vs. _POSIX_C_SOURCE.  Instead,
// protect each CPP macro that we want to supply.

// Feature-test macros are defined by several standards, and allow an
// application to specify what symbols they want the system headers to
// expose, and hence what standard they want them to conform to.
// There are two classes of feature-test macros.  The first class
// specify complete standards, and if one of these is defined, header
// files will try to conform to the relevant standard.  They are:
//
// ANSI macros:
// _ANSI_SOURCE			ANSI C89
//
// POSIX macros:
// _POSIX_SOURCE == 1		IEEE Std 1003.1 (version?)
// _POSIX_C_SOURCE == 1		IEEE Std 1003.1-1990
// _POSIX_C_SOURCE == 2		IEEE Std 1003.2-1992
// _POSIX_C_SOURCE == 199309L	IEEE Std 1003.1b-1993
// _POSIX_C_SOURCE == 199506L	ISO/IEC 9945-1:1996
// _POSIX_C_SOURCE == 200112L	IEEE Std 1003.1-2001
// _POSIX_C_SOURCE == 200809L   IEEE Std 1003.1-2008
//
// X/Open macros:
// _XOPEN_SOURCE		System Interfaces and Headers, Issue 4, Ver 2
// _XOPEN_SOURCE_EXTENDED == 1	XSH4.2 UNIX extensions
// _XOPEN_SOURCE == 500		System Interfaces and Headers, Issue 5
// _XOPEN_SOURCE == 520		Networking Services (XNS), Issue 5.2
// _XOPEN_SOURCE == 600		IEEE Std 1003.1-2001, XSI option
// _XOPEN_SOURCE == 700		IEEE Std 1003.1-2008, XSI option
//
// NetBSD macros:
// _NETBSD_SOURCE == 1		Make all NetBSD features available.
//
// If more than one of these "major" feature-test macros is defined,
// then the set of facilities provided (and namespace used) is the
// union of that specified by the relevant standards, and in case of
// conflict, the earlier standard in the above list has precedence (so
// if both _POSIX_C_SOURCE and _NETBSD_SOURCE are defined, the version
// of rename() that's used is the POSIX one).  If none of the "major"
// feature-test macros is defined, _NETBSD_SOURCE is assumed.
//
// There are also "minor" feature-test macros, which enable extra
// functionality in addition to some base standard.  They should be
// defined along with one of the "major" macros.  The "minor" macros
// are:
//
// _REENTRANT
// _ISOC99_SOURCE
// _ISOC11_SOURCE
// _LARGEFILE_SOURCE		Large File Support
//		<http://ftp.sas.com/standards/large.file/x_open.20Mar96.html>

type sig_atomic_t = int32 /* signal.h:41:13 */

type mcontext_t = struct {
	__gregs     [26]uint64
	_mc_tlsbase uint64
	__fpregs    [512]int8
} /* mcontext.h:65:3 */

//	$NetBSD: featuretest.h,v 1.10 2013/04/26 18:29:06 christos Exp $

// Written by Klaus Klein <kleink@NetBSD.org>, February 2, 1998.
// Public domain.
//
// NOTE: Do not protect this header against multiple inclusion.  Doing
// so can have subtle side-effects due to header file inclusion order
// and testing of e.g. _POSIX_SOURCE vs. _POSIX_C_SOURCE.  Instead,
// protect each CPP macro that we want to supply.

// Feature-test macros are defined by several standards, and allow an
// application to specify what symbols they want the system headers to
// expose, and hence what standard they want them to conform to.
// There are two classes of feature-test macros.  The first class
// specify complete standards, and if one of these is defined, header
// files will try to conform to the relevant standard.  They are:
//
// ANSI macros:
// _ANSI_SOURCE			ANSI C89
//
// POSIX macros:
// _POSIX_SOURCE == 1		IEEE Std 1003.1 (version?)
// _POSIX_C_SOURCE == 1		IEEE Std 1003.1-1990
// _POSIX_C_SOURCE == 2		IEEE Std 1003.2-1992
// _POSIX_C_SOURCE == 199309L	IEEE Std 1003.1b-1993
// _POSIX_C_SOURCE == 199506L	ISO/IEC 9945-1:1996
// _POSIX_C_SOURCE == 200112L	IEEE Std 1003.1-2001
// _POSIX_C_SOURCE == 200809L   IEEE Std 1003.1-2008
//
// X/Open macros:
// _XOPEN_SOURCE		System Interfaces and Headers, Issue 4, Ver 2
// _XOPEN_SOURCE_EXTENDED == 1	XSH4.2 UNIX extensions
// _XOPEN_SOURCE == 500		System Interfaces and Headers, Issue 5
// _XOPEN_SOURCE == 520		Networking Services (XNS), Issue 5.2
// _XOPEN_SOURCE == 600		IEEE Std 1003.1-2001, XSI option
// _XOPEN_SOURCE == 700		IEEE Std 1003.1-2008, XSI option
//
// NetBSD macros:
// _NETBSD_SOURCE == 1		Make all NetBSD features available.
//
// If more than one of these "major" feature-test macros is defined,
// then the set of facilities provided (and namespace used) is the
// union of that specified by the relevant standards, and in case of
// conflict, the earlier standard in the above list has precedence (so
// if both _POSIX_C_SOURCE and _NETBSD_SOURCE are defined, the version
// of rename() that's used is the POSIX one).  If none of the "major"
// feature-test macros is defined, _NETBSD_SOURCE is assumed.
//
// There are also "minor" feature-test macros, which enable extra
// functionality in addition to some base standard.  They should be
// defined along with one of the "major" macros.  The "minor" macros
// are:
//
// _REENTRANT
// _ISOC99_SOURCE
// _ISOC11_SOURCE
// _LARGEFILE_SOURCE		Large File Support
//		<http://ftp.sas.com/standards/large.file/x_open.20Mar96.html>

type sigval = struct {
	_         [0]uint64
	sival_int int32
	_         [4]byte
} /* time.h:146:1 */

//	$NetBSD: featuretest.h,v 1.10 2013/04/26 18:29:06 christos Exp $

// Written by Klaus Klein <kleink@NetBSD.org>, February 2, 1998.
// Public domain.
//
// NOTE: Do not protect this header against multiple inclusion.  Doing
// so can have subtle side-effects due to header file inclusion order
// and testing of e.g. _POSIX_SOURCE vs. _POSIX_C_SOURCE.  Instead,
// protect each CPP macro that we want to supply.

// Feature-test macros are defined by several standards, and allow an
// application to specify what symbols they want the system headers to
// expose, and hence what standard they want them to conform to.
// There are two classes of feature-test macros.  The first class
// specify complete standards, and if one of these is defined, header
// files will try to conform to the relevant standard.  They are:
//
// ANSI macros:
// _ANSI_SOURCE			ANSI C89
//
// POSIX macros:
// _POSIX_SOURCE == 1		IEEE Std 1003.1 (version?)
// _POSIX_C_SOURCE == 1		IEEE Std 1003.1-1990
// _POSIX_C_SOURCE == 2		IEEE Std 1003.2-1992
// _POSIX_C_SOURCE == 199309L	IEEE Std 1003.1b-1993
// _POSIX_C_SOURCE == 199506L	ISO/IEC 9945-1:1996
// _POSIX_C_SOURCE == 200112L	IEEE Std 1003.1-2001
// _POSIX_C_SOURCE == 200809L   IEEE Std 1003.1-2008
//
// X/Open macros:
// _XOPEN_SOURCE		System Interfaces and Headers, Issue 4, Ver 2
// _XOPEN_SOURCE_EXTENDED == 1	XSH4.2 UNIX extensions
// _XOPEN_SOURCE == 500		System Interfaces and Headers, Issue 5
// _XOPEN_SOURCE == 520		Networking Services (XNS), Issue 5.2
// _XOPEN_SOURCE == 600		IEEE Std 1003.1-2001, XSI option
// _XOPEN_SOURCE == 700		IEEE Std 1003.1-2008, XSI option
//
// NetBSD macros:
// _NETBSD_SOURCE == 1		Make all NetBSD features available.
//
// If more than one of these "major" feature-test macros is defined,
// then the set of facilities provided (and namespace used) is the
// union of that specified by the relevant standards, and in case of
// conflict, the earlier standard in the above list has precedence (so
// if both _POSIX_C_SOURCE and _NETBSD_SOURCE are defined, the version
// of rename() that's used is the POSIX one).  If none of the "major"
// feature-test macros is defined, _NETBSD_SOURCE is assumed.
//
// There are also "minor" feature-test macros, which enable extra
// functionality in addition to some base standard.  They should be
// defined along with one of the "major" macros.  The "minor" macros
// are:
//
// _REENTRANT
// _ISOC99_SOURCE
// _ISOC11_SOURCE
// _LARGEFILE_SOURCE		Large File Support
//		<http://ftp.sas.com/standards/large.file/x_open.20Mar96.html>

type sigval_t = sigval /* siginfo.h:44:3 */

type _ksiginfo = struct {
	_signo  int32
	_code   int32
	_errno  int32
	_pad    int32
	_reason struct {
		_rt struct {
			_pid   int32
			_uid   uint32
			_value sigval_t
		}
		_ [64]byte
	}
} /* siginfo.h:46:1 */

type siginfo = struct {
	_      [0]uint64
	si_pad [128]int8
} /* siginfo.h:148:9 */

type siginfo_t = siginfo /* siginfo.h:151:3 */

//* Field access macros

//* si_code
// SIGILL

// SIGFPE

// SIGSEGV

// SIGBUS

// SIGTRAP

// SIGCHLD
// did not create a core file
// created a core file

// SIGIO

//* si_code
// set by timer_settime(2)
// asynchronous I/O signal
// an empty message queue

//	$NetBSD: ucontext.h,v 1.19 2018/02/27 23:09:02 uwe Exp $

// -
// Copyright (c) 1999, 2003 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Klaus Klein, and by Jason R. Thorpe.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

//	$NetBSD: sigtypes.h,v 1.11 2017/01/12 18:29:14 christos Exp $

// Copyright (c) 1982, 1986, 1989, 1991, 1993
//	The Regents of the University of California.  All rights reserved.
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)signal.h	8.4 (Berkeley) 5/4/95

//	$NetBSD: mcontext.h,v 1.19 2018/02/15 15:53:56 kamil Exp $

// -
// Copyright (c) 1999 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Klaus Klein.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

type __ucontext = struct {
	uc_flags    uint32
	_           [4]byte
	uc_link     uintptr
	uc_sigmask  sigset_t
	uc_stack    stack_t
	uc_mcontext mcontext_t
} /* ucontext.h:38:9 */

//* Field access macros

//* si_code
// SIGILL

// SIGFPE

// SIGSEGV

// SIGBUS

// SIGTRAP

// SIGCHLD
// did not create a core file
// created a core file

// SIGIO

//* si_code
// set by timer_settime(2)
// asynchronous I/O signal
// an empty message queue

//	$NetBSD: ucontext.h,v 1.19 2018/02/27 23:09:02 uwe Exp $

// -
// Copyright (c) 1999, 2003 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Klaus Klein, and by Jason R. Thorpe.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

//	$NetBSD: sigtypes.h,v 1.11 2017/01/12 18:29:14 christos Exp $

// Copyright (c) 1982, 1986, 1989, 1991, 1993
//	The Regents of the University of California.  All rights reserved.
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)signal.h	8.4 (Berkeley) 5/4/95

//	$NetBSD: mcontext.h,v 1.19 2018/02/15 15:53:56 kamil Exp $

// -
// Copyright (c) 1999 The NetBSD Foundation, Inc.
// All rights reserved.
//
// This code is derived from software contributed to The NetBSD Foundation
// by Klaus Klein.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
// ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

type ucontext_t = __ucontext /* ucontext.h:38:27 */

// uc_flags

// if your port needs more MD bits, please try to choose bits from _UC_MD
// first, rather than picking random unused bits.
//
// _UC_MD details
//
// 	_UC_TLSBASE	Context contains valid pthread private pointer
//			All ports must define this MD flag
// 			0x00040000	hppa, mips
// 			0x00000020	alpha
//			0x00080000	all other ports
//
//	_UC_SETSTACK	Context uses signal stack
//			0x00020000	arm
//			[undefined]	alpha, powerpc and vax
//			0x00010000	other ports
//
//	_UC_CLRSTACK	Context does not use signal stack
//			0x00040000	arm
//			[undefined]	alpha, powerpc and vax
//			0x00020000	other ports
//
//	_UC_POWERPC_VEC Context contains valid AltiVec context
//			0x00010000	powerpc only
//
//	_UC_POWERPC_SPE	Context contains valid SPE context
//			0x00020000	powerpc only
//
//	_UC_M68K_UC_USER Used by m68k machdep code, but undocumented
//			0x40000000	m68k only
//
//	_UC_ARM_VFP	Unused
//			0x00010000	arm only
//
//	_UC_VM		Context contains valid virtual 8086 context
//			0x00040000	i386, amd64 only
//
//	_UC_FXSAVE	Context contains FPU context in that
//			is in FXSAVE format in XMM space
//			0x00000020	i386, amd64 only

// Signal vector "template" used in sigaction call.
type sigaction = struct {
	_sa_u    struct{ _sa_handler uintptr }
	sa_mask  sigset_t
	sa_flags int32
	_        [4]byte
} /* signal.h:123:1 */

//	$NetBSD: signal.h,v 1.12 2013/01/02 19:40:23 dsl Exp $

// Copyright (c) 1982, 1986, 1989, 1991 Regents of the University of California.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)signal.h	7.16 (Berkeley) 3/17/91

// Only valid for SIGCHLD.

// Flags for sigprocmask():

type sig_t = uintptr /* signal.h:172:14 */ // type of signal function

// Flags used with stack_t/struct sigaltstack.

// Structure used in sigstack call.
type sigstack = struct {
	ss_sp      uintptr
	ss_onstack int32
	_          [4]byte
} /* signal.h:198:1 */

//	$NetBSD: fcntl.h,v 1.50 2018/02/20 18:20:05 kamil Exp $

// -
// Copyright (c) 1983, 1990, 1993
//	The Regents of the University of California.  All rights reserved.
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)fcntl.h	8.3 (Berkeley) 1/21/94

// #define hook __builtin_printf("TRC %s:%i:\n", __func__, __LINE__);

// Size of the write buffer used by journal files in bytes.

// The maximum pathname length supported by this VFS.

// When using this VFS, the sqlite3_file* handles that SQLite uses are
// actually pointers to instances of type VFSFile.
type VFSFile1 = struct {
	base        sqlite3_file
	fsFile      uintptr
	fd          int32
	_           [4]byte
	aBuffer     uintptr
	nBuffer     int32
	_           [4]byte
	iBufferOfst sqlite3_int64
} /* vfs.c:154:9 */

//	$NetBSD: fcntl.h,v 1.50 2018/02/20 18:20:05 kamil Exp $

// -
// Copyright (c) 1983, 1990, 1993
//	The Regents of the University of California.  All rights reserved.
// (c) UNIX System Laboratories, Inc.
// All or some portions of this file are derived from material licensed
// to the University of California by American Telephone and Telegraph
// Co. or Unix System Laboratories, Inc. and are reproduced herein with
// the permission of UNIX System Laboratories, Inc.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the University nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
//	@(#)fcntl.h	8.3 (Berkeley) 1/21/94

// #define hook __builtin_printf("TRC %s:%i:\n", __func__, __LINE__);

// Size of the write buffer used by journal files in bytes.

// The maximum pathname length supported by this VFS.

// When using this VFS, the sqlite3_file* handles that SQLite uses are
// actually pointers to instances of type VFSFile.
type VFSFile = VFSFile1 /* vfs.c:154:24 */

// Write directly to the file passed as the first argument. Even if the
// file has a write-buffer (VFSFile.aBuffer), ignore it.
func vfsDirectWrite(tls *libc.TLS, p uintptr, zBuf uintptr, iAmt int32, iOfst sqlite_int64) int32 { /* vfs.c:169:12: */
	bp := tls.Alloc(16)
	defer tls.Free(16)

	var ofst int64    // Return value from lseek()
	var nWrite size_t // Return value from write()

	libc.X__builtin_printf(tls, ts, libc.VaList(bp, uintptr(unsafe.Pointer(&__func__)), 178))
	libc.X__builtin_abort(tls)
	ofst = libc.Xlseek(tls, (*VFSFile)(unsafe.Pointer(p)).fd, int64(iOfst), 0)
	if sqlite_int64(ofst) != iOfst {
		return 10 | int32(3)<<8
	}

	nWrite = size_t(libc.Xwrite(tls, (*VFSFile)(unsafe.Pointer(p)).fd, zBuf, uint64(iAmt)))
	if nWrite != size_t(iAmt) {
		return 10 | int32(3)<<8
	}

	return 0
}

var __func__ = *(*[15]int8)(unsafe.Pointer(ts + 13)) /* vfs.c:174:2 */

// Flush the contents of the VFSFile.aBuffer buffer to disk. This is a
// no-op if this particular file does not have a buffer (i.e. it is not
// a journal file) or if the buffer is currently empty.
func vfsFlushBuffer(tls *libc.TLS, p uintptr) int32 { /* vfs.c:197:12: */
	bp := tls.Alloc(16)
	defer tls.Free(16)

	libc.X__builtin_printf(tls, ts, libc.VaList(bp, uintptr(unsafe.Pointer(&__func__1)), 198))
	libc.X__builtin_abort(tls)
	var rc int32 = 0
	if (*VFSFile)(unsafe.Pointer(p)).nBuffer != 0 {
		rc = vfsDirectWrite(tls, p, (*VFSFile)(unsafe.Pointer(p)).aBuffer, (*VFSFile)(unsafe.Pointer(p)).nBuffer, (*VFSFile)(unsafe.Pointer(p)).iBufferOfst)
		(*VFSFile)(unsafe.Pointer(p)).nBuffer = 0
	}
	return rc
}

var __func__1 = *(*[15]int8)(unsafe.Pointer(ts + 28)) /* vfs.c:197:38 */

// Write data to a crash-file.
func vfsWrite(tls *libc.TLS, pFile uintptr, zBuf uintptr, iAmt int32, iOfst sqlite_int64) int32 { /* vfs.c:267:12: */
	bp := tls.Alloc(16)
	defer tls.Free(16)

	libc.X__builtin_printf(tls, ts, libc.VaList(bp, uintptr(unsafe.Pointer(&__func__4)), 273))
	libc.X__builtin_abort(tls)
	var p uintptr = pFile

	if (*VFSFile)(unsafe.Pointer(p)).aBuffer != 0 {
		var z uintptr = zBuf        // Pointer to remaining data to write
		var n int32 = iAmt          // Number of bytes at z
		var i sqlite3_int64 = iOfst // File offset to write to

		for n > 0 {
			var nCopy int32 // Number of bytes to copy into buffer

			// If the buffer is full, or if this data is not being written directly
			// following the data already buffered, flush the buffer. Flushing
			// the buffer is a no-op if it is empty.
			if (*VFSFile)(unsafe.Pointer(p)).nBuffer == 8192 || (*VFSFile)(unsafe.Pointer(p)).iBufferOfst+sqlite3_int64((*VFSFile)(unsafe.Pointer(p)).nBuffer) != i {
				var rc int32 = vfsFlushBuffer(tls, p)
				if rc != 0 {
					return rc
				}
			}
			if !((*VFSFile)(unsafe.Pointer(p)).nBuffer == 0 || (*VFSFile)(unsafe.Pointer(p)).iBufferOfst+sqlite3_int64((*VFSFile)(unsafe.Pointer(p)).nBuffer) == i) {
				libc.X__assert13(tls, ts+43, 294, uintptr(unsafe.Pointer(&__func__4)), ts+51)
			}
			(*VFSFile)(unsafe.Pointer(p)).iBufferOfst = i - sqlite3_int64((*VFSFile)(unsafe.Pointer(p)).nBuffer)

			// Copy as much data as possible into the buffer.
			nCopy = 8192 - (*VFSFile)(unsafe.Pointer(p)).nBuffer
			if nCopy > n {
				nCopy = n
			}
			libc.Xmemcpy(tls, (*VFSFile)(unsafe.Pointer(p)).aBuffer+uintptr((*VFSFile)(unsafe.Pointer(p)).nBuffer), z, uint64(nCopy))
			*(*int32)(unsafe.Pointer(p + 32)) += nCopy

			n = n - nCopy
			i = i + sqlite3_int64(nCopy)
			z += uintptr(nCopy)
		}
	} else {
		return vfsDirectWrite(tls, p, zBuf, iAmt, iOfst)
	}

	return 0
}

var __func__4 = *(*[9]int8)(unsafe.Pointer(ts + 97)) /* vfs.c:272:2 */

// Truncate a file. This is a no-op for this VFS (see header comments at
// the top of the file).
func vfsTruncate(tls *libc.TLS, pFile uintptr, size sqlite_int64) int32 { /* vfs.c:320:12: */
	return 0
}

// Sync the contents of the file to the persistent media.
func vfsSync(tls *libc.TLS, pFile uintptr, flags int32) int32 { /* vfs.c:330:12: */
	bp := tls.Alloc(16)
	defer tls.Free(16)

	libc.X__builtin_printf(tls, ts, libc.VaList(bp, uintptr(unsafe.Pointer(&__func__5)), 331))
	libc.X__builtin_abort(tls)
	var p uintptr = pFile
	var rc int32

	rc = vfsFlushBuffer(tls, p)
	if rc != 0 {
		return rc
	}

	rc = libc.Xfsync(tls, (*VFSFile)(unsafe.Pointer(p)).fd)
	return func() int32 {
		if rc == 0 {
			return 0
		}
		return 10 | int32(4)<<8
	}()
}

var __func__5 = *(*[8]int8)(unsafe.Pointer(ts + 106)) /* vfs.c:330:51 */

// Locking functions. The xLock() and xUnlock() methods are both no-ops.
// The xCheckReservedLock() always indicates that no other process holds
// a reserved lock on the database file. This ensures that if a hot-journal
// file is found in the file-system it is rolled back.
func vfsLock(tls *libc.TLS, pFile uintptr, eLock int32) int32 { /* vfs.c:375:12: */
	return 0
}

func vfsUnlock(tls *libc.TLS, pFile uintptr, eLock int32) int32 { /* vfs.c:378:12: */
	return 0
}

func vfsCheckReservedLock(tls *libc.TLS, pFile uintptr, pResOut uintptr) int32 { /* vfs.c:381:12: */
	*(*int32)(unsafe.Pointer(pResOut)) = 0
	return 0
}

// No xFileControl() verbs are implemented by this VFS.
func vfsFileControl(tls *libc.TLS, pFile uintptr, op int32, pArg uintptr) int32 { /* vfs.c:389:12: */
	return 12
}

// The xSectorSize() and xDeviceCharacteristics() methods. These two
// may return special values allowing SQLite to optimize file-system
// access to some extent. But it is also safe to simply return 0.
func vfsSectorSize(tls *libc.TLS, pFile uintptr) int32 { /* vfs.c:398:12: */
	return 0
}

func vfsDeviceCharacteristics(tls *libc.TLS, pFile uintptr) int32 { /* vfs.c:401:12: */
	return 0
}

// Delete the file identified by argument zPath. If the dirSync parameter
// is non-zero, then ensure the file-system modification to delete the
// file has been synced to disk before returning.
func vfsDelete(tls *libc.TLS, pVfs uintptr, zPath uintptr, dirSync int32) int32 { /* vfs.c:472:12: */
	bp := tls.Alloc(4129)
	defer tls.Free(4129)

	libc.X__builtin_printf(tls, ts, libc.VaList(bp, uintptr(unsafe.Pointer(&__func__8)), 473))
	libc.X__builtin_abort(tls)
	var rc int32 // Return code

	rc = libc.Xunlink(tls, zPath)
	if rc != 0 && *(*int32)(unsafe.Pointer(libc.X__errno(tls))) == 2 {
		return 0
	}

	if rc == 0 && dirSync != 0 {
		var dfd int32 // File descriptor open on directory
		var i int32   // Iterator variable
		// var zDir [4097]int8 at bp+32, 4097
		// Name of directory containing file zPath

		// Figure out the directory name from the path of the file deleted.
		sqlite3.Xsqlite3_snprintf(tls, 4096, bp+32, ts+114, libc.VaList(bp+16, zPath))
		*(*int8)(unsafe.Pointer(bp + 32 + 4096)) = int8(0)
		for i = int32(libc.Xstrlen(tls, bp+32)); i > 1 && int32(*(*int8)(unsafe.Pointer(bp + 32 /* &zDir[0] */ + uintptr(i)))) != '/'; i++ {
		}
		*(*int8)(unsafe.Pointer(bp + 32 + uintptr(i))) = int8(0)

		// Open a file-descriptor on the directory. Sync. Close.
		dfd = libc.Xopen(tls, bp+32, 0x00000000, libc.VaList(bp+24, 0))
		if dfd < 0 {
			rc = -1
		} else {
			rc = libc.Xfsync(tls, dfd)
			libc.Xclose(tls, dfd)
		}
	}
	return func() int32 {
		if rc == 0 {
			return 0
		}
		return 10 | int32(10)<<8
	}()
}

var __func__8 = *(*[10]int8)(unsafe.Pointer(ts + 117)) /* vfs.c:472:72 */

// The following four VFS methods:
//
//	xDlOpen
//	xDlError
//	xDlSym
//	xDlClose
//
// are supposed to implement the functionality needed by SQLite to load
// extensions compiled as shared objects. This simple VFS does not support
// this functionality, so the following functions are no-ops.
func vfsDlOpen(tls *libc.TLS, pVfs uintptr, zPath uintptr) uintptr { /* vfs.c:583:13: */
	return uintptr(0)
}

func vfsDlError(tls *libc.TLS, pVfs uintptr, nByte int32, zErrMsg uintptr) { /* vfs.c:586:13: */
	sqlite3.Xsqlite3_snprintf(tls, nByte, zErrMsg, ts+127, 0)
	*(*int8)(unsafe.Pointer(zErrMsg + uintptr(nByte-1))) = int8(0)
}

func vfsDlSym(tls *libc.TLS, pVfs uintptr, pH uintptr, z uintptr) uintptr { /* vfs.c:590:13: */
	return uintptr(0)
}

func vfsDlClose(tls *libc.TLS, pVfs uintptr, pHandle uintptr) { /* vfs.c:593:13: */
	return
}

// Parameter zByte points to a buffer nByte bytes in size. Populate this
// buffer with pseudo-random data.
func vfsRandomness(tls *libc.TLS, pVfs uintptr, nByte int32, zByte uintptr) int32 { /* vfs.c:601:12: */
	return 0
}

// Sleep for at least nMicro microseconds. Return the (approximate) number
// of microseconds slept for.
func vfsSleep(tls *libc.TLS, pVfs uintptr, nMicro int32) int32 { /* vfs.c:609:12: */
	libc.Xsleep(tls, uint32(nMicro/1000000))
	libc.Xusleep(tls, uint32(nMicro%1000000))
	return nMicro
}

// Set *pTime to the current UTC time expressed as a Julian day. Return
// SQLITE_OK if successful, or an error code otherwise.
//
//	http://en.wikipedia.org/wiki/Julian_day
//
// This implementation is not very good. The current time is rounded to
// an integer number of seconds. Also, assuming time_t is a signed 32-bit
// value, it will stop working some time in the year 2038 AD (the so-called
// "year 2038" problem that afflicts systems that store time this way).
func vfsCurrentTime(tls *libc.TLS, pVfs uintptr, pTime uintptr) int32 { /* vfs.c:626:12: */
	var t time_t = libc.Xtime(tls, uintptr(0))
	*(*float64)(unsafe.Pointer(pTime)) = float64(t)/86400.0 + 2440587.5
	return 0
}

// This function returns a pointer to the VFS implemented in this file.
// To make the VFS available to SQLite:
//
//	sqlite3_vfs_register(sqlite3_fsFS(), 0);
func Xsqlite3_fsFS(tls *libc.TLS, zName uintptr, pAppData uintptr) uintptr { /* vfs.c:638:13: */
	var p uintptr = sqlite3.Xsqlite3_malloc(tls, int32(unsafe.Sizeof(sqlite3_vfs{})))
	if !(p != 0) {
		return uintptr(0)
	}

	*(*sqlite3_vfs)(unsafe.Pointer(p)) = sqlite3_vfs{
		iVersion:   1,                               // iVersion
		szOsFile:   int32(unsafe.Sizeof(VFSFile{})), // szOsFile
		mxPathname: 4096,                            // pNext
		zName:      zName,                           // zName
		pAppData:   pAppData,                        // pAppData
		xOpen: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr, uintptr, int32, uintptr) int32
		}{vfsOpen})), // xOpen
		xDelete: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr, int32) int32
		}{vfsDelete})), // xDelete
		xAccess: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr, int32, uintptr) int32
		}{vfsAccess})), // xAccess
		xFullPathname: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr, int32, uintptr) int32
		}{vfsFullPathname})), // xFullPathname
		xDlOpen: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr) uintptr
		}{vfsDlOpen})), // xDlOpen
		xDlError: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, int32, uintptr)
		}{vfsDlError})), // xDlError
		xDlSym: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr, uintptr) uintptr
		}{vfsDlSym})), // xDlSym
		xDlClose: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr)
		}{vfsDlClose})), // xDlClose
		xRandomness: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, int32, uintptr) int32
		}{vfsRandomness})), // xRandomness
		xSleep: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, int32) int32
		}{vfsSleep})), // xSleep
		xCurrentTime: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr) int32
		}{vfsCurrentTime}))}
	return p
}

var ts1 = "TODO %s:%i:\n\x00vfsDirectWrite\x00vfsFlushBuffer\x00c/vfs.c\x00p->nBuffer==0 || p->iBufferOfst+p->nBuffer==i\x00vfsWrite\x00vfsSync\x00%s\x00vfsDelete\x00Loadable extensions are not supported\x00"
var ts = (*reflect.StringHeader)(unsafe.Pointer(&ts1)).Data
