/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.java.j2seplatform.platformdefinition.PlatformConvertor;
import org.netbeans.modules.java.j2seplatform.platformdefinition.Util;
import org.netbeans.modules.java.j2seplatform.wizard.J2SEWizardIterator;
import org.netbeans.modules.java.j2seplatform.wizard.NewJ2SEPlatform;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.SpecificationVersion;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Utilities;

public class DetectPanel
extends JPanel {
    private static final int COLS = 30;
    private static final RequestProcessor RP = new RequestProcessor(DetectPanel.class.getName(), 1, false, false);
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private static final String INNER_SEPARATOR = "!/";
    private static final String PATH_SEPARATOR = ";";
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField javadoc;
    private JTextField jdkName;
    private JLabel progressLabel;
    private JPanel progressPanel;
    private JTextField sources;

    public DetectPanel() {
        this.initComponents();
        this.postInitComponents();
        this.putClientProperty("WizardPanel_contentData", new String[]{NbBundle.getMessage(DetectPanel.class, (String)"TITLE_PlatformName")});
        this.setName(NbBundle.getMessage(DetectPanel.class, (String)"TITLE_PlatformName"));
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    private void postInitComponents() {
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DetectPanel.this.cs.fireChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DetectPanel.this.cs.fireChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DetectPanel.this.cs.fireChange();
            }
        };
        this.jdkName.getDocument().addDocumentListener(docListener);
        this.javadoc.getDocument().addDocumentListener(docListener);
        this.sources.getDocument().addDocumentListener(docListener);
        this.progressLabel.setVisible(false);
        this.progressPanel.setVisible(false);
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.jdkName = new JTextField();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.javadoc = new JTextField();
        this.sources = new JTextField();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel2 = new JPanel();
        this.progressLabel = new JLabel();
        this.progressPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jLabel3.setLabelFor(this.jdkName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getBundle(DetectPanel.class).getString("LBL_DetailsPanel_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.jdkName, gridBagConstraints);
        this.jdkName.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(DetectPanel.class).getString("AD_PlatformName"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.sources);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getBundle(DetectPanel.class).getString("TXT_Sources"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel4.setLabelFor(this.javadoc);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getBundle(DetectPanel.class).getString("TXT_JavaDoc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        this.javadoc.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.jPanel1.add((Component)this.javadoc, gridBagConstraints);
        this.javadoc.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(DetectPanel.class).getString("AD_PlatformJavadoc"));
        this.sources.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.sources, gridBagConstraints);
        this.sources.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(DetectPanel.class).getString("AD_PlatformSources"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getBundle(DetectPanel.class).getString("LBL_BrowseSources"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DetectPanel.this.selectSources(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.jButton1, gridBagConstraints);
        this.jButton1.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(DetectPanel.class).getString("AD_SelectSources"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getBundle(DetectPanel.class).getString("LBL_BrowseJavadoc"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DetectPanel.this.selectJavadoc(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.jPanel1.add((Component)this.jButton2, gridBagConstraints);
        this.jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(DetectPanel.class).getString("AD_SelectJavadoc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(24, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.progressLabel.setLabelFor(this.progressPanel);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/java/j2seplatform/wizard/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.progressLabel, (String)bundle.getString("TXT_PlatfromDetectProgress"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 6, 0);
        this.add((Component)this.progressLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.progressPanel, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(DetectPanel.class).getString("AD_DetectPanel"));
    }

    private void selectJavadoc(ActionEvent evt) {
        String newValue = this.browse(this.javadoc.getText(), NbBundle.getMessage(DetectPanel.class, (String)"TXT_SelectJavadoc"));
        if (newValue != null) {
            this.javadoc.setText(newValue);
        }
    }

    private void selectSources(ActionEvent evt) {
        String newValue = this.browse(this.sources.getText(), NbBundle.getMessage(DetectPanel.class, (String)"TXT_SelectSources"));
        if (newValue != null) {
            this.sources.setText(newValue);
        }
    }

    public final synchronized void addChangeListener(ChangeListener listener) {
        this.cs.addChangeListener(listener);
    }

    public final synchronized void removeChangeListener(ChangeListener listener) {
        this.cs.removeChangeListener(listener);
    }

    public String getPlatformName() {
        return this.jdkName.getText().trim();
    }

    String getSources() {
        return this.sources.getText();
    }

    void setSources(String sources) {
        this.sources.setText(sources == null ? "" : sources);
    }

    String getJavadoc() {
        return this.javadoc.getText();
    }

    void setJavadoc(@NonNull String jdoc) {
        this.javadoc.setText(jdoc);
    }

    private void updatePlatformName(@NonNull NewJ2SEPlatform platform, String name) {
        assert (platform != null);
        assert (SwingUtilities.isEventDispatchThread());
        Map m = platform.getSystemProperties();
        if ("".equals(this.jdkName.getText())) {
            if (name != null) {
                this.jdkName.setText(name);
            } else {
                this.jdkName.setText(DetectPanel.getInitialName(m));
            }
            this.jdkName.selectAll();
        }
    }

    private static String getInitialName(Map<String, String> m) {
        String vmVersion = m.get("java.specification.version");
        StringBuilder result = new StringBuilder(NbBundle.getMessage(DetectPanel.class, (String)"TXT_DetectPanel_Java"));
        if (vmVersion != null) {
            result.append(vmVersion);
        }
        return result.toString();
    }

    private String browse(String oldValue, String title) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(2);
        if (Utilities.isMac()) {
            chooser.putClientProperty("JFileChooser.packageIsTraversable", "always");
        }
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.exists() && f.canRead() && (f.isDirectory() || f.getName().endsWith(".zip") || f.getName().endsWith(".jar"));
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(DetectPanel.class, (String)"TXT_ZipFilter");
            }
        });
        File f = new File(oldValue);
        chooser.setSelectedFile(f);
        chooser.setDialogTitle(title);
        if (chooser.showOpenDialog(this) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    static class WizardPanel
    implements WizardDescriptor.AsynchronousValidatingPanel<WizardDescriptor>,
    TaskListener,
    ChangeListener {
        private DetectPanel component;
        private RequestProcessor.Task task;
        private final J2SEWizardIterator iterator;
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private final AtomicReference<PlatformState> detected = new AtomicReference<PlatformState>(PlatformState.UNKNOWN);
        private volatile boolean valid;
        private boolean firstPass = true;
        private WizardDescriptor wiz;
        private ProgressHandle progressHandle;
        private volatile String sourcesString;
        private volatile List<PathResourceImplementation> sources;
        private volatile String javadocString;
        private volatile List<URL> javadoc;

        WizardPanel(J2SEWizardIterator iterator) {
            this.iterator = iterator;
        }

        public void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        public Component getComponent() {
            if (this.component == null) {
                final NewJ2SEPlatform primaryPlatform = this.iterator.getPlatform();
                final NewJ2SEPlatform secondaryPlatform = this.iterator.getSecondaryPlatform();
                this.component = new DetectPanel();
                this.component.addChangeListener(this);
                this.task = RP.create(new Runnable(){

                    @Override
                    public void run() {
                        primaryPlatform.run();
                        if (secondaryPlatform != null) {
                            secondaryPlatform.run();
                        }
                    }
                });
                this.task.addTaskListener((TaskListener)this);
            }
            return this.component;
        }

        void setValid(boolean v) {
            if (v == this.valid) {
                return;
            }
            this.valid = v;
            this.cs.fireChange();
        }

        public HelpCtx getHelp() {
            return new HelpCtx(DetectPanel.class);
        }

        public boolean isValid() {
            return this.valid;
        }

        public void readSettings(WizardDescriptor settings) {
            this.sources = null;
            this.sourcesString = null;
            this.javadoc = null;
            this.javadocString = null;
            this.wiz = settings;
            this.component.progressPanel.setVisible(true);
            this.component.progressLabel.setVisible(true);
            this.progressHandle = ProgressHandle.createHandle((String)NbBundle.getMessage(DetectPanel.class, (String)"TXT_PlatfromDetectProgress"));
            this.component.progressPanel.removeAll();
            this.component.progressPanel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = -1;
            c.gridx = -1;
            c.gridwidth = 0;
            c.gridheight = 0;
            c.fill = 2;
            c.weightx = 1.0;
            JComponent pc = ProgressHandleFactory.createProgressComponent((ProgressHandle)this.progressHandle);
            ((GridBagLayout)this.component.progressPanel.getLayout()).setConstraints(pc, c);
            this.component.progressPanel.add(pc);
            this.progressHandle.start();
            this.task.schedule(0);
        }

        public void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }

        public void storeSettings(WizardDescriptor settings) {
            List<PathResourceImplementation> src = this.sources;
            List<URL> jdoc = this.javadoc;
            if (this.isValid() && src != null && jdoc != null) {
                String name = this.component.getPlatformName();
                NewJ2SEPlatform platform = this.iterator.getPlatform();
                platform.setDisplayName(name);
                platform.setAntName(PlatformConvertor.getFreeAntName(name));
                platform.setSourceFolders(ClassPathSupport.createClassPath(src));
                if (!jdoc.isEmpty()) {
                    platform.setJavadocFolders(jdoc);
                }
                if ((platform = this.iterator.getSecondaryPlatform()) != null) {
                    name = NbBundle.getMessage(DetectPanel.class, (String)"FMT_64BIT", (Object)name);
                    platform.setDisplayName(name);
                    platform.setAntName(PlatformConvertor.getFreeAntName(name));
                    platform.setSourceFolders(ClassPathSupport.createClassPath(src));
                    if (!jdoc.isEmpty()) {
                        platform.setJavadocFolders(jdoc);
                    }
                }
            }
        }

        public void prepareValidation() {
            this.sourcesString = this.component.getSources();
            this.javadocString = this.component.getJavadoc();
        }

        public void validate() throws WizardValidationException {
            assert (this.valid);
            try {
                this.sources = WizardPanel.stringToSourcePath(this.sourcesString);
            }
            catch (IllegalStateException ise) {
                throw new WizardValidationException((JComponent)this.component, "ERROR_Sources", NbBundle.getMessage(DetectPanel.class, (String)"ERROR_Sources"));
            }
            try {
                this.javadoc = WizardPanel.stringToJavadoc(this.javadocString);
            }
            catch (IllegalStateException ise) {
                throw new WizardValidationException((JComponent)this.component, "ERROR_Javadoc", NbBundle.getMessage(DetectPanel.class, (String)"ERROR_Javadoc"));
            }
        }

        public void taskFinished(Task task) {
            final NewJ2SEPlatform platform = this.iterator.getPlatform();
            List<URL> jdoc = platform.getJavadocFolders();
            if (jdoc.isEmpty()) {
                jdoc = platform.defaultJavadoc();
            }
            final String jdocStr = WizardPanel.urlsToString(jdoc);
            List<URL> src = WizardPanel.cpToUrls(platform.getSourceFolders());
            if (src.isEmpty()) {
                src = platform.defaultSources();
            }
            final String srcStr = WizardPanel.urlsToString(src);
            this.detected.set(platform.isValid() ? (WizardPanel.isSupported(platform.getSpecification().getVersion()) ? PlatformState.VALID : PlatformState.UNSUPPORTED) : PlatformState.INVALID);
            Object attr = this.iterator.getInstallFolder().getAttribute("J2SEPlatform.displayName");
            final String name = attr instanceof String ? (String)attr : null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    component.updatePlatformName(platform, name);
                    component.setJavadoc(jdocStr);
                    component.setSources(srcStr);
                    assert (progressHandle != null);
                    progressHandle.finish();
                    component.progressPanel.setVisible(false);
                    component.progressLabel.setVisible(false);
                    this.checkValid();
                }
            });
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.checkValid();
        }

        private void checkValid() {
            this.wiz.putProperty("WizardPanel_errorMessage", (Object)"");
            String name = this.component.getPlatformName();
            boolean vld = switch (this.detected.get()) {
                case PlatformState.INVALID -> {
                    this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(DetectPanel.class, (String)"ERROR_NoSDKRegistry"));
                    yield false;
                }
                case PlatformState.UNKNOWN -> false;
                case PlatformState.VALID -> true;
                case PlatformState.UNSUPPORTED -> {
                    this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(DetectPanel.class, (String)"ERROR_UnsupportedPlatform", (Object)SourceLevelQuery.MINIMAL_SOURCE_LEVEL));
                    yield false;
                }
                default -> throw new IllegalStateException();
            };
            if (vld && name.length() == 0) {
                vld = false;
                this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(DetectPanel.class, (String)"ERROR_InvalidDisplayName"));
            }
            if (vld) {
                for (JavaPlatform platform : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
                    if (!name.equals(platform.getDisplayName())) continue;
                    vld = false;
                    this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(DetectPanel.class, (String)"ERROR_UsedDisplayName"));
                    break;
                }
            }
            this.setValid(vld);
        }

        @NonNull
        private static List<PathResourceImplementation> stringToSourcePath(@NonNull String path) {
            assert (path != null);
            ArrayList<PathResourceImplementation> result = new ArrayList<PathResourceImplementation>();
            StringTokenizer tk = new StringTokenizer(path, DetectPanel.PATH_SEPARATOR);
            while (tk.hasMoreTokens()) {
                try {
                    String token = tk.nextToken().trim();
                    if (token.isEmpty()) continue;
                    int index = token.lastIndexOf(DetectPanel.INNER_SEPARATOR);
                    if (index > 0) {
                        String outherPath = token.substring(0, index);
                        String innerPath = index + 2 == token.length() ? "" : token.substring(index + 2);
                        File f = new File(outherPath);
                        if (f.exists()) {
                            result.add(ClassPathSupport.createResource((URL)new URL(FileUtil.getArchiveRoot((URL)Utilities.toURI((File)f).toURL()).toExternalForm() + innerPath)));
                            continue;
                        }
                        throw new IllegalStateException();
                    }
                    File f = new File(token);
                    if (f.exists()) {
                        try {
                            URL url = Utilities.toURI((File)f).toURL();
                            if (FileUtil.isArchiveFile((URL)url)) {
                                FileObject fo = URLMapper.findFileObject((URL)(url = FileUtil.getArchiveRoot((URL)url)));
                                if (fo != null && (fo = fo.getFileObject("src")) != null) {
                                    url = fo.toURL();
                                }
                                result.add(ClassPathSupport.createResource((URL)url));
                                continue;
                            }
                            result.add(ClassPathSupport.createResource((URL)url));
                            continue;
                        }
                        catch (IllegalArgumentException | MalformedURLException mue) {
                            throw new IllegalStateException(mue);
                        }
                    }
                    throw new IllegalStateException();
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException(e);
                }
            }
            return result;
        }

        @NonNull
        private static List<URL> stringToJavadoc(@NonNull String path) {
            assert (path != null);
            ArrayList<URL> result = new ArrayList<URL>();
            StringTokenizer tk = new StringTokenizer(path, DetectPanel.PATH_SEPARATOR);
            while (tk.hasMoreTokens()) {
                try {
                    String token = tk.nextToken().trim();
                    if (token.startsWith("http") || token.startsWith("https")) {
                        result.add(new URI(token).toURL());
                        continue;
                    }
                    int index = token.lastIndexOf(DetectPanel.INNER_SEPARATOR);
                    if (index > 0) {
                        String outherPath = token.substring(0, index);
                        String innerPath = index + 2 == token.length() ? "" : token.substring(index + 2);
                        File f = new File(outherPath);
                        if (f.exists()) {
                            result.add(new URL(FileUtil.getArchiveRoot((URL)Utilities.toURI((File)f).toURL()).toExternalForm() + innerPath));
                            continue;
                        }
                        throw new IllegalStateException();
                    }
                    File f = new File(token);
                    URL url = FileUtil.urlForArchiveOrDir((File)f);
                    if (url != null) {
                        result.add(url);
                        continue;
                    }
                    throw new IllegalStateException();
                }
                catch (MalformedURLException | URISyntaxException e) {
                    throw new IllegalStateException(e);
                }
            }
            return result;
        }

        @NonNull
        private static List<URL> cpToUrls(@NonNull ClassPath cp) {
            ArrayList<URL> result = new ArrayList<URL>();
            for (ClassPath.Entry entry : cp.entries()) {
                result.add(entry.getURL());
            }
            return result;
        }

        @NonNull
        private static String urlsToString(@NonNull List<URL> path) {
            StringBuilder result = new StringBuilder();
            for (URL jdocRoot : path) {
                try {
                    String userName;
                    String relative;
                    String extUrl = jdocRoot.toExternalForm();
                    URL url = FileUtil.getArchiveFile((URL)jdocRoot);
                    if (url == null) {
                        url = jdocRoot;
                        relative = "";
                    } else {
                        int index = extUrl.lastIndexOf(DetectPanel.INNER_SEPARATOR);
                        relative = index < 0 ? "" : extUrl.substring(index + DetectPanel.INNER_SEPARATOR.length());
                    }
                    String protocol = url.getProtocol();
                    if ("file".equals(protocol)) {
                        String absolutePath = Utilities.toFile((URI)url.toURI()).getAbsolutePath();
                        StringBuilder sb = new StringBuilder(absolutePath.length() + DetectPanel.INNER_SEPARATOR.length() + relative.length());
                        sb.append(absolutePath);
                        if (!relative.isEmpty()) {
                            sb.append(DetectPanel.INNER_SEPARATOR);
                            sb.append(relative);
                        }
                        userName = sb.toString();
                    } else {
                        if (!Util.isRemoteProtocol(protocol)) continue;
                        userName = extUrl;
                    }
                    if (result.length() > 0) {
                        result.append(DetectPanel.PATH_SEPARATOR);
                    }
                    result.append(userName);
                }
                catch (URISyntaxException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
            return result.toString();
        }

        private static boolean isSupported(@NonNull SpecificationVersion specVersion) {
            return SourceLevelQuery.MINIMAL_SOURCE_LEVEL.compareTo(specVersion) <= 0;
        }
    }

    private static enum PlatformState {
        UNKNOWN,
        VALID,
        INVALID,
        UNSUPPORTED;

    }
}

