/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListUserGroupMembershipsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String userId;
    private String groupId;
    private String page;
    private Integer limit;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).userId(this.userId).groupId(this.groupId).page(this.page).limit(this.limit);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",userId=").append(String.valueOf(this.userId));
        sb.append(",groupId=").append(String.valueOf(this.groupId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListUserGroupMembershipsRequest)) {
            return false;
        }
        ListUserGroupMembershipsRequest other = (ListUserGroupMembershipsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.userId, other.userId) && Objects.equals(this.groupId, other.groupId) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.userId == null ? 43 : this.userId.hashCode());
        result = result * 59 + (this.groupId == null ? 43 : this.groupId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListUserGroupMembershipsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String userId = null;
        private String groupId = null;
        private String page = null;
        private Integer limit = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListUserGroupMembershipsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.userId(o.getUserId());
            this.groupId(o.getGroupId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListUserGroupMembershipsRequest build() {
            ListUserGroupMembershipsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListUserGroupMembershipsRequest buildWithoutInvocationCallback() {
            ListUserGroupMembershipsRequest request = new ListUserGroupMembershipsRequest();
            request.compartmentId = this.compartmentId;
            request.userId = this.userId;
            request.groupId = this.groupId;
            request.page = this.page;
            request.limit = this.limit;
            return request;
        }
    }
}

