/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.identity.model.UpdateCompartmentDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateCompartmentRequest
extends BmcRequest<UpdateCompartmentDetails> {
    private String compartmentId;
    private UpdateCompartmentDetails updateCompartmentDetails;
    private String ifMatch;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public UpdateCompartmentDetails getUpdateCompartmentDetails() {
        return this.updateCompartmentDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateCompartmentDetails getBody$() {
        return this.updateCompartmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).updateCompartmentDetails(this.updateCompartmentDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",updateCompartmentDetails=").append(String.valueOf((Object)this.updateCompartmentDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateCompartmentRequest)) {
            return false;
        }
        UpdateCompartmentRequest other = (UpdateCompartmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.updateCompartmentDetails, (Object)other.updateCompartmentDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.updateCompartmentDetails == null ? 43 : this.updateCompartmentDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateCompartmentRequest, UpdateCompartmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private UpdateCompartmentDetails updateCompartmentDetails = null;
        private String ifMatch = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder updateCompartmentDetails(UpdateCompartmentDetails updateCompartmentDetails) {
            this.updateCompartmentDetails = updateCompartmentDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateCompartmentRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.updateCompartmentDetails(o.getUpdateCompartmentDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateCompartmentRequest build() {
            UpdateCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateCompartmentDetails body) {
            this.updateCompartmentDetails(body);
            return this;
        }

        public UpdateCompartmentRequest buildWithoutInvocationCallback() {
            UpdateCompartmentRequest request = new UpdateCompartmentRequest();
            request.compartmentId = this.compartmentId;
            request.updateCompartmentDetails = this.updateCompartmentDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

