/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.selectors;

import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.DelegatingConnector;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.RepositoryRegistry;
import org.netbeans.modules.bugtracking.tasks.DashboardTopComponent;
import org.netbeans.modules.bugtracking.ui.selectors.SelectorPanel;

public class RepositorySelector {
    private SelectorPanel selectorPanel = new SelectorPanel();

    public RepositoryImpl create(boolean selectNode) {
        DelegatingConnector[] connectors = BugtrackingManager.getInstance().getConnectors();
        ArrayList<DelegatingConnector> l = new ArrayList<DelegatingConnector>(connectors.length);
        for (DelegatingConnector dc : connectors) {
            if (!dc.providesRepositoryManagement()) continue;
            l.add(dc);
        }
        connectors = l.toArray(new DelegatingConnector[0]);
        this.selectorPanel.setConnectors(connectors);
        boolean didCreate = this.selectorPanel.create();
        final RepositoryImpl repo = this.selectorPanel.getRepository();
        if (!didCreate) {
            if (repo != null) {
                repo.cancelChanges();
            }
            return null;
        }
        repo.applyChanges();
        RepositoryRegistry.getInstance().addRepository(repo);
        if (selectNode) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DashboardTopComponent.findInstance().select(repo, true);
                }
            });
        }
        return repo;
    }

    public boolean edit(RepositoryImpl repository, String errorMessage) {
        boolean didEdit = this.selectorPanel.edit(repository, errorMessage);
        RepositoryImpl repo = this.selectorPanel.getRepository();
        if (!didEdit) {
            if (repo != null) {
                repo.cancelChanges();
            }
            return false;
        }
        repo.applyChanges();
        RepositoryRegistry.getInstance().addRepository(repo);
        return true;
    }
}

