/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.indent;

import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.spi.editor.typinghooks.TypedBreakInterceptor;

public class LineBreakHook
implements TypedBreakInterceptor {
    private static final Logger LOG = Logger.getLogger(LineBreakHook.class.getName());

    public void afterInsert(TypedBreakInterceptor.Context context) throws BadLocationException {
    }

    private boolean precedesClosingTag(TokenSequence seq) {
        if (!seq.moveNext()) {
            return false;
        }
        Token tukac = seq.token();
        if (tukac.id() != XMLTokenId.TAG) {
            return false;
        }
        String text = tukac.text().toString();
        return text.startsWith("</");
    }

    private int followsOpeningTag(TokenSequence seq) {
        int closingIndex = -1;
        boolean selfClose = false;
        block5: while (seq.movePrevious()) {
            Token tukac = seq.token();
            switch ((XMLTokenId)tukac.id()) {
                case ARGUMENT: 
                case OPERATOR: 
                case VALUE: {
                    if (closingIndex == -1) {
                        return Integer.MIN_VALUE;
                    }
                }
                case WS: {
                    continue block5;
                }
                case TAG: {
                    String text = tukac.text().toString();
                    if (text.endsWith(">")) {
                        if (closingIndex > -1) {
                            return Integer.MIN_VALUE;
                        }
                        closingIndex = seq.offset() + tukac.length();
                        if (!text.endsWith("/>")) continue block5;
                        selfClose = true;
                        continue block5;
                    }
                    if (text.startsWith("<") && text.length() > 1 && text.charAt(1) != '/') {
                        if (selfClose) {
                            return -seq.offset() - 1;
                        }
                        return seq.offset();
                    }
                    return Integer.MIN_VALUE;
                }
            }
            return Integer.MIN_VALUE;
        }
        return Integer.MIN_VALUE;
    }

    public boolean beforeInsert(TypedBreakInterceptor.Context context) throws BadLocationException {
        return false;
    }

    public void cancelled(TypedBreakInterceptor.Context context) {
    }

    public void insert(TypedBreakInterceptor.MutableContext context) throws BadLocationException {
        int desiredIndent;
        if (!(context.getDocument() instanceof BaseDocument)) {
            return;
        }
        BaseDocument doc = (BaseDocument)context.getDocument();
        int insertPos = context.getCaretOffset();
        int caretPos = context.getComponent().getCaretPosition();
        int lineStartPos = LineDocumentUtils.getLineStartOffset((LineDocument)doc, (int)insertPos);
        TokenHierarchy h = TokenHierarchy.get((Document)doc);
        TokenSequence seq = h.tokenSequence();
        seq.move(context.getCaretOffset());
        int openOffset = this.followsOpeningTag(seq);
        int nonWhiteBefore = LineDocumentUtils.getPreviousNonWhitespace((LineDocument)doc, (int)insertPos, (int)lineStartPos);
        int lineEndPos = LineDocumentUtils.getLineEndOffset((LineDocument)doc, (int)caretPos);
        int nonWhiteAfter = LineDocumentUtils.getNextNonWhitespace((LineDocument)doc, (int)caretPos, (int)lineEndPos);
        if (nonWhiteBefore != -1 && nonWhiteAfter != -1 && openOffset >= 0) {
            seq.move(nonWhiteAfter);
            if (this.precedesClosingTag(seq)) {
                int startClosingLine = LineDocumentUtils.getLineStartOffset((LineDocument)doc, (int)nonWhiteAfter);
                int nextLineStart = Utilities.getRowStart((BaseDocument)doc, (int)insertPos, (int)1);
                if (nextLineStart >= startClosingLine - 1) {
                    this.insertBlankBetweenTabs(context, openOffset);
                }
                return;
            }
        }
        if (nonWhiteAfter != -1) {
            return;
        }
        if (openOffset != Integer.MIN_VALUE) {
            desiredIndent = IndentUtils.lineIndent((Document)doc, (int)LineDocumentUtils.getLineStartOffset((LineDocument)doc, (int)Math.abs(openOffset)));
            if (openOffset >= 0) {
                desiredIndent += IndentUtils.indentLevelSize((Document)doc);
            }
        } else {
            desiredIndent = IndentUtils.lineIndent((Document)doc, (int)lineStartPos);
        }
        String blankLine = "\n" + IndentUtils.createIndentString((Document)doc, (int)desiredIndent);
        context.setText(blankLine, -1, blankLine.length(), new int[]{1, blankLine.length()});
    }

    private void insertBlankBetweenTabs(TypedBreakInterceptor.MutableContext context, int openOffset) throws BadLocationException {
        BaseDocument baseDoc = (BaseDocument)context.getDocument();
        int spacesPerTab = IndentUtils.indentLevelSize((Document)baseDoc);
        int col = Utilities.getVisualColumn((BaseDocument)baseDoc, (int)openOffset);
        String blankLine = "\n" + IndentUtils.createIndentString((Document)baseDoc, (int)(col + spacesPerTab));
        int caretOffset = blankLine.length();
        blankLine = blankLine + "\n" + IndentUtils.createIndentString((Document)baseDoc, (int)col);
        context.setText(blankLine, -1, caretOffset, new int[]{1, blankLine.length()});
    }

    public static class F
    implements TypedBreakInterceptor.Factory {
        public TypedBreakInterceptor createTypedBreakInterceptor(MimePath mimePath) {
            return new LineBreakHook();
        }
    }
}

