/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Infer;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ExhaustivenessComputer {
    protected static final Context.Key<ExhaustivenessComputer> exhaustivenessKey = new Context.Key();
    private final Symtab syms;
    private final Types types;
    private final Check chk;
    private final Infer infer;
    private final Map<Pair<Type, Type>, Boolean> isSubtypeCache = new HashMap<Pair<Type, Type>, Boolean>();

    public static ExhaustivenessComputer instance(Context context) {
        ExhaustivenessComputer instance = context.get(exhaustivenessKey);
        if (instance == null) {
            instance = new ExhaustivenessComputer(context);
        }
        return instance;
    }

    protected ExhaustivenessComputer(Context context) {
        context.put(exhaustivenessKey, this);
        this.syms = Symtab.instance(context);
        this.types = Types.instance(context);
        this.chk = Check.instance(context);
        this.infer = Infer.instance(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exhausts(JCTree.JCExpression selector, List<JCTree.JCCase> cases) {
        HashSet<PatternDescription> patternSet = new HashSet<PatternDescription>();
        HashMap<Symbol, Set> enum2Constants = new HashMap<Symbol, Set>();
        HashSet<Integer> booleanLiterals = new HashSet<Integer>(Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(0, 1))));
        for (JCTree.JCCase jCCase : cases) {
            if (!TreeInfo.unguardedCase(jCCase)) continue;
            for (JCTree.JCCaseLabel l : jCCase.labels) {
                if (l instanceof JCTree.JCPatternCaseLabel) {
                    JCTree.JCPatternCaseLabel patternLabel = (JCTree.JCPatternCaseLabel)l;
                    for (Type component : this.components(selector.type)) {
                        patternSet.add(this.makePatternDescription(component, patternLabel.pat));
                    }
                    continue;
                }
                if (!(l instanceof JCTree.JCConstantCaseLabel)) continue;
                JCTree.JCConstantCaseLabel constantLabel = (JCTree.JCConstantCaseLabel)l;
                if (this.types.unboxedTypeOrType(selector.type).hasTag(TypeTag.BOOLEAN)) {
                    Object value = ((JCTree.JCLiteral)constantLabel.expr).value;
                    booleanLiterals.remove(value);
                    continue;
                }
                Symbol s = TreeInfo.symbol(constantLabel.expr);
                if (s == null || !s.isEnum()) continue;
                enum2Constants.computeIfAbsent(s.owner, x -> {
                    HashSet result = new HashSet();
                    s.owner.members().getSymbols(sym -> sym.kind == Kinds.Kind.VAR && sym.isEnum()).forEach(result::add);
                    return result;
                }).remove(s);
            }
        }
        if (this.types.unboxedTypeOrType(selector.type).hasTag(TypeTag.BOOLEAN) && booleanLiterals.isEmpty()) {
            return true;
        }
        for (Map.Entry entry : enum2Constants.entrySet()) {
            if (!((Set)entry.getValue()).isEmpty()) continue;
            patternSet.add(new BindingPattern(((Symbol)entry.getKey()).type));
        }
        Set<PatternDescription> patterns = patternSet;
        HashSet<Set<PatternDescription>> hashSet = new HashSet<Set<PatternDescription>>();
        boolean useHashes = true;
        try {
            boolean repeat = true;
            while (repeat) {
                Set<PatternDescription> updatedPatterns = this.reduceBindingPatterns(selector.type, patterns);
                updatedPatterns = this.reduceNestedPatterns(updatedPatterns, useHashes);
                updatedPatterns = this.reduceRecordPatterns(updatedPatterns);
                boolean bl = repeat = !(updatedPatterns = this.removeCoveredRecordPatterns(updatedPatterns)).equals(patterns);
                if (this.checkCovered(selector.type, patterns)) {
                    boolean bl2 = true;
                    return bl2;
                }
                if (!repeat) {
                    repeat = useHashes && hashSet.add(updatedPatterns);
                    useHashes = false;
                } else {
                    useHashes = true;
                }
                patterns = updatedPatterns;
            }
            boolean bl = this.checkCovered(selector.type, patterns);
            return bl;
        }
        catch (Symbol.CompletionFailure cf) {
            this.chk.completionError(selector.pos(), cf);
            boolean bl = true;
            return bl;
        }
        finally {
            this.isSubtypeCache.clear();
        }
    }

    private boolean checkCovered(Type seltype, Iterable<PatternDescription> patterns) {
        for (Type seltypeComponent : this.components(seltype)) {
            for (PatternDescription pd : patterns) {
                if (!this.isBpCovered(seltypeComponent, pd)) continue;
                return true;
            }
        }
        return false;
    }

    private List<Type> components(Type seltype) {
        return switch (seltype.getTag()) {
            case TypeTag.CLASS -> {
                if (seltype.isCompound()) {
                    if (seltype.isIntersection()) {
                        yield ((Type.IntersectionClassType)seltype).getComponents().stream().flatMap(t -> this.components((Type)t).stream()).collect(List.collector());
                    }
                    yield List.nil();
                }
                yield List.of(this.types.erasure(seltype));
            }
            case TypeTag.TYPEVAR -> this.components(((Type.TypeVar)seltype).getUpperBound());
            default -> List.of(this.types.erasure(seltype));
        };
    }

    private Set<PatternDescription> reduceBindingPatterns(Type selectorType, Set<PatternDescription> patterns) {
        Set existingBindings = patterns.stream().filter(pd -> pd instanceof BindingPattern).map(pd -> ((BindingPattern)pd).type.tsym).collect(Collectors.toSet());
        for (PatternDescription pdOne : patterns) {
            if (!(pdOne instanceof BindingPattern)) continue;
            BindingPattern bpOne = (BindingPattern)pdOne;
            HashSet<BindingPattern> toAdd = new HashSet<BindingPattern>();
            for (Type sup : this.types.directSupertypes(bpOne.type)) {
                Symbol.ClassSymbol clazz = (Symbol.ClassSymbol)this.types.erasure((Type)sup).tsym;
                clazz.complete();
                if (!clazz.isSealed() || !clazz.isAbstract() || existingBindings.contains(clazz)) continue;
                Type clazzType = clazz.type;
                if (this.components(selectorType).stream().noneMatch(c -> this.isSubtypeErasure(clazzType, (Type)c))) continue;
                Set<Symbol> permitted = this.allPermittedSubTypes(clazz, csym -> {
                    Type instantiated = csym.type.allparams().isEmpty() ? csym.type : this.infer.instantiatePatternType(selectorType, (Symbol.TypeSymbol)csym);
                    return instantiated != null && this.types.isCastable(selectorType, instantiated);
                });
                HashSet<Symbol> pendingPermitted = new HashSet<Symbol>(permitted);
                for (PatternDescription pdOther : patterns) {
                    if (!(pdOther instanceof BindingPattern)) continue;
                    BindingPattern bpOther = (BindingPattern)pdOther;
                    pendingPermitted.removeIf(pending -> this.isSubtypeErasure(pending.type, bpOther.type));
                    if (!bpOther.type.tsym.isAbstract()) continue;
                    Predicate<Symbol> check = pending -> permitted.stream().filter(perm -> this.isSubtypeErasure(perm.type, bpOther.type)).filter(perm -> this.isSubtypeErasure(perm.type, pending.type)).findAny().isPresent();
                    pendingPermitted.removeIf(check);
                }
                if (!pendingPermitted.isEmpty()) continue;
                toAdd.add(new BindingPattern(clazz.type));
            }
            if (toAdd.isEmpty()) continue;
            HashSet<PatternDescription> newPatterns = new HashSet<PatternDescription>(patterns);
            newPatterns.addAll(toAdd);
            return newPatterns;
        }
        return patterns;
    }

    private Set<Symbol> allPermittedSubTypes(Symbol.TypeSymbol root, Predicate<Symbol.ClassSymbol> accept) {
        HashSet<Symbol> permitted = new HashSet<Symbol>();
        List<Symbol.ClassSymbol> permittedSubtypesClosure = this.baseClasses(root);
        while (permittedSubtypesClosure.nonEmpty()) {
            Symbol.ClassSymbol current = (Symbol.ClassSymbol)permittedSubtypesClosure.head;
            permittedSubtypesClosure = permittedSubtypesClosure.tail;
            current.complete();
            if (!current.isSealed() || !current.isAbstract()) continue;
            for (Type t : current.getPermittedSubclasses()) {
                Symbol.ClassSymbol csym = (Symbol.ClassSymbol)t.tsym;
                if (!accept.test(csym)) continue;
                permittedSubtypesClosure = permittedSubtypesClosure.prepend(csym);
                permitted.add(csym);
            }
        }
        return permitted;
    }

    private List<Symbol.ClassSymbol> baseClasses(Symbol.TypeSymbol root) {
        if (root instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol clazz = (Symbol.ClassSymbol)root;
            return List.of(clazz);
        }
        if (root instanceof Symbol.TypeVariableSymbol) {
            Symbol.TypeVariableSymbol tvar = (Symbol.TypeVariableSymbol)root;
            ListBuffer<Symbol.ClassSymbol> result = new ListBuffer<Symbol.ClassSymbol>();
            for (Type bound : tvar.getBounds()) {
                result.appendList(this.baseClasses(bound.tsym));
            }
            return result.toList();
        }
        return List.nil();
    }

    private Set<PatternDescription> reduceNestedPatterns(Set<PatternDescription> patterns, boolean useHashes) {
        Map<Symbol.ClassSymbol, java.util.List<RecordPattern>> groupByRecordClass = patterns.stream().filter(pd -> pd instanceof RecordPattern).map(pd -> (RecordPattern)pd).collect(Collectors.groupingBy(pd -> (Symbol.ClassSymbol)pd.recordType.tsym));
        for (Map.Entry<Symbol.ClassSymbol, java.util.List<RecordPattern>> e : groupByRecordClass.entrySet()) {
            int nestedPatternsCount = ((List)e.getKey().getRecordComponents()).size();
            HashSet<RecordPattern> current = new HashSet<RecordPattern>((Collection)e.getValue());
            for (int mismatchingCandidate = 0; mismatchingCandidate < nestedPatternsCount; ++mismatchingCandidate) {
                int mismatchingCandidateFin = mismatchingCandidate;
                Map<Integer, java.util.List<RecordPattern>> groupEquivalenceCandidates = current.stream().filter(pd -> pd.nested.length == nestedPatternsCount).collect(Collectors.groupingBy(pd -> useHashes ? pd.hashCode(mismatchingCandidateFin) : 0));
                for (java.util.List<RecordPattern> candidates : groupEquivalenceCandidates.values()) {
                    RecordPattern[] candidatesArr = candidates.toArray(new RecordPattern[0]);
                    for (int firstCandidate = 0; firstCandidate < candidatesArr.length; ++firstCandidate) {
                        RecordPattern rpOne = candidatesArr[firstCandidate];
                        ListBuffer<RecordPattern> join = new ListBuffer<RecordPattern>();
                        join.append(rpOne);
                        for (int nextCandidate = 0; nextCandidate < candidatesArr.length; ++nextCandidate) {
                            if (firstCandidate == nextCandidate) continue;
                            RecordPattern rpOther = candidatesArr[nextCandidate];
                            if (rpOne.recordType.tsym != rpOther.recordType.tsym || !this.nestedComponentsEquivalent(rpOne, rpOther, mismatchingCandidate, useHashes)) continue;
                            join.append(rpOther);
                        }
                        Set<PatternDescription> nestedPatterns = join.stream().map(rp -> rp.nested[mismatchingCandidateFin]).collect(Collectors.toSet());
                        Set<PatternDescription> updatedPatterns = this.reduceNestedPatterns(nestedPatterns, useHashes);
                        updatedPatterns = this.reduceRecordPatterns(updatedPatterns);
                        updatedPatterns = this.removeCoveredRecordPatterns(updatedPatterns);
                        updatedPatterns = this.reduceBindingPatterns(rpOne.fullComponentTypes()[mismatchingCandidateFin], updatedPatterns);
                        if (nestedPatterns.equals(updatedPatterns)) continue;
                        if (useHashes) {
                            current.removeAll(join);
                        }
                        for (PatternDescription nested : updatedPatterns) {
                            PatternDescription[] newNested = Arrays.copyOf(rpOne.nested, rpOne.nested.length);
                            newNested[mismatchingCandidateFin] = nested;
                            RecordPattern nue = new RecordPattern(rpOne.recordType(), rpOne.fullComponentTypes(), newNested, new HashSet<PatternDescription>(join));
                            current.add(nue);
                        }
                    }
                }
            }
            if (current.equals(new HashSet(e.getValue()))) continue;
            HashSet<PatternDescription> result = new HashSet<PatternDescription>(patterns);
            result.removeAll((Collection)e.getValue());
            result.addAll(current);
            return result;
        }
        return patterns;
    }

    private boolean nestedComponentsEquivalent(RecordPattern existing, RecordPattern candidate, int mismatchingCandidate, boolean useHashes) {
        block0: for (int i = 0; i < existing.nested.length; ++i) {
            if (i == mismatchingCandidate || existing.nested[i].equals(candidate.nested[i])) continue;
            if (useHashes) {
                return false;
            }
            PatternDescription patternDescription = candidate.nested[i];
            if (!(patternDescription instanceof BindingPattern)) {
                return false;
            }
            BindingPattern nestedCandidate = (BindingPattern)patternDescription;
            PatternDescription patternDescription2 = existing.nested[i];
            if (patternDescription2 instanceof BindingPattern) {
                BindingPattern nestedExisting = (BindingPattern)patternDescription2;
                if (this.isSubtypeErasure(nestedExisting.type, nestedCandidate.type)) continue;
                return false;
            }
            patternDescription2 = existing.nested[i];
            if (patternDescription2 instanceof RecordPattern) {
                RecordPattern nestedExisting = (RecordPattern)patternDescription2;
                ArrayList<PatternDescription> pendingReplacedPatterns = new ArrayList<PatternDescription>(nestedCandidate.sourcePatterns());
                while (!pendingReplacedPatterns.isEmpty()) {
                    PatternDescription currentReplaced = (PatternDescription)pendingReplacedPatterns.remove(pendingReplacedPatterns.size() - 1);
                    if (nestedExisting.equals(currentReplaced)) continue block0;
                    pendingReplacedPatterns.addAll(currentReplaced.sourcePatterns());
                }
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean isSubtypeErasure(Type t, Type s) {
        Pair<Type, Type> key = Pair.of(t, s);
        return this.isSubtypeCache.computeIfAbsent(key, pair -> this.types.isSubtype(this.types.erasure(t), this.types.erasure(s)));
    }

    private Set<PatternDescription> reduceRecordPatterns(Set<PatternDescription> patterns) {
        HashSet<PatternDescription> newPatterns = new HashSet<PatternDescription>();
        boolean modified = false;
        for (PatternDescription pd : patterns) {
            RecordPattern rpOne;
            PatternDescription reducedPattern;
            if (pd instanceof RecordPattern && (reducedPattern = this.reduceRecordPattern(rpOne = (RecordPattern)pd)) != rpOne) {
                newPatterns.add(reducedPattern);
                modified = true;
                continue;
            }
            newPatterns.add(pd);
        }
        return modified ? newPatterns : patterns;
    }

    private PatternDescription reduceRecordPattern(PatternDescription pattern) {
        if (pattern instanceof RecordPattern) {
            RecordPattern rpOne = (RecordPattern)pattern;
            Type[] componentType = rpOne.fullComponentTypes();
            if (componentType.length != rpOne.nested.length) {
                return pattern;
            }
            PatternDescription[] reducedNestedPatterns = null;
            boolean covered = true;
            for (int i = 0; i < componentType.length; ++i) {
                PatternDescription newNested = this.reduceRecordPattern(rpOne.nested[i]);
                if (newNested != rpOne.nested[i]) {
                    if (reducedNestedPatterns == null) {
                        reducedNestedPatterns = Arrays.copyOf(rpOne.nested, rpOne.nested.length);
                    }
                    reducedNestedPatterns[i] = newNested;
                }
                covered &= this.checkCovered(componentType[i], List.of(newNested));
            }
            if (covered) {
                BindingPattern pd = new BindingPattern(rpOne.recordType, Collections.unmodifiableSet(new HashSet<PatternDescription>(Arrays.asList(pattern))));
                return pd;
            }
            if (reducedNestedPatterns != null) {
                RecordPattern pd = new RecordPattern(rpOne.recordType, rpOne.fullComponentTypes(), reducedNestedPatterns, Collections.unmodifiableSet(new HashSet<PatternDescription>(Arrays.asList(pattern))));
                return pd;
            }
        }
        return pattern;
    }

    private Set<PatternDescription> removeCoveredRecordPatterns(Set<PatternDescription> patterns) {
        Set existingBindings = patterns.stream().filter(pd -> pd instanceof BindingPattern).map(pd -> ((BindingPattern)pd).type.tsym).collect(Collectors.toSet());
        HashSet<PatternDescription> result = new HashSet<PatternDescription>(patterns);
        Iterator it = result.iterator();
        while (it.hasNext()) {
            PatternDescription pd2 = (PatternDescription)it.next();
            if (!(pd2 instanceof RecordPattern)) continue;
            RecordPattern rp = (RecordPattern)pd2;
            if (!existingBindings.contains(rp.recordType.tsym)) continue;
            it.remove();
        }
        return result;
    }

    private boolean isBpCovered(Type componentType, PatternDescription newNested) {
        if (newNested instanceof BindingPattern) {
            BindingPattern bp = (BindingPattern)newNested;
            Type seltype = this.types.erasure(componentType);
            Type pattype = this.types.erasure(bp.type);
            return seltype.isPrimitive() ? this.types.isUnconditionallyExactTypeBased(seltype, pattype) : bp.type.isPrimitive() && this.types.isUnconditionallyExactTypeBased(this.types.unboxedType(seltype), bp.type) || this.types.isSubtype(seltype, pattype);
        }
        return false;
    }

    public PatternDescription makePatternDescription(Type selectorType, JCTree.JCPattern pattern) {
        if (pattern instanceof JCTree.JCBindingPattern) {
            JCTree.JCBindingPattern binding = (JCTree.JCBindingPattern)pattern;
            Type type = !selectorType.isPrimitive() && this.types.isSubtype(selectorType, binding.type) ? selectorType : binding.type;
            return new BindingPattern(type);
        }
        if (pattern instanceof JCTree.JCRecordPattern) {
            JCTree.JCRecordPattern record = (JCTree.JCRecordPattern)pattern;
            Type[] componentTypes = !record.type.isErroneous() ? ((List)((Symbol.ClassSymbol)record.type.tsym).getRecordComponents()).map(r -> this.types.memberType(record.type, (Symbol)r)).toArray(new Type[0]) : record.nested.map(t -> this.types.createErrorType(t.type)).toArray(new Type[0]);
            PatternDescription[] nestedDescriptions = new PatternDescription[record.nested.size()];
            int i = 0;
            List<JCTree.JCPattern> it = record.nested;
            while (it.nonEmpty()) {
                Type componentType = i < componentTypes.length ? componentTypes[i] : this.syms.errType;
                nestedDescriptions[i] = this.makePatternDescription(this.types.erasure(componentType), (JCTree.JCPattern)it.head);
                it = it.tail;
                ++i;
            }
            return new RecordPattern(record.type, componentTypes, nestedDescriptions);
        }
        if (pattern instanceof JCTree.JCAnyPattern) {
            return new BindingPattern(selectorType);
        }
        throw Assert.error();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static interface PatternDescription {
        public Set<PatternDescription> sourcePatterns();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    record BindingPattern(Type type, Set<PatternDescription> sourcePatterns) implements PatternDescription
    {
        public BindingPattern(Type type) {
            this(type, Collections.unmodifiableSet(new HashSet<PatternDescription>(Arrays.asList(new PatternDescription[0]))));
        }

        @Override
        public int hashCode() {
            return this.type.tsym.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            if (!(o instanceof BindingPattern)) return false;
            BindingPattern other = (BindingPattern)o;
            if (this.type.tsym != other.type.tsym) return false;
            return true;
        }

        @Override
        public String toString() {
            return String.valueOf(this.type.tsym) + " _";
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    record RecordPattern(Type recordType, int _hashCode, Type[] fullComponentTypes, PatternDescription[] nested, Set<PatternDescription> sourcePatterns) implements PatternDescription
    {
        public RecordPattern(Type recordType, Type[] fullComponentTypes, PatternDescription[] nested) {
            this(recordType, fullComponentTypes, nested, Collections.unmodifiableSet(new HashSet<PatternDescription>(Arrays.asList(new PatternDescription[0]))));
        }

        public RecordPattern(Type recordType, Type[] fullComponentTypes, PatternDescription[] nested, Set<PatternDescription> sourcePatterns) {
            this(recordType, RecordPattern.hashCode(-1, recordType, nested), fullComponentTypes, nested, sourcePatterns);
        }

        @Override
        public int hashCode() {
            return this._hashCode;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            if (!(o instanceof RecordPattern)) return false;
            RecordPattern other = (RecordPattern)o;
            if (this.recordType.tsym != other.recordType.tsym) return false;
            if (!Arrays.equals(this.nested, other.nested)) return false;
            return true;
        }

        public int hashCode(int excludeComponent) {
            return RecordPattern.hashCode(excludeComponent, this.recordType, this.nested);
        }

        public static int hashCode(int excludeComponent, Type recordType, PatternDescription ... nested) {
            int hash = 5;
            hash = 41 * hash + recordType.tsym.hashCode();
            for (int i = 0; i < nested.length; ++i) {
                if (i == excludeComponent) continue;
                hash = 41 * hash + nested[i].hashCode();
            }
            return hash;
        }

        @Override
        public String toString() {
            return String.valueOf(this.recordType.tsym) + "(" + Arrays.stream(this.nested).map(pd -> pd.toString()).collect(Collectors.joining(", ")) + ")";
        }
    }
}

