/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.yaml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.languages.yaml.YamlParserResult;
import org.openide.util.Exceptions;

public class YamlScanner
implements StructureScanner {
    private static final Logger LOGGER = Logger.getLogger(YamlScanner.class.getName());

    public List<? extends StructureItem> scan(ParserResult info) {
        YamlParserResult result = (YamlParserResult)info;
        return result.getItems();
    }

    public Map<String, List<OffsetRange>> folds(ParserResult info) {
        Map<String, List<OffsetRange>> folds = Collections.emptyMap();
        List<? extends StructureItem> items = this.scan(info);
        if (!items.isEmpty()) {
            folds = new HashMap<String, List<OffsetRange>>();
            ArrayList<OffsetRange> codeblocks = new ArrayList<OffsetRange>();
            folds.put("tags", codeblocks);
            BaseDocument doc = (BaseDocument)info.getSnapshot().getSource().getDocument(false);
            for (StructureItem structureItem : items) {
                try {
                    this.addBlocks(doc, info.getSnapshot().getText(), codeblocks, structureItem);
                }
                catch (BadLocationException ble) {
                    Exceptions.printStackTrace((Throwable)ble);
                    break;
                }
            }
        }
        return folds;
    }

    private void addBlocks(BaseDocument doc, CharSequence text, List<OffsetRange> codeblocks, StructureItem item) throws BadLocationException {
        int lastRowEnd;
        int docLength = doc == null ? text.length() : doc.getLength();
        int begin = Math.min((int)item.getPosition(), docLength);
        int end = Math.min((int)item.getEndPosition(), docLength);
        int firstRowEnd = doc == null ? GsfUtilities.getRowEnd((CharSequence)text, (int)begin) : LineDocumentUtils.getLineEndOffset((LineDocument)doc, (int)begin);
        int n = lastRowEnd = doc == null ? GsfUtilities.getRowEnd((CharSequence)text, (int)end) : LineDocumentUtils.getLineEndOffset((LineDocument)doc, (int)end);
        if (begin >= end || firstRowEnd == lastRowEnd) {
            return;
        }
        codeblocks.add(new OffsetRange(firstRowEnd, end));
        for (StructureItem child : item.getNestedItems()) {
            int childBegin = (int)child.getPosition();
            int childEnd = (int)child.getEndPosition();
            if (childBegin < begin || childEnd > end) continue;
            this.addBlocks(doc, text, codeblocks, child);
        }
    }

    public StructureScanner.Configuration getConfiguration() {
        return new StructureScanner.Configuration(false, false, 0);
    }
}

