/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.light;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.websvc.api.support.RefreshCookie;
import org.netbeans.modules.websvc.api.wseditor.InvalidDataException;
import org.netbeans.modules.websvc.api.wseditor.WSEditor;
import org.netbeans.modules.websvc.customization.multiview.SaveableSectionInnerPanel;
import org.netbeans.modules.websvc.customization.multiview.WSCustomizationTopComponent;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CustomizationWSEditor
implements WSEditor {
    private WSCustomizationTopComponent wsTopComponent;
    private boolean wsdlIsDirty;
    private Definitions primaryDefinitions;
    private UndoManager undoManager;
    private JAXWSLightSupport jaxWsSupport;
    private JaxWsService service;
    private Map<WSDLModel, Boolean> wsdlModels = new HashMap<WSDLModel, Boolean>();

    public CustomizationWSEditor(JAXWSLightSupport jaxWsSupport, JaxWsService service) {
        this.jaxWsSupport = jaxWsSupport;
        this.service = service;
    }

    public CustomizationWSEditor() {
    }

    private void saveAndRefresh(final Node node) {
        Collection<SaveableSectionInnerPanel> panels = this.wsTopComponent.getPanels();
        for (SaveableSectionInnerPanel saveableSectionInnerPanel : panels) {
            saveableSectionInnerPanel.save();
            if (this.wsdlIsDirty) continue;
            this.wsdlIsDirty = saveableSectionInnerPanel.wsdlIsDirty();
        }
        try {
            if (this.wsdlIsDirty) {
                Set<WSDLModel> modelSet = this.wsdlModels.keySet();
                for (WSDLModel wsdlModel : modelSet) {
                    ModelSource ms = wsdlModel.getModelSource();
                    FileObject fo = (FileObject)ms.getLookup().lookup(FileObject.class);
                    DataObject wsdlDO = DataObject.find((FileObject)fo);
                    SaveCookie wsdlSaveCookie = (SaveCookie)wsdlDO.getCookie(SaveCookie.class);
                    if (wsdlSaveCookie == null) continue;
                    wsdlSaveCookie.save();
                }
            }
            final ProgressHandle handle = ProgressHandle.createHandle((String)NbBundle.getMessage(CustomizationWSEditor.class, (String)"TXT_Refreshing"));
            handle.start(100);
            handle.switchToIndeterminate();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        RefreshCookie refreshCookie;
                        if (CustomizationWSEditor.this.wsdlIsDirty && (refreshCookie = (RefreshCookie)node.getCookie(RefreshCookie.class)) != null) {
                            refreshCookie.refreshService(false);
                        }
                    }
                    finally {
                        handle.finish();
                    }
                }
            };
            RequestProcessor.getDefault().post(runnable);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    public void save(Node node) {
        this.saveAndRefresh(node);
        this.removeListeners();
    }

    public JComponent createWSEditorComponent(Node node) throws InvalidDataException {
        try {
            this.initializeModels(node);
        }
        catch (InvalidDataException ex) {
            throw ex;
        }
        catch (Exception e) {
            Logger.getLogger(CustomizationWSEditor.class.getName()).log(Level.FINE, "Cannot create WSEditor Component", e);
        }
        this.wsTopComponent = new WSCustomizationTopComponent(node, this.getWSDLModels(), this.primaryDefinitions, true);
        this.wsTopComponent.setName(this.getTitle());
        return this.wsTopComponent;
    }

    public String getTitle() {
        return NbBundle.getMessage(CustomizationWSEditor.class, (String)"TITLE_WSDL_CUSTOMIZATION");
    }

    public Set<WSDLModel> getWSDLModels() {
        return this.wsdlModels.keySet();
    }

    private void initializeModels(Node node) throws IOException, CatalogModelException, InvalidDataException {
        if (this.wsdlModels.isEmpty()) {
            this.undoManager = new UndoManager();
            WSDLModel primaryModel = this.getPrimaryModel(node);
            this.populateAllModels(primaryModel);
            Set<WSDLModel> modelSet = this.wsdlModels.keySet();
            for (WSDLModel wsdlModel : modelSet) {
                wsdlModel.addUndoableEditListener((UndoableEditListener)this.undoManager);
            }
        }
    }

    private void removeListeners() {
        Set<WSDLModel> modelSet = this.wsdlModels.keySet();
        for (WSDLModel wsdlModel : modelSet) {
            wsdlModel.removeUndoableEditListener((UndoableEditListener)this.undoManager);
        }
    }

    private DataObject getDataObjectOfModel(WSDLModel wsdlModel) {
        ModelSource ms = wsdlModel.getModelSource();
        return (DataObject)ms.getLookup().lookup(DataObject.class);
    }

    private boolean modelExists(WSDLModel wsdlModel) {
        if (this.wsdlModels.size() == 0) {
            return false;
        }
        DataObject modelDobj = this.getDataObjectOfModel(wsdlModel);
        if (!modelDobj.isValid()) {
            return true;
        }
        Set<WSDLModel> wsdls = this.wsdlModels.keySet();
        for (WSDLModel wsdl : wsdls) {
            DataObject dobj = this.getDataObjectOfModel(wsdl);
            if (!dobj.isValid() || !modelDobj.equals(dobj)) continue;
            return true;
        }
        return false;
    }

    private void populateAllModels(WSDLModel wsdlModel) throws CatalogModelException {
        if (this.modelExists(wsdlModel)) {
            return;
        }
        DataObject dobj = this.getDataObjectOfModel(wsdlModel);
        if (!dobj.isValid()) {
            return;
        }
        Definitions definitions = wsdlModel.getDefinitions();
        if (definitions.getImports().size() == 0) {
            this.wsdlModels.put(wsdlModel, dobj.isModified());
            return;
        }
        this.wsdlModels.put(wsdlModel, dobj.isModified());
        Set<WSDLModel> modelSet = this.getImportedModels(definitions);
        for (WSDLModel wModel : modelSet) {
            this.populateAllModels(wModel);
        }
    }

    private Set<WSDLModel> getImportedModels(Definitions definitions) throws CatalogModelException {
        HashSet<WSDLModel> importedModels = new HashSet<WSDLModel>();
        Collection importedWsdls = definitions.getImports();
        for (Import importedWsdl : importedWsdls) {
            WSDLModel wsdlModel = importedWsdl.getImportedWSDLModel();
            importedModels.add(wsdlModel);
        }
        return importedModels;
    }

    private WSDLModel getPrimaryModel(Node node) throws MalformedURLException, IOException, InvalidDataException {
        WSDLModel model = null;
        FileObject wsdlFO = null;
        if (this.jaxWsSupport == null) {
            return null;
        }
        FileObject wsdlFolder = this.jaxWsSupport.getWsdlFolder(false);
        if (wsdlFolder != null) {
            wsdlFO = wsdlFolder.getFileObject(this.service.getLocalWsdl());
            if (wsdlFO != null) {
                ModelSource ms = Utilities.getModelSource((FileObject)wsdlFO, (boolean)true);
                model = WSDLModelFactory.getDefault().getModel(ms);
            } else {
                this.notifyWsdlAbsence();
            }
        } else {
            this.notifyWsdlAbsence();
        }
        this.primaryDefinitions = model.getDefinitions();
        return model;
    }

    private void notifyWsdlAbsence() throws InvalidDataException {
        throw new InvalidDataException("WSDL not found", NbBundle.getMessage(CustomizationWSEditor.class, (String)"TXT_WsdlNotFound"));
    }

    public void cancel(Node node) {
        if (this.undoManager != null) {
            while (this.undoManager.canUndo()) {
                this.undoManager.undo();
            }
        }
        try {
            Set<WSDLModel> modelSet = this.wsdlModels.keySet();
            for (WSDLModel wsdlModel : modelSet) {
                ModelSource ms = wsdlModel.getModelSource();
                FileObject fo = (FileObject)ms.getLookup().lookup(FileObject.class);
                DataObject wsdlDobj = DataObject.find((FileObject)fo);
                wsdlDobj.setModified(this.wsdlModels.get(wsdlModel).booleanValue());
            }
        }
        catch (DataObjectNotFoundException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        this.removeListeners();
    }

    public String getDescription() {
        return NbBundle.getMessage(CustomizationWSEditor.class, (String)"WSDL_CUSTOMIZE_DESC");
    }
}

