/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.netbeans.lib.profiler.heap.File;
import org.netbeans.lib.profiler.heap.RandomAccessFile;

final class JavaIoFile
extends File {
    static final File.Factory IO = new File.Factory(){

        @Override
        public File newFile(File parent, String relative) {
            return new JavaIoFile(this, (JavaIoFile)parent, relative);
        }

        @Override
        public File newFile(String fileName) {
            return new JavaIoFile((File.Factory)this, fileName);
        }

        @Override
        public File newFile(java.io.File real) {
            return new JavaIoFile((File.Factory)this, real);
        }

        @Override
        public File createTempFile(String prefix, String suffix, File cacheDirectory) throws IOException {
            if (cacheDirectory == null) {
                return this.newFile(Files.createTempFile(prefix, suffix, new FileAttribute[0]).toFile());
            }
            return this.newFile(Files.createTempFile(((JavaIoFile)cacheDirectory).delegate.toPath(), prefix, suffix, new FileAttribute[0]).toFile());
        }
    };
    final java.io.File delegate;

    private JavaIoFile(File.Factory io, JavaIoFile parent, String relative) {
        this(io, new java.io.File(parent.delegate, relative));
    }

    private JavaIoFile(File.Factory io, String fileName) {
        this(io, new java.io.File(fileName));
    }

    private JavaIoFile(File.Factory io, java.io.File real) {
        super(io);
        this.delegate = real;
    }

    @Override
    String getAbsolutePath() {
        return this.delegate.getAbsolutePath();
    }

    @Override
    String getName() {
        return this.delegate.getName();
    }

    @Override
    File getParentFile() {
        return this.io.newFile(this.delegate.getParentFile());
    }

    @Override
    boolean exists() {
        return this.delegate.exists();
    }

    @Override
    boolean mkdir() {
        return this.delegate.mkdir();
    }

    @Override
    void deleteOnExit() {
        this.delegate.deleteOnExit();
    }

    @Override
    boolean isDirectory() {
        return this.delegate.isDirectory();
    }

    @Override
    boolean canRead() {
        return this.delegate.canRead();
    }

    @Override
    boolean canWrite() {
        return this.delegate.canWrite();
    }

    @Override
    boolean isFile() {
        return this.delegate.isFile();
    }

    @Override
    long length() {
        return this.delegate.length();
    }

    @Override
    boolean delete() {
        return this.delegate.delete();
    }

    @Override
    boolean renameTo(File bufferFile) {
        if (bufferFile instanceof JavaIoFile) {
            return this.delegate.renameTo(((JavaIoFile)bufferFile).delegate);
        }
        return false;
    }

    @Override
    RandomAccessFile newRandomAccessFile(String mode) throws FileNotFoundException {
        return new RandomAccess(this, mode);
    }

    @Override
    DataOutputStream newDataOutputStream(int bufferSize) throws FileNotFoundException {
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.delegate), bufferSize));
    }

    @Override
    DataInputStream newDataInputStream(int bufferLength) throws FileNotFoundException {
        return new DataInputStream(new BufferedInputStream(new FileInputStream(this.delegate), bufferLength));
    }

    @Override
    ByteBuffer mmapReadOnly() throws IOException {
        try (FileChannel channel = new FileInputStream(this.delegate).getChannel();){
            MappedByteBuffer mappedByteBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
            return mappedByteBuffer;
        }
    }

    @Override
    ByteBuffer force(FileChannel.MapMode mode, ByteBuffer buf) throws IOException {
        if (mode == FileChannel.MapMode.PRIVATE) {
            java.io.File newBufferFile = new java.io.File(this.delegate.getAbsolutePath() + ".new");
            int length = buf.capacity();
            new FileOutputStream(newBufferFile).getChannel().write(buf);
            this.delegate.delete();
            newBufferFile.renameTo(this.delegate);
            return this.newRandomAccessFile("rw").mmap(mode, length, true);
        }
        ((MappedByteBuffer)buf).force();
        return buf;
    }

    @Override
    ByteBuffer[] mmapReadOnlyAsBuffers(long[] length, long bufferSize, long bufferExt) throws IOException {
        FileInputStream fis = new FileInputStream(this.delegate);
        try (FileChannel channel = fis.getChannel();){
            length[0] = channel.size();
            ByteBuffer[] buffers = new ByteBuffer[(int)((length[0] + bufferSize - 1L) / bufferSize)];
            for (int i = 0; i < buffers.length; ++i) {
                long position = (long)i * bufferSize;
                long size = Math.min(bufferSize + bufferExt, length[0] - position);
                buffers[i] = channel.map(FileChannel.MapMode.READ_ONLY, position, size);
            }
            ByteBuffer[] byteBufferArray = buffers;
            return byteBufferArray;
        }
    }

    @Override
    ByteBuffer[] force(FileChannel.MapMode MAP_MODE, ByteBuffer[] dumpBuffer, long bufferSize, long bufferExt, long entrySize) throws IOException {
        if (MAP_MODE == FileChannel.MapMode.PRIVATE) {
            java.io.File newBufferFile = new java.io.File(this.getAbsolutePath() + ".new");
            long length = this.delegate.length();
            FileChannel channel = new FileOutputStream(newBufferFile).getChannel();
            int offset_start = 0;
            for (int i = 0; i < dumpBuffer.length; ++i) {
                ByteBuffer buf = dumpBuffer[i];
                long offset_end = (long)(i + 1) * bufferSize / entrySize * entrySize + entrySize;
                if (offset_end > length) {
                    offset_end = length;
                }
                buf.limit((int)(offset_end - (long)i * bufferSize));
                buf.position(offset_start);
                channel.write(buf);
                offset_start = (int)(offset_end - (long)(i + 1) * bufferSize);
            }
            this.delegate.delete();
            newBufferFile.renameTo(this.delegate);
            return this.newRandomAccessFile("rw").mmapAsBuffers(MAP_MODE, length, bufferSize, bufferExt);
        }
        for (ByteBuffer buf : dumpBuffer) {
            ((MappedByteBuffer)buf).force();
        }
        return dumpBuffer;
    }

    private static final class RandomAccess
    extends RandomAccessFile {
        private final java.io.RandomAccessFile delegate;

        RandomAccess(JavaIoFile file, String mode) throws FileNotFoundException {
            this.delegate = new java.io.RandomAccessFile(file.delegate, mode);
        }

        @Override
        long length() throws IOException {
            return this.delegate.length();
        }

        @Override
        void write(byte[] arr) throws IOException {
            this.delegate.write(arr);
        }

        @Override
        void write(byte[] arr, int off, int len) throws IOException {
            this.delegate.write(arr, off, len);
        }

        @Override
        void setLength(long fileSize) throws IOException {
            this.delegate.setLength(fileSize);
        }

        @Override
        void seek(long newOffset) throws IOException {
            this.delegate.seek(newOffset);
        }

        @Override
        void readFully(byte[] buf, int off, int len) throws IOException {
            this.delegate.readFully(buf, off, len);
        }

        @Override
        void readFully(byte[] buf) throws IOException {
            this.delegate.readFully(buf);
        }

        @Override
        long readLong() throws IOException {
            return this.delegate.readLong();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        ByteBuffer mmap(FileChannel.MapMode mode, long size, boolean close) throws IOException {
            FileChannel ch = this.delegate.getChannel();
            try {
                MappedByteBuffer mappedByteBuffer = ch.map(mode, 0L, size);
                return mappedByteBuffer;
            }
            finally {
                if (close) {
                    ch.close();
                }
            }
        }

        @Override
        ByteBuffer[] mmapAsBuffers(FileChannel.MapMode mode, long length, long BUFFER_SIZE, long BUFFER_EXT) throws IOException {
            try (FileChannel channel = this.delegate.getChannel();){
                ByteBuffer[] dumpBuffer = new ByteBuffer[(int)((length + BUFFER_SIZE - 1L) / BUFFER_SIZE)];
                for (int i = 0; i < dumpBuffer.length; ++i) {
                    long position = (long)i * BUFFER_SIZE;
                    long size = Math.min(BUFFER_SIZE + BUFFER_EXT, length - position);
                    dumpBuffer[i] = channel.map(mode, position, size);
                }
                ByteBuffer[] byteBufferArray = dumpBuffer;
                return byteBufferArray;
            }
        }
    }
}

