/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.actions;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbPreferences;

public class ShowNotifications {
    private static final Logger LOGGER = Logger.getLogger(ShowNotifications.class.getName());
    private static final String SEPARATOR = " ";
    private static final String PROP = "shown-notifications";
    private static final Map<String, Notification> notifications = new HashMap<String, Notification>();

    public static void checkNotification(UpdateUnitProvider p) {
        LOGGER.finest("Checking notification for " + p.getDisplayName());
        String m = ShowNotifications.getMessage(p);
        if (m != null) {
            LOGGER.finest("Check message " + m.hashCode() + " to show... \n" + m + "\n");
            if (ShowNotifications.add(m)) {
                LOGGER.finest("Show message " + m.hashCode());
                ShowNotifications.showNotification(m, p);
            } else {
                LOGGER.finest("Message " + m.hashCode() + "... was already shown");
            }
        }
    }

    private static String getMessage(UpdateUnitProvider p) {
        String token;
        String desc = p.getDescription();
        if (desc != null && desc.indexOf(token = "<a name=\"autoupdate_catalog_parser\"") != -1) {
            return desc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static boolean add(String notification) {
        Class<ShowNotifications> clazz = ShowNotifications.class;
        synchronized (ShowNotifications.class) {
            Preferences p = NbPreferences.root().node("/org/netbeans/modules/autoupdate/ui");
            ArrayList<Object> alreadyShown = new ArrayList<Object>();
            for (String string : p.get(PROP, "").split(SEPARATOR)) {
                if (string.length() <= 0) continue;
                alreadyShown.add(string);
            }
            boolean add = true;
            String hashCode = "" + notification.hashCode();
            for (String string : alreadyShown) {
                if (!hashCode.equals(string)) continue;
                add = false;
            }
            if (add) {
                void var7_14;
                alreadyShown.add(hashCode);
                StringBuilder sb = new StringBuilder();
                boolean bl = false;
                while (var7_14 < alreadyShown.size()) {
                    if (var7_14 != false) {
                        sb.append(SEPARATOR);
                    }
                    sb.append((String)alreadyShown.get((int)var7_14));
                    ++var7_14;
                }
                p.put(PROP, sb.toString());
            }
            // ** MonitorExit[clazz] (shouldn't be in output)
            return add;
        }
    }

    private static void showNotification(String notification, UpdateUnitProvider p) {
        if (notifications.get(p.getName()) != null) {
            notifications.get(p.getName()).clear();
        }
        Notification n = NotificationDisplayer.getDefault().notify(ShowNotifications.getTitle(notification), (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/autoupdate/ui/resources/info_icon.png", (boolean)false), (JComponent)ShowNotifications.createInfoPanel(notification), (JComponent)ShowNotifications.createInfoPanel(notification), NotificationDisplayer.Priority.HIGH);
        notifications.put(p.getName(), n);
    }

    private static String getTitle(String notification) {
        return ShowNotifications.getMessagePart(notification, true);
    }

    private static String getDetails(String notification) {
        return ShowNotifications.getMessagePart(notification, false);
    }

    private static String getMessagePart(String message, boolean leading) {
        String[] sep;
        String title = message;
        for (String s : sep = new String[]{"\r\n", "\r", "\n", "<br>", "<br/>"}) {
            if (title.indexOf(s) != 0) continue;
            title = ShowNotifications.getMessagePart(title.substring(s.length()), leading);
        }
        String sp = null;
        int idx = -1;
        for (String s : sep) {
            int i = title.indexOf(s);
            if (i == -1 || idx != -1 && i >= idx) continue;
            sp = s;
            idx = i;
        }
        if (sp == null) {
            return leading ? title : "";
        }
        return leading ? title.substring(0, idx) : title.substring(idx + sp.length());
    }

    private static JTextPane createInfoPanel(String notification) {
        JTextPane balloon = new JTextPane();
        balloon.setContentType("text/html");
        String text = ShowNotifications.getDetails(notification).replaceAll("(\r\n|\n|\r)", "<br>");
        balloon.setText(text);
        balloon.setOpaque(false);
        balloon.setEditable(false);
        balloon.setBorder(new EmptyBorder(0, 0, 0, 0));
        if (UIManager.getLookAndFeel().getID().equals("Nimbus")) {
            balloon.setBackground(new Color(0, 0, 0, 0));
        }
        balloon.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(e.getURL());
                }
            }
        });
        return balloon;
    }
}

