/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.modules.profiler.snaptracer.PackageStateHandler;
import org.netbeans.modules.profiler.snaptracer.Positionable;
import org.netbeans.modules.profiler.snaptracer.ProbeStateHandler;
import org.netbeans.modules.profiler.snaptracer.TracerPackage;
import org.netbeans.modules.profiler.snaptracer.TracerProbe;
import org.netbeans.modules.profiler.snaptracer.TracerProbeDescriptor;
import org.netbeans.modules.profiler.snaptracer.impl.IdeSnapshot;
import org.netbeans.modules.profiler.snaptracer.impl.TracerController;
import org.netbeans.modules.profiler.snaptracer.impl.TracerSupportImpl;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineSupport;
import org.openide.util.Exceptions;

public final class TracerModel {
    private static final Logger LOGGER = Logger.getLogger(TracerController.class.getName());
    private final IdeSnapshot snapshot;
    private final Map<TracerPackage, List<TracerProbe>> probesCache = new HashMap<TracerPackage, List<TracerProbe>>();
    private final Map<TracerProbe, TracerProbeDescriptor> descriptorsCache = new HashMap<TracerProbe, TracerProbeDescriptor>();
    private final Set<Listener> listeners = new HashSet<Listener>();
    private final TimelineSupport timelineSupport;

    public TracerModel(IdeSnapshot snapshot) {
        this.snapshot = snapshot;
        this.timelineSupport = new TimelineSupport(new TimelineSupport.DescriptorResolver(){

            @Override
            public TracerProbeDescriptor getDescriptor(TracerProbe p) {
                return TracerModel.this.getDescriptor(p);
            }
        }, snapshot);
    }

    IdeSnapshot getSnapshot() {
        return this.snapshot;
    }

    int getSamplesCount() {
        return this.snapshot.getSamplesCount();
    }

    long firstTimestamp() {
        return this.getTimestamp(0);
    }

    long lastTimestamp() {
        return this.getTimestamp(this.getSamplesCount() - 1);
    }

    long getTimestamp(int sampleIndex) {
        try {
            return this.snapshot.getTimestamp(sampleIndex) / 1000000L;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return -1L;
        }
    }

    List<TracerPackage> getPackages() {
        try {
            return TracerSupportImpl.getInstance().getPackages(this.snapshot);
        }
        catch (Throwable t) {
            LOGGER.log(Level.INFO, "Package exception in getPackages", t);
            return null;
        }
    }

    void addDescriptor(final TracerPackage p, final TracerProbeDescriptor d) {
        TracerSupportImpl.getInstance().perform(new Runnable(){

            @Override
            public void run() {
                TracerModel.this.addProbe(p, d);
            }
        });
    }

    void removeDescriptor(final TracerPackage p, final TracerProbeDescriptor d) {
        TracerSupportImpl.getInstance().perform(new Runnable(){

            @Override
            public void run() {
                TracerModel.this.removeProbe(p, d);
            }
        });
    }

    void addDescriptors(TracerPackage p, TracerProbeDescriptor[] da) {
        for (TracerProbeDescriptor d : da) {
            this.addProbe(p, d);
        }
    }

    void removeDescriptors(TracerPackage p, TracerProbeDescriptor[] da) {
        for (TracerProbeDescriptor d : da) {
            this.removeProbe(p, d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TracerProbeDescriptor getDescriptor(TracerProbe p) {
        Map<TracerProbe, TracerProbeDescriptor> map = this.descriptorsCache;
        synchronized (map) {
            return this.descriptorsCache.get(p);
        }
    }

    List<TracerProbe> getDefinedProbes() {
        ArrayList<TracerProbe> probes = new ArrayList<TracerProbe>();
        probes.addAll(this.timelineSupport.getProbes());
        return probes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Map.Entry<TracerPackage, List<TracerProbe>>> getDefinedProbeSets() {
        Comparator<Map.Entry<TracerPackage, List<TracerProbe>>> comp = new Comparator<Map.Entry<TracerPackage, List<TracerProbe>>>(){

            @Override
            public int compare(Map.Entry<TracerPackage, List<TracerProbe>> o1, Map.Entry<TracerPackage, List<TracerProbe>> o2) {
                return Positionable.STRONG_COMPARATOR.compare(o1.getKey(), o2.getKey());
            }
        };
        TreeSet<Map.Entry<TracerPackage, List<TracerProbe>>> probes = new TreeSet<Map.Entry<TracerPackage, List<TracerProbe>>>(comp);
        Map<TracerPackage, List<TracerProbe>> map = this.probesCache;
        synchronized (map) {
            probes.addAll(this.probesCache.entrySet());
        }
        return probes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean areProbesDefined() {
        Map<TracerPackage, List<TracerProbe>> map = this.probesCache;
        synchronized (map) {
            return !this.probesCache.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addProbe(TracerPackage p, TracerProbeDescriptor d) {
        TracerProbe r = p.getProbe(d);
        Map<Object, Object> map = this.descriptorsCache;
        synchronized (map) {
            this.descriptorsCache.put(r, d);
        }
        map = this.probesCache;
        synchronized (map) {
            List<TracerProbe> probes = this.probesCache.get(p);
            if (probes == null) {
                probes = new ArrayList<TracerProbe>();
                this.probesCache.put(p, probes);
            }
            probes.add(r);
        }
        this.timelineSupport.addProbe(r);
        this.notifyProbeAdded(p, r);
        this.fireProbeAdded(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProbe(TracerPackage p, TracerProbeDescriptor d) {
        TracerProbe probe = null;
        boolean probesDefined = true;
        Map<Object, Object> map = this.descriptorsCache;
        synchronized (map) {
            for (Map.Entry<TracerProbe, TracerProbeDescriptor> entry : this.descriptorsCache.entrySet()) {
                if (entry.getValue() != d) continue;
                probe = entry.getKey();
                break;
            }
            this.descriptorsCache.remove(probe);
        }
        map = this.probesCache;
        synchronized (map) {
            List<TracerProbe> probes = this.probesCache.get(p);
            probes.remove(probe);
            if (probes.isEmpty()) {
                this.probesCache.remove(p);
                probesDefined = !this.probesCache.isEmpty();
            }
        }
        this.timelineSupport.removeProbe(probe);
        this.notifyProbeRemoved(p, probe);
        this.fireProbeRemoved(probe, probesDefined);
    }

    private void notifyProbeAdded(TracerPackage p, TracerProbe r) {
        ProbeStateHandler rh;
        PackageStateHandler ph = p.getStateHandler();
        if (ph != null) {
            try {
                ph.probeAdded(r, this.snapshot);
            }
            catch (Throwable t) {
                LOGGER.log(Level.INFO, "Package exception in probeAdded", t);
            }
        }
        if ((rh = r.getStateHandler()) != null) {
            try {
                rh.probeAdded(this.snapshot);
            }
            catch (Throwable t) {
                LOGGER.log(Level.INFO, "Probe exception in probeAdded", t);
            }
        }
    }

    private void notifyProbeRemoved(TracerPackage p, TracerProbe r) {
        ProbeStateHandler rh;
        PackageStateHandler ph = p.getStateHandler();
        if (ph != null) {
            try {
                ph.probeRemoved(r, this.snapshot);
            }
            catch (Throwable t) {
                LOGGER.log(Level.INFO, "Package exception in probeRemoved", t);
            }
        }
        if ((rh = r.getStateHandler()) != null) {
            try {
                rh.probeRemoved(this.snapshot);
            }
            catch (Throwable t) {
                LOGGER.log(Level.INFO, "Probe exception in probeRemoved", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(Listener listener) {
        Set<Listener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(Listener listener) {
        Set<Listener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProbeAdded(final TracerProbe probe) {
        final HashSet<Listener> toNotify = new HashSet<Listener>();
        Set<Listener> set = this.listeners;
        synchronized (set) {
            toNotify.addAll(this.listeners);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Listener listener : toNotify) {
                    listener.probeAdded(probe);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProbeRemoved(final TracerProbe probe, final boolean probesDefined) {
        final HashSet<Listener> toNotify = new HashSet<Listener>();
        Set<Listener> set = this.listeners;
        synchronized (set) {
            toNotify.addAll(this.listeners);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Listener listener : toNotify) {
                    listener.probeRemoved(probe, probesDefined);
                }
            }
        });
    }

    TimelineSupport getTimelineSupport() {
        return this.timelineSupport;
    }

    List<Integer> getIntervals(PrestimeCPUCCTNode node) throws IOException {
        TimelineSupport support = this.getTimelineSupport();
        int startIndex = Math.min(support.getStartIndex(), support.getEndIndex());
        int endIndex = Math.max(support.getStartIndex(), support.getEndIndex());
        return this.getSnapshot().getIntervals(startIndex, endIndex, node);
    }

    static interface Listener {
        public void probeAdded(TracerProbe var1);

        public void probeRemoved(TracerProbe var1, boolean var2);
    }
}

