/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.converters.AbstractConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.SerializedObjectConverter;

public class SerializedConverterMetadata
extends AbstractConverterMetadata {
    private String m_className;
    private String m_serializerPackage;

    public SerializedConverterMetadata() {
        super("<serialized-converter>");
    }

    public SerializedConverterMetadata(MetadataAnnotation serializer, MetadataAccessor accessor) {
        super(serializer, accessor);
        this.m_className = serializer.getAttributeString("serializerClass");
        this.m_serializerPackage = serializer.getAttributeString("serializerPackage");
    }

    protected SerializedConverterMetadata(String xmlElement) {
        super(xmlElement);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof SerializedConverterMetadata) {
            SerializedConverterMetadata serializer = (SerializedConverterMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_className, serializer.getClassName())) {
                return false;
            }
            return this.valuesMatch(this.m_serializerPackage, serializer.getSerializerPackage());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.m_className != null ? this.m_className.hashCode() : 0);
        result = 31 * result + (this.m_serializerPackage != null ? this.m_serializerPackage.hashCode() : 0);
        return result;
    }

    public String getClassName() {
        return this.m_className;
    }

    public String getSerializerPackage() {
        return this.m_serializerPackage;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.m_className = this.initXMLClassName(this.m_className).getName();
    }

    @Override
    public void process(DatabaseMapping mapping, MappingAccessor accessor, MetadataClass referenceClass, boolean isForMapKey) {
        SerializedObjectConverter converter = null;
        converter = this.m_className == null || this.m_className.length() == 0 ? new SerializedObjectConverter(mapping) : new SerializedObjectConverter(mapping, this.getClassName());
        if (this.m_serializerPackage != null && this.m_serializerPackage.length() > 0) {
            converter.setSerializerPackage(this.m_serializerPackage);
        } else {
            converter.setSerializerPackage(referenceClass.getName().substring(0, referenceClass.getName().lastIndexOf(46)));
        }
        this.setConverter(mapping, (Converter)converter, isForMapKey);
    }

    public void setClassName(String className) {
        this.m_className = className;
    }

    public void setSerializerPackage(String serializerPackage) {
        this.m_serializerPackage = serializerPackage;
    }
}

