/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.editor;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.editor.document.AtomicLockDocument;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.PositionRegion;
import org.netbeans.modules.jshell.editor.ConsoleEditor;
import org.netbeans.modules.jshell.model.ConsoleModel;
import org.netbeans.modules.jshell.model.ConsoleSection;
import org.netbeans.modules.jshell.support.ShellSession;
import org.netbeans.spi.editor.typinghooks.TypedBreakInterceptor;
import org.openide.awt.UndoRedo;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;

public class OverrideEditorActions {
    public static final String PROP_NAVIGATE_BOUNDARIES = "NetBeansEditor.navigateBoundaries";
    public static final String lineFirstColumnAction = "caret-line-first-column";
    public static final String selectionLineFirstColumnAction = "selection-line-first-column";
    private static volatile Reference<EditorKit> plainKitRef = new WeakReference<Object>(null);
    public static final String JSHELL_EXECUTE = "jshell-execute";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EditorKit getBaseEditorKit() {
        Reference<EditorKit> r = plainKitRef;
        EditorKit ek = r.get();
        if (ek != null) {
            return ek;
        }
        ek = (EditorKit)MimeLookup.getLookup((MimePath)MimePath.parse((String)"text/plain")).lookup(EditorKit.class);
        Class<OverrideEditorActions> clazz = OverrideEditorActions.class;
        synchronized (OverrideEditorActions.class) {
            if (r == plainKitRef) {
                plainKitRef = new WeakReference<EditorKit>(ek);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ek;
        }
    }

    private static Action findDelegate(String id) {
        EditorKit ek = OverrideEditorActions.getBaseEditorKit();
        if (ek == null) {
            return null;
        }
        if (ek instanceof BaseKit) {
            BaseKit bk = (BaseKit)ek;
            return bk.getActionByName(id);
        }
        return null;
    }

    static void flushUndoQueue(Document d) {
        SwingUtilities.invokeLater(() -> {
            if (d == null) {
                return;
            }
            for (TopComponent tc : TopComponent.getRegistry().getOpened()) {
                UndoRedo ur;
                Document check;
                ConsoleEditor cake;
                if (!(tc instanceof ConsoleEditor) || (cake = (ConsoleEditor)tc).getEditorPane() == null || (check = cake.getEditorPane().getDocument()) != d || !((ur = tc.getUndoRedo()) instanceof UndoManager)) continue;
                ((UndoManager)ur).discardAllEdits();
            }
        });
    }

    public static final class ForceExecute
    extends BaseAction {
        public ForceExecute() {
            super(OverrideEditorActions.JSHELL_EXECUTE, 58);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target == null || target.getDocument() == null) {
                return;
            }
            Document doc = target.getDocument();
            AtomicLockDocument ald = (AtomicLockDocument)LineDocumentUtils.asRequired((Document)doc, AtomicLockDocument.class);
            ShellSession s = ShellSession.get(doc);
            if (s == null) {
                return;
            }
            ConsoleModel mod = s.getModel();
            ConsoleSection sec = mod.processInputSection(true);
            if (sec == null || sec.isIncomplete()) {
                return;
            }
            OverrideEditorActions.flushUndoQueue(doc);
            try {
                s.evaluate(null);
                target.setCaretPosition(doc.getLength());
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static final class ExecF
    implements TypedBreakInterceptor.Factory {
        public TypedBreakInterceptor createTypedBreakInterceptor(MimePath mimePath) {
            return new ExecuteInterceptor();
        }
    }

    public static class ExecuteInterceptor
    implements TypedBreakInterceptor {
        private boolean execute;

        public boolean beforeInsert(TypedBreakInterceptor.Context context) throws BadLocationException {
            return false;
        }

        public void insert(TypedBreakInterceptor.MutableContext context) throws BadLocationException {
        }

        public void afterInsert(TypedBreakInterceptor.Context context) throws BadLocationException {
            Document doc = context.getDocument();
            ShellSession session = ShellSession.get(doc);
            if (session == null) {
                return;
            }
            ConsoleModel mod = session.getModel();
            ConsoleSection sec = mod.processInputSection(true);
            if (sec == null || sec.getPartBegin() > context.getBreakInsertOffset()) {
                return;
            }
            context.getDocument().render(() -> {
                this.execute = false;
                if (mod == null) {
                    return;
                }
                if (sec == null || sec.isIncomplete()) {
                    return;
                }
                if (sec.getContents(doc).trim().isEmpty()) {
                    return;
                }
                if (context.getBreakInsertOffset() >= sec.getEnd()) {
                    this.execute = true;
                } else {
                    String s = sec.getContents(doc).substring(sec.offsetToContents(context.getCaretOffset(), true)).trim();
                    this.execute = s.isEmpty();
                }
            });
            if (this.execute) {
                OverrideEditorActions.flushUndoQueue(doc);
                try {
                    ShellSession.get(context.getDocument()).evaluate(null);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return;
                }
            }
        }

        public void cancelled(TypedBreakInterceptor.Context context) {
        }
    }

    public static class UpAndHistory
    extends DelegatingAction {
        public UpAndHistory() {
            super("caret-up", 60);
        }

        @Override
        protected void performAction(ActionEvent evt, JTextComponent target) {
            target.putClientProperty("history-completion", true);
            Completion.get().showCompletion();
        }

        @Override
        protected boolean delegates(JTextComponent target, PositionRegion region, int pos) {
            if (super.delegates(target, region, pos)) {
                return true;
            }
            LineDocument ld = (LineDocument)LineDocumentUtils.as((Document)target.getDocument(), LineDocument.class);
            if (ld == null) {
                return true;
            }
            try {
                int end = LineDocumentUtils.getLineEndOffset((LineDocument)ld, (int)region.getStartOffset());
                return pos > end;
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return true;
            }
        }
    }

    public static abstract class DelegatingAction
    extends BaseAction {
        private final String delegateID;

        public DelegatingAction(String name, int updateMask) {
            super(name, updateMask);
            this.delegateID = name;
        }

        public DelegatingAction(String name, int updateMask, String delegateID) {
            super(name, updateMask);
            this.delegateID = delegateID;
        }

        public final String getDelegateId() {
            return this.delegateID;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (this.delegates(target)) {
                this.delegateActionPerformed(evt, target);
            } else {
                this.performAction(evt, target);
            }
        }

        private void delegateActionPerformed(ActionEvent evt, JTextComponent target) {
            Action del = OverrideEditorActions.findDelegate(this.getDelegateId());
            del.actionPerformed(evt);
        }

        protected abstract void performAction(ActionEvent var1, JTextComponent var2);

        protected boolean delegates(JTextComponent target) {
            ConsoleModel model = ConsoleModel.get(target.getDocument());
            if (model == null) {
                return true;
            }
            ConsoleSection input = model.getInputSection();
            if (input == null) {
                return true;
            }
            int offset = target.getCaretPosition();
            if (offset < input.getPartBegin() || offset > input.getEnd()) {
                return true;
            }
            Document doc = target.getDocument();
            LineDocument ld = (LineDocument)LineDocumentUtils.as((Document)doc, LineDocument.class);
            if (ld == null) {
                return true;
            }
            try {
                int end = LineDocumentUtils.getLineEndOffset((LineDocument)ld, (int)input.getPartBegin());
                return offset > end;
            }
            catch (BadLocationException ex) {
                return true;
            }
        }

        protected boolean delegates(JTextComponent target, PositionRegion region, int pos) {
            return region.getStartOffset() > pos && region.getEndOffset() <= pos;
        }
    }

    public static class BeginLineAction
    extends BaseAction {
        boolean homeKeyColumnOne;
        static final long serialVersionUID = 3269462923524077779L;

        public static BeginLineAction create() {
            return new BeginLineAction(false);
        }

        public static BeginLineAction createColumnOne() {
            return new BeginLineAction(true);
        }

        public BeginLineAction(boolean columnOne) {
            super(62);
            this.homeKeyColumnOne = columnOne;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                BaseDocument doc = (BaseDocument)target.getDocument();
                try {
                    int dot = caret.getDot();
                    Object o = target.getClientProperty(OverrideEditorActions.PROP_NAVIGATE_BOUNDARIES);
                    PositionRegion bounds = null;
                    int lineStartPos = Utilities.getRowStart((JTextComponent)target, (int)dot);
                    if (o instanceof PositionRegion) {
                        bounds = (PositionRegion)o;
                        int start = bounds.getStartOffset();
                        int end = bounds.getEndOffset();
                        int boundLineStart = Utilities.getRowStart((JTextComponent)target, (int)start);
                        if (boundLineStart == lineStartPos && dot > start && dot <= end) {
                            dot = start;
                        } else {
                            bounds = null;
                        }
                    }
                    if (bounds == null) {
                        if (this.homeKeyColumnOne) {
                            dot = lineStartPos;
                        } else {
                            int textStartPos = LineDocumentUtils.getLineFirstNonWhitespace((LineDocument)doc, (int)lineStartPos);
                            if (textStartPos < 0) {
                                textStartPos = Utilities.getRowEnd((JTextComponent)target, (int)lineStartPos);
                            }
                            dot = dot == lineStartPos ? textStartPos : (dot <= textStartPos ? lineStartPos : textStartPos);
                        }
                    }
                    dot = Math.max(dot, target.getUI().getRootView(target).getStartOffset());
                    String actionName = (String)this.getValue("Name");
                    boolean select = "selection-begin-line".equals(actionName) || OverrideEditorActions.selectionLineFirstColumnAction.equals(actionName);
                    Rectangle r = target.modelToView(dot);
                    Rectangle visRect = target.getVisibleRect();
                    if (r.getMaxX() < visRect.getWidth()) {
                        r.x = 0;
                        target.scrollRectToVisible(r);
                    }
                    target.putClientProperty("navigational.action", 7);
                    if (select) {
                        caret.moveDot(dot);
                    } else {
                        caret.setDot(dot);
                    }
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }
}

