/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lib.api.properties;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.css.lib.api.CssTokenId;
import org.netbeans.modules.css.lib.api.properties.Token;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public abstract class TokenAcceptor {
    public static final Collection<TokenAcceptor> ACCEPTORS = new ArrayList<TokenAcceptor>();
    public static final Map<String, TokenAcceptor> ACCEPTORS_MAP = new LinkedHashMap<String, TokenAcceptor>();
    private static final Lookup INSTANCES;
    private final String id;

    public static <T extends TokenAcceptor> T getAcceptor(Class<T> acceptorType) {
        return (T)((TokenAcceptor)INSTANCES.lookup(acceptorType));
    }

    public static TokenAcceptor getAcceptor(String name) {
        return ACCEPTORS_MAP.get(name.toLowerCase());
    }

    public TokenAcceptor(String id) {
        this.id = id;
    }

    public final String id() {
        return this.id;
    }

    public abstract boolean accepts(Token var1);

    Collection<String> getFixedImageTokens() {
        return null;
    }

    static {
        ACCEPTORS.add(new Resolution("resolution"));
        ACCEPTORS.add(new Angle("angle"));
        ACCEPTORS.add(new Percentage("percentage"));
        ACCEPTORS.add(new Length("length"));
        ACCEPTORS.add(new HashColor("hash_color_code"));
        ACCEPTORS.add(new HashColorAplha("hash_color_alpha_code"));
        ACCEPTORS.add(new StringAcceptor("string"));
        ACCEPTORS.add(new NonNegativeInteger("non-negative-integer"));
        ACCEPTORS.add(new Integer("integer"));
        ACCEPTORS.add(new Number("number"));
        ACCEPTORS.add(new Variable("variable"));
        ACCEPTORS.add(new Identifier("identifier"));
        ACCEPTORS.add(new Time("time"));
        ACCEPTORS.add(new Date("date"));
        ACCEPTORS.add(new Frequency("frequency"));
        ACCEPTORS.add(new Semitones("semitones"));
        ACCEPTORS.add(new Decibel("decibel"));
        ACCEPTORS.add(new RelativeLength("relative-length"));
        ACCEPTORS.add(new Uri("uri"));
        ACCEPTORS.add(new Anything("anything"));
        ACCEPTORS.add(new Urange("urange"));
        ACCEPTORS.add(new Flex("flex"));
        ACCEPTORS.add(new NonBrace("nonbrace"));
        InstanceContent content = new InstanceContent();
        for (TokenAcceptor ta : ACCEPTORS) {
            ACCEPTORS_MAP.put(ta.id().toLowerCase(), ta);
            content.add((Object)ta);
        }
        INSTANCES = new AbstractLookup((AbstractLookup.Content)content);
    }

    public static class Resolution
    extends NumberPostfixAcceptor {
        private static final List<String> POSTFIXES = Arrays.asList("dpi", "dppx", "dpcm", "x");

        public Resolution(String id) {
            super(id);
        }

        @Override
        protected List<String> postfixes() {
            return POSTFIXES;
        }
    }

    public static class Angle
    extends NumberPostfixAcceptor {
        private static final List<String> POSTFIXES = Arrays.asList("deg", "rad", "grad", "turn");

        public Angle(String id) {
            super(id);
        }

        @Override
        protected List<String> postfixes() {
            return POSTFIXES;
        }
    }

    public static class Percentage
    extends NumberPostfixAcceptor {
        private static final List<String> POSTFIXES = Arrays.asList("%");

        public Percentage(String id) {
            super(id);
        }

        @Override
        protected List<String> postfixes() {
            return POSTFIXES;
        }
    }

    public static class Length
    extends NumberPostfixAcceptor {
        private static final List<String> POSTFIXES = Arrays.asList("rem", "vmin", "vmax", "cqmin", "cqmax", "ex", "em", "vw", "vh", "ch", "cm", "mm", "in", "pt", "pc", "px", "cqw", "cqh", "cqi", "cqb");

        public Length(String id) {
            super(id);
        }

        @Override
        protected List<String> postfixes() {
            return POSTFIXES;
        }

        @Override
        public boolean accepts(String text) {
            boolean sa = super.accepts(text);
            if (!sa) {
                return "0".equals(text);
            }
            return sa;
        }

        @Override
        public Float getNumberValue(CharSequence image) {
            Float f = super.getNumberValue(image);
            if (f == null && image.length() > 0 && image.charAt(0) == '0') {
                f = Float.valueOf(0.0f);
            }
            return f;
        }
    }

    public static class HashColor
    extends TokenAcceptor {
        public HashColor(String id) {
            super(id);
        }

        @Override
        public boolean accepts(Token token) {
            if (token.tokenId() != CssTokenId.HASH) {
                return false;
            }
            CharSequence cs = token.image();
            int len = cs.length();
            if (len != 4 && len != 7 && len != 5 && len != 9) {
                return false;
            }
            if (cs.charAt(0) != '#') {
                return false;
            }
            for (int i = 1; i < len; ++i) {
                if (HashColor.hexChar(cs.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private static boolean hexChar(int val) {
            return val >= 48 && val <= 57 || val >= 97 && val <= 102 || val >= 65 && val <= 70;
        }
    }

    public static class HashColorAplha
    extends TokenAcceptor {
        public HashColorAplha(String id) {
            super(id);
        }

        @Override
        public boolean accepts(Token token) {
            int len = token.image().length();
            return token.tokenId() == CssTokenId.HASH && len == 9;
        }
    }

    public static class StringAcceptor
    extends TokenImageAcceptor {
        public StringAcceptor(String id) {
            super(id);
        }

        @Override
        public boolean accepts(String token) {
            return this.getUnquotedValue(token) != null;
        }

        public String getUnquotedValue(String token) {
            if (token.length() < 2) {
                return null;
            }
            char first = token.charAt(0);
            char last = token.charAt(token.length() - 1);
            if (first == '\'' && last == '\'' || first == '\"' && last == '\"') {
                return token.substring(1, token.length() - 1);
            }
            return null;
        }
    }

    public static class NonNegativeInteger
    extends TokenImageAcceptor {
        public NonNegativeInteger(String id) {
            super(id);
        }

        @Override
        public boolean accepts(String token) {
            return this.getNumberValue(token) != -1;
        }

        public int getNumberValue(String token) {
            try {
                int i = java.lang.Integer.parseInt(token);
                if (i >= 0) {
                    return i;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return -1;
        }
    }

    public static class Integer
    extends TokenImageAcceptor {
        public Integer(String id) {
            super(id);
        }

        @Override
        public boolean accepts(String token) {
            return this.getNumberValue(token) != java.lang.Integer.MIN_VALUE;
        }

        public int getNumberValue(String token) {
            try {
                return java.lang.Integer.parseInt(token);
            }
            catch (NumberFormatException numberFormatException) {
                return java.lang.Integer.MIN_VALUE;
            }
        }
    }

    public static class Number
    extends TokenImageAcceptor {
        public Number(String id) {
            super(id);
        }

        @Override
        public boolean accepts(String token) {
            return this.getNumberValue(token) != null;
        }

        public Float getNumberValue(String token) {
            try {
                return Float.valueOf(token);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
    }

    public static class Variable
    extends TokenAcceptor {
        public Variable(String id) {
            super(id);
        }

        @Override
        public boolean accepts(Token token) {
            return token.tokenId() == CssTokenId.VARIABLE;
        }
    }

    public static class Identifier
    extends TokenAcceptor {
        public Identifier(String id) {
            super(id);
        }

        @Override
        public boolean accepts(Token token) {
            return token.tokenId() == CssTokenId.IDENT && !LexerUtils.equals((CharSequence)"inherit", (CharSequence)token.image(), (boolean)true, (boolean)true);
        }
    }

    public static class Time
    extends NumberPostfixAcceptor {
        private static final List<String> POSTFIXES = Arrays.asList("ms", "s");

        public Time(String id) {
            super(id);
        }

        @Override
        protected List<String> postfixes() {
            return POSTFIXES;
        }
    }

    public static class Date
    extends TokenImageAcceptor {
        public Date(String id) {
            super(id);
        }

        @Override
        public boolean accepts(String token) {
            try {
                DateFormat.getDateInstance().parse(token);
                return true;
            }
            catch (ParseException ex) {
                return false;
            }
        }
    }

    public static class Frequency
    extends NumberPostfixAcceptor {
        private static final List<String> POSTFIXES = Arrays.asList("khz", "hz");

        public Frequency(String id) {
            super(id);
        }

        @Override
        protected List<String> postfixes() {
            return POSTFIXES;
        }
    }

    public static class Semitones
    extends NumberPostfixAcceptor {
        private static final List<String> POSTFIXES = Collections.singletonList("st");

        public Semitones(String id) {
            super(id);
        }

        @Override
        protected List<String> postfixes() {
            return POSTFIXES;
        }
    }

    public static class Decibel
    extends NumberPostfixAcceptor {
        private static final List<String> POSTFIXES = Collections.singletonList("dB");

        public Decibel(String id) {
            super(id);
        }

        @Override
        protected List<String> postfixes() {
            return POSTFIXES;
        }
    }

    public static class RelativeLength
    extends NumberPostfixAcceptor {
        private static final List<String> POSTFIXES = Collections.singletonList("*");

        public RelativeLength(String id) {
            super(id);
        }

        @Override
        protected List<String> postfixes() {
            return POSTFIXES;
        }
    }

    public static class Uri
    extends TokenAcceptor {
        private static final String URL_TOKEN_IMAGE = "url";

        public Uri(String id) {
            super(id);
        }

        @Override
        public boolean accepts(Token token) {
            return token.tokenId() == CssTokenId.URI;
        }

        @Override
        Collection<String> getFixedImageTokens() {
            return Collections.singleton(URL_TOKEN_IMAGE);
        }
    }

    public static class Anything
    extends TokenAcceptor {
        public Anything(String id) {
            super(id);
        }

        @Override
        public boolean accepts(Token token) {
            return true;
        }
    }

    public static class Urange
    extends TokenAcceptor {
        private static final String URANGE_TOKEN_IMAGE = "U+";

        public Urange(String id) {
            super(id);
        }

        @Override
        public boolean accepts(Token token) {
            return token.tokenId() == CssTokenId.URANGE;
        }

        @Override
        Collection<String> getFixedImageTokens() {
            return Collections.singleton(URANGE_TOKEN_IMAGE);
        }
    }

    public static class Flex
    extends NumberPostfixAcceptor {
        private static final List<String> POSTFIXES = Collections.singletonList("fr");

        public Flex(String id) {
            super(id);
        }

        @Override
        protected List<String> postfixes() {
            return POSTFIXES;
        }
    }

    private static class NonBrace
    extends TokenAcceptor {
        private static final Set<CssTokenId> BRACES = new HashSet<CssTokenId>(Arrays.asList(CssTokenId.LBRACE, CssTokenId.LBRACKET, CssTokenId.LPAREN, CssTokenId.RBRACE, CssTokenId.RBRACKET, CssTokenId.RPAREN));

        public NonBrace(String id) {
            super(id);
        }

        @Override
        public boolean accepts(Token token) {
            return !BRACES.contains((Object)token.tokenId());
        }
    }

    public static abstract class TokenImageAcceptor
    extends TokenAcceptor {
        public TokenImageAcceptor(String id) {
            super(id);
        }

        public abstract boolean accepts(String var1);

        @Override
        public boolean accepts(Token token) {
            String tokenImage = token.image().toString();
            return this.accepts(tokenImage);
        }
    }

    public static abstract class NumberPostfixAcceptor
    extends TokenImageAcceptor {
        public NumberPostfixAcceptor(String id) {
            super(id);
        }

        protected abstract List<String> postfixes();

        @Override
        public boolean accepts(String image) {
            return this.getNumberValue(image) != null;
        }

        public CharSequence getPostfix(CharSequence image) {
            for (String postfix : this.postfixes()) {
                if (!LexerUtils.endsWith((CharSequence)image, (CharSequence)postfix, (boolean)true, (boolean)false)) continue;
                return postfix;
            }
            return null;
        }

        public Float getNumberValue(CharSequence image) {
            CharSequence postfix = this.getPostfix(image);
            if (postfix == null) {
                return null;
            }
            CharSequence numberImage = image.subSequence(0, image.length() - postfix.length());
            try {
                return Float.valueOf(numberImage.toString());
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
    }
}

