/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution;

import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.modules.nativeexecution.ExecutionEnvironmentFactoryServiceImpl;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;

public final class ExecutionEnvironmentImpl
implements ExecutionEnvironment,
Serializable {
    private final String user;
    private final String host;
    private final int sshPort;
    private final AtomicReference<String> displayNameRef = new AtomicReference();
    static final long serialVersionUID = 2098997126628923682L;

    ExecutionEnvironmentImpl(String user, String host, int sshPort) {
        assert (host != null);
        assert (user != null || ExecutionEnvironmentFactoryServiceImpl.DEFAULT_USER == null);
        this.user = user;
        Object aHost = host;
        if (!(host.indexOf(58) < 0 || host.startsWith("[") && host.endsWith("]"))) {
            aHost = "[" + host + "]";
        }
        this.host = aHost;
        this.sshPort = sshPort;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getHostAddress() {
        return this.getHost();
    }

    @Override
    public String getDisplayName() {
        String displayName = this.displayNameRef.get();
        if (displayName == null) {
            if (this.sshPort == 0) {
                displayName = "localhost";
            } else {
                StringBuilder sb = new StringBuilder();
                if (this.user != null) {
                    sb.append(this.user).append('@');
                }
                sb.append(this.host);
                if (this.sshPort != 22) {
                    sb.append(':').append(this.sshPort);
                }
                displayName = sb.toString();
            }
            String old = this.displayNameRef.getAndSet(displayName);
            if (old != null) {
                displayName = old;
            }
        }
        return displayName;
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public int getSSHPort() {
        return this.sshPort;
    }

    @Override
    public boolean isRemote() {
        return !this.isLocal();
    }

    @Override
    public boolean isLocal() {
        return this.sshPort == 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ExecutionEnvironmentImpl)) {
            return false;
        }
        ExecutionEnvironmentImpl ee = (ExecutionEnvironmentImpl)obj;
        boolean bothLocalhost = ee.isLocal() && this.isLocal();
        boolean result = (bothLocalhost || ee.host.equals(this.host)) && ee.user.equals(this.user) && ee.sshPort == this.sshPort;
        return result;
    }

    public final int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.user != null ? this.user.hashCode() : 0);
        hash = 97 * hash + (this.host != null ? this.host.hashCode() : 0);
        hash = 97 * hash + this.sshPort;
        return hash;
    }

    @Override
    public void prepareForConnection() throws IOException, ConnectionManager.CancellationException {
    }

    Object writeReplace() throws ObjectStreamException {
        return new SerializedForm(ExecutionEnvironmentFactory.toUniqueID(this));
    }

    private static class SerializedForm
    implements Serializable {
        static final long serialVersionUID = -1L;
        private final String id;

        public SerializedForm(String id) {
            this.id = id;
        }

        Object readResolve() throws ObjectStreamException {
            return ExecutionEnvironmentFactory.fromUniqueID(this.id);
        }
    }
}

