/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.save;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import org.netbeans.modules.java.source.builder.ASTService;
import org.netbeans.modules.java.source.builder.QualIdentTree;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;

public class ElementOverlay {
    private static final Logger LOG = Logger.getLogger(ElementOverlay.class.getName());
    private static final ThreadLocal<ElementOverlay> transactionOverlay = new ThreadLocal();
    private final Map<String, List<String>> class2Enclosed = new HashMap<String, List<String>>();
    private final Map<String, Collection<String>> class2SuperElementTrees = new HashMap<String, Collection<String>>();
    private final Set<String> packages = new HashSet<String>();
    private final Map<String, Set<Modifier>> classes = new HashMap<String, Set<Modifier>>();
    private final Map<String, Element> elementCache = new HashMap<String, Element>();

    public static void beginTransaction() {
        transactionOverlay.set(new ElementOverlay());
        LOG.log(Level.FINE, "transaction started");
    }

    public static void endTransaction() {
        transactionOverlay.set(null);
        LOG.log(Level.FINE, "transaction end");
    }

    public static ElementOverlay getOrCreateOverlay() {
        ElementOverlay overlay = transactionOverlay.get();
        if (overlay == null) {
            overlay = new ElementOverlay();
        }
        return overlay;
    }

    private ElementOverlay() {
    }

    public List<Element> getEnclosedElements(ASTService ast, Elements elements, String parent, ModuleElement modle) {
        LinkedList<Element> result = new LinkedList<Element>();
        List<String> enclosed = this.class2Enclosed.get(parent);
        if (enclosed != null) {
            for (String enc : enclosed) {
                Element el = this.resolve(ast, elements, enc, modle);
                if (el == null) continue;
                result.add(el);
            }
            return result;
        }
        Element parentEl = this.resolve(ast, elements, parent, modle);
        if (parentEl == null) {
            throw new IllegalStateException(parent);
        }
        if (parentEl instanceof FakeTypeElement) {
            TypeElement original;
            TypeElement typeElement = original = modle != null ? elements.getTypeElement(modle, parent) : elements.getTypeElement(parent);
            if (original != null) {
                result.addAll(this.wrap(ast, elements, original.getEnclosedElements()));
            }
        } else if (parentEl instanceof FakePackageElement) {
            PackageElement original;
            PackageElement packageElement = original = modle != null ? elements.getPackageElement(modle, parent) : elements.getPackageElement(parent);
            if (original != null) {
                result.addAll(this.wrap(ast, elements, original.getEnclosedElements()));
            }
        } else {
            result.addAll(parentEl.getEnclosedElements());
        }
        return result;
    }

    private Element createElement(ASTService ast, Elements elements, String name, Element original, ModuleElement modle) {
        Element el = this.elementCache.get(name);
        if (el == null) {
            if (original != null) {
                if (original.getKind().isClass() || original.getKind().isInterface()) {
                    el = new TypeElementWrapper(ast, elements, (TypeElement)original);
                    this.elementCache.put(name, el);
                    return el;
                }
                if (original.getKind() == ElementKind.PACKAGE) {
                    el = new PackageElementWrapper(ast, elements, (PackageElement)original);
                    this.elementCache.put(name, el);
                    return el;
                }
                return original;
            }
            int lastDot = name.lastIndexOf(46);
            Name simpleName = elements.getName(name.substring(lastDot + 1));
            Name fqnName = elements.getName(name);
            if (this.classes.containsKey(name)) {
                PackageElement parent = lastDot > 0 ? this.resolve(ast, elements, name.substring(0, lastDot), modle) : elements.getPackageElement("");
                el = new FakeTypeElement(ast, elements, simpleName, fqnName, name, parent, this.classes.get(name), modle);
                this.elementCache.put(name, el);
            } else if (this.packages.contains(name)) {
                el = new FakePackageElement(ast, elements, fqnName, name, simpleName, modle);
                this.elementCache.put(name, el);
            } else {
                return null;
            }
        }
        return el;
    }

    public Element getOriginal(Element e) {
        if (e instanceof TypeElementWrapper) {
            return ((TypeElementWrapper)e).delegateTo;
        }
        if (e instanceof PackageElementWrapper) {
            return ((PackageElementWrapper)e).delegateTo;
        }
        return e;
    }

    public Element resolve(ASTService ast, Elements elements, String what) {
        return this.resolve(ast, elements, what, null);
    }

    public Element resolve(ASTService ast, Elements elements, String what, ModuleElement modle) {
        return this.resolve(ast, elements, what, null, modle);
    }

    public Element resolve(ASTService ast, Elements elements, String what, Element original, ModuleElement modle) {
        Element result = original;
        if (this.classes.containsKey(what)) {
            result = this.createElement(ast, elements, what, null, modle);
        }
        if (result == null) {
            Element element = result = modle != null ? elements.getTypeElement(modle, what) : elements.getTypeElement(what);
        }
        if (result == null) {
            Element element = result = modle != null ? elements.getPackageElement(modle, what) : elements.getPackageElement(what);
        }
        if (result == null && modle == null) {
            result = elements.getModuleElement(what);
        }
        result = this.createElement(ast, elements, what, result, modle);
        return result;
    }

    public void registerClass(String parent, String clazz, ClassTree tree, boolean modified) {
        LinkedHashSet<String> original;
        boolean newOrModified;
        if (clazz == null) {
            return;
        }
        Element myself = ASTService.getElementImpl(tree);
        boolean bl = newOrModified = myself == null || !myself.getKind().isClass() && !myself.getKind().isInterface() || !((QualifiedNameable)myself).getQualifiedName().contentEquals(clazz);
        if (newOrModified || this.class2Enclosed.containsKey(parent)) {
            List<String> c = this.class2Enclosed.get(parent);
            if (c == null) {
                c = new ArrayList<String>();
                this.class2Enclosed.put(parent, c);
            }
            c.add(clazz);
        }
        if (modified) {
            this.class2Enclosed.put(clazz, new ArrayList());
        }
        Set<String> superFQNs = this.superFQNs(tree);
        boolean hadObject = superFQNs.remove("java.lang.Object");
        if (!newOrModified) {
            original = new LinkedHashSet<String>();
            TypeElement tel = (TypeElement)myself;
            if (tel.getSuperclass() != null && tel.getSuperclass().getKind() == TypeKind.DECLARED) {
                original.add(((TypeElement)((DeclaredType)tel.getSuperclass()).asElement()).getQualifiedName().toString());
            }
            for (TypeMirror typeMirror : tel.getInterfaces()) {
                original.add(((TypeElement)((DeclaredType)typeMirror).asElement()).getQualifiedName().toString());
            }
            original.remove("java.lang.Object");
        } else {
            original = null;
        }
        if (!superFQNs.equals(original)) {
            if (hadObject) {
                superFQNs.add("java.lang.Object");
            }
            EnumSet<Modifier> mods = EnumSet.noneOf(Modifier.class);
            mods.addAll(tree.getModifiers().getFlags());
            this.classes.put(clazz, mods);
            this.class2SuperElementTrees.put(clazz, superFQNs);
        }
    }

    private Set<String> superFQNs(ClassTree tree) {
        String fqn;
        LinkedHashSet<String> superFQNs = new LinkedHashSet<String>(tree.getImplementsClause().size() + 1);
        if (tree.getExtendsClause() != null && (fqn = this.fqnFor(tree.getExtendsClause())) != null) {
            superFQNs.add(fqn);
        }
        for (Tree tree2 : tree.getImplementsClause()) {
            String fqn2 = this.fqnFor(tree2);
            if (fqn2 == null) continue;
            superFQNs.add(fqn2);
        }
        return superFQNs;
    }

    public void registerPackage(String currentPackage) {
        this.packages.add(currentPackage);
    }

    public Iterable<? extends Element> getAllSuperElements(ASTService ast, Elements elements, Element forElement) {
        LinkedList<Element> result;
        block4: {
            block3: {
                result = new LinkedList<Element>();
                if (!(forElement instanceof FakeTypeElement)) break block3;
                for (String string : this.class2SuperElementTrees.get(((FakeTypeElement)forElement).fqnString)) {
                    Element el = this.resolve(ast, elements, string, this.moduleOf(elements, forElement));
                    if (el != null) {
                        result.add(el);
                        continue;
                    }
                    Logger.getLogger(ElementOverlay.class.getName()).log(Level.SEVERE, "Cannot resolve {0} to element", string);
                }
                break block4;
            }
            if (!forElement.getKind().isClass() && !forElement.getKind().isInterface()) break block4;
            this.addElement(ast, elements, ((TypeElement)forElement).getSuperclass(), result);
            for (TypeMirror typeMirror : ((TypeElement)forElement).getInterfaces()) {
                this.addElement(ast, elements, typeMirror, result);
            }
        }
        return result;
    }

    private String fqnFor(Tree t) {
        Element el = ASTService.getElementImpl(t);
        if (el != null) {
            if (el.getKind().isClass() || el.getKind().isInterface() || el.getKind() == ElementKind.PACKAGE) {
                return ((QualifiedNameable)el).getQualifiedName().toString();
            }
            Logger.getLogger(ElementOverlay.class.getName()).log(Level.SEVERE, "Not a QualifiedNameable: {0}", el);
            return null;
        }
        if (t instanceof QualIdentTree) {
            return ((QualIdentTree)t).getFQN();
        }
        if (t.getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
            return this.fqnFor(((ParameterizedTypeTree)t).getType());
        }
        Logger.getLogger(ElementOverlay.class.getName()).log(Level.FINE, "No element and no QualIdent");
        return null;
    }

    private void addElement(ASTService ast, Elements elements, TypeMirror tm, List<Element> result) {
        if (tm == null || tm.getKind() != TypeKind.DECLARED) {
            return;
        }
        String fqn = ((TypeElement)((DeclaredType)tm).asElement()).getQualifiedName().toString();
        Element resolved = this.resolve(ast, elements, fqn, this.moduleOf(elements, ((DeclaredType)tm).asElement()));
        if (resolved != null) {
            result.add(resolved);
        } else {
            Logger.getLogger(ElementOverlay.class.getName()).log(Level.FINE, "cannot resolve {0}", fqn);
        }
    }

    public Element wrap(ASTService ast, Elements elements, Element original) {
        if (original == null) {
            return null;
        }
        if (original.getKind().isClass() || original.getKind().isInterface()) {
            return this.resolve(ast, elements, ((TypeElement)original).getQualifiedName().toString(), this.moduleOf(elements, original));
        }
        return original;
    }

    private List<? extends Element> wrap(ASTService ast, Elements elements, Collection<? extends Element> original) {
        ArrayList<Element> result = new ArrayList<Element>(original.size());
        for (Element element : original) {
            Element wrapped = this.wrap(ast, elements, element);
            if (wrapped == null) continue;
            result.add(wrapped);
        }
        return result;
    }

    public void clearElementsCache() {
        this.elementCache.clear();
    }

    public int totalMapsSize() {
        return this.class2Enclosed.size() + this.class2SuperElementTrees.size() + this.classes.size() + this.elementCache.size() + this.packages.size();
    }

    public Collection<? extends Element> getAllVisibleThrough(ASTService ast, Elements elements, String what, ClassTree tree, Element currentPackage, ModuleElement modle) {
        Element current;
        ArrayList<? extends Element> result = new ArrayList<Element>();
        Element element = current = what != null ? this.resolve(ast, elements, what, modle) : null;
        if (current == null) {
            for (String sup : this.superFQNs(tree)) {
                Element c = this.resolve(ast, elements, sup, modle);
                if (c == null) continue;
                result.add(c);
            }
        } else {
            result.addAll(this.getAllMembers(ast, elements, current, currentPackage, false));
        }
        return result;
    }

    private Collection<? extends Element> getAllMembers(ASTService ast, Elements elements, Element el, Element currentPackage, boolean inherited) {
        ArrayList<? extends Element> result = new ArrayList<Element>();
        el.getEnclosedElements().stream().filter(encl -> !inherited || encl.getModifiers().contains((Object)Modifier.PUBLIC) || encl.getModifiers().contains((Object)Modifier.PROTECTED) || !encl.getModifiers().contains((Object)Modifier.PRIVATE) && this.resolvedPackageOf(ast, elements, (Element)encl) == currentPackage).forEach(result::add);
        for (Element element : this.getAllSuperElements(ast, elements, el)) {
            if (el.equals(element)) continue;
            result.addAll(this.getAllMembers(ast, elements, element, currentPackage, true));
        }
        return result;
    }

    private Element resolvedPackageOf(ASTService ast, Elements elements, Element el) {
        ModuleElement modle = this.moduleOf(elements, el);
        PackageElement pack = this.packageOf(el);
        return this.resolve(ast, elements, pack.getQualifiedName().toString(), modle);
    }

    public PackageElement unnamedPackage(ASTService ast, Elements elements, ModuleElement modle) {
        return (PackageElement)this.resolve(ast, elements, "", modle);
    }

    public PackageElement packageOf(Element el) {
        while (el != null && el.getKind() != ElementKind.PACKAGE) {
            el = el.getEnclosingElement();
        }
        return (PackageElement)el;
    }

    public ModuleElement moduleOf(Elements elements, Element el) {
        if (el instanceof TypeElementWrapper) {
            return this.moduleOf(elements, ((TypeElementWrapper)el).delegateTo);
        }
        if (el instanceof FakeTypeElement) {
            return ((FakeTypeElement)el).modle;
        }
        if (el instanceof PackageElementWrapper) {
            return this.moduleOf(elements, ((PackageElementWrapper)el).delegateTo);
        }
        if (el instanceof FakePackageElement) {
            return ((FakePackageElement)el).modle;
        }
        if (el instanceof Symbol) {
            return elements.getModuleOf(el);
        }
        return null;
    }

    private final class FakeTypeElement
    implements TypeElement {
        private final ASTService ast;
        private final Elements elements;
        private final Name simpleName;
        private final Name fqn;
        private final String fqnString;
        private final Element parent;
        private final Set<Modifier> mods;
        private final ModuleElement modle;

        public FakeTypeElement(ASTService ast, Elements elements, Name simpleName, Name fqn, String fqnString, Element parent, Set<Modifier> mods, ModuleElement modle) {
            this.ast = ast;
            this.elements = elements;
            this.simpleName = simpleName;
            this.fqn = fqn;
            this.fqnString = fqnString;
            this.parent = parent;
            this.mods = mods;
            this.modle = modle;
        }

        @Override
        public List<? extends Element> getEnclosedElements() {
            return ElementOverlay.this.getEnclosedElements(this.ast, this.elements, this.fqnString, this.modle);
        }

        @Override
        public NestingKind getNestingKind() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Name getQualifiedName() {
            return this.fqn;
        }

        @Override
        public TypeMirror getSuperclass() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<? extends TypeMirror> getInterfaces() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<? extends TypeParameterElement> getTypeParameters() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public TypeMirror asType() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.CLASS;
        }

        @Override
        public List<? extends AnnotationMirror> getAnnotationMirrors() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Set<Modifier> getModifiers() {
            return this.mods;
        }

        @Override
        public Name getSimpleName() {
            return this.simpleName;
        }

        @Override
        public Element getEnclosingElement() {
            return this.parent;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class FakePackageElement
    implements PackageElement {
        private final ASTService ast;
        private final Elements elements;
        private final Name fqn;
        private final String fqnString;
        private final Name simpleName;
        private final ModuleElement modle;

        public FakePackageElement(ASTService ast, Elements elements, Name fqn, String fqnString, Name simpleName, ModuleElement modle) {
            this.ast = ast;
            this.elements = elements;
            this.fqn = fqn;
            this.fqnString = fqnString;
            this.simpleName = simpleName;
            this.modle = modle;
        }

        @Override
        public Name getQualifiedName() {
            return this.fqn;
        }

        @Override
        public boolean isUnnamed() {
            return false;
        }

        @Override
        public TypeMirror asType() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.PACKAGE;
        }

        @Override
        public List<? extends AnnotationMirror> getAnnotationMirrors() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Set<Modifier> getModifiers() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Name getSimpleName() {
            return this.simpleName;
        }

        @Override
        public Element getEnclosingElement() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<? extends Element> getEnclosedElements() {
            return ElementOverlay.this.getEnclosedElements(this.ast, this.elements, this.fqnString, this.modle);
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private final class TypeElementWrapper
    implements TypeElement {
        private final ASTService ast;
        private final Elements elements;
        private final TypeElement delegateTo;

        public TypeElementWrapper(ASTService ast, Elements elements, TypeElement delegateTo) {
            this.ast = ast;
            this.elements = elements;
            this.delegateTo = delegateTo;
        }

        @Override
        public List<? extends Element> getEnclosedElements() {
            return ElementOverlay.this.wrap(this.ast, this.elements, this.delegateTo.getEnclosedElements());
        }

        @Override
        public NestingKind getNestingKind() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Name getQualifiedName() {
            return this.delegateTo.getQualifiedName();
        }

        @Override
        public TypeMirror getSuperclass() {
            return this.delegateTo.getSuperclass();
        }

        @Override
        public List<? extends TypeMirror> getInterfaces() {
            return this.delegateTo.getInterfaces();
        }

        @Override
        public List<? extends TypeParameterElement> getTypeParameters() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public TypeMirror asType() {
            return this.delegateTo.asType();
        }

        @Override
        public ElementKind getKind() {
            return this.delegateTo.getKind();
        }

        @Override
        public List<? extends AnnotationMirror> getAnnotationMirrors() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Set<Modifier> getModifiers() {
            return this.delegateTo.getModifiers();
        }

        @Override
        public Name getSimpleName() {
            return this.delegateTo.getSimpleName();
        }

        @Override
        public Element getEnclosingElement() {
            return ElementOverlay.this.resolve(this.ast, this.elements, ((QualifiedNameable)this.delegateTo.getEnclosingElement()).getQualifiedName().toString(), ElementOverlay.this.moduleOf(this.elements, this.delegateTo));
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class PackageElementWrapper
    implements PackageElement {
        private final ASTService ast;
        private final Elements elements;
        private final PackageElement delegateTo;

        public PackageElementWrapper(ASTService ast, Elements elements, PackageElement delegateTo) {
            this.ast = ast;
            this.elements = elements;
            this.delegateTo = delegateTo;
        }

        @Override
        public Name getQualifiedName() {
            return this.delegateTo.getQualifiedName();
        }

        @Override
        public boolean isUnnamed() {
            return this.delegateTo.isUnnamed();
        }

        @Override
        public TypeMirror asType() {
            return this.delegateTo.asType();
        }

        @Override
        public ElementKind getKind() {
            return this.delegateTo.getKind();
        }

        @Override
        public List<? extends AnnotationMirror> getAnnotationMirrors() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Set<Modifier> getModifiers() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Name getSimpleName() {
            return this.delegateTo.getSimpleName();
        }

        @Override
        public Element getEnclosingElement() {
            return null;
        }

        @Override
        public List<? extends Element> getEnclosedElements() {
            while (true) {
                try {
                    return ElementOverlay.this.wrap(this.ast, this.elements, this.delegateTo.getEnclosedElements());
                }
                catch (Symbol.CompletionFailure completionFailure) {
                    continue;
                }
                break;
            }
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static class RunLastFactory
    implements RefactoringPluginFactory {
        public RefactoringPlugin createInstance(AbstractRefactoring refactoring) {
            return new RefactoringPlugin(){

                public Problem preCheck() {
                    return null;
                }

                public Problem checkParameters() {
                    return null;
                }

                public Problem fastCheckParameters() {
                    return null;
                }

                public void cancelRequest() {
                    ElementOverlay.endTransaction();
                }

                public Problem prepare(RefactoringElementsBag refactoringElements) {
                    ElementOverlay.endTransaction();
                    return null;
                }
            };
        }
    }

    public static class RunFirstFactory
    implements RefactoringPluginFactory {
        public RefactoringPlugin createInstance(AbstractRefactoring refactoring) {
            return new RefactoringPlugin(){

                public Problem preCheck() {
                    return null;
                }

                public Problem checkParameters() {
                    return null;
                }

                public Problem fastCheckParameters() {
                    return null;
                }

                public void cancelRequest() {
                    ElementOverlay.endTransaction();
                }

                public Problem prepare(RefactoringElementsBag refactoringElements) {
                    ElementOverlay.beginTransaction();
                    return null;
                }
            };
        }
    }

    public static class FQNComputer {
        private final StringBuilder fqn = new StringBuilder();
        private int anonymousCounter = 0;

        public void setCompilationUnit(CompilationUnitTree cut) {
            this.setPackageNameTree(cut.getPackageName());
        }

        public void enterClass(ClassTree ct, boolean isAnonymous) {
            if (ct.getSimpleName() == null || ct.getSimpleName().length() == 0 || this.anonymousCounter > 0 || isAnonymous) {
                ++this.anonymousCounter;
            } else {
                if (this.fqn.length() > 0) {
                    this.fqn.append('.');
                }
                this.fqn.append(ct.getSimpleName());
            }
        }

        public void leaveClass() {
            if (this.anonymousCounter > 0) {
                --this.anonymousCounter;
            } else {
                int dot = Math.max(0, this.fqn.lastIndexOf("."));
                this.fqn.delete(dot, this.fqn.length());
            }
        }

        public String getFQN() {
            if (this.anonymousCounter > 0) {
                return null;
            }
            return this.fqn.toString();
        }

        public void setPackageNameTree(ExpressionTree packageNameTree) {
            this.fqn.delete(0, this.fqn.length());
            if (packageNameTree != null) {
                this.fqn.append(packageNameTree.toString());
            }
        }
    }
}

