/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.base.semantic;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;

public class Utilities {
    private static final Logger LOG = Logger.getLogger(Utilities.class.getName());
    @Deprecated
    private static final boolean DEBUG = false;
    private static final Map<Class<?>, List<Tree.Kind>> class2Kind = new HashMap();
    private static final Set<String> keywords;
    private static final Set<String> nonCtorKeywords;
    private static final Set<ElementKind> LOCAL_ELEMENT_KINDS;

    private static Token<JavaTokenId> findTokenWithText(CompilationInfo info, String text, int start, int end) {
        TokenHierarchy th = info.getTokenHierarchy();
        TokenSequence ts = th.tokenSequence(JavaTokenId.language()).subSequence(start, end);
        while (ts.moveNext()) {
            Token t = ts.token();
            if (t.id() != JavaTokenId.IDENTIFIER) continue;
            boolean nameMatches = text.equals(info.getTreeUtilities().decodeIdentifier(t.text()).toString());
            if (!nameMatches) {
                ExpressionTree expr = info.getTreeUtilities().parseExpression(t.text().toString(), new SourcePositions[1]);
                boolean bl = nameMatches = expr.getKind() == Tree.Kind.IDENTIFIER && text.contentEquals(((IdentifierTree)expr).getName());
            }
            if (!nameMatches) continue;
            return t;
        }
        return null;
    }

    private static Tree normalizeLastLeftTree(Tree lastLeft) {
        while (lastLeft != null && lastLeft.getKind() == Tree.Kind.ARRAY_TYPE) {
            lastLeft = ((ArrayTypeTree)lastLeft).getType();
        }
        return lastLeft;
    }

    private static Token<JavaTokenId> findIdentifierSpanImpl(CompilationInfo info, Tree decl, Tree lastLeft, List<? extends Tree> firstRight, String name, CompilationUnitTree cu, SourcePositions positions) {
        int start;
        int declStart = (int)positions.getStartPosition(cu, decl);
        int n = start = (lastLeft = Utilities.normalizeLastLeftTree(lastLeft)) != null ? (int)positions.getEndPosition(cu, lastLeft) : declStart;
        if (start == -1 && (start = declStart) == -1) {
            return null;
        }
        int end = (int)positions.getEndPosition(cu, decl);
        for (Tree tree : firstRight) {
            int proposedEnd;
            if (tree == null || (proposedEnd = (int)positions.getStartPosition(cu, tree)) == -1 || proposedEnd >= end) continue;
            end = proposedEnd;
        }
        if (end == -1) {
            return null;
        }
        if (start > end) {
            start = (int)positions.getStartPosition(cu, decl);
        }
        if (start == end) {
            end = start + 1;
        }
        return Utilities.findTokenWithText(info, name, start, end);
    }

    private static Token<JavaTokenId> findIdentifierSpanImpl(CompilationInfo info, MemberSelectTree tree, CompilationUnitTree cu, SourcePositions positions) {
        int start = (int)positions.getStartPosition(cu, tree);
        int endPosition = (int)positions.getEndPosition(cu, tree);
        if (start == -1 || endPosition == -1) {
            return null;
        }
        String member = tree.getIdentifier().toString();
        TokenHierarchy th = info.getTokenHierarchy();
        TokenSequence ts = th.tokenSequence(JavaTokenId.language());
        if (ts.move(endPosition) == Integer.MAX_VALUE) {
            return null;
        }
        if (ts.moveNext()) {
            while (ts.offset() >= start) {
                Token t = ts.token();
                if (t.id() == JavaTokenId.IDENTIFIER && member.equals(info.getTreeUtilities().decodeIdentifier(t.text()).toString())) {
                    return t;
                }
                if (ts.movePrevious()) continue;
                break;
            }
        }
        return null;
    }

    private static Token<JavaTokenId> findIdentifierSpanImpl(CompilationInfo info, MemberReferenceTree tree, CompilationUnitTree cu, SourcePositions positions) {
        int start = (int)positions.getStartPosition(cu, tree);
        int endPosition = (int)positions.getEndPosition(cu, tree);
        if (start == -1 || endPosition == -1) {
            return null;
        }
        String member = tree.getName().toString();
        TokenHierarchy th = info.getTokenHierarchy();
        TokenSequence ts = th.tokenSequence(JavaTokenId.language());
        if (ts.move(endPosition) == Integer.MAX_VALUE) {
            return null;
        }
        if (ts.moveNext()) {
            while (ts.offset() >= start) {
                Token t = ts.token();
                if (t.id() == JavaTokenId.IDENTIFIER && member.equals(info.getTreeUtilities().decodeIdentifier(t.text()).toString())) {
                    return t;
                }
                if (ts.movePrevious()) continue;
                break;
            }
        }
        return null;
    }

    private static Token<JavaTokenId> findIdentifierSpanImpl(CompilationInfo info, IdentifierTree tree, CompilationUnitTree cu, SourcePositions positions) {
        int start = (int)positions.getStartPosition(cu, tree);
        int endPosition = (int)positions.getEndPosition(cu, tree);
        if (start == -1 || endPosition == -1) {
            return null;
        }
        TokenHierarchy th = info.getTokenHierarchy();
        TokenSequence ts = th.tokenSequence(JavaTokenId.language());
        if (ts.move(start) == Integer.MAX_VALUE) {
            return null;
        }
        if (ts.moveNext() && ts.offset() >= start) {
            Token t = ts.token();
            return t;
        }
        return null;
    }

    private static Token<JavaTokenId> findIdentifierSpanImpl(CompilationInfo info, TreePath decl) {
        if (info.getTreeUtilities().isSynthetic(decl)) {
            return null;
        }
        Tree leaf = decl.getLeaf();
        if (class2Kind.get(MethodTree.class).contains((Object)leaf.getKind())) {
            boolean ignoreParameters;
            MethodTree method = (MethodTree)leaf;
            TreePath parentPath = decl.getParentPath();
            ArrayList<Tree> rightTrees = new ArrayList<Tree>();
            boolean bl = ignoreParameters = parentPath.getLeaf().getKind() == Tree.Kind.RECORD && !method.getParameters().isEmpty() && info.getTreeUtilities().isSynthetic(new TreePath(decl, method.getParameters().get(0)));
            if (!ignoreParameters) {
                rightTrees.addAll(method.getParameters());
            }
            rightTrees.addAll(method.getThrows());
            rightTrees.add(method.getBody());
            Name name = method.getName();
            if (method.getReturnType() == null) {
                name = ((ClassTree)parentPath.getLeaf()).getSimpleName();
            }
            return Utilities.findIdentifierSpanImpl(info, leaf, method.getReturnType(), rightTrees, name.toString(), info.getCompilationUnit(), info.getTrees().getSourcePositions());
        }
        if (class2Kind.get(VariableTree.class).contains((Object)leaf.getKind())) {
            VariableTree var = (VariableTree)leaf;
            boolean typeSynthetic = var.getType() == null || info.getTreeUtilities().isSynthetic(new TreePath(decl, var.getType()));
            return Utilities.findIdentifierSpanImpl(info, leaf, typeSynthetic ? null : var.getType(), Collections.singletonList(var.getInitializer()), var.getName().toString(), info.getCompilationUnit(), info.getTrees().getSourcePositions());
        }
        if (class2Kind.get(MemberSelectTree.class).contains((Object)leaf.getKind())) {
            return Utilities.findIdentifierSpanImpl(info, (MemberSelectTree)leaf, info.getCompilationUnit(), info.getTrees().getSourcePositions());
        }
        if (class2Kind.get(MemberReferenceTree.class).contains((Object)leaf.getKind())) {
            return Utilities.findIdentifierSpanImpl(info, (MemberReferenceTree)leaf, info.getCompilationUnit(), info.getTrees().getSourcePositions());
        }
        if (class2Kind.get(ClassTree.class).contains((Object)leaf.getKind())) {
            int start;
            String name = ((ClassTree)leaf).getSimpleName().toString();
            if (name.isEmpty()) {
                return null;
            }
            SourcePositions positions = info.getTrees().getSourcePositions();
            CompilationUnitTree cu = info.getCompilationUnit();
            ModifiersTree mods = ((ClassTree)leaf).getModifiers();
            int n = start = mods != null ? (int)positions.getEndPosition(cu, mods) : -1;
            if (start == -1) {
                start = (int)positions.getStartPosition(cu, leaf);
            }
            int end = (int)positions.getEndPosition(cu, leaf);
            if (start == -1 || end == -1) {
                return null;
            }
            return Utilities.findTokenWithText(info, name, start, end);
        }
        if (class2Kind.get(IdentifierTree.class).contains((Object)leaf.getKind())) {
            return Utilities.findIdentifierSpanImpl(info, (IdentifierTree)leaf, info.getCompilationUnit(), info.getTrees().getSourcePositions());
        }
        if (class2Kind.get(ParameterizedTypeTree.class).contains((Object)leaf.getKind())) {
            return Utilities.findIdentifierSpanImpl(info, new TreePath(decl, ((ParameterizedTypeTree)leaf).getType()));
        }
        if (class2Kind.get(AnnotatedTypeTree.class).contains((Object)leaf.getKind())) {
            return Utilities.findIdentifierSpanImpl(info, new TreePath(decl, ((AnnotatedTypeTree)leaf).getUnderlyingType()));
        }
        if (class2Kind.get(BreakTree.class).contains((Object)leaf.getKind())) {
            Name name = ((BreakTree)leaf).getLabel();
            if (name == null || name.length() == 0) {
                return null;
            }
            SourcePositions positions = info.getTrees().getSourcePositions();
            CompilationUnitTree cu = info.getCompilationUnit();
            int start = (int)positions.getStartPosition(cu, leaf);
            int end = (int)positions.getEndPosition(cu, leaf);
            if (start == -1 || end == -1) {
                return null;
            }
            return Utilities.findTokenWithText(info, name.toString(), start, end);
        }
        if (class2Kind.get(ContinueTree.class).contains((Object)leaf.getKind())) {
            Name name = ((ContinueTree)leaf).getLabel();
            if (name == null || name.length() == 0) {
                return null;
            }
            SourcePositions positions = info.getTrees().getSourcePositions();
            CompilationUnitTree cu = info.getCompilationUnit();
            int start = (int)positions.getStartPosition(cu, leaf);
            int end = (int)positions.getEndPosition(cu, leaf);
            if (start == -1 || end == -1) {
                return null;
            }
            return Utilities.findTokenWithText(info, name.toString(), start, end);
        }
        if (class2Kind.get(LabeledStatementTree.class).contains((Object)leaf.getKind())) {
            Name name = ((LabeledStatementTree)leaf).getLabel();
            if (name == null || name.length() == 0) {
                return null;
            }
            SourcePositions positions = info.getTrees().getSourcePositions();
            CompilationUnitTree cu = info.getCompilationUnit();
            int start = (int)positions.getStartPosition(cu, leaf);
            int end = (int)positions.getStartPosition(cu, ((LabeledStatementTree)leaf).getStatement());
            if (start == -1 || end == -1) {
                return null;
            }
            return Utilities.findTokenWithText(info, name.toString(), start, end);
        }
        throw new IllegalArgumentException("Only MethodDecl, VariableDecl, MemberSelectTree, IdentifierTree, ParameterizedTypeTree, AnnotatedTypeTree, ClassDecl, BreakTree, ContinueTree, LabeledStatementTree and BindingPatternTree are accepted by this method. Got: " + leaf.getKind());
    }

    public static int[] findIdentifierSpan(TreePath decl, CompilationInfo info, Document doc) {
        int[] result = new int[]{-1, -1};
        Runnable r = () -> {
            Token<JavaTokenId> t = Utilities.findIdentifierSpan(info, doc, decl);
            if (t != null) {
                result[0] = t.offset(null);
                result[1] = t.offset(null) + t.length();
            }
        };
        if (doc != null) {
            doc.render(r);
        } else {
            r.run();
        }
        return result;
    }

    public static Token<JavaTokenId> findIdentifierSpan(CompilationInfo info, Document doc, TreePath decl) {
        Token[] result = new Token[1];
        Runnable r = () -> {
            result[0] = Utilities.findIdentifierSpanImpl(info, decl);
        };
        if (doc != null) {
            doc.render(r);
        } else {
            r.run();
        }
        return result[0];
    }

    private static int findSubtreeEnd(CompilationUnitTree cu, SourcePositions pos, Object ... treeSets) {
        for (Object o : treeSets) {
            Tree t;
            int offset;
            if (o == null) continue;
            if (o instanceof Tree) {
                Tree tree = (Tree)o;
                int offset2 = (int)pos.getEndPosition(cu, tree);
                if (offset2 < 0) continue;
                return offset2;
            }
            List set = (List)o;
            if (set.isEmpty() || (offset = (int)pos.getEndPosition(cu, t = (Tree)set.get(set.size() - 1))) < 0) continue;
            return offset;
        }
        return -1;
    }

    private static int findBodyStartImpl(CompilationInfo info, Tree cltree, CompilationUnitTree cu, SourcePositions positions, Document doc) {
        int start = (int)positions.getStartPosition(cu, cltree);
        int end = (int)positions.getEndPosition(cu, cltree);
        if (start == -1 || end == -1) {
            return -1;
        }
        int startPos = -1;
        switch (cltree.getKind()) {
            case CLASS: 
            case INTERFACE: 
            case ENUM: {
                ClassTree ct = (ClassTree)cltree;
                startPos = Utilities.findSubtreeEnd(cu, positions, ct.getImplementsClause(), ct.getExtendsClause(), ct.getTypeParameters(), ct.getModifiers());
                break;
            }
            case METHOD: {
                MethodTree mt = (MethodTree)cltree;
                startPos = Utilities.findSubtreeEnd(cu, positions, mt.getDefaultValue(), mt.getThrows(), mt.getParameters(), mt.getModifiers());
            }
        }
        if (startPos > start) {
            start = startPos;
        }
        if (start > doc.getLength() || end > doc.getLength()) {
            return -1;
        }
        TokenHierarchy th = info.getTokenHierarchy();
        TokenSequence seq = th.tokenSequence();
        seq.move(start);
        while (seq.moveNext()) {
            if (seq.token().id() != JavaTokenId.LBRACE) continue;
            return seq.offset();
        }
        return -1;
    }

    public static int findBodyStart(CompilationInfo info, Tree cltree, CompilationUnitTree cu, SourcePositions positions, Document doc) {
        Tree.Kind kind = cltree.getKind();
        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)kind) && kind != Tree.Kind.METHOD) {
            throw new IllegalArgumentException("Unsupported kind: " + kind);
        }
        int[] result = new int[1];
        doc.render(() -> {
            result[0] = Utilities.findBodyStartImpl(info, cltree, cu, positions, doc);
        });
        return result[0];
    }

    private static int findLastBracketImpl(Tree tree, CompilationUnitTree cu, SourcePositions positions, Document doc) {
        int start = (int)positions.getStartPosition(cu, tree);
        int end = (int)positions.getEndPosition(cu, tree);
        if (start == -1 || end == -1) {
            return -1;
        }
        if (start > doc.getLength() || end > doc.getLength()) {
            return -1;
        }
        try {
            String text = doc.getText(end - 1, 1);
            if (text.charAt(0) == '}') {
                return end - 1;
            }
        }
        catch (BadLocationException e) {
            LOG.log(Level.INFO, null, e);
        }
        return -1;
    }

    public static int findLastBracket(Tree tree, CompilationUnitTree cu, SourcePositions positions, Document doc) {
        int[] result = new int[1];
        doc.render(() -> {
            result[0] = Utilities.findLastBracketImpl(tree, cu, positions, doc);
        });
        return result[0];
    }

    private static Token<JavaTokenId> createHighlightImpl(CompilationInfo info, Document doc, TreePath tree) {
        Tree leaf = tree.getLeaf();
        SourcePositions positions = info.getTrees().getSourcePositions();
        CompilationUnitTree cu = info.getCompilationUnit();
        if (leaf instanceof MethodTree || leaf instanceof VariableTree || leaf instanceof ClassTree || leaf instanceof MemberSelectTree || leaf instanceof AnnotatedTypeTree || leaf instanceof MemberReferenceTree || leaf.getKind() == Tree.Kind.BINDING_PATTERN) {
            return Utilities.findIdentifierSpan(info, doc, tree);
        }
        int start = (int)positions.getStartPosition(cu, leaf);
        int end = (int)positions.getEndPosition(cu, leaf);
        if ((long)start == -1L || (long)end == -1L) {
            return null;
        }
        TokenHierarchy th = info.getTokenHierarchy();
        TokenSequence ts = th.tokenSequence(JavaTokenId.language());
        if (ts.move(start) == Integer.MAX_VALUE) {
            return null;
        }
        if (ts.moveNext()) {
            Token token = ts.token();
            if (ts.offset() == start && token != null) {
                JavaTokenId id = (JavaTokenId)token.id();
                if (id == JavaTokenId.IDENTIFIER) {
                    return token;
                }
                if (id == JavaTokenId.THIS || id == JavaTokenId.SUPER) {
                    return ts.offsetToken();
                }
            }
        }
        return null;
    }

    public static Token<JavaTokenId> getToken(CompilationInfo info, Document doc, TreePath tree) {
        Token[] result = new Token[1];
        doc.render(() -> {
            result[0] = Utilities.createHighlightImpl(info, doc, tree);
        });
        return result[0];
    }

    public static boolean isKeyword(Tree tree) {
        if (tree.getKind() == Tree.Kind.IDENTIFIER) {
            return keywords.contains(((IdentifierTree)tree).getName().toString());
        }
        if (tree.getKind() == Tree.Kind.MEMBER_SELECT) {
            return keywords.contains(((MemberSelectTree)tree).getIdentifier().toString());
        }
        return false;
    }

    public static boolean isNonCtorKeyword(Tree tree) {
        if (tree.getKind() == Tree.Kind.IDENTIFIER) {
            return nonCtorKeywords.contains(((IdentifierTree)tree).getName().toString());
        }
        if (tree.getKind() == Tree.Kind.MEMBER_SELECT) {
            return nonCtorKeywords.contains(((MemberSelectTree)tree).getIdentifier().toString());
        }
        return false;
    }

    public static boolean isPrivateElement(Element el) {
        return LOCAL_ELEMENT_KINDS.contains((Object)el.getKind()) || el.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    public static Element toRecordComponent(Element el) {
        if (el == null || el.getKind() != ElementKind.FIELD) {
            return el;
        }
        TypeElement owner = (TypeElement)el.getEnclosingElement();
        if (!ElementKind.RECORD.equals((Object)owner.getKind())) {
            return el;
        }
        for (Element element : owner.getEnclosedElements()) {
            if (element.getKind() != ElementKind.RECORD_COMPONENT || !element.getSimpleName().equals(el.getSimpleName())) continue;
            return element;
        }
        return el;
    }

    static {
        for (Tree.Kind kind : Tree.Kind.values()) {
            class2Kind.computeIfAbsent(kind.asInterface(), k -> new ArrayList()).add(kind);
        }
        keywords = Set.of("true", "false", "null", "this", "super", "class");
        nonCtorKeywords = Set.of("true", "false", "null", "class");
        LOCAL_ELEMENT_KINDS = EnumSet.of(ElementKind.PARAMETER, ElementKind.LOCAL_VARIABLE, ElementKind.EXCEPTION_PARAMETER, ElementKind.RESOURCE_VARIABLE, ElementKind.BINDING_VARIABLE);
    }
}

