/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.gsp.editor.indent;

import java.util.Set;
import javax.swing.text.BadLocationException;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lexer.Token;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.groovy.gsp.lexer.GspLexerLanguage;
import org.netbeans.modules.groovy.gsp.lexer.GspTokenId;
import org.netbeans.modules.web.indent.api.embedding.JoinedTokenSequence;
import org.netbeans.modules.web.indent.api.support.IndenterContextData;
import org.netbeans.modules.web.indent.api.support.MarkupAbstractIndenter;

public class GspIndenter
extends MarkupAbstractIndenter<GspTokenId> {
    public GspIndenter(Context context) {
        super(GspLexerLanguage.getLanguage(), context);
    }

    protected boolean isOpenTagNameToken(Token<GspTokenId> token) {
        return token.id() == GspTokenId.GTAG_OPENING_NAME;
    }

    protected boolean isCloseTagNameToken(Token<GspTokenId> token) {
        return token.id() == GspTokenId.GTAG_CLOSING_NAME;
    }

    protected boolean isStartTagSymbol(Token<GspTokenId> token) {
        return token.id() == GspTokenId.GTAG_OPENING_START;
    }

    protected boolean isStartTagClosingSymbol(Token<GspTokenId> token) {
        return token.id() == GspTokenId.GTAG_CLOSING_START;
    }

    protected boolean isEndTagSymbol(Token<GspTokenId> token) {
        return token.id() == GspTokenId.GTAG_OPENING_END || token.id() == GspTokenId.GTAG_CLOSING_END;
    }

    protected boolean isEndTagClosingSymbol(Token<GspTokenId> token) {
        return token.id() == GspTokenId.GTAG_INDEPENDENT_END;
    }

    protected boolean isTagArgumentToken(Token<GspTokenId> token) {
        return false;
    }

    protected boolean isBlockCommentToken(Token<GspTokenId> token) {
        return ((GspTokenId)token.id()).isComment();
    }

    protected boolean isTagContentToken(Token<GspTokenId> token) {
        return token.id() == GspTokenId.GTAG_ATTRIBUTE_NAME || token.id() == GspTokenId.GTAG_ATTRIBUTE_VALUE;
    }

    protected boolean isClosingTagOptional(CharSequence tagName) {
        return false;
    }

    protected boolean isOpeningTagOptional(CharSequence tagName) {
        return false;
    }

    protected Boolean isEmptyTag(CharSequence tagName) {
        return Boolean.FALSE;
    }

    protected boolean isTagContentUnformattable(CharSequence tagName) {
        return false;
    }

    protected Set<String> getTagChildren(CharSequence tagName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected boolean isPreservedLine(Token<GspTokenId> token, IndenterContextData<GspTokenId> context) {
        return ((GspTokenId)token.id()).isComment();
    }

    protected int getPreservedLineInitialIndentation(JoinedTokenSequence<GspTokenId> ts) throws BadLocationException {
        int[] index = ts.index();
        boolean found = false;
        if (((GspTokenId)ts.token().id()).isComment()) {
            found = true;
        }
        int indent = 0;
        if (found) {
            int lineStart = LineDocumentUtils.getLineStartOffset((LineDocument)this.getDocument(), (int)ts.offset());
            int column = ts.offset();
            indent = column - lineStart;
        }
        ts.moveIndex(index);
        ts.moveNext();
        return indent;
    }

    protected boolean isForeignLanguageStartToken(Token<GspTokenId> token, JoinedTokenSequence<GspTokenId> ts) {
        return ((GspTokenId)token.id()).isStartDelimiter();
    }

    protected boolean isForeignLanguageEndToken(Token<GspTokenId> token, JoinedTokenSequence<GspTokenId> ts) {
        return ((GspTokenId)token.id()).isEndDelimiter();
    }

    protected boolean isWhiteSpaceToken(Token<GspTokenId> token) {
        return token.id() == GspTokenId.WHITESPACE || token.id() == GspTokenId.HTML && token.text().toString().trim().length() == 0;
    }
}

