/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class SimpleIO {
    private static final int DELAY = 1000;
    private final String name;
    private final InputOutput io;
    private final CancelAction cancelAction;
    private final AtomicReference<Process> process;

    public SimpleIO(String displayName, Process task) {
        this.name = displayName;
        this.process = new AtomicReference<Process>(task);
        this.cancelAction = new CancelAction();
        this.io = IOProvider.getDefault().getIO(displayName, new Action[]{this.cancelAction});
        this.io.select();
    }

    public void readInputStreams(InputStream ... inputStreams) {
        RequestProcessor rp = RequestProcessor.getDefault();
        for (InputStream inputStream : inputStreams) {
            rp.post((Runnable)new IOReader(inputStream));
        }
    }

    public synchronized void write(String s) {
        OutputWriter writer = this.io.getOut();
        writer.print(s);
        writer.flush();
    }

    public synchronized void selectIO() {
        this.io.select();
    }

    public synchronized void closeIO() {
        this.process.set(null);
        this.cancelAction.updateEnabled();
    }

    public class CancelAction
    extends AbstractAction {
        private static final String PROP_ENABLED = "enabled";
        private static final String ICON = "org/netbeans/modules/glassfish/common/resources/stop.png";

        public CancelAction() {
            super(NbBundle.getMessage(SimpleIO.class, (String)"CTL_Cancel"), ImageUtilities.loadImageIcon((String)ICON, (boolean)false));
            this.putValue("ShortDescription", NbBundle.getMessage(SimpleIO.class, (String)"LBL_CancelDesc"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SimpleIO.this.process.get() != null) {
                String message = NbBundle.getMessage(SimpleIO.class, (String)"MSG_QueryCancel", (Object)SimpleIO.this.name);
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)message, 0, 3);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) == NotifyDescriptor.YES_OPTION) {
                    Process p = SimpleIO.this.process.getAndSet(null);
                    if (p != null) {
                        p.destroy();
                    } else {
                        Logger.getLogger("glassfish").log(Level.FINEST, "Process handle unexpectedly null, cancel aborted.");
                    }
                }
            }
        }

        @Override
        public boolean isEnabled() {
            return SimpleIO.this.process.get() != null;
        }

        public void updateEnabled() {
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    CancelAction.this.firePropertyChange(CancelAction.PROP_ENABLED, null, CancelAction.this.isEnabled() ? Boolean.TRUE : Boolean.FALSE);
                }
            });
        }
    }

    private class IOReader
    implements Runnable {
        private InputStream inputStream;

        public IOReader(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String originalName = Thread.currentThread().getName();
            try {
                Thread.currentThread().setName(this.getClass().getName() + " - " + this.inputStream);
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream));
                char[] chars = new char[1024];
                int len = 0;
                while (len != -1) {
                    while ((len = reader.read(chars)) != -1) {
                        SimpleIO.this.write(new String(chars, 0, len));
                        SimpleIO.this.selectIO();
                        if (((Reader)reader).ready()) continue;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (IOException ex) {
                Logger.getLogger("glassfish").log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
            finally {
                try {
                    this.inputStream.close();
                }
                catch (IOException ex) {
                    Logger.getLogger("glassfish").log(Level.INFO, ex.getLocalizedMessage(), ex);
                }
                Thread.currentThread().setName(originalName);
            }
        }
    }
}

