/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.codegen.CodeDeleter;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.editor.codegen.RemoveSurroundingCodePanel;
import org.netbeans.modules.java.editor.overridden.PopupUtil;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class RemoveSurroundingCodeAction
extends BaseAction
implements LookupListener {
    private static final String DELETE_HIGHLIGHT_FCS_NAME = "remove-surround-code-delete";
    private static final String REMAIN_HIGHLIGHT_FCS_NAME = "remove-surround-code-remain";
    private static AttributeSet DELETE_HIGHLIGHT;
    private static AttributeSet REMAIN_HIGHLIGHT;
    private Lookup.Result<FontColorSettings> result;

    public RemoveSurroundingCodeAction() {
        Lookup lookup = MimeLookup.getLookup((String)"text/x-java");
        this.result = lookup.lookupResult(FontColorSettings.class);
        this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.result));
        this.resultChanged(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultChanged(LookupEvent ev) {
        FontColorSettings fcs = (FontColorSettings)this.result.allInstances().iterator().next();
        RemoveSurroundingCodeAction removeSurroundingCodeAction = this;
        synchronized (removeSurroundingCodeAction) {
            if (fcs != null) {
                DELETE_HIGHLIGHT = fcs.getFontColors(DELETE_HIGHLIGHT_FCS_NAME);
                REMAIN_HIGHLIGHT = fcs.getFontColors(REMAIN_HIGHLIGHT_FCS_NAME);
            }
            if (DELETE_HIGHLIGHT == null) {
                DELETE_HIGHLIGHT = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, new Color(245, 245, 245), StyleConstants.Foreground, new Color(180, 180, 180)});
            }
            if (REMAIN_HIGHLIGHT == null) {
                REMAIN_HIGHLIGHT = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, new Color(210, 240, 210)});
            }
        }
    }

    public void actionPerformed(ActionEvent evt, final JTextComponent component) {
        if (component == null || !component.isEditable() || !component.isEnabled()) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        BaseDocument doc = (BaseDocument)component.getDocument();
        final JavaSource js = JavaSource.forDocument((Document)doc);
        if (js != null) {
            final AtomicBoolean cancel = new AtomicBoolean();
            BaseProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        js.runUserActionTask((Task)new Task<CompilationController>(){

                            public void run(CompilationController controller) throws Exception {
                                try {
                                    if (cancel.get()) {
                                        return;
                                    }
                                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                    if (cancel.get()) {
                                        return;
                                    }
                                    TreeUtilities tu = controller.getTreeUtilities();
                                    final ArrayList<CodeDeleter> codeDeleters = new ArrayList<CodeDeleter>();
                                    final int caretOffset = component.getCaretPosition();
                                    TokenSequence ts = controller.getTokenHierarchy().tokenSequence(JavaTokenId.language());
                                    ts.move(caretOffset);
                                    if (ts.moveNext() && (ts.token().id() == JavaTokenId.BLOCK_COMMENT || ts.token().id() == JavaTokenId.LINE_COMMENT)) {
                                        codeDeleters.add(new CommentDeleter(component, (TokenSequence<JavaTokenId>)ts));
                                    }
                                    block8: for (TreePath tp = tu.pathFor(caretOffset); tp != null; tp = tp.getParentPath()) {
                                        Tree leaf = tp.getLeaf();
                                        switch (leaf.getKind()) {
                                            case IF: {
                                                if (RemoveSurroundingCodeAction.this.insideElse(controller, (IfTree)leaf, component.getCaretPosition())) {
                                                    codeDeleters.add(new TreeDeleter((CompilationInfo)controller, component, tp, false));
                                                }
                                            }
                                            case FOR_LOOP: 
                                            case ENHANCED_FOR_LOOP: 
                                            case WHILE_LOOP: 
                                            case DO_WHILE_LOOP: 
                                            case SYNCHRONIZED: 
                                            case TRY: {
                                                codeDeleters.add(new TreeDeleter((CompilationInfo)controller, component, tp));
                                                continue block8;
                                            }
                                            case BLOCK: {
                                                if (tp.getParentPath().getLeaf().getKind() != Tree.Kind.BLOCK) continue block8;
                                                codeDeleters.add(new TreeDeleter((CompilationInfo)controller, component, tp));
                                                continue block8;
                                            }
                                            case PARENTHESIZED: {
                                                if (tp.getParentPath().getLeaf().getKind() == Tree.Kind.IF || Utilities.containErrors(tp.getParentPath().getLeaf())) continue block8;
                                                codeDeleters.add(new TreeDeleter((CompilationInfo)controller, component, tp));
                                            }
                                        }
                                    }
                                    if (codeDeleters.size() > 0) {
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                int altHeight = -1;
                                                Point where = null;
                                                try {
                                                    Rectangle carretRectangle = component.modelToView(caretOffset);
                                                    altHeight = carretRectangle.height;
                                                    where = new Point(carretRectangle.x, carretRectangle.y + carretRectangle.height);
                                                    SwingUtilities.convertPointToScreen(where, component);
                                                }
                                                catch (BadLocationException badLocationException) {
                                                    // empty catch block
                                                }
                                                if (where == null) {
                                                    where = new Point(-1, -1);
                                                }
                                                PopupUtil.showPopup(new RemoveSurroundingCodePanel(component, codeDeleters), null, where.x, where.y, true, altHeight);
                                            }
                                        });
                                    } else {
                                        component.getToolkit().beep();
                                    }
                                }
                                catch (IOException ioe) {
                                    component.getToolkit().beep();
                                }
                            }
                        }, true);
                    }
                    catch (IOException ioe) {
                        component.getToolkit().beep();
                    }
                }
            }, (String)this.getShortDescription(), (AtomicBoolean)cancel, (boolean)false);
        }
    }

    private String getShortDescription() {
        String name = (String)this.getValue("Name");
        if (name != null) {
            try {
                return NbBundle.getMessage(RemoveSurroundingCodeAction.class, (String)name);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return name;
    }

    private boolean insideElse(CompilationController controller, IfTree ifTree, int caretPosition) {
        if (ifTree.getElseStatement() == null) {
            return false;
        }
        SourcePositions sp = controller.getTrees().getSourcePositions();
        int end = (int)sp.getEndPosition(controller.getCompilationUnit(), ifTree.getThenStatement());
        return end > 0 && caretPosition > end;
    }

    private static class CommentDeleter
    implements CodeDeleter {
        private final boolean lineComment;
        private final JTextComponent component;
        private final int offset;
        private final int length;
        private final OffsetsBag bag;

        public CommentDeleter(JTextComponent component, TokenSequence<JavaTokenId> ts) {
            this.lineComment = ts.token().id() == JavaTokenId.LINE_COMMENT;
            this.component = component;
            this.offset = ts.offset();
            this.length = ts.token().length();
            this.bag = new OffsetsBag(component.getDocument(), true);
            if (this.lineComment) {
                this.bag.addHighlight(this.offset, this.offset + 2, DELETE_HIGHLIGHT);
                this.bag.addHighlight(this.offset + 2, this.offset + this.length, REMAIN_HIGHLIGHT);
            } else {
                this.bag.addHighlight(this.offset, this.offset + 2, DELETE_HIGHLIGHT);
                this.bag.addHighlight(this.offset + 2, this.offset + this.length - 2, REMAIN_HIGHLIGHT);
                this.bag.addHighlight(this.offset + this.length - 2, this.offset + this.length, DELETE_HIGHLIGHT);
            }
        }

        @Override
        public String getDisplayName() {
            return this.lineComment ? "// ..." : "/* ... */";
        }

        @Override
        public void invoke() {
            Document doc = this.component.getDocument();
            TokenSequence ts = TokenHierarchy.get((Document)doc).tokenSequence(JavaTokenId.language());
            ts.move(this.component.getCaretPosition());
            if (ts.moveNext() && (ts.token().id() == JavaTokenId.BLOCK_COMMENT || ts.token().id() == JavaTokenId.LINE_COMMENT) && ts.offset() == this.offset && ts.token().length() == this.length) {
                try {
                    if (!this.lineComment) {
                        doc.remove(this.offset + this.length - 2, 2);
                    }
                    doc.remove(this.offset, 2);
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        @Override
        public OffsetsBag getHighlight() {
            return this.bag;
        }
    }

    private static class TreeDeleter
    implements CodeDeleter {
        private JTextComponent component;
        private TreePathHandle tpHandle;
        private boolean unwrap;
        private OffsetsBag bag;

        private TreeDeleter(CompilationInfo cInfo, JTextComponent component, TreePath path) throws BadLocationException {
            this(cInfo, component, path, true);
        }

        private TreeDeleter(CompilationInfo cInfo, JTextComponent component, TreePath path, boolean unwrap) throws BadLocationException {
            this.component = component;
            this.tpHandle = TreePathHandle.create((TreePath)path, (CompilationInfo)cInfo);
            this.unwrap = unwrap;
            this.bag = this.createOffsetsBag(component, cInfo.getTreeUtilities(), cInfo.getTrees().getSourcePositions(), path);
        }

        @Override
        public String getDisplayName() {
            switch (this.tpHandle.getKind()) {
                case IF: {
                    return this.unwrap ? "if (...) ..." : "else ...";
                }
                case FOR_LOOP: 
                case ENHANCED_FOR_LOOP: {
                    return "for (...) ...";
                }
                case WHILE_LOOP: {
                    return "while (...) ...";
                }
                case DO_WHILE_LOOP: {
                    return "do ... while(...)";
                }
                case SYNCHRONIZED: {
                    return "synchronized (...) ...";
                }
                case TRY: {
                    return "try ...";
                }
                case BLOCK: {
                    return "{...}";
                }
                case PARENTHESIZED: {
                    return "(...)";
                }
            }
            throw new IllegalStateException("Unsupported kind: " + this.tpHandle.getKind());
        }

        @Override
        public void invoke() {
            JavaSource js = JavaSource.forDocument((Document)this.component.getDocument());
            if (js != null) {
                try {
                    ModificationResult mr = js.runModificationTask((Task)new Task<WorkingCopy>(){

                        public void run(WorkingCopy copy) throws IOException {
                            copy.toPhase(JavaSource.Phase.PARSED);
                            TreePath tp = tpHandle.resolve((CompilationInfo)copy);
                            if (tp != null) {
                                TreeMaker tm = copy.getTreeMaker();
                                TreeUtilities tu = copy.getTreeUtilities();
                                Tree tree = tp.getLeaf();
                                Tree parent = tp.getParentPath().getLeaf();
                                ArrayList<StatementTree> stats = new ArrayList<StatementTree>();
                                List<Comment> trailingComments = null;
                                switch (tree.getKind()) {
                                    case IF: {
                                        Iterator<Comment> it = (IfTree)tree;
                                        if (unwrap) {
                                            this.addStat(it.getThenStatement(), stats);
                                        } else {
                                            this.addStat(tm.If(it.getCondition(), it.getThenStatement(), null), stats);
                                        }
                                        this.addStat(it.getElseStatement(), stats);
                                        trailingComments = this.getTrailingComments(tu, it.getElseStatement() != null ? it.getElseStatement() : it.getThenStatement());
                                        break;
                                    }
                                    case FOR_LOOP: {
                                        ForLoopTree flt = (ForLoopTree)tree;
                                        stats.addAll(flt.getInitializer());
                                        this.addStat(flt.getStatement(), stats);
                                        trailingComments = this.getTrailingComments(tu, flt.getStatement());
                                        break;
                                    }
                                    case ENHANCED_FOR_LOOP: {
                                        EnhancedForLoopTree eflt = (EnhancedForLoopTree)tree;
                                        VariableTree var = eflt.getVariable();
                                        stats.add(tm.Variable(var.getModifiers(), (CharSequence)var.getName(), var.getType(), (ExpressionTree)tm.Literal(null)));
                                        this.addStat(eflt.getStatement(), stats);
                                        trailingComments = this.getTrailingComments(tu, eflt.getStatement());
                                        break;
                                    }
                                    case WHILE_LOOP: {
                                        WhileLoopTree wlt = (WhileLoopTree)tree;
                                        this.addStat(wlt.getStatement(), stats);
                                        trailingComments = this.getTrailingComments(tu, wlt.getStatement());
                                        break;
                                    }
                                    case DO_WHILE_LOOP: {
                                        DoWhileLoopTree dwlt = (DoWhileLoopTree)tree;
                                        this.addStat(dwlt.getStatement(), stats);
                                        break;
                                    }
                                    case SYNCHRONIZED: {
                                        SynchronizedTree st = (SynchronizedTree)tree;
                                        this.addStat(st.getBlock(), stats);
                                        trailingComments = this.getTrailingComments(tu, st.getBlock());
                                        break;
                                    }
                                    case TRY: {
                                        TryTree tt = (TryTree)tree;
                                        for (Tree tree2 : tt.getResources()) {
                                            this.addStat((StatementTree)tree2, stats);
                                        }
                                        this.addStat(tt.getBlock(), stats);
                                        this.addStat(tt.getFinallyBlock(), stats);
                                        trailingComments = this.getTrailingComments(tu, tt.getFinallyBlock() != null ? tt.getFinallyBlock() : (tt.getCatches().isEmpty() ? tt.getBlock() : (Tree)tt.getCatches().get(tt.getCatches().size() - 1)));
                                        break;
                                    }
                                    case BLOCK: {
                                        BlockTree bt = (BlockTree)tree;
                                        this.addStat(bt, stats);
                                        break;
                                    }
                                    case PARENTHESIZED: {
                                        ParenthesizedTree parenthesizedTree = (ParenthesizedTree)tree;
                                        copy.rewrite(tree, (Tree)parenthesizedTree.getExpression());
                                        return;
                                    }
                                }
                                if (!stats.isEmpty()) {
                                    for (Comment comment : tu.getComments(tree, true)) {
                                        tm.addComment((Tree)stats.get(0), comment, true);
                                    }
                                    if (trailingComments == null) {
                                        trailingComments = tu.getComments(tree, false);
                                    }
                                    for (Comment comment : trailingComments) {
                                        tm.addComment((Tree)stats.get(stats.size() - 1), comment, false);
                                    }
                                }
                                if (parent.getKind() == Tree.Kind.BLOCK) {
                                    int i;
                                    BlockTree block = (BlockTree)parent;
                                    int idx = -1;
                                    List<? extends StatementTree> blockStats = block.getStatements();
                                    for (i = 0; i < blockStats.size(); ++i) {
                                        if (tree != blockStats.get(i)) continue;
                                        idx = i;
                                        break;
                                    }
                                    if (idx >= 0) {
                                        block = tm.removeBlockStatement(block, idx);
                                        for (i = stats.size() - 1; i >= 0; --i) {
                                            block = tm.insertBlockStatement(block, idx, stats.get(i));
                                        }
                                    }
                                    copy.rewrite(parent, (Tree)block);
                                } else {
                                    BlockTree newTree = stats.size() > 1 ? tm.Block(stats, false) : (stats.size() == 1 ? (Tree)stats.get(0) : null);
                                    copy.rewrite(tree, (Tree)newTree);
                                }
                            }
                        }
                    });
                    GeneratorUtils.guardedCommit(this.component, mr);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        @Override
        public OffsetsBag getHighlight() {
            return this.bag;
        }

        private List<Comment> getTrailingComments(TreeUtilities tu, Tree tree) {
            return tree.getKind() == Tree.Kind.BLOCK ? tu.getComments(tree, false) : null;
        }

        private OffsetsBag createOffsetsBag(JTextComponent component, TreeUtilities tu, SourcePositions sp, TreePath path) throws BadLocationException {
            Document doc = component.getDocument();
            OffsetsBag offsetsBag = new OffsetsBag(doc, true);
            int start = (int)sp.getStartPosition(path.getCompilationUnit(), path.getLeaf());
            if (start >= 0) {
                ArrayList<int[]> positions = new ArrayList<int[]>();
                Tree tree = path.getLeaf();
                switch (tree.getKind()) {
                    case IF: {
                        IfTree it = (IfTree)tree;
                        if (this.unwrap) {
                            positions.add(this.getBounds(tu, sp, path.getCompilationUnit(), it.getThenStatement()));
                        } else {
                            int end;
                            start = (int)sp.getEndPosition(path.getCompilationUnit(), it.getThenStatement());
                            int off = doc.getText(start, (end = (int)sp.getStartPosition(path.getCompilationUnit(), it.getElseStatement())) - start).indexOf("else");
                            if (off > 0) {
                                start += off;
                            }
                        }
                        positions.add(this.getBounds(tu, sp, path.getCompilationUnit(), it.getElseStatement()));
                        break;
                    }
                    case FOR_LOOP: {
                        ForLoopTree flt = (ForLoopTree)tree;
                        List<? extends StatementTree> inits = flt.getInitializer();
                        if (inits != null && !inits.isEmpty()) {
                            int[] bounds = new int[]{-1, -1};
                            bounds[0] = this.getStart(tu, sp, path.getCompilationUnit(), inits.get(0));
                            bounds[1] = this.getEnd(tu, sp, path.getCompilationUnit(), inits.get(inits.size() - 1));
                            positions.add(bounds);
                        }
                        positions.add(this.getBounds(tu, sp, path.getCompilationUnit(), flt.getStatement()));
                        break;
                    }
                    case ENHANCED_FOR_LOOP: {
                        EnhancedForLoopTree eflt = (EnhancedForLoopTree)tree;
                        positions.add(this.getBounds(tu, sp, path.getCompilationUnit(), eflt.getVariable()));
                        positions.add(this.getBounds(tu, sp, path.getCompilationUnit(), eflt.getStatement()));
                        break;
                    }
                    case WHILE_LOOP: {
                        WhileLoopTree wlt = (WhileLoopTree)tree;
                        positions.add(this.getBounds(tu, sp, path.getCompilationUnit(), wlt.getStatement()));
                        break;
                    }
                    case DO_WHILE_LOOP: {
                        DoWhileLoopTree dwlt = (DoWhileLoopTree)tree;
                        positions.add(this.getBounds(tu, sp, path.getCompilationUnit(), dwlt.getStatement()));
                        break;
                    }
                    case SYNCHRONIZED: {
                        SynchronizedTree st = (SynchronizedTree)tree;
                        positions.add(this.getBounds(tu, sp, path.getCompilationUnit(), st.getBlock()));
                        break;
                    }
                    case TRY: {
                        TryTree tt = (TryTree)tree;
                        for (Tree tree2 : tt.getResources()) {
                            positions.add(this.getBounds(tu, sp, path.getCompilationUnit(), (StatementTree)tree2));
                        }
                        positions.add(this.getBounds(tu, sp, path.getCompilationUnit(), tt.getBlock()));
                        positions.add(this.getBounds(tu, sp, path.getCompilationUnit(), tt.getFinallyBlock()));
                        break;
                    }
                    case BLOCK: {
                        BlockTree bt = (BlockTree)tree;
                        positions.add(this.getBounds(tu, sp, path.getCompilationUnit(), bt));
                        break;
                    }
                    case PARENTHESIZED: {
                        ParenthesizedTree parenthesizedTree = (ParenthesizedTree)tree;
                        positions.add(this.getBounds(tu, sp, path.getCompilationUnit(), parenthesizedTree.getExpression()));
                    }
                }
                for (int[] bounds : positions) {
                    if (bounds[0] < 0 || bounds[1] <= bounds[0]) continue;
                    offsetsBag.addHighlight(start, bounds[0], DELETE_HIGHLIGHT);
                    offsetsBag.addHighlight(bounds[0], bounds[1], REMAIN_HIGHLIGHT);
                    start = bounds[1];
                }
                int end = (int)sp.getEndPosition(path.getCompilationUnit(), path.getLeaf());
                if (end > start) {
                    offsetsBag.addHighlight(start, end, DELETE_HIGHLIGHT);
                }
            }
            return offsetsBag;
        }

        private void addStat(StatementTree stat, List<StatementTree> to) {
            if (stat != null) {
                if (stat.getKind() == Tree.Kind.BLOCK) {
                    to.addAll(((BlockTree)stat).getStatements());
                } else {
                    to.add(stat);
                }
            }
        }

        private int[] getBounds(TreeUtilities tu, SourcePositions sp, CompilationUnitTree cut, Tree tree) {
            int[] bounds = new int[]{-1, -1};
            if (tree != null) {
                if (tree.getKind() == Tree.Kind.BLOCK) {
                    List<? extends StatementTree> stats = ((BlockTree)tree).getStatements();
                    if (stats != null && !stats.isEmpty()) {
                        bounds[0] = this.getStart(tu, sp, cut, stats.get(0));
                        bounds[1] = this.getEnd(tu, sp, cut, stats.get(stats.size() - 1));
                    }
                } else {
                    bounds[0] = this.getStart(tu, sp, cut, tree);
                    bounds[1] = this.getEnd(tu, sp, cut, tree);
                }
            }
            return bounds;
        }

        private int getStart(TreeUtilities tu, SourcePositions sp, CompilationUnitTree cut, Tree tree) {
            List comments = tu.getComments(tree, true);
            return comments.isEmpty() ? (int)sp.getStartPosition(cut, tree) : ((Comment)comments.get(0)).pos();
        }

        private int getEnd(TreeUtilities tu, SourcePositions sp, CompilationUnitTree cut, Tree tree) {
            List comments = tu.getComments(tree, false);
            return comments.isEmpty() ? (int)sp.getEndPosition(cut, tree) : ((Comment)comments.get(comments.size() - 1)).endPos();
        }
    }
}

