/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import com.google.api.client.util.Key;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.firebase.auth.SamlProviderConfig;
import com.google.firebase.auth.internal.ListProviderConfigsResponse;
import java.util.List;

public final class ListSamlProviderConfigsResponse
implements ListProviderConfigsResponse<SamlProviderConfig> {
    @Key(value="inboundSamlConfigs")
    private List<SamlProviderConfig> providerConfigs;
    @Key(value="nextPageToken")
    private String pageToken;

    @VisibleForTesting
    public ListSamlProviderConfigsResponse(List<SamlProviderConfig> providerConfigs, String pageToken) {
        this.providerConfigs = providerConfigs;
        this.pageToken = pageToken;
    }

    public ListSamlProviderConfigsResponse() {
    }

    @Override
    public List<SamlProviderConfig> getProviderConfigs() {
        return this.providerConfigs == null ? ImmutableList.of() : this.providerConfigs;
    }

    @Override
    public boolean hasProviderConfigs() {
        return this.providerConfigs != null && !this.providerConfigs.isEmpty();
    }

    @Override
    public String getPageToken() {
        return Strings.nullToEmpty((String)this.pageToken);
    }
}

