/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.notificators;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.model.User;
import org.traccar.notification.MessageException;
import org.traccar.notification.NotificationFormatter;
import org.traccar.notification.NotificationMessage;
import org.traccar.notificators.Notificator;

@Singleton
public class NotificatorWhatsapp
extends Notificator {
    private final Client client;
    private final String token;
    private final String phoneNumberId;
    private final String templateName;
    private final String templateLanguage;

    @Inject
    public NotificatorWhatsapp(Config config, NotificationFormatter notificationFormatter, Client client) {
        super(notificationFormatter);
        this.client = client;
        this.token = config.getString(Keys.NOTIFICATOR_WHATSAPP_TOKEN);
        this.phoneNumberId = config.getString(Keys.NOTIFICATOR_WHATSAPP_PHONE_NUMBER_ID);
        this.templateName = config.getString(Keys.NOTIFICATOR_WHATSAPP_TEMPLATE_NAME);
        this.templateLanguage = config.getString(Keys.NOTIFICATOR_WHATSAPP_TEMPLATE_LANGUAGE);
    }

    @Override
    public void send(User user, NotificationMessage shortMessage, Event event, Position position) throws MessageException {
        String recipient = user.getPhone();
        if (recipient == null || recipient.isBlank()) {
            return;
        }
        if (this.token == null || this.phoneNumberId == null || this.templateName == null) {
            throw new MessageException("Missing WhatsApp configuration");
        }
        Parameter parameter = new Parameter();
        parameter.text = shortMessage.digest();
        Component component = new Component();
        component.parameters = List.of(parameter);
        Message message = new Message();
        message.to = recipient;
        message.template.name = this.templateName;
        message.template.language.code = this.templateLanguage;
        message.template.components = List.of(component);
        try (Response response = this.client.target(String.format("https://graph.facebook.com/v22.0/%s/messages", this.phoneNumberId)).request().header("Authorization", (Object)("Bearer " + this.token)).post(Entity.json((Object)message));){
            if (response.getStatus() / 100 != 2) {
                throw new MessageException((String)response.readEntity(String.class));
            }
        }
    }

    public static class Parameter {
        @JsonProperty(value="type")
        private String type = "text";
        @JsonProperty(value="text")
        private String text;
    }

    public static class Component {
        @JsonProperty(value="type")
        private String type = "body";
        @JsonProperty(value="parameters")
        private List<Parameter> parameters;
    }

    public static class Message {
        @JsonProperty(value="messaging_product")
        private String messagingProduct = "whatsapp";
        @JsonProperty(value="to")
        private String to;
        @JsonProperty(value="type")
        private String type = "template";
        @JsonProperty(value="template")
        private Template template = new Template();
    }

    public static class Template {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="language")
        private Language language = new Language();
        @JsonProperty(value="components")
        private List<Component> components;
    }

    public static class Language {
        @JsonProperty(value="code")
        private String code;
    }
}

