/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.BufferUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.model.WifiAccessPoint;
import org.traccar.session.DeviceSession;

public class Minifinder2ProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_DATA = 1;
    public static final int MSG_CONFIGURATION = 2;
    public static final int MSG_SERVICES = 3;
    public static final int MSG_SYSTEM_CONTROL = 4;
    public static final int MSG_FIRMWARE = 126;
    public static final int MSG_RESPONSE = 127;

    public Minifinder2ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress, int index, int type, ByteBuf buf) {
        if (channel != null) {
            ByteBuf body = Unpooled.buffer();
            if (type == 3) {
                while (buf.isReadable()) {
                    int endIndex = buf.readUnsignedByte() + buf.readerIndex();
                    short key = buf.readUnsignedByte();
                    switch (key) {
                        case 17: {
                            body.writeByte(10);
                            body.writeByte((int)key);
                            body.writeIntLE(0);
                            body.writeIntLE(0);
                            body.writeByte(0);
                            break;
                        }
                        case 18: {
                            body.writeByte(5);
                            body.writeByte((int)key);
                            body.writeIntLE((int)(System.currentTimeMillis() / 1000L));
                        }
                    }
                    buf.readerIndex(endIndex);
                }
            }
            ByteBuf content = Unpooled.buffer();
            if (body.isReadable()) {
                content.writeByte(3);
            } else {
                content.writeByte(127);
                body.writeByte(1);
                body.writeByte(0);
            }
            content.writeBytes(body);
            body.release();
            ByteBuf response = Unpooled.buffer();
            response.writeByte(171);
            response.writeByte(0);
            response.writeShortLE(content.readableBytes());
            response.writeShortLE(Checksum.crc16(Checksum.CRC16_XMODEM, content.nioBuffer()));
            response.writeShortLE(index);
            response.writeBytes(content);
            content.release();
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    private String readTagId(ByteBuf buf) {
        StringBuilder tagId = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            tagId.insert(0, ByteBufUtil.hexDump((ByteBuf)buf.readSlice(1)));
        }
        return tagId.toString();
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedByte();
        short flags = buf.readUnsignedByte();
        buf.readUnsignedShortLE();
        buf.readUnsignedShortLE();
        int index = buf.readUnsignedShortLE();
        short type = buf.readUnsignedByte();
        if (BitUtil.check(flags, 4)) {
            this.sendResponse(channel, remoteAddress, index, type, buf.slice());
        }
        if (type == 1 || type == 3) {
            LinkedList<Position> positions = new LinkedList<Position>();
            HashSet<Integer> keys = new HashSet<Integer>();
            Position position = new Position(this.getProtocolName());
            DeviceSession deviceSession = null;
            while (buf.isReadable()) {
                short length = buf.readUnsignedByte();
                int endIndex = buf.readerIndex() + length;
                short key = buf.readUnsignedByte();
                if (keys.contains(key)) {
                    positions.add(position);
                    keys.clear();
                    position = new Position(this.getProtocolName());
                }
                keys.add(Integer.valueOf(key));
                switch (key) {
                    case 1: {
                        deviceSession = this.getDeviceSession(channel, remoteAddress, buf.readCharSequence(15, StandardCharsets.US_ASCII).toString());
                        if (deviceSession != null) break;
                        return null;
                    }
                    case 2: {
                        long alarm = buf.readUnsignedIntLE();
                        if (BitUtil.check(alarm, 0)) {
                            position.addAlarm("lowBattery");
                        }
                        if (BitUtil.check(alarm, 1)) {
                            position.addAlarm("overspeed");
                        }
                        if (BitUtil.check(alarm, 2)) {
                            position.addAlarm("fallDown");
                        }
                        for (int i = 0; i < 4; ++i) {
                            if (!BitUtil.check(alarm, i + 4)) continue;
                            if (BitUtil.check(alarm, i + 26)) {
                                position.addAlarm("geofenceEnter");
                            } else {
                                position.addAlarm("geofenceExit");
                            }
                            position.set("geofence", i + 1);
                        }
                        if (BitUtil.check(alarm, 8)) {
                            position.addAlarm("powerOff");
                        }
                        if (BitUtil.check(alarm, 9)) {
                            position.addAlarm("powerOn");
                        }
                        if (BitUtil.check(alarm, 10)) {
                            position.addAlarm("movement");
                        }
                        if (BitUtil.check(alarm, 12)) {
                            position.addAlarm("sos");
                        }
                        if (BitUtil.check(alarm, 31)) {
                            position.set("bark", true);
                        }
                        if (length == 5) {
                            position.setDeviceTime(new Date(buf.readUnsignedIntLE() * 1000L));
                        }
                        position.set("event", alarm);
                        break;
                    }
                    case 20: {
                        position.set("batteryLevel", buf.readUnsignedByte());
                        position.set("battery", (double)buf.readUnsignedShortLE() * 0.001);
                        break;
                    }
                    case 32: {
                        position.setLatitude((double)buf.readIntLE() * 1.0E-7);
                        position.setLongitude((double)buf.readIntLE() * 1.0E-7);
                        position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedShortLE()));
                        position.setCourse(buf.readUnsignedShortLE());
                        position.setAltitude(buf.readShortLE());
                        int hdop = buf.readUnsignedShortLE();
                        position.setValid(hdop > 0);
                        position.set("hdop", (double)hdop * 0.1);
                        position.set("odometer", buf.readUnsignedIntLE());
                        position.set("sat", buf.readUnsignedByte());
                        break;
                    }
                    case 33: 
                    case 41: {
                        int mcc = buf.readUnsignedShortLE();
                        short mnc = buf.readUnsignedByte();
                        if (position.getNetwork() == null) {
                            position.setNetwork(new Network());
                        }
                        while (buf.readerIndex() < endIndex) {
                            byte rssi = buf.readByte();
                            int lac = buf.readUnsignedShortLE();
                            long cid = key == 41 ? (long)buf.readIntLE() : (long)buf.readUnsignedShortLE();
                            position.getNetwork().addCellTower(CellTower.from(mcc, mnc, lac, cid, rssi));
                        }
                        break;
                    }
                    case 25: 
                    case 34: {
                        if (position.getNetwork() == null) {
                            position.setNetwork(new Network());
                        }
                        while (buf.readerIndex() < endIndex) {
                            byte rssi = buf.readByte();
                            String mac = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(6)).replaceAll("(..)", "$1:");
                            position.getNetwork().addWifiAccessPoint(WifiAccessPoint.from(mac.substring(0, mac.length() - 1), rssi));
                            if (key != 25) continue;
                            buf.skipBytes((int)buf.readUnsignedByte());
                        }
                        break;
                    }
                    case 35: 
                    case 38: {
                        if (length >= 7) {
                            position.set("tagId", this.readTagId(buf));
                        }
                        if (length >= 15) {
                            position.setLatitude((double)buf.readIntLE() * 1.0E-7);
                            position.setLongitude((double)buf.readIntLE() * 1.0E-7);
                            position.setValid(true);
                        }
                        if (key == 38) {
                            position.set("hdop", (double)buf.readUnsignedShortLE() * 0.1);
                            position.setAltitude(buf.readShortLE());
                            break;
                        }
                        if (length <= 15) break;
                        position.set("description", buf.readCharSequence((int)length, StandardCharsets.US_ASCII).toString());
                        break;
                    }
                    case 36: {
                        position.setTime(new Date(buf.readUnsignedIntLE() * 1000L));
                        long status = buf.readUnsignedIntLE();
                        if (BitUtil.check(status, 4)) {
                            position.set("charge", true);
                        }
                        if (BitUtil.check(status, 7)) {
                            position.set("archive", true);
                        }
                        position.set("motion", BitUtil.check(status, 9));
                        position.set("rssi", BitUtil.between(status, 19, 24));
                        position.set("batteryLevel", BitUtil.from(status, 24));
                        position.set("status", status);
                        break;
                    }
                    case 37: {
                        position.setTime(new Date(buf.readUnsignedIntLE() * 1000L));
                        position.set("callStatus", buf.readUnsignedByte());
                        position.set("callDuration", buf.readUnsignedShortLE());
                        position.set("callResult", buf.readUnsignedByte());
                        position.set("phone", buf.readCharSequence(endIndex - buf.readerIndex(), StandardCharsets.US_ASCII).toString());
                        break;
                    }
                    case 39: {
                        position.setLatitude((double)buf.readIntLE() * 1.0E-7);
                        position.setLongitude((double)buf.readIntLE() * 1.0E-7);
                        position.setValid(true);
                        position.set("hdop", (double)buf.readUnsignedShortLE() * 0.1);
                        position.setAltitude(buf.readShortLE());
                        break;
                    }
                    case 40: 
                    case 44: {
                        short beaconFlags = buf.readUnsignedByte();
                        position.set("tagId", this.readTagId(buf));
                        position.set("tagRssi", Integer.valueOf(buf.readByte()));
                        position.set("tag1mRssi", Integer.valueOf(buf.readByte()));
                        if (key == 44) {
                            position.set("tagBattery", buf.readUnsignedByte());
                        }
                        if (BitUtil.check(beaconFlags, 7)) {
                            position.setLatitude((double)buf.readIntLE() * 1.0E-7);
                            position.setLongitude((double)buf.readIntLE() * 1.0E-7);
                            position.setValid(true);
                        }
                        if (BitUtil.check(beaconFlags, 6)) {
                            int descriptionLength = key == 44 ? buf.readUnsignedByte() : endIndex - buf.readerIndex();
                            position.set("description", buf.readCharSequence(descriptionLength, StandardCharsets.US_ASCII).toString());
                        }
                        if (key != 44) break;
                        position.set("tagTemp", (double)buf.readShort() / 10.0);
                        break;
                    }
                    case 42: {
                        buf.readUnsignedByte();
                        buf.skipBytes(6);
                        buf.readUnsignedByte();
                        position.setLatitude((double)buf.readIntLE() * 1.0E-7);
                        position.setLongitude((double)buf.readIntLE() * 1.0E-7);
                        position.setValid(true);
                        if (endIndex <= buf.readerIndex()) break;
                        position.set("description", buf.readCharSequence(endIndex - buf.readerIndex(), StandardCharsets.US_ASCII).toString());
                        break;
                    }
                    case 48: {
                        buf.readUnsignedIntLE();
                        position.set("steps", buf.readUnsignedIntLE());
                        break;
                    }
                    case 49: {
                        int i = 1;
                        while (buf.readerIndex() < endIndex) {
                            position.set("activity" + i + "Time", buf.readUnsignedIntLE());
                            position.set("activity" + i, buf.readUnsignedIntLE());
                            ++i;
                        }
                        break;
                    }
                    case 55: {
                        buf.readUnsignedIntLE();
                        long barking = buf.readUnsignedIntLE();
                        if (BitUtil.check(barking, 31)) {
                            position.set("barkStop", true);
                        }
                        position.set("barkCount", BitUtil.to(barking, 31));
                        break;
                    }
                    case 64: {
                        buf.readUnsignedIntLE();
                        short heartRate = buf.readUnsignedByte();
                        if (heartRate <= 1) break;
                        position.set("heartRate", Integer.valueOf(heartRate));
                        break;
                    }
                    case 65: {
                        buf.readUnsignedIntLE();
                        short spO2 = buf.readUnsignedByte();
                        if (spO2 <= 1) break;
                        position.set("spO2", Integer.valueOf(spO2));
                        break;
                    }
                }
                buf.readerIndex(endIndex);
            }
            positions.add(position);
            if (deviceSession != null) {
                for (Position p : positions) {
                    p.setDeviceId(deviceSession.getDeviceId());
                    if (p.getValid() || p.hasAttribute("hdop")) continue;
                    this.getLastLocation(p, null);
                }
            } else {
                return null;
            }
            return positions;
        }
        if (type == 2) {
            return this.decodeConfiguration(channel, remoteAddress, buf);
        }
        if (type == 127) {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.getLastLocation(position, null);
            buf.readUnsignedByte();
            position.set("result", String.valueOf(buf.readUnsignedByte()));
            return position;
        }
        return null;
    }

    private Position decodeConfiguration(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, null);
        while (buf.isReadable()) {
            int length = buf.readUnsignedByte() - 1;
            int endIndex = buf.readerIndex() + length + 1;
            short key = buf.readUnsignedByte();
            switch (key) {
                case 1: {
                    position.set("moduleNumber", buf.readUnsignedInt());
                    break;
                }
                case 2: {
                    position.set("versionFw", String.valueOf(buf.readUnsignedInt()));
                    break;
                }
                case 3: {
                    position.set("imei", buf.readCharSequence(length, StandardCharsets.US_ASCII).toString());
                    break;
                }
                case 4: {
                    position.set("iccid", BufferUtil.readString(buf, length));
                    break;
                }
                case 5: {
                    position.set("bleMac", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(length)));
                    break;
                }
                case 6: {
                    position.set("settingTime", buf.readUnsignedInt());
                    break;
                }
                case 7: {
                    position.set("runTimes", buf.readUnsignedInt());
                    break;
                }
                case 10: {
                    position.set("interval", buf.readUnsignedMedium());
                    position.set("petMode", buf.readUnsignedByte());
                    break;
                }
                case 13: {
                    position.set("passwordProtect", buf.readUnsignedInt());
                    break;
                }
                case 14: {
                    position.set("timeZone", Integer.valueOf(buf.readByte()));
                    break;
                }
                case 15: {
                    position.set("enableControl", buf.readUnsignedInt());
                    break;
                }
                case 19: {
                    position.set("deviceName", BufferUtil.readString(buf, length));
                    break;
                }
                case 20: {
                    position.set("batteryLevel", buf.readUnsignedByte());
                    position.set("battery", (double)buf.readUnsignedShort() * 0.001);
                    break;
                }
                case 21: {
                    position.set("bleLatitude", (double)buf.readIntLE() * 1.0E-7);
                    position.set("bleLongitude", (double)buf.readIntLE() * 1.0E-7);
                    position.set("bleLocation", BufferUtil.readString(buf, length - 8));
                    break;
                }
                case 23: {
                    position.set("gpsUrl", BufferUtil.readString(buf, length));
                    break;
                }
                case 24: {
                    position.set("lbsUrl", BufferUtil.readString(buf, length));
                    break;
                }
                case 26: {
                    position.set("firmware", BufferUtil.readString(buf, length));
                    break;
                }
                case 27: {
                    position.set("gsmModule", BufferUtil.readString(buf, length));
                    break;
                }
                case 29: {
                    position.set("agpsUpdate", buf.readUnsignedByte());
                    position.set("agpsLatitude", (double)buf.readIntLE() * 1.0E-7);
                    position.set("agpsLongitude", (double)buf.readIntLE() * 1.0E-7);
                    break;
                }
                case 48: {
                    position.set("numberFlag", buf.readUnsignedByte());
                    position.set("number", BufferUtil.readString(buf, length - 1));
                    break;
                }
                case 49: {
                    position.set("prefixFlag", buf.readUnsignedByte());
                    position.set("prefix", BufferUtil.readString(buf, length - 1));
                    break;
                }
                case 51: {
                    position.set("phoneSwitches", buf.readUnsignedByte());
                    break;
                }
                case 64: {
                    position.set("apn", BufferUtil.readString(buf, length));
                    break;
                }
                case 65: {
                    position.set("apnUser", BufferUtil.readString(buf, length));
                    break;
                }
                case 66: {
                    position.set("apnPassword", BufferUtil.readString(buf, length));
                    break;
                }
                case 67: {
                    buf.readUnsignedByte();
                    position.set("port", buf.readUnsignedShort());
                    position.set("server", BufferUtil.readString(buf, length - 3));
                    break;
                }
                case 68: {
                    position.set("heartbeatInterval", buf.readUnsignedInt());
                    position.set("uploadInterval", buf.readUnsignedInt());
                    position.set("uploadLazyInterval", buf.readUnsignedInt());
                    break;
                }
                case 71: {
                    position.set("deviceId", BufferUtil.readString(buf, length));
                    break;
                }
                case 78: {
                    position.set("gsmBand", buf.readUnsignedByte());
                    break;
                }
                case 80: {
                    position.set("powerAlert", buf.readUnsignedInt());
                    break;
                }
                case 81: {
                    position.set("geoAlert", buf.readUnsignedInt());
                    break;
                }
                case 83: {
                    position.set("motionAlert", buf.readUnsignedInt());
                    break;
                }
                case 92: {
                    position.set("barkLevel", buf.readUnsignedByte());
                    position.set("barkInterval", buf.readUnsignedInt());
                    break;
                }
                case 97: {
                    position.set("msisdn", BufferUtil.readString(buf, length));
                    break;
                }
                case 98: {
                    position.set("wifiWhitelist", buf.readUnsignedByte());
                    position.set("wifiWhitelistMac", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(6)));
                    break;
                }
                case 100: {
                    position.set("rssi", buf.readUnsignedByte());
                    position.set("networkBand", buf.readUnsignedInt());
                    position.set("operator", BufferUtil.readString(buf, length - 5));
                    break;
                }
                case 101: {
                    position.set("rssi", buf.readUnsignedByte());
                    position.set("networkStatus", buf.readUnsignedByte());
                    position.set("serverStatus", buf.readUnsignedByte());
                    position.set("networkPlmn", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(6)));
                    position.set("homePlmn", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(6)));
                    break;
                }
                case 102: {
                    position.set("imsi", BufferUtil.readString(buf, length));
                    break;
                }
                case 117: {
                    position.set("extraEnableControl", buf.readUnsignedInt());
                }
            }
            buf.readerIndex(endIndex);
        }
        return position;
    }
}

