/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.session.state;

import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.traccar.helper.DistanceCalculator;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.session.state.NewMotionState;

public final class NewMotionProcessor {
    private NewMotionProcessor() {
    }

    public static void updateState(NewMotionState state, Position position, double minDistance, long minDuration, long stopGap) {
        long gap;
        ArrayList<Event> events = new ArrayList<Event>();
        state.setEvents(events);
        Deque<Position> positions = state.getPositions();
        if (positions.isEmpty()) {
            return;
        }
        double minAverageSpeed = minDistance / (double)minDuration;
        Position last = positions.peekLast();
        if (last != null && (gap = position.getFixTime().getTime() - last.getFixTime().getTime()) > stopGap && NewMotionProcessor.averageSpeed(last, position) < minAverageSpeed) {
            if (state.getMotionStreak()) {
                NewMotionProcessor.addEvent(state, events, "deviceStopped", last);
            }
            NewMotionProcessor.addEvent(state, events, "deviceMoving", last);
            NewMotionProcessor.addEvent(state, events, "deviceStopped", position);
            state.setMotionStreak(false);
            return;
        }
        if (state.getMotionStreak()) {
            Iterator<Position> iterator = positions.descendingIterator();
            while (iterator.hasNext()) {
                Position candidate = iterator.next();
                double distance = DistanceCalculator.distance(candidate.getLatitude(), candidate.getLongitude(), position.getLatitude(), position.getLongitude());
                if (!(distance >= minDistance)) continue;
                return;
            }
            Position oldest = positions.peekFirst();
            long duration = position.getFixTime().getTime() - oldest.getFixTime().getTime();
            if (duration >= minDuration) {
                state.setMotionStreak(false);
                NewMotionProcessor.addEvent(state, events, "deviceStopped", position);
            }
        } else {
            double distance = DistanceCalculator.distance(state.getEventLatitude(), state.getEventLongitude(), position.getLatitude(), position.getLongitude());
            if (distance >= minDistance) {
                state.setMotionStreak(true);
                NewMotionProcessor.addEvent(state, events, "deviceMoving", position);
            }
        }
    }

    private static double averageSpeed(Position from, Position to) {
        long duration = to.getFixTime().getTime() - from.getFixTime().getTime();
        if (duration <= 0L) {
            return Double.NaN;
        }
        double distance = DistanceCalculator.distance(from.getLatitude(), from.getLongitude(), to.getLatitude(), to.getLongitude());
        return distance / (double)duration;
    }

    private static void addEvent(NewMotionState state, List<Event> events, String type, Position position) {
        Event event = new Event(type, position.getDeviceId());
        event.setPositionId(position.getId());
        event.setEventTime(position.getFixTime());
        events.add(event);
        state.setEventPosition(position);
    }
}

