/*
 * Decompiled with CFR 0.152.
 */
package com.azure.json.implementation.jackson.core;

import com.azure.json.implementation.jackson.core.JsonEncoding;
import com.azure.json.implementation.jackson.core.JsonGenerator;
import com.azure.json.implementation.jackson.core.JsonParser;
import com.azure.json.implementation.jackson.core.io.ContentReference;
import com.azure.json.implementation.jackson.core.io.IOContext;
import com.azure.json.implementation.jackson.core.io.UTF8Writer;
import com.azure.json.implementation.jackson.core.json.ByteSourceJsonBootstrapper;
import com.azure.json.implementation.jackson.core.json.ReaderBasedJsonParser;
import com.azure.json.implementation.jackson.core.json.UTF8JsonGenerator;
import com.azure.json.implementation.jackson.core.json.WriterBasedJsonGenerator;
import com.azure.json.implementation.jackson.core.sym.ByteQuadsCanonicalizer;
import com.azure.json.implementation.jackson.core.sym.CharsToNameCanonicalizer;
import com.azure.json.implementation.jackson.core.util.BufferRecycler;
import com.azure.json.implementation.jackson.core.util.BufferRecyclers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

public class JsonFactory {
    protected final transient CharsToNameCanonicalizer _rootCharSymbols = CharsToNameCanonicalizer.createRoot();
    protected final transient ByteQuadsCanonicalizer _byteSymbolCanonicalizer = ByteQuadsCanonicalizer.createRoot();
    private static final int _parserFeatures = JsonParser.Feature.collectDefaults();
    private static final int _generatorFeatures = JsonGenerator.Feature.collectDefaults();

    public JsonParser createParser(InputStream in) throws IOException {
        return new ByteSourceJsonBootstrapper(JsonFactory._createContext(ContentReference.construct(in), false), in).constructParser(_parserFeatures, this._byteSymbolCanonicalizer, this._rootCharSymbols);
    }

    public JsonParser createParser(Reader r) {
        return new ReaderBasedJsonParser(JsonFactory._createContext(ContentReference.construct(r), false), _parserFeatures, r, this._rootCharSymbols.makeChild());
    }

    public JsonParser createParser(byte[] data) throws IOException {
        IOContext ctxt = JsonFactory._createContext(ContentReference.construct(data), true);
        return new ByteSourceJsonBootstrapper(ctxt, data, 0, data.length).constructParser(_parserFeatures, this._byteSymbolCanonicalizer, this._rootCharSymbols);
    }

    public JsonParser createParser(String content) {
        int strLen = content.length();
        IOContext ctxt = JsonFactory._createContext(ContentReference.construct(content), true);
        char[] buf = ctxt.allocTokenBuffer(strLen);
        content.getChars(0, strLen, buf, 0);
        return new ReaderBasedJsonParser(ctxt, _parserFeatures, null, this._rootCharSymbols.makeChild(), buf, 0, strLen, true);
    }

    public JsonGenerator createGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        IOContext ctxt = JsonFactory._createContext(ContentReference.construct(out), false);
        ctxt.setEncoding(enc);
        if (enc == JsonEncoding.UTF8) {
            return new UTF8JsonGenerator(ctxt, _generatorFeatures, out);
        }
        Writer w = this._createWriter(out, enc, ctxt);
        return this._createGenerator(w, ctxt);
    }

    public JsonGenerator createGenerator(OutputStream out) throws IOException {
        return this.createGenerator(out, JsonEncoding.UTF8);
    }

    public JsonGenerator createGenerator(Writer w) {
        return this._createGenerator(w, JsonFactory._createContext(ContentReference.construct(w), false));
    }

    protected JsonGenerator _createGenerator(Writer out, IOContext ctxt) {
        return new WriterBasedJsonGenerator(ctxt, _generatorFeatures, out);
    }

    protected Writer _createWriter(OutputStream out, JsonEncoding enc, IOContext ctxt) throws IOException {
        if (enc == JsonEncoding.UTF8) {
            return new UTF8Writer(ctxt, out);
        }
        return new OutputStreamWriter(out, enc.getJavaName());
    }

    private static BufferRecycler _getBufferRecycler() {
        return BufferRecyclers.getBufferRecycler();
    }

    private static IOContext _createContext(ContentReference contentRef, boolean resourceManaged) {
        return new IOContext(JsonFactory._getBufferRecycler(), contentRef, resourceManaged);
    }
}

