/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.dpop.verifiers;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.dpop.JWKThumbprintConfirmation;
import com.nimbusds.oauth2.sdk.dpop.verifiers.AccessTokenValidationException;
import com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPCommonVerifier;
import com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPIssuer;
import com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPProofContext;
import com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPProofUse;
import com.nimbusds.oauth2.sdk.dpop.verifiers.InvalidDPoPProofException;
import com.nimbusds.oauth2.sdk.id.JWTID;
import com.nimbusds.oauth2.sdk.token.DPoPAccessToken;
import com.nimbusds.oauth2.sdk.util.Receiver;
import com.nimbusds.oauth2.sdk.util.singleuse.SingleUseChecker;
import com.nimbusds.openid.connect.sdk.Nonce;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DPoPProtectedResourceRequestVerifier
extends DPoPCommonVerifier {
    public DPoPProtectedResourceRequestVerifier(Set<JWSAlgorithm> acceptedJWSAlgs, long maxClockSkewSeconds, long maxAgeSeconds, SingleUseChecker<DPoPProofUse> singleUseChecker) {
        super(acceptedJWSAlgs, maxClockSkewSeconds, maxAgeSeconds, singleUseChecker);
    }

    @Deprecated
    public DPoPProtectedResourceRequestVerifier(Set<JWSAlgorithm> acceptedJWSAlgs, long maxClockSkewSeconds, SingleUseChecker<Map.Entry<DPoPIssuer, JWTID>> singleUseChecker) {
        super(acceptedJWSAlgs, maxClockSkewSeconds, singleUseChecker);
    }

    @Deprecated
    public void verify(String method, URI uri, DPoPIssuer issuer, SignedJWT proof, DPoPAccessToken accessToken, JWKThumbprintConfirmation cnf) throws InvalidDPoPProofException, AccessTokenValidationException, JOSEException {
        this.verify(method, uri, issuer, proof, accessToken, cnf, null, null);
    }

    public void verify(String method, URI uri, DPoPIssuer issuer, SignedJWT proof, DPoPAccessToken accessToken, JWKThumbprintConfirmation cnf, Nonce nonce) throws InvalidDPoPProofException, AccessTokenValidationException, JOSEException {
        this.verify(method, uri, issuer, proof, accessToken, cnf, nonce != null ? Collections.singleton(nonce) : null, null);
    }

    @Override
    public void verify(String method, URI uri, DPoPIssuer issuer, SignedJWT proof, DPoPAccessToken accessToken, JWKThumbprintConfirmation cnf, Set<Nonce> nonces, Receiver<DPoPProofContext> ctxReceiver) throws InvalidDPoPProofException, AccessTokenValidationException, JOSEException {
        if (proof == null) {
            throw new InvalidDPoPProofException("Missing required DPoP proof");
        }
        Objects.requireNonNull(accessToken);
        Objects.requireNonNull(cnf);
        super.verify(method, uri, issuer, proof, accessToken, cnf, nonces, ctxReceiver);
    }
}

