/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search.hybrid;

import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.search.Scorer;
import redis.clients.jedis.search.SearchProtocol;
import redis.clients.jedis.util.JedisAsserts;

@Experimental
public class FTHybridSearchParams
implements IParams {
    private String query;
    private Scorer scorer;
    private String scoreAlias;

    private FTHybridSearchParams() {
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void addParams(CommandArguments args) {
        args.add(SearchProtocol.SearchKeyword.SEARCH);
        args.add(this.query);
        if (this.scorer != null) {
            args.add(SearchProtocol.SearchKeyword.SCORER);
            this.scorer.addParams(args);
        }
        if (this.scoreAlias != null) {
            args.add(SearchProtocol.SearchKeyword.YIELD_SCORE_AS);
            args.add(this.scoreAlias);
        }
    }

    public static class Builder {
        private final FTHybridSearchParams instance = new FTHybridSearchParams();

        public FTHybridSearchParams build() {
            JedisAsserts.notNull(this.instance.query, "Query must not be null");
            return this.instance;
        }

        public Builder query(String query) {
            this.instance.query = query;
            return this;
        }

        public Builder scorer(Scorer scorer) {
            this.instance.scorer = scorer;
            return this;
        }

        public Builder scoreAlias(String scoreAlias) {
            this.instance.scoreAlias = scoreAlias;
            return this;
        }
    }
}

