/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StreamController;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.ExplainStats;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.FirestoreRpcContext;
import com.google.cloud.firestore.PipelineResult;
import com.google.cloud.firestore.PipelineUtils;
import com.google.cloud.firestore.VectorValue;
import com.google.cloud.firestore.pipeline.expressions.AliasedAggregate;
import com.google.cloud.firestore.pipeline.expressions.BooleanExpression;
import com.google.cloud.firestore.pipeline.expressions.Expression;
import com.google.cloud.firestore.pipeline.expressions.Field;
import com.google.cloud.firestore.pipeline.expressions.Ordering;
import com.google.cloud.firestore.pipeline.expressions.Selectable;
import com.google.cloud.firestore.pipeline.stages.AddFields;
import com.google.cloud.firestore.pipeline.stages.Aggregate;
import com.google.cloud.firestore.pipeline.stages.AggregateOptions;
import com.google.cloud.firestore.pipeline.stages.Distinct;
import com.google.cloud.firestore.pipeline.stages.FindNearest;
import com.google.cloud.firestore.pipeline.stages.FindNearestOptions;
import com.google.cloud.firestore.pipeline.stages.Limit;
import com.google.cloud.firestore.pipeline.stages.Offset;
import com.google.cloud.firestore.pipeline.stages.PipelineExecuteOptions;
import com.google.cloud.firestore.pipeline.stages.RawStage;
import com.google.cloud.firestore.pipeline.stages.RemoveFields;
import com.google.cloud.firestore.pipeline.stages.ReplaceWith;
import com.google.cloud.firestore.pipeline.stages.Sample;
import com.google.cloud.firestore.pipeline.stages.Select;
import com.google.cloud.firestore.pipeline.stages.Sort;
import com.google.cloud.firestore.pipeline.stages.Stage;
import com.google.cloud.firestore.pipeline.stages.StageUtils;
import com.google.cloud.firestore.pipeline.stages.Union;
import com.google.cloud.firestore.pipeline.stages.Unnest;
import com.google.cloud.firestore.pipeline.stages.UnnestOptions;
import com.google.cloud.firestore.pipeline.stages.Where;
import com.google.cloud.firestore.telemetry.MetricsUtil;
import com.google.cloud.firestore.telemetry.TelemetryConstants;
import com.google.cloud.firestore.telemetry.TraceUtil;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.ExecutePipelineRequest;
import com.google.firestore.v1.ExecutePipelineResponse;
import com.google.firestore.v1.StructuredPipeline;
import com.google.firestore.v1.Value;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@BetaApi
public final class Pipeline {
    private static Logger logger = Logger.getLogger(Pipeline.class.getName());
    private final FluentIterable<Stage> stages;
    private final FirestoreRpcContext<?> rpcContext;

    private Pipeline(FirestoreRpcContext<?> rpcContext, FluentIterable<Stage> stages) {
        this.rpcContext = rpcContext;
        this.stages = stages;
    }

    @InternalApi
    Pipeline(FirestoreRpcContext<?> rpcContext, Stage stage) {
        this(rpcContext, (FluentIterable<Stage>)FluentIterable.of((Object)stage, (Object[])new Stage[0]));
    }

    private Pipeline append(Stage stage) {
        return new Pipeline(this.rpcContext, (FluentIterable<Stage>)this.stages.append((Object[])new Stage[]{stage}));
    }

    @BetaApi
    public Pipeline addFields(Selectable field, Selectable ... additionalFields) {
        return this.append(new AddFields(PipelineUtils.selectablesToMap((Selectable[])ImmutableList.builder().add((Object)field).add((Object[])additionalFields).build().toArray((Object[])new Selectable[0]))));
    }

    @BetaApi
    public Pipeline removeFields(String field, String ... additionalFields) {
        return this.append(new RemoveFields((ImmutableList<Field>)ImmutableList.builder().add((Object)Field.ofUserPath(field)).addAll(Arrays.stream(additionalFields).map(f -> Field.ofUserPath(f)).iterator()).build()));
    }

    @BetaApi
    public Pipeline removeFields(Field field, Field ... additionalFields) {
        return this.append(new RemoveFields((ImmutableList<Field>)ImmutableList.builder().add((Object)field).addAll(Arrays.stream(additionalFields).iterator()).build()));
    }

    @BetaApi
    public Pipeline select(Selectable selection, Selectable ... additionalSelections) {
        return this.append(new Select(PipelineUtils.selectablesToMap((Selectable[])ImmutableList.builder().add((Object)selection).add((Object[])additionalSelections).build().toArray((Object[])new Selectable[0]))));
    }

    @BetaApi
    public Pipeline select(String field, String ... additionalFields) {
        return this.append(new Select(PipelineUtils.fieldNamesToMap((String[])ImmutableList.builder().add((Object)field).add((Object[])additionalFields).build().toArray((Object[])new String[0]))));
    }

    @BetaApi
    public Pipeline where(BooleanExpression condition) {
        return this.append(new Where(condition));
    }

    @BetaApi
    public Pipeline offset(int offset) {
        return this.append(new Offset(offset));
    }

    @BetaApi
    public Pipeline limit(int limit) {
        return this.append(new Limit(limit));
    }

    @BetaApi
    public Pipeline aggregate(AliasedAggregate ... accumulators) {
        return this.append(Aggregate.withAccumulators(accumulators));
    }

    @BetaApi
    public Pipeline aggregate(Aggregate aggregate) {
        return this.append(aggregate);
    }

    @BetaApi
    public Pipeline aggregate(Aggregate aggregate, AggregateOptions options) {
        return this.append(aggregate.withOptions(options));
    }

    @BetaApi
    public Pipeline distinct(String ... fields) {
        return this.append(new Distinct(PipelineUtils.fieldNamesToMap(fields)));
    }

    @BetaApi
    public Pipeline distinct(Selectable ... selectables) {
        return this.append(new Distinct(PipelineUtils.selectablesToMap(selectables)));
    }

    @BetaApi
    public Pipeline findNearest(String fieldName, double[] vector, FindNearest.DistanceMeasure distanceMeasure, FindNearestOptions options) {
        return this.findNearest(Expression.field(fieldName), vector, distanceMeasure, options);
    }

    @BetaApi
    public Pipeline findNearest(Expression property, double[] vector, FindNearest.DistanceMeasure distanceMeasure, FindNearestOptions options) {
        return this.append(new FindNearest(property, new VectorValue(vector), distanceMeasure, options));
    }

    @BetaApi
    public Pipeline sort(Ordering ... orders) {
        return this.append(new Sort((ImmutableList<Ordering>)ImmutableList.copyOf((Object[])orders)));
    }

    @BetaApi
    public Pipeline replaceWith(String fieldName) {
        return this.replaceWith(Expression.field(fieldName));
    }

    @BetaApi
    public Pipeline replaceWith(Expression expr) {
        return this.append(new ReplaceWith(expr));
    }

    @BetaApi
    public Pipeline sample(int limit) {
        return this.sample(Sample.withDocLimit(limit));
    }

    @BetaApi
    public Pipeline sample(Sample sample) {
        return this.append(sample);
    }

    @BetaApi
    public Pipeline union(Pipeline other) {
        return this.append(new Union(other));
    }

    @BetaApi
    public Pipeline unnest(String fieldName, String alias) {
        return this.append(new Unnest(Expression.field(fieldName), alias));
    }

    @BetaApi
    public Pipeline unnest(String fieldName, String alias, UnnestOptions options) {
        return this.append(new Unnest(Expression.field(fieldName), alias, options));
    }

    @BetaApi
    public Pipeline unnest(Selectable expr) {
        return this.append(new Unnest(expr));
    }

    @BetaApi
    public Pipeline unnest(Selectable field, UnnestOptions options) {
        return this.append(new Unnest(field, options));
    }

    @BetaApi
    public Pipeline rawStage(RawStage stage) {
        return this.append(stage);
    }

    @BetaApi
    public ApiFuture<Snapshot> execute() {
        return this.execute(new PipelineExecuteOptions(), null, null);
    }

    @BetaApi
    public ApiFuture<Snapshot> execute(PipelineExecuteOptions options) {
        return this.execute(options, null, null);
    }

    MetricsUtil.MetricsContext createMetricsContext(String methodName) {
        return ((FirestoreOptions)this.rpcContext.getFirestore().getOptions()).getMetricsUtil().createMetricsContext(methodName);
    }

    @BetaApi
    public void execute(final ApiStreamObserver<PipelineResult> observer) {
        MetricsUtil.MetricsContext metricsContext = this.createMetricsContext("ExecutePipeline.Execute");
        this.executeInternal(new PipelineExecuteOptions(), null, null, new PipelineResultObserver(){

            public void onNext(PipelineResult result) {
                observer.onNext((Object)result);
            }

            public void onError(Throwable t) {
                observer.onError(t);
            }

            public void onCompleted() {
                observer.onCompleted();
            }
        }, metricsContext);
    }

    ApiFuture<Snapshot> execute(@Nonnull PipelineExecuteOptions options, @Nullable ByteString transactionId, @Nullable com.google.protobuf.Timestamp readTime) {
        TraceUtil.Span span = ((FirestoreOptions)this.rpcContext.getFirestore().getOptions()).getTraceUtil().startSpan("Pipeline.Execute");
        MetricsUtil.MetricsContext metricsContext = this.createMetricsContext("ExecutePipeline.Execute");
        TraceUtil.Scope ignored = span.makeCurrent();
        try {
            final SettableApiFuture futureResult = SettableApiFuture.create();
            this.executeInternal(options, transactionId, readTime, new PipelineResultObserver(){
                final List<PipelineResult> results = new ArrayList<PipelineResult>();

                public void onCompleted() {
                    futureResult.set((Object)new Snapshot(Pipeline.this, this.results, this.getExecutionTime(), this.getExplainStats()));
                }

                public void onNext(PipelineResult result) {
                    this.results.add(result);
                }

                public void onError(Throwable t) {
                    futureResult.setException(t);
                }
            }, metricsContext);
            span.endAtFuture(futureResult);
            SettableApiFuture settableApiFuture = futureResult;
            if (ignored != null) {
                ignored.close();
            }
            return settableApiFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception error) {
                span.end(error);
                metricsContext.recordLatency(TelemetryConstants.MetricType.END_TO_END_LATENCY, error);
                throw error;
            }
        }
    }

    void executeInternal(@Nonnull PipelineExecuteOptions options, @Nullable ByteString transactionId, @Nullable com.google.protobuf.Timestamp readTime, final PipelineResultObserver observer, MetricsUtil.MetricsContext metricsContext) {
        ExecutePipelineRequest.Builder request = ExecutePipelineRequest.newBuilder().setDatabase(this.rpcContext.getDatabaseName()).setStructuredPipeline(StructuredPipeline.newBuilder().setPipeline(this.toProto()).putAllOptions(StageUtils.toMap(options)).build());
        if (transactionId != null) {
            request.setTransaction(transactionId);
        }
        if (readTime != null) {
            request.setReadTime(readTime);
        }
        this.pipelineInternalStream(request.build(), new PipelineResultObserver(){

            public void onCompleted() {
                observer.setExplainStats(this.getExplainStats());
                observer.setExecutionTime(this.getExecutionTime());
                observer.onCompleted();
            }

            public void onNext(PipelineResult result) {
                observer.onNext(result);
            }

            public void onError(Throwable t) {
                observer.onError(t);
            }
        }, metricsContext);
    }

    @InternalApi
    private com.google.firestore.v1.Pipeline toProto() {
        return com.google.firestore.v1.Pipeline.newBuilder().addAllStages((Iterable)this.stages.transform(StageUtils::toStageProto)).build();
    }

    @InternalApi
    public Value toProtoValue() {
        return Value.newBuilder().setPipelineValue(this.toProto()).build();
    }

    private void pipelineInternalStream(ExecutePipelineRequest request, final PipelineResultObserver resultObserver, final MetricsUtil.MetricsContext metricsContext) {
        TraceUtil traceUtil = ((FirestoreOptions)this.rpcContext.getFirestore().getOptions()).getTraceUtil();
        int NUM_RESPONSES_PER_TRACE_EVENT = 100;
        final TraceUtil.Span currentSpan = traceUtil.currentSpan();
        currentSpan.addEvent("ExecutePipeline", (Map<String, Object>)new ImmutableMap.Builder().put((Object)"transactional", (Object)request.hasTransaction()).build());
        ResponseObserver<ExecutePipelineResponse> observer = new ResponseObserver<ExecutePipelineResponse>(){
            Timestamp executionTime = null;
            boolean firstResponse = false;
            int numDocuments = 0;
            boolean hasCompleted = false;

            public void onStart(StreamController controller) {
            }

            public void onResponse(ExecutePipelineResponse response) {
                if (!this.firstResponse) {
                    this.firstResponse = true;
                    currentSpan.addEvent("ExecutePipeline: First Response");
                    metricsContext.recordLatency(TelemetryConstants.MetricType.FIRST_RESPONSE_LATENCY);
                }
                if (response.hasExplainStats()) {
                    resultObserver.setExplainStats(new ExplainStats(response.getExplainStats().getData()));
                }
                if (response.hasExecutionTime()) {
                    this.executionTime = Timestamp.fromProto((com.google.protobuf.Timestamp)response.getExecutionTime());
                }
                if (response.getResultsCount() > 0) {
                    this.numDocuments += response.getResultsCount();
                    if (this.numDocuments % 100 == 0) {
                        currentSpan.addEvent("ExecutePipeline: Received " + this.numDocuments + " results");
                    }
                    for (Document doc : response.getResultsList()) {
                        resultObserver.onNext(PipelineResult.fromDocument(Pipeline.this.rpcContext, this.executionTime, doc));
                    }
                }
            }

            public void onError(Throwable throwable) {
                currentSpan.addEvent("ExecutePipeline: Error", (Map<String, Object>)ImmutableMap.of((Object)"error.message", (Object)throwable.toString()));
                metricsContext.recordLatency(TelemetryConstants.MetricType.END_TO_END_LATENCY, throwable);
                resultObserver.onError(throwable);
            }

            public void onComplete() {
                if (this.hasCompleted) {
                    return;
                }
                this.hasCompleted = true;
                metricsContext.recordLatency(TelemetryConstants.MetricType.END_TO_END_LATENCY);
                currentSpan.addEvent("ExecutePipeline: Completed", (Map<String, Object>)ImmutableMap.of((Object)"doc_count", (Object)this.numDocuments));
                resultObserver.onCompleted(this.executionTime);
            }
        };
        logger.log(Level.FINEST, "Sending pipeline request: " + request.getStructuredPipeline());
        this.rpcContext.streamRequest(request, observer, this.rpcContext.getClient().executePipelineCallable());
    }

    @InternalExtensionOnly
    static abstract class PipelineResultObserver
    implements ResultObserver {
        private Timestamp executionTime;
        private ExplainStats explainStats;

        PipelineResultObserver() {
        }

        @Override
        public void onCompleted(Timestamp executionTime) {
            this.executionTime = executionTime;
            this.onCompleted();
        }

        public Timestamp getExecutionTime() {
            return this.executionTime;
        }

        public ExplainStats getExplainStats() {
            return this.explainStats;
        }

        @Override
        public void setExplainStats(ExplainStats explainStats) {
            this.explainStats = explainStats;
        }

        @Override
        public void setExecutionTime(Timestamp executionTime) {
            this.executionTime = executionTime;
        }
    }

    private static interface ResultObserver
    extends ApiStreamObserver<PipelineResult> {
        public void onCompleted(Timestamp var1);

        public void setExplainStats(ExplainStats var1);

        public void setExecutionTime(Timestamp var1);
    }

    @BetaApi
    public static final class Snapshot {
        private final Pipeline pipeline;
        private final Timestamp executionTime;
        private final List<PipelineResult> results;
        private final ExplainStats explainStats;

        Snapshot(@Nonnull Pipeline pipeline, @Nonnull List<PipelineResult> results, @Nonnull Timestamp executionTime, @Nullable ExplainStats explainStats) {
            this.pipeline = pipeline;
            this.results = results;
            this.executionTime = executionTime;
            this.explainStats = explainStats;
        }

        @Nonnull
        Pipeline getPipeline() {
            return this.pipeline;
        }

        @Nonnull
        public List<PipelineResult> getResults() {
            return this.results;
        }

        @Nonnull
        public Timestamp getExecutionTime() {
            return this.executionTime;
        }

        @Nullable
        public ExplainStats getExplainStats() {
            return this.explainStats;
        }
    }
}

