/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.cloud.firestore.AggregateQuery;
import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FirestoreRpcContext;
import com.google.cloud.firestore.Pipeline;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.pipeline.stages.Collection;
import com.google.cloud.firestore.pipeline.stages.CollectionGroup;
import com.google.cloud.firestore.pipeline.stages.CollectionGroupOptions;
import com.google.cloud.firestore.pipeline.stages.CollectionOptions;
import com.google.cloud.firestore.pipeline.stages.Database;
import com.google.cloud.firestore.pipeline.stages.Documents;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import javax.annotation.Nonnull;

@BetaApi
public final class PipelineSource {
    private final FirestoreRpcContext<?> rpcContext;

    @InternalApi
    PipelineSource(FirestoreRpcContext<?> rpcContext) {
        this.rpcContext = rpcContext;
    }

    @Nonnull
    @BetaApi
    public Pipeline collection(@Nonnull String path) {
        return this.collection(path, new CollectionOptions());
    }

    @Nonnull
    @BetaApi
    public Pipeline collection(@Nonnull String path, CollectionOptions options) {
        return new Pipeline(this.rpcContext, new Collection(path, options));
    }

    @Nonnull
    @BetaApi
    public Pipeline collection(@Nonnull CollectionReference ref) {
        if (!this.rpcContext.getFirestore().equals(ref.getFirestore())) {
            throw new IllegalArgumentException("Invalid CollectionReference. The Firestore instance of the CollectionReference must match the Firestore instance of the PipelineSource.");
        }
        return this.collection(ref.getPath(), new CollectionOptions());
    }

    @Nonnull
    @BetaApi
    public Pipeline collectionGroup(@Nonnull String collectionId) {
        return this.collectionGroup(collectionId, new CollectionGroupOptions());
    }

    @Nonnull
    @BetaApi
    public Pipeline collectionGroup(@Nonnull String collectionId, CollectionGroupOptions options) {
        Preconditions.checkArgument((!collectionId.contains("/") ? 1 : 0) != 0, (String)"Invalid collectionId '%s'. Collection IDs must not contain '/'.", (Object)collectionId);
        return new Pipeline(this.rpcContext, new CollectionGroup(collectionId, options));
    }

    @Nonnull
    @BetaApi
    public Pipeline database() {
        return new Pipeline(this.rpcContext, new Database());
    }

    @Nonnull
    @BetaApi
    public Pipeline documents(DocumentReference ... docs) {
        return new Pipeline(this.rpcContext, Documents.of(docs));
    }

    @Nonnull
    @BetaApi
    public Pipeline documents(String ... docs) {
        return new Pipeline(this.rpcContext, Documents.of((DocumentReference[])Arrays.stream(docs).map(d -> this.rpcContext.getFirestore().document((String)d)).toArray(DocumentReference[]::new)));
    }

    @Nonnull
    @BetaApi
    public Pipeline createFrom(Query query) {
        return query.pipeline();
    }

    @Nonnull
    @BetaApi
    public Pipeline createFrom(AggregateQuery query) {
        return query.pipeline();
    }
}

