/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.cloud.firestore.AggregateQuery;
import com.google.cloud.firestore.AggregateQuerySnapshot;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FieldMask;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.Pipeline;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.QuerySnapshot;
import com.google.cloud.firestore.UpdateBuilder;
import com.google.cloud.firestore.pipeline.stages.PipelineExecuteOptions;
import com.google.cloud.firestore.telemetry.MetricsUtil;
import com.google.cloud.firestore.telemetry.TraceUtil;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalExtensionOnly
public abstract class Transaction
extends UpdateBuilder<Transaction> {
    private static final Logger LOGGER = Logger.getLogger(Transaction.class.getName());
    private static final String READ_BEFORE_WRITE_ERROR_MSG = "Firestore transactions require all reads to be executed before all writes";
    @Nonnull
    protected TraceUtil.Context transactionTraceContext;

    protected Transaction(FirestoreImpl firestore) {
        super(firestore);
        this.transactionTraceContext = firestore.getOptions().getTraceUtil().currentContext();
    }

    @Nonnull
    TraceUtil getTraceUtil() {
        return this.firestore.getOptions().getTraceUtil();
    }

    @Nonnull
    MetricsUtil getMetricsUtil() {
        return this.firestore.getOptions().getMetricsUtil();
    }

    @Nonnull
    TraceUtil.Context setTransactionTraceContext(TraceUtil.Context context) {
        this.transactionTraceContext = context;
        return this.transactionTraceContext;
    }

    @Override
    protected String className() {
        return "Transaction";
    }

    public abstract boolean hasTransactionId();

    @Override
    Transaction wrapResult(int writeIndex) {
        return this;
    }

    @Nonnull
    public abstract ApiFuture<DocumentSnapshot> get(@Nonnull DocumentReference var1);

    @Nonnull
    public abstract ApiFuture<List<DocumentSnapshot>> getAll(DocumentReference ... var1);

    @Nonnull
    public abstract ApiFuture<List<DocumentSnapshot>> getAll(@Nonnull DocumentReference[] var1, @Nullable FieldMask var2);

    @Nonnull
    public abstract ApiFuture<QuerySnapshot> get(@Nonnull Query var1);

    @Nonnull
    public abstract ApiFuture<AggregateQuerySnapshot> get(@Nonnull AggregateQuery var1);

    @Nonnull
    @BetaApi
    public abstract ApiFuture<Pipeline.Snapshot> execute(@Nonnull Pipeline var1);

    @Nonnull
    @BetaApi
    public abstract ApiFuture<Pipeline.Snapshot> execute(@Nonnull Pipeline var1, @Nonnull PipelineExecuteOptions var2);

    public static interface AsyncFunction<T> {
        public ApiFuture<T> updateCallback(Transaction var1);
    }

    public static interface Function<T> {
        public T updateCallback(Transaction var1) throws Exception;
    }
}

