/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.pipeline.expressions;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.Pipeline;
import com.google.cloud.firestore.pipeline.expressions.Expression;
import com.google.cloud.firestore.pipeline.expressions.Selectable;
import com.google.common.base.Objects;
import com.google.firestore.v1.Value;
import javax.annotation.Nullable;

@BetaApi
public final class Field
extends Expression
implements Selectable {
    public static final String DOCUMENT_ID = "__name__";
    private final FieldPath path;
    @Nullable
    private Pipeline pipeline;

    private Field(FieldPath path) {
        this.path = path;
    }

    @InternalApi
    public static Field ofUserPath(String path) {
        if (path.equals(DOCUMENT_ID)) {
            return new Field(FieldPath.documentId());
        }
        return new Field(FieldPath.fromDotSeparatedString(path));
    }

    @InternalApi
    public static Field ofServerPath(String path) {
        if (path.equals(DOCUMENT_ID)) {
            return new Field(FieldPath.documentId());
        }
        return new Field(FieldPath.fromServerFormat(path));
    }

    @Override
    @InternalApi
    public Value toProto() {
        return Value.newBuilder().setFieldReferenceValue(this.path.toString()).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Field field = (Field)o;
        return Objects.equal((Object)this.path, (Object)field.path) && Objects.equal((Object)this.pipeline, (Object)field.pipeline);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.path, this.pipeline});
    }

    @InternalApi
    public FieldPath getPath() {
        return this.path;
    }
}

