/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.pipeline.expressions;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.cloud.firestore.PipelineUtils;
import com.google.cloud.firestore.pipeline.expressions.Expression;
import com.google.firestore.v1.MapValue;
import com.google.firestore.v1.Value;
import java.util.Locale;

@BetaApi
public final class Ordering {
    private final Expression expr;
    private final Direction dir;

    private Ordering(Expression expr, Direction dir) {
        this.expr = expr;
        this.dir = dir;
    }

    @InternalApi
    public Value toProto() {
        return Value.newBuilder().setMapValue(MapValue.newBuilder().putFields("direction", PipelineUtils.encodeValue(this.dir.toString())).putFields("expression", this.expr.toProto()).build()).build();
    }

    @BetaApi
    public static Ordering ascending(Expression expr) {
        return new Ordering(expr, Direction.ASCENDING);
    }

    @BetaApi
    public static Ordering descending(Expression expr) {
        return new Ordering(expr, Direction.DESCENDING);
    }

    @InternalApi
    public Expression getExpr() {
        return this.expr;
    }

    @InternalApi
    public Direction getDir() {
        return this.dir;
    }

    @BetaApi
    public static enum Direction {
        ASCENDING,
        DESCENDING;


        public String toString() {
            return this.name().toLowerCase(Locale.getDefault());
        }
    }
}

