/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.pipeline.stages;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.cloud.firestore.PipelineUtils;
import com.google.cloud.firestore.pipeline.expressions.AggregateFunction;
import com.google.cloud.firestore.pipeline.expressions.AliasedAggregate;
import com.google.cloud.firestore.pipeline.expressions.Expression;
import com.google.cloud.firestore.pipeline.expressions.Selectable;
import com.google.cloud.firestore.pipeline.stages.AggregateOptions;
import com.google.cloud.firestore.pipeline.stages.Stage;
import com.google.firestore.v1.Value;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

@BetaApi
public final class Aggregate
extends Stage {
    private final Map<String, Expression> groups;
    private final Map<String, AggregateFunction> accumulators;

    @BetaApi
    public Aggregate withGroups(String ... fields) {
        return new Aggregate(PipelineUtils.fieldNamesToMap(fields), this.accumulators, new AggregateOptions());
    }

    @BetaApi
    public Aggregate withGroups(Selectable ... selectables) {
        return new Aggregate(PipelineUtils.selectablesToMap(selectables), this.accumulators, new AggregateOptions());
    }

    @BetaApi
    public static Aggregate withAccumulators(AliasedAggregate ... accumulators) {
        HashMap<String, AggregateFunction> accumulatorMap = new HashMap<String, AggregateFunction>();
        for (AliasedAggregate accumulator : accumulators) {
            if (accumulatorMap.containsKey(accumulator.getAlias())) {
                throw new IllegalArgumentException("Duplicate alias or field name: " + accumulator.getAlias());
            }
            accumulatorMap.put(accumulator.getAlias(), accumulator.getExpr());
        }
        return new Aggregate(Collections.emptyMap(), accumulatorMap, new AggregateOptions());
    }

    @InternalApi
    public Aggregate withOptions(@Nonnull AggregateOptions options) {
        return new Aggregate(this.groups, this.accumulators, options);
    }

    private Aggregate(Map<String, Expression> groups, Map<String, AggregateFunction> accumulators, AggregateOptions options) {
        super("aggregate", options.options);
        if (accumulators.isEmpty()) {
            throw new IllegalArgumentException("Must specify at least one accumulator for aggregate() stage. There is a distinct() stage if only distinct group values are needed.");
        }
        this.groups = groups;
        this.accumulators = accumulators;
    }

    @Override
    Iterable<Value> toStageArgs() {
        return Arrays.asList(PipelineUtils.encodeValue(this.accumulators), PipelineUtils.encodeValue(this.groups));
    }
}

