/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.client.shadow;

import com.amazonaws.services.iot.client.AWSIotDeviceErrorCode;
import com.amazonaws.services.iot.client.AWSIotMessage;
import com.amazonaws.services.iot.client.AWSIotQos;
import com.amazonaws.services.iot.client.shadow.AbstractAwsIotDevice;
import com.amazonaws.services.iot.client.shadow.AwsIotJsonDeserializer;
import java.io.IOException;
import java.util.logging.Logger;

public class AwsIotDeviceSyncMessage
extends AWSIotMessage {
    private static final Logger LOGGER = Logger.getLogger(AwsIotDeviceSyncMessage.class.getName());
    private final AbstractAwsIotDevice device;

    public AwsIotDeviceSyncMessage(String topic, AWSIotQos qos, AbstractAwsIotDevice device) {
        super(topic, qos);
        this.device = device;
    }

    @Override
    public void onSuccess() {
        if (this.payload != null) {
            try {
                long version = AwsIotJsonDeserializer.deserializeVersion(this.device, this.getStringPayload());
                if (version > 0L) {
                    LOGGER.info("Received shadow version number: " + version);
                    boolean updated = this.device.getLocalVersion().compareAndSet(-1L, version);
                    if (!updated) {
                        LOGGER.warning("Local version not updated likely because newer version recieved from shadow update");
                    }
                }
            }
            catch (IOException e) {
                LOGGER.warning("Device update error: " + e.getMessage());
            }
        }
    }

    @Override
    public void onFailure() {
        if (AWSIotDeviceErrorCode.NOT_FOUND.equals((Object)this.errorCode)) {
            LOGGER.info("No shadow document found, reset local version to 0");
            this.device.getLocalVersion().set(0L);
        } else {
            LOGGER.warning("Failed to get shadow version: " + this.errorMessage);
        }
    }
}

