/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.systemlog.threat;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ubnt.model.api.systemlog.threat.ImmutableThreatLogFormattedDto;
import com.ubnt.service.ips.C;
import com.ubnt.service.ips.X;
import com.ubnt.service.systemlog.threat.ThreatLogDocument;
import org.apache.commons.lang3.StringUtils;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonSerialize(as=ImmutableThreatLogFormattedDto.class)
@JsonDeserialize(builder=ImmutableThreatLogFormattedDto.Builder.class)
@Value.Immutable
@com.ubnt.return.C
public interface ThreatLogFormattedDto {
    @JsonProperty(value="id")
    @Value.Lazy
    default public String id() {
        return StringUtils.defaultString((String)this.alarmId(), (String)this.ipsAlertId());
    }

    @JsonProperty(value="alarm_id")
    public String alarmId();

    @JsonProperty(value="ips_alert_id")
    public String ipsAlertId();

    @JsonProperty(value="threat_direction")
    public X threatDirection();

    @JsonProperty(value="device")
    public String device();

    @JsonProperty(value="device_mac")
    public String deviceMac();

    @JsonProperty(value="counterpart")
    public String counterpart();

    @JsonProperty(value="counterpart_mac")
    public String counterpartMac();

    @JsonProperty(value="counterpart_location")
    public String counterpartLocation();

    @JsonProperty(value="threat_type")
    public C threatType();

    @JsonProperty(value="timestamp")
    public Long timestamp();

    public static ThreatLogFormattedDto mapThreatLogDocument(ThreatLogDocument threatLogDocument) {
        return ThreatLogFormattedDto.builder().alarmId(threatLogDocument.getAlarmId()).ipsAlertId(threatLogDocument.getIpsAlertId()).threatType(threatLogDocument.getThreatType()).threatDirection(threatLogDocument.getThreatDirection()).device(threatLogDocument.getDevice()).deviceMac(threatLogDocument.getDeviceMac()).counterpart(threatLogDocument.getCounterpart()).counterpartMac(threatLogDocument.getCounterpartMac()).counterpartLocation(threatLogDocument.getCounterpartLocation()).timestamp(threatLogDocument.getTimestamp()).build();
    }

    public static ImmutableThreatLogFormattedDto.Builder builder() {
        return ImmutableThreatLogFormattedDto.builder();
    }
}

