/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.stat;

import io.jenetics.stat.LongMoments;
import io.jenetics.stat.MomentStatistics;
import java.util.Objects;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;

public class LongMomentStatistics
extends MomentStatistics
implements LongConsumer,
IntConsumer {
    private long _min = Long.MAX_VALUE;
    private long _max = Long.MIN_VALUE;
    private long _sum = 0L;

    @Override
    public void accept(long value) {
        super.accept(value);
        this._min = Math.min(this._min, value);
        this._max = Math.max(this._max, value);
        this._sum += value;
    }

    @Override
    public void accept(int value) {
        this.accept((long)value);
    }

    public LongMomentStatistics combine(LongMomentStatistics other) {
        super.combine(other);
        this._min = Math.min(this._min, other._min);
        this._max = Math.max(this._max, other._max);
        this._sum += other._sum;
        return this;
    }

    public long getMin() {
        return this._min;
    }

    public long getMax() {
        return this._max;
    }

    public long getSum() {
        return this._sum;
    }

    public boolean sameState(LongMomentStatistics other) {
        return this == other || this._min == other._min && this._max == other._max && this._sum == other._sum && super.sameState(other);
    }

    public LongMoments toLongMoments() {
        return LongMoments.of(this);
    }

    public String toString() {
        return String.format("LongMomentStatistics[N=%d, \u2227=%s, \u2228=%s, \u03a3=%s, \u03bc=%s, s\u00b2=%s, S=%s, K=%s]", this.getCount(), this.getMin(), this.getMax(), this.getSum(), this.getMean(), this.getVariance(), this.getSkewness(), this.getKurtosis());
    }

    public static <T> Collector<T, ?, LongMomentStatistics> toLongMomentStatistics(ToLongFunction<? super T> mapper) {
        Objects.requireNonNull(mapper);
        return Collector.of(LongMomentStatistics::new, (r, t) -> r.accept(mapper.applyAsLong(t)), LongMomentStatistics::combine, new Collector.Characteristics[0]);
    }
}

