/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.checkers;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.checkers.CustomAnnotationChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/checkers/NamedParamAnnotationChecker;", "Lorg/jetbrains/plugins/groovy/annotator/checkers/CustomAnnotationChecker;", "<init>", "()V", "checkArgumentList", "", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "annotation", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/annotation/GrAnnotation;", "intellij.groovy.psi"})
public final class NamedParamAnnotationChecker
extends CustomAnnotationChecker {
    @Override
    public boolean checkArgumentList(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        Pair<PsiElement, String> r;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        if (!Intrinsics.areEqual((Object)"groovy.transform.NamedParam", (Object)annotation.getQualifiedName())) {
            return false;
        }
        PsiClass psiClass = ResolveUtil.resolveAnnotation(annotation);
        if (psiClass == null) {
            return false;
        }
        PsiClass annotationClass = psiClass;
        Pair<PsiElement, String> pair = r = CustomAnnotationChecker.checkAnnotationArguments(annotationClass, annotation.getParameterList().getAttributes(), false);
        if ((pair != null ? (PsiElement)pair.getFirst() : null) != null) {
            String message = (String)r.second;
            holder.newAnnotation(HighlightSeverity.ERROR, message).range((PsiElement)r.first).create();
        }
        return true;
    }
}

