/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.diff.tools.external.ExternalDiffTool;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.EditorTabDiffPreviewKt;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeDiffPreviewHandler;
import com.intellij.openapi.vcs.changes.ui.TreeHandlerEditorDiffPreview;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.toolWindow.InternalDecoratorImpl;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.ui.frame.VcsLogChangesBrowser;
import com.intellij.vcs.log.ui.frame.VcsLogDiffPreviewHandler;
import java.awt.Component;
import java.lang.ref.WeakReference;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0014J\n\u0010\r\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010\u000e\u001a\u00020\f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\tH\u0016J\b\u0010\u0016\u001a\u00020\tH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogEditorDiffPreview;", "Lcom/intellij/openapi/vcs/changes/ui/TreeHandlerEditorDiffPreview;", "changesBrowser", "Lcom/intellij/vcs/log/ui/frame/VcsLogChangesBrowser;", "<init>", "(Lcom/intellij/vcs/log/ui/frame/VcsLogChangesBrowser;)V", "oldToolWindowFocus", "Lcom/intellij/vcs/log/ui/frame/VcsLogEditorDiffPreview$ToolWindowFocus;", "openPreview", "", "requestFocus", "returnFocusToTree", "", "getCurrentToolWindowFocus", "restoreToolWindowFocus", "createViewer", "Lcom/intellij/diff/impl/DiffEditorViewer;", "getEditorTabName", "", "wrapper", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$Wrapper;", "performDiffAction", "isOpenPreviewWithNextDiffShortcut", "ToolWindowFocus", "intellij.platform.vcs.log.impl"})
public final class VcsLogEditorDiffPreview
extends TreeHandlerEditorDiffPreview {
    @NotNull
    private final VcsLogChangesBrowser changesBrowser;
    @Nullable
    private ToolWindowFocus oldToolWindowFocus;

    public VcsLogEditorDiffPreview(@NotNull VcsLogChangesBrowser changesBrowser) {
        Intrinsics.checkNotNullParameter((Object)((Object)changesBrowser), (String)"changesBrowser");
        super((ChangesTree)changesBrowser.getViewer(), (ChangesTreeDiffPreviewHandler)new VcsLogDiffPreviewHandler(changesBrowser));
        this.changesBrowser = changesBrowser;
        Disposer.register((Disposable)this.changesBrowser, (Disposable)((Disposable)this));
    }

    public boolean openPreview(boolean requestFocus) {
        this.oldToolWindowFocus = this.getCurrentToolWindowFocus();
        return super.openPreview(requestFocus);
    }

    protected void returnFocusToTree() {
        this.restoreToolWindowFocus(this.oldToolWindowFocus);
    }

    private final ToolWindowFocus getCurrentToolWindowFocus() {
        Component component = IdeFocusManager.getInstance((Project)this.getProject()).getFocusOwner();
        if (component == null) {
            return null;
        }
        Component focusOwner = component;
        Object object = InternalDecoratorImpl.Companion.findTopLevelDecorator(focusOwner);
        if (object == null || (object = object.getToolWindowId()) == null) {
            return null;
        }
        Object toolWindowId = object;
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.getProject()).getToolWindow((String)toolWindowId);
        if (toolWindow == null) {
            return null;
        }
        ToolWindow toolWindow2 = toolWindow;
        ContentManager contentManager = toolWindow2.getContentManagerIfCreated();
        if (contentManager == null || (contentManager = contentManager.getSelectedContent()) == null) {
            return null;
        }
        ContentManager selectedContent = contentManager;
        return new ToolWindowFocus(focusOwner, (String)toolWindowId, (Content)selectedContent);
    }

    private final void restoreToolWindowFocus(ToolWindowFocus oldToolWindowFocus) {
        if (oldToolWindowFocus == null) {
            return;
        }
        Component component = (Component)oldToolWindowFocus.getComponent().get();
        if (component == null) {
            return;
        }
        Component component2 = component;
        Content content = (Content)oldToolWindowFocus.getContent().get();
        if (content == null) {
            return;
        }
        Content content2 = content;
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.getProject()).getToolWindow(oldToolWindowFocus.getToolWindowId());
        if (toolWindow == null) {
            return;
        }
        ToolWindow toolWindow2 = toolWindow;
        ContentManager contentManager = toolWindow2.getContentManagerIfCreated();
        if (contentManager == null) {
            return;
        }
        ContentManager contentManager2 = contentManager;
        if (contentManager2.getIndexOfContent(content2) < 0) {
            return;
        }
        contentManager2.setSelectedContent(content2);
        toolWindow2.activate(() -> VcsLogEditorDiffPreview.restoreToolWindowFocus$lambda$0(this, component2), false);
    }

    @NotNull
    protected DiffEditorViewer createViewer() {
        return this.changesBrowser.createChangeProcessor(true);
    }

    @NotNull
    public String getEditorTabName(@Nullable ChangeViewDiffRequestProcessor.Wrapper wrapper) {
        String string;
        FilePath filePath;
        ChangeViewDiffRequestProcessor.Wrapper wrapper2 = wrapper;
        Object object = filePath = wrapper2 != null ? wrapper2.getFilePath() : null;
        if (filePath == null) {
            String string2 = VcsLogBundle.message("vcs.log.diff.preview.editor.empty.tab.name", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            Object[] objectArray = new Object[]{filePath.getName()};
            String string3 = VcsLogBundle.message("vcs.log.diff.preview.editor.tab.name", objectArray);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        return string;
    }

    public boolean performDiffAction() {
        if (ExternalDiffTool.isEnabled()) {
            ListSelection listSelection = VcsTreeModelData.getListSelectionOrAll((JTree)((JTree)this.changesBrowser.getViewer())).map(arg_0 -> VcsLogEditorDiffPreview.performDiffAction$lambda$0(this, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)listSelection, (String)"map(...)");
            ListSelection diffProducers = listSelection;
            if (EditorTabDiffPreviewKt.showExternalToolIfNeeded((Project)this.getProject(), (ListSelection)diffProducers)) {
                return true;
            }
        }
        return super.performDiffAction();
    }

    protected boolean isOpenPreviewWithNextDiffShortcut() {
        return false;
    }

    private static final void restoreToolWindowFocus$lambda$0(VcsLogEditorDiffPreview this$0, Component $component) {
        IdeFocusManager.getInstance((Project)this$0.getProject()).requestFocus($component, true);
    }

    private static final ChangeDiffRequestChain.Producer performDiffAction$lambda$0(VcsLogEditorDiffPreview this$0, Object change) {
        VcsLogChangesBrowser vcsLogChangesBrowser = this$0.changesBrowser;
        Intrinsics.checkNotNull((Object)change);
        return vcsLogChangesBrowser.getDiffRequestProducer(change, false);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogEditorDiffPreview$ToolWindowFocus;", "", "component", "Ljava/awt/Component;", "toolWindowId", "", "content", "Lcom/intellij/ui/content/Content;", "<init>", "(Ljava/awt/Component;Ljava/lang/String;Lcom/intellij/ui/content/Content;)V", "getToolWindowId", "()Ljava/lang/String;", "Ljava/lang/ref/WeakReference;", "getComponent", "()Ljava/lang/ref/WeakReference;", "getContent", "intellij.platform.vcs.log.impl"})
    private static final class ToolWindowFocus {
        @NotNull
        private final String toolWindowId;
        @NotNull
        private final WeakReference<Component> component;
        @NotNull
        private final WeakReference<Content> content;

        public ToolWindowFocus(@NotNull Component component, @NotNull String toolWindowId, @NotNull Content content) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter((Object)toolWindowId, (String)"toolWindowId");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this.toolWindowId = toolWindowId;
            this.component = new WeakReference<Component>(component);
            this.content = new WeakReference<Content>(content);
        }

        @NotNull
        public final String getToolWindowId() {
            return this.toolWindowId;
        }

        @NotNull
        public final WeakReference<Component> getComponent() {
            return this.component;
        }

        @NotNull
        public final WeakReference<Content> getContent() {
            return this.content;
        }
    }
}

