/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.objects;

import java.lang.reflect.Constructor;
import org.testng.ITestObjectFactory;
import org.testng.TestNGException;
import org.testng.internal.objects.InstanceCreator;

public class ObjectFactoryImpl
implements ITestObjectFactory {
    @Override
    public <T> T newInstance(Constructor<T> constructor, Object ... params) {
        if (constructor == null) {
            throw new IllegalArgumentException("Constructor cannot be null.");
        }
        try {
            constructor.setAccessible(true);
            return InstanceCreator.newInstance(constructor, params);
        }
        catch (TestNGException ex) {
            return ObjectFactoryImpl.tryOtherConstructor(constructor.getDeclaringClass());
        }
        catch (SecurityException e) {
            throw new TestNGException(constructor.getName() + " must be public", e);
        }
        catch (Exception ex) {
            throw new TestNGException("Cannot instantiate class " + constructor.getDeclaringClass().getName(), ex);
        }
    }

    private static <T> T tryOtherConstructor(Class<T> declaringClass) {
        T result;
        try {
            if (declaringClass.getModifiers() == 0) {
                return null;
            }
            Constructor<T> ctor = declaringClass.getConstructor(String.class);
            result = InstanceCreator.newInstance(ctor, "Default test name");
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null && e.getCause() != null) {
                message = e.getCause().getMessage();
            }
            String error = "Could not create an instance of class " + declaringClass + (String)(message != null ? ": " + message : "") + ".\nPlease make sure it has a constructor that accepts either a String or no parameter.";
            throw new TestNGException(error);
        }
        return result;
    }
}

