/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.configuration;

import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002B\u001d\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\n\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0002R\u0012\u0010\u0007\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/fus/reporting/configuration/CachingSupplier;", "T", "Ljava/util/function/Supplier;", "valueSupplier", "timeoutMs", "", "(Ljava/util/function/Supplier;J)V", "cache", "Ljava/lang/Object;", "lastCalcTime", "get", "()Ljava/lang/Object;", "hasUpToDateValue", "", "configuration"})
public final class CachingSupplier<T>
implements Supplier<T> {
    @NotNull
    private final Supplier<? extends T> valueSupplier;
    private final long timeoutMs;
    private long lastCalcTime;
    @Nullable
    private T cache;

    public CachingSupplier(@NotNull Supplier<? extends T> valueSupplier, long timeoutMs) {
        Intrinsics.checkNotNullParameter(valueSupplier, (String)"valueSupplier");
        this.valueSupplier = valueSupplier;
        this.timeoutMs = timeoutMs;
    }

    @Override
    @Nullable
    public synchronized T get() {
        if (this.hasUpToDateValue()) {
            return this.cache;
        }
        this.cache = this.valueSupplier.get();
        this.lastCalcTime = System.currentTimeMillis();
        return this.cache;
    }

    private final boolean hasUpToDateValue() {
        return this.timeoutMs > System.currentTimeMillis() - this.lastCalcTime;
    }
}

