//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Numeric/SafeSpinBox.h
//! @brief     Defines class SafeSpinBox.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_NUMERIC_SAFESPINBOX_H
#define BORNAGAIN_GUI_VIEW_NUMERIC_SAFESPINBOX_H

#include <QSpinBox>

//! SpinBox that enables scrolling only on focus

class SafeSpinBox : public QSpinBox {
    Q_OBJECT
public:
    explicit SafeSpinBox(bool easyScrollable = false, QWidget* parent = nullptr);

protected:
    void wheelEvent(QWheelEvent* event) override;

private:
    bool m_easy_scrollable;
};

#endif // BORNAGAIN_GUI_VIEW_NUMERIC_SAFESPINBOX_H
