//
// Copyright(C) 1993-1996 Id Software, Inc.
// Copyright(C) 1993-2008 Raven Software
// Copyright(C) 2005-2014 Simon Howard
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//

#include "p_mobj.h"
#include "sounds.h"
#include "info.h"

// generated by stateco

const char *hexen_sprnames[] = {
    "MAN1","ACLO","TLGL","FBL1","XPL1","ARRW","DART","RIPP","CFCF","BLAD",
    "SHRD","FFSM","FFLG","PTN1","PTN2","SOAR","INVU","SUMN","TSPK","TELO",
    "TRNG","ROCK","FOGS","FOGM","FOGL","SGSA","SGSB","PORK","EGGM","FHFX",
    "SPHL","STWN","GMPD","ASKU","ABGM","AGMR","AGMG","AGG2","AGMB","AGB2",
    "ABK1","ABK2","ASK2","AFWP","ACWP","AMWP","AGER","AGR2","AGR3","AGR4",
    "TRCH","PSBG","ATLP","THRW","SPED","BMAN","BRAC","BLST","HRAD","SPSH",
    "LVAS","SLDG","STTW","RCK1","RCK2","RCK3","RCK4","CDLR","TRE1","TRDT",
    "TRE2","TRE3","STM1","STM2","STM3","STM4","MSH1","MSH2","MSH3","MSH4",
    "MSH5","MSH6","MSH7","MSH8","SGMP","SGM1","SGM2","SGM3","SLC1","SLC2",
    "SLC3","MSS1","MSS2","SWMV","CPS1","CPS2","TMS1","TMS2","TMS3","TMS4",
    "TMS5","TMS6","TMS7","CPS3","STT2","STT3","STT4","STT5","GAR1","GAR2",
    "GAR3","GAR4","GAR5","GAR6","GAR7","GAR8","GAR9","BNR1","TRE4","TRE5",
    "TRE6","TRE7","LOGG","ICT1","ICT2","ICT3","ICT4","ICM1","ICM2","ICM3",
    "ICM4","RKBL","RKBS","RKBK","RBL1","RBL2","RBL3","VASE","POT1","POT2",
    "POT3","PBIT","CPS4","CPS5","CPS6","CPB1","CPB2","CPB3","CPB4","BDRP",
    "BDSH","BDPL","CNDL","LEF1","LEF3","LEF2","TWTR","WLTR","BARL","SHB1",
    "SHB2","BCKT","SHRM","FBUL","FSKL","BRTR","SUIT","BBLL","CAND","IRON",
    "XMAS","CDRN","CHNS","TST1","TST2","TST3","TST4","TST5","TST6","TST7",
    "TST8","TST9","TST0","TELE","TSMK","FPCH","WFAX","FAXE","WFHM","FHMR",
    "FSRD","FSFX","CMCE","WCSS","CSSF","WCFM","CFLM","CFFX","CHLY","SPIR",
    "MWND","WMLG","MLNG","MLFX","MLF2","MSTF","MSP1","MSP2","WFR1","WFR2",
    "WFR3","WCH1","WCH2","WCH3","WMS1","WMS2","WMS3","WPIG","WMCS","CONE",
    "SHEX","BLOD","GIBS","PLAY","FDTH","BSKL","ICEC","CLER","MAGE","PIGY",
    "CENT","CTXD","CTFX","CTDP","DEMN","DEMA","DEMB","DEMC","DEMD","DEME",
    "DMFX","DEM2","DMBA","DMBB","DMBC","DMBD","DMBE","D2FX","WRTH","WRT2",
    "WRBL","MNTR","FX12","FX13","MNSM","SSPT","SSDV","SSXD","SSFX","BISH",
    "BPFX","DRAG","DRFX","ARM1","ARM2","ARM3","ARM4","MAN2","MAN3","KEY1",
    "KEY2","KEY3","KEY4","KEY5","KEY6","KEY7","KEY8","KEY9","KEYA","KEYB",
    "ETTN","ETTB","FDMN","FDMB","ICEY","ICPR","ICWS","SORC","SBMP","SBS4",
    "SBMB","SBS3","SBMG","SBS1","SBS2","SBFX","RADE","WATR","KORX","ABAT",
    NULL
};

void A_FreeTargMobj();
void A_FlameCheck();
void A_HideThing();
void A_UnHideThing();
void A_RestoreSpecialThing1();
void A_RestoreSpecialThing2();
void A_RestoreArtifact();
void A_Summon();
void A_ThrustInitUp();
void A_ThrustInitDn();
void A_ThrustRaise();
void A_ThrustBlock();
void A_ThrustImpale();
void A_ThrustLower();
void A_TeloSpawnC();
void A_TeloSpawnB();
void A_TeloSpawnA();
void A_TeloSpawnD();
void A_CheckTeleRing();
void A_FogSpawn();
void A_FogMove();
void A_Quake();
void A_ContMobjSound();
void A_Scream();
void A_Explode();
void A_PoisonBagInit();
void A_PoisonBagDamage();
void A_PoisonBagCheck();
void A_CheckThrowBomb();
void A_NoGravity();
void A_PotteryExplode();
void A_PotteryChooseBit();
void A_PotteryCheck();
void A_CorpseBloodDrip();
void A_CorpseExplode();
void A_LeafSpawn();
void A_LeafThrust();
void A_LeafCheck();
void A_BridgeInit();
void A_BridgeOrbit();
void A_TreeDeath();
void A_PoisonShroom();
void A_Pain();
void A_SoAExplode();
void A_BellReset1();
void A_BellReset2();
void A_NoBlocking();
void A_Light0();
void A_WeaponReady();
void A_Lower();
void A_Raise();
void A_FPunchAttack();
void A_ReFire();
void A_FAxeAttack();
void A_FHammerAttack();
void A_FHammerThrow();
void A_FSwordAttack();
void A_FSwordFlames();
void A_CMaceAttack();
void A_CStaffInitBlink();
void A_CStaffCheckBlink();
void A_CStaffCheck();
void A_CStaffAttack();
void A_CStaffMissileSlither();
void A_CFlameAttack();
void A_CFlameRotate();
void A_CFlamePuff();
void A_CFlameMissile();
void A_CHolyAttack();
void A_CHolyPalette();
void A_CHolySeek();
void A_CHolyCheckScream();
void A_CHolyTail();
void A_CHolySpawnPuff();
void A_CHolyAttack2();
void A_MWandAttack();
void A_LightningReady();
void A_MLightningAttack();
void A_LightningZap();
void A_LightningClip();
void A_LightningRemove();
void A_LastZap();
void A_ZapMimic();
void A_MStaffAttack();
void A_MStaffPalette();
void A_MStaffWeave();
void A_MStaffTrack();
void A_SnoutAttack();
void A_FireConePL1();
void A_ShedShard();
void A_AddPlayerCorpse();
void A_SkullPop();
void A_FreezeDeath();
void A_FreezeDeathChunks();
void A_CheckBurnGone();
void A_CheckSkullFloor();
void A_CheckSkullDone();
void A_SpeedFade();
void A_IceSetTics();
void A_IceCheckHeadDone();
void A_PigPain();
void A_PigLook();
void A_PigChase();
void A_FaceTarget();
void A_PigAttack();
void A_QueueCorpse();
void A_Look();
void A_Chase();
void A_CentaurAttack();
void A_CentaurAttack2();
void A_SetReflective();
void A_CentaurDefend();
void A_UnSetReflective();
void A_CentaurDropStuff();
void A_CheckFloor();
void A_DemonAttack1();
void A_DemonAttack2();
void A_DemonDeath();
void A_Demon2Death();
void A_WraithRaiseInit();
void A_WraithRaise();
void A_WraithInit();
void A_WraithLook();
void A_WraithChase();
void A_WraithFX3();
void A_WraithMelee();
void A_WraithMissile();
void A_WraithFX2();
void A_MinotaurFade1();
void A_MinotaurFade2();
void A_MinotaurLook();
void A_MinotaurChase();
void A_MinotaurRoam();
void A_MinotaurAtk1();
void A_MinotaurDecide();
void A_MinotaurAtk2();
void A_MinotaurAtk3();
void A_MinotaurCharge();
void A_SmokePuffExit();
void A_MinotaurFade0();
void A_MntrFloorFire();
void A_SerpentChase();
void A_SerpentHumpDecide();
void A_SerpentUnHide();
void A_SerpentRaiseHump();
void A_SerpentLowerHump();
void A_SerpentHide();
void A_SerpentBirthScream();
void A_SetShootable();
void A_SerpentCheckForAttack();
void A_UnSetShootable();
void A_SerpentDiveSound();
void A_SerpentWalk();
void A_SerpentChooseAttack();
void A_SerpentMeleeAttack();
void A_SerpentMissileAttack();
void A_SerpentHeadPop();
void A_SerpentSpawnGibs();
void A_SerpentHeadCheck();
void A_FloatGib();
void A_DelayGib();
void A_SinkGib();
void A_BishopDecide();
void A_BishopDoBlur();
void A_BishopSpawnBlur();
void A_BishopChase();
void A_BishopAttack();
void A_BishopAttack2();
void A_BishopPainBlur();
void A_BishopPuff();
void A_SetAltShadow();
void A_BishopMissileWeave();
void A_BishopMissileSeek();
void A_DragonInitFlight();
void A_DragonFlap();
void A_DragonFlight();
void A_DragonAttack();
void A_DragonPain();
void A_DragonCheckCrash();
void A_DragonFX2();
void A_ESound();
void A_EttinAttack();
void A_DropMace();
void A_FiredRocks();
void A_UnSetInvulnerable();
void A_FiredChase();
void A_FiredAttack();
void A_FiredSplotch();
void A_SmBounce();
void A_IceGuyLook();
void A_IceGuyChase();
void A_IceGuyAttack();
void A_IceGuyDie();
void A_IceGuyMissilePuff();
void A_IceGuyMissileExplode();
void A_ClassBossHealth();
void A_FastChase();
void A_FighterAttack();
void A_ClericAttack();
void A_MageAttack();
void A_SorcSpinBalls();
void A_SpeedBalls();
void A_SpawnFizzle();
void A_SorcBossAttack();
void A_SorcBallOrbit();
void A_SorcBallPop();
void A_BounceCheck();
void A_SorcFX1Seek();
void A_SorcFX2Split();
void A_SorcFX2Orbit();
void A_SorcererBishopEntry();
void A_SpawnBishop();
void A_SorcFX4Check();
void A_KoraxStep2();
void A_KoraxChase();
void A_KoraxStep();
void A_KoraxDecide();
void A_KoraxMissile();
void A_KoraxCommand();
void A_KoraxBonePop();
void A_KSpiritRoam();
void A_KBoltRaise();
void A_KBolt();
void A_BatSpawnInit();
void A_BatSpawn();
void A_BatMove();

state_t hexen_states[HEXEN_NUMSTATES] = {
    {HEXEN_SPR_MAN1, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_NULL
    {HEXEN_SPR_ACLO, 4, 1050, A_FreeTargMobj, HEXEN_S_NULL, 0, 0},  // HEXEN_S_FREETARGMOBJ
    {HEXEN_SPR_TLGL, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_MAPSPOT
    {HEXEN_SPR_FBL1, 32768, 4, NULL, HEXEN_S_FIREBALL1_2, 0, 0},    // HEXEN_S_FIREBALL1_1
    {HEXEN_SPR_FBL1, 32769, 4, NULL, HEXEN_S_FIREBALL1_1, 0, 0},    // HEXEN_S_FIREBALL1_2
    {HEXEN_SPR_XPL1, 32768, 4, NULL, HEXEN_S_FIREBALL1_X2, 0, 0},   // HEXEN_S_FIREBALL1_X1
    {HEXEN_SPR_XPL1, 32769, 4, NULL, HEXEN_S_FIREBALL1_X3, 0, 0},   // HEXEN_S_FIREBALL1_X2
    {HEXEN_SPR_XPL1, 32770, 4, NULL, HEXEN_S_FIREBALL1_X4, 0, 0},   // HEXEN_S_FIREBALL1_X3
    {HEXEN_SPR_XPL1, 32771, 4, NULL, HEXEN_S_FIREBALL1_X5, 0, 0},   // HEXEN_S_FIREBALL1_X4
    {HEXEN_SPR_XPL1, 32772, 4, NULL, HEXEN_S_FIREBALL1_X6, 0, 0},   // HEXEN_S_FIREBALL1_X5
    {HEXEN_SPR_XPL1, 32773, 4, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_FIREBALL1_X6
    {HEXEN_SPR_ARRW, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ARROW_1
    {HEXEN_SPR_ARRW, 0, 1, NULL, HEXEN_S_NULL, 0, 0},       // HEXEN_S_ARROW_X1
    {HEXEN_SPR_DART, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_DART_1
    {HEXEN_SPR_DART, 0, 1, NULL, HEXEN_S_NULL, 0, 0},       // HEXEN_S_DART_X1
    {HEXEN_SPR_DART, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_POISONDART_1
    {HEXEN_SPR_DART, 0, 1, NULL, HEXEN_S_NULL, 0, 0},       // HEXEN_S_POISONDART_X1
    {HEXEN_SPR_RIPP, 0, 3, NULL, HEXEN_S_RIPPERBALL_2, 0, 0},       // HEXEN_S_RIPPERBALL_1
    {HEXEN_SPR_RIPP, 1, 3, NULL, HEXEN_S_RIPPERBALL_3, 0, 0},       // HEXEN_S_RIPPERBALL_2
    {HEXEN_SPR_RIPP, 2, 3, NULL, HEXEN_S_RIPPERBALL_1, 0, 0},       // HEXEN_S_RIPPERBALL_3
    {HEXEN_SPR_CFCF, 32784, 4, NULL, HEXEN_S_RIPPERBALL_X2, 0, 0},  // HEXEN_S_RIPPERBALL_X1
    {HEXEN_SPR_CFCF, 32785, 3, NULL, HEXEN_S_RIPPERBALL_X3, 0, 0},  // HEXEN_S_RIPPERBALL_X2
    {HEXEN_SPR_CFCF, 32786, 4, NULL, HEXEN_S_RIPPERBALL_X4, 0, 0},  // HEXEN_S_RIPPERBALL_X3
    {HEXEN_SPR_CFCF, 32787, 3, NULL, HEXEN_S_RIPPERBALL_X5, 0, 0},  // HEXEN_S_RIPPERBALL_X4
    {HEXEN_SPR_CFCF, 32788, 4, NULL, HEXEN_S_RIPPERBALL_X6, 0, 0},  // HEXEN_S_RIPPERBALL_X5
    {HEXEN_SPR_CFCF, 32789, 3, NULL, HEXEN_S_RIPPERBALL_X7, 0, 0},  // HEXEN_S_RIPPERBALL_X6
    {HEXEN_SPR_CFCF, 32790, 4, NULL, HEXEN_S_RIPPERBALL_X8, 0, 0},  // HEXEN_S_RIPPERBALL_X7
    {HEXEN_SPR_CFCF, 32791, 3, NULL, HEXEN_S_RIPPERBALL_X9, 0, 0},  // HEXEN_S_RIPPERBALL_X8
    {HEXEN_SPR_CFCF, 32792, 4, NULL, HEXEN_S_RIPPERBALL_X10, 0, 0}, // HEXEN_S_RIPPERBALL_X9
    {HEXEN_SPR_CFCF, 32793, 3, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_RIPPERBALL_X10
    {HEXEN_SPR_BLAD, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_PRJ_BLADE1
    {HEXEN_SPR_BLAD, 0, 1, NULL, HEXEN_S_NULL, 0, 0},       // HEXEN_S_PRJ_BLADE_X1
    {HEXEN_SPR_SHRD, 32768, 3, NULL, HEXEN_S_ICESHARD2, 0, 0},      // HEXEN_S_ICESHARD1
    {HEXEN_SPR_SHRD, 32769, 3, NULL, HEXEN_S_ICESHARD3, 0, 0},      // HEXEN_S_ICESHARD2
    {HEXEN_SPR_SHRD, 32770, 3, NULL, HEXEN_S_ICESHARD1, 0, 0},      // HEXEN_S_ICESHARD3
    {HEXEN_SPR_FFSM, 32768, 3, NULL, HEXEN_S_FLAME_TSMALL2, 0, 0},  // HEXEN_S_FLAME_TSMALL1
    {HEXEN_SPR_FFSM, 32769, 3, NULL, HEXEN_S_FLAME_TSMALL3, 0, 0},  // HEXEN_S_FLAME_TSMALL2
    {HEXEN_SPR_FFSM, 32770, 2, A_FlameCheck, HEXEN_S_FLAME_TSMALL4, 0, 0},  // HEXEN_S_FLAME_TSMALL3
    {HEXEN_SPR_FFSM, 32770, 2, NULL, HEXEN_S_FLAME_TSMALL5, 0, 0},  // HEXEN_S_FLAME_TSMALL4
    {HEXEN_SPR_FFSM, 32771, 3, NULL, HEXEN_S_FLAME_TSMALL6, 0, 0},  // HEXEN_S_FLAME_TSMALL5
    {HEXEN_SPR_FFSM, 32772, 3, A_FlameCheck, HEXEN_S_FLAME_TSMALL1, 0, 0},  // HEXEN_S_FLAME_TSMALL6
    {HEXEN_SPR_FFLG, 32768, 4, NULL, HEXEN_S_FLAME_TLARGE2, 0, 0},  // HEXEN_S_FLAME_TLARGE1
    {HEXEN_SPR_FFLG, 32769, 4, A_FlameCheck, HEXEN_S_FLAME_TLARGE3, 0, 0},  // HEXEN_S_FLAME_TLARGE2
    {HEXEN_SPR_FFLG, 32770, 4, NULL, HEXEN_S_FLAME_TLARGE4, 0, 0},  // HEXEN_S_FLAME_TLARGE3
    {HEXEN_SPR_FFLG, 32771, 4, A_FlameCheck, HEXEN_S_FLAME_TLARGE5, 0, 0},  // HEXEN_S_FLAME_TLARGE4
    {HEXEN_SPR_FFLG, 32772, 4, NULL, HEXEN_S_FLAME_TLARGE6, 0, 0},  // HEXEN_S_FLAME_TLARGE5
    {HEXEN_SPR_FFLG, 32773, 4, A_FlameCheck, HEXEN_S_FLAME_TLARGE7, 0, 0},  // HEXEN_S_FLAME_TLARGE6
    {HEXEN_SPR_FFLG, 32774, 4, NULL, HEXEN_S_FLAME_TLARGE8, 0, 0},  // HEXEN_S_FLAME_TLARGE7
    {HEXEN_SPR_FFLG, 32775, 4, A_FlameCheck, HEXEN_S_FLAME_TLARGE9, 0, 0},  // HEXEN_S_FLAME_TLARGE8
    {HEXEN_SPR_FFLG, 32776, 4, NULL, HEXEN_S_FLAME_TLARGE10, 0, 0}, // HEXEN_S_FLAME_TLARGE9
    {HEXEN_SPR_FFLG, 32777, 4, A_FlameCheck, HEXEN_S_FLAME_TLARGE11, 0, 0}, // HEXEN_S_FLAME_TLARGE10
    {HEXEN_SPR_FFLG, 32778, 4, NULL, HEXEN_S_FLAME_TLARGE12, 0, 0}, // HEXEN_S_FLAME_TLARGE11
    {HEXEN_SPR_FFLG, 32779, 4, A_FlameCheck, HEXEN_S_FLAME_TLARGE13, 0, 0}, // HEXEN_S_FLAME_TLARGE12
    {HEXEN_SPR_FFLG, 32780, 4, NULL, HEXEN_S_FLAME_TLARGE14, 0, 0}, // HEXEN_S_FLAME_TLARGE13
    {HEXEN_SPR_FFLG, 32781, 4, A_FlameCheck, HEXEN_S_FLAME_TLARGE15, 0, 0}, // HEXEN_S_FLAME_TLARGE14
    {HEXEN_SPR_FFLG, 32782, 4, NULL, HEXEN_S_FLAME_TLARGE16, 0, 0}, // HEXEN_S_FLAME_TLARGE15
    {HEXEN_SPR_FFLG, 32783, 4, A_FlameCheck, HEXEN_S_FLAME_TLARGE5, 0, 0},  // HEXEN_S_FLAME_TLARGE16
    {HEXEN_SPR_FFSM, 0, 2, NULL, HEXEN_S_FLAME_SDORM2, 0, 0},       // HEXEN_S_FLAME_SDORM1
    {HEXEN_SPR_FFSM, 1, 2, A_HideThing, HEXEN_S_FLAME_SDORM3, 0, 0},        // HEXEN_S_FLAME_SDORM2
    {HEXEN_SPR_FFSM, 2, 200, NULL, HEXEN_S_FLAME_SDORM3, 0, 0},     // HEXEN_S_FLAME_SDORM3
    {HEXEN_SPR_FFSM, 32768, 3, NULL, HEXEN_S_FLAME_SMALL2, 0, 0},   // HEXEN_S_FLAME_SMALL1
    {HEXEN_SPR_FFSM, 32768, 3, A_UnHideThing, HEXEN_S_FLAME_SMALL3, 0, 0},  // HEXEN_S_FLAME_SMALL2
    {HEXEN_SPR_FFSM, 32768, 3, NULL, HEXEN_S_FLAME_SMALL4, 0, 0},   // HEXEN_S_FLAME_SMALL3
    {HEXEN_SPR_FFSM, 32769, 3, NULL, HEXEN_S_FLAME_SMALL5, 0, 0},   // HEXEN_S_FLAME_SMALL4
    {HEXEN_SPR_FFSM, 32770, 3, NULL, HEXEN_S_FLAME_SMALL6, 0, 0},   // HEXEN_S_FLAME_SMALL5
    {HEXEN_SPR_FFSM, 32771, 3, NULL, HEXEN_S_FLAME_SMALL7, 0, 0},   // HEXEN_S_FLAME_SMALL6
    {HEXEN_SPR_FFSM, 32772, 3, NULL, HEXEN_S_FLAME_SMALL3, 0, 0},   // HEXEN_S_FLAME_SMALL7
    {HEXEN_SPR_FFLG, 3, 2, NULL, HEXEN_S_FLAME_LDORM2, 0, 0},       // HEXEN_S_FLAME_LDORM1
    {HEXEN_SPR_FFLG, 2, 2, NULL, HEXEN_S_FLAME_LDORM3, 0, 0},       // HEXEN_S_FLAME_LDORM2
    {HEXEN_SPR_FFLG, 1, 2, NULL, HEXEN_S_FLAME_LDORM4, 0, 0},       // HEXEN_S_FLAME_LDORM3
    {HEXEN_SPR_FFLG, 0, 2, A_HideThing, HEXEN_S_FLAME_LDORM5, 0, 0},        // HEXEN_S_FLAME_LDORM4
    {HEXEN_SPR_FFLG, 0, 200, NULL, HEXEN_S_FLAME_LDORM5, 0, 0},     // HEXEN_S_FLAME_LDORM5
    {HEXEN_SPR_FFLG, 32768, 2, NULL, HEXEN_S_FLAME_LARGE2, 0, 0},   // HEXEN_S_FLAME_LARGE1
    {HEXEN_SPR_FFLG, 32768, 2, A_UnHideThing, HEXEN_S_FLAME_LARGE3, 0, 0},  // HEXEN_S_FLAME_LARGE2
    {HEXEN_SPR_FFLG, 32768, 4, NULL, HEXEN_S_FLAME_LARGE4, 0, 0},   // HEXEN_S_FLAME_LARGE3
    {HEXEN_SPR_FFLG, 32769, 4, NULL, HEXEN_S_FLAME_LARGE5, 0, 0},   // HEXEN_S_FLAME_LARGE4
    {HEXEN_SPR_FFLG, 32770, 4, NULL, HEXEN_S_FLAME_LARGE6, 0, 0},   // HEXEN_S_FLAME_LARGE5
    {HEXEN_SPR_FFLG, 32771, 4, NULL, HEXEN_S_FLAME_LARGE7, 0, 0},   // HEXEN_S_FLAME_LARGE6
    {HEXEN_SPR_FFLG, 32772, 4, NULL, HEXEN_S_FLAME_LARGE8, 0, 0},   // HEXEN_S_FLAME_LARGE7
    {HEXEN_SPR_FFLG, 32773, 4, NULL, HEXEN_S_FLAME_LARGE9, 0, 0},   // HEXEN_S_FLAME_LARGE8
    {HEXEN_SPR_FFLG, 32774, 4, NULL, HEXEN_S_FLAME_LARGE10, 0, 0},  // HEXEN_S_FLAME_LARGE9
    {HEXEN_SPR_FFLG, 32775, 4, NULL, HEXEN_S_FLAME_LARGE11, 0, 0},  // HEXEN_S_FLAME_LARGE10
    {HEXEN_SPR_FFLG, 32776, 4, NULL, HEXEN_S_FLAME_LARGE12, 0, 0},  // HEXEN_S_FLAME_LARGE11
    {HEXEN_SPR_FFLG, 32777, 4, NULL, HEXEN_S_FLAME_LARGE13, 0, 0},  // HEXEN_S_FLAME_LARGE12
    {HEXEN_SPR_FFLG, 32778, 4, NULL, HEXEN_S_FLAME_LARGE14, 0, 0},  // HEXEN_S_FLAME_LARGE13
    {HEXEN_SPR_FFLG, 32779, 4, NULL, HEXEN_S_FLAME_LARGE15, 0, 0},  // HEXEN_S_FLAME_LARGE14
    {HEXEN_SPR_FFLG, 32780, 4, NULL, HEXEN_S_FLAME_LARGE16, 0, 0},  // HEXEN_S_FLAME_LARGE15
    {HEXEN_SPR_FFLG, 32781, 4, NULL, HEXEN_S_FLAME_LARGE17, 0, 0},  // HEXEN_S_FLAME_LARGE16
    {HEXEN_SPR_FFLG, 32782, 4, NULL, HEXEN_S_FLAME_LARGE18, 0, 0},  // HEXEN_S_FLAME_LARGE17
    {HEXEN_SPR_FFLG, 32783, 4, NULL, HEXEN_S_FLAME_LARGE7, 0, 0},   // HEXEN_S_FLAME_LARGE18
    {HEXEN_SPR_PTN1, 0, 3, NULL, HEXEN_S_ITEM_PTN1_2, 0, 0},        // HEXEN_S_ITEM_PTN1_1
    {HEXEN_SPR_PTN1, 1, 3, NULL, HEXEN_S_ITEM_PTN1_3, 0, 0},        // HEXEN_S_ITEM_PTN1_2
    {HEXEN_SPR_PTN1, 2, 3, NULL, HEXEN_S_ITEM_PTN1_1, 0, 0},        // HEXEN_S_ITEM_PTN1_3
    {HEXEN_SPR_ACLO, 4, 1400, NULL, HEXEN_S_HIDESPECIAL2, 0, 0},    // HEXEN_S_HIDESPECIAL1
    {HEXEN_SPR_ACLO, 0, 4, A_RestoreSpecialThing1, HEXEN_S_HIDESPECIAL3, 0, 0},     // HEXEN_S_HIDESPECIAL2
    {HEXEN_SPR_ACLO, 1, 4, NULL, HEXEN_S_HIDESPECIAL4, 0, 0},       // HEXEN_S_HIDESPECIAL3
    {HEXEN_SPR_ACLO, 0, 4, NULL, HEXEN_S_HIDESPECIAL5, 0, 0},       // HEXEN_S_HIDESPECIAL4
    {HEXEN_SPR_ACLO, 1, 4, NULL, HEXEN_S_HIDESPECIAL6, 0, 0},       // HEXEN_S_HIDESPECIAL5
    {HEXEN_SPR_ACLO, 2, 4, NULL, HEXEN_S_HIDESPECIAL7, 0, 0},       // HEXEN_S_HIDESPECIAL6
    {HEXEN_SPR_ACLO, 1, 4, NULL, HEXEN_S_HIDESPECIAL8, 0, 0},       // HEXEN_S_HIDESPECIAL7
    {HEXEN_SPR_ACLO, 2, 4, NULL, HEXEN_S_HIDESPECIAL9, 0, 0},       // HEXEN_S_HIDESPECIAL8
    {HEXEN_SPR_ACLO, 3, 4, NULL, HEXEN_S_HIDESPECIAL10, 0, 0},      // HEXEN_S_HIDESPECIAL9
    {HEXEN_SPR_ACLO, 2, 4, NULL, HEXEN_S_HIDESPECIAL11, 0, 0},      // HEXEN_S_HIDESPECIAL10
    {HEXEN_SPR_ACLO, 3, 4, A_RestoreSpecialThing2, HEXEN_S_NULL, 0, 0},     // HEXEN_S_HIDESPECIAL11
    {HEXEN_SPR_ACLO, 3, 3, NULL, HEXEN_S_DORMANTARTI1_2, 0, 0},     // HEXEN_S_DORMANTARTI1_1
    {HEXEN_SPR_ACLO, 2, 3, NULL, HEXEN_S_DORMANTARTI1_3, 0, 0},     // HEXEN_S_DORMANTARTI1_2
    {HEXEN_SPR_ACLO, 3, 3, NULL, HEXEN_S_DORMANTARTI1_4, 0, 0},     // HEXEN_S_DORMANTARTI1_3
    {HEXEN_SPR_ACLO, 2, 3, NULL, HEXEN_S_DORMANTARTI1_5, 0, 0},     // HEXEN_S_DORMANTARTI1_4
    {HEXEN_SPR_ACLO, 1, 3, NULL, HEXEN_S_DORMANTARTI1_6, 0, 0},     // HEXEN_S_DORMANTARTI1_5
    {HEXEN_SPR_ACLO, 2, 3, NULL, HEXEN_S_DORMANTARTI1_7, 0, 0},     // HEXEN_S_DORMANTARTI1_6
    {HEXEN_SPR_ACLO, 1, 3, NULL, HEXEN_S_DORMANTARTI1_8, 0, 0},     // HEXEN_S_DORMANTARTI1_7
    {HEXEN_SPR_ACLO, 0, 3, NULL, HEXEN_S_DORMANTARTI1_9, 0, 0},     // HEXEN_S_DORMANTARTI1_8
    {HEXEN_SPR_ACLO, 1, 3, NULL, HEXEN_S_DORMANTARTI1_10, 0, 0},    // HEXEN_S_DORMANTARTI1_9
    {HEXEN_SPR_ACLO, 0, 3, NULL, HEXEN_S_DORMANTARTI1_11, 0, 0},    // HEXEN_S_DORMANTARTI1_10
    {HEXEN_SPR_ACLO, 0, 1400, A_HideThing, HEXEN_S_DORMANTARTI1_12, 0, 0},  // HEXEN_S_DORMANTARTI1_11
    {HEXEN_SPR_ACLO, 0, 3, A_UnHideThing, HEXEN_S_DORMANTARTI1_13, 0, 0},   // HEXEN_S_DORMANTARTI1_12
    {HEXEN_SPR_ACLO, 1, 3, NULL, HEXEN_S_DORMANTARTI1_14, 0, 0},    // HEXEN_S_DORMANTARTI1_13
    {HEXEN_SPR_ACLO, 0, 3, NULL, HEXEN_S_DORMANTARTI1_15, 0, 0},    // HEXEN_S_DORMANTARTI1_14
    {HEXEN_SPR_ACLO, 1, 3, NULL, HEXEN_S_DORMANTARTI1_16, 0, 0},    // HEXEN_S_DORMANTARTI1_15
    {HEXEN_SPR_ACLO, 2, 3, NULL, HEXEN_S_DORMANTARTI1_17, 0, 0},    // HEXEN_S_DORMANTARTI1_16
    {HEXEN_SPR_ACLO, 1, 3, NULL, HEXEN_S_DORMANTARTI1_18, 0, 0},    // HEXEN_S_DORMANTARTI1_17
    {HEXEN_SPR_ACLO, 2, 3, NULL, HEXEN_S_DORMANTARTI1_19, 0, 0},    // HEXEN_S_DORMANTARTI1_18
    {HEXEN_SPR_ACLO, 3, 3, NULL, HEXEN_S_DORMANTARTI1_20, 0, 0},    // HEXEN_S_DORMANTARTI1_19
    {HEXEN_SPR_ACLO, 2, 3, NULL, HEXEN_S_DORMANTARTI1_21, 0, 0},    // HEXEN_S_DORMANTARTI1_20
    {HEXEN_SPR_ACLO, 3, 3, A_RestoreArtifact, HEXEN_S_NULL, 0, 0},  // HEXEN_S_DORMANTARTI1_21
    {HEXEN_SPR_ACLO, 3, 3, NULL, HEXEN_S_DORMANTARTI2_2, 0, 0},     // HEXEN_S_DORMANTARTI2_1
    {HEXEN_SPR_ACLO, 2, 3, NULL, HEXEN_S_DORMANTARTI2_3, 0, 0},     // HEXEN_S_DORMANTARTI2_2
    {HEXEN_SPR_ACLO, 3, 3, NULL, HEXEN_S_DORMANTARTI2_4, 0, 0},     // HEXEN_S_DORMANTARTI2_3
    {HEXEN_SPR_ACLO, 2, 3, NULL, HEXEN_S_DORMANTARTI2_5, 0, 0},     // HEXEN_S_DORMANTARTI2_4
    {HEXEN_SPR_ACLO, 1, 3, NULL, HEXEN_S_DORMANTARTI2_6, 0, 0},     // HEXEN_S_DORMANTARTI2_5
    {HEXEN_SPR_ACLO, 2, 3, NULL, HEXEN_S_DORMANTARTI2_7, 0, 0},     // HEXEN_S_DORMANTARTI2_6
    {HEXEN_SPR_ACLO, 1, 3, NULL, HEXEN_S_DORMANTARTI2_8, 0, 0},     // HEXEN_S_DORMANTARTI2_7
    {HEXEN_SPR_ACLO, 0, 3, NULL, HEXEN_S_DORMANTARTI2_9, 0, 0},     // HEXEN_S_DORMANTARTI2_8
    {HEXEN_SPR_ACLO, 1, 3, NULL, HEXEN_S_DORMANTARTI2_10, 0, 0},    // HEXEN_S_DORMANTARTI2_9
    {HEXEN_SPR_ACLO, 0, 3, NULL, HEXEN_S_DORMANTARTI2_11, 0, 0},    // HEXEN_S_DORMANTARTI2_10
    {HEXEN_SPR_ACLO, 0, 4200, A_HideThing, HEXEN_S_DORMANTARTI2_12, 0, 0},  // HEXEN_S_DORMANTARTI2_11
    {HEXEN_SPR_ACLO, 0, 3, A_UnHideThing, HEXEN_S_DORMANTARTI2_13, 0, 0},   // HEXEN_S_DORMANTARTI2_12
    {HEXEN_SPR_ACLO, 1, 3, NULL, HEXEN_S_DORMANTARTI2_14, 0, 0},    // HEXEN_S_DORMANTARTI2_13
    {HEXEN_SPR_ACLO, 0, 3, NULL, HEXEN_S_DORMANTARTI2_15, 0, 0},    // HEXEN_S_DORMANTARTI2_14
    {HEXEN_SPR_ACLO, 1, 3, NULL, HEXEN_S_DORMANTARTI2_16, 0, 0},    // HEXEN_S_DORMANTARTI2_15
    {HEXEN_SPR_ACLO, 2, 3, NULL, HEXEN_S_DORMANTARTI2_17, 0, 0},    // HEXEN_S_DORMANTARTI2_16
    {HEXEN_SPR_ACLO, 1, 3, NULL, HEXEN_S_DORMANTARTI2_18, 0, 0},    // HEXEN_S_DORMANTARTI2_17
    {HEXEN_SPR_ACLO, 2, 3, NULL, HEXEN_S_DORMANTARTI2_19, 0, 0},    // HEXEN_S_DORMANTARTI2_18
    {HEXEN_SPR_ACLO, 3, 3, NULL, HEXEN_S_DORMANTARTI2_20, 0, 0},    // HEXEN_S_DORMANTARTI2_19
    {HEXEN_SPR_ACLO, 2, 3, NULL, HEXEN_S_DORMANTARTI2_21, 0, 0},    // HEXEN_S_DORMANTARTI2_20
    {HEXEN_SPR_ACLO, 3, 3, A_RestoreArtifact, HEXEN_S_NULL, 0, 0},  // HEXEN_S_DORMANTARTI2_21
    {HEXEN_SPR_ACLO, 3, 3, NULL, HEXEN_S_DORMANTARTI3_2, 0, 0},     // HEXEN_S_DORMANTARTI3_1
    {HEXEN_SPR_ACLO, 2, 3, NULL, HEXEN_S_DORMANTARTI3_3, 0, 0},     // HEXEN_S_DORMANTARTI3_2
    {HEXEN_SPR_ACLO, 3, 3, NULL, HEXEN_S_DORMANTARTI3_4, 0, 0},     // HEXEN_S_DORMANTARTI3_3
    {HEXEN_SPR_ACLO, 2, 3, NULL, HEXEN_S_DORMANTARTI3_5, 0, 0},     // HEXEN_S_DORMANTARTI3_4
    {HEXEN_SPR_ACLO, 1, 3, NULL, HEXEN_S_DORMANTARTI3_6, 0, 0},     // HEXEN_S_DORMANTARTI3_5
    {HEXEN_SPR_ACLO, 2, 3, NULL, HEXEN_S_DORMANTARTI3_7, 0, 0},     // HEXEN_S_DORMANTARTI3_6
    {HEXEN_SPR_ACLO, 1, 3, NULL, HEXEN_S_DORMANTARTI3_8, 0, 0},     // HEXEN_S_DORMANTARTI3_7
    {HEXEN_SPR_ACLO, 0, 3, NULL, HEXEN_S_DORMANTARTI3_9, 0, 0},     // HEXEN_S_DORMANTARTI3_8
    {HEXEN_SPR_ACLO, 1, 3, NULL, HEXEN_S_DORMANTARTI3_10, 0, 0},    // HEXEN_S_DORMANTARTI3_9
    {HEXEN_SPR_ACLO, 0, 3, NULL, HEXEN_S_DORMANTARTI3_11, 0, 0},    // HEXEN_S_DORMANTARTI3_10
    {HEXEN_SPR_ACLO, 0, 21000, A_HideThing, HEXEN_S_DORMANTARTI3_12, 0, 0}, // HEXEN_S_DORMANTARTI3_11
    {HEXEN_SPR_ACLO, 0, 3, A_UnHideThing, HEXEN_S_DORMANTARTI3_13, 0, 0},   // HEXEN_S_DORMANTARTI3_12
    {HEXEN_SPR_ACLO, 1, 3, NULL, HEXEN_S_DORMANTARTI3_14, 0, 0},    // HEXEN_S_DORMANTARTI3_13
    {HEXEN_SPR_ACLO, 0, 3, NULL, HEXEN_S_DORMANTARTI3_15, 0, 0},    // HEXEN_S_DORMANTARTI3_14
    {HEXEN_SPR_ACLO, 1, 3, NULL, HEXEN_S_DORMANTARTI3_16, 0, 0},    // HEXEN_S_DORMANTARTI3_15
    {HEXEN_SPR_ACLO, 2, 3, NULL, HEXEN_S_DORMANTARTI3_17, 0, 0},    // HEXEN_S_DORMANTARTI3_16
    {HEXEN_SPR_ACLO, 1, 3, NULL, HEXEN_S_DORMANTARTI3_18, 0, 0},    // HEXEN_S_DORMANTARTI3_17
    {HEXEN_SPR_ACLO, 2, 3, NULL, HEXEN_S_DORMANTARTI3_19, 0, 0},    // HEXEN_S_DORMANTARTI3_18
    {HEXEN_SPR_ACLO, 3, 3, NULL, HEXEN_S_DORMANTARTI3_20, 0, 0},    // HEXEN_S_DORMANTARTI3_19
    {HEXEN_SPR_ACLO, 2, 3, NULL, HEXEN_S_DORMANTARTI3_21, 0, 0},    // HEXEN_S_DORMANTARTI3_20
    {HEXEN_SPR_ACLO, 3, 3, A_RestoreArtifact, HEXEN_S_NULL, 0, 0},  // HEXEN_S_DORMANTARTI3_21
    {HEXEN_SPR_ACLO, 3, 3, NULL, HEXEN_S_DEADARTI2, 0, 0},  // HEXEN_S_DEADARTI1
    {HEXEN_SPR_ACLO, 2, 3, NULL, HEXEN_S_DEADARTI3, 0, 0},  // HEXEN_S_DEADARTI2
    {HEXEN_SPR_ACLO, 3, 3, NULL, HEXEN_S_DEADARTI4, 0, 0},  // HEXEN_S_DEADARTI3
    {HEXEN_SPR_ACLO, 2, 3, NULL, HEXEN_S_DEADARTI5, 0, 0},  // HEXEN_S_DEADARTI4
    {HEXEN_SPR_ACLO, 1, 3, NULL, HEXEN_S_DEADARTI6, 0, 0},  // HEXEN_S_DEADARTI5
    {HEXEN_SPR_ACLO, 2, 3, NULL, HEXEN_S_DEADARTI7, 0, 0},  // HEXEN_S_DEADARTI6
    {HEXEN_SPR_ACLO, 1, 3, NULL, HEXEN_S_DEADARTI8, 0, 0},  // HEXEN_S_DEADARTI7
    {HEXEN_SPR_ACLO, 0, 3, NULL, HEXEN_S_DEADARTI9, 0, 0},  // HEXEN_S_DEADARTI8
    {HEXEN_SPR_ACLO, 1, 3, NULL, HEXEN_S_DEADARTI10, 0, 0}, // HEXEN_S_DEADARTI9
    {HEXEN_SPR_ACLO, 0, 3, NULL, HEXEN_S_NULL, 0, 0},       // HEXEN_S_DEADARTI10
    {HEXEN_SPR_PTN2, 0, 4, NULL, HEXEN_S_ARTI_PTN2_2, 0, 0},        // HEXEN_S_ARTI_PTN2_1
    {HEXEN_SPR_PTN2, 1, 4, NULL, HEXEN_S_ARTI_PTN2_3, 0, 0},        // HEXEN_S_ARTI_PTN2_2
    {HEXEN_SPR_PTN2, 2, 4, NULL, HEXEN_S_ARTI_PTN2_1, 0, 0},        // HEXEN_S_ARTI_PTN2_3
    {HEXEN_SPR_SOAR, 0, 5, NULL, HEXEN_S_ARTI_SOAR2, 0, 0}, // HEXEN_S_ARTI_SOAR1
    {HEXEN_SPR_SOAR, 1, 5, NULL, HEXEN_S_ARTI_SOAR3, 0, 0}, // HEXEN_S_ARTI_SOAR2
    {HEXEN_SPR_SOAR, 2, 5, NULL, HEXEN_S_ARTI_SOAR4, 0, 0}, // HEXEN_S_ARTI_SOAR3
    {HEXEN_SPR_SOAR, 1, 5, NULL, HEXEN_S_ARTI_SOAR1, 0, 0}, // HEXEN_S_ARTI_SOAR4
    {HEXEN_SPR_INVU, 0, 3, NULL, HEXEN_S_ARTI_INVU2, 0, 0}, // HEXEN_S_ARTI_INVU1
    {HEXEN_SPR_INVU, 1, 3, NULL, HEXEN_S_ARTI_INVU3, 0, 0}, // HEXEN_S_ARTI_INVU2
    {HEXEN_SPR_INVU, 2, 3, NULL, HEXEN_S_ARTI_INVU4, 0, 0}, // HEXEN_S_ARTI_INVU3
    {HEXEN_SPR_INVU, 3, 3, NULL, HEXEN_S_ARTI_INVU1, 0, 0}, // HEXEN_S_ARTI_INVU4
    {HEXEN_SPR_SUMN, 0, 350, NULL, HEXEN_S_ARTI_SUMMON, 0, 0},      // HEXEN_S_ARTI_SUMMON
    {HEXEN_SPR_SUMN, 0, 4, NULL, HEXEN_S_SUMMON_FX1_1, 0, 0},       // HEXEN_S_SUMMON_FX1_1
    {HEXEN_SPR_SUMN, 0, 4, NULL, HEXEN_S_SUMMON_FX2_2, 0, 0},       // HEXEN_S_SUMMON_FX2_1
    {HEXEN_SPR_SUMN, 0, 4, NULL, HEXEN_S_SUMMON_FX2_3, 0, 0},       // HEXEN_S_SUMMON_FX2_2
    {HEXEN_SPR_SUMN, 0, 4, A_Summon, HEXEN_S_NULL, 0, 0},   // HEXEN_S_SUMMON_FX2_3
    {HEXEN_SPR_TSPK, 0, 3, NULL, HEXEN_S_THRUSTINIT2_2, 0, 0},      // HEXEN_S_THRUSTINIT2_1
    {HEXEN_SPR_TSPK, 0, 4, A_ThrustInitUp, HEXEN_S_THRUSTBLOCK, 0, 0},      // HEXEN_S_THRUSTINIT2_2
    {HEXEN_SPR_TSPK, 1, 3, NULL, HEXEN_S_BTHRUSTINIT2_2, 0, 0},     // HEXEN_S_BTHRUSTINIT2_1
    {HEXEN_SPR_TSPK, 1, 4, A_ThrustInitUp, HEXEN_S_BTHRUSTBLOCK, 0, 0},     // HEXEN_S_BTHRUSTINIT2_2
    {HEXEN_SPR_TSPK, 0, 3, NULL, HEXEN_S_THRUSTINIT1_2, 0, 0},      // HEXEN_S_THRUSTINIT1_1
    {HEXEN_SPR_TSPK, 0, 4, A_ThrustInitDn, HEXEN_S_THRUSTSTAY, 0, 0},       // HEXEN_S_THRUSTINIT1_2
    {HEXEN_SPR_TSPK, 1, 3, NULL, HEXEN_S_BTHRUSTINIT1_2, 0, 0},     // HEXEN_S_BTHRUSTINIT1_1
    {HEXEN_SPR_TSPK, 1, 4, A_ThrustInitDn, HEXEN_S_BTHRUSTSTAY, 0, 0},      // HEXEN_S_BTHRUSTINIT1_2
    {HEXEN_SPR_TSPK, 0, 8, A_ThrustRaise, HEXEN_S_THRUSTRAISE2, 0, 0},      // HEXEN_S_THRUSTRAISE1
    {HEXEN_SPR_TSPK, 0, 6, A_ThrustRaise, HEXEN_S_THRUSTRAISE3, 0, 0},      // HEXEN_S_THRUSTRAISE2
    {HEXEN_SPR_TSPK, 0, 4, A_ThrustRaise, HEXEN_S_THRUSTRAISE4, 0, 0},      // HEXEN_S_THRUSTRAISE3
    {HEXEN_SPR_TSPK, 0, 3, A_ThrustBlock, HEXEN_S_THRUSTIMPALE, 0, 0},      // HEXEN_S_THRUSTRAISE4
    {HEXEN_SPR_TSPK, 1, 8, A_ThrustRaise, HEXEN_S_BTHRUSTRAISE2, 0, 0},     // HEXEN_S_BTHRUSTRAISE1
    {HEXEN_SPR_TSPK, 1, 6, A_ThrustRaise, HEXEN_S_BTHRUSTRAISE3, 0, 0},     // HEXEN_S_BTHRUSTRAISE2
    {HEXEN_SPR_TSPK, 1, 4, A_ThrustRaise, HEXEN_S_BTHRUSTRAISE4, 0, 0},     // HEXEN_S_BTHRUSTRAISE3
    {HEXEN_SPR_TSPK, 1, 3, A_ThrustBlock, HEXEN_S_BTHRUSTIMPALE, 0, 0},     // HEXEN_S_BTHRUSTRAISE4
    {HEXEN_SPR_TSPK, 0, 2, A_ThrustImpale, HEXEN_S_THRUSTRAISE, 0, 0},      // HEXEN_S_THRUSTIMPALE
    {HEXEN_SPR_TSPK, 1, 2, A_ThrustImpale, HEXEN_S_BTHRUSTRAISE, 0, 0},     // HEXEN_S_BTHRUSTIMPALE
    {HEXEN_SPR_TSPK, 0, 2, A_ThrustRaise, HEXEN_S_THRUSTRAISE, 0, 0},       // HEXEN_S_THRUSTRAISE
    {HEXEN_SPR_TSPK, 1, 2, A_ThrustRaise, HEXEN_S_BTHRUSTRAISE, 0, 0},      // HEXEN_S_BTHRUSTRAISE
    {HEXEN_SPR_TSPK, 0, 10, NULL, HEXEN_S_THRUSTBLOCK, 0, 0},       // HEXEN_S_THRUSTBLOCK
    {HEXEN_SPR_TSPK, 1, 10, NULL, HEXEN_S_BTHRUSTBLOCK, 0, 0},      // HEXEN_S_BTHRUSTBLOCK
    {HEXEN_SPR_TSPK, 0, 2, A_ThrustLower, HEXEN_S_THRUSTLOWER, 0, 0},       // HEXEN_S_THRUSTLOWER
    {HEXEN_SPR_TSPK, 1, 2, A_ThrustLower, HEXEN_S_BTHRUSTLOWER, 0, 0},      // HEXEN_S_BTHRUSTLOWER
    {HEXEN_SPR_TSPK, 0, -1, NULL, HEXEN_S_THRUSTSTAY, 0, 0},        // HEXEN_S_THRUSTSTAY
    {HEXEN_SPR_TSPK, 1, -1, NULL, HEXEN_S_BTHRUSTSTAY, 0, 0},       // HEXEN_S_BTHRUSTSTAY
    {HEXEN_SPR_TELO, 0, 5, NULL, HEXEN_S_ARTI_TELOTHER2, 0, 0},     // HEXEN_S_ARTI_TELOTHER1
    {HEXEN_SPR_TELO, 1, 5, NULL, HEXEN_S_ARTI_TELOTHER3, 0, 0},     // HEXEN_S_ARTI_TELOTHER2
    {HEXEN_SPR_TELO, 2, 5, NULL, HEXEN_S_ARTI_TELOTHER4, 0, 0},     // HEXEN_S_ARTI_TELOTHER3
    {HEXEN_SPR_TELO, 3, 5, NULL, HEXEN_S_ARTI_TELOTHER1, 0, 0},     // HEXEN_S_ARTI_TELOTHER4
    {HEXEN_SPR_TRNG, 32772, 5, NULL, HEXEN_S_TELO_FX2, 0, 0},       // HEXEN_S_TELO_FX1
    {HEXEN_SPR_TRNG, 32771, 4, NULL, HEXEN_S_TELO_FX3, 0, 0},       // HEXEN_S_TELO_FX2
    {HEXEN_SPR_TRNG, 32770, 3, A_TeloSpawnC, HEXEN_S_TELO_FX4, 0, 0},       // HEXEN_S_TELO_FX3
    {HEXEN_SPR_TRNG, 32769, 3, A_TeloSpawnB, HEXEN_S_TELO_FX5, 0, 0},       // HEXEN_S_TELO_FX4
    {HEXEN_SPR_TRNG, 32768, 3, A_TeloSpawnA, HEXEN_S_TELO_FX6, 0, 0},       // HEXEN_S_TELO_FX5
    {HEXEN_SPR_TRNG, 32769, 3, A_TeloSpawnB, HEXEN_S_TELO_FX7, 0, 0},       // HEXEN_S_TELO_FX6
    {HEXEN_SPR_TRNG, 32770, 3, A_TeloSpawnC, HEXEN_S_TELO_FX8, 0, 0},       // HEXEN_S_TELO_FX7
    {HEXEN_SPR_TRNG, 32771, 3, A_TeloSpawnD, HEXEN_S_TELO_FX3, 0, 0},       // HEXEN_S_TELO_FX8
    {HEXEN_SPR_TRNG, 32772, 3, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_TELO_FX9
    {HEXEN_SPR_TRNG, 32769, 4, NULL, HEXEN_S_TELO_FX2_2, 0, 0},     // HEXEN_S_TELO_FX2_1
    {HEXEN_SPR_TRNG, 32770, 4, NULL, HEXEN_S_TELO_FX2_3, 0, 0},     // HEXEN_S_TELO_FX2_2
    {HEXEN_SPR_TRNG, 32771, 4, NULL, HEXEN_S_TELO_FX2_4, 0, 0},     // HEXEN_S_TELO_FX2_3
    {HEXEN_SPR_TRNG, 32770, 4, NULL, HEXEN_S_TELO_FX2_5, 0, 0},     // HEXEN_S_TELO_FX2_4
    {HEXEN_SPR_TRNG, 32769, 4, NULL, HEXEN_S_TELO_FX2_6, 0, 0},     // HEXEN_S_TELO_FX2_5
    {HEXEN_SPR_TRNG, 32768, 4, A_CheckTeleRing, HEXEN_S_TELO_FX2_1, 0, 0},  // HEXEN_S_TELO_FX2_6
    {HEXEN_SPR_TRNG, 32770, 4, NULL, HEXEN_S_TELO_FX3_2, 0, 0},     // HEXEN_S_TELO_FX3_1
    {HEXEN_SPR_TRNG, 32771, 4, NULL, HEXEN_S_TELO_FX3_3, 0, 0},     // HEXEN_S_TELO_FX3_2
    {HEXEN_SPR_TRNG, 32770, 4, NULL, HEXEN_S_TELO_FX3_4, 0, 0},     // HEXEN_S_TELO_FX3_3
    {HEXEN_SPR_TRNG, 32769, 4, NULL, HEXEN_S_TELO_FX3_5, 0, 0},     // HEXEN_S_TELO_FX3_4
    {HEXEN_SPR_TRNG, 32768, 4, NULL, HEXEN_S_TELO_FX3_6, 0, 0},     // HEXEN_S_TELO_FX3_5
    {HEXEN_SPR_TRNG, 32769, 4, A_CheckTeleRing, HEXEN_S_TELO_FX3_1, 0, 0},  // HEXEN_S_TELO_FX3_6
    {HEXEN_SPR_TRNG, 32771, 4, NULL, HEXEN_S_TELO_FX4_2, 0, 0},     // HEXEN_S_TELO_FX4_1
    {HEXEN_SPR_TRNG, 32770, 4, NULL, HEXEN_S_TELO_FX4_3, 0, 0},     // HEXEN_S_TELO_FX4_2
    {HEXEN_SPR_TRNG, 32769, 4, NULL, HEXEN_S_TELO_FX4_4, 0, 0},     // HEXEN_S_TELO_FX4_3
    {HEXEN_SPR_TRNG, 32768, 4, NULL, HEXEN_S_TELO_FX4_5, 0, 0},     // HEXEN_S_TELO_FX4_4
    {HEXEN_SPR_TRNG, 32769, 4, NULL, HEXEN_S_TELO_FX4_6, 0, 0},     // HEXEN_S_TELO_FX4_5
    {HEXEN_SPR_TRNG, 32770, 4, A_CheckTeleRing, HEXEN_S_TELO_FX4_1, 0, 0},  // HEXEN_S_TELO_FX4_6
    {HEXEN_SPR_TRNG, 32770, 4, NULL, HEXEN_S_TELO_FX5_2, 0, 0},     // HEXEN_S_TELO_FX5_1
    {HEXEN_SPR_TRNG, 32769, 4, NULL, HEXEN_S_TELO_FX5_3, 0, 0},     // HEXEN_S_TELO_FX5_2
    {HEXEN_SPR_TRNG, 32768, 4, NULL, HEXEN_S_TELO_FX5_4, 0, 0},     // HEXEN_S_TELO_FX5_3
    {HEXEN_SPR_TRNG, 32769, 4, NULL, HEXEN_S_TELO_FX5_5, 0, 0},     // HEXEN_S_TELO_FX5_4
    {HEXEN_SPR_TRNG, 32770, 4, NULL, HEXEN_S_TELO_FX5_6, 0, 0},     // HEXEN_S_TELO_FX5_5
    {HEXEN_SPR_TRNG, 32771, 4, A_CheckTeleRing, HEXEN_S_TELO_FX5_1, 0, 0},  // HEXEN_S_TELO_FX5_6
    {HEXEN_SPR_ROCK, 3, 20, NULL, HEXEN_S_DIRT1_1, 0, 0},   // HEXEN_S_DIRT1_1
    {HEXEN_SPR_ROCK, 3, 10, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_DIRT1_D
    {HEXEN_SPR_ROCK, 4, 20, NULL, HEXEN_S_DIRT2_1, 0, 0},   // HEXEN_S_DIRT2_1
    {HEXEN_SPR_ROCK, 4, 10, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_DIRT2_D
    {HEXEN_SPR_ROCK, 5, 20, NULL, HEXEN_S_DIRT3_1, 0, 0},   // HEXEN_S_DIRT3_1
    {HEXEN_SPR_ROCK, 5, 10, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_DIRT3_D
    {HEXEN_SPR_ROCK, 6, 20, NULL, HEXEN_S_DIRT4_1, 0, 0},   // HEXEN_S_DIRT4_1
    {HEXEN_SPR_ROCK, 6, 10, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_DIRT4_D
    {HEXEN_SPR_ROCK, 7, 20, NULL, HEXEN_S_DIRT5_1, 0, 0},   // HEXEN_S_DIRT5_1
    {HEXEN_SPR_ROCK, 7, 10, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_DIRT5_D
    {HEXEN_SPR_ROCK, 8, 20, NULL, HEXEN_S_DIRT6_1, 0, 0},   // HEXEN_S_DIRT6_1
    {HEXEN_SPR_ROCK, 8, 10, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_DIRT6_D
    {HEXEN_SPR_TSPK, 2, 20, NULL, HEXEN_S_DIRTCLUMP1, 0, 0},        // HEXEN_S_DIRTCLUMP1
    {HEXEN_SPR_ROCK, 0, 20, NULL, HEXEN_S_ROCK1_1, 0, 0},   // HEXEN_S_ROCK1_1
    {HEXEN_SPR_ROCK, 0, 10, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ROCK1_D
    {HEXEN_SPR_ROCK, 1, 20, NULL, HEXEN_S_ROCK2_1, 0, 0},   // HEXEN_S_ROCK2_1
    {HEXEN_SPR_ROCK, 1, 10, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ROCK2_D
    {HEXEN_SPR_ROCK, 2, 20, NULL, HEXEN_S_ROCK3_1, 0, 0},   // HEXEN_S_ROCK3_1
    {HEXEN_SPR_ROCK, 2, 10, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ROCK3_D
    {HEXEN_SPR_MAN1, 0, 20, A_FogSpawn, HEXEN_S_SPAWNFOG1, 0, 0},   // HEXEN_S_SPAWNFOG1
    {HEXEN_SPR_FOGS, 0, 7, A_FogMove, HEXEN_S_FOGPATCHS2, 0, 0},    // HEXEN_S_FOGPATCHS1
    {HEXEN_SPR_FOGS, 1, 7, A_FogMove, HEXEN_S_FOGPATCHS3, 0, 0},    // HEXEN_S_FOGPATCHS2
    {HEXEN_SPR_FOGS, 2, 7, A_FogMove, HEXEN_S_FOGPATCHS4, 0, 0},    // HEXEN_S_FOGPATCHS3
    {HEXEN_SPR_FOGS, 3, 7, A_FogMove, HEXEN_S_FOGPATCHS5, 0, 0},    // HEXEN_S_FOGPATCHS4
    {HEXEN_SPR_FOGS, 4, 7, A_FogMove, HEXEN_S_FOGPATCHS1, 0, 0},    // HEXEN_S_FOGPATCHS5
    {HEXEN_SPR_FOGS, 4, 5, NULL, HEXEN_S_NULL, 0, 0},       // HEXEN_S_FOGPATCHS0
    {HEXEN_SPR_FOGM, 0, 7, A_FogMove, HEXEN_S_FOGPATCHM2, 0, 0},    // HEXEN_S_FOGPATCHM1
    {HEXEN_SPR_FOGM, 1, 7, A_FogMove, HEXEN_S_FOGPATCHM3, 0, 0},    // HEXEN_S_FOGPATCHM2
    {HEXEN_SPR_FOGM, 2, 7, A_FogMove, HEXEN_S_FOGPATCHM4, 0, 0},    // HEXEN_S_FOGPATCHM3
    {HEXEN_SPR_FOGM, 3, 7, A_FogMove, HEXEN_S_FOGPATCHM5, 0, 0},    // HEXEN_S_FOGPATCHM4
    {HEXEN_SPR_FOGM, 4, 7, A_FogMove, HEXEN_S_FOGPATCHM1, 0, 0},    // HEXEN_S_FOGPATCHM5
    {HEXEN_SPR_FOGS, 0, 5, NULL, HEXEN_S_FOGPATCHMA, 0, 0}, // HEXEN_S_FOGPATCHM0
    {HEXEN_SPR_FOGS, 1, 5, NULL, HEXEN_S_FOGPATCHMB, 0, 0}, // HEXEN_S_FOGPATCHMA
    {HEXEN_SPR_FOGS, 2, 5, NULL, HEXEN_S_FOGPATCHMC, 0, 0}, // HEXEN_S_FOGPATCHMB
    {HEXEN_SPR_FOGS, 3, 5, NULL, HEXEN_S_FOGPATCHMD, 0, 0}, // HEXEN_S_FOGPATCHMC
    {HEXEN_SPR_FOGS, 4, 5, NULL, HEXEN_S_FOGPATCHS0, 0, 0}, // HEXEN_S_FOGPATCHMD
    {HEXEN_SPR_FOGL, 0, 7, A_FogMove, HEXEN_S_FOGPATCHL2, 0, 0},    // HEXEN_S_FOGPATCHL1
    {HEXEN_SPR_FOGL, 1, 7, A_FogMove, HEXEN_S_FOGPATCHL3, 0, 0},    // HEXEN_S_FOGPATCHL2
    {HEXEN_SPR_FOGL, 2, 7, A_FogMove, HEXEN_S_FOGPATCHL4, 0, 0},    // HEXEN_S_FOGPATCHL3
    {HEXEN_SPR_FOGL, 3, 7, A_FogMove, HEXEN_S_FOGPATCHL5, 0, 0},    // HEXEN_S_FOGPATCHL4
    {HEXEN_SPR_FOGL, 4, 7, A_FogMove, HEXEN_S_FOGPATCHL1, 0, 0},    // HEXEN_S_FOGPATCHL5
    {HEXEN_SPR_FOGM, 0, 4, NULL, HEXEN_S_FOGPATCHLA, 0, 0}, // HEXEN_S_FOGPATCHL0
    {HEXEN_SPR_FOGM, 1, 4, NULL, HEXEN_S_FOGPATCHLB, 0, 0}, // HEXEN_S_FOGPATCHLA
    {HEXEN_SPR_FOGM, 2, 4, NULL, HEXEN_S_FOGPATCHLC, 0, 0}, // HEXEN_S_FOGPATCHLB
    {HEXEN_SPR_FOGM, 3, 4, NULL, HEXEN_S_FOGPATCHLD, 0, 0}, // HEXEN_S_FOGPATCHLC
    {HEXEN_SPR_FOGM, 4, 4, NULL, HEXEN_S_FOGPATCHM0, 0, 0}, // HEXEN_S_FOGPATCHLD
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVE2, 0, 0},   // HEXEN_S_QUAKE_ACTIVE1
    {HEXEN_SPR_MAN1, 0, 1, A_ContMobjSound, HEXEN_S_QUAKE_ACTIVE3, 0, 0},   // HEXEN_S_QUAKE_ACTIVE2
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVE4, 0, 0},   // HEXEN_S_QUAKE_ACTIVE3
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVE5, 0, 0},   // HEXEN_S_QUAKE_ACTIVE4
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVE6, 0, 0},   // HEXEN_S_QUAKE_ACTIVE5
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVE7, 0, 0},   // HEXEN_S_QUAKE_ACTIVE6
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVE8, 0, 0},   // HEXEN_S_QUAKE_ACTIVE7
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVE9, 0, 0},   // HEXEN_S_QUAKE_ACTIVE8
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVE0, 0, 0},   // HEXEN_S_QUAKE_ACTIVE9
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVEA, 0, 0},   // HEXEN_S_QUAKE_ACTIVE0
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVEB, 0, 0},   // HEXEN_S_QUAKE_ACTIVEA
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVEC, 0, 0},   // HEXEN_S_QUAKE_ACTIVEB
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVED, 0, 0},   // HEXEN_S_QUAKE_ACTIVEC
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVEE, 0, 0},   // HEXEN_S_QUAKE_ACTIVED
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVEF, 0, 0},   // HEXEN_S_QUAKE_ACTIVEE
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVEG, 0, 0},   // HEXEN_S_QUAKE_ACTIVEF
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVEH, 0, 0},   // HEXEN_S_QUAKE_ACTIVEG
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVEI, 0, 0},   // HEXEN_S_QUAKE_ACTIVEH
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVEJ, 0, 0},   // HEXEN_S_QUAKE_ACTIVEI
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVEK, 0, 0},   // HEXEN_S_QUAKE_ACTIVEJ
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVEL, 0, 0},   // HEXEN_S_QUAKE_ACTIVEK
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVEM, 0, 0},   // HEXEN_S_QUAKE_ACTIVEL
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVEN, 0, 0},   // HEXEN_S_QUAKE_ACTIVEM
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVEO, 0, 0},   // HEXEN_S_QUAKE_ACTIVEN
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVEP, 0, 0},   // HEXEN_S_QUAKE_ACTIVEO
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVEQ, 0, 0},   // HEXEN_S_QUAKE_ACTIVEP
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVER, 0, 0},   // HEXEN_S_QUAKE_ACTIVEQ
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVES, 0, 0},   // HEXEN_S_QUAKE_ACTIVER
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVET, 0, 0},   // HEXEN_S_QUAKE_ACTIVES
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVEU, 0, 0},   // HEXEN_S_QUAKE_ACTIVET
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVEV, 0, 0},   // HEXEN_S_QUAKE_ACTIVEU
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVEW, 0, 0},   // HEXEN_S_QUAKE_ACTIVEV
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVEX, 0, 0},   // HEXEN_S_QUAKE_ACTIVEW
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVEY, 0, 0},   // HEXEN_S_QUAKE_ACTIVEX
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVEZ, 0, 0},   // HEXEN_S_QUAKE_ACTIVEY
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACT1, 0, 0},      // HEXEN_S_QUAKE_ACTIVEZ
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACT2, 0, 0},      // HEXEN_S_QUAKE_ACT1
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACT3, 0, 0},      // HEXEN_S_QUAKE_ACT2
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACT4, 0, 0},      // HEXEN_S_QUAKE_ACT3
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACT5, 0, 0},      // HEXEN_S_QUAKE_ACT4
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACT6, 0, 0},      // HEXEN_S_QUAKE_ACT5
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACT7, 0, 0},      // HEXEN_S_QUAKE_ACT6
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACT8, 0, 0},      // HEXEN_S_QUAKE_ACT7
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACT9, 0, 0},      // HEXEN_S_QUAKE_ACT8
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACT0, 0, 0},      // HEXEN_S_QUAKE_ACT9
    {HEXEN_SPR_MAN1, 0, 2, A_Quake, HEXEN_S_QUAKE_ACTIVE1, 0, 0},   // HEXEN_S_QUAKE_ACT0
    {HEXEN_SPR_SGSA, 0, 4, NULL, HEXEN_S_SGSHARD1_2, 0, 0}, // HEXEN_S_SGSHARD1_1
    {HEXEN_SPR_SGSA, 1, 4, NULL, HEXEN_S_SGSHARD1_3, 0, 0}, // HEXEN_S_SGSHARD1_2
    {HEXEN_SPR_SGSA, 2, 4, NULL, HEXEN_S_SGSHARD1_4, 0, 0}, // HEXEN_S_SGSHARD1_3
    {HEXEN_SPR_SGSA, 3, 4, NULL, HEXEN_S_SGSHARD1_5, 0, 0}, // HEXEN_S_SGSHARD1_4
    {HEXEN_SPR_SGSA, 4, 4, NULL, HEXEN_S_SGSHARD1_1, 0, 0}, // HEXEN_S_SGSHARD1_5
    {HEXEN_SPR_SGSA, 4, 30, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_SGSHARD1_D
    {HEXEN_SPR_SGSA, 5, 4, NULL, HEXEN_S_SGSHARD2_2, 0, 0}, // HEXEN_S_SGSHARD2_1
    {HEXEN_SPR_SGSA, 6, 4, NULL, HEXEN_S_SGSHARD2_3, 0, 0}, // HEXEN_S_SGSHARD2_2
    {HEXEN_SPR_SGSA, 7, 4, NULL, HEXEN_S_SGSHARD2_4, 0, 0}, // HEXEN_S_SGSHARD2_3
    {HEXEN_SPR_SGSA, 8, 4, NULL, HEXEN_S_SGSHARD2_5, 0, 0}, // HEXEN_S_SGSHARD2_4
    {HEXEN_SPR_SGSA, 9, 4, NULL, HEXEN_S_SGSHARD2_1, 0, 0}, // HEXEN_S_SGSHARD2_5
    {HEXEN_SPR_SGSA, 9, 30, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_SGSHARD2_D
    {HEXEN_SPR_SGSA, 10, 4, NULL, HEXEN_S_SGSHARD3_2, 0, 0},        // HEXEN_S_SGSHARD3_1
    {HEXEN_SPR_SGSA, 11, 4, NULL, HEXEN_S_SGSHARD3_3, 0, 0},        // HEXEN_S_SGSHARD3_2
    {HEXEN_SPR_SGSA, 12, 4, NULL, HEXEN_S_SGSHARD3_4, 0, 0},        // HEXEN_S_SGSHARD3_3
    {HEXEN_SPR_SGSA, 13, 4, NULL, HEXEN_S_SGSHARD3_5, 0, 0},        // HEXEN_S_SGSHARD3_4
    {HEXEN_SPR_SGSA, 14, 4, NULL, HEXEN_S_SGSHARD3_1, 0, 0},        // HEXEN_S_SGSHARD3_5
    {HEXEN_SPR_SGSA, 14, 30, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_SGSHARD3_D
    {HEXEN_SPR_SGSA, 15, 4, NULL, HEXEN_S_SGSHARD4_2, 0, 0},        // HEXEN_S_SGSHARD4_1
    {HEXEN_SPR_SGSA, 16, 4, NULL, HEXEN_S_SGSHARD4_3, 0, 0},        // HEXEN_S_SGSHARD4_2
    {HEXEN_SPR_SGSA, 17, 4, NULL, HEXEN_S_SGSHARD4_4, 0, 0},        // HEXEN_S_SGSHARD4_3
    {HEXEN_SPR_SGSA, 18, 4, NULL, HEXEN_S_SGSHARD4_5, 0, 0},        // HEXEN_S_SGSHARD4_4
    {HEXEN_SPR_SGSA, 19, 4, NULL, HEXEN_S_SGSHARD4_1, 0, 0},        // HEXEN_S_SGSHARD4_5
    {HEXEN_SPR_SGSA, 19, 30, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_SGSHARD4_D
    {HEXEN_SPR_SGSA, 20, 4, NULL, HEXEN_S_SGSHARD5_2, 0, 0},        // HEXEN_S_SGSHARD5_1
    {HEXEN_SPR_SGSA, 21, 4, NULL, HEXEN_S_SGSHARD5_3, 0, 0},        // HEXEN_S_SGSHARD5_2
    {HEXEN_SPR_SGSA, 22, 4, NULL, HEXEN_S_SGSHARD5_4, 0, 0},        // HEXEN_S_SGSHARD5_3
    {HEXEN_SPR_SGSA, 23, 4, NULL, HEXEN_S_SGSHARD5_5, 0, 0},        // HEXEN_S_SGSHARD5_4
    {HEXEN_SPR_SGSA, 24, 4, NULL, HEXEN_S_SGSHARD5_1, 0, 0},        // HEXEN_S_SGSHARD5_5
    {HEXEN_SPR_SGSA, 24, 30, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_SGSHARD5_D
    {HEXEN_SPR_SGSB, 0, 4, NULL, HEXEN_S_SGSHARD6_1, 0, 0}, // HEXEN_S_SGSHARD6_1
    {HEXEN_SPR_SGSB, 0, 30, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_SGSHARD6_D
    {HEXEN_SPR_SGSB, 1, 4, NULL, HEXEN_S_SGSHARD7_1, 0, 0}, // HEXEN_S_SGSHARD7_1
    {HEXEN_SPR_SGSB, 1, 30, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_SGSHARD7_D
    {HEXEN_SPR_SGSB, 2, 4, NULL, HEXEN_S_SGSHARD8_1, 0, 0}, // HEXEN_S_SGSHARD8_1
    {HEXEN_SPR_SGSB, 2, 30, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_SGSHARD8_D
    {HEXEN_SPR_SGSB, 3, 4, NULL, HEXEN_S_SGSHARD9_1, 0, 0}, // HEXEN_S_SGSHARD9_1
    {HEXEN_SPR_SGSB, 3, 30, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_SGSHARD9_D
    {HEXEN_SPR_SGSB, 4, 4, NULL, HEXEN_S_SGSHARD0_1, 0, 0}, // HEXEN_S_SGSHARD0_1
    {HEXEN_SPR_SGSB, 4, 30, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_SGSHARD0_D
    {HEXEN_SPR_PORK, 0, 5, NULL, HEXEN_S_ARTI_EGGC2, 0, 0}, // HEXEN_S_ARTI_EGGC1
    {HEXEN_SPR_PORK, 1, 5, NULL, HEXEN_S_ARTI_EGGC3, 0, 0}, // HEXEN_S_ARTI_EGGC2
    {HEXEN_SPR_PORK, 2, 5, NULL, HEXEN_S_ARTI_EGGC4, 0, 0}, // HEXEN_S_ARTI_EGGC3
    {HEXEN_SPR_PORK, 3, 5, NULL, HEXEN_S_ARTI_EGGC5, 0, 0}, // HEXEN_S_ARTI_EGGC4
    {HEXEN_SPR_PORK, 4, 5, NULL, HEXEN_S_ARTI_EGGC6, 0, 0}, // HEXEN_S_ARTI_EGGC5
    {HEXEN_SPR_PORK, 5, 5, NULL, HEXEN_S_ARTI_EGGC7, 0, 0}, // HEXEN_S_ARTI_EGGC6
    {HEXEN_SPR_PORK, 6, 5, NULL, HEXEN_S_ARTI_EGGC8, 0, 0}, // HEXEN_S_ARTI_EGGC7
    {HEXEN_SPR_PORK, 7, 5, NULL, HEXEN_S_ARTI_EGGC1, 0, 0}, // HEXEN_S_ARTI_EGGC8
    {HEXEN_SPR_EGGM, 0, 4, NULL, HEXEN_S_EGGFX2, 0, 0},     // HEXEN_S_EGGFX1
    {HEXEN_SPR_EGGM, 1, 4, NULL, HEXEN_S_EGGFX3, 0, 0},     // HEXEN_S_EGGFX2
    {HEXEN_SPR_EGGM, 2, 4, NULL, HEXEN_S_EGGFX4, 0, 0},     // HEXEN_S_EGGFX3
    {HEXEN_SPR_EGGM, 3, 4, NULL, HEXEN_S_EGGFX5, 0, 0},     // HEXEN_S_EGGFX4
    {HEXEN_SPR_EGGM, 4, 4, NULL, HEXEN_S_EGGFX1, 0, 0},     // HEXEN_S_EGGFX5
    {HEXEN_SPR_FHFX, 32776, 3, NULL, HEXEN_S_EGGFXI1_2, 0, 0},      // HEXEN_S_EGGFXI1_1
    {HEXEN_SPR_FHFX, 32777, 3, NULL, HEXEN_S_EGGFXI1_3, 0, 0},      // HEXEN_S_EGGFXI1_2
    {HEXEN_SPR_FHFX, 32778, 3, NULL, HEXEN_S_EGGFXI1_4, 0, 0},      // HEXEN_S_EGGFXI1_3
    {HEXEN_SPR_FHFX, 32779, 3, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_EGGFXI1_4
    {HEXEN_SPR_SPHL, 0, 350, NULL, HEXEN_S_ARTI_SPHL1, 0, 0},       // HEXEN_S_ARTI_SPHL1
    {HEXEN_SPR_STWN, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZWINGEDSTATUENOSKULL
    {HEXEN_SPR_STWN, 1, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZWINGEDSTATUENOSKULL2
    {HEXEN_SPR_GMPD, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZGEMPEDESTAL1
    {HEXEN_SPR_GMPD, 1, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZGEMPEDESTAL2
    {HEXEN_SPR_ASKU, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ARTIPUZZSKULL
    {HEXEN_SPR_ABGM, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ARTIPUZZGEMBIG
    {HEXEN_SPR_AGMR, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ARTIPUZZGEMRED
    {HEXEN_SPR_AGMG, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ARTIPUZZGEMGREEN1
    {HEXEN_SPR_AGG2, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ARTIPUZZGEMGREEN2
    {HEXEN_SPR_AGMB, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ARTIPUZZGEMBLUE1
    {HEXEN_SPR_AGB2, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ARTIPUZZGEMBLUE2
    {HEXEN_SPR_ABK1, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ARTIPUZZBOOK1
    {HEXEN_SPR_ABK2, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ARTIPUZZBOOK2
    {HEXEN_SPR_ASK2, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ARTIPUZZSKULL2
    {HEXEN_SPR_AFWP, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ARTIPUZZFWEAPON
    {HEXEN_SPR_ACWP, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ARTIPUZZCWEAPON
    {HEXEN_SPR_AMWP, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ARTIPUZZMWEAPON
    {HEXEN_SPR_AGER, 32768, 4, NULL, HEXEN_S_ARTIPUZZGEAR_2, 0, 0}, // HEXEN_S_ARTIPUZZGEAR_1
    {HEXEN_SPR_AGER, 32769, 4, NULL, HEXEN_S_ARTIPUZZGEAR_3, 0, 0}, // HEXEN_S_ARTIPUZZGEAR_2
    {HEXEN_SPR_AGER, 32770, 4, NULL, HEXEN_S_ARTIPUZZGEAR_4, 0, 0}, // HEXEN_S_ARTIPUZZGEAR_3
    {HEXEN_SPR_AGER, 32771, 4, NULL, HEXEN_S_ARTIPUZZGEAR_5, 0, 0}, // HEXEN_S_ARTIPUZZGEAR_4
    {HEXEN_SPR_AGER, 32772, 4, NULL, HEXEN_S_ARTIPUZZGEAR_6, 0, 0}, // HEXEN_S_ARTIPUZZGEAR_5
    {HEXEN_SPR_AGER, 32773, 4, NULL, HEXEN_S_ARTIPUZZGEAR_7, 0, 0}, // HEXEN_S_ARTIPUZZGEAR_6
    {HEXEN_SPR_AGER, 32774, 4, NULL, HEXEN_S_ARTIPUZZGEAR_8, 0, 0}, // HEXEN_S_ARTIPUZZGEAR_7
    {HEXEN_SPR_AGER, 32775, 4, NULL, HEXEN_S_ARTIPUZZGEAR_1, 0, 0}, // HEXEN_S_ARTIPUZZGEAR_8
    {HEXEN_SPR_AGR2, 32768, 4, NULL, HEXEN_S_ARTIPUZZGEAR2_2, 0, 0},        // HEXEN_S_ARTIPUZZGEAR2_1
    {HEXEN_SPR_AGR2, 32769, 4, NULL, HEXEN_S_ARTIPUZZGEAR2_3, 0, 0},        // HEXEN_S_ARTIPUZZGEAR2_2
    {HEXEN_SPR_AGR2, 32770, 4, NULL, HEXEN_S_ARTIPUZZGEAR2_4, 0, 0},        // HEXEN_S_ARTIPUZZGEAR2_3
    {HEXEN_SPR_AGR2, 32771, 4, NULL, HEXEN_S_ARTIPUZZGEAR2_5, 0, 0},        // HEXEN_S_ARTIPUZZGEAR2_4
    {HEXEN_SPR_AGR2, 32772, 4, NULL, HEXEN_S_ARTIPUZZGEAR2_6, 0, 0},        // HEXEN_S_ARTIPUZZGEAR2_5
    {HEXEN_SPR_AGR2, 32773, 4, NULL, HEXEN_S_ARTIPUZZGEAR2_7, 0, 0},        // HEXEN_S_ARTIPUZZGEAR2_6
    {HEXEN_SPR_AGR2, 32774, 4, NULL, HEXEN_S_ARTIPUZZGEAR2_8, 0, 0},        // HEXEN_S_ARTIPUZZGEAR2_7
    {HEXEN_SPR_AGR2, 32775, 4, NULL, HEXEN_S_ARTIPUZZGEAR2_1, 0, 0},        // HEXEN_S_ARTIPUZZGEAR2_8
    {HEXEN_SPR_AGR3, 32768, 4, NULL, HEXEN_S_ARTIPUZZGEAR3_2, 0, 0},        // HEXEN_S_ARTIPUZZGEAR3_1
    {HEXEN_SPR_AGR3, 32769, 4, NULL, HEXEN_S_ARTIPUZZGEAR3_3, 0, 0},        // HEXEN_S_ARTIPUZZGEAR3_2
    {HEXEN_SPR_AGR3, 32770, 4, NULL, HEXEN_S_ARTIPUZZGEAR3_4, 0, 0},        // HEXEN_S_ARTIPUZZGEAR3_3
    {HEXEN_SPR_AGR3, 32771, 4, NULL, HEXEN_S_ARTIPUZZGEAR3_5, 0, 0},        // HEXEN_S_ARTIPUZZGEAR3_4
    {HEXEN_SPR_AGR3, 32772, 4, NULL, HEXEN_S_ARTIPUZZGEAR3_6, 0, 0},        // HEXEN_S_ARTIPUZZGEAR3_5
    {HEXEN_SPR_AGR3, 32773, 4, NULL, HEXEN_S_ARTIPUZZGEAR3_7, 0, 0},        // HEXEN_S_ARTIPUZZGEAR3_6
    {HEXEN_SPR_AGR3, 32774, 4, NULL, HEXEN_S_ARTIPUZZGEAR3_8, 0, 0},        // HEXEN_S_ARTIPUZZGEAR3_7
    {HEXEN_SPR_AGR3, 32775, 4, NULL, HEXEN_S_ARTIPUZZGEAR3_1, 0, 0},        // HEXEN_S_ARTIPUZZGEAR3_8
    {HEXEN_SPR_AGR4, 32768, 4, NULL, HEXEN_S_ARTIPUZZGEAR4_2, 0, 0},        // HEXEN_S_ARTIPUZZGEAR4_1
    {HEXEN_SPR_AGR4, 32769, 4, NULL, HEXEN_S_ARTIPUZZGEAR4_3, 0, 0},        // HEXEN_S_ARTIPUZZGEAR4_2
    {HEXEN_SPR_AGR4, 32770, 4, NULL, HEXEN_S_ARTIPUZZGEAR4_4, 0, 0},        // HEXEN_S_ARTIPUZZGEAR4_3
    {HEXEN_SPR_AGR4, 32771, 4, NULL, HEXEN_S_ARTIPUZZGEAR4_5, 0, 0},        // HEXEN_S_ARTIPUZZGEAR4_4
    {HEXEN_SPR_AGR4, 32772, 4, NULL, HEXEN_S_ARTIPUZZGEAR4_6, 0, 0},        // HEXEN_S_ARTIPUZZGEAR4_5
    {HEXEN_SPR_AGR4, 32773, 4, NULL, HEXEN_S_ARTIPUZZGEAR4_7, 0, 0},        // HEXEN_S_ARTIPUZZGEAR4_6
    {HEXEN_SPR_AGR4, 32774, 4, NULL, HEXEN_S_ARTIPUZZGEAR4_8, 0, 0},        // HEXEN_S_ARTIPUZZGEAR4_7
    {HEXEN_SPR_AGR4, 32775, 4, NULL, HEXEN_S_ARTIPUZZGEAR4_1, 0, 0},        // HEXEN_S_ARTIPUZZGEAR4_8
    {HEXEN_SPR_TRCH, 32768, 3, NULL, HEXEN_S_ARTI_TRCH2, 0, 0},     // HEXEN_S_ARTI_TRCH1
    {HEXEN_SPR_TRCH, 32769, 3, NULL, HEXEN_S_ARTI_TRCH3, 0, 0},     // HEXEN_S_ARTI_TRCH2
    {HEXEN_SPR_TRCH, 32770, 3, NULL, HEXEN_S_ARTI_TRCH1, 0, 0},     // HEXEN_S_ARTI_TRCH3
    {HEXEN_SPR_PSBG, 0, 20, NULL, HEXEN_S_FIREBOMB2, 0, 0}, // HEXEN_S_FIREBOMB1
    {HEXEN_SPR_PSBG, 0, 10, NULL, HEXEN_S_FIREBOMB3, 0, 0}, // HEXEN_S_FIREBOMB2
    {HEXEN_SPR_PSBG, 0, 10, NULL, HEXEN_S_FIREBOMB4, 0, 0}, // HEXEN_S_FIREBOMB3
    {HEXEN_SPR_PSBG, 1, 4, NULL, HEXEN_S_FIREBOMB5, 0, 0},  // HEXEN_S_FIREBOMB4
    {HEXEN_SPR_PSBG, 2, 4, A_Scream, HEXEN_S_FIREBOMB6, 0, 0},      // HEXEN_S_FIREBOMB5
    {HEXEN_SPR_XPL1, 32768, 4, A_Explode, HEXEN_S_FIREBOMB7, 0, 0}, // HEXEN_S_FIREBOMB6
    {HEXEN_SPR_XPL1, 32769, 4, NULL, HEXEN_S_FIREBOMB8, 0, 0},      // HEXEN_S_FIREBOMB7
    {HEXEN_SPR_XPL1, 32770, 4, NULL, HEXEN_S_FIREBOMB9, 0, 0},      // HEXEN_S_FIREBOMB8
    {HEXEN_SPR_XPL1, 32771, 4, NULL, HEXEN_S_FIREBOMB10, 0, 0},     // HEXEN_S_FIREBOMB9
    {HEXEN_SPR_XPL1, 32772, 4, NULL, HEXEN_S_FIREBOMB11, 0, 0},     // HEXEN_S_FIREBOMB10
    {HEXEN_SPR_XPL1, 32773, 4, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_FIREBOMB11
    {HEXEN_SPR_ATLP, 0, 4, NULL, HEXEN_S_ARTI_ATLP2, 0, 0}, // HEXEN_S_ARTI_ATLP1
    {HEXEN_SPR_ATLP, 1, 4, NULL, HEXEN_S_ARTI_ATLP3, 0, 0}, // HEXEN_S_ARTI_ATLP2
    {HEXEN_SPR_ATLP, 2, 4, NULL, HEXEN_S_ARTI_ATLP4, 0, 0}, // HEXEN_S_ARTI_ATLP3
    {HEXEN_SPR_ATLP, 1, 4, NULL, HEXEN_S_ARTI_ATLP1, 0, 0}, // HEXEN_S_ARTI_ATLP4
    {HEXEN_SPR_PSBG, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ARTI_PSBG1
    {HEXEN_SPR_PSBG, 32768, 18, NULL, HEXEN_S_POISONBAG2, 0, 0},    // HEXEN_S_POISONBAG1
    {HEXEN_SPR_PSBG, 32769, 4, NULL, HEXEN_S_POISONBAG3, 0, 0},     // HEXEN_S_POISONBAG2
    {HEXEN_SPR_PSBG, 2, 3, NULL, HEXEN_S_POISONBAG4, 0, 0}, // HEXEN_S_POISONBAG3
    {HEXEN_SPR_PSBG, 2, 1, A_PoisonBagInit, HEXEN_S_NULL, 0, 0},    // HEXEN_S_POISONBAG4
    {HEXEN_SPR_PSBG, 3, 1, NULL, HEXEN_S_POISONCLOUD2, 0, 0},       // HEXEN_S_POISONCLOUD1
    {HEXEN_SPR_PSBG, 3, 1, A_Scream, HEXEN_S_POISONCLOUD3, 0, 0},   // HEXEN_S_POISONCLOUD2
    {HEXEN_SPR_PSBG, 3, 2, A_PoisonBagDamage, HEXEN_S_POISONCLOUD4, 0, 0},  // HEXEN_S_POISONCLOUD3
    {HEXEN_SPR_PSBG, 4, 2, A_PoisonBagDamage, HEXEN_S_POISONCLOUD5, 0, 0},  // HEXEN_S_POISONCLOUD4
    {HEXEN_SPR_PSBG, 4, 2, A_PoisonBagDamage, HEXEN_S_POISONCLOUD6, 0, 0},  // HEXEN_S_POISONCLOUD5
    {HEXEN_SPR_PSBG, 4, 2, A_PoisonBagDamage, HEXEN_S_POISONCLOUD7, 0, 0},  // HEXEN_S_POISONCLOUD6
    {HEXEN_SPR_PSBG, 5, 2, A_PoisonBagDamage, HEXEN_S_POISONCLOUD8, 0, 0},  // HEXEN_S_POISONCLOUD7
    {HEXEN_SPR_PSBG, 5, 2, A_PoisonBagDamage, HEXEN_S_POISONCLOUD9, 0, 0},  // HEXEN_S_POISONCLOUD8
    {HEXEN_SPR_PSBG, 5, 2, A_PoisonBagDamage, HEXEN_S_POISONCLOUD10, 0, 0}, // HEXEN_S_POISONCLOUD9
    {HEXEN_SPR_PSBG, 6, 2, A_PoisonBagDamage, HEXEN_S_POISONCLOUD11, 0, 0}, // HEXEN_S_POISONCLOUD10
    {HEXEN_SPR_PSBG, 6, 2, A_PoisonBagDamage, HEXEN_S_POISONCLOUD12, 0, 0}, // HEXEN_S_POISONCLOUD11
    {HEXEN_SPR_PSBG, 6, 2, A_PoisonBagDamage, HEXEN_S_POISONCLOUD13, 0, 0}, // HEXEN_S_POISONCLOUD12
    {HEXEN_SPR_PSBG, 7, 2, A_PoisonBagDamage, HEXEN_S_POISONCLOUD14, 0, 0}, // HEXEN_S_POISONCLOUD13
    {HEXEN_SPR_PSBG, 7, 2, A_PoisonBagDamage, HEXEN_S_POISONCLOUD15, 0, 0}, // HEXEN_S_POISONCLOUD14
    {HEXEN_SPR_PSBG, 7, 2, A_PoisonBagDamage, HEXEN_S_POISONCLOUD16, 0, 0}, // HEXEN_S_POISONCLOUD15
    {HEXEN_SPR_PSBG, 8, 2, A_PoisonBagDamage, HEXEN_S_POISONCLOUD17, 0, 0}, // HEXEN_S_POISONCLOUD16
    {HEXEN_SPR_PSBG, 8, 1, A_PoisonBagDamage, HEXEN_S_POISONCLOUD18, 0, 0}, // HEXEN_S_POISONCLOUD17
    {HEXEN_SPR_PSBG, 8, 1, A_PoisonBagCheck, HEXEN_S_POISONCLOUD4, 0, 0},   // HEXEN_S_POISONCLOUD18
    {HEXEN_SPR_PSBG, 7, 7, NULL, HEXEN_S_POISONCLOUD_X2, 0, 0},     // HEXEN_S_POISONCLOUD_X1
    {HEXEN_SPR_PSBG, 6, 7, NULL, HEXEN_S_POISONCLOUD_X3, 0, 0},     // HEXEN_S_POISONCLOUD_X2
    {HEXEN_SPR_PSBG, 5, 6, NULL, HEXEN_S_POISONCLOUD_X4, 0, 0},     // HEXEN_S_POISONCLOUD_X3
    {HEXEN_SPR_PSBG, 3, 6, NULL, HEXEN_S_NULL, 0, 0},       // HEXEN_S_POISONCLOUD_X4
    {HEXEN_SPR_THRW, 0, 4, A_CheckThrowBomb, HEXEN_S_THROWINGBOMB2, 0, 0},  // HEXEN_S_THROWINGBOMB1
    {HEXEN_SPR_THRW, 1, 3, A_CheckThrowBomb, HEXEN_S_THROWINGBOMB3, 0, 0},  // HEXEN_S_THROWINGBOMB2
    {HEXEN_SPR_THRW, 2, 3, A_CheckThrowBomb, HEXEN_S_THROWINGBOMB4, 0, 0},  // HEXEN_S_THROWINGBOMB3
    {HEXEN_SPR_THRW, 3, 3, A_CheckThrowBomb, HEXEN_S_THROWINGBOMB5, 0, 0},  // HEXEN_S_THROWINGBOMB4
    {HEXEN_SPR_THRW, 4, 3, A_CheckThrowBomb, HEXEN_S_THROWINGBOMB6, 0, 0},  // HEXEN_S_THROWINGBOMB5
    {HEXEN_SPR_THRW, 5, 3, A_CheckThrowBomb, HEXEN_S_THROWINGBOMB1, 0, 0},  // HEXEN_S_THROWINGBOMB6
    {HEXEN_SPR_THRW, 6, 6, A_CheckThrowBomb, HEXEN_S_THROWINGBOMB8, 0, 0},  // HEXEN_S_THROWINGBOMB7
    {HEXEN_SPR_THRW, 5, 4, A_CheckThrowBomb, HEXEN_S_THROWINGBOMB9, 0, 0},  // HEXEN_S_THROWINGBOMB8
    {HEXEN_SPR_THRW, 7, 6, A_CheckThrowBomb, HEXEN_S_THROWINGBOMB10, 0, 0}, // HEXEN_S_THROWINGBOMB9
    {HEXEN_SPR_THRW, 5, 4, A_CheckThrowBomb, HEXEN_S_THROWINGBOMB11, 0, 0}, // HEXEN_S_THROWINGBOMB10
    {HEXEN_SPR_THRW, 6, 6, A_CheckThrowBomb, HEXEN_S_THROWINGBOMB12, 0, 0}, // HEXEN_S_THROWINGBOMB11
    {HEXEN_SPR_THRW, 5, 3, A_CheckThrowBomb, HEXEN_S_THROWINGBOMB12, 0, 0}, // HEXEN_S_THROWINGBOMB12
    {HEXEN_SPR_CFCF, 32784, 4, A_NoGravity, HEXEN_S_THROWINGBOMB_X2, 0, 0}, // HEXEN_S_THROWINGBOMB_X1
    {HEXEN_SPR_CFCF, 32785, 3, A_Scream, HEXEN_S_THROWINGBOMB_X3, 0, 0},    // HEXEN_S_THROWINGBOMB_X2
    {HEXEN_SPR_CFCF, 32786, 4, A_Explode, HEXEN_S_THROWINGBOMB_X4, 0, 0},   // HEXEN_S_THROWINGBOMB_X3
    {HEXEN_SPR_CFCF, 32787, 3, NULL, HEXEN_S_THROWINGBOMB_X5, 0, 0},        // HEXEN_S_THROWINGBOMB_X4
    {HEXEN_SPR_CFCF, 32788, 4, NULL, HEXEN_S_THROWINGBOMB_X6, 0, 0},        // HEXEN_S_THROWINGBOMB_X5
    {HEXEN_SPR_CFCF, 32790, 3, NULL, HEXEN_S_THROWINGBOMB_X7, 0, 0},        // HEXEN_S_THROWINGBOMB_X6
    {HEXEN_SPR_CFCF, 32791, 4, NULL, HEXEN_S_THROWINGBOMB_X8, 0, 0},        // HEXEN_S_THROWINGBOMB_X7
    {HEXEN_SPR_CFCF, 32793, 3, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_THROWINGBOMB_X8
    {HEXEN_SPR_SPED, 32768, 3, NULL, HEXEN_S_ARTI_BOOTS2, 0, 0},    // HEXEN_S_ARTI_BOOTS1
    {HEXEN_SPR_SPED, 32769, 3, NULL, HEXEN_S_ARTI_BOOTS3, 0, 0},    // HEXEN_S_ARTI_BOOTS2
    {HEXEN_SPR_SPED, 32770, 3, NULL, HEXEN_S_ARTI_BOOTS4, 0, 0},    // HEXEN_S_ARTI_BOOTS3
    {HEXEN_SPR_SPED, 32771, 3, NULL, HEXEN_S_ARTI_BOOTS5, 0, 0},    // HEXEN_S_ARTI_BOOTS4
    {HEXEN_SPR_SPED, 32772, 3, NULL, HEXEN_S_ARTI_BOOTS6, 0, 0},    // HEXEN_S_ARTI_BOOTS5
    {HEXEN_SPR_SPED, 32773, 3, NULL, HEXEN_S_ARTI_BOOTS7, 0, 0},    // HEXEN_S_ARTI_BOOTS6
    {HEXEN_SPR_SPED, 32774, 3, NULL, HEXEN_S_ARTI_BOOTS8, 0, 0},    // HEXEN_S_ARTI_BOOTS7
    {HEXEN_SPR_SPED, 32775, 3, NULL, HEXEN_S_ARTI_BOOTS1, 0, 0},    // HEXEN_S_ARTI_BOOTS8
    {HEXEN_SPR_BMAN, 32768, -1, NULL, HEXEN_S_NULL, 0, 0},  // HEXEN_S_ARTI_MANA
    {HEXEN_SPR_BRAC, 32768, 4, NULL, HEXEN_S_ARTI_ARMOR2, 0, 0},    // HEXEN_S_ARTI_ARMOR1
    {HEXEN_SPR_BRAC, 32769, 4, NULL, HEXEN_S_ARTI_ARMOR3, 0, 0},    // HEXEN_S_ARTI_ARMOR2
    {HEXEN_SPR_BRAC, 32770, 4, NULL, HEXEN_S_ARTI_ARMOR4, 0, 0},    // HEXEN_S_ARTI_ARMOR3
    {HEXEN_SPR_BRAC, 32771, 4, NULL, HEXEN_S_ARTI_ARMOR5, 0, 0},    // HEXEN_S_ARTI_ARMOR4
    {HEXEN_SPR_BRAC, 32772, 4, NULL, HEXEN_S_ARTI_ARMOR6, 0, 0},    // HEXEN_S_ARTI_ARMOR5
    {HEXEN_SPR_BRAC, 32773, 4, NULL, HEXEN_S_ARTI_ARMOR7, 0, 0},    // HEXEN_S_ARTI_ARMOR6
    {HEXEN_SPR_BRAC, 32774, 4, NULL, HEXEN_S_ARTI_ARMOR8, 0, 0},    // HEXEN_S_ARTI_ARMOR7
    {HEXEN_SPR_BRAC, 32775, 4, NULL, HEXEN_S_ARTI_ARMOR1, 0, 0},    // HEXEN_S_ARTI_ARMOR8
    {HEXEN_SPR_BLST, 32768, 4, NULL, HEXEN_S_ARTI_BLAST2, 0, 0},    // HEXEN_S_ARTI_BLAST1
    {HEXEN_SPR_BLST, 32769, 4, NULL, HEXEN_S_ARTI_BLAST3, 0, 0},    // HEXEN_S_ARTI_BLAST2
    {HEXEN_SPR_BLST, 32770, 4, NULL, HEXEN_S_ARTI_BLAST4, 0, 0},    // HEXEN_S_ARTI_BLAST3
    {HEXEN_SPR_BLST, 32771, 4, NULL, HEXEN_S_ARTI_BLAST5, 0, 0},    // HEXEN_S_ARTI_BLAST4
    {HEXEN_SPR_BLST, 32772, 4, NULL, HEXEN_S_ARTI_BLAST6, 0, 0},    // HEXEN_S_ARTI_BLAST5
    {HEXEN_SPR_BLST, 32773, 4, NULL, HEXEN_S_ARTI_BLAST7, 0, 0},    // HEXEN_S_ARTI_BLAST6
    {HEXEN_SPR_BLST, 32774, 4, NULL, HEXEN_S_ARTI_BLAST8, 0, 0},    // HEXEN_S_ARTI_BLAST7
    {HEXEN_SPR_BLST, 32775, 4, NULL, HEXEN_S_ARTI_BLAST1, 0, 0},    // HEXEN_S_ARTI_BLAST8
    {HEXEN_SPR_HRAD, 32768, 4, NULL, HEXEN_S_ARTI_HEALRAD2, 0, 0},  // HEXEN_S_ARTI_HEALRAD1
    {HEXEN_SPR_HRAD, 32769, 4, NULL, HEXEN_S_ARTI_HEALRAD3, 0, 0},  // HEXEN_S_ARTI_HEALRAD2
    {HEXEN_SPR_HRAD, 32770, 4, NULL, HEXEN_S_ARTI_HEALRAD4, 0, 0},  // HEXEN_S_ARTI_HEALRAD3
    {HEXEN_SPR_HRAD, 32771, 4, NULL, HEXEN_S_ARTI_HEALRAD5, 0, 0},  // HEXEN_S_ARTI_HEALRAD4
    {HEXEN_SPR_HRAD, 32772, 4, NULL, HEXEN_S_ARTI_HEALRAD6, 0, 0},  // HEXEN_S_ARTI_HEALRAD5
    {HEXEN_SPR_HRAD, 32773, 4, NULL, HEXEN_S_ARTI_HEALRAD7, 0, 0},  // HEXEN_S_ARTI_HEALRAD6
    {HEXEN_SPR_HRAD, 32774, 4, NULL, HEXEN_S_ARTI_HEALRAD8, 0, 0},  // HEXEN_S_ARTI_HEALRAD7
    {HEXEN_SPR_HRAD, 32775, 4, NULL, HEXEN_S_ARTI_HEALRAD9, 0, 0},  // HEXEN_S_ARTI_HEALRAD8
    {HEXEN_SPR_HRAD, 32776, 4, NULL, HEXEN_S_ARTI_HEALRAD0, 0, 0},  // HEXEN_S_ARTI_HEALRAD9
    {HEXEN_SPR_HRAD, 32777, 4, NULL, HEXEN_S_ARTI_HEALRADA, 0, 0},  // HEXEN_S_ARTI_HEALRAD0
    {HEXEN_SPR_HRAD, 32778, 4, NULL, HEXEN_S_ARTI_HEALRADB, 0, 0},  // HEXEN_S_ARTI_HEALRADA
    {HEXEN_SPR_HRAD, 32779, 4, NULL, HEXEN_S_ARTI_HEALRADC, 0, 0},  // HEXEN_S_ARTI_HEALRADB
    {HEXEN_SPR_HRAD, 32780, 4, NULL, HEXEN_S_ARTI_HEALRADD, 0, 0},  // HEXEN_S_ARTI_HEALRADC
    {HEXEN_SPR_HRAD, 32781, 4, NULL, HEXEN_S_ARTI_HEALRADE, 0, 0},  // HEXEN_S_ARTI_HEALRADD
    {HEXEN_SPR_HRAD, 32782, 4, NULL, HEXEN_S_ARTI_HEALRADF, 0, 0},  // HEXEN_S_ARTI_HEALRADE
    {HEXEN_SPR_HRAD, 32783, 4, NULL, HEXEN_S_ARTI_HEALRAD1, 0, 0},  // HEXEN_S_ARTI_HEALRADF
    {HEXEN_SPR_SPSH, 0, 8, NULL, HEXEN_S_SPLASH2, 0, 0},    // HEXEN_S_SPLASH1
    {HEXEN_SPR_SPSH, 1, 8, NULL, HEXEN_S_SPLASH3, 0, 0},    // HEXEN_S_SPLASH2
    {HEXEN_SPR_SPSH, 2, 8, NULL, HEXEN_S_SPLASH4, 0, 0},    // HEXEN_S_SPLASH3
    {HEXEN_SPR_SPSH, 3, 16, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_SPLASH4
    {HEXEN_SPR_SPSH, 3, 10, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_SPLASHX
    {HEXEN_SPR_SPSH, 4, 5, NULL, HEXEN_S_SPLASHBASE2, 0, 0},        // HEXEN_S_SPLASHBASE1
    {HEXEN_SPR_SPSH, 5, 5, NULL, HEXEN_S_SPLASHBASE3, 0, 0},        // HEXEN_S_SPLASHBASE2
    {HEXEN_SPR_SPSH, 6, 5, NULL, HEXEN_S_SPLASHBASE4, 0, 0},        // HEXEN_S_SPLASHBASE3
    {HEXEN_SPR_SPSH, 7, 5, NULL, HEXEN_S_SPLASHBASE5, 0, 0},        // HEXEN_S_SPLASHBASE4
    {HEXEN_SPR_SPSH, 8, 5, NULL, HEXEN_S_SPLASHBASE6, 0, 0},        // HEXEN_S_SPLASHBASE5
    {HEXEN_SPR_SPSH, 9, 5, NULL, HEXEN_S_SPLASHBASE7, 0, 0},        // HEXEN_S_SPLASHBASE6
    {HEXEN_SPR_SPSH, 10, 5, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_SPLASHBASE7
    {HEXEN_SPR_LVAS, 32768, 5, NULL, HEXEN_S_LAVASPLASH2, 0, 0},    // HEXEN_S_LAVASPLASH1
    {HEXEN_SPR_LVAS, 32769, 5, NULL, HEXEN_S_LAVASPLASH3, 0, 0},    // HEXEN_S_LAVASPLASH2
    {HEXEN_SPR_LVAS, 32770, 5, NULL, HEXEN_S_LAVASPLASH4, 0, 0},    // HEXEN_S_LAVASPLASH3
    {HEXEN_SPR_LVAS, 32771, 5, NULL, HEXEN_S_LAVASPLASH5, 0, 0},    // HEXEN_S_LAVASPLASH4
    {HEXEN_SPR_LVAS, 32772, 5, NULL, HEXEN_S_LAVASPLASH6, 0, 0},    // HEXEN_S_LAVASPLASH5
    {HEXEN_SPR_LVAS, 32773, 5, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_LAVASPLASH6
    {HEXEN_SPR_LVAS, 32774, 5, NULL, HEXEN_S_LAVASMOKE2, 0, 0},     // HEXEN_S_LAVASMOKE1
    {HEXEN_SPR_LVAS, 32775, 5, NULL, HEXEN_S_LAVASMOKE3, 0, 0},     // HEXEN_S_LAVASMOKE2
    {HEXEN_SPR_LVAS, 32776, 5, NULL, HEXEN_S_LAVASMOKE4, 0, 0},     // HEXEN_S_LAVASMOKE3
    {HEXEN_SPR_LVAS, 32777, 5, NULL, HEXEN_S_LAVASMOKE5, 0, 0},     // HEXEN_S_LAVASMOKE4
    {HEXEN_SPR_LVAS, 32778, 5, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_LAVASMOKE5
    {HEXEN_SPR_SLDG, 0, 8, NULL, HEXEN_S_SLUDGECHUNK2, 0, 0},       // HEXEN_S_SLUDGECHUNK1
    {HEXEN_SPR_SLDG, 1, 8, NULL, HEXEN_S_SLUDGECHUNK3, 0, 0},       // HEXEN_S_SLUDGECHUNK2
    {HEXEN_SPR_SLDG, 2, 8, NULL, HEXEN_S_SLUDGECHUNK4, 0, 0},       // HEXEN_S_SLUDGECHUNK3
    {HEXEN_SPR_SLDG, 3, 8, NULL, HEXEN_S_NULL, 0, 0},       // HEXEN_S_SLUDGECHUNK4
    {HEXEN_SPR_SLDG, 3, 6, NULL, HEXEN_S_NULL, 0, 0},       // HEXEN_S_SLUDGECHUNKX
    {HEXEN_SPR_SLDG, 4, 6, NULL, HEXEN_S_SLUDGESPLASH2, 0, 0},      // HEXEN_S_SLUDGESPLASH1
    {HEXEN_SPR_SLDG, 5, 6, NULL, HEXEN_S_SLUDGESPLASH3, 0, 0},      // HEXEN_S_SLUDGESPLASH2
    {HEXEN_SPR_SLDG, 6, 6, NULL, HEXEN_S_SLUDGESPLASH4, 0, 0},      // HEXEN_S_SLUDGESPLASH3
    {HEXEN_SPR_SLDG, 7, 6, NULL, HEXEN_S_NULL, 0, 0},       // HEXEN_S_SLUDGESPLASH4
    {HEXEN_SPR_STTW, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZWINGEDSTATUE1
    {HEXEN_SPR_RCK1, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZROCK1_1
    {HEXEN_SPR_RCK2, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZROCK2_1
    {HEXEN_SPR_RCK3, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZROCK3_1
    {HEXEN_SPR_RCK4, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZROCK4_1
    {HEXEN_SPR_CDLR, 0, 4, NULL, HEXEN_S_ZCHANDELIER2, 0, 0},       // HEXEN_S_ZCHANDELIER1
    {HEXEN_SPR_CDLR, 1, 4, NULL, HEXEN_S_ZCHANDELIER3, 0, 0},       // HEXEN_S_ZCHANDELIER2
    {HEXEN_SPR_CDLR, 2, 4, NULL, HEXEN_S_ZCHANDELIER1, 0, 0},       // HEXEN_S_ZCHANDELIER3
    {HEXEN_SPR_CDLR, 3, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZCHANDELIER_U
    {HEXEN_SPR_TRE1, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZTREEDEAD1
    {HEXEN_SPR_TRE1, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZTREE
    {HEXEN_SPR_TRDT, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZTREEDESTRUCTIBLE1
    {HEXEN_SPR_TRDT, 1, 5, NULL, HEXEN_S_ZTREEDES_D2, 0, 0},        // HEXEN_S_ZTREEDES_D1
    {HEXEN_SPR_TRDT, 2, 5, A_Scream, HEXEN_S_ZTREEDES_D3, 0, 0},    // HEXEN_S_ZTREEDES_D2
    {HEXEN_SPR_TRDT, 3, 5, NULL, HEXEN_S_ZTREEDES_D4, 0, 0},        // HEXEN_S_ZTREEDES_D3
    {HEXEN_SPR_TRDT, 4, 5, NULL, HEXEN_S_ZTREEDES_D5, 0, 0},        // HEXEN_S_ZTREEDES_D4
    {HEXEN_SPR_TRDT, 5, 5, NULL, HEXEN_S_ZTREEDES_D6, 0, 0},        // HEXEN_S_ZTREEDES_D5
    {HEXEN_SPR_TRDT, 6, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZTREEDES_D6
    {HEXEN_SPR_TRDT, 32775, 5, NULL, HEXEN_S_ZTREEDES_X2, 0, 0},    // HEXEN_S_ZTREEDES_X1
    {HEXEN_SPR_TRDT, 32776, 5, NULL, HEXEN_S_ZTREEDES_X3, 0, 0},    // HEXEN_S_ZTREEDES_X2
    {HEXEN_SPR_TRDT, 32777, 5, NULL, HEXEN_S_ZTREEDES_X4, 0, 0},    // HEXEN_S_ZTREEDES_X3
    {HEXEN_SPR_TRDT, 32778, 5, NULL, HEXEN_S_ZTREEDES_X5, 0, 0},    // HEXEN_S_ZTREEDES_X4
    {HEXEN_SPR_TRDT, 32779, 5, NULL, HEXEN_S_ZTREEDES_X6, 0, 0},    // HEXEN_S_ZTREEDES_X5
    {HEXEN_SPR_TRDT, 32780, 5, A_Explode, HEXEN_S_ZTREEDES_X7, 0, 0},       // HEXEN_S_ZTREEDES_X6
    {HEXEN_SPR_TRDT, 32781, 5, NULL, HEXEN_S_ZTREEDES_X8, 0, 0},    // HEXEN_S_ZTREEDES_X7
    {HEXEN_SPR_TRDT, 14, 5, NULL, HEXEN_S_ZTREEDES_X9, 0, 0},       // HEXEN_S_ZTREEDES_X8
    {HEXEN_SPR_TRDT, 15, 5, NULL, HEXEN_S_ZTREEDES_X10, 0, 0},      // HEXEN_S_ZTREEDES_X9
    {HEXEN_SPR_TRDT, 16, -1, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_ZTREEDES_X10
    {HEXEN_SPR_TRE2, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZTREESWAMP182_1
    {HEXEN_SPR_TRE3, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZTREESWAMP172_1
    {HEXEN_SPR_STM1, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTUMPBURNED1
    {HEXEN_SPR_STM2, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTUMPBARE1
    {HEXEN_SPR_STM3, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTUMPSWAMP1_1
    {HEXEN_SPR_STM4, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTUMPSWAMP2_1
    {HEXEN_SPR_MSH1, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSHROOMLARGE1_1
    {HEXEN_SPR_MSH2, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSHROOMLARGE2_1
    {HEXEN_SPR_MSH3, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSHROOMLARGE3_1
    {HEXEN_SPR_MSH4, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSHROOMSMALL1_1
    {HEXEN_SPR_MSH5, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSHROOMSMALL2_1
    {HEXEN_SPR_MSH6, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSHROOMSMALL3_1
    {HEXEN_SPR_MSH7, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSHROOMSMALL4_1
    {HEXEN_SPR_MSH8, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSHROOMSMALL5_1
    {HEXEN_SPR_SGMP, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTALAGMITEPILLAR1
    {HEXEN_SPR_SGM1, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTALAGMITELARGE1
    {HEXEN_SPR_SGM2, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTALAGMITEMEDIUM1
    {HEXEN_SPR_SGM3, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTALAGMITESMALL1
    {HEXEN_SPR_SLC1, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTALACTITELARGE1
    {HEXEN_SPR_SLC2, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTALACTITEMEDIUM1
    {HEXEN_SPR_SLC3, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTALACTITESMALL1
    {HEXEN_SPR_MSS1, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZMOSSCEILING1_1
    {HEXEN_SPR_MSS2, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZMOSSCEILING2_1
    {HEXEN_SPR_SWMV, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSWAMPVINE1
    {HEXEN_SPR_CPS1, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZCORPSEKABOB1
    {HEXEN_SPR_CPS2, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZCORPSESLEEPING1
    {HEXEN_SPR_TMS1, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZTOMBSTONERIP1
    {HEXEN_SPR_TMS2, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZTOMBSTONESHANE1
    {HEXEN_SPR_TMS3, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZTOMBSTONEBIGCROSS1
    {HEXEN_SPR_TMS4, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZTOMBSTONEBRIANR1
    {HEXEN_SPR_TMS5, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZTOMBSTONECROSSCIRCLE1
    {HEXEN_SPR_TMS6, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZTOMBSTONESMALLCROSS1
    {HEXEN_SPR_TMS7, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZTOMBSTONEBRIANP1
    {HEXEN_SPR_CPS3, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_CORPSEHANGING_1
    {HEXEN_SPR_STT2, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTATUEGARGOYLEGREENTALL_1
    {HEXEN_SPR_STT3, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTATUEGARGOYLEBLUETALL_1
    {HEXEN_SPR_STT4, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTATUEGARGOYLEGREENSHORT_1
    {HEXEN_SPR_STT5, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTATUEGARGOYLEBLUESHORT_1
    {HEXEN_SPR_GAR1, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTATUEGARGOYLESTRIPETALL_1
    {HEXEN_SPR_GAR2, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTATUEGARGOYLEDARKREDTALL_1
    {HEXEN_SPR_GAR3, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTATUEGARGOYLEREDTALL_1
    {HEXEN_SPR_GAR4, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTATUEGARGOYLETANTALL_1
    {HEXEN_SPR_GAR5, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTATUEGARGOYLERUSTTALL_1
    {HEXEN_SPR_GAR6, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTATUEGARGOYLEDARKREDSHORT_1
    {HEXEN_SPR_GAR7, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTATUEGARGOYLEREDSHORT_1
    {HEXEN_SPR_GAR8, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTATUEGARGOYLETANSHORT_1
    {HEXEN_SPR_GAR9, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTATUEGARGOYLERUSTSHORT_1
    {HEXEN_SPR_BNR1, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZBANNERTATTERED_1
    {HEXEN_SPR_TRE4, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZTREELARGE1
    {HEXEN_SPR_TRE5, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZTREELARGE2
    {HEXEN_SPR_TRE6, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZTREEGNARLED1
    {HEXEN_SPR_TRE7, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZTREEGNARLED2
    {HEXEN_SPR_LOGG, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZLOG
    {HEXEN_SPR_ICT1, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTALACTITEICELARGE
    {HEXEN_SPR_ICT2, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTALACTITEICEMEDIUM
    {HEXEN_SPR_ICT3, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTALACTITEICESMALL
    {HEXEN_SPR_ICT4, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTALACTITEICETINY
    {HEXEN_SPR_ICM1, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTALAGMITEICELARGE
    {HEXEN_SPR_ICM2, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTALAGMITEICEMEDIUM
    {HEXEN_SPR_ICM3, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTALAGMITEICESMALL
    {HEXEN_SPR_ICM4, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSTALAGMITEICETINY
    {HEXEN_SPR_RKBL, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZROCKBROWN1
    {HEXEN_SPR_RKBS, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZROCKBROWN2
    {HEXEN_SPR_RKBK, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZROCKBLACK
    {HEXEN_SPR_RBL1, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZRUBBLE1
    {HEXEN_SPR_RBL2, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZRUBBLE2
    {HEXEN_SPR_RBL3, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZRUBBLE3
    {HEXEN_SPR_VASE, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZVASEPILLAR
    {HEXEN_SPR_POT1, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZPOTTERY1
    {HEXEN_SPR_POT2, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZPOTTERY2
    {HEXEN_SPR_POT3, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZPOTTERY3
    {HEXEN_SPR_POT1, 0, 0, A_PotteryExplode, HEXEN_S_NULL, 0, 0},   // HEXEN_S_ZPOTTERY_EXPLODE
    {HEXEN_SPR_PBIT, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_POTTERYBIT_1
    {HEXEN_SPR_PBIT, 1, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_POTTERYBIT_2
    {HEXEN_SPR_PBIT, 2, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_POTTERYBIT_3
    {HEXEN_SPR_PBIT, 3, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_POTTERYBIT_4
    {HEXEN_SPR_PBIT, 4, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_POTTERYBIT_5
    {HEXEN_SPR_PBIT, 5, 0, A_PotteryChooseBit, HEXEN_S_NULL, 0, 0}, // HEXEN_S_POTTERYBIT_EX0
    {HEXEN_SPR_PBIT, 5, 140, NULL, HEXEN_S_POTTERYBIT_EX1_2, 0, 0}, // HEXEN_S_POTTERYBIT_EX1
    {HEXEN_SPR_PBIT, 5, 1, A_PotteryCheck, HEXEN_S_NULL, 0, 0},     // HEXEN_S_POTTERYBIT_EX1_2
    {HEXEN_SPR_PBIT, 6, 140, NULL, HEXEN_S_POTTERYBIT_EX2_2, 0, 0}, // HEXEN_S_POTTERYBIT_EX2
    {HEXEN_SPR_PBIT, 6, 1, A_PotteryCheck, HEXEN_S_NULL, 0, 0},     // HEXEN_S_POTTERYBIT_EX2_2
    {HEXEN_SPR_PBIT, 7, 140, NULL, HEXEN_S_POTTERYBIT_EX3_2, 0, 0}, // HEXEN_S_POTTERYBIT_EX3
    {HEXEN_SPR_PBIT, 7, 1, A_PotteryCheck, HEXEN_S_NULL, 0, 0},     // HEXEN_S_POTTERYBIT_EX3_2
    {HEXEN_SPR_PBIT, 8, 140, NULL, HEXEN_S_POTTERYBIT_EX4_2, 0, 0}, // HEXEN_S_POTTERYBIT_EX4
    {HEXEN_SPR_PBIT, 8, 1, A_PotteryCheck, HEXEN_S_NULL, 0, 0},     // HEXEN_S_POTTERYBIT_EX4_2
    {HEXEN_SPR_PBIT, 9, 140, NULL, HEXEN_S_POTTERYBIT_EX5_2, 0, 0}, // HEXEN_S_POTTERYBIT_EX5
    {HEXEN_SPR_PBIT, 9, 1, A_PotteryCheck, HEXEN_S_NULL, 0, 0},     // HEXEN_S_POTTERYBIT_EX5_2
    {HEXEN_SPR_CPS4, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZCORPSELYNCHED1
    {HEXEN_SPR_CPS5, 0, 140, A_CorpseBloodDrip, HEXEN_S_ZCORPSELYNCHED2, 0, 0},     // HEXEN_S_ZCORPSELYNCHED2
    {HEXEN_SPR_CPS6, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZCORPSESITTING
    {HEXEN_SPR_CPS6, 0, 1, A_CorpseExplode, HEXEN_S_NULL, 0, 0},    // HEXEN_S_ZCORPSESITTING_X
    {HEXEN_SPR_CPB1, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_CORPSEBIT_1
    {HEXEN_SPR_CPB2, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_CORPSEBIT_2
    {HEXEN_SPR_CPB3, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_CORPSEBIT_3
    {HEXEN_SPR_CPB4, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_CORPSEBIT_4
    {HEXEN_SPR_BDRP, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_CORPSEBLOODDRIP
    {HEXEN_SPR_BDSH, 0, 3, NULL, HEXEN_S_CORPSEBLOODDRIP_X2, 0, 0}, // HEXEN_S_CORPSEBLOODDRIP_X1
    {HEXEN_SPR_BDSH, 1, 3, NULL, HEXEN_S_CORPSEBLOODDRIP_X3, 0, 0}, // HEXEN_S_CORPSEBLOODDRIP_X2
    {HEXEN_SPR_BDSH, 2, 2, NULL, HEXEN_S_CORPSEBLOODDRIP_X4, 0, 0}, // HEXEN_S_CORPSEBLOODDRIP_X3
    {HEXEN_SPR_BDSH, 3, 2, NULL, HEXEN_S_NULL, 0, 0},       // HEXEN_S_CORPSEBLOODDRIP_X4
    {HEXEN_SPR_BDPL, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_BLOODPOOL
    {HEXEN_SPR_CNDL, 32768, 4, NULL, HEXEN_S_ZCANDLE2, 0, 0},       // HEXEN_S_ZCANDLE1
    {HEXEN_SPR_CNDL, 32769, 4, NULL, HEXEN_S_ZCANDLE3, 0, 0},       // HEXEN_S_ZCANDLE2
    {HEXEN_SPR_CNDL, 32770, 4, NULL, HEXEN_S_ZCANDLE1, 0, 0},       // HEXEN_S_ZCANDLE3
    {HEXEN_SPR_MAN1, 0, 20, A_LeafSpawn, HEXEN_S_ZLEAFSPAWNER, 0, 0},       // HEXEN_S_ZLEAFSPAWNER
    {HEXEN_SPR_LEF1, 0, 4, NULL, HEXEN_S_LEAF1_2, 0, 0},    // HEXEN_S_LEAF1_1
    {HEXEN_SPR_LEF1, 1, 4, NULL, HEXEN_S_LEAF1_3, 0, 0},    // HEXEN_S_LEAF1_2
    {HEXEN_SPR_LEF1, 2, 4, NULL, HEXEN_S_LEAF1_4, 0, 0},    // HEXEN_S_LEAF1_3
    {HEXEN_SPR_LEF1, 3, 4, A_LeafThrust, HEXEN_S_LEAF1_5, 0, 0},    // HEXEN_S_LEAF1_4
    {HEXEN_SPR_LEF1, 4, 4, NULL, HEXEN_S_LEAF1_6, 0, 0},    // HEXEN_S_LEAF1_5
    {HEXEN_SPR_LEF1, 5, 4, NULL, HEXEN_S_LEAF1_7, 0, 0},    // HEXEN_S_LEAF1_6
    {HEXEN_SPR_LEF1, 6, 4, NULL, HEXEN_S_LEAF1_8, 0, 0},    // HEXEN_S_LEAF1_7
    {HEXEN_SPR_LEF1, 7, 4, A_LeafThrust, HEXEN_S_LEAF1_9, 0, 0},    // HEXEN_S_LEAF1_8
    {HEXEN_SPR_LEF1, 8, 4, NULL, HEXEN_S_LEAF1_10, 0, 0},   // HEXEN_S_LEAF1_9
    {HEXEN_SPR_LEF1, 0, 4, NULL, HEXEN_S_LEAF1_11, 0, 0},   // HEXEN_S_LEAF1_10
    {HEXEN_SPR_LEF1, 1, 4, NULL, HEXEN_S_LEAF1_12, 0, 0},   // HEXEN_S_LEAF1_11
    {HEXEN_SPR_LEF1, 2, 4, A_LeafThrust, HEXEN_S_LEAF1_13, 0, 0},   // HEXEN_S_LEAF1_12
    {HEXEN_SPR_LEF1, 3, 4, NULL, HEXEN_S_LEAF1_14, 0, 0},   // HEXEN_S_LEAF1_13
    {HEXEN_SPR_LEF1, 4, 4, NULL, HEXEN_S_LEAF1_15, 0, 0},   // HEXEN_S_LEAF1_14
    {HEXEN_SPR_LEF1, 5, 4, NULL, HEXEN_S_LEAF1_16, 0, 0},   // HEXEN_S_LEAF1_15
    {HEXEN_SPR_LEF1, 6, 4, A_LeafThrust, HEXEN_S_LEAF1_17, 0, 0},   // HEXEN_S_LEAF1_16
    {HEXEN_SPR_LEF1, 7, 4, NULL, HEXEN_S_LEAF1_18, 0, 0},   // HEXEN_S_LEAF1_17
    {HEXEN_SPR_LEF1, 8, 4, NULL, HEXEN_S_NULL, 0, 0},       // HEXEN_S_LEAF1_18
    {HEXEN_SPR_LEF3, 3, 10, A_LeafCheck, HEXEN_S_LEAF_X1, 0, 0},    // HEXEN_S_LEAF_X1
    {HEXEN_SPR_LEF2, 0, 4, NULL, HEXEN_S_LEAF2_2, 0, 0},    // HEXEN_S_LEAF2_1
    {HEXEN_SPR_LEF2, 1, 4, NULL, HEXEN_S_LEAF2_3, 0, 0},    // HEXEN_S_LEAF2_2
    {HEXEN_SPR_LEF2, 2, 4, NULL, HEXEN_S_LEAF2_4, 0, 0},    // HEXEN_S_LEAF2_3
    {HEXEN_SPR_LEF2, 3, 4, A_LeafThrust, HEXEN_S_LEAF2_5, 0, 0},    // HEXEN_S_LEAF2_4
    {HEXEN_SPR_LEF2, 4, 4, NULL, HEXEN_S_LEAF2_6, 0, 0},    // HEXEN_S_LEAF2_5
    {HEXEN_SPR_LEF2, 5, 4, NULL, HEXEN_S_LEAF2_7, 0, 0},    // HEXEN_S_LEAF2_6
    {HEXEN_SPR_LEF2, 6, 4, NULL, HEXEN_S_LEAF2_8, 0, 0},    // HEXEN_S_LEAF2_7
    {HEXEN_SPR_LEF2, 7, 4, A_LeafThrust, HEXEN_S_LEAF2_9, 0, 0},    // HEXEN_S_LEAF2_8
    {HEXEN_SPR_LEF2, 8, 4, NULL, HEXEN_S_LEAF2_10, 0, 0},   // HEXEN_S_LEAF2_9
    {HEXEN_SPR_LEF2, 0, 4, NULL, HEXEN_S_LEAF2_11, 0, 0},   // HEXEN_S_LEAF2_10
    {HEXEN_SPR_LEF2, 1, 4, NULL, HEXEN_S_LEAF2_12, 0, 0},   // HEXEN_S_LEAF2_11
    {HEXEN_SPR_LEF2, 2, 4, A_LeafThrust, HEXEN_S_LEAF2_13, 0, 0},   // HEXEN_S_LEAF2_12
    {HEXEN_SPR_LEF2, 3, 4, NULL, HEXEN_S_LEAF2_14, 0, 0},   // HEXEN_S_LEAF2_13
    {HEXEN_SPR_LEF2, 4, 4, NULL, HEXEN_S_LEAF2_15, 0, 0},   // HEXEN_S_LEAF2_14
    {HEXEN_SPR_LEF2, 5, 4, NULL, HEXEN_S_LEAF2_16, 0, 0},   // HEXEN_S_LEAF2_15
    {HEXEN_SPR_LEF2, 6, 4, A_LeafThrust, HEXEN_S_LEAF2_17, 0, 0},   // HEXEN_S_LEAF2_16
    {HEXEN_SPR_LEF2, 7, 4, NULL, HEXEN_S_LEAF2_18, 0, 0},   // HEXEN_S_LEAF2_17
    {HEXEN_SPR_LEF2, 8, 4, NULL, HEXEN_S_NULL, 0, 0},       // HEXEN_S_LEAF2_18
    {HEXEN_SPR_TWTR, 32768, 4, NULL, HEXEN_S_ZTWINEDTORCH_2, 0, 0}, // HEXEN_S_ZTWINEDTORCH_1
    {HEXEN_SPR_TWTR, 32769, 4, NULL, HEXEN_S_ZTWINEDTORCH_3, 0, 0}, // HEXEN_S_ZTWINEDTORCH_2
    {HEXEN_SPR_TWTR, 32770, 4, NULL, HEXEN_S_ZTWINEDTORCH_4, 0, 0}, // HEXEN_S_ZTWINEDTORCH_3
    {HEXEN_SPR_TWTR, 32771, 4, NULL, HEXEN_S_ZTWINEDTORCH_5, 0, 0}, // HEXEN_S_ZTWINEDTORCH_4
    {HEXEN_SPR_TWTR, 32772, 4, NULL, HEXEN_S_ZTWINEDTORCH_6, 0, 0}, // HEXEN_S_ZTWINEDTORCH_5
    {HEXEN_SPR_TWTR, 32773, 4, NULL, HEXEN_S_ZTWINEDTORCH_7, 0, 0}, // HEXEN_S_ZTWINEDTORCH_6
    {HEXEN_SPR_TWTR, 32774, 4, NULL, HEXEN_S_ZTWINEDTORCH_8, 0, 0}, // HEXEN_S_ZTWINEDTORCH_7
    {HEXEN_SPR_TWTR, 32775, 4, NULL, HEXEN_S_ZTWINEDTORCH_1, 0, 0}, // HEXEN_S_ZTWINEDTORCH_8
    {HEXEN_SPR_TWTR, 8, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZTWINEDTORCH_UNLIT
    {HEXEN_SPR_TLGL, 0, 2, NULL, HEXEN_S_BRIDGE2, 0, 0},    // HEXEN_S_BRIDGE1
    {HEXEN_SPR_TLGL, 0, 2, A_BridgeInit, HEXEN_S_BRIDGE3, 0, 0},    // HEXEN_S_BRIDGE2
    {HEXEN_SPR_TLGL, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_BRIDGE3
    {HEXEN_SPR_TLGL, 0, 2, NULL, HEXEN_S_FREE_BRIDGE2, 0, 0},       // HEXEN_S_FREE_BRIDGE1
    {HEXEN_SPR_TLGL, 0, 300, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_FREE_BRIDGE2
    {HEXEN_SPR_TLGL, 0, 2, NULL, HEXEN_S_BBALL2, 0, 0},     // HEXEN_S_BBALL1
    {HEXEN_SPR_TLGL, 0, 5, A_BridgeOrbit, HEXEN_S_BBALL2, 0, 0},    // HEXEN_S_BBALL2
    {HEXEN_SPR_WLTR, 32768, 5, NULL, HEXEN_S_ZWALLTORCH2, 0, 0},    // HEXEN_S_ZWALLTORCH1
    {HEXEN_SPR_WLTR, 32769, 5, NULL, HEXEN_S_ZWALLTORCH3, 0, 0},    // HEXEN_S_ZWALLTORCH2
    {HEXEN_SPR_WLTR, 32770, 5, NULL, HEXEN_S_ZWALLTORCH4, 0, 0},    // HEXEN_S_ZWALLTORCH3
    {HEXEN_SPR_WLTR, 32771, 5, NULL, HEXEN_S_ZWALLTORCH5, 0, 0},    // HEXEN_S_ZWALLTORCH4
    {HEXEN_SPR_WLTR, 32772, 5, NULL, HEXEN_S_ZWALLTORCH6, 0, 0},    // HEXEN_S_ZWALLTORCH5
    {HEXEN_SPR_WLTR, 32773, 5, NULL, HEXEN_S_ZWALLTORCH7, 0, 0},    // HEXEN_S_ZWALLTORCH6
    {HEXEN_SPR_WLTR, 32774, 5, NULL, HEXEN_S_ZWALLTORCH8, 0, 0},    // HEXEN_S_ZWALLTORCH7
    {HEXEN_SPR_WLTR, 32775, 5, NULL, HEXEN_S_ZWALLTORCH1, 0, 0},    // HEXEN_S_ZWALLTORCH8
    {HEXEN_SPR_WLTR, 8, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZWALLTORCH_U
    {HEXEN_SPR_BARL, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZBARREL1
    {HEXEN_SPR_SHB1, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSHRUB1
    {HEXEN_SPR_SHB1, 0, 1, A_TreeDeath, HEXEN_S_ZSHRUB1, 0, 0},     // HEXEN_S_ZSHRUB1_DIE
    {HEXEN_SPR_SHB1, 32769, 7, NULL, HEXEN_S_ZSHRUB1_X2, 0, 0},     // HEXEN_S_ZSHRUB1_X1
    {HEXEN_SPR_SHB1, 32770, 6, A_Scream, HEXEN_S_ZSHRUB1_X3, 0, 0}, // HEXEN_S_ZSHRUB1_X2
    {HEXEN_SPR_SHB1, 32771, 5, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_ZSHRUB1_X3
    {HEXEN_SPR_SHB2, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSHRUB2
    {HEXEN_SPR_SHB2, 0, 1, A_TreeDeath, HEXEN_S_ZSHRUB2, 0, 0},     // HEXEN_S_ZSHRUB2_DIE
    {HEXEN_SPR_SHB2, 32769, 7, NULL, HEXEN_S_ZSHRUB2_X2, 0, 0},     // HEXEN_S_ZSHRUB2_X1
    {HEXEN_SPR_SHB2, 32770, 6, A_Scream, HEXEN_S_ZSHRUB2_X3, 0, 0}, // HEXEN_S_ZSHRUB2_X2
    {HEXEN_SPR_SHB2, 32771, 5, A_Explode, HEXEN_S_ZSHRUB2_X4, 0, 0},        // HEXEN_S_ZSHRUB2_X3
    {HEXEN_SPR_SHB2, 32772, 5, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_ZSHRUB2_X4
    {HEXEN_SPR_BCKT, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZBUCKET1
    {HEXEN_SPR_SHRM, 0, 5, A_PoisonShroom, HEXEN_S_ZPOISONSHROOM_P2, 0, 0}, // HEXEN_S_ZPOISONSHROOM1
    {HEXEN_SPR_SHRM, 0, 6, NULL, HEXEN_S_ZPOISONSHROOM_P2, 0, 0},   // HEXEN_S_ZPOISONSHROOM_P1
    {HEXEN_SPR_SHRM, 1, 8, A_Pain, HEXEN_S_ZPOISONSHROOM1, 0, 0},   // HEXEN_S_ZPOISONSHROOM_P2
    {HEXEN_SPR_SHRM, 2, 5, NULL, HEXEN_S_ZPOISONSHROOM_X2, 0, 0},   // HEXEN_S_ZPOISONSHROOM_X1
    {HEXEN_SPR_SHRM, 3, 5, NULL, HEXEN_S_ZPOISONSHROOM_X3, 0, 0},   // HEXEN_S_ZPOISONSHROOM_X2
    {HEXEN_SPR_SHRM, 4, 5, A_PoisonBagInit, HEXEN_S_ZPOISONSHROOM_X4, 0, 0},        // HEXEN_S_ZPOISONSHROOM_X3
    {HEXEN_SPR_SHRM, 5, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZPOISONSHROOM_X4
    {HEXEN_SPR_FBUL, 32768, 4, NULL, HEXEN_S_ZFIREBULL2, 0, 0},     // HEXEN_S_ZFIREBULL1
    {HEXEN_SPR_FBUL, 32769, 4, NULL, HEXEN_S_ZFIREBULL3, 0, 0},     // HEXEN_S_ZFIREBULL2
    {HEXEN_SPR_FBUL, 32770, 4, NULL, HEXEN_S_ZFIREBULL4, 0, 0},     // HEXEN_S_ZFIREBULL3
    {HEXEN_SPR_FBUL, 32771, 4, NULL, HEXEN_S_ZFIREBULL5, 0, 0},     // HEXEN_S_ZFIREBULL4
    {HEXEN_SPR_FBUL, 32772, 4, NULL, HEXEN_S_ZFIREBULL6, 0, 0},     // HEXEN_S_ZFIREBULL5
    {HEXEN_SPR_FBUL, 32773, 4, NULL, HEXEN_S_ZFIREBULL7, 0, 0},     // HEXEN_S_ZFIREBULL6
    {HEXEN_SPR_FBUL, 32774, 4, NULL, HEXEN_S_ZFIREBULL1, 0, 0},     // HEXEN_S_ZFIREBULL7
    {HEXEN_SPR_FBUL, 32777, 4, NULL, HEXEN_S_ZFIREBULL_DEATH2, 0, 0},       // HEXEN_S_ZFIREBULL_DEATH
    {HEXEN_SPR_FBUL, 32776, 4, NULL, HEXEN_S_ZFIREBULL_U, 0, 0},    // HEXEN_S_ZFIREBULL_DEATH2
    {HEXEN_SPR_FBUL, 7, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZFIREBULL_U
    {HEXEN_SPR_FBUL, 32776, 4, NULL, HEXEN_S_ZFIREBULL_BIRTH2, 0, 0},       // HEXEN_S_ZFIREBULL_BIRTH
    {HEXEN_SPR_FBUL, 32777, 4, NULL, HEXEN_S_ZFIREBULL1, 0, 0},     // HEXEN_S_ZFIREBULL_BIRTH2
    {HEXEN_SPR_FSKL, 32768, 4, NULL, HEXEN_S_ZFIRETHING2, 0, 0},    // HEXEN_S_ZFIRETHING1
    {HEXEN_SPR_FSKL, 32769, 3, NULL, HEXEN_S_ZFIRETHING3, 0, 0},    // HEXEN_S_ZFIRETHING2
    {HEXEN_SPR_FSKL, 32770, 4, NULL, HEXEN_S_ZFIRETHING4, 0, 0},    // HEXEN_S_ZFIRETHING3
    {HEXEN_SPR_FSKL, 32771, 3, NULL, HEXEN_S_ZFIRETHING5, 0, 0},    // HEXEN_S_ZFIRETHING4
    {HEXEN_SPR_FSKL, 32772, 4, NULL, HEXEN_S_ZFIRETHING6, 0, 0},    // HEXEN_S_ZFIRETHING5
    {HEXEN_SPR_FSKL, 32773, 3, NULL, HEXEN_S_ZFIRETHING7, 0, 0},    // HEXEN_S_ZFIRETHING6
    {HEXEN_SPR_FSKL, 32774, 4, NULL, HEXEN_S_ZFIRETHING8, 0, 0},    // HEXEN_S_ZFIRETHING7
    {HEXEN_SPR_FSKL, 32775, 3, NULL, HEXEN_S_ZFIRETHING9, 0, 0},    // HEXEN_S_ZFIRETHING8
    {HEXEN_SPR_FSKL, 32776, 4, NULL, HEXEN_S_ZFIRETHING1, 0, 0},    // HEXEN_S_ZFIRETHING9
    {HEXEN_SPR_BRTR, 32768, 4, NULL, HEXEN_S_ZBRASSTORCH2, 0, 0},   // HEXEN_S_ZBRASSTORCH1
    {HEXEN_SPR_BRTR, 32769, 4, NULL, HEXEN_S_ZBRASSTORCH3, 0, 0},   // HEXEN_S_ZBRASSTORCH2
    {HEXEN_SPR_BRTR, 32770, 4, NULL, HEXEN_S_ZBRASSTORCH4, 0, 0},   // HEXEN_S_ZBRASSTORCH3
    {HEXEN_SPR_BRTR, 32771, 4, NULL, HEXEN_S_ZBRASSTORCH5, 0, 0},   // HEXEN_S_ZBRASSTORCH4
    {HEXEN_SPR_BRTR, 32772, 4, NULL, HEXEN_S_ZBRASSTORCH6, 0, 0},   // HEXEN_S_ZBRASSTORCH5
    {HEXEN_SPR_BRTR, 32773, 4, NULL, HEXEN_S_ZBRASSTORCH7, 0, 0},   // HEXEN_S_ZBRASSTORCH6
    {HEXEN_SPR_BRTR, 32774, 4, NULL, HEXEN_S_ZBRASSTORCH8, 0, 0},   // HEXEN_S_ZBRASSTORCH7
    {HEXEN_SPR_BRTR, 32775, 4, NULL, HEXEN_S_ZBRASSTORCH9, 0, 0},   // HEXEN_S_ZBRASSTORCH8
    {HEXEN_SPR_BRTR, 32776, 4, NULL, HEXEN_S_ZBRASSTORCH10, 0, 0},  // HEXEN_S_ZBRASSTORCH9
    {HEXEN_SPR_BRTR, 32777, 4, NULL, HEXEN_S_ZBRASSTORCH11, 0, 0},  // HEXEN_S_ZBRASSTORCH10
    {HEXEN_SPR_BRTR, 32778, 4, NULL, HEXEN_S_ZBRASSTORCH12, 0, 0},  // HEXEN_S_ZBRASSTORCH11
    {HEXEN_SPR_BRTR, 32779, 4, NULL, HEXEN_S_ZBRASSTORCH13, 0, 0},  // HEXEN_S_ZBRASSTORCH12
    {HEXEN_SPR_BRTR, 32780, 4, NULL, HEXEN_S_ZBRASSTORCH1, 0, 0},   // HEXEN_S_ZBRASSTORCH13
    {HEXEN_SPR_SUIT, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZSUITOFARMOR
    {HEXEN_SPR_SUIT, 0, 1, A_SoAExplode, HEXEN_S_NULL, 0, 0},       // HEXEN_S_ZSUITOFARMOR_X1
    {HEXEN_SPR_SUIT, 1, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZARMORCHUNK1
    {HEXEN_SPR_SUIT, 2, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZARMORCHUNK2
    {HEXEN_SPR_SUIT, 3, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZARMORCHUNK3
    {HEXEN_SPR_SUIT, 4, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZARMORCHUNK4
    {HEXEN_SPR_SUIT, 5, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZARMORCHUNK5
    {HEXEN_SPR_SUIT, 6, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZARMORCHUNK6
    {HEXEN_SPR_SUIT, 7, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZARMORCHUNK7
    {HEXEN_SPR_SUIT, 8, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZARMORCHUNK8
    {HEXEN_SPR_SUIT, 9, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZARMORCHUNK9
    {HEXEN_SPR_SUIT, 10, -1, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_ZARMORCHUNK10
    {HEXEN_SPR_BBLL, 5, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZBELL
    {HEXEN_SPR_BBLL, 0, 4, A_BellReset1, HEXEN_S_ZBELL_X2, 0, 0},   // HEXEN_S_ZBELL_X1
    {HEXEN_SPR_BBLL, 1, 4, NULL, HEXEN_S_ZBELL_X3, 0, 0},   // HEXEN_S_ZBELL_X2
    {HEXEN_SPR_BBLL, 2, 4, NULL, HEXEN_S_ZBELL_X4, 0, 0},   // HEXEN_S_ZBELL_X3
    {HEXEN_SPR_BBLL, 3, 5, A_Scream, HEXEN_S_ZBELL_X5, 0, 0},       // HEXEN_S_ZBELL_X4
    {HEXEN_SPR_BBLL, 2, 4, NULL, HEXEN_S_ZBELL_X6, 0, 0},   // HEXEN_S_ZBELL_X5
    {HEXEN_SPR_BBLL, 1, 4, NULL, HEXEN_S_ZBELL_X7, 0, 0},   // HEXEN_S_ZBELL_X6
    {HEXEN_SPR_BBLL, 0, 3, NULL, HEXEN_S_ZBELL_X8, 0, 0},   // HEXEN_S_ZBELL_X7
    {HEXEN_SPR_BBLL, 4, 4, NULL, HEXEN_S_ZBELL_X9, 0, 0},   // HEXEN_S_ZBELL_X8
    {HEXEN_SPR_BBLL, 5, 5, NULL, HEXEN_S_ZBELL_X10, 0, 0},  // HEXEN_S_ZBELL_X9
    {HEXEN_SPR_BBLL, 6, 6, A_Scream, HEXEN_S_ZBELL_X11, 0, 0},      // HEXEN_S_ZBELL_X10
    {HEXEN_SPR_BBLL, 5, 5, NULL, HEXEN_S_ZBELL_X12, 0, 0},  // HEXEN_S_ZBELL_X11
    {HEXEN_SPR_BBLL, 4, 4, NULL, HEXEN_S_ZBELL_X13, 0, 0},  // HEXEN_S_ZBELL_X12
    {HEXEN_SPR_BBLL, 0, 4, NULL, HEXEN_S_ZBELL_X14, 0, 0},  // HEXEN_S_ZBELL_X13
    {HEXEN_SPR_BBLL, 1, 5, NULL, HEXEN_S_ZBELL_X15, 0, 0},  // HEXEN_S_ZBELL_X14
    {HEXEN_SPR_BBLL, 2, 5, NULL, HEXEN_S_ZBELL_X16, 0, 0},  // HEXEN_S_ZBELL_X15
    {HEXEN_SPR_BBLL, 3, 6, A_Scream, HEXEN_S_ZBELL_X17, 0, 0},      // HEXEN_S_ZBELL_X16
    {HEXEN_SPR_BBLL, 2, 5, NULL, HEXEN_S_ZBELL_X18, 0, 0},  // HEXEN_S_ZBELL_X17
    {HEXEN_SPR_BBLL, 1, 5, NULL, HEXEN_S_ZBELL_X19, 0, 0},  // HEXEN_S_ZBELL_X18
    {HEXEN_SPR_BBLL, 0, 4, NULL, HEXEN_S_ZBELL_X20, 0, 0},  // HEXEN_S_ZBELL_X19
    {HEXEN_SPR_BBLL, 4, 5, NULL, HEXEN_S_ZBELL_X21, 0, 0},  // HEXEN_S_ZBELL_X20
    {HEXEN_SPR_BBLL, 5, 5, NULL, HEXEN_S_ZBELL_X22, 0, 0},  // HEXEN_S_ZBELL_X21
    {HEXEN_SPR_BBLL, 6, 7, A_Scream, HEXEN_S_ZBELL_X23, 0, 0},      // HEXEN_S_ZBELL_X22
    {HEXEN_SPR_BBLL, 5, 5, NULL, HEXEN_S_ZBELL_X24, 0, 0},  // HEXEN_S_ZBELL_X23
    {HEXEN_SPR_BBLL, 4, 5, NULL, HEXEN_S_ZBELL_X25, 0, 0},  // HEXEN_S_ZBELL_X24
    {HEXEN_SPR_BBLL, 0, 5, NULL, HEXEN_S_ZBELL_X26, 0, 0},  // HEXEN_S_ZBELL_X25
    {HEXEN_SPR_BBLL, 1, 6, NULL, HEXEN_S_ZBELL_X27, 0, 0},  // HEXEN_S_ZBELL_X26
    {HEXEN_SPR_BBLL, 2, 6, NULL, HEXEN_S_ZBELL_X28, 0, 0},  // HEXEN_S_ZBELL_X27
    {HEXEN_SPR_BBLL, 3, 7, A_Scream, HEXEN_S_ZBELL_X29, 0, 0},      // HEXEN_S_ZBELL_X28
    {HEXEN_SPR_BBLL, 2, 6, NULL, HEXEN_S_ZBELL_X30, 0, 0},  // HEXEN_S_ZBELL_X29
    {HEXEN_SPR_BBLL, 1, 6, NULL, HEXEN_S_ZBELL_X31, 0, 0},  // HEXEN_S_ZBELL_X30
    {HEXEN_SPR_BBLL, 0, 5, NULL, HEXEN_S_ZBELL_X32, 0, 0},  // HEXEN_S_ZBELL_X31
    {HEXEN_SPR_BBLL, 4, 6, NULL, HEXEN_S_ZBELL_X33, 0, 0},  // HEXEN_S_ZBELL_X32
    {HEXEN_SPR_BBLL, 5, 6, NULL, HEXEN_S_ZBELL_X34, 0, 0},  // HEXEN_S_ZBELL_X33
    {HEXEN_SPR_BBLL, 6, 7, A_Scream, HEXEN_S_ZBELL_X35, 0, 0},      // HEXEN_S_ZBELL_X34
    {HEXEN_SPR_BBLL, 5, 6, NULL, HEXEN_S_ZBELL_X36, 0, 0},  // HEXEN_S_ZBELL_X35
    {HEXEN_SPR_BBLL, 4, 6, NULL, HEXEN_S_ZBELL_X37, 0, 0},  // HEXEN_S_ZBELL_X36
    {HEXEN_SPR_BBLL, 0, 6, NULL, HEXEN_S_ZBELL_X38, 0, 0},  // HEXEN_S_ZBELL_X37
    {HEXEN_SPR_BBLL, 1, 6, NULL, HEXEN_S_ZBELL_X39, 0, 0},  // HEXEN_S_ZBELL_X38
    {HEXEN_SPR_BBLL, 2, 6, NULL, HEXEN_S_ZBELL_X40, 0, 0},  // HEXEN_S_ZBELL_X39
    {HEXEN_SPR_BBLL, 1, 7, NULL, HEXEN_S_ZBELL_X41, 0, 0},  // HEXEN_S_ZBELL_X40
    {HEXEN_SPR_BBLL, 0, 8, NULL, HEXEN_S_ZBELL_X42, 0, 0},  // HEXEN_S_ZBELL_X41
    {HEXEN_SPR_BBLL, 4, 12, NULL, HEXEN_S_ZBELL_X43, 0, 0}, // HEXEN_S_ZBELL_X42
    {HEXEN_SPR_BBLL, 0, 10, NULL, HEXEN_S_ZBELL_X44, 0, 0}, // HEXEN_S_ZBELL_X43
    {HEXEN_SPR_BBLL, 1, 12, NULL, HEXEN_S_ZBELL_X45, 0, 0}, // HEXEN_S_ZBELL_X44
    {HEXEN_SPR_BBLL, 0, 12, NULL, HEXEN_S_ZBELL_X46, 0, 0}, // HEXEN_S_ZBELL_X45
    {HEXEN_SPR_BBLL, 4, 14, NULL, HEXEN_S_ZBELL_X47, 0, 0}, // HEXEN_S_ZBELL_X46
    {HEXEN_SPR_BBLL, 0, 1, A_BellReset2, HEXEN_S_ZBELL, 0, 0},      // HEXEN_S_ZBELL_X47
    {HEXEN_SPR_CAND, 32768, 5, NULL, HEXEN_S_ZBLUE_CANDLE2, 0, 0},  // HEXEN_S_ZBLUE_CANDLE1
    {HEXEN_SPR_CAND, 32769, 5, NULL, HEXEN_S_ZBLUE_CANDLE3, 0, 0},  // HEXEN_S_ZBLUE_CANDLE2
    {HEXEN_SPR_CAND, 32770, 5, NULL, HEXEN_S_ZBLUE_CANDLE4, 0, 0},  // HEXEN_S_ZBLUE_CANDLE3
    {HEXEN_SPR_CAND, 32771, 5, NULL, HEXEN_S_ZBLUE_CANDLE5, 0, 0},  // HEXEN_S_ZBLUE_CANDLE4
    {HEXEN_SPR_CAND, 32772, 5, NULL, HEXEN_S_ZBLUE_CANDLE1, 0, 0},  // HEXEN_S_ZBLUE_CANDLE5
    {HEXEN_SPR_IRON, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZIRON_MAIDEN
    {HEXEN_SPR_XMAS, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZXMAS_TREE
    {HEXEN_SPR_XMAS, 0, 4, A_TreeDeath, HEXEN_S_ZXMAS_TREE, 0, 0},  // HEXEN_S_ZXMAS_TREE_DIE
    {HEXEN_SPR_XMAS, 32769, 6, NULL, HEXEN_S_ZXMAS_TREE_X2, 0, 0},  // HEXEN_S_ZXMAS_TREE_X1
    {HEXEN_SPR_XMAS, 32770, 6, A_Scream, HEXEN_S_ZXMAS_TREE_X3, 0, 0},      // HEXEN_S_ZXMAS_TREE_X2
    {HEXEN_SPR_XMAS, 32771, 5, NULL, HEXEN_S_ZXMAS_TREE_X4, 0, 0},  // HEXEN_S_ZXMAS_TREE_X3
    {HEXEN_SPR_XMAS, 32772, 5, A_Explode, HEXEN_S_ZXMAS_TREE_X5, 0, 0},     // HEXEN_S_ZXMAS_TREE_X4
    {HEXEN_SPR_XMAS, 32773, 5, NULL, HEXEN_S_ZXMAS_TREE_X6, 0, 0},  // HEXEN_S_ZXMAS_TREE_X5
    {HEXEN_SPR_XMAS, 32774, 4, NULL, HEXEN_S_ZXMAS_TREE_X7, 0, 0},  // HEXEN_S_ZXMAS_TREE_X6
    {HEXEN_SPR_XMAS, 7, 5, NULL, HEXEN_S_ZXMAS_TREE_X8, 0, 0},      // HEXEN_S_ZXMAS_TREE_X7
    {HEXEN_SPR_XMAS, 8, 4, A_NoBlocking, HEXEN_S_ZXMAS_TREE_X9, 0, 0},      // HEXEN_S_ZXMAS_TREE_X8
    {HEXEN_SPR_XMAS, 9, 4, NULL, HEXEN_S_ZXMAS_TREE_X10, 0, 0},     // HEXEN_S_ZXMAS_TREE_X9
    {HEXEN_SPR_XMAS, 10, -1, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_ZXMAS_TREE_X10
    {HEXEN_SPR_CDRN, 32769, 4, NULL, HEXEN_S_ZCAULDRON2, 0, 0},     // HEXEN_S_ZCAULDRON1
    {HEXEN_SPR_CDRN, 32770, 4, NULL, HEXEN_S_ZCAULDRON3, 0, 0},     // HEXEN_S_ZCAULDRON2
    {HEXEN_SPR_CDRN, 32771, 4, NULL, HEXEN_S_ZCAULDRON4, 0, 0},     // HEXEN_S_ZCAULDRON3
    {HEXEN_SPR_CDRN, 32772, 4, NULL, HEXEN_S_ZCAULDRON5, 0, 0},     // HEXEN_S_ZCAULDRON4
    {HEXEN_SPR_CDRN, 32773, 4, NULL, HEXEN_S_ZCAULDRON6, 0, 0},     // HEXEN_S_ZCAULDRON5
    {HEXEN_SPR_CDRN, 32774, 4, NULL, HEXEN_S_ZCAULDRON7, 0, 0},     // HEXEN_S_ZCAULDRON6
    {HEXEN_SPR_CDRN, 32775, 4, NULL, HEXEN_S_ZCAULDRON1, 0, 0},     // HEXEN_S_ZCAULDRON7
    {HEXEN_SPR_CDRN, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZCAULDRON_U
    {HEXEN_SPR_CHNS, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZCHAINBIT32
    {HEXEN_SPR_CHNS, 1, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZCHAINBIT64
    {HEXEN_SPR_CHNS, 2, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZCHAINEND_HEART
    {HEXEN_SPR_CHNS, 3, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZCHAINEND_HOOK1
    {HEXEN_SPR_CHNS, 4, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZCHAINEND_HOOK2
    {HEXEN_SPR_CHNS, 5, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZCHAINEND_SPIKE
    {HEXEN_SPR_CHNS, 6, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ZCHAINEND_SKULL
    {HEXEN_SPR_TST1, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_TABLE_SHIT1
    {HEXEN_SPR_TST2, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_TABLE_SHIT2
    {HEXEN_SPR_TST3, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_TABLE_SHIT3
    {HEXEN_SPR_TST4, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_TABLE_SHIT4
    {HEXEN_SPR_TST5, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_TABLE_SHIT5
    {HEXEN_SPR_TST6, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_TABLE_SHIT6
    {HEXEN_SPR_TST7, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_TABLE_SHIT7
    {HEXEN_SPR_TST8, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_TABLE_SHIT8
    {HEXEN_SPR_TST9, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_TABLE_SHIT9
    {HEXEN_SPR_TST0, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_TABLE_SHIT10
    {HEXEN_SPR_TELE, 32768, 6, NULL, HEXEN_S_TFOG2, 0, 0},  // HEXEN_S_TFOG1
    {HEXEN_SPR_TELE, 32769, 6, NULL, HEXEN_S_TFOG3, 0, 0},  // HEXEN_S_TFOG2
    {HEXEN_SPR_TELE, 32770, 6, NULL, HEXEN_S_TFOG4, 0, 0},  // HEXEN_S_TFOG3
    {HEXEN_SPR_TELE, 32771, 6, NULL, HEXEN_S_TFOG5, 0, 0},  // HEXEN_S_TFOG4
    {HEXEN_SPR_TELE, 32772, 6, NULL, HEXEN_S_TFOG6, 0, 0},  // HEXEN_S_TFOG5
    {HEXEN_SPR_TELE, 32773, 6, NULL, HEXEN_S_TFOG7, 0, 0},  // HEXEN_S_TFOG6
    {HEXEN_SPR_TELE, 32774, 6, NULL, HEXEN_S_TFOG8, 0, 0},  // HEXEN_S_TFOG7
    {HEXEN_SPR_TELE, 32775, 6, NULL, HEXEN_S_TFOG9, 0, 0},  // HEXEN_S_TFOG8
    {HEXEN_SPR_TELE, 32774, 6, NULL, HEXEN_S_TFOG10, 0, 0}, // HEXEN_S_TFOG9
    {HEXEN_SPR_TELE, 32773, 6, NULL, HEXEN_S_TFOG11, 0, 0}, // HEXEN_S_TFOG10
    {HEXEN_SPR_TELE, 32772, 6, NULL, HEXEN_S_TFOG12, 0, 0}, // HEXEN_S_TFOG11
    {HEXEN_SPR_TELE, 32771, 6, NULL, HEXEN_S_TFOG13, 0, 0}, // HEXEN_S_TFOG12
    {HEXEN_SPR_TELE, 32770, 6, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_TFOG13
    {HEXEN_SPR_TSMK, 0, 4, NULL, HEXEN_S_TELESMOKE2, 0, 0}, // HEXEN_S_TELESMOKE1
    {HEXEN_SPR_TSMK, 1, 3, NULL, HEXEN_S_TELESMOKE3, 0, 0}, // HEXEN_S_TELESMOKE2
    {HEXEN_SPR_TSMK, 2, 4, NULL, HEXEN_S_TELESMOKE4, 0, 0}, // HEXEN_S_TELESMOKE3
    {HEXEN_SPR_TSMK, 3, 3, NULL, HEXEN_S_TELESMOKE5, 0, 0}, // HEXEN_S_TELESMOKE4
    {HEXEN_SPR_TSMK, 4, 4, NULL, HEXEN_S_TELESMOKE6, 0, 0}, // HEXEN_S_TELESMOKE5
    {HEXEN_SPR_TSMK, 5, 3, NULL, HEXEN_S_TELESMOKE7, 0, 0}, // HEXEN_S_TELESMOKE6
    {HEXEN_SPR_TSMK, 6, 4, NULL, HEXEN_S_TELESMOKE8, 0, 0}, // HEXEN_S_TELESMOKE7
    {HEXEN_SPR_TSMK, 7, 3, NULL, HEXEN_S_TELESMOKE9, 0, 0}, // HEXEN_S_TELESMOKE8
    {HEXEN_SPR_TSMK, 8, 4, NULL, HEXEN_S_TELESMOKE10, 0, 0},        // HEXEN_S_TELESMOKE9
    {HEXEN_SPR_TSMK, 9, 3, NULL, HEXEN_S_TELESMOKE11, 0, 0},        // HEXEN_S_TELESMOKE10
    {HEXEN_SPR_TSMK, 10, 4, NULL, HEXEN_S_TELESMOKE12, 0, 0},       // HEXEN_S_TELESMOKE11
    {HEXEN_SPR_TSMK, 11, 3, NULL, HEXEN_S_TELESMOKE13, 0, 0},       // HEXEN_S_TELESMOKE12
    {HEXEN_SPR_TSMK, 12, 4, NULL, HEXEN_S_TELESMOKE14, 0, 0},       // HEXEN_S_TELESMOKE13
    {HEXEN_SPR_TSMK, 13, 3, NULL, HEXEN_S_TELESMOKE15, 0, 0},       // HEXEN_S_TELESMOKE14
    {HEXEN_SPR_TSMK, 14, 4, NULL, HEXEN_S_TELESMOKE16, 0, 0},       // HEXEN_S_TELESMOKE15
    {HEXEN_SPR_TSMK, 15, 3, NULL, HEXEN_S_TELESMOKE17, 0, 0},       // HEXEN_S_TELESMOKE16
    {HEXEN_SPR_TSMK, 16, 4, NULL, HEXEN_S_TELESMOKE18, 0, 0},       // HEXEN_S_TELESMOKE17
    {HEXEN_SPR_TSMK, 17, 3, NULL, HEXEN_S_TELESMOKE19, 0, 0},       // HEXEN_S_TELESMOKE18
    {HEXEN_SPR_TSMK, 18, 4, NULL, HEXEN_S_TELESMOKE20, 0, 0},       // HEXEN_S_TELESMOKE19
    {HEXEN_SPR_TSMK, 19, 3, NULL, HEXEN_S_TELESMOKE21, 0, 0},       // HEXEN_S_TELESMOKE20
    {HEXEN_SPR_TSMK, 20, 4, NULL, HEXEN_S_TELESMOKE22, 0, 0},       // HEXEN_S_TELESMOKE21
    {HEXEN_SPR_TSMK, 21, 3, NULL, HEXEN_S_TELESMOKE23, 0, 0},       // HEXEN_S_TELESMOKE22
    {HEXEN_SPR_TSMK, 22, 4, NULL, HEXEN_S_TELESMOKE24, 0, 0},       // HEXEN_S_TELESMOKE23
    {HEXEN_SPR_TSMK, 23, 3, NULL, HEXEN_S_TELESMOKE25, 0, 0},       // HEXEN_S_TELESMOKE24
    {HEXEN_SPR_TSMK, 24, 4, NULL, HEXEN_S_TELESMOKE26, 0, 0},       // HEXEN_S_TELESMOKE25
    {HEXEN_SPR_TSMK, 25, 3, NULL, HEXEN_S_TELESMOKE1, 0, 0},        // HEXEN_S_TELESMOKE26
    {HEXEN_SPR_FPCH, 0, 0, A_Light0, HEXEN_S_NULL, 0, 0},   // HEXEN_S_LIGHTDONE
    {HEXEN_SPR_FPCH, 0, 1, A_WeaponReady, HEXEN_S_PUNCHREADY, 0, 0},        // HEXEN_S_PUNCHREADY
    {HEXEN_SPR_FPCH, 0, 1, A_Lower, HEXEN_S_PUNCHDOWN, 0, 0},       // HEXEN_S_PUNCHDOWN
    {HEXEN_SPR_FPCH, 0, 1, A_Raise, HEXEN_S_PUNCHUP, 0, 0}, // HEXEN_S_PUNCHUP
    {HEXEN_SPR_FPCH, 1, 5, NULL, HEXEN_S_PUNCHATK1_2, 5, 40},       // HEXEN_S_PUNCHATK1_1
    {HEXEN_SPR_FPCH, 2, 4, NULL, HEXEN_S_PUNCHATK1_3, 5, 40},       // HEXEN_S_PUNCHATK1_2
    {HEXEN_SPR_FPCH, 3, 4, A_FPunchAttack, HEXEN_S_PUNCHATK1_4, 5, 40},     // HEXEN_S_PUNCHATK1_3
    {HEXEN_SPR_FPCH, 2, 4, NULL, HEXEN_S_PUNCHATK1_5, 5, 40},       // HEXEN_S_PUNCHATK1_4
    {HEXEN_SPR_FPCH, 1, 5, A_ReFire, HEXEN_S_PUNCHREADY, 5, 40},    // HEXEN_S_PUNCHATK1_5
    {HEXEN_SPR_FPCH, 3, 4, NULL, HEXEN_S_PUNCHATK2_2, 5, 40},       // HEXEN_S_PUNCHATK2_1
    {HEXEN_SPR_FPCH, 4, 4, NULL, HEXEN_S_PUNCHATK2_3, 5, 40},       // HEXEN_S_PUNCHATK2_2
    {HEXEN_SPR_FPCH, 4, 1, NULL, HEXEN_S_PUNCHATK2_4, 15, 50},      // HEXEN_S_PUNCHATK2_3
    {HEXEN_SPR_FPCH, 4, 1, NULL, HEXEN_S_PUNCHATK2_5, 25, 60},      // HEXEN_S_PUNCHATK2_4
    {HEXEN_SPR_FPCH, 4, 1, NULL, HEXEN_S_PUNCHATK2_6, 35, 70},      // HEXEN_S_PUNCHATK2_5
    {HEXEN_SPR_FPCH, 4, 1, NULL, HEXEN_S_PUNCHATK2_7, 45, 80},      // HEXEN_S_PUNCHATK2_6
    {HEXEN_SPR_FPCH, 4, 1, NULL, HEXEN_S_PUNCHATK2_8, 55, 90},      // HEXEN_S_PUNCHATK2_7
    {HEXEN_SPR_FPCH, 4, 1, NULL, HEXEN_S_PUNCHATK2_9, 65, 100},     // HEXEN_S_PUNCHATK2_8
    {HEXEN_SPR_FPCH, 4, 10, NULL, HEXEN_S_PUNCHREADY, 0, 150},      // HEXEN_S_PUNCHATK2_9
    {HEXEN_SPR_FHFX, 18, 4, NULL, HEXEN_S_PUNCHPUFF2, 0, 0},        // HEXEN_S_PUNCHPUFF1
    {HEXEN_SPR_FHFX, 19, 4, NULL, HEXEN_S_PUNCHPUFF3, 0, 0},        // HEXEN_S_PUNCHPUFF2
    {HEXEN_SPR_FHFX, 20, 4, NULL, HEXEN_S_PUNCHPUFF4, 0, 0},        // HEXEN_S_PUNCHPUFF3
    {HEXEN_SPR_FHFX, 21, 4, NULL, HEXEN_S_PUNCHPUFF5, 0, 0},        // HEXEN_S_PUNCHPUFF4
    {HEXEN_SPR_FHFX, 22, 4, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_PUNCHPUFF5
    {HEXEN_SPR_WFAX, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_AXE
    {HEXEN_SPR_FAXE, 0, 1, A_WeaponReady, HEXEN_S_FAXEREADY, 0, 0}, // HEXEN_S_FAXEREADY
    {HEXEN_SPR_FAXE, 0, 1, A_Lower, HEXEN_S_FAXEDOWN, 0, 0},        // HEXEN_S_FAXEDOWN
    {HEXEN_SPR_FAXE, 0, 1, A_Raise, HEXEN_S_FAXEUP, 0, 0},  // HEXEN_S_FAXEUP
    {HEXEN_SPR_FAXE, 1, 4, NULL, HEXEN_S_FAXEATK_2, 15, 32},        // HEXEN_S_FAXEATK_1
    {HEXEN_SPR_FAXE, 2, 3, NULL, HEXEN_S_FAXEATK_3, 15, 32},        // HEXEN_S_FAXEATK_2
    {HEXEN_SPR_FAXE, 3, 2, NULL, HEXEN_S_FAXEATK_4, 15, 32},        // HEXEN_S_FAXEATK_3
    {HEXEN_SPR_FAXE, 3, 1, A_FAxeAttack, HEXEN_S_FAXEATK_5, -5, 70},        // HEXEN_S_FAXEATK_4
    {HEXEN_SPR_FAXE, 3, 2, NULL, HEXEN_S_FAXEATK_6, -25, 90},       // HEXEN_S_FAXEATK_5
    {HEXEN_SPR_FAXE, 4, 1, NULL, HEXEN_S_FAXEATK_7, 15, 32},        // HEXEN_S_FAXEATK_6
    {HEXEN_SPR_FAXE, 4, 2, NULL, HEXEN_S_FAXEATK_8, 10, 54},        // HEXEN_S_FAXEATK_7
    {HEXEN_SPR_FAXE, 4, 7, NULL, HEXEN_S_FAXEATK_9, 10, 150},       // HEXEN_S_FAXEATK_8
    {HEXEN_SPR_FAXE, 0, 1, A_ReFire, HEXEN_S_FAXEATK_10, 0, 60},    // HEXEN_S_FAXEATK_9
    {HEXEN_SPR_FAXE, 0, 1, NULL, HEXEN_S_FAXEATK_11, 0, 52},        // HEXEN_S_FAXEATK_10
    {HEXEN_SPR_FAXE, 0, 1, NULL, HEXEN_S_FAXEATK_12, 0, 44},        // HEXEN_S_FAXEATK_11
    {HEXEN_SPR_FAXE, 0, 1, NULL, HEXEN_S_FAXEATK_13, 0, 36},        // HEXEN_S_FAXEATK_12
    {HEXEN_SPR_FAXE, 0, 1, NULL, HEXEN_S_FAXEREADY, 0, 0},  // HEXEN_S_FAXEATK_13
    {HEXEN_SPR_FAXE, 11, 1, A_WeaponReady, HEXEN_S_FAXEREADY_G1, 0, 0},     // HEXEN_S_FAXEREADY_G
    {HEXEN_SPR_FAXE, 11, 1, A_WeaponReady, HEXEN_S_FAXEREADY_G2, 0, 0},     // HEXEN_S_FAXEREADY_G1
    {HEXEN_SPR_FAXE, 11, 1, A_WeaponReady, HEXEN_S_FAXEREADY_G3, 0, 0},     // HEXEN_S_FAXEREADY_G2
    {HEXEN_SPR_FAXE, 12, 1, A_WeaponReady, HEXEN_S_FAXEREADY_G4, 0, 0},     // HEXEN_S_FAXEREADY_G3
    {HEXEN_SPR_FAXE, 12, 1, A_WeaponReady, HEXEN_S_FAXEREADY_G5, 0, 0},     // HEXEN_S_FAXEREADY_G4
    {HEXEN_SPR_FAXE, 12, 1, A_WeaponReady, HEXEN_S_FAXEREADY_G, 0, 0},      // HEXEN_S_FAXEREADY_G5
    {HEXEN_SPR_FAXE, 11, 1, A_Lower, HEXEN_S_FAXEDOWN_G, 0, 0},     // HEXEN_S_FAXEDOWN_G
    {HEXEN_SPR_FAXE, 11, 1, A_Raise, HEXEN_S_FAXEUP_G, 0, 0},       // HEXEN_S_FAXEUP_G
    {HEXEN_SPR_FAXE, 13, 4, NULL, HEXEN_S_FAXEATK_G2, 15, 32},      // HEXEN_S_FAXEATK_G1
    {HEXEN_SPR_FAXE, 14, 3, NULL, HEXEN_S_FAXEATK_G3, 15, 32},      // HEXEN_S_FAXEATK_G2
    {HEXEN_SPR_FAXE, 15, 2, NULL, HEXEN_S_FAXEATK_G4, 15, 32},      // HEXEN_S_FAXEATK_G3
    {HEXEN_SPR_FAXE, 15, 1, A_FAxeAttack, HEXEN_S_FAXEATK_G5, -5, 70},      // HEXEN_S_FAXEATK_G4
    {HEXEN_SPR_FAXE, 15, 2, NULL, HEXEN_S_FAXEATK_G6, -25, 90},     // HEXEN_S_FAXEATK_G5
    {HEXEN_SPR_FAXE, 16, 1, NULL, HEXEN_S_FAXEATK_G7, 15, 32},      // HEXEN_S_FAXEATK_G6
    {HEXEN_SPR_FAXE, 16, 2, NULL, HEXEN_S_FAXEATK_G8, 10, 54},      // HEXEN_S_FAXEATK_G7
    {HEXEN_SPR_FAXE, 16, 7, NULL, HEXEN_S_FAXEATK_G9, 10, 150},     // HEXEN_S_FAXEATK_G8
    {HEXEN_SPR_FAXE, 0, 1, A_ReFire, HEXEN_S_FAXEATK_G10, 0, 60},   // HEXEN_S_FAXEATK_G9
    {HEXEN_SPR_FAXE, 0, 1, NULL, HEXEN_S_FAXEATK_G11, 0, 52},       // HEXEN_S_FAXEATK_G10
    {HEXEN_SPR_FAXE, 0, 1, NULL, HEXEN_S_FAXEATK_G12, 0, 44},       // HEXEN_S_FAXEATK_G11
    {HEXEN_SPR_FAXE, 0, 1, NULL, HEXEN_S_FAXEATK_G13, 0, 36},       // HEXEN_S_FAXEATK_G12
    {HEXEN_SPR_FAXE, 0, 1, NULL, HEXEN_S_FAXEREADY_G, 0, 0},        // HEXEN_S_FAXEATK_G13
    {HEXEN_SPR_FAXE, 32785, 4, NULL, HEXEN_S_AXEPUFF_GLOW2, 0, 0},  // HEXEN_S_AXEPUFF_GLOW1
    {HEXEN_SPR_FAXE, 32786, 4, NULL, HEXEN_S_AXEPUFF_GLOW3, 0, 0},  // HEXEN_S_AXEPUFF_GLOW2
    {HEXEN_SPR_FAXE, 32787, 4, NULL, HEXEN_S_AXEPUFF_GLOW4, 0, 0},  // HEXEN_S_AXEPUFF_GLOW3
    {HEXEN_SPR_FAXE, 32788, 4, NULL, HEXEN_S_AXEPUFF_GLOW5, 0, 0},  // HEXEN_S_AXEPUFF_GLOW4
    {HEXEN_SPR_FAXE, 32789, 4, NULL, HEXEN_S_AXEPUFF_GLOW6, 0, 0},  // HEXEN_S_AXEPUFF_GLOW5
    {HEXEN_SPR_FAXE, 32790, 4, NULL, HEXEN_S_AXEPUFF_GLOW7, 0, 0},  // HEXEN_S_AXEPUFF_GLOW6
    {HEXEN_SPR_FAXE, 32791, 4, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_AXEPUFF_GLOW7
    {HEXEN_SPR_FAXE, 5, 3, NULL, HEXEN_S_AXEBLOOD2, 0, 0},  // HEXEN_S_AXEBLOOD1
    {HEXEN_SPR_FAXE, 6, 3, NULL, HEXEN_S_AXEBLOOD3, 0, 0},  // HEXEN_S_AXEBLOOD2
    {HEXEN_SPR_FAXE, 7, 3, NULL, HEXEN_S_AXEBLOOD4, 0, 0},  // HEXEN_S_AXEBLOOD3
    {HEXEN_SPR_FAXE, 8, 3, NULL, HEXEN_S_AXEBLOOD5, 0, 0},  // HEXEN_S_AXEBLOOD4
    {HEXEN_SPR_FAXE, 9, 3, NULL, HEXEN_S_AXEBLOOD6, 0, 0},  // HEXEN_S_AXEBLOOD5
    {HEXEN_SPR_FAXE, 10, 3, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_AXEBLOOD6
    {HEXEN_SPR_WFHM, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_HAMM
    {HEXEN_SPR_FHMR, 0, 1, A_WeaponReady, HEXEN_S_FHAMMERREADY, 0, 0},      // HEXEN_S_FHAMMERREADY
    {HEXEN_SPR_FHMR, 0, 1, A_Lower, HEXEN_S_FHAMMERDOWN, 0, 0},     // HEXEN_S_FHAMMERDOWN
    {HEXEN_SPR_FHMR, 0, 1, A_Raise, HEXEN_S_FHAMMERUP, 0, 0},       // HEXEN_S_FHAMMERUP
    {HEXEN_SPR_FHMR, 1, 6, NULL, HEXEN_S_FHAMMERATK_2, 5, 0},       // HEXEN_S_FHAMMERATK_1
    {HEXEN_SPR_FHMR, 2, 3, A_FHammerAttack, HEXEN_S_FHAMMERATK_3, 5, 0},    // HEXEN_S_FHAMMERATK_2
    {HEXEN_SPR_FHMR, 3, 3, NULL, HEXEN_S_FHAMMERATK_4, 5, 0},       // HEXEN_S_FHAMMERATK_3
    {HEXEN_SPR_FHMR, 4, 2, NULL, HEXEN_S_FHAMMERATK_5, 5, 0},       // HEXEN_S_FHAMMERATK_4
    {HEXEN_SPR_FHMR, 4, 10, A_FHammerThrow, HEXEN_S_FHAMMERATK_6, 5, 150},  // HEXEN_S_FHAMMERATK_5
    {HEXEN_SPR_FHMR, 0, 1, NULL, HEXEN_S_FHAMMERATK_7, 0, 60},      // HEXEN_S_FHAMMERATK_6
    {HEXEN_SPR_FHMR, 0, 1, NULL, HEXEN_S_FHAMMERATK_8, 0, 55},      // HEXEN_S_FHAMMERATK_7
    {HEXEN_SPR_FHMR, 0, 1, NULL, HEXEN_S_FHAMMERATK_9, 0, 50},      // HEXEN_S_FHAMMERATK_8
    {HEXEN_SPR_FHMR, 0, 1, NULL, HEXEN_S_FHAMMERATK_10, 0, 45},     // HEXEN_S_FHAMMERATK_9
    {HEXEN_SPR_FHMR, 0, 1, NULL, HEXEN_S_FHAMMERATK_11, 0, 40},     // HEXEN_S_FHAMMERATK_10
    {HEXEN_SPR_FHMR, 0, 1, NULL, HEXEN_S_FHAMMERATK_12, 0, 35},     // HEXEN_S_FHAMMERATK_11
    {HEXEN_SPR_FHMR, 0, 1, NULL, HEXEN_S_FHAMMERREADY, 0, 0},       // HEXEN_S_FHAMMERATK_12
    {HEXEN_SPR_FHFX, 32768, 2, NULL, HEXEN_S_HAMMER_MISSILE_2, 0, 0},       // HEXEN_S_HAMMER_MISSILE_1
    {HEXEN_SPR_FHFX, 32769, 2, A_ContMobjSound, HEXEN_S_HAMMER_MISSILE_3, 0, 0},    // HEXEN_S_HAMMER_MISSILE_2
    {HEXEN_SPR_FHFX, 32770, 2, NULL, HEXEN_S_HAMMER_MISSILE_4, 0, 0},       // HEXEN_S_HAMMER_MISSILE_3
    {HEXEN_SPR_FHFX, 32771, 2, NULL, HEXEN_S_HAMMER_MISSILE_5, 0, 0},       // HEXEN_S_HAMMER_MISSILE_4
    {HEXEN_SPR_FHFX, 32772, 2, NULL, HEXEN_S_HAMMER_MISSILE_6, 0, 0},       // HEXEN_S_HAMMER_MISSILE_5
    {HEXEN_SPR_FHFX, 32773, 2, NULL, HEXEN_S_HAMMER_MISSILE_7, 0, 0},       // HEXEN_S_HAMMER_MISSILE_6
    {HEXEN_SPR_FHFX, 32774, 2, NULL, HEXEN_S_HAMMER_MISSILE_8, 0, 0},       // HEXEN_S_HAMMER_MISSILE_7
    {HEXEN_SPR_FHFX, 32775, 2, NULL, HEXEN_S_HAMMER_MISSILE_1, 0, 0},       // HEXEN_S_HAMMER_MISSILE_8
    {HEXEN_SPR_FHFX, 32776, 3, NULL, HEXEN_S_HAMMER_MISSILE_X2, 0, 0},      // HEXEN_S_HAMMER_MISSILE_X1
    {HEXEN_SPR_FHFX, 32777, 3, NULL, HEXEN_S_HAMMER_MISSILE_X3, 0, 0},      // HEXEN_S_HAMMER_MISSILE_X2
    {HEXEN_SPR_FHFX, 32778, 3, A_Explode, HEXEN_S_HAMMER_MISSILE_X4, 0, 0}, // HEXEN_S_HAMMER_MISSILE_X3
    {HEXEN_SPR_FHFX, 32779, 3, NULL, HEXEN_S_HAMMER_MISSILE_X5, 0, 0},      // HEXEN_S_HAMMER_MISSILE_X4
    {HEXEN_SPR_FHFX, 32780, 3, NULL, HEXEN_S_HAMMER_MISSILE_X6, 0, 0},      // HEXEN_S_HAMMER_MISSILE_X5
    {HEXEN_SPR_FHFX, 13, 3, NULL, HEXEN_S_HAMMER_MISSILE_X7, 0, 0}, // HEXEN_S_HAMMER_MISSILE_X6
    {HEXEN_SPR_FHFX, 32782, 3, NULL, HEXEN_S_HAMMER_MISSILE_X8, 0, 0},      // HEXEN_S_HAMMER_MISSILE_X7
    {HEXEN_SPR_FHFX, 32783, 3, NULL, HEXEN_S_HAMMER_MISSILE_X9, 0, 0},      // HEXEN_S_HAMMER_MISSILE_X8
    {HEXEN_SPR_FHFX, 32784, 3, NULL, HEXEN_S_HAMMER_MISSILE_X10, 0, 0},     // HEXEN_S_HAMMER_MISSILE_X9
    {HEXEN_SPR_FHFX, 32785, 3, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_HAMMER_MISSILE_X10
    {HEXEN_SPR_FHFX, 18, 4, NULL, HEXEN_S_HAMMERPUFF2, 0, 0},       // HEXEN_S_HAMMERPUFF1
    {HEXEN_SPR_FHFX, 19, 4, NULL, HEXEN_S_HAMMERPUFF3, 0, 0},       // HEXEN_S_HAMMERPUFF2
    {HEXEN_SPR_FHFX, 20, 4, NULL, HEXEN_S_HAMMERPUFF4, 0, 0},       // HEXEN_S_HAMMERPUFF3
    {HEXEN_SPR_FHFX, 21, 4, NULL, HEXEN_S_HAMMERPUFF5, 0, 0},       // HEXEN_S_HAMMERPUFF4
    {HEXEN_SPR_FHFX, 22, 4, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_HAMMERPUFF5
    {HEXEN_SPR_FSRD, 32768, 1, A_WeaponReady, HEXEN_S_FSWORDREADY1, 0, 0},  // HEXEN_S_FSWORDREADY
    {HEXEN_SPR_FSRD, 32768, 1, A_WeaponReady, HEXEN_S_FSWORDREADY2, 0, 0},  // HEXEN_S_FSWORDREADY1
    {HEXEN_SPR_FSRD, 32768, 1, A_WeaponReady, HEXEN_S_FSWORDREADY3, 0, 0},  // HEXEN_S_FSWORDREADY2
    {HEXEN_SPR_FSRD, 32768, 1, A_WeaponReady, HEXEN_S_FSWORDREADY4, 0, 0},  // HEXEN_S_FSWORDREADY3
    {HEXEN_SPR_FSRD, 32769, 1, A_WeaponReady, HEXEN_S_FSWORDREADY5, 0, 0},  // HEXEN_S_FSWORDREADY4
    {HEXEN_SPR_FSRD, 32769, 1, A_WeaponReady, HEXEN_S_FSWORDREADY6, 0, 0},  // HEXEN_S_FSWORDREADY5
    {HEXEN_SPR_FSRD, 32769, 1, A_WeaponReady, HEXEN_S_FSWORDREADY7, 0, 0},  // HEXEN_S_FSWORDREADY6
    {HEXEN_SPR_FSRD, 32769, 1, A_WeaponReady, HEXEN_S_FSWORDREADY8, 0, 0},  // HEXEN_S_FSWORDREADY7
    {HEXEN_SPR_FSRD, 32770, 1, A_WeaponReady, HEXEN_S_FSWORDREADY9, 0, 0},  // HEXEN_S_FSWORDREADY8
    {HEXEN_SPR_FSRD, 32770, 1, A_WeaponReady, HEXEN_S_FSWORDREADY10, 0, 0}, // HEXEN_S_FSWORDREADY9
    {HEXEN_SPR_FSRD, 32770, 1, A_WeaponReady, HEXEN_S_FSWORDREADY11, 0, 0}, // HEXEN_S_FSWORDREADY10
    {HEXEN_SPR_FSRD, 32770, 1, A_WeaponReady, HEXEN_S_FSWORDREADY, 0, 0},   // HEXEN_S_FSWORDREADY11
    {HEXEN_SPR_FSRD, 32768, 1, A_Lower, HEXEN_S_FSWORDDOWN, 0, 0},  // HEXEN_S_FSWORDDOWN
    {HEXEN_SPR_FSRD, 32768, 1, A_Raise, HEXEN_S_FSWORDUP, 0, 0},    // HEXEN_S_FSWORDUP
    {HEXEN_SPR_FSRD, 32771, 3, NULL, HEXEN_S_FSWORDATK_2, 5, 36},   // HEXEN_S_FSWORDATK_1
    {HEXEN_SPR_FSRD, 32772, 3, NULL, HEXEN_S_FSWORDATK_3, 5, 36},   // HEXEN_S_FSWORDATK_2
    {HEXEN_SPR_FSRD, 32773, 2, NULL, HEXEN_S_FSWORDATK_4, 5, 36},   // HEXEN_S_FSWORDATK_3
    {HEXEN_SPR_FSRD, 32774, 3, A_FSwordAttack, HEXEN_S_FSWORDATK_5, 5, 36}, // HEXEN_S_FSWORDATK_4
    {HEXEN_SPR_FSRD, 32775, 2, NULL, HEXEN_S_FSWORDATK_6, 5, 36},   // HEXEN_S_FSWORDATK_5
    {HEXEN_SPR_FSRD, 32776, 2, NULL, HEXEN_S_FSWORDATK_7, 5, 36},   // HEXEN_S_FSWORDATK_6
    {HEXEN_SPR_FSRD, 32776, 10, NULL, HEXEN_S_FSWORDATK_8, 5, 150}, // HEXEN_S_FSWORDATK_7
    {HEXEN_SPR_FSRD, 32768, 1, NULL, HEXEN_S_FSWORDATK_9, 5, 60},   // HEXEN_S_FSWORDATK_8
    {HEXEN_SPR_FSRD, 32769, 1, NULL, HEXEN_S_FSWORDATK_10, 5, 55},  // HEXEN_S_FSWORDATK_9
    {HEXEN_SPR_FSRD, 32770, 1, NULL, HEXEN_S_FSWORDATK_11, 5, 50},  // HEXEN_S_FSWORDATK_10
    {HEXEN_SPR_FSRD, 32768, 1, NULL, HEXEN_S_FSWORDATK_12, 5, 45},  // HEXEN_S_FSWORDATK_11
    {HEXEN_SPR_FSRD, 32769, 1, NULL, HEXEN_S_FSWORDREADY, 5, 40},   // HEXEN_S_FSWORDATK_12
    {HEXEN_SPR_FSFX, 32768, 3, NULL, HEXEN_S_FSWORD_MISSILE2, 0, 0},        // HEXEN_S_FSWORD_MISSILE1
    {HEXEN_SPR_FSFX, 32769, 3, NULL, HEXEN_S_FSWORD_MISSILE3, 0, 0},        // HEXEN_S_FSWORD_MISSILE2
    {HEXEN_SPR_FSFX, 32770, 3, NULL, HEXEN_S_FSWORD_MISSILE1, 0, 0},        // HEXEN_S_FSWORD_MISSILE3
    {HEXEN_SPR_FSFX, 32771, 4, NULL, HEXEN_S_FSWORD_MISSILE_X2, 0, 0},      // HEXEN_S_FSWORD_MISSILE_X1
    {HEXEN_SPR_FSFX, 32772, 3, A_FSwordFlames, HEXEN_S_FSWORD_MISSILE_X3, 0, 0},    // HEXEN_S_FSWORD_MISSILE_X2
    {HEXEN_SPR_FSFX, 32773, 4, A_Explode, HEXEN_S_FSWORD_MISSILE_X4, 0, 0}, // HEXEN_S_FSWORD_MISSILE_X3
    {HEXEN_SPR_FSFX, 32774, 3, NULL, HEXEN_S_FSWORD_MISSILE_X5, 0, 0},      // HEXEN_S_FSWORD_MISSILE_X4
    {HEXEN_SPR_FSFX, 32775, 4, NULL, HEXEN_S_FSWORD_MISSILE_X6, 0, 0},      // HEXEN_S_FSWORD_MISSILE_X5
    {HEXEN_SPR_FSFX, 32776, 3, NULL, HEXEN_S_FSWORD_MISSILE_X7, 0, 0},      // HEXEN_S_FSWORD_MISSILE_X6
    {HEXEN_SPR_FSFX, 32777, 4, NULL, HEXEN_S_FSWORD_MISSILE_X8, 0, 0},      // HEXEN_S_FSWORD_MISSILE_X7
    {HEXEN_SPR_FSFX, 32778, 3, NULL, HEXEN_S_FSWORD_MISSILE_X9, 0, 0},      // HEXEN_S_FSWORD_MISSILE_X8
    {HEXEN_SPR_FSFX, 32779, 3, NULL, HEXEN_S_FSWORD_MISSILE_X10, 0, 0},     // HEXEN_S_FSWORD_MISSILE_X9
    {HEXEN_SPR_FSFX, 32780, 3, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_FSWORD_MISSILE_X10
    {HEXEN_SPR_FSFX, 32781, 3, NULL, HEXEN_S_FSWORD_FLAME2, 0, 0},  // HEXEN_S_FSWORD_FLAME1
    {HEXEN_SPR_FSFX, 32782, 3, NULL, HEXEN_S_FSWORD_FLAME3, 0, 0},  // HEXEN_S_FSWORD_FLAME2
    {HEXEN_SPR_FSFX, 32783, 3, NULL, HEXEN_S_FSWORD_FLAME4, 0, 0},  // HEXEN_S_FSWORD_FLAME3
    {HEXEN_SPR_FSFX, 32784, 3, NULL, HEXEN_S_FSWORD_FLAME5, 0, 0},  // HEXEN_S_FSWORD_FLAME4
    {HEXEN_SPR_FSFX, 32785, 3, NULL, HEXEN_S_FSWORD_FLAME6, 0, 0},  // HEXEN_S_FSWORD_FLAME5
    {HEXEN_SPR_FSFX, 32786, 3, NULL, HEXEN_S_FSWORD_FLAME7, 0, 0},  // HEXEN_S_FSWORD_FLAME6
    {HEXEN_SPR_FSFX, 32787, 3, NULL, HEXEN_S_FSWORD_FLAME8, 0, 0},  // HEXEN_S_FSWORD_FLAME7
    {HEXEN_SPR_FSFX, 32788, 3, NULL, HEXEN_S_FSWORD_FLAME9, 0, 0},  // HEXEN_S_FSWORD_FLAME8
    {HEXEN_SPR_FSFX, 32789, 3, NULL, HEXEN_S_FSWORD_FLAME10, 0, 0}, // HEXEN_S_FSWORD_FLAME9
    {HEXEN_SPR_FSFX, 32790, 3, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_FSWORD_FLAME10
    {HEXEN_SPR_CMCE, 0, 1, A_WeaponReady, HEXEN_S_CMACEREADY, 0, 0},        // HEXEN_S_CMACEREADY
    {HEXEN_SPR_CMCE, 0, 1, A_Lower, HEXEN_S_CMACEDOWN, 0, 0},       // HEXEN_S_CMACEDOWN
    {HEXEN_SPR_CMCE, 0, 1, A_Raise, HEXEN_S_CMACEUP, 0, 0}, // HEXEN_S_CMACEUP
    {HEXEN_SPR_CMCE, 1, 2, NULL, HEXEN_S_CMACEATK_2, 60, 20},       // HEXEN_S_CMACEATK_1
    {HEXEN_SPR_CMCE, 1, 1, NULL, HEXEN_S_CMACEATK_3, 30, 33},       // HEXEN_S_CMACEATK_2
    {HEXEN_SPR_CMCE, 1, 2, NULL, HEXEN_S_CMACEATK_4, 8, 45},        // HEXEN_S_CMACEATK_3
    {HEXEN_SPR_CMCE, 2, 1, NULL, HEXEN_S_CMACEATK_5, 8, 45},        // HEXEN_S_CMACEATK_4
    {HEXEN_SPR_CMCE, 3, 1, NULL, HEXEN_S_CMACEATK_6, 8, 45},        // HEXEN_S_CMACEATK_5
    {HEXEN_SPR_CMCE, 4, 1, NULL, HEXEN_S_CMACEATK_7, 8, 45},        // HEXEN_S_CMACEATK_6
    {HEXEN_SPR_CMCE, 4, 1, A_CMaceAttack, HEXEN_S_CMACEATK_8, -11, 58},     // HEXEN_S_CMACEATK_7
    {HEXEN_SPR_CMCE, 5, 1, NULL, HEXEN_S_CMACEATK_9, 8, 45},        // HEXEN_S_CMACEATK_8
    {HEXEN_SPR_CMCE, 5, 2, NULL, HEXEN_S_CMACEATK_10, -8, 74},      // HEXEN_S_CMACEATK_9
    {HEXEN_SPR_CMCE, 5, 1, NULL, HEXEN_S_CMACEATK_11, -20, 96},     // HEXEN_S_CMACEATK_10
    {HEXEN_SPR_CMCE, 5, 8, NULL, HEXEN_S_CMACEATK_12, -33, 160},    // HEXEN_S_CMACEATK_11
    {HEXEN_SPR_CMCE, 0, 2, A_ReFire, HEXEN_S_CMACEATK_13, 8, 75},   // HEXEN_S_CMACEATK_12
    {HEXEN_SPR_CMCE, 0, 1, NULL, HEXEN_S_CMACEATK_14, 8, 65},       // HEXEN_S_CMACEATK_13
    {HEXEN_SPR_CMCE, 0, 2, NULL, HEXEN_S_CMACEATK_15, 8, 60},       // HEXEN_S_CMACEATK_14
    {HEXEN_SPR_CMCE, 0, 1, NULL, HEXEN_S_CMACEATK_16, 8, 55},       // HEXEN_S_CMACEATK_15
    {HEXEN_SPR_CMCE, 0, 2, NULL, HEXEN_S_CMACEATK_17, 8, 50},       // HEXEN_S_CMACEATK_16
    {HEXEN_SPR_CMCE, 0, 1, NULL, HEXEN_S_CMACEREADY, 8, 45},        // HEXEN_S_CMACEATK_17
    {HEXEN_SPR_WCSS, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_CSTAFF
    {HEXEN_SPR_CSSF, 2, 4, NULL, HEXEN_S_CSTAFFREADY1, 0, 0},       // HEXEN_S_CSTAFFREADY
    {HEXEN_SPR_CSSF, 1, 3, A_CStaffInitBlink, HEXEN_S_CSTAFFREADY2, 0, 0},  // HEXEN_S_CSTAFFREADY1
    {HEXEN_SPR_CSSF, 0, 1, A_WeaponReady, HEXEN_S_CSTAFFREADY3, 0, 0},      // HEXEN_S_CSTAFFREADY2
    {HEXEN_SPR_CSSF, 0, 1, A_WeaponReady, HEXEN_S_CSTAFFREADY4, 0, 0},      // HEXEN_S_CSTAFFREADY3
    {HEXEN_SPR_CSSF, 0, 1, A_WeaponReady, HEXEN_S_CSTAFFREADY5, 0, 0},      // HEXEN_S_CSTAFFREADY4
    {HEXEN_SPR_CSSF, 0, 1, A_WeaponReady, HEXEN_S_CSTAFFREADY6, 0, 0},      // HEXEN_S_CSTAFFREADY5
    {HEXEN_SPR_CSSF, 0, 1, A_WeaponReady, HEXEN_S_CSTAFFREADY7, 0, 0},      // HEXEN_S_CSTAFFREADY6
    {HEXEN_SPR_CSSF, 0, 1, A_WeaponReady, HEXEN_S_CSTAFFREADY8, 0, 0},      // HEXEN_S_CSTAFFREADY7
    {HEXEN_SPR_CSSF, 0, 1, A_WeaponReady, HEXEN_S_CSTAFFREADY9, 0, 0},      // HEXEN_S_CSTAFFREADY8
    {HEXEN_SPR_CSSF, 0, 1, A_CStaffCheckBlink, HEXEN_S_CSTAFFREADY2, 0, 0}, // HEXEN_S_CSTAFFREADY9
    {HEXEN_SPR_CSSF, 1, 1, A_WeaponReady, HEXEN_S_CSTAFFBLINK2, 0, 0},      // HEXEN_S_CSTAFFBLINK1
    {HEXEN_SPR_CSSF, 1, 1, A_WeaponReady, HEXEN_S_CSTAFFBLINK3, 0, 0},      // HEXEN_S_CSTAFFBLINK2
    {HEXEN_SPR_CSSF, 1, 1, A_WeaponReady, HEXEN_S_CSTAFFBLINK4, 0, 0},      // HEXEN_S_CSTAFFBLINK3
    {HEXEN_SPR_CSSF, 2, 1, A_WeaponReady, HEXEN_S_CSTAFFBLINK5, 0, 0},      // HEXEN_S_CSTAFFBLINK4
    {HEXEN_SPR_CSSF, 2, 1, A_WeaponReady, HEXEN_S_CSTAFFBLINK6, 0, 0},      // HEXEN_S_CSTAFFBLINK5
    {HEXEN_SPR_CSSF, 2, 1, A_WeaponReady, HEXEN_S_CSTAFFBLINK7, 0, 0},      // HEXEN_S_CSTAFFBLINK6
    {HEXEN_SPR_CSSF, 2, 1, A_WeaponReady, HEXEN_S_CSTAFFBLINK8, 0, 0},      // HEXEN_S_CSTAFFBLINK7
    {HEXEN_SPR_CSSF, 2, 1, A_WeaponReady, HEXEN_S_CSTAFFBLINK9, 0, 0},      // HEXEN_S_CSTAFFBLINK8
    {HEXEN_SPR_CSSF, 1, 1, A_WeaponReady, HEXEN_S_CSTAFFBLINK10, 0, 0},     // HEXEN_S_CSTAFFBLINK9
    {HEXEN_SPR_CSSF, 1, 1, A_WeaponReady, HEXEN_S_CSTAFFBLINK11, 0, 0},     // HEXEN_S_CSTAFFBLINK10
    {HEXEN_SPR_CSSF, 1, 1, A_WeaponReady, HEXEN_S_CSTAFFREADY2, 0, 0},      // HEXEN_S_CSTAFFBLINK11
    {HEXEN_SPR_CSSF, 1, 3, NULL, HEXEN_S_CSTAFFDOWN2, 0, 0},        // HEXEN_S_CSTAFFDOWN
    {HEXEN_SPR_CSSF, 2, 4, NULL, HEXEN_S_CSTAFFDOWN3, 0, 0},        // HEXEN_S_CSTAFFDOWN2
    {HEXEN_SPR_CSSF, 2, 1, A_Lower, HEXEN_S_CSTAFFDOWN3, 0, 0},     // HEXEN_S_CSTAFFDOWN3
    {HEXEN_SPR_CSSF, 2, 1, A_Raise, HEXEN_S_CSTAFFUP, 0, 0},        // HEXEN_S_CSTAFFUP
    {HEXEN_SPR_CSSF, 0, 1, A_CStaffCheck, HEXEN_S_CSTAFFATK_2, 0, 45},      // HEXEN_S_CSTAFFATK_1
    {HEXEN_SPR_CSSF, 9, 1, A_CStaffAttack, HEXEN_S_CSTAFFATK_3, 0, 50},     // HEXEN_S_CSTAFFATK_2
    {HEXEN_SPR_CSSF, 9, 2, NULL, HEXEN_S_CSTAFFATK_4, 0, 50},       // HEXEN_S_CSTAFFATK_3
    {HEXEN_SPR_CSSF, 9, 2, NULL, HEXEN_S_CSTAFFATK_5, 0, 45},       // HEXEN_S_CSTAFFATK_4
    {HEXEN_SPR_CSSF, 0, 2, NULL, HEXEN_S_CSTAFFATK_6, 0, 40},       // HEXEN_S_CSTAFFATK_5
    {HEXEN_SPR_CSSF, 0, 2, NULL, HEXEN_S_CSTAFFREADY2, 0, 36},      // HEXEN_S_CSTAFFATK_6
    {HEXEN_SPR_CSSF, 10, 10, NULL, HEXEN_S_CSTAFFREADY2, 0, 36},    // HEXEN_S_CSTAFFATK2_1
    {HEXEN_SPR_CSSF, 32771, 1, A_CStaffMissileSlither, HEXEN_S_CSTAFF_MISSILE2, 0, 0},      // HEXEN_S_CSTAFF_MISSILE1
    {HEXEN_SPR_CSSF, 32771, 1, A_CStaffMissileSlither, HEXEN_S_CSTAFF_MISSILE3, 0, 0},      // HEXEN_S_CSTAFF_MISSILE2
    {HEXEN_SPR_CSSF, 32772, 1, A_CStaffMissileSlither, HEXEN_S_CSTAFF_MISSILE4, 0, 0},      // HEXEN_S_CSTAFF_MISSILE3
    {HEXEN_SPR_CSSF, 32772, 1, A_CStaffMissileSlither, HEXEN_S_CSTAFF_MISSILE1, 0, 0},      // HEXEN_S_CSTAFF_MISSILE4
    {HEXEN_SPR_CSSF, 32773, 4, NULL, HEXEN_S_CSTAFF_MISSILE_X2, 0, 0},      // HEXEN_S_CSTAFF_MISSILE_X1
    {HEXEN_SPR_CSSF, 32774, 4, NULL, HEXEN_S_CSTAFF_MISSILE_X3, 0, 0},      // HEXEN_S_CSTAFF_MISSILE_X2
    {HEXEN_SPR_CSSF, 32775, 3, NULL, HEXEN_S_CSTAFF_MISSILE_X4, 0, 0},      // HEXEN_S_CSTAFF_MISSILE_X3
    {HEXEN_SPR_CSSF, 32776, 3, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_CSTAFF_MISSILE_X4
    {HEXEN_SPR_FHFX, 18, 4, NULL, HEXEN_S_CSTAFFPUFF2, 0, 0},       // HEXEN_S_CSTAFFPUFF1
    {HEXEN_SPR_FHFX, 19, 4, NULL, HEXEN_S_CSTAFFPUFF3, 0, 0},       // HEXEN_S_CSTAFFPUFF2
    {HEXEN_SPR_FHFX, 20, 4, NULL, HEXEN_S_CSTAFFPUFF4, 0, 0},       // HEXEN_S_CSTAFFPUFF3
    {HEXEN_SPR_FHFX, 21, 4, NULL, HEXEN_S_CSTAFFPUFF5, 0, 0},       // HEXEN_S_CSTAFFPUFF4
    {HEXEN_SPR_FHFX, 22, 4, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_CSTAFFPUFF5
    {HEXEN_SPR_WCFM, 32768, 4, NULL, HEXEN_S_CFLAME2, 0, 0},        // HEXEN_S_CFLAME1
    {HEXEN_SPR_WCFM, 32769, 4, NULL, HEXEN_S_CFLAME3, 0, 0},        // HEXEN_S_CFLAME2
    {HEXEN_SPR_WCFM, 32770, 4, NULL, HEXEN_S_CFLAME4, 0, 0},        // HEXEN_S_CFLAME3
    {HEXEN_SPR_WCFM, 32771, 4, NULL, HEXEN_S_CFLAME5, 0, 0},        // HEXEN_S_CFLAME4
    {HEXEN_SPR_WCFM, 32772, 4, NULL, HEXEN_S_CFLAME6, 0, 0},        // HEXEN_S_CFLAME5
    {HEXEN_SPR_WCFM, 32773, 4, NULL, HEXEN_S_CFLAME7, 0, 0},        // HEXEN_S_CFLAME6
    {HEXEN_SPR_WCFM, 32774, 4, NULL, HEXEN_S_CFLAME8, 0, 0},        // HEXEN_S_CFLAME7
    {HEXEN_SPR_WCFM, 32775, 4, NULL, HEXEN_S_CFLAME1, 0, 0},        // HEXEN_S_CFLAME8
    {HEXEN_SPR_CFLM, 0, 1, A_WeaponReady, HEXEN_S_CFLAMEREADY2, 0, 0},      // HEXEN_S_CFLAMEREADY1
    {HEXEN_SPR_CFLM, 0, 1, A_WeaponReady, HEXEN_S_CFLAMEREADY3, 0, 0},      // HEXEN_S_CFLAMEREADY2
    {HEXEN_SPR_CFLM, 0, 1, A_WeaponReady, HEXEN_S_CFLAMEREADY4, 0, 0},      // HEXEN_S_CFLAMEREADY3
    {HEXEN_SPR_CFLM, 0, 1, A_WeaponReady, HEXEN_S_CFLAMEREADY5, 0, 0},      // HEXEN_S_CFLAMEREADY4
    {HEXEN_SPR_CFLM, 1, 1, A_WeaponReady, HEXEN_S_CFLAMEREADY6, 0, 0},      // HEXEN_S_CFLAMEREADY5
    {HEXEN_SPR_CFLM, 1, 1, A_WeaponReady, HEXEN_S_CFLAMEREADY7, 0, 0},      // HEXEN_S_CFLAMEREADY6
    {HEXEN_SPR_CFLM, 1, 1, A_WeaponReady, HEXEN_S_CFLAMEREADY8, 0, 0},      // HEXEN_S_CFLAMEREADY7
    {HEXEN_SPR_CFLM, 1, 1, A_WeaponReady, HEXEN_S_CFLAMEREADY9, 0, 0},      // HEXEN_S_CFLAMEREADY8
    {HEXEN_SPR_CFLM, 2, 1, A_WeaponReady, HEXEN_S_CFLAMEREADY10, 0, 0},     // HEXEN_S_CFLAMEREADY9
    {HEXEN_SPR_CFLM, 2, 1, A_WeaponReady, HEXEN_S_CFLAMEREADY11, 0, 0},     // HEXEN_S_CFLAMEREADY10
    {HEXEN_SPR_CFLM, 2, 1, A_WeaponReady, HEXEN_S_CFLAMEREADY12, 0, 0},     // HEXEN_S_CFLAMEREADY11
    {HEXEN_SPR_CFLM, 2, 1, A_WeaponReady, HEXEN_S_CFLAMEREADY1, 0, 0},      // HEXEN_S_CFLAMEREADY12
    {HEXEN_SPR_CFLM, 0, 1, A_Lower, HEXEN_S_CFLAMEDOWN, 0, 0},      // HEXEN_S_CFLAMEDOWN
    {HEXEN_SPR_CFLM, 0, 1, A_Raise, HEXEN_S_CFLAMEUP, 0, 0},        // HEXEN_S_CFLAMEUP
    {HEXEN_SPR_CFLM, 0, 2, NULL, HEXEN_S_CFLAMEATK_2, 0, 40},       // HEXEN_S_CFLAMEATK_1
    {HEXEN_SPR_CFLM, 3, 2, NULL, HEXEN_S_CFLAMEATK_3, 0, 50},       // HEXEN_S_CFLAMEATK_2
    {HEXEN_SPR_CFLM, 3, 2, NULL, HEXEN_S_CFLAMEATK_4, 0, 36},       // HEXEN_S_CFLAMEATK_3
    {HEXEN_SPR_CFLM, 32772, 4, NULL, HEXEN_S_CFLAMEATK_5, 0, 0},    // HEXEN_S_CFLAMEATK_4
    {HEXEN_SPR_CFLM, 32773, 4, A_CFlameAttack, HEXEN_S_CFLAMEATK_6, 0, 0},  // HEXEN_S_CFLAMEATK_5
    {HEXEN_SPR_CFLM, 32772, 4, NULL, HEXEN_S_CFLAMEATK_7, 0, 0},    // HEXEN_S_CFLAMEATK_6
    {HEXEN_SPR_CFLM, 6, 2, NULL, HEXEN_S_CFLAMEATK_8, 0, 40},       // HEXEN_S_CFLAMEATK_7
    {HEXEN_SPR_CFLM, 6, 2, NULL, HEXEN_S_CFLAMEREADY1, 0, 0},       // HEXEN_S_CFLAMEATK_8
    {HEXEN_SPR_CFFX, 32781, 5, NULL, HEXEN_S_CFLAMEFLOOR2, 0, 0},   // HEXEN_S_CFLAMEFLOOR1
    {HEXEN_SPR_CFFX, 32782, 4, NULL, HEXEN_S_CFLAMEFLOOR3, 0, 0},   // HEXEN_S_CFLAMEFLOOR2
    {HEXEN_SPR_CFFX, 32783, 3, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_CFLAMEFLOOR3
    {HEXEN_SPR_CFFX, 32768, 3, NULL, HEXEN_S_FLAMEPUFF2, 0, 0},     // HEXEN_S_FLAMEPUFF1
    {HEXEN_SPR_CFFX, 32769, 3, NULL, HEXEN_S_FLAMEPUFF3, 0, 0},     // HEXEN_S_FLAMEPUFF2
    {HEXEN_SPR_CFFX, 32770, 3, NULL, HEXEN_S_FLAMEPUFF4, 0, 0},     // HEXEN_S_FLAMEPUFF3
    {HEXEN_SPR_CFFX, 32771, 4, NULL, HEXEN_S_FLAMEPUFF5, 0, 0},     // HEXEN_S_FLAMEPUFF4
    {HEXEN_SPR_CFFX, 32772, 3, NULL, HEXEN_S_FLAMEPUFF6, 0, 0},     // HEXEN_S_FLAMEPUFF5
    {HEXEN_SPR_CFFX, 32773, 4, NULL, HEXEN_S_FLAMEPUFF7, 0, 0},     // HEXEN_S_FLAMEPUFF6
    {HEXEN_SPR_CFFX, 32774, 3, NULL, HEXEN_S_FLAMEPUFF8, 0, 0},     // HEXEN_S_FLAMEPUFF7
    {HEXEN_SPR_CFFX, 32775, 4, NULL, HEXEN_S_FLAMEPUFF9, 0, 0},     // HEXEN_S_FLAMEPUFF8
    {HEXEN_SPR_CFFX, 32776, 3, NULL, HEXEN_S_FLAMEPUFF10, 0, 0},    // HEXEN_S_FLAMEPUFF9
    {HEXEN_SPR_CFFX, 32777, 4, NULL, HEXEN_S_FLAMEPUFF11, 0, 0},    // HEXEN_S_FLAMEPUFF10
    {HEXEN_SPR_CFFX, 32778, 3, NULL, HEXEN_S_FLAMEPUFF12, 0, 0},    // HEXEN_S_FLAMEPUFF11
    {HEXEN_SPR_CFFX, 32779, 4, NULL, HEXEN_S_FLAMEPUFF13, 0, 0},    // HEXEN_S_FLAMEPUFF12
    {HEXEN_SPR_CFFX, 32780, 3, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_FLAMEPUFF13
    {HEXEN_SPR_CFFX, 32768, 3, NULL, HEXEN_S_FLAMEPUFF2_2, 0, 0},   // HEXEN_S_FLAMEPUFF2_1
    {HEXEN_SPR_CFFX, 32769, 3, NULL, HEXEN_S_FLAMEPUFF2_3, 0, 0},   // HEXEN_S_FLAMEPUFF2_2
    {HEXEN_SPR_CFFX, 32770, 3, NULL, HEXEN_S_FLAMEPUFF2_4, 0, 0},   // HEXEN_S_FLAMEPUFF2_3
    {HEXEN_SPR_CFFX, 32771, 4, NULL, HEXEN_S_FLAMEPUFF2_5, 0, 0},   // HEXEN_S_FLAMEPUFF2_4
    {HEXEN_SPR_CFFX, 32772, 3, NULL, HEXEN_S_FLAMEPUFF2_6, 0, 0},   // HEXEN_S_FLAMEPUFF2_5
    {HEXEN_SPR_CFFX, 32773, 4, NULL, HEXEN_S_FLAMEPUFF2_7, 0, 0},   // HEXEN_S_FLAMEPUFF2_6
    {HEXEN_SPR_CFFX, 32774, 3, NULL, HEXEN_S_FLAMEPUFF2_8, 0, 0},   // HEXEN_S_FLAMEPUFF2_7
    {HEXEN_SPR_CFFX, 32775, 4, NULL, HEXEN_S_FLAMEPUFF2_9, 0, 0},   // HEXEN_S_FLAMEPUFF2_8
    {HEXEN_SPR_CFFX, 32776, 3, NULL, HEXEN_S_FLAMEPUFF2_10, 0, 0},  // HEXEN_S_FLAMEPUFF2_9
    {HEXEN_SPR_CFFX, 32770, 3, NULL, HEXEN_S_FLAMEPUFF2_11, 0, 0},  // HEXEN_S_FLAMEPUFF2_10
    {HEXEN_SPR_CFFX, 32771, 4, NULL, HEXEN_S_FLAMEPUFF2_12, 0, 0},  // HEXEN_S_FLAMEPUFF2_11
    {HEXEN_SPR_CFFX, 32772, 3, NULL, HEXEN_S_FLAMEPUFF2_13, 0, 0},  // HEXEN_S_FLAMEPUFF2_12
    {HEXEN_SPR_CFFX, 32773, 4, NULL, HEXEN_S_FLAMEPUFF2_14, 0, 0},  // HEXEN_S_FLAMEPUFF2_13
    {HEXEN_SPR_CFFX, 32774, 3, NULL, HEXEN_S_FLAMEPUFF2_15, 0, 0},  // HEXEN_S_FLAMEPUFF2_14
    {HEXEN_SPR_CFFX, 32775, 4, NULL, HEXEN_S_FLAMEPUFF2_16, 0, 0},  // HEXEN_S_FLAMEPUFF2_15
    {HEXEN_SPR_CFFX, 32776, 3, NULL, HEXEN_S_FLAMEPUFF2_17, 0, 0},  // HEXEN_S_FLAMEPUFF2_16
    {HEXEN_SPR_CFFX, 32777, 4, NULL, HEXEN_S_FLAMEPUFF2_18, 0, 0},  // HEXEN_S_FLAMEPUFF2_17
    {HEXEN_SPR_CFFX, 32778, 3, NULL, HEXEN_S_FLAMEPUFF2_19, 0, 0},  // HEXEN_S_FLAMEPUFF2_18
    {HEXEN_SPR_CFFX, 32779, 4, NULL, HEXEN_S_FLAMEPUFF2_20, 0, 0},  // HEXEN_S_FLAMEPUFF2_19
    {HEXEN_SPR_CFFX, 32780, 3, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_FLAMEPUFF2_20
    {HEXEN_SPR_CFCF, 32768, 4, NULL, HEXEN_S_CIRCLE_FLAME2, 0, 0},  // HEXEN_S_CIRCLE_FLAME1
    {HEXEN_SPR_CFCF, 32769, 2, A_CFlameRotate, HEXEN_S_CIRCLE_FLAME3, 0, 0},        // HEXEN_S_CIRCLE_FLAME2
    {HEXEN_SPR_CFCF, 32770, 2, NULL, HEXEN_S_CIRCLE_FLAME4, 0, 0},  // HEXEN_S_CIRCLE_FLAME3
    {HEXEN_SPR_CFCF, 32771, 1, NULL, HEXEN_S_CIRCLE_FLAME5, 0, 0},  // HEXEN_S_CIRCLE_FLAME4
    {HEXEN_SPR_CFCF, 32772, 2, NULL, HEXEN_S_CIRCLE_FLAME6, 0, 0},  // HEXEN_S_CIRCLE_FLAME5
    {HEXEN_SPR_CFCF, 32773, 2, A_CFlameRotate, HEXEN_S_CIRCLE_FLAME7, 0, 0},        // HEXEN_S_CIRCLE_FLAME6
    {HEXEN_SPR_CFCF, 32774, 1, NULL, HEXEN_S_CIRCLE_FLAME8, 0, 0},  // HEXEN_S_CIRCLE_FLAME7
    {HEXEN_SPR_CFCF, 32775, 2, NULL, HEXEN_S_CIRCLE_FLAME9, 0, 0},  // HEXEN_S_CIRCLE_FLAME8
    {HEXEN_SPR_CFCF, 32776, 2, NULL, HEXEN_S_CIRCLE_FLAME10, 0, 0}, // HEXEN_S_CIRCLE_FLAME9
    {HEXEN_SPR_CFCF, 32777, 1, A_CFlameRotate, HEXEN_S_CIRCLE_FLAME11, 0, 0},       // HEXEN_S_CIRCLE_FLAME10
    {HEXEN_SPR_CFCF, 32778, 2, NULL, HEXEN_S_CIRCLE_FLAME12, 0, 0}, // HEXEN_S_CIRCLE_FLAME11
    {HEXEN_SPR_CFCF, 32779, 3, NULL, HEXEN_S_CIRCLE_FLAME13, 0, 0}, // HEXEN_S_CIRCLE_FLAME12
    {HEXEN_SPR_CFCF, 32780, 3, NULL, HEXEN_S_CIRCLE_FLAME14, 0, 0}, // HEXEN_S_CIRCLE_FLAME13
    {HEXEN_SPR_CFCF, 32781, 2, A_CFlameRotate, HEXEN_S_CIRCLE_FLAME15, 0, 0},       // HEXEN_S_CIRCLE_FLAME14
    {HEXEN_SPR_CFCF, 32782, 3, NULL, HEXEN_S_CIRCLE_FLAME16, 0, 0}, // HEXEN_S_CIRCLE_FLAME15
    {HEXEN_SPR_CFCF, 32783, 2, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_CIRCLE_FLAME16
    {HEXEN_SPR_CFCF, 32784, 3, NULL, HEXEN_S_CIRCLE_FLAME_X2, 0, 0},        // HEXEN_S_CIRCLE_FLAME_X1
    {HEXEN_SPR_CFCF, 32785, 3, NULL, HEXEN_S_CIRCLE_FLAME_X3, 0, 0},        // HEXEN_S_CIRCLE_FLAME_X2
    {HEXEN_SPR_CFCF, 32786, 3, A_Explode, HEXEN_S_CIRCLE_FLAME_X4, 0, 0},   // HEXEN_S_CIRCLE_FLAME_X3
    {HEXEN_SPR_CFCF, 32787, 3, NULL, HEXEN_S_CIRCLE_FLAME_X5, 0, 0},        // HEXEN_S_CIRCLE_FLAME_X4
    {HEXEN_SPR_CFCF, 32788, 3, NULL, HEXEN_S_CIRCLE_FLAME_X6, 0, 0},        // HEXEN_S_CIRCLE_FLAME_X5
    {HEXEN_SPR_CFCF, 32789, 3, NULL, HEXEN_S_CIRCLE_FLAME_X7, 0, 0},        // HEXEN_S_CIRCLE_FLAME_X6
    {HEXEN_SPR_CFCF, 32790, 3, NULL, HEXEN_S_CIRCLE_FLAME_X8, 0, 0},        // HEXEN_S_CIRCLE_FLAME_X7
    {HEXEN_SPR_CFCF, 32791, 3, NULL, HEXEN_S_CIRCLE_FLAME_X9, 0, 0},        // HEXEN_S_CIRCLE_FLAME_X8
    {HEXEN_SPR_CFCF, 32792, 3, NULL, HEXEN_S_CIRCLE_FLAME_X10, 0, 0},       // HEXEN_S_CIRCLE_FLAME_X9
    {HEXEN_SPR_CFCF, 32793, 3, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_CIRCLE_FLAME_X10
    {HEXEN_SPR_CFFX, 32768, 4, NULL, HEXEN_S_CFLAME_MISSILE2, 0, 0},        // HEXEN_S_CFLAME_MISSILE1
    {HEXEN_SPR_CFFX, 0, 1, A_CFlamePuff, HEXEN_S_FLAMEPUFF1, 0, 0}, // HEXEN_S_CFLAME_MISSILE2
    {HEXEN_SPR_CFFX, 32768, 1, A_CFlameMissile, HEXEN_S_FLAMEPUFF1, 0, 0},  // HEXEN_S_CFLAME_MISSILE_X
    {HEXEN_SPR_CHLY, 0, 1, A_WeaponReady, HEXEN_S_CHOLYREADY, 0, 0},        // HEXEN_S_CHOLYREADY
    {HEXEN_SPR_CHLY, 0, 1, A_Lower, HEXEN_S_CHOLYDOWN, 0, 0},       // HEXEN_S_CHOLYDOWN
    {HEXEN_SPR_CHLY, 0, 1, A_Raise, HEXEN_S_CHOLYUP, 0, 0}, // HEXEN_S_CHOLYUP
    {HEXEN_SPR_CHLY, 32768, 1, NULL, HEXEN_S_CHOLYATK_2, 0, 40},    // HEXEN_S_CHOLYATK_1
    {HEXEN_SPR_CHLY, 32769, 1, NULL, HEXEN_S_CHOLYATK_3, 0, 40},    // HEXEN_S_CHOLYATK_2
    {HEXEN_SPR_CHLY, 32770, 2, NULL, HEXEN_S_CHOLYATK_4, 0, 43},    // HEXEN_S_CHOLYATK_3
    {HEXEN_SPR_CHLY, 32771, 2, NULL, HEXEN_S_CHOLYATK_5, 0, 43},    // HEXEN_S_CHOLYATK_4
    {HEXEN_SPR_CHLY, 32772, 2, NULL, HEXEN_S_CHOLYATK_6, 0, 45},    // HEXEN_S_CHOLYATK_5
    {HEXEN_SPR_CHLY, 32773, 6, A_CHolyAttack, HEXEN_S_CHOLYATK_7, 0, 48},   // HEXEN_S_CHOLYATK_6
    {HEXEN_SPR_CHLY, 32774, 2, A_CHolyPalette, HEXEN_S_CHOLYATK_8, 0, 40},  // HEXEN_S_CHOLYATK_7
    {HEXEN_SPR_CHLY, 32774, 2, A_CHolyPalette, HEXEN_S_CHOLYATK_9, 0, 40},  // HEXEN_S_CHOLYATK_8
    {HEXEN_SPR_CHLY, 32774, 2, A_CHolyPalette, HEXEN_S_CHOLYREADY, 0, 36},  // HEXEN_S_CHOLYATK_9
    {HEXEN_SPR_SPIR, 0, 2, A_CHolySeek, HEXEN_S_HOLY_FX2, 0, 0},    // HEXEN_S_HOLY_FX1
    {HEXEN_SPR_SPIR, 0, 2, A_CHolySeek, HEXEN_S_HOLY_FX3, 0, 0},    // HEXEN_S_HOLY_FX2
    {HEXEN_SPR_SPIR, 1, 2, A_CHolySeek, HEXEN_S_HOLY_FX4, 0, 0},    // HEXEN_S_HOLY_FX3
    {HEXEN_SPR_SPIR, 1, 2, A_CHolyCheckScream, HEXEN_S_HOLY_FX1, 0, 0},     // HEXEN_S_HOLY_FX4
    {HEXEN_SPR_SPIR, 3, 4, NULL, HEXEN_S_HOLY_FX_X2, 0, 0}, // HEXEN_S_HOLY_FX_X1
    {HEXEN_SPR_SPIR, 4, 4, A_Scream, HEXEN_S_HOLY_FX_X3, 0, 0},     // HEXEN_S_HOLY_FX_X2
    {HEXEN_SPR_SPIR, 5, 4, NULL, HEXEN_S_HOLY_FX_X4, 0, 0}, // HEXEN_S_HOLY_FX_X3
    {HEXEN_SPR_SPIR, 6, 4, NULL, HEXEN_S_HOLY_FX_X5, 0, 0}, // HEXEN_S_HOLY_FX_X4
    {HEXEN_SPR_SPIR, 7, 4, NULL, HEXEN_S_HOLY_FX_X6, 0, 0}, // HEXEN_S_HOLY_FX_X5
    {HEXEN_SPR_SPIR, 8, 4, NULL, HEXEN_S_NULL, 0, 0},       // HEXEN_S_HOLY_FX_X6
    {HEXEN_SPR_SPIR, 2, 1, A_CHolyTail, HEXEN_S_HOLY_TAIL1, 0, 0},  // HEXEN_S_HOLY_TAIL1
    {HEXEN_SPR_SPIR, 3, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_HOLY_TAIL2
    {HEXEN_SPR_SPIR, 10, 3, NULL, HEXEN_S_HOLY_PUFF2, 0, 0},        // HEXEN_S_HOLY_PUFF1
    {HEXEN_SPR_SPIR, 11, 3, NULL, HEXEN_S_HOLY_PUFF3, 0, 0},        // HEXEN_S_HOLY_PUFF2
    {HEXEN_SPR_SPIR, 12, 3, NULL, HEXEN_S_HOLY_PUFF4, 0, 0},        // HEXEN_S_HOLY_PUFF3
    {HEXEN_SPR_SPIR, 13, 3, NULL, HEXEN_S_HOLY_PUFF5, 0, 0},        // HEXEN_S_HOLY_PUFF4
    {HEXEN_SPR_SPIR, 14, 3, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_HOLY_PUFF5
    {HEXEN_SPR_SPIR, 32783, 3, A_CHolySpawnPuff, HEXEN_S_HOLY_MISSILE2, 0, 0},      // HEXEN_S_HOLY_MISSILE1
    {HEXEN_SPR_SPIR, 32783, 3, A_CHolySpawnPuff, HEXEN_S_HOLY_MISSILE3, 0, 0},      // HEXEN_S_HOLY_MISSILE2
    {HEXEN_SPR_SPIR, 32783, 3, A_CHolySpawnPuff, HEXEN_S_HOLY_MISSILE4, 0, 0},      // HEXEN_S_HOLY_MISSILE3
    {HEXEN_SPR_SPIR, 32783, 3, A_CHolySpawnPuff, HEXEN_S_HOLY_MISSILE_X, 0, 0},     // HEXEN_S_HOLY_MISSILE4
    {HEXEN_SPR_SPIR, 32783, 1, A_CHolyAttack2, HEXEN_S_NULL, 0, 0}, // HEXEN_S_HOLY_MISSILE_X
    {HEXEN_SPR_SPIR, 16, 3, NULL, HEXEN_S_HOLY_MISSILE_P2, 0, 0},   // HEXEN_S_HOLY_MISSILE_P1
    {HEXEN_SPR_SPIR, 17, 3, NULL, HEXEN_S_HOLY_MISSILE_P3, 0, 0},   // HEXEN_S_HOLY_MISSILE_P2
    {HEXEN_SPR_SPIR, 18, 3, NULL, HEXEN_S_HOLY_MISSILE_P4, 0, 0},   // HEXEN_S_HOLY_MISSILE_P3
    {HEXEN_SPR_SPIR, 19, 3, NULL, HEXEN_S_HOLY_MISSILE_P5, 0, 0},   // HEXEN_S_HOLY_MISSILE_P4
    {HEXEN_SPR_SPIR, 20, 3, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_HOLY_MISSILE_P5
    {HEXEN_SPR_MWND, 0, 1, A_WeaponReady, HEXEN_S_MWANDREADY, 0, 0},        // HEXEN_S_MWANDREADY
    {HEXEN_SPR_MWND, 0, 1, A_Lower, HEXEN_S_MWANDDOWN, 0, 0},       // HEXEN_S_MWANDDOWN
    {HEXEN_SPR_MWND, 0, 1, A_Raise, HEXEN_S_MWANDUP, 0, 0}, // HEXEN_S_MWANDUP
    {HEXEN_SPR_MWND, 0, 6, NULL, HEXEN_S_MWANDATK_2, 0, 0}, // HEXEN_S_MWANDATK_1
    {HEXEN_SPR_MWND, 32769, 6, A_MWandAttack, HEXEN_S_MWANDATK_3, 0, 48},   // HEXEN_S_MWANDATK_2
    {HEXEN_SPR_MWND, 0, 3, NULL, HEXEN_S_MWANDATK_4, 0, 40},        // HEXEN_S_MWANDATK_3
    {HEXEN_SPR_MWND, 0, 3, A_ReFire, HEXEN_S_MWANDREADY, 0, 36},    // HEXEN_S_MWANDATK_4
    {HEXEN_SPR_MWND, 32772, 4, NULL, HEXEN_S_MWANDPUFF2, 0, 0},     // HEXEN_S_MWANDPUFF1
    {HEXEN_SPR_MWND, 32773, 3, NULL, HEXEN_S_MWANDPUFF3, 0, 0},     // HEXEN_S_MWANDPUFF2
    {HEXEN_SPR_MWND, 32774, 4, NULL, HEXEN_S_MWANDPUFF4, 0, 0},     // HEXEN_S_MWANDPUFF3
    {HEXEN_SPR_MWND, 32775, 3, NULL, HEXEN_S_MWANDPUFF5, 0, 0},     // HEXEN_S_MWANDPUFF4
    {HEXEN_SPR_MWND, 32776, 4, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_MWANDPUFF5
    {HEXEN_SPR_MWND, 2, 4, NULL, HEXEN_S_MWANDSMOKE2, 0, 0},        // HEXEN_S_MWANDSMOKE1
    {HEXEN_SPR_MWND, 3, 4, NULL, HEXEN_S_MWANDSMOKE3, 0, 0},        // HEXEN_S_MWANDSMOKE2
    {HEXEN_SPR_MWND, 2, 4, NULL, HEXEN_S_MWANDSMOKE4, 0, 0},        // HEXEN_S_MWANDSMOKE3
    {HEXEN_SPR_MWND, 3, 4, NULL, HEXEN_S_NULL, 0, 0},       // HEXEN_S_MWANDSMOKE4
    {HEXEN_SPR_MWND, 32770, 4, NULL, HEXEN_S_MWAND_MISSILE2, 0, 0}, // HEXEN_S_MWAND_MISSILE1
    {HEXEN_SPR_MWND, 32771, 4, NULL, HEXEN_S_MWAND_MISSILE1, 0, 0}, // HEXEN_S_MWAND_MISSILE2
    {HEXEN_SPR_WMLG, 32768, 4, NULL, HEXEN_S_MW_LIGHTNING2, 0, 0},  // HEXEN_S_MW_LIGHTNING1
    {HEXEN_SPR_WMLG, 32769, 4, NULL, HEXEN_S_MW_LIGHTNING3, 0, 0},  // HEXEN_S_MW_LIGHTNING2
    {HEXEN_SPR_WMLG, 32770, 4, NULL, HEXEN_S_MW_LIGHTNING4, 0, 0},  // HEXEN_S_MW_LIGHTNING3
    {HEXEN_SPR_WMLG, 32771, 4, NULL, HEXEN_S_MW_LIGHTNING5, 0, 0},  // HEXEN_S_MW_LIGHTNING4
    {HEXEN_SPR_WMLG, 32772, 4, NULL, HEXEN_S_MW_LIGHTNING6, 0, 0},  // HEXEN_S_MW_LIGHTNING5
    {HEXEN_SPR_WMLG, 32773, 4, NULL, HEXEN_S_MW_LIGHTNING7, 0, 0},  // HEXEN_S_MW_LIGHTNING6
    {HEXEN_SPR_WMLG, 32774, 4, NULL, HEXEN_S_MW_LIGHTNING8, 0, 0},  // HEXEN_S_MW_LIGHTNING7
    {HEXEN_SPR_WMLG, 32775, 4, NULL, HEXEN_S_MW_LIGHTNING1, 0, 0},  // HEXEN_S_MW_LIGHTNING8
    {HEXEN_SPR_MLNG, 32768, 1, A_WeaponReady, HEXEN_S_MLIGHTNINGREADY2, 0, 0},      // HEXEN_S_MLIGHTNINGREADY
    {HEXEN_SPR_MLNG, 32768, 1, A_WeaponReady, HEXEN_S_MLIGHTNINGREADY3, 0, 0},      // HEXEN_S_MLIGHTNINGREADY2
    {HEXEN_SPR_MLNG, 32768, 1, A_WeaponReady, HEXEN_S_MLIGHTNINGREADY4, 0, 0},      // HEXEN_S_MLIGHTNINGREADY3
    {HEXEN_SPR_MLNG, 32768, 1, A_WeaponReady, HEXEN_S_MLIGHTNINGREADY5, 0, 0},      // HEXEN_S_MLIGHTNINGREADY4
    {HEXEN_SPR_MLNG, 32768, 1, A_WeaponReady, HEXEN_S_MLIGHTNINGREADY6, 0, 0},      // HEXEN_S_MLIGHTNINGREADY5
    {HEXEN_SPR_MLNG, 32768, 1, A_LightningReady, HEXEN_S_MLIGHTNINGREADY7, 0, 0},   // HEXEN_S_MLIGHTNINGREADY6
    {HEXEN_SPR_MLNG, 32769, 1, A_WeaponReady, HEXEN_S_MLIGHTNINGREADY8, 0, 0},      // HEXEN_S_MLIGHTNINGREADY7
    {HEXEN_SPR_MLNG, 32769, 1, A_WeaponReady, HEXEN_S_MLIGHTNINGREADY9, 0, 0},      // HEXEN_S_MLIGHTNINGREADY8
    {HEXEN_SPR_MLNG, 32769, 1, A_WeaponReady, HEXEN_S_MLIGHTNINGREADY10, 0, 0},     // HEXEN_S_MLIGHTNINGREADY9
    {HEXEN_SPR_MLNG, 32769, 1, A_WeaponReady, HEXEN_S_MLIGHTNINGREADY11, 0, 0},     // HEXEN_S_MLIGHTNINGREADY10
    {HEXEN_SPR_MLNG, 32769, 1, A_WeaponReady, HEXEN_S_MLIGHTNINGREADY12, 0, 0},     // HEXEN_S_MLIGHTNINGREADY11
    {HEXEN_SPR_MLNG, 32769, 1, A_WeaponReady, HEXEN_S_MLIGHTNINGREADY13, 0, 0},     // HEXEN_S_MLIGHTNINGREADY12
    {HEXEN_SPR_MLNG, 32770, 1, A_WeaponReady, HEXEN_S_MLIGHTNINGREADY14, 0, 0},     // HEXEN_S_MLIGHTNINGREADY13
    {HEXEN_SPR_MLNG, 32770, 1, A_WeaponReady, HEXEN_S_MLIGHTNINGREADY15, 0, 0},     // HEXEN_S_MLIGHTNINGREADY14
    {HEXEN_SPR_MLNG, 32770, 1, A_WeaponReady, HEXEN_S_MLIGHTNINGREADY16, 0, 0},     // HEXEN_S_MLIGHTNINGREADY15
    {HEXEN_SPR_MLNG, 32770, 1, A_WeaponReady, HEXEN_S_MLIGHTNINGREADY17, 0, 0},     // HEXEN_S_MLIGHTNINGREADY16
    {HEXEN_SPR_MLNG, 32770, 1, A_WeaponReady, HEXEN_S_MLIGHTNINGREADY18, 0, 0},     // HEXEN_S_MLIGHTNINGREADY17
    {HEXEN_SPR_MLNG, 32770, 1, A_LightningReady, HEXEN_S_MLIGHTNINGREADY19, 0, 0},  // HEXEN_S_MLIGHTNINGREADY18
    {HEXEN_SPR_MLNG, 32769, 1, A_WeaponReady, HEXEN_S_MLIGHTNINGREADY20, 0, 0},     // HEXEN_S_MLIGHTNINGREADY19
    {HEXEN_SPR_MLNG, 32769, 1, A_WeaponReady, HEXEN_S_MLIGHTNINGREADY21, 0, 0},     // HEXEN_S_MLIGHTNINGREADY20
    {HEXEN_SPR_MLNG, 32769, 1, A_WeaponReady, HEXEN_S_MLIGHTNINGREADY22, 0, 0},     // HEXEN_S_MLIGHTNINGREADY21
    {HEXEN_SPR_MLNG, 32769, 1, A_WeaponReady, HEXEN_S_MLIGHTNINGREADY23, 0, 0},     // HEXEN_S_MLIGHTNINGREADY22
    {HEXEN_SPR_MLNG, 32769, 1, A_WeaponReady, HEXEN_S_MLIGHTNINGREADY24, 0, 0},     // HEXEN_S_MLIGHTNINGREADY23
    {HEXEN_SPR_MLNG, 32769, 1, A_WeaponReady, HEXEN_S_MLIGHTNINGREADY, 0, 0},       // HEXEN_S_MLIGHTNINGREADY24
    {HEXEN_SPR_MLNG, 32768, 1, A_Lower, HEXEN_S_MLIGHTNINGDOWN, 0, 0},      // HEXEN_S_MLIGHTNINGDOWN
    {HEXEN_SPR_MLNG, 32768, 1, A_Raise, HEXEN_S_MLIGHTNINGUP, 0, 0},        // HEXEN_S_MLIGHTNINGUP
    {HEXEN_SPR_MLNG, 32771, 3, NULL, HEXEN_S_MLIGHTNINGATK_2, 0, 0},        // HEXEN_S_MLIGHTNINGATK_1
    {HEXEN_SPR_MLNG, 32772, 3, NULL, HEXEN_S_MLIGHTNINGATK_3, 0, 0},        // HEXEN_S_MLIGHTNINGATK_2
    {HEXEN_SPR_MLNG, 32773, 4, A_MLightningAttack, HEXEN_S_MLIGHTNINGATK_4, 0, 0},  // HEXEN_S_MLIGHTNINGATK_3
    {HEXEN_SPR_MLNG, 32774, 4, NULL, HEXEN_S_MLIGHTNINGATK_5, 0, 0},        // HEXEN_S_MLIGHTNINGATK_4
    {HEXEN_SPR_MLNG, 32775, 3, NULL, HEXEN_S_MLIGHTNINGATK_6, 0, 0},        // HEXEN_S_MLIGHTNINGATK_5
    {HEXEN_SPR_MLNG, 32776, 3, NULL, HEXEN_S_MLIGHTNINGATK_7, 0, 0},        // HEXEN_S_MLIGHTNINGATK_6
    {HEXEN_SPR_MLNG, 32776, 6, NULL, HEXEN_S_MLIGHTNINGATK_8, 0, 199},      // HEXEN_S_MLIGHTNINGATK_7
    {HEXEN_SPR_MLNG, 32770, 2, NULL, HEXEN_S_MLIGHTNINGATK_9, 0, 55},       // HEXEN_S_MLIGHTNINGATK_8
    {HEXEN_SPR_MLNG, 32769, 2, NULL, HEXEN_S_MLIGHTNINGATK_10, 0, 50},      // HEXEN_S_MLIGHTNINGATK_9
    {HEXEN_SPR_MLNG, 32769, 2, NULL, HEXEN_S_MLIGHTNINGATK_11, 0, 45},      // HEXEN_S_MLIGHTNINGATK_10
    {HEXEN_SPR_MLNG, 32769, 2, NULL, HEXEN_S_MLIGHTNINGREADY, 0, 40},       // HEXEN_S_MLIGHTNINGATK_11
    {HEXEN_SPR_MLFX, 32768, 2, A_LightningZap, HEXEN_S_LIGHTNING_CEILING2, 0, 0},   // HEXEN_S_LIGHTNING_CEILING1
    {HEXEN_SPR_MLFX, 32769, 2, A_LightningClip, HEXEN_S_LIGHTNING_CEILING3, 0, 0},  // HEXEN_S_LIGHTNING_CEILING2
    {HEXEN_SPR_MLFX, 32770, 2, A_LightningClip, HEXEN_S_LIGHTNING_CEILING4, 0, 0},  // HEXEN_S_LIGHTNING_CEILING3
    {HEXEN_SPR_MLFX, 32771, 2, A_LightningClip, HEXEN_S_LIGHTNING_CEILING1, 0, 0},  // HEXEN_S_LIGHTNING_CEILING4
    {HEXEN_SPR_MLF2, 32768, 2, A_LightningRemove, HEXEN_S_LIGHTNING_C_X2, 0, 0},    // HEXEN_S_LIGHTNING_C_X1
    {HEXEN_SPR_MLF2, 32769, 3, NULL, HEXEN_S_LIGHTNING_C_X3, 0, 0}, // HEXEN_S_LIGHTNING_C_X2
    {HEXEN_SPR_MLF2, 32770, 3, NULL, HEXEN_S_LIGHTNING_C_X4, 0, 0}, // HEXEN_S_LIGHTNING_C_X3
    {HEXEN_SPR_MLF2, 32771, 3, NULL, HEXEN_S_LIGHTNING_C_X5, 0, 0}, // HEXEN_S_LIGHTNING_C_X4
    {HEXEN_SPR_MLF2, 32772, 3, NULL, HEXEN_S_LIGHTNING_C_X6, 0, 0}, // HEXEN_S_LIGHTNING_C_X5
    {HEXEN_SPR_MLF2, 32778, 3, NULL, HEXEN_S_LIGHTNING_C_X7, 0, 0}, // HEXEN_S_LIGHTNING_C_X6
    {HEXEN_SPR_MLF2, 32779, 3, NULL, HEXEN_S_LIGHTNING_C_X8, 0, 0}, // HEXEN_S_LIGHTNING_C_X7
    {HEXEN_SPR_MLF2, 32780, 3, NULL, HEXEN_S_LIGHTNING_C_X9, 0, 0}, // HEXEN_S_LIGHTNING_C_X8
    {HEXEN_SPR_ACLO, 4, 35, NULL, HEXEN_S_LIGHTNING_C_X10, 0, 0},   // HEXEN_S_LIGHTNING_C_X9
    {HEXEN_SPR_MLF2, 32781, 3, NULL, HEXEN_S_LIGHTNING_C_X11, 0, 0},        // HEXEN_S_LIGHTNING_C_X10
    {HEXEN_SPR_MLF2, 32782, 3, NULL, HEXEN_S_LIGHTNING_C_X12, 0, 0},        // HEXEN_S_LIGHTNING_C_X11
    {HEXEN_SPR_MLF2, 32783, 4, NULL, HEXEN_S_LIGHTNING_C_X13, 0, 0},        // HEXEN_S_LIGHTNING_C_X12
    {HEXEN_SPR_MLF2, 32784, 3, NULL, HEXEN_S_LIGHTNING_C_X14, 0, 0},        // HEXEN_S_LIGHTNING_C_X13
    {HEXEN_SPR_MLF2, 32783, 3, NULL, HEXEN_S_LIGHTNING_C_X15, 0, 0},        // HEXEN_S_LIGHTNING_C_X14
    {HEXEN_SPR_MLF2, 32784, 4, NULL, HEXEN_S_LIGHTNING_C_X16, 0, 0},        // HEXEN_S_LIGHTNING_C_X15
    {HEXEN_SPR_MLF2, 32783, 3, NULL, HEXEN_S_LIGHTNING_C_X17, 0, 0},        // HEXEN_S_LIGHTNING_C_X16
    {HEXEN_SPR_MLF2, 32782, 3, NULL, HEXEN_S_LIGHTNING_C_X18, 0, 0},        // HEXEN_S_LIGHTNING_C_X17
    {HEXEN_SPR_MLF2, 32783, 3, NULL, HEXEN_S_LIGHTNING_C_X19, 0, 0},        // HEXEN_S_LIGHTNING_C_X18
    {HEXEN_SPR_MLF2, 32783, 1, A_HideThing, HEXEN_S_FREETARGMOBJ, 0, 0},    // HEXEN_S_LIGHTNING_C_X19
    {HEXEN_SPR_MLFX, 32772, 2, A_LightningZap, HEXEN_S_LIGHTNING_FLOOR2, 0, 0},     // HEXEN_S_LIGHTNING_FLOOR1
    {HEXEN_SPR_MLFX, 32773, 2, A_LightningClip, HEXEN_S_LIGHTNING_FLOOR3, 0, 0},    // HEXEN_S_LIGHTNING_FLOOR2
    {HEXEN_SPR_MLFX, 32774, 2, A_LightningClip, HEXEN_S_LIGHTNING_FLOOR4, 0, 0},    // HEXEN_S_LIGHTNING_FLOOR3
    {HEXEN_SPR_MLFX, 32775, 2, A_LightningClip, HEXEN_S_LIGHTNING_FLOOR1, 0, 0},    // HEXEN_S_LIGHTNING_FLOOR4
    {HEXEN_SPR_MLF2, 32773, 2, A_LightningRemove, HEXEN_S_LIGHTNING_F_X2, 0, 0},    // HEXEN_S_LIGHTNING_F_X1
    {HEXEN_SPR_MLF2, 32774, 3, NULL, HEXEN_S_LIGHTNING_F_X3, 0, 0}, // HEXEN_S_LIGHTNING_F_X2
    {HEXEN_SPR_MLF2, 32775, 3, NULL, HEXEN_S_LIGHTNING_F_X4, 0, 0}, // HEXEN_S_LIGHTNING_F_X3
    {HEXEN_SPR_MLF2, 32776, 3, NULL, HEXEN_S_LIGHTNING_F_X5, 0, 0}, // HEXEN_S_LIGHTNING_F_X4
    {HEXEN_SPR_MLF2, 32777, 3, NULL, HEXEN_S_LIGHTNING_F_X6, 0, 0}, // HEXEN_S_LIGHTNING_F_X5
    {HEXEN_SPR_MLF2, 32778, 3, NULL, HEXEN_S_LIGHTNING_F_X7, 0, 0}, // HEXEN_S_LIGHTNING_F_X6
    {HEXEN_SPR_MLF2, 32779, 3, NULL, HEXEN_S_LIGHTNING_F_X8, 0, 0}, // HEXEN_S_LIGHTNING_F_X7
    {HEXEN_SPR_MLF2, 32780, 3, NULL, HEXEN_S_LIGHTNING_F_X9, 0, 0}, // HEXEN_S_LIGHTNING_F_X8
    {HEXEN_SPR_ACLO, 4, 20, NULL, HEXEN_S_LIGHTNING_F_X10, 0, 0},   // HEXEN_S_LIGHTNING_F_X9
    {HEXEN_SPR_MLF2, 32781, 3, NULL, HEXEN_S_LIGHTNING_F_X11, 0, 0},        // HEXEN_S_LIGHTNING_F_X10
    {HEXEN_SPR_MLF2, 32782, 3, NULL, HEXEN_S_LIGHTNING_F_X12, 0, 0},        // HEXEN_S_LIGHTNING_F_X11
    {HEXEN_SPR_MLF2, 32783, 4, NULL, HEXEN_S_LIGHTNING_F_X13, 0, 0},        // HEXEN_S_LIGHTNING_F_X12
    {HEXEN_SPR_MLF2, 32784, 3, NULL, HEXEN_S_LIGHTNING_F_X14, 0, 0},        // HEXEN_S_LIGHTNING_F_X13
    {HEXEN_SPR_MLF2, 32783, 3, NULL, HEXEN_S_LIGHTNING_F_X15, 0, 0},        // HEXEN_S_LIGHTNING_F_X14
    {HEXEN_SPR_MLF2, 32784, 4, A_LastZap, HEXEN_S_LIGHTNING_F_X16, 0, 0},   // HEXEN_S_LIGHTNING_F_X15
    {HEXEN_SPR_MLF2, 32783, 3, NULL, HEXEN_S_LIGHTNING_F_X17, 0, 0},        // HEXEN_S_LIGHTNING_F_X16
    {HEXEN_SPR_MLF2, 32782, 3, NULL, HEXEN_S_LIGHTNING_F_X18, 0, 0},        // HEXEN_S_LIGHTNING_F_X17
    {HEXEN_SPR_MLF2, 32783, 3, NULL, HEXEN_S_LIGHTNING_F_X19, 0, 0},        // HEXEN_S_LIGHTNING_F_X18
    {HEXEN_SPR_MLF2, 32783, 1, A_HideThing, HEXEN_S_FREETARGMOBJ, 0, 0},    // HEXEN_S_LIGHTNING_F_X19
    {HEXEN_SPR_MLFX, 32776, 2, A_ZapMimic, HEXEN_S_LIGHTNING_ZAP2, 0, 0},   // HEXEN_S_LIGHTNING_ZAP1
    {HEXEN_SPR_MLFX, 32777, 2, A_ZapMimic, HEXEN_S_LIGHTNING_ZAP3, 0, 0},   // HEXEN_S_LIGHTNING_ZAP2
    {HEXEN_SPR_MLFX, 32778, 2, A_ZapMimic, HEXEN_S_LIGHTNING_ZAP4, 0, 0},   // HEXEN_S_LIGHTNING_ZAP3
    {HEXEN_SPR_MLFX, 32779, 2, A_ZapMimic, HEXEN_S_LIGHTNING_ZAP5, 0, 0},   // HEXEN_S_LIGHTNING_ZAP4
    {HEXEN_SPR_MLFX, 32780, 2, A_ZapMimic, HEXEN_S_LIGHTNING_ZAP1, 0, 0},   // HEXEN_S_LIGHTNING_ZAP5
    {HEXEN_SPR_MLFX, 32781, 2, NULL, HEXEN_S_LIGHTNING_ZAP_X2, 0, 0},       // HEXEN_S_LIGHTNING_ZAP_X1
    {HEXEN_SPR_MLFX, 32782, 2, NULL, HEXEN_S_LIGHTNING_ZAP_X3, 0, 0},       // HEXEN_S_LIGHTNING_ZAP_X2
    {HEXEN_SPR_MLFX, 32783, 2, NULL, HEXEN_S_LIGHTNING_ZAP_X4, 0, 0},       // HEXEN_S_LIGHTNING_ZAP_X3
    {HEXEN_SPR_MLFX, 32784, 2, NULL, HEXEN_S_LIGHTNING_ZAP_X5, 0, 0},       // HEXEN_S_LIGHTNING_ZAP_X4
    {HEXEN_SPR_MLFX, 32785, 2, NULL, HEXEN_S_LIGHTNING_ZAP_X6, 0, 0},       // HEXEN_S_LIGHTNING_ZAP_X5
    {HEXEN_SPR_MLFX, 32786, 2, NULL, HEXEN_S_LIGHTNING_ZAP_X7, 0, 0},       // HEXEN_S_LIGHTNING_ZAP_X6
    {HEXEN_SPR_MLFX, 32787, 2, NULL, HEXEN_S_LIGHTNING_ZAP_X8, 0, 0},       // HEXEN_S_LIGHTNING_ZAP_X7
    {HEXEN_SPR_MLFX, 32788, 2, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_LIGHTNING_ZAP_X8
    {HEXEN_SPR_MSTF, 0, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY2, 0, 0},      // HEXEN_S_MSTAFFREADY
    {HEXEN_SPR_MSTF, 0, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY3, 0, 0},      // HEXEN_S_MSTAFFREADY2
    {HEXEN_SPR_MSTF, 0, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY4, 0, 0},      // HEXEN_S_MSTAFFREADY3
    {HEXEN_SPR_MSTF, 0, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY5, 0, 0},      // HEXEN_S_MSTAFFREADY4
    {HEXEN_SPR_MSTF, 0, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY6, 0, 0},      // HEXEN_S_MSTAFFREADY5
    {HEXEN_SPR_MSTF, 0, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY7, 0, 0},      // HEXEN_S_MSTAFFREADY6
    {HEXEN_SPR_MSTF, 1, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY8, 0, 0},      // HEXEN_S_MSTAFFREADY7
    {HEXEN_SPR_MSTF, 1, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY9, 0, 0},      // HEXEN_S_MSTAFFREADY8
    {HEXEN_SPR_MSTF, 1, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY10, 0, 0},     // HEXEN_S_MSTAFFREADY9
    {HEXEN_SPR_MSTF, 1, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY11, 0, 0},     // HEXEN_S_MSTAFFREADY10
    {HEXEN_SPR_MSTF, 1, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY12, 0, 0},     // HEXEN_S_MSTAFFREADY11
    {HEXEN_SPR_MSTF, 1, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY13, 0, 0},     // HEXEN_S_MSTAFFREADY12
    {HEXEN_SPR_MSTF, 2, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY14, 0, 0},     // HEXEN_S_MSTAFFREADY13
    {HEXEN_SPR_MSTF, 2, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY15, 0, 0},     // HEXEN_S_MSTAFFREADY14
    {HEXEN_SPR_MSTF, 2, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY16, 0, 0},     // HEXEN_S_MSTAFFREADY15
    {HEXEN_SPR_MSTF, 2, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY17, 0, 0},     // HEXEN_S_MSTAFFREADY16
    {HEXEN_SPR_MSTF, 2, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY18, 0, 0},     // HEXEN_S_MSTAFFREADY17
    {HEXEN_SPR_MSTF, 2, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY19, 0, 0},     // HEXEN_S_MSTAFFREADY18
    {HEXEN_SPR_MSTF, 3, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY20, 0, 0},     // HEXEN_S_MSTAFFREADY19
    {HEXEN_SPR_MSTF, 3, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY21, 0, 0},     // HEXEN_S_MSTAFFREADY20
    {HEXEN_SPR_MSTF, 3, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY22, 0, 0},     // HEXEN_S_MSTAFFREADY21
    {HEXEN_SPR_MSTF, 3, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY23, 0, 0},     // HEXEN_S_MSTAFFREADY22
    {HEXEN_SPR_MSTF, 3, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY24, 0, 0},     // HEXEN_S_MSTAFFREADY23
    {HEXEN_SPR_MSTF, 3, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY25, 0, 0},     // HEXEN_S_MSTAFFREADY24
    {HEXEN_SPR_MSTF, 4, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY26, 0, 0},     // HEXEN_S_MSTAFFREADY25
    {HEXEN_SPR_MSTF, 4, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY27, 0, 0},     // HEXEN_S_MSTAFFREADY26
    {HEXEN_SPR_MSTF, 4, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY28, 0, 0},     // HEXEN_S_MSTAFFREADY27
    {HEXEN_SPR_MSTF, 4, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY29, 0, 0},     // HEXEN_S_MSTAFFREADY28
    {HEXEN_SPR_MSTF, 4, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY30, 0, 0},     // HEXEN_S_MSTAFFREADY29
    {HEXEN_SPR_MSTF, 4, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY31, 0, 0},     // HEXEN_S_MSTAFFREADY30
    {HEXEN_SPR_MSTF, 5, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY32, 0, 0},     // HEXEN_S_MSTAFFREADY31
    {HEXEN_SPR_MSTF, 5, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY33, 0, 0},     // HEXEN_S_MSTAFFREADY32
    {HEXEN_SPR_MSTF, 5, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY34, 0, 0},     // HEXEN_S_MSTAFFREADY33
    {HEXEN_SPR_MSTF, 5, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY35, 0, 0},     // HEXEN_S_MSTAFFREADY34
    {HEXEN_SPR_MSTF, 5, 1, A_WeaponReady, HEXEN_S_MSTAFFREADY, 0, 0},       // HEXEN_S_MSTAFFREADY35
    {HEXEN_SPR_MSTF, 0, 1, A_Lower, HEXEN_S_MSTAFFDOWN, 0, 0},      // HEXEN_S_MSTAFFDOWN
    {HEXEN_SPR_MSTF, 0, 1, A_Raise, HEXEN_S_MSTAFFUP, 0, 0},        // HEXEN_S_MSTAFFUP
    {HEXEN_SPR_MSTF, 6, 4, NULL, HEXEN_S_MSTAFFATK_2, 0, 40},       // HEXEN_S_MSTAFFATK_1
    {HEXEN_SPR_MSTF, 32775, 4, A_MStaffAttack, HEXEN_S_MSTAFFATK_3, 0, 48}, // HEXEN_S_MSTAFFATK_2
    {HEXEN_SPR_MSTF, 32775, 2, A_MStaffPalette, HEXEN_S_MSTAFFATK_4, 0, 48},        // HEXEN_S_MSTAFFATK_3
    {HEXEN_SPR_MSTF, 8, 2, A_MStaffPalette, HEXEN_S_MSTAFFATK_5, 0, 48},    // HEXEN_S_MSTAFFATK_4
    {HEXEN_SPR_MSTF, 8, 2, A_MStaffPalette, HEXEN_S_MSTAFFATK_6, 0, 48},    // HEXEN_S_MSTAFFATK_5
    {HEXEN_SPR_MSTF, 8, 1, NULL, HEXEN_S_MSTAFFATK_7, 0, 40},       // HEXEN_S_MSTAFFATK_6
    {HEXEN_SPR_MSTF, 9, 5, NULL, HEXEN_S_MSTAFFREADY, 0, 36},       // HEXEN_S_MSTAFFATK_7
    {HEXEN_SPR_MSP1, 32768, 3, A_MStaffWeave, HEXEN_S_MSTAFF_FX1_2, 0, 0},  // HEXEN_S_MSTAFF_FX1_1
    {HEXEN_SPR_MSP1, 32769, 3, A_MStaffWeave, HEXEN_S_MSTAFF_FX1_3, 0, 0},  // HEXEN_S_MSTAFF_FX1_2
    {HEXEN_SPR_MSP1, 32770, 3, A_MStaffWeave, HEXEN_S_MSTAFF_FX1_4, 0, 0},  // HEXEN_S_MSTAFF_FX1_3
    {HEXEN_SPR_MSP1, 32771, 3, A_MStaffWeave, HEXEN_S_MSTAFF_FX1_5, 0, 0},  // HEXEN_S_MSTAFF_FX1_4
    {HEXEN_SPR_MSP1, 32772, 3, A_MStaffWeave, HEXEN_S_MSTAFF_FX1_6, 0, 0},  // HEXEN_S_MSTAFF_FX1_5
    {HEXEN_SPR_MSP1, 32773, 3, A_MStaffWeave, HEXEN_S_MSTAFF_FX1_1, 0, 0},  // HEXEN_S_MSTAFF_FX1_6
    {HEXEN_SPR_MSP1, 32774, 4, NULL, HEXEN_S_MSTAFF_FX_X2, 0, 0},   // HEXEN_S_MSTAFF_FX_X1
    {HEXEN_SPR_MSP1, 32775, 5, A_Explode, HEXEN_S_MSTAFF_FX_X3, 0, 0},      // HEXEN_S_MSTAFF_FX_X2
    {HEXEN_SPR_MSP1, 32776, 4, NULL, HEXEN_S_MSTAFF_FX_X4, 0, 0},   // HEXEN_S_MSTAFF_FX_X3
    {HEXEN_SPR_MSP1, 32777, 5, NULL, HEXEN_S_MSTAFF_FX_X5, 0, 0},   // HEXEN_S_MSTAFF_FX_X4
    {HEXEN_SPR_MSP1, 32778, 4, NULL, HEXEN_S_MSTAFF_FX_X6, 0, 0},   // HEXEN_S_MSTAFF_FX_X5
    {HEXEN_SPR_MSP1, 32779, 5, NULL, HEXEN_S_MSTAFF_FX_X7, 0, 0},   // HEXEN_S_MSTAFF_FX_X6
    {HEXEN_SPR_MSP1, 32780, 4, NULL, HEXEN_S_MSTAFF_FX_X8, 0, 0},   // HEXEN_S_MSTAFF_FX_X7
    {HEXEN_SPR_MSP1, 32781, 5, NULL, HEXEN_S_MSTAFF_FX_X9, 0, 0},   // HEXEN_S_MSTAFF_FX_X8
    {HEXEN_SPR_MSP1, 32782, 4, NULL, HEXEN_S_MSTAFF_FX_X10, 0, 0},  // HEXEN_S_MSTAFF_FX_X9
    {HEXEN_SPR_MSP1, 32783, 4, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_MSTAFF_FX_X10
    {HEXEN_SPR_MSP2, 32768, 2, A_MStaffTrack, HEXEN_S_MSTAFF_FX2_2, 0, 0},  // HEXEN_S_MSTAFF_FX2_1
    {HEXEN_SPR_MSP2, 32769, 2, A_MStaffTrack, HEXEN_S_MSTAFF_FX2_3, 0, 0},  // HEXEN_S_MSTAFF_FX2_2
    {HEXEN_SPR_MSP2, 32770, 2, A_MStaffTrack, HEXEN_S_MSTAFF_FX2_4, 0, 0},  // HEXEN_S_MSTAFF_FX2_3
    {HEXEN_SPR_MSP2, 32771, 2, A_MStaffTrack, HEXEN_S_MSTAFF_FX2_1, 0, 0},  // HEXEN_S_MSTAFF_FX2_4
    {HEXEN_SPR_MSP2, 32772, 4, NULL, HEXEN_S_MSTAFF_FX2_X2, 0, 0},  // HEXEN_S_MSTAFF_FX2_X1
    {HEXEN_SPR_MSP2, 32773, 5, A_Explode, HEXEN_S_MSTAFF_FX2_X3, 0, 0},     // HEXEN_S_MSTAFF_FX2_X2
    {HEXEN_SPR_MSP2, 32774, 5, NULL, HEXEN_S_MSTAFF_FX2_X4, 0, 0},  // HEXEN_S_MSTAFF_FX2_X3
    {HEXEN_SPR_MSP2, 32775, 5, NULL, HEXEN_S_MSTAFF_FX2_X5, 0, 0},  // HEXEN_S_MSTAFF_FX2_X4
    {HEXEN_SPR_MSP2, 32776, 4, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_MSTAFF_FX2_X5
    {HEXEN_SPR_WFR1, 32768, -1, NULL, HEXEN_S_NULL, 0, 0},  // HEXEN_S_FSWORD1
    {HEXEN_SPR_WFR2, 32768, -1, NULL, HEXEN_S_NULL, 0, 0},  // HEXEN_S_FSWORD2
    {HEXEN_SPR_WFR3, 32768, -1, NULL, HEXEN_S_NULL, 0, 0},  // HEXEN_S_FSWORD3
    {HEXEN_SPR_WCH1, 32768, -1, NULL, HEXEN_S_NULL, 0, 0},  // HEXEN_S_CHOLY1
    {HEXEN_SPR_WCH2, 32768, -1, NULL, HEXEN_S_NULL, 0, 0},  // HEXEN_S_CHOLY2
    {HEXEN_SPR_WCH3, 32768, -1, NULL, HEXEN_S_NULL, 0, 0},  // HEXEN_S_CHOLY3
    {HEXEN_SPR_WMS1, 32768, -1, NULL, HEXEN_S_NULL, 0, 0},  // HEXEN_S_MSTAFF1
    {HEXEN_SPR_WMS2, 32768, -1, NULL, HEXEN_S_NULL, 0, 0},  // HEXEN_S_MSTAFF2
    {HEXEN_SPR_WMS3, 32768, -1, NULL, HEXEN_S_NULL, 0, 0},  // HEXEN_S_MSTAFF3
    {HEXEN_SPR_WPIG, 0, 1, A_WeaponReady, HEXEN_S_SNOUTREADY, 0, 0},        // HEXEN_S_SNOUTREADY
    {HEXEN_SPR_WPIG, 0, 1, A_Lower, HEXEN_S_SNOUTDOWN, 0, 0},       // HEXEN_S_SNOUTDOWN
    {HEXEN_SPR_WPIG, 0, 1, A_Raise, HEXEN_S_SNOUTUP, 0, 0}, // HEXEN_S_SNOUTUP
    {HEXEN_SPR_WPIG, 0, 4, A_SnoutAttack, HEXEN_S_SNOUTATK2, 0, 0}, // HEXEN_S_SNOUTATK1
    {HEXEN_SPR_WPIG, 1, 8, A_SnoutAttack, HEXEN_S_SNOUTREADY, 0, 0},        // HEXEN_S_SNOUTATK2
    {HEXEN_SPR_WMCS, 32768, 8, NULL, HEXEN_S_COS2, 0, 0},   // HEXEN_S_COS1
    {HEXEN_SPR_WMCS, 32769, 8, NULL, HEXEN_S_COS3, 0, 0},   // HEXEN_S_COS2
    {HEXEN_SPR_WMCS, 32770, 8, NULL, HEXEN_S_COS1, 0, 0},   // HEXEN_S_COS3
    {HEXEN_SPR_CONE, 0, 1, A_WeaponReady, HEXEN_S_CONEREADY, 0, 0}, // HEXEN_S_CONEREADY
    {HEXEN_SPR_CONE, 0, 1, A_Lower, HEXEN_S_CONEDOWN, 0, 0},        // HEXEN_S_CONEDOWN
    {HEXEN_SPR_CONE, 0, 1, A_Raise, HEXEN_S_CONEUP, 0, 0},  // HEXEN_S_CONEUP
    {HEXEN_SPR_CONE, 1, 3, NULL, HEXEN_S_CONEATK1_2, 0, 0}, // HEXEN_S_CONEATK1_1
    {HEXEN_SPR_CONE, 2, 4, NULL, HEXEN_S_CONEATK1_3, 0, 0}, // HEXEN_S_CONEATK1_2
    {HEXEN_SPR_CONE, 3, 3, NULL, HEXEN_S_CONEATK1_4, 0, 0}, // HEXEN_S_CONEATK1_3
    {HEXEN_SPR_CONE, 4, 5, NULL, HEXEN_S_CONEATK1_5, 0, 0}, // HEXEN_S_CONEATK1_4
    {HEXEN_SPR_CONE, 5, 3, A_FireConePL1, HEXEN_S_CONEATK1_6, 0, 0},        // HEXEN_S_CONEATK1_5
    {HEXEN_SPR_CONE, 6, 3, NULL, HEXEN_S_CONEATK1_7, 0, 0}, // HEXEN_S_CONEATK1_6
    {HEXEN_SPR_CONE, 0, 9, NULL, HEXEN_S_CONEATK1_8, 0, 0}, // HEXEN_S_CONEATK1_7
    {HEXEN_SPR_CONE, 0, 10, A_ReFire, HEXEN_S_CONEREADY, 0, 0},     // HEXEN_S_CONEATK1_8
    {HEXEN_SPR_SHRD, 32768, 2, NULL, HEXEN_S_SHARDFX1_2, 0, 0},     // HEXEN_S_SHARDFX1_1
    {HEXEN_SPR_SHRD, 32768, 3, A_ShedShard, HEXEN_S_SHARDFX1_3, 0, 0},      // HEXEN_S_SHARDFX1_2
    {HEXEN_SPR_SHRD, 32769, 3, NULL, HEXEN_S_SHARDFX1_4, 0, 0},     // HEXEN_S_SHARDFX1_3
    {HEXEN_SPR_SHRD, 32770, 3, NULL, HEXEN_S_SHARDFX1_1, 0, 0},     // HEXEN_S_SHARDFX1_4
    {HEXEN_SPR_SHEX, 32768, 5, NULL, HEXEN_S_SHARDFXE1_2, 0, 0},    // HEXEN_S_SHARDFXE1_1
    {HEXEN_SPR_SHEX, 32769, 5, NULL, HEXEN_S_SHARDFXE1_3, 0, 0},    // HEXEN_S_SHARDFXE1_2
    {HEXEN_SPR_SHEX, 32770, 5, NULL, HEXEN_S_SHARDFXE1_4, 0, 0},    // HEXEN_S_SHARDFXE1_3
    {HEXEN_SPR_SHEX, 32771, 5, NULL, HEXEN_S_SHARDFXE1_5, 0, 0},    // HEXEN_S_SHARDFXE1_4
    {HEXEN_SPR_SHEX, 32772, 5, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_SHARDFXE1_5
    {HEXEN_SPR_BLOD, 2, 8, NULL, HEXEN_S_BLOOD2, 0, 0},     // HEXEN_S_BLOOD1
    {HEXEN_SPR_BLOD, 1, 8, NULL, HEXEN_S_BLOOD3, 0, 0},     // HEXEN_S_BLOOD2
    {HEXEN_SPR_BLOD, 0, 8, NULL, HEXEN_S_NULL, 0, 0},       // HEXEN_S_BLOOD3
    {HEXEN_SPR_BLOD, 2, 8, NULL, HEXEN_S_BLOODSPLATTER2, 0, 0},     // HEXEN_S_BLOODSPLATTER1
    {HEXEN_SPR_BLOD, 1, 8, NULL, HEXEN_S_BLOODSPLATTER3, 0, 0},     // HEXEN_S_BLOODSPLATTER2
    {HEXEN_SPR_BLOD, 0, 8, NULL, HEXEN_S_NULL, 0, 0},       // HEXEN_S_BLOODSPLATTER3
    {HEXEN_SPR_BLOD, 0, 6, NULL, HEXEN_S_NULL, 0, 0},       // HEXEN_S_BLOODSPLATTERX
    {HEXEN_SPR_GIBS, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_GIBS1
    {HEXEN_SPR_PLAY, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_FPLAY
    {HEXEN_SPR_PLAY, 0, 4, NULL, HEXEN_S_FPLAY_RUN2, 0, 0}, // HEXEN_S_FPLAY_RUN1
    {HEXEN_SPR_PLAY, 1, 4, NULL, HEXEN_S_FPLAY_RUN3, 0, 0}, // HEXEN_S_FPLAY_RUN2
    {HEXEN_SPR_PLAY, 2, 4, NULL, HEXEN_S_FPLAY_RUN4, 0, 0}, // HEXEN_S_FPLAY_RUN3
    {HEXEN_SPR_PLAY, 3, 4, NULL, HEXEN_S_FPLAY_RUN1, 0, 0}, // HEXEN_S_FPLAY_RUN4
    {HEXEN_SPR_PLAY, 4, 8, NULL, HEXEN_S_FPLAY_ATK2, 0, 0}, // HEXEN_S_FPLAY_ATK1
    {HEXEN_SPR_PLAY, 5, 8, NULL, HEXEN_S_FPLAY, 0, 0},      // HEXEN_S_FPLAY_ATK2
    {HEXEN_SPR_PLAY, 6, 4, NULL, HEXEN_S_FPLAY_PAIN2, 0, 0},        // HEXEN_S_FPLAY_PAIN
    {HEXEN_SPR_PLAY, 6, 4, A_Pain, HEXEN_S_FPLAY, 0, 0},    // HEXEN_S_FPLAY_PAIN2
    {HEXEN_SPR_PLAY, 7, 6, NULL, HEXEN_S_FPLAY_DIE2, 0, 0}, // HEXEN_S_FPLAY_DIE1
    {HEXEN_SPR_PLAY, 8, 6, A_Scream, HEXEN_S_FPLAY_DIE3, 0, 0},     // HEXEN_S_FPLAY_DIE2
    {HEXEN_SPR_PLAY, 9, 6, NULL, HEXEN_S_FPLAY_DIE4, 0, 0}, // HEXEN_S_FPLAY_DIE3
    {HEXEN_SPR_PLAY, 10, 6, NULL, HEXEN_S_FPLAY_DIE5, 0, 0},        // HEXEN_S_FPLAY_DIE4
    {HEXEN_SPR_PLAY, 11, 6, A_NoBlocking, HEXEN_S_FPLAY_DIE6, 0, 0},        // HEXEN_S_FPLAY_DIE5
    {HEXEN_SPR_PLAY, 12, 6, NULL, HEXEN_S_FPLAY_DIE7, 0, 0},        // HEXEN_S_FPLAY_DIE6
    {HEXEN_SPR_PLAY, 13, -1, A_AddPlayerCorpse, HEXEN_S_NULL, 0, 0},        // HEXEN_S_FPLAY_DIE7
    {HEXEN_SPR_PLAY, 14, 5, A_Scream, HEXEN_S_FPLAY_XDIE2, 0, 0},   // HEXEN_S_FPLAY_XDIE1
    {HEXEN_SPR_PLAY, 15, 5, A_SkullPop, HEXEN_S_FPLAY_XDIE3, 0, 0}, // HEXEN_S_FPLAY_XDIE2
    {HEXEN_SPR_PLAY, 17, 5, A_NoBlocking, HEXEN_S_FPLAY_XDIE4, 0, 0},       // HEXEN_S_FPLAY_XDIE3
    {HEXEN_SPR_PLAY, 18, 5, NULL, HEXEN_S_FPLAY_XDIE5, 0, 0},       // HEXEN_S_FPLAY_XDIE4
    {HEXEN_SPR_PLAY, 19, 5, NULL, HEXEN_S_FPLAY_XDIE6, 0, 0},       // HEXEN_S_FPLAY_XDIE5
    {HEXEN_SPR_PLAY, 20, 5, NULL, HEXEN_S_FPLAY_XDIE7, 0, 0},       // HEXEN_S_FPLAY_XDIE6
    {HEXEN_SPR_PLAY, 21, 5, NULL, HEXEN_S_FPLAY_XDIE8, 0, 0},       // HEXEN_S_FPLAY_XDIE7
    {HEXEN_SPR_PLAY, 22, -1, A_AddPlayerCorpse, HEXEN_S_NULL, 0, 0},        // HEXEN_S_FPLAY_XDIE8
    {HEXEN_SPR_PLAY, 23, 5, A_FreezeDeath, HEXEN_S_FPLAY_ICE2, 0, 0},       // HEXEN_S_FPLAY_ICE
    {HEXEN_SPR_PLAY, 23, 1, A_FreezeDeathChunks, HEXEN_S_FPLAY_ICE2, 0, 0}, // HEXEN_S_FPLAY_ICE2
    {HEXEN_SPR_FDTH, 32768, 5, NULL, HEXEN_S_PLAY_F_FDTH2, 0, 0},   // HEXEN_S_PLAY_F_FDTH1
    {HEXEN_SPR_FDTH, 32769, 4, NULL, HEXEN_S_PLAY_FDTH3, 0, 0},     // HEXEN_S_PLAY_F_FDTH2
    {HEXEN_SPR_FDTH, 32770, 5, NULL, HEXEN_S_PLAY_C_FDTH2, 0, 0},   // HEXEN_S_PLAY_C_FDTH1
    {HEXEN_SPR_FDTH, 32771, 4, NULL, HEXEN_S_PLAY_FDTH3, 0, 0},     // HEXEN_S_PLAY_C_FDTH2
    {HEXEN_SPR_FDTH, 32772, 5, NULL, HEXEN_S_PLAY_M_FDTH2, 0, 0},   // HEXEN_S_PLAY_M_FDTH1
    {HEXEN_SPR_FDTH, 32773, 4, NULL, HEXEN_S_PLAY_FDTH3, 0, 0},     // HEXEN_S_PLAY_M_FDTH2
    {HEXEN_SPR_FDTH, 32774, 5, NULL, HEXEN_S_PLAY_FDTH4, 0, 0},     // HEXEN_S_PLAY_FDTH3
    {HEXEN_SPR_FDTH, 32775, 4, A_Scream, HEXEN_S_PLAY_FDTH5, 0, 0}, // HEXEN_S_PLAY_FDTH4
    {HEXEN_SPR_FDTH, 32776, 5, NULL, HEXEN_S_PLAY_FDTH6, 0, 0},     // HEXEN_S_PLAY_FDTH5
    {HEXEN_SPR_FDTH, 32777, 4, NULL, HEXEN_S_PLAY_FDTH7, 0, 0},     // HEXEN_S_PLAY_FDTH6
    {HEXEN_SPR_FDTH, 32778, 5, NULL, HEXEN_S_PLAY_FDTH8, 0, 0},     // HEXEN_S_PLAY_FDTH7
    {HEXEN_SPR_FDTH, 32779, 4, NULL, HEXEN_S_PLAY_FDTH9, 0, 0},     // HEXEN_S_PLAY_FDTH8
    {HEXEN_SPR_FDTH, 32780, 5, NULL, HEXEN_S_PLAY_FDTH10, 0, 0},    // HEXEN_S_PLAY_FDTH9
    {HEXEN_SPR_FDTH, 32781, 4, NULL, HEXEN_S_PLAY_FDTH11, 0, 0},    // HEXEN_S_PLAY_FDTH10
    {HEXEN_SPR_FDTH, 32782, 5, NULL, HEXEN_S_PLAY_FDTH12, 0, 0},    // HEXEN_S_PLAY_FDTH11
    {HEXEN_SPR_FDTH, 32783, 4, NULL, HEXEN_S_PLAY_FDTH13, 0, 0},    // HEXEN_S_PLAY_FDTH12
    {HEXEN_SPR_FDTH, 32784, 5, NULL, HEXEN_S_PLAY_FDTH14, 0, 0},    // HEXEN_S_PLAY_FDTH13
    {HEXEN_SPR_FDTH, 32785, 4, NULL, HEXEN_S_PLAY_FDTH15, 0, 0},    // HEXEN_S_PLAY_FDTH14
    {HEXEN_SPR_FDTH, 32786, 5, A_NoBlocking, HEXEN_S_PLAY_FDTH16, 0, 0},    // HEXEN_S_PLAY_FDTH15
    {HEXEN_SPR_FDTH, 32787, 4, NULL, HEXEN_S_PLAY_FDTH17, 0, 0},    // HEXEN_S_PLAY_FDTH16
    {HEXEN_SPR_FDTH, 32788, 5, NULL, HEXEN_S_PLAY_FDTH18, 0, 0},    // HEXEN_S_PLAY_FDTH17
    {HEXEN_SPR_FDTH, 32789, 4, NULL, HEXEN_S_PLAY_FDTH19, 0, 0},    // HEXEN_S_PLAY_FDTH18
    {HEXEN_SPR_ACLO, 4, 35, A_CheckBurnGone, HEXEN_S_PLAY_FDTH19, 0, 0},    // HEXEN_S_PLAY_FDTH19
    {HEXEN_SPR_ACLO, 4, 8, NULL, HEXEN_S_NULL, 0, 0},       // HEXEN_S_PLAY_FDTH20
    {HEXEN_SPR_BSKL, 0, 5, A_CheckSkullFloor, HEXEN_S_BLOODYSKULL2, 0, 0},  // HEXEN_S_BLOODYSKULL1
    {HEXEN_SPR_BSKL, 1, 5, A_CheckSkullFloor, HEXEN_S_BLOODYSKULL3, 0, 0},  // HEXEN_S_BLOODYSKULL2
    {HEXEN_SPR_BSKL, 2, 5, A_CheckSkullFloor, HEXEN_S_BLOODYSKULL4, 0, 0},  // HEXEN_S_BLOODYSKULL3
    {HEXEN_SPR_BSKL, 3, 5, A_CheckSkullFloor, HEXEN_S_BLOODYSKULL5, 0, 0},  // HEXEN_S_BLOODYSKULL4
    {HEXEN_SPR_BSKL, 5, 5, A_CheckSkullFloor, HEXEN_S_BLOODYSKULL6, 0, 0},  // HEXEN_S_BLOODYSKULL5
    {HEXEN_SPR_BSKL, 6, 5, A_CheckSkullFloor, HEXEN_S_BLOODYSKULL7, 0, 0},  // HEXEN_S_BLOODYSKULL6
    {HEXEN_SPR_BSKL, 7, 5, A_CheckSkullFloor, HEXEN_S_BLOODYSKULL1, 0, 0},  // HEXEN_S_BLOODYSKULL7
    {HEXEN_SPR_BSKL, 8, 16, A_CheckSkullDone, HEXEN_S_BLOODYSKULLX1, 0, 0}, // HEXEN_S_BLOODYSKULLX1
    {HEXEN_SPR_BSKL, 8, 1050, NULL, HEXEN_S_NULL, 0, 0},    // HEXEN_S_BLOODYSKULLX2
    {HEXEN_SPR_PLAY, 0, 5, NULL, HEXEN_S_PLAYER_SPEED2, 0, 0},      // HEXEN_S_PLAYER_SPEED1
    {HEXEN_SPR_PLAY, 0, 3, A_SpeedFade, HEXEN_S_NULL, 0, 0},        // HEXEN_S_PLAYER_SPEED2
    {HEXEN_SPR_ICEC, 0, 10, NULL, HEXEN_S_ICECHUNK2, 0, 0}, // HEXEN_S_ICECHUNK1
    {HEXEN_SPR_ICEC, 1, 10, A_IceSetTics, HEXEN_S_ICECHUNK3, 0, 0}, // HEXEN_S_ICECHUNK2
    {HEXEN_SPR_ICEC, 2, 10, A_IceSetTics, HEXEN_S_ICECHUNK4, 0, 0}, // HEXEN_S_ICECHUNK3
    {HEXEN_SPR_ICEC, 3, 10, A_IceSetTics, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ICECHUNK4
    {HEXEN_SPR_ICEC, 0, 10, A_IceCheckHeadDone, HEXEN_S_ICECHUNK_HEAD, 0, 0},       // HEXEN_S_ICECHUNK_HEAD
    {HEXEN_SPR_ICEC, 0, 1050, NULL, HEXEN_S_NULL, 0, 0},    // HEXEN_S_ICECHUNK_HEAD2
    {HEXEN_SPR_CLER, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_CPLAY
    {HEXEN_SPR_CLER, 0, 4, NULL, HEXEN_S_CPLAY_RUN2, 0, 0}, // HEXEN_S_CPLAY_RUN1
    {HEXEN_SPR_CLER, 1, 4, NULL, HEXEN_S_CPLAY_RUN3, 0, 0}, // HEXEN_S_CPLAY_RUN2
    {HEXEN_SPR_CLER, 2, 4, NULL, HEXEN_S_CPLAY_RUN4, 0, 0}, // HEXEN_S_CPLAY_RUN3
    {HEXEN_SPR_CLER, 3, 4, NULL, HEXEN_S_CPLAY_RUN1, 0, 0}, // HEXEN_S_CPLAY_RUN4
    {HEXEN_SPR_CLER, 4, 6, NULL, HEXEN_S_CPLAY_ATK2, 0, 0}, // HEXEN_S_CPLAY_ATK1
    {HEXEN_SPR_CLER, 5, 6, NULL, HEXEN_S_CPLAY_ATK3, 0, 0}, // HEXEN_S_CPLAY_ATK2
    {HEXEN_SPR_CLER, 6, 6, NULL, HEXEN_S_CPLAY, 0, 0},      // HEXEN_S_CPLAY_ATK3
    {HEXEN_SPR_CLER, 7, 4, NULL, HEXEN_S_CPLAY_PAIN2, 0, 0},        // HEXEN_S_CPLAY_PAIN
    {HEXEN_SPR_CLER, 7, 4, A_Pain, HEXEN_S_CPLAY, 0, 0},    // HEXEN_S_CPLAY_PAIN2
    {HEXEN_SPR_CLER, 8, 6, NULL, HEXEN_S_CPLAY_DIE2, 0, 0}, // HEXEN_S_CPLAY_DIE1
    {HEXEN_SPR_CLER, 10, 6, A_Scream, HEXEN_S_CPLAY_DIE3, 0, 0},    // HEXEN_S_CPLAY_DIE2
    {HEXEN_SPR_CLER, 11, 6, NULL, HEXEN_S_CPLAY_DIE4, 0, 0},        // HEXEN_S_CPLAY_DIE3
    {HEXEN_SPR_CLER, 11, 6, NULL, HEXEN_S_CPLAY_DIE5, 0, 0},        // HEXEN_S_CPLAY_DIE4
    {HEXEN_SPR_CLER, 12, 6, A_NoBlocking, HEXEN_S_CPLAY_DIE6, 0, 0},        // HEXEN_S_CPLAY_DIE5
    {HEXEN_SPR_CLER, 13, 6, NULL, HEXEN_S_CPLAY_DIE7, 0, 0},        // HEXEN_S_CPLAY_DIE6
    {HEXEN_SPR_CLER, 14, 6, NULL, HEXEN_S_CPLAY_DIE8, 0, 0},        // HEXEN_S_CPLAY_DIE7
    {HEXEN_SPR_CLER, 15, 6, NULL, HEXEN_S_CPLAY_DIE9, 0, 0},        // HEXEN_S_CPLAY_DIE8
    {HEXEN_SPR_CLER, 16, -1, A_AddPlayerCorpse, HEXEN_S_NULL, 0, 0},        // HEXEN_S_CPLAY_DIE9
    {HEXEN_SPR_CLER, 17, 5, A_Scream, HEXEN_S_CPLAY_XDIE2, 0, 0},   // HEXEN_S_CPLAY_XDIE1
    {HEXEN_SPR_CLER, 18, 5, NULL, HEXEN_S_CPLAY_XDIE3, 0, 0},       // HEXEN_S_CPLAY_XDIE2
    {HEXEN_SPR_CLER, 19, 5, A_NoBlocking, HEXEN_S_CPLAY_XDIE4, 0, 0},       // HEXEN_S_CPLAY_XDIE3
    {HEXEN_SPR_CLER, 20, 5, NULL, HEXEN_S_CPLAY_XDIE5, 0, 0},       // HEXEN_S_CPLAY_XDIE4
    {HEXEN_SPR_CLER, 21, 5, NULL, HEXEN_S_CPLAY_XDIE6, 0, 0},       // HEXEN_S_CPLAY_XDIE5
    {HEXEN_SPR_CLER, 22, 5, NULL, HEXEN_S_CPLAY_XDIE7, 0, 0},       // HEXEN_S_CPLAY_XDIE6
    {HEXEN_SPR_CLER, 23, 5, NULL, HEXEN_S_CPLAY_XDIE8, 0, 0},       // HEXEN_S_CPLAY_XDIE7
    {HEXEN_SPR_CLER, 24, 5, NULL, HEXEN_S_CPLAY_XDIE9, 0, 0},       // HEXEN_S_CPLAY_XDIE8
    {HEXEN_SPR_CLER, 25, 5, NULL, HEXEN_S_CPLAY_XDIE10, 0, 0},      // HEXEN_S_CPLAY_XDIE9
    {HEXEN_SPR_CLER, 26, -1, A_AddPlayerCorpse, HEXEN_S_NULL, 0, 0},        // HEXEN_S_CPLAY_XDIE10
    {HEXEN_SPR_CLER, 27, 5, A_FreezeDeath, HEXEN_S_CPLAY_ICE2, 0, 0},       // HEXEN_S_CPLAY_ICE
    {HEXEN_SPR_CLER, 27, 1, A_FreezeDeathChunks, HEXEN_S_CPLAY_ICE2, 0, 0}, // HEXEN_S_CPLAY_ICE2
    {HEXEN_SPR_MAGE, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_MPLAY
    {HEXEN_SPR_MAGE, 0, 4, NULL, HEXEN_S_MPLAY_RUN2, 0, 0}, // HEXEN_S_MPLAY_RUN1
    {HEXEN_SPR_MAGE, 1, 4, NULL, HEXEN_S_MPLAY_RUN3, 0, 0}, // HEXEN_S_MPLAY_RUN2
    {HEXEN_SPR_MAGE, 2, 4, NULL, HEXEN_S_MPLAY_RUN4, 0, 0}, // HEXEN_S_MPLAY_RUN3
    {HEXEN_SPR_MAGE, 3, 4, NULL, HEXEN_S_MPLAY_RUN1, 0, 0}, // HEXEN_S_MPLAY_RUN4
    {HEXEN_SPR_MAGE, 4, 8, NULL, HEXEN_S_MPLAY_ATK2, 0, 0}, // HEXEN_S_MPLAY_ATK1
    {HEXEN_SPR_MAGE, 32773, 8, NULL, HEXEN_S_MPLAY, 0, 0},  // HEXEN_S_MPLAY_ATK2
    {HEXEN_SPR_MAGE, 6, 4, NULL, HEXEN_S_MPLAY_PAIN2, 0, 0},        // HEXEN_S_MPLAY_PAIN
    {HEXEN_SPR_MAGE, 6, 4, A_Pain, HEXEN_S_MPLAY, 0, 0},    // HEXEN_S_MPLAY_PAIN2
    {HEXEN_SPR_MAGE, 7, 6, NULL, HEXEN_S_MPLAY_DIE2, 0, 0}, // HEXEN_S_MPLAY_DIE1
    {HEXEN_SPR_MAGE, 8, 6, A_Scream, HEXEN_S_MPLAY_DIE3, 0, 0},     // HEXEN_S_MPLAY_DIE2
    {HEXEN_SPR_MAGE, 9, 6, NULL, HEXEN_S_MPLAY_DIE4, 0, 0}, // HEXEN_S_MPLAY_DIE3
    {HEXEN_SPR_MAGE, 10, 6, NULL, HEXEN_S_MPLAY_DIE5, 0, 0},        // HEXEN_S_MPLAY_DIE4
    {HEXEN_SPR_MAGE, 11, 6, A_NoBlocking, HEXEN_S_MPLAY_DIE6, 0, 0},        // HEXEN_S_MPLAY_DIE5
    {HEXEN_SPR_MAGE, 12, 6, NULL, HEXEN_S_MPLAY_DIE7, 0, 0},        // HEXEN_S_MPLAY_DIE6
    {HEXEN_SPR_MAGE, 13, -1, A_AddPlayerCorpse, HEXEN_S_NULL, 0, 0},        // HEXEN_S_MPLAY_DIE7
    {HEXEN_SPR_MAGE, 14, 5, A_Scream, HEXEN_S_MPLAY_XDIE2, 0, 0},   // HEXEN_S_MPLAY_XDIE1
    {HEXEN_SPR_MAGE, 15, 5, NULL, HEXEN_S_MPLAY_XDIE3, 0, 0},       // HEXEN_S_MPLAY_XDIE2
    {HEXEN_SPR_MAGE, 17, 5, A_NoBlocking, HEXEN_S_MPLAY_XDIE4, 0, 0},       // HEXEN_S_MPLAY_XDIE3
    {HEXEN_SPR_MAGE, 18, 5, NULL, HEXEN_S_MPLAY_XDIE5, 0, 0},       // HEXEN_S_MPLAY_XDIE4
    {HEXEN_SPR_MAGE, 19, 5, NULL, HEXEN_S_MPLAY_XDIE6, 0, 0},       // HEXEN_S_MPLAY_XDIE5
    {HEXEN_SPR_MAGE, 20, 5, NULL, HEXEN_S_MPLAY_XDIE7, 0, 0},       // HEXEN_S_MPLAY_XDIE6
    {HEXEN_SPR_MAGE, 21, 5, NULL, HEXEN_S_MPLAY_XDIE8, 0, 0},       // HEXEN_S_MPLAY_XDIE7
    {HEXEN_SPR_MAGE, 22, 5, NULL, HEXEN_S_MPLAY_XDIE9, 0, 0},       // HEXEN_S_MPLAY_XDIE8
    {HEXEN_SPR_MAGE, 23, -1, A_AddPlayerCorpse, HEXEN_S_NULL, 0, 0},        // HEXEN_S_MPLAY_XDIE9
    {HEXEN_SPR_MAGE, 24, 5, A_FreezeDeath, HEXEN_S_MPLAY_ICE2, 0, 0},       // HEXEN_S_MPLAY_ICE
    {HEXEN_SPR_MAGE, 24, 1, A_FreezeDeathChunks, HEXEN_S_MPLAY_ICE2, 0, 0}, // HEXEN_S_MPLAY_ICE2
    {HEXEN_SPR_PIGY, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_PIGPLAY
    {HEXEN_SPR_PIGY, 0, 3, NULL, HEXEN_S_PIGPLAY_RUN2, 0, 0},       // HEXEN_S_PIGPLAY_RUN1
    {HEXEN_SPR_PIGY, 1, 3, NULL, HEXEN_S_PIGPLAY_RUN3, 0, 0},       // HEXEN_S_PIGPLAY_RUN2
    {HEXEN_SPR_PIGY, 2, 3, NULL, HEXEN_S_PIGPLAY_RUN4, 0, 0},       // HEXEN_S_PIGPLAY_RUN3
    {HEXEN_SPR_PIGY, 3, 3, NULL, HEXEN_S_PIGPLAY_RUN1, 0, 0},       // HEXEN_S_PIGPLAY_RUN4
    {HEXEN_SPR_PIGY, 0, 12, NULL, HEXEN_S_PIGPLAY, 0, 0},   // HEXEN_S_PIGPLAY_ATK1
    {HEXEN_SPR_PIGY, 3, 4, A_PigPain, HEXEN_S_PIGPLAY, 0, 0},       // HEXEN_S_PIGPLAY_PAIN
    {HEXEN_SPR_PIGY, 1, 10, A_PigLook, HEXEN_S_PIG_LOOK1, 0, 0},    // HEXEN_S_PIG_LOOK1
    {HEXEN_SPR_PIGY, 0, 3, A_PigChase, HEXEN_S_PIG_WALK2, 0, 0},    // HEXEN_S_PIG_WALK1
    {HEXEN_SPR_PIGY, 1, 3, A_PigChase, HEXEN_S_PIG_WALK3, 0, 0},    // HEXEN_S_PIG_WALK2
    {HEXEN_SPR_PIGY, 2, 3, A_PigChase, HEXEN_S_PIG_WALK4, 0, 0},    // HEXEN_S_PIG_WALK3
    {HEXEN_SPR_PIGY, 3, 3, A_PigChase, HEXEN_S_PIG_WALK1, 0, 0},    // HEXEN_S_PIG_WALK4
    {HEXEN_SPR_PIGY, 3, 4, A_PigPain, HEXEN_S_PIG_WALK1, 0, 0},     // HEXEN_S_PIG_PAIN
    {HEXEN_SPR_PIGY, 0, 5, A_FaceTarget, HEXEN_S_PIG_ATK2, 0, 0},   // HEXEN_S_PIG_ATK1
    {HEXEN_SPR_PIGY, 0, 10, A_PigAttack, HEXEN_S_PIG_WALK1, 0, 0},  // HEXEN_S_PIG_ATK2
    {HEXEN_SPR_PIGY, 4, 4, A_Scream, HEXEN_S_PIG_DIE2, 0, 0},       // HEXEN_S_PIG_DIE1
    {HEXEN_SPR_PIGY, 5, 3, A_NoBlocking, HEXEN_S_PIG_DIE3, 0, 0},   // HEXEN_S_PIG_DIE2
    {HEXEN_SPR_PIGY, 6, 4, A_QueueCorpse, HEXEN_S_PIG_DIE4, 0, 0},  // HEXEN_S_PIG_DIE3
    {HEXEN_SPR_PIGY, 7, 3, NULL, HEXEN_S_PIG_DIE5, 0, 0},   // HEXEN_S_PIG_DIE4
    {HEXEN_SPR_PIGY, 8, 4, NULL, HEXEN_S_PIG_DIE6, 0, 0},   // HEXEN_S_PIG_DIE5
    {HEXEN_SPR_PIGY, 9, 4, NULL, HEXEN_S_PIG_DIE7, 0, 0},   // HEXEN_S_PIG_DIE6
    {HEXEN_SPR_PIGY, 10, 4, NULL, HEXEN_S_PIG_DIE8, 0, 0},  // HEXEN_S_PIG_DIE7
    {HEXEN_SPR_PIGY, 11, -1, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_PIG_DIE8
    {HEXEN_SPR_PIGY, 12, 5, A_FreezeDeath, HEXEN_S_PIG_ICE2, 0, 0}, // HEXEN_S_PIG_ICE
    {HEXEN_SPR_PIGY, 12, 1, A_FreezeDeathChunks, HEXEN_S_PIG_ICE2, 0, 0},   // HEXEN_S_PIG_ICE2
    {HEXEN_SPR_CENT, 0, 10, A_Look, HEXEN_S_CENTAUR_LOOK2, 0, 0},   // HEXEN_S_CENTAUR_LOOK1
    {HEXEN_SPR_CENT, 1, 10, A_Look, HEXEN_S_CENTAUR_LOOK1, 0, 0},   // HEXEN_S_CENTAUR_LOOK2
    {HEXEN_SPR_CENT, 0, 4, A_Chase, HEXEN_S_CENTAUR_WALK2, 0, 0},   // HEXEN_S_CENTAUR_WALK1
    {HEXEN_SPR_CENT, 1, 4, A_Chase, HEXEN_S_CENTAUR_WALK3, 0, 0},   // HEXEN_S_CENTAUR_WALK2
    {HEXEN_SPR_CENT, 2, 4, A_Chase, HEXEN_S_CENTAUR_WALK4, 0, 0},   // HEXEN_S_CENTAUR_WALK3
    {HEXEN_SPR_CENT, 3, 4, A_Chase, HEXEN_S_CENTAUR_WALK1, 0, 0},   // HEXEN_S_CENTAUR_WALK4
    {HEXEN_SPR_CENT, 7, 5, A_FaceTarget, HEXEN_S_CENTAUR_ATK2, 0, 0},       // HEXEN_S_CENTAUR_ATK1
    {HEXEN_SPR_CENT, 8, 4, A_FaceTarget, HEXEN_S_CENTAUR_ATK3, 0, 0},       // HEXEN_S_CENTAUR_ATK2
    {HEXEN_SPR_CENT, 9, 7, A_CentaurAttack, HEXEN_S_CENTAUR_WALK1, 0, 0},   // HEXEN_S_CENTAUR_ATK3
    {HEXEN_SPR_CENT, 4, 10, A_FaceTarget, HEXEN_S_CENTAUR_MISSILE2, 0, 0},  // HEXEN_S_CENTAUR_MISSILE1
    {HEXEN_SPR_CENT, 32773, 8, A_CentaurAttack2, HEXEN_S_CENTAUR_MISSILE3, 0, 0},   // HEXEN_S_CENTAUR_MISSILE2
    {HEXEN_SPR_CENT, 4, 10, A_FaceTarget, HEXEN_S_CENTAUR_MISSILE4, 0, 0},  // HEXEN_S_CENTAUR_MISSILE3
    {HEXEN_SPR_CENT, 32773, 8, A_CentaurAttack2, HEXEN_S_CENTAUR_WALK1, 0, 0},      // HEXEN_S_CENTAUR_MISSILE4
    {HEXEN_SPR_CENT, 6, 6, A_Pain, HEXEN_S_CENTAUR_PAIN2, 0, 0},    // HEXEN_S_CENTAUR_PAIN1
    {HEXEN_SPR_CENT, 6, 6, A_SetReflective, HEXEN_S_CENTAUR_PAIN3, 0, 0},   // HEXEN_S_CENTAUR_PAIN2
    {HEXEN_SPR_CENT, 4, 15, A_CentaurDefend, HEXEN_S_CENTAUR_PAIN4, 0, 0},  // HEXEN_S_CENTAUR_PAIN3
    {HEXEN_SPR_CENT, 4, 15, A_CentaurDefend, HEXEN_S_CENTAUR_PAIN5, 0, 0},  // HEXEN_S_CENTAUR_PAIN4
    {HEXEN_SPR_CENT, 4, 15, A_CentaurDefend, HEXEN_S_CENTAUR_PAIN6, 0, 0},  // HEXEN_S_CENTAUR_PAIN5
    {HEXEN_SPR_CENT, 4, 1, A_UnSetReflective, HEXEN_S_CENTAUR_WALK1, 0, 0}, // HEXEN_S_CENTAUR_PAIN6
    {HEXEN_SPR_CENT, 10, 4, NULL, HEXEN_S_CENTAUR_DEATH2, 0, 0},    // HEXEN_S_CENTAUR_DEATH1
    {HEXEN_SPR_CENT, 11, 4, A_Scream, HEXEN_S_CENTAUR_DEATH3, 0, 0},        // HEXEN_S_CENTAUR_DEATH2
    {HEXEN_SPR_CENT, 12, 4, NULL, HEXEN_S_CENTAUR_DEATH4, 0, 0},    // HEXEN_S_CENTAUR_DEATH3
    {HEXEN_SPR_CENT, 13, 4, NULL, HEXEN_S_CENTAUR_DEATH5, 0, 0},    // HEXEN_S_CENTAUR_DEATH4
    {HEXEN_SPR_CENT, 14, 4, A_NoBlocking, HEXEN_S_CENTAUR_DEATH6, 0, 0},    // HEXEN_S_CENTAUR_DEATH5
    {HEXEN_SPR_CENT, 15, 4, NULL, HEXEN_S_CENTAUR_DEATH7, 0, 0},    // HEXEN_S_CENTAUR_DEATH6
    {HEXEN_SPR_CENT, 16, 4, NULL, HEXEN_S_CENTAUR_DEATH8, 0, 0},    // HEXEN_S_CENTAUR_DEATH7
    {HEXEN_SPR_CENT, 17, 4, A_QueueCorpse, HEXEN_S_CENTAUR_DEATH9, 0, 0},   // HEXEN_S_CENTAUR_DEATH8
    {HEXEN_SPR_CENT, 18, 4, NULL, HEXEN_S_CENTAUR_DEATH0, 0, 0},    // HEXEN_S_CENTAUR_DEATH9
    {HEXEN_SPR_CENT, 19, -1, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_CENTAUR_DEATH0
    {HEXEN_SPR_CTXD, 0, 4, NULL, HEXEN_S_CENTAUR_DEATH_X2, 0, 0},   // HEXEN_S_CENTAUR_DEATH_X1
    {HEXEN_SPR_CTXD, 1, 4, A_NoBlocking, HEXEN_S_CENTAUR_DEATH_X3, 0, 0},   // HEXEN_S_CENTAUR_DEATH_X2
    {HEXEN_SPR_CTXD, 2, 4, A_CentaurDropStuff, HEXEN_S_CENTAUR_DEATH_X4, 0, 0},     // HEXEN_S_CENTAUR_DEATH_X3
    {HEXEN_SPR_CTXD, 3, 3, A_Scream, HEXEN_S_CENTAUR_DEATH_X5, 0, 0},       // HEXEN_S_CENTAUR_DEATH_X4
    {HEXEN_SPR_CTXD, 4, 4, A_QueueCorpse, HEXEN_S_CENTAUR_DEATH_X6, 0, 0},  // HEXEN_S_CENTAUR_DEATH_X5
    {HEXEN_SPR_CTXD, 5, 3, NULL, HEXEN_S_CENTAUR_DEATH_X7, 0, 0},   // HEXEN_S_CENTAUR_DEATH_X6
    {HEXEN_SPR_CTXD, 6, 4, NULL, HEXEN_S_CENTAUR_DEATH_X8, 0, 0},   // HEXEN_S_CENTAUR_DEATH_X7
    {HEXEN_SPR_CTXD, 7, 3, NULL, HEXEN_S_CENTAUR_DEATH_X9, 0, 0},   // HEXEN_S_CENTAUR_DEATH_X8
    {HEXEN_SPR_CTXD, 8, 4, NULL, HEXEN_S_CENTAUR_DEATH_X10, 0, 0},  // HEXEN_S_CENTAUR_DEATH_X9
    {HEXEN_SPR_CTXD, 9, 3, NULL, HEXEN_S_CENTAUR_DEATH_X11, 0, 0},  // HEXEN_S_CENTAUR_DEATH_X10
    {HEXEN_SPR_CTXD, 10, -1, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_CENTAUR_DEATH_X11
    {HEXEN_SPR_CENT, 20, 5, A_FreezeDeath, HEXEN_S_CENTAUR_ICE2, 0, 0},     // HEXEN_S_CENTAUR_ICE
    {HEXEN_SPR_CENT, 20, 1, A_FreezeDeathChunks, HEXEN_S_CENTAUR_ICE2, 0, 0},       // HEXEN_S_CENTAUR_ICE2
    {HEXEN_SPR_CTFX, 32768, -1, NULL, HEXEN_S_NULL, 0, 0},  // HEXEN_S_CENTAUR_FX1
    {HEXEN_SPR_CTFX, 32769, 4, NULL, HEXEN_S_CENTAUR_FX_X2, 0, 0},  // HEXEN_S_CENTAUR_FX_X1
    {HEXEN_SPR_CTFX, 32770, 3, NULL, HEXEN_S_CENTAUR_FX_X3, 0, 0},  // HEXEN_S_CENTAUR_FX_X2
    {HEXEN_SPR_CTFX, 32771, 4, NULL, HEXEN_S_CENTAUR_FX_X4, 0, 0},  // HEXEN_S_CENTAUR_FX_X3
    {HEXEN_SPR_CTFX, 32772, 3, NULL, HEXEN_S_CENTAUR_FX_X5, 0, 0},  // HEXEN_S_CENTAUR_FX_X4
    {HEXEN_SPR_CTFX, 32773, 2, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_CENTAUR_FX_X5
    {HEXEN_SPR_CTDP, 0, 3, A_CheckFloor, HEXEN_S_CENTAUR_SHIELD2, 0, 0},    // HEXEN_S_CENTAUR_SHIELD1
    {HEXEN_SPR_CTDP, 1, 3, A_CheckFloor, HEXEN_S_CENTAUR_SHIELD3, 0, 0},    // HEXEN_S_CENTAUR_SHIELD2
    {HEXEN_SPR_CTDP, 2, 3, A_CheckFloor, HEXEN_S_CENTAUR_SHIELD4, 0, 0},    // HEXEN_S_CENTAUR_SHIELD3
    {HEXEN_SPR_CTDP, 3, 3, A_CheckFloor, HEXEN_S_CENTAUR_SHIELD5, 0, 0},    // HEXEN_S_CENTAUR_SHIELD4
    {HEXEN_SPR_CTDP, 4, 3, A_CheckFloor, HEXEN_S_CENTAUR_SHIELD6, 0, 0},    // HEXEN_S_CENTAUR_SHIELD5
    {HEXEN_SPR_CTDP, 5, 3, A_CheckFloor, HEXEN_S_CENTAUR_SHIELD3, 0, 0},    // HEXEN_S_CENTAUR_SHIELD6
    {HEXEN_SPR_CTDP, 6, 4, NULL, HEXEN_S_CENTAUR_SHIELD_X2, 0, 0},  // HEXEN_S_CENTAUR_SHIELD_X1
    {HEXEN_SPR_CTDP, 7, 4, A_QueueCorpse, HEXEN_S_CENTAUR_SHIELD_X3, 0, 0}, // HEXEN_S_CENTAUR_SHIELD_X2
    {HEXEN_SPR_CTDP, 8, 4, NULL, HEXEN_S_CENTAUR_SHIELD_X4, 0, 0},  // HEXEN_S_CENTAUR_SHIELD_X3
    {HEXEN_SPR_CTDP, 9, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_CENTAUR_SHIELD_X4
    {HEXEN_SPR_CTDP, 10, 3, A_CheckFloor, HEXEN_S_CENTAUR_SWORD2, 0, 0},    // HEXEN_S_CENTAUR_SWORD1
    {HEXEN_SPR_CTDP, 11, 3, A_CheckFloor, HEXEN_S_CENTAUR_SWORD3, 0, 0},    // HEXEN_S_CENTAUR_SWORD2
    {HEXEN_SPR_CTDP, 12, 3, A_CheckFloor, HEXEN_S_CENTAUR_SWORD4, 0, 0},    // HEXEN_S_CENTAUR_SWORD3
    {HEXEN_SPR_CTDP, 13, 3, A_CheckFloor, HEXEN_S_CENTAUR_SWORD5, 0, 0},    // HEXEN_S_CENTAUR_SWORD4
    {HEXEN_SPR_CTDP, 14, 3, A_CheckFloor, HEXEN_S_CENTAUR_SWORD6, 0, 0},    // HEXEN_S_CENTAUR_SWORD5
    {HEXEN_SPR_CTDP, 15, 3, A_CheckFloor, HEXEN_S_CENTAUR_SWORD7, 0, 0},    // HEXEN_S_CENTAUR_SWORD6
    {HEXEN_SPR_CTDP, 16, 3, A_CheckFloor, HEXEN_S_CENTAUR_SWORD3, 0, 0},    // HEXEN_S_CENTAUR_SWORD7
    {HEXEN_SPR_CTDP, 17, 4, NULL, HEXEN_S_CENTAUR_SWORD_X2, 0, 0},  // HEXEN_S_CENTAUR_SWORD_X1
    {HEXEN_SPR_CTDP, 18, 4, A_QueueCorpse, HEXEN_S_CENTAUR_SWORD_X3, 0, 0}, // HEXEN_S_CENTAUR_SWORD_X2
    {HEXEN_SPR_CTDP, 19, -1, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_CENTAUR_SWORD_X3
    {HEXEN_SPR_DEMN, 0, 10, A_Look, HEXEN_S_DEMN_LOOK2, 0, 0},      // HEXEN_S_DEMN_LOOK1
    {HEXEN_SPR_DEMN, 0, 10, A_Look, HEXEN_S_DEMN_LOOK1, 0, 0},      // HEXEN_S_DEMN_LOOK2
    {HEXEN_SPR_DEMN, 0, 4, A_Chase, HEXEN_S_DEMN_CHASE2, 0, 0},     // HEXEN_S_DEMN_CHASE1
    {HEXEN_SPR_DEMN, 1, 4, A_Chase, HEXEN_S_DEMN_CHASE3, 0, 0},     // HEXEN_S_DEMN_CHASE2
    {HEXEN_SPR_DEMN, 2, 4, A_Chase, HEXEN_S_DEMN_CHASE4, 0, 0},     // HEXEN_S_DEMN_CHASE3
    {HEXEN_SPR_DEMN, 3, 4, A_Chase, HEXEN_S_DEMN_CHASE1, 0, 0},     // HEXEN_S_DEMN_CHASE4
    {HEXEN_SPR_DEMN, 4, 6, A_FaceTarget, HEXEN_S_DEMN_ATK1_2, 0, 0},        // HEXEN_S_DEMN_ATK1_1
    {HEXEN_SPR_DEMN, 5, 8, A_FaceTarget, HEXEN_S_DEMN_ATK1_3, 0, 0},        // HEXEN_S_DEMN_ATK1_2
    {HEXEN_SPR_DEMN, 6, 6, A_DemonAttack1, HEXEN_S_DEMN_CHASE1, 0, 0},      // HEXEN_S_DEMN_ATK1_3
    {HEXEN_SPR_DEMN, 4, 5, A_FaceTarget, HEXEN_S_DEMN_ATK2_2, 0, 0},        // HEXEN_S_DEMN_ATK2_1
    {HEXEN_SPR_DEMN, 5, 6, A_FaceTarget, HEXEN_S_DEMN_ATK2_3, 0, 0},        // HEXEN_S_DEMN_ATK2_2
    {HEXEN_SPR_DEMN, 6, 5, A_DemonAttack2, HEXEN_S_DEMN_CHASE1, 0, 0},      // HEXEN_S_DEMN_ATK2_3
    {HEXEN_SPR_DEMN, 4, 4, NULL, HEXEN_S_DEMN_PAIN2, 0, 0}, // HEXEN_S_DEMN_PAIN1
    {HEXEN_SPR_DEMN, 4, 4, A_Pain, HEXEN_S_DEMN_CHASE1, 0, 0},      // HEXEN_S_DEMN_PAIN2
    {HEXEN_SPR_DEMN, 7, 6, NULL, HEXEN_S_DEMN_DEATH2, 0, 0},        // HEXEN_S_DEMN_DEATH1
    {HEXEN_SPR_DEMN, 8, 6, NULL, HEXEN_S_DEMN_DEATH3, 0, 0},        // HEXEN_S_DEMN_DEATH2
    {HEXEN_SPR_DEMN, 9, 6, A_Scream, HEXEN_S_DEMN_DEATH4, 0, 0},    // HEXEN_S_DEMN_DEATH3
    {HEXEN_SPR_DEMN, 10, 6, A_NoBlocking, HEXEN_S_DEMN_DEATH5, 0, 0},       // HEXEN_S_DEMN_DEATH4
    {HEXEN_SPR_DEMN, 11, 6, A_QueueCorpse, HEXEN_S_DEMN_DEATH6, 0, 0},      // HEXEN_S_DEMN_DEATH5
    {HEXEN_SPR_DEMN, 12, 6, NULL, HEXEN_S_DEMN_DEATH7, 0, 0},       // HEXEN_S_DEMN_DEATH6
    {HEXEN_SPR_DEMN, 13, 6, NULL, HEXEN_S_DEMN_DEATH8, 0, 0},       // HEXEN_S_DEMN_DEATH7
    {HEXEN_SPR_DEMN, 14, 6, NULL, HEXEN_S_DEMN_DEATH9, 0, 0},       // HEXEN_S_DEMN_DEATH8
    {HEXEN_SPR_DEMN, 15, -1, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_DEMN_DEATH9
    {HEXEN_SPR_DEMN, 7, 6, NULL, HEXEN_S_DEMN_XDEATH2, 0, 0},       // HEXEN_S_DEMN_XDEATH1
    {HEXEN_SPR_DEMN, 8, 6, A_DemonDeath, HEXEN_S_DEMN_XDEATH3, 0, 0},       // HEXEN_S_DEMN_XDEATH2
    {HEXEN_SPR_DEMN, 9, 6, A_Scream, HEXEN_S_DEMN_XDEATH4, 0, 0},   // HEXEN_S_DEMN_XDEATH3
    {HEXEN_SPR_DEMN, 10, 6, A_NoBlocking, HEXEN_S_DEMN_XDEATH5, 0, 0},      // HEXEN_S_DEMN_XDEATH4
    {HEXEN_SPR_DEMN, 11, 6, A_QueueCorpse, HEXEN_S_DEMN_XDEATH6, 0, 0},     // HEXEN_S_DEMN_XDEATH5
    {HEXEN_SPR_DEMN, 12, 6, NULL, HEXEN_S_DEMN_XDEATH7, 0, 0},      // HEXEN_S_DEMN_XDEATH6
    {HEXEN_SPR_DEMN, 13, 6, NULL, HEXEN_S_DEMN_XDEATH8, 0, 0},      // HEXEN_S_DEMN_XDEATH7
    {HEXEN_SPR_DEMN, 14, 6, NULL, HEXEN_S_DEMN_XDEATH9, 0, 0},      // HEXEN_S_DEMN_XDEATH8
    {HEXEN_SPR_DEMN, 15, -1, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_DEMN_XDEATH9
    {HEXEN_SPR_DEMN, 16, 5, A_FreezeDeath, HEXEN_S_DEMON_ICE2, 0, 0},       // HEXEN_S_DEMON_ICE
    {HEXEN_SPR_DEMN, 16, 1, A_FreezeDeathChunks, HEXEN_S_DEMON_ICE2, 0, 0}, // HEXEN_S_DEMON_ICE2
    {HEXEN_SPR_DEMA, 0, 4, NULL, HEXEN_S_DEMONCHUNK1_2, 0, 0},      // HEXEN_S_DEMONCHUNK1_1
    {HEXEN_SPR_DEMA, 0, 10, A_QueueCorpse, HEXEN_S_DEMONCHUNK1_3, 0, 0},    // HEXEN_S_DEMONCHUNK1_2
    {HEXEN_SPR_DEMA, 0, 20, NULL, HEXEN_S_DEMONCHUNK1_3, 0, 0},     // HEXEN_S_DEMONCHUNK1_3
    {HEXEN_SPR_DEMA, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_DEMONCHUNK1_4
    {HEXEN_SPR_DEMB, 0, 4, NULL, HEXEN_S_DEMONCHUNK2_2, 0, 0},      // HEXEN_S_DEMONCHUNK2_1
    {HEXEN_SPR_DEMB, 0, 10, A_QueueCorpse, HEXEN_S_DEMONCHUNK2_3, 0, 0},    // HEXEN_S_DEMONCHUNK2_2
    {HEXEN_SPR_DEMB, 0, 20, NULL, HEXEN_S_DEMONCHUNK2_3, 0, 0},     // HEXEN_S_DEMONCHUNK2_3
    {HEXEN_SPR_DEMB, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_DEMONCHUNK2_4
    {HEXEN_SPR_DEMC, 0, 4, NULL, HEXEN_S_DEMONCHUNK3_2, 0, 0},      // HEXEN_S_DEMONCHUNK3_1
    {HEXEN_SPR_DEMC, 0, 10, A_QueueCorpse, HEXEN_S_DEMONCHUNK3_3, 0, 0},    // HEXEN_S_DEMONCHUNK3_2
    {HEXEN_SPR_DEMC, 0, 20, NULL, HEXEN_S_DEMONCHUNK3_3, 0, 0},     // HEXEN_S_DEMONCHUNK3_3
    {HEXEN_SPR_DEMC, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_DEMONCHUNK3_4
    {HEXEN_SPR_DEMD, 0, 4, NULL, HEXEN_S_DEMONCHUNK4_2, 0, 0},      // HEXEN_S_DEMONCHUNK4_1
    {HEXEN_SPR_DEMD, 0, 10, A_QueueCorpse, HEXEN_S_DEMONCHUNK4_3, 0, 0},    // HEXEN_S_DEMONCHUNK4_2
    {HEXEN_SPR_DEMD, 0, 20, NULL, HEXEN_S_DEMONCHUNK4_3, 0, 0},     // HEXEN_S_DEMONCHUNK4_3
    {HEXEN_SPR_DEMD, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_DEMONCHUNK4_4
    {HEXEN_SPR_DEME, 0, 4, NULL, HEXEN_S_DEMONCHUNK5_2, 0, 0},      // HEXEN_S_DEMONCHUNK5_1
    {HEXEN_SPR_DEME, 0, 10, A_QueueCorpse, HEXEN_S_DEMONCHUNK5_3, 0, 0},    // HEXEN_S_DEMONCHUNK5_2
    {HEXEN_SPR_DEME, 0, 20, NULL, HEXEN_S_DEMONCHUNK5_3, 0, 0},     // HEXEN_S_DEMONCHUNK5_3
    {HEXEN_SPR_DEME, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_DEMONCHUNK5_4
    {HEXEN_SPR_DMFX, 32768, 4, NULL, HEXEN_S_DEMONFX_MOVE2, 0, 0},  // HEXEN_S_DEMONFX_MOVE1
    {HEXEN_SPR_DMFX, 32769, 4, NULL, HEXEN_S_DEMONFX_MOVE3, 0, 0},  // HEXEN_S_DEMONFX_MOVE2
    {HEXEN_SPR_DMFX, 32770, 4, NULL, HEXEN_S_DEMONFX_MOVE1, 0, 0},  // HEXEN_S_DEMONFX_MOVE3
    {HEXEN_SPR_DMFX, 32771, 4, NULL, HEXEN_S_DEMONFX_BOOM2, 0, 0},  // HEXEN_S_DEMONFX_BOOM1
    {HEXEN_SPR_DMFX, 32772, 4, NULL, HEXEN_S_DEMONFX_BOOM3, 0, 0},  // HEXEN_S_DEMONFX_BOOM2
    {HEXEN_SPR_DMFX, 32773, 3, NULL, HEXEN_S_DEMONFX_BOOM4, 0, 0},  // HEXEN_S_DEMONFX_BOOM3
    {HEXEN_SPR_DMFX, 32774, 3, NULL, HEXEN_S_DEMONFX_BOOM5, 0, 0},  // HEXEN_S_DEMONFX_BOOM4
    {HEXEN_SPR_DMFX, 32775, 3, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_DEMONFX_BOOM5
    {HEXEN_SPR_DEM2, 0, 10, A_Look, HEXEN_S_DEMN2_LOOK2, 0, 0},     // HEXEN_S_DEMN2_LOOK1
    {HEXEN_SPR_DEM2, 0, 10, A_Look, HEXEN_S_DEMN2_LOOK1, 0, 0},     // HEXEN_S_DEMN2_LOOK2
    {HEXEN_SPR_DEM2, 0, 4, A_Chase, HEXEN_S_DEMN2_CHASE2, 0, 0},    // HEXEN_S_DEMN2_CHASE1
    {HEXEN_SPR_DEM2, 1, 4, A_Chase, HEXEN_S_DEMN2_CHASE3, 0, 0},    // HEXEN_S_DEMN2_CHASE2
    {HEXEN_SPR_DEM2, 2, 4, A_Chase, HEXEN_S_DEMN2_CHASE4, 0, 0},    // HEXEN_S_DEMN2_CHASE3
    {HEXEN_SPR_DEM2, 3, 4, A_Chase, HEXEN_S_DEMN2_CHASE1, 0, 0},    // HEXEN_S_DEMN2_CHASE4
    {HEXEN_SPR_DEM2, 4, 6, A_FaceTarget, HEXEN_S_DEMN2_ATK1_2, 0, 0},       // HEXEN_S_DEMN2_ATK1_1
    {HEXEN_SPR_DEM2, 5, 8, A_FaceTarget, HEXEN_S_DEMN2_ATK1_3, 0, 0},       // HEXEN_S_DEMN2_ATK1_2
    {HEXEN_SPR_DEM2, 6, 6, A_DemonAttack1, HEXEN_S_DEMN2_CHASE1, 0, 0},     // HEXEN_S_DEMN2_ATK1_3
    {HEXEN_SPR_DEM2, 4, 5, A_FaceTarget, HEXEN_S_DEMN2_ATK2_2, 0, 0},       // HEXEN_S_DEMN2_ATK2_1
    {HEXEN_SPR_DEM2, 5, 6, A_FaceTarget, HEXEN_S_DEMN2_ATK2_3, 0, 0},       // HEXEN_S_DEMN2_ATK2_2
    {HEXEN_SPR_DEM2, 6, 5, A_DemonAttack2, HEXEN_S_DEMN2_CHASE1, 0, 0},     // HEXEN_S_DEMN2_ATK2_3
    {HEXEN_SPR_DEM2, 4, 4, NULL, HEXEN_S_DEMN2_PAIN2, 0, 0},        // HEXEN_S_DEMN2_PAIN1
    {HEXEN_SPR_DEM2, 4, 4, A_Pain, HEXEN_S_DEMN2_CHASE1, 0, 0},     // HEXEN_S_DEMN2_PAIN2
    {HEXEN_SPR_DEM2, 7, 6, NULL, HEXEN_S_DEMN2_DEATH2, 0, 0},       // HEXEN_S_DEMN2_DEATH1
    {HEXEN_SPR_DEM2, 8, 6, NULL, HEXEN_S_DEMN2_DEATH3, 0, 0},       // HEXEN_S_DEMN2_DEATH2
    {HEXEN_SPR_DEM2, 9, 6, A_Scream, HEXEN_S_DEMN2_DEATH4, 0, 0},   // HEXEN_S_DEMN2_DEATH3
    {HEXEN_SPR_DEM2, 10, 6, A_NoBlocking, HEXEN_S_DEMN2_DEATH5, 0, 0},      // HEXEN_S_DEMN2_DEATH4
    {HEXEN_SPR_DEM2, 11, 6, A_QueueCorpse, HEXEN_S_DEMN2_DEATH6, 0, 0},     // HEXEN_S_DEMN2_DEATH5
    {HEXEN_SPR_DEM2, 12, 6, NULL, HEXEN_S_DEMN2_DEATH7, 0, 0},      // HEXEN_S_DEMN2_DEATH6
    {HEXEN_SPR_DEM2, 13, 6, NULL, HEXEN_S_DEMN2_DEATH8, 0, 0},      // HEXEN_S_DEMN2_DEATH7
    {HEXEN_SPR_DEM2, 14, 6, NULL, HEXEN_S_DEMN2_DEATH9, 0, 0},      // HEXEN_S_DEMN2_DEATH8
    {HEXEN_SPR_DEM2, 15, -1, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_DEMN2_DEATH9
    {HEXEN_SPR_DEM2, 7, 6, NULL, HEXEN_S_DEMN2_XDEATH2, 0, 0},      // HEXEN_S_DEMN2_XDEATH1
    {HEXEN_SPR_DEM2, 8, 6, A_Demon2Death, HEXEN_S_DEMN2_XDEATH3, 0, 0},     // HEXEN_S_DEMN2_XDEATH2
    {HEXEN_SPR_DEM2, 9, 6, A_Scream, HEXEN_S_DEMN2_XDEATH4, 0, 0},  // HEXEN_S_DEMN2_XDEATH3
    {HEXEN_SPR_DEM2, 10, 6, A_NoBlocking, HEXEN_S_DEMN2_XDEATH5, 0, 0},     // HEXEN_S_DEMN2_XDEATH4
    {HEXEN_SPR_DEM2, 11, 6, A_QueueCorpse, HEXEN_S_DEMN2_XDEATH6, 0, 0},    // HEXEN_S_DEMN2_XDEATH5
    {HEXEN_SPR_DEM2, 12, 6, NULL, HEXEN_S_DEMN2_XDEATH7, 0, 0},     // HEXEN_S_DEMN2_XDEATH6
    {HEXEN_SPR_DEM2, 13, 6, NULL, HEXEN_S_DEMN2_XDEATH8, 0, 0},     // HEXEN_S_DEMN2_XDEATH7
    {HEXEN_SPR_DEM2, 14, 6, NULL, HEXEN_S_DEMN2_XDEATH9, 0, 0},     // HEXEN_S_DEMN2_XDEATH8
    {HEXEN_SPR_DEM2, 15, -1, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_DEMN2_XDEATH9
    {HEXEN_SPR_DMBA, 0, 4, NULL, HEXEN_S_DEMON2CHUNK1_2, 0, 0},     // HEXEN_S_DEMON2CHUNK1_1
    {HEXEN_SPR_DMBA, 0, 10, A_QueueCorpse, HEXEN_S_DEMON2CHUNK1_3, 0, 0},   // HEXEN_S_DEMON2CHUNK1_2
    {HEXEN_SPR_DMBA, 0, 20, NULL, HEXEN_S_DEMON2CHUNK1_3, 0, 0},    // HEXEN_S_DEMON2CHUNK1_3
    {HEXEN_SPR_DMBA, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_DEMON2CHUNK1_4
    {HEXEN_SPR_DMBB, 0, 4, NULL, HEXEN_S_DEMON2CHUNK2_2, 0, 0},     // HEXEN_S_DEMON2CHUNK2_1
    {HEXEN_SPR_DMBB, 0, 10, A_QueueCorpse, HEXEN_S_DEMON2CHUNK2_3, 0, 0},   // HEXEN_S_DEMON2CHUNK2_2
    {HEXEN_SPR_DMBB, 0, 20, NULL, HEXEN_S_DEMON2CHUNK2_3, 0, 0},    // HEXEN_S_DEMON2CHUNK2_3
    {HEXEN_SPR_DMBB, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_DEMON2CHUNK2_4
    {HEXEN_SPR_DMBC, 0, 4, NULL, HEXEN_S_DEMON2CHUNK3_2, 0, 0},     // HEXEN_S_DEMON2CHUNK3_1
    {HEXEN_SPR_DMBC, 0, 10, A_QueueCorpse, HEXEN_S_DEMON2CHUNK3_3, 0, 0},   // HEXEN_S_DEMON2CHUNK3_2
    {HEXEN_SPR_DMBC, 0, 20, NULL, HEXEN_S_DEMON2CHUNK3_3, 0, 0},    // HEXEN_S_DEMON2CHUNK3_3
    {HEXEN_SPR_DMBC, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_DEMON2CHUNK3_4
    {HEXEN_SPR_DMBD, 0, 4, NULL, HEXEN_S_DEMON2CHUNK4_2, 0, 0},     // HEXEN_S_DEMON2CHUNK4_1
    {HEXEN_SPR_DMBD, 0, 10, A_QueueCorpse, HEXEN_S_DEMON2CHUNK4_3, 0, 0},   // HEXEN_S_DEMON2CHUNK4_2
    {HEXEN_SPR_DMBD, 0, 20, NULL, HEXEN_S_DEMON2CHUNK4_3, 0, 0},    // HEXEN_S_DEMON2CHUNK4_3
    {HEXEN_SPR_DMBD, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_DEMON2CHUNK4_4
    {HEXEN_SPR_DMBE, 0, 4, NULL, HEXEN_S_DEMON2CHUNK5_2, 0, 0},     // HEXEN_S_DEMON2CHUNK5_1
    {HEXEN_SPR_DMBE, 0, 10, NULL, HEXEN_S_DEMON2CHUNK5_3, 0, 0},    // HEXEN_S_DEMON2CHUNK5_2
    {HEXEN_SPR_DMBE, 0, 20, NULL, HEXEN_S_DEMON2CHUNK5_3, 0, 0},    // HEXEN_S_DEMON2CHUNK5_3
    {HEXEN_SPR_DMBE, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_DEMON2CHUNK5_4
    {HEXEN_SPR_D2FX, 32768, 4, NULL, HEXEN_S_DEMON2FX_MOVE2, 0, 0}, // HEXEN_S_DEMON2FX_MOVE1
    {HEXEN_SPR_D2FX, 32769, 4, NULL, HEXEN_S_DEMON2FX_MOVE3, 0, 0}, // HEXEN_S_DEMON2FX_MOVE2
    {HEXEN_SPR_D2FX, 32770, 4, NULL, HEXEN_S_DEMON2FX_MOVE4, 0, 0}, // HEXEN_S_DEMON2FX_MOVE3
    {HEXEN_SPR_D2FX, 32771, 4, NULL, HEXEN_S_DEMON2FX_MOVE5, 0, 0}, // HEXEN_S_DEMON2FX_MOVE4
    {HEXEN_SPR_D2FX, 32772, 4, NULL, HEXEN_S_DEMON2FX_MOVE6, 0, 0}, // HEXEN_S_DEMON2FX_MOVE5
    {HEXEN_SPR_D2FX, 32773, 4, NULL, HEXEN_S_DEMON2FX_MOVE1, 0, 0}, // HEXEN_S_DEMON2FX_MOVE6
    {HEXEN_SPR_D2FX, 32774, 4, NULL, HEXEN_S_DEMON2FX_BOOM2, 0, 0}, // HEXEN_S_DEMON2FX_BOOM1
    {HEXEN_SPR_D2FX, 32775, 4, NULL, HEXEN_S_DEMON2FX_BOOM3, 0, 0}, // HEXEN_S_DEMON2FX_BOOM2
    {HEXEN_SPR_D2FX, 32776, 4, NULL, HEXEN_S_DEMON2FX_BOOM4, 0, 0}, // HEXEN_S_DEMON2FX_BOOM3
    {HEXEN_SPR_D2FX, 32777, 4, NULL, HEXEN_S_DEMON2FX_BOOM5, 0, 0}, // HEXEN_S_DEMON2FX_BOOM4
    {HEXEN_SPR_D2FX, 32778, 3, NULL, HEXEN_S_DEMON2FX_BOOM6, 0, 0}, // HEXEN_S_DEMON2FX_BOOM5
    {HEXEN_SPR_D2FX, 32779, 3, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_DEMON2FX_BOOM6
    {HEXEN_SPR_WRTH, 0, 2, A_WraithRaiseInit, HEXEN_S_WRAITH_RAISE2, 0, 0}, // HEXEN_S_WRAITH_RAISE1
    {HEXEN_SPR_WRTH, 0, 2, A_WraithRaise, HEXEN_S_WRAITH_RAISE3, 0, 0},     // HEXEN_S_WRAITH_RAISE2
    {HEXEN_SPR_WRTH, 0, 2, A_FaceTarget, HEXEN_S_WRAITH_RAISE4, 0, 0},      // HEXEN_S_WRAITH_RAISE3
    {HEXEN_SPR_WRTH, 1, 2, A_WraithRaise, HEXEN_S_WRAITH_RAISE5, 0, 0},     // HEXEN_S_WRAITH_RAISE4
    {HEXEN_SPR_WRTH, 1, 2, A_WraithRaise, HEXEN_S_WRAITH_RAISE2, 0, 0},     // HEXEN_S_WRAITH_RAISE5
    {HEXEN_SPR_WRTH, 0, 10, NULL, HEXEN_S_WRAITH_INIT2, 0, 0},      // HEXEN_S_WRAITH_INIT1
    {HEXEN_SPR_WRTH, 1, 5, A_WraithInit, HEXEN_S_WRAITH_LOOK1, 0, 0},       // HEXEN_S_WRAITH_INIT2
    {HEXEN_SPR_WRTH, 0, 15, A_WraithLook, HEXEN_S_WRAITH_LOOK2, 0, 0},      // HEXEN_S_WRAITH_LOOK1
    {HEXEN_SPR_WRTH, 1, 15, A_WraithLook, HEXEN_S_WRAITH_LOOK1, 0, 0},      // HEXEN_S_WRAITH_LOOK2
    {HEXEN_SPR_WRTH, 0, 4, A_WraithChase, HEXEN_S_WRAITH_CHASE2, 0, 0},     // HEXEN_S_WRAITH_CHASE1
    {HEXEN_SPR_WRTH, 1, 4, A_WraithChase, HEXEN_S_WRAITH_CHASE3, 0, 0},     // HEXEN_S_WRAITH_CHASE2
    {HEXEN_SPR_WRTH, 2, 4, A_WraithChase, HEXEN_S_WRAITH_CHASE4, 0, 0},     // HEXEN_S_WRAITH_CHASE3
    {HEXEN_SPR_WRTH, 3, 4, A_WraithChase, HEXEN_S_WRAITH_CHASE1, 0, 0},     // HEXEN_S_WRAITH_CHASE4
    {HEXEN_SPR_WRTH, 4, 6, A_FaceTarget, HEXEN_S_WRAITH_ATK1_2, 0, 0},      // HEXEN_S_WRAITH_ATK1_1
    {HEXEN_SPR_WRTH, 5, 6, A_WraithFX3, HEXEN_S_WRAITH_ATK1_3, 0, 0},       // HEXEN_S_WRAITH_ATK1_2
    {HEXEN_SPR_WRTH, 6, 6, A_WraithMelee, HEXEN_S_WRAITH_CHASE1, 0, 0},     // HEXEN_S_WRAITH_ATK1_3
    {HEXEN_SPR_WRTH, 4, 6, A_FaceTarget, HEXEN_S_WRAITH_ATK2_2, 0, 0},      // HEXEN_S_WRAITH_ATK2_1
    {HEXEN_SPR_WRTH, 5, 6, NULL, HEXEN_S_WRAITH_ATK2_3, 0, 0},      // HEXEN_S_WRAITH_ATK2_2
    {HEXEN_SPR_WRTH, 6, 6, A_WraithMissile, HEXEN_S_WRAITH_CHASE1, 0, 0},   // HEXEN_S_WRAITH_ATK2_3
    {HEXEN_SPR_WRTH, 0, 2, NULL, HEXEN_S_WRAITH_PAIN2, 0, 0},       // HEXEN_S_WRAITH_PAIN1
    {HEXEN_SPR_WRTH, 7, 6, A_Pain, HEXEN_S_WRAITH_CHASE1, 0, 0},    // HEXEN_S_WRAITH_PAIN2
    {HEXEN_SPR_WRTH, 8, 4, NULL, HEXEN_S_WRAITH_DEATH1_2, 0, 0},    // HEXEN_S_WRAITH_DEATH1_1
    {HEXEN_SPR_WRTH, 9, 4, A_Scream, HEXEN_S_WRAITH_DEATH1_3, 0, 0},        // HEXEN_S_WRAITH_DEATH1_2
    {HEXEN_SPR_WRTH, 10, 4, NULL, HEXEN_S_WRAITH_DEATH1_4, 0, 0},   // HEXEN_S_WRAITH_DEATH1_3
    {HEXEN_SPR_WRTH, 11, 4, NULL, HEXEN_S_WRAITH_DEATH1_5, 0, 0},   // HEXEN_S_WRAITH_DEATH1_4
    {HEXEN_SPR_WRTH, 12, 4, A_NoBlocking, HEXEN_S_WRAITH_DEATH1_6, 0, 0},   // HEXEN_S_WRAITH_DEATH1_5
    {HEXEN_SPR_WRTH, 13, 4, A_QueueCorpse, HEXEN_S_WRAITH_DEATH1_7, 0, 0},  // HEXEN_S_WRAITH_DEATH1_6
    {HEXEN_SPR_WRTH, 14, 4, NULL, HEXEN_S_WRAITH_DEATH1_8, 0, 0},   // HEXEN_S_WRAITH_DEATH1_7
    {HEXEN_SPR_WRTH, 15, 5, NULL, HEXEN_S_WRAITH_DEATH1_9, 0, 0},   // HEXEN_S_WRAITH_DEATH1_8
    {HEXEN_SPR_WRTH, 16, 5, NULL, HEXEN_S_WRAITH_DEATH1_0, 0, 0},   // HEXEN_S_WRAITH_DEATH1_9
    {HEXEN_SPR_WRTH, 17, -1, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_WRAITH_DEATH1_0
    {HEXEN_SPR_WRT2, 0, 5, NULL, HEXEN_S_WRAITH_DEATH2_2, 0, 0},    // HEXEN_S_WRAITH_DEATH2_1
    {HEXEN_SPR_WRT2, 1, 5, A_Scream, HEXEN_S_WRAITH_DEATH2_3, 0, 0},        // HEXEN_S_WRAITH_DEATH2_2
    {HEXEN_SPR_WRT2, 2, 5, NULL, HEXEN_S_WRAITH_DEATH2_4, 0, 0},    // HEXEN_S_WRAITH_DEATH2_3
    {HEXEN_SPR_WRT2, 3, 5, NULL, HEXEN_S_WRAITH_DEATH2_5, 0, 0},    // HEXEN_S_WRAITH_DEATH2_4
    {HEXEN_SPR_WRT2, 4, 5, A_NoBlocking, HEXEN_S_WRAITH_DEATH2_6, 0, 0},    // HEXEN_S_WRAITH_DEATH2_5
    {HEXEN_SPR_WRT2, 5, 5, A_QueueCorpse, HEXEN_S_WRAITH_DEATH2_7, 0, 0},   // HEXEN_S_WRAITH_DEATH2_6
    {HEXEN_SPR_WRT2, 6, 5, NULL, HEXEN_S_WRAITH_DEATH2_8, 0, 0},    // HEXEN_S_WRAITH_DEATH2_7
    {HEXEN_SPR_WRT2, 7, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_WRAITH_DEATH2_8
    {HEXEN_SPR_WRT2, 8, 5, A_FreezeDeath, HEXEN_S_WRAITH_ICE2, 0, 0},       // HEXEN_S_WRAITH_ICE
    {HEXEN_SPR_WRT2, 8, 1, A_FreezeDeathChunks, HEXEN_S_WRAITH_ICE2, 0, 0}, // HEXEN_S_WRAITH_ICE2
    {HEXEN_SPR_WRBL, 32768, 3, NULL, HEXEN_S_WRTHFX_MOVE2, 0, 0},   // HEXEN_S_WRTHFX_MOVE1
    {HEXEN_SPR_WRBL, 32769, 3, A_WraithFX2, HEXEN_S_WRTHFX_MOVE3, 0, 0},    // HEXEN_S_WRTHFX_MOVE2
    {HEXEN_SPR_WRBL, 32770, 3, NULL, HEXEN_S_WRTHFX_MOVE1, 0, 0},   // HEXEN_S_WRTHFX_MOVE3
    {HEXEN_SPR_WRBL, 32771, 4, NULL, HEXEN_S_WRTHFX_BOOM2, 0, 0},   // HEXEN_S_WRTHFX_BOOM1
    {HEXEN_SPR_WRBL, 32772, 4, A_WraithFX2, HEXEN_S_WRTHFX_BOOM3, 0, 0},    // HEXEN_S_WRTHFX_BOOM2
    {HEXEN_SPR_WRBL, 32773, 4, NULL, HEXEN_S_WRTHFX_BOOM4, 0, 0},   // HEXEN_S_WRTHFX_BOOM3
    {HEXEN_SPR_WRBL, 32774, 3, A_WraithFX2, HEXEN_S_WRTHFX_BOOM5, 0, 0},    // HEXEN_S_WRTHFX_BOOM4
    {HEXEN_SPR_WRBL, 32775, 3, A_WraithFX2, HEXEN_S_WRTHFX_BOOM6, 0, 0},    // HEXEN_S_WRTHFX_BOOM5
    {HEXEN_SPR_WRBL, 32776, 3, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_WRTHFX_BOOM6
    {HEXEN_SPR_WRBL, 32777, 4, NULL, HEXEN_S_WRTHFX_SIZZLE2, 0, 0}, // HEXEN_S_WRTHFX_SIZZLE1
    {HEXEN_SPR_WRBL, 32778, 4, NULL, HEXEN_S_WRTHFX_SIZZLE3, 0, 0}, // HEXEN_S_WRTHFX_SIZZLE2
    {HEXEN_SPR_WRBL, 32779, 4, NULL, HEXEN_S_WRTHFX_SIZZLE4, 0, 0}, // HEXEN_S_WRTHFX_SIZZLE3
    {HEXEN_SPR_WRBL, 32780, 4, NULL, HEXEN_S_WRTHFX_SIZZLE5, 0, 0}, // HEXEN_S_WRTHFX_SIZZLE4
    {HEXEN_SPR_WRBL, 32781, 4, NULL, HEXEN_S_WRTHFX_SIZZLE6, 0, 0}, // HEXEN_S_WRTHFX_SIZZLE5
    {HEXEN_SPR_WRBL, 32782, 4, NULL, HEXEN_S_WRTHFX_SIZZLE7, 0, 0}, // HEXEN_S_WRTHFX_SIZZLE6
    {HEXEN_SPR_WRBL, 32783, 4, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_WRTHFX_SIZZLE7
    {HEXEN_SPR_WRBL, 32784, 4, NULL, HEXEN_S_WRTHFX_DROP2, 0, 0},   // HEXEN_S_WRTHFX_DROP1
    {HEXEN_SPR_WRBL, 32785, 4, NULL, HEXEN_S_WRTHFX_DROP3, 0, 0},   // HEXEN_S_WRTHFX_DROP2
    {HEXEN_SPR_WRBL, 32786, 4, NULL, HEXEN_S_WRTHFX_DROP1, 0, 0},   // HEXEN_S_WRTHFX_DROP3
    {HEXEN_SPR_WRBL, 32786, 4, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_WRTHFX_DEAD1
    {HEXEN_SPR_WRBL, 19, 4, NULL, HEXEN_S_WRTHFX_ADROP2, 0, 0},     // HEXEN_S_WRTHFX_ADROP1
    {HEXEN_SPR_WRBL, 20, 4, NULL, HEXEN_S_WRTHFX_ADROP3, 0, 0},     // HEXEN_S_WRTHFX_ADROP2
    {HEXEN_SPR_WRBL, 21, 4, NULL, HEXEN_S_WRTHFX_ADROP4, 0, 0},     // HEXEN_S_WRTHFX_ADROP3
    {HEXEN_SPR_WRBL, 22, 4, NULL, HEXEN_S_WRTHFX_ADROP1, 0, 0},     // HEXEN_S_WRTHFX_ADROP4
    {HEXEN_SPR_WRBL, 22, 10, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_WRTHFX_ADEAD1
    {HEXEN_SPR_WRBL, 23, 7, NULL, HEXEN_S_WRTHFX_BDROP2, 0, 0},     // HEXEN_S_WRTHFX_BDROP1
    {HEXEN_SPR_WRBL, 24, 7, NULL, HEXEN_S_WRTHFX_BDROP3, 0, 0},     // HEXEN_S_WRTHFX_BDROP2
    {HEXEN_SPR_WRBL, 25, 7, NULL, HEXEN_S_WRTHFX_BDROP1, 0, 0},     // HEXEN_S_WRTHFX_BDROP3
    {HEXEN_SPR_WRBL, 25, 35, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_WRTHFX_BDEAD1
    {HEXEN_SPR_MNTR, 0, 15, NULL, HEXEN_S_MNTR_SPAWN2, 0, 0},       // HEXEN_S_MNTR_SPAWN1
    {HEXEN_SPR_MNTR, 0, 15, A_MinotaurFade1, HEXEN_S_MNTR_SPAWN3, 0, 0},    // HEXEN_S_MNTR_SPAWN2
    {HEXEN_SPR_MNTR, 0, 3, A_MinotaurFade2, HEXEN_S_MNTR_LOOK1, 0, 0},      // HEXEN_S_MNTR_SPAWN3
    {HEXEN_SPR_MNTR, 0, 10, A_MinotaurLook, HEXEN_S_MNTR_LOOK2, 0, 0},      // HEXEN_S_MNTR_LOOK1
    {HEXEN_SPR_MNTR, 1, 10, A_MinotaurLook, HEXEN_S_MNTR_LOOK1, 0, 0},      // HEXEN_S_MNTR_LOOK2
    {HEXEN_SPR_MNTR, 0, 5, A_MinotaurChase, HEXEN_S_MNTR_WALK2, 0, 0},      // HEXEN_S_MNTR_WALK1
    {HEXEN_SPR_MNTR, 1, 5, A_MinotaurChase, HEXEN_S_MNTR_WALK3, 0, 0},      // HEXEN_S_MNTR_WALK2
    {HEXEN_SPR_MNTR, 2, 5, A_MinotaurChase, HEXEN_S_MNTR_WALK4, 0, 0},      // HEXEN_S_MNTR_WALK3
    {HEXEN_SPR_MNTR, 3, 5, A_MinotaurChase, HEXEN_S_MNTR_WALK1, 0, 0},      // HEXEN_S_MNTR_WALK4
    {HEXEN_SPR_MNTR, 0, 5, A_MinotaurRoam, HEXEN_S_MNTR_ROAM2, 0, 0},       // HEXEN_S_MNTR_ROAM1
    {HEXEN_SPR_MNTR, 1, 5, A_MinotaurRoam, HEXEN_S_MNTR_ROAM3, 0, 0},       // HEXEN_S_MNTR_ROAM2
    {HEXEN_SPR_MNTR, 2, 5, A_MinotaurRoam, HEXEN_S_MNTR_ROAM4, 0, 0},       // HEXEN_S_MNTR_ROAM3
    {HEXEN_SPR_MNTR, 3, 5, A_MinotaurRoam, HEXEN_S_MNTR_ROAM1, 0, 0},       // HEXEN_S_MNTR_ROAM4
    {HEXEN_SPR_MNTR, 6, 10, A_FaceTarget, HEXEN_S_MNTR_ATK1_2, 0, 0},       // HEXEN_S_MNTR_ATK1_1
    {HEXEN_SPR_MNTR, 7, 7, A_FaceTarget, HEXEN_S_MNTR_ATK1_3, 0, 0},        // HEXEN_S_MNTR_ATK1_2
    {HEXEN_SPR_MNTR, 8, 12, A_MinotaurAtk1, HEXEN_S_MNTR_WALK1, 0, 0},      // HEXEN_S_MNTR_ATK1_3
    {HEXEN_SPR_MNTR, 6, 10, A_MinotaurDecide, HEXEN_S_MNTR_ATK2_2, 0, 0},   // HEXEN_S_MNTR_ATK2_1
    {HEXEN_SPR_MNTR, 9, 4, A_FaceTarget, HEXEN_S_MNTR_ATK2_3, 0, 0},        // HEXEN_S_MNTR_ATK2_2
    {HEXEN_SPR_MNTR, 10, 9, A_MinotaurAtk2, HEXEN_S_MNTR_WALK1, 0, 0},      // HEXEN_S_MNTR_ATK2_3
    {HEXEN_SPR_MNTR, 6, 10, A_FaceTarget, HEXEN_S_MNTR_ATK3_2, 0, 0},       // HEXEN_S_MNTR_ATK3_1
    {HEXEN_SPR_MNTR, 7, 7, A_FaceTarget, HEXEN_S_MNTR_ATK3_3, 0, 0},        // HEXEN_S_MNTR_ATK3_2
    {HEXEN_SPR_MNTR, 8, 12, A_MinotaurAtk3, HEXEN_S_MNTR_WALK1, 0, 0},      // HEXEN_S_MNTR_ATK3_3
    {HEXEN_SPR_MNTR, 8, 12, NULL, HEXEN_S_MNTR_ATK3_1, 0, 0},       // HEXEN_S_MNTR_ATK3_4
    {HEXEN_SPR_MNTR, 5, 2, A_MinotaurCharge, HEXEN_S_MNTR_ATK4_1, 0, 0},    // HEXEN_S_MNTR_ATK4_1
    {HEXEN_SPR_MNTR, 4, 3, NULL, HEXEN_S_MNTR_PAIN2, 0, 0}, // HEXEN_S_MNTR_PAIN1
    {HEXEN_SPR_MNTR, 4, 6, A_Pain, HEXEN_S_MNTR_WALK1, 0, 0},       // HEXEN_S_MNTR_PAIN2
    {HEXEN_SPR_MNTR, 4, 6, NULL, HEXEN_S_MNTR_DIE2, 0, 0},  // HEXEN_S_MNTR_DIE1
    {HEXEN_SPR_MNTR, 4, 2, A_Scream, HEXEN_S_MNTR_DIE3, 0, 0},      // HEXEN_S_MNTR_DIE2
    {HEXEN_SPR_MNTR, 4, 5, A_SmokePuffExit, HEXEN_S_MNTR_DIE4, 0, 0},       // HEXEN_S_MNTR_DIE3
    {HEXEN_SPR_MNTR, 4, 5, NULL, HEXEN_S_MNTR_DIE5, 0, 0},  // HEXEN_S_MNTR_DIE4
    {HEXEN_SPR_MNTR, 4, 5, A_NoBlocking, HEXEN_S_MNTR_DIE6, 0, 0},  // HEXEN_S_MNTR_DIE5
    {HEXEN_SPR_MNTR, 4, 5, NULL, HEXEN_S_MNTR_DIE7, 0, 0},  // HEXEN_S_MNTR_DIE6
    {HEXEN_SPR_MNTR, 4, 5, A_MinotaurFade1, HEXEN_S_MNTR_DIE8, 0, 0},       // HEXEN_S_MNTR_DIE7
    {HEXEN_SPR_MNTR, 4, 5, A_MinotaurFade0, HEXEN_S_MNTR_DIE9, 0, 0},       // HEXEN_S_MNTR_DIE8
    {HEXEN_SPR_MNTR, 4, 10, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_MNTR_DIE9
    {HEXEN_SPR_FX12, 32768, 6, NULL, HEXEN_S_MNTRFX1_2, 0, 0},      // HEXEN_S_MNTRFX1_1
    {HEXEN_SPR_FX12, 32769, 6, NULL, HEXEN_S_MNTRFX1_1, 0, 0},      // HEXEN_S_MNTRFX1_2
    {HEXEN_SPR_FX12, 32770, 5, NULL, HEXEN_S_MNTRFXI1_2, 0, 0},     // HEXEN_S_MNTRFXI1_1
    {HEXEN_SPR_FX12, 32771, 5, NULL, HEXEN_S_MNTRFXI1_3, 0, 0},     // HEXEN_S_MNTRFXI1_2
    {HEXEN_SPR_FX12, 32772, 5, NULL, HEXEN_S_MNTRFXI1_4, 0, 0},     // HEXEN_S_MNTRFXI1_3
    {HEXEN_SPR_FX12, 32773, 5, NULL, HEXEN_S_MNTRFXI1_5, 0, 0},     // HEXEN_S_MNTRFXI1_4
    {HEXEN_SPR_FX12, 32774, 5, NULL, HEXEN_S_MNTRFXI1_6, 0, 0},     // HEXEN_S_MNTRFXI1_5
    {HEXEN_SPR_FX12, 32775, 5, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_MNTRFXI1_6
    {HEXEN_SPR_FX13, 0, 2, A_MntrFloorFire, HEXEN_S_MNTRFX2_1, 0, 0},       // HEXEN_S_MNTRFX2_1
    {HEXEN_SPR_FX13, 32776, 4, A_Explode, HEXEN_S_MNTRFXI2_2, 0, 0},        // HEXEN_S_MNTRFXI2_1
    {HEXEN_SPR_FX13, 32777, 4, NULL, HEXEN_S_MNTRFXI2_3, 0, 0},     // HEXEN_S_MNTRFXI2_2
    {HEXEN_SPR_FX13, 32778, 4, NULL, HEXEN_S_MNTRFXI2_4, 0, 0},     // HEXEN_S_MNTRFXI2_3
    {HEXEN_SPR_FX13, 32779, 4, NULL, HEXEN_S_MNTRFXI2_5, 0, 0},     // HEXEN_S_MNTRFXI2_4
    {HEXEN_SPR_FX13, 32780, 4, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_MNTRFXI2_5
    {HEXEN_SPR_FX13, 32771, 4, NULL, HEXEN_S_MNTRFX3_2, 0, 0},      // HEXEN_S_MNTRFX3_1
    {HEXEN_SPR_FX13, 32770, 4, NULL, HEXEN_S_MNTRFX3_3, 0, 0},      // HEXEN_S_MNTRFX3_2
    {HEXEN_SPR_FX13, 32769, 5, NULL, HEXEN_S_MNTRFX3_4, 0, 0},      // HEXEN_S_MNTRFX3_3
    {HEXEN_SPR_FX13, 32770, 5, NULL, HEXEN_S_MNTRFX3_5, 0, 0},      // HEXEN_S_MNTRFX3_4
    {HEXEN_SPR_FX13, 32771, 5, NULL, HEXEN_S_MNTRFX3_6, 0, 0},      // HEXEN_S_MNTRFX3_5
    {HEXEN_SPR_FX13, 32772, 5, NULL, HEXEN_S_MNTRFX3_7, 0, 0},      // HEXEN_S_MNTRFX3_6
    {HEXEN_SPR_FX13, 32773, 4, NULL, HEXEN_S_MNTRFX3_8, 0, 0},      // HEXEN_S_MNTRFX3_7
    {HEXEN_SPR_FX13, 32774, 4, NULL, HEXEN_S_MNTRFX3_9, 0, 0},      // HEXEN_S_MNTRFX3_8
    {HEXEN_SPR_FX13, 32775, 4, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_MNTRFX3_9
    {HEXEN_SPR_MNSM, 0, 3, NULL, HEXEN_S_MINOSMOKE2, 0, 0}, // HEXEN_S_MINOSMOKE1
    {HEXEN_SPR_MNSM, 1, 3, NULL, HEXEN_S_MINOSMOKE3, 0, 0}, // HEXEN_S_MINOSMOKE2
    {HEXEN_SPR_MNSM, 2, 3, NULL, HEXEN_S_MINOSMOKE4, 0, 0}, // HEXEN_S_MINOSMOKE3
    {HEXEN_SPR_MNSM, 3, 3, NULL, HEXEN_S_MINOSMOKE5, 0, 0}, // HEXEN_S_MINOSMOKE4
    {HEXEN_SPR_MNSM, 4, 3, NULL, HEXEN_S_MINOSMOKE6, 0, 0}, // HEXEN_S_MINOSMOKE5
    {HEXEN_SPR_MNSM, 5, 3, NULL, HEXEN_S_MINOSMOKE7, 0, 0}, // HEXEN_S_MINOSMOKE6
    {HEXEN_SPR_MNSM, 6, 3, NULL, HEXEN_S_MINOSMOKE8, 0, 0}, // HEXEN_S_MINOSMOKE7
    {HEXEN_SPR_MNSM, 7, 3, NULL, HEXEN_S_MINOSMOKE9, 0, 0}, // HEXEN_S_MINOSMOKE8
    {HEXEN_SPR_MNSM, 8, 3, NULL, HEXEN_S_MINOSMOKE0, 0, 0}, // HEXEN_S_MINOSMOKE9
    {HEXEN_SPR_MNSM, 9, 3, NULL, HEXEN_S_MINOSMOKEA, 0, 0}, // HEXEN_S_MINOSMOKE0
    {HEXEN_SPR_MNSM, 10, 3, NULL, HEXEN_S_MINOSMOKEB, 0, 0},        // HEXEN_S_MINOSMOKEA
    {HEXEN_SPR_MNSM, 11, 3, NULL, HEXEN_S_MINOSMOKEC, 0, 0},        // HEXEN_S_MINOSMOKEB
    {HEXEN_SPR_MNSM, 12, 3, NULL, HEXEN_S_MINOSMOKED, 0, 0},        // HEXEN_S_MINOSMOKEC
    {HEXEN_SPR_MNSM, 13, 3, NULL, HEXEN_S_MINOSMOKEE, 0, 0},        // HEXEN_S_MINOSMOKED
    {HEXEN_SPR_MNSM, 14, 3, NULL, HEXEN_S_MINOSMOKEF, 0, 0},        // HEXEN_S_MINOSMOKEE
    {HEXEN_SPR_MNSM, 15, 3, NULL, HEXEN_S_MINOSMOKEG, 0, 0},        // HEXEN_S_MINOSMOKEF
    {HEXEN_SPR_MNSM, 16, 3, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_MINOSMOKEG
    {HEXEN_SPR_MNSM, 0, 3, NULL, HEXEN_S_MINOSMOKEX2, 0, 0},        // HEXEN_S_MINOSMOKEX1
    {HEXEN_SPR_MNSM, 1, 3, NULL, HEXEN_S_MINOSMOKEX3, 0, 0},        // HEXEN_S_MINOSMOKEX2
    {HEXEN_SPR_MNSM, 2, 3, NULL, HEXEN_S_MINOSMOKEX4, 0, 0},        // HEXEN_S_MINOSMOKEX3
    {HEXEN_SPR_MNSM, 3, 3, NULL, HEXEN_S_MINOSMOKEX5, 0, 0},        // HEXEN_S_MINOSMOKEX4
    {HEXEN_SPR_MNSM, 4, 3, NULL, HEXEN_S_MINOSMOKEX6, 0, 0},        // HEXEN_S_MINOSMOKEX5
    {HEXEN_SPR_MNSM, 5, 3, NULL, HEXEN_S_MINOSMOKEX7, 0, 0},        // HEXEN_S_MINOSMOKEX6
    {HEXEN_SPR_MNSM, 6, 3, NULL, HEXEN_S_MINOSMOKEX8, 0, 0},        // HEXEN_S_MINOSMOKEX7
    {HEXEN_SPR_MNSM, 7, 3, NULL, HEXEN_S_MINOSMOKEX9, 0, 0},        // HEXEN_S_MINOSMOKEX8
    {HEXEN_SPR_MNSM, 8, 3, NULL, HEXEN_S_MINOSMOKEX0, 0, 0},        // HEXEN_S_MINOSMOKEX9
    {HEXEN_SPR_MNSM, 9, 3, NULL, HEXEN_S_MINOSMOKEXA, 0, 0},        // HEXEN_S_MINOSMOKEX0
    {HEXEN_SPR_MNSM, 8, 3, NULL, HEXEN_S_MINOSMOKEXB, 0, 0},        // HEXEN_S_MINOSMOKEXA
    {HEXEN_SPR_MNSM, 7, 3, NULL, HEXEN_S_MINOSMOKEXC, 0, 0},        // HEXEN_S_MINOSMOKEXB
    {HEXEN_SPR_MNSM, 6, 3, NULL, HEXEN_S_MINOSMOKEXD, 0, 0},        // HEXEN_S_MINOSMOKEXC
    {HEXEN_SPR_MNSM, 5, 3, NULL, HEXEN_S_MINOSMOKEXE, 0, 0},        // HEXEN_S_MINOSMOKEXD
    {HEXEN_SPR_MNSM, 4, 3, NULL, HEXEN_S_MINOSMOKEXF, 0, 0},        // HEXEN_S_MINOSMOKEXE
    {HEXEN_SPR_MNSM, 3, 3, NULL, HEXEN_S_MINOSMOKEXG, 0, 0},        // HEXEN_S_MINOSMOKEXF
    {HEXEN_SPR_MNSM, 2, 3, NULL, HEXEN_S_MINOSMOKEXH, 0, 0},        // HEXEN_S_MINOSMOKEXG
    {HEXEN_SPR_MNSM, 1, 3, NULL, HEXEN_S_MINOSMOKEXI, 0, 0},        // HEXEN_S_MINOSMOKEXH
    {HEXEN_SPR_MNSM, 0, 3, NULL, HEXEN_S_NULL, 0, 0},       // HEXEN_S_MINOSMOKEXI
    {HEXEN_SPR_SSPT, 7, 10, A_Look, HEXEN_S_SERPENT_LOOK1, 0, 0},   // HEXEN_S_SERPENT_LOOK1
    {HEXEN_SPR_SSPT, 7, 1, A_SerpentChase, HEXEN_S_SERPENT_SWIM2, 0, 0},    // HEXEN_S_SERPENT_SWIM1
    {HEXEN_SPR_SSPT, 7, 1, A_SerpentChase, HEXEN_S_SERPENT_SWIM3, 0, 0},    // HEXEN_S_SERPENT_SWIM2
    {HEXEN_SPR_SSPT, 7, 2, A_SerpentHumpDecide, HEXEN_S_SERPENT_SWIM1, 0, 0},       // HEXEN_S_SERPENT_SWIM3
    {HEXEN_SPR_SSPT, 7, 3, A_SerpentUnHide, HEXEN_S_SERPENT_HUMP2, 0, 0},   // HEXEN_S_SERPENT_HUMP1
    {HEXEN_SPR_SSPT, 4, 3, A_SerpentRaiseHump, HEXEN_S_SERPENT_HUMP3, 0, 0},        // HEXEN_S_SERPENT_HUMP2
    {HEXEN_SPR_SSPT, 5, 3, A_SerpentRaiseHump, HEXEN_S_SERPENT_HUMP4, 0, 0},        // HEXEN_S_SERPENT_HUMP3
    {HEXEN_SPR_SSPT, 6, 3, A_SerpentRaiseHump, HEXEN_S_SERPENT_HUMP5, 0, 0},        // HEXEN_S_SERPENT_HUMP4
    {HEXEN_SPR_SSPT, 4, 3, A_SerpentRaiseHump, HEXEN_S_SERPENT_HUMP6, 0, 0},        // HEXEN_S_SERPENT_HUMP5
    {HEXEN_SPR_SSPT, 5, 3, A_SerpentRaiseHump, HEXEN_S_SERPENT_HUMP7, 0, 0},        // HEXEN_S_SERPENT_HUMP6
    {HEXEN_SPR_SSPT, 6, 3, NULL, HEXEN_S_SERPENT_HUMP8, 0, 0},      // HEXEN_S_SERPENT_HUMP7
    {HEXEN_SPR_SSPT, 4, 3, NULL, HEXEN_S_SERPENT_HUMP9, 0, 0},      // HEXEN_S_SERPENT_HUMP8
    {HEXEN_SPR_SSPT, 5, 3, NULL, HEXEN_S_SERPENT_HUMP10, 0, 0},     // HEXEN_S_SERPENT_HUMP9
    {HEXEN_SPR_SSPT, 6, 3, A_SerpentLowerHump, HEXEN_S_SERPENT_HUMP11, 0, 0},       // HEXEN_S_SERPENT_HUMP10
    {HEXEN_SPR_SSPT, 4, 3, A_SerpentLowerHump, HEXEN_S_SERPENT_HUMP12, 0, 0},       // HEXEN_S_SERPENT_HUMP11
    {HEXEN_SPR_SSPT, 5, 3, A_SerpentLowerHump, HEXEN_S_SERPENT_HUMP13, 0, 0},       // HEXEN_S_SERPENT_HUMP12
    {HEXEN_SPR_SSPT, 6, 3, A_SerpentLowerHump, HEXEN_S_SERPENT_HUMP14, 0, 0},       // HEXEN_S_SERPENT_HUMP13
    {HEXEN_SPR_SSPT, 4, 3, A_SerpentLowerHump, HEXEN_S_SERPENT_HUMP15, 0, 0},       // HEXEN_S_SERPENT_HUMP14
    {HEXEN_SPR_SSPT, 5, 3, A_SerpentHide, HEXEN_S_SERPENT_SWIM1, 0, 0},     // HEXEN_S_SERPENT_HUMP15
    {HEXEN_SPR_SSPT, 0, 1, A_UnHideThing, HEXEN_S_SERPENT_SURFACE2, 0, 0},  // HEXEN_S_SERPENT_SURFACE1
    {HEXEN_SPR_SSPT, 0, 1, A_SerpentBirthScream, HEXEN_S_SERPENT_SURFACE3, 0, 0},   // HEXEN_S_SERPENT_SURFACE2
    {HEXEN_SPR_SSPT, 1, 3, A_SetShootable, HEXEN_S_SERPENT_SURFACE4, 0, 0}, // HEXEN_S_SERPENT_SURFACE3
    {HEXEN_SPR_SSPT, 2, 3, NULL, HEXEN_S_SERPENT_SURFACE5, 0, 0},   // HEXEN_S_SERPENT_SURFACE4
    {HEXEN_SPR_SSPT, 3, 4, A_SerpentCheckForAttack, HEXEN_S_SERPENT_DIVE1, 0, 0},   // HEXEN_S_SERPENT_SURFACE5
    {HEXEN_SPR_SSDV, 0, 4, NULL, HEXEN_S_SERPENT_DIVE2, 0, 0},      // HEXEN_S_SERPENT_DIVE1
    {HEXEN_SPR_SSDV, 1, 4, NULL, HEXEN_S_SERPENT_DIVE3, 0, 0},      // HEXEN_S_SERPENT_DIVE2
    {HEXEN_SPR_SSDV, 2, 4, NULL, HEXEN_S_SERPENT_DIVE4, 0, 0},      // HEXEN_S_SERPENT_DIVE3
    {HEXEN_SPR_SSDV, 3, 4, A_UnSetShootable, HEXEN_S_SERPENT_DIVE5, 0, 0},  // HEXEN_S_SERPENT_DIVE4
    {HEXEN_SPR_SSDV, 4, 3, A_SerpentDiveSound, HEXEN_S_SERPENT_DIVE6, 0, 0},        // HEXEN_S_SERPENT_DIVE5
    {HEXEN_SPR_SSDV, 5, 3, NULL, HEXEN_S_SERPENT_DIVE7, 0, 0},      // HEXEN_S_SERPENT_DIVE6
    {HEXEN_SPR_SSDV, 6, 4, NULL, HEXEN_S_SERPENT_DIVE8, 0, 0},      // HEXEN_S_SERPENT_DIVE7
    {HEXEN_SPR_SSDV, 7, 4, NULL, HEXEN_S_SERPENT_DIVE9, 0, 0},      // HEXEN_S_SERPENT_DIVE8
    {HEXEN_SPR_SSDV, 8, 3, NULL, HEXEN_S_SERPENT_DIVE10, 0, 0},     // HEXEN_S_SERPENT_DIVE9
    {HEXEN_SPR_SSDV, 9, 3, A_SerpentHide, HEXEN_S_SERPENT_SWIM1, 0, 0},     // HEXEN_S_SERPENT_DIVE10
    {HEXEN_SPR_SSPT, 8, 5, A_SerpentWalk, HEXEN_S_SERPENT_WALK2, 0, 0},     // HEXEN_S_SERPENT_WALK1
    {HEXEN_SPR_SSPT, 9, 5, A_SerpentWalk, HEXEN_S_SERPENT_WALK3, 0, 0},     // HEXEN_S_SERPENT_WALK2
    {HEXEN_SPR_SSPT, 8, 5, A_SerpentWalk, HEXEN_S_SERPENT_WALK4, 0, 0},     // HEXEN_S_SERPENT_WALK3
    {HEXEN_SPR_SSPT, 9, 5, A_SerpentCheckForAttack, HEXEN_S_SERPENT_DIVE1, 0, 0},   // HEXEN_S_SERPENT_WALK4
    {HEXEN_SPR_SSPT, 11, 5, NULL, HEXEN_S_SERPENT_PAIN2, 0, 0},     // HEXEN_S_SERPENT_PAIN1
    {HEXEN_SPR_SSPT, 11, 5, A_Pain, HEXEN_S_SERPENT_DIVE1, 0, 0},   // HEXEN_S_SERPENT_PAIN2
    {HEXEN_SPR_SSPT, 10, 6, A_FaceTarget, HEXEN_S_SERPENT_ATK2, 0, 0},      // HEXEN_S_SERPENT_ATK1
    {HEXEN_SPR_SSPT, 11, 5, A_SerpentChooseAttack, HEXEN_S_SERPENT_MELEE1, 0, 0},   // HEXEN_S_SERPENT_ATK2
    {HEXEN_SPR_SSPT, 13, 5, A_SerpentMeleeAttack, HEXEN_S_SERPENT_DIVE1, 0, 0},     // HEXEN_S_SERPENT_MELEE1
    {HEXEN_SPR_SSPT, 13, 5, A_SerpentMissileAttack, HEXEN_S_SERPENT_DIVE1, 0, 0},   // HEXEN_S_SERPENT_MISSILE1
    {HEXEN_SPR_SSPT, 14, 4, NULL, HEXEN_S_SERPENT_DIE2, 0, 0},      // HEXEN_S_SERPENT_DIE1
    {HEXEN_SPR_SSPT, 15, 4, A_Scream, HEXEN_S_SERPENT_DIE3, 0, 0},  // HEXEN_S_SERPENT_DIE2
    {HEXEN_SPR_SSPT, 16, 4, A_NoBlocking, HEXEN_S_SERPENT_DIE4, 0, 0},      // HEXEN_S_SERPENT_DIE3
    {HEXEN_SPR_SSPT, 17, 4, NULL, HEXEN_S_SERPENT_DIE5, 0, 0},      // HEXEN_S_SERPENT_DIE4
    {HEXEN_SPR_SSPT, 18, 4, NULL, HEXEN_S_SERPENT_DIE6, 0, 0},      // HEXEN_S_SERPENT_DIE5
    {HEXEN_SPR_SSPT, 19, 4, NULL, HEXEN_S_SERPENT_DIE7, 0, 0},      // HEXEN_S_SERPENT_DIE6
    {HEXEN_SPR_SSPT, 20, 4, NULL, HEXEN_S_SERPENT_DIE8, 0, 0},      // HEXEN_S_SERPENT_DIE7
    {HEXEN_SPR_SSPT, 21, 4, NULL, HEXEN_S_SERPENT_DIE9, 0, 0},      // HEXEN_S_SERPENT_DIE8
    {HEXEN_SPR_SSPT, 22, 4, NULL, HEXEN_S_SERPENT_DIE10, 0, 0},     // HEXEN_S_SERPENT_DIE9
    {HEXEN_SPR_SSPT, 23, 4, NULL, HEXEN_S_SERPENT_DIE11, 0, 0},     // HEXEN_S_SERPENT_DIE10
    {HEXEN_SPR_SSPT, 24, 4, NULL, HEXEN_S_SERPENT_DIE12, 0, 0},     // HEXEN_S_SERPENT_DIE11
    {HEXEN_SPR_SSPT, 25, 4, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_SERPENT_DIE12
    {HEXEN_SPR_SSXD, 0, 4, NULL, HEXEN_S_SERPENT_XDIE2, 0, 0},      // HEXEN_S_SERPENT_XDIE1
    {HEXEN_SPR_SSXD, 1, 4, A_SerpentHeadPop, HEXEN_S_SERPENT_XDIE3, 0, 0},  // HEXEN_S_SERPENT_XDIE2
    {HEXEN_SPR_SSXD, 2, 4, A_NoBlocking, HEXEN_S_SERPENT_XDIE4, 0, 0},      // HEXEN_S_SERPENT_XDIE3
    {HEXEN_SPR_SSXD, 3, 4, NULL, HEXEN_S_SERPENT_XDIE5, 0, 0},      // HEXEN_S_SERPENT_XDIE4
    {HEXEN_SPR_SSXD, 4, 4, NULL, HEXEN_S_SERPENT_XDIE6, 0, 0},      // HEXEN_S_SERPENT_XDIE5
    {HEXEN_SPR_SSXD, 5, 3, NULL, HEXEN_S_SERPENT_XDIE7, 0, 0},      // HEXEN_S_SERPENT_XDIE6
    {HEXEN_SPR_SSXD, 6, 3, NULL, HEXEN_S_SERPENT_XDIE8, 0, 0},      // HEXEN_S_SERPENT_XDIE7
    {HEXEN_SPR_SSXD, 7, 3, A_SerpentSpawnGibs, HEXEN_S_NULL, 0, 0}, // HEXEN_S_SERPENT_XDIE8
    {HEXEN_SPR_SSPT, 26, 5, A_FreezeDeath, HEXEN_S_SERPENT_ICE2, 0, 0},     // HEXEN_S_SERPENT_ICE
    {HEXEN_SPR_SSPT, 26, 1, A_FreezeDeathChunks, HEXEN_S_SERPENT_ICE2, 0, 0},       // HEXEN_S_SERPENT_ICE2
    {HEXEN_SPR_SSFX, 32768, 3, A_ContMobjSound, HEXEN_S_SERPENT_FX2, 0, 0}, // HEXEN_S_SERPENT_FX1
    {HEXEN_SPR_SSFX, 32769, 3, NULL, HEXEN_S_SERPENT_FX3, 0, 0},    // HEXEN_S_SERPENT_FX2
    {HEXEN_SPR_SSFX, 32768, 3, NULL, HEXEN_S_SERPENT_FX4, 0, 0},    // HEXEN_S_SERPENT_FX3
    {HEXEN_SPR_SSFX, 32769, 3, NULL, HEXEN_S_SERPENT_FX1, 0, 0},    // HEXEN_S_SERPENT_FX4
    {HEXEN_SPR_SSFX, 32770, 4, NULL, HEXEN_S_SERPENT_FX_X2, 0, 0},  // HEXEN_S_SERPENT_FX_X1
    {HEXEN_SPR_SSFX, 32771, 4, NULL, HEXEN_S_SERPENT_FX_X3, 0, 0},  // HEXEN_S_SERPENT_FX_X2
    {HEXEN_SPR_SSFX, 32772, 4, NULL, HEXEN_S_SERPENT_FX_X4, 0, 0},  // HEXEN_S_SERPENT_FX_X3
    {HEXEN_SPR_SSFX, 32773, 4, NULL, HEXEN_S_SERPENT_FX_X5, 0, 0},  // HEXEN_S_SERPENT_FX_X4
    {HEXEN_SPR_SSFX, 32774, 4, NULL, HEXEN_S_SERPENT_FX_X6, 0, 0},  // HEXEN_S_SERPENT_FX_X5
    {HEXEN_SPR_SSFX, 32775, 4, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_SERPENT_FX_X6
    {HEXEN_SPR_SSXD, 8, 4, A_SerpentHeadCheck, HEXEN_S_SERPENT_HEAD2, 0, 0},        // HEXEN_S_SERPENT_HEAD1
    {HEXEN_SPR_SSXD, 9, 4, A_SerpentHeadCheck, HEXEN_S_SERPENT_HEAD3, 0, 0},        // HEXEN_S_SERPENT_HEAD2
    {HEXEN_SPR_SSXD, 10, 4, A_SerpentHeadCheck, HEXEN_S_SERPENT_HEAD4, 0, 0},       // HEXEN_S_SERPENT_HEAD3
    {HEXEN_SPR_SSXD, 11, 4, A_SerpentHeadCheck, HEXEN_S_SERPENT_HEAD5, 0, 0},       // HEXEN_S_SERPENT_HEAD4
    {HEXEN_SPR_SSXD, 12, 4, A_SerpentHeadCheck, HEXEN_S_SERPENT_HEAD6, 0, 0},       // HEXEN_S_SERPENT_HEAD5
    {HEXEN_SPR_SSXD, 13, 4, A_SerpentHeadCheck, HEXEN_S_SERPENT_HEAD7, 0, 0},       // HEXEN_S_SERPENT_HEAD6
    {HEXEN_SPR_SSXD, 14, 4, A_SerpentHeadCheck, HEXEN_S_SERPENT_HEAD8, 0, 0},       // HEXEN_S_SERPENT_HEAD7
    {HEXEN_SPR_SSXD, 15, 4, A_SerpentHeadCheck, HEXEN_S_SERPENT_HEAD1, 0, 0},       // HEXEN_S_SERPENT_HEAD8
    {HEXEN_SPR_SSXD, 18, -1, NULL, HEXEN_S_SERPENT_HEAD_X1, 0, 0},  // HEXEN_S_SERPENT_HEAD_X1
    {HEXEN_SPR_SSXD, 16, 6, NULL, HEXEN_S_SERPENT_GIB1_2, 0, 0},    // HEXEN_S_SERPENT_GIB1_1
    {HEXEN_SPR_SSXD, 16, 6, A_FloatGib, HEXEN_S_SERPENT_GIB1_3, 0, 0},      // HEXEN_S_SERPENT_GIB1_2
    {HEXEN_SPR_SSXD, 16, 8, A_FloatGib, HEXEN_S_SERPENT_GIB1_4, 0, 0},      // HEXEN_S_SERPENT_GIB1_3
    {HEXEN_SPR_SSXD, 16, 8, A_FloatGib, HEXEN_S_SERPENT_GIB1_5, 0, 0},      // HEXEN_S_SERPENT_GIB1_4
    {HEXEN_SPR_SSXD, 16, 12, A_FloatGib, HEXEN_S_SERPENT_GIB1_6, 0, 0},     // HEXEN_S_SERPENT_GIB1_5
    {HEXEN_SPR_SSXD, 16, 12, A_FloatGib, HEXEN_S_SERPENT_GIB1_7, 0, 0},     // HEXEN_S_SERPENT_GIB1_6
    {HEXEN_SPR_SSXD, 16, 232, A_DelayGib, HEXEN_S_SERPENT_GIB1_8, 0, 0},    // HEXEN_S_SERPENT_GIB1_7
    {HEXEN_SPR_SSXD, 16, 12, A_SinkGib, HEXEN_S_SERPENT_GIB1_9, 0, 0},      // HEXEN_S_SERPENT_GIB1_8
    {HEXEN_SPR_SSXD, 16, 12, A_SinkGib, HEXEN_S_SERPENT_GIB1_10, 0, 0},     // HEXEN_S_SERPENT_GIB1_9
    {HEXEN_SPR_SSXD, 16, 8, A_SinkGib, HEXEN_S_SERPENT_GIB1_11, 0, 0},      // HEXEN_S_SERPENT_GIB1_10
    {HEXEN_SPR_SSXD, 16, 8, A_SinkGib, HEXEN_S_SERPENT_GIB1_12, 0, 0},      // HEXEN_S_SERPENT_GIB1_11
    {HEXEN_SPR_SSXD, 16, 8, A_SinkGib, HEXEN_S_NULL, 0, 0}, // HEXEN_S_SERPENT_GIB1_12
    {HEXEN_SPR_SSXD, 17, 6, NULL, HEXEN_S_SERPENT_GIB2_2, 0, 0},    // HEXEN_S_SERPENT_GIB2_1
    {HEXEN_SPR_SSXD, 17, 6, A_FloatGib, HEXEN_S_SERPENT_GIB2_3, 0, 0},      // HEXEN_S_SERPENT_GIB2_2
    {HEXEN_SPR_SSXD, 17, 8, A_FloatGib, HEXEN_S_SERPENT_GIB2_4, 0, 0},      // HEXEN_S_SERPENT_GIB2_3
    {HEXEN_SPR_SSXD, 17, 8, A_FloatGib, HEXEN_S_SERPENT_GIB2_5, 0, 0},      // HEXEN_S_SERPENT_GIB2_4
    {HEXEN_SPR_SSXD, 17, 12, A_FloatGib, HEXEN_S_SERPENT_GIB2_6, 0, 0},     // HEXEN_S_SERPENT_GIB2_5
    {HEXEN_SPR_SSXD, 17, 12, A_FloatGib, HEXEN_S_SERPENT_GIB2_7, 0, 0},     // HEXEN_S_SERPENT_GIB2_6
    {HEXEN_SPR_SSXD, 17, 232, A_DelayGib, HEXEN_S_SERPENT_GIB2_8, 0, 0},    // HEXEN_S_SERPENT_GIB2_7
    {HEXEN_SPR_SSXD, 17, 12, A_SinkGib, HEXEN_S_SERPENT_GIB2_9, 0, 0},      // HEXEN_S_SERPENT_GIB2_8
    {HEXEN_SPR_SSXD, 17, 12, A_SinkGib, HEXEN_S_SERPENT_GIB2_10, 0, 0},     // HEXEN_S_SERPENT_GIB2_9
    {HEXEN_SPR_SSXD, 17, 8, A_SinkGib, HEXEN_S_SERPENT_GIB2_11, 0, 0},      // HEXEN_S_SERPENT_GIB2_10
    {HEXEN_SPR_SSXD, 17, 8, A_SinkGib, HEXEN_S_SERPENT_GIB2_12, 0, 0},      // HEXEN_S_SERPENT_GIB2_11
    {HEXEN_SPR_SSXD, 17, 8, A_SinkGib, HEXEN_S_NULL, 0, 0}, // HEXEN_S_SERPENT_GIB2_12
    {HEXEN_SPR_SSXD, 19, 6, NULL, HEXEN_S_SERPENT_GIB3_2, 0, 0},    // HEXEN_S_SERPENT_GIB3_1
    {HEXEN_SPR_SSXD, 19, 6, A_FloatGib, HEXEN_S_SERPENT_GIB3_3, 0, 0},      // HEXEN_S_SERPENT_GIB3_2
    {HEXEN_SPR_SSXD, 19, 8, A_FloatGib, HEXEN_S_SERPENT_GIB3_4, 0, 0},      // HEXEN_S_SERPENT_GIB3_3
    {HEXEN_SPR_SSXD, 19, 8, A_FloatGib, HEXEN_S_SERPENT_GIB3_5, 0, 0},      // HEXEN_S_SERPENT_GIB3_4
    {HEXEN_SPR_SSXD, 19, 12, A_FloatGib, HEXEN_S_SERPENT_GIB3_6, 0, 0},     // HEXEN_S_SERPENT_GIB3_5
    {HEXEN_SPR_SSXD, 19, 12, A_FloatGib, HEXEN_S_SERPENT_GIB3_7, 0, 0},     // HEXEN_S_SERPENT_GIB3_6
    {HEXEN_SPR_SSXD, 19, 232, A_DelayGib, HEXEN_S_SERPENT_GIB3_8, 0, 0},    // HEXEN_S_SERPENT_GIB3_7
    {HEXEN_SPR_SSXD, 19, 12, A_SinkGib, HEXEN_S_SERPENT_GIB3_9, 0, 0},      // HEXEN_S_SERPENT_GIB3_8
    {HEXEN_SPR_SSXD, 19, 12, A_SinkGib, HEXEN_S_SERPENT_GIB3_10, 0, 0},     // HEXEN_S_SERPENT_GIB3_9
    {HEXEN_SPR_SSXD, 19, 8, A_SinkGib, HEXEN_S_SERPENT_GIB3_11, 0, 0},      // HEXEN_S_SERPENT_GIB3_10
    {HEXEN_SPR_SSXD, 19, 8, A_SinkGib, HEXEN_S_SERPENT_GIB3_12, 0, 0},      // HEXEN_S_SERPENT_GIB3_11
    {HEXEN_SPR_SSXD, 19, 8, A_SinkGib, HEXEN_S_NULL, 0, 0}, // HEXEN_S_SERPENT_GIB3_12
    {HEXEN_SPR_BISH, 0, 10, A_Look, HEXEN_S_BISHOP_LOOK1, 0, 0},    // HEXEN_S_BISHOP_LOOK1
    {HEXEN_SPR_BISH, 0, 1, A_BishopDecide, HEXEN_S_BISHOP_WALK1, 0, 0},     // HEXEN_S_BISHOP_DECIDE
    {HEXEN_SPR_BISH, 0, 2, A_BishopDoBlur, HEXEN_S_BISHOP_BLUR2, 0, 0},     // HEXEN_S_BISHOP_BLUR1
    {HEXEN_SPR_BISH, 0, 4, A_BishopSpawnBlur, HEXEN_S_BISHOP_BLUR2, 0, 0},  // HEXEN_S_BISHOP_BLUR2
    {HEXEN_SPR_BISH, 0, 2, A_Chase, HEXEN_S_BISHOP_WALK2, 0, 0},    // HEXEN_S_BISHOP_WALK1
    {HEXEN_SPR_BISH, 0, 2, A_BishopChase, HEXEN_S_BISHOP_WALK3, 0, 0},      // HEXEN_S_BISHOP_WALK2
    {HEXEN_SPR_BISH, 0, 2, NULL, HEXEN_S_BISHOP_WALK4, 0, 0},       // HEXEN_S_BISHOP_WALK3
    {HEXEN_SPR_BISH, 1, 2, A_BishopChase, HEXEN_S_BISHOP_WALK5, 0, 0},      // HEXEN_S_BISHOP_WALK4
    {HEXEN_SPR_BISH, 1, 2, A_Chase, HEXEN_S_BISHOP_WALK6, 0, 0},    // HEXEN_S_BISHOP_WALK5
    {HEXEN_SPR_BISH, 1, 2, A_BishopChase, HEXEN_S_BISHOP_DECIDE, 0, 0},     // HEXEN_S_BISHOP_WALK6
    {HEXEN_SPR_BISH, 0, 3, A_FaceTarget, HEXEN_S_BISHOP_ATK2, 0, 0},        // HEXEN_S_BISHOP_ATK1
    {HEXEN_SPR_BISH, 32771, 3, A_FaceTarget, HEXEN_S_BISHOP_ATK3, 0, 0},    // HEXEN_S_BISHOP_ATK2
    {HEXEN_SPR_BISH, 32772, 3, A_FaceTarget, HEXEN_S_BISHOP_ATK4, 0, 0},    // HEXEN_S_BISHOP_ATK3
    {HEXEN_SPR_BISH, 32773, 3, A_BishopAttack, HEXEN_S_BISHOP_ATK5, 0, 0},  // HEXEN_S_BISHOP_ATK4
    {HEXEN_SPR_BISH, 32773, 5, A_BishopAttack2, HEXEN_S_BISHOP_ATK5, 0, 0}, // HEXEN_S_BISHOP_ATK5
    {HEXEN_SPR_BISH, 2, 6, A_Pain, HEXEN_S_BISHOP_PAIN2, 0, 0},     // HEXEN_S_BISHOP_PAIN1
    {HEXEN_SPR_BISH, 2, 6, A_BishopPainBlur, HEXEN_S_BISHOP_PAIN3, 0, 0},   // HEXEN_S_BISHOP_PAIN2
    {HEXEN_SPR_BISH, 2, 6, A_BishopPainBlur, HEXEN_S_BISHOP_PAIN4, 0, 0},   // HEXEN_S_BISHOP_PAIN3
    {HEXEN_SPR_BISH, 2, 6, A_BishopPainBlur, HEXEN_S_BISHOP_PAIN5, 0, 0},   // HEXEN_S_BISHOP_PAIN4
    {HEXEN_SPR_BISH, 2, 0, NULL, HEXEN_S_BISHOP_WALK1, 0, 0},       // HEXEN_S_BISHOP_PAIN5
    {HEXEN_SPR_BISH, 6, 6, NULL, HEXEN_S_BISHOP_DEATH2, 0, 0},      // HEXEN_S_BISHOP_DEATH1
    {HEXEN_SPR_BISH, 32775, 6, A_Scream, HEXEN_S_BISHOP_DEATH3, 0, 0},      // HEXEN_S_BISHOP_DEATH2
    {HEXEN_SPR_BISH, 32776, 5, A_NoBlocking, HEXEN_S_BISHOP_DEATH4, 0, 0},  // HEXEN_S_BISHOP_DEATH3
    {HEXEN_SPR_BISH, 32777, 5, A_Explode, HEXEN_S_BISHOP_DEATH5, 0, 0},     // HEXEN_S_BISHOP_DEATH4
    {HEXEN_SPR_BISH, 32778, 5, NULL, HEXEN_S_BISHOP_DEATH6, 0, 0},  // HEXEN_S_BISHOP_DEATH5
    {HEXEN_SPR_BISH, 32779, 4, NULL, HEXEN_S_BISHOP_DEATH7, 0, 0},  // HEXEN_S_BISHOP_DEATH6
    {HEXEN_SPR_BISH, 32780, 4, NULL, HEXEN_S_BISHOP_DEATH8, 0, 0},  // HEXEN_S_BISHOP_DEATH7
    {HEXEN_SPR_BISH, 13, 4, A_BishopPuff, HEXEN_S_BISHOP_DEATH9, 0, 0},     // HEXEN_S_BISHOP_DEATH8
    {HEXEN_SPR_BISH, 14, 4, A_QueueCorpse, HEXEN_S_BISHOP_DEATH10, 0, 0},   // HEXEN_S_BISHOP_DEATH9
    {HEXEN_SPR_BISH, 15, -1, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_BISHOP_DEATH10
    {HEXEN_SPR_BISH, 23, 5, A_FreezeDeath, HEXEN_S_BISHOP_ICE2, 0, 0},      // HEXEN_S_BISHOP_ICE
    {HEXEN_SPR_BISH, 23, 1, A_FreezeDeathChunks, HEXEN_S_BISHOP_ICE2, 0, 0},        // HEXEN_S_BISHOP_ICE2
    {HEXEN_SPR_BISH, 16, 5, NULL, HEXEN_S_BISHOP_PUFF2, 0, 0},      // HEXEN_S_BISHOP_PUFF1
    {HEXEN_SPR_BISH, 17, 5, NULL, HEXEN_S_BISHOP_PUFF3, 0, 0},      // HEXEN_S_BISHOP_PUFF2
    {HEXEN_SPR_BISH, 18, 5, NULL, HEXEN_S_BISHOP_PUFF4, 0, 0},      // HEXEN_S_BISHOP_PUFF3
    {HEXEN_SPR_BISH, 19, 5, NULL, HEXEN_S_BISHOP_PUFF5, 0, 0},      // HEXEN_S_BISHOP_PUFF4
    {HEXEN_SPR_BISH, 20, 6, NULL, HEXEN_S_BISHOP_PUFF6, 0, 0},      // HEXEN_S_BISHOP_PUFF5
    {HEXEN_SPR_BISH, 21, 6, NULL, HEXEN_S_BISHOP_PUFF7, 0, 0},      // HEXEN_S_BISHOP_PUFF6
    {HEXEN_SPR_BISH, 22, 5, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_BISHOP_PUFF7
    {HEXEN_SPR_BISH, 0, 16, NULL, HEXEN_S_BISHOPBLUR2, 0, 0},       // HEXEN_S_BISHOPBLUR1
    {HEXEN_SPR_BISH, 0, 8, A_SetAltShadow, HEXEN_S_NULL, 0, 0},     // HEXEN_S_BISHOPBLUR2
    {HEXEN_SPR_BISH, 2, 8, NULL, HEXEN_S_NULL, 0, 0},       // HEXEN_S_BISHOPPAINBLUR1
    {HEXEN_SPR_BPFX, 32768, 1, A_BishopMissileWeave, HEXEN_S_BISHFX1_2, 0, 0},      // HEXEN_S_BISHFX1_1
    {HEXEN_SPR_BPFX, 32769, 1, A_BishopMissileWeave, HEXEN_S_BISHFX1_3, 0, 0},      // HEXEN_S_BISHFX1_2
    {HEXEN_SPR_BPFX, 32768, 1, A_BishopMissileWeave, HEXEN_S_BISHFX1_4, 0, 0},      // HEXEN_S_BISHFX1_3
    {HEXEN_SPR_BPFX, 32769, 1, A_BishopMissileWeave, HEXEN_S_BISHFX1_5, 0, 0},      // HEXEN_S_BISHFX1_4
    {HEXEN_SPR_BPFX, 32769, 0, A_BishopMissileSeek, HEXEN_S_BISHFX1_1, 0, 0},       // HEXEN_S_BISHFX1_5
    {HEXEN_SPR_BPFX, 32770, 4, NULL, HEXEN_S_BISHFXI1_2, 0, 0},     // HEXEN_S_BISHFXI1_1
    {HEXEN_SPR_BPFX, 32771, 4, NULL, HEXEN_S_BISHFXI1_3, 0, 0},     // HEXEN_S_BISHFXI1_2
    {HEXEN_SPR_BPFX, 32772, 4, NULL, HEXEN_S_BISHFXI1_4, 0, 0},     // HEXEN_S_BISHFXI1_3
    {HEXEN_SPR_BPFX, 32773, 4, NULL, HEXEN_S_BISHFXI1_5, 0, 0},     // HEXEN_S_BISHFXI1_4
    {HEXEN_SPR_BPFX, 32774, 3, NULL, HEXEN_S_BISHFXI1_6, 0, 0},     // HEXEN_S_BISHFXI1_5
    {HEXEN_SPR_BPFX, 32775, 3, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_BISHFXI1_6
    {HEXEN_SPR_DRAG, 3, 10, A_Look, HEXEN_S_DRAGON_LOOK1, 0, 0},    // HEXEN_S_DRAGON_LOOK1
    {HEXEN_SPR_DRAG, 2, 5, NULL, HEXEN_S_DRAGON_INIT2, 0, 0},       // HEXEN_S_DRAGON_INIT
    {HEXEN_SPR_DRAG, 1, 5, NULL, HEXEN_S_DRAGON_INIT3, 0, 0},       // HEXEN_S_DRAGON_INIT2
    {HEXEN_SPR_DRAG, 0, 5, A_DragonInitFlight, HEXEN_S_DRAGON_WALK1, 0, 0}, // HEXEN_S_DRAGON_INIT3
    {HEXEN_SPR_DRAG, 1, 3, A_DragonFlap, HEXEN_S_DRAGON_WALK2, 0, 0},       // HEXEN_S_DRAGON_WALK1
    {HEXEN_SPR_DRAG, 1, 3, A_DragonFlight, HEXEN_S_DRAGON_WALK3, 0, 0},     // HEXEN_S_DRAGON_WALK2
    {HEXEN_SPR_DRAG, 2, 3, A_DragonFlight, HEXEN_S_DRAGON_WALK4, 0, 0},     // HEXEN_S_DRAGON_WALK3
    {HEXEN_SPR_DRAG, 2, 3, A_DragonFlight, HEXEN_S_DRAGON_WALK5, 0, 0},     // HEXEN_S_DRAGON_WALK4
    {HEXEN_SPR_DRAG, 3, 3, A_DragonFlight, HEXEN_S_DRAGON_WALK6, 0, 0},     // HEXEN_S_DRAGON_WALK5
    {HEXEN_SPR_DRAG, 3, 3, A_DragonFlight, HEXEN_S_DRAGON_WALK7, 0, 0},     // HEXEN_S_DRAGON_WALK6
    {HEXEN_SPR_DRAG, 2, 3, A_DragonFlight, HEXEN_S_DRAGON_WALK8, 0, 0},     // HEXEN_S_DRAGON_WALK7
    {HEXEN_SPR_DRAG, 2, 3, A_DragonFlight, HEXEN_S_DRAGON_WALK9, 0, 0},     // HEXEN_S_DRAGON_WALK8
    {HEXEN_SPR_DRAG, 1, 3, A_DragonFlight, HEXEN_S_DRAGON_WALK10, 0, 0},    // HEXEN_S_DRAGON_WALK9
    {HEXEN_SPR_DRAG, 1, 3, A_DragonFlight, HEXEN_S_DRAGON_WALK11, 0, 0},    // HEXEN_S_DRAGON_WALK10
    {HEXEN_SPR_DRAG, 0, 3, A_DragonFlight, HEXEN_S_DRAGON_WALK12, 0, 0},    // HEXEN_S_DRAGON_WALK11
    {HEXEN_SPR_DRAG, 0, 3, A_DragonFlight, HEXEN_S_DRAGON_WALK1, 0, 0},     // HEXEN_S_DRAGON_WALK12
    {HEXEN_SPR_DRAG, 4, 8, A_DragonAttack, HEXEN_S_DRAGON_WALK1, 0, 0},     // HEXEN_S_DRAGON_ATK1
    {HEXEN_SPR_DRAG, 5, 10, A_DragonPain, HEXEN_S_DRAGON_WALK1, 0, 0},      // HEXEN_S_DRAGON_PAIN1
    {HEXEN_SPR_DRAG, 6, 5, A_Scream, HEXEN_S_DRAGON_DEATH2, 0, 0},  // HEXEN_S_DRAGON_DEATH1
    {HEXEN_SPR_DRAG, 7, 4, A_NoBlocking, HEXEN_S_DRAGON_DEATH3, 0, 0},      // HEXEN_S_DRAGON_DEATH2
    {HEXEN_SPR_DRAG, 8, 4, NULL, HEXEN_S_DRAGON_DEATH4, 0, 0},      // HEXEN_S_DRAGON_DEATH3
    {HEXEN_SPR_DRAG, 9, 4, A_DragonCheckCrash, HEXEN_S_DRAGON_DEATH4, 0, 0},        // HEXEN_S_DRAGON_DEATH4
    {HEXEN_SPR_DRAG, 10, 5, NULL, HEXEN_S_DRAGON_CRASH2, 0, 0},     // HEXEN_S_DRAGON_CRASH1
    {HEXEN_SPR_DRAG, 11, 5, NULL, HEXEN_S_DRAGON_CRASH3, 0, 0},     // HEXEN_S_DRAGON_CRASH2
    {HEXEN_SPR_DRAG, 12, -1, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_DRAGON_CRASH3
    {HEXEN_SPR_DRFX, 32768, 4, NULL, HEXEN_S_DRAGON_FX1_2, 0, 0},   // HEXEN_S_DRAGON_FX1_1
    {HEXEN_SPR_DRFX, 32769, 4, NULL, HEXEN_S_DRAGON_FX1_3, 0, 0},   // HEXEN_S_DRAGON_FX1_2
    {HEXEN_SPR_DRFX, 32770, 4, NULL, HEXEN_S_DRAGON_FX1_4, 0, 0},   // HEXEN_S_DRAGON_FX1_3
    {HEXEN_SPR_DRFX, 32771, 4, NULL, HEXEN_S_DRAGON_FX1_5, 0, 0},   // HEXEN_S_DRAGON_FX1_4
    {HEXEN_SPR_DRFX, 32772, 4, NULL, HEXEN_S_DRAGON_FX1_6, 0, 0},   // HEXEN_S_DRAGON_FX1_5
    {HEXEN_SPR_DRFX, 32773, 4, NULL, HEXEN_S_DRAGON_FX1_1, 0, 0},   // HEXEN_S_DRAGON_FX1_6
    {HEXEN_SPR_DRFX, 32774, 4, NULL, HEXEN_S_DRAGON_FX1_X2, 0, 0},  // HEXEN_S_DRAGON_FX1_X1
    {HEXEN_SPR_DRFX, 32775, 4, NULL, HEXEN_S_DRAGON_FX1_X3, 0, 0},  // HEXEN_S_DRAGON_FX1_X2
    {HEXEN_SPR_DRFX, 32776, 4, NULL, HEXEN_S_DRAGON_FX1_X4, 0, 0},  // HEXEN_S_DRAGON_FX1_X3
    {HEXEN_SPR_DRFX, 32777, 4, A_DragonFX2, HEXEN_S_DRAGON_FX1_X5, 0, 0},   // HEXEN_S_DRAGON_FX1_X4
    {HEXEN_SPR_DRFX, 32778, 3, NULL, HEXEN_S_DRAGON_FX1_X6, 0, 0},  // HEXEN_S_DRAGON_FX1_X5
    {HEXEN_SPR_DRFX, 32779, 3, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_DRAGON_FX1_X6
    {HEXEN_SPR_CFCF, 32784, 1, NULL, HEXEN_S_DRAGON_FX2_2, 0, 0},   // HEXEN_S_DRAGON_FX2_1
    {HEXEN_SPR_CFCF, 32784, 4, A_UnHideThing, HEXEN_S_DRAGON_FX2_3, 0, 0},  // HEXEN_S_DRAGON_FX2_2
    {HEXEN_SPR_CFCF, 32785, 3, A_Scream, HEXEN_S_DRAGON_FX2_4, 0, 0},       // HEXEN_S_DRAGON_FX2_3
    {HEXEN_SPR_CFCF, 32786, 4, NULL, HEXEN_S_DRAGON_FX2_5, 0, 0},   // HEXEN_S_DRAGON_FX2_4
    {HEXEN_SPR_CFCF, 32787, 3, A_Explode, HEXEN_S_DRAGON_FX2_6, 0, 0},      // HEXEN_S_DRAGON_FX2_5
    {HEXEN_SPR_CFCF, 32788, 4, NULL, HEXEN_S_DRAGON_FX2_7, 0, 0},   // HEXEN_S_DRAGON_FX2_6
    {HEXEN_SPR_CFCF, 32789, 3, NULL, HEXEN_S_DRAGON_FX2_8, 0, 0},   // HEXEN_S_DRAGON_FX2_7
    {HEXEN_SPR_CFCF, 32790, 4, NULL, HEXEN_S_DRAGON_FX2_9, 0, 0},   // HEXEN_S_DRAGON_FX2_8
    {HEXEN_SPR_CFCF, 32791, 3, NULL, HEXEN_S_DRAGON_FX2_10, 0, 0},  // HEXEN_S_DRAGON_FX2_9
    {HEXEN_SPR_CFCF, 32792, 4, NULL, HEXEN_S_DRAGON_FX2_11, 0, 0},  // HEXEN_S_DRAGON_FX2_10
    {HEXEN_SPR_CFCF, 32793, 3, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_DRAGON_FX2_11
    {HEXEN_SPR_ARM1, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ARMOR_1
    {HEXEN_SPR_ARM2, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ARMOR_2
    {HEXEN_SPR_ARM3, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ARMOR_3
    {HEXEN_SPR_ARM4, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ARMOR_4
    {HEXEN_SPR_MAN1, 32768, 4, NULL, HEXEN_S_MANA1_2, 0, 0},        // HEXEN_S_MANA1_1
    {HEXEN_SPR_MAN1, 32769, 4, NULL, HEXEN_S_MANA1_3, 0, 0},        // HEXEN_S_MANA1_2
    {HEXEN_SPR_MAN1, 32770, 4, NULL, HEXEN_S_MANA1_4, 0, 0},        // HEXEN_S_MANA1_3
    {HEXEN_SPR_MAN1, 32771, 4, NULL, HEXEN_S_MANA1_5, 0, 0},        // HEXEN_S_MANA1_4
    {HEXEN_SPR_MAN1, 32772, 4, NULL, HEXEN_S_MANA1_6, 0, 0},        // HEXEN_S_MANA1_5
    {HEXEN_SPR_MAN1, 32773, 4, NULL, HEXEN_S_MANA1_7, 0, 0},        // HEXEN_S_MANA1_6
    {HEXEN_SPR_MAN1, 32774, 4, NULL, HEXEN_S_MANA1_8, 0, 0},        // HEXEN_S_MANA1_7
    {HEXEN_SPR_MAN1, 32775, 4, NULL, HEXEN_S_MANA1_9, 0, 0},        // HEXEN_S_MANA1_8
    {HEXEN_SPR_MAN1, 32776, 4, NULL, HEXEN_S_MANA1_1, 0, 0},        // HEXEN_S_MANA1_9
    {HEXEN_SPR_MAN2, 32768, 4, NULL, HEXEN_S_MANA2_2, 0, 0},        // HEXEN_S_MANA2_1
    {HEXEN_SPR_MAN2, 32769, 4, NULL, HEXEN_S_MANA2_3, 0, 0},        // HEXEN_S_MANA2_2
    {HEXEN_SPR_MAN2, 32770, 4, NULL, HEXEN_S_MANA2_4, 0, 0},        // HEXEN_S_MANA2_3
    {HEXEN_SPR_MAN2, 32771, 4, NULL, HEXEN_S_MANA2_5, 0, 0},        // HEXEN_S_MANA2_4
    {HEXEN_SPR_MAN2, 32772, 4, NULL, HEXEN_S_MANA2_6, 0, 0},        // HEXEN_S_MANA2_5
    {HEXEN_SPR_MAN2, 32773, 4, NULL, HEXEN_S_MANA2_7, 0, 0},        // HEXEN_S_MANA2_6
    {HEXEN_SPR_MAN2, 32774, 4, NULL, HEXEN_S_MANA2_8, 0, 0},        // HEXEN_S_MANA2_7
    {HEXEN_SPR_MAN2, 32775, 4, NULL, HEXEN_S_MANA2_9, 0, 0},        // HEXEN_S_MANA2_8
    {HEXEN_SPR_MAN2, 32776, 4, NULL, HEXEN_S_MANA2_10, 0, 0},       // HEXEN_S_MANA2_9
    {HEXEN_SPR_MAN2, 32777, 4, NULL, HEXEN_S_MANA2_11, 0, 0},       // HEXEN_S_MANA2_10
    {HEXEN_SPR_MAN2, 32778, 4, NULL, HEXEN_S_MANA2_12, 0, 0},       // HEXEN_S_MANA2_11
    {HEXEN_SPR_MAN2, 32779, 4, NULL, HEXEN_S_MANA2_13, 0, 0},       // HEXEN_S_MANA2_12
    {HEXEN_SPR_MAN2, 32780, 4, NULL, HEXEN_S_MANA2_14, 0, 0},       // HEXEN_S_MANA2_13
    {HEXEN_SPR_MAN2, 32781, 4, NULL, HEXEN_S_MANA2_15, 0, 0},       // HEXEN_S_MANA2_14
    {HEXEN_SPR_MAN2, 32782, 4, NULL, HEXEN_S_MANA2_16, 0, 0},       // HEXEN_S_MANA2_15
    {HEXEN_SPR_MAN2, 32783, 4, NULL, HEXEN_S_MANA2_1, 0, 0},        // HEXEN_S_MANA2_16
    {HEXEN_SPR_MAN3, 32768, 4, NULL, HEXEN_S_MANA3_2, 0, 0},        // HEXEN_S_MANA3_1
    {HEXEN_SPR_MAN3, 32769, 4, NULL, HEXEN_S_MANA3_3, 0, 0},        // HEXEN_S_MANA3_2
    {HEXEN_SPR_MAN3, 32770, 4, NULL, HEXEN_S_MANA3_4, 0, 0},        // HEXEN_S_MANA3_3
    {HEXEN_SPR_MAN3, 32771, 4, NULL, HEXEN_S_MANA3_5, 0, 0},        // HEXEN_S_MANA3_4
    {HEXEN_SPR_MAN3, 32772, 4, NULL, HEXEN_S_MANA3_6, 0, 0},        // HEXEN_S_MANA3_5
    {HEXEN_SPR_MAN3, 32773, 4, NULL, HEXEN_S_MANA3_7, 0, 0},        // HEXEN_S_MANA3_6
    {HEXEN_SPR_MAN3, 32774, 4, NULL, HEXEN_S_MANA3_8, 0, 0},        // HEXEN_S_MANA3_7
    {HEXEN_SPR_MAN3, 32775, 4, NULL, HEXEN_S_MANA3_9, 0, 0},        // HEXEN_S_MANA3_8
    {HEXEN_SPR_MAN3, 32776, 4, NULL, HEXEN_S_MANA3_10, 0, 0},       // HEXEN_S_MANA3_9
    {HEXEN_SPR_MAN3, 32777, 4, NULL, HEXEN_S_MANA3_11, 0, 0},       // HEXEN_S_MANA3_10
    {HEXEN_SPR_MAN3, 32778, 4, NULL, HEXEN_S_MANA3_12, 0, 0},       // HEXEN_S_MANA3_11
    {HEXEN_SPR_MAN3, 32779, 4, NULL, HEXEN_S_MANA3_13, 0, 0},       // HEXEN_S_MANA3_12
    {HEXEN_SPR_MAN3, 32780, 4, NULL, HEXEN_S_MANA3_14, 0, 0},       // HEXEN_S_MANA3_13
    {HEXEN_SPR_MAN3, 32781, 4, NULL, HEXEN_S_MANA3_15, 0, 0},       // HEXEN_S_MANA3_14
    {HEXEN_SPR_MAN3, 32782, 4, NULL, HEXEN_S_MANA3_16, 0, 0},       // HEXEN_S_MANA3_15
    {HEXEN_SPR_MAN3, 32783, 4, NULL, HEXEN_S_MANA3_1, 0, 0},        // HEXEN_S_MANA3_16
    {HEXEN_SPR_KEY1, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_KEY1
    {HEXEN_SPR_KEY2, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_KEY2
    {HEXEN_SPR_KEY3, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_KEY3
    {HEXEN_SPR_KEY4, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_KEY4
    {HEXEN_SPR_KEY5, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_KEY5
    {HEXEN_SPR_KEY6, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_KEY6
    {HEXEN_SPR_KEY7, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_KEY7
    {HEXEN_SPR_KEY8, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_KEY8
    {HEXEN_SPR_KEY9, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_KEY9
    {HEXEN_SPR_KEYA, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_KEYA
    {HEXEN_SPR_KEYB, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_KEYB
    {HEXEN_SPR_TLGL, 0, 1, NULL, HEXEN_S_SND_WIND2, 0, 0},  // HEXEN_S_SND_WIND1
    {HEXEN_SPR_TLGL, 0, 200, A_ESound, HEXEN_S_SND_WIND2, 0, 0},    // HEXEN_S_SND_WIND2
    {HEXEN_SPR_TLGL, 0, 85, A_ESound, HEXEN_S_SND_WATERFALL, 0, 0}, // HEXEN_S_SND_WATERFALL
    {HEXEN_SPR_ETTN, 0, 10, A_Look, HEXEN_S_ETTIN_LOOK2, 0, 0},     // HEXEN_S_ETTIN_LOOK1
    {HEXEN_SPR_ETTN, 0, 10, A_Look, HEXEN_S_ETTIN_LOOK1, 0, 0},     // HEXEN_S_ETTIN_LOOK2
    {HEXEN_SPR_ETTN, 0, 5, A_Chase, HEXEN_S_ETTIN_CHASE2, 0, 0},    // HEXEN_S_ETTIN_CHASE1
    {HEXEN_SPR_ETTN, 1, 5, A_Chase, HEXEN_S_ETTIN_CHASE3, 0, 0},    // HEXEN_S_ETTIN_CHASE2
    {HEXEN_SPR_ETTN, 2, 5, A_Chase, HEXEN_S_ETTIN_CHASE4, 0, 0},    // HEXEN_S_ETTIN_CHASE3
    {HEXEN_SPR_ETTN, 3, 5, A_Chase, HEXEN_S_ETTIN_CHASE1, 0, 0},    // HEXEN_S_ETTIN_CHASE4
    {HEXEN_SPR_ETTN, 7, 7, A_Pain, HEXEN_S_ETTIN_CHASE1, 0, 0},     // HEXEN_S_ETTIN_PAIN1
    {HEXEN_SPR_ETTN, 4, 6, A_FaceTarget, HEXEN_S_ETTIN_ATK1_2, 0, 0},       // HEXEN_S_ETTIN_ATK1_1
    {HEXEN_SPR_ETTN, 5, 6, A_FaceTarget, HEXEN_S_ETTIN_ATK1_3, 0, 0},       // HEXEN_S_ETTIN_ATK1_2
    {HEXEN_SPR_ETTN, 6, 8, A_EttinAttack, HEXEN_S_ETTIN_CHASE1, 0, 0},      // HEXEN_S_ETTIN_ATK1_3
    {HEXEN_SPR_ETTN, 8, 4, NULL, HEXEN_S_ETTIN_DEATH1_2, 0, 0},     // HEXEN_S_ETTIN_DEATH1_1
    {HEXEN_SPR_ETTN, 9, 4, NULL, HEXEN_S_ETTIN_DEATH1_3, 0, 0},     // HEXEN_S_ETTIN_DEATH1_2
    {HEXEN_SPR_ETTN, 10, 4, A_Scream, HEXEN_S_ETTIN_DEATH1_4, 0, 0},        // HEXEN_S_ETTIN_DEATH1_3
    {HEXEN_SPR_ETTN, 11, 4, A_NoBlocking, HEXEN_S_ETTIN_DEATH1_5, 0, 0},    // HEXEN_S_ETTIN_DEATH1_4
    {HEXEN_SPR_ETTN, 12, 4, A_QueueCorpse, HEXEN_S_ETTIN_DEATH1_6, 0, 0},   // HEXEN_S_ETTIN_DEATH1_5
    {HEXEN_SPR_ETTN, 13, 4, NULL, HEXEN_S_ETTIN_DEATH1_7, 0, 0},    // HEXEN_S_ETTIN_DEATH1_6
    {HEXEN_SPR_ETTN, 14, 4, NULL, HEXEN_S_ETTIN_DEATH1_8, 0, 0},    // HEXEN_S_ETTIN_DEATH1_7
    {HEXEN_SPR_ETTN, 15, 4, NULL, HEXEN_S_ETTIN_DEATH1_9, 0, 0},    // HEXEN_S_ETTIN_DEATH1_8
    {HEXEN_SPR_ETTN, 16, -1, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_ETTIN_DEATH1_9
    {HEXEN_SPR_ETTB, 0, 4, NULL, HEXEN_S_ETTIN_DEATH2_2, 0, 0},     // HEXEN_S_ETTIN_DEATH2_1
    {HEXEN_SPR_ETTB, 1, 4, A_NoBlocking, HEXEN_S_ETTIN_DEATH2_3, 0, 0},     // HEXEN_S_ETTIN_DEATH2_2
    {HEXEN_SPR_ETTB, 2, 4, A_DropMace, HEXEN_S_ETTIN_DEATH2_4, 0, 0},       // HEXEN_S_ETTIN_DEATH2_3
    {HEXEN_SPR_ETTB, 3, 4, A_Scream, HEXEN_S_ETTIN_DEATH2_5, 0, 0}, // HEXEN_S_ETTIN_DEATH2_4
    {HEXEN_SPR_ETTB, 4, 4, A_QueueCorpse, HEXEN_S_ETTIN_DEATH2_6, 0, 0},    // HEXEN_S_ETTIN_DEATH2_5
    {HEXEN_SPR_ETTB, 5, 4, NULL, HEXEN_S_ETTIN_DEATH2_7, 0, 0},     // HEXEN_S_ETTIN_DEATH2_6
    {HEXEN_SPR_ETTB, 6, 4, NULL, HEXEN_S_ETTIN_DEATH2_8, 0, 0},     // HEXEN_S_ETTIN_DEATH2_7
    {HEXEN_SPR_ETTB, 7, 4, NULL, HEXEN_S_ETTIN_DEATH2_9, 0, 0},     // HEXEN_S_ETTIN_DEATH2_8
    {HEXEN_SPR_ETTB, 8, 4, NULL, HEXEN_S_ETTIN_DEATH2_0, 0, 0},     // HEXEN_S_ETTIN_DEATH2_9
    {HEXEN_SPR_ETTB, 9, 4, NULL, HEXEN_S_ETTIN_DEATH2_A, 0, 0},     // HEXEN_S_ETTIN_DEATH2_0
    {HEXEN_SPR_ETTB, 10, 4, NULL, HEXEN_S_ETTIN_DEATH2_B, 0, 0},    // HEXEN_S_ETTIN_DEATH2_A
    {HEXEN_SPR_ETTB, 11, -1, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_ETTIN_DEATH2_B
    {HEXEN_SPR_ETTN, 17, 5, A_FreezeDeath, HEXEN_S_ETTIN_ICE2, 0, 0},       // HEXEN_S_ETTIN_ICE1
    {HEXEN_SPR_ETTN, 17, 1, A_FreezeDeathChunks, HEXEN_S_ETTIN_ICE2, 0, 0}, // HEXEN_S_ETTIN_ICE2
    {HEXEN_SPR_ETTB, 12, 5, A_CheckFloor, HEXEN_S_ETTIN_MACE2, 0, 0},       // HEXEN_S_ETTIN_MACE1
    {HEXEN_SPR_ETTB, 13, 5, A_CheckFloor, HEXEN_S_ETTIN_MACE3, 0, 0},       // HEXEN_S_ETTIN_MACE2
    {HEXEN_SPR_ETTB, 14, 5, A_CheckFloor, HEXEN_S_ETTIN_MACE4, 0, 0},       // HEXEN_S_ETTIN_MACE3
    {HEXEN_SPR_ETTB, 15, 5, A_CheckFloor, HEXEN_S_ETTIN_MACE1, 0, 0},       // HEXEN_S_ETTIN_MACE4
    {HEXEN_SPR_ETTB, 16, 5, NULL, HEXEN_S_ETTIN_MACE6, 0, 0},       // HEXEN_S_ETTIN_MACE5
    {HEXEN_SPR_ETTB, 17, 5, A_QueueCorpse, HEXEN_S_ETTIN_MACE7, 0, 0},      // HEXEN_S_ETTIN_MACE6
    {HEXEN_SPR_ETTB, 18, -1, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_ETTIN_MACE7
    {HEXEN_SPR_FDMN, 32791, 5, NULL, HEXEN_S_FIRED_LOOK1, 0, 0},    // HEXEN_S_FIRED_SPAWN1
    {HEXEN_SPR_FDMN, 32772, 10, A_Look, HEXEN_S_FIRED_LOOK2, 0, 0}, // HEXEN_S_FIRED_LOOK1
    {HEXEN_SPR_FDMN, 32773, 10, A_Look, HEXEN_S_FIRED_LOOK3, 0, 0}, // HEXEN_S_FIRED_LOOK2
    {HEXEN_SPR_FDMN, 32774, 10, A_Look, HEXEN_S_FIRED_LOOK1, 0, 0}, // HEXEN_S_FIRED_LOOK3
    {HEXEN_SPR_FDMN, 32772, 8, NULL, HEXEN_S_FIRED_LOOK5, 0, 0},    // HEXEN_S_FIRED_LOOK4
    {HEXEN_SPR_FDMN, 32773, 6, NULL, HEXEN_S_FIRED_LOOK6, 0, 0},    // HEXEN_S_FIRED_LOOK5
    {HEXEN_SPR_FDMN, 32774, 5, NULL, HEXEN_S_FIRED_LOOK7, 0, 0},    // HEXEN_S_FIRED_LOOK6
    {HEXEN_SPR_FDMN, 32773, 8, NULL, HEXEN_S_FIRED_LOOK8, 0, 0},    // HEXEN_S_FIRED_LOOK7
    {HEXEN_SPR_FDMN, 32772, 6, NULL, HEXEN_S_FIRED_LOOK9, 0, 0},    // HEXEN_S_FIRED_LOOK8
    {HEXEN_SPR_FDMN, 32773, 7, A_FiredRocks, HEXEN_S_FIRED_LOOK0, 0, 0},    // HEXEN_S_FIRED_LOOK9
    {HEXEN_SPR_FDMN, 32775, 5, NULL, HEXEN_S_FIRED_LOOKA, 0, 0},    // HEXEN_S_FIRED_LOOK0
    {HEXEN_SPR_FDMN, 32776, 5, NULL, HEXEN_S_FIRED_LOOKB, 0, 0},    // HEXEN_S_FIRED_LOOKA
    {HEXEN_SPR_FDMN, 32777, 5, A_UnSetInvulnerable, HEXEN_S_FIRED_WALK1, 0, 0},     // HEXEN_S_FIRED_LOOKB
    {HEXEN_SPR_FDMN, 32768, 5, A_FiredChase, HEXEN_S_FIRED_WALK2, 0, 0},    // HEXEN_S_FIRED_WALK1
    {HEXEN_SPR_FDMN, 32769, 5, A_FiredChase, HEXEN_S_FIRED_WALK3, 0, 0},    // HEXEN_S_FIRED_WALK2
    {HEXEN_SPR_FDMN, 32770, 5, A_FiredChase, HEXEN_S_FIRED_WALK1, 0, 0},    // HEXEN_S_FIRED_WALK3
    {HEXEN_SPR_FDMN, 32771, 6, A_Pain, HEXEN_S_FIRED_WALK1, 0, 0},  // HEXEN_S_FIRED_PAIN1
    {HEXEN_SPR_FDMN, 32778, 3, A_FaceTarget, HEXEN_S_FIRED_ATTACK2, 0, 0},  // HEXEN_S_FIRED_ATTACK1
    {HEXEN_SPR_FDMN, 32778, 5, A_FiredAttack, HEXEN_S_FIRED_ATTACK3, 0, 0}, // HEXEN_S_FIRED_ATTACK2
    {HEXEN_SPR_FDMN, 32778, 5, A_FiredAttack, HEXEN_S_FIRED_ATTACK4, 0, 0}, // HEXEN_S_FIRED_ATTACK3
    {HEXEN_SPR_FDMN, 32778, 5, A_FiredAttack, HEXEN_S_FIRED_WALK1, 0, 0},   // HEXEN_S_FIRED_ATTACK4
    {HEXEN_SPR_FDMN, 32771, 4, A_FaceTarget, HEXEN_S_FIRED_DEATH2, 0, 0},   // HEXEN_S_FIRED_DEATH1
    {HEXEN_SPR_FDMN, 32779, 4, A_Scream, HEXEN_S_FIRED_DEATH3, 0, 0},       // HEXEN_S_FIRED_DEATH2
    {HEXEN_SPR_FDMN, 32779, 4, A_NoBlocking, HEXEN_S_FIRED_DEATH4, 0, 0},   // HEXEN_S_FIRED_DEATH3
    {HEXEN_SPR_FDMN, 32779, 200, NULL, HEXEN_S_NULL, 0, 0}, // HEXEN_S_FIRED_DEATH4
    {HEXEN_SPR_FDMN, 12, 5, A_FaceTarget, HEXEN_S_FIRED_XDEATH2, 0, 0},     // HEXEN_S_FIRED_XDEATH1
    {HEXEN_SPR_FDMN, 13, 5, A_NoBlocking, HEXEN_S_FIRED_XDEATH3, 0, 0},     // HEXEN_S_FIRED_XDEATH2
    {HEXEN_SPR_FDMN, 14, 5, A_FiredSplotch, HEXEN_S_NULL, 0, 0},    // HEXEN_S_FIRED_XDEATH3
    {HEXEN_SPR_FDMN, 17, 5, A_FreezeDeath, HEXEN_S_FIRED_ICE2, 0, 0},       // HEXEN_S_FIRED_ICE1
    {HEXEN_SPR_FDMN, 17, 1, A_FreezeDeathChunks, HEXEN_S_FIRED_ICE2, 0, 0}, // HEXEN_S_FIRED_ICE2
    {HEXEN_SPR_FDMN, 15, 3, NULL, HEXEN_S_FIRED_CORPSE2, 0, 0},     // HEXEN_S_FIRED_CORPSE1
    {HEXEN_SPR_FDMN, 15, 6, A_QueueCorpse, HEXEN_S_FIRED_CORPSE3, 0, 0},    // HEXEN_S_FIRED_CORPSE2
    {HEXEN_SPR_FDMN, 24, -1, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_FIRED_CORPSE3
    {HEXEN_SPR_FDMN, 16, 3, NULL, HEXEN_S_FIRED_CORPSE5, 0, 0},     // HEXEN_S_FIRED_CORPSE4
    {HEXEN_SPR_FDMN, 16, 6, A_QueueCorpse, HEXEN_S_FIRED_CORPSE6, 0, 0},    // HEXEN_S_FIRED_CORPSE5
    {HEXEN_SPR_FDMN, 25, -1, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_FIRED_CORPSE6
    {HEXEN_SPR_FDMN, 18, 4, NULL, HEXEN_S_FIRED_RDROP1, 0, 0},      // HEXEN_S_FIRED_RDROP1
    {HEXEN_SPR_FDMN, 18, 5, A_SmBounce, HEXEN_S_FIRED_RDEAD1_2, 0, 0},      // HEXEN_S_FIRED_RDEAD1_1
    {HEXEN_SPR_FDMN, 18, 200, NULL, HEXEN_S_NULL, 0, 0},    // HEXEN_S_FIRED_RDEAD1_2
    {HEXEN_SPR_FDMN, 19, 4, NULL, HEXEN_S_FIRED_RDROP2, 0, 0},      // HEXEN_S_FIRED_RDROP2
    {HEXEN_SPR_FDMN, 19, 5, A_SmBounce, HEXEN_S_FIRED_RDEAD2_2, 0, 0},      // HEXEN_S_FIRED_RDEAD2_1
    {HEXEN_SPR_FDMN, 19, 200, NULL, HEXEN_S_NULL, 0, 0},    // HEXEN_S_FIRED_RDEAD2_2
    {HEXEN_SPR_FDMN, 20, 4, NULL, HEXEN_S_FIRED_RDROP3, 0, 0},      // HEXEN_S_FIRED_RDROP3
    {HEXEN_SPR_FDMN, 20, 5, A_SmBounce, HEXEN_S_FIRED_RDEAD3_2, 0, 0},      // HEXEN_S_FIRED_RDEAD3_1
    {HEXEN_SPR_FDMN, 20, 200, NULL, HEXEN_S_NULL, 0, 0},    // HEXEN_S_FIRED_RDEAD3_2
    {HEXEN_SPR_FDMN, 21, 4, NULL, HEXEN_S_FIRED_RDROP4, 0, 0},      // HEXEN_S_FIRED_RDROP4
    {HEXEN_SPR_FDMN, 21, 5, A_SmBounce, HEXEN_S_FIRED_RDEAD4_2, 0, 0},      // HEXEN_S_FIRED_RDEAD4_1
    {HEXEN_SPR_FDMN, 21, 200, NULL, HEXEN_S_NULL, 0, 0},    // HEXEN_S_FIRED_RDEAD4_2
    {HEXEN_SPR_FDMN, 22, 4, NULL, HEXEN_S_FIRED_RDROP5, 0, 0},      // HEXEN_S_FIRED_RDROP5
    {HEXEN_SPR_FDMN, 22, 5, A_SmBounce, HEXEN_S_FIRED_RDEAD5_2, 0, 0},      // HEXEN_S_FIRED_RDEAD5_1
    {HEXEN_SPR_FDMN, 22, 200, NULL, HEXEN_S_NULL, 0, 0},    // HEXEN_S_FIRED_RDEAD5_2
    {HEXEN_SPR_FDMB, 32768, 5, NULL, HEXEN_S_FIRED_FX6_1, 0, 0},    // HEXEN_S_FIRED_FX6_1
    {HEXEN_SPR_FDMB, 32769, 5, NULL, HEXEN_S_FIRED_FX6_3, 0, 0},    // HEXEN_S_FIRED_FX6_2
    {HEXEN_SPR_FDMB, 32770, 5, NULL, HEXEN_S_FIRED_FX6_4, 0, 0},    // HEXEN_S_FIRED_FX6_3
    {HEXEN_SPR_FDMB, 32771, 5, NULL, HEXEN_S_FIRED_FX6_5, 0, 0},    // HEXEN_S_FIRED_FX6_4
    {HEXEN_SPR_FDMB, 32772, 5, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_FIRED_FX6_5
    {HEXEN_SPR_ICEY, 0, 10, A_IceGuyLook, HEXEN_S_ICEGUY_LOOK, 0, 0},       // HEXEN_S_ICEGUY_LOOK
    {HEXEN_SPR_ICEY, 0, -1, NULL, HEXEN_S_ICEGUY_LOOK, 0, 0},       // HEXEN_S_ICEGUY_DORMANT
    {HEXEN_SPR_ICEY, 0, 4, A_Chase, HEXEN_S_ICEGUY_WALK2, 0, 0},    // HEXEN_S_ICEGUY_WALK1
    {HEXEN_SPR_ICEY, 1, 4, A_IceGuyChase, HEXEN_S_ICEGUY_WALK3, 0, 0},      // HEXEN_S_ICEGUY_WALK2
    {HEXEN_SPR_ICEY, 2, 4, A_Chase, HEXEN_S_ICEGUY_WALK4, 0, 0},    // HEXEN_S_ICEGUY_WALK3
    {HEXEN_SPR_ICEY, 3, 4, A_Chase, HEXEN_S_ICEGUY_WALK1, 0, 0},    // HEXEN_S_ICEGUY_WALK4
    {HEXEN_SPR_ICEY, 4, 3, A_FaceTarget, HEXEN_S_ICEGUY_ATK2, 0, 0},        // HEXEN_S_ICEGUY_ATK1
    {HEXEN_SPR_ICEY, 5, 3, A_FaceTarget, HEXEN_S_ICEGUY_ATK3, 0, 0},        // HEXEN_S_ICEGUY_ATK2
    {HEXEN_SPR_ICEY, 32774, 8, A_IceGuyAttack, HEXEN_S_ICEGUY_ATK4, 0, 0},  // HEXEN_S_ICEGUY_ATK3
    {HEXEN_SPR_ICEY, 5, 4, A_FaceTarget, HEXEN_S_ICEGUY_WALK1, 0, 0},       // HEXEN_S_ICEGUY_ATK4
    {HEXEN_SPR_ICEY, 0, 1, A_Pain, HEXEN_S_ICEGUY_WALK1, 0, 0},     // HEXEN_S_ICEGUY_PAIN1
    {HEXEN_SPR_ICEY, 0, 1, A_IceGuyDie, HEXEN_S_NULL, 0, 0},        // HEXEN_S_ICEGUY_DEATH
    {HEXEN_SPR_ICPR, 32768, 3, A_IceGuyMissilePuff, HEXEN_S_ICEGUY_FX2, 0, 0},      // HEXEN_S_ICEGUY_FX1
    {HEXEN_SPR_ICPR, 32769, 3, A_IceGuyMissilePuff, HEXEN_S_ICEGUY_FX3, 0, 0},      // HEXEN_S_ICEGUY_FX2
    {HEXEN_SPR_ICPR, 32770, 3, A_IceGuyMissilePuff, HEXEN_S_ICEGUY_FX1, 0, 0},      // HEXEN_S_ICEGUY_FX3
    {HEXEN_SPR_ICPR, 32771, 4, NULL, HEXEN_S_ICEGUY_FX_X2, 0, 0},   // HEXEN_S_ICEGUY_FX_X1
    {HEXEN_SPR_ICPR, 32772, 4, A_IceGuyMissileExplode, HEXEN_S_ICEGUY_FX_X3, 0, 0}, // HEXEN_S_ICEGUY_FX_X2
    {HEXEN_SPR_ICPR, 32773, 4, NULL, HEXEN_S_ICEGUY_FX_X4, 0, 0},   // HEXEN_S_ICEGUY_FX_X3
    {HEXEN_SPR_ICPR, 32774, 4, NULL, HEXEN_S_ICEGUY_FX_X5, 0, 0},   // HEXEN_S_ICEGUY_FX_X4
    {HEXEN_SPR_ICPR, 32775, 3, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_ICEGUY_FX_X5
    {HEXEN_SPR_ICPR, 8, 3, NULL, HEXEN_S_ICEFX_PUFF2, 0, 0},        // HEXEN_S_ICEFX_PUFF1
    {HEXEN_SPR_ICPR, 9, 3, NULL, HEXEN_S_ICEFX_PUFF3, 0, 0},        // HEXEN_S_ICEFX_PUFF2
    {HEXEN_SPR_ICPR, 10, 3, NULL, HEXEN_S_ICEFX_PUFF4, 0, 0},       // HEXEN_S_ICEFX_PUFF3
    {HEXEN_SPR_ICPR, 11, 2, NULL, HEXEN_S_ICEFX_PUFF5, 0, 0},       // HEXEN_S_ICEFX_PUFF4
    {HEXEN_SPR_ICPR, 12, 2, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ICEFX_PUFF5
    {HEXEN_SPR_ICPR, 32781, 3, NULL, HEXEN_S_ICEGUY_FX2_2, 0, 0},   // HEXEN_S_ICEGUY_FX2_1
    {HEXEN_SPR_ICPR, 32782, 3, NULL, HEXEN_S_ICEGUY_FX2_3, 0, 0},   // HEXEN_S_ICEGUY_FX2_2
    {HEXEN_SPR_ICPR, 32783, 3, NULL, HEXEN_S_ICEGUY_FX2_1, 0, 0},   // HEXEN_S_ICEGUY_FX2_3
    {HEXEN_SPR_ICPR, 32784, 50, NULL, HEXEN_S_NULL, 0, 0},  // HEXEN_S_ICEGUY_BIT1
    {HEXEN_SPR_ICPR, 32785, 50, NULL, HEXEN_S_NULL, 0, 0},  // HEXEN_S_ICEGUY_BIT2
    {HEXEN_SPR_ICWS, 0, 2, NULL, HEXEN_S_ICEGUY_WISP1_2, 0, 0},     // HEXEN_S_ICEGUY_WISP1_1
    {HEXEN_SPR_ICWS, 1, 2, NULL, HEXEN_S_ICEGUY_WISP1_3, 0, 0},     // HEXEN_S_ICEGUY_WISP1_2
    {HEXEN_SPR_ICWS, 2, 2, NULL, HEXEN_S_ICEGUY_WISP1_4, 0, 0},     // HEXEN_S_ICEGUY_WISP1_3
    {HEXEN_SPR_ICWS, 3, 2, NULL, HEXEN_S_ICEGUY_WISP1_5, 0, 0},     // HEXEN_S_ICEGUY_WISP1_4
    {HEXEN_SPR_ICWS, 4, 2, NULL, HEXEN_S_ICEGUY_WISP1_6, 0, 0},     // HEXEN_S_ICEGUY_WISP1_5
    {HEXEN_SPR_ICWS, 5, 2, NULL, HEXEN_S_ICEGUY_WISP1_7, 0, 0},     // HEXEN_S_ICEGUY_WISP1_6
    {HEXEN_SPR_ICWS, 6, 2, NULL, HEXEN_S_ICEGUY_WISP1_8, 0, 0},     // HEXEN_S_ICEGUY_WISP1_7
    {HEXEN_SPR_ICWS, 7, 2, NULL, HEXEN_S_ICEGUY_WISP1_9, 0, 0},     // HEXEN_S_ICEGUY_WISP1_8
    {HEXEN_SPR_ICWS, 8, 2, NULL, HEXEN_S_NULL, 0, 0},       // HEXEN_S_ICEGUY_WISP1_9
    {HEXEN_SPR_ICWS, 9, 2, NULL, HEXEN_S_ICEGUY_WISP2_2, 0, 0},     // HEXEN_S_ICEGUY_WISP2_1
    {HEXEN_SPR_ICWS, 10, 2, NULL, HEXEN_S_ICEGUY_WISP2_3, 0, 0},    // HEXEN_S_ICEGUY_WISP2_2
    {HEXEN_SPR_ICWS, 11, 2, NULL, HEXEN_S_ICEGUY_WISP2_4, 0, 0},    // HEXEN_S_ICEGUY_WISP2_3
    {HEXEN_SPR_ICWS, 12, 2, NULL, HEXEN_S_ICEGUY_WISP2_5, 0, 0},    // HEXEN_S_ICEGUY_WISP2_4
    {HEXEN_SPR_ICWS, 13, 2, NULL, HEXEN_S_ICEGUY_WISP2_6, 0, 0},    // HEXEN_S_ICEGUY_WISP2_5
    {HEXEN_SPR_ICWS, 14, 2, NULL, HEXEN_S_ICEGUY_WISP2_7, 0, 0},    // HEXEN_S_ICEGUY_WISP2_6
    {HEXEN_SPR_ICWS, 15, 2, NULL, HEXEN_S_ICEGUY_WISP2_8, 0, 0},    // HEXEN_S_ICEGUY_WISP2_7
    {HEXEN_SPR_ICWS, 16, 2, NULL, HEXEN_S_ICEGUY_WISP2_9, 0, 0},    // HEXEN_S_ICEGUY_WISP2_8
    {HEXEN_SPR_ICWS, 17, 2, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_ICEGUY_WISP2_9
    {HEXEN_SPR_PLAY, 0, 2, NULL, HEXEN_S_FIGHTER2, 0, 0},   // HEXEN_S_FIGHTER
    {HEXEN_SPR_PLAY, 0, 3, A_ClassBossHealth, HEXEN_S_FIGHTERLOOK, 0, 0},   // HEXEN_S_FIGHTER2
    {HEXEN_SPR_PLAY, 0, 5, A_Look, HEXEN_S_FIGHTERLOOK, 0, 0},      // HEXEN_S_FIGHTERLOOK
    {HEXEN_SPR_PLAY, 0, 4, A_FastChase, HEXEN_S_FIGHTER_RUN2, 0, 0},        // HEXEN_S_FIGHTER_RUN1
    {HEXEN_SPR_PLAY, 1, 4, A_FastChase, HEXEN_S_FIGHTER_RUN3, 0, 0},        // HEXEN_S_FIGHTER_RUN2
    {HEXEN_SPR_PLAY, 2, 4, A_FastChase, HEXEN_S_FIGHTER_RUN4, 0, 0},        // HEXEN_S_FIGHTER_RUN3
    {HEXEN_SPR_PLAY, 3, 4, A_FastChase, HEXEN_S_FIGHTER_RUN1, 0, 0},        // HEXEN_S_FIGHTER_RUN4
    {HEXEN_SPR_PLAY, 4, 8, A_FaceTarget, HEXEN_S_FIGHTER_ATK2, 0, 0},       // HEXEN_S_FIGHTER_ATK1
    {HEXEN_SPR_PLAY, 5, 8, A_FighterAttack, HEXEN_S_FIGHTER_RUN1, 0, 0},    // HEXEN_S_FIGHTER_ATK2
    {HEXEN_SPR_PLAY, 6, 4, NULL, HEXEN_S_FIGHTER_PAIN2, 0, 0},      // HEXEN_S_FIGHTER_PAIN
    {HEXEN_SPR_PLAY, 6, 4, A_Pain, HEXEN_S_FIGHTER_RUN1, 0, 0},     // HEXEN_S_FIGHTER_PAIN2
    {HEXEN_SPR_PLAY, 7, 6, NULL, HEXEN_S_FIGHTER_DIE2, 0, 0},       // HEXEN_S_FIGHTER_DIE1
    {HEXEN_SPR_PLAY, 8, 6, A_Scream, HEXEN_S_FIGHTER_DIE3, 0, 0},   // HEXEN_S_FIGHTER_DIE2
    {HEXEN_SPR_PLAY, 9, 6, NULL, HEXEN_S_FIGHTER_DIE4, 0, 0},       // HEXEN_S_FIGHTER_DIE3
    {HEXEN_SPR_PLAY, 10, 6, NULL, HEXEN_S_FIGHTER_DIE5, 0, 0},      // HEXEN_S_FIGHTER_DIE4
    {HEXEN_SPR_PLAY, 11, 6, A_NoBlocking, HEXEN_S_FIGHTER_DIE6, 0, 0},      // HEXEN_S_FIGHTER_DIE5
    {HEXEN_SPR_PLAY, 12, 6, NULL, HEXEN_S_FIGHTER_DIE7, 0, 0},      // HEXEN_S_FIGHTER_DIE6
    {HEXEN_SPR_PLAY, 13, -1, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_FIGHTER_DIE7
    {HEXEN_SPR_PLAY, 14, 5, A_Scream, HEXEN_S_FIGHTER_XDIE2, 0, 0}, // HEXEN_S_FIGHTER_XDIE1
    {HEXEN_SPR_PLAY, 15, 5, A_SkullPop, HEXEN_S_FIGHTER_XDIE3, 0, 0},       // HEXEN_S_FIGHTER_XDIE2
    {HEXEN_SPR_PLAY, 17, 5, A_NoBlocking, HEXEN_S_FIGHTER_XDIE4, 0, 0},     // HEXEN_S_FIGHTER_XDIE3
    {HEXEN_SPR_PLAY, 18, 5, NULL, HEXEN_S_FIGHTER_XDIE5, 0, 0},     // HEXEN_S_FIGHTER_XDIE4
    {HEXEN_SPR_PLAY, 19, 5, NULL, HEXEN_S_FIGHTER_XDIE6, 0, 0},     // HEXEN_S_FIGHTER_XDIE5
    {HEXEN_SPR_PLAY, 20, 5, NULL, HEXEN_S_FIGHTER_XDIE7, 0, 0},     // HEXEN_S_FIGHTER_XDIE6
    {HEXEN_SPR_PLAY, 21, 5, NULL, HEXEN_S_FIGHTER_XDIE8, 0, 0},     // HEXEN_S_FIGHTER_XDIE7
    {HEXEN_SPR_PLAY, 22, -1, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_FIGHTER_XDIE8
    {HEXEN_SPR_PLAY, 23, 5, A_FreezeDeath, HEXEN_S_FIGHTER_ICE2, 0, 0},     // HEXEN_S_FIGHTER_ICE
    {HEXEN_SPR_PLAY, 23, 1, A_FreezeDeathChunks, HEXEN_S_FIGHTER_ICE2, 0, 0},       // HEXEN_S_FIGHTER_ICE2
    {HEXEN_SPR_CLER, 0, 2, NULL, HEXEN_S_CLERIC2, 0, 0},    // HEXEN_S_CLERIC
    {HEXEN_SPR_CLER, 0, 3, A_ClassBossHealth, HEXEN_S_CLERICLOOK, 0, 0},    // HEXEN_S_CLERIC2
    {HEXEN_SPR_CLER, 0, 5, A_Look, HEXEN_S_CLERICLOOK, 0, 0},       // HEXEN_S_CLERICLOOK
    {HEXEN_SPR_CLER, 0, 4, A_FastChase, HEXEN_S_CLERIC_RUN2, 0, 0}, // HEXEN_S_CLERIC_RUN1
    {HEXEN_SPR_CLER, 1, 4, A_FastChase, HEXEN_S_CLERIC_RUN3, 0, 0}, // HEXEN_S_CLERIC_RUN2
    {HEXEN_SPR_CLER, 2, 4, A_FastChase, HEXEN_S_CLERIC_RUN4, 0, 0}, // HEXEN_S_CLERIC_RUN3
    {HEXEN_SPR_CLER, 3, 4, A_FastChase, HEXEN_S_CLERIC_RUN1, 0, 0}, // HEXEN_S_CLERIC_RUN4
    {HEXEN_SPR_CLER, 4, 8, A_FaceTarget, HEXEN_S_CLERIC_ATK2, 0, 0},        // HEXEN_S_CLERIC_ATK1
    {HEXEN_SPR_CLER, 5, 8, A_FaceTarget, HEXEN_S_CLERIC_ATK3, 0, 0},        // HEXEN_S_CLERIC_ATK2
    {HEXEN_SPR_CLER, 6, 10, A_ClericAttack, HEXEN_S_CLERIC_RUN1, 0, 0},     // HEXEN_S_CLERIC_ATK3
    {HEXEN_SPR_CLER, 7, 4, NULL, HEXEN_S_CLERIC_PAIN2, 0, 0},       // HEXEN_S_CLERIC_PAIN
    {HEXEN_SPR_CLER, 7, 4, A_Pain, HEXEN_S_CLERIC_RUN1, 0, 0},      // HEXEN_S_CLERIC_PAIN2
    {HEXEN_SPR_CLER, 8, 6, NULL, HEXEN_S_CLERIC_DIE2, 0, 0},        // HEXEN_S_CLERIC_DIE1
    {HEXEN_SPR_CLER, 10, 6, A_Scream, HEXEN_S_CLERIC_DIE3, 0, 0},   // HEXEN_S_CLERIC_DIE2
    {HEXEN_SPR_CLER, 11, 6, NULL, HEXEN_S_CLERIC_DIE4, 0, 0},       // HEXEN_S_CLERIC_DIE3
    {HEXEN_SPR_CLER, 11, 6, NULL, HEXEN_S_CLERIC_DIE5, 0, 0},       // HEXEN_S_CLERIC_DIE4
    {HEXEN_SPR_CLER, 12, 6, A_NoBlocking, HEXEN_S_CLERIC_DIE6, 0, 0},       // HEXEN_S_CLERIC_DIE5
    {HEXEN_SPR_CLER, 13, 6, NULL, HEXEN_S_CLERIC_DIE7, 0, 0},       // HEXEN_S_CLERIC_DIE6
    {HEXEN_SPR_CLER, 14, 6, NULL, HEXEN_S_CLERIC_DIE8, 0, 0},       // HEXEN_S_CLERIC_DIE7
    {HEXEN_SPR_CLER, 15, 6, NULL, HEXEN_S_CLERIC_DIE9, 0, 0},       // HEXEN_S_CLERIC_DIE8
    {HEXEN_SPR_CLER, 16, -1, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_CLERIC_DIE9
    {HEXEN_SPR_CLER, 17, 5, A_Scream, HEXEN_S_CLERIC_XDIE2, 0, 0},  // HEXEN_S_CLERIC_XDIE1
    {HEXEN_SPR_CLER, 18, 5, NULL, HEXEN_S_CLERIC_XDIE3, 0, 0},      // HEXEN_S_CLERIC_XDIE2
    {HEXEN_SPR_CLER, 19, 5, A_NoBlocking, HEXEN_S_CLERIC_XDIE4, 0, 0},      // HEXEN_S_CLERIC_XDIE3
    {HEXEN_SPR_CLER, 20, 5, NULL, HEXEN_S_CLERIC_XDIE5, 0, 0},      // HEXEN_S_CLERIC_XDIE4
    {HEXEN_SPR_CLER, 21, 5, NULL, HEXEN_S_CLERIC_XDIE6, 0, 0},      // HEXEN_S_CLERIC_XDIE5
    {HEXEN_SPR_CLER, 22, 5, NULL, HEXEN_S_CLERIC_XDIE7, 0, 0},      // HEXEN_S_CLERIC_XDIE6
    {HEXEN_SPR_CLER, 23, 5, NULL, HEXEN_S_CLERIC_XDIE8, 0, 0},      // HEXEN_S_CLERIC_XDIE7
    {HEXEN_SPR_CLER, 24, 5, NULL, HEXEN_S_CLERIC_XDIE9, 0, 0},      // HEXEN_S_CLERIC_XDIE8
    {HEXEN_SPR_CLER, 25, 5, NULL, HEXEN_S_CLERIC_XDIE10, 0, 0},     // HEXEN_S_CLERIC_XDIE9
    {HEXEN_SPR_CLER, 26, -1, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_CLERIC_XDIE10
    {HEXEN_SPR_CLER, 27, 5, A_FreezeDeath, HEXEN_S_CLERIC_ICE2, 0, 0},      // HEXEN_S_CLERIC_ICE
    {HEXEN_SPR_CLER, 27, 1, A_FreezeDeathChunks, HEXEN_S_CLERIC_ICE2, 0, 0},        // HEXEN_S_CLERIC_ICE2
    {HEXEN_SPR_MAGE, 0, 2, NULL, HEXEN_S_MAGE2, 0, 0},      // HEXEN_S_MAGE
    {HEXEN_SPR_MAGE, 0, 3, A_ClassBossHealth, HEXEN_S_MAGELOOK, 0, 0},      // HEXEN_S_MAGE2
    {HEXEN_SPR_MAGE, 0, 5, A_Look, HEXEN_S_MAGELOOK, 0, 0}, // HEXEN_S_MAGELOOK
    {HEXEN_SPR_MAGE, 0, 4, A_FastChase, HEXEN_S_MAGE_RUN2, 0, 0},   // HEXEN_S_MAGE_RUN1
    {HEXEN_SPR_MAGE, 1, 4, A_FastChase, HEXEN_S_MAGE_RUN3, 0, 0},   // HEXEN_S_MAGE_RUN2
    {HEXEN_SPR_MAGE, 2, 4, A_FastChase, HEXEN_S_MAGE_RUN4, 0, 0},   // HEXEN_S_MAGE_RUN3
    {HEXEN_SPR_MAGE, 3, 4, A_FastChase, HEXEN_S_MAGE_RUN1, 0, 0},   // HEXEN_S_MAGE_RUN4
    {HEXEN_SPR_MAGE, 4, 8, A_FaceTarget, HEXEN_S_MAGE_ATK2, 0, 0},  // HEXEN_S_MAGE_ATK1
    {HEXEN_SPR_MAGE, 32773, 8, A_MageAttack, HEXEN_S_MAGE_RUN1, 0, 0},      // HEXEN_S_MAGE_ATK2
    {HEXEN_SPR_MAGE, 6, 4, NULL, HEXEN_S_MAGE_PAIN2, 0, 0}, // HEXEN_S_MAGE_PAIN
    {HEXEN_SPR_MAGE, 6, 4, A_Pain, HEXEN_S_MAGE_RUN1, 0, 0},        // HEXEN_S_MAGE_PAIN2
    {HEXEN_SPR_MAGE, 7, 6, NULL, HEXEN_S_MAGE_DIE2, 0, 0},  // HEXEN_S_MAGE_DIE1
    {HEXEN_SPR_MAGE, 8, 6, A_Scream, HEXEN_S_MAGE_DIE3, 0, 0},      // HEXEN_S_MAGE_DIE2
    {HEXEN_SPR_MAGE, 9, 6, NULL, HEXEN_S_MAGE_DIE4, 0, 0},  // HEXEN_S_MAGE_DIE3
    {HEXEN_SPR_MAGE, 10, 6, NULL, HEXEN_S_MAGE_DIE5, 0, 0}, // HEXEN_S_MAGE_DIE4
    {HEXEN_SPR_MAGE, 11, 6, A_NoBlocking, HEXEN_S_MAGE_DIE6, 0, 0}, // HEXEN_S_MAGE_DIE5
    {HEXEN_SPR_MAGE, 12, 6, NULL, HEXEN_S_MAGE_DIE7, 0, 0}, // HEXEN_S_MAGE_DIE6
    {HEXEN_SPR_MAGE, 13, -1, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_MAGE_DIE7
    {HEXEN_SPR_MAGE, 14, 5, A_Scream, HEXEN_S_MAGE_XDIE2, 0, 0},    // HEXEN_S_MAGE_XDIE1
    {HEXEN_SPR_MAGE, 15, 5, NULL, HEXEN_S_MAGE_XDIE3, 0, 0},        // HEXEN_S_MAGE_XDIE2
    {HEXEN_SPR_MAGE, 17, 5, A_NoBlocking, HEXEN_S_MAGE_XDIE4, 0, 0},        // HEXEN_S_MAGE_XDIE3
    {HEXEN_SPR_MAGE, 18, 5, NULL, HEXEN_S_MAGE_XDIE5, 0, 0},        // HEXEN_S_MAGE_XDIE4
    {HEXEN_SPR_MAGE, 19, 5, NULL, HEXEN_S_MAGE_XDIE6, 0, 0},        // HEXEN_S_MAGE_XDIE5
    {HEXEN_SPR_MAGE, 20, 5, NULL, HEXEN_S_MAGE_XDIE7, 0, 0},        // HEXEN_S_MAGE_XDIE6
    {HEXEN_SPR_MAGE, 21, 5, NULL, HEXEN_S_MAGE_XDIE8, 0, 0},        // HEXEN_S_MAGE_XDIE7
    {HEXEN_SPR_MAGE, 22, 5, NULL, HEXEN_S_MAGE_XDIE9, 0, 0},        // HEXEN_S_MAGE_XDIE8
    {HEXEN_SPR_MAGE, 23, -1, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_MAGE_XDIE9
    {HEXEN_SPR_MAGE, 24, 5, A_FreezeDeath, HEXEN_S_MAGE_ICE2, 0, 0},        // HEXEN_S_MAGE_ICE
    {HEXEN_SPR_MAGE, 24, 1, A_FreezeDeathChunks, HEXEN_S_MAGE_ICE2, 0, 0},  // HEXEN_S_MAGE_ICE2
    {HEXEN_SPR_SORC, 0, 3, NULL, HEXEN_S_SORC_SPAWN2, 0, 0},        // HEXEN_S_SORC_SPAWN1
    {HEXEN_SPR_SORC, 0, 2, A_SorcSpinBalls, HEXEN_S_SORC_LOOK1, 0, 0},      // HEXEN_S_SORC_SPAWN2
    {HEXEN_SPR_SORC, 0, 10, A_Look, HEXEN_S_SORC_LOOK1, 0, 0},      // HEXEN_S_SORC_LOOK1
    {HEXEN_SPR_SORC, 0, 5, A_Chase, HEXEN_S_SORC_WALK2, 0, 0},      // HEXEN_S_SORC_WALK1
    {HEXEN_SPR_SORC, 1, 5, A_Chase, HEXEN_S_SORC_WALK3, 0, 0},      // HEXEN_S_SORC_WALK2
    {HEXEN_SPR_SORC, 2, 5, A_Chase, HEXEN_S_SORC_WALK4, 0, 0},      // HEXEN_S_SORC_WALK3
    {HEXEN_SPR_SORC, 3, 5, A_Chase, HEXEN_S_SORC_WALK1, 0, 0},      // HEXEN_S_SORC_WALK4
    {HEXEN_SPR_SORC, 6, 8, NULL, HEXEN_S_SORC_PAIN2, 0, 0}, // HEXEN_S_SORC_PAIN1
    {HEXEN_SPR_SORC, 6, 8, A_Pain, HEXEN_S_SORC_WALK1, 0, 0},       // HEXEN_S_SORC_PAIN2
    {HEXEN_SPR_SORC, 32773, 6, A_FaceTarget, HEXEN_S_SORC_ATK2_2, 0, 0},    // HEXEN_S_SORC_ATK2_1
    {HEXEN_SPR_SORC, 32773, 6, A_SpeedBalls, HEXEN_S_SORC_ATK2_3, 0, 0},    // HEXEN_S_SORC_ATK2_2
    {HEXEN_SPR_SORC, 32773, 6, A_FaceTarget, HEXEN_S_SORC_ATK2_3, 0, 0},    // HEXEN_S_SORC_ATK2_3
    {HEXEN_SPR_SORC, 32772, 6, NULL, HEXEN_S_SORC_ATTACK2, 0, 0},   // HEXEN_S_SORC_ATTACK1
    {HEXEN_SPR_SORC, 32772, 6, A_SpawnFizzle, HEXEN_S_SORC_ATTACK3, 0, 0},  // HEXEN_S_SORC_ATTACK2
    {HEXEN_SPR_SORC, 32772, 5, A_FaceTarget, HEXEN_S_SORC_ATTACK2, 0, 0},   // HEXEN_S_SORC_ATTACK3
    {HEXEN_SPR_SORC, 32772, 2, NULL, HEXEN_S_SORC_ATTACK5, 0, 0},   // HEXEN_S_SORC_ATTACK4
    {HEXEN_SPR_SORC, 32772, 2, A_SorcBossAttack, HEXEN_S_SORC_WALK1, 0, 0}, // HEXEN_S_SORC_ATTACK5
    {HEXEN_SPR_SORC, 32775, 5, NULL, HEXEN_S_SORC_DIE2, 0, 0},      // HEXEN_S_SORC_DIE1
    {HEXEN_SPR_SORC, 32776, 5, A_FaceTarget, HEXEN_S_SORC_DIE3, 0, 0},      // HEXEN_S_SORC_DIE2
    {HEXEN_SPR_SORC, 32777, 5, A_Scream, HEXEN_S_SORC_DIE4, 0, 0},  // HEXEN_S_SORC_DIE3
    {HEXEN_SPR_SORC, 32778, 5, NULL, HEXEN_S_SORC_DIE5, 0, 0},      // HEXEN_S_SORC_DIE4
    {HEXEN_SPR_SORC, 32779, 5, NULL, HEXEN_S_SORC_DIE6, 0, 0},      // HEXEN_S_SORC_DIE5
    {HEXEN_SPR_SORC, 32780, 5, NULL, HEXEN_S_SORC_DIE7, 0, 0},      // HEXEN_S_SORC_DIE6
    {HEXEN_SPR_SORC, 32781, 5, NULL, HEXEN_S_SORC_DIE8, 0, 0},      // HEXEN_S_SORC_DIE7
    {HEXEN_SPR_SORC, 32782, 5, NULL, HEXEN_S_SORC_DIE9, 0, 0},      // HEXEN_S_SORC_DIE8
    {HEXEN_SPR_SORC, 32783, 5, NULL, HEXEN_S_SORC_DIE0, 0, 0},      // HEXEN_S_SORC_DIE9
    {HEXEN_SPR_SORC, 32784, 5, NULL, HEXEN_S_SORC_DIEA, 0, 0},      // HEXEN_S_SORC_DIE0
    {HEXEN_SPR_SORC, 32785, 5, NULL, HEXEN_S_SORC_DIEB, 0, 0},      // HEXEN_S_SORC_DIEA
    {HEXEN_SPR_SORC, 32786, 5, NULL, HEXEN_S_SORC_DIEC, 0, 0},      // HEXEN_S_SORC_DIEB
    {HEXEN_SPR_SORC, 32787, 5, NULL, HEXEN_S_SORC_DIED, 0, 0},      // HEXEN_S_SORC_DIEC
    {HEXEN_SPR_SORC, 32788, 5, A_NoBlocking, HEXEN_S_SORC_DIEE, 0, 0},      // HEXEN_S_SORC_DIED
    {HEXEN_SPR_SORC, 32789, 5, NULL, HEXEN_S_SORC_DIEF, 0, 0},      // HEXEN_S_SORC_DIEE
    {HEXEN_SPR_SORC, 32790, 5, NULL, HEXEN_S_SORC_DIEG, 0, 0},      // HEXEN_S_SORC_DIEF
    {HEXEN_SPR_SORC, 32791, 5, NULL, HEXEN_S_SORC_DIEH, 0, 0},      // HEXEN_S_SORC_DIEG
    {HEXEN_SPR_SORC, 32792, 5, NULL, HEXEN_S_SORC_DIEI, 0, 0},      // HEXEN_S_SORC_DIEH
    {HEXEN_SPR_SORC, 32793, -1, NULL, HEXEN_S_NULL, 0, 0},  // HEXEN_S_SORC_DIEI
    {HEXEN_SPR_SBMP, 0, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL1_2, 0, 0},     // HEXEN_S_SORCBALL1_1
    {HEXEN_SPR_SBMP, 1, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL1_3, 0, 0},     // HEXEN_S_SORCBALL1_2
    {HEXEN_SPR_SBMP, 2, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL1_4, 0, 0},     // HEXEN_S_SORCBALL1_3
    {HEXEN_SPR_SBMP, 3, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL1_5, 0, 0},     // HEXEN_S_SORCBALL1_4
    {HEXEN_SPR_SBMP, 4, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL1_6, 0, 0},     // HEXEN_S_SORCBALL1_5
    {HEXEN_SPR_SBMP, 5, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL1_7, 0, 0},     // HEXEN_S_SORCBALL1_6
    {HEXEN_SPR_SBMP, 6, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL1_8, 0, 0},     // HEXEN_S_SORCBALL1_7
    {HEXEN_SPR_SBMP, 7, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL1_9, 0, 0},     // HEXEN_S_SORCBALL1_8
    {HEXEN_SPR_SBMP, 8, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL1_0, 0, 0},     // HEXEN_S_SORCBALL1_9
    {HEXEN_SPR_SBMP, 9, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL1_A, 0, 0},     // HEXEN_S_SORCBALL1_0
    {HEXEN_SPR_SBMP, 10, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL1_B, 0, 0},    // HEXEN_S_SORCBALL1_A
    {HEXEN_SPR_SBMP, 11, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL1_C, 0, 0},    // HEXEN_S_SORCBALL1_B
    {HEXEN_SPR_SBMP, 12, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL1_D, 0, 0},    // HEXEN_S_SORCBALL1_C
    {HEXEN_SPR_SBMP, 13, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL1_E, 0, 0},    // HEXEN_S_SORCBALL1_D
    {HEXEN_SPR_SBMP, 14, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL1_F, 0, 0},    // HEXEN_S_SORCBALL1_E
    {HEXEN_SPR_SBMP, 15, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL1_1, 0, 0},    // HEXEN_S_SORCBALL1_F
    {HEXEN_SPR_SBMP, 0, 5, A_SorcBallPop, HEXEN_S_SORCBALL1_D2, 0, 0},      // HEXEN_S_SORCBALL1_D1
    {HEXEN_SPR_SBMP, 1, 2, A_BounceCheck, HEXEN_S_SORCBALL1_D2, 0, 0},      // HEXEN_S_SORCBALL1_D2
    {HEXEN_SPR_SBS4, 3, 5, A_Explode, HEXEN_S_SORCBALL1_D6, 0, 0},  // HEXEN_S_SORCBALL1_D5
    {HEXEN_SPR_SBS4, 4, 5, NULL, HEXEN_S_SORCBALL1_D7, 0, 0},       // HEXEN_S_SORCBALL1_D6
    {HEXEN_SPR_SBS4, 5, 6, NULL, HEXEN_S_SORCBALL1_D8, 0, 0},       // HEXEN_S_SORCBALL1_D7
    {HEXEN_SPR_SBS4, 6, 6, NULL, HEXEN_S_SORCBALL1_D9, 0, 0},       // HEXEN_S_SORCBALL1_D8
    {HEXEN_SPR_SBS4, 7, 6, NULL, HEXEN_S_NULL, 0, 0},       // HEXEN_S_SORCBALL1_D9
    {HEXEN_SPR_SBMB, 0, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL2_2, 0, 0},     // HEXEN_S_SORCBALL2_1
    {HEXEN_SPR_SBMB, 1, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL2_3, 0, 0},     // HEXEN_S_SORCBALL2_2
    {HEXEN_SPR_SBMB, 2, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL2_4, 0, 0},     // HEXEN_S_SORCBALL2_3
    {HEXEN_SPR_SBMB, 3, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL2_5, 0, 0},     // HEXEN_S_SORCBALL2_4
    {HEXEN_SPR_SBMB, 4, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL2_6, 0, 0},     // HEXEN_S_SORCBALL2_5
    {HEXEN_SPR_SBMB, 5, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL2_7, 0, 0},     // HEXEN_S_SORCBALL2_6
    {HEXEN_SPR_SBMB, 6, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL2_8, 0, 0},     // HEXEN_S_SORCBALL2_7
    {HEXEN_SPR_SBMB, 7, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL2_9, 0, 0},     // HEXEN_S_SORCBALL2_8
    {HEXEN_SPR_SBMB, 8, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL2_0, 0, 0},     // HEXEN_S_SORCBALL2_9
    {HEXEN_SPR_SBMB, 9, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL2_A, 0, 0},     // HEXEN_S_SORCBALL2_0
    {HEXEN_SPR_SBMB, 10, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL2_B, 0, 0},    // HEXEN_S_SORCBALL2_A
    {HEXEN_SPR_SBMB, 11, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL2_C, 0, 0},    // HEXEN_S_SORCBALL2_B
    {HEXEN_SPR_SBMB, 12, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL2_D, 0, 0},    // HEXEN_S_SORCBALL2_C
    {HEXEN_SPR_SBMB, 13, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL2_E, 0, 0},    // HEXEN_S_SORCBALL2_D
    {HEXEN_SPR_SBMB, 14, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL2_F, 0, 0},    // HEXEN_S_SORCBALL2_E
    {HEXEN_SPR_SBMB, 15, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL2_1, 0, 0},    // HEXEN_S_SORCBALL2_F
    {HEXEN_SPR_SBMB, 0, 5, A_SorcBallPop, HEXEN_S_SORCBALL2_D2, 0, 0},      // HEXEN_S_SORCBALL2_D1
    {HEXEN_SPR_SBMB, 1, 2, A_BounceCheck, HEXEN_S_SORCBALL2_D2, 0, 0},      // HEXEN_S_SORCBALL2_D2
    {HEXEN_SPR_SBS3, 3, 5, A_Explode, HEXEN_S_SORCBALL2_D6, 0, 0},  // HEXEN_S_SORCBALL2_D5
    {HEXEN_SPR_SBS3, 4, 5, NULL, HEXEN_S_SORCBALL2_D7, 0, 0},       // HEXEN_S_SORCBALL2_D6
    {HEXEN_SPR_SBS3, 5, 6, NULL, HEXEN_S_SORCBALL2_D8, 0, 0},       // HEXEN_S_SORCBALL2_D7
    {HEXEN_SPR_SBS3, 6, 6, NULL, HEXEN_S_SORCBALL2_D9, 0, 0},       // HEXEN_S_SORCBALL2_D8
    {HEXEN_SPR_SBS3, 7, 6, NULL, HEXEN_S_NULL, 0, 0},       // HEXEN_S_SORCBALL2_D9
    {HEXEN_SPR_SBMG, 0, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL3_2, 0, 0},     // HEXEN_S_SORCBALL3_1
    {HEXEN_SPR_SBMG, 1, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL3_3, 0, 0},     // HEXEN_S_SORCBALL3_2
    {HEXEN_SPR_SBMG, 2, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL3_4, 0, 0},     // HEXEN_S_SORCBALL3_3
    {HEXEN_SPR_SBMG, 3, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL3_5, 0, 0},     // HEXEN_S_SORCBALL3_4
    {HEXEN_SPR_SBMG, 4, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL3_6, 0, 0},     // HEXEN_S_SORCBALL3_5
    {HEXEN_SPR_SBMG, 5, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL3_7, 0, 0},     // HEXEN_S_SORCBALL3_6
    {HEXEN_SPR_SBMG, 6, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL3_8, 0, 0},     // HEXEN_S_SORCBALL3_7
    {HEXEN_SPR_SBMG, 7, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL3_9, 0, 0},     // HEXEN_S_SORCBALL3_8
    {HEXEN_SPR_SBMG, 8, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL3_0, 0, 0},     // HEXEN_S_SORCBALL3_9
    {HEXEN_SPR_SBMG, 9, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL3_A, 0, 0},     // HEXEN_S_SORCBALL3_0
    {HEXEN_SPR_SBMG, 10, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL3_B, 0, 0},    // HEXEN_S_SORCBALL3_A
    {HEXEN_SPR_SBMG, 11, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL3_C, 0, 0},    // HEXEN_S_SORCBALL3_B
    {HEXEN_SPR_SBMG, 12, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL3_D, 0, 0},    // HEXEN_S_SORCBALL3_C
    {HEXEN_SPR_SBMG, 13, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL3_E, 0, 0},    // HEXEN_S_SORCBALL3_D
    {HEXEN_SPR_SBMG, 14, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL3_F, 0, 0},    // HEXEN_S_SORCBALL3_E
    {HEXEN_SPR_SBMG, 15, 2, A_SorcBallOrbit, HEXEN_S_SORCBALL3_1, 0, 0},    // HEXEN_S_SORCBALL3_F
    {HEXEN_SPR_SBMG, 0, 5, A_SorcBallPop, HEXEN_S_SORCBALL3_D2, 0, 0},      // HEXEN_S_SORCBALL3_D1
    {HEXEN_SPR_SBMG, 1, 2, A_BounceCheck, HEXEN_S_SORCBALL3_D2, 0, 0},      // HEXEN_S_SORCBALL3_D2
    {HEXEN_SPR_SBS3, 3, 5, A_Explode, HEXEN_S_SORCBALL3_D6, 0, 0},  // HEXEN_S_SORCBALL3_D5
    {HEXEN_SPR_SBS3, 4, 5, NULL, HEXEN_S_SORCBALL3_D7, 0, 0},       // HEXEN_S_SORCBALL3_D6
    {HEXEN_SPR_SBS3, 5, 6, NULL, HEXEN_S_SORCBALL3_D8, 0, 0},       // HEXEN_S_SORCBALL3_D7
    {HEXEN_SPR_SBS3, 6, 6, NULL, HEXEN_S_SORCBALL3_D9, 0, 0},       // HEXEN_S_SORCBALL3_D8
    {HEXEN_SPR_SBS3, 7, 6, NULL, HEXEN_S_NULL, 0, 0},       // HEXEN_S_SORCBALL3_D9
    {HEXEN_SPR_SBS1, 32768, 2, NULL, HEXEN_S_SORCFX1_2, 0, 0},      // HEXEN_S_SORCFX1_1
    {HEXEN_SPR_SBS1, 32769, 3, A_SorcFX1Seek, HEXEN_S_SORCFX1_3, 0, 0},     // HEXEN_S_SORCFX1_2
    {HEXEN_SPR_SBS1, 32770, 3, A_SorcFX1Seek, HEXEN_S_SORCFX1_4, 0, 0},     // HEXEN_S_SORCFX1_3
    {HEXEN_SPR_SBS1, 32771, 3, A_SorcFX1Seek, HEXEN_S_SORCFX1_1, 0, 0},     // HEXEN_S_SORCFX1_4
    {HEXEN_SPR_FHFX, 32786, 2, A_Explode, HEXEN_S_SORCFX1_D2, 0, 0},        // HEXEN_S_SORCFX1_D1
    {HEXEN_SPR_FHFX, 32786, 6, NULL, HEXEN_S_SORCFX1_D3, 0, 0},     // HEXEN_S_SORCFX1_D2
    {HEXEN_SPR_FHFX, 32786, 6, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_SORCFX1_D3
    {HEXEN_SPR_SBS2, 32768, 3, A_SorcFX2Split, HEXEN_S_SORCFX2_SPLIT1, 0, 0},       // HEXEN_S_SORCFX2_SPLIT1
    {HEXEN_SPR_SBS2, 32768, 2, A_SorcFX2Orbit, HEXEN_S_SORCFX2_ORBIT2, 0, 0},       // HEXEN_S_SORCFX2_ORBIT1
    {HEXEN_SPR_SBS2, 32769, 2, A_SorcFX2Orbit, HEXEN_S_SORCFX2_ORBIT3, 0, 0},       // HEXEN_S_SORCFX2_ORBIT2
    {HEXEN_SPR_SBS2, 32770, 2, A_SorcFX2Orbit, HEXEN_S_SORCFX2_ORBIT4, 0, 0},       // HEXEN_S_SORCFX2_ORBIT3
    {HEXEN_SPR_SBS2, 32771, 2, A_SorcFX2Orbit, HEXEN_S_SORCFX2_ORBIT5, 0, 0},       // HEXEN_S_SORCFX2_ORBIT4
    {HEXEN_SPR_SBS2, 32772, 2, A_SorcFX2Orbit, HEXEN_S_SORCFX2_ORBIT6, 0, 0},       // HEXEN_S_SORCFX2_ORBIT5
    {HEXEN_SPR_SBS2, 32773, 2, A_SorcFX2Orbit, HEXEN_S_SORCFX2_ORBIT7, 0, 0},       // HEXEN_S_SORCFX2_ORBIT6
    {HEXEN_SPR_SBS2, 32774, 2, A_SorcFX2Orbit, HEXEN_S_SORCFX2_ORBIT8, 0, 0},       // HEXEN_S_SORCFX2_ORBIT7
    {HEXEN_SPR_SBS2, 32775, 2, A_SorcFX2Orbit, HEXEN_S_SORCFX2_ORBIT9, 0, 0},       // HEXEN_S_SORCFX2_ORBIT8
    {HEXEN_SPR_SBS2, 32776, 2, A_SorcFX2Orbit, HEXEN_S_SORCFX2_ORBIT0, 0, 0},       // HEXEN_S_SORCFX2_ORBIT9
    {HEXEN_SPR_SBS2, 32777, 2, A_SorcFX2Orbit, HEXEN_S_SORCFX2_ORBITA, 0, 0},       // HEXEN_S_SORCFX2_ORBIT0
    {HEXEN_SPR_SBS2, 32778, 2, A_SorcFX2Orbit, HEXEN_S_SORCFX2_ORBITB, 0, 0},       // HEXEN_S_SORCFX2_ORBITA
    {HEXEN_SPR_SBS2, 32779, 2, A_SorcFX2Orbit, HEXEN_S_SORCFX2_ORBITC, 0, 0},       // HEXEN_S_SORCFX2_ORBITB
    {HEXEN_SPR_SBS2, 32780, 2, A_SorcFX2Orbit, HEXEN_S_SORCFX2_ORBITD, 0, 0},       // HEXEN_S_SORCFX2_ORBITC
    {HEXEN_SPR_SBS2, 32781, 2, A_SorcFX2Orbit, HEXEN_S_SORCFX2_ORBITE, 0, 0},       // HEXEN_S_SORCFX2_ORBITD
    {HEXEN_SPR_SBS2, 32782, 2, A_SorcFX2Orbit, HEXEN_S_SORCFX2_ORBITF, 0, 0},       // HEXEN_S_SORCFX2_ORBITE
    {HEXEN_SPR_SBS2, 32783, 2, A_SorcFX2Orbit, HEXEN_S_SORCFX2_ORBIT1, 0, 0},       // HEXEN_S_SORCFX2_ORBITF
    {HEXEN_SPR_SBS2, 0, 10, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_SORCFX2T1
    {HEXEN_SPR_SBS3, 32768, 2, NULL, HEXEN_S_SORCFX3_2, 0, 0},      // HEXEN_S_SORCFX3_1
    {HEXEN_SPR_SBS3, 32769, 2, NULL, HEXEN_S_SORCFX3_3, 0, 0},      // HEXEN_S_SORCFX3_2
    {HEXEN_SPR_SBS3, 32770, 2, NULL, HEXEN_S_SORCFX3_1, 0, 0},      // HEXEN_S_SORCFX3_3
    {HEXEN_SPR_SBS3, 32768, 4, NULL, HEXEN_S_BISHMORPHA, 0, 0},     // HEXEN_S_BISHMORPH1
    {HEXEN_SPR_BISH, 15, 4, A_SorcererBishopEntry, HEXEN_S_BISHMORPHB, 0, 0},       // HEXEN_S_BISHMORPHA
    {HEXEN_SPR_BISH, 14, 4, NULL, HEXEN_S_BISHMORPHC, 0, 0},        // HEXEN_S_BISHMORPHB
    {HEXEN_SPR_BISH, 13, 4, NULL, HEXEN_S_BISHMORPHD, 0, 0},        // HEXEN_S_BISHMORPHC
    {HEXEN_SPR_BISH, 12, 3, NULL, HEXEN_S_BISHMORPHE, 0, 0},        // HEXEN_S_BISHMORPHD
    {HEXEN_SPR_BISH, 11, 3, NULL, HEXEN_S_BISHMORPHF, 0, 0},        // HEXEN_S_BISHMORPHE
    {HEXEN_SPR_BISH, 10, 3, NULL, HEXEN_S_BISHMORPHG, 0, 0},        // HEXEN_S_BISHMORPHF
    {HEXEN_SPR_BISH, 9, 3, NULL, HEXEN_S_BISHMORPHH, 0, 0}, // HEXEN_S_BISHMORPHG
    {HEXEN_SPR_BISH, 8, 3, NULL, HEXEN_S_BISHMORPHI, 0, 0}, // HEXEN_S_BISHMORPHH
    {HEXEN_SPR_BISH, 7, 3, NULL, HEXEN_S_BISHMORPHJ, 0, 0}, // HEXEN_S_BISHMORPHI
    {HEXEN_SPR_BISH, 6, 3, A_SpawnBishop, HEXEN_S_NULL, 0, 0},      // HEXEN_S_BISHMORPHJ
    {HEXEN_SPR_SBS3, 3, 3, NULL, HEXEN_S_SORCFX3_EXP2, 0, 0},       // HEXEN_S_SORCFX3_EXP1
    {HEXEN_SPR_SBS3, 4, 3, NULL, HEXEN_S_SORCFX3_EXP3, 0, 0},       // HEXEN_S_SORCFX3_EXP2
    {HEXEN_SPR_SBS3, 5, 3, NULL, HEXEN_S_SORCFX3_EXP4, 0, 0},       // HEXEN_S_SORCFX3_EXP3
    {HEXEN_SPR_SBS3, 6, 3, NULL, HEXEN_S_SORCFX3_EXP5, 0, 0},       // HEXEN_S_SORCFX3_EXP4
    {HEXEN_SPR_SBS3, 7, 3, NULL, HEXEN_S_NULL, 0, 0},       // HEXEN_S_SORCFX3_EXP5
    {HEXEN_SPR_SBS4, 32768, 2, A_SorcFX4Check, HEXEN_S_SORCFX4_2, 0, 0},    // HEXEN_S_SORCFX4_1
    {HEXEN_SPR_SBS4, 32769, 2, A_SorcFX4Check, HEXEN_S_SORCFX4_3, 0, 0},    // HEXEN_S_SORCFX4_2
    {HEXEN_SPR_SBS4, 32770, 2, A_SorcFX4Check, HEXEN_S_SORCFX4_1, 0, 0},    // HEXEN_S_SORCFX4_3
    {HEXEN_SPR_SBS4, 32771, 2, NULL, HEXEN_S_SORCFX4_D2, 0, 0},     // HEXEN_S_SORCFX4_D1
    {HEXEN_SPR_SBS4, 32772, 2, A_Explode, HEXEN_S_SORCFX4_D3, 0, 0},        // HEXEN_S_SORCFX4_D2
    {HEXEN_SPR_SBS4, 32773, 2, NULL, HEXEN_S_SORCFX4_D4, 0, 0},     // HEXEN_S_SORCFX4_D3
    {HEXEN_SPR_SBS4, 32774, 2, NULL, HEXEN_S_SORCFX4_D5, 0, 0},     // HEXEN_S_SORCFX4_D4
    {HEXEN_SPR_SBS4, 32775, 2, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_SORCFX4_D5
    {HEXEN_SPR_SBFX, 32768, 4, NULL, HEXEN_S_SORCSPARK2, 0, 0},     // HEXEN_S_SORCSPARK1
    {HEXEN_SPR_SBFX, 32769, 4, NULL, HEXEN_S_SORCSPARK3, 0, 0},     // HEXEN_S_SORCSPARK2
    {HEXEN_SPR_SBFX, 32770, 4, NULL, HEXEN_S_SORCSPARK4, 0, 0},     // HEXEN_S_SORCSPARK3
    {HEXEN_SPR_SBFX, 32771, 4, NULL, HEXEN_S_SORCSPARK5, 0, 0},     // HEXEN_S_SORCSPARK4
    {HEXEN_SPR_SBFX, 32772, 4, NULL, HEXEN_S_SORCSPARK6, 0, 0},     // HEXEN_S_SORCSPARK5
    {HEXEN_SPR_SBFX, 32773, 4, NULL, HEXEN_S_SORCSPARK7, 0, 0},     // HEXEN_S_SORCSPARK6
    {HEXEN_SPR_SBFX, 32774, 4, NULL, HEXEN_S_NULL, 0, 0},   // HEXEN_S_SORCSPARK7
    {HEXEN_SPR_RADE, 0, 4, NULL, HEXEN_S_BLASTEFFECT2, 0, 0},       // HEXEN_S_BLASTEFFECT1
    {HEXEN_SPR_RADE, 1, 4, NULL, HEXEN_S_BLASTEFFECT3, 0, 0},       // HEXEN_S_BLASTEFFECT2
    {HEXEN_SPR_RADE, 2, 4, NULL, HEXEN_S_BLASTEFFECT4, 0, 0},       // HEXEN_S_BLASTEFFECT3
    {HEXEN_SPR_RADE, 3, 4, NULL, HEXEN_S_BLASTEFFECT5, 0, 0},       // HEXEN_S_BLASTEFFECT4
    {HEXEN_SPR_RADE, 4, 4, NULL, HEXEN_S_BLASTEFFECT6, 0, 0},       // HEXEN_S_BLASTEFFECT5
    {HEXEN_SPR_RADE, 5, 4, NULL, HEXEN_S_BLASTEFFECT7, 0, 0},       // HEXEN_S_BLASTEFFECT6
    {HEXEN_SPR_RADE, 6, 4, NULL, HEXEN_S_BLASTEFFECT8, 0, 0},       // HEXEN_S_BLASTEFFECT7
    {HEXEN_SPR_RADE, 7, 4, NULL, HEXEN_S_BLASTEFFECT9, 0, 0},       // HEXEN_S_BLASTEFFECT8
    {HEXEN_SPR_RADE, 8, 4, NULL, HEXEN_S_NULL, 0, 0},       // HEXEN_S_BLASTEFFECT9
    {HEXEN_SPR_WATR, 0, 5, NULL, HEXEN_S_WATERDRIP1, 0, 0}, // HEXEN_S_WATERDRIP1
    {HEXEN_SPR_KORX, 0, 5, A_Look, HEXEN_S_KORAX_LOOK1, 0, 0},      // HEXEN_S_KORAX_LOOK1
    {HEXEN_SPR_KORX, 0, 3, A_KoraxStep2, HEXEN_S_KORAX_CHASE2, 0, 0},       // HEXEN_S_KORAX_CHASE1
    {HEXEN_SPR_KORX, 0, 3, A_KoraxChase, HEXEN_S_KORAX_CHASE3, 0, 0},       // HEXEN_S_KORAX_CHASE2
    {HEXEN_SPR_KORX, 0, 3, A_KoraxChase, HEXEN_S_KORAX_CHASE4, 0, 0},       // HEXEN_S_KORAX_CHASE3
    {HEXEN_SPR_KORX, 0, 3, A_KoraxChase, HEXEN_S_KORAX_CHASE5, 0, 0},       // HEXEN_S_KORAX_CHASE4
    {HEXEN_SPR_KORX, 1, 3, A_KoraxStep, HEXEN_S_KORAX_CHASE6, 0, 0},        // HEXEN_S_KORAX_CHASE5
    {HEXEN_SPR_KORX, 1, 3, A_KoraxChase, HEXEN_S_KORAX_CHASE7, 0, 0},       // HEXEN_S_KORAX_CHASE6
    {HEXEN_SPR_KORX, 1, 3, A_KoraxChase, HEXEN_S_KORAX_CHASE8, 0, 0},       // HEXEN_S_KORAX_CHASE7
    {HEXEN_SPR_KORX, 1, 3, A_KoraxChase, HEXEN_S_KORAX_CHASE9, 0, 0},       // HEXEN_S_KORAX_CHASE8
    {HEXEN_SPR_KORX, 2, 3, A_KoraxStep2, HEXEN_S_KORAX_CHASE0, 0, 0},       // HEXEN_S_KORAX_CHASE9
    {HEXEN_SPR_KORX, 2, 3, A_KoraxChase, HEXEN_S_KORAX_CHASEA, 0, 0},       // HEXEN_S_KORAX_CHASE0
    {HEXEN_SPR_KORX, 2, 3, A_KoraxChase, HEXEN_S_KORAX_CHASEB, 0, 0},       // HEXEN_S_KORAX_CHASEA
    {HEXEN_SPR_KORX, 2, 3, A_KoraxChase, HEXEN_S_KORAX_CHASEC, 0, 0},       // HEXEN_S_KORAX_CHASEB
    {HEXEN_SPR_KORX, 3, 3, A_KoraxStep, HEXEN_S_KORAX_CHASED, 0, 0},        // HEXEN_S_KORAX_CHASEC
    {HEXEN_SPR_KORX, 3, 3, A_KoraxChase, HEXEN_S_KORAX_CHASEE, 0, 0},       // HEXEN_S_KORAX_CHASED
    {HEXEN_SPR_KORX, 3, 3, A_KoraxChase, HEXEN_S_KORAX_CHASEF, 0, 0},       // HEXEN_S_KORAX_CHASEE
    {HEXEN_SPR_KORX, 3, 3, A_KoraxChase, HEXEN_S_KORAX_CHASE1, 0, 0},       // HEXEN_S_KORAX_CHASEF
    {HEXEN_SPR_KORX, 7, 5, A_Pain, HEXEN_S_KORAX_PAIN2, 0, 0},      // HEXEN_S_KORAX_PAIN1
    {HEXEN_SPR_KORX, 7, 5, NULL, HEXEN_S_KORAX_CHASE2, 0, 0},       // HEXEN_S_KORAX_PAIN2
    {HEXEN_SPR_KORX, 32772, 2, A_FaceTarget, HEXEN_S_KORAX_ATTACK2, 0, 0},  // HEXEN_S_KORAX_ATTACK1
    {HEXEN_SPR_KORX, 32772, 5, A_KoraxDecide, HEXEN_S_KORAX_ATTACK2, 0, 0}, // HEXEN_S_KORAX_ATTACK2
    {HEXEN_SPR_KORX, 32772, 4, A_FaceTarget, HEXEN_S_KORAX_MISSILE2, 0, 0}, // HEXEN_S_KORAX_MISSILE1
    {HEXEN_SPR_KORX, 32773, 8, A_KoraxMissile, HEXEN_S_KORAX_MISSILE3, 0, 0},       // HEXEN_S_KORAX_MISSILE2
    {HEXEN_SPR_KORX, 32772, 8, NULL, HEXEN_S_KORAX_CHASE2, 0, 0},   // HEXEN_S_KORAX_MISSILE3
    {HEXEN_SPR_KORX, 32772, 5, A_FaceTarget, HEXEN_S_KORAX_COMMAND2, 0, 0}, // HEXEN_S_KORAX_COMMAND1
    {HEXEN_SPR_KORX, 32790, 10, A_FaceTarget, HEXEN_S_KORAX_COMMAND3, 0, 0},        // HEXEN_S_KORAX_COMMAND2
    {HEXEN_SPR_KORX, 32774, 15, A_KoraxCommand, HEXEN_S_KORAX_COMMAND4, 0, 0},      // HEXEN_S_KORAX_COMMAND3
    {HEXEN_SPR_KORX, 32790, 10, NULL, HEXEN_S_KORAX_COMMAND5, 0, 0},        // HEXEN_S_KORAX_COMMAND4
    {HEXEN_SPR_KORX, 32772, 5, NULL, HEXEN_S_KORAX_CHASE2, 0, 0},   // HEXEN_S_KORAX_COMMAND5
    {HEXEN_SPR_KORX, 8, 5, NULL, HEXEN_S_KORAX_DEATH2, 0, 0},       // HEXEN_S_KORAX_DEATH1
    {HEXEN_SPR_KORX, 9, 5, A_FaceTarget, HEXEN_S_KORAX_DEATH3, 0, 0},       // HEXEN_S_KORAX_DEATH2
    {HEXEN_SPR_KORX, 10, 5, A_Scream, HEXEN_S_KORAX_DEATH4, 0, 0},  // HEXEN_S_KORAX_DEATH3
    {HEXEN_SPR_KORX, 11, 5, NULL, HEXEN_S_KORAX_DEATH5, 0, 0},      // HEXEN_S_KORAX_DEATH4
    {HEXEN_SPR_KORX, 12, 5, NULL, HEXEN_S_KORAX_DEATH6, 0, 0},      // HEXEN_S_KORAX_DEATH5
    {HEXEN_SPR_KORX, 13, 5, NULL, HEXEN_S_KORAX_DEATH7, 0, 0},      // HEXEN_S_KORAX_DEATH6
    {HEXEN_SPR_KORX, 14, 5, NULL, HEXEN_S_KORAX_DEATH8, 0, 0},      // HEXEN_S_KORAX_DEATH7
    {HEXEN_SPR_KORX, 15, 5, NULL, HEXEN_S_KORAX_DEATH9, 0, 0},      // HEXEN_S_KORAX_DEATH8
    {HEXEN_SPR_KORX, 16, 10, NULL, HEXEN_S_KORAX_DEATH0, 0, 0},     // HEXEN_S_KORAX_DEATH9
    {HEXEN_SPR_KORX, 17, 5, A_KoraxBonePop, HEXEN_S_KORAX_DEATHA, 0, 0},    // HEXEN_S_KORAX_DEATH0
    {HEXEN_SPR_KORX, 18, 5, A_NoBlocking, HEXEN_S_KORAX_DEATHB, 0, 0},      // HEXEN_S_KORAX_DEATHA
    {HEXEN_SPR_KORX, 19, 5, NULL, HEXEN_S_KORAX_DEATHC, 0, 0},      // HEXEN_S_KORAX_DEATHB
    {HEXEN_SPR_KORX, 20, 5, NULL, HEXEN_S_KORAX_DEATHD, 0, 0},      // HEXEN_S_KORAX_DEATHC
    {HEXEN_SPR_KORX, 21, -1, NULL, HEXEN_S_NULL, 0, 0},     // HEXEN_S_KORAX_DEATHD
    {HEXEN_SPR_SPIR, 0, 5, A_KSpiritRoam, HEXEN_S_KSPIRIT_ROAM2, 0, 0},     // HEXEN_S_KSPIRIT_ROAM1
    {HEXEN_SPR_SPIR, 1, 5, A_KSpiritRoam, HEXEN_S_KSPIRIT_ROAM1, 0, 0},     // HEXEN_S_KSPIRIT_ROAM2
    {HEXEN_SPR_SPIR, 3, 5, NULL, HEXEN_S_KSPIRIT_DEATH2, 0, 0},     // HEXEN_S_KSPIRIT_DEATH1
    {HEXEN_SPR_SPIR, 4, 5, NULL, HEXEN_S_KSPIRIT_DEATH3, 0, 0},     // HEXEN_S_KSPIRIT_DEATH2
    {HEXEN_SPR_SPIR, 5, 5, NULL, HEXEN_S_KSPIRIT_DEATH4, 0, 0},     // HEXEN_S_KSPIRIT_DEATH3
    {HEXEN_SPR_SPIR, 6, 5, NULL, HEXEN_S_KSPIRIT_DEATH5, 0, 0},     // HEXEN_S_KSPIRIT_DEATH4
    {HEXEN_SPR_SPIR, 7, 5, NULL, HEXEN_S_KSPIRIT_DEATH6, 0, 0},     // HEXEN_S_KSPIRIT_DEATH5
    {HEXEN_SPR_SPIR, 8, 5, NULL, HEXEN_S_NULL, 0, 0},       // HEXEN_S_KSPIRIT_DEATH6
    {HEXEN_SPR_MLFX, 32776, 2, NULL, HEXEN_S_KBOLT2, 0, 0}, // HEXEN_S_KBOLT1
    {HEXEN_SPR_MLFX, 32777, 2, A_KBoltRaise, HEXEN_S_KBOLT3, 0, 0}, // HEXEN_S_KBOLT2
    {HEXEN_SPR_MLFX, 32776, 2, A_KBolt, HEXEN_S_KBOLT4, 0, 0},      // HEXEN_S_KBOLT3
    {HEXEN_SPR_MLFX, 32777, 2, A_KBolt, HEXEN_S_KBOLT5, 0, 0},      // HEXEN_S_KBOLT4
    {HEXEN_SPR_MLFX, 32778, 2, A_KBolt, HEXEN_S_KBOLT6, 0, 0},      // HEXEN_S_KBOLT5
    {HEXEN_SPR_MLFX, 32779, 2, A_KBolt, HEXEN_S_KBOLT7, 0, 0},      // HEXEN_S_KBOLT6
    {HEXEN_SPR_MLFX, 32780, 2, A_KBolt, HEXEN_S_KBOLT3, 0, 0},      // HEXEN_S_KBOLT7
    {HEXEN_SPR_MAN1, 0, 2, NULL, HEXEN_S_SPAWNBATS2, 0, 0}, // HEXEN_S_SPAWNBATS1
    {HEXEN_SPR_MAN1, 0, 2, A_BatSpawnInit, HEXEN_S_SPAWNBATS3, 0, 0},       // HEXEN_S_SPAWNBATS2
    {HEXEN_SPR_MAN1, 0, 2, A_BatSpawn, HEXEN_S_SPAWNBATS3, 0, 0},   // HEXEN_S_SPAWNBATS3
    {HEXEN_SPR_MAN1, 0, -1, NULL, HEXEN_S_NULL, 0, 0},      // HEXEN_S_SPAWNBATS_OFF
    {HEXEN_SPR_ABAT, 0, 2, A_BatMove, HEXEN_S_BAT2, 0, 0},  // HEXEN_S_BAT1
    {HEXEN_SPR_ABAT, 1, 2, A_BatMove, HEXEN_S_BAT3, 0, 0},  // HEXEN_S_BAT2
    {HEXEN_SPR_ABAT, 2, 2, A_BatMove, HEXEN_S_BAT1, 0, 0},  // HEXEN_S_BAT3
    {HEXEN_SPR_ABAT, 0, 2, NULL, HEXEN_S_NULL, 0, 0}        // HEXEN_S_BAT_DEATH
};


raven_mobjinfo_t hexen_mobjinfo[HEXEN_NUMMOBJTYPES] = {

    {                           // HEXEN_MT_MAPSPOT
     9001,                      // doomednum
     HEXEN_S_MAPSPOT,                 // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOSECTOR | MF_NOGRAVITY,        // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MAPSPOTGRAVITY
     9013,                      // doomednum
     HEXEN_S_MAPSPOT,                 // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     0,                         // flags
     MF2_DONTDRAW               // flags2
     },

    {                           // HEXEN_MT_FIREBALL1
     -1,                        // doomednum
     HEXEN_S_FIREBALL1_1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_FIREBALL1_X1,            // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_fireball,              // deathsound
     2 * FRACUNIT,              // speed
     8 * FRACUNIT,              // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     4,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_FIREDAMAGE    // flags2
     },

    {                           // HEXEN_MT_ARROW
     -1,                        // doomednum
     HEXEN_S_ARROW_1,                 // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_ARROW_X1,                // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     6 * FRACUNIT,              // speed
     8 * FRACUNIT,              // radius
     4 * FRACUNIT,              // height
     100,                       // mass
     4,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_DART
     -1,                        // doomednum
     HEXEN_S_DART_1,                  // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_DART_X1,                 // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     6 * FRACUNIT,              // speed
     8 * FRACUNIT,              // radius
     4 * FRACUNIT,              // height
     100,                       // mass
     2,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_POISONDART
     -1,                        // doomednum
     HEXEN_S_POISONDART_1,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_POISONDART_X1,           // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     6 * FRACUNIT,              // speed
     8 * FRACUNIT,              // radius
     4 * FRACUNIT,              // height
     100,                       // mass
     2,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_RIPPERBALL
     -1,                        // doomednum
     HEXEN_S_RIPPERBALL_1,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_RIPPERBALL_X1,           // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     6 * FRACUNIT,              // speed
     8 * FRACUNIT,              // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     2,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_RIP   // flags2
     },

    {                           // HEXEN_MT_PROJECTILE_BLADE
     -1,                        // doomednum
     HEXEN_S_PRJ_BLADE1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_PRJ_BLADE_X1,            // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     6 * FRACUNIT,              // speed
     6 * FRACUNIT,              // radius
     6 * FRACUNIT,              // height
     100,                       // mass
     3,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_ICESHARD
     -1,                        // doomednum
     HEXEN_S_ICESHARD1,               // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_SHARDFXE1_1,             // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_mage_shards_explode,   // deathsound
     25 * FRACUNIT,             // speed
     13 * FRACUNIT,             // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     1,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_ICEDAMAGE     // flags2
     },

    {                           // HEXEN_MT_FLAME_SMALL_TEMP
     10500,                     // doomednum
     HEXEN_S_FLAME_TSMALL1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     0,                         // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_FLAME_LARGE_TEMP
     10502,                     // doomednum
     HEXEN_S_FLAME_TLARGE1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     0,                         // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_FLAME_SMALL
     10501,                     // doomednum
     HEXEN_S_FLAME_SMALL1,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     0,                         // flags
     MF2_NOTELEPORT | MF2_DONTDRAW      // flags2
     },

    {                           // HEXEN_MT_FLAME_LARGE
     10503,                     // doomednum
     HEXEN_S_FLAME_LARGE1,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     0,                         // flags
     MF2_NOTELEPORT | MF2_DONTDRAW      // flags2
     },

    {                           // HEXEN_MT_HEALINGBOTTLE
     81,                        // doomednum
     HEXEN_S_ITEM_PTN1_1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     MF2_FLOATBOB               // flags2
     },

    {                           // HEXEN_MT_HEALTHFLASK
     82,                        // doomednum
     HEXEN_S_ARTI_PTN2_1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     MF2_FLOATBOB               // flags2
     },

    {                           // HEXEN_MT_ARTIFLY
     83,                        // doomednum
     HEXEN_S_ARTI_SOAR1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     MF2_FLOATBOB               // flags2
     },

    {                           // HEXEN_MT_ARTIINVULNERABILITY
     84,                        // doomednum
     HEXEN_S_ARTI_INVU1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     MF2_FLOATBOB               // flags2
     },

    {                           // HEXEN_MT_SUMMONMAULATOR
     86,                        // doomednum
     HEXEN_S_ARTI_SUMMON,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     MF2_FLOATBOB               // flags2
     },

    {                           // HEXEN_MT_SUMMON_FX
     -1,                        // doomednum
     HEXEN_S_SUMMON_FX1_1,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_SUMMON_FX2_1,            // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     20 * FRACUNIT,             // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_MISSILE | MF_DROPOFF | MF_NOBLOCKMAP,   // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_THRUSTFLOOR_UP
     10091,                     // doomednum
     HEXEN_S_THRUSTINIT2_1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     128 * FRACUNIT,            // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     MF2_NOTELEPORT | MF2_FOOTCLIP     // flags2
     },

    {                           // HEXEN_MT_THRUSTFLOOR_DOWN
     10090,                     // doomednum
     HEXEN_S_THRUSTINIT1_1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     128 * FRACUNIT,            // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     0,                         // flags
     MF2_NOTELEPORT | MF2_FOOTCLIP | MF2_DONTDRAW      // flags2
     },

    {                           // HEXEN_MT_TELEPORTOTHER
     10040,                     // doomednum
     HEXEN_S_ARTI_TELOTHER1,          // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     MF2_FLOATBOB               // flags2
     },

    {                           // HEXEN_MT_TELOTHER_FX1
     -1,                        // doomednum
     HEXEN_S_TELO_FX1,                // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_TELO_FX9,                // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     20 * FRACUNIT,             // speed
     16 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     10001,                     // damage
     hexen_sfx_None,                  // activesound
     MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY | MF_NOBLOCKMAP,    // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_TELOTHER_FX2
     -1,                        // doomednum
     HEXEN_S_TELO_FX2_1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_TELO_FX9,                // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     16 * FRACUNIT,             // speed
     16 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     10001,                     // damage
     hexen_sfx_None,                  // activesound
     MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY | MF_NOBLOCKMAP,    // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_TELOTHER_FX3
     -1,                        // doomednum
     HEXEN_S_TELO_FX3_1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_TELO_FX9,                // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     16 * FRACUNIT,             // speed
     16 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     10001,                     // damage
     hexen_sfx_None,                  // activesound
     MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY | MF_NOBLOCKMAP,    // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_TELOTHER_FX4
     -1,                        // doomednum
     HEXEN_S_TELO_FX4_1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_TELO_FX9,                // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     16 * FRACUNIT,             // speed
     16 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     10001,                     // damage
     hexen_sfx_None,                  // activesound
     MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY | MF_NOBLOCKMAP,    // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_TELOTHER_FX5
     -1,                        // doomednum
     HEXEN_S_TELO_FX5_1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_TELO_FX9,                // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     16 * FRACUNIT,             // speed
     16 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     10001,                     // damage
     hexen_sfx_None,                  // activesound
     MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY | MF_NOBLOCKMAP,    // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_DIRT1
     -1,                        // doomednum
     HEXEN_S_DIRT1_1,                 // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_DIRT1_D,                 // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_MISSILE,   // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_DIRT2
     -1,                        // doomednum
     HEXEN_S_DIRT2_1,                 // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_DIRT2_D,                 // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_MISSILE,   // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_DIRT3
     -1,                        // doomednum
     HEXEN_S_DIRT3_1,                 // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_DIRT3_D,                 // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_MISSILE,   // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_DIRT4
     -1,                        // doomednum
     HEXEN_S_DIRT4_1,                 // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_DIRT4_D,                 // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_MISSILE,   // flags
     MF2_NOTELEPORT | MF2_LOGRAV        // flags2
     },

    {                           // HEXEN_MT_DIRT5
     -1,                        // doomednum
     HEXEN_S_DIRT5_1,                 // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_DIRT5_D,                 // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_MISSILE,   // flags
     MF2_NOTELEPORT | MF2_LOGRAV        // flags2
     },

    {                           // HEXEN_MT_DIRT6
     -1,                        // doomednum
     HEXEN_S_DIRT6_1,                 // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_DIRT6_D,                 // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_MISSILE,   // flags
     MF2_NOTELEPORT | MF2_LOGRAV        // flags2
     },

    {                           // HEXEN_MT_DIRTCLUMP
     -1,                        // doomednum
     HEXEN_S_DIRTCLUMP1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP,             // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_ROCK1
     -1,                        // doomednum
     HEXEN_S_ROCK1_1,                 // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_ROCK1_D,                 // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_MISSILE,   // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_ROCK2
     -1,                        // doomednum
     HEXEN_S_ROCK2_1,                 // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_ROCK2_D,                 // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_MISSILE,   // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_ROCK3
     -1,                        // doomednum
     HEXEN_S_ROCK3_1,                 // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_ROCK3_D,                 // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_MISSILE,   // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_FOGSPAWNER
     10000,                     // doomednum
     HEXEN_S_SPAWNFOG1,               // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOSECTOR,       // flags
     MF2_DONTDRAW | MF2_FLOATBOB        // flags2
     },

    {                           // HEXEN_MT_FOGPATCHS
     10001,                     // doomednum
     HEXEN_S_FOGPATCHS1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_FOGPATCHS0,              // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     FRACUNIT,                  // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_FLOAT | MF_NOGRAVITY | MF_SHADOW | MF_NOCLIP,   // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_FOGPATCHM
     10002,                     // doomednum
     HEXEN_S_FOGPATCHM1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_FOGPATCHM0,              // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     FRACUNIT,                  // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_FLOAT | MF_NOGRAVITY | MF_SHADOW | MF_NOCLIP,   // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_FOGPATCHL
     10003,                     // doomednum
     HEXEN_S_FOGPATCHL1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_FOGPATCHL0,              // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     FRACUNIT,                  // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_FLOAT | MF_NOGRAVITY | MF_SHADOW | MF_NOCLIP,   // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_QUAKE_FOCUS
     -1,                        // doomednum
     HEXEN_S_QUAKE_ACTIVE1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOSECTOR,       // flags
     MF2_DONTDRAW               // flags2
     },

    {                           // HEXEN_MT_SGSHARD1
     -1,                        // doomednum
     HEXEN_S_SGSHARD1_1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_SGSHARD1_D,              // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     5 * FRACUNIT,              // radius
     16 * FRACUNIT,             // height
     5,                         // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_MISSILE | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_FLOORBOUNCE   // flags2
     },

    {                           // HEXEN_MT_SGSHARD2
     -1,                        // doomednum
     HEXEN_S_SGSHARD2_1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_SGSHARD2_D,              // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     5 * FRACUNIT,              // radius
     16 * FRACUNIT,             // height
     5,                         // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_MISSILE | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_FLOORBOUNCE   // flags2
     },

    {                           // HEXEN_MT_SGSHARD3
     -1,                        // doomednum
     HEXEN_S_SGSHARD3_1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_SGSHARD3_D,              // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     5 * FRACUNIT,              // radius
     16 * FRACUNIT,             // height
     5,                         // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_MISSILE | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_FLOORBOUNCE   // flags2
     },

    {                           // HEXEN_MT_SGSHARD4
     -1,                        // doomednum
     HEXEN_S_SGSHARD4_1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_SGSHARD4_D,              // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     5 * FRACUNIT,              // radius
     16 * FRACUNIT,             // height
     5,                         // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_MISSILE | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_FLOORBOUNCE   // flags2
     },

    {                           // HEXEN_MT_SGSHARD5
     -1,                        // doomednum
     HEXEN_S_SGSHARD5_1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_SGSHARD5_D,              // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     5 * FRACUNIT,              // radius
     16 * FRACUNIT,             // height
     5,                         // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_MISSILE | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_FLOORBOUNCE   // flags2
     },

    {                           // HEXEN_MT_SGSHARD6
     -1,                        // doomednum
     HEXEN_S_SGSHARD6_1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_SGSHARD6_D,              // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     5 * FRACUNIT,              // radius
     16 * FRACUNIT,             // height
     5,                         // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_MISSILE | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_FLOORBOUNCE   // flags2
     },

    {                           // HEXEN_MT_SGSHARD7
     -1,                        // doomednum
     HEXEN_S_SGSHARD7_1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_SGSHARD7_D,              // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     5 * FRACUNIT,              // radius
     16 * FRACUNIT,             // height
     5,                         // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_MISSILE | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_FLOORBOUNCE   // flags2
     },

    {                           // HEXEN_MT_SGSHARD8
     -1,                        // doomednum
     HEXEN_S_SGSHARD8_1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_SGSHARD8_D,              // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     5 * FRACUNIT,              // radius
     16 * FRACUNIT,             // height
     5,                         // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_MISSILE | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_FLOORBOUNCE   // flags2
     },

    {                           // HEXEN_MT_SGSHARD9
     -1,                        // doomednum
     HEXEN_S_SGSHARD9_1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_SGSHARD9_D,              // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     5 * FRACUNIT,              // radius
     16 * FRACUNIT,             // height
     5,                         // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_MISSILE | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_FLOORBOUNCE   // flags2
     },

    {                           // HEXEN_MT_SGSHARD0
     -1,                        // doomednum
     HEXEN_S_SGSHARD0_1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_SGSHARD0_D,              // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     5 * FRACUNIT,              // radius
     16 * FRACUNIT,             // height
     5,                         // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_MISSILE | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_FLOORBOUNCE   // flags2
     },

    {                           // HEXEN_MT_ARTIEGG
     30,                        // doomednum
     HEXEN_S_ARTI_EGGC1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     MF2_FLOATBOB               // flags2
     },

    {                           // HEXEN_MT_EGGFX
     -1,                        // doomednum
     HEXEN_S_EGGFX1,                  // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     0,                         // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_EGGFXI1_1,               // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     0,                         // deathsound
     18 * FRACUNIT,             // speed
     8 * FRACUNIT,              // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     1,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_ARTISUPERHEAL
     32,                        // doomednum
     HEXEN_S_ARTI_SPHL1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     MF2_FLOATBOB               // flags2
     },

    {                           // HEXEN_MT_ZWINGEDSTATUENOSKULL
     9011,                      // doomednum
     HEXEN_S_ZWINGEDSTATUENOSKULL,    // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     10 * FRACUNIT,             // radius
     62 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ZGEMPEDESTAL
     9012,                      // doomednum
     HEXEN_S_ZGEMPEDESTAL1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     10 * FRACUNIT,             // radius
     40 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ARTIPUZZSKULL
     9002,                      // doomednum
     HEXEN_S_ARTIPUZZSKULL,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ARTIPUZZGEMBIG
     9003,                      // doomednum
     HEXEN_S_ARTIPUZZGEMBIG,          // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ARTIPUZZGEMRED
     9004,                      // doomednum
     HEXEN_S_ARTIPUZZGEMRED,          // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ARTIPUZZGEMGREEN1
     9005,                      // doomednum
     HEXEN_S_ARTIPUZZGEMGREEN1,       // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ARTIPUZZGEMGREEN2
     9009,                      // doomednum
     HEXEN_S_ARTIPUZZGEMGREEN2,       // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ARTIPUZZGEMBLUE1
     9006,                      // doomednum
     HEXEN_S_ARTIPUZZGEMBLUE1,        // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ARTIPUZZGEMBLUE2
     9010,                      // doomednum
     HEXEN_S_ARTIPUZZGEMBLUE2,        // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ARTIPUZZBOOK1
     9007,                      // doomednum
     HEXEN_S_ARTIPUZZBOOK1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ARTIPUZZBOOK2
     9008,                      // doomednum
     HEXEN_S_ARTIPUZZBOOK2,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ARTIPUZZSKULL2
     9014,                      // doomednum
     HEXEN_S_ARTIPUZZSKULL2,          // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ARTIPUZZFWEAPON
     9015,                      // doomednum
     HEXEN_S_ARTIPUZZFWEAPON,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ARTIPUZZCWEAPON
     9016,                      // doomednum
     HEXEN_S_ARTIPUZZCWEAPON,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ARTIPUZZMWEAPON
     9017,                      // doomednum
     HEXEN_S_ARTIPUZZMWEAPON,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ARTIPUZZGEAR
     9018,                      // doomednum
     HEXEN_S_ARTIPUZZGEAR_1,          // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ARTIPUZZGEAR2
     9019,                      // doomednum
     HEXEN_S_ARTIPUZZGEAR2_1,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ARTIPUZZGEAR3
     9020,                      // doomednum
     HEXEN_S_ARTIPUZZGEAR3_1,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ARTIPUZZGEAR4
     9021,                      // doomednum
     HEXEN_S_ARTIPUZZGEAR4_1,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ARTITORCH
     33,                        // doomednum
     HEXEN_S_ARTI_TRCH1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     MF2_FLOATBOB               // flags2
     },

    {                           // HEXEN_MT_FIREBOMB
     -1,                        // doomednum
     HEXEN_S_FIREBOMB1,               // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_flechette_explode,     // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOGRAVITY | MF_ALTSHADOW,       // flags
     MF2_FIREDAMAGE             // flags2
     },

    {                           // HEXEN_MT_ARTITELEPORT
     36,                        // doomednum
     HEXEN_S_ARTI_ATLP1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     MF2_FLOATBOB               // flags2
     },

    {                           // HEXEN_MT_ARTIPOISONBAG
     8000,                      // doomednum
     HEXEN_S_ARTI_PSBG1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     MF2_FLOATBOB               // flags2
     },

    {                           // HEXEN_MT_POISONBAG
     -1,                        // doomednum
     HEXEN_S_POISONBAG1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     5 * FRACUNIT,              // radius
     5 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOGRAVITY | MF_NOBLOCKMAP,      // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_POISONCLOUD
     -1,                        // doomednum
     HEXEN_S_POISONCLOUD1,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_poisonshroom_death,    // deathsound
     0,                         // speed
     1,                         // radius
     1,                         // height
     INT_MAX,                    // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOGRAVITY | MF_NOBLOCKMAP | MF_SHADOW | MF_NOCLIP | MF_DROPOFF, // flags
     MF2_NODMGTHRUST            // flags2
     },

    {                           // HEXEN_MT_THROWINGBOMB
     -1,                        // doomednum
     HEXEN_S_THROWINGBOMB1,           // spawnstate
     48,                        // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_flechette_bounce,      // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_THROWINGBOMB_X1,         // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_flechette_explode,     // deathsound
     12 * FRACUNIT,             // speed
     8 * FRACUNIT,              // radius
     10 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_MISSILE,   // flags
     MF2_FLOORBOUNCE | MF2_FIREDAMAGE   // flags2
     },

    {                           // HEXEN_MT_SPEEDBOOTS
     8002,                      // doomednum
     HEXEN_S_ARTI_BOOTS1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     MF2_FLOATBOB               // flags2
     },

    {                           // HEXEN_MT_BOOSTMANA
     8003,                      // doomednum
     HEXEN_S_ARTI_MANA,               // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     MF2_FLOATBOB               // flags2
     },

    {                           // HEXEN_MT_BOOSTARMOR
     8041,                      // doomednum
     HEXEN_S_ARTI_ARMOR1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     MF2_FLOATBOB               // flags2
     },

    {                           // HEXEN_MT_BLASTRADIUS
     10110,                     // doomednum
     HEXEN_S_ARTI_BLAST1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     MF2_FLOATBOB               // flags2
     },

    {                           // HEXEN_MT_HEALRADIUS
     10120,                     // doomednum
     HEXEN_S_ARTI_HEALRAD1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     MF2_FLOATBOB               // flags2
     },

    {                           // HEXEN_MT_SPLASH
     -1,                        // doomednum
     HEXEN_S_SPLASH1,                 // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_SPLASHX,                 // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     2 * FRACUNIT,              // radius
     4 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF,   // flags
     MF2_NOTELEPORT | MF2_LOGRAV | MF2_CANNOTPUSH       // flags2
     },

    {                           // HEXEN_MT_SPLASHBASE
     -1,                        // doomednum
     HEXEN_S_SPLASHBASE1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP,             // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_LAVASPLASH
     -1,                        // doomednum
     HEXEN_S_LAVASPLASH1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP,             // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_LAVASMOKE
     -1,                        // doomednum
     HEXEN_S_LAVASMOKE1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_SHADOW,  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_SLUDGECHUNK
     -1,                        // doomednum
     HEXEN_S_SLUDGECHUNK1,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_SLUDGECHUNKX,            // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     2 * FRACUNIT,              // radius
     4 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF,   // flags
     MF2_NOTELEPORT | MF2_LOGRAV | MF2_CANNOTPUSH       // flags2
     },

    {                           // HEXEN_MT_SLUDGESPLASH
     -1,                        // doomednum
     HEXEN_S_SLUDGESPLASH1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP,             // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC0
     5,                         // doomednum
     HEXEN_S_ZWINGEDSTATUE1,          // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     10 * FRACUNIT,             // radius
     62 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC1
     6,                         // doomednum
     HEXEN_S_ZROCK1_1,                // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     0,                         // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC2
     7,                         // doomednum
     HEXEN_S_ZROCK2_1,                // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     0,                         // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC3
     9,                         // doomednum
     HEXEN_S_ZROCK3_1,                // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     0,                         // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC4
     15,                        // doomednum
     HEXEN_S_ZROCK4_1,                // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC5
     17,                        // doomednum
     HEXEN_S_ZCHANDELIER1,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     60 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPAWNCEILING | MF_NOGRAVITY,    // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC6
     8063,                      // doomednum
     HEXEN_S_ZCHANDELIER_U,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     60 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPAWNCEILING | MF_NOGRAVITY,    // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC7
     24,                        // doomednum
     HEXEN_S_ZTREEDEAD1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     10 * FRACUNIT,             // radius
     96 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC8
     25,                        // doomednum
     HEXEN_S_ZTREE,                   // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     15 * FRACUNIT,             // radius
     128 * FRACUNIT,            // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_TREEDESTRUCTIBLE
     8062,                      // doomednum
     HEXEN_S_ZTREEDESTRUCTIBLE1,      // spawnstate
     70,                        // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_ZTREEDES_D1,             // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_tree_break,            // deathsound
     0,                         // speed
     15 * FRACUNIT,             // radius
     180 * FRACUNIT,            // height
     INT_MAX,                    // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_SHOOTABLE | MF_NOBLOOD,      // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC9
     26,                        // doomednum
     HEXEN_S_ZTREESWAMP182_1,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     10 * FRACUNIT,             // radius
     150 * FRACUNIT,            // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC10
     27,                        // doomednum
     HEXEN_S_ZTREESWAMP172_1,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     10 * FRACUNIT,             // radius
     120 * FRACUNIT,            // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC11
     28,                        // doomednum
     HEXEN_S_ZSTUMPBURNED1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     12 * FRACUNIT,             // radius
     20 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC12
     29,                        // doomednum
     HEXEN_S_ZSTUMPBARE1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     12 * FRACUNIT,             // radius
     20 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC13
     37,                        // doomednum
     HEXEN_S_ZSTUMPSWAMP1_1,          // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     0,                         // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC14
     38,                        // doomednum
     HEXEN_S_ZSTUMPSWAMP2_1,          // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     0,                         // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC15
     39,                        // doomednum
     HEXEN_S_ZSHROOMLARGE1_1,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     0,                         // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC16
     40,                        // doomednum
     HEXEN_S_ZSHROOMLARGE2_1,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     0,                         // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC17
     41,                        // doomednum
     HEXEN_S_ZSHROOMLARGE3_1,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     0,                         // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC18
     42,                        // doomednum
     HEXEN_S_ZSHROOMSMALL1_1,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     0,                         // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC19
     44,                        // doomednum
     HEXEN_S_ZSHROOMSMALL2_1,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     0,                         // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC20
     45,                        // doomednum
     HEXEN_S_ZSHROOMSMALL3_1,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     0,                         // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC21
     46,                        // doomednum
     HEXEN_S_ZSHROOMSMALL4_1,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     0,                         // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC22
     47,                        // doomednum
     HEXEN_S_ZSHROOMSMALL5_1,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     0,                         // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC23
     48,                        // doomednum
     HEXEN_S_ZSTALAGMITEPILLAR1,      // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     8 * FRACUNIT,              // radius
     138 * FRACUNIT,            // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC24
     49,                        // doomednum
     HEXEN_S_ZSTALAGMITELARGE1,       // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     8 * FRACUNIT,              // radius
     48 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC25
     50,                        // doomednum
     HEXEN_S_ZSTALAGMITEMEDIUM1,      // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     6 * FRACUNIT,              // radius
     40 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC26
     51,                        // doomednum
     HEXEN_S_ZSTALAGMITESMALL1,       // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     8 * FRACUNIT,              // radius
     36 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC27
     52,                        // doomednum
     HEXEN_S_ZSTALACTITELARGE1,       // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     8 * FRACUNIT,              // radius
     66 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_SPAWNCEILING | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC28
     56,                        // doomednum
     HEXEN_S_ZSTALACTITEMEDIUM1,      // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     6 * FRACUNIT,              // radius
     50 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_SPAWNCEILING | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC29
     57,                        // doomednum
     HEXEN_S_ZSTALACTITESMALL1,       // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     8 * FRACUNIT,              // radius
     40 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_SPAWNCEILING | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC30
     58,                        // doomednum
     HEXEN_S_ZMOSSCEILING1_1,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     20 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPAWNCEILING | MF_NOGRAVITY,    // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC31
     59,                        // doomednum
     HEXEN_S_ZMOSSCEILING2_1,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     24 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPAWNCEILING | MF_NOGRAVITY,    // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC32
     60,                        // doomednum
     HEXEN_S_ZSWAMPVINE1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     8 * FRACUNIT,              // radius
     52 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC33
     61,                        // doomednum
     HEXEN_S_ZCORPSEKABOB1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     10 * FRACUNIT,             // radius
     92 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC34
     62,                        // doomednum
     HEXEN_S_ZCORPSESLEEPING1,        // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     0,                         // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC35
     63,                        // doomednum
     HEXEN_S_ZTOMBSTONERIP1,          // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     10 * FRACUNIT,             // radius
     46 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC36
     64,                        // doomednum
     HEXEN_S_ZTOMBSTONESHANE1,        // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     10 * FRACUNIT,             // radius
     46 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC37
     65,                        // doomednum
     HEXEN_S_ZTOMBSTONEBIGCROSS1,     // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     10 * FRACUNIT,             // radius
     46 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC38
     66,                        // doomednum
     HEXEN_S_ZTOMBSTONEBRIANR1,       // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     10 * FRACUNIT,             // radius
     52 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC39
     67,                        // doomednum
     HEXEN_S_ZTOMBSTONECROSSCIRCLE1,  // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     10 * FRACUNIT,             // radius
     52 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC40
     68,                        // doomednum
     HEXEN_S_ZTOMBSTONESMALLCROSS1,   // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     8 * FRACUNIT,              // radius
     46 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC41
     69,                        // doomednum
     HEXEN_S_ZTOMBSTONEBRIANP1,       // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     8 * FRACUNIT,              // radius
     46 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC42
     71,                        // doomednum
     HEXEN_S_CORPSEHANGING_1,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     6 * FRACUNIT,              // radius
     75 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_SPAWNCEILING | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC43
     72,                        // doomednum
     HEXEN_S_ZSTATUEGARGOYLEGREENTALL_1,      // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     14 * FRACUNIT,             // radius
     108 * FRACUNIT,            // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC44
     73,                        // doomednum
     HEXEN_S_ZSTATUEGARGOYLEBLUETALL_1,       // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     14 * FRACUNIT,             // radius
     108 * FRACUNIT,            // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC45
     74,                        // doomednum
     HEXEN_S_ZSTATUEGARGOYLEGREENSHORT_1,     // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     14 * FRACUNIT,             // radius
     62 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC46
     76,                        // doomednum
     HEXEN_S_ZSTATUEGARGOYLEBLUESHORT_1,      // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     14 * FRACUNIT,             // radius
     62 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC47
     8044,                      // doomednum
     HEXEN_S_ZSTATUEGARGOYLESTRIPETALL_1,     // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     14 * FRACUNIT,             // radius
     108 * FRACUNIT,            // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC48
     8045,                      // doomednum
     HEXEN_S_ZSTATUEGARGOYLEDARKREDTALL_1,    // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     14 * FRACUNIT,             // radius
     108 * FRACUNIT,            // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC49
     8046,                      // doomednum
     HEXEN_S_ZSTATUEGARGOYLEREDTALL_1,        // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     14 * FRACUNIT,             // radius
     108 * FRACUNIT,            // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC50
     8047,                      // doomednum
     HEXEN_S_ZSTATUEGARGOYLETANTALL_1,        // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     14 * FRACUNIT,             // radius
     108 * FRACUNIT,            // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC51
     8048,                      // doomednum
     HEXEN_S_ZSTATUEGARGOYLERUSTTALL_1,       // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     14 * FRACUNIT,             // radius
     108 * FRACUNIT,            // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC52
     8049,                      // doomednum
     HEXEN_S_ZSTATUEGARGOYLEDARKREDSHORT_1,   // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     14 * FRACUNIT,             // radius
     62 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC53
     8050,                      // doomednum
     HEXEN_S_ZSTATUEGARGOYLEREDSHORT_1,       // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     14 * FRACUNIT,             // radius
     62 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC54
     8051,                      // doomednum
     HEXEN_S_ZSTATUEGARGOYLETANSHORT_1,       // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     14 * FRACUNIT,             // radius
     62 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC55
     8052,                      // doomednum
     HEXEN_S_ZSTATUEGARGOYLERUSTSHORT_1,      // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     14 * FRACUNIT,             // radius
     62 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC56
     77,                        // doomednum
     HEXEN_S_ZBANNERTATTERED_1,       // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     8 * FRACUNIT,              // radius
     120 * FRACUNIT,            // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC57
     78,                        // doomednum
     HEXEN_S_ZTREELARGE1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_ZTREELARGE1,             // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     15 * FRACUNIT,             // radius
     180 * FRACUNIT,            // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC58
     79,                        // doomednum
     HEXEN_S_ZTREELARGE2,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_ZTREELARGE2,             // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     15 * FRACUNIT,             // radius
     180 * FRACUNIT,            // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC59
     80,                        // doomednum
     HEXEN_S_ZTREEGNARLED1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     22 * FRACUNIT,             // radius
     100 * FRACUNIT,            // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC60
     87,                        // doomednum
     HEXEN_S_ZTREEGNARLED2,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     22 * FRACUNIT,             // radius
     100 * FRACUNIT,            // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC61
     88,                        // doomednum
     HEXEN_S_ZLOG,                    // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     25 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC62
     89,                        // doomednum
     HEXEN_S_ZSTALACTITEICELARGE,     // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     8 * FRACUNIT,              // radius
     66 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_SPAWNCEILING | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC63
     90,                        // doomednum
     HEXEN_S_ZSTALACTITEICEMEDIUM,    // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     5 * FRACUNIT,              // radius
     50 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_SPAWNCEILING | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC64
     91,                        // doomednum
     HEXEN_S_ZSTALACTITEICESMALL,     // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     4 * FRACUNIT,              // radius
     32 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_SPAWNCEILING | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC65
     92,                        // doomednum
     HEXEN_S_ZSTALACTITEICETINY,      // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     4 * FRACUNIT,              // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_SPAWNCEILING | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC66
     93,                        // doomednum
     HEXEN_S_ZSTALAGMITEICELARGE,     // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     8 * FRACUNIT,              // radius
     66 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC67
     94,                        // doomednum
     HEXEN_S_ZSTALAGMITEICEMEDIUM,    // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     5 * FRACUNIT,              // radius
     50 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC68
     95,                        // doomednum
     HEXEN_S_ZSTALAGMITEICESMALL,     // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     4 * FRACUNIT,              // radius
     32 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC69
     96,                        // doomednum
     HEXEN_S_ZSTALAGMITEICETINY,      // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     4 * FRACUNIT,              // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC70
     97,                        // doomednum
     HEXEN_S_ZROCKBROWN1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     17 * FRACUNIT,             // radius
     72 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC71
     98,                        // doomednum
     HEXEN_S_ZROCKBROWN2,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     15 * FRACUNIT,             // radius
     50 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC72
     99,                        // doomednum
     HEXEN_S_ZROCKBLACK,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     40 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC73
     100,                       // doomednum
     HEXEN_S_ZRUBBLE1,                // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     0,                         // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC74
     101,                       // doomednum
     HEXEN_S_ZRUBBLE2,                // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     0,                         // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC75
     102,                       // doomednum
     HEXEN_S_ZRUBBLE3,                // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     0,                         // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC76
     103,                       // doomednum
     HEXEN_S_ZVASEPILLAR,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     12 * FRACUNIT,             // radius
     54 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_POTTERY1
     104,                       // doomednum
     HEXEN_S_ZPOTTERY1,               // spawnstate
     15,                        // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_ZPOTTERY_EXPLODE,        // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     10 * FRACUNIT,             // radius
     32 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_SHOOTABLE | MF_NOBLOOD | MF_DROPOFF, // flags
     MF2_SLIDE | MF2_PUSHABLE | MF2_TELESTOMP | MF2_PASSMOBJ    // flags2
     },

    {                           // HEXEN_MT_POTTERY2
     105,                       // doomednum
     HEXEN_S_ZPOTTERY2,               // spawnstate
     15,                        // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_ZPOTTERY_EXPLODE,        // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     10 * FRACUNIT,             // radius
     25 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_SHOOTABLE | MF_NOBLOOD | MF_DROPOFF, // flags
     MF2_SLIDE | MF2_PUSHABLE | MF2_TELESTOMP | MF2_PASSMOBJ    // flags2
     },

    {                           // HEXEN_MT_POTTERY3
     106,                       // doomednum
     HEXEN_S_ZPOTTERY3,               // spawnstate
     15,                        // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_ZPOTTERY_EXPLODE,        // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     15 * FRACUNIT,             // radius
     25 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_SHOOTABLE | MF_NOBLOOD | MF_DROPOFF, // flags
     MF2_SLIDE | MF2_PUSHABLE | MF2_TELESTOMP | MF2_PASSMOBJ    // flags2
     },

    {                           // HEXEN_MT_POTTERYBIT1
     -1,                        // doomednum
     HEXEN_S_POTTERYBIT_1,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_POTTERYBIT_EX0,          // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     5 * FRACUNIT,              // radius
     5 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_MISSILE,                // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_MISC77
     108,                       // doomednum
     HEXEN_S_ZCORPSELYNCHED1,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     11 * FRACUNIT,             // radius
     95 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_SPAWNCEILING | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ZLYNCHED_NOHEART
     109,                       // doomednum
     HEXEN_S_ZCORPSELYNCHED2,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     10 * FRACUNIT,             // radius
     100 * FRACUNIT,            // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_SPAWNCEILING | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC78
     110,                       // doomednum
     HEXEN_S_ZCORPSESITTING,          // spawnstate
     30,                        // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_ZCORPSESITTING_X,        // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     15 * FRACUNIT,             // radius
     35 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_SHOOTABLE | MF_NOBLOOD,      // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_CORPSEBIT
     -1,                        // doomednum
     HEXEN_S_CORPSEBIT_1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     5 * FRACUNIT,              // radius
     5 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP,             // flags
     MF2_TELESTOMP              // flags2
     },

    {                           // HEXEN_MT_CORPSEBLOODDRIP
     -1,                        // doomednum
     HEXEN_S_CORPSEBLOODDRIP,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_CORPSEBLOODDRIP_X1,      // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_drip,                  // deathsound
     0,                         // speed
     FRACUNIT,                  // radius
     4 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_MISSILE,                // flags
     MF2_LOGRAV                 // flags2
     },

    {                           // HEXEN_MT_BLOODPOOL
     111,                       // doomednum
     HEXEN_S_BLOODPOOL,               // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP,             // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC79
     119,                       // doomednum
     HEXEN_S_ZCANDLE1,                // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY,      // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC80
     113,                       // doomednum
     HEXEN_S_ZLEAFSPAWNER,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOSECTOR,       // flags
     MF2_DONTDRAW               // flags2
     },

    {                           // HEXEN_MT_LEAF1
     -1,                        // doomednum
     HEXEN_S_LEAF1_1,                 // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_LEAF_X1,                 // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     2 * FRACUNIT,              // radius
     4 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE,        // flags
     MF2_NOTELEPORT | MF2_LOGRAV        // flags2
     },

    {                           // HEXEN_MT_LEAF2
     -1,                        // doomednum
     HEXEN_S_LEAF2_1,                 // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_LEAF_X1,                 // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     2 * FRACUNIT,              // radius
     4 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE,        // flags
     MF2_NOTELEPORT | MF2_LOGRAV        // flags2
     },

    {                           // HEXEN_MT_ZTWINEDTORCH
     116,                       // doomednum
     HEXEN_S_ZTWINEDTORCH_1,          // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     10 * FRACUNIT,             // radius
     64 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ZTWINEDTORCH_UNLIT
     117,                       // doomednum
     HEXEN_S_ZTWINEDTORCH_UNLIT,      // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     10 * FRACUNIT,             // radius
     64 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_BRIDGE
     118,                       // doomednum
     HEXEN_S_BRIDGE1,                 // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     32 * FRACUNIT,             // radius
     2 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_NOGRAVITY,   // flags
     MF2_DONTDRAW               // flags2
     },

    {                           // HEXEN_MT_BRIDGEBALL
     -1,                        // doomednum
     HEXEN_S_BBALL1,                  // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY,      // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_ZWALLTORCH
     54,                        // doomednum
     HEXEN_S_ZWALLTORCH1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY,      // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ZWALLTORCH_UNLIT
     55,                        // doomednum
     HEXEN_S_ZWALLTORCH_U,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY,      // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ZBARREL
     8100,                      // doomednum
     HEXEN_S_ZBARREL1,                // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     15 * FRACUNIT,             // radius
     32 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ZSHRUB1
     8101,                      // doomednum
     HEXEN_S_ZSHRUB1,                 // spawnstate
     20,                        // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_ZSHRUB1_X1,              // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_ZSHRUB1_DIE,             // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_tree_explode,          // deathsound
     0,                         // speed
     8 * FRACUNIT,              // radius
     24 * FRACUNIT,             // height
     INT_MAX,                    // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_SHOOTABLE | MF_NOBLOOD,      // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ZSHRUB2
     8102,                      // doomednum
     HEXEN_S_ZSHRUB2,                 // spawnstate
     10,                        // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_ZSHRUB2_X1,              // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_ZSHRUB2_DIE,             // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_tree_explode,          // deathsound
     0,                         // speed
     16 * FRACUNIT,             // radius
     40 * FRACUNIT,             // height
     INT_MAX,                    // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_SHOOTABLE | MF_NOBLOOD,      // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ZBUCKET
     8103,                      // doomednum
     HEXEN_S_ZBUCKET1,                // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     8 * FRACUNIT,              // radius
     72 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_SPAWNCEILING | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ZPOISONSHROOM
     8104,                      // doomednum
     HEXEN_S_ZPOISONSHROOM1,          // spawnstate
     30,                        // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_ZPOISONSHROOM_P1,        // painstate
     255,                       // painchance
     hexen_sfx_poisonshroom_pain,     // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_ZPOISONSHROOM_X1,        // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_poisonshroom_death,    // deathsound
     0,                         // speed
     6 * FRACUNIT,              // radius
     20 * FRACUNIT,             // height
     INT_MAX,                    // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SHOOTABLE | MF_SOLID | MF_NOBLOOD,      // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ZFIREBULL
     8042,                      // doomednum
     HEXEN_S_ZFIREBULL1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     80 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ZFIREBULL_UNLIT
     8043,                      // doomednum
     HEXEN_S_ZFIREBULL_U,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     80 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_FIRETHING
     8060,                      // doomednum
     HEXEN_S_ZFIRETHING1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     5 * FRACUNIT,              // radius
     10 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_BRASSTORCH
     8061,                      // doomednum
     HEXEN_S_ZBRASSTORCH1,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     6 * FRACUNIT,              // radius
     35 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ZSUITOFARMOR
     8064,                      // doomednum
     HEXEN_S_ZSUITOFARMOR,            // spawnstate
     60,                        // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_ZSUITOFARMOR_X1,         // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_suitofarmor_break,     // deathsound
     0,                         // speed
     16 * FRACUNIT,             // radius
     72 * FRACUNIT,             // height
     INT_MAX,                    // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_SHOOTABLE | MF_NOBLOOD,      // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ZARMORCHUNK
     -1,                        // doomednum
     HEXEN_S_ZARMORCHUNK1,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     4 * FRACUNIT,              // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     0,                         // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ZBELL
     8065,                      // doomednum
     HEXEN_S_ZBELL,                   // spawnstate
     5,                         // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_ZBELL_X1,                // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_bellring,              // deathsound
     0,                         // speed
     56 * FRACUNIT,             // radius
     120 * FRACUNIT,            // height
     INT_MAX,                    // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_SHOOTABLE | MF_NOBLOOD | MF_NOGRAVITY | MF_SPAWNCEILING,     // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ZBLUE_CANDLE
     8066,                      // doomednum
     HEXEN_S_ZBLUE_CANDLE1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP,             // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ZIRON_MAIDEN
     8067,                      // doomednum
     HEXEN_S_ZIRON_MAIDEN,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     12 * FRACUNIT,             // radius
     60 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ZXMAS_TREE
     8068,                      // doomednum
     HEXEN_S_ZXMAS_TREE,              // spawnstate
     20,                        // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_ZXMAS_TREE_X1,           // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_ZXMAS_TREE_DIE,          // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_tree_explode,          // deathsound
     0,                         // speed
     11 * FRACUNIT,             // radius
     130 * FRACUNIT,            // height
     INT_MAX,                    // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_SHOOTABLE | MF_NOBLOOD,      // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ZCAULDRON
     8069,                      // doomednum
     HEXEN_S_ZCAULDRON1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     12 * FRACUNIT,             // radius
     26 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ZCAULDRON_UNLIT
     8070,                      // doomednum
     HEXEN_S_ZCAULDRON_U,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     12 * FRACUNIT,             // radius
     26 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID,                  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ZCHAINBIT32
     8071,                      // doomednum
     HEXEN_S_ZCHAINBIT32,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     4 * FRACUNIT,              // radius
     32 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_SPAWNCEILING,    // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ZCHAINBIT64
     8072,                      // doomednum
     HEXEN_S_ZCHAINBIT64,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     4 * FRACUNIT,              // radius
     64 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_SPAWNCEILING,    // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ZCHAINEND_HEART
     8073,                      // doomednum
     HEXEN_S_ZCHAINEND_HEART,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     4 * FRACUNIT,              // radius
     32 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_SPAWNCEILING,    // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ZCHAINEND_HOOK1
     8074,                      // doomednum
     HEXEN_S_ZCHAINEND_HOOK1,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     4 * FRACUNIT,              // radius
     32 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_SPAWNCEILING,    // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ZCHAINEND_HOOK2
     8075,                      // doomednum
     HEXEN_S_ZCHAINEND_HOOK2,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     4 * FRACUNIT,              // radius
     32 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_SPAWNCEILING,    // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ZCHAINEND_SPIKE
     8076,                      // doomednum
     HEXEN_S_ZCHAINEND_SPIKE,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     4 * FRACUNIT,              // radius
     32 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_SPAWNCEILING,    // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ZCHAINEND_SKULL
     8077,                      // doomednum
     HEXEN_S_ZCHAINEND_SKULL,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     4 * FRACUNIT,              // radius
     32 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_SPAWNCEILING,    // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_TABLE_SHIT1
     8500,                      // doomednum
     HEXEN_S_TABLE_SHIT1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP,             // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_TABLE_SHIT2
     8501,                      // doomednum
     HEXEN_S_TABLE_SHIT2,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP,             // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_TABLE_SHIT3
     8502,                      // doomednum
     HEXEN_S_TABLE_SHIT3,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP,             // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_TABLE_SHIT4
     8503,                      // doomednum
     HEXEN_S_TABLE_SHIT4,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP,             // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_TABLE_SHIT5
     8504,                      // doomednum
     HEXEN_S_TABLE_SHIT5,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP,             // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_TABLE_SHIT6
     8505,                      // doomednum
     HEXEN_S_TABLE_SHIT6,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP,             // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_TABLE_SHIT7
     8506,                      // doomednum
     HEXEN_S_TABLE_SHIT7,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP,             // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_TABLE_SHIT8
     8507,                      // doomednum
     HEXEN_S_TABLE_SHIT8,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP,             // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_TABLE_SHIT9
     8508,                      // doomednum
     HEXEN_S_TABLE_SHIT9,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP,             // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_TABLE_SHIT10
     8509,                      // doomednum
     HEXEN_S_TABLE_SHIT10,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP,             // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_TFOG
     -1,                        // doomednum
     HEXEN_S_TFOG1,                   // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY,      // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MISC81
     140,                       // doomednum
     HEXEN_S_TELESMOKE1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY,      // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_TELEPORTMAN
     14,                        // doomednum
     HEXEN_S_NULL,                    // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOSECTOR,       // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_PUNCHPUFF
     -1,                        // doomednum
     HEXEN_S_PUNCHPUFF1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_fighter_punch_hitthing,        // seesound
     8,                         // reactiontime
     hexen_sfx_fighter_punch_hitwall, // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_SHADOW,  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_FW_AXE
     8010,                      // doomednum
     HEXEN_S_AXE,                     // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_AXEPUFF
     -1,                        // doomednum
     HEXEN_S_HAMMERPUFF1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_fighter_axe_hitthing,  // seesound
     8,                         // reactiontime
     hexen_sfx_fighter_hammer_hitwall,        // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_SHADOW,  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_AXEPUFF_GLOW
     -1,                        // doomednum
     HEXEN_S_AXEPUFF_GLOW1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_fighter_axe_hitthing,  // seesound
     8,                         // reactiontime
     hexen_sfx_fighter_hammer_hitwall,        // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY,      // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_AXEBLOOD
     -1,                        // doomednum
     HEXEN_S_AXEBLOOD1,               // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_AXEBLOOD6,               // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     2 * FRACUNIT,              // radius
     4 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_DROPOFF, // flags
     MF2_NOTELEPORT | MF2_CANNOTPUSH    // flags2
     },

    {                           // HEXEN_MT_FW_HAMMER
     123,                       // doomednum
     HEXEN_S_HAMM,                    // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_HAMMER_MISSILE
     -1,                        // doomednum
     HEXEN_S_HAMMER_MISSILE_1,        // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_HAMMER_MISSILE_X1,       // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_fighter_hammer_explode,        // deathsound
     25 * FRACUNIT,             // speed
     14 * FRACUNIT,             // radius
     20 * FRACUNIT,             // height
     100,                       // mass
     10,                        // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_IMPACT | MF2_PCROSS | MF2_FIREDAMAGE  // flags2
     },

    {                           // HEXEN_MT_HAMMERPUFF
     -1,                        // doomednum
     HEXEN_S_HAMMERPUFF1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_fighter_hammer_hitthing,       // seesound
     8,                         // reactiontime
     hexen_sfx_fighter_hammer_hitwall,        // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_SHADOW,  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_FSWORD_MISSILE
     -1,                        // doomednum
     HEXEN_S_FSWORD_MISSILE1,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_FSWORD_MISSILE_X1,       // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_fighter_sword_explode, // deathsound
     30 * FRACUNIT,             // speed
     16 * FRACUNIT,             // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     8,                         // damage
     hexen_sfx_None,                  // activesound
     MF_MISSILE | MF_NOBLOCKMAP | MF_NOGRAVITY | MF_DROPOFF,    // flags
     MF2_NOTELEPORT | MF2_IMPACT | MF2_PCROSS   // flags2
     },

    {                           // HEXEN_MT_FSWORD_FLAME
     -1,                        // doomednum
     HEXEN_S_FSWORD_FLAME1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_SHADOW,  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_CW_SERPSTAFF
     10,                        // doomednum
     HEXEN_S_CSTAFF,                  // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_CSTAFF_MISSILE
     -1,                        // doomednum
     HEXEN_S_CSTAFF_MISSILE1,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_CSTAFF_MISSILE_X1,       // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_cleric_cstaff_explode, // deathsound
     22 * FRACUNIT,             // speed
     12 * FRACUNIT,             // radius
     10 * FRACUNIT,             // height
     100,                       // mass
     5,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_IMPACT | MF2_PCROSS   // flags2
     },

    {                           // HEXEN_MT_CSTAFFPUFF
     -1,                        // doomednum
     HEXEN_S_CSTAFFPUFF1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_cleric_cstaff_hitthing,        // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_SHADOW,  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_CW_FLAME
     8009,                      // doomednum
     HEXEN_S_CFLAME1,                 // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_CFLAMEFLOOR
     -1,                        // doomednum
     HEXEN_S_CFLAMEFLOOR1,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY,      // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_FLAMEPUFF
     -1,                        // doomednum
     HEXEN_S_FLAMEPUFF1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_cleric_flame_explode,  // seesound
     8,                         // reactiontime
     hexen_sfx_cleric_flame_explode,  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     FRACUNIT,                  // radius
     FRACUNIT,                  // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY,      // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_FLAMEPUFF2
     -1,                        // doomednum
     HEXEN_S_FLAMEPUFF2_1,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_cleric_flame_explode,  // seesound
     8,                         // reactiontime
     hexen_sfx_cleric_flame_explode,  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     FRACUNIT,                  // radius
     FRACUNIT,                  // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY,      // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_CIRCLEFLAME
     -1,                        // doomednum
     HEXEN_S_CIRCLE_FLAME1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_CIRCLE_FLAME_X1,         // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_cleric_flame_circle,   // deathsound
     0,                         // speed
     6 * FRACUNIT,              // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     2,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_FIREDAMAGE    // flags2
     },

    {                           // HEXEN_MT_CFLAME_MISSILE
     -1,                        // doomednum
     HEXEN_S_CFLAME_MISSILE1,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_CFLAME_MISSILE_X,        // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     200 * FRACUNIT,            // speed
     14 * FRACUNIT,             // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     8,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_IMPACT | MF2_PCROSS | MF2_DONTDRAW | MF2_FIREDAMAGE   // flags2
     },

    {                           // HEXEN_MT_HOLY_FX
     -1,                        // doomednum
     HEXEN_S_HOLY_FX1,                // spawnstate
     105,                       // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_HOLY_FX_X1,              // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_spirit_die,            // deathsound
     12 * FRACUNIT,             // speed
     10 * FRACUNIT,             // radius
     6 * FRACUNIT,              // height
     100,                       // mass
     3,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_NOGRAVITY | MF_ALTSHADOW | MF_MISSILE,     // flags
     MF2_NOTELEPORT | MF2_SEEKERMISSILE | MF2_RIP | MF2_IMPACT | MF2_PCROSS     // flags2
     },

    {                           // HEXEN_MT_HOLY_TAIL
     -1,                        // doomednum
     HEXEN_S_HOLY_TAIL1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     FRACUNIT,                  // radius
     FRACUNIT,                  // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_NOGRAVITY | MF_NOCLIP | MF_ALTSHADOW,      // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_HOLY_PUFF
     -1,                        // doomednum
     HEXEN_S_HOLY_PUFF1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_SHADOW,  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_HOLY_MISSILE
     -1,                        // doomednum
     HEXEN_S_HOLY_MISSILE1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_HOLY_MISSILE_X,          // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     30 * FRACUNIT,             // speed
     15 * FRACUNIT,             // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     4,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_NOGRAVITY | MF_MISSILE,    // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_HOLY_MISSILE_PUFF
     -1,                        // doomednum
     HEXEN_S_HOLY_MISSILE_P1,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     4 * FRACUNIT,              // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_NOGRAVITY | MF_ALTSHADOW,  // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_MWANDPUFF
     -1,                        // doomednum
     HEXEN_S_MWANDPUFF1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY,      // flags
     MF2_NOTELEPORT | MF2_CANNOTPUSH | MF2_NODMGTHRUST  // flags2
     },

    {                           // HEXEN_MT_MWANDSMOKE
     -1,                        // doomednum
     HEXEN_S_MWANDSMOKE1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_SHADOW,  // flags
     MF2_NOTELEPORT | MF2_CANNOTPUSH | MF2_NODMGTHRUST  // flags2
     },

    {                           // HEXEN_MT_MWAND_MISSILE
     -1,                        // doomednum
     HEXEN_S_MWAND_MISSILE1,          // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_MWANDPUFF1,              // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     184 * FRACUNIT,            // speed
     12 * FRACUNIT,             // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     2,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_RIP | MF2_IMPACT | MF2_PCROSS | MF2_NODMGTHRUST | MF2_CANNOTPUSH      // flags2
     },

    {                           // HEXEN_MT_MW_LIGHTNING
     8040,                      // doomednum
     HEXEN_S_MW_LIGHTNING1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_LIGHTNING_CEILING
     -1,                        // doomednum
     HEXEN_S_LIGHTNING_CEILING1,      // spawnstate
     144,                       // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_LIGHTNING_C_X1,          // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     25 * FRACUNIT,             // speed
     16 * FRACUNIT,             // radius
     40 * FRACUNIT,             // height
     100,                       // mass
     8,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_MISSILE | MF_DROPOFF,    // flags
     MF2_NOTELEPORT | MF2_IMPACT | MF2_PCROSS   // flags2
     },

    {                           // HEXEN_MT_LIGHTNING_FLOOR
     -1,                        // doomednum
     HEXEN_S_LIGHTNING_FLOOR1,        // spawnstate
     144,                       // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_LIGHTNING_F_X1,          // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     25 * FRACUNIT,             // speed
     16 * FRACUNIT,             // radius
     40 * FRACUNIT,             // height
     100,                       // mass
     8,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_MISSILE | MF_DROPOFF,    // flags
     MF2_NOTELEPORT | MF2_IMPACT | MF2_PCROSS   // flags2
     },

    {                           // HEXEN_MT_LIGHTNING_ZAP
     -1,                        // doomednum
     HEXEN_S_LIGHTNING_ZAP1,          // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_LIGHTNING_ZAP_X8,        // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     15 * FRACUNIT,             // radius
     35 * FRACUNIT,             // height
     100,                       // mass
     2,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_MISSILE | MF_DROPOFF,    // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MSTAFF_FX
     -1,                        // doomednum
     HEXEN_S_MSTAFF_FX1_1,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_MSTAFF_FX_X1,            // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_mage_staff_explode,    // deathsound
     20 * FRACUNIT,             // speed
     16 * FRACUNIT,             // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     6,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_FIREDAMAGE | MF2_RIP | MF2_IMPACT | MF2_PCROSS        // flags2
     },

    {                           // HEXEN_MT_MSTAFF_FX2
     -1,                        // doomednum
     HEXEN_S_MSTAFF_FX2_1,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_MSTAFF_FX2_X1,           // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_mage_staff_explode,    // deathsound
     17 * FRACUNIT,             // speed
     20 * FRACUNIT,             // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     4,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_FIREDAMAGE | MF2_IMPACT | MF2_PCROSS | MF2_SEEKERMISSILE      // flags2
     },

    {                           // HEXEN_MT_FW_SWORD1
     12,                        // doomednum
     HEXEN_S_FSWORD1,                 // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     MF2_FLOATBOB               // flags2
     },

    {                           // HEXEN_MT_FW_SWORD2
     13,                        // doomednum
     HEXEN_S_FSWORD2,                 // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     MF2_FLOATBOB               // flags2
     },

    {                           // HEXEN_MT_FW_SWORD3
     16,                        // doomednum
     HEXEN_S_FSWORD3,                 // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     MF2_FLOATBOB               // flags2
     },

    {                           // HEXEN_MT_CW_HOLY1
     18,                        // doomednum
     HEXEN_S_CHOLY1,                  // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     MF2_FLOATBOB               // flags2
     },

    {                           // HEXEN_MT_CW_HOLY2
     19,                        // doomednum
     HEXEN_S_CHOLY2,                  // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     MF2_FLOATBOB               // flags2
     },

    {                           // HEXEN_MT_CW_HOLY3
     20,                        // doomednum
     HEXEN_S_CHOLY3,                  // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     MF2_FLOATBOB               // flags2
     },

    {                           // HEXEN_MT_MW_STAFF1
     21,                        // doomednum
     HEXEN_S_MSTAFF1,                 // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     MF2_FLOATBOB               // flags2
     },

    {                           // HEXEN_MT_MW_STAFF2
     22,                        // doomednum
     HEXEN_S_MSTAFF2,                 // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     MF2_FLOATBOB               // flags2
     },

    {                           // HEXEN_MT_MW_STAFF3
     23,                        // doomednum
     HEXEN_S_MSTAFF3,                 // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     MF2_FLOATBOB               // flags2
     },

    {                           // HEXEN_MT_SNOUTPUFF
     -1,                        // doomednum
     HEXEN_S_PUNCHPUFF1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_SHADOW,  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MW_CONE
     53,                        // doomednum
     HEXEN_S_COS1,                    // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_SHARDFX1
     -1,                        // doomednum
     HEXEN_S_SHARDFX1_1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_SHARDFXE1_1,             // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_mage_shards_explode,   // deathsound
     25 * FRACUNIT,             // speed
     13 * FRACUNIT,             // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     1,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_IMPACT | MF2_PCROSS | MF2_ICEDAMAGE   // flags2
     },

    {                           // HEXEN_MT_BLOOD
     -1,                        // doomednum
     HEXEN_S_BLOOD1,                  // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     5,                         // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP,             // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_BLOODSPLATTER
     -1,                        // doomednum
     HEXEN_S_BLOODSPLATTER1,          // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_BLOODSPLATTERX,          // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     2 * FRACUNIT,              // radius
     4 * FRACUNIT,              // height
     5,                         // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF,   // flags
     MF2_NOTELEPORT | MF2_CANNOTPUSH    // flags2
     },

    {                           // HEXEN_MT_GIBS
     -1,                        // doomednum
     HEXEN_S_GIBS1,                   // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_CORPSE,    // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_PLAYER_FIGHTER
     -1,                        // doomednum
     HEXEN_S_FPLAY,                   // spawnstate
     100,                       // spawnhealth
     HEXEN_S_FPLAY_RUN1,              // seestate
     hexen_sfx_None,                  // seesound
     0,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_FPLAY_PAIN,              // painstate
     255,                       // painchance
     hexen_sfx_player_fighter_pain,   // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_FPLAY_ATK1,              // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_FPLAY_DIE1,              // deathstate
     HEXEN_S_FPLAY_XDIE1,             // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     16 * FRACUNIT,             // radius
     64 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_SHOOTABLE | MF_DROPOFF | MF_PICKUP | MF_NOTDMATCH,   // flags
     MF2_WINDTHRUST | MF2_FOOTCLIP | MF2_SLIDE | MF2_PASSMOBJ | MF2_TELESTOMP | MF2_PUSHWALL   // flags2
     },

    {                           // HEXEN_MT_BLOODYSKULL
     -1,                        // doomednum
     HEXEN_S_BLOODYSKULL1,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     4 * FRACUNIT,              // radius
     4 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF,        // flags
     MF2_LOGRAV | MF2_CANNOTPUSH        // flags2
     },

    {                           // HEXEN_MT_PLAYER_SPEED
     -1,                        // doomednum
     HEXEN_S_PLAYER_SPEED1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_ALTSHADOW,       // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ICECHUNK
     -1,                        // doomednum
     HEXEN_S_ICECHUNK1,               // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     3 * FRACUNIT,              // radius
     4 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF,        // flags
     MF2_LOGRAV | MF2_CANNOTPUSH | MF2_FOOTCLIP        // flags2
     },

    {                           // HEXEN_MT_PLAYER_CLERIC
     -1,                        // doomednum
     HEXEN_S_CPLAY,                   // spawnstate
     100,                       // spawnhealth
     HEXEN_S_CPLAY_RUN1,              // seestate
     hexen_sfx_None,                  // seesound
     0,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_CPLAY_PAIN,              // painstate
     255,                       // painchance
     hexen_sfx_player_cleric_pain,    // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_CPLAY_ATK1,              // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_CPLAY_DIE1,              // deathstate
     HEXEN_S_CPLAY_XDIE1,             // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     16 * FRACUNIT,             // radius
     64 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_SHOOTABLE | MF_DROPOFF | MF_PICKUP | MF_NOTDMATCH,   // flags
     MF2_WINDTHRUST | MF2_FOOTCLIP | MF2_SLIDE | MF2_PASSMOBJ | MF2_TELESTOMP | MF2_PUSHWALL   // flags2
     },

    {                           // HEXEN_MT_PLAYER_MAGE
     -1,                        // doomednum
     HEXEN_S_MPLAY,                   // spawnstate
     100,                       // spawnhealth
     HEXEN_S_MPLAY_RUN1,              // seestate
     hexen_sfx_None,                  // seesound
     0,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_MPLAY_PAIN,              // painstate
     255,                       // painchance
     hexen_sfx_player_mage_pain,      // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_MPLAY_ATK1,              // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_MPLAY_DIE1,              // deathstate
     HEXEN_S_MPLAY_XDIE1,             // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     16 * FRACUNIT,             // radius
     64 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_SHOOTABLE | MF_DROPOFF | MF_PICKUP | MF_NOTDMATCH,   // flags
     MF2_WINDTHRUST | MF2_FOOTCLIP | MF2_SLIDE | MF2_PASSMOBJ | MF2_TELESTOMP | MF2_PUSHWALL   // flags2
     },

    {                           // HEXEN_MT_PIGPLAYER
     -1,                        // doomednum
     HEXEN_S_PIGPLAY,                 // spawnstate
     100,                       // spawnhealth
     HEXEN_S_PIGPLAY_RUN1,            // seestate
     hexen_sfx_None,                  // seesound
     0,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_PIGPLAY_PAIN,            // painstate
     255,                       // painchance
     hexen_sfx_pig_pain,              // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_PIGPLAY_ATK1,            // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_PIG_DIE1,                // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_pig_death,             // deathsound
     0,                         // speed
     16 * FRACUNIT,             // radius
     24 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_SHOOTABLE | MF_DROPOFF | MF_NOTDMATCH,       // flags
     MF2_WINDTHRUST | MF2_SLIDE | MF2_PASSMOBJ | MF2_FOOTCLIP | MF2_TELESTOMP | MF2_PUSHWALL   // flags2
     },

    {                           // HEXEN_MT_PIG
     -1,                        // doomednum
     HEXEN_S_PIG_LOOK1,               // spawnstate
     25,                        // spawnhealth
     HEXEN_S_PIG_WALK1,               // seestate
     hexen_sfx_pig_active1,           // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_PIG_PAIN,                // painstate
     128,                       // painchance
     hexen_sfx_pig_pain,              // painsound
     HEXEN_S_PIG_ATK1,                // meleestate
     0,                         // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_PIG_DIE1,                // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_pig_death,             // deathsound
     10,                        // speed
     12 * FRACUNIT,             // radius
     22 * FRACUNIT,             // height
     60,                        // mass
     0,                         // damage
     hexen_sfx_pig_active1,           // activesound
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL,    // flags
     MF2_WINDTHRUST | MF2_FOOTCLIP | MF2_PASSMOBJ | MF2_PUSHWALL | MF2_TELESTOMP       // flags2
     },

    {                           // HEXEN_MT_CENTAUR
     107,                       // doomednum
     HEXEN_S_CENTAUR_LOOK1,           // spawnstate
     200,                       // spawnhealth
     HEXEN_S_CENTAUR_WALK1,           // seestate
     hexen_sfx_centaur_sight,         // seesound
     8,                         // reactiontime
     hexen_sfx_centaur_attack,        // attacksound
     HEXEN_S_CENTAUR_PAIN1,           // painstate
     135,                       // painchance
     hexen_sfx_centaur_pain,          // painsound
     HEXEN_S_CENTAUR_ATK1,            // meleestate
     0,                         // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_CENTAUR_DEATH1,          // deathstate
     HEXEN_S_CENTAUR_DEATH_X1,        // xdeathstate
     hexen_sfx_centaur_death,         // deathsound
     13,                        // speed
     20 * FRACUNIT,             // radius
     64 * FRACUNIT,             // height
     120,                       // mass
     0,                         // damage
     hexen_sfx_centaur_active,        // activesound
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL,    // flags
     MF2_FOOTCLIP | MF2_PASSMOBJ | MF2_PUSHWALL | MF2_MCROSS | MF2_TELESTOMP   // flags2
     },

    {                           // HEXEN_MT_CENTAURLEADER
     115,                       // doomednum
     HEXEN_S_CENTAUR_LOOK1,           // spawnstate
     250,                       // spawnhealth
     HEXEN_S_CENTAUR_WALK1,           // seestate
     hexen_sfx_centaur_sight,         // seesound
     8,                         // reactiontime
     hexen_sfx_centaur_attack,        // attacksound
     HEXEN_S_CENTAUR_PAIN1,           // painstate
     96,                        // painchance
     hexen_sfx_centaur_pain,          // painsound
     HEXEN_S_CENTAUR_ATK1,            // meleestate
     HEXEN_S_CENTAUR_MISSILE1,        // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_CENTAUR_DEATH1,          // deathstate
     HEXEN_S_CENTAUR_DEATH_X1,        // xdeathstate
     hexen_sfx_centaur_death,         // deathsound
     10,                        // speed
     20 * FRACUNIT,             // radius
     64 * FRACUNIT,             // height
     120,                       // mass
     0,                         // damage
     hexen_sfx_centaur_active,        // activesound
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL,    // flags
     MF2_FOOTCLIP | MF2_PASSMOBJ | MF2_PUSHWALL | MF2_MCROSS | MF2_TELESTOMP   // flags2
     },

    {                           // HEXEN_MT_CENTAUR_FX
     -1,                        // doomednum
     HEXEN_S_CENTAUR_FX1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_CENTAUR_FX_X1,           // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_centaur_missile_explode,       // deathsound
     20 * FRACUNIT,             // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     4,                         // damage
     hexen_sfx_None,                  // activesound
     MF_MISSILE | MF_NOBLOCKMAP | MF_NOGRAVITY | MF_DROPOFF,    // flags
     MF2_NOTELEPORT | MF2_IMPACT | MF2_PCROSS   // flags2
     },

    {                           // HEXEN_MT_CENTAUR_SHIELD
     -1,                        // doomednum
     HEXEN_S_CENTAUR_SHIELD1,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_CENTAUR_SHIELD_X1,       // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_DROPOFF | MF_CORPSE,    // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_CENTAUR_SWORD
     -1,                        // doomednum
     HEXEN_S_CENTAUR_SWORD1,          // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_CENTAUR_SWORD_X1,        // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_DROPOFF | MF_CORPSE,    // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_DEMON
     31,                        // doomednum
     HEXEN_S_DEMN_LOOK1,              // spawnstate
     250,                       // spawnhealth
     HEXEN_S_DEMN_CHASE1,             // seestate
     hexen_sfx_demon_sight,           // seesound
     8,                         // reactiontime
     hexen_sfx_demon_attack,          // attacksound
     HEXEN_S_DEMN_PAIN1,              // painstate
     50,                        // painchance
     hexen_sfx_demon_pain,            // painsound
     HEXEN_S_DEMN_ATK1_1,             // meleestate
     HEXEN_S_DEMN_ATK2_1,             // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_DEMN_DEATH1,             // deathstate
     HEXEN_S_DEMN_XDEATH1,            // xdeathstate
     hexen_sfx_demon_death,           // deathsound
     13,                        // speed
     32 * FRACUNIT,             // radius
     64 * FRACUNIT,             // height
     220,                       // mass
     0,                         // damage
     hexen_sfx_demon_active,          // activesound
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL,    // flags
     MF2_FOOTCLIP | MF2_PASSMOBJ | MF2_MCROSS | MF2_TELESTOMP  // flags2
     },

    {                           // HEXEN_MT_DEMONCHUNK1
     -1,                        // doomednum
     HEXEN_S_DEMONCHUNK1_1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_DEMONCHUNK1_4,           // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     5 * FRACUNIT,              // radius
     5 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_CORPSE,       // flags
     MF2_NOTELEPORT | MF2_FOOTCLIP     // flags2
     },

    {                           // HEXEN_MT_DEMONCHUNK2
     -1,                        // doomednum
     HEXEN_S_DEMONCHUNK2_1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_DEMONCHUNK2_4,           // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     5 * FRACUNIT,              // radius
     5 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_CORPSE,       // flags
     MF2_NOTELEPORT | MF2_FOOTCLIP     // flags2
     },

    {                           // HEXEN_MT_DEMONCHUNK3
     -1,                        // doomednum
     HEXEN_S_DEMONCHUNK3_1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_DEMONCHUNK3_4,           // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     5 * FRACUNIT,              // radius
     5 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_CORPSE,       // flags
     MF2_NOTELEPORT | MF2_FOOTCLIP     // flags2
     },

    {                           // HEXEN_MT_DEMONCHUNK4
     -1,                        // doomednum
     HEXEN_S_DEMONCHUNK4_1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_DEMONCHUNK4_4,           // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     5 * FRACUNIT,              // radius
     5 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_CORPSE,       // flags
     MF2_NOTELEPORT | MF2_FOOTCLIP     // flags2
     },

    {                           // HEXEN_MT_DEMONCHUNK5
     -1,                        // doomednum
     HEXEN_S_DEMONCHUNK5_1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_DEMONCHUNK5_4,           // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     5 * FRACUNIT,              // radius
     5 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_CORPSE,       // flags
     MF2_NOTELEPORT | MF2_FOOTCLIP     // flags2
     },

    {                           // HEXEN_MT_DEMONFX1
     -1,                        // doomednum
     HEXEN_S_DEMONFX_MOVE1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_DEMONFX_BOOM1,           // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_demon_missile_explode, // deathsound
     15 * FRACUNIT,             // speed
     10 * FRACUNIT,             // radius
     6 * FRACUNIT,              // height
     100,                       // mass
     5,                         // damage
     hexen_sfx_None,                  // activesound
     MF_MISSILE | MF_NOBLOCKMAP | MF_NOGRAVITY | MF_DROPOFF,    // flags
     MF2_NOTELEPORT | MF2_IMPACT | MF2_PCROSS | MF2_FIREDAMAGE  // flags2
     },

    {                           // HEXEN_MT_DEMON2
     8080,                      // doomednum
     HEXEN_S_DEMN2_LOOK1,             // spawnstate
     250,                       // spawnhealth
     HEXEN_S_DEMN2_CHASE1,            // seestate
     hexen_sfx_demon_sight,           // seesound
     8,                         // reactiontime
     hexen_sfx_demon_attack,          // attacksound
     HEXEN_S_DEMN2_PAIN1,             // painstate
     50,                        // painchance
     hexen_sfx_demon_pain,            // painsound
     HEXEN_S_DEMN2_ATK1_1,            // meleestate
     HEXEN_S_DEMN2_ATK2_1,            // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_DEMN2_DEATH1,            // deathstate
     HEXEN_S_DEMN2_XDEATH1,           // xdeathstate
     hexen_sfx_demon_death,           // deathsound
     13,                        // speed
     32 * FRACUNIT,             // radius
     64 * FRACUNIT,             // height
     220,                       // mass
     0,                         // damage
     hexen_sfx_demon_active,          // activesound
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL,    // flags
     MF2_FOOTCLIP | MF2_PASSMOBJ | MF2_MCROSS | MF2_TELESTOMP  // flags2
     },

    {                           // HEXEN_MT_DEMON2CHUNK1
     -1,                        // doomednum
     HEXEN_S_DEMON2CHUNK1_1,          // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_DEMON2CHUNK1_4,          // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     5 * FRACUNIT,              // radius
     5 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_CORPSE,       // flags
     MF2_NOTELEPORT | MF2_FOOTCLIP     // flags2
     },

    {                           // HEXEN_MT_DEMON2CHUNK2
     -1,                        // doomednum
     HEXEN_S_DEMON2CHUNK2_1,          // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_DEMON2CHUNK2_4,          // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     5 * FRACUNIT,              // radius
     5 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_CORPSE,       // flags
     MF2_NOTELEPORT | MF2_FOOTCLIP     // flags2
     },

    {                           // HEXEN_MT_DEMON2CHUNK3
     -1,                        // doomednum
     HEXEN_S_DEMON2CHUNK3_1,          // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_DEMON2CHUNK3_4,          // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     5 * FRACUNIT,              // radius
     5 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_CORPSE,       // flags
     MF2_NOTELEPORT | MF2_FOOTCLIP     // flags2
     },

    {                           // HEXEN_MT_DEMON2CHUNK4
     -1,                        // doomednum
     HEXEN_S_DEMON2CHUNK4_1,          // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_DEMON2CHUNK4_4,          // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     5 * FRACUNIT,              // radius
     5 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_CORPSE,       // flags
     MF2_NOTELEPORT | MF2_FOOTCLIP     // flags2
     },

    {                           // HEXEN_MT_DEMON2CHUNK5
     -1,                        // doomednum
     HEXEN_S_DEMON2CHUNK5_1,          // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_DEMON2CHUNK5_4,          // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     5 * FRACUNIT,              // radius
     5 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_CORPSE,       // flags
     MF2_NOTELEPORT | MF2_FOOTCLIP     // flags2
     },

    {                           // HEXEN_MT_DEMON2FX1
     -1,                        // doomednum
     HEXEN_S_DEMON2FX_MOVE1,          // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_DEMON2FX_BOOM1,          // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_demon_missile_explode, // deathsound
     15 * FRACUNIT,             // speed
     10 * FRACUNIT,             // radius
     6 * FRACUNIT,              // height
     100,                       // mass
     5,                         // damage
     hexen_sfx_None,                  // activesound
     MF_MISSILE | MF_NOBLOCKMAP | MF_NOGRAVITY | MF_DROPOFF,    // flags
     MF2_NOTELEPORT | MF2_IMPACT | MF2_PCROSS | MF2_FIREDAMAGE  // flags2
     },

    {                           // HEXEN_MT_WRAITHB
     10011,                     // doomednum
     HEXEN_S_WRAITH_LOOK1,            // spawnstate
     150,                       // spawnhealth
     HEXEN_S_WRAITH_RAISE1,           // seestate
     hexen_sfx_wraith_sight,          // seesound
     8,                         // reactiontime
     hexen_sfx_wraith_attack,         // attacksound
     HEXEN_S_WRAITH_PAIN1,            // painstate
     25,                        // painchance
     hexen_sfx_wraith_pain,           // painsound
     HEXEN_S_WRAITH_ATK1_1,           // meleestate
     HEXEN_S_WRAITH_ATK2_1,           // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_WRAITH_DEATH1_1,         // deathstate
     HEXEN_S_WRAITH_DEATH2_1,         // xdeathstate
     hexen_sfx_wraith_death,          // deathsound
     11,                        // speed
     20 * FRACUNIT,             // radius
     68 * FRACUNIT,             // height
     75,                        // mass
     10,                        // damage
     hexen_sfx_wraith_active,         // activesound
     MF_DROPOFF | MF_NOGRAVITY | MF_FLOAT | MF_COUNTKILL,       // flags
     MF2_FOOTCLIP | MF2_PASSMOBJ | MF2_PUSHWALL | MF2_TELESTOMP | MF2_DONTDRAW // flags2
     },

    {                           // HEXEN_MT_WRAITH
     34,                        // doomednum
     HEXEN_S_WRAITH_INIT1,            // spawnstate
     150,                       // spawnhealth
     HEXEN_S_WRAITH_CHASE1,           // seestate
     hexen_sfx_wraith_sight,          // seesound
     8,                         // reactiontime
     hexen_sfx_wraith_attack,         // attacksound
     HEXEN_S_WRAITH_PAIN1,            // painstate
     25,                        // painchance
     hexen_sfx_wraith_pain,           // painsound
     HEXEN_S_WRAITH_ATK1_1,           // meleestate
     HEXEN_S_WRAITH_ATK2_1,           // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_WRAITH_DEATH1_1,         // deathstate
     HEXEN_S_WRAITH_DEATH2_1,         // xdeathstate
     hexen_sfx_wraith_death,          // deathsound
     11,                        // speed
     20 * FRACUNIT,             // radius
     55 * FRACUNIT,             // height
     75,                        // mass
     10,                        // damage
     hexen_sfx_wraith_active,         // activesound
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL | MF_DROPOFF | MF_NOGRAVITY | MF_FLOAT,     // flags
     MF2_FOOTCLIP | MF2_PASSMOBJ | MF2_PUSHWALL | MF2_TELESTOMP        // flags2
     },

    {                           // HEXEN_MT_WRAITHFX1
     -1,                        // doomednum
     HEXEN_S_WRTHFX_MOVE1,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_WRTHFX_BOOM1,            // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_wraith_missile_explode,        // deathsound
     14 * FRACUNIT,             // speed
     10 * FRACUNIT,             // radius
     6 * FRACUNIT,              // height
     5,                         // mass
     5,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_DROPOFF | MF_MISSILE,    // flags
     MF2_NOTELEPORT | MF2_IMPACT | MF2_PCROSS | MF2_FOOTCLIP | MF2_FIREDAMAGE  // flags2
     },

    {                           // HEXEN_MT_WRAITHFX2
     -1,                        // doomednum
     HEXEN_S_WRTHFX_SIZZLE1,          // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     2 * FRACUNIT,              // radius
     5 * FRACUNIT,              // height
     5,                         // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF,        // flags
     MF2_NOTELEPORT | MF2_FOOTCLIP     // flags2
     },

    {                           // HEXEN_MT_WRAITHFX3
     -1,                        // doomednum
     HEXEN_S_WRTHFX_DROP1,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_WRTHFX_DEAD1,            // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_drip,                  // deathsound
     0,                         // speed
     2 * FRACUNIT,              // radius
     5 * FRACUNIT,              // height
     5,                         // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_MISSILE,   // flags
     MF2_NOTELEPORT | MF2_FOOTCLIP     // flags2
     },

    {                           // HEXEN_MT_WRAITHFX4
     -1,                        // doomednum
     HEXEN_S_WRTHFX_ADROP1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_WRTHFX_ADEAD1,           // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_drip,                  // deathsound
     0,                         // speed
     2 * FRACUNIT,              // radius
     5 * FRACUNIT,              // height
     5,                         // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_MISSILE,   // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_WRAITHFX5
     -1,                        // doomednum
     HEXEN_S_WRTHFX_BDROP1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_WRTHFX_BDEAD1,           // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_drip,                  // deathsound
     0,                         // speed
     2 * FRACUNIT,              // radius
     5 * FRACUNIT,              // height
     5,                         // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_MISSILE,   // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_MINOTAUR
     -1,                        // doomednum
     HEXEN_S_MNTR_SPAWN1,             // spawnstate
     2500,                      // spawnhealth
     HEXEN_S_MNTR_WALK1,              // seestate
     hexen_sfx_maulator_sight,        // seesound
     8,                         // reactiontime
     hexen_sfx_maulator_hammer_swing, // attacksound
     HEXEN_S_MNTR_PAIN1,              // painstate
     25,                        // painchance
     hexen_sfx_maulator_pain,         // painsound
     HEXEN_S_MNTR_ATK1_1,             // meleestate
     HEXEN_S_MNTR_ATK2_1,             // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_MNTR_DIE1,               // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_maulator_death,        // deathsound
     16,                        // speed
     28 * FRACUNIT,             // radius
     100 * FRACUNIT,            // height
     800,                       // mass
     7,                         // damage
     hexen_sfx_maulator_active,       // activesound
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL | MF_SHADOW,        // flags
     MF2_FOOTCLIP | MF2_PASSMOBJ | MF2_PUSHWALL | MF2_TELESTOMP        // flags2
     },

    {                           // HEXEN_MT_MNTRFX1
     -1,                        // doomednum
     HEXEN_S_MNTRFX1_1,               // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_MNTRFXI1_1,              // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     20 * FRACUNIT,             // speed
     10 * FRACUNIT,             // radius
     6 * FRACUNIT,              // height
     100,                       // mass
     3,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_FIREDAMAGE    // flags2
     },

    {                           // HEXEN_MT_MNTRFX2
     -1,                        // doomednum
     HEXEN_S_MNTRFX2_1,               // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_MNTRFXI2_1,              // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     14 * FRACUNIT,             // speed
     5 * FRACUNIT,              // radius
     12 * FRACUNIT,             // height
     100,                       // mass
     4,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_FIREDAMAGE    // flags2
     },

    {                           // HEXEN_MT_MNTRFX3
     -1,                        // doomednum
     HEXEN_S_MNTRFX3_1,               // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     0,                         // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_MNTRFXI2_1,              // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     8 * FRACUNIT,              // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     4,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_FIREDAMAGE    // flags2
     },

    {                           // HEXEN_MT_MNTRSMOKE
     -1,                        // doomednum
     HEXEN_S_MINOSMOKE1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_SHADOW,  // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_MNTRSMOKEEXIT
     -1,                        // doomednum
     HEXEN_S_MINOSMOKEX1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_SHADOW,  // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_SERPENT
     121,                       // doomednum
     HEXEN_S_SERPENT_LOOK1,           // spawnstate
     90,                        // spawnhealth
     HEXEN_S_SERPENT_SWIM1,           // seestate
     hexen_sfx_serpent_sight,         // seesound
     8,                         // reactiontime
     hexen_sfx_serpent_attack,        // attacksound
     HEXEN_S_SERPENT_PAIN1,           // painstate
     96,                        // painchance
     hexen_sfx_serpent_pain,          // painsound
     HEXEN_S_SERPENT_SURFACE1,        // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_SERPENT_DIE1,            // deathstate
     HEXEN_S_SERPENT_XDIE1,           // xdeathstate
     hexen_sfx_serpent_death,         // deathsound
     12,                        // speed
     32 * FRACUNIT,             // radius
     70 * FRACUNIT,             // height
     INT_MAX,                    // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_COUNTKILL | MF_NOBLOOD,      // flags
     MF2_PASSMOBJ | MF2_DONTDRAW | MF2_CANTLEAVEFLOORPIC | MF2_NONSHOOTABLE | MF2_MCROSS        // flags2
     },

    {                           // HEXEN_MT_SERPENTLEADER
     120,                       // doomednum
     HEXEN_S_SERPENT_LOOK1,           // spawnstate
     90,                        // spawnhealth
     HEXEN_S_SERPENT_SWIM1,           // seestate
     hexen_sfx_serpent_sight,         // seesound
     8,                         // reactiontime
     hexen_sfx_serpent_attack,        // attacksound
     HEXEN_S_SERPENT_PAIN1,           // painstate
     96,                        // painchance
     hexen_sfx_serpent_pain,          // painsound
     HEXEN_S_SERPENT_SURFACE1,        // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_SERPENT_DIE1,            // deathstate
     HEXEN_S_SERPENT_XDIE1,           // xdeathstate
     hexen_sfx_serpent_death,         // deathsound
     12,                        // speed
     32 * FRACUNIT,             // radius
     70 * FRACUNIT,             // height
     200,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_COUNTKILL | MF_NOBLOOD,      // flags
     MF2_PASSMOBJ | MF2_DONTDRAW | MF2_CANTLEAVEFLOORPIC | MF2_NONSHOOTABLE | MF2_MCROSS        // flags2
     },

    {                           // HEXEN_MT_SERPENTFX
     -1,                        // doomednum
     HEXEN_S_SERPENT_FX1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     0,                         // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_SERPENT_FX_X1,           // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_serpentfx_hit,         // deathsound
     15 * FRACUNIT,             // speed
     8 * FRACUNIT,              // radius
     10 * FRACUNIT,             // height
     100,                       // mass
     4,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_SERPENT_HEAD
     -1,                        // doomednum
     HEXEN_S_SERPENT_HEAD1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     5 * FRACUNIT,              // radius
     10 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP,             // flags
     MF2_LOGRAV                 // flags2
     },

    {                           // HEXEN_MT_SERPENT_GIB1
     -1,                        // doomednum
     HEXEN_S_SERPENT_GIB1_1,          // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     3 * FRACUNIT,              // radius
     3 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY,      // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_SERPENT_GIB2
     -1,                        // doomednum
     HEXEN_S_SERPENT_GIB2_1,          // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     3 * FRACUNIT,              // radius
     3 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY,      // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_SERPENT_GIB3
     -1,                        // doomednum
     HEXEN_S_SERPENT_GIB3_1,          // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     3 * FRACUNIT,              // radius
     3 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY,      // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_BISHOP
     114,                       // doomednum
     HEXEN_S_BISHOP_LOOK1,            // spawnstate
     130,                       // spawnhealth
     HEXEN_S_BISHOP_WALK1,            // seestate
     hexen_sfx_bishop_sight,          // seesound
     8,                         // reactiontime
     hexen_sfx_bishop_attack,         // attacksound
     HEXEN_S_BISHOP_PAIN1,            // painstate
     110,                       // painchance
     hexen_sfx_bishop_pain,           // painsound
     0,                         // meleestate
     HEXEN_S_BISHOP_ATK1,             // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_BISHOP_DEATH1,           // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_bishop_death,          // deathsound
     10,                        // speed
     22 * FRACUNIT,             // radius
     65 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_bishop_active,         // activesound
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL | MF_FLOAT | MF_NOGRAVITY | MF_NOBLOOD,     // flags
     MF2_PASSMOBJ | MF2_PUSHWALL | MF2_TELESTOMP        // flags2
     },

    {                           // HEXEN_MT_BISHOP_PUFF
     -1,                        // doomednum
     HEXEN_S_BISHOP_PUFF1,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SHADOW | MF_NOBLOCKMAP | MF_NOGRAVITY,  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_BISHOPBLUR
     -1,                        // doomednum
     HEXEN_S_BISHOPBLUR1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_SHADOW,  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_BISHOPPAINBLUR
     -1,                        // doomednum
     HEXEN_S_BISHOPPAINBLUR1,         // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_SHADOW,  // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_BISH_FX
     -1,                        // doomednum
     HEXEN_S_BISHFX1_1,               // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_BISHFXI1_1,              // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_bishop_missile_explode,        // deathsound
     10 * FRACUNIT,             // speed
     10 * FRACUNIT,             // radius
     6 * FRACUNIT,              // height
     100,                       // mass
     1,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_SEEKERMISSILE // flags2
     },

    {                           // HEXEN_MT_DRAGON
     254,                       // doomednum
     HEXEN_S_DRAGON_LOOK1,            // spawnstate
     640,                       // spawnhealth
     HEXEN_S_DRAGON_INIT,             // seestate
     hexen_sfx_dragon_sight,          // seesound
     8,                         // reactiontime
     hexen_sfx_dragon_attack,         // attacksound
     HEXEN_S_DRAGON_PAIN1,            // painstate
     128,                       // painchance
     hexen_sfx_dragon_pain,           // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_DRAGON_ATK1,             // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_DRAGON_DEATH1,           // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_dragon_death,          // deathsound
     10 * FRACUNIT,             // speed
     20 * FRACUNIT,             // radius
     65 * FRACUNIT,             // height
     INT_MAX,                    // mass
     0,                         // damage
     hexen_sfx_dragon_active,         // activesound
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL | MF_FLOAT | MF_NOGRAVITY | MF_NOBLOOD,     // flags
     MF2_PASSMOBJ | MF2_BOSS    // flags2
     },

    {                           // HEXEN_MT_DRAGON_FX
     -1,                        // doomednum
     HEXEN_S_DRAGON_FX1_1,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_DRAGON_FX1_X1,           // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_dragon_fireball_explode,       // deathsound
     24 * FRACUNIT,             // speed
     12 * FRACUNIT,             // radius
     10 * FRACUNIT,             // height
     100,                       // mass
     6,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_FIREDAMAGE    // flags2
     },

    {                           // HEXEN_MT_DRAGON_FX2
     -1,                        // doomednum
     HEXEN_S_DRAGON_FX2_1,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_dragon_fireball_explode,       // deathsound
     0,                         // speed
     8 * FRACUNIT,              // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP,             // flags
     MF2_NOTELEPORT | MF2_FIREDAMAGE | MF2_DONTDRAW     // flags2
     },

    {                           // HEXEN_MT_ARMOR_1
     8005,                      // doomednum
     HEXEN_S_ARMOR_1,                 // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ARMOR_2
     8006,                      // doomednum
     HEXEN_S_ARMOR_2,                 // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ARMOR_3
     8007,                      // doomednum
     HEXEN_S_ARMOR_3,                 // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ARMOR_4
     8008,                      // doomednum
     HEXEN_S_ARMOR_4,                 // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL | MF_NOGRAVITY, // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_MANA1
     122,                       // doomednum
     HEXEN_S_MANA1_1,                 // spawnstate
     10,                        // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     8 * FRACUNIT,              // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     MF2_FLOATBOB               // flags2
     },

    {                           // HEXEN_MT_MANA2
     124,                       // doomednum
     HEXEN_S_MANA2_1,                 // spawnstate
     10,                        // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     8 * FRACUNIT,              // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     MF2_FLOATBOB               // flags2
     },

    {                           // HEXEN_MT_MANA3
     8004,                      // doomednum
     HEXEN_S_MANA3_1,                 // spawnstate
     20,                        // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     8 * FRACUNIT,              // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     MF2_FLOATBOB               // flags2
     },

    {                           // HEXEN_MT_KEY1
     8030,                      // doomednum
     HEXEN_S_KEY1,                    // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     8 * FRACUNIT,              // radius
     20 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_KEY2
     8031,                      // doomednum
     HEXEN_S_KEY2,                    // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     8 * FRACUNIT,              // radius
     20 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_KEY3
     8032,                      // doomednum
     HEXEN_S_KEY3,                    // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     8 * FRACUNIT,              // radius
     20 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_KEY4
     8033,                      // doomednum
     HEXEN_S_KEY4,                    // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     8 * FRACUNIT,              // radius
     20 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_KEY5
     8034,                      // doomednum
     HEXEN_S_KEY5,                    // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     8 * FRACUNIT,              // radius
     20 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_KEY6
     8035,                      // doomednum
     HEXEN_S_KEY6,                    // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     8 * FRACUNIT,              // radius
     20 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_KEY7
     8036,                      // doomednum
     HEXEN_S_KEY7,                    // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     8 * FRACUNIT,              // radius
     20 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_KEY8
     8037,                      // doomednum
     HEXEN_S_KEY8,                    // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     8 * FRACUNIT,              // radius
     20 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_KEY9
     8038,                      // doomednum
     HEXEN_S_KEY9,                    // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     8 * FRACUNIT,              // radius
     20 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_KEYA
     8039,                      // doomednum
     HEXEN_S_KEYA,                    // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     8 * FRACUNIT,              // radius
     20 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_KEYB
     8200,                      // doomednum
     HEXEN_S_KEYB,                    // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     8 * FRACUNIT,              // radius
     20 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SPECIAL,                // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_SOUNDWIND
     1410,                      // doomednum
     HEXEN_S_SND_WIND1,               // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOSECTOR,       // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_SOUNDWATERFALL
     -1,                        // doomednum
     HEXEN_S_SND_WATERFALL,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOSECTOR,       // flags
     0                          // flags2
     },

    {                           // HEXEN_MT_ETTIN
     10030,                     // doomednum
     HEXEN_S_ETTIN_LOOK1,             // spawnstate
     175,                       // spawnhealth
     HEXEN_S_ETTIN_CHASE1,            // seestate
     hexen_sfx_ettin_sight,           // seesound
     8,                         // reactiontime
     hexen_sfx_ettin_attack,          // attacksound
     HEXEN_S_ETTIN_PAIN1,             // painstate
     60,                        // painchance
     hexen_sfx_ettin_pain,            // painsound
     HEXEN_S_ETTIN_ATK1_1,            // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_ETTIN_DEATH1_1,          // deathstate
     HEXEN_S_ETTIN_DEATH2_1,          // xdeathstate
     hexen_sfx_ettin_death,           // deathsound
     13,                        // speed
     25 * FRACUNIT,             // radius
     68 * FRACUNIT,             // height
     175,                       // mass
     3,                         // damage
     hexen_sfx_ettin_active,          // activesound
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL,    // flags
     MF2_FOOTCLIP | MF2_PUSHWALL | MF2_MCROSS | MF2_TELESTOMP  // flags2
     },

    {                           // HEXEN_MT_ETTIN_MACE
     -1,                        // doomednum
     HEXEN_S_ETTIN_MACE1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_ETTIN_MACE5,             // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     5 * FRACUNIT,              // radius
     5 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_DROPOFF | MF_CORPSE,    // flags
     MF2_NOTELEPORT | MF2_FOOTCLIP     // flags2
     },

    {                           // HEXEN_MT_FIREDEMON
     10060,                     // doomednum
     HEXEN_S_FIRED_SPAWN1,            // spawnstate
     80,                        // spawnhealth
     HEXEN_S_FIRED_LOOK4,             // seestate
     hexen_sfx_fired_spawn,           // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_FIRED_PAIN1,             // painstate
     1,                         // painchance
     hexen_sfx_fired_pain,            // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_FIRED_ATTACK1,           // missilestate
     HEXEN_S_FIRED_XDEATH1,           // crashstate
     HEXEN_S_FIRED_DEATH1,            // deathstate
     HEXEN_S_FIRED_XDEATH1,           // xdeathstate
     hexen_sfx_fired_death,           // deathsound
     13,                        // speed
     20 * FRACUNIT,             // radius
     68 * FRACUNIT,             // height
     75,                        // mass
     1,                         // damage
     hexen_sfx_fired_active,          // activesound
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL | MF_DROPOFF | MF_NOGRAVITY | MF_FLOAT,     // flags
     MF2_FOOTCLIP | MF2_PASSMOBJ | MF2_PUSHWALL | MF2_INVULNERABLE | MF2_MCROSS | MF2_TELESTOMP        // flags2
     },

    {                           // HEXEN_MT_FIREDEMON_SPLOTCH1
     -1,                        // doomednum
     HEXEN_S_FIRED_CORPSE1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     3 * FRACUNIT,              // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_DROPOFF | MF_CORPSE,    // flags
     MF2_NOTELEPORT | MF2_FOOTCLIP     // flags2
     },

    {                           // HEXEN_MT_FIREDEMON_SPLOTCH2
     -1,                        // doomednum
     HEXEN_S_FIRED_CORPSE4,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     3 * FRACUNIT,              // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_DROPOFF | MF_CORPSE,    // flags
     MF2_NOTELEPORT | MF2_FOOTCLIP     // flags2
     },

    {                           // HEXEN_MT_FIREDEMON_FX1
     -1,                        // doomednum
     HEXEN_S_FIRED_RDROP1,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_FIRED_RDEAD1_1,          // deathstate
     HEXEN_S_FIRED_RDEAD1_2,          // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     3 * FRACUNIT,              // radius
     5 * FRACUNIT,              // height
     16,                        // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_MISSILE,   // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_FIREDEMON_FX2
     -1,                        // doomednum
     HEXEN_S_FIRED_RDROP2,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_FIRED_RDEAD2_1,          // deathstate
     HEXEN_S_FIRED_RDEAD2_2,          // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     3 * FRACUNIT,              // radius
     5 * FRACUNIT,              // height
     16,                        // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_MISSILE,   // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_FIREDEMON_FX3
     -1,                        // doomednum
     HEXEN_S_FIRED_RDROP3,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_FIRED_RDEAD3_1,          // deathstate
     HEXEN_S_FIRED_RDEAD3_2,          // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     3 * FRACUNIT,              // radius
     5 * FRACUNIT,              // height
     16,                        // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_MISSILE,   // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_FIREDEMON_FX4
     -1,                        // doomednum
     HEXEN_S_FIRED_RDROP4,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_FIRED_RDEAD4_1,          // deathstate
     HEXEN_S_FIRED_RDEAD4_2,          // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     3 * FRACUNIT,              // radius
     5 * FRACUNIT,              // height
     16,                        // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_MISSILE,   // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_FIREDEMON_FX5
     -1,                        // doomednum
     HEXEN_S_FIRED_RDROP5,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_FIRED_RDEAD5_1,          // deathstate
     HEXEN_S_FIRED_RDEAD5_2,          // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     3 * FRACUNIT,              // radius
     5 * FRACUNIT,              // height
     16,                        // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_MISSILE,   // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_FIREDEMON_FX6
     -1,                        // doomednum
     HEXEN_S_FIRED_FX6_1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_FIRED_FX6_2,             // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_fired_missile_hit,     // deathsound
     10 * FRACUNIT,             // speed
     10 * FRACUNIT,             // radius
     6 * FRACUNIT,              // height
     15,                        // mass
     1,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_DROPOFF | MF_MISSILE,    // flags
     MF2_NOTELEPORT | MF2_IMPACT | MF2_PCROSS | MF2_FOOTCLIP | MF2_FIREDAMAGE  // flags2
     },

    {                           // HEXEN_MT_ICEGUY
     8020,                      // doomednum
     HEXEN_S_ICEGUY_LOOK,             // spawnstate
     120,                       // spawnhealth
     HEXEN_S_ICEGUY_WALK1,            // seestate
     hexen_sfx_iceguy_sight,          // seesound
     8,                         // reactiontime
     hexen_sfx_iceguy_attack,         // attacksound
     HEXEN_S_ICEGUY_PAIN1,            // painstate
     144,                       // painchance
     hexen_sfx_None,                  // painsound
     0,                         // meleestate
     HEXEN_S_ICEGUY_ATK1,             // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_ICEGUY_DEATH,            // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     14,                        // speed
     22 * FRACUNIT,             // radius
     75 * FRACUNIT,             // height
     150,                       // mass
     0,                         // damage
     hexen_sfx_iceguy_active,         // activesound
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL | MF_NOBLOOD,       // flags
     MF2_PASSMOBJ | MF2_PUSHWALL | MF2_ICEDAMAGE | MF2_MCROSS | MF2_TELESTOMP   // flags2
     },

    {                           // HEXEN_MT_ICEGUY_FX
     -1,                        // doomednum
     HEXEN_S_ICEGUY_FX1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_ICEGUY_FX_X1,            // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_iceguy_fx_explode,     // deathsound
     14 * FRACUNIT,             // speed
     8 * FRACUNIT,              // radius
     10 * FRACUNIT,             // height
     100,                       // mass
     1,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_ICEDAMAGE     // flags2
     },

    {                           // HEXEN_MT_ICEFX_PUFF
     -1,                        // doomednum
     HEXEN_S_ICEFX_PUFF1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     FRACUNIT,                  // radius
     FRACUNIT,                  // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_SHADOW | MF_DROPOFF,     // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_ICEGUY_FX2
     -1,                        // doomednum
     HEXEN_S_ICEGUY_FX2_1,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     10 * FRACUNIT,             // speed
     4 * FRACUNIT,              // radius
     4 * FRACUNIT,              // height
     100,                       // mass
     1,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_MISSILE,   // flags
     MF2_NOTELEPORT | MF2_LOGRAV | MF2_ICEDAMAGE        // flags2
     },

    {                           // HEXEN_MT_ICEGUY_BIT
     -1,                        // doomednum
     HEXEN_S_ICEGUY_BIT1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     FRACUNIT,                  // radius
     FRACUNIT,                  // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF,        // flags
     MF2_NOTELEPORT | MF2_LOGRAV        // flags2
     },

    {                           // HEXEN_MT_ICEGUY_WISP1
     -1,                        // doomednum
     HEXEN_S_ICEGUY_WISP1_1,          // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_NOGRAVITY | MF_ALTSHADOW | MF_MISSILE,     // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_ICEGUY_WISP2
     -1,                        // doomednum
     HEXEN_S_ICEGUY_WISP2_1,          // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_NOGRAVITY | MF_ALTSHADOW | MF_MISSILE,     // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_FIGHTER_BOSS
     10100,                     // doomednum
     HEXEN_S_FIGHTER,                 // spawnstate
     800,                       // spawnhealth
     HEXEN_S_FIGHTER_RUN1,            // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_FIGHTER_PAIN,            // painstate
     50,                        // painchance
     hexen_sfx_player_fighter_pain,   // painsound
     HEXEN_S_FIGHTER_ATK1,            // meleestate
     HEXEN_S_FIGHTER_ATK1,            // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_FIGHTER_DIE1,            // deathstate
     HEXEN_S_FIGHTER_XDIE1,           // xdeathstate
     hexen_sfx_player_fighter_crazy_death,    // deathsound
     25,                        // speed
     16 * FRACUNIT,             // radius
     64 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL,    // flags
     MF2_FOOTCLIP | MF2_PASSMOBJ | MF2_TELESTOMP | MF2_PUSHWALL | MF2_MCROSS   // flags2
     },

    {                           // HEXEN_MT_CLERIC_BOSS
     10101,                     // doomednum
     HEXEN_S_CLERIC,                  // spawnstate
     800,                       // spawnhealth
     HEXEN_S_CLERIC_RUN1,             // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_CLERIC_PAIN,             // painstate
     50,                        // painchance
     hexen_sfx_player_cleric_pain,    // painsound
     HEXEN_S_CLERIC_ATK1,             // meleestate
     HEXEN_S_CLERIC_ATK1,             // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_CLERIC_DIE1,             // deathstate
     HEXEN_S_CLERIC_XDIE1,            // xdeathstate
     hexen_sfx_player_cleric_crazy_death,     // deathsound
     25,                        // speed
     16 * FRACUNIT,             // radius
     64 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL,    // flags
     MF2_FOOTCLIP | MF2_PASSMOBJ | MF2_TELESTOMP | MF2_PUSHWALL | MF2_MCROSS   // flags2
     },

    {                           // HEXEN_MT_MAGE_BOSS
     10102,                     // doomednum
     HEXEN_S_MAGE,                    // spawnstate
     800,                       // spawnhealth
     HEXEN_S_MAGE_RUN1,               // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_MAGE_PAIN,               // painstate
     50,                        // painchance
     hexen_sfx_player_mage_pain,      // painsound
     HEXEN_S_MAGE_ATK1,               // meleestate
     HEXEN_S_MAGE_ATK1,               // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_MAGE_DIE1,               // deathstate
     HEXEN_S_MAGE_XDIE1,              // xdeathstate
     hexen_sfx_player_mage_crazy_death,       // deathsound
     25,                        // speed
     16 * FRACUNIT,             // radius
     64 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL,    // flags
     MF2_FOOTCLIP | MF2_PASSMOBJ | MF2_TELESTOMP | MF2_PUSHWALL | MF2_MCROSS   // flags2
     },

    {                           // HEXEN_MT_SORCBOSS
     10080,                     // doomednum
     HEXEN_S_SORC_SPAWN1,             // spawnstate
     5000,                      // spawnhealth
     HEXEN_S_SORC_WALK1,              // seestate
     hexen_sfx_sorcerer_sight,        // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_SORC_PAIN1,              // painstate
     10,                        // painchance
     hexen_sfx_sorcerer_pain,         // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_SORC_ATK2_1,             // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_SORC_DIE1,               // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_sorcerer_deathscream,  // deathsound
     16,                        // speed
     40 * FRACUNIT,             // radius
     110 * FRACUNIT,            // height
     500,                       // mass
     9,                         // damage
     hexen_sfx_sorcerer_active,       // activesound
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL | MF_NOBLOOD,       // flags
     MF2_FOOTCLIP | MF2_PASSMOBJ | MF2_PUSHWALL | MF2_BOSS | MF2_MCROSS        // flags2
     },

    {                           // HEXEN_MT_SORCBALL1
     -1,                        // doomednum
     HEXEN_S_SORCBALL1_1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_sorcerer_ballbounce,   // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_SORCBALL1_D1,            // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_SORCBALL1_D5,            // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     10 * FRACUNIT,             // speed
     5 * FRACUNIT,              // radius
     5 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_MISSILE, // flags
     MF2_NOTELEPORT | MF2_FLOORBOUNCE   // flags2
     },

    {                           // HEXEN_MT_SORCBALL2
     -1,                        // doomednum
     HEXEN_S_SORCBALL2_1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_sorcerer_ballbounce,   // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_SORCBALL2_D1,            // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_SORCBALL2_D5,            // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     10 * FRACUNIT,             // speed
     5 * FRACUNIT,              // radius
     5 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_MISSILE, // flags
     MF2_NOTELEPORT | MF2_FLOORBOUNCE   // flags2
     },

    {                           // HEXEN_MT_SORCBALL3
     -1,                        // doomednum
     HEXEN_S_SORCBALL3_1,             // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_sorcerer_ballbounce,   // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_SORCBALL3_D1,            // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_SORCBALL3_D5,            // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     10 * FRACUNIT,             // speed
     5 * FRACUNIT,              // radius
     5 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_MISSILE, // flags
     MF2_NOTELEPORT | MF2_FLOORBOUNCE   // flags2
     },

    {                           // HEXEN_MT_SORCFX1
     -1,                        // doomednum
     HEXEN_S_SORCFX1_1,               // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_sorcerer_ballbounce,   // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_SORCFX1_D1,              // deathstate
     HEXEN_S_SORCFX1_D1,              // xdeathstate
     hexen_sfx_None,                  // deathsound
     7 * FRACUNIT,              // speed
     5 * FRACUNIT,              // radius
     5 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE,        // flags
     MF2_NOTELEPORT | MF2_FLOORBOUNCE   // flags2
     },

    {                           // HEXEN_MT_SORCFX2
     -1,                        // doomednum
     HEXEN_S_SORCFX2_SPLIT1,          // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_SORCFX2T1,               // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     15 * FRACUNIT,             // speed
     5 * FRACUNIT,              // radius
     5 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY,      // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_SORCFX2_T1
     -1,                        // doomednum
     HEXEN_S_SORCFX2T1,               // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_ALTSHADOW,       // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_SORCFX3
     -1,                        // doomednum
     HEXEN_S_SORCFX3_1,               // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_sorcerer_bishopspawn,  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_BISHMORPH1,              // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     15 * FRACUNIT,             // speed
     22 * FRACUNIT,             // radius
     65 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE,        // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_SORCFX3_EXPLOSION
     -1,                        // doomednum
     HEXEN_S_SORCFX3_EXP1,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_ALTSHADOW,       // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_SORCFX4
     -1,                        // doomednum
     HEXEN_S_SORCFX4_1,               // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_SORCFX4_D1,              // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_sorcerer_ballexplode,  // deathsound
     12 * FRACUNIT,             // speed
     10 * FRACUNIT,             // radius
     10 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_MISSILE | MF_NOGRAVITY, // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_SORCSPARK1
     -1,                        // doomednum
     HEXEN_S_SORCSPARK1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     5 * FRACUNIT,              // radius
     5 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF,        // flags
     MF2_NOTELEPORT | MF2_LOGRAV        // flags2
     },

    {                           // HEXEN_MT_BLASTEFFECT
     -1,                        // doomednum
     HEXEN_S_BLASTEFFECT1,            // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_NOCLIP | MF_ALTSHADOW,   // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_WATER_DRIP
     -1,                        // doomednum
     HEXEN_S_WATERDRIP1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_drip,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     1,                         // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_MISSILE,                // flags
     MF2_LOGRAV | MF2_NOTELEPORT        // flags2
     },

    {                           // HEXEN_MT_KORAX
     10200,                     // doomednum
     HEXEN_S_KORAX_LOOK1,             // spawnstate
     5000,                      // spawnhealth
     HEXEN_S_KORAX_CHASE2,            // seestate
     hexen_sfx_korax_sight,           // seesound
     8,                         // reactiontime
     hexen_sfx_korax_attack,          // attacksound
     HEXEN_S_KORAX_PAIN1,             // painstate
     20,                        // painchance
     hexen_sfx_korax_pain,            // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_KORAX_ATTACK1,           // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_KORAX_DEATH1,            // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_korax_death,           // deathsound
     10,                        // speed
     65 * FRACUNIT,             // radius
     115 * FRACUNIT,            // height
     2000,                      // mass
     15,                        // damage
     hexen_sfx_korax_active,          // activesound
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL,    // flags
     MF2_FOOTCLIP | MF2_PUSHWALL | MF2_MCROSS | MF2_TELESTOMP | MF2_BOSS       // flags2
     },

    {                           // HEXEN_MT_KORAX_SPIRIT1
     -1,                        // doomednum
     HEXEN_S_KSPIRIT_ROAM1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     8 * FRACUNIT,              // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_NOGRAVITY | MF_ALTSHADOW | MF_MISSILE | MF_NOCLIP, // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_KORAX_SPIRIT2
     -1,                        // doomednum
     HEXEN_S_KSPIRIT_ROAM1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     8 * FRACUNIT,              // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_NOGRAVITY | MF_ALTSHADOW | MF_MISSILE | MF_NOCLIP, // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_KORAX_SPIRIT3
     -1,                        // doomednum
     HEXEN_S_KSPIRIT_ROAM1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     8 * FRACUNIT,              // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_NOGRAVITY | MF_ALTSHADOW | MF_MISSILE | MF_NOCLIP, // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_KORAX_SPIRIT4
     -1,                        // doomednum
     HEXEN_S_KSPIRIT_ROAM1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     8 * FRACUNIT,              // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_NOGRAVITY | MF_ALTSHADOW | MF_MISSILE | MF_NOCLIP, // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_KORAX_SPIRIT5
     -1,                        // doomednum
     HEXEN_S_KSPIRIT_ROAM1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     8 * FRACUNIT,              // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_NOGRAVITY | MF_ALTSHADOW | MF_MISSILE | MF_NOCLIP, // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_KORAX_SPIRIT6
     -1,                        // doomednum
     HEXEN_S_KSPIRIT_ROAM1,           // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     8 * FRACUNIT,              // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_DROPOFF | MF_NOGRAVITY | MF_ALTSHADOW | MF_MISSILE | MF_NOCLIP, // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_DEMON_MASH
     -1,                        // doomednum
     HEXEN_S_DEMN_LOOK1,              // spawnstate
     250,                       // spawnhealth
     HEXEN_S_DEMN_CHASE1,             // seestate
     hexen_sfx_demon_sight,           // seesound
     8,                         // reactiontime
     hexen_sfx_demon_attack,          // attacksound
     HEXEN_S_DEMN_PAIN1,              // painstate
     50,                        // painchance
     hexen_sfx_demon_pain,            // painsound
     HEXEN_S_DEMN_ATK1_1,             // meleestate
     HEXEN_S_DEMN_ATK2_1,             // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_demon_death,           // deathsound
     13,                        // speed
     32 * FRACUNIT,             // radius
     64 * FRACUNIT,             // height
     220,                       // mass
     0,                         // damage
     hexen_sfx_demon_active,          // activesound
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL | MF_ALTSHADOW | MF_NOBLOOD,        // flags
     MF2_FOOTCLIP | MF2_PASSMOBJ | MF2_MCROSS | MF2_PUSHWALL | MF2_BLASTED     // flags2
     },

    {                           // HEXEN_MT_DEMON2_MASH
     -1,                        // doomednum
     HEXEN_S_DEMN2_LOOK1,             // spawnstate
     250,                       // spawnhealth
     HEXEN_S_DEMN2_CHASE1,            // seestate
     hexen_sfx_demon_sight,           // seesound
     8,                         // reactiontime
     hexen_sfx_demon_attack,          // attacksound
     HEXEN_S_DEMN2_PAIN1,             // painstate
     50,                        // painchance
     hexen_sfx_demon_pain,            // painsound
     HEXEN_S_DEMN2_ATK1_1,            // meleestate
     HEXEN_S_DEMN2_ATK2_1,            // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_demon_death,           // deathsound
     13,                        // speed
     32 * FRACUNIT,             // radius
     64 * FRACUNIT,             // height
     220,                       // mass
     0,                         // damage
     hexen_sfx_demon_active,          // activesound
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL | MF_ALTSHADOW | MF_NOBLOOD,        // flags
     MF2_FOOTCLIP | MF2_PASSMOBJ | MF2_MCROSS | MF2_PUSHWALL | MF2_BLASTED     // flags2
     },

    {                           // HEXEN_MT_ETTIN_MASH
     -1,                        // doomednum
     HEXEN_S_ETTIN_LOOK1,             // spawnstate
     175,                       // spawnhealth
     HEXEN_S_ETTIN_CHASE1,            // seestate
     hexen_sfx_ettin_sight,           // seesound
     8,                         // reactiontime
     hexen_sfx_ettin_attack,          // attacksound
     HEXEN_S_ETTIN_PAIN1,             // painstate
     60,                        // painchance
     hexen_sfx_ettin_pain,            // painsound
     HEXEN_S_ETTIN_ATK1_1,            // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_ettin_death,           // deathsound
     13,                        // speed
     25 * FRACUNIT,             // radius
     68 * FRACUNIT,             // height
     175,                       // mass
     3,                         // damage
     hexen_sfx_ettin_active,          // activesound
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL | MF_ALTSHADOW | MF_NOBLOOD,        // flags
     MF2_FOOTCLIP | MF2_PASSMOBJ | MF2_MCROSS | MF2_PUSHWALL | MF2_BLASTED     // flags2
     },

    {                           // HEXEN_MT_CENTAUR_MASH
     -1,                        // doomednum
     HEXEN_S_CENTAUR_LOOK1,           // spawnstate
     200,                       // spawnhealth
     HEXEN_S_CENTAUR_WALK1,           // seestate
     hexen_sfx_centaur_sight,         // seesound
     8,                         // reactiontime
     hexen_sfx_centaur_attack,        // attacksound
     HEXEN_S_CENTAUR_PAIN1,           // painstate
     135,                       // painchance
     hexen_sfx_centaur_pain,          // painsound
     HEXEN_S_CENTAUR_ATK1,            // meleestate
     0,                         // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_centaur_death,         // deathsound
     13,                        // speed
     20 * FRACUNIT,             // radius
     64 * FRACUNIT,             // height
     120,                       // mass
     0,                         // damage
     hexen_sfx_centaur_active,        // activesound
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL | MF_ALTSHADOW | MF_NOBLOOD,        // flags
     MF2_FOOTCLIP | MF2_PASSMOBJ | MF2_MCROSS | MF2_PUSHWALL | MF2_BLASTED     // flags2
     },

    {                           // HEXEN_MT_KORAX_BOLT
     -1,                        // doomednum
     HEXEN_S_KBOLT1,                  // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     15 * FRACUNIT,             // radius
     35 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_MISSILE | MF_DROPOFF,    // flags
     MF2_NOTELEPORT             // flags2
     },

    {                           // HEXEN_MT_BAT_SPAWNER
     10225,                     // doomednum
     HEXEN_S_SPAWNBATS1,              // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_NULL,                    // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOSECTOR | MF_NOGRAVITY,        // flags
     MF2_DONTDRAW               // flags2
     },

    {                           // HEXEN_MT_BAT
     -1,                        // doomednum
     HEXEN_S_BAT1,                    // spawnstate
     1000,                      // spawnhealth
     HEXEN_S_NULL,                    // seestate
     hexen_sfx_None,                  // seesound
     8,                         // reactiontime
     hexen_sfx_None,                  // attacksound
     HEXEN_S_NULL,                    // painstate
     0,                         // painchance
     hexen_sfx_None,                  // painsound
     HEXEN_S_NULL,                    // meleestate
     HEXEN_S_NULL,                    // missilestate
     HEXEN_S_NULL,                    // crashstate
     HEXEN_S_BAT_DEATH,               // deathstate
     HEXEN_S_NULL,                    // xdeathstate
     hexen_sfx_None,                  // deathsound
     5 * FRACUNIT,              // speed
     3 * FRACUNIT,              // radius
     3 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     hexen_sfx_None,                  // activesound
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_MISSILE, // flags
     MF2_PASSMOBJ | MF2_NOTELEPORT      // flags2
     }
};
