/* This machine-generated file includes source code from GNU Jitter.

   Copyright (C) 2016-2021 Luca Saiu
   Written by Luca Saiu

   GNU Jitter is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published
   by the Free Software Foundation, either version 3 of the License,
   or (at your option) any later version.

   GNU Jitter is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Jitter.  If not, see <http://www.gnu.org/licenses/>.


  Copyright (C) 2016, 2017, 2019, 2020, 2021 Luca Saiu
  Written by Luca Saiu

  This file is part of GNU Jitter.

  GNU Jitter is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  GNU Jitter is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with GNU Jitter.  If not, see <http://www.gnu.org/licenses/>.

*/

/* User-specified code, initial vm2 part: beginning. */

/* User-specified code, initial vm2 part: end */

/* These two macros are convenient for making VM-specific identifiers
   using VM-independent macros from a public header, without polluting
   the global namespace. */
#define JITTER_VM_PREFIX_LOWER_CASE uninspired
#define JITTER_VM_PREFIX_UPPER_CASE UNINSPIRED

//#include <config.h>

#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>

/* Early C code from the user. */
/* End of the early C code from the user. */

#include <jitter/jitter.h>
#include <jitter/jitter-instruction.h>

#define JITTER_THIS_CAN_INCLUDE_JITTER_EXECUTOR_H
#include <jitter/jitter-executor.h>

#ifdef JITTER_ENABLE_ASSEMBLY
#include <jitter/jitter-machine-common.h>
#include <jitter/machine/jitter-machine.h>
#endif // #ifdef JITTER_ENABLE_ASSEMBLY
#include <jitter/jitter-fatal.h>
#include <jitter/jitter-malloc.h>

#include "uninspired-vm.h"
//#include "uninspired-meta-instructions.h"
//#include "uninspired-specialized-instructions.h"
//#include "uninspired-state.h"

/* Include stack data structure support. */
#include <jitter/jitter-stack.h>

/* Include patch-in definitions, only if patch-in is enabled.  We know whether it is
   by checking JITTER_HAVE_PATCH_IN , defined in jitter/jitter-patch-in.h .
   The same for defects. */
#include <jitter/jitter-patch-in.h>
#include <jitter/jitter-fast-branch.h>
#include <jitter/jitter-defect.h>
#ifdef JITTER_HAVE_PATCH_IN
  JITTER_PATCH_IN_DESCRIPTOR_DECLARATIONS_(uninspired);
#endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_HAVE_DEFECT_REPLACEMENT
  static void jitter_useless_function (void) asm ("jitter_fake_target_asm");
  static void jitter_useless_function (void) {}
  JITTER_DEFECT_DESCRIPTOR_DECLARATIONS_(uninspired);
  static const char * const uninspired_fake_target_asm
    = (const char *) & jitter_useless_function;
#endif // #ifdef JITTER_HAVE_DEFECT_REPLACEMENT

/* Always include the non-user fast-branch definitions, which use patch-ins where possible
   or consist in fallback definitions otherwise. */
#include <jitter/jitter-fast-branch.h>

#define JITTER_FAST_BRANCH_PREFIX uninspired_

/* Most of the needed macros are in jitter-executor.h .  This however
   needs to be here, as it relies on a prefix to be substituted. */
#define _JITTER_STATE_BACKING  \
  (jitter_original_state->uninspired_state_backing)
/* Expand to an l-value evaluating to the pending_notification field for
   the current state. */
#define JITTER_PENDING_NOTIFICATIONS  \
  (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA->pending_notifications)
/* Expand to an l-value evaluating to the pending field of the struct
   jitter_signal_notification element for the given signal, for the
   current state. */
#define JITTER_PENDING_SIGNAL_NOTIFICATION(signal_id)  \
  ((UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA->pending_signal_notifications + (signal_id))->pending)

/* Expand to the i-th fast register as an lvalue.  This is used internally,
   always with a literal index . */
#define JITTER_FAST_REGISTER(class, index)                             \
  (JITTER_CONCATENATE_FOUR(jitter_state_runtime.jitter_fast_register_, \
                           class, _, index))

/* Expand to a slow register lvalue, given an offset in bytes from the base. */
#define JITTER_SLOW_REGISTER_FROM_OFFSET(c, offset)               \
  (* ((JITTER_CONCATENATE_TWO(uninspired_register_, c) * restrict)  \
      (((char *) jitter_array_base) + offset)))

/* Expand to the i-th register, which must be a slow register, as an lvalue.
   The given index must be a register index counting from 0 and including fast
   regusters as well, if there are any.  For example if an r class had 3 fast
   registers then the first slow register would be %r3, to be accessed as
   JITTER_SLOW_REGISTER(r, 3).  It would be invalid to access %r0, %r1 and
   %r2 which this macro, as %r0, %r1 and %r2 would be fast. */
#define JITTER_SLOW_REGISTER(c, i)                                          \
  JITTER_SLOW_REGISTER_FROM_OFFSET(c, UNINSPIRED_SLOW_REGISTER_OFFSET(c, i))

/* It's not possible to have a single macro JITTER_REGISTER taking an index and
   expanding to either a fast or a slow register lvalue, due to CPP conditional
   limitations.  This restriction is unfortunate, but we have to live with it
   as long as we don't switch to a different preprocessor.
   What we can have is a set of zero-argument macros each expanding to a register
   lvalue, for *a limited number* of registers.  Here we define access macros for
   every fast register plus a reasonable number (currently 32) of slow registers,
   per class. */
#define JITTER_REGISTER_r_0    JITTER_SLOW_REGISTER(r, 0)
#define JITTER_REGISTER_r_1    JITTER_SLOW_REGISTER(r, 1)
#define JITTER_REGISTER_r_2    JITTER_SLOW_REGISTER(r, 2)
#define JITTER_REGISTER_r_3    JITTER_SLOW_REGISTER(r, 3)
#define JITTER_REGISTER_r_4    JITTER_SLOW_REGISTER(r, 4)
#define JITTER_REGISTER_r_5    JITTER_SLOW_REGISTER(r, 5)
#define JITTER_REGISTER_r_6    JITTER_SLOW_REGISTER(r, 6)
#define JITTER_REGISTER_r_7    JITTER_SLOW_REGISTER(r, 7)
#define JITTER_REGISTER_r_8    JITTER_SLOW_REGISTER(r, 8)
#define JITTER_REGISTER_r_9    JITTER_SLOW_REGISTER(r, 9)
#define JITTER_REGISTER_r_10   JITTER_SLOW_REGISTER(r, 10)
#define JITTER_REGISTER_r_11   JITTER_SLOW_REGISTER(r, 11)
#define JITTER_REGISTER_r_12   JITTER_SLOW_REGISTER(r, 12)
#define JITTER_REGISTER_r_13   JITTER_SLOW_REGISTER(r, 13)
#define JITTER_REGISTER_r_14   JITTER_SLOW_REGISTER(r, 14)
#define JITTER_REGISTER_r_15   JITTER_SLOW_REGISTER(r, 15)
#define JITTER_REGISTER_r_16   JITTER_SLOW_REGISTER(r, 16)
#define JITTER_REGISTER_r_17   JITTER_SLOW_REGISTER(r, 17)
#define JITTER_REGISTER_r_18   JITTER_SLOW_REGISTER(r, 18)
#define JITTER_REGISTER_r_19   JITTER_SLOW_REGISTER(r, 19)
#define JITTER_REGISTER_r_20   JITTER_SLOW_REGISTER(r, 20)
#define JITTER_REGISTER_r_21   JITTER_SLOW_REGISTER(r, 21)
#define JITTER_REGISTER_r_22   JITTER_SLOW_REGISTER(r, 22)
#define JITTER_REGISTER_r_23   JITTER_SLOW_REGISTER(r, 23)
#define JITTER_REGISTER_r_24   JITTER_SLOW_REGISTER(r, 24)
#define JITTER_REGISTER_r_25   JITTER_SLOW_REGISTER(r, 25)
#define JITTER_REGISTER_r_26   JITTER_SLOW_REGISTER(r, 26)
#define JITTER_REGISTER_r_27   JITTER_SLOW_REGISTER(r, 27)
#define JITTER_REGISTER_r_28   JITTER_SLOW_REGISTER(r, 28)
#define JITTER_REGISTER_r_29   JITTER_SLOW_REGISTER(r, 29)
#define JITTER_REGISTER_r_30   JITTER_SLOW_REGISTER(r, 30)
#define JITTER_REGISTER_r_31   JITTER_SLOW_REGISTER(r, 31)
#define JITTER_REGISTER_f_0    JITTER_SLOW_REGISTER(f, 0)
#define JITTER_REGISTER_f_1    JITTER_SLOW_REGISTER(f, 1)
#define JITTER_REGISTER_f_2    JITTER_SLOW_REGISTER(f, 2)
#define JITTER_REGISTER_f_3    JITTER_SLOW_REGISTER(f, 3)
#define JITTER_REGISTER_f_4    JITTER_SLOW_REGISTER(f, 4)
#define JITTER_REGISTER_f_5    JITTER_SLOW_REGISTER(f, 5)
#define JITTER_REGISTER_f_6    JITTER_SLOW_REGISTER(f, 6)
#define JITTER_REGISTER_f_7    JITTER_SLOW_REGISTER(f, 7)
#define JITTER_REGISTER_f_8    JITTER_SLOW_REGISTER(f, 8)
#define JITTER_REGISTER_f_9    JITTER_SLOW_REGISTER(f, 9)
#define JITTER_REGISTER_f_10   JITTER_SLOW_REGISTER(f, 10)
#define JITTER_REGISTER_f_11   JITTER_SLOW_REGISTER(f, 11)
#define JITTER_REGISTER_f_12   JITTER_SLOW_REGISTER(f, 12)
#define JITTER_REGISTER_f_13   JITTER_SLOW_REGISTER(f, 13)
#define JITTER_REGISTER_f_14   JITTER_SLOW_REGISTER(f, 14)
#define JITTER_REGISTER_f_15   JITTER_SLOW_REGISTER(f, 15)
#define JITTER_REGISTER_f_16   JITTER_SLOW_REGISTER(f, 16)
#define JITTER_REGISTER_f_17   JITTER_SLOW_REGISTER(f, 17)
#define JITTER_REGISTER_f_18   JITTER_SLOW_REGISTER(f, 18)
#define JITTER_REGISTER_f_19   JITTER_SLOW_REGISTER(f, 19)
#define JITTER_REGISTER_f_20   JITTER_SLOW_REGISTER(f, 20)
#define JITTER_REGISTER_f_21   JITTER_SLOW_REGISTER(f, 21)
#define JITTER_REGISTER_f_22   JITTER_SLOW_REGISTER(f, 22)
#define JITTER_REGISTER_f_23   JITTER_SLOW_REGISTER(f, 23)
#define JITTER_REGISTER_f_24   JITTER_SLOW_REGISTER(f, 24)
#define JITTER_REGISTER_f_25   JITTER_SLOW_REGISTER(f, 25)
#define JITTER_REGISTER_f_26   JITTER_SLOW_REGISTER(f, 26)
#define JITTER_REGISTER_f_27   JITTER_SLOW_REGISTER(f, 27)
#define JITTER_REGISTER_f_28   JITTER_SLOW_REGISTER(f, 28)
#define JITTER_REGISTER_f_29   JITTER_SLOW_REGISTER(f, 29)
#define JITTER_REGISTER_f_30   JITTER_SLOW_REGISTER(f, 30)
#define JITTER_REGISTER_f_31   JITTER_SLOW_REGISTER(f, 31)
#define JITTER_REGISTER_v_0    JITTER_SLOW_REGISTER(v, 0)
#define JITTER_REGISTER_v_1    JITTER_SLOW_REGISTER(v, 1)
#define JITTER_REGISTER_v_2    JITTER_SLOW_REGISTER(v, 2)
#define JITTER_REGISTER_v_3    JITTER_SLOW_REGISTER(v, 3)
#define JITTER_REGISTER_v_4    JITTER_SLOW_REGISTER(v, 4)
#define JITTER_REGISTER_v_5    JITTER_SLOW_REGISTER(v, 5)
#define JITTER_REGISTER_v_6    JITTER_SLOW_REGISTER(v, 6)
#define JITTER_REGISTER_v_7    JITTER_SLOW_REGISTER(v, 7)
#define JITTER_REGISTER_v_8    JITTER_SLOW_REGISTER(v, 8)
#define JITTER_REGISTER_v_9    JITTER_SLOW_REGISTER(v, 9)
#define JITTER_REGISTER_v_10   JITTER_SLOW_REGISTER(v, 10)
#define JITTER_REGISTER_v_11   JITTER_SLOW_REGISTER(v, 11)
#define JITTER_REGISTER_v_12   JITTER_SLOW_REGISTER(v, 12)
#define JITTER_REGISTER_v_13   JITTER_SLOW_REGISTER(v, 13)
#define JITTER_REGISTER_v_14   JITTER_SLOW_REGISTER(v, 14)
#define JITTER_REGISTER_v_15   JITTER_SLOW_REGISTER(v, 15)
#define JITTER_REGISTER_v_16   JITTER_SLOW_REGISTER(v, 16)
#define JITTER_REGISTER_v_17   JITTER_SLOW_REGISTER(v, 17)
#define JITTER_REGISTER_v_18   JITTER_SLOW_REGISTER(v, 18)
#define JITTER_REGISTER_v_19   JITTER_SLOW_REGISTER(v, 19)
#define JITTER_REGISTER_v_20   JITTER_SLOW_REGISTER(v, 20)
#define JITTER_REGISTER_v_21   JITTER_SLOW_REGISTER(v, 21)
#define JITTER_REGISTER_v_22   JITTER_SLOW_REGISTER(v, 22)
#define JITTER_REGISTER_v_23   JITTER_SLOW_REGISTER(v, 23)
#define JITTER_REGISTER_v_24   JITTER_SLOW_REGISTER(v, 24)
#define JITTER_REGISTER_v_25   JITTER_SLOW_REGISTER(v, 25)
#define JITTER_REGISTER_v_26   JITTER_SLOW_REGISTER(v, 26)
#define JITTER_REGISTER_v_27   JITTER_SLOW_REGISTER(v, 27)
#define JITTER_REGISTER_v_28   JITTER_SLOW_REGISTER(v, 28)
#define JITTER_REGISTER_v_29   JITTER_SLOW_REGISTER(v, 29)
#define JITTER_REGISTER_v_30   JITTER_SLOW_REGISTER(v, 30)
#define JITTER_REGISTER_v_31   JITTER_SLOW_REGISTER(v, 31)
#define JITTER_REGISTER_c_0    JITTER_SLOW_REGISTER(c, 0)
#define JITTER_REGISTER_c_1    JITTER_SLOW_REGISTER(c, 1)
#define JITTER_REGISTER_c_2    JITTER_SLOW_REGISTER(c, 2)
#define JITTER_REGISTER_c_3    JITTER_SLOW_REGISTER(c, 3)
#define JITTER_REGISTER_c_4    JITTER_SLOW_REGISTER(c, 4)
#define JITTER_REGISTER_c_5    JITTER_SLOW_REGISTER(c, 5)
#define JITTER_REGISTER_c_6    JITTER_SLOW_REGISTER(c, 6)
#define JITTER_REGISTER_c_7    JITTER_SLOW_REGISTER(c, 7)
#define JITTER_REGISTER_c_8    JITTER_SLOW_REGISTER(c, 8)
#define JITTER_REGISTER_c_9    JITTER_SLOW_REGISTER(c, 9)
#define JITTER_REGISTER_c_10   JITTER_SLOW_REGISTER(c, 10)
#define JITTER_REGISTER_c_11   JITTER_SLOW_REGISTER(c, 11)
#define JITTER_REGISTER_c_12   JITTER_SLOW_REGISTER(c, 12)
#define JITTER_REGISTER_c_13   JITTER_SLOW_REGISTER(c, 13)
#define JITTER_REGISTER_c_14   JITTER_SLOW_REGISTER(c, 14)
#define JITTER_REGISTER_c_15   JITTER_SLOW_REGISTER(c, 15)
#define JITTER_REGISTER_c_16   JITTER_SLOW_REGISTER(c, 16)
#define JITTER_REGISTER_c_17   JITTER_SLOW_REGISTER(c, 17)
#define JITTER_REGISTER_c_18   JITTER_SLOW_REGISTER(c, 18)
#define JITTER_REGISTER_c_19   JITTER_SLOW_REGISTER(c, 19)
#define JITTER_REGISTER_c_20   JITTER_SLOW_REGISTER(c, 20)
#define JITTER_REGISTER_c_21   JITTER_SLOW_REGISTER(c, 21)
#define JITTER_REGISTER_c_22   JITTER_SLOW_REGISTER(c, 22)
#define JITTER_REGISTER_c_23   JITTER_SLOW_REGISTER(c, 23)
#define JITTER_REGISTER_c_24   JITTER_SLOW_REGISTER(c, 24)
#define JITTER_REGISTER_c_25   JITTER_SLOW_REGISTER(c, 25)
#define JITTER_REGISTER_c_26   JITTER_SLOW_REGISTER(c, 26)
#define JITTER_REGISTER_c_27   JITTER_SLOW_REGISTER(c, 27)
#define JITTER_REGISTER_c_28   JITTER_SLOW_REGISTER(c, 28)
#define JITTER_REGISTER_c_29   JITTER_SLOW_REGISTER(c, 29)
#define JITTER_REGISTER_c_30   JITTER_SLOW_REGISTER(c, 30)
#define JITTER_REGISTER_c_31   JITTER_SLOW_REGISTER(c, 31)


#ifdef JITTER_DISPATCH_NO_THREADING

/* Reserve the scratch register, if any. */
#ifdef JITTER_SCRATCH_REGISTER
  register union jitter_word
  jitter_residual_argument_scratch_register_variable asm (JITTER_STRINGIFY(JITTER_SCRATCH_REGISTER));
#endif // #ifdef JITTER_SCRATCH_REGISTER

/* Reserve The Array base register. */
#ifndef JITTER_BASE_REGISTER
# error "the machine does not define JITTER_BASE_REGISTER"
#else
register char * restrict
uninspired_array_base_register_variable asm (JITTER_STRINGIFY(JITTER_BASE_REGISTER));
#endif // #ifndef JITTER_BASE_REGISTER

/* Reserve registers for our 5 residual arguments.  If this particular VM doesn't
   need all of those supported by the assembly machine then reserve only the first
   ones.  If, on the other hand, we need more residual arguments than we have
   available registers, use CPP macros to map the remaining residual arguments
   to memory locations relative to the base, with constant offsets. */

/* Define a macro for the 0-th residual as a register, or as a residual
   memory slot.  Also define a macro expanding to inline asm code with
   output constraints on the appropriate register or memory, to let GCC
   know that its value has been changed by unknown code. */
#if (0 < JITTER_RESIDUAL_REGISTER_NO)
  register union jitter_word
  jitter_residual_argument_0_register_variable asm (JITTER_STRINGIFY(JITTER_RESIDUAL_REGISTER_0));
# define JITTER_RESIDUAL_ARGUMENT_0               \
    jitter_residual_argument_0_register_variable
# define JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY                 \
    JITTER_MARK_REGISTER_AS_SET_BY_ASSEMBLY(jitter_residual_argument_0_register_variable)
#else
# define JITTER_RESIDUAL_ARGUMENT_0  \
    (* (union jitter_word *)                 \
       (jitter_array_base + UNINSPIRED_RESIDUAL_OFFSET(0)))
# define JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY                    \
    JITTER_MARK_MEMORY_AS_SET_BY_ASSEMBLY(JITTER_RESIDUAL_ARGUMENT_0)
#endif // #if (0 < JITTER_RESIDUAL_REGISTER_NO)

/* Define a macro for the 1-th residual as a register, or as a residual
   memory slot.  Also define a macro expanding to inline asm code with
   output constraints on the appropriate register or memory, to let GCC
   know that its value has been changed by unknown code. */
#if (1 < JITTER_RESIDUAL_REGISTER_NO)
  register union jitter_word
  jitter_residual_argument_1_register_variable asm (JITTER_STRINGIFY(JITTER_RESIDUAL_REGISTER_1));
# define JITTER_RESIDUAL_ARGUMENT_1               \
    jitter_residual_argument_1_register_variable
# define JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY                 \
    JITTER_MARK_REGISTER_AS_SET_BY_ASSEMBLY(jitter_residual_argument_1_register_variable)
#else
# define JITTER_RESIDUAL_ARGUMENT_1  \
    (* (union jitter_word *)                 \
       (jitter_array_base + UNINSPIRED_RESIDUAL_OFFSET(1)))
# define JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY                    \
    JITTER_MARK_MEMORY_AS_SET_BY_ASSEMBLY(JITTER_RESIDUAL_ARGUMENT_1)
#endif // #if (1 < JITTER_RESIDUAL_REGISTER_NO)

/* Define a macro for the 2-th residual as a register, or as a residual
   memory slot.  Also define a macro expanding to inline asm code with
   output constraints on the appropriate register or memory, to let GCC
   know that its value has been changed by unknown code. */
#if (2 < JITTER_RESIDUAL_REGISTER_NO)
  register union jitter_word
  jitter_residual_argument_2_register_variable asm (JITTER_STRINGIFY(JITTER_RESIDUAL_REGISTER_2));
# define JITTER_RESIDUAL_ARGUMENT_2               \
    jitter_residual_argument_2_register_variable
# define JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY                 \
    JITTER_MARK_REGISTER_AS_SET_BY_ASSEMBLY(jitter_residual_argument_2_register_variable)
#else
# define JITTER_RESIDUAL_ARGUMENT_2  \
    (* (union jitter_word *)                 \
       (jitter_array_base + UNINSPIRED_RESIDUAL_OFFSET(2)))
# define JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY                    \
    JITTER_MARK_MEMORY_AS_SET_BY_ASSEMBLY(JITTER_RESIDUAL_ARGUMENT_2)
#endif // #if (2 < JITTER_RESIDUAL_REGISTER_NO)

/* Define a macro for the 3-th residual as a register, or as a residual
   memory slot.  Also define a macro expanding to inline asm code with
   output constraints on the appropriate register or memory, to let GCC
   know that its value has been changed by unknown code. */
#if (3 < JITTER_RESIDUAL_REGISTER_NO)
  register union jitter_word
  jitter_residual_argument_3_register_variable asm (JITTER_STRINGIFY(JITTER_RESIDUAL_REGISTER_3));
# define JITTER_RESIDUAL_ARGUMENT_3               \
    jitter_residual_argument_3_register_variable
# define JITTER_MARK_RESIDUAL_3_AS_SET_BY_ASSEMBLY                 \
    JITTER_MARK_REGISTER_AS_SET_BY_ASSEMBLY(jitter_residual_argument_3_register_variable)
#else
# define JITTER_RESIDUAL_ARGUMENT_3  \
    (* (union jitter_word *)                 \
       (jitter_array_base + UNINSPIRED_RESIDUAL_OFFSET(3)))
# define JITTER_MARK_RESIDUAL_3_AS_SET_BY_ASSEMBLY                    \
    JITTER_MARK_MEMORY_AS_SET_BY_ASSEMBLY(JITTER_RESIDUAL_ARGUMENT_3)
#endif // #if (3 < JITTER_RESIDUAL_REGISTER_NO)

/* Define a macro for the 4-th residual as a register, or as a residual
   memory slot.  Also define a macro expanding to inline asm code with
   output constraints on the appropriate register or memory, to let GCC
   know that its value has been changed by unknown code. */
#if (4 < JITTER_RESIDUAL_REGISTER_NO)
  register union jitter_word
  jitter_residual_argument_4_register_variable asm (JITTER_STRINGIFY(JITTER_RESIDUAL_REGISTER_4));
# define JITTER_RESIDUAL_ARGUMENT_4               \
    jitter_residual_argument_4_register_variable
# define JITTER_MARK_RESIDUAL_4_AS_SET_BY_ASSEMBLY                 \
    JITTER_MARK_REGISTER_AS_SET_BY_ASSEMBLY(jitter_residual_argument_4_register_variable)
#else
# define JITTER_RESIDUAL_ARGUMENT_4  \
    (* (union jitter_word *)                 \
       (jitter_array_base + UNINSPIRED_RESIDUAL_OFFSET(4)))
# define JITTER_MARK_RESIDUAL_4_AS_SET_BY_ASSEMBLY                    \
    JITTER_MARK_MEMORY_AS_SET_BY_ASSEMBLY(JITTER_RESIDUAL_ARGUMENT_4)
#endif // #if (4 < JITTER_RESIDUAL_REGISTER_NO)

/* The global register values we reserve in this compilation unit are
   callee-save: the called function is supposed to save them before
   setting them, and restore them to their previous value before
   returning to the caller.  Of course this is not done automatically
   in this compilation unit, so we have to do it by hand.  Notice that
   every variable allocated to a register by GCC will not use the
   registers we reserved, so we can be sure that, if we save our
   global register variables before setting them for the first time,
   their values will be the ones we want to retain. */

/* The buffer where I keep the original register values needs to hold
   every residual register, plus possibly the scratch register and the
   residual base; those two registers are not always used, but allocating
   just two words more costs essentially nothing and lets me simplify
   the code a little.  The two words are not written or read unless
   needed. */
#define UNINSPIRED_REGISTER_BUFFER_ELEMENT_NO (JITTER_RESIDUAL_REGISTER_NO + 2)
__attribute__ ((noinline, cold))

static void
uninspired_save_registers (union jitter_word *buffer)
{
  buffer [0].pointer = (union jitter_word*) uninspired_array_base_register_variable;
#ifdef JITTER_SCRATCH_REGISTER
  buffer [1] = jitter_residual_argument_scratch_register_variable;
#endif // #ifdef JITTER_SCRATCH_REGISTER
#if (0 < JITTER_RESIDUAL_REGISTER_NO)
  buffer [0 + 2] = JITTER_RESIDUAL_ARGUMENT_0;
#endif // #if (0 < JITTER_RESIDUAL_REGISTER_NO)
#if (1 < JITTER_RESIDUAL_REGISTER_NO)
  buffer [1 + 2] = JITTER_RESIDUAL_ARGUMENT_1;
#endif // #if (1 < JITTER_RESIDUAL_REGISTER_NO)
#if (2 < JITTER_RESIDUAL_REGISTER_NO)
  buffer [2 + 2] = JITTER_RESIDUAL_ARGUMENT_2;
#endif // #if (2 < JITTER_RESIDUAL_REGISTER_NO)
#if (3 < JITTER_RESIDUAL_REGISTER_NO)
  buffer [3 + 2] = JITTER_RESIDUAL_ARGUMENT_3;
#endif // #if (3 < JITTER_RESIDUAL_REGISTER_NO)
#if (4 < JITTER_RESIDUAL_REGISTER_NO)
  buffer [4 + 2] = JITTER_RESIDUAL_ARGUMENT_4;
#endif // #if (4 < JITTER_RESIDUAL_REGISTER_NO)
}

__attribute__ ((noinline, cold))
static void
uninspired_restore_registers (const union jitter_word *buffer)
{
  uninspired_array_base_register_variable = (char *) buffer [0].pointer;
#ifdef JITTER_SCRATCH_REGISTER
  jitter_residual_argument_scratch_register_variable = buffer [1];
#endif // #ifdef JITTER_SCRATCH_REGISTER
#if (0 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_RESIDUAL_ARGUMENT_0 = buffer [0 + 2];
#endif // #if (0 < JITTER_RESIDUAL_REGISTER_NO)
#if (1 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_RESIDUAL_ARGUMENT_1 = buffer [1 + 2];
#endif // #if (1 < JITTER_RESIDUAL_REGISTER_NO)
#if (2 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_RESIDUAL_ARGUMENT_2 = buffer [2 + 2];
#endif // #if (2 < JITTER_RESIDUAL_REGISTER_NO)
#if (3 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_RESIDUAL_ARGUMENT_3 = buffer [3 + 2];
#endif // #if (3 < JITTER_RESIDUAL_REGISTER_NO)
#if (4 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_RESIDUAL_ARGUMENT_4 = buffer [4 + 2];
#endif // #if (4 < JITTER_RESIDUAL_REGISTER_NO)
}

#endif // #ifdef JITTER_DISPATCH_NO_THREADING


/* The following stack operations (without the initial state
   argument) can be used inside instruction code blocks.
   Notice that macros with the same "UNINSPIRED_" names are
   defined in the generated header to be used out of VM code,
   but those alternative definitions have an additional first
   argument, a VM state pointer. */

/* Wrapper definition of the top operation for the
   TOS-optimized stack "stack". */
#undef JITTER_TOP_STACK
#undef UNINSPIRED_TOP_STACK
#define UNINSPIRED_TOP_STACK /* The preferred name. */ \
  JITTER_TOP_STACK
#define JITTER_TOP_STACK()  \
  JITTER_STACK_TOS_TOP (union jitter_word,  \
    jitter_state_runtime. /* not an error */,  \
    stack  \
    )
/* Wrapper definition of the under_top operation for the
   TOS-optimized stack "stack". */
#undef JITTER_UNDER_TOP_STACK
#undef UNINSPIRED_UNDER_TOP_STACK
#define UNINSPIRED_UNDER_TOP_STACK /* The preferred name. */ \
  JITTER_UNDER_TOP_STACK
#define JITTER_UNDER_TOP_STACK()  \
  JITTER_STACK_TOS_UNDER_TOP (union jitter_word,  \
    jitter_state_runtime. /* not an error */,  \
    stack  \
    )
/* Wrapper definition of the at_depth operation for the
   TOS-optimized stack "stack". */
#undef JITTER_AT_DEPTH_STACK
#undef UNINSPIRED_AT_DEPTH_STACK
#define UNINSPIRED_AT_DEPTH_STACK /* The preferred name. */ \
  JITTER_AT_DEPTH_STACK
#define JITTER_AT_DEPTH_STACK(x0)  \
  JITTER_STACK_TOS_AT_DEPTH (union jitter_word,  \
    jitter_state_runtime. /* not an error */,  \
    stack  \
    , x0)
/* Wrapper definition of the at_nonzero_depth operation for the
   TOS-optimized stack "stack". */
#undef JITTER_AT_NONZERO_DEPTH_STACK
#undef UNINSPIRED_AT_NONZERO_DEPTH_STACK
#define UNINSPIRED_AT_NONZERO_DEPTH_STACK /* The preferred name. */ \
  JITTER_AT_NONZERO_DEPTH_STACK
#define JITTER_AT_NONZERO_DEPTH_STACK(x0)  \
  JITTER_STACK_TOS_AT_NONZERO_DEPTH (union jitter_word,  \
    jitter_state_runtime. /* not an error */,  \
    stack  \
    , x0)
/* Wrapper definition of the set_at_depth operation for the
   TOS-optimized stack "stack". */
#undef JITTER_SET_AT_DEPTH_STACK
#undef UNINSPIRED_SET_AT_DEPTH_STACK
#define UNINSPIRED_SET_AT_DEPTH_STACK /* The preferred name. */ \
  JITTER_SET_AT_DEPTH_STACK
#define JITTER_SET_AT_DEPTH_STACK(x0, x1)  \
  JITTER_STACK_TOS_SET_AT_DEPTH (union jitter_word,  \
    jitter_state_runtime. /* not an error */,  \
    stack  \
    , x0, x1)
/* Wrapper definition of the set_at_nonzero_depth operation for the
   TOS-optimized stack "stack". */
#undef JITTER_SET_AT_NONZERO_DEPTH_STACK
#undef UNINSPIRED_SET_AT_NONZERO_DEPTH_STACK
#define UNINSPIRED_SET_AT_NONZERO_DEPTH_STACK /* The preferred name. */ \
  JITTER_SET_AT_NONZERO_DEPTH_STACK
#define JITTER_SET_AT_NONZERO_DEPTH_STACK(x0, x1)  \
  JITTER_STACK_TOS_SET_AT_NONZERO_DEPTH (union jitter_word,  \
    jitter_state_runtime. /* not an error */,  \
    stack  \
    , x0, x1)
/* Wrapper definition of the push_unspecified operation for the
   TOS-optimized stack "stack". */
#undef JITTER_PUSH_UNSPECIFIED_STACK
#undef UNINSPIRED_PUSH_UNSPECIFIED_STACK
#define UNINSPIRED_PUSH_UNSPECIFIED_STACK /* The preferred name. */ \
  JITTER_PUSH_UNSPECIFIED_STACK
#define JITTER_PUSH_UNSPECIFIED_STACK()  \
  JITTER_STACK_TOS_PUSH_UNSPECIFIED (union jitter_word,  \
    jitter_state_runtime. /* not an error */,  \
    stack  \
    )
/* Wrapper definition of the push operation for the
   TOS-optimized stack "stack". */
#undef JITTER_PUSH_STACK
#undef UNINSPIRED_PUSH_STACK
#define UNINSPIRED_PUSH_STACK /* The preferred name. */ \
  JITTER_PUSH_STACK
#define JITTER_PUSH_STACK(x0)  \
  JITTER_STACK_TOS_PUSH (union jitter_word,  \
    jitter_state_runtime. /* not an error */,  \
    stack  \
    , x0)
/* Wrapper definition of the under_push_unspecified operation for the
   TOS-optimized stack "stack". */
#undef JITTER_UNDER_PUSH_UNSPECIFIED_STACK
#undef UNINSPIRED_UNDER_PUSH_UNSPECIFIED_STACK
#define UNINSPIRED_UNDER_PUSH_UNSPECIFIED_STACK /* The preferred name. */ \
  JITTER_UNDER_PUSH_UNSPECIFIED_STACK
#define JITTER_UNDER_PUSH_UNSPECIFIED_STACK()  \
  JITTER_STACK_TOS_UNDER_PUSH_UNSPECIFIED (union jitter_word,  \
    jitter_state_runtime. /* not an error */,  \
    stack  \
    )
/* Wrapper definition of the under_push operation for the
   TOS-optimized stack "stack". */
#undef JITTER_UNDER_PUSH_STACK
#undef UNINSPIRED_UNDER_PUSH_STACK
#define UNINSPIRED_UNDER_PUSH_STACK /* The preferred name. */ \
  JITTER_UNDER_PUSH_STACK
#define JITTER_UNDER_PUSH_STACK(x0)  \
  JITTER_STACK_TOS_UNDER_PUSH (union jitter_word,  \
    jitter_state_runtime. /* not an error */,  \
    stack  \
    , x0)
/* Wrapper definition of the drop operation for the
   TOS-optimized stack "stack". */
#undef JITTER_DROP_STACK
#undef UNINSPIRED_DROP_STACK
#define UNINSPIRED_DROP_STACK /* The preferred name. */ \
  JITTER_DROP_STACK
#define JITTER_DROP_STACK()  \
  JITTER_STACK_TOS_DROP (union jitter_word,  \
    jitter_state_runtime. /* not an error */,  \
    stack  \
    )
/* Wrapper definition of the dup operation for the
   TOS-optimized stack "stack". */
#undef JITTER_DUP_STACK
#undef UNINSPIRED_DUP_STACK
#define UNINSPIRED_DUP_STACK /* The preferred name. */ \
  JITTER_DUP_STACK
#define JITTER_DUP_STACK()  \
  JITTER_STACK_TOS_DUP (union jitter_word,  \
    jitter_state_runtime. /* not an error */,  \
    stack  \
    )
/* Wrapper definition of the swap operation for the
   TOS-optimized stack "stack". */
#undef JITTER_SWAP_STACK
#undef UNINSPIRED_SWAP_STACK
#define UNINSPIRED_SWAP_STACK /* The preferred name. */ \
  JITTER_SWAP_STACK
#define JITTER_SWAP_STACK()  \
  JITTER_STACK_TOS_SWAP (union jitter_word,  \
    jitter_state_runtime. /* not an error */,  \
    stack  \
    )
/* Wrapper definition of the quake operation for the
   TOS-optimized stack "stack". */
#undef JITTER_QUAKE_STACK
#undef UNINSPIRED_QUAKE_STACK
#define UNINSPIRED_QUAKE_STACK /* The preferred name. */ \
  JITTER_QUAKE_STACK
#define JITTER_QUAKE_STACK()  \
  JITTER_STACK_TOS_QUAKE (union jitter_word,  \
    jitter_state_runtime. /* not an error */,  \
    stack  \
    )
/* Wrapper definition of the over operation for the
   TOS-optimized stack "stack". */
#undef JITTER_OVER_STACK
#undef UNINSPIRED_OVER_STACK
#define UNINSPIRED_OVER_STACK /* The preferred name. */ \
  JITTER_OVER_STACK
#define JITTER_OVER_STACK()  \
  JITTER_STACK_TOS_OVER (union jitter_word,  \
    jitter_state_runtime. /* not an error */,  \
    stack  \
    )
/* Wrapper definition of the tuck operation for the
   TOS-optimized stack "stack". */
#undef JITTER_TUCK_STACK
#undef UNINSPIRED_TUCK_STACK
#define UNINSPIRED_TUCK_STACK /* The preferred name. */ \
  JITTER_TUCK_STACK
#define JITTER_TUCK_STACK()  \
  JITTER_STACK_TOS_TUCK (union jitter_word,  \
    jitter_state_runtime. /* not an error */,  \
    stack  \
    )
/* Wrapper definition of the nip operation for the
   TOS-optimized stack "stack". */
#undef JITTER_NIP_STACK
#undef UNINSPIRED_NIP_STACK
#define UNINSPIRED_NIP_STACK /* The preferred name. */ \
  JITTER_NIP_STACK
#define JITTER_NIP_STACK()  \
  JITTER_STACK_TOS_NIP (union jitter_word,  \
    jitter_state_runtime. /* not an error */,  \
    stack  \
    )
/* Wrapper definition of the rot operation for the
   TOS-optimized stack "stack". */
#undef JITTER_ROT_STACK
#undef UNINSPIRED_ROT_STACK
#define UNINSPIRED_ROT_STACK /* The preferred name. */ \
  JITTER_ROT_STACK
#define JITTER_ROT_STACK()  \
  JITTER_STACK_TOS_ROT (union jitter_word,  \
    jitter_state_runtime. /* not an error */,  \
    stack  \
    )
/* Wrapper definition of the mrot operation for the
   TOS-optimized stack "stack". */
#undef JITTER_MROT_STACK
#undef UNINSPIRED_MROT_STACK
#define UNINSPIRED_MROT_STACK /* The preferred name. */ \
  JITTER_MROT_STACK
#define JITTER_MROT_STACK()  \
  JITTER_STACK_TOS_MROT (union jitter_word,  \
    jitter_state_runtime. /* not an error */,  \
    stack  \
    )
/* Wrapper definition of the roll operation for the
   TOS-optimized stack "stack". */
#undef JITTER_ROLL_STACK
#undef UNINSPIRED_ROLL_STACK
#define UNINSPIRED_ROLL_STACK /* The preferred name. */ \
  JITTER_ROLL_STACK
#define JITTER_ROLL_STACK(x0)  \
  JITTER_STACK_TOS_ROLL (union jitter_word,  \
    jitter_state_runtime. /* not an error */,  \
    stack  \
    , x0)
/* Wrapper definition of the mroll operation for the
   TOS-optimized stack "stack". */
#undef JITTER_MROLL_STACK
#undef UNINSPIRED_MROLL_STACK
#define UNINSPIRED_MROLL_STACK /* The preferred name. */ \
  JITTER_MROLL_STACK
#define JITTER_MROLL_STACK(x0)  \
  JITTER_STACK_TOS_MROLL (union jitter_word,  \
    jitter_state_runtime. /* not an error */,  \
    stack  \
    , x0)
/* Wrapper definition of the slide operation for the
   TOS-optimized stack "stack". */
#undef JITTER_SLIDE_STACK
#undef UNINSPIRED_SLIDE_STACK
#define UNINSPIRED_SLIDE_STACK /* The preferred name. */ \
  JITTER_SLIDE_STACK
#define JITTER_SLIDE_STACK(x0, x1)  \
  JITTER_STACK_TOS_SLIDE (union jitter_word,  \
    jitter_state_runtime. /* not an error */,  \
    stack  \
    , x0, x1)
/* Wrapper definition of the whirl operation for the
   TOS-optimized stack "stack". */
#undef JITTER_WHIRL_STACK
#undef UNINSPIRED_WHIRL_STACK
#define UNINSPIRED_WHIRL_STACK /* The preferred name. */ \
  JITTER_WHIRL_STACK
#define JITTER_WHIRL_STACK(x0)  \
  JITTER_STACK_TOS_WHIRL (union jitter_word,  \
    jitter_state_runtime. /* not an error */,  \
    stack  \
    , x0)
/* Wrapper definition of the bulge operation for the
   TOS-optimized stack "stack". */
#undef JITTER_BULGE_STACK
#undef UNINSPIRED_BULGE_STACK
#define UNINSPIRED_BULGE_STACK /* The preferred name. */ \
  JITTER_BULGE_STACK
#define JITTER_BULGE_STACK(x0)  \
  JITTER_STACK_TOS_BULGE (union jitter_word,  \
    jitter_state_runtime. /* not an error */,  \
    stack  \
    , x0)
/* Wrapper definition of the height operation for the
   TOS-optimized stack "stack". */
#undef JITTER_HEIGHT_STACK
#undef UNINSPIRED_HEIGHT_STACK
#define UNINSPIRED_HEIGHT_STACK /* The preferred name. */ \
  JITTER_HEIGHT_STACK
#define JITTER_HEIGHT_STACK()  \
  JITTER_STACK_TOS_HEIGHT (union jitter_word,  \
    jitter_state_runtime. /* not an error */,  \
    stack  \
    )
/* Wrapper definition of the set_height operation for the
   TOS-optimized stack "stack". */
#undef JITTER_SET_HEIGHT_STACK
#undef UNINSPIRED_SET_HEIGHT_STACK
#define UNINSPIRED_SET_HEIGHT_STACK /* The preferred name. */ \
  JITTER_SET_HEIGHT_STACK
#define JITTER_SET_HEIGHT_STACK(x0)  \
  JITTER_STACK_TOS_SET_HEIGHT (union jitter_word,  \
    jitter_state_runtime. /* not an error */,  \
    stack  \
    , x0)
/* Wrapper definition of the reverse operation for the
   TOS-optimized stack "stack". */
#undef JITTER_REVERSE_STACK
#undef UNINSPIRED_REVERSE_STACK
#define UNINSPIRED_REVERSE_STACK /* The preferred name. */ \
  JITTER_REVERSE_STACK
#define JITTER_REVERSE_STACK(x0)  \
  JITTER_STACK_TOS_REVERSE (union jitter_word,  \
    jitter_state_runtime. /* not an error */,  \
    stack  \
    , x0)
/* Wrapper definition of the unary operation for the
   TOS-optimized stack "stack". */
#undef JITTER_UNARY_STACK
#undef UNINSPIRED_UNARY_STACK
#define UNINSPIRED_UNARY_STACK /* The preferred name. */ \
  JITTER_UNARY_STACK
#define JITTER_UNARY_STACK(x0)  \
  JITTER_STACK_TOS_UNARY (union jitter_word,  \
    jitter_state_runtime. /* not an error */,  \
    stack  \
    , x0)
/* Wrapper definition of the binary operation for the
   TOS-optimized stack "stack". */
#undef JITTER_BINARY_STACK
#undef UNINSPIRED_BINARY_STACK
#define UNINSPIRED_BINARY_STACK /* The preferred name. */ \
  JITTER_BINARY_STACK
#define JITTER_BINARY_STACK(x0)  \
  JITTER_STACK_TOS_BINARY (union jitter_word,  \
    jitter_state_runtime. /* not an error */,  \
    stack  \
    , x0)
/* Wrapper definition of the top operation for the
   non-TOS-optimized stack "handlers". */
#undef JITTER_TOP_HANDLERS
#undef UNINSPIRED_TOP_HANDLERS
#define UNINSPIRED_TOP_HANDLERS /* The preferred name. */ \
  JITTER_TOP_HANDLERS
#define JITTER_TOP_HANDLERS()  \
  JITTER_STACK_NTOS_TOP (struct exception_handler,  \
    jitter_state_runtime. /* not an error */,  \
    handlers  \
    )
/* Wrapper definition of the under_top operation for the
   non-TOS-optimized stack "handlers". */
#undef JITTER_UNDER_TOP_HANDLERS
#undef UNINSPIRED_UNDER_TOP_HANDLERS
#define UNINSPIRED_UNDER_TOP_HANDLERS /* The preferred name. */ \
  JITTER_UNDER_TOP_HANDLERS
#define JITTER_UNDER_TOP_HANDLERS()  \
  JITTER_STACK_NTOS_UNDER_TOP (struct exception_handler,  \
    jitter_state_runtime. /* not an error */,  \
    handlers  \
    )
/* Wrapper definition of the at_depth operation for the
   non-TOS-optimized stack "handlers". */
#undef JITTER_AT_DEPTH_HANDLERS
#undef UNINSPIRED_AT_DEPTH_HANDLERS
#define UNINSPIRED_AT_DEPTH_HANDLERS /* The preferred name. */ \
  JITTER_AT_DEPTH_HANDLERS
#define JITTER_AT_DEPTH_HANDLERS(x0)  \
  JITTER_STACK_NTOS_AT_DEPTH (struct exception_handler,  \
    jitter_state_runtime. /* not an error */,  \
    handlers  \
    , x0)
/* Wrapper definition of the at_nonzero_depth operation for the
   non-TOS-optimized stack "handlers". */
#undef JITTER_AT_NONZERO_DEPTH_HANDLERS
#undef UNINSPIRED_AT_NONZERO_DEPTH_HANDLERS
#define UNINSPIRED_AT_NONZERO_DEPTH_HANDLERS /* The preferred name. */ \
  JITTER_AT_NONZERO_DEPTH_HANDLERS
#define JITTER_AT_NONZERO_DEPTH_HANDLERS(x0)  \
  JITTER_STACK_NTOS_AT_NONZERO_DEPTH (struct exception_handler,  \
    jitter_state_runtime. /* not an error */,  \
    handlers  \
    , x0)
/* Wrapper definition of the set_at_depth operation for the
   non-TOS-optimized stack "handlers". */
#undef JITTER_SET_AT_DEPTH_HANDLERS
#undef UNINSPIRED_SET_AT_DEPTH_HANDLERS
#define UNINSPIRED_SET_AT_DEPTH_HANDLERS /* The preferred name. */ \
  JITTER_SET_AT_DEPTH_HANDLERS
#define JITTER_SET_AT_DEPTH_HANDLERS(x0, x1)  \
  JITTER_STACK_NTOS_SET_AT_DEPTH (struct exception_handler,  \
    jitter_state_runtime. /* not an error */,  \
    handlers  \
    , x0, x1)
/* Wrapper definition of the set_at_nonzero_depth operation for the
   non-TOS-optimized stack "handlers". */
#undef JITTER_SET_AT_NONZERO_DEPTH_HANDLERS
#undef UNINSPIRED_SET_AT_NONZERO_DEPTH_HANDLERS
#define UNINSPIRED_SET_AT_NONZERO_DEPTH_HANDLERS /* The preferred name. */ \
  JITTER_SET_AT_NONZERO_DEPTH_HANDLERS
#define JITTER_SET_AT_NONZERO_DEPTH_HANDLERS(x0, x1)  \
  JITTER_STACK_NTOS_SET_AT_NONZERO_DEPTH (struct exception_handler,  \
    jitter_state_runtime. /* not an error */,  \
    handlers  \
    , x0, x1)
/* Wrapper definition of the push_unspecified operation for the
   non-TOS-optimized stack "handlers". */
#undef JITTER_PUSH_UNSPECIFIED_HANDLERS
#undef UNINSPIRED_PUSH_UNSPECIFIED_HANDLERS
#define UNINSPIRED_PUSH_UNSPECIFIED_HANDLERS /* The preferred name. */ \
  JITTER_PUSH_UNSPECIFIED_HANDLERS
#define JITTER_PUSH_UNSPECIFIED_HANDLERS()  \
  JITTER_STACK_NTOS_PUSH_UNSPECIFIED (struct exception_handler,  \
    jitter_state_runtime. /* not an error */,  \
    handlers  \
    )
/* Wrapper definition of the push operation for the
   non-TOS-optimized stack "handlers". */
#undef JITTER_PUSH_HANDLERS
#undef UNINSPIRED_PUSH_HANDLERS
#define UNINSPIRED_PUSH_HANDLERS /* The preferred name. */ \
  JITTER_PUSH_HANDLERS
#define JITTER_PUSH_HANDLERS(x0)  \
  JITTER_STACK_NTOS_PUSH (struct exception_handler,  \
    jitter_state_runtime. /* not an error */,  \
    handlers  \
    , x0)
/* Wrapper definition of the under_push_unspecified operation for the
   non-TOS-optimized stack "handlers". */
#undef JITTER_UNDER_PUSH_UNSPECIFIED_HANDLERS
#undef UNINSPIRED_UNDER_PUSH_UNSPECIFIED_HANDLERS
#define UNINSPIRED_UNDER_PUSH_UNSPECIFIED_HANDLERS /* The preferred name. */ \
  JITTER_UNDER_PUSH_UNSPECIFIED_HANDLERS
#define JITTER_UNDER_PUSH_UNSPECIFIED_HANDLERS()  \
  JITTER_STACK_NTOS_UNDER_PUSH_UNSPECIFIED (struct exception_handler,  \
    jitter_state_runtime. /* not an error */,  \
    handlers  \
    )
/* Wrapper definition of the under_push operation for the
   non-TOS-optimized stack "handlers". */
#undef JITTER_UNDER_PUSH_HANDLERS
#undef UNINSPIRED_UNDER_PUSH_HANDLERS
#define UNINSPIRED_UNDER_PUSH_HANDLERS /* The preferred name. */ \
  JITTER_UNDER_PUSH_HANDLERS
#define JITTER_UNDER_PUSH_HANDLERS(x0)  \
  JITTER_STACK_NTOS_UNDER_PUSH (struct exception_handler,  \
    jitter_state_runtime. /* not an error */,  \
    handlers  \
    , x0)
/* Wrapper definition of the drop operation for the
   non-TOS-optimized stack "handlers". */
#undef JITTER_DROP_HANDLERS
#undef UNINSPIRED_DROP_HANDLERS
#define UNINSPIRED_DROP_HANDLERS /* The preferred name. */ \
  JITTER_DROP_HANDLERS
#define JITTER_DROP_HANDLERS()  \
  JITTER_STACK_NTOS_DROP (struct exception_handler,  \
    jitter_state_runtime. /* not an error */,  \
    handlers  \
    )
/* Wrapper definition of the dup operation for the
   non-TOS-optimized stack "handlers". */
#undef JITTER_DUP_HANDLERS
#undef UNINSPIRED_DUP_HANDLERS
#define UNINSPIRED_DUP_HANDLERS /* The preferred name. */ \
  JITTER_DUP_HANDLERS
#define JITTER_DUP_HANDLERS()  \
  JITTER_STACK_NTOS_DUP (struct exception_handler,  \
    jitter_state_runtime. /* not an error */,  \
    handlers  \
    )
/* Wrapper definition of the swap operation for the
   non-TOS-optimized stack "handlers". */
#undef JITTER_SWAP_HANDLERS
#undef UNINSPIRED_SWAP_HANDLERS
#define UNINSPIRED_SWAP_HANDLERS /* The preferred name. */ \
  JITTER_SWAP_HANDLERS
#define JITTER_SWAP_HANDLERS()  \
  JITTER_STACK_NTOS_SWAP (struct exception_handler,  \
    jitter_state_runtime. /* not an error */,  \
    handlers  \
    )
/* Wrapper definition of the quake operation for the
   non-TOS-optimized stack "handlers". */
#undef JITTER_QUAKE_HANDLERS
#undef UNINSPIRED_QUAKE_HANDLERS
#define UNINSPIRED_QUAKE_HANDLERS /* The preferred name. */ \
  JITTER_QUAKE_HANDLERS
#define JITTER_QUAKE_HANDLERS()  \
  JITTER_STACK_NTOS_QUAKE (struct exception_handler,  \
    jitter_state_runtime. /* not an error */,  \
    handlers  \
    )
/* Wrapper definition of the over operation for the
   non-TOS-optimized stack "handlers". */
#undef JITTER_OVER_HANDLERS
#undef UNINSPIRED_OVER_HANDLERS
#define UNINSPIRED_OVER_HANDLERS /* The preferred name. */ \
  JITTER_OVER_HANDLERS
#define JITTER_OVER_HANDLERS()  \
  JITTER_STACK_NTOS_OVER (struct exception_handler,  \
    jitter_state_runtime. /* not an error */,  \
    handlers  \
    )
/* Wrapper definition of the tuck operation for the
   non-TOS-optimized stack "handlers". */
#undef JITTER_TUCK_HANDLERS
#undef UNINSPIRED_TUCK_HANDLERS
#define UNINSPIRED_TUCK_HANDLERS /* The preferred name. */ \
  JITTER_TUCK_HANDLERS
#define JITTER_TUCK_HANDLERS()  \
  JITTER_STACK_NTOS_TUCK (struct exception_handler,  \
    jitter_state_runtime. /* not an error */,  \
    handlers  \
    )
/* Wrapper definition of the nip operation for the
   non-TOS-optimized stack "handlers". */
#undef JITTER_NIP_HANDLERS
#undef UNINSPIRED_NIP_HANDLERS
#define UNINSPIRED_NIP_HANDLERS /* The preferred name. */ \
  JITTER_NIP_HANDLERS
#define JITTER_NIP_HANDLERS()  \
  JITTER_STACK_NTOS_NIP (struct exception_handler,  \
    jitter_state_runtime. /* not an error */,  \
    handlers  \
    )
/* Wrapper definition of the rot operation for the
   non-TOS-optimized stack "handlers". */
#undef JITTER_ROT_HANDLERS
#undef UNINSPIRED_ROT_HANDLERS
#define UNINSPIRED_ROT_HANDLERS /* The preferred name. */ \
  JITTER_ROT_HANDLERS
#define JITTER_ROT_HANDLERS()  \
  JITTER_STACK_NTOS_ROT (struct exception_handler,  \
    jitter_state_runtime. /* not an error */,  \
    handlers  \
    )
/* Wrapper definition of the mrot operation for the
   non-TOS-optimized stack "handlers". */
#undef JITTER_MROT_HANDLERS
#undef UNINSPIRED_MROT_HANDLERS
#define UNINSPIRED_MROT_HANDLERS /* The preferred name. */ \
  JITTER_MROT_HANDLERS
#define JITTER_MROT_HANDLERS()  \
  JITTER_STACK_NTOS_MROT (struct exception_handler,  \
    jitter_state_runtime. /* not an error */,  \
    handlers  \
    )
/* Wrapper definition of the roll operation for the
   non-TOS-optimized stack "handlers". */
#undef JITTER_ROLL_HANDLERS
#undef UNINSPIRED_ROLL_HANDLERS
#define UNINSPIRED_ROLL_HANDLERS /* The preferred name. */ \
  JITTER_ROLL_HANDLERS
#define JITTER_ROLL_HANDLERS(x0)  \
  JITTER_STACK_NTOS_ROLL (struct exception_handler,  \
    jitter_state_runtime. /* not an error */,  \
    handlers  \
    , x0)
/* Wrapper definition of the mroll operation for the
   non-TOS-optimized stack "handlers". */
#undef JITTER_MROLL_HANDLERS
#undef UNINSPIRED_MROLL_HANDLERS
#define UNINSPIRED_MROLL_HANDLERS /* The preferred name. */ \
  JITTER_MROLL_HANDLERS
#define JITTER_MROLL_HANDLERS(x0)  \
  JITTER_STACK_NTOS_MROLL (struct exception_handler,  \
    jitter_state_runtime. /* not an error */,  \
    handlers  \
    , x0)
/* Wrapper definition of the slide operation for the
   non-TOS-optimized stack "handlers". */
#undef JITTER_SLIDE_HANDLERS
#undef UNINSPIRED_SLIDE_HANDLERS
#define UNINSPIRED_SLIDE_HANDLERS /* The preferred name. */ \
  JITTER_SLIDE_HANDLERS
#define JITTER_SLIDE_HANDLERS(x0, x1)  \
  JITTER_STACK_NTOS_SLIDE (struct exception_handler,  \
    jitter_state_runtime. /* not an error */,  \
    handlers  \
    , x0, x1)
/* Wrapper definition of the whirl operation for the
   non-TOS-optimized stack "handlers". */
#undef JITTER_WHIRL_HANDLERS
#undef UNINSPIRED_WHIRL_HANDLERS
#define UNINSPIRED_WHIRL_HANDLERS /* The preferred name. */ \
  JITTER_WHIRL_HANDLERS
#define JITTER_WHIRL_HANDLERS(x0)  \
  JITTER_STACK_NTOS_WHIRL (struct exception_handler,  \
    jitter_state_runtime. /* not an error */,  \
    handlers  \
    , x0)
/* Wrapper definition of the bulge operation for the
   non-TOS-optimized stack "handlers". */
#undef JITTER_BULGE_HANDLERS
#undef UNINSPIRED_BULGE_HANDLERS
#define UNINSPIRED_BULGE_HANDLERS /* The preferred name. */ \
  JITTER_BULGE_HANDLERS
#define JITTER_BULGE_HANDLERS(x0)  \
  JITTER_STACK_NTOS_BULGE (struct exception_handler,  \
    jitter_state_runtime. /* not an error */,  \
    handlers  \
    , x0)
/* Wrapper definition of the height operation for the
   non-TOS-optimized stack "handlers". */
#undef JITTER_HEIGHT_HANDLERS
#undef UNINSPIRED_HEIGHT_HANDLERS
#define UNINSPIRED_HEIGHT_HANDLERS /* The preferred name. */ \
  JITTER_HEIGHT_HANDLERS
#define JITTER_HEIGHT_HANDLERS()  \
  JITTER_STACK_NTOS_HEIGHT (struct exception_handler,  \
    jitter_state_runtime. /* not an error */,  \
    handlers  \
    )
/* Wrapper definition of the set_height operation for the
   non-TOS-optimized stack "handlers". */
#undef JITTER_SET_HEIGHT_HANDLERS
#undef UNINSPIRED_SET_HEIGHT_HANDLERS
#define UNINSPIRED_SET_HEIGHT_HANDLERS /* The preferred name. */ \
  JITTER_SET_HEIGHT_HANDLERS
#define JITTER_SET_HEIGHT_HANDLERS(x0)  \
  JITTER_STACK_NTOS_SET_HEIGHT (struct exception_handler,  \
    jitter_state_runtime. /* not an error */,  \
    handlers  \
    , x0)
/* Wrapper definition of the reverse operation for the
   non-TOS-optimized stack "handlers". */
#undef JITTER_REVERSE_HANDLERS
#undef UNINSPIRED_REVERSE_HANDLERS
#define UNINSPIRED_REVERSE_HANDLERS /* The preferred name. */ \
  JITTER_REVERSE_HANDLERS
#define JITTER_REVERSE_HANDLERS(x0)  \
  JITTER_STACK_NTOS_REVERSE (struct exception_handler,  \
    jitter_state_runtime. /* not an error */,  \
    handlers  \
    , x0)
/* Wrapper definition of the unary operation for the
   non-TOS-optimized stack "handlers". */
#undef JITTER_UNARY_HANDLERS
#undef UNINSPIRED_UNARY_HANDLERS
#define UNINSPIRED_UNARY_HANDLERS /* The preferred name. */ \
  JITTER_UNARY_HANDLERS
#define JITTER_UNARY_HANDLERS(x0)  \
  JITTER_STACK_NTOS_UNARY (struct exception_handler,  \
    jitter_state_runtime. /* not an error */,  \
    handlers  \
    , x0)
/* Wrapper definition of the binary operation for the
   non-TOS-optimized stack "handlers". */
#undef JITTER_BINARY_HANDLERS
#undef UNINSPIRED_BINARY_HANDLERS
#define UNINSPIRED_BINARY_HANDLERS /* The preferred name. */ \
  JITTER_BINARY_HANDLERS
#define JITTER_BINARY_HANDLERS(x0)  \
  JITTER_STACK_NTOS_BINARY (struct exception_handler,  \
    jitter_state_runtime. /* not an error */,  \
    handlers  \
    , x0)

/* Late C code from the user. */

/* See install-signal-handler below. */
static void
jitter_my_signal_handler (int signal_number)
{
  struct uninspired_state *s;
  /* For every state... */
  UNINSPIRED_FOR_EACH_STATE (s)
    {
      /* ...Mark the signal signal_number as pending... */
      UNINSPIRED_STATE_AND_SIGNAL_TO_PENDING_SIGNAL_NOTIFICATION
         (s, signal_number) = true;
      /* ...And record the fact that there is at least one notification to
         handle. */
      UNINSPIRED_STATE_TO_PENDING_NOTIFICATIONS (s) = true;
    }
}
  
    #include <stdio.h>
    #include <stdlib.h>

    static const char * const
    uninspired_printfixnum_decimal_hex_format_string
      __attribute__ ((unused))
      = "%" JITTER_PRIi " 0x%" JITTER_PRIx "\n";

    static const char * const
    uninspired_printfixnum_format_string
      __attribute__ ((unused))
      = "%" JITTER_PRIi "\n";

    static const char * const
    uninspired_printdouble_format_string
      = "%f\n";

    static const char * const
    uninspired_hcf_format_string = "Halting and catching fire\n";

    static const char * const
    uninspired_newline_string = "\n";

    static const char * const
    uninspired_print_topmost_format_string = "(%i)%" JITTER_PRIi "  ";
  /* End of the late C code from the user. */

/* The definition of this is machine-generated in uninspired-vm2.c , and the
   function is not intended for the user.  If initializing then set
   structuredvm_threads and structuredvm_thread_sizes and just return, ignoring
   the other fields and s.  If not initializing then actually enter VM code
   starting from the initial program point in the state. */
static enum uninspired_exit_status
uninspired_execute_or_initialize (bool jitter_initialize,
                                struct uninspired_state * const jitter_original_state)
  __attribute__ ((noclone, noinline, no_reorder));

enum uninspired_exit_status
uninspired_execute_executable_routine (const struct jitter_executable_routine *er,
                                     struct uninspired_state *s)
{
  uninspired_make_place_for_slow_registers (s, er->slow_register_per_class_no);
  jitter_program_point initial_program_point
    = UNINSPIRED_EXECUTABLE_ROUTINE_BEGINNING (er);
  return uninspired_branch_to_program_point (initial_program_point,
                                           s);
}


/* Threads or pointers to native code blocks of course don't exist with
   switch-dispatching. */
#ifndef JITTER_DISPATCH_SWITCH
const jitter_thread *
uninspired_threads;

const jitter_thread *
uninspired_thread_ends;

const long *
uninspired_thread_sizes;
#endif // #ifndef JITTER_DISPATCH_SWITCH

void
uninspired_initialize_threads (void)
{
  uninspired_execute_or_initialize (true, NULL);
}

enum uninspired_exit_status
uninspired_branch_to_program_point (uninspired_program_point p, struct uninspired_state *s)
{
  /* Change the state to set the initial program point. */
  s->uninspired_state_backing.initial_program_point = p;

  /* Execute. */
  return uninspired_execute_or_initialize (false, s);
}

__attribute__ ((noinline, noclone, no_reorder))
void
uninspired_asm_headers (void)
{
#ifdef JITTER_HAVE_PATCH_IN
  /* Generate the single patch-in header for this executor as a
     global asm statement.  This expands into a global definition in
     assembly in a separate subsection, and relies on toplevel C
     definitions not being reordered: uninspired_execute_or_initialize
     will add to the same global.  Do the same for defects. */
  JITTER_PATCH_IN_HEADER(uninspired);
#endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_HAVE_DEFECT_REPLACEMENT

  /* The same for defects... */
  JITTER_DEFECT_HEADER(uninspired);
#endif // #ifdef JITTER_HAVE_DEFECT_REPLACEMENT

#ifndef JITTER_DISPATCH_SWITCH
  JITTER_DATA_LOCATION_HEADER(uninspired);
#endif // #ifndef JITTER_DISPATCH_SWITCH

}
static enum uninspired_exit_status
uninspired_execute_or_initialize (bool jitter_initialize,
                                struct uninspired_state * const jitter_original_state)
{
/* Undefine the state field access macros which are meant to be
   used out of VM instructions. */
#undef UNINSPIRED_STATE_RUNTIME_FIELD
#undef UNINSPIRED_STATE_BACKING_FIELD

/* Replace the definitions by versions which will work (only!)
   inside instruction bodies.  These macros have one argument
   instead of two: the VM state being used is *the* current
   state. */
#define UNINSPIRED_STATE_RUNTIME_FIELD  _JITTER_STATE_RUNTIME_FIELD
#define UNINSPIRED_STATE_BACKING_FIELD  _JITTER_STATE_BACKING_FIELD

#ifdef JITTER_DISPATCH_NO_THREADING
  /* Save the values in the registers we reserved as global variables,
     since from the point of view of the other C compilation units such
     registers are callee-save.  FIXME: this is not really needed when
     initializing, if I've been careful; but for the time being I want
     to play it safe. */
  union jitter_word jitter_register_buffer [UNINSPIRED_REGISTER_BUFFER_ELEMENT_NO];
  uninspired_save_registers (jitter_register_buffer);
#endif // #ifdef JITTER_DISPATCH_NO_THREADING

  /* Initialization.  This is only called once at startup. */
  if (__builtin_expect (jitter_initialize, false))
    {
      /* Make sure that vm1 and vm2 were macroexpanded consistently
         with respect to instrumentation macros.  This relies on the
         enum values for each feature working as individual bits in a
         bitmask: see the comment in jitter/jitter-vm.h . */
      enum jitter_vm_instrumentation correct_instrumentation
        = jitter_vm_instrumentation_none;
#if defined (UNINSPIRED_PROFILE_COUNT)
      correct_instrumentation |= jitter_vm_instrumentation_count;
#endif
#if defined (UNINSPIRED_PROFILE_SAMPLE)
      correct_instrumentation |= jitter_vm_instrumentation_sample;
#endif
      if (uninspired_vm_configuration->instrumentation != correct_instrumentation)
        jitter_fatal ("vm1 and vm2 were compiled with different profiling "
                      "instrumentation macros.  Please recompile with coherent "
                      "CPPFLAGS");

#if defined (UNINSPIRED_PROFILE_SAMPLE)
    /* Initialise the sample-profile subsystem, once and for all. */
    uninspired_profile_sample_initialize ();
#endif // #if defined (UNINSPIRED_PROFILE_SAMPLE)

#ifndef JITTER_DISPATCH_SWITCH
      /* FIXME: I can do this with only one relocation, by keeping
         a pointer to the first VM instruction beginning in a static
         variable, and then having a static vector of offsets with
         respect to the first pointer.  This will slightly complicate
         my initialization code, but should make startup faster.
         FIXME: that won't work on AVR, according to the GCC
         documentation.  Do I care?  Probably not, since AVRs can't
         address more than 2^16 bytes, which is too little to run my
         VMs. */
      static const jitter_thread uninspired_the_threads []
        = {
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eINVALID),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eBEGINBASICBLOCK),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eEXITVM),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eDATALOCATIONS),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eNOP),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eUNREACHABLE0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eUNREACHABLE1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_ePRETENDTOJUMPANYWHERE),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(add___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(add___rrR__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(add___rrR__n_m1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(add___rrR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(add__n1___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(add__n1__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(add__n1__n_m1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(add__n1__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(add__n_m1___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(add__n_m1__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(add__n_m1__n_m1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(add__n_m1__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(add__nR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(add__nR__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(add__nR__n_m1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(add__nR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(addo___rrR___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(addo___rrR__n1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(addo___rrR__n_m1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(addo___rrR__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(addo__nR___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(addo__nR__n1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(addo__nR__n_m1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(addo__nR__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(b__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(band___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(band___rrR__n3__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(band___rrR__n7__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(band___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(band__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(band__nR__n3__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(band__nR__n7__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(band__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beq___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beq___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beq__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beq__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rrR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__n0__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__n1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__n1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__n1__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__n1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__nR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgeu___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgeu___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgeu___rrR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgeu___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgeu__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgeu__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgeu__n0__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgeu__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgeu__n1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgeu__n1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgeu__n1__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgeu__n1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgeu__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgeu__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgeu__nR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgeu__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgt___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgt___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgt___rrR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgt___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgt__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgt__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgt__n0__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgt__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgt__n1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgt__n1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgt__n1__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgt__n1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgt__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgt__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgt__nR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgt__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgtu___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgtu___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgtu___rrR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgtu___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgtu__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgtu__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgtu__n0__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgtu__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgtu__n1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgtu__n1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgtu__n1__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgtu__n1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgtu__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgtu__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgtu__nR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bgtu__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rrR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__n0__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__n1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__n1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__n1__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__n1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__nR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bleu___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bleu___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bleu___rrR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bleu___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bleu__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bleu__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bleu__n0__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bleu__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bleu__n1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bleu__n1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bleu__n1__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bleu__n1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bleu__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bleu__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bleu__nR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bleu__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(blt___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(blt___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(blt___rrR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(blt___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(blt__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(blt__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(blt__n0__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(blt__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(blt__n1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(blt__n1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(blt__n1__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(blt__n1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(blt__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(blt__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(blt__nR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(blt__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bltu___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bltu___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bltu___rrR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bltu___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bltu__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bltu__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bltu__n0__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bltu__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bltu__n1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bltu__n1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bltu__n1__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bltu__n1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bltu__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bltu__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bltu__nR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bltu__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneg___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneg__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnneg___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnneg__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnotand___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnotand___rrR__n3__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnotand___rrR__n7__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnotand___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnotand__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnotand__nR__n3__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnotand__nR__n7__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnotand__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnpos___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnpos__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnz___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnz__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bpos___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bpos__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(br___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bulge__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bulge__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bulge__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bulge__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bulge__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bulgeforth),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bz___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bz__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(clear_mpending__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(div___rrR___rrR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(div___rrR__n2___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(div___rrR__nR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(div__nR___rrR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(div__nR__n2___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(div__nR__nR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divo___rrR___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divo___rrR__n2___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divo___rrR__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divo__nR___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divo__nR__n2___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divo__nR__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(drop_mhandler),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(endvm),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(exit___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(exit__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(exitvm),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(fadd___rfR___rfR___rfR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(fdiv___rfR___rfR___rfR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(fincr___rfR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(fmul___rfR___rfR___rfR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(fprint___rfR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(fset___rrR___rfR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(fset__nR___rfR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(fsub___rfR___rfR___rfR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(hcf__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(install_msignal_mhandler__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(loadwithbyteoffset___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(loadwithbyteoffset___rrR__n0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(loadwithbyteoffset___rrR__n8___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(loadwithbyteoffset___rrR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(loadwithwordoffset___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(loadwithwordoffset___rrR__n0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(loadwithwordoffset___rrR__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(loadwithwordoffset___rrR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(loadwithwordoffset___rrR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mallocwords___rrR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mallocwords__nR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mod___rrR___rrR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mod___rrR__n2___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mod___rrR__nR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mod__nR___rrR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mod__nR__n2___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mod__nR__nR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(modo___rrR___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(modo___rrR__n2___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(modo___rrR__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(modo__nR___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(modo__nR__n2___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(modo__nR__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__lR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n5),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n6),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n7),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n8),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n9),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n10),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n11),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n12),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n13),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n14),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n15),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n16),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n17),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n18),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n19),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n20),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n21),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n22),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n23),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n24),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n25),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n26),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n27),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n28),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n29),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n30),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n31),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n32),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n33),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n34),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n35),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n36),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n37),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n38),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n39),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n40),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n41),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n42),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n43),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n44),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n45),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n46),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n47),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n48),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n49),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n50),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n51),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n52),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n53),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n54),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n55),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n56),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n57),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n58),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n59),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n60),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n61),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n62),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n63),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n64),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n65),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n66),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n67),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n68),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n69),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__n70),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mroll__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mrollforth),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mrot),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mul___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mul___rrR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mul___rrR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mul__n2___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mul__n2__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mul__n2__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mul__nR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mul__nR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mul__nR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mulo___rrR___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mulo___rrR__n2___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mulo___rrR__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mulo__nR___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mulo__nR__n2___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mulo__nR__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nop),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(print_mpending_msignals__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(print_mtopmost__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(printfixnum___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(printfixnum__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(procedurecall__fR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(procedurecallr___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(procedurecallr__lR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(procedureprolog),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(procedurereturn),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mdepths__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mhandler__n0__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mhandler__n1__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mhandler__n2__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mhandler__n3__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mhandler__n4__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mhandler__n5__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mhandler__n6__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mhandler__n7__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mhandler__n8__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mhandler__n9__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mhandler__n10__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mhandler__nR__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mincreasing__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(quake),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(raise___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(raise__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(raise__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(raise__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(raise__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(raise__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(raise__n5),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(raise__n6),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(raise__n7),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(raise__n8),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(raise__n9),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(raise__n10),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(raise__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(random___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n5),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n6),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n7),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n8),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n9),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n10),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n11),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n12),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n13),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n14),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n15),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n16),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n17),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n18),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n19),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n20),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n21),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n22),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n23),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n24),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n25),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n26),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n27),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n28),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n29),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n30),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n31),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n32),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n33),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n34),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n35),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n36),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n37),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n38),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n39),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n40),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n41),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n42),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n43),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n44),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n45),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n46),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n47),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n48),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n49),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n50),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n51),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n52),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n53),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n54),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n55),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n56),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n57),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n58),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n59),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n60),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n61),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n62),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n63),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n64),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n65),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n66),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n67),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n68),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n69),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__n70),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reverse__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n5),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n6),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n7),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n8),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n9),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n10),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n11),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n12),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n13),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n14),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n15),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n16),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n17),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n18),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n19),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n20),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n21),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n22),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n23),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n24),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n25),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n26),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n27),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n28),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n29),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n30),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n31),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n32),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n33),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n34),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n35),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n36),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n37),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n38),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n39),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n40),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n41),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n42),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n43),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n44),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n45),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n46),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n47),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n48),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n49),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n50),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n51),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n52),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n53),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n54),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n55),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n56),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n57),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n58),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n59),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n60),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n61),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n62),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n63),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n64),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n65),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n66),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n67),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n68),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n69),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__n70),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(roll__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(rollforth),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(rot),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(safe_mpoint__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(set_mpending),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(slide__n1__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(slide__n1__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(slide__n1__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(slide__n1__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(slide__n1__n5),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(slide__n1__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(slide__n2__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(slide__n2__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(slide__n2__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(slide__n2__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(slide__n2__n5),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(slide__n2__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(slide__n3__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(slide__n3__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(slide__n3__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(slide__n3__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(slide__n3__n5),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(slide__n3__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(slide__nR__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(slide__nR__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(slide__nR__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(slide__nR__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(slide__nR__n5),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(slide__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(slideforth),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stackdrop),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stackdup),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stackif__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stacknip),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stacknondroppingif__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stacknot),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stackoneminus),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stackoneplus),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stackover),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stackpeek___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stackplus),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stackplusr___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stackpop___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stackprint__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stackpush___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stackpush__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stackpush__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stackpush__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stackpush__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stackpushunspecified),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stackset___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stackset__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stackset__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stackset__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stackset__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stackswap),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stackswaptop___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stacktimes),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(storewithbyteoffset___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(storewithbyteoffset___rrR___rrR__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(storewithbyteoffset___rrR___rrR__n8),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(storewithbyteoffset___rrR___rrR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(storewithbyteoffset__nR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(storewithbyteoffset__nR___rrR__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(storewithbyteoffset__nR___rrR__n8),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(storewithbyteoffset__nR___rrR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(storewithwordoffset___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(storewithwordoffset___rrR___rrR__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(storewithwordoffset___rrR___rrR__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(storewithwordoffset___rrR___rrR__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(storewithwordoffset___rrR___rrR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(storewithwordoffset__nR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(storewithwordoffset__nR___rrR__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(storewithwordoffset__nR___rrR__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(storewithwordoffset__nR___rrR__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(storewithwordoffset__nR___rrR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sub___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sub___rrR__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sub___rrR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sub__n0___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sub__n0__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sub__n0__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sub__nR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sub__nR__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sub__nR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(subo___rrR___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(subo___rrR__n1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(subo___rrR__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(subo__nR___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(subo__nR__n1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(subo__nR__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tuck),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(unreachable),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(whirl__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(whirl__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(whirl__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(whirl__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(whirl__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(whirlforth),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_maddo___rrR___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_maddo___rrR__n1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_maddo___rrR__n_m1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_maddo___rrR__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_maddo__nR___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_maddo__nR__n1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_maddo__nR__n_m1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_maddo__nR__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mb__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mband___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mband___rrR__n3__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mband___rrR__n7__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mband___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mband__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mband__nR__n3__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mband__nR__n7__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mband__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbeq___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbeq___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbeq__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbeq__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge___rrR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge__n0__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge__n1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge__n1__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge__n1__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge__n1__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge__nR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgeu___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgeu___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgeu___rrR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgeu___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgeu__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgeu__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgeu__n0__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgeu__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgeu__n1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgeu__n1__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgeu__n1__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgeu__n1__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgeu__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgeu__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgeu__nR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgeu__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgt___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgt___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgt___rrR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgt___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgt__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgt__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgt__n0__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgt__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgt__n1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgt__n1__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgt__n1__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgt__n1__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgt__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgt__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgt__nR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgt__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgtu___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgtu___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgtu___rrR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgtu___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgtu__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgtu__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgtu__n0__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgtu__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgtu__n1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgtu__n1__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgtu__n1__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgtu__n1__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgtu__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgtu__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgtu__nR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbgtu__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble___rrR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble__n0__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble__n1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble__n1__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble__n1__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble__n1__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble__nR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbleu___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbleu___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbleu___rrR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbleu___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbleu__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbleu__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbleu__n0__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbleu__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbleu__n1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbleu__n1__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbleu__n1__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbleu__n1__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbleu__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbleu__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbleu__nR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbleu__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mblt___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mblt___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mblt___rrR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mblt___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mblt__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mblt__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mblt__n0__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mblt__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mblt__n1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mblt__n1__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mblt__n1__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mblt__n1__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mblt__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mblt__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mblt__nR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mblt__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbltu___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbltu___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbltu___rrR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbltu___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbltu__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbltu__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbltu__n0__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbltu__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbltu__n1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbltu__n1__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbltu__n1__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbltu__n1__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbltu__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbltu__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbltu__nR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbltu__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbneg___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbneg__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbnneg___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbnneg__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbnotand___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbnotand___rrR__n3__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbnotand___rrR__n7__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbnotand___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbnotand__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbnotand__nR__n3__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbnotand__nR__n7__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbnotand__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbnpos___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbnpos__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbnz___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbnz__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbpos___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbpos__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbr___rrR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbz___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbz__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mdivo___rrR___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mdivo___rrR__n2___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mdivo___rrR__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mdivo__nR___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mdivo__nR__n2___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mdivo__nR__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mendvm__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mexitvm__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mmodo___rrR___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mmodo___rrR__n2___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mmodo___rrR__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mmodo__nR___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mmodo__nR__n2___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mmodo__nR__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mmulo___rrR___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mmulo___rrR__n2___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mmulo___rrR__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mmulo__nR___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mmulo__nR__n2___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mmulo__nR__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprocedurecall__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprocedurecallr___rrR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprocedurecallr__lR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprocedureprolog__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprocedurereturn__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mraise___rrR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mraise__n0__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mraise__n1__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mraise__n2__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mraise__n3__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mraise__n4__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mraise__n5__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mraise__n6__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mraise__n7__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mraise__n8__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mraise__n9__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mraise__n10__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mraise__nR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_msafe_mpoint__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mstackif__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mstacknondroppingif__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_msubo___rrR___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_msubo___rrR__n1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_msubo___rrR__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_msubo__nR___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_msubo__nR__n1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_msubo__nR__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_munreachable__retR),
                0)
          };
      static const jitter_thread uninspired_the_thread_ends []
        = {
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eINVALID),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eBEGINBASICBLOCK),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eEXITVM),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eDATALOCATIONS),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eNOP),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eUNREACHABLE0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eUNREACHABLE1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_ePRETENDTOJUMPANYWHERE),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(add___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(add___rrR__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(add___rrR__n_m1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(add___rrR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(add__n1___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(add__n1__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(add__n1__n_m1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(add__n1__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(add__n_m1___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(add__n_m1__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(add__n_m1__n_m1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(add__n_m1__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(add__nR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(add__nR__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(add__nR__n_m1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(add__nR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(addo___rrR___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(addo___rrR__n1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(addo___rrR__n_m1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(addo___rrR__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(addo__nR___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(addo__nR__n1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(addo__nR__n_m1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(addo__nR__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(b__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(band___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(band___rrR__n3__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(band___rrR__n7__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(band___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(band__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(band__nR__n3__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(band__nR__n7__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(band__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(beq___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(beq___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(beq__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(beq__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rrR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__n0__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__n1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__n1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__n1__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__n1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__nR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgeu___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgeu___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgeu___rrR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgeu___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgeu__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgeu__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgeu__n0__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgeu__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgeu__n1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgeu__n1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgeu__n1__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgeu__n1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgeu__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgeu__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgeu__nR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgeu__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgt___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgt___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgt___rrR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgt___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgt__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgt__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgt__n0__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgt__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgt__n1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgt__n1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgt__n1__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgt__n1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgt__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgt__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgt__nR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgt__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgtu___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgtu___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgtu___rrR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgtu___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgtu__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgtu__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgtu__n0__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgtu__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgtu__n1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgtu__n1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgtu__n1__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgtu__n1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgtu__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgtu__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgtu__nR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bgtu__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rrR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__n0__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__n1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__n1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__n1__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__n1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__nR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bleu___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bleu___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bleu___rrR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bleu___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bleu__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bleu__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bleu__n0__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bleu__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bleu__n1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bleu__n1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bleu__n1__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bleu__n1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bleu__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bleu__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bleu__nR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bleu__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(blt___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(blt___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(blt___rrR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(blt___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(blt__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(blt__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(blt__n0__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(blt__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(blt__n1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(blt__n1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(blt__n1__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(blt__n1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(blt__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(blt__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(blt__nR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(blt__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bltu___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bltu___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bltu___rrR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bltu___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bltu__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bltu__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bltu__n0__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bltu__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bltu__n1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bltu__n1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bltu__n1__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bltu__n1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bltu__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bltu__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bltu__nR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bltu__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bneg___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bneg__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnneg___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnneg__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnotand___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnotand___rrR__n3__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnotand___rrR__n7__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnotand___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnotand__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnotand__nR__n3__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnotand__nR__n7__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnotand__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnpos___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnpos__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnz___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnz__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bpos___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bpos__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(br___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bulge__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bulge__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bulge__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bulge__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bulge__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bulgeforth),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bz___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bz__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(clear_mpending__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(div___rrR___rrR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(div___rrR__n2___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(div___rrR__nR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(div__nR___rrR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(div__nR__n2___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(div__nR__nR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divo___rrR___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divo___rrR__n2___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divo___rrR__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divo__nR___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divo__nR__n2___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divo__nR__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(drop_mhandler),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(endvm),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(exit___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(exit__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(exitvm),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(fadd___rfR___rfR___rfR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(fdiv___rfR___rfR___rfR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(fincr___rfR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(fmul___rfR___rfR___rfR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(fprint___rfR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(fset___rrR___rfR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(fset__nR___rfR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(fsub___rfR___rfR___rfR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(hcf__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(install_msignal_mhandler__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(loadwithbyteoffset___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(loadwithbyteoffset___rrR__n0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(loadwithbyteoffset___rrR__n8___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(loadwithbyteoffset___rrR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(loadwithwordoffset___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(loadwithwordoffset___rrR__n0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(loadwithwordoffset___rrR__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(loadwithwordoffset___rrR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(loadwithwordoffset___rrR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mallocwords___rrR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mallocwords__nR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mod___rrR___rrR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mod___rrR__n2___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mod___rrR__nR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mod__nR___rrR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mod__nR__n2___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mod__nR__nR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(modo___rrR___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(modo___rrR__n2___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(modo___rrR__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(modo__nR___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(modo__nR__n2___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(modo__nR__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__lR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n5),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n6),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n7),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n8),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n9),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n10),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n11),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n12),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n13),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n14),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n15),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n16),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n17),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n18),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n19),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n20),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n21),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n22),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n23),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n24),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n25),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n26),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n27),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n28),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n29),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n30),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n31),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n32),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n33),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n34),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n35),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n36),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n37),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n38),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n39),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n40),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n41),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n42),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n43),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n44),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n45),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n46),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n47),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n48),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n49),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n50),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n51),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n52),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n53),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n54),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n55),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n56),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n57),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n58),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n59),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n60),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n61),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n62),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n63),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n64),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n65),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n66),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n67),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n68),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n69),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__n70),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mroll__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mrollforth),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mrot),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mul___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mul___rrR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mul___rrR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mul__n2___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mul__n2__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mul__n2__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mul__nR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mul__nR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mul__nR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mulo___rrR___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mulo___rrR__n2___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mulo___rrR__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mulo__nR___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mulo__nR__n2___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mulo__nR__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nop),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(print_mpending_msignals__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(print_mtopmost__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(printfixnum___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(printfixnum__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(procedurecall__fR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(procedurecallr___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(procedurecallr__lR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(procedureprolog),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(procedurereturn),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mdepths__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mhandler__n0__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mhandler__n1__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mhandler__n2__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mhandler__n3__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mhandler__n4__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mhandler__n5__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mhandler__n6__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mhandler__n7__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mhandler__n8__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mhandler__n9__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mhandler__n10__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mhandler__nR__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mincreasing__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(quake),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(raise___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(raise__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(raise__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(raise__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(raise__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(raise__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(raise__n5),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(raise__n6),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(raise__n7),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(raise__n8),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(raise__n9),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(raise__n10),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(raise__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(random___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n5),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n6),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n7),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n8),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n9),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n10),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n11),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n12),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n13),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n14),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n15),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n16),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n17),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n18),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n19),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n20),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n21),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n22),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n23),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n24),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n25),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n26),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n27),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n28),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n29),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n30),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n31),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n32),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n33),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n34),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n35),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n36),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n37),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n38),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n39),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n40),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n41),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n42),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n43),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n44),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n45),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n46),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n47),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n48),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n49),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n50),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n51),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n52),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n53),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n54),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n55),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n56),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n57),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n58),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n59),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n60),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n61),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n62),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n63),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n64),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n65),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n66),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n67),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n68),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n69),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__n70),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reverse__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n5),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n6),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n7),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n8),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n9),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n10),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n11),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n12),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n13),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n14),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n15),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n16),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n17),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n18),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n19),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n20),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n21),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n22),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n23),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n24),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n25),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n26),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n27),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n28),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n29),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n30),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n31),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n32),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n33),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n34),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n35),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n36),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n37),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n38),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n39),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n40),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n41),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n42),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n43),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n44),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n45),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n46),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n47),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n48),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n49),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n50),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n51),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n52),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n53),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n54),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n55),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n56),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n57),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n58),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n59),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n60),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n61),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n62),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n63),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n64),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n65),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n66),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n67),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n68),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n69),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__n70),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(roll__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(rollforth),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(rot),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(safe_mpoint__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(set_mpending),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(slide__n1__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(slide__n1__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(slide__n1__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(slide__n1__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(slide__n1__n5),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(slide__n1__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(slide__n2__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(slide__n2__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(slide__n2__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(slide__n2__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(slide__n2__n5),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(slide__n2__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(slide__n3__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(slide__n3__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(slide__n3__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(slide__n3__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(slide__n3__n5),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(slide__n3__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(slide__nR__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(slide__nR__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(slide__nR__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(slide__nR__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(slide__nR__n5),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(slide__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(slideforth),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stackdrop),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stackdup),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stackif__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stacknip),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stacknondroppingif__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stacknot),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stackoneminus),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stackoneplus),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stackover),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stackpeek___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stackplus),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stackplusr___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stackpop___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stackprint__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stackpush___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stackpush__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stackpush__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stackpush__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stackpush__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stackpushunspecified),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stackset___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stackset__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stackset__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stackset__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stackset__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stackswap),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stackswaptop___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stacktimes),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(storewithbyteoffset___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(storewithbyteoffset___rrR___rrR__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(storewithbyteoffset___rrR___rrR__n8),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(storewithbyteoffset___rrR___rrR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(storewithbyteoffset__nR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(storewithbyteoffset__nR___rrR__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(storewithbyteoffset__nR___rrR__n8),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(storewithbyteoffset__nR___rrR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(storewithwordoffset___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(storewithwordoffset___rrR___rrR__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(storewithwordoffset___rrR___rrR__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(storewithwordoffset___rrR___rrR__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(storewithwordoffset___rrR___rrR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(storewithwordoffset__nR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(storewithwordoffset__nR___rrR__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(storewithwordoffset__nR___rrR__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(storewithwordoffset__nR___rrR__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(storewithwordoffset__nR___rrR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sub___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sub___rrR__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sub___rrR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sub__n0___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sub__n0__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sub__n0__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sub__nR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sub__nR__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sub__nR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(subo___rrR___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(subo___rrR__n1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(subo___rrR__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(subo__nR___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(subo__nR__n1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(subo__nR__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tuck),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(unreachable),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(whirl__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(whirl__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(whirl__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(whirl__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(whirl__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(whirlforth),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_maddo___rrR___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_maddo___rrR__n1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_maddo___rrR__n_m1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_maddo___rrR__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_maddo__nR___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_maddo__nR__n1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_maddo__nR__n_m1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_maddo__nR__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mb__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mband___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mband___rrR__n3__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mband___rrR__n7__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mband___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mband__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mband__nR__n3__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mband__nR__n7__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mband__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbeq___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbeq___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbeq__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbeq__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge___rrR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge__n0__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge__n1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge__n1__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge__n1__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge__n1__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge__nR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgeu___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgeu___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgeu___rrR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgeu___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgeu__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgeu__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgeu__n0__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgeu__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgeu__n1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgeu__n1__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgeu__n1__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgeu__n1__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgeu__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgeu__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgeu__nR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgeu__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgt___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgt___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgt___rrR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgt___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgt__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgt__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgt__n0__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgt__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgt__n1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgt__n1__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgt__n1__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgt__n1__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgt__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgt__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgt__nR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgt__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgtu___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgtu___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgtu___rrR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgtu___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgtu__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgtu__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgtu__n0__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgtu__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgtu__n1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgtu__n1__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgtu__n1__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgtu__n1__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgtu__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgtu__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgtu__nR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbgtu__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble___rrR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble__n0__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble__n1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble__n1__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble__n1__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble__n1__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble__nR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbleu___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbleu___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbleu___rrR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbleu___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbleu__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbleu__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbleu__n0__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbleu__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbleu__n1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbleu__n1__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbleu__n1__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbleu__n1__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbleu__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbleu__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbleu__nR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbleu__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mblt___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mblt___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mblt___rrR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mblt___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mblt__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mblt__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mblt__n0__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mblt__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mblt__n1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mblt__n1__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mblt__n1__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mblt__n1__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mblt__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mblt__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mblt__nR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mblt__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbltu___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbltu___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbltu___rrR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbltu___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbltu__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbltu__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbltu__n0__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbltu__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbltu__n1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbltu__n1__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbltu__n1__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbltu__n1__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbltu__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbltu__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbltu__nR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbltu__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbneg___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbneg__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbnneg___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbnneg__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbnotand___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbnotand___rrR__n3__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbnotand___rrR__n7__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbnotand___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbnotand__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbnotand__nR__n3__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbnotand__nR__n7__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbnotand__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbnpos___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbnpos__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbnz___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbnz__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbpos___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbpos__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbr___rrR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbz___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbz__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mdivo___rrR___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mdivo___rrR__n2___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mdivo___rrR__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mdivo__nR___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mdivo__nR__n2___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mdivo__nR__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mendvm__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mexitvm__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mmodo___rrR___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mmodo___rrR__n2___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mmodo___rrR__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mmodo__nR___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mmodo__nR__n2___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mmodo__nR__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mmulo___rrR___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mmulo___rrR__n2___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mmulo___rrR__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mmulo__nR___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mmulo__nR__n2___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mmulo__nR__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprocedurecall__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprocedurecallr___rrR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprocedurecallr__lR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprocedureprolog__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprocedurereturn__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mraise___rrR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mraise__n0__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mraise__n1__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mraise__n2__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mraise__n3__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mraise__n4__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mraise__n5__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mraise__n6__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mraise__n7__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mraise__n8__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mraise__n9__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mraise__n10__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mraise__nR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_msafe_mpoint__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mstackif__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mstacknondroppingif__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_msubo___rrR___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_msubo___rrR__n1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_msubo___rrR__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_msubo__nR___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_msubo__nR__n1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_msubo__nR__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_munreachable__retR),
                0)
          };
      /* A few non-GCC compilers such as TCC support GNU C's labels
         as values, but do not recognise their differences as
         *constant* expressions.  Compute the difference at
         initialisation then. */
      static long
      uninspired_the_thread_sizes [UNINSPIRED_SPECIALIZED_INSTRUCTION_NO];
      int i;
      for (i = 0; i < UNINSPIRED_SPECIALIZED_INSTRUCTION_NO; i ++)
        uninspired_the_thread_sizes [i]
          = uninspired_the_thread_ends [i] - uninspired_the_threads [i];
      uninspired_thread_sizes
        = (const long *) uninspired_the_thread_sizes;
      uninspired_threads = uninspired_the_threads;
      uninspired_thread_ends = uninspired_the_thread_ends;

#ifdef JITTER_HAVE_DEFECT_REPLACEMENT
      /* Define the correct distance between the fake target in C
         and in assembly, for this VM. */
      JITTER_DEFECT_CORRECT_DISPLACEMENT_NAME (uninspired)
        = ((char *) && jitter_fake_target
           - (char *) uninspired_fake_target_asm);
      //fprintf (stderr, "DEBUG: INITIALISE CORRECT DISPLACEMENT TO %li\n", (long) JITTER_DEFECT_CORRECT_DISPLACEMENT_NAME (uninspired));
#endif // #ifdef JITTER_HAVE_DEFECT_REPLACEMENT

#endif // #ifndef JITTER_DISPATCH_SWITCH

      /* Back to regular C, without our reserved registers if any; I can share
         the end code with the non-initialization case. */
#ifdef JITTER_HAVE_PATCH_IN
      //JITTER_DUMP_PATCH_IN_DESCRIPTORS(uninspired);
#endif // #ifdef JITTER_HAVE_PATCH_IN
      goto jitter_possibly_restore_registers_and_return_label;
    }


  /* Before setting up runtime structures and jumping to the first
     instruction check that the last exit status was correct, and
     update it for the present run. */
  switch (_JITTER_STATE_BACKING_FIELD (exit_status))
    {
    case uninspired_exit_status_never_executed:
    case uninspired_exit_status_exited:
    case uninspired_exit_status_debug:
      /* This is normal and expected. */
      _JITTER_STATE_BACKING_FIELD (exit_status)
        = uninspired_exit_status_being_executed;
      break;

    case uninspired_exit_status_being_executed:
      jitter_fatal ("the exit status before execution is "
                    "uninspired_exit_status_being_executed: "
                    "you may have exited the last evaluation "
                    "through longjmp, or reused the same VM "
                    "state for a new execution with a previous "
                    "execution still in progress.");

    default:
      jitter_fatal ("invalid exit state %i",
                    (int) _JITTER_STATE_BACKING_FIELD (exit_status));
    }

  /* Here is the actual *executor* initialization, to be run before
     actually running the code. */

/* Selectively suppress suprious -Wmaybe-uninitialized .
   The indirect jump hack I use in profiling mode in order to
   have a large gap inside a function introduced by assembler without
   being restricted by jump offset limits (intentionally) tricks GCC
   into believing that the indirect jump may reach any instruction label;
   GCC would then warn that some locals might be used uninitialized,
   by skipping over their initialization.  This however is not possible,
   and I want to selectively silence the warning for the variables in
   question. */
//#pragma GCC diagnostic push
//#pragma GCC diagnostic ignored "-Wmaybe-uninitialized"

  /* Wrap functions and globals used within VM instructions, if needed.
     This is a trick to keep instructions readable while avoiding PC-relative
     addressing, which would mess up replicated code. */
#ifdef JITTER_REPLICATE

  /* Protect the C globals used in VM instructions so that they are always
     referred thru a pointer (from a register or the stack) set in the
     non-replicated part.  This is necessary on architectures where I can't
     force global references to pass thru a GOT.
     [FIXME: possibly don't do this on architectures that don't need it.] */

  typeof (uninspired_states) * volatile _my_volatile_pointer_to_uninspired_states = & uninspired_states;
  typeof (uninspired_states) * const restrict _my_pointer_to_uninspired_states __attribute__ ((unused))
     = _my_volatile_pointer_to_uninspired_states;
# undef uninspired_states
# define uninspired_states (* _my_pointer_to_uninspired_states)

  typeof (uninspired_newline_string) * volatile _my_volatile_pointer_to_uninspired_newline_string = & uninspired_newline_string;
  typeof (uninspired_newline_string) * const restrict _my_pointer_to_uninspired_newline_string __attribute__ ((unused))
     = _my_volatile_pointer_to_uninspired_newline_string;
# undef uninspired_newline_string
# define uninspired_newline_string (* _my_pointer_to_uninspired_newline_string)

  typeof (uninspired_print_topmost_format_string) * volatile _my_volatile_pointer_to_uninspired_print_topmost_format_string = & uninspired_print_topmost_format_string;
  typeof (uninspired_print_topmost_format_string) * const restrict _my_pointer_to_uninspired_print_topmost_format_string __attribute__ ((unused))
     = _my_volatile_pointer_to_uninspired_print_topmost_format_string;
# undef uninspired_print_topmost_format_string
# define uninspired_print_topmost_format_string (* _my_pointer_to_uninspired_print_topmost_format_string)

  typeof (uninspired_hcf_format_string) * volatile _my_volatile_pointer_to_uninspired_hcf_format_string = & uninspired_hcf_format_string;
  typeof (uninspired_hcf_format_string) * const restrict _my_pointer_to_uninspired_hcf_format_string __attribute__ ((unused))
     = _my_volatile_pointer_to_uninspired_hcf_format_string;
# undef uninspired_hcf_format_string
# define uninspired_hcf_format_string (* _my_pointer_to_uninspired_hcf_format_string)

  typeof (uninspired_printfixnum_decimal_hex_format_string) * volatile _my_volatile_pointer_to_uninspired_printfixnum_decimal_hex_format_string = & uninspired_printfixnum_decimal_hex_format_string;
  typeof (uninspired_printfixnum_decimal_hex_format_string) * const restrict _my_pointer_to_uninspired_printfixnum_decimal_hex_format_string __attribute__ ((unused))
     = _my_volatile_pointer_to_uninspired_printfixnum_decimal_hex_format_string;
# undef uninspired_printfixnum_decimal_hex_format_string
# define uninspired_printfixnum_decimal_hex_format_string (* _my_pointer_to_uninspired_printfixnum_decimal_hex_format_string)

  typeof (uninspired_printdouble_format_string) * volatile _my_volatile_pointer_to_uninspired_printdouble_format_string = & uninspired_printdouble_format_string;
  typeof (uninspired_printdouble_format_string) * const restrict _my_pointer_to_uninspired_printdouble_format_string __attribute__ ((unused))
     = _my_volatile_pointer_to_uninspired_printdouble_format_string;
# undef uninspired_printdouble_format_string
# define uninspired_printdouble_format_string (* _my_pointer_to_uninspired_printdouble_format_string)

  typeof (uninspired_printfixnum_format_string) * volatile _my_volatile_pointer_to_uninspired_printfixnum_format_string = & uninspired_printfixnum_format_string;
  typeof (uninspired_printfixnum_format_string) * const restrict _my_pointer_to_uninspired_printfixnum_format_string __attribute__ ((unused))
     = _my_volatile_pointer_to_uninspired_printfixnum_format_string;
# undef uninspired_printfixnum_format_string
# define uninspired_printfixnum_format_string (* _my_pointer_to_uninspired_printfixnum_format_string)

  /* Similarly, wrap the C functions used in VM instructions, so that they are
     always called thru a function pointer.  This is necessary on architectures
     where call instructions represent the callee as a PC-relative address.
     Unfortunately C has a special quirky syntax for function pointers, so I
     can't just use the code above.  [FIXME: don't do this on architectures
     that don't need it.] */
  typeof (jitter_xmalloc) * volatile _jitter_my_volatile_pointer_to_jitter_xmalloc = & jitter_xmalloc;
  typeof (jitter_xmalloc) * const _jitter_my_jitter_xmalloc __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_jitter_xmalloc;
# undef jitter_xmalloc
# define jitter_xmalloc(...)  \
  JITTER_CALL_C (_jitter_my_jitter_xmalloc, __VA_ARGS__)
  typeof (rand) * volatile _jitter_my_volatile_pointer_to_rand = & rand;
  typeof (rand) * const _jitter_my_rand __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_rand;
# undef rand
# define rand(...)  \
  JITTER_CALL_C (_jitter_my_rand, __VA_ARGS__)
  typeof (exit) * volatile _jitter_my_volatile_pointer_to_exit = & exit;
  typeof (exit) * const _jitter_my_exit __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_exit;
# undef exit
# define exit(...)  \
  JITTER_CALL_C (_jitter_my_exit, __VA_ARGS__)
  typeof (fprintf) * volatile _jitter_my_volatile_pointer_to_fprintf = & fprintf;
  typeof (fprintf) * const _jitter_my_fprintf __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_fprintf;
# undef fprintf
# define fprintf(...)  \
  JITTER_CALL_C (_jitter_my_fprintf, __VA_ARGS__)
  typeof (fflush) * volatile _jitter_my_volatile_pointer_to_fflush = & fflush;
  typeof (fflush) * const _jitter_my_fflush __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_fflush;
# undef fflush
# define fflush(...)  \
  JITTER_CALL_C (_jitter_my_fflush, __VA_ARGS__)
  typeof (printf) * volatile _jitter_my_volatile_pointer_to_printf = & printf;
  typeof (printf) * const _jitter_my_printf __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_printf;
# undef printf
# define printf(...)  \
  JITTER_CALL_C (_jitter_my_printf, __VA_ARGS__)
/* See the comment above about spurious -Wmaybe-uninitialized warnings. */
//#pragma GCC diagnostic pop
#endif // #ifdef JITTER_REPLICATE


  /* Make an automatic struct holding a copy of the state whose pointer was given.
     The idea is that the copy should be in registers, as far as possible. */
  struct uninspired_state_runtime jitter_state_runtime
    = jitter_original_state->_uninspired_xOxBm2j5vO_state_runtime;

  /* Initialize a pointer to The Array base.  This pointer will be in a
     global register variable with no-threading dispatch, and with
     other dispatches in an automatic variable, still hopefully kept
     in a register. */
/* About the pragma, look for "-Wmaybe-uninitialized" in the comments above. FIXME: this is to avoid a GCC warning with profiling.  Check with profiling on. */
//#pragma GCC diagnostic push
//#pragma GCC diagnostic ignored "-Wmaybe-uninitialized"
#ifdef JITTER_DISPATCH_NO_THREADING
# define jitter_array_base uninspired_array_base_register_variable
#else
  char * restrict jitter_array_base __attribute__ ((unused));
#endif // #ifdef JITTER_DISPATCH_NO_THREADING
//#pragma GCC diagnostic pop
  jitter_array_base
    = (((char *) jitter_original_state->uninspired_state_backing.jitter_array)
       + JITTER_ARRAY_BIAS);

  /* Declare the instruction pointer from the thread array, unless the dispatch
     is no-threading, in which case no thread array even exists. */
  uninspired_program_point jitter_ip = NULL; /* Invalidate to catch errors. */
#ifdef JITTER_REPLICATE
  /* Save an instruction address within this function, to jump to at VM exit
     time; that way we can be sure that at exit time we are back to
     non-replicated code, and stuff like PC-relative addressing work again
     without special tricks.  This variable may safely (and actually should,
     for performance) be kept on the stack.  We need it to be volatile to
     prevent the compiler from being too clever and jump to it using a
     PC-relative displacement from replicated code.   It must not be static,
     since non-automatic variables are problematic to access from replicated
     code, which might use PC-relative addressing. */
  volatile typeof (&& jitter_exit_vm_label) restrict
  jitter_saved_exit_non_replicated_code_pointer = &&jitter_exit_vm_label;
  JITTER_MARK_MEMORY_AS_SET_BY_ASSEMBLY(jitter_saved_exit_non_replicated_code_pointer);
#endif // #ifdef JITTER_REPLICATE


#ifdef JITTER_REPLICATE
  /* FIXME: comment. */
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(clear_mpending__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(clear_mpending__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(clear_mpending__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(clear_mpending__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(div___rrR___rrR___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(div___rrR___rrR___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(div___rrR___rrR___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(div___rrR___rrR___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(div___rrR__n2___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(div___rrR__n2___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(div___rrR__n2___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(div___rrR__n2___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(div___rrR__nR___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(div___rrR__nR___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(div___rrR__nR___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(div___rrR__nR___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(div__nR___rrR___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(div__nR___rrR___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(div__nR___rrR___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(div__nR___rrR___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(div__nR__n2___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(div__nR__n2___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(div__nR__n2___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(div__nR__n2___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(div__nR__nR___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(div__nR__nR___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(div__nR__nR___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(div__nR__nR___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(exit___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(exit___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(exit___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(exit___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(exit__nR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(exit__nR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(exit__nR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(exit__nR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(hcf__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(hcf__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(hcf__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(hcf__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(install_msignal_mhandler__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(install_msignal_mhandler__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(install_msignal_mhandler__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(install_msignal_mhandler__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(mallocwords___rrR___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(mallocwords___rrR___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(mallocwords___rrR___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(mallocwords___rrR___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(mallocwords__nR___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(mallocwords__nR___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(mallocwords__nR___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(mallocwords__nR___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(mod___rrR___rrR___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(mod___rrR___rrR___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(mod___rrR___rrR___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(mod___rrR___rrR___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(mod___rrR__n2___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(mod___rrR__n2___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(mod___rrR__n2___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(mod___rrR__n2___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(mod___rrR__nR___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(mod___rrR__nR___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(mod___rrR__nR___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(mod___rrR__nR___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(mod__nR___rrR___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(mod__nR___rrR___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(mod__nR___rrR___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(mod__nR___rrR___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(mod__nR__n2___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(mod__nR__n2___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(mod__nR__n2___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(mod__nR__n2___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(mod__nR__nR___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(mod__nR__nR___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(mod__nR__nR___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(mod__nR__nR___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print_mpending_msignals__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(print_mpending_msignals__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print_mpending_msignals__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print_mpending_msignals__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print_mtopmost__nR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(print_mtopmost__nR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print_mtopmost__nR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print_mtopmost__nR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(printfixnum___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(printfixnum___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(printfixnum___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(printfixnum___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(printfixnum__nR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(printfixnum__nR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(printfixnum__nR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(printfixnum__nR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(push_mdepths__nR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(push_mdepths__nR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(push_mdepths__nR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(push_mdepths__nR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(push_mincreasing__nR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(push_mincreasing__nR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(push_mincreasing__nR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(push_mincreasing__nR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(random___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(random___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(random___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(random___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(stackprint__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(stackprint__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(stackprint__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(stackprint__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_maddo___rrR___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_maddo___rrR___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_maddo___rrR___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_maddo___rrR___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_maddo___rrR__n1___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_maddo___rrR__n1___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_maddo___rrR__n1___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_maddo___rrR__n1___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_maddo___rrR__n_m1___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_maddo___rrR__n_m1___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_maddo___rrR__n_m1___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_maddo___rrR__n_m1___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_maddo___rrR__nR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_maddo___rrR__nR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_maddo___rrR__nR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_maddo___rrR__nR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_maddo__nR___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_maddo__nR___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_maddo__nR___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_maddo__nR___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_maddo__nR__n1___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_maddo__nR__n1___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_maddo__nR__n1___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_maddo__nR__n1___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_maddo__nR__n_m1___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_maddo__nR__n_m1___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_maddo__nR__n_m1___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_maddo__nR__n_m1___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_maddo__nR__nR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_maddo__nR__nR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_maddo__nR__nR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_maddo__nR__nR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mb__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mb__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mb__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mb__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mband___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mband___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mband___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mband___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mband___rrR__n3__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mband___rrR__n3__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mband___rrR__n3__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mband___rrR__n3__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mband___rrR__n7__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mband___rrR__n7__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mband___rrR__n7__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mband___rrR__n7__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mband___rrR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mband___rrR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mband___rrR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mband___rrR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mband__nR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mband__nR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mband__nR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mband__nR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mband__nR__n3__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mband__nR__n3__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mband__nR__n3__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mband__nR__n3__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mband__nR__n7__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mband__nR__n7__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mband__nR__n7__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mband__nR__n7__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mband__nR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mband__nR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mband__nR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mband__nR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbeq___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbeq___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbeq___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbeq___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbeq___rrR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbeq___rrR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbeq___rrR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbeq___rrR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbeq__nR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbeq__nR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbeq__nR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbeq__nR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbeq__nR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbeq__nR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbeq__nR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbeq__nR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rrR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge___rrR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rrR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rrR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rrR__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge___rrR__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rrR__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rrR__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rrR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge___rrR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rrR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rrR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n0___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge__n0___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n0___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n0___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n0__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge__n0__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n0__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n0__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n0__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge__n0__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n0__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n0__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n0__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge__n0__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n0__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n0__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n1___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge__n1___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n1___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n1___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n1__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge__n1__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n1__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n1__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n1__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge__n1__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n1__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n1__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n1__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge__n1__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n1__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n1__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__nR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge__nR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__nR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__nR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__nR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge__nR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__nR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__nR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__nR__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge__nR__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__nR__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__nR__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__nR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge__nR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__nR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__nR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgeu___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu___rrR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgeu___rrR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu___rrR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu___rrR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu___rrR__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgeu___rrR__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu___rrR__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu___rrR__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu___rrR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgeu___rrR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu___rrR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu___rrR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__n0___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgeu__n0___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__n0___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__n0___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__n0__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgeu__n0__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__n0__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__n0__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__n0__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgeu__n0__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__n0__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__n0__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__n0__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgeu__n0__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__n0__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__n0__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__n1___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgeu__n1___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__n1___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__n1___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__n1__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgeu__n1__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__n1__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__n1__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__n1__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgeu__n1__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__n1__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__n1__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__n1__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgeu__n1__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__n1__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__n1__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__nR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgeu__nR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__nR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__nR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__nR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgeu__nR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__nR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__nR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__nR__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgeu__nR__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__nR__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__nR__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__nR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgeu__nR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__nR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgeu__nR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgt___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt___rrR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgt___rrR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt___rrR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt___rrR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt___rrR__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgt___rrR__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt___rrR__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt___rrR__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt___rrR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgt___rrR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt___rrR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt___rrR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__n0___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgt__n0___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__n0___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__n0___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__n0__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgt__n0__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__n0__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__n0__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__n0__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgt__n0__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__n0__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__n0__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__n0__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgt__n0__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__n0__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__n0__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__n1___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgt__n1___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__n1___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__n1___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__n1__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgt__n1__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__n1__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__n1__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__n1__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgt__n1__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__n1__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__n1__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__n1__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgt__n1__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__n1__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__n1__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__nR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgt__nR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__nR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__nR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__nR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgt__nR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__nR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__nR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__nR__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgt__nR__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__nR__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__nR__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__nR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgt__nR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__nR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgt__nR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgtu___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu___rrR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgtu___rrR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu___rrR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu___rrR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu___rrR__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgtu___rrR__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu___rrR__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu___rrR__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu___rrR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgtu___rrR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu___rrR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu___rrR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__n0___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgtu__n0___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__n0___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__n0___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__n0__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgtu__n0__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__n0__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__n0__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__n0__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgtu__n0__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__n0__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__n0__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__n0__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgtu__n0__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__n0__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__n0__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__n1___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgtu__n1___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__n1___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__n1___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__n1__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgtu__n1__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__n1__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__n1__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__n1__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgtu__n1__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__n1__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__n1__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__n1__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgtu__n1__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__n1__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__n1__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__nR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgtu__nR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__nR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__nR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__nR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgtu__nR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__nR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__nR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__nR__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgtu__nR__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__nR__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__nR__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__nR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbgtu__nR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__nR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbgtu__nR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rrR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble___rrR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rrR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rrR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rrR__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble___rrR__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rrR__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rrR__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rrR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble___rrR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rrR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rrR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n0___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble__n0___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n0___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n0___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n0__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble__n0__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n0__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n0__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n0__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble__n0__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n0__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n0__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n0__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble__n0__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n0__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n0__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n1___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble__n1___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n1___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n1___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n1__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble__n1__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n1__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n1__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n1__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble__n1__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n1__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n1__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n1__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble__n1__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n1__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n1__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__nR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble__nR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__nR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__nR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__nR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble__nR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__nR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__nR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__nR__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble__nR__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__nR__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__nR__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__nR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble__nR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__nR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__nR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbleu___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu___rrR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbleu___rrR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu___rrR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu___rrR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu___rrR__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbleu___rrR__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu___rrR__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu___rrR__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu___rrR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbleu___rrR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu___rrR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu___rrR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__n0___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbleu__n0___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__n0___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__n0___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__n0__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbleu__n0__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__n0__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__n0__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__n0__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbleu__n0__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__n0__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__n0__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__n0__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbleu__n0__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__n0__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__n0__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__n1___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbleu__n1___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__n1___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__n1___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__n1__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbleu__n1__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__n1__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__n1__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__n1__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbleu__n1__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__n1__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__n1__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__n1__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbleu__n1__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__n1__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__n1__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__nR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbleu__nR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__nR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__nR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__nR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbleu__nR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__nR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__nR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__nR__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbleu__nR__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__nR__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__nR__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__nR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbleu__nR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__nR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbleu__nR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mblt___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt___rrR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mblt___rrR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt___rrR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt___rrR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt___rrR__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mblt___rrR__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt___rrR__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt___rrR__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt___rrR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mblt___rrR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt___rrR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt___rrR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__n0___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mblt__n0___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__n0___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__n0___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__n0__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mblt__n0__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__n0__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__n0__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__n0__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mblt__n0__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__n0__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__n0__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__n0__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mblt__n0__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__n0__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__n0__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__n1___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mblt__n1___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__n1___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__n1___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__n1__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mblt__n1__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__n1__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__n1__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__n1__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mblt__n1__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__n1__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__n1__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__n1__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mblt__n1__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__n1__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__n1__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__nR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mblt__nR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__nR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__nR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__nR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mblt__nR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__nR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__nR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__nR__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mblt__nR__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__nR__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__nR__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__nR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mblt__nR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__nR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mblt__nR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbltu___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu___rrR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbltu___rrR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu___rrR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu___rrR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu___rrR__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbltu___rrR__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu___rrR__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu___rrR__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu___rrR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbltu___rrR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu___rrR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu___rrR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__n0___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbltu__n0___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__n0___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__n0___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__n0__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbltu__n0__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__n0__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__n0__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__n0__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbltu__n0__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__n0__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__n0__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__n0__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbltu__n0__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__n0__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__n0__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__n1___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbltu__n1___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__n1___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__n1___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__n1__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbltu__n1__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__n1__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__n1__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__n1__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbltu__n1__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__n1__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__n1__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__n1__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbltu__n1__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__n1__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__n1__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__nR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbltu__nR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__nR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__nR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__nR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbltu__nR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__nR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__nR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__nR__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbltu__nR__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__nR__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__nR__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__nR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbltu__nR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__nR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbltu__nR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rrR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne___rrR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rrR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rrR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rrR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne___rrR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rrR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rrR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__n0___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne__n0___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__n0___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__n0___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__n0__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne__n0__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__n0__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__n0__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__n0__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne__n0__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__n0__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__n0__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__nR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne__nR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__nR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__nR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__nR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne__nR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__nR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__nR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__nR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne__nR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__nR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__nR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbneg___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbneg___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbneg___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbneg___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbneg__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbneg__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbneg__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbneg__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnneg___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbnneg___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnneg___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnneg___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnneg__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbnneg__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnneg__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnneg__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnotand___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbnotand___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnotand___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnotand___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnotand___rrR__n3__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbnotand___rrR__n3__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnotand___rrR__n3__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnotand___rrR__n3__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnotand___rrR__n7__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbnotand___rrR__n7__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnotand___rrR__n7__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnotand___rrR__n7__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnotand___rrR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbnotand___rrR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnotand___rrR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnotand___rrR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnotand__nR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbnotand__nR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnotand__nR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnotand__nR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnotand__nR__n3__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbnotand__nR__n3__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnotand__nR__n3__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnotand__nR__n3__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnotand__nR__n7__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbnotand__nR__n7__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnotand__nR__n7__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnotand__nR__n7__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnotand__nR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbnotand__nR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnotand__nR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnotand__nR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnpos___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbnpos___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnpos___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnpos___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnpos__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbnpos__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnpos__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnpos__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnz___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbnz___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnz___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnz___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnz__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbnz__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnz__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnz__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbpos___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbpos___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbpos___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbpos___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbpos__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbpos__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbpos__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbpos__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbr___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbr___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbr___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbr___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbz___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbz___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbz___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbz___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbz__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbz__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbz__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbz__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mdivo___rrR___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mdivo___rrR___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mdivo___rrR___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mdivo___rrR___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mdivo___rrR__n2___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mdivo___rrR__n2___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mdivo___rrR__n2___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mdivo___rrR__n2___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mdivo___rrR__nR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mdivo___rrR__nR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mdivo___rrR__nR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mdivo___rrR__nR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mdivo__nR___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mdivo__nR___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mdivo__nR___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mdivo__nR___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mdivo__nR__n2___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mdivo__nR__n2___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mdivo__nR__n2___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mdivo__nR__n2___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mdivo__nR__nR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mdivo__nR__nR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mdivo__nR__nR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mdivo__nR__nR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mendvm__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mendvm__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mendvm__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mendvm__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mexitvm__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mexitvm__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mexitvm__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mexitvm__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmodo___rrR___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mmodo___rrR___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmodo___rrR___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmodo___rrR___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmodo___rrR__n2___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mmodo___rrR__n2___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmodo___rrR__n2___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmodo___rrR__n2___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmodo___rrR__nR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mmodo___rrR__nR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmodo___rrR__nR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmodo___rrR__nR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmodo__nR___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mmodo__nR___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmodo__nR___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmodo__nR___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmodo__nR__n2___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mmodo__nR__n2___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmodo__nR__n2___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmodo__nR__n2___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmodo__nR__nR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mmodo__nR__nR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmodo__nR__nR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmodo__nR__nR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmulo___rrR___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mmulo___rrR___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmulo___rrR___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmulo___rrR___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmulo___rrR__n2___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mmulo___rrR__n2___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmulo___rrR__n2___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmulo___rrR__n2___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmulo___rrR__nR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mmulo___rrR__nR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmulo___rrR__nR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmulo___rrR__nR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmulo__nR___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mmulo__nR___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmulo__nR___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmulo__nR___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmulo__nR__n2___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mmulo__nR__n2___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmulo__nR__n2___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmulo__nR__n2___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmulo__nR__nR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mmulo__nR__nR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmulo__nR__nR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mmulo__nR__nR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprocedurecall__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprocedurecall__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprocedurecall__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprocedurecall__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprocedurecallr___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprocedurecallr___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprocedurecallr___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprocedurecallr___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprocedurecallr__lR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprocedurecallr__lR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprocedurecallr__lR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprocedurecallr__lR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprocedureprolog__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprocedureprolog__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprocedureprolog__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprocedureprolog__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprocedurereturn__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprocedurereturn__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprocedurereturn__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprocedurereturn__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mraise___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mraise__n0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mraise__n1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n2__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mraise__n2__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n2__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n2__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n3__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mraise__n3__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n3__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n3__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n4__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mraise__n4__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n4__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n4__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n5__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mraise__n5__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n5__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n5__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n6__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mraise__n6__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n6__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n6__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n7__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mraise__n7__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n7__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n7__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n8__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mraise__n8__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n8__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n8__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n9__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mraise__n9__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n9__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n9__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n10__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mraise__n10__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n10__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__n10__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__nR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mraise__nR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__nR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__nR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msafe_mpoint__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_msafe_mpoint__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msafe_mpoint__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msafe_mpoint__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mstackif__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mstackif__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mstackif__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mstackif__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mstacknondroppingif__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mstacknondroppingif__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mstacknondroppingif__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mstacknondroppingif__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msubo___rrR___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_msubo___rrR___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msubo___rrR___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msubo___rrR___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msubo___rrR__n1___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_msubo___rrR__n1___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msubo___rrR__n1___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msubo___rrR__n1___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msubo___rrR__nR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_msubo___rrR__nR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msubo___rrR__nR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msubo___rrR__nR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msubo__nR___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_msubo__nR___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msubo__nR___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msubo__nR___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msubo__nR__n1___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_msubo__nR__n1___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msubo__nR__n1___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msubo__nR__n1___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msubo__nR__nR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_msubo__nR__nR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msubo__nR__nR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msubo__nR__nR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_munreachable__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_munreachable__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_munreachable__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_munreachable__retR)));
#endif // #ifdef JITTER_REPLICATE

  /* Initialization C code from the user */

    /* End of the initialization C code from the user */


# if defined(JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined(JITTER_DISPATCH_NO_THREADING)
  /* Execute architecture-specific execution-beginning code, if any.
     Make sure it is safe to expand the macro without do..while
     (false), since the expansion may contain declarations of
     variables to be used later. */
  {}; JITTER_EXECUTION_BEGINNING_; {};
  /* Declare a variable used in asm constraints on some architectures:
     see the comment in jitter-executor.h . */
  volatile long _jitter_useless_variable __attribute__ ((unused))
    = 0;
# endif

#if defined (UNINSPIRED_PROFILE_SAMPLE)
    /* Start sample-profiling: this starts the periodic timer signal,
       whose handler will look at the current instruction field within
       the special-purpose struct in the Array. */
    uninspired_profile_sample_start (UNINSPIRED_OWN_STATE);
#endif // #if defined (UNINSPIRED_PROFILE_SAMPLE)

  /* Jump to the first instruction.  If replication is enabled this point
     marks the boundary between the ordinary world of C compiled code and
     the more fragile replicated code, where PC-relative address does
     not work as intended (which prevents the use of global and static
     variables, string literals and possibly large literal constants), and
     GDB gets easily confused. */
  jitter_ip
    = jitter_original_state->uninspired_state_backing.initial_program_point;

  /* This is the actual jump to the first instruction: it's not an
     inline asm constraint lie like below. */

# if   defined(JITTER_DISPATCH_SWITCH)
    goto jitter_dispatching_switch_label;
# elif (defined(JITTER_DISPATCH_DIRECT_THREADING)  \
        || defined(JITTER_DISPATCH_MINIMAL_THREADING))
    goto * (jitter_ip->label);
# elif defined(JITTER_DISPATCH_NO_THREADING)
    /* On no-threading we only use jitter_ip for the first instruction.
       Make it an alias for the base, which will be enough to satisfy
       inline assembly code which pretends to alter the instruction
       pointer in ways invisible to the compiler.
       At least in my tests this trick frees up one hardware register,
       which is not surprising. */
    goto * jitter_ip;
#   define jitter_ip uninspired_array_base_register_variable
# else
#   error "unknown dispatch"
# endif // if ... dispatch
#ifdef JITTER_REPLICATE
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE();
  goto jitter_fake_target;
#endif // #ifdef JITTER_REPLICATE

#ifdef JITTER_DISPATCH_SWITCH
  /* This is the dispatching switch.  At the beginning of the first VM
     VM instruction and at the end of each other, control jumps here. */
 jitter_dispatching_switch_label:
  switch (jitter_ip->fixnum)
    {
#endif // #ifdef JITTER_DISPATCH_SWITCH

#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
JITTER_INSTRUCTION_PROLOG_(!INVALID, _eINVALID, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  0
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !INVALID
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eINVALID
{

jitter_fatal ("reached the !INVALID instruction");
}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!INVALID, _eINVALID, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
JITTER_INSTRUCTION_PROLOG_(!BEGINBASICBLOCK, _eBEGINBASICBLOCK, hot)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  1
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !BEGINBASICBLOCK
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eBEGINBASICBLOCK
{

#ifdef JITTER_DISPATCH_MINIMAL_THREADING
  JITTER_SET_IP (jitter_ip + 1);
#endif // #ifdef JITTER_DISPATCH_MINIMAL_THREADING

}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!BEGINBASICBLOCK, _eBEGINBASICBLOCK, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
JITTER_INSTRUCTION_PROLOG_(!EXITVM, _eEXITVM, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  2
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !EXITVM
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eEXITVM
{

_JITTER_EXIT();
}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!EXITVM, _eEXITVM, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

JITTER_INSTRUCTION_PROLOG_(!DATALOCATIONS, _eDATALOCATIONS, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  3
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !DATALOCATIONS
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eDATALOCATIONS
{
#ifndef JITTER_DISPATCH_SWITCH
#ifndef JITTER_DISPATCH_NO_THREADING
  JITTER_DATA_LOCATION_DATUM ("instruction pointer", jitter_ip);
#endif // #ifndef JITTER_DISPATCH_NO_THREADING
  JITTER_DATA_LOCATION_DATUM ("base", jitter_array_base);
#ifdef JITTER_DISPATCH_NO_THREADING
#ifdef JITTER_SCRATCH_REGISTER
  JITTER_DATA_LOCATION_DATUM ("scratch", jitter_residual_argument_scratch_register_variable);
#endif // #ifdef JITTER_SCRATCH_REGISTER

#endif // #ifdef JITTER_DISPATCH_NO_THREADING
#ifdef JITTER_DISPATCH_NO_THREADING
#if (0 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_DATA_LOCATION_DATUM ("residual 0", jitter_residual_argument_0_register_variable);
#endif // #if (0 < JITTER_RESIDUAL_REGISTER_NO)
#if (1 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_DATA_LOCATION_DATUM ("residual 1", jitter_residual_argument_1_register_variable);
#endif // #if (1 < JITTER_RESIDUAL_REGISTER_NO)
#if (2 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_DATA_LOCATION_DATUM ("residual 2", jitter_residual_argument_2_register_variable);
#endif // #if (2 < JITTER_RESIDUAL_REGISTER_NO)
#if (3 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_DATA_LOCATION_DATUM ("residual 3", jitter_residual_argument_3_register_variable);
#endif // #if (3 < JITTER_RESIDUAL_REGISTER_NO)
#if (4 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_DATA_LOCATION_DATUM ("residual 4", jitter_residual_argument_4_register_variable);
#endif // #if (4 < JITTER_RESIDUAL_REGISTER_NO)
#endif // #ifdef JITTER_DISPATCH_NO_THREADING
  JITTER_DATA_LOCATION_DATUM ("link register", jitter_state_runtime._jitter_link);
  JITTER_DATA_LOCATION_DATUM ("stack top", 
     JITTER_STACK_TOS_TOP_NAME (whatever, jitter_state_runtime., stack));
  JITTER_DATA_LOCATION_DATUM ("stack undertop ptr", 
     JITTER_STACK_TOS_UNDER_TOP_POINTER_NAME (whatever, jitter_state_runtime., stack));
  JITTER_DATA_LOCATION_DATUM ("handlers top ptr", 
     JITTER_STACK_NTOS_TOP_POINTER_NAME (whatever, jitter_state_runtime., handlers));
#endif // #ifndef JITTER_DISPATCH_SWITCH
}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!DATALOCATIONS, _eDATALOCATIONS, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
JITTER_INSTRUCTION_PROLOG_(!NOP, _eNOP, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  4
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !NOP
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eNOP
{

  /* Do nothing. */;
}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!NOP, _eNOP, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
JITTER_INSTRUCTION_PROLOG_(!UNREACHABLE0, _eUNREACHABLE0, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  5
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !UNREACHABLE0
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eUNREACHABLE0
{

jitter_fatal ("reached the !UNREACHABLE0 instruction");
}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!UNREACHABLE0, _eUNREACHABLE0, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
JITTER_INSTRUCTION_PROLOG_(!UNREACHABLE1, _eUNREACHABLE1, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  6
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !UNREACHABLE1
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eUNREACHABLE1
{

jitter_fatal ("reached the !UNREACHABLE1 instruction");
}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!UNREACHABLE1, _eUNREACHABLE1, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
JITTER_INSTRUCTION_PROLOG_(!PRETENDTOJUMPANYWHERE, _ePRETENDTOJUMPANYWHERE, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  7
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !PRETENDTOJUMPANYWHERE
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _ePRETENDTOJUMPANYWHERE
jitter_fake_target: __attribute__ ((unused));{

#if ! defined(JITTER_DISPATCH_SWITCH)
  JITTER_PRETEND_TO_UPDATE_IP_;
  goto * jitter_ip;
#endif

}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!PRETENDTOJUMPANYWHERE, _ePRETENDTOJUMPANYWHERE, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  /* Ordinary specialized instructions. */
  /* Ordinary specialised instruction add/%rR/%rR/%rR */
  JITTER_INSTRUCTION_PROLOG_(add/%rR/%rR/%rR, add___rrR___rrR___rrR, cold)
  { /* This block begins with definitions for add/%rR/%rR/%rR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       8
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         add/%rR/%rR/%rR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "add"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "add/%rR/%rR/%rR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME add___rrR___rrR___rrR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3

    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_2.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[3]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of add/%rR/%rR/%rR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "add/%rR/%rR/%rR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for add/%rR/%rR/%rR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_ARGN2 = JITTER_ARGN0 + JITTER_ARGN1;
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for add/%rR/%rR/%rR . */

  //fprintf (stderr, "..Executed instruction %s\n", "add/%rR/%rR/%rR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the add/%rR/%rR/%rR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(add/%rR/%rR/%rR, add___rrR___rrR___rrR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for add/%rR/%rR/%rR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction add/%rR/n1/%rR */
  JITTER_INSTRUCTION_PROLOG_(add/%rR/n1/%rR, add___rrR__n1___rrR, cold)
  { /* This block begins with definitions for add/%rR/n1/%rR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       9
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         add/%rR/n1/%rR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "add"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "add/%rR/n1/%rR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME add___rrR__n1___rrR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2

    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 1L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of add/%rR/n1/%rR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "add/%rR/n1/%rR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for add/%rR/n1/%rR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_ARGN2 = JITTER_ARGN0 + JITTER_ARGN1;
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for add/%rR/n1/%rR . */

  //fprintf (stderr, "..Executed instruction %s\n", "add/%rR/n1/%rR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the add/%rR/n1/%rR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(add/%rR/n1/%rR, add___rrR__n1___rrR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for add/%rR/n1/%rR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction add/%rR/n-1/%rR */
  JITTER_INSTRUCTION_PROLOG_(add/%rR/n-1/%rR, add___rrR__n_m1___rrR, cold)
  { /* This block begins with definitions for add/%rR/n-1/%rR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       10
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         add/%rR/n-1/%rR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "add"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "add/%rR/n-1/%rR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME add___rrR__n_m1___rrR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2

    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = -1L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of add/%rR/n-1/%rR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "add/%rR/n-1/%rR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for add/%rR/n-1/%rR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_ARGN2 = JITTER_ARGN0 + JITTER_ARGN1;
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for add/%rR/n-1/%rR . */

  //fprintf (stderr, "..Executed instruction %s\n", "add/%rR/n-1/%rR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the add/%rR/n-1/%rR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(add/%rR/n-1/%rR, add___rrR__n_m1___rrR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for add/%rR/n-1/%rR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction add/%rR/nR/%rR */
  JITTER_INSTRUCTION_PROLOG_(add/%rR/nR/%rR, add___rrR__nR___rrR, cold)
  { /* This block begins with definitions for add/%rR/nR/%rR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       11
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         add/%rR/nR/%rR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "add"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "add/%rR/nR/%rR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME add___rrR__nR___rrR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3

    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_2.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[3]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of add/%rR/nR/%rR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "add/%rR/nR/%rR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for add/%rR/nR/%rR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_ARGN2 = JITTER_ARGN0 + JITTER_ARGN1;
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for add/%rR/nR/%rR . */

  //fprintf (stderr, "..Executed instruction %s\n", "add/%rR/nR/%rR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the add/%rR/nR/%rR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(add/%rR/nR/%rR, add___rrR__nR___rrR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for add/%rR/nR/%rR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction add/n1/%rR/%rR */
  JITTER_INSTRUCTION_PROLOG_(add/n1/%rR/%rR, add__n1___rrR___rrR, cold)
  { /* This block begins with definitions for add/n1/%rR/%rR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       12
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         add/n1/%rR/%rR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "add"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "add/n1/%rR/%rR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME add__n1___rrR___rrR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 1L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of add/n1/%rR/%rR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "add/n1/%rR/%rR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for add/n1/%rR/%rR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_ARGN2 = JITTER_ARGN0 + JITTER_ARGN1;
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for add/n1/%rR/%rR . */

  //fprintf (stderr, "..Executed instruction %s\n", "add/n1/%rR/%rR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the add/n1/%rR/%rR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(add/n1/%rR/%rR, add__n1___rrR___rrR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for add/n1/%rR/%rR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction add/n1/n1/%rR */
  JITTER_INSTRUCTION_PROLOG_(add/n1/n1/%rR, add__n1__n1___rrR, cold)
  { /* This block begins with definitions for add/n1/n1/%rR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       13
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         add/n1/n1/%rR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "add"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "add/n1/n1/%rR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME add__n1__n1___rrR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 1L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 1L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of add/n1/n1/%rR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "add/n1/n1/%rR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for add/n1/n1/%rR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_ARGN2 = JITTER_ARGN0 + JITTER_ARGN1;
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for add/n1/n1/%rR . */

  //fprintf (stderr, "..Executed instruction %s\n", "add/n1/n1/%rR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the add/n1/n1/%rR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(add/n1/n1/%rR, add__n1__n1___rrR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for add/n1/n1/%rR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction add/n1/n-1/%rR */
  JITTER_INSTRUCTION_PROLOG_(add/n1/n-1/%rR, add__n1__n_m1___rrR, cold)
  { /* This block begins with definitions for add/n1/n-1/%rR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       14
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         add/n1/n-1/%rR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "add"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "add/n1/n-1/%rR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME add__n1__n_m1___rrR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 1L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = -1L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of add/n1/n-1/%rR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "add/n1/n-1/%rR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for add/n1/n-1/%rR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_ARGN2 = JITTER_ARGN0 + JITTER_ARGN1;
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for add/n1/n-1/%rR . */

  //fprintf (stderr, "..Executed instruction %s\n", "add/n1/n-1/%rR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the add/n1/n-1/%rR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(add/n1/n-1/%rR, add__n1__n_m1___rrR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for add/n1/n-1/%rR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction add/n1/nR/%rR */
  JITTER_INSTRUCTION_PROLOG_(add/n1/nR/%rR, add__n1__nR___rrR, cold)
  { /* This block begins with definitions for add/n1/nR/%rR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       15
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         add/n1/nR/%rR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "add"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "add/n1/nR/%rR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME add__n1__nR___rrR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 1L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of add/n1/nR/%rR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "add/n1/nR/%rR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for add/n1/nR/%rR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_ARGN2 = JITTER_ARGN0 + JITTER_ARGN1;
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for add/n1/nR/%rR . */

  //fprintf (stderr, "..Executed instruction %s\n", "add/n1/nR/%rR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the add/n1/nR/%rR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(add/n1/nR/%rR, add__n1__nR___rrR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for add/n1/nR/%rR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction add/n-1/%rR/%rR */
  JITTER_INSTRUCTION_PROLOG_(add/n-1/%rR/%rR, add__n_m1___rrR___rrR, cold)
  { /* This block begins with definitions for add/n-1/%rR/%rR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       16
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         add/n-1/%rR/%rR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "add"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "add/n-1/%rR/%rR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME add__n_m1___rrR___rrR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = -1L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of add/n-1/%rR/%rR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "add/n-1/%rR/%rR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for add/n-1/%rR/%rR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_ARGN2 = JITTER_ARGN0 + JITTER_ARGN1;
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for add/n-1/%rR/%rR . */

  //fprintf (stderr, "..Executed instruction %s\n", "add/n-1/%rR/%rR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the add/n-1/%rR/%rR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(add/n-1/%rR/%rR, add__n_m1___rrR___rrR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for add/n-1/%rR/%rR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction add/n-1/n1/%rR */
  JITTER_INSTRUCTION_PROLOG_(add/n-1/n1/%rR, add__n_m1__n1___rrR, cold)
  { /* This block begins with definitions for add/n-1/n1/%rR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       17
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         add/n-1/n1/%rR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "add"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "add/n-1/n1/%rR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME add__n_m1__n1___rrR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = -1L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 1L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of add/n-1/n1/%rR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "add/n-1/n1/%rR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for add/n-1/n1/%rR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_ARGN2 = JITTER_ARGN0 + JITTER_ARGN1;
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for add/n-1/n1/%rR . */

  //fprintf (stderr, "..Executed instruction %s\n", "add/n-1/n1/%rR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the add/n-1/n1/%rR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(add/n-1/n1/%rR, add__n_m1__n1___rrR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for add/n-1/n1/%rR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction add/n-1/n-1/%rR */
  JITTER_INSTRUCTION_PROLOG_(add/n-1/n-1/%rR, add__n_m1__n_m1___rrR, cold)
  { /* This block begins with definitions for add/n-1/n-1/%rR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       18
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         add/n-1/n-1/%rR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "add"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "add/n-1/n-1/%rR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME add__n_m1__n_m1___rrR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = -1L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = -1L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of add/n-1/n-1/%rR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "add/n-1/n-1/%rR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for add/n-1/n-1/%rR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_ARGN2 = JITTER_ARGN0 + JITTER_ARGN1;
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for add/n-1/n-1/%rR . */

  //fprintf (stderr, "..Executed instruction %s\n", "add/n-1/n-1/%rR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the add/n-1/n-1/%rR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(add/n-1/n-1/%rR, add__n_m1__n_m1___rrR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for add/n-1/n-1/%rR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction add/n-1/nR/%rR */
  JITTER_INSTRUCTION_PROLOG_(add/n-1/nR/%rR, add__n_m1__nR___rrR, cold)
  { /* This block begins with definitions for add/n-1/nR/%rR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       19
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         add/n-1/nR/%rR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "add"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "add/n-1/nR/%rR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME add__n_m1__nR___rrR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = -1L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of add/n-1/nR/%rR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "add/n-1/nR/%rR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for add/n-1/nR/%rR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_ARGN2 = JITTER_ARGN0 + JITTER_ARGN1;
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for add/n-1/nR/%rR . */

  //fprintf (stderr, "..Executed instruction %s\n", "add/n-1/nR/%rR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the add/n-1/nR/%rR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(add/n-1/nR/%rR, add__n_m1__nR___rrR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for add/n-1/nR/%rR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction add/nR/%rR/%rR */
  JITTER_INSTRUCTION_PROLOG_(add/nR/%rR/%rR, add__nR___rrR___rrR, cold)
  { /* This block begins with definitions for add/nR/%rR/%rR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       20
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         add/nR/%rR/%rR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "add"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "add/nR/%rR/%rR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME add__nR___rrR___rrR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3

    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_2.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[3]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of add/nR/%rR/%rR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "add/nR/%rR/%rR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for add/nR/%rR/%rR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_ARGN2 = JITTER_ARGN0 + JITTER_ARGN1;
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for add/nR/%rR/%rR . */

  //fprintf (stderr, "..Executed instruction %s\n", "add/nR/%rR/%rR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the add/nR/%rR/%rR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(add/nR/%rR/%rR, add__nR___rrR___rrR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for add/nR/%rR/%rR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction add/nR/n1/%rR */
  JITTER_INSTRUCTION_PROLOG_(add/nR/n1/%rR, add__nR__n1___rrR, cold)
  { /* This block begins with definitions for add/nR/n1/%rR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       21
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         add/nR/n1/%rR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "add"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "add/nR/n1/%rR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME add__nR__n1___rrR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2

    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 1L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of add/nR/n1/%rR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "add/nR/n1/%rR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for add/nR/n1/%rR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_ARGN2 = JITTER_ARGN0 + JITTER_ARGN1;
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for add/nR/n1/%rR . */

  //fprintf (stderr, "..Executed instruction %s\n", "add/nR/n1/%rR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the add/nR/n1/%rR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(add/nR/n1/%rR, add__nR__n1___rrR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for add/nR/n1/%rR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction add/nR/n-1/%rR */
  JITTER_INSTRUCTION_PROLOG_(add/nR/n-1/%rR, add__nR__n_m1___rrR, cold)
  { /* This block begins with definitions for add/nR/n-1/%rR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       22
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         add/nR/n-1/%rR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "add"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "add/nR/n-1/%rR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME add__nR__n_m1___rrR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2

    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = -1L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of add/nR/n-1/%rR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "add/nR/n-1/%rR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for add/nR/n-1/%rR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_ARGN2 = JITTER_ARGN0 + JITTER_ARGN1;
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for add/nR/n-1/%rR . */

  //fprintf (stderr, "..Executed instruction %s\n", "add/nR/n-1/%rR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the add/nR/n-1/%rR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(add/nR/n-1/%rR, add__nR__n_m1___rrR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for add/nR/n-1/%rR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction add/nR/nR/%rR */
  JITTER_INSTRUCTION_PROLOG_(add/nR/nR/%rR, add__nR__nR___rrR, cold)
  { /* This block begins with definitions for add/nR/nR/%rR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       23
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         add/nR/nR/%rR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "add"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "add/nR/nR/%rR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME add__nR__nR___rrR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3

    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_2.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[3]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of add/nR/nR/%rR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "add/nR/nR/%rR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for add/nR/nR/%rR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_ARGN2 = JITTER_ARGN0 + JITTER_ARGN1;
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for add/nR/nR/%rR . */

  //fprintf (stderr, "..Executed instruction %s\n", "add/nR/nR/%rR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the add/nR/nR/%rR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(add/nR/nR/%rR, add__nR__nR___rrR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for add/nR/nR/%rR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction addo/%rR/%rR/%rR/fR */
  JITTER_INSTRUCTION_PROLOG_(addo/%rR/%rR/%rR/fR, addo___rrR___rrR___rrR__fR, cold)
  { /* This block begins with definitions for addo/%rR/%rR/%rR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       24
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         addo/%rR/%rR/%rR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "addo"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "addo/%rR/%rR/%rR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME addo___rrR___rrR___rrR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 4
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for addo/%rR/%rR/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_2.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[3]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

    /* The 3th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF3 0
    /* JITTER_ARG3 is intentionally not defined for a fast label. */

#   define JITTER_ARGN3 (JITTER_ARG3.fixnum)
#   define JITTER_ARGU3 (JITTER_ARG3.ufixnum)
#   define JITTER_ARGP3 (JITTER_ARG3.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_2.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[3]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG3  JITTER_RESIDUAL_ARGUMENT_3
    JITTER_MARK_RESIDUAL_3_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG3  (((union jitter_word*)jitter_ip)[3])
#else
#   define JITTER_ARG3  (((union jitter_word*)jitter_ip)[4])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN3 (JITTER_ARG3.fixnum)
#   define JITTER_ARGU3 (JITTER_ARG3.ufixnum)
#   define JITTER_ARGP3 (JITTER_ARG3.pointer)
#   define JITTER_ARGF3 JITTER_ARGP3

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of addo/%rR/%rR/%rR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "addo/%rR/%rR/%rR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for addo/%rR/%rR/%rR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW (JITTER_ARGN2,
                                         JITTER_ARGN0, JITTER_ARGN1,
                                         JITTER_ARGF3);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for addo/%rR/%rR/%rR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "addo/%rR/%rR/%rR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the addo/%rR/%rR/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2
#   undef JITTER_SLOW_REGISTER_OFFSET3
#   undef JITTER_ARG3
#   undef JITTER_ARGN3
#   undef JITTER_ARGU3
#   undef JITTER_ARGP3
#   undef JITTER_ARGF3

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(addo/%rR/%rR/%rR/fR, addo___rrR___rrR___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for addo/%rR/%rR/%rR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction addo/%rR/n1/%rR/fR */
  JITTER_INSTRUCTION_PROLOG_(addo/%rR/n1/%rR/fR, addo___rrR__n1___rrR__fR, cold)
  { /* This block begins with definitions for addo/%rR/n1/%rR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       25
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         addo/%rR/n1/%rR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "addo"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "addo/%rR/n1/%rR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME addo___rrR__n1___rrR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for addo/%rR/n1/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 1L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

    /* The 3th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF3 0
    /* JITTER_ARG3 is intentionally not defined for a fast label. */

#   define JITTER_ARGN3 (JITTER_ARG3.fixnum)
#   define JITTER_ARGU3 (JITTER_ARG3.ufixnum)
#   define JITTER_ARGP3 (JITTER_ARG3.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 1L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG3  JITTER_RESIDUAL_ARGUMENT_2
    JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG3  (((union jitter_word*)jitter_ip)[2])
#else
#   define JITTER_ARG3  (((union jitter_word*)jitter_ip)[3])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN3 (JITTER_ARG3.fixnum)
#   define JITTER_ARGU3 (JITTER_ARG3.ufixnum)
#   define JITTER_ARGP3 (JITTER_ARG3.pointer)
#   define JITTER_ARGF3 JITTER_ARGP3

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of addo/%rR/n1/%rR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "addo/%rR/n1/%rR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for addo/%rR/n1/%rR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW (JITTER_ARGN2,
                                         JITTER_ARGN0, JITTER_ARGN1,
                                         JITTER_ARGF3);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for addo/%rR/n1/%rR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "addo/%rR/n1/%rR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the addo/%rR/n1/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2
#   undef JITTER_SLOW_REGISTER_OFFSET3
#   undef JITTER_ARG3
#   undef JITTER_ARGN3
#   undef JITTER_ARGU3
#   undef JITTER_ARGP3
#   undef JITTER_ARGF3

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(addo/%rR/n1/%rR/fR, addo___rrR__n1___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for addo/%rR/n1/%rR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction addo/%rR/n-1/%rR/fR */
  JITTER_INSTRUCTION_PROLOG_(addo/%rR/n-1/%rR/fR, addo___rrR__n_m1___rrR__fR, cold)
  { /* This block begins with definitions for addo/%rR/n-1/%rR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       26
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         addo/%rR/n-1/%rR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "addo"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "addo/%rR/n-1/%rR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME addo___rrR__n_m1___rrR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for addo/%rR/n-1/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = -1L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

    /* The 3th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF3 0
    /* JITTER_ARG3 is intentionally not defined for a fast label. */

#   define JITTER_ARGN3 (JITTER_ARG3.fixnum)
#   define JITTER_ARGU3 (JITTER_ARG3.ufixnum)
#   define JITTER_ARGP3 (JITTER_ARG3.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = -1L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG3  JITTER_RESIDUAL_ARGUMENT_2
    JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG3  (((union jitter_word*)jitter_ip)[2])
#else
#   define JITTER_ARG3  (((union jitter_word*)jitter_ip)[3])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN3 (JITTER_ARG3.fixnum)
#   define JITTER_ARGU3 (JITTER_ARG3.ufixnum)
#   define JITTER_ARGP3 (JITTER_ARG3.pointer)
#   define JITTER_ARGF3 JITTER_ARGP3

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of addo/%rR/n-1/%rR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "addo/%rR/n-1/%rR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for addo/%rR/n-1/%rR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW (JITTER_ARGN2,
                                         JITTER_ARGN0, JITTER_ARGN1,
                                         JITTER_ARGF3);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for addo/%rR/n-1/%rR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "addo/%rR/n-1/%rR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the addo/%rR/n-1/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2
#   undef JITTER_SLOW_REGISTER_OFFSET3
#   undef JITTER_ARG3
#   undef JITTER_ARGN3
#   undef JITTER_ARGU3
#   undef JITTER_ARGP3
#   undef JITTER_ARGF3

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(addo/%rR/n-1/%rR/fR, addo___rrR__n_m1___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for addo/%rR/n-1/%rR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction addo/%rR/nR/%rR/fR */
  JITTER_INSTRUCTION_PROLOG_(addo/%rR/nR/%rR/fR, addo___rrR__nR___rrR__fR, cold)
  { /* This block begins with definitions for addo/%rR/nR/%rR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       27
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         addo/%rR/nR/%rR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "addo"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "addo/%rR/nR/%rR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME addo___rrR__nR___rrR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 4
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for addo/%rR/nR/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_2.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[3]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

    /* The 3th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF3 0
    /* JITTER_ARG3 is intentionally not defined for a fast label. */

#   define JITTER_ARGN3 (JITTER_ARG3.fixnum)
#   define JITTER_ARGU3 (JITTER_ARG3.ufixnum)
#   define JITTER_ARGP3 (JITTER_ARG3.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_2.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[3]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG3  JITTER_RESIDUAL_ARGUMENT_3
    JITTER_MARK_RESIDUAL_3_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG3  (((union jitter_word*)jitter_ip)[3])
#else
#   define JITTER_ARG3  (((union jitter_word*)jitter_ip)[4])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN3 (JITTER_ARG3.fixnum)
#   define JITTER_ARGU3 (JITTER_ARG3.ufixnum)
#   define JITTER_ARGP3 (JITTER_ARG3.pointer)
#   define JITTER_ARGF3 JITTER_ARGP3

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of addo/%rR/nR/%rR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "addo/%rR/nR/%rR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for addo/%rR/nR/%rR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW (JITTER_ARGN2,
                                         JITTER_ARGN0, JITTER_ARGN1,
                                         JITTER_ARGF3);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for addo/%rR/nR/%rR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "addo/%rR/nR/%rR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the addo/%rR/nR/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2
#   undef JITTER_SLOW_REGISTER_OFFSET3
#   undef JITTER_ARG3
#   undef JITTER_ARGN3
#   undef JITTER_ARGU3
#   undef JITTER_ARGP3
#   undef JITTER_ARGF3

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(addo/%rR/nR/%rR/fR, addo___rrR__nR___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for addo/%rR/nR/%rR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction addo/nR/%rR/%rR/fR */
  JITTER_INSTRUCTION_PROLOG_(addo/nR/%rR/%rR/fR, addo__nR___rrR___rrR__fR, cold)
  { /* This block begins with definitions for addo/nR/%rR/%rR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       28
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         addo/nR/%rR/%rR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "addo"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "addo/nR/%rR/%rR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME addo__nR___rrR___rrR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 4
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for addo/nR/%rR/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_2.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[3]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

    /* The 3th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF3 0
    /* JITTER_ARG3 is intentionally not defined for a fast label. */

#   define JITTER_ARGN3 (JITTER_ARG3.fixnum)
#   define JITTER_ARGU3 (JITTER_ARG3.ufixnum)
#   define JITTER_ARGP3 (JITTER_ARG3.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_2.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[3]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG3  JITTER_RESIDUAL_ARGUMENT_3
    JITTER_MARK_RESIDUAL_3_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG3  (((union jitter_word*)jitter_ip)[3])
#else
#   define JITTER_ARG3  (((union jitter_word*)jitter_ip)[4])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN3 (JITTER_ARG3.fixnum)
#   define JITTER_ARGU3 (JITTER_ARG3.ufixnum)
#   define JITTER_ARGP3 (JITTER_ARG3.pointer)
#   define JITTER_ARGF3 JITTER_ARGP3

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of addo/nR/%rR/%rR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "addo/nR/%rR/%rR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for addo/nR/%rR/%rR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW (JITTER_ARGN2,
                                         JITTER_ARGN0, JITTER_ARGN1,
                                         JITTER_ARGF3);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for addo/nR/%rR/%rR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "addo/nR/%rR/%rR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the addo/nR/%rR/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2
#   undef JITTER_SLOW_REGISTER_OFFSET3
#   undef JITTER_ARG3
#   undef JITTER_ARGN3
#   undef JITTER_ARGU3
#   undef JITTER_ARGP3
#   undef JITTER_ARGF3

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(addo/nR/%rR/%rR/fR, addo__nR___rrR___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for addo/nR/%rR/%rR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction addo/nR/n1/%rR/fR */
  JITTER_INSTRUCTION_PROLOG_(addo/nR/n1/%rR/fR, addo__nR__n1___rrR__fR, cold)
  { /* This block begins with definitions for addo/nR/n1/%rR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       29
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         addo/nR/n1/%rR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "addo"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "addo/nR/n1/%rR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME addo__nR__n1___rrR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for addo/nR/n1/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 1L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

    /* The 3th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF3 0
    /* JITTER_ARG3 is intentionally not defined for a fast label. */

#   define JITTER_ARGN3 (JITTER_ARG3.fixnum)
#   define JITTER_ARGU3 (JITTER_ARG3.ufixnum)
#   define JITTER_ARGP3 (JITTER_ARG3.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 1L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG3  JITTER_RESIDUAL_ARGUMENT_2
    JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG3  (((union jitter_word*)jitter_ip)[2])
#else
#   define JITTER_ARG3  (((union jitter_word*)jitter_ip)[3])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN3 (JITTER_ARG3.fixnum)
#   define JITTER_ARGU3 (JITTER_ARG3.ufixnum)
#   define JITTER_ARGP3 (JITTER_ARG3.pointer)
#   define JITTER_ARGF3 JITTER_ARGP3

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of addo/nR/n1/%rR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "addo/nR/n1/%rR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for addo/nR/n1/%rR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW (JITTER_ARGN2,
                                         JITTER_ARGN0, JITTER_ARGN1,
                                         JITTER_ARGF3);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for addo/nR/n1/%rR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "addo/nR/n1/%rR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the addo/nR/n1/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2
#   undef JITTER_SLOW_REGISTER_OFFSET3
#   undef JITTER_ARG3
#   undef JITTER_ARGN3
#   undef JITTER_ARGU3
#   undef JITTER_ARGP3
#   undef JITTER_ARGF3

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(addo/nR/n1/%rR/fR, addo__nR__n1___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for addo/nR/n1/%rR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction addo/nR/n-1/%rR/fR */
  JITTER_INSTRUCTION_PROLOG_(addo/nR/n-1/%rR/fR, addo__nR__n_m1___rrR__fR, cold)
  { /* This block begins with definitions for addo/nR/n-1/%rR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       30
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         addo/nR/n-1/%rR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "addo"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "addo/nR/n-1/%rR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME addo__nR__n_m1___rrR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for addo/nR/n-1/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = -1L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

    /* The 3th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF3 0
    /* JITTER_ARG3 is intentionally not defined for a fast label. */

#   define JITTER_ARGN3 (JITTER_ARG3.fixnum)
#   define JITTER_ARGU3 (JITTER_ARG3.ufixnum)
#   define JITTER_ARGP3 (JITTER_ARG3.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = -1L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG3  JITTER_RESIDUAL_ARGUMENT_2
    JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG3  (((union jitter_word*)jitter_ip)[2])
#else
#   define JITTER_ARG3  (((union jitter_word*)jitter_ip)[3])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN3 (JITTER_ARG3.fixnum)
#   define JITTER_ARGU3 (JITTER_ARG3.ufixnum)
#   define JITTER_ARGP3 (JITTER_ARG3.pointer)
#   define JITTER_ARGF3 JITTER_ARGP3

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of addo/nR/n-1/%rR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "addo/nR/n-1/%rR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for addo/nR/n-1/%rR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW (JITTER_ARGN2,
                                         JITTER_ARGN0, JITTER_ARGN1,
                                         JITTER_ARGF3);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for addo/nR/n-1/%rR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "addo/nR/n-1/%rR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the addo/nR/n-1/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2
#   undef JITTER_SLOW_REGISTER_OFFSET3
#   undef JITTER_ARG3
#   undef JITTER_ARGN3
#   undef JITTER_ARGU3
#   undef JITTER_ARGP3
#   undef JITTER_ARGF3

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(addo/nR/n-1/%rR/fR, addo__nR__n_m1___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for addo/nR/n-1/%rR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction addo/nR/nR/%rR/fR */
  JITTER_INSTRUCTION_PROLOG_(addo/nR/nR/%rR/fR, addo__nR__nR___rrR__fR, cold)
  { /* This block begins with definitions for addo/nR/nR/%rR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       31
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         addo/nR/nR/%rR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "addo"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "addo/nR/nR/%rR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME addo__nR__nR___rrR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 4
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for addo/nR/nR/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_2.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[3]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

    /* The 3th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF3 0
    /* JITTER_ARG3 is intentionally not defined for a fast label. */

#   define JITTER_ARGN3 (JITTER_ARG3.fixnum)
#   define JITTER_ARGU3 (JITTER_ARG3.ufixnum)
#   define JITTER_ARGP3 (JITTER_ARG3.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

    /* The 2th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 (JITTER_RESIDUAL_ARGUMENT_2.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET2 ((((union jitter_word*)jitter_ip)[3]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG2  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET2)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG3  JITTER_RESIDUAL_ARGUMENT_3
    JITTER_MARK_RESIDUAL_3_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG3  (((union jitter_word*)jitter_ip)[3])
#else
#   define JITTER_ARG3  (((union jitter_word*)jitter_ip)[4])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN3 (JITTER_ARG3.fixnum)
#   define JITTER_ARGU3 (JITTER_ARG3.ufixnum)
#   define JITTER_ARGP3 (JITTER_ARG3.pointer)
#   define JITTER_ARGF3 JITTER_ARGP3

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of addo/nR/nR/%rR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "addo/nR/nR/%rR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for addo/nR/nR/%rR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW (JITTER_ARGN2,
                                         JITTER_ARGN0, JITTER_ARGN1,
                                         JITTER_ARGF3);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for addo/nR/nR/%rR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "addo/nR/nR/%rR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the addo/nR/nR/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2
#   undef JITTER_SLOW_REGISTER_OFFSET3
#   undef JITTER_ARG3
#   undef JITTER_ARGN3
#   undef JITTER_ARGU3
#   undef JITTER_ARGP3
#   undef JITTER_ARGF3

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(addo/nR/nR/%rR/fR, addo__nR__nR___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for addo/nR/nR/%rR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction b/fR */
  JITTER_INSTRUCTION_PROLOG_(b/fR, b__fR, hot)
  { /* This block begins with definitions for b/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       32
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         b/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "b"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "b/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME b__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for b/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of b/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "b/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for b/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST (JITTER_ARGF0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for b/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "b/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the b/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(b/fR, b__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for b/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction band/%rR/%rR/fR */
  JITTER_INSTRUCTION_PROLOG_(band/%rR/%rR/fR, band___rrR___rrR__fR, cold)
  { /* This block begins with definitions for band/%rR/%rR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       33
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         band/%rR/%rR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "band"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "band/%rR/%rR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME band___rrR___rrR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for band/%rR/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_2
    JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[3])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of band/%rR/%rR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "band/%rR/%rR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for band/%rR/%rR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_AND (JITTER_ARGU0, JITTER_ARGU1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for band/%rR/%rR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "band/%rR/%rR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the band/%rR/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(band/%rR/%rR/fR, band___rrR___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for band/%rR/%rR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction band/%rR/n3/fR */
  JITTER_INSTRUCTION_PROLOG_(band/%rR/n3/fR, band___rrR__n3__fR, cold)
  { /* This block begins with definitions for band/%rR/n3/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       34
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         band/%rR/n3/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "band"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "band/%rR/n3/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME band___rrR__n3__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for band/%rR/n3/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 3L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 3L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of band/%rR/n3/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "band/%rR/n3/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for band/%rR/n3/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_AND (JITTER_ARGU0, JITTER_ARGU1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for band/%rR/n3/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "band/%rR/n3/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the band/%rR/n3/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(band/%rR/n3/fR, band___rrR__n3__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for band/%rR/n3/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction band/%rR/n7/fR */
  JITTER_INSTRUCTION_PROLOG_(band/%rR/n7/fR, band___rrR__n7__fR, cold)
  { /* This block begins with definitions for band/%rR/n7/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       35
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         band/%rR/n7/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "band"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "band/%rR/n7/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME band___rrR__n7__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for band/%rR/n7/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 7L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 7L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of band/%rR/n7/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "band/%rR/n7/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for band/%rR/n7/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_AND (JITTER_ARGU0, JITTER_ARGU1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for band/%rR/n7/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "band/%rR/n7/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the band/%rR/n7/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(band/%rR/n7/fR, band___rrR__n7__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for band/%rR/n7/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction band/%rR/nR/fR */
  JITTER_INSTRUCTION_PROLOG_(band/%rR/nR/fR, band___rrR__nR__fR, cold)
  { /* This block begins with definitions for band/%rR/nR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       36
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         band/%rR/nR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "band"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "band/%rR/nR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME band___rrR__nR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for band/%rR/nR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_2
    JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[3])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of band/%rR/nR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "band/%rR/nR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for band/%rR/nR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_AND (JITTER_ARGU0, JITTER_ARGU1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for band/%rR/nR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "band/%rR/nR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the band/%rR/nR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(band/%rR/nR/fR, band___rrR__nR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for band/%rR/nR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction band/nR/%rR/fR */
  JITTER_INSTRUCTION_PROLOG_(band/nR/%rR/fR, band__nR___rrR__fR, cold)
  { /* This block begins with definitions for band/nR/%rR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       37
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         band/nR/%rR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "band"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "band/nR/%rR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME band__nR___rrR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for band/nR/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_2
    JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[3])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of band/nR/%rR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "band/nR/%rR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for band/nR/%rR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_AND (JITTER_ARGU0, JITTER_ARGU1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for band/nR/%rR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "band/nR/%rR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the band/nR/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(band/nR/%rR/fR, band__nR___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for band/nR/%rR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction band/nR/n3/fR */
  JITTER_INSTRUCTION_PROLOG_(band/nR/n3/fR, band__nR__n3__fR, cold)
  { /* This block begins with definitions for band/nR/n3/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       38
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         band/nR/n3/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "band"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "band/nR/n3/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME band__nR__n3__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for band/nR/n3/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 3L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 3L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of band/nR/n3/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "band/nR/n3/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for band/nR/n3/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_AND (JITTER_ARGU0, JITTER_ARGU1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for band/nR/n3/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "band/nR/n3/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the band/nR/n3/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(band/nR/n3/fR, band__nR__n3__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for band/nR/n3/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction band/nR/n7/fR */
  JITTER_INSTRUCTION_PROLOG_(band/nR/n7/fR, band__nR__n7__fR, cold)
  { /* This block begins with definitions for band/nR/n7/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       39
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         band/nR/n7/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "band"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "band/nR/n7/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME band__nR__n7__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for band/nR/n7/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 7L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 7L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of band/nR/n7/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "band/nR/n7/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for band/nR/n7/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_AND (JITTER_ARGU0, JITTER_ARGU1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for band/nR/n7/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "band/nR/n7/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the band/nR/n7/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(band/nR/n7/fR, band__nR__n7__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for band/nR/n7/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction band/nR/nR/fR */
  JITTER_INSTRUCTION_PROLOG_(band/nR/nR/fR, band__nR__nR__fR, cold)
  { /* This block begins with definitions for band/nR/nR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       40
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         band/nR/nR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "band"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "band/nR/nR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME band__nR__nR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for band/nR/nR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_2
    JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[3])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of band/nR/nR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "band/nR/nR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for band/nR/nR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_AND (JITTER_ARGU0, JITTER_ARGU1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for band/nR/nR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "band/nR/nR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the band/nR/nR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(band/nR/nR/fR, band__nR__nR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for band/nR/nR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction beq/%rR/%rR/fR */
  JITTER_INSTRUCTION_PROLOG_(beq/%rR/%rR/fR, beq___rrR___rrR__fR, cold)
  { /* This block begins with definitions for beq/%rR/%rR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       41
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         beq/%rR/%rR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "beq"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "beq/%rR/%rR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME beq___rrR___rrR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for beq/%rR/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_2
    JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[3])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of beq/%rR/%rR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "beq/%rR/%rR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for beq/%rR/%rR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL (JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for beq/%rR/%rR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "beq/%rR/%rR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the beq/%rR/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(beq/%rR/%rR/fR, beq___rrR___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for beq/%rR/%rR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction beq/%rR/nR/fR */
  JITTER_INSTRUCTION_PROLOG_(beq/%rR/nR/fR, beq___rrR__nR__fR, cold)
  { /* This block begins with definitions for beq/%rR/nR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       42
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         beq/%rR/nR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "beq"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "beq/%rR/nR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME beq___rrR__nR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for beq/%rR/nR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_2
    JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[3])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of beq/%rR/nR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "beq/%rR/nR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for beq/%rR/nR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL (JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for beq/%rR/nR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "beq/%rR/nR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the beq/%rR/nR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(beq/%rR/nR/fR, beq___rrR__nR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for beq/%rR/nR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction beq/nR/%rR/fR */
  JITTER_INSTRUCTION_PROLOG_(beq/nR/%rR/fR, beq__nR___rrR__fR, cold)
  { /* This block begins with definitions for beq/nR/%rR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       43
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         beq/nR/%rR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "beq"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "beq/nR/%rR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME beq__nR___rrR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for beq/nR/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_2
    JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[3])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of beq/nR/%rR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "beq/nR/%rR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for beq/nR/%rR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL (JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for beq/nR/%rR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "beq/nR/%rR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the beq/nR/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(beq/nR/%rR/fR, beq__nR___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for beq/nR/%rR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction beq/nR/nR/fR */
  JITTER_INSTRUCTION_PROLOG_(beq/nR/nR/fR, beq__nR__nR__fR, cold)
  { /* This block begins with definitions for beq/nR/nR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       44
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         beq/nR/nR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "beq"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "beq/nR/nR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME beq__nR__nR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for beq/nR/nR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_2
    JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[3])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of beq/nR/nR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "beq/nR/nR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for beq/nR/nR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL (JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for beq/nR/nR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "beq/nR/nR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the beq/nR/nR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(beq/nR/nR/fR, beq__nR__nR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for beq/nR/nR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bge/%rR/%rR/fR */
  JITTER_INSTRUCTION_PROLOG_(bge/%rR/%rR/fR, bge___rrR___rrR__fR, cold)
  { /* This block begins with definitions for bge/%rR/%rR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       45
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bge/%rR/%rR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bge"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bge/%rR/%rR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bge___rrR___rrR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bge/%rR/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_2
    JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[3])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bge/%rR/%rR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bge/%rR/%rR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bge/%rR/%rR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED (JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bge/%rR/%rR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "bge/%rR/%rR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bge/%rR/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bge/%rR/%rR/fR, bge___rrR___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bge/%rR/%rR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bge/%rR/n0/fR */
  JITTER_INSTRUCTION_PROLOG_(bge/%rR/n0/fR, bge___rrR__n0__fR, cold)
  { /* This block begins with definitions for bge/%rR/n0/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       46
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bge/%rR/n0/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bge"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bge/%rR/n0/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bge___rrR__n0__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bge/%rR/n0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bge/%rR/n0/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bge/%rR/n0/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bge/%rR/n0/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED (JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bge/%rR/n0/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "bge/%rR/n0/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bge/%rR/n0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bge/%rR/n0/fR, bge___rrR__n0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bge/%rR/n0/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bge/%rR/n1/fR */
  JITTER_INSTRUCTION_PROLOG_(bge/%rR/n1/fR, bge___rrR__n1__fR, cold)
  { /* This block begins with definitions for bge/%rR/n1/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       47
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bge/%rR/n1/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bge"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bge/%rR/n1/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bge___rrR__n1__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bge/%rR/n1/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 1L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 1L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bge/%rR/n1/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bge/%rR/n1/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bge/%rR/n1/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED (JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bge/%rR/n1/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "bge/%rR/n1/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bge/%rR/n1/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bge/%rR/n1/fR, bge___rrR__n1__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bge/%rR/n1/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bge/%rR/nR/fR */
  JITTER_INSTRUCTION_PROLOG_(bge/%rR/nR/fR, bge___rrR__nR__fR, cold)
  { /* This block begins with definitions for bge/%rR/nR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       48
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bge/%rR/nR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bge"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bge/%rR/nR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bge___rrR__nR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bge/%rR/nR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_2
    JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[3])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bge/%rR/nR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bge/%rR/nR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bge/%rR/nR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED (JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bge/%rR/nR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "bge/%rR/nR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bge/%rR/nR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bge/%rR/nR/fR, bge___rrR__nR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bge/%rR/nR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bge/n0/%rR/fR */
  JITTER_INSTRUCTION_PROLOG_(bge/n0/%rR/fR, bge__n0___rrR__fR, cold)
  { /* This block begins with definitions for bge/n0/%rR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       49
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bge/n0/%rR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bge"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bge/n0/%rR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bge__n0___rrR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bge/n0/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bge/n0/%rR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (UNINSPIRED_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (UNINSPIRED_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (UNINSPIRED_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bge/n0/%rR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bge/n0/%rR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED (JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bge/n0/%rR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "bge/n0/%rR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bge/n0/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bge/n0/%rR/fR, bge__n0___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bge/n0/%rR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bge/n0/n0/fR */
  JITTER_INSTRUCTION_PROLOG_(bge/n0/n0/fR, bge__n0__n0__fR, hot)
  { /* This block begins with definitions for bge/n0/n0/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       50
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bge/n0/n0/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bge"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bge/n0/n0/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bge__n0__n0__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* 