# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ComponentPurgeBodyFilters(Model):
    """User-defined filters to return data which will be purged from the table.

    :param column: The column of the table over which the given query should
     run
    :type column: str
    :param operator: A query operator to evaluate over the provided column and
     value(s).
    :type operator: str
    :param value: the value for the operator to function over. This can be a
     number (e.g., > 100), a string (timestamp >= '2017-09-01') or array of
     values.
    :type value: object
    :param key: When filtering over custom dimensions, this key will be used
     as the name of the custom dimension.
    :type key: str
    """

    _attribute_map = {
        'column': {'key': 'column', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'value': {'key': 'value', 'type': 'object'},
        'key': {'key': 'key', 'type': 'str'},
    }

    def __init__(self, *, column: str=None, operator: str=None, value=None, key: str=None, **kwargs) -> None:
        super(ComponentPurgeBodyFilters, self).__init__(**kwargs)
        self.column = column
        self.operator = operator
        self.value = value
        self.key = key
