# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource_py3 import Resource


class UsageDetailsDownloadResponse(Resource):
    """Download response of Usage Details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar download_url: The URL to the csv file.
    :vartype download_url: str
    :ivar valid_till: The time in UTC at which this download URL will expire.
    :vartype valid_till: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
        'download_url': {'readonly': True},
        'valid_till': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'download_url': {'key': 'properties.downloadUrl', 'type': 'str'},
        'valid_till': {'key': 'properties.validTill', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(UsageDetailsDownloadResponse, self).__init__(**kwargs)
        self.download_url = None
        self.valid_till = None
