# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import MaintenanceManagementClientConfiguration
from .operations import ApplyUpdatesOperations
from .operations import ConfigurationAssignmentsOperations
from .operations import MaintenanceConfigurationsOperations
from .operations import Operations
from .operations import UpdatesOperations
from . import models


class MaintenanceManagementClient(SDKClient):
    """Azure Maintenance Management Client

    :ivar config: Configuration for client.
    :vartype config: MaintenanceManagementClientConfiguration

    :ivar apply_updates: ApplyUpdates operations
    :vartype apply_updates: azure.mgmt.maintenance.operations.ApplyUpdatesOperations
    :ivar configuration_assignments: ConfigurationAssignments operations
    :vartype configuration_assignments: azure.mgmt.maintenance.operations.ConfigurationAssignmentsOperations
    :ivar maintenance_configurations: MaintenanceConfigurations operations
    :vartype maintenance_configurations: azure.mgmt.maintenance.operations.MaintenanceConfigurationsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.maintenance.operations.Operations
    :ivar updates: Updates operations
    :vartype updates: azure.mgmt.maintenance.operations.UpdatesOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Subscription credentials that uniquely identify a
     Microsoft Azure subscription. The subscription ID forms part of the URI
     for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = MaintenanceManagementClientConfiguration(credentials, subscription_id, base_url)
        super(MaintenanceManagementClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2018-06-01-preview'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.apply_updates = ApplyUpdatesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.configuration_assignments = ConfigurationAssignmentsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.maintenance_configurations = MaintenanceConfigurationsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
        self.updates = UpdatesOperations(
            self._client, self.config, self._serialize, self._deserialize)
