# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class USqlTablePreview(Model):
    """A Data Lake Analytics catalog table or partition preview rows item.

    :param total_row_count: the total number of rows in the table or
     partition.
    :type total_row_count: long
    :param total_column_count: the total number of columns in the table or
     partition.
    :type total_column_count: long
    :param rows: the rows of the table or partition preview, where each row is
     an array of string representations the row's values. Note: Byte arrays
     will appear as base-64 encoded values, SqlMap and SqlArray objects will
     appear as escaped JSON objects, and DateTime objects will appear as ISO
     formatted UTC date-times.
    :type rows: list[list[str]]
    :param truncated: true if the amount of data in the response is less than
     expected due to the preview operation's size limitations. This can occur
     if the requested rows or row counts are too large.
    :type truncated: bool
    :param schema: the schema of the table or partition.
    :type schema:
     list[~azure.mgmt.datalake.analytics.catalog.models.USqlTableColumn]
    """

    _attribute_map = {
        'total_row_count': {'key': 'totalRowCount', 'type': 'long'},
        'total_column_count': {'key': 'totalColumnCount', 'type': 'long'},
        'rows': {'key': 'rows', 'type': '[[str]]'},
        'truncated': {'key': 'truncated', 'type': 'bool'},
        'schema': {'key': 'schema', 'type': '[USqlTableColumn]'},
    }

    def __init__(self, *, total_row_count: int=None, total_column_count: int=None, rows=None, truncated: bool=None, schema=None, **kwargs) -> None:
        super(USqlTablePreview, self).__init__(**kwargs)
        self.total_row_count = total_row_count
        self.total_column_count = total_column_count
        self.rows = rows
        self.truncated = truncated
        self.schema = schema
