# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class CloudName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The multi cloud resource's cloud name."""

    AZURE = "Azure"
    AWS = "AWS"
    GCP = "GCP"
    GITHUB = "Github"
    AZURE_DEV_OPS = "AzureDevOps"
    GIT_LAB = "GitLab"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class EnvironmentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the environment data."""

    AWS_ACCOUNT = "AwsAccount"
    GCP_PROJECT = "GcpProject"
    GITHUB_SCOPE = "GithubScope"
    AZURE_DEV_OPS_SCOPE = "AzureDevOpsScope"
    GITLAB_SCOPE = "GitlabScope"


class OfferingType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the security offering."""

    CSPM_MONITOR_AWS = "CspmMonitorAws"
    DEFENDER_FOR_CONTAINERS_AWS = "DefenderForContainersAws"
    DEFENDER_FOR_SERVERS_AWS = "DefenderForServersAws"
    DEFENDER_FOR_DATABASES_AWS = "DefenderForDatabasesAws"
    INFORMATION_PROTECTION_AWS = "InformationProtectionAws"
    CSPM_MONITOR_GCP = "CspmMonitorGcp"
    CSPM_MONITOR_GITHUB = "CspmMonitorGithub"
    CSPM_MONITOR_AZURE_DEV_OPS = "CspmMonitorAzureDevOps"
    DEFENDER_FOR_SERVERS_GCP = "DefenderForServersGcp"
    DEFENDER_FOR_CONTAINERS_GCP = "DefenderForContainersGcp"
    DEFENDER_FOR_DATABASES_GCP = "DefenderForDatabasesGcp"
    DEFENDER_CSPM_AWS = "DefenderCspmAws"
    DEFENDER_CSPM_GCP = "DefenderCspmGcp"
    DEFENDER_FOR_DEV_OPS_GITHUB = "DefenderForDevOpsGithub"
    DEFENDER_FOR_DEV_OPS_AZURE_DEV_OPS = "DefenderForDevOpsAzureDevOps"
    CSPM_MONITOR_GIT_LAB = "CspmMonitorGitLab"
    DEFENDER_FOR_DEV_OPS_GIT_LAB = "DefenderForDevOpsGitLab"


class OrganizationMembershipType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The multi cloud account's membership type in the organization."""

    MEMBER = "Member"
    ORGANIZATION = "Organization"


class ScanningMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The scanning mode for the VM scan."""

    DEFAULT = "Default"


class SubPlan(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The available sub plans."""

    P1 = "P1"
    P2 = "P2"


class Type(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or 'Qualys'."""

    QUALYS = "Qualys"
    TVM = "TVM"
